/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.scheme;

import com.oracle.coherence.common.util.Duration;
import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.coherence.config.builder.MapBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.scheme.AbstractLocalCachingScheme;
import com.tangosol.coherence.config.scheme.BundleManager;
import com.tangosol.coherence.config.scheme.CacheStoreScheme;
import com.tangosol.coherence.config.scheme.CachingScheme;
import com.tangosol.coherence.config.scheme.LocalScheme;
import com.tangosol.coherence.config.scheme.ObservableCachingScheme;
import com.tangosol.coherence.config.unit.Millis;
import com.tangosol.coherence.config.unit.Seconds;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.BinaryEntryStore;
import com.tangosol.net.cache.CacheLoader;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.cache.NonBlockingEntryStore;
import com.tangosol.net.cache.ReadWriteBackingMap;
import com.tangosol.net.partition.PartitionAwareBackingMap;
import com.tangosol.net.partition.ReadWriteSplittingBackingMap;
import com.tangosol.util.Base;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import java.util.Map;

public class ReadWriteBackingMapScheme
extends AbstractLocalCachingScheme<ReadWriteBackingMap> {
    private CacheStoreScheme m_schemeCacheStore;
    private CachingScheme m_schemeInternal;
    private LocalScheme m_schemeMissCache;
    private Expression<Millis> m_exprCacheStoreTimeout = new LiteralExpression<Millis>(new Millis("0"));
    private Expression<Boolean> m_exprReadOnly = new LiteralExpression<Boolean>(Boolean.FALSE);
    private Expression<Double> m_exprRefreshAheadFactor = new LiteralExpression<Double>(0.0);
    private Expression<Boolean> m_exprfRollbackCacheStoreFailures = new LiteralExpression<Boolean>(Boolean.TRUE);
    private Expression<Double> m_exprWriteBatchFactor = new LiteralExpression<Double>(0.0);
    private Expression<Seconds> m_exprWriteDelay = new LiteralExpression<Seconds>(new Seconds("0"));
    private Expression<Integer> m_exprWriteDelaySeconds = new LiteralExpression<Integer>(0);
    private Expression<Integer> m_exprWriteMaxBatchSize = new LiteralExpression<Integer>(128);
    private Expression<Integer> m_exprWriteRequeueThreshold = new LiteralExpression<Integer>(0);
    private Expression<Boolean> m_exprWriteBehindRemove = new LiteralExpression<Boolean>(ReadWriteBackingMap.RWBM_WB_REMOVE_DEFAULT);
    private ObservableMap m_mapInternal;

    @Override
    public ReadWriteBackingMap realizeMap(ParameterResolver resolver, MapBuilder.Dependencies dependencies) {
        BundleManager managerBundle;
        long cWriteBehindMillis;
        this.validate(resolver);
        ReadWriteBackingMap rwbm = null;
        ClassLoader loader = dependencies.getClassLoader();
        CacheStoreScheme bldrCacheStore = this.getCacheStoreScheme();
        CachingScheme bldrInternalMap = this.getInternalScheme();
        LocalScheme bldrMissCache = this.getMissCacheScheme();
        ObservableMap mapInternal = this.getInternalMap();
        BackingMapManagerContext contextBmm = dependencies.getBackingMapManagerContext();
        ParameterizedBuilder bldrCustom = this.getCustomBuilder();
        boolean fReadOnly = this.isReadOnly(resolver);
        boolean fSplitting = mapInternal instanceof PartitionAwareBackingMap;
        boolean fWBRemove = this.isWriteBehindRemove(resolver);
        if (mapInternal == null) {
            mapInternal = bldrInternalMap == null ? null : (ObservableMap)bldrInternalMap.realizeMap(resolver, dependencies);
        }
        LocalCache mapMisses = bldrMissCache == null ? null : bldrMissCache.realizeMap(resolver, dependencies);
        Object store = bldrCacheStore == null ? null : bldrCacheStore.realize(resolver, dependencies);
        BinaryEntryStore storeBinary = null;
        NonBlockingEntryStore storeNonBlockingBinary = null;
        if (!(!(store instanceof BinaryEntryStore) && !(store instanceof NonBlockingEntryStore) || store instanceof NamedCache && store instanceof ClassLoaderAware && ((ClassLoaderAware)store).getContextClassLoader() != NullImplementation.getClassLoader())) {
            if (store instanceof BinaryEntryStore) {
                storeBinary = (BinaryEntryStore)store;
            } else {
                storeNonBlockingBinary = (NonBlockingEntryStore)store;
            }
        }
        if ((cWriteBehindMillis = this.getWriteDelay(resolver).as(Duration.Magnitude.MILLI)) == 0L) {
            cWriteBehindMillis = 1000L * (long)this.getWriteDelaySeconds(resolver);
        }
        int cWriteBehindSec = cWriteBehindMillis == 0L ? 0 : Math.max(1, (int)(cWriteBehindMillis / 1000L));
        double dflRefreshAheadFactor = this.getRefreshAheadFactor(resolver);
        if (bldrCustom == null) {
            if (storeBinary == null && storeNonBlockingBinary == null) {
                CacheLoader storeObject = (CacheLoader)store;
                rwbm = fSplitting ? this.instantiateReadWriteSplittingBackingMap(contextBmm, (PartitionAwareBackingMap)((Object)mapInternal), (Map)mapMisses, storeObject, fReadOnly, cWriteBehindSec, dflRefreshAheadFactor, fWBRemove) : this.instantiateReadWriteBackingMap(contextBmm, mapInternal, (Map)mapMisses, storeObject, fReadOnly, cWriteBehindSec, dflRefreshAheadFactor, fWBRemove);
            } else if (storeNonBlockingBinary != null) {
                if (cWriteBehindSec != 0) {
                    Base.log("Write-behind configured with a non-blocking store implementation. Disabling write-behind.");
                    cWriteBehindSec = 0;
                }
                rwbm = fSplitting ? this.instantiateReadWriteSplittingBackingMap(contextBmm, (PartitionAwareBackingMap)((Object)mapInternal), (Map)mapMisses, storeNonBlockingBinary, fReadOnly, cWriteBehindSec, dflRefreshAheadFactor, fWBRemove) : this.instantiateReadWriteBackingMap(contextBmm, mapInternal, (Map)mapMisses, storeNonBlockingBinary, fReadOnly, cWriteBehindSec, dflRefreshAheadFactor, fWBRemove);
            } else {
                rwbm = fSplitting ? this.instantiateReadWriteSplittingBackingMap(contextBmm, (PartitionAwareBackingMap)((Object)mapInternal), (Map)mapMisses, storeBinary, fReadOnly, cWriteBehindSec, dflRefreshAheadFactor, fWBRemove) : this.instantiateReadWriteBackingMap(contextBmm, mapInternal, (Map)mapMisses, storeBinary, fReadOnly, cWriteBehindSec, dflRefreshAheadFactor, fWBRemove);
            }
        } else {
            ResolvableParameterList listArgs = new ResolvableParameterList();
            listArgs.add(new Parameter("contextBmm", contextBmm));
            listArgs.add(new Parameter("mapInternal", mapInternal));
            listArgs.add(new Parameter("mapMisses", mapMisses));
            listArgs.add(new Parameter("storeBinary", storeBinary == null ? store : storeBinary));
            listArgs.add(new Parameter("readOnly", fReadOnly));
            listArgs.add(new Parameter("writeBehindSec", cWriteBehindSec));
            listArgs.add(new Parameter("refreshAheadFactory", dflRefreshAheadFactor));
            if (fWBRemove) {
                listArgs.add(new Parameter("writeBehindRemove", fWBRemove));
            }
            rwbm = (ReadWriteBackingMap)bldrCustom.realize(resolver, loader, listArgs);
        }
        rwbm.setCacheName(dependencies.getCacheName());
        rwbm.setRethrowExceptions(this.isRollbackCacheStoreFailures(resolver));
        rwbm.setWriteBatchFactor(this.getWriteBatchFactor(resolver));
        rwbm.setWriteRequeueThreshold(this.getWriteRequeueThreshold(resolver));
        rwbm.setWriteMaxBatchSize(this.getWriteMaxBatchSize(resolver));
        if (cWriteBehindMillis != 1000L * (long)cWriteBehindSec) {
            rwbm.setWriteBehindMillis(cWriteBehindMillis);
        }
        rwbm.setCacheStoreTimeoutMillis(this.getCacheStoreTimeout(resolver).as(Duration.Magnitude.MILLI));
        BundleManager bundleManager = managerBundle = bldrCacheStore == null ? null : bldrCacheStore.getBundleManager();
        if (managerBundle != null) {
            managerBundle.ensureBundles(resolver, rwbm.getCacheStore());
        }
        return rwbm;
    }

    @Override
    public void establishMapListeners(Map map, ParameterResolver resolver, MapBuilder.Dependencies dependencies) {
        super.establishMapListeners(map, resolver, dependencies);
        if (this.getInternalScheme() instanceof ObservableCachingScheme && map instanceof ReadWriteBackingMap) {
            ((ObservableCachingScheme)this.getInternalScheme()).establishMapListeners(((ReadWriteBackingMap)map).getInternalCache(), resolver, dependencies);
        }
    }

    public CacheStoreScheme getCacheStoreScheme() {
        return this.m_schemeCacheStore;
    }

    @Injectable(value="cachestore-scheme")
    public void setCacheStoreScheme(CacheStoreScheme bldr) {
        this.m_schemeCacheStore = bldr;
    }

    public Millis getCacheStoreTimeout(ParameterResolver resolver) {
        return this.m_exprCacheStoreTimeout.evaluate(resolver);
    }

    @Injectable(value="cachestore-timeout")
    public void setCacheStoreTimeout(Expression<Millis> expr) {
        this.m_exprCacheStoreTimeout = expr;
    }

    public CachingScheme getInternalScheme() {
        return this.m_schemeInternal;
    }

    @Injectable(value="internal-cache-scheme")
    public void setInternalScheme(CachingScheme scheme) {
        this.m_schemeInternal = scheme;
    }

    public ObservableMap getInternalMap() {
        return this.m_mapInternal;
    }

    public void setInternalMap(ObservableMap map) {
        this.m_mapInternal = map;
    }

    public LocalScheme getMissCacheScheme() {
        return this.m_schemeMissCache;
    }

    @Injectable(value="miss-cache-scheme")
    public void setMissCacheScheme(LocalScheme scheme) {
        this.m_schemeMissCache = scheme;
    }

    public boolean isReadOnly(ParameterResolver resolver) {
        return this.m_exprReadOnly.evaluate(resolver);
    }

    @Injectable
    public void setReadOnly(Expression<Boolean> expr) {
        this.m_exprReadOnly = expr;
    }

    public double getRefreshAheadFactor(ParameterResolver resolver) {
        return this.m_exprRefreshAheadFactor.evaluate(resolver);
    }

    @Injectable
    public void setRefreshAheadFactor(Expression<Double> expr) {
        this.m_exprRefreshAheadFactor = expr;
    }

    public boolean isRollbackCacheStoreFailures(ParameterResolver resolver) {
        return this.m_exprfRollbackCacheStoreFailures.evaluate(resolver);
    }

    @Injectable(value="rollback-cachestore-failures")
    public void setRollbackCacheStoreFailures(Expression<Boolean> expr) {
        this.m_exprfRollbackCacheStoreFailures = expr;
    }

    public double getWriteBatchFactor(ParameterResolver resolver) {
        return this.m_exprWriteBatchFactor.evaluate(resolver);
    }

    @Injectable
    public void setWriteBatchFactor(Expression<Double> expr) {
        this.m_exprWriteBatchFactor = expr;
    }

    public Seconds getWriteDelay(ParameterResolver resolver) {
        return this.m_exprWriteDelay.evaluate(resolver);
    }

    @Injectable
    public void setWriteDelay(Expression<Seconds> expr) {
        this.m_exprWriteDelay = expr;
    }

    public int getWriteDelaySeconds(ParameterResolver resolver) {
        return this.m_exprWriteDelaySeconds.evaluate(resolver);
    }

    @Injectable
    public void setWriteDelaySeconds(Expression<Integer> expr) {
        this.m_exprWriteDelaySeconds = expr;
    }

    public int getWriteMaxBatchSize(ParameterResolver resolver) {
        return this.m_exprWriteMaxBatchSize.evaluate(resolver);
    }

    @Injectable
    public void setWriteMaxBatchSize(Expression<Integer> expr) {
        this.m_exprWriteMaxBatchSize = expr;
    }

    public int getWriteRequeueThreshold(ParameterResolver resolver) {
        return this.m_exprWriteRequeueThreshold.evaluate(resolver);
    }

    @Injectable
    public void setWriteRequeueThreshold(Expression<Integer> expr) {
        this.m_exprWriteRequeueThreshold = expr;
    }

    public boolean isWriteBehindRemove(ParameterResolver resolver) {
        return this.m_exprWriteBehindRemove.evaluate(resolver);
    }

    @Injectable
    public void setWriteBehindRemove(Expression<Boolean> expr) {
        this.m_exprWriteBehindRemove = expr;
    }

    protected ReadWriteBackingMap instantiateReadWriteBackingMap(BackingMapManagerContext context, ObservableMap mapInternal, Map mapMisses, CacheLoader store, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor, boolean fWriteBehindRemove) {
        return new ReadWriteBackingMap(context, mapInternal, mapMisses, store, fReadOnly, cWriteBehindSeconds, dflRefreshAheadFactor, fWriteBehindRemove);
    }

    protected ReadWriteBackingMap instantiateReadWriteBackingMap(BackingMapManagerContext context, ObservableMap mapInternal, Map mapMisses, BinaryEntryStore storeBinary, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor, boolean fWriteBehindRemove) {
        return new ReadWriteBackingMap(context, mapInternal, mapMisses, storeBinary, fReadOnly, cWriteBehindSeconds, dflRefreshAheadFactor, fWriteBehindRemove);
    }

    protected ReadWriteBackingMap instantiateReadWriteBackingMap(BackingMapManagerContext context, ObservableMap mapInternal, Map mapMisses, NonBlockingEntryStore storeBinary, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor, boolean fWriteBehindRemove) {
        return new ReadWriteBackingMap(context, mapInternal, mapMisses, storeBinary, fReadOnly, cWriteBehindSeconds, dflRefreshAheadFactor, fWriteBehindRemove);
    }

    protected ReadWriteSplittingBackingMap instantiateReadWriteSplittingBackingMap(BackingMapManagerContext context, PartitionAwareBackingMap mapInternal, Map mapMisses, CacheLoader store, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor, boolean fWriteBehindRemove) {
        return new ReadWriteSplittingBackingMap(context, mapInternal, mapMisses, store, fReadOnly, cWriteBehindSeconds, dflRefreshAheadFactor, fWriteBehindRemove);
    }

    protected ReadWriteSplittingBackingMap instantiateReadWriteSplittingBackingMap(BackingMapManagerContext context, PartitionAwareBackingMap mapInternal, Map mapMisses, BinaryEntryStore storeBinary, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor, boolean fWriteBehindRemove) {
        return new ReadWriteSplittingBackingMap(context, mapInternal, mapMisses, storeBinary, fReadOnly, cWriteBehindSeconds, dflRefreshAheadFactor, fWriteBehindRemove);
    }

    protected ReadWriteSplittingBackingMap instantiateReadWriteSplittingBackingMap(BackingMapManagerContext context, PartitionAwareBackingMap mapInternal, Map mapMisses, NonBlockingEntryStore storeBinary, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor, boolean fWriteBehindRemove) {
        return new ReadWriteSplittingBackingMap(context, mapInternal, mapMisses, storeBinary, fReadOnly, cWriteBehindSeconds, dflRefreshAheadFactor, fWriteBehindRemove);
    }

    @Override
    protected void validate(ParameterResolver resolver) {
        super.validate(resolver);
        Base.checkNotNull(this.getInternalScheme(), "Internal scheme");
    }
}

