/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.scheme;

import com.oracle.coherence.common.net.InetAddresses;
import com.oracle.coherence.common.util.Duration;
import com.oracle.coherence.common.util.MemorySize;
import com.oracle.coherence.common.util.Options;
import com.tangosol.coherence.config.builder.ElementCalculatorBuilder;
import com.tangosol.coherence.config.builder.MapBuilder;
import com.tangosol.coherence.config.builder.NamedEventInterceptorBuilder;
import com.tangosol.coherence.config.builder.UnitCalculatorBuilder;
import com.tangosol.coherence.config.scheme.BackingMapScheme;
import com.tangosol.coherence.config.scheme.CachingScheme;
import com.tangosol.coherence.config.scheme.DistributedScheme;
import com.tangosol.coherence.config.scheme.LocalScheme;
import com.tangosol.coherence.config.scheme.NamedTopicScheme;
import com.tangosol.coherence.config.unit.Seconds;
import com.tangosol.coherence.config.unit.Units;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.config.injection.SimpleInjector;
import com.tangosol.internal.net.service.grid.DefaultPagedTopicServiceDependencies;
import com.tangosol.internal.net.service.grid.PartitionedCacheDependencies;
import com.tangosol.internal.net.topic.impl.paged.DefaultPagedTopicDependencies;
import com.tangosol.internal.net.topic.impl.paged.PagedTopic;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicBackingMapManager;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicDependencies;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicSubscriber;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.NamedCollection;
import com.tangosol.net.Service;
import com.tangosol.net.TopicService;
import com.tangosol.net.ValueTypeAssertion;
import com.tangosol.net.events.annotation.Interceptor;
import com.tangosol.net.topic.BinaryElementCalculator;
import com.tangosol.net.topic.FixedElementCalculator;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.util.RegistrationBehavior;
import com.tangosol.util.ResourceResolver;
import com.tangosol.util.ResourceResolverHelper;
import java.util.ArrayList;
import java.util.List;

public class PagedTopicScheme
extends DistributedScheme
implements NamedTopicScheme {
    private static final ParameterResolver NULL_PARAMETER_RESOLVER = new NullParameterResolver();
    private Expression<Integer> m_exprChannelCount = new LiteralExpression<Integer>(0);
    private Expression<Units> m_exprPageSize = new LiteralExpression<Units>(new Units(new MemorySize(0x100000L)));
    private Expression<MemorySize> m_exprHighUnits = new LiteralExpression<MemorySize>(new MemorySize(0L));
    private Expression<Boolean> m_exprTransient = new LiteralExpression<Boolean>(Boolean.FALSE);
    private Expression<String> m_exprStorageAccessAuthorizer = null;
    private CachingScheme m_schemeBackingMap;
    private Expression<Boolean> m_exprRetainConsumed = new LiteralExpression<Boolean>(Boolean.FALSE);
    private Expression<Seconds> m_exprExpiryDelay = new LiteralExpression<Seconds>(new Seconds(0));
    private Expression<Seconds> m_exprSubscriberTimeout = new LiteralExpression<Seconds>(PagedTopic.DEFAULT_SUBSCRIBER_TIMEOUT_SECONDS);
    private Expression<Boolean> m_exprAllowUnownedCommits = new LiteralExpression<Boolean>(Boolean.FALSE);
    private ElementCalculatorBuilder m_bldrElementCalculator;
    private Expression<Seconds> m_exprReconnectTimeout = new LiteralExpression<Seconds>(PagedTopic.DEFAULT_RECONNECT_TIMEOUT_SECONDS);
    private Expression<Seconds> m_exprReconnectRetry = new LiteralExpression<Seconds>(PagedTopic.DEFAULT_RECONNECT_RETRY_SECONDS);
    private Expression<Seconds> m_exprReconnectWait = new LiteralExpression<Seconds>(PagedTopic.DEFAULT_RECONNECT_WAIT_SECONDS);

    public PagedTopicScheme() {
        super(new DefaultPagedTopicServiceDependencies());
    }

    @Override
    public String getServiceType() {
        return "PagedTopic";
    }

    @Override
    public BackingMapManager realizeBackingMapManager(ConfigurableCacheFactory ccf) {
        if (ccf instanceof ExtensibleConfigurableCacheFactory) {
            return new PagedTopicBackingMapManager((ExtensibleConfigurableCacheFactory)ccf);
        }
        throw new IllegalArgumentException("The BackingMapManager cannot be must be instantiatedwith a given a ExtensibleConfigurableCacheFactory");
    }

    @Override
    public <T extends NamedCollection> boolean realizes(Class<T> type) {
        return NamedTopic.class.equals(type);
    }

    @Override
    public PagedTopicScheme getNamedCollectionBuilder(Class<? extends NamedCollection> clz, Options<NamedCollection.Option> options) {
        if (clz.isAssignableFrom(NamedTopic.class)) {
            return this;
        }
        return null;
    }

    public CachingScheme getStorageScheme(ParameterResolver resolver) {
        if (this.m_schemeBackingMap == null) {
            LocalScheme scheme = new LocalScheme();
            scheme.setUnitCalculatorBuilder(this.getUnitCalculatorBuilder(resolver));
            long cbHigh = this.getHighUnits(resolver);
            if (cbHigh >= Integer.MAX_VALUE) {
                scheme.setUnitFactor(r -> 1024);
            }
            this.m_schemeBackingMap = scheme;
        }
        return this.m_schemeBackingMap;
    }

    public CachingScheme getStorageScheme() {
        return this.getStorageScheme(NULL_PARAMETER_RESOLVER);
    }

    @Injectable(value="channel-count")
    public void setChannelCount(Expression<Integer> expr) {
        this.m_exprChannelCount = expr;
    }

    public int getChannelCount(ParameterResolver resolver) {
        return this.m_exprChannelCount.evaluate(resolver);
    }

    @Injectable(value="storage")
    public void setStorageScheme(CachingScheme scheme) {
        this.m_schemeBackingMap = scheme;
    }

    public Units getPageSize(ParameterResolver resolver) {
        return this.m_exprPageSize.evaluate(resolver);
    }

    @Injectable(value="page-size")
    public void setPageSize(Expression<Units> expr) {
        this.m_exprPageSize = expr;
    }

    public long getHighUnits(ParameterResolver resolver) {
        return this.m_exprHighUnits.evaluate(resolver).getByteCount();
    }

    @Injectable(value="high-units")
    public void setHighUnits(Expression<MemorySize> expr) {
        this.m_exprHighUnits = expr;
    }

    public Expression<Boolean> getTransientExpression() {
        return this.m_exprTransient;
    }

    @Injectable
    public void setTransient(Expression<Boolean> expr) {
        this.m_exprTransient = expr;
    }

    public Expression<String> getStorageAccessAuthorizer() {
        return this.m_exprStorageAccessAuthorizer;
    }

    @Injectable(value="storage-authorizer")
    public void setStorageAccessAuthorizer(Expression<String> exprStorageAccessAuthorizer) {
        this.m_exprStorageAccessAuthorizer = exprStorageAccessAuthorizer;
        BackingMapScheme scheme = this.getBackingMapScheme();
        if (scheme != null) {
            scheme.setStorageAccessAuthorizer(this.m_exprStorageAccessAuthorizer);
        }
    }

    public Seconds getExpiryDelay(ParameterResolver resolver) {
        return this.m_exprExpiryDelay.evaluate(resolver);
    }

    @Injectable
    public void setExpiryDelay(Expression<Seconds> expr) {
        this.m_exprExpiryDelay = expr;
    }

    public boolean isRetainConsumed(ParameterResolver resolver) {
        Boolean fRetain = this.m_exprRetainConsumed.evaluate(resolver);
        return fRetain != null && fRetain != false;
    }

    @Injectable(value="retain-consumed")
    public void setRetainConsumed(Expression<Boolean> expr) {
        this.m_exprRetainConsumed = expr;
    }

    public boolean isAllowUnownedCommits(ParameterResolver resolver) {
        Boolean fRetain = this.m_exprAllowUnownedCommits.evaluate(resolver);
        return fRetain != null && fRetain != false;
    }

    @Injectable(value="allow-unowned-commits")
    public void setAllowUnownedCommits(Expression<Boolean> expr) {
        this.m_exprAllowUnownedCommits = expr;
    }

    public Seconds getSubscriberTimeout(ParameterResolver resolver) {
        return this.m_exprSubscriberTimeout.evaluate(resolver);
    }

    @Injectable(value="subscriber-timeout")
    public void setSubscriberTimeout(Expression<Seconds> expr) {
        this.m_exprSubscriberTimeout = expr == null ? new LiteralExpression<Seconds>(PagedTopic.DEFAULT_SUBSCRIBER_TIMEOUT_SECONDS) : expr;
    }

    public ElementCalculatorBuilder getElementCalculatorBuilder() {
        return this.m_bldrElementCalculator;
    }

    @Injectable(value="element-calculator")
    public void setElementCalculatorBuilder(ElementCalculatorBuilder builder) {
        this.m_bldrElementCalculator = builder;
    }

    @Override
    @Injectable(value="interceptors")
    public void setEventInterceptorBuilders(List<NamedEventInterceptorBuilder> listBuilders) {
        super.setEventInterceptorBuilders(listBuilders);
    }

    @Override
    public List<NamedEventInterceptorBuilder> getEventInterceptorBuilders() {
        List<NamedEventInterceptorBuilder> list = super.getEventInterceptorBuilders();
        if (list == null) {
            list = new ArrayList<NamedEventInterceptorBuilder>();
        }
        NamedEventInterceptorBuilder builderTimeout = new NamedEventInterceptorBuilder();
        builderTimeout.setOrder(Interceptor.Order.HIGH);
        builderTimeout.setName("$SubscriberExpiry$" + this.getServiceName());
        builderTimeout.setRegistrationBehavior(RegistrationBehavior.REPLACE);
        builderTimeout.setCustomBuilder((resolver, loader, listParameters) -> new PagedTopicSubscriber.TimeoutInterceptor());
        list.add(builderTimeout);
        return list;
    }

    public Seconds getReconnectTimeoutMillis(ParameterResolver resolver) {
        return this.m_exprReconnectTimeout.evaluate(resolver);
    }

    @Injectable(value="reconnect-timeout")
    public void setReconnectTimeoutMillis(Expression<Seconds> expr) {
        this.m_exprReconnectTimeout = expr == null ? new LiteralExpression<Seconds>(PagedTopic.DEFAULT_RECONNECT_TIMEOUT_SECONDS) : expr;
    }

    public Seconds getReconnectRetryMillis(ParameterResolver resolver) {
        return this.m_exprReconnectRetry.evaluate(resolver);
    }

    @Injectable(value="reconnect-retry")
    public void setReconnectRetryMillis(Expression<Seconds> expr) {
        this.m_exprReconnectRetry = expr == null ? new LiteralExpression<Seconds>(PagedTopic.DEFAULT_RECONNECT_RETRY_SECONDS) : expr;
    }

    public Seconds getReconnectWaitMillis(ParameterResolver resolver) {
        return this.m_exprReconnectWait.evaluate(resolver);
    }

    @Injectable(value="reconnect-wait")
    public void setReconnectWaitMillis(Expression<Seconds> expr) {
        this.m_exprReconnectWait = expr == null ? new LiteralExpression<Seconds>(PagedTopic.DEFAULT_RECONNECT_WAIT_SECONDS) : expr;
    }

    @Override
    public <V> NamedTopic realize(ValueTypeAssertion<V> typeConstraint, ParameterResolver resolver, MapBuilder.Dependencies deps) {
        String sQueueName = deps.getCacheName();
        TopicService service = this.ensureConfiguredService(resolver, deps);
        return service.ensureTopic(sQueueName, deps.getClassLoader());
    }

    @Override
    public TopicService ensureConfiguredService(ParameterResolver resolver, MapBuilder.Dependencies deps) {
        return this.getOrEnsureService(deps);
    }

    private TopicService getOrEnsureService(MapBuilder.Dependencies deps) {
        ExtensibleConfigurableCacheFactory eccf = (ExtensibleConfigurableCacheFactory)deps.getConfigurableCacheFactory();
        Service service = CacheFactory.getCluster().getService(this.getScopedServiceName());
        if (service == null) {
            service = eccf.ensureService(this);
        }
        if (service instanceof TopicService) {
            return (TopicService)service;
        }
        throw new IllegalArgumentException("Error: the configured service " + service.getInfo().getServiceName() + " is not a TopicService");
    }

    public PagedTopicDependencies createConfiguration(ParameterResolver resolver, ClassLoader loader) {
        NamedTopic.ElementCalculator calculator;
        int nMaxBatchSizeBytes;
        Cluster cluster;
        int nMTU;
        SimpleInjector injector = new SimpleInjector();
        ResourceResolver resourceResolver = ResourceResolverHelper.resourceResolverFrom(PagedTopicScheme.class, this);
        injector.inject(this, ResourceResolverHelper.resourceResolverFrom(resourceResolver, resourceResolver));
        long cbServer = this.getHighUnits(resolver);
        long expiryDelayMillis = 0L;
        Seconds expiryDelaySeconds = this.getExpiryDelay(resolver);
        boolean fRetainConsumed = this.isRetainConsumed(resolver);
        if (expiryDelaySeconds != null) {
            expiryDelayMillis = expiryDelaySeconds.as(Duration.Magnitude.MILLI);
        }
        if ((nMTU = InetAddresses.getLocalMTU((cluster = CacheFactory.getCluster()).getLocalMember().getAddress())) == 0) {
            nMTU = 1500;
        }
        try {
            nMaxBatchSizeBytes = Math.multiplyExact(nMTU, cluster.getDependencies().getPublisherCloggedCount());
        }
        catch (ArithmeticException e) {
            nMaxBatchSizeBytes = Integer.MAX_VALUE;
        }
        Units pageSize = this.getPageSize(resolver);
        long cbPage = pageSize.getUnitCount();
        boolean fBinarySize = pageSize.isMemorySize();
        if (cbPage <= 0L) {
            cbPage = 0x100000L;
            fBinarySize = true;
        } else if (cbPage > Integer.MAX_VALUE) {
            cbPage = Integer.MAX_VALUE;
        }
        NamedTopic.ElementCalculator calculatorDefault = fBinarySize ? BinaryElementCalculator.INSTANCE : FixedElementCalculator.INSTANCE;
        ElementCalculatorBuilder calculatorBuilder = this.getElementCalculatorBuilder();
        NamedTopic.ElementCalculator elementCalculator = calculator = calculatorBuilder == null ? calculatorDefault : calculatorBuilder.realize(resolver, loader, null);
        if (pageSize.isMemorySize() && calculator instanceof FixedElementCalculator) {
            throw new ConfigurationException("Cannot use the FIXED element calculator with a memory (or default) page-size", "When using a FIXED element calculator a page-size without a memory-unit suffix must be specified");
        }
        PartitionedCacheDependencies depsService = (PartitionedCacheDependencies)this.getServiceDependencies();
        int cPart = depsService.getPreferredPartitionCount();
        DefaultPagedTopicDependencies dependencies = new DefaultPagedTopicDependencies(cPart);
        dependencies.setServerCapacity(cbServer);
        dependencies.setPageCapacity((int)cbPage);
        dependencies.setElementExpiryMillis(expiryDelayMillis);
        dependencies.setMaxBatchSizeBytes(Math.min((int)cbPage, nMaxBatchSizeBytes));
        dependencies.setRetainConsumed(fRetainConsumed);
        dependencies.setElementCalculator(calculator);
        dependencies.setChannelCount(this.getChannelCount(resolver));
        dependencies.setAllowUnownedCommits(this.isAllowUnownedCommits(resolver));
        dependencies.setSubscriberTimeoutMillis(this.getSubscriberTimeout(resolver).as(Duration.Magnitude.MILLI));
        dependencies.setReconnectTimeoutMillis(this.getReconnectTimeoutMillis(resolver).as(Duration.Magnitude.MILLI));
        dependencies.setReconnectRetryMillis(this.getReconnectRetryMillis(resolver).as(Duration.Magnitude.MILLI));
        dependencies.setReconnectWaitMillis(this.getReconnectWaitMillis(resolver).as(Duration.Magnitude.MILLI));
        return dependencies;
    }

    private UnitCalculatorBuilder getUnitCalculatorBuilder(ParameterResolver resolver) {
        UnitCalculatorBuilder bldr = new UnitCalculatorBuilder();
        Parameter param = resolver.resolve("unit-calculator");
        LiteralExpression<String> expr = param == null ? new LiteralExpression<String>("BINARY") : param.evaluate(resolver).as(Expression.class);
        bldr.setUnitCalculatorType(expr);
        return bldr;
    }
}

