/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.scheme;

import com.oracle.coherence.common.util.MemorySize;
import com.oracle.coherence.common.util.Options;
import com.tangosol.coherence.config.builder.MapBuilder;
import com.tangosol.coherence.config.builder.NamedEventInterceptorBuilder;
import com.tangosol.coherence.config.scheme.DistributedScheme;
import com.tangosol.coherence.config.scheme.NamedQueueScheme;
import com.tangosol.coherence.config.unit.Units;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.config.injection.SimpleInjector;
import com.tangosol.internal.net.NamedMapValuesCollection;
import com.tangosol.internal.net.queue.DefaultPagedQueueDependencies;
import com.tangosol.internal.net.queue.NamedMapQueue;
import com.tangosol.internal.net.queue.PagedQueueDependencies;
import com.tangosol.internal.net.queue.paged.BinaryPagedNamedQueue;
import com.tangosol.internal.net.queue.paged.PagedNamedQueue;
import com.tangosol.internal.net.service.grid.DefaultPagedQueueServiceDependencies;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedCollection;
import com.tangosol.net.NamedQueue;
import com.tangosol.net.QueueService;
import com.tangosol.net.Service;
import com.tangosol.net.ValueTypeAssertion;
import com.tangosol.net.cache.NearCache;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ResourceResolver;
import com.tangosol.util.ResourceResolverHelper;
import java.util.List;

public class PagedQueueScheme
extends DistributedScheme
implements NamedQueueScheme<NamedMapQueue> {
    private Expression<Units> m_exprPageSize = new LiteralExpression<Units>(new Units(new MemorySize(0xA00000L)));
    public static final PagedQueueScheme INSTANCE = new PagedQueueScheme();

    public PagedQueueScheme() {
        super(new DefaultPagedQueueServiceDependencies());
    }

    @Override
    public String getServiceType() {
        return "DistributedQueue";
    }

    @Override
    public <T extends NamedCollection> boolean realizes(Class<T> type) {
        return type.isAssignableFrom(PagedNamedQueue.class);
    }

    @Override
    public PagedQueueScheme getNamedCollectionBuilder(Class<? extends NamedCollection> clz, Options<NamedCollection.Option> options) {
        if (clz.isAssignableFrom(NamedQueue.class)) {
            return this;
        }
        return null;
    }

    public Units getPageSize(ParameterResolver resolver) {
        return this.m_exprPageSize.evaluate(resolver);
    }

    @Injectable(value="page-size")
    public void setPageSize(Expression<Units> expr) {
        this.m_exprPageSize = expr;
    }

    @Override
    @Injectable(value="interceptors")
    public void setEventInterceptorBuilders(List<NamedEventInterceptorBuilder> listBuilders) {
        super.setEventInterceptorBuilders(listBuilders);
    }

    @Override
    public <V> NamedMapQueue<?, V> realize(ValueTypeAssertion<V> typeConstraint, ParameterResolver resolver, MapBuilder.Dependencies deps) {
        NamedMapValuesCollection pagedQueue;
        ExtensibleConfigurableCacheFactory eccf = (ExtensibleConfigurableCacheFactory)deps.getConfigurableCacheFactory();
        String sQueueName = deps.getCacheName();
        if (NullImplementation.getClassLoader().equals(deps.getClassLoader())) {
            pagedQueue = new BinaryPagedNamedQueue(sQueueName, eccf);
        } else {
            NamedCache cache = eccf.ensureCache(sQueueName, null);
            if (cache instanceof NearCache) {
                cache = ((NearCache)cache).getBackCache();
            }
            pagedQueue = new PagedNamedQueue(sQueueName, cache);
        }
        return pagedQueue;
    }

    @Override
    public QueueService ensureConfiguredService(ParameterResolver resolver, MapBuilder.Dependencies deps) {
        return this.getOrEnsureService(deps);
    }

    private QueueService getOrEnsureService(MapBuilder.Dependencies deps) {
        ExtensibleConfigurableCacheFactory eccf = (ExtensibleConfigurableCacheFactory)deps.getConfigurableCacheFactory();
        Service service = CacheFactory.getCluster().getService(this.getScopedServiceName());
        if (service == null) {
            service = eccf.ensureService(this);
        }
        if (service instanceof QueueService) {
            return (QueueService)service;
        }
        throw new IllegalArgumentException("Error: the configured service " + service.getInfo().getServiceName() + " is not a QueueService");
    }

    public PagedQueueDependencies createConfiguration(ParameterResolver resolver, ClassLoader loader) {
        SimpleInjector injector = new SimpleInjector();
        ResourceResolver resourceResolver = ResourceResolverHelper.resourceResolverFrom(PagedQueueScheme.class, this);
        injector.inject(this, ResourceResolverHelper.resourceResolverFrom(resourceResolver, resourceResolver));
        Units pageSize = this.getPageSize(resolver);
        long cbPage = pageSize.getUnitCount();
        if (cbPage <= 0L) {
            cbPage = 0xA00000L;
        } else if (cbPage > Integer.MAX_VALUE) {
            cbPage = Integer.MAX_VALUE;
        }
        DefaultPagedQueueDependencies dependencies = new DefaultPagedQueueDependencies();
        dependencies.setPageCapacity((int)cbPage);
        return dependencies;
    }
}

