/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.scheme;

import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.coherence.config.builder.MapBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.storemanager.BinaryStoreManagerBuilder;
import com.tangosol.coherence.config.builder.storemanager.BinaryStoreManagerBuilderCustomization;
import com.tangosol.coherence.config.scheme.AbstractLocalCachingScheme;
import com.tangosol.coherence.config.unit.Seconds;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.io.BinaryStoreManager;
import com.tangosol.net.cache.SerializationPagedCache;
import com.tangosol.util.Base;
import java.util.Map;

public class PagedExternalScheme
extends AbstractLocalCachingScheme<Map>
implements BinaryStoreManagerBuilderCustomization {
    private static final int DEFAULT_PAGE_SECONDS = 5;
    private static final int MIN_PAGE_SECONDS = 5;
    private static final int MAX_PAGE_SECONDS = 604800;
    private static final int DEFAULT_PAGE_LIMIT = 0;
    private static final int MIN_PAGE_LIMIT = 2;
    private static final int MAX_PAGE_LIMIT = 3600;
    private BinaryStoreManagerBuilder m_bldrStoreManager;
    private Expression<Seconds> m_exprPageDurationSeconds = new LiteralExpression<Seconds>(new Seconds(5));
    private Expression<Integer> m_exprPageLimit = new LiteralExpression<Integer>(0);

    @Override
    public Map realizeMap(ParameterResolver resolver, MapBuilder.Dependencies dependencies) {
        this.validate(resolver);
        ClassLoader loader = dependencies.getClassLoader();
        int cPages = this.getPageLimit(resolver);
        int cPageSecs = (int)this.getPageDurationSeconds(resolver).get();
        boolean fBackup = dependencies.isBackup();
        boolean fBinaryMap = dependencies.isBinary();
        BinaryStoreManager storeManager = this.getBinaryStoreManagerBuilder().realize(resolver, loader, true);
        ParameterizedBuilder bldrCustom = this.getCustomBuilder();
        if (bldrCustom == null) {
            return fBinaryMap ? this.instantiateSerializationPagedCache(storeManager, cPages, cPageSecs, true, fBackup) : this.instantiateSerializationPagedCache(storeManager, cPages, cPageSecs, loader);
        }
        ResolvableParameterList listArgs = new ResolvableParameterList();
        listArgs.add(new Parameter("store-manager", storeManager));
        listArgs.add(new Parameter("pages", cPages));
        listArgs.add(new Parameter("page-duration", cPageSecs));
        if (fBinaryMap) {
            listArgs.add(new Parameter("fBinary", Boolean.TRUE));
            listArgs.add(new Parameter("fBackup", fBackup));
        } else {
            listArgs.add(new Parameter("loader", loader));
        }
        return (Map)bldrCustom.realize(resolver, loader, listArgs);
    }

    @Override
    public BinaryStoreManagerBuilder getBinaryStoreManagerBuilder() {
        return this.m_bldrStoreManager;
    }

    @Override
    public void setBinaryStoreManagerBuilder(BinaryStoreManagerBuilder bldr) {
        this.m_bldrStoreManager = bldr;
    }

    public Seconds getPageDurationSeconds(ParameterResolver resolver) {
        return this.m_exprPageDurationSeconds.evaluate(resolver);
    }

    @Injectable(value="page-duration")
    public void setPageDurationSeconds(Expression<Seconds> expr) {
        this.m_exprPageDurationSeconds = expr;
    }

    public int getPageLimit(ParameterResolver resolver) {
        return this.m_exprPageLimit.evaluate(resolver);
    }

    @Injectable
    public void setPageLimit(Expression<Integer> expr) {
        this.m_exprPageLimit = expr;
    }

    protected SerializationPagedCache instantiateSerializationPagedCache(BinaryStoreManager storeMgr, int cPages, int cPageSecs, ClassLoader loader) {
        return new SerializationPagedCache(storeMgr, cPages, cPageSecs, loader);
    }

    protected SerializationPagedCache instantiateSerializationPagedCache(BinaryStoreManager storeMgr, int cPages, int cPageSecs, boolean fBinaryMap, boolean fPassive) {
        return new SerializationPagedCache(storeMgr, cPages, cPageSecs, fBinaryMap, fPassive);
    }

    @Override
    protected void validate(ParameterResolver resolver) {
        super.validate(resolver);
        int cPages = this.getPageLimit(resolver);
        int cPageSecs = (int)this.getPageDurationSeconds(resolver).get();
        Base.checkRange(cPages, 2L, 3600L, "Page limit");
        Base.checkRange(cPageSecs, 5L, 604800L, "Page seconds");
        Base.checkNotNull(this.m_bldrStoreManager, "StoreManager");
    }
}

