/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.scheme;

import com.oracle.coherence.common.util.MemorySize;
import com.tangosol.coherence.config.builder.MapBuilder;
import com.tangosol.coherence.config.builder.NamedEventInterceptorBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.scheme.AbstractCachingScheme;
import com.tangosol.coherence.config.scheme.AbstractScheme;
import com.tangosol.coherence.config.scheme.BackingMapScheme;
import com.tangosol.coherence.config.scheme.BackupMapConfig;
import com.tangosol.coherence.config.scheme.BundleManager;
import com.tangosol.coherence.config.scheme.BundlingScheme;
import com.tangosol.coherence.config.scheme.ClusteredCachingScheme;
import com.tangosol.coherence.config.scheme.FlashJournalScheme;
import com.tangosol.coherence.config.scheme.LocalScheme;
import com.tangosol.coherence.config.scheme.RamJournalScheme;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.internal.net.service.grid.DefaultPartitionedCacheDependencies;
import com.tangosol.internal.net.service.grid.PartitionedCacheDependencies;
import java.util.List;
import java.util.Map;

public class DistributedScheme
extends AbstractCachingScheme<PartitionedCacheDependencies>
implements ClusteredCachingScheme,
BundlingScheme {
    private BackingMapScheme m_schemeBackingMap;
    private BackupMapConfig m_configBackup;
    private BundleManager m_mgrBundle;
    private List<NamedEventInterceptorBuilder> m_listEventInterceptorBuilders;

    public DistributedScheme() {
        this(new DefaultPartitionedCacheDependencies());
    }

    protected DistributedScheme(PartitionedCacheDependencies deps) {
        this.m_serviceDependencies = deps;
        this.m_mgrBundle = null;
        this.m_schemeBackingMap = new BackingMapScheme();
        this.m_schemeBackingMap.setInnerScheme(new LocalScheme());
    }

    @Override
    public String getServiceType() {
        return "DistributedCache";
    }

    @Override
    public List<NamedEventInterceptorBuilder> getEventInterceptorBuilders() {
        return this.m_listEventInterceptorBuilders;
    }

    @Override
    public boolean isRunningClusterNeeded() {
        return true;
    }

    @Override
    public BundleManager getBundleManager() {
        return this.m_mgrBundle;
    }

    @Override
    public BackingMapScheme getBackingMapScheme() {
        return this.m_schemeBackingMap;
    }

    @Injectable(value="backing-map-scheme")
    public void setBackingMapScheme(BackingMapScheme scheme) {
        this.m_schemeBackingMap = scheme;
    }

    public BackupMapConfig getBackupMapConfig() {
        BackupMapConfig config = this.m_configBackup;
        if (config == null) {
            this.m_configBackup = config = new BackupConfig();
        }
        return config;
    }

    @Injectable(value="operation-bundling")
    public void setBundleManager(BundleManager mgrBundle) {
        this.m_mgrBundle = mgrBundle;
    }

    @Injectable(value="backup-storage")
    public void setBackupMapConfig(BackupMapConfig config) {
        this.m_configBackup = config;
    }

    @Injectable(value="interceptors")
    public void setEventInterceptorBuilders(List<NamedEventInterceptorBuilder> listBuilders) {
        this.m_listEventInterceptorBuilders = listBuilders;
    }

    public static class BackupConfig
    extends AbstractScheme
    implements BackupMapConfig {
        private Expression<String> m_exprDirectory = new LiteralExpression<String>("");
        private Expression<MemorySize> m_exprInitialSize = new LiteralExpression<MemorySize>(new MemorySize("1M"));
        private Expression<MemorySize> m_exprMaximumSize = new LiteralExpression<MemorySize>(new MemorySize("1024M"));
        private Expression<String> m_exprBackupSchemeName = new LiteralExpression<String>("");
        private Expression<String> m_exrpType = new LiteralExpression<String>("");
        private ParameterizedBuilder<Map> m_bldrCustom;

        @Override
        public int resolveType(ParameterResolver resolver, MapBuilder bldrPrimaryMap) {
            String sType = this.getType(resolver);
            int nType = 0;
            if (sType == null || sType.isEmpty()) {
                if (bldrPrimaryMap instanceof FlashJournalScheme || bldrPrimaryMap instanceof RamJournalScheme) {
                    nType = 5;
                }
            } else {
                nType = this.translateType(sType);
            }
            return nType;
        }

        @Override
        public String getDirectory(ParameterResolver resolver) {
            return this.m_exprDirectory.evaluate(resolver);
        }

        @Injectable
        public void setDirectory(Expression<String> expr) {
            this.m_exprDirectory = expr;
        }

        @Override
        public int getInitialSize(ParameterResolver resolver) {
            return (int)this.m_exprInitialSize.evaluate(resolver).getByteCount();
        }

        @Injectable
        public void setInitialSize(Expression<MemorySize> expr) {
            this.m_exprInitialSize = expr;
        }

        @Override
        public int getMaximumSize(ParameterResolver resolver) {
            return (int)this.m_exprMaximumSize.evaluate(resolver).getByteCount();
        }

        @Injectable
        public void setMaximumSize(Expression<MemorySize> expr) {
            this.m_exprMaximumSize = expr;
        }

        @Override
        public String getBackupSchemeName(ParameterResolver resolver) {
            return this.m_exprBackupSchemeName.evaluate(resolver);
        }

        @Injectable(value="scheme-name")
        public void setBackupSchemeName(Expression<String> expr) {
            this.m_exprBackupSchemeName = expr;
        }

        private String getType(ParameterResolver resolver) {
            return this.m_exrpType.evaluate(resolver);
        }

        @Injectable
        public void setType(Expression<String> expr) {
            this.m_exrpType = expr;
        }

        @Override
        public ParameterizedBuilder<Map> getCustomBuilder() {
            return this.m_bldrCustom;
        }

        @Override
        public void setCustomBuilder(ParameterizedBuilder<Map> bldr) {
            this.m_bldrCustom = bldr;
        }

        protected int translateType(String sType) {
            int nType = -1;
            if (sType.equalsIgnoreCase("custom")) {
                nType = 3;
            } else if (sType.equalsIgnoreCase("off-heap")) {
                nType = 1;
            } else if (sType.equalsIgnoreCase("on-heap")) {
                nType = 0;
            } else if (sType.equalsIgnoreCase("file-mapped")) {
                nType = 2;
            } else if (sType.equalsIgnoreCase("scheme")) {
                nType = 4;
            } else {
                throw new IllegalArgumentException("Invalid backup storage type " + sType);
            }
            return nType;
        }
    }
}

