/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.scheme;

import com.oracle.coherence.caffeine.CaffeineCache;
import com.oracle.coherence.common.util.Duration;
import com.tangosol.coherence.config.builder.MapBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.UnitCalculatorBuilder;
import com.tangosol.coherence.config.scheme.AbstractLocalCachingScheme;
import com.tangosol.coherence.config.unit.Seconds;
import com.tangosol.coherence.config.unit.Units;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.config.injection.SimpleInjector;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.util.ResourceResolver;
import com.tangosol.util.ResourceResolverHelper;

public class CaffeineScheme
extends AbstractLocalCachingScheme<CaffeineCache> {
    private UnitCalculatorBuilder m_bldrUnitCalculator;
    private Expression<Seconds> m_exprExpiryDelay = new LiteralExpression<Seconds>(new Seconds(0));
    private Expression<Units> m_exprHighUnits = new LiteralExpression<Units>(new Units(0L));
    private Expression<Integer> m_exprUnitFactor = new LiteralExpression<Integer>(1);

    @Override
    public CaffeineCache realizeMap(ParameterResolver resolver, MapBuilder.Dependencies dependencies) {
        this.validate(resolver);
        Units highUnits = this.getHighUnits(resolver);
        long cHighUnits = highUnits.getUnitCount();
        int nUnitFactor = this.getUnitFactor(resolver);
        int cExpiryDelayMillis = (int)this.getExpiryDelay(resolver).as(Duration.Magnitude.MILLI);
        while (cHighUnits >= Integer.MAX_VALUE) {
            cHighUnits /= 1024L;
            nUnitFactor *= 1024;
        }
        if (cHighUnits <= 0L) {
            cHighUnits = Integer.MAX_VALUE;
        }
        if (cExpiryDelayMillis < 0) {
            cExpiryDelayMillis = 0;
        }
        CaffeineCache cache = null;
        ClassLoader loader = dependencies.getClassLoader();
        ParameterizedBuilder bldrCustom = this.getCustomBuilder();
        if (bldrCustom == null) {
            cache = new CaffeineCache();
            cache.setHighUnits((int)cHighUnits);
            cache.setExpiryDelay(cExpiryDelayMillis);
        } else {
            cache = (CaffeineCache)bldrCustom.realize(resolver, loader, null);
            cache.setHighUnits((int)cHighUnits);
            cache.setExpiryDelay(cExpiryDelayMillis);
            SimpleInjector injector = new SimpleInjector();
            ResourceResolver resourceResolver = ResourceResolverHelper.resourceResolverFrom(ResourceResolverHelper.resourceResolverFrom(resolver, this.getDefaultParameterResolver()), ResourceResolverHelper.resourceResolverFrom(dependencies));
            injector.inject(cache, resourceResolver);
        }
        if (CacheFactory.getCluster().isRunning()) {
            cache.setOptimizeGetTime(true);
        }
        ConfigurableCacheMap.UnitCalculator defaultCalculator = highUnits.isMemorySize() && dependencies.isBinary() ? LocalCache.INSTANCE_BINARY : null;
        UnitCalculatorBuilder bldrUnitCalculator = this.getUnitCalculatorBuilder();
        cache.setUnitFactor(nUnitFactor);
        cache.setUnitCalculator(bldrUnitCalculator == null ? defaultCalculator : bldrUnitCalculator.realize(resolver, loader, null));
        return cache;
    }

    public Seconds getExpiryDelay(ParameterResolver resolver) {
        return this.m_exprExpiryDelay.evaluate(resolver);
    }

    @Injectable
    public void setExpiryDelay(Expression<Seconds> expr) {
        this.m_exprExpiryDelay = expr;
    }

    public Units getHighUnits(ParameterResolver resolver) {
        return this.m_exprHighUnits.evaluate(resolver);
    }

    @Injectable
    public void setHighUnits(Expression<Units> expr) {
        this.m_exprHighUnits = expr;
    }

    public UnitCalculatorBuilder getUnitCalculatorBuilder() {
        return this.m_bldrUnitCalculator;
    }

    @Injectable(value="unit-calculator")
    public void setUnitCalculatorBuilder(UnitCalculatorBuilder builder) {
        this.m_bldrUnitCalculator = builder;
    }

    public int getUnitFactor(ParameterResolver resolver) {
        return this.m_exprUnitFactor.evaluate(resolver);
    }

    @Injectable
    public void setUnitFactor(Expression<Integer> expr) {
        this.m_exprUnitFactor = expr;
    }

    @Override
    protected void validate(ParameterResolver resolver) {
        super.validate(resolver);
        if (this.getExpiryDelay(resolver).as(Duration.Magnitude.MILLI) > Integer.MAX_VALUE) {
            throw new ConfigurationException("Illegal value specified for <expiry-delay> for caffeine scheme '" + this.getSchemeName() + "'", "The expiry delay cannot exceed 2147483 seconds or ~24 days.");
        }
    }
}

