/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.scheme;

import com.tangosol.coherence.config.builder.MapBuilder;
import com.tangosol.coherence.config.builder.ReadLocatorBuilder;
import com.tangosol.coherence.config.scheme.AbstractJournalScheme;
import com.tangosol.coherence.config.scheme.AbstractLocalCachingScheme;
import com.tangosol.coherence.config.scheme.CachingScheme;
import com.tangosol.coherence.config.scheme.ReadWriteBackingMapScheme;
import com.tangosol.coherence.config.scheme.WrapperCachingScheme;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import java.util.Map;

public class BackingMapScheme
extends AbstractLocalCachingScheme {
    public static final int ON_HEAP = 0;
    public static final int OFF_HEAP = 1;
    public static final int FILE_MAPPED = 2;
    public static final int CUSTOM = 3;
    public static final int SCHEME = 4;
    public static final int FLASHJOURNAL = 5;
    public static final int RAMJOURNAL = 6;
    private Expression<String> m_exprPartitioned = new LiteralExpression<String>("");
    private Expression<Boolean> m_exprTransient = new LiteralExpression<Boolean>(Boolean.FALSE);
    private Expression<Boolean> m_exprSlidingExpiry = new LiteralExpression<Boolean>(Boolean.FALSE);
    private Expression<Boolean> m_exprFedApplySynthetic = new LiteralExpression<Boolean>(Boolean.FALSE);
    private Expression<String> m_exprStorageAccessAuthorizer = null;
    private ReadLocatorBuilder m_bldrReadLocator = new ReadLocatorBuilder();
    private CachingScheme m_schemeInner;

    @Override
    public Map realizeMap(ParameterResolver resolver, MapBuilder.Dependencies dependencies) {
        this.validate(resolver);
        CachingScheme bldrMap = this.getInnerScheme();
        return bldrMap.realizeMap(resolver, dependencies);
    }

    public CachingScheme getInnerScheme() {
        return this.m_schemeInner;
    }

    public void setInnerScheme(CachingScheme scheme) {
        this.m_schemeInner = scheme;
    }

    private String getPartitioned(ParameterResolver resolver) {
        return this.m_exprPartitioned.evaluate(resolver);
    }

    @Injectable
    public void setPartitioned(Expression<String> expr) {
        this.m_exprPartitioned = expr;
    }

    public boolean isPartitioned(ParameterResolver resolver, boolean fDefault) {
        boolean fPartitioned = fDefault;
        this.validate(resolver);
        String sPartitioned = this.getPartitioned(resolver);
        if (sPartitioned == null || sPartitioned.isEmpty()) {
            CachingScheme bldr = this.getInnerScheme();
            if (bldr instanceof WrapperCachingScheme) {
                bldr = ((WrapperCachingScheme)bldr).getCachingScheme();
            }
            if (bldr instanceof ReadWriteBackingMapScheme) {
                bldr = ((ReadWriteBackingMapScheme)bldr).getInternalScheme();
            }
            fPartitioned = bldr instanceof AbstractJournalScheme ? true : fPartitioned;
        } else {
            Boolean BPartitioned;
            if (sPartitioned.equals("observable")) {
                fPartitioned = true;
            }
            if ((BPartitioned = (Boolean)XmlHelper.convert(sPartitioned, 1)) == null) {
                throw new IllegalArgumentException("Invalid \"partitioned\" value: \"" + sPartitioned + "\"");
            }
            fPartitioned = BPartitioned;
        }
        return fPartitioned;
    }

    public boolean isTransient(ParameterResolver resolver) {
        return this.m_exprTransient.evaluate(resolver);
    }

    @Injectable
    public void setTransient(Expression<Boolean> expr) {
        this.m_exprTransient = expr;
    }

    public Boolean isSlidingExpiry(ParameterResolver resolver) {
        return this.m_exprSlidingExpiry.evaluate(resolver);
    }

    @Injectable(value="sliding-expiry")
    public void setSlidingExpiry(Expression<Boolean> expr) {
        this.m_exprSlidingExpiry = expr;
    }

    public Boolean isFederateApplySynthetic(ParameterResolver resolver) {
        return this.m_exprFedApplySynthetic.evaluate(resolver);
    }

    @Injectable(value="federate-apply-synthetic")
    public void setFederateApplySynthetic(Expression<Boolean> expr) {
        this.m_exprFedApplySynthetic = expr;
    }

    public Expression<String> getStorageAccessAuthorizer() {
        return this.m_exprStorageAccessAuthorizer;
    }

    @Injectable(value="storage-authorizer")
    public void setStorageAccessAuthorizer(Expression<String> exprStorageAccessAuthorizer) {
        this.m_exprStorageAccessAuthorizer = exprStorageAccessAuthorizer;
    }

    public ReadLocatorBuilder getReadLocatorBuilder() {
        return this.m_bldrReadLocator;
    }

    @Injectable(value="read-locator")
    public void etReadLocatorBuilder(ReadLocatorBuilder bldrReadLocator) {
        this.m_bldrReadLocator = bldrReadLocator;
    }

    @Override
    protected void validate(ParameterResolver resolver) {
        super.validate(resolver);
        Base.checkNotNull(this.getInnerScheme(), "inner scheme");
    }
}

