/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.scheme;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.config.builder.NamedEventInterceptorBuilder;
import com.tangosol.coherence.config.builder.ServiceBuilder;
import com.tangosol.coherence.config.scheme.AbstractScheme;
import com.tangosol.coherence.config.scheme.ServiceScheme;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.Cluster;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.ClassHelper;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;

public abstract class AbstractServiceScheme<D extends ServiceDependencies>
extends AbstractScheme
implements ServiceBuilder,
ServiceScheme {
    private boolean m_fAutoStart;
    private XmlElement m_element;
    private String m_sScopeName;
    private WeakReference<Service> m_refService;
    private String m_sServiceName;
    protected D m_serviceDependencies;

    @Override
    public Service realizeService(ParameterResolver resolver, ClassLoader loader, Cluster cluster) {
        this.validate();
        String sService = this.getScopedServiceName();
        Service service = this.ensureService(sService, cluster);
        if (!service.isRunning()) {
            ConfigurableCacheFactory ccf;
            Service servicePrev;
            Service service2 = servicePrev = this.m_refService == null ? null : (Service)this.m_refService.get();
            if (servicePrev != null && servicePrev.isRunning()) {
                String sServicePrev = servicePrev.getInfo().getServiceName();
                Logger.err("This scheme is used to create an instance of service \"" + sService + "\", while another service \"" + sServicePrev + "\" created by the same scheme is already running. This could lead to extremely dangerous side effects.");
            } else {
                this.m_refService = new WeakReference<Service>(service);
            }
            Parameter parameter = resolver.resolve("{cache-factory}");
            if (parameter != null && (ccf = parameter.evaluate(resolver).as(ConfigurableCacheFactory.class)) != null) {
                service.getResourceRegistry().registerResource(ConfigurableCacheFactory.class, "ConfigurableCacheFactory", ccf);
            }
            service.setDependencies((ServiceDependencies)this.getServiceDependencies());
        }
        return service;
    }

    @Override
    public abstract boolean isRunningClusterNeeded();

    @Override
    public String getScopeName() {
        return this.m_sScopeName;
    }

    @Injectable
    public void setScopeName(String sName) {
        this.m_sScopeName = sName;
    }

    @Override
    @Deprecated
    public void setXml(XmlElement element) {
        this.m_element = element;
    }

    @Override
    @Deprecated
    public XmlElement getXml() {
        return this.m_element;
    }

    @Override
    public boolean isAutoStart() {
        return this.m_fAutoStart;
    }

    @Injectable(value="autostart")
    public void setAutoStart(boolean fEnabled) {
        this.m_fAutoStart = fEnabled;
    }

    @Override
    public ServiceBuilder getServiceBuilder() {
        return this;
    }

    @Injectable
    public void setServiceName(String sName) {
        this.m_sServiceName = sName;
    }

    @Override
    public String getServiceName() {
        String sName = this.m_sServiceName;
        if (sName == null || sName.trim().isEmpty()) {
            this.m_sServiceName = sName = this.getDefaultServiceName();
        }
        return sName;
    }

    @Override
    public String getScopedServiceName() {
        String sServiceName = this.getServiceName();
        String sScopeName = this.getScopeName();
        return ServiceScheme.getScopedServiceName(sScopeName, sServiceName);
    }

    @Override
    public List<NamedEventInterceptorBuilder> getEventInterceptorBuilders() {
        return Collections.EMPTY_LIST;
    }

    protected void injectScopeNameIntoService(Service service) {
        String sScopeName = this.getScopeName();
        if (sScopeName != null && sScopeName.length() > 0) {
            try {
                Service innerService = (Service)ClassHelper.invoke(service, "getService", null);
                if (innerService == null) {
                    Logger.err("Unable to pass scope name \"" + sScopeName + "\" to service \"" + String.valueOf(service) + "\". The service wrapped by the safe service is null");
                    return;
                }
                ClassHelper.invoke(innerService, "setScopeName", new Object[]{sScopeName});
            }
            catch (ReflectiveOperationException e) {
                Logger.err("Unable to pass scope name \"" + sScopeName + "\" to service \"" + String.valueOf(service) + "\": " + String.valueOf(e));
            }
        }
    }

    @Injectable(value=".")
    public D getServiceDependencies() {
        return this.m_serviceDependencies;
    }

    public void setServiceDependencies(D dependencies) {
        this.m_serviceDependencies = dependencies;
    }

    protected String getDefaultServiceName() {
        return this.getServiceType();
    }

    protected Service ensureService(String sService, Cluster cluster) {
        return cluster.ensureService(sService, this.getServiceType());
    }
}

