/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.builder;

import com.oracle.coherence.common.net.SSLSettings;
import com.oracle.coherence.common.net.SSLSocketProvider;
import com.oracle.coherence.common.net.SocketProvider;
import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.DatagramSocketProvider;
import com.tangosol.net.SocketProviderFactory;

public class SocketProviderBuilder
implements ParameterizedBuilder<SocketProvider> {
    public static String UNNAMED_PROVIDER_ID = "";
    private final String f_sId;
    private final SocketProviderFactory.Dependencies f_deps;
    private final SocketProvider f_provider;
    private final boolean f_fUseGlobal;

    public SocketProviderBuilder(String sId, SocketProviderFactory.Dependencies deps, boolean fCanUseGlobal) {
        this.f_sId = sId;
        this.f_deps = deps;
        this.f_provider = null;
        this.f_fUseGlobal = fCanUseGlobal;
    }

    public SocketProviderBuilder(SocketProvider provider, boolean fCanUseGlobal) {
        this.f_sId = null;
        this.f_deps = null;
        this.f_provider = provider;
        this.f_fUseGlobal = fCanUseGlobal;
    }

    public SocketProviderFactory.Dependencies getDependencies() {
        return this.f_deps;
    }

    public String getId() {
        return this.f_sId;
    }

    public SocketProvider getDemultiplexedSocketProvider(int nSubport) {
        if (this.f_deps == null) {
            throw new NullPointerException("The SocketProviderFactory dependencies field is null");
        }
        return this.f_deps.getSocketProviderFactory().getDemultiplexedSocketProvider(this.f_sId, this.f_deps, nSubport, this.f_fUseGlobal);
    }

    public DatagramSocketProvider getDatagramSocketProvider(int nSubport) {
        if (this.f_deps == null) {
            throw new NullPointerException("The SocketProviderFactory dependencies field is null");
        }
        return this.f_deps.getSocketProviderFactory().getDatagramSocketProvider(this.f_sId, this.f_deps, nSubport, this.f_fUseGlobal);
    }

    public SSLSettings getSSLSettings() {
        SocketProviderBuilder builder;
        if (this.canUseGlobal() && (builder = SocketProviderFactory.getGlobalSocketProviderBuilder()) != null) {
            return builder.getSSLSettings();
        }
        if (this.f_deps == null) {
            throw new NullPointerException("The SocketProviderFactory dependencies field is null");
        }
        SSLSocketProvider.Dependencies depsSSL = this.f_deps.getSSLDependencies(this.f_sId);
        return depsSSL == null ? null : SocketProviderFactory.createSSLSettings(depsSSL);
    }

    public boolean canUseGlobal() {
        return this.f_fUseGlobal;
    }

    @Override
    public SocketProvider realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
        SocketProviderBuilder builder;
        if (this.f_fUseGlobal && (builder = SocketProviderFactory.getGlobalSocketProviderBuilder()) != null) {
            return builder.realize(resolver, loader, listParameters);
        }
        if (this.f_provider != null) {
            return this.f_provider;
        }
        if (this.f_deps == null) {
            throw new NullPointerException("The SocketProviderFactory dependencies field is null");
        }
        return this.f_deps.getSocketProviderFactory().getSocketProvider(this.f_sId, this.f_deps, 0);
    }
}

