/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.builder;

import com.oracle.coherence.common.base.Disposable;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilderRegistry;
import com.tangosol.net.security.LocalPermission;
import com.tangosol.util.Base;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SimpleParameterizedBuilderRegistry
implements ParameterizedBuilderRegistry {
    private final ConcurrentHashMap<RegistryKey, RegistryValue> f_mapBuilders = new ConcurrentHashMap();

    public SimpleParameterizedBuilderRegistry() {
    }

    public SimpleParameterizedBuilderRegistry(ParameterizedBuilderRegistry registry) {
        this();
        for (ParameterizedBuilderRegistry.Registration reg : registry) {
            this.registerBuilder(reg.getInstanceClass(), reg.getName(), reg.getBuilder());
        }
    }

    public boolean isEmpty() {
        return this.f_mapBuilders.isEmpty();
    }

    @Override
    public synchronized void dispose() {
        ConcurrentHashMap<RegistryKey, RegistryValue> mapResource = this.f_mapBuilders;
        for (Map.Entry entry : mapResource.entrySet()) {
            RegistryValue value = (RegistryValue)entry.getValue();
            try {
                value.dispose();
            }
            catch (RuntimeException e) {
                Base.log("Exception while disposing the " + ((RegistryKey)entry.getKey()).getName() + " builder: " + String.valueOf(e));
                Base.log(e);
            }
        }
        mapResource.clear();
    }

    @Override
    public <T> ParameterizedBuilder<T> getBuilder(Class<T> clzInstance) {
        RegistryValue value = this.f_mapBuilders.get(new RegistryKey(clzInstance));
        return value == null ? null : value.getBuilder();
    }

    @Override
    public <T> ParameterizedBuilder<T> getBuilder(Class<T> clzInstance, String sBuilderName) {
        RegistryValue value = this.f_mapBuilders.get(new RegistryKey(clzInstance, sBuilderName));
        return value == null ? null : value.getBuilder();
    }

    @Override
    public <T> String registerBuilder(Class<T> clzInstance, ParameterizedBuilder<? extends T> builder) throws IllegalArgumentException {
        return this.registerBuilder(clzInstance, "default", builder);
    }

    @Override
    public <T> String registerBuilder(Class<T> clzInstance, String sBuilderName, ParameterizedBuilder<? extends T> builder) throws IllegalArgumentException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new LocalPermission("Service.registerResource"));
        }
        Class<T> clazz = clzInstance;
        synchronized (clazz) {
            RegistryKey key = new RegistryKey(clzInstance, sBuilderName);
            RegistryValue value = this.f_mapBuilders.get(key);
            if (value == null) {
                value = new RegistryValue(builder);
                this.f_mapBuilders.put(key, value);
                return sBuilderName;
            }
            throw new IllegalArgumentException(String.format("Can not register builder [%s] as [%s] of type [%s] is it already registered [%s]", builder, sBuilderName, key.getInstanceClass(), value.getBuilder()));
        }
    }

    @Override
    public Iterator<ParameterizedBuilderRegistry.Registration> iterator() {
        ArrayList<BuilderRegistration> listRegistrations = new ArrayList<BuilderRegistration>(this.f_mapBuilders.size());
        for (Map.Entry<RegistryKey, RegistryValue> entry : this.f_mapBuilders.entrySet()) {
            RegistryKey key = entry.getKey();
            RegistryValue value = entry.getValue();
            BuilderRegistration registration = new BuilderRegistration(key.getName(), key.getInstanceClass(), value.getBuilder());
            listRegistrations.add(registration);
        }
        return listRegistrations.iterator();
    }

    protected class RegistryValue
    implements Disposable {
        private ParameterizedBuilder<?> m_builder;

        public RegistryValue(ParameterizedBuilder<?> builder) {
            if (builder == null) {
                throw new NullPointerException("Resource cannot be null");
            }
            this.m_builder = builder;
        }

        public ParameterizedBuilder<?> getBuilder() {
            return this.m_builder;
        }

        @Override
        public void dispose() {
            ParameterizedBuilder<?> builder = this.m_builder;
            if (builder instanceof Disposable) {
                ((Disposable)((Object)builder)).dispose();
            }
        }
    }

    protected class RegistryKey {
        private Class m_clz;
        private String m_sName;

        public RegistryKey(Class clz) {
            this(clz, clz.getName());
        }

        public RegistryKey(Class clz, String sName) {
            if (clz == null) {
                throw new NullPointerException("ParameterizedBuilder class cannot be null");
            }
            if (sName == null) {
                throw new NullPointerException("ParameterizedBuilder name cannot be null");
            }
            this.m_clz = clz;
            this.m_sName = sName;
        }

        public Class getInstanceClass() {
            return this.m_clz;
        }

        public String getName() {
            return this.m_sName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !Base.equals(this.getClass(), o.getClass())) {
                return false;
            }
            RegistryKey that = (RegistryKey)o;
            return Base.equals(this.m_clz, that.m_clz) && Base.equals(this.m_sName, that.m_sName);
        }

        public int hashCode() {
            int result = this.m_clz.hashCode();
            result = 31 * result + this.m_sName.hashCode();
            return result;
        }
    }

    protected class BuilderRegistration
    implements ParameterizedBuilderRegistry.Registration {
        private String m_sBuilderName;
        private Class<?> m_clzInstance;
        private ParameterizedBuilder<?> m_bldr;

        public BuilderRegistration(String sBuilderName, Class<?> clzInstance, ParameterizedBuilder<?> bldr) {
            this.m_sBuilderName = sBuilderName;
            this.m_clzInstance = clzInstance;
            this.m_bldr = bldr;
        }

        @Override
        public String getName() {
            return this.m_sBuilderName;
        }

        public Class<?> getInstanceClass() {
            return this.m_clzInstance;
        }

        public ParameterizedBuilder<?> getBuilder() {
            return this.m_bldr;
        }
    }
}

