/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.builder;

import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.internal.net.cluster.DefaultServiceFailurePolicy;
import com.tangosol.net.ServiceFailurePolicy;
import com.tangosol.run.xml.XmlElement;

public class ServiceFailurePolicyBuilder
implements ParameterizedBuilder<ServiceFailurePolicy> {
    private final String m_sPolicyDefault;
    private final ParameterizedBuilder<ServiceFailurePolicy> m_builder;
    private final XmlElement m_xmlConfig;

    public ServiceFailurePolicyBuilder(int nPolicy) {
        this.m_xmlConfig = null;
        this.m_builder = null;
        this.m_sPolicyDefault = switch (nPolicy) {
            case 1 -> "exit-cluster";
            case 2 -> "exit-process";
            case 3 -> "logging";
            default -> "unknown default ServiceFailurePolicy number " + nPolicy;
        };
    }

    public ServiceFailurePolicyBuilder(ParameterizedBuilder<ServiceFailurePolicy> builder, XmlElement xmlConfig) {
        this.m_builder = builder;
        this.m_sPolicyDefault = null;
        this.m_xmlConfig = xmlConfig;
    }

    public ServiceFailurePolicyBuilder(String sPolicy, XmlElement xmlConfig) {
        this.m_builder = null;
        this.m_sPolicyDefault = sPolicy;
        this.m_xmlConfig = xmlConfig;
    }

    @Override
    public ServiceFailurePolicy realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
        if (this.m_builder == null) {
            return new DefaultServiceFailurePolicy(switch (this.m_sPolicyDefault) {
                case "exit-cluster" -> 1;
                case "exit-process" -> 2;
                case "logging" -> 3;
                default -> {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Unknown default service failure policy: :").append(this.m_sPolicyDefault);
                    if (this.m_xmlConfig != null) {
                        sb.append(" in [").append(this.m_xmlConfig).append("].");
                    }
                    throw new ConfigurationException(sb.toString(), "Please specify a default ServiceFailurePolicy value of exit-cluster, exit-process or logging");
                }
            });
        }
        try {
            return this.m_builder.realize(resolver, loader, listParameters);
        }
        catch (ClassCastException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Invalid customized ServiceFailurePolicy class ").append(this.m_builder.getClass().getCanonicalName());
            if (this.m_xmlConfig != null) {
                sb.append(" in [").append(this.m_xmlConfig).append("]");
            }
            throw new ConfigurationException(sb.toString(), "Provide a customized class that implements ServiceFailurePolicy ", e);
        }
    }
}

