/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.builder;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.internal.net.ssl.SSLCertUtility;
import com.oracle.coherence.common.net.SSLSocketProvider;
import com.oracle.coherence.common.util.Duration;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.coherence.config.unit.Seconds;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.internal.net.ssl.DefaultManagerDependencies;
import com.tangosol.internal.net.ssl.ManagerDependencies;
import com.tangosol.internal.net.ssl.SSLContextDependencies;
import com.tangosol.internal.net.ssl.SSLContextProvider;
import com.tangosol.internal.net.ssl.SSLSocketProviderDefaultDependencies;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.net.security.SecurityProvider;
import com.tangosol.net.ssl.RefreshPolicy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;

public class SSLSocketProviderDependenciesBuilder
implements ParameterizedBuilder<SSLSocketProviderDefaultDependencies> {
    public static final String NAME = "CoherenceSSLContextProvider";
    public static final String SERVICE_TYPE = "SSLContext";
    public static final String ACTION_ALLOW = "allow";
    private static final boolean VERIFY_CN_AFTER_SAN = Config.getBoolean("coherence.security.ssl.verifyCNAfterSAN", true);
    private static final boolean ALLOW_LOCALHOST = Config.getBoolean("coherence.security.ssl.allowLocalhost", false);
    private static final String LOCALHOST_HOSTNAME = "localhost";
    private static final String LOCALHOST_IPADDRESS = "127.0.0.1";
    private static final String WILDCARD_DNSNAME_REGEX = "^\\*((\\.[^*.]+){2,})$";
    private static final Pattern WILDCARD_DNSNAME_PATTERN = Pattern.compile("^\\*((\\.[^*.]+){2,})$");
    private static final String URL_HOSTNAME_REGEX = "^[^*.\\s]+((\\.[^*.]+){2,})$";
    private static final Pattern URL_HOSTNAME_PATTERN = Pattern.compile("^[^*.\\s]+((\\.[^*.]+){2,})$");
    public static final Seconds NO_REFRESH = new Seconds(0);
    private SocketProviderBuilder m_bldrDelegateSocketProvider;
    private ParameterizedBuilder<Executor> m_bldrExecutor;
    private ParameterizedBuilder<HostnameVerifier> m_bldrHostnameVerifier;
    private ProviderBuilder m_bldrProvider;
    private final SSLSocketProviderDefaultDependencies m_deps;
    private NameListDependencies m_depsCipherSuite;
    private ManagerDependencies m_depsIdentityManager;
    private NameListDependencies m_depsProtocolVersion;
    private ManagerDependencies m_depsTrustManager;
    private boolean m_fRealized;
    private String m_sNameProtocol;
    private SSLSocketProvider.ClientAuthMode m_clientAuthMode;
    private Seconds m_refreshPeriod = NO_REFRESH;
    private RefreshPolicy m_refreshPolicy = RefreshPolicy.Always;

    public SSLSocketProviderDependenciesBuilder(SSLSocketProviderDefaultDependencies deps) {
        this.m_deps = deps;
        this.m_bldrDelegateSocketProvider = new SocketProviderBuilder(SocketProviderFactory.DEFAULT_SOCKET_PROVIDER, false);
        this.m_sNameProtocol = "TLS";
    }

    @Injectable(value="protocol")
    public void setProtocol(String sName) {
        this.m_sNameProtocol = sName;
    }

    public String getProtocol() {
        return this.m_sNameProtocol;
    }

    @Injectable(value="provider")
    public void setProviderBuilder(ProviderBuilder builder) {
        this.m_bldrProvider = builder;
    }

    public ProviderBuilder getProviderBuilder() {
        return this.m_bldrProvider;
    }

    protected Provider realizeProvider() {
        return this.m_bldrProvider == null ? null : this.m_bldrProvider.realize(null, null, null);
    }

    protected String getProviderName() {
        return this.m_bldrProvider == null ? null : this.m_bldrProvider.getName();
    }

    @Injectable(value="executor")
    public void setExecutor(ParameterizedBuilder<Executor> bldr) {
        this.m_bldrExecutor = bldr;
    }

    @Injectable(value="identity-manager")
    public void setIdentityManager(DefaultManagerDependencies deps) {
        this.m_depsIdentityManager = deps;
    }

    public ManagerDependencies getIdentityManager() {
        return this.m_depsIdentityManager;
    }

    public ManagerDependencies getTrustManager() {
        return this.m_depsTrustManager;
    }

    @Injectable(value="trust-manager")
    public void setTrustManager(ManagerDependencies deps) {
        this.m_depsTrustManager = deps;
    }

    @Injectable(value="hostname-verifier")
    public void setHostnameVerifierBuilder(ParameterizedBuilder<HostnameVerifier> bldr) {
        this.m_bldrHostnameVerifier = bldr;
    }

    public ParameterizedBuilder<HostnameVerifier> getHostnameVerifierBuilder() {
        return this.m_bldrHostnameVerifier;
    }

    @Injectable(value="cipher-suites")
    public void setCipherSuitesNameList(NameListDependencies deps) {
        this.m_depsCipherSuite = deps;
    }

    @Injectable(value="protocol-versions")
    public void setProtocolVersionsNameList(NameListDependencies deps) {
        this.m_depsProtocolVersion = deps;
    }

    @Injectable(value="socket-provider")
    public void setDelegate(SocketProviderBuilder bldr) {
        this.m_bldrDelegateSocketProvider = bldr;
    }

    @Injectable(value="client-auth")
    public void setClientAuth(String sAuthMode) {
        if (sAuthMode == null || sAuthMode.isEmpty()) {
            this.m_clientAuthMode = SSLSocketProvider.ClientAuthMode.none;
        } else {
            try {
                this.m_clientAuthMode = SSLSocketProvider.ClientAuthMode.valueOf(sAuthMode);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid client auth configuration", e);
            }
        }
    }

    @Injectable(value="refresh-period")
    public void setRefreshPeriod(Seconds refreshPeriod) {
        this.m_refreshPeriod = refreshPeriod == null ? NO_REFRESH : refreshPeriod;
    }

    public Seconds getRefreshPeriod() {
        return this.m_refreshPeriod;
    }

    @Injectable(value="refresh-policy")
    public void setRefreshPolicy(RefreshPolicy policy) {
        this.m_refreshPolicy = policy == null ? RefreshPolicy.Always : policy;
    }

    public RefreshPolicy getRefreshPolicy() {
        return this.m_refreshPolicy;
    }

    public SocketProviderBuilder getSocketProviderBuilder() {
        return this.m_bldrDelegateSocketProvider;
    }

    public synchronized SSLSocketProviderDefaultDependencies realize() {
        if (this.m_fRealized) {
            return this.m_deps;
        }
        SSLSocketProviderDefaultDependencies deps = this.m_deps;
        try {
            KeyManager[] aKeyManager = null;
            TrustManager[] aTrustManager = null;
            String sProtocol = this.getProtocol();
            ManagerDependencies depsIdMgr = this.getIdentityManager();
            ManagerDependencies depsTrustMgr = this.getTrustManager();
            Provider provider = this.realizeProvider();
            String sProviderName = this.getProviderName();
            RefreshPolicy refreshPolicy = deps.getRefreshPolicy();
            if (depsIdMgr != null) {
                depsIdMgr.addListener(refreshPolicy);
            }
            if (depsTrustMgr != null) {
                depsTrustMgr.addListener(refreshPolicy);
            }
            if (provider instanceof DependenciesAware) {
                ((DependenciesAware)((Object)provider)).setDependencies(deps, depsIdMgr, depsTrustMgr);
            }
            if (this.m_bldrExecutor == null) {
                deps.setExecutor(SSLSocketProviderDefaultDependencies.DEFAULT_EXECUTOR);
            } else {
                deps.setExecutor(this.m_bldrExecutor.realize(new NullParameterResolver(), null, null));
            }
            deps.setRefreshPeriod(this.m_refreshPeriod);
            deps.setRefreshPolicy(this.m_refreshPolicy);
            deps.setClientAuth(this.m_clientAuthMode);
            ParameterizedBuilder<HostnameVerifier> bldrHostnameVerifier = this.getHostnameVerifierBuilder();
            if (bldrHostnameVerifier != null) {
                deps.setHostnameVerifier(bldrHostnameVerifier.realize(null, null, null));
            }
            SecureRandom random = new SecureRandom();
            random.nextInt();
            SSLContextDependencies sslContextDependencies = new SSLContextDependencies(null);
            sslContextDependencies.setProvider(provider, sProviderName);
            sslContextDependencies.setDependencies(deps, depsIdMgr, depsTrustMgr);
            sslContextDependencies.setClientAuth(deps.getClientAuth());
            sslContextDependencies.setRefreshPeriodInMillis(this.m_refreshPeriod.as(Duration.Magnitude.MILLI));
            sslContextDependencies.setSecureRandom(random);
            deps.setSSLContextDependencies(sslContextDependencies);
            SSLContext ctx = SSLContext.getInstance(sProtocol, new SSLContextProvider(sProtocol, deps));
            deps.setSSLContext(ctx);
            ctx.init(aKeyManager, aTrustManager, random);
            SSLEngine engine = ctx.createSSLEngine();
            if (this.m_depsCipherSuite != null) {
                List<String> listCipher = this.m_depsCipherSuite.getNameList();
                if (this.m_depsCipherSuite.isBlackList()) {
                    ArrayList<String> listDefaultCipher = new ArrayList<String>(Arrays.asList(engine.getEnabledCipherSuites()));
                    listDefaultCipher.removeAll(listCipher);
                    listCipher = listDefaultCipher;
                }
                deps.setEnabledCipherSuites(listCipher.toArray(new String[0]));
            }
            if (this.m_depsProtocolVersion != null) {
                List<String> listProtocol = this.m_depsProtocolVersion.getNameList();
                if (this.m_depsProtocolVersion.isBlackList()) {
                    ArrayList<String> listDefaultProtocols = new ArrayList<String>(Arrays.asList(engine.getEnabledProtocols()));
                    listDefaultProtocols.removeAll(listProtocol);
                    listProtocol = listDefaultProtocols;
                }
                deps.setEnabledProtocolVersions(listProtocol.toArray(new String[0]));
            }
            deps.setDelegateSocketProviderBuilder(this.m_bldrDelegateSocketProvider);
            this.m_fRealized = true;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Invalid configuration ", e);
        }
        return deps;
    }

    @Override
    public SSLSocketProviderDefaultDependencies realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
        return this.realize();
    }

    public static class ProviderBuilder
    implements ParameterizedBuilder<Provider> {
        private String m_sName;
        private ParameterizedBuilder<Provider> m_builder;
        private static boolean m_fRegisteredCoherenceSecurityProvider = false;

        @Injectable(value="name")
        public void setName(String sName) {
            this.m_sName = sName;
            if (!m_fRegisteredCoherenceSecurityProvider && "CoherenceSecurityProvider".equals(sName)) {
                SecurityProvider.ensureRegistration();
            }
        }

        public String getName() {
            return this.m_sName;
        }

        @Injectable(value="provider")
        public void setBuilder(ParameterizedBuilder<Provider> builder) {
            this.m_builder = builder;
        }

        @Override
        public Provider realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
            return this.m_builder == null ? null : this.m_builder.realize(resolver, loader, listParameters);
        }
    }

    public static class NameListDependencies {
        final String f_sDescription;
        public static final USAGE USAGE_DEFAULT = USAGE.WHITE_LIST;
        private final List<String> m_lstNames = new LinkedList<String>();
        private USAGE m_usage = USAGE_DEFAULT;

        public NameListDependencies(String sDescription) {
            this.f_sDescription = sDescription;
        }

        public void add(String sName) {
            this.m_lstNames.add(sName);
        }

        public List<String> getNameList() {
            return this.m_lstNames;
        }

        public void setUsage(String v) {
            this.m_usage = USAGE.myValueOf(v);
        }

        public boolean isBlackList() {
            return this.m_usage == USAGE.BLACK_LIST;
        }

        public static enum USAGE {
            WHITE_LIST("white-list"),
            BLACK_LIST("black-list");

            private final String f_value;

            private USAGE(String s) {
                this.f_value = s;
            }

            public String toString() {
                return this.f_value;
            }

            public static USAGE myValueOf(String v) {
                if ("white-list".equals(v)) {
                    return WHITE_LIST;
                }
                if ("black-list".equals(v)) {
                    return BLACK_LIST;
                }
                throw new IllegalArgumentException("unknown usage value of " + v + "; expected either \"white-list\" or \"black-list\"");
            }

            public boolean equalsName(String otherName) {
                return this.f_value.equals(otherName);
            }
        }
    }

    public static interface DependenciesAware {
        public void setDependencies(SSLSocketProvider.Dependencies var1, ManagerDependencies var2, ManagerDependencies var3);
    }

    static class DefaultHostnameVerifier
    implements HostnameVerifier {
        DefaultHostnameVerifier() {
        }

        @Override
        public boolean verify(String sUrlHostname, SSLSession sslSession) {
            boolean fMatched = false;
            if (sUrlHostname != null && !sUrlHostname.isEmpty() && sslSession != null) {
                Collection<String> colWildcardDNSNames = SSLCertUtility.getDNSSubjAltNames(sslSession, true, false);
                String sCertHostname = SSLCertUtility.getCommonName(sslSession);
                fMatched = colWildcardDNSNames != null && !colWildcardDNSNames.isEmpty() ? (VERIFY_CN_AFTER_SAN ? DefaultHostnameVerifier.verifySANWildcardDNSNames(sUrlHostname, colWildcardDNSNames) || DefaultHostnameVerifier.isLegalWildcarded(sUrlHostname, sCertHostname) : DefaultHostnameVerifier.verifySANWildcardDNSNames(sUrlHostname, colWildcardDNSNames)) : DefaultHostnameVerifier.isLegalWildcarded(sUrlHostname, sCertHostname);
                if (!fMatched) {
                    Collection<String> colSubAltNames = SSLCertUtility.getDNSSubjAltNames(sslSession, false, true);
                    fMatched = colSubAltNames != null && !colSubAltNames.isEmpty() ? (VERIFY_CN_AFTER_SAN ? this.doDNSSubjAltNamesVerify(sUrlHostname, colSubAltNames) || this.doVerify(sUrlHostname, sCertHostname) : this.doDNSSubjAltNamesVerify(sUrlHostname, colSubAltNames)) : this.doVerify(sUrlHostname, sCertHostname);
                }
            }
            if (!fMatched) {
                Logger.err("DefaultHostnameVerifier rejecting hostname " + sUrlHostname);
            }
            return fMatched;
        }

        private boolean doVerify(String sUrlHostname, String sCertHostname) {
            int domainIndex;
            if (sCertHostname == null || sCertHostname.length() == 0) {
                return false;
            }
            if (sUrlHostname.equalsIgnoreCase(sCertHostname)) {
                return true;
            }
            if (sCertHostname.indexOf(".") < 0 && sUrlHostname.indexOf(".") > 0 && (domainIndex = sUrlHostname.indexOf(".")) == sCertHostname.length() && sCertHostname.compareToIgnoreCase(sUrlHostname.substring(0, domainIndex)) == 0) {
                return true;
            }
            if (!ALLOW_LOCALHOST) {
                return false;
            }
            try {
                InetAddress addrLocalhost = InetAddressHelper.getLocalHost();
                String sHostname = addrLocalhost.getHostName();
                if (sHostname.equalsIgnoreCase(sCertHostname)) {
                    if (addrLocalhost.getHostAddress().equalsIgnoreCase(sUrlHostname)) {
                        return true;
                    }
                    if (SSLSocketProviderDependenciesBuilder.LOCALHOST_HOSTNAME.equalsIgnoreCase(sUrlHostname) || SSLSocketProviderDependenciesBuilder.LOCALHOST_IPADDRESS.equalsIgnoreCase(sUrlHostname)) {
                        return true;
                    }
                }
            }
            catch (UnknownHostException e) {
                Logger.err("HostnameVerifier: " + e.getMessage());
            }
            return false;
        }

        private boolean doDNSSubjAltNamesVerify(String sUrlhostname, Collection<String> colDnsAltNames) {
            if (colDnsAltNames != null && !colDnsAltNames.isEmpty()) {
                for (String dnsName : colDnsAltNames) {
                    if (!dnsName.equalsIgnoreCase(sUrlhostname)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isLegalWildcarded(String sURL, String sCommonName) {
            if (sCommonName != null) {
                if (!sCommonName.contains("*")) {
                    return false;
                }
                if (sCommonName.indexOf(".") != sCommonName.lastIndexOf(".") && sCommonName.startsWith("*.") && sCommonName.indexOf("*") == sCommonName.lastIndexOf("*") && DefaultHostnameVerifier.domainMatchesDomain(sURL, sCommonName)) {
                    return true;
                }
            }
            return false;
        }

        private static boolean domainMatchesDomain(String sUrl, String sCommonName) {
            int nIndex = sCommonName.indexOf("*");
            if (nIndex == -1) {
                return false;
            }
            String sStrippedCN = sCommonName.substring(nIndex + 1).toLowerCase();
            String sUrlLower = sUrl.toLowerCase();
            if (!sUrlLower.endsWith(sStrippedCN)) {
                return false;
            }
            if (sUrlLower.lastIndexOf(sStrippedCN) == -1) {
                return false;
            }
            String sUrlBeginning = sUrlLower.substring(0, sUrlLower.length() - sStrippedCN.length());
            if (sUrlBeginning.length() <= 0) {
                return false;
            }
            return !sUrlBeginning.contains(".");
        }

        private static boolean verifySANWildcardDNSNames(String sUrlHostname, Collection<String> colWildcardDNSNames) {
            boolean fMatched = false;
            if (colWildcardDNSNames != null && !colWildcardDNSNames.isEmpty()) {
                Matcher urlHostnameMatcher = URL_HOSTNAME_PATTERN.matcher(sUrlHostname);
                boolean fURLHostnameValid = urlHostnameMatcher.matches();
                for (String sDnsName : colWildcardDNSNames) {
                    Matcher wildCardDNSNameMatcher = WILDCARD_DNSNAME_PATTERN.matcher(sDnsName);
                    if (!wildCardDNSNameMatcher.matches()) continue;
                    String sDomainOfWildcardDNS = wildCardDNSNameMatcher.group(1);
                    if (!fURLHostnameValid) continue;
                    String sDomainOfURL = urlHostnameMatcher.group(1);
                    if (sDomainOfWildcardDNS == null || !sDomainOfWildcardDNS.equalsIgnoreCase(sDomainOfURL)) continue;
                    fMatched = true;
                    break;
                }
            }
            return fMatched;
        }
    }

    public static class HostnameVerifierBuilder
    implements ParameterizedBuilder<HostnameVerifier> {
        private String m_sAction;
        private ParameterizedBuilder<HostnameVerifier> m_builder;

        @Injectable(value="action")
        public void setAction(String sAction) {
            this.m_sAction = sAction;
        }

        public String getAction() {
            return this.m_sAction;
        }

        @Injectable(value="instance")
        public void setBuilder(ParameterizedBuilder<HostnameVerifier> builder) {
            this.m_builder = builder;
        }

        @Override
        public HostnameVerifier realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
            if (this.m_builder != null) {
                return this.m_builder.realize(resolver, loader, listParameters);
            }
            if (SSLSocketProviderDependenciesBuilder.ACTION_ALLOW.equals(this.m_sAction)) {
                return (s, sslSession) -> true;
            }
            return new DefaultHostnameVerifier();
        }
    }
}

