/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.builder;

import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.builder.DefaultBuilderCustomization;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.Member;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.ServiceInfo;
import com.tangosol.net.partition.Ownership;
import com.tangosol.util.Base;
import java.util.function.BiFunction;

public class ReadLocatorBuilder
extends DefaultBuilderCustomization<BiFunction<Ownership, PartitionedService, Member>>
implements ParameterizedBuilder<BiFunction<Ownership, PartitionedService, Member>> {
    public static final BiFunction<Ownership, PartitionedService, Member> PRIMARY = (owners, service) -> service.getInfo().getServiceMember(owners.getPrimaryOwner());
    public static final BiFunction<Ownership, PartitionedService, Member> RANDOM = (owners, service) -> {
        int cBackups = owners.getBackupCount();
        if (cBackups < 1) {
            return PRIMARY.apply((Ownership)owners, (PartitionedService)service);
        }
        int iStore = Base.getRandom().nextInt(cBackups + 1);
        return service.getInfo().getServiceMember(owners.getOwner(iStore));
    };
    public static final BiFunction<Ownership, PartitionedService, Member> RANDOM_BACKUP = (owners, service) -> {
        int cBackups = owners.getBackupCount();
        if (cBackups < 1) {
            return PRIMARY.apply((Ownership)owners, (PartitionedService)service);
        }
        int iStore = Base.getRandom().nextInt(cBackups) + 1;
        return service.getInfo().getServiceMember(owners.getOwner(iStore));
    };
    public static final BiFunction<Ownership, PartitionedService, Member> CLOSEST = (owners, service) -> {
        int cBackups = owners.getBackupCount();
        if (cBackups < 1) {
            return PRIMARY.apply((Ownership)owners, (PartitionedService)service);
        }
        ServiceInfo info = service.getInfo();
        Member memberThis = service.getCluster().getLocalMember();
        Member memberClosest = null;
        for (int i = 0; i <= cBackups; ++i) {
            Member member = info.getServiceMember(owners.getOwner(i));
            if (member == null) continue;
            if (memberClosest == null) {
                memberClosest = member;
            }
            if (memberThis.equals(member)) {
                return member;
            }
            if (memberThis.getMachineId() == member.getMachineId()) {
                return member;
            }
            if (Base.equals(memberThis.getRackName(), member.getRackName()) && !Base.equals(memberClosest.getRackName(), memberThis.getRackName())) {
                memberClosest = member;
                continue;
            }
            if (!Base.equals(memberThis.getSiteName(), member.getSiteName()) || Base.equals(memberClosest.getSiteName(), memberThis.getSiteName())) continue;
            memberClosest = member;
        }
        return memberClosest;
    };
    private Expression<String> m_exprLocator = new LiteralExpression<String>("PRIMARY");

    public String getMemberLocatorType(ParameterResolver resolver) {
        return this.m_exprLocator.evaluate(resolver);
    }

    @Injectable
    public void setMemberLocatorType(Expression<String> expr) {
        this.m_exprLocator = expr;
    }

    @Override
    public BiFunction<Ownership, PartitionedService, Member> realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
        ParameterizedBuilder bldr = this.getCustomBuilder();
        if (bldr == null) {
            String sType;
            switch (sType = this.getMemberLocatorType(resolver).toUpperCase()) {
                case "PRIMARY": {
                    return null;
                }
                case "CLOSEST": {
                    return CLOSEST;
                }
                case "RANDOM": {
                    return RANDOM;
                }
                case "RANDOM-BACKUP": {
                    return RANDOM_BACKUP;
                }
            }
            throw new ConfigurationException("Unexpected read locator type: " + sType, "Choose one of the following read-locator types: primary, closest, random, or random-backup");
        }
        return (BiFunction)bldr.realize(resolver, loader, listParameters);
    }
}

