/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.builder;

import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.persistence.PersistenceEnvironment;
import com.oracle.coherence.persistence.PersistenceManager;
import com.oracle.coherence.persistence.PersistentStore;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.io.FileHelper;
import com.tangosol.io.ReadBuffer;
import com.tangosol.persistence.AbstractPersistenceEnvironment;
import com.tangosol.persistence.SafePersistenceWrappers;
import com.tangosol.persistence.bdb.BerkeleyDBEnvironment;
import com.tangosol.util.Base;
import java.io.File;

public class PersistenceEnvironmentParamBuilder
implements ParameterizedBuilder<PersistenceEnvironment> {
    protected static final SafePersistenceWrappers.FailureContinuationFactory DEFAULT_FACTORY = new SafePersistenceWrappers.FailureContinuationFactory(){

        public Continuation getEnvironmentContinuation(PersistenceEnvironment env) {
            return new AbstractPersistenceEnvironment.DefaultFailureContinuation(env);
        }

        public Continuation getManagerContinuation(PersistenceManager mgr) {
            return new AbstractPersistenceEnvironment.DefaultFailureContinuation(mgr);
        }

        public Continuation getStoreContinuation(PersistentStore store) {
            return new AbstractPersistenceEnvironment.DefaultFailureContinuation(store);
        }
    };
    protected String m_sMode;
    protected String m_sActive;
    protected String m_sBackup;
    protected String m_sEvents;
    protected String m_sSnapshot;
    protected String m_sTrash;
    protected ParameterizedBuilder<PersistenceEnvironment<ReadBuffer>> m_bldr;

    public PersistenceEnvironmentParamBuilder() {
        String sHome = PersistenceEnvironmentParamBuilder.getDefaultPersistenceEnvironmentHomeDirectory();
        this.m_sActive = sHome + File.separatorChar + "active";
        this.m_sBackup = sHome + File.separatorChar + "backup";
        this.m_sSnapshot = sHome + File.separatorChar + "snapshots";
        this.m_sTrash = sHome + File.separatorChar + "trash";
        this.m_sMode = "active";
    }

    @Override
    public PersistenceEnvironment<ReadBuffer> realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
        PersistenceEnvironment<ReadBuffer> environment;
        if (!(this.getPersistenceMode().equalsIgnoreCase("active") || this.getPersistenceMode().equalsIgnoreCase("active-backup") || this.getPersistenceMode().equalsIgnoreCase("active-async") || this.getPersistenceMode().equalsIgnoreCase("on-demand"))) {
            throw new ConfigurationException("Invalid persistence mode: '" + this.getPersistenceMode() + "'.", "Valid values are: 'active', 'active-backup', 'active-async' and 'on-demand'");
        }
        String sServiceName = PersistenceEnvironmentParamBuilder.getValueAsString(resolver, "service-name");
        String sClusterName = PersistenceEnvironmentParamBuilder.getValueAsString(resolver, "cluster-name");
        PersistenceEnvironmentInfo info = this.getPersistenceEnvironmentInfo(sClusterName, sServiceName);
        try {
            environment = this.m_bldr == null ? new BerkeleyDBEnvironment(info.getPersistenceActiveDirectory(), info.getPersistenceBackupDirectory(), info.getPersistenceEventsDirectory(), info.getPersistenceSnapshotDirectory(), info.getPersistenceTrashDirectory()) : this.m_bldr.realize(this.createResolver(sClusterName, sServiceName), loader, listParameters);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "Error creating PersistenceEnvironment: " + String.valueOf(this));
        }
        return this.wrap(environment);
    }

    public PersistenceEnvironmentInfo getPersistenceEnvironmentInfo(String sClusterName, String sServiceName) {
        if (sClusterName == null || (sClusterName = sClusterName.trim()).length() == 0) {
            throw new IllegalArgumentException("invalid cluster name");
        }
        String sCluster = FileHelper.toFilename(sClusterName);
        if (sServiceName == null || (sServiceName = sServiceName.trim()).length() == 0) {
            throw new IllegalArgumentException("invalid service name");
        }
        String sService = FileHelper.toFilename(sServiceName);
        File fileActive = this.isActive() ? new File(new File(new File(this.m_sActive), sCluster), sService) : null;
        File fileBackup = this.isActiveBackup() ? new File(new File(new File(this.m_sBackup), sCluster), sService) : null;
        File fileSnapshot = new File(new File(new File(this.m_sSnapshot), sCluster), sService);
        File fileTrash = new File(new File(new File(this.m_sTrash), sCluster), sService);
        File fileEvents = this.m_sEvents == null || this.m_sEvents.isEmpty() || !this.isActive() ? null : new File(new File(new File(this.m_sEvents), sCluster), sService);
        return new PersistenceEnvironmentInfo(this.m_sMode, fileActive, fileBackup, fileEvents, fileSnapshot, fileTrash);
    }

    public String getPersistenceMode() {
        return this.m_sMode;
    }

    @Injectable(value="persistence-mode")
    public void setPersistenceMode(String sMode) {
        if (sMode != null && sMode.length() > 0) {
            this.m_sMode = sMode;
        }
    }

    @Injectable(value="active-directory")
    public void setActiveDirectory(String sPathname) {
        if (sPathname != null && sPathname.length() > 0) {
            this.m_sActive = sPathname;
        }
    }

    @Injectable(value="backup-directory")
    public void setBackupDirectory(String sPathname) {
        if (sPathname != null && sPathname.length() > 0) {
            this.m_sBackup = sPathname;
        }
    }

    @Injectable(value="events-directory")
    public void setEventsDirectory(String sPathname) {
        if (sPathname != null && sPathname.length() > 0) {
            this.m_sEvents = sPathname;
        }
    }

    @Injectable(value="snapshot-directory")
    public void setPersistenceSnapshotDirectory(String sPathname) {
        if (sPathname != null && sPathname.length() > 0) {
            this.m_sSnapshot = sPathname;
        }
    }

    @Injectable(value="trash-directory")
    public void setPersistenceTrashDirectory(String sPathname) {
        if (sPathname != null && sPathname.length() > 0) {
            this.m_sTrash = sPathname;
        }
    }

    @Injectable(value="instance")
    public void setCustomEnvironment(ParameterizedBuilder<PersistenceEnvironment<ReadBuffer>> bldrPersistence) {
        this.m_bldr = bldrPersistence;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("\n        Mode: ").append(this.m_sMode).append("\n        Active Location: ").append(this.m_sActive).append("\n        Backup Location: ").append(this.m_sBackup).append("\n        Events Location: ").append(this.m_sEvents).append("\n        Snapshot Location:").append(this.m_sSnapshot).append("\n        Trash Location:").append(this.m_sTrash);
        if (this.m_bldr != null) {
            sb.append("\n         Instance: ").append(this.m_bldr);
        }
        return sb.toString();
    }

    protected PersistenceEnvironment<ReadBuffer> wrap(PersistenceEnvironment<ReadBuffer> env) {
        return new SafePersistenceWrappers.SafePersistenceEnvironment(env, DEFAULT_FACTORY);
    }

    protected ResolvableParameterList createResolver(String sClusterName, String sServiceName) {
        PersistenceEnvironmentInfo info = this.getPersistenceEnvironmentInfo(sClusterName, sServiceName);
        ResolvableParameterList resolver = new ResolvableParameterList();
        resolver.add(new Parameter("cluster-name", String.class, sClusterName));
        resolver.add(new Parameter("service-name", String.class, sServiceName));
        resolver.add(new Parameter("persistence-mode", String.class, info.getPersistenceMode()));
        resolver.add(new Parameter("active-directory", File.class, info.getPersistenceActiveDirectory()));
        resolver.add(new Parameter("backup-directory", File.class, info.getPersistenceBackupDirectory()));
        resolver.add(new Parameter("events-directory", File.class, info.getPersistenceEventsDirectory()));
        resolver.add(new Parameter("snapshot-directory", File.class, info.getPersistenceSnapshotDirectory()));
        resolver.add(new Parameter("trash-directory", File.class, info.getPersistenceTrashDirectory()));
        return resolver;
    }

    protected boolean isActive() {
        return this.m_sMode.equalsIgnoreCase("active") || this.m_sMode.equalsIgnoreCase("active-backup") || this.m_sMode.equalsIgnoreCase("active-async");
    }

    protected boolean isActiveBackup() {
        return this.m_sMode.equalsIgnoreCase("active-backup");
    }

    public static String getDefaultPersistenceEnvironmentHomeDirectory() {
        Object sHome = Config.getProperty("coherence.distributed.persistence.base.dir");
        if (sHome == null) {
            sHome = System.getProperty("user.home") + File.separatorChar + "coherence";
        }
        return sHome;
    }

    private static String getValueAsString(ParameterResolver resolver, String sParamName) {
        Parameter p = resolver.resolve(sParamName);
        return p == null ? "" : p.evaluate(resolver).as(String.class);
    }

    public static class PersistenceEnvironmentInfo
    implements com.tangosol.persistence.PersistenceEnvironmentInfo {
        private final File f_dirActive;
        private final File f_dirBackup;
        private final File f_dirEvents;
        private final File f_dirSnapshot;
        private final File f_dirTrash;
        private final String f_sMode;

        public PersistenceEnvironmentInfo(String sMode, File dirActive, File dirBackup, File dirEvents, File dirSnapshot, File dirTrash) {
            this.f_sMode = sMode;
            this.f_dirActive = dirActive;
            this.f_dirEvents = dirEvents;
            this.f_dirBackup = dirBackup;
            this.f_dirSnapshot = dirSnapshot;
            this.f_dirTrash = dirTrash;
        }

        @Override
        public File getPersistenceActiveDirectory() {
            return this.f_dirActive;
        }

        @Override
        public File getPersistenceBackupDirectory() {
            return this.f_dirBackup;
        }

        @Override
        public File getPersistenceEventsDirectory() {
            return this.f_dirEvents;
        }

        @Override
        public File getPersistenceSnapshotDirectory() {
            return this.f_dirSnapshot;
        }

        @Override
        public File getPersistenceTrashDirectory() {
            return this.f_dirTrash;
        }

        @Override
        public long getPersistenceActiveSpaceUsed() {
            return 0L;
        }

        @Override
        public long getPersistenceBackupSpaceUsed() {
            return 0L;
        }

        public String getPersistenceMode() {
            return this.f_sMode;
        }

        public boolean isActive() {
            return "active".equalsIgnoreCase(this.f_sMode);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{mode=" + this.f_sMode + ", activeDir=" + String.valueOf(this.f_dirActive == null ? null : this.f_dirActive.getAbsoluteFile()) + ", snapshotDir=" + String.valueOf(this.f_dirSnapshot.getAbsoluteFile()) + ", trashDir=" + String.valueOf(this.f_dirTrash.getAbsoluteFile()) + "}";
        }
    }
}

