/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.builder;

import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.internal.util.DaemonPool;
import com.tangosol.internal.util.Daemons;
import com.tangosol.internal.util.DefaultDaemonPoolDependencies;

public class DaemonPoolBuilder
implements ParameterizedBuilder<DaemonPool> {
    private Expression<Integer> m_cThreadsMax;
    private Expression<Integer> m_cThreadsMin;

    @Override
    public DaemonPool realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
        Integer n;
        int cThreads;
        int cThreadsMax = Integer.MAX_VALUE;
        int cThreadsMin = cThreads = Runtime.getRuntime().availableProcessors();
        if (this.m_cThreadsMax != null) {
            n = this.m_cThreadsMax.evaluate(resolver);
            int n2 = cThreadsMax = n == null || n <= 0 ? Integer.MAX_VALUE : n;
        }
        if (this.m_cThreadsMin != null) {
            n = this.m_cThreadsMin.evaluate(resolver);
            cThreadsMin = n == null || n <= 0 ? cThreads : n;
        }
        cThreads = Math.max(cThreads, cThreadsMin);
        cThreads = Math.min(cThreads, cThreadsMax);
        DefaultDaemonPoolDependencies deps = new DefaultDaemonPoolDependencies();
        deps.setName("CoherenceCommonPool");
        deps.setThreadCount(cThreads);
        deps.setThreadCountMax(cThreadsMax);
        deps.setThreadCountMin(cThreadsMin);
        return Daemons.newDaemonPool(deps);
    }

    public Expression<Integer> getMaxThreadCount() {
        return this.m_cThreadsMax;
    }

    @Injectable(value="thread-count-max")
    public void setMaxThreadCount(Expression<Integer> cThreadsMax) {
        this.m_cThreadsMax = cThreadsMax;
    }

    public Expression<Integer> getMinThreadCount() {
        return this.m_cThreadsMin;
    }

    @Injectable(value="thread-count-min")
    public void setMinThreadCount(Expression<Integer> cThreadsMin) {
        this.m_cThreadsMin = cThreadsMin;
    }
}

