/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.builder;

import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.ActionPolicy;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.NullImplementation;

public abstract class ActionPolicyBuilder
implements ParameterizedBuilder<ActionPolicy> {

    public static class QuorumRule {
        protected XmlElement m_xmlElement;
        protected String m_sRuleElementName;
        protected int m_nRuleMask;
        protected int m_nThreshold;
        protected float m_flThresholdPct;

        public QuorumRule(String sRuleElementName, int nRuleMask, int nThreshold, XmlElement xmlElement) {
            this(sRuleElementName, nRuleMask, nThreshold, 0.0f, xmlElement);
        }

        public QuorumRule(String sRuleElementName, int nRuleMask, int nThreshold, float flThresholdPct, XmlElement xmlElement) {
            this.m_sRuleElementName = sRuleElementName;
            this.m_nRuleMask = nRuleMask;
            this.m_nThreshold = nThreshold;
            this.m_flThresholdPct = flThresholdPct;
            this.m_xmlElement = xmlElement;
        }

        public void validate() throws ConfigurationException {
            if (this.m_nThreshold < 0 || this.m_flThresholdPct < 0.0f || this.m_flThresholdPct > 1.0f) {
                String sValue = this.m_nThreshold < 0 ? String.valueOf(this.m_nThreshold) : this.m_flThresholdPct * 100.0f + "%";
                throw new ConfigurationException("Invalid value [" + sValue + "] for <" + this.m_sRuleElementName + "> in [" + String.valueOf(this.m_xmlElement) + "]", "The <" + this.m_sRuleElementName + "> must be non-negative and less than 100% if percentage is specified.");
            }
        }
    }

    public static class NullImplementationBuilder
    extends ActionPolicyBuilder {
        @Override
        public ActionPolicy realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) throws ConfigurationException {
            return NullImplementation.getActionPolicy();
        }
    }

    public static class ActionPolicyParameterizedBuilder
    extends ActionPolicyBuilder {
        private ParameterizedBuilder<ActionPolicy> m_builder;

        public ActionPolicyParameterizedBuilder(ParameterizedBuilder<ActionPolicy> bldr) {
            this.m_builder = bldr;
        }

        @Override
        public ActionPolicy realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) throws ConfigurationException {
            return this.m_builder.realize(resolver, loader, listParameters);
        }
    }
}

