/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config;

import com.tangosol.coherence.config.scheme.ServiceScheme;
import com.tangosol.util.UUID;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class ServiceSchemeRegistry
implements Iterable<ServiceScheme> {
    private LinkedHashMap<String, ServiceScheme> m_mapServiceSchemesBySchemeName = new LinkedHashMap();

    @Override
    public Iterator<ServiceScheme> iterator() {
        return this.m_mapServiceSchemesBySchemeName.values().iterator();
    }

    public void register(ServiceScheme scheme) {
        if (scheme.isAnonymous()) {
            ServiceScheme schemeOther = this.findSchemeByServiceName(scheme.getServiceName());
            if (schemeOther != null) {
                throw new IllegalArgumentException(String.format("Attempted to register an anonymous service scheme with a <service-name>%s</service-name> that is already defined.", scheme.getSchemeName()));
            }
            this.m_mapServiceSchemesBySchemeName.put("anonymous-" + scheme.getServiceName() + "-" + String.valueOf(new UUID()), scheme);
        } else {
            if (this.m_mapServiceSchemesBySchemeName.containsKey(scheme.getSchemeName())) {
                throw new IllegalArgumentException(String.format("Attempted to define multiple service schemes of <scheme-name>%s</scheme-name>.\nDefined %s, Invalid duplicate %s.", scheme.getSchemeName(), ServiceSchemeRegistry.describeServiceScheme(this.m_mapServiceSchemesBySchemeName.get(scheme.getSchemeName())), ServiceSchemeRegistry.describeServiceScheme(scheme)));
            }
            this.m_mapServiceSchemesBySchemeName.put(scheme.getSchemeName(), scheme);
        }
    }

    public ServiceScheme findSchemeBySchemeName(String sSchemeName) {
        return this.m_mapServiceSchemesBySchemeName.get(sSchemeName);
    }

    public ServiceScheme findSchemeByServiceName(String sServiceName) {
        ServiceScheme schemeMatch = null;
        for (ServiceScheme scheme : this) {
            if (!scheme.getServiceName().equals(sServiceName)) continue;
            if (scheme.isAutoStart()) {
                return scheme;
            }
            schemeMatch = scheme;
        }
        return schemeMatch;
    }

    public int size() {
        return this.m_mapServiceSchemesBySchemeName.size();
    }

    private static String describeServiceScheme(ServiceScheme scheme) {
        StringBuilder sb = new StringBuilder();
        if (scheme != null) {
            sb.append("ServiceScheme scheme-name=").append(scheme.getSchemeName());
            sb.append(" service-name=").append(scheme.getServiceName());
            sb.append(" service type=").append(scheme.getServiceType());
        }
        return sb.toString();
    }
}

