/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config;

import com.tangosol.application.ContainerContext;
import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.coherence.config.builder.MapBuilder;
import com.tangosol.coherence.config.builder.NamedEventInterceptorBuilder;
import com.tangosol.coherence.config.scheme.Scheme;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.util.Base;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.SimpleResourceRegistry;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class ResourceMapping<R> {
    private boolean m_fInternal;
    private final String f_sNamePattern;
    private final String f_sSchemeName;
    private ParameterResolver m_parameterResolver;
    private final ResourceRegistry f_resourceRegistry;
    private List<NamedEventInterceptorBuilder> m_listEventInterceptorBuilders;
    private final List<ResourceMapping> f_subMappings;

    public ResourceMapping(String sNamePattern, String sSchemeName) {
        Base.azzert(sNamePattern != null);
        Base.azzert(sSchemeName != null);
        this.f_sNamePattern = sNamePattern;
        this.f_sSchemeName = sSchemeName;
        this.m_parameterResolver = new ResolvableParameterList();
        this.m_listEventInterceptorBuilders = new LinkedList<NamedEventInterceptorBuilder>();
        this.f_resourceRegistry = new SimpleResourceRegistry();
        this.f_subMappings = new ArrayList<ResourceMapping>();
    }

    public abstract String getConfigElementName();

    public abstract void validateScheme(Scheme var1);

    public ResourceMapping setInternal(boolean fInternal) {
        this.m_fInternal = fInternal;
        return this;
    }

    public boolean isInternal() {
        return this.m_fInternal;
    }

    public String getNamePattern() {
        return this.f_sNamePattern;
    }

    public String getSchemeName() {
        return this.f_sSchemeName;
    }

    public ResourceRegistry getResourceRegistry() {
        return this.f_resourceRegistry;
    }

    public ParameterResolver getParameterResolver() {
        return this.m_parameterResolver;
    }

    @Injectable(value="init-params")
    public void setParameterResolver(ParameterResolver resolver) {
        this.m_parameterResolver = resolver == null ? new ResolvableParameterList() : resolver;
    }

    public List<NamedEventInterceptorBuilder> getEventInterceptorBuilders() {
        return this.m_listEventInterceptorBuilders;
    }

    @Injectable(value="interceptors")
    public void setEventInterceptorBuilders(List<NamedEventInterceptorBuilder> listBuilders) {
        this.m_listEventInterceptorBuilders = listBuilders;
    }

    public boolean isForName(String sName) {
        return this.f_sNamePattern.endsWith("*") && sName.regionMatches(0, this.f_sNamePattern, 0, this.f_sNamePattern.length() - 1) || this.f_sNamePattern.equals(sName);
    }

    public boolean usesWildcard() {
        return this.f_sNamePattern.contains("*");
    }

    public String getWildcardMatch(String sName) {
        if (sName != null && !sName.isEmpty() && this.usesWildcard() && this.isForName(sName)) {
            return this.f_sNamePattern.equals("*") ? sName : sName.substring(this.f_sNamePattern.indexOf("*"));
        }
        return null;
    }

    public <T> T getValue(String sParamName, Class<T> paramValueType) {
        Parameter param = this.getParameterResolver().resolve(sParamName);
        return param == null ? null : (T)param.evaluate(this.getParameterResolver()).as(paramValueType);
    }

    public Object getValue(String sParamName) {
        ParameterResolver resolver = this.getParameterResolver();
        Parameter param = resolver.resolve(sParamName);
        return param == null ? null : param.evaluate(resolver).get();
    }

    public String getNameUsing(String sWildCardValue) {
        if (sWildCardValue != null && !sWildCardValue.isEmpty() && this.usesWildcard()) {
            return this.f_sNamePattern.replaceAll("\\*", sWildCardValue);
        }
        return null;
    }

    public List<ResourceMapping> getSubMappings() {
        return this.f_subMappings;
    }

    public void preConstruct(ContainerContext context, ParameterResolver resolver, MapBuilder.Dependencies dependencies) {
    }

    public void postConstruct(ContainerContext context, R resource, ParameterResolver resolver, MapBuilder.Dependencies dependencies) {
    }
}

