/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.config.expression.Value;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ParameterMacroExpression<T>
implements Expression<T>,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="resultType")
    private Class<T> m_clzResultType;
    @JsonbProperty(value="expression")
    private String m_sExpression;

    public ParameterMacroExpression() {
    }

    public ParameterMacroExpression(String sExpression, Class<T> clzResultType) {
        Base.azzert(clzResultType != null);
        this.m_clzResultType = clzResultType;
        this.m_sExpression = sExpression.trim();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public T evaluate(ParameterResolver resolver) {
        Object o;
        Value result = null;
        boolean fUseStringBasedResult = false;
        StringBuilder bldr = new StringBuilder();
        for (int idx = 0; idx < this.m_sExpression.length(); ++idx) {
            if (this.m_sExpression.startsWith("\\{", idx)) {
                bldr.append("{");
                ++idx;
                fUseStringBasedResult = true;
                continue;
            }
            if (this.m_sExpression.startsWith("\\}", idx)) {
                bldr.append("}");
                ++idx;
                fUseStringBasedResult = true;
                continue;
            }
            if (this.m_sExpression.charAt(idx) == '{') {
                Value value;
                String sDefaultValue;
                String sParameterName;
                int idxDefaultValue = this.m_sExpression.indexOf(" ", idx + 1);
                if (idxDefaultValue >= 0) {
                    sParameterName = this.m_sExpression.substring(idx + 1, idxDefaultValue).trim();
                    idxEndMacro = this.m_sExpression.indexOf("}", idxDefaultValue);
                    if (idxEndMacro <= idxDefaultValue) throw new IllegalArgumentException(String.format("Invalid parameter macro definition in [%s].  Missing closing brace '}'.", this.m_sExpression));
                    sDefaultValue = this.m_sExpression.substring(idxDefaultValue, idxEndMacro).trim();
                    idx = idxEndMacro;
                } else {
                    idxEndMacro = this.m_sExpression.indexOf("}", idx + 1);
                    if (idxEndMacro <= idx + 1) throw new IllegalArgumentException(String.format("Invalid parameter macro definition in [%s].  Missing closing brace '}'.", this.m_sExpression));
                    sParameterName = this.m_sExpression.substring(idx + 1, idxEndMacro).trim();
                    sDefaultValue = null;
                    idx = idxEndMacro;
                }
                Parameter parameter = resolver.resolve(sParameterName);
                if (parameter == null) {
                    if (sDefaultValue == null) {
                        throw new IllegalArgumentException(String.format("The specified parameter name '%s' in the macro parameter '%s' is unknown and not resolvable", sParameterName, this.m_sExpression));
                    }
                    value = new Value(sDefaultValue);
                } else {
                    value = parameter.evaluate(resolver);
                }
                Value value2 = result = value == null ? new Value() : value;
                if (!fUseStringBasedResult && !(value.get() instanceof String)) continue;
                try {
                    bldr.append(value.get().toString());
                    continue;
                }
                catch (Exception e) {
                    Logger.warn("ParameterMacroExpression evaluation resulted in a toString Exception for class " + value.get().getClass().getName());
                    throw Base.ensureRuntimeException(e);
                }
            }
            bldr.append(this.m_sExpression.charAt(idx));
            fUseStringBasedResult = true;
        }
        Object v1 = fUseStringBasedResult ? new Value(bldr.toString()).as(this.m_clzResultType) : (o = result == null ? null : result.as(this.m_clzResultType));
        return fUseStringBasedResult ? (T)new Value(bldr.toString()).as(this.m_clzResultType) : (result == null ? null : (T)result.as(this.m_clzResultType));
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_sExpression = ExternalizableHelper.readUTF(in);
        String sClzName = ExternalizableHelper.readSafeUTF(in);
        if (sClzName.length() > 0) {
            try {
                this.m_clzResultType = Class.forName(sClzName);
            }
            catch (ClassNotFoundException e) {
                throw Base.ensureRuntimeException(e);
            }
        }
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeUTF(out, this.m_sExpression);
        ExternalizableHelper.writeUTF(out, this.m_clzResultType.getName());
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_sExpression = in.readString(0);
        String sClzName = in.readString(1);
        if (sClzName.length() > 0) {
            try {
                this.m_clzResultType = Class.forName(sClzName);
            }
            catch (ClassNotFoundException e) {
                throw Base.ensureRuntimeException(e);
            }
        }
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeString(0, this.m_sExpression);
        out.writeString(1, this.m_clzResultType.getName());
    }

    public String toString() {
        return String.format("ParameterMacroExpression{type=%s, expression=%s}", this.m_clzResultType, this.m_sExpression);
    }
}

