/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config;

import com.tangosol.coherence.config.CacheMapping;
import com.tangosol.coherence.config.ResourceMapping;
import com.tangosol.coherence.config.ResourceMappingRegistry;
import com.tangosol.coherence.config.SchemeMappingRegistry;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class CacheMappingRegistry
implements Iterable<CacheMapping> {
    private final ResourceMappingRegistry f_registry;

    public CacheMappingRegistry() {
        this.f_registry = new SchemeMappingRegistry();
    }

    public CacheMappingRegistry(ResourceMappingRegistry registry) {
        this.f_registry = registry;
    }

    @Override
    public Iterator<CacheMapping> iterator() {
        Stream<ResourceMapping> stream = StreamSupport.stream(this.f_registry.spliterator(), false).filter(e -> e instanceof CacheMapping);
        return stream.iterator();
    }

    public void register(CacheMapping cacheMapping) throws IllegalArgumentException {
        if (this.findCacheMapping(cacheMapping.getNamePattern()) != null) {
            throw new IllegalArgumentException(String.format("Attempted to redefined an existing cache mapping for the <cache-name>%s</cache-name>", cacheMapping.getNamePattern()));
        }
        this.f_registry.register(cacheMapping);
    }

    public CacheMapping findCacheMapping(String sCacheName) {
        return this.f_registry.findCacheMapping(sCacheName);
    }

    public int size() {
        return (int)StreamSupport.stream(this.f_registry.spliterator(), false).filter(e -> e instanceof CacheMapping).count();
    }

    public ResourceMappingRegistry getMappingRegistry() {
        return this.f_registry;
    }
}

