/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config;

import com.tangosol.coherence.config.TypedResourceMapping;
import com.tangosol.coherence.config.scheme.CachingScheme;
import com.tangosol.coherence.config.scheme.Scheme;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.net.NamedCache;
import com.tangosol.util.ClassHelper;

public class CacheMapping
extends TypedResourceMapping<NamedCache> {
    public boolean m_fFederated = true;
    private String m_sKeyClassName = null;

    public CacheMapping(String sCacheNamePattern, String sCachingSchemeName) {
        super(sCacheNamePattern, sCachingSchemeName);
    }

    @Override
    public String getConfigElementName() {
        return "cache-name";
    }

    @Override
    public void validateScheme(Scheme scheme) {
        if (scheme instanceof CachingScheme) {
            return;
        }
        String sElement = this.getConfigElementName();
        String sPattern = this.getNamePattern();
        String sScheme = scheme.getSchemeName();
        String sMsg = String.format("Mapping <%s>%s</%s> maps to %s which is not a valid caching scheme", sScheme, sElement, sPattern, sElement);
        throw new IllegalStateException(sMsg);
    }

    @Injectable(value="federated")
    public CacheMapping setFederated(boolean fIsFederated) {
        this.m_fFederated = fIsFederated;
        return this;
    }

    public boolean isFederated() {
        return this.m_fFederated;
    }

    @Override
    public CacheMapping setInternal(boolean fIsInternal) {
        super.setInternal(fIsInternal);
        return this;
    }

    public String getCacheNamePattern() {
        return this.getNamePattern();
    }

    public String getCachingSchemeName() {
        return this.getSchemeName();
    }

    public String getKeyClassName() {
        return this.m_sKeyClassName;
    }

    @Injectable(value="key-type")
    public void setKeyClassName(String sKeyClassName) {
        this.m_sKeyClassName = ClassHelper.getFullyQualifiedClassNameOf(sKeyClassName);
    }

    @Override
    @Injectable(value="value-type")
    public void setValueClassName(String sValueClassName) {
        super.setValueClassName(sValueClassName);
    }
}

