/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.windowedArray;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.WindowedArray;

public abstract class OptimisticWindowedArray
extends WindowedArray {
    public OptimisticWindowedArray(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/windowedArray/OptimisticWindowedArray".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    public synchronized long add(Object o) {
        long lVirtual = this.getSize();
        int iActual = this.ensureIndex(lVirtual);
        if (o != null) {
            this.assignIndexToValue(lVirtual, o);
        }
        this.getStore()[iActual] = o;
        return lVirtual;
    }

    protected void assignIndexToValue(long lVirtual, Object o) {
    }

    @Override
    public Object get(long lVirtual) {
        if (lVirtual < 0L) {
            throw new IndexOutOfBoundsException("negative index is illegal: " + lVirtual);
        }
        Object[] aoStore = this.getStore();
        int iaAnchor = -1;
        long lvAnchor = -1L;
        int cCapacity = aoStore.length;
        int iaStart = this.getWindowIndex() % cCapacity;
        int iaEnd = (cCapacity + iaStart - 1) % cCapacity;
        int j = iaStart;
        while (j != iaEnd) {
            Object o = aoStore[j];
            if (o != null && o != REMOVED && (lvAnchor = this.retrieveIndexFromValue(o)) >= 0L) {
                iaAnchor = j;
                break;
            }
            j = (j + 1) % cCapacity;
        }
        if (iaAnchor == -1) {
            return null;
        }
        long lDelta = lvAnchor - lVirtual;
        if (Math.abs(lDelta) > (long)cCapacity) {
            return null;
        }
        long lAdjust = cCapacity + iaAnchor;
        int iaStore = (int)((lAdjust - lDelta) % (long)cCapacity);
        Object o = aoStore[iaStore];
        return o == null || o == REMOVED || this.retrieveIndexFromValue(o) != lVirtual ? null : o;
    }

    @Override
    public int getAll(long[] alIndex, int cEntries, Object[] aoResult) {
        Object[] aoStore = this.getStore();
        int iaAnchor = -1;
        long lvAnchor = -1L;
        int cCapacity = aoStore.length;
        int iaStart = this.getWindowIndex() % cCapacity;
        int iaEnd = (cCapacity + iaStart - 1) % cCapacity;
        int i = iaStart;
        while (i != iaEnd) {
            Object o = aoStore[i];
            if (o != null && o != REMOVED && (lvAnchor = this.retrieveIndexFromValue(o)) >= 0L) {
                iaAnchor = i;
                break;
            }
            i = (i + 1) % cCapacity;
        }
        if (iaAnchor == -1) {
            for (i = 0; i < cEntries; ++i) {
                aoResult[i] = null;
            }
            return 0;
        }
        int cFound = 0;
        long lAdjust = cCapacity + iaAnchor;
        for (int i2 = 0; i2 < cEntries; ++i2) {
            long lVirtual = alIndex[i2];
            if (lVirtual < 0L) {
                throw new IndexOutOfBoundsException("negative index is illegal: " + lVirtual);
            }
            long lDelta = lvAnchor - lVirtual;
            if (Math.abs(lDelta) > (long)cCapacity) {
                aoResult[i2] = null;
                continue;
            }
            int iaStore = (int)((lAdjust - lDelta) % (long)cCapacity);
            Object o = aoStore[iaStore];
            if (o == null || o == REMOVED || this.retrieveIndexFromValue(o) != lVirtual) {
                aoResult[i2] = null;
                continue;
            }
            aoResult[i2] = o;
            ++cFound;
        }
        return cFound;
    }

    protected long retrieveIndexFromValue(Object o) {
        return 0L;
    }

    @Override
    public synchronized Object set(long lVirtual, Object o) {
        this.assignIndexToValue(lVirtual, o);
        return super.set(lVirtual, o);
    }
}

