/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.windowedArray;

import com.oracle.coherence.common.base.Blocking;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.WindowedArray;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public abstract class ConcurrentWindowedArray
extends WindowedArray {
    private volatile long __m_AssumedFirstIndex;
    private AtomicLong __m_AtomicLastIndex;
    private transient long __m_LockOffset;
    private PlaceHolder[] __m_RecentPlaceHolders;
    private long __m_StatsGetsOptimistic;
    private long __m_StatsPlaceHolderAllocations;
    private long __m_StatsWaits;
    private AtomicLong __m_WaitingThreadCount;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("PlaceHolder", PlaceHolder.get_CLASS());
    }

    public ConcurrentWindowedArray(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/windowedArray/ConcurrentWindowedArray".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    public long add(Object o) {
        long iVirtual = this.getAtomicLastIndex().incrementAndGet();
        this.setInternal(iVirtual, o);
        return iVirtual;
    }

    protected void assignIndexToValue(long lVirtual, Object o) {
    }

    protected void ensureLastIndexMinimum(long lVirtual) {
        long lvLast;
        AtomicLong atomicLast = this.getAtomicLastIndex();
        while ((lvLast = atomicLast.get()) < lVirtual && !atomicLast.compareAndSet(lvLast, lVirtual)) {
        }
    }

    @Override
    public String formatStats() {
        StringBuilder sb = new StringBuilder(super.formatStats());
        sb.append(", optimistic gets=").append(this.getStatsGetsOptimistic()).append(", place holder allocations=").append(this.getStatsPlaceHolderAllocations()).append(", waits=").append(this.getStatsWaits()).append(", waiting threads=").append(this.getWaitingThreadCount().get());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(long lVirtual) {
        Object oValue;
        Object[] aoStore = this.getStableStore();
        int iActual = (int)(lVirtual % (long)aoStore.length);
        Object object = this.getIndexLock(lVirtual);
        synchronized (object) {
            oValue = aoStore[iActual];
        }
        return this.safeRetrieveIndexFromValue(oValue, iActual) == lVirtual && !(oValue instanceof PlaceHolder) ? oValue : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(long lVirtual, long cMillis) throws InterruptedException {
        long ldtTimeout = cMillis > 0L ? System.currentTimeMillis() + cMillis : 0L;
        while (true) {
            Object oLock;
            Object[] aoStore = this.getStableStore();
            int iActual = (int)(lVirtual % (long)aoStore.length);
            Object object = oLock = this.getIndexLock(lVirtual);
            synchronized (object) {
                Object oValue = aoStore[iActual];
                long lvFound = this.safeRetrieveIndexFromValue(oValue, iActual);
                if (lvFound > lVirtual) {
                    return null;
                }
                if (lvFound < lVirtual || oValue instanceof PlaceHolder) {
                    if (cMillis == 0L) {
                        return null;
                    }
                    long cMillisLeft = this.waitIndex(oLock, ldtTimeout);
                    if (cMillis > 0L && (cMillisLeft <= 0L || cMillisLeft > cMillis)) {
                        return null;
                    }
                } else {
                    return oValue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAll(long[] alIndex, int cEntries, Object[] aoResult) {
        Object[] aoStore = this.getStableStore();
        int cCapacity = aoStore.length;
        int cFound = 0;
        for (int iReq = 0; iReq < cEntries; ++iReq) {
            Object oValue;
            long lVirtual = alIndex[iReq];
            int iActual = (int)(lVirtual % (long)cCapacity);
            Object object = this.getIndexLock(lVirtual);
            synchronized (object) {
                oValue = aoStore[iActual];
            }
            if (this.safeRetrieveIndexFromValue(oValue, iActual) == lVirtual && !(oValue instanceof PlaceHolder)) {
                ++cFound;
                aoResult[iReq] = oValue;
                continue;
            }
            aoResult[iReq] = null;
        }
        return cFound;
    }

    protected long getAssumedFirstIndex() {
        return this.__m_AssumedFirstIndex;
    }

    protected AtomicLong getAtomicLastIndex() {
        return this.__m_AtomicLastIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFirstIndex() {
        long lvAssumed = this.getAssumedFirstIndex();
        Object[] aoStore = this.getStableStore();
        int cCapacity = aoStore.length;
        long lVirtual = lvAssumed;
        while (true) {
            int iActual;
            if (this.safeRetrieveIndexFromValue(aoStore[iActual = (int)(lVirtual % (long)cCapacity)], iActual) <= lVirtual) {
                Object object = this.getIndexLock(lVirtual);
                synchronized (object) {
                    long lvFound = this.safeRetrieveIndexFromValue(aoStore[iActual], iActual);
                    if (lvFound == lVirtual) {
                        if (lVirtual != lvAssumed) {
                            this.setAssumedFirstIndex(lVirtual);
                        }
                        return lVirtual;
                    }
                    if (lvFound < lVirtual) {
                        throw new IllegalStateException(lvFound + ", " + lVirtual);
                    }
                }
            }
            ++lVirtual;
        }
    }

    protected Object getIndexLock(long lVirtual) {
        return Base.getCommonMonitor(this.getLockOffset() + lVirtual);
    }

    @Override
    public long getLastIndex() {
        return this.getAtomicLastIndex().get();
    }

    protected long getLockOffset() {
        return this.__m_LockOffset;
    }

    protected Object getPlaceHolder(long lOffset) {
        PlaceHolder[] aHolders = this.getRecentPlaceHolders();
        int iOldest = 0;
        long lOldestOffset = Long.MAX_VALUE;
        int c = aHolders.length;
        for (int i = 0; i < c; ++i) {
            PlaceHolder holder = aHolders[i];
            if (holder == null) {
                lOldestOffset = -1L;
                iOldest = i;
                continue;
            }
            long lFoundOffset = holder.getVirtualOffset();
            if (lFoundOffset == lOffset) {
                return holder;
            }
            if (lFoundOffset >= lOldestOffset) continue;
            lOldestOffset = lFoundOffset;
            iOldest = i;
        }
        if (lOffset < 0L) {
            throw new IllegalStateException();
        }
        PlaceHolder holder = new PlaceHolder();
        holder.setVirtualOffset(lOffset);
        aHolders[iOldest] = holder;
        this.setStatsPlaceHolderAllocations(this.getStatsPlaceHolderAllocations() + 1L);
        return holder;
    }

    protected PlaceHolder[] getRecentPlaceHolders() {
        return this.__m_RecentPlaceHolders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] getStableStore() {
        Object[] aoStore = this.getStore();
        if (aoStore == null) {
            ConcurrentWindowedArray concurrentWindowedArray = this;
            synchronized (concurrentWindowedArray) {
                aoStore = this.getStore();
            }
            ConcurrentWindowedArray._assert(aoStore != null);
        }
        return aoStore;
    }

    public long getStatsGetsOptimistic() {
        return this.__m_StatsGetsOptimistic;
    }

    public long getStatsPlaceHolderAllocations() {
        return this.__m_StatsPlaceHolderAllocations;
    }

    public long getStatsWaits() {
        return this.__m_StatsWaits;
    }

    protected AtomicLong getWaitingThreadCount() {
        return this.__m_WaitingThreadCount;
    }

    @Override
    public int getWindowSize() {
        return (int)(this.getLastIndex() - this.getFirstIndex() + 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void grow(long lVirtual) {
        Object[] aoStore = this.getStore();
        long lvFirst = this.getFirstIndex();
        int cOldCapacity = aoStore.length;
        int cNewCapacity = this.checkCapacity(Math.max(cOldCapacity * 2, (int)(lVirtual - lvFirst) + 3));
        try {
            int iActual;
            this.setStore(null);
            long lvLast = this.getLastIndex();
            int cReqCapacity = (int)(lvLast - lvFirst) + 1;
            if (cReqCapacity > cNewCapacity) {
                if (cReqCapacity > this.getMaximumCapacity()) {
                    throw new IndexOutOfBoundsException(this.get_Name() + " has exceeded max capacity");
                }
                cNewCapacity = cReqCapacity;
            }
            Object[] aoNew = new Object[cNewCapacity];
            int iaNewFirst = (int)(lvFirst % (long)cNewCapacity);
            long lNewOffset = lvFirst - (long)iaNewFirst;
            Object oFree = this.getPlaceHolder(lNewOffset);
            for (iActual = iaNewFirst; iActual < cNewCapacity; ++iActual) {
                aoNew[iActual] = oFree;
            }
            oFree = this.getPlaceHolder(lNewOffset + (long)cNewCapacity);
            for (iActual = 0; iActual < iaNewFirst; ++iActual) {
                aoNew[iActual] = oFree;
            }
            for (long lvNext = lvFirst; lvNext <= lvLast; ++lvNext) {
                Object oOld;
                int iaOld = (int)(lvNext % (long)cOldCapacity);
                Object object = this.getIndexLock(lvNext);
                synchronized (object) {
                    oOld = aoStore[iaOld];
                }
                long lvFound = this.safeRetrieveIndexFromValue(oOld, iaOld);
                int iaNew = (int)(lvNext % (long)cNewCapacity);
                if (lvFound == lvNext && !(oOld instanceof PlaceHolder)) {
                    aoNew[iaNew] = oOld;
                    continue;
                }
                if (lvFound <= lvNext) continue;
                aoNew[iaNew] = this.getPlaceHolder(lvNext + (long)cNewCapacity - (long)iaNew);
            }
            aoStore = aoNew;
        }
        finally {
            this.setStore(aoStore);
            this.setStatsExpansions(this.getStatsExpansions() + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRemoved(long lVirtual) {
        int iActual;
        Object[] aoStore = this.getStableStore();
        Object oValue = aoStore[iActual = (int)(lVirtual % (long)aoStore.length)];
        if (this.safeRetrieveIndexFromValue(oValue, iActual) > lVirtual) {
            return true;
        }
        Object object = this.getIndexLock(lVirtual);
        synchronized (object) {
            oValue = aoStore[iActual];
        }
        return this.safeRetrieveIndexFromValue(oValue, iActual) > lVirtual;
    }

    @Override
    public void onInit() {
        this.setAtomicLastIndex(new AtomicLong(-1L));
        this.setWaitingThreadCount(new AtomicLong());
        this.setLockOffset(System.identityHashCode(this));
        this.setRecentPlaceHolders(new PlaceHolder[3]);
        super.onInit();
        Object[] aoStore = this.getStore();
        Object oFree = this.getPlaceHolder(0L);
        int c = aoStore.length;
        for (int i = 0; i < c; ++i) {
            aoStore[i] = oFree;
        }
        this.setStore(aoStore);
    }

    public Object optimisticGet(long lVirtual) {
        int iActual;
        Object oValue;
        Object[] aoStore = this.getStore();
        if (aoStore != null && this.safeRetrieveIndexFromValue(oValue = aoStore[iActual = (int)(lVirtual % (long)aoStore.length)], iActual) == lVirtual && !(oValue instanceof PlaceHolder)) {
            this.setStatsGetsOptimistic(this.getStatsGetsOptimistic() + 1L);
            return oValue;
        }
        return null;
    }

    @Override
    public Object remove(long lVirtual) {
        if (lVirtual > this.getLastIndex()) {
            throw new IndexOutOfBoundsException("cannot remove beyond the window");
        }
        try {
            return this.removeInternal(lVirtual, 0L, false);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Base.ensureRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected Object removeInternal(long lVirtual, long cMillis, boolean fSafe) throws InterruptedException {
        Object oResult;
        block18: {
            Object[] aoStore;
            if (lVirtual < 0L) {
                throw new IndexOutOfBoundsException("negative index is illegal: " + lVirtual);
            }
            oResult = null;
            int cCapacity = 0;
            boolean fBlocking = cMillis != 0L;
            long ldtTimeout = cMillis > 0L ? System.currentTimeMillis() + cMillis : 0L;
            int iActual = 0;
            if (fBlocking && !fSafe) {
                throw new IllegalArgumentException("Blocking remove cannot remove nulls");
            }
            while (true) {
                Object oLock;
                Object object = oLock = this.getIndexLock(lVirtual);
                // MONITORENTER : object
                aoStore = this.getStore();
                if (aoStore != null) {
                    cCapacity = aoStore.length;
                    iActual = (int)(lVirtual % (long)cCapacity);
                    oResult = aoStore[iActual];
                    long lvFound = this.safeRetrieveIndexFromValue(oResult, iActual);
                    if (lvFound > lVirtual) {
                        // MONITOREXIT : object
                        return null;
                    }
                    if (lvFound < lVirtual || fSafe && oResult instanceof PlaceHolder) {
                        if (!fBlocking) {
                            if (!fSafe) throw new IndexOutOfBoundsException("cannot remove beyond the window");
                            // MONITOREXIT : object
                            return null;
                        }
                        long cMillisLeft = this.waitIndex(oLock, ldtTimeout);
                        if (cMillis >= 0L && (cMillisLeft <= 0L || cMillisLeft > cMillis)) {
                            // MONITOREXIT : object
                            return null;
                        }
                    } else {
                        aoStore[iActual] = this.getPlaceHolder(lVirtual - (long)iActual + (long)cCapacity);
                        if (this.getWaitingThreadCount().get() > 0L) {
                            oLock.notifyAll();
                        }
                        // MONITOREXIT : object
                        oLock = this.getIndexLock(lVirtual + (long)cCapacity);
                        // MONITORENTER : oLock
                        // MONITOREXIT : oLock
                        if (lVirtual == this.getAssumedFirstIndex()) {
                            break;
                        }
                        break block18;
                    }
                }
                // MONITOREXIT : object
                if (aoStore != null) continue;
                this.getStableStore();
            }
            long lvFirst = lVirtual + 1L;
            while (true) {
                if (this.safeRetrieveIndexFromValue(aoStore[iActual = (int)(lvFirst % (long)cCapacity)], iActual) <= lvFirst) {
                    this.setAssumedFirstIndex(lvFirst);
                    break;
                }
                ++lvFirst;
            }
        }
        if (oResult instanceof PlaceHolder) {
            return null;
        }
        Object object = oResult;
        return object;
    }

    protected long retrieveIndexFromValue(Object o) {
        return 0L;
    }

    public Object safeRemove(long lVirtual) {
        try {
            return this.removeInternal(lVirtual, 0L, true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Base.ensureRuntimeException(e);
        }
    }

    public Object safeRemove(long lVirtual, long cMillis) throws InterruptedException {
        return this.removeInternal(lVirtual, cMillis, true);
    }

    protected long safeRetrieveIndexFromValue(Object o, int iActual) {
        return o instanceof PlaceHolder ? ((PlaceHolder)o).getVirtualIndex(iActual) : this.retrieveIndexFromValue(o);
    }

    @Override
    public Object set(long lVirtual, Object o) {
        if (lVirtual < 0L) {
            throw new IndexOutOfBoundsException("negative index is illegal: " + lVirtual);
        }
        this.ensureLastIndexMinimum(lVirtual);
        return this.setInternal(lVirtual, o);
    }

    protected void setAssumedFirstIndex(long i) {
        this.__m_AssumedFirstIndex = i;
    }

    protected void setAtomicLastIndex(AtomicLong counter) {
        this.__m_AtomicLastIndex = counter;
    }

    @Override
    protected void setFirstIndex(long lVirtual) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object setInternal(long lVirtual, Object o) {
        while (true) {
            Object[] aoStore;
            Object oLock;
            long lvFound = 0L;
            int iActual = 0;
            Object object = oLock = this.getIndexLock(lVirtual);
            synchronized (object) {
                Object oOld;
                aoStore = this.getStore();
                if (aoStore != null && (lvFound = this.safeRetrieveIndexFromValue(oOld = aoStore[iActual = (int)(lVirtual % (long)aoStore.length)], iActual)) == lVirtual) {
                    if (o == null) {
                        o = this.getPlaceHolder(lVirtual - (long)iActual);
                    } else {
                        this.assignIndexToValue(lVirtual, o);
                    }
                    aoStore[iActual] = o;
                    if (this.getWaitingThreadCount().get() > 0L) {
                        oLock.notifyAll();
                    }
                    return oOld;
                }
            }
            if (aoStore == null) {
                this.getStableStore();
                continue;
            }
            if (lvFound > lVirtual) {
                int iaFound = (int)(lvFound % (long)aoStore.length);
                if (iaFound == iActual) {
                    throw new IndexOutOfBoundsException("index " + lVirtual + " has already been removed and cannot be reset");
                }
                throw new IllegalStateException("found unexpected value at virtual index " + lvFound + " actual " + iaFound + " capacity " + aoStore.length);
            }
            object = this;
            synchronized (object) {
                if (this.getStore() == aoStore) {
                    this.grow(lVirtual);
                }
            }
        }
    }

    protected void setLockOffset(long lOffset) {
        this.__m_LockOffset = lOffset;
    }

    protected void setRecentPlaceHolders(PlaceHolder[] aPlaceHolder) {
        this.__m_RecentPlaceHolders = aPlaceHolder;
    }

    public void setStatsGetsOptimistic(long pStatsGetsOptimistic) {
        this.__m_StatsGetsOptimistic = pStatsGetsOptimistic;
    }

    protected void setStatsPlaceHolderAllocations(long cHolders) {
        this.__m_StatsPlaceHolderAllocations = cHolders;
    }

    protected void setStatsWaits(long cWaits) {
        this.__m_StatsWaits = cWaits;
    }

    @Override
    protected void setStore(Object[] ao) {
        ConcurrentWindowedArray._assert(ao == null || ao.length != 0);
        super.setStore(ao);
    }

    protected void setWaitingThreadCount(AtomicLong counter) {
        this.__m_WaitingThreadCount = counter;
    }

    @Override
    protected int translateIndex(long lVirtual) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long waitIndex(Object oLock, long ldtTimeout) throws InterruptedException {
        AtomicLong waiting = this.getWaitingThreadCount();
        waiting.incrementAndGet();
        this.setStatsWaits(this.getStatsWaits() + 1L);
        try {
            if (ldtTimeout > 0L) {
                long cWaitMillis = ldtTimeout - System.currentTimeMillis();
                if (cWaitMillis > 0L) {
                    Blocking.wait(oLock, Math.min(1000L, cWaitMillis));
                    long l = ldtTimeout - System.currentTimeMillis();
                    return l;
                }
                long l = cWaitMillis;
                return l;
            }
            Blocking.wait(oLock);
            long l = Long.MAX_VALUE;
            return l;
        }
        finally {
            waiting.decrementAndGet();
        }
    }

    static {
        ConcurrentWindowedArray.__initStatic();
    }

    public static class PlaceHolder
    extends Component {
        private long __m_VirtualOffset;

        public PlaceHolder() {
            this(null, null, true);
        }

        public PlaceHolder(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setVirtualOffset(-1L);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PlaceHolder();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/windowedArray/ConcurrentWindowedArray$PlaceHolder".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public long getVirtualIndex(int iActual) {
            return this.getVirtualOffset() + (long)iActual;
        }

        public long getVirtualOffset() {
            return this.__m_VirtualOffset;
        }

        public void setVirtualOffset(long lVirtual) {
            this.__m_VirtualOffset = lVirtual;
        }

        @Override
        public String toString() {
            return "PlaceHolder VirtualOffset=" + this.getVirtualOffset();
        }
    }
}

