/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.safeService;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.util.SafeNamedCache;
import com.tangosol.coherence.component.util.SafeService;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.Service;
import com.tangosol.net.internal.ScopedCacheReferenceStore;
import com.tangosol.net.security.SecurityHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.SimpleResourceRegistry;
import com.tangosol.util.WrapperException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class SafeCacheService
extends SafeService
implements CacheService {
    private transient BackingMapManager __m_BackingMapManager;
    private ScopedCacheReferenceStore __m_ScopedCacheStore;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("DestroyCacheAction", DestroyCacheAction.get_CLASS());
        __mapChildren.put("EnsureServiceAction", SafeService.EnsureServiceAction.get_CLASS());
        __mapChildren.put("ReleaseCacheAction", ReleaseCacheAction.get_CLASS());
        __mapChildren.put("StartAction", SafeService.StartAction.get_CLASS());
        __mapChildren.put("Unlockable", SafeService.Unlockable.get_CLASS());
    }

    public SafeCacheService() {
        this(null, null, true);
    }

    public SafeCacheService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setLock(new ReentrantLock());
            this.setResourceRegistry(new SimpleResourceRegistry());
            this.setSafeServiceState(0);
            this.setScopedCacheStore(new ScopedCacheReferenceStore());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new SafeCacheService();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/safeService/SafeCacheService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    private NamedCache ensureCache$Router(String sName, ClassLoader loader) {
        return this.getRunningCacheService().ensureCache(sName, loader);
    }

    @Override
    public NamedCache ensureCache(String sName, ClassLoader loader) {
        this.checkClientThread("ensureCache");
        if (sName == null || sName.length() == 0) {
            sName = "Default";
        }
        if (loader == null) {
            loader = this.getContextClassLoader();
        }
        Security.checkPermission(this.getSafeCluster(), this.getServiceName(), sName, "join");
        ScopedCacheReferenceStore store = this.getScopedCacheStore();
        SafeNamedCache cacheSafe = (SafeNamedCache)store.getCache(sName, loader);
        if (cacheSafe != null) {
            if (cacheSafe.isActive() || !cacheSafe.isDestroyed() && !cacheSafe.isReleased()) {
                return cacheSafe;
            }
            cacheSafe = null;
        }
        store.clearInactiveCacheRefs();
        while (cacheSafe == null) {
            NamedCache cache = this.ensureCache$Router(sName, loader);
            cacheSafe = new SafeNamedCache();
            cacheSafe.setSubject(SecurityHelper.getCurrentSubject());
            cacheSafe.setSafeCacheService(this);
            cacheSafe.setCacheName(sName);
            cacheSafe.setClassLoader(loader);
            cacheSafe.setInternalNamedCache(cache);
            cacheSafe.setStarted(true);
            if (store.putCacheIfAbsent(cacheSafe, loader) == null) break;
            cacheSafe = (SafeNamedCache)store.getCache(sName, loader);
        }
        return cacheSafe;
    }

    @Override
    public Enumeration getCacheNames() {
        return this.getRunningCacheService().getCacheNames();
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        this.setBackingMapManager(null);
        this.getScopedCacheStore().clear();
    }

    @Override
    public void destroyCache(NamedCache cache) {
        Security.checkPermission(this.getSafeCluster(), this.getServiceName(), cache.getCacheName(), "destroy");
        SafeNamedCache cacheSafe = (SafeNamedCache)cache;
        this.removeCacheReference(cacheSafe);
        DestroyCacheAction action = (DestroyCacheAction)this._newChild("DestroyCacheAction");
        action.setSafeNamedCache(cacheSafe);
        action.setCacheService((CacheService)this.getInternalService());
        AccessController.doPrivileged(action);
    }

    @Override
    public BackingMapManager getBackingMapManager() {
        return this.__m_BackingMapManager;
    }

    public CacheService getRunningCacheService() {
        return (CacheService)this.getRunningService();
    }

    protected ScopedCacheReferenceStore getScopedCacheStore() {
        return this.__m_ScopedCacheStore;
    }

    @Override
    public void releaseCache(NamedCache cache) {
        SafeNamedCache cacheSafe = (SafeNamedCache)cache;
        this.removeCacheReference(cacheSafe);
        ReleaseCacheAction action = (ReleaseCacheAction)this._newChild("ReleaseCacheAction");
        action.setSafeNamedCache(cacheSafe);
        action.setCacheService((CacheService)this.getInternalService());
        AccessController.doPrivileged(action);
    }

    protected void removeCacheReference(SafeNamedCache cacheSafe) {
        cacheSafe.setReleased(true);
        this.getScopedCacheStore().releaseCache(cacheSafe);
    }

    @Override
    public void setBackingMapManager(BackingMapManager manager) {
        this.__m_BackingMapManager = manager;
    }

    protected void setScopedCacheStore(ScopedCacheReferenceStore scopedStore) {
        this.__m_ScopedCacheStore = scopedStore;
    }

    @Override
    protected void startService(Service service) {
        ((CacheService)service).setBackingMapManager(this.getBackingMapManager());
        super.startService(service);
    }

    static {
        SafeCacheService.__initStatic();
    }

    public static class DestroyCacheAction
    extends Util
    implements PrivilegedAction {
        private CacheService __m_CacheService;
        private SafeNamedCache __m_SafeNamedCache;

        public DestroyCacheAction() {
            this(null, null, true);
        }

        public DestroyCacheAction(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new DestroyCacheAction();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/safeService/SafeCacheService$DestroyCacheAction".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public CacheService getCacheService() {
            return this.__m_CacheService;
        }

        public SafeNamedCache getSafeNamedCache() {
            return this.__m_SafeNamedCache;
        }

        public Object run() {
            block3: {
                CacheService serviceInternal = this.getCacheService();
                NamedCache cacheInternal = this.getSafeNamedCache().getNamedCache();
                if (cacheInternal == null) {
                    throw new IllegalStateException("Cache is already released");
                }
                try {
                    serviceInternal.destroyCache(cacheInternal);
                }
                catch (RuntimeException e) {
                    if (serviceInternal == null || !serviceInternal.isRunning()) break block3;
                    throw e;
                }
            }
            return null;
        }

        public void setCacheService(CacheService service) {
            this.__m_CacheService = service;
        }

        public void setSafeNamedCache(SafeNamedCache cacheSafe) {
            this.__m_SafeNamedCache = cacheSafe;
        }
    }

    public static class ReleaseCacheAction
    extends Util
    implements PrivilegedAction {
        private CacheService __m_CacheService;
        private SafeNamedCache __m_SafeNamedCache;

        public ReleaseCacheAction() {
            this(null, null, true);
        }

        public ReleaseCacheAction(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ReleaseCacheAction();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/safeService/SafeCacheService$ReleaseCacheAction".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public CacheService getCacheService() {
            return this.__m_CacheService;
        }

        public SafeNamedCache getSafeNamedCache() {
            return this.__m_SafeNamedCache;
        }

        public Object run() {
            block3: {
                CacheService serviceInternal = this.getCacheService();
                NamedCache cacheInternal = this.getSafeNamedCache().getNamedCache();
                if (cacheInternal == null) {
                    throw new IllegalStateException("Cache is already released");
                }
                try {
                    serviceInternal.releaseCache(cacheInternal);
                }
                catch (RuntimeException e) {
                    if (serviceInternal == null || !serviceInternal.isRunning()) break block3;
                    throw e;
                }
            }
            return null;
        }

        public void setCacheService(CacheService service) {
            this.__m_CacheService = service;
        }

        public void setSafeNamedCache(SafeNamedCache cacheSafe) {
            this.__m_SafeNamedCache = cacheSafe;
        }
    }
}

