/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.queue.concurrentQueue.dualQueue;

import com.oracle.coherence.common.base.Associated;
import com.oracle.coherence.common.util.AssociationPile;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.queue.concurrentQueue.DualQueue;
import com.tangosol.util.ListMap;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.WrapperException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class AssociationQueue
extends DualQueue
implements AssociationPile {
    private transient AtomicLong __m_AddCounter;
    private transient long __m_AddStamp;
    private boolean __m_AllLocked;
    private Set __m_ContendedKeys;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Iterator", Queue.Iterator.get_CLASS());
    }

    public AssociationQueue() {
        this(null, null, true);
    }

    public AssociationQueue(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setBatchSize(1);
            this.setContendedKeys(new HashSet());
            this.setElementList(new RecyclingLinkedList());
            this.setHeadElementList(new RecyclingLinkedList());
            this.setHeadLock(new Object());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new AssociationQueue();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/queue/concurrentQueue/dualQueue/AssociationQueue".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    protected void checkFlush(int cElements) {
        this.getNotifier().signal();
    }

    protected AtomicLong getAddCounter() {
        return this.__m_AddCounter;
    }

    protected long getAddStamp() {
        return this.__m_AddStamp;
    }

    public static Object getAssociatedKey(Object oItem) {
        return oItem instanceof Associated ? ((Associated)oItem).getAssociatedKey() : null;
    }

    protected Set getContendedKeys() {
        return this.__m_ContendedKeys;
    }

    protected boolean isAllLocked() {
        return this.__m_AllLocked;
    }

    @Override
    public boolean isAvailable() {
        return !this.isEmpty() && this.getAddCounter().get() > this.getAddStamp();
    }

    @Override
    protected void onAddElement() {
        this.getAddCounter().incrementAndGet();
        super.onAddElement();
    }

    @Override
    public void onInit() {
        this.setAddCounter(new AtomicLong());
        super.onInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll() {
        Object oEntry;
        long lStamp;
        AtomicInteger counter = this.getElementCounter();
        Object object = this.getHeadLock();
        synchronized (object) {
            if (counter.get() == 0) {
                return null;
            }
            RecyclingLinkedList listHead = this.getHeadElementList();
            if (listHead.isEmpty()) {
                if (!this.swapNoWait()) {
                    return null;
                }
                listHead = this.getHeadElementList();
            }
            lStamp = this.getAddCounter().get();
            boolean fUnassocOnly = this.isAllLocked();
            oEntry = this.removeUncontended(listHead, fUnassocOnly);
            if (oEntry == null) {
                oEntry = this.removeUncontended(this.getElementList(), fUnassocOnly);
                if (oEntry == AssociationPile.ASSOCIATION_ALL) {
                    oEntry = null;
                }
            } else if (oEntry == AssociationPile.ASSOCIATION_ALL) {
                oEntry = this.removeUncontended(this.getElementList(), true);
            }
        }
        if (oEntry == null) {
            this.setAddStamp(lStamp);
        } else if (counter.decrementAndGet() == 0) {
            this.onEmpty();
        }
        return oEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Object oItem) {
        Object oKey = AssociationQueue.getAssociatedKey(oItem);
        if (oKey != null) {
            Object object = this.getHeadLock();
            synchronized (object) {
                if (oKey == AssociationPile.ASSOCIATION_ALL) {
                    this.setAllLocked(false);
                } else {
                    this.getContendedKeys().remove(oKey);
                    this.setAddStamp(0L);
                }
            }
        }
    }

    @Override
    public Object removeNoWait() {
        return this.poll();
    }

    protected Object removeUncontended(List listItem, boolean fUnassocOnly) {
        boolean fAllFound = false;
        int cItems = listItem.size();
        if (cItems > 0) {
            Set setKeys = this.getContendedKeys();
            for (int i = 0; i < cItems; ++i) {
                Object oEntry = listItem.get(i);
                Object oKey = AssociationQueue.getAssociatedKey(oEntry);
                if (oKey != null) {
                    if (fUnassocOnly || setKeys.contains(oKey)) continue;
                    if (oKey == AssociationPile.ASSOCIATION_ALL) {
                        if (setKeys.isEmpty()) {
                            this.setAllLocked(true);
                            oKey = null;
                        } else {
                            fAllFound = true;
                            fUnassocOnly = true;
                            continue;
                        }
                    }
                }
                if (listItem.remove(i) == oEntry) {
                    if (oKey != null) {
                        setKeys.add(oKey);
                    }
                    return oEntry;
                }
                throw new IllegalStateException();
            }
        }
        return fAllFound ? AssociationPile.ASSOCIATION_ALL : null;
    }

    protected void setAddCounter(AtomicLong counter) {
        this.__m_AddCounter = counter;
    }

    protected void setAddStamp(long lStamp) {
        this.__m_AddStamp = lStamp;
    }

    protected void setAllLocked(boolean fLocked) {
        this.__m_AllLocked = fLocked;
    }

    protected void setContendedKeys(Set setKeys) {
        this.__m_ContendedKeys = setKeys;
    }

    static {
        AssociationQueue.__initStatic();
    }
}

