/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.queue.concurrentQueue.balancedQueue;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.queue.concurrentQueue.BalancedQueue;
import com.tangosol.internal.util.MovingAverage;
import com.tangosol.util.ListMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BundlingQueue
extends BalancedQueue {
    private transient MovingAverage __m_BundleAverage;
    private transient double __m_BundlingAggression;
    private transient boolean __m_BundlingEnabled;
    private transient long __m_DeferralThresholdNanos;
    private transient long __m_DeferralThresholdReads;
    private transient long __m_ReadAttemptCount;
    private transient long __m_StatsBundled;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Iterator", Queue.Iterator.get_CLASS());
        __mapChildren.put("TargetQueue", TargetQueue.get_CLASS());
    }

    public BundlingQueue(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/queue/concurrentQueue/balancedQueue/BundlingQueue".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    public AtomicInteger getAtomicFlushState() {
        return super.getAtomicFlushState();
    }

    public MovingAverage getBundleAverage() {
        return this.__m_BundleAverage;
    }

    public double getBundlingAggression() {
        return this.__m_BundlingAggression;
    }

    public long getDeferralThresholdNanos() {
        return this.__m_DeferralThresholdNanos;
    }

    public long getDeferralThresholdReads() {
        return this.__m_DeferralThresholdReads;
    }

    public long getReadAttemptCount() {
        return this.__m_ReadAttemptCount;
    }

    public long getStatsBundled() {
        return this.__m_StatsBundled;
    }

    @Override
    protected Queue instantiateTargetQueue() {
        return this.isBundlingEnabled() ? (TargetQueue)this._newChild("TargetQueue") : super.instantiateTargetQueue();
    }

    public boolean isBundlingEnabled() {
        return this.__m_BundlingEnabled;
    }

    @Override
    public void onEmptyTarget(Object oTarget, Queue queueTarget) {
        if (queueTarget.isEmpty()) {
            super.onEmptyTarget(oTarget, queueTarget);
        }
    }

    @Override
    public void onInit() {
        this.setBundleAverage(new MovingAverage(1000, 10));
        super.onInit();
    }

    public void resetStats() {
        this.setStatsBundled(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void safeRemoveTargetQueue(Object oTarget) {
        boolean fRemoved = false;
        Object object = this.getLock(oTarget);
        synchronized (object) {
            Map mapTarget = this.getTargetMap();
            Queue queueTarget = (Queue)mapTarget.get(oTarget);
            if (queueTarget instanceof TargetQueue) {
                Object object2 = ((TargetQueue)queueTarget).getHeadLock();
                synchronized (object2) {
                    if (queueTarget.isEmpty()) {
                        mapTarget.remove(oTarget);
                        fRemoved = true;
                    }
                }
            } else if (queueTarget != null && queueTarget.isEmpty()) {
                mapTarget.remove(oTarget);
                fRemoved = true;
            }
        }
        if (fRemoved) {
            this.refreshEntries();
        }
    }

    protected void setBundleAverage(MovingAverage average) {
        this.__m_BundleAverage = average;
    }

    public void setBundlingAggression(double dAggression) {
        this.__m_BundlingAggression = Math.max(0.0, dAggression);
    }

    public void setBundlingEnabled(boolean fEnabled) {
        this.__m_BundlingEnabled = fEnabled;
    }

    public void setDeferralThresholdNanos(long cNanos) {
        this.__m_DeferralThresholdNanos = cNanos;
    }

    public void setDeferralThresholdReads(long cReads) {
        this.__m_DeferralThresholdReads = cReads;
    }

    public void setReadAttemptCount(long cAttempts) {
        this.__m_ReadAttemptCount = cAttempts;
    }

    public void setStatsBundled(long cBundled) {
        this.__m_StatsBundled = cBundled;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(", bundled=").append(this.getStatsBundled()).append(", average/bundle=").append(this.getBundleAverage().getDoubleAverage()).append(", stddev=").append(this.getBundleAverage().getStandardDeviation());
        return sb.toString();
    }

    static {
        BundlingQueue.__initStatic();
    }

    public static abstract class TargetQueue
    extends BalancedQueue.TargetQueue {
        private transient long __m_DeferralReadStamp;
        private transient long __m_DeferralTimeStamp;
        private int __m_HeadBundles;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Iterator", BalancedQueue.TargetQueue.Iterator.get_CLASS());
        }

        public TargetQueue(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/queue/concurrentQueue/balancedQueue/BundlingQueue$TargetQueue".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        protected boolean bundle(Object oSrc, Object oDst) {
            return false;
        }

        @Override
        public AtomicInteger getAtomicFlushState() {
            return super.getAtomicFlushState();
        }

        public long getDeferralReadStamp() {
            return this.__m_DeferralReadStamp;
        }

        public long getDeferralTimeStamp() {
            return this.__m_DeferralTimeStamp;
        }

        public int getHeadBundles() {
            return this.__m_HeadBundles;
        }

        public boolean isBundleDeferrable(Object oBundle) {
            if (this.isDeferralTimeout()) {
                return false;
            }
            BundlingQueue queueParent = (BundlingQueue)this.get_Parent();
            MovingAverage average = queueParent.getBundleAverage();
            double dAggression = queueParent.getBundlingAggression();
            int nAverage = average.getAverage();
            return (double)this.getHeadBundles() < (dAggression == 0.0 ? (double)nAverage : (double)nAverage + dAggression * average.getStandardDeviation());
        }

        public boolean isDeferralTimeout() {
            BundlingQueue queueParent = (BundlingQueue)this.get_Parent();
            long cNanosThreshold = queueParent.getDeferralThresholdNanos();
            long ldtDeferral = this.getDeferralTimeStamp();
            if (cNanosThreshold == 0L) {
                return true;
            }
            if (ldtDeferral == 0L) {
                return false;
            }
            long MILLI = 1000000L;
            long cNanos = Math.abs(System.currentTimeMillis() - this.getDeferralTimeStamp()) * 1000000L;
            long cReadAttempts = queueParent.getReadAttemptCount();
            long cReads = Math.abs(cReadAttempts - this.getDeferralReadStamp());
            long nReadThreshold = queueParent.getDeferralThresholdReads();
            if (cNanos >= cNanosThreshold + 1000000L) {
                long cReadsOptimal = cReads * cNanosThreshold / cNanos;
                if (cReadsOptimal > nReadThreshold) {
                    queueParent.setDeferralThresholdReads(cReadsOptimal);
                }
                return true;
            }
            if (nReadThreshold > 0L && cReads > nReadThreshold) {
                if (cReadAttempts % 8192L == 0L) {
                    queueParent.setDeferralThresholdReads(0L);
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object removeNoWait() {
            Object oHead;
            BundlingQueue queueParent = (BundlingQueue)this.get_Parent();
            long lReadCount = queueParent.getReadAttemptCount() + 1L;
            queueParent.setReadAttemptCount(lReadCount);
            int cPassBundles = 0;
            Object object = this.getHeadLock();
            synchronized (object) {
                Object oNext;
                oHead = super.removeNoWait();
                if (oHead == null) {
                    return null;
                }
                int cHeadBundles = this.getHeadBundles();
                if (queueParent.getBundleAverage().getAverage() > cHeadBundles + 3) {
                    oNext = super.removeNoWait();
                    while (oNext != null && this.bundle(oNext, oHead)) {
                        ++cPassBundles;
                        oNext = super.removeNoWait();
                    }
                    if (oNext != null) {
                        this.addHead(oNext);
                    }
                } else {
                    oNext = this.peekNoWait();
                    while (oNext != null && this.bundle(oNext, oHead)) {
                        super.removeNoWait();
                        ++cPassBundles;
                        oNext = this.peekNoWait();
                    }
                }
                cHeadBundles += cPassBundles;
                if (oNext == null && this.isBundleDeferrable(oHead)) {
                    if (this.getDeferralTimeStamp() == 0L) {
                        this.setDeferralTimeStamp(System.currentTimeMillis());
                        this.setDeferralReadStamp(lReadCount);
                    }
                    this.setHeadBundles(cHeadBundles);
                    this.addHead(oHead);
                    oHead = null;
                } else {
                    this.setDeferralTimeStamp(0L);
                    this.setDeferralReadStamp(0L);
                    this.setHeadBundles(0);
                    queueParent.getBundleAverage().addSample(cHeadBundles);
                }
            }
            if (cPassBundles > 0) {
                queueParent.getElementCounter().addAndGet(-cPassBundles);
                queueParent.setStatsBundled(queueParent.getStatsBundled() + (long)cPassBundles);
            }
            return oHead;
        }

        public void setDeferralReadStamp(long lReadStamp) {
            this.__m_DeferralReadStamp = lReadStamp;
        }

        protected void setDeferralTimeStamp(long ldtAddLast) {
            this.__m_DeferralTimeStamp = ldtAddLast;
        }

        public void setHeadBundles(int pHeadBundles) {
            this.__m_HeadBundles = pHeadBundles;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(super.toString());
            sb.append(", head bundles=").append(this.getHeadBundles());
            long ldtDef = this.getDeferralTimeStamp();
            if (ldtDef != 0L) {
                sb.append(", deferred=").append(System.currentTimeMillis() - ldtDef).append("ms");
            }
            return sb.toString();
        }

        static {
            TargetQueue.__initStatic();
        }
    }
}

