/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.queue.concurrentQueue;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.queue.ConcurrentQueue;
import com.tangosol.coherence.component.util.windowedArray.ConcurrentWindowedArray;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public abstract class MultiQueue
extends ConcurrentQueue {
    private AtomicLong __m_NextRemoveableIndex;
    private WindowedArray __m_WindowedArray;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Iterator", Queue.Iterator.get_CLASS());
    }

    public MultiQueue(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/queue/concurrentQueue/MultiQueue".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    public boolean add(Object oElement) {
        if (oElement == null) {
            throw new IllegalArgumentException("The MultiQueue does not support null values.");
        }
        this.getWindowedArray().add(oElement);
        this.onAddElement();
        return true;
    }

    @Override
    public boolean addHead(Object oElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void checkFlush(int cElements) {
        if (cElements == 0) {
            this.onEmpty();
        } else {
            super.checkFlush(cElements);
        }
    }

    public AtomicLong getNextRemoveableIndex() {
        return this.__m_NextRemoveableIndex;
    }

    protected WindowedArray getWindowedArray() {
        return this.__m_WindowedArray;
    }

    @Override
    public void onInit() {
        super.onInit();
        WindowedArray wa = (WindowedArray)this._findChild("WindowedArray");
        this.setWindowedArray(wa);
        this.setNextRemoveableIndex(new AtomicLong(wa.getFirstIndex()));
    }

    @Override
    public Object peekNoWait() {
        AtomicLong atomicNext;
        long lNext;
        WindowedArray wa = this.getWindowedArray();
        Object oPeek = wa.optimisticGet(lNext = (atomicNext = this.getNextRemoveableIndex()).get());
        return oPeek == null && lNext <= wa.getLastIndex() ? wa.get(atomicNext.get()) : oPeek;
    }

    @Override
    public Object remove(long cMillis) {
        return this.getNotifier() == null ? this.removeMulti(cMillis) : super.remove(cMillis);
    }

    protected Object removeMulti(long cMillis) {
        WindowedArray wa = this.getWindowedArray();
        while (true) {
            long lNext = this.getNextRemoveableIndex().getAndIncrement();
            boolean fRollback = true;
            long cWait = 0L < cMillis && cMillis < 1000L ? cMillis : 1000L;
            try {
                Object oRemoved = wa.safeRemove(lNext, cWait);
                if (oRemoved == null) {
                    boolean bl = fRollback = !wa.isRemoved(lNext);
                    if (cMillis == 0L || (cMillis -= cWait) > 0L) continue;
                    Object var10_8 = null;
                    return var10_8;
                }
                fRollback = false;
                if (this.getElementCounter().decrementAndGet() == 0) {
                    this.onEmpty();
                }
                Object object = oRemoved;
                return object;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Base.ensureRuntimeException(e);
            }
            finally {
                if (!fRollback) continue;
                this.rollbackNextIndex(lNext);
                continue;
            }
            break;
        }
    }

    @Override
    public Object removeNoWait() {
        return this.getNotifier() == null ? this.removeNoWaitMulti() : this.removeNoWaitSingle();
    }

    protected Object removeNoWaitMulti() {
        WindowedArray wa = this.getWindowedArray();
        AtomicLong atomicNext = this.getNextRemoveableIndex();
        Object oRemoved = null;
        boolean fRollback = true;
        do {
            long lNext = atomicNext.getAndIncrement();
            try {
                oRemoved = wa.safeRemove(lNext);
                if (oRemoved == null) {
                    if (lNext <= wa.getLastIndex()) {
                        oRemoved = wa.safeRemove(lNext, -1L);
                    } else {
                        Object var7_6 = null;
                        return var7_6;
                    }
                }
                fRollback = false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Base.ensureRuntimeException(e);
            }
            finally {
                if (fRollback) {
                    this.rollbackNextIndex(lNext);
                }
            }
        } while (oRemoved == null);
        if (this.getElementCounter().decrementAndGet() == 0) {
            this.onEmpty();
        }
        return oRemoved;
    }

    protected Object removeNoWaitSingle() {
        WindowedArray wa = this.getWindowedArray();
        AtomicLong atomicNext = this.getNextRemoveableIndex();
        Object oRemoved = wa.safeRemove(atomicNext.get());
        try {
            while (oRemoved == null) {
                long lFirst = atomicNext.get();
                if (lFirst > wa.getLastIndex()) {
                    return null;
                }
                oRemoved = wa.safeRemove(lFirst, -1L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Base.ensureRuntimeException(e);
        }
        atomicNext.incrementAndGet();
        if (this.getElementCounter().decrementAndGet() == 0) {
            this.onEmpty();
        }
        return oRemoved;
    }

    protected void rollbackNextIndex(long iVirtual) {
        long lCur;
        AtomicLong atomicNext = this.getNextRemoveableIndex();
        while ((lCur = atomicNext.get()) > iVirtual && !atomicNext.compareAndSet(lCur, iVirtual)) {
        }
    }

    public void setNextRemoveableIndex(AtomicLong pNextRemoveableIndex) {
        this.__m_NextRemoveableIndex = pNextRemoveableIndex;
    }

    protected void setWindowedArray(WindowedArray waElements) {
        this.__m_WindowedArray = waElements;
    }

    @Override
    public int size() {
        long iNextRemove = this.getNextRemoveableIndex().get();
        long iNextInsert = this.getWindowedArray().getLastIndex() + 1L;
        return (int)(iNextInsert - iNextRemove);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(", next=").append(this.getNextRemoveableIndex().get()).append(", storage array={").append(this.getWindowedArray()).append('}');
        return sb.toString();
    }

    static {
        MultiQueue.__initStatic();
    }

    public static abstract class WindowedArray
    extends ConcurrentWindowedArray {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("PlaceHolder", PlaceHolder.get_CLASS());
        }

        public WindowedArray(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/queue/concurrentQueue/MultiQueue$WindowedArray".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public void setStatsWaits(long cWaits) {
            super.setStatsWaits(cWaits);
        }

        static {
            WindowedArray.__initStatic();
        }

        public static class PlaceHolder
        extends ConcurrentWindowedArray.PlaceHolder {
            public PlaceHolder() {
                this(null, null, true);
            }

            public PlaceHolder(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setVirtualOffset(-1L);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new PlaceHolder();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/queue/concurrentQueue/MultiQueue$WindowedArray$PlaceHolder".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }
}

