/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.queue.concurrentQueue;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.queue.ConcurrentQueue;
import com.tangosol.util.ChainedEnumerator;
import com.tangosol.util.ListMap;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.WrapperException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class DualQueue
extends ConcurrentQueue {
    private volatile RecyclingLinkedList __m_HeadElementList;
    private transient Object __m_HeadLock;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Iterator", Queue.Iterator.get_CLASS());
    }

    public DualQueue() {
        this(null, null, true);
    }

    public DualQueue(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setBatchSize(1);
            this.setElementList(new RecyclingLinkedList());
            this.setHeadElementList(new RecyclingLinkedList());
            this.setHeadLock(new Object());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new DualQueue();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/queue/concurrentQueue/DualQueue".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addHead(Object oElement) {
        if (oElement == null) {
            throw new IllegalArgumentException("The ConcurrentQueue does not support null values.");
        }
        Object object = this.getHeadLock();
        synchronized (object) {
            this.getHeadElementList().add(0, oElement);
        }
        this.onAddElement();
        return true;
    }

    protected RecyclingLinkedList getHeadElementList() {
        return this.__m_HeadElementList;
    }

    protected Object getHeadLock() {
        return this.__m_HeadLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator iterator() {
        SimpleEnumerator<Object> iterTail;
        Object[] aoHead = null;
        Object[] aoTail = null;
        Object object = this.getHeadLock();
        synchronized (object) {
            RecyclingLinkedList listHead = this.getHeadElementList();
            RecyclingLinkedList listTail = this.getElementList();
            if (!listHead.isEmpty()) {
                aoHead = listHead.toArray();
            }
            if (!listTail.isEmpty()) {
                aoTail = listTail.toArray();
            }
        }
        SimpleEnumerator<Object> iterHead = aoHead == null ? null : new SimpleEnumerator<Object>(aoHead);
        SimpleEnumerator<Object> simpleEnumerator = iterTail = aoTail == null ? null : new SimpleEnumerator<Object>(aoTail);
        return iterHead == null ? (iterTail == null ? NullImplementation.getIterator() : iterTail) : (iterTail == null ? iterHead : new ChainedEnumerator(iterHead, iterTail));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object peekNoWait() {
        if (this.isEmpty()) {
            return null;
        }
        Object object = this.getHeadLock();
        synchronized (object) {
            RecyclingLinkedList listHead = this.getHeadElementList();
            if (listHead.isEmpty()) {
                if (!this.swapNoWait()) {
                    return null;
                }
                listHead = this.getHeadElementList();
            }
            return listHead.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object removeNoWait() {
        Object oEntry;
        AtomicInteger counter = this.getElementCounter();
        if (counter.get() == 0) {
            return null;
        }
        Object object = this.getHeadLock();
        synchronized (object) {
            RecyclingLinkedList listHead = this.getHeadElementList();
            if (listHead.isEmpty()) {
                if (!this.swapNoWait()) {
                    return null;
                }
                listHead = this.getHeadElementList();
            }
            oEntry = listHead.remove(0);
        }
        if (counter.decrementAndGet() == 0) {
            this.onEmpty();
        }
        return oEntry;
    }

    protected void setHeadElementList(RecyclingLinkedList listHead) {
        this.__m_HeadElementList = listHead;
    }

    protected void setHeadLock(Object oLock) {
        this.__m_HeadLock = oLock;
    }

    protected boolean swapNoWait() {
        RecyclingLinkedList listTail;
        RecyclingLinkedList listHead = this.getHeadElementList();
        if (listHead.isEmpty() && !(listTail = this.getElementList()).isEmpty()) {
            this.setElementList(listHead);
            this.setHeadElementList(listTail);
            return true;
        }
        return false;
    }

    static {
        DualQueue.__initStatic();
    }
}

