/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.queue.concurrentQueue;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.queue.ConcurrentQueue;
import com.tangosol.coherence.component.util.queue.concurrentQueue.DualQueue;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.WrapperException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BalancedQueue
extends ConcurrentQueue {
    private volatile Map.Entry[] __m_Entries;
    private int __m_EntryIndex;
    private static transient Object[] __s_LockArray;
    private Map __m_TargetMap;
    private static ListMap __mapChildren;

    private static void _initStatic$Default() {
        BalancedQueue.__initStatic();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Iterator", Queue.Iterator.get_CLASS());
        __mapChildren.put("TargetQueue", TargetQueue.get_CLASS());
    }

    public BalancedQueue(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/queue/concurrentQueue/BalancedQueue".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Object oElement) {
        Object object = this.getLock(this.getTarget(oElement));
        synchronized (object) {
            this.ensureTargetQueue(oElement).add(oElement);
        }
        this.onAddElement();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addHead(Object oElement) {
        Object object = this.getLock(this.getTarget(oElement));
        synchronized (object) {
            this.ensureTargetQueue(oElement).addHead(oElement);
        }
        this.onAddElement();
        return true;
    }

    protected Queue ensureTargetQueue(Object oElement) {
        Object oTarget = this.getTarget(oElement);
        Map map = this.getTargetMap();
        Queue queue = (Queue)map.get(oTarget);
        if (queue == null) {
            queue = this.instantiateTargetQueue();
            map.put(oTarget, queue);
            this.refreshEntries();
        }
        return queue;
    }

    public Map.Entry getCurrentEntry() {
        int cEntries;
        Map.Entry[] aEntry = this.getEntries();
        int n = cEntries = aEntry == null ? -1 : aEntry.length;
        if (cEntries > 0) {
            return aEntry[this.getEntryIndex() % cEntries];
        }
        return null;
    }

    public Map.Entry[] getEntries() {
        return this.__m_Entries;
    }

    public int getEntryIndex() {
        return this.__m_EntryIndex;
    }

    protected Object getLock(Object oTarget) {
        Object[] aoLock = BalancedQueue.getLockArray();
        int nHash = oTarget == null ? 0 : Integer.MAX_VALUE & oTarget.hashCode();
        return aoLock[nHash % aoLock.length];
    }

    public static Object[] getLockArray() {
        return __s_LockArray;
    }

    public Object getTarget(Object oElement) {
        return null;
    }

    public int getTargetCount() {
        return this.getTargetMap().size();
    }

    protected Map getTargetMap() {
        return this.__m_TargetMap;
    }

    protected Queue instantiateTargetQueue() {
        return new TargetQueue();
    }

    protected Map.Entry nextEntry() {
        Map.Entry entryCurrent = this.getCurrentEntry();
        int iEntry = this.getEntryIndex();
        if (++iEntry < 0 || entryCurrent == null) {
            iEntry = 0;
        }
        this.setEntryIndex(iEntry);
        return entryCurrent;
    }

    public void onEmptyTarget(Object oTarget, Queue queueTarget) {
        if (Base.getRandom().nextInt(1000) == 0 && this.getTargetMap().size() > 1) {
            this.safeRemoveTargetQueue(oTarget);
        }
    }

    @Override
    public Object peekNoWait() {
        Map.Entry entry = this.getCurrentEntry();
        while (!this.isEmpty()) {
            Queue queue;
            Object oPeek;
            if (entry != null && (oPeek = (queue = (Queue)entry.getValue()).peekNoWait()) != null) {
                return oPeek;
            }
            entry = this.nextEntry();
        }
        return null;
    }

    protected synchronized Map.Entry[] refreshEntries() {
        Set setEntry = this.getTargetMap().entrySet();
        Map.Entry[] aEntry = this.getEntries();
        if (aEntry == null) {
            aEntry = new Map.Entry[setEntry.size()];
        }
        aEntry = setEntry.toArray(aEntry);
        this.setEntries(aEntry);
        return aEntry;
    }

    @Override
    public Object removeNoWait() {
        Map map = this.getTargetMap();
        AtomicInteger counter = this.getElementCounter();
        while (counter.get() > 0) {
            Map.Entry entry = this.nextEntry();
            if (entry == null) continue;
            Queue queue = (Queue)entry.getValue();
            Object oRemoved = queue.removeNoWait();
            if (oRemoved == null) {
                this.onEmptyTarget(entry.getKey(), queue);
                continue;
            }
            if (counter.decrementAndGet() == 0) {
                this.onEmpty();
            }
            return oRemoved;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void safeRemoveTargetQueue(Object oTarget) {
        boolean fRemoved = false;
        Object object = this.getLock(oTarget);
        synchronized (object) {
            Map mapTarget = this.getTargetMap();
            Queue queueTarget = (Queue)mapTarget.get(oTarget);
            if (queueTarget != null && queueTarget.isEmpty()) {
                mapTarget.remove(oTarget);
                fRemoved = true;
            }
        }
        if (fRemoved) {
            this.refreshEntries();
        }
    }

    protected void setEntries(Map.Entry[] cEntries) {
        this.__m_Entries = cEntries;
    }

    protected void setEntryIndex(int i) {
        this.__m_EntryIndex = i;
    }

    public static void setLockArray(Object[] aoArray) {
        __s_LockArray = aoArray;
    }

    protected void setTargetMap(Map mapTarget) {
        this.__m_TargetMap = mapTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Map map;
        StringBuilder sb = new StringBuilder(super.toString());
        Map map2 = map = this.getTargetMap();
        synchronized (map2) {
            for (Map.Entry entry : map.entrySet()) {
                sb.append(", target[").append(entry.getKey()).append("]={").append(entry.getValue()).append('}');
            }
        }
        return sb.toString();
    }

    static {
        BalancedQueue._initStatic$Default();
        int c = Math.max(17, Runtime.getRuntime().availableProcessors());
        Object[] ao = new Object[c];
        for (int i = 0; i < c; ++i) {
            ao[i] = new Object();
        }
        BalancedQueue.setLockArray(ao);
    }

    public static class TargetQueue
    extends DualQueue {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Iterator", Iterator.get_CLASS());
        }

        public TargetQueue() {
            this(null, null, true);
        }

        public TargetQueue(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setElementList(new RecyclingLinkedList());
                this.setHeadElementList(new RecyclingLinkedList());
                this.setHeadLock(new Object());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new TargetQueue();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/queue/concurrentQueue/BalancedQueue$TargetQueue".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Object getHeadLock() {
            return super.getHeadLock();
        }

        @Override
        protected void onAddElement() {
            this.getElementCounter().incrementAndGet();
        }

        @Override
        public Object remove() {
            throw new UnsupportedOperationException();
        }

        static {
            TargetQueue.__initStatic();
        }

        public static class Iterator
        extends Queue.Iterator {
            public Iterator() {
                this(null, null, true);
            }

            public Iterator(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Iterator();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/queue/concurrentQueue/BalancedQueue$TargetQueue$Iterator".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }
}

