/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.queue;

import com.oracle.coherence.common.base.Notifier;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.util.ListMap;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.WrapperException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ConcurrentQueue
extends Queue {
    private transient AtomicInteger __m_AtomicFlushState;
    private transient int __m_BatchSize;
    private AtomicInteger __m_ElementCounter;
    public static final int FLUSH_AUTO = 1;
    public static final int FLUSH_EXPLICIT = 2;
    public static final int FLUSH_PENDING = 0;
    private Notifier __m_Notifier;
    private long __m_StatsEmptied;
    private long __m_StatsFlushed;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Iterator", Queue.Iterator.get_CLASS());
    }

    public ConcurrentQueue() {
        this(null, null, true);
    }

    public ConcurrentQueue(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setBatchSize(1);
            this.setElementList(new RecyclingLinkedList());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new ConcurrentQueue();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/queue/ConcurrentQueue".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    public boolean add(Object oElement) {
        if (oElement == null) {
            throw new IllegalArgumentException("The ConcurrentQueue does not support null values.");
        }
        this.getElementList().add(oElement);
        this.onAddElement();
        return true;
    }

    @Override
    public boolean addHead(Object oElement) {
        if (oElement == null) {
            throw new IllegalArgumentException("The ConcurrentQueue does not support null values.");
        }
        this.getElementList().add(0, oElement);
        this.onAddElement();
        return true;
    }

    @Override
    public void await(long cMillis) throws InterruptedException {
        Notifier notifier = this.getNotifier();
        if (notifier == null) {
            throw new UnsupportedOperationException("blocking remove without a notifier");
        }
        if (!this.isAvailable()) {
            if (notifier == this) {
                super.await(cMillis);
            } else {
                notifier.await(cMillis);
            }
        }
    }

    protected void checkFlush(int cElements) {
        if (this.getNotifier() != null) {
            int nFlushState;
            if (cElements == 1) {
                nFlushState = 0;
                this.updateFlushState(nFlushState);
            } else {
                nFlushState = this.getFlushState();
            }
            switch (nFlushState) {
                case 0: {
                    if (cElements % this.getBatchSize() != 0) break;
                    this.flush(true);
                    break;
                }
                case 2: {
                    this.updateFlushStateConditionally(2, 1);
                    break;
                }
            }
        }
    }

    @Override
    public void flush() {
        this.flush(false);
    }

    protected void flush(boolean fAuto) {
        if (this.updateFlushState(fAuto ? 1 : 2) == 0) {
            this.setStatsFlushed(this.getStatsFlushed() + 1L);
            this.signal();
        }
    }

    protected AtomicInteger getAtomicFlushState() {
        return this.__m_AtomicFlushState;
    }

    public int getBatchSize() {
        return this.__m_BatchSize;
    }

    public AtomicInteger getElementCounter() {
        return this.__m_ElementCounter;
    }

    public int getFlushState() {
        return this.getAtomicFlushState().get();
    }

    public Notifier getNotifier() {
        return this.__m_Notifier;
    }

    public long getStatsEmptied() {
        return this.__m_StatsEmptied;
    }

    public long getStatsFlushed() {
        return this.__m_StatsFlushed;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isFlushPending() {
        return this.getFlushState() == 0;
    }

    @Override
    public Iterator iterator() {
        throw new UnsupportedOperationException();
    }

    protected void onAddElement() {
        this.checkFlush(this.getElementCounter().incrementAndGet());
    }

    protected void onEmpty() {
        this.setStatsEmptied(this.getStatsEmptied() + 1L);
    }

    @Override
    public void onInit() {
        this.setElementCounter(new AtomicInteger());
        this.setAtomicFlushState(new AtomicInteger(0));
        this.setNotifier(this);
        super.onInit();
    }

    @Override
    public Object removeNoWait() {
        AtomicInteger counter = this.getElementCounter();
        if (counter.get() == 0) {
            return null;
        }
        Object oEntry = this.getElementList().removeFirst();
        if (oEntry != null && counter.decrementAndGet() == 0) {
            this.onEmpty();
        }
        return oEntry;
    }

    protected void setAtomicFlushState(AtomicInteger atomicState) {
        ConcurrentQueue._assert(this.getAtomicFlushState() == null);
        this.__m_AtomicFlushState = atomicState;
    }

    public void setBatchSize(int cBatch) {
        if (cBatch > 0) {
            this.__m_BatchSize = cBatch;
        }
    }

    protected void setElementCounter(AtomicInteger counter) {
        this.__m_ElementCounter = counter;
    }

    public void setNotifier(Notifier notifier) {
        this.__m_Notifier = notifier;
    }

    protected void setStatsEmptied(long cEmptied) {
        this.__m_StatsEmptied = cEmptied;
    }

    protected void setStatsFlushed(long cFlush) {
        this.__m_StatsFlushed = cFlush;
    }

    @Override
    public void signal() {
        Notifier notifier = this.getNotifier();
        if (notifier == this) {
            super.signal();
        } else if (notifier != null) {
            notifier.signal();
        }
    }

    @Override
    public int size() {
        return this.getElementCounter().get();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.get_Name()).append(" size=").append(this.size()).append(", emptied=").append(this.getStatsEmptied()).append(", flushed=").append(this.getStatsFlushed()).append(", first=").append(this.peekNoWait());
        return sb.toString();
    }

    protected int updateFlushState(int nState) {
        return this.getAtomicFlushState().getAndSet(nState);
    }

    protected boolean updateFlushStateConditionally(int nStateAssumed, int nStateNew) {
        return this.getAtomicFlushState().compareAndSet(nStateAssumed, nStateNew);
    }

    static {
        ConcurrentQueue.__initStatic();
    }
}

