/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.deltaMap.transactionMap;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.deltaMap.TransactionMap;
import com.tangosol.coherence.config.Config;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.LiteSet;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;

public abstract class Pessimistic
extends TransactionMap {
    private boolean __m_ValidateLocks;

    public Pessimistic(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/deltaMap/transactionMap/Pessimistic".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected void enlist(Object oKey, boolean fWrite) {
        LiteSet setLock;
        if (fWrite && !(setLock = this.getBaseLockSet()).contains(oKey)) {
            if (this.getBaseMap().lock(oKey, this.getLockWaitMillis())) {
                setLock.add(oKey);
            } else {
                throw new ConcurrentModificationException("Failed to lock: key=" + String.valueOf(oKey));
            }
        }
    }

    @Override
    protected void enlistAll(boolean fWrite) {
        if (fWrite) {
            ConcurrentMap mapBase = this.getBaseMap();
            LiteSet setLock = this.getBaseLockSet();
            ArrayList listLocked = new ArrayList();
            Object oKeyFailed = null;
            for (Object oKey : this.keySetImpl()) {
                if (setLock.contains(oKey)) continue;
                if (mapBase.lock(oKey, this.getLockWaitMillis())) {
                    listLocked.add(oKey);
                    continue;
                }
                oKeyFailed = oKey;
                break;
            }
            if (oKeyFailed != null) {
                for (Object oKey : listLocked) {
                    mapBase.unlock(oKey);
                }
                throw new ConcurrentModificationException("Failed to lock: key=" + String.valueOf(oKeyFailed));
            }
            setLock.addAll(listLocked);
        }
    }

    protected boolean isValidateLocks() {
        return this.__m_ValidateLocks;
    }

    @Override
    public void onInit() {
        this.setValidateLocks(Config.getBoolean("coherence.transaction.pessimistic.validatelocks"));
        super.onInit();
    }

    @Override
    public void prepare() {
        super.prepare();
        boolean fValidateLocks = this.isValidateLocks();
        if (fValidateLocks) {
            ConcurrentMap mapBase = this.getBaseMap();
            LiteSet setLock = this.getBaseLockSet();
            for (Object oKey : setLock) {
                if (mapBase.lock(oKey)) continue;
                throw new ConcurrentModificationException("Lock has expired: key=" + String.valueOf(oKey));
            }
        }
    }

    protected void setValidateLocks(boolean fValidate) {
        this.__m_ValidateLocks = fValidate;
    }
}

