/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.deltaMap.transactionMap;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.deltaMap.TransactionMap;
import com.tangosol.util.ChainedEnumerator;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.LiteSet;
import com.tangosol.util.TransactionMap;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class Optimistic
extends TransactionMap {
    private boolean __m_LockExternal;

    public Optimistic(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/deltaMap/transactionMap/Optimistic".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected void enlist(Object oKey, boolean fWrite) {
        TransactionMap.Validator validator;
        if (fWrite && !this.isModified(oKey) && (validator = this.getValidator()) != null) {
            validator.enlist(this, oKey);
        }
        super.enlist(oKey, fWrite);
    }

    @Override
    protected void enlistAll(boolean fWrite) {
        TransactionMap.Validator validator;
        if (!this.isFullyRead() && (validator = this.getValidator()) != null) {
            Map mapOrig = this.getOriginalMap();
            Iterator iter = mapOrig.keySet().iterator();
            while (iter.hasNext()) {
                this.enlist(iter.next(), fWrite);
            }
        }
        super.enlistAll(fWrite);
    }

    public boolean isLockExternal() {
        return this.__m_LockExternal;
    }

    @Override
    public void prepare() {
        TransactionMap.Validator validator;
        super.prepare();
        ConcurrentMap mapBase = this.getBaseMap();
        Set setInsert = this.getInsertKeySet();
        Set setUpdate = this.getUpdateKeySet();
        Set setDelete = this.getDeleteKeySet();
        Set setRead = this.getReadKeySet();
        Set setFanthom = Collections.EMPTY_SET;
        if (!this.isLockExternal()) {
            LiteSet setLock = this.getBaseLockSet();
            Object oKeyFailed = null;
            ChainedEnumerator iter = new ChainedEnumerator(new Iterator[]{setInsert.iterator(), setUpdate.iterator(), setDelete.iterator(), setRead.iterator()});
            long cWaitMillis = this.getLockWaitMillis();
            while (iter.hasNext()) {
                Object oKey = iter.next();
                if (setLock.contains(oKey)) continue;
                if (mapBase.lock(oKey, cWaitMillis)) {
                    setLock.add(oKey);
                    continue;
                }
                oKeyFailed = oKey;
                break;
            }
            if (oKeyFailed != null) {
                this.rollback();
                throw new ConcurrentModificationException("Failed to lock during prepare: key=" + String.valueOf(oKeyFailed));
            }
        }
        if ((validator = this.getValidator()) != null) {
            try {
                validator.validate(this, setInsert, setUpdate, setDelete, setRead, setFanthom);
            }
            catch (RuntimeException e) {
                this.rollback();
                throw e;
            }
        }
    }

    public void setLockExternal(boolean fExternal) {
        this.__m_LockExternal = fExternal;
    }
}

