/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.initiator;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.oracle.coherence.common.net.InetSocketAddress32;
import com.oracle.coherence.common.net.SocketProvider;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.util.TcpUtil;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.daemon.QueueProcessor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Initiator;
import com.tangosol.coherence.config.builder.FactoryBasedAddressProviderBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.internal.net.service.DefaultServiceDependencies;
import com.tangosol.internal.net.service.peer.initiator.DefaultTcpInitiatorDependencies;
import com.tangosol.internal.net.service.peer.initiator.LegacyXmlTcpInitiatorHelper;
import com.tangosol.internal.net.service.peer.initiator.TcpInitiatorDependencies;
import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.AddressProviderFactory;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.SocketAddressProvider;
import com.tangosol.net.SocketOptions;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.net.messaging.Connection;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.SparseArray;
import com.tangosol.util.WrapperException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class TcpInitiator
extends Initiator {
    private SocketAddress __m_LocalAddress;
    private SocketAddressProvider __m_RemoteAddressProvider;
    private transient SocketOptions __m_SocketOptions;
    private SocketProvider __m_SocketProvider;
    private SocketProviderFactory __m_SocketProviderFactory;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("DispatchEvent", Peer.DispatchEvent.get_CLASS());
        __mapChildren.put("MessageFactory", MessageFactory.get_CLASS());
        __mapChildren.put("Queue", QueueProcessor.Queue.get_CLASS());
        __mapChildren.put("TcpConnection", TcpConnection.get_CLASS());
    }

    public TcpInitiator() {
        this(null, null, true);
    }

    public TcpInitiator(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setCloseOnExit(new SafeHashSet());
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setProtocolMap(new HashMap());
            this.setReceiverMap(new HashMap());
            this.setRequestTimeout(30000L);
            this.setSerializerMap(new WeakHashMap());
            this.setSocketOptions(new SocketOptions());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Peer.DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Service.EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Daemon.Guard("Guard", this, true), "Guard");
        this._addChild(new Peer.Protocol("Protocol", this, true), "Protocol");
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new TcpInitiator();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/initiator/TcpInitiator".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    protected DefaultServiceDependencies cloneDependencies(ServiceDependencies deps) {
        return new DefaultTcpInitiatorDependencies((TcpInitiatorDependencies)deps);
    }

    @Override
    public synchronized void configure(XmlElement xml) {
        this.setDependencies(LegacyXmlTcpInitiatorHelper.fromXml(xml, new DefaultTcpInitiatorDependencies(), this.getOperationalContext(), this.getContextClassLoader()));
        this.setServiceConfig(xml);
    }

    protected void configureSocket(Socket socket) {
        try {
            this.getSocketOptions().apply(socket);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "error configuring Socket");
        }
        SocketAddress addr = this.getLocalAddress();
        if (addr != null) {
            TcpInitiator._trace("Binding Socket to " + TcpUtil.toString(addr), 6);
            try {
                socket.bind(addr);
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e, "error binding Socket to " + TcpUtil.toString(addr));
            }
            if (!socket.isBound()) {
                throw new RuntimeException("could not bind Socket to " + TcpUtil.toString(addr));
            }
        }
    }

    @Override
    public String getDescription() {
        StringBuffer sb = new StringBuffer(super.getDescription());
        sb.append(", SocketProvider=").append(this.getSocketProvider());
        SocketAddress addr = this.getLocalAddress();
        if (addr != null) {
            sb.append(", LocalAddress=").append(TcpUtil.toString(addr));
        }
        sb.append(", RemoteAddresses=").append(this.getRemoteAddressProvider());
        SocketOptions options = this.getSocketOptions();
        if (options != null) {
            sb.append(", ").append(options);
        }
        return sb.toString();
    }

    public SocketAddress getLocalAddress() {
        return this.__m_LocalAddress;
    }

    public SocketAddressProvider getRemoteAddressProvider() {
        return this.__m_RemoteAddressProvider;
    }

    public SocketOptions getSocketOptions() {
        return this.__m_SocketOptions;
    }

    public SocketProvider getSocketProvider() {
        return this.__m_SocketProvider;
    }

    public SocketProviderFactory getSocketProviderFactory() {
        SocketProviderFactory factory = this.__m_SocketProviderFactory;
        if (factory == null) {
            OperationalContext ctx = this.getOperationalContext();
            factory = ctx == null ? new SocketProviderFactory() : ctx.getSocketProviderFactory();
            this.setSocketProviderFactory(factory);
        }
        return factory;
    }

    @Override
    protected com.tangosol.coherence.component.net.extend.Connection instantiateConnection() {
        TcpConnection connection = (TcpConnection)this._newChild("TcpConnection");
        connection.setConnectionManager(this);
        connection.setRequestSendTimeout(this.getRequestSendTimeout());
        return connection;
    }

    public Socket instantiateSocket() {
        Socket socket;
        try {
            socket = this.getSocketProvider().openSocket();
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e, "error creating Socket");
        }
        this.configureSocket(socket);
        return socket;
    }

    @Override
    protected void onDependencies(ServiceDependencies deps) {
        AddressProviderFactory factory;
        super.onDependencies(deps);
        TcpInitiatorDependencies tcpDeps = (TcpInitiatorDependencies)deps;
        SocketAddress addrLocal = tcpDeps.getLocalAddress();
        if (addrLocal instanceof InetSocketAddress) {
            InetSocketAddress addrLocalInet = (InetSocketAddress)addrLocal;
            addrLocal = new InetSocketAddress32(addrLocalInet.getAddress(), addrLocalInet.getPort());
        }
        this.setLocalAddress(addrLocal);
        this.setSocketOptions(tcpDeps.getSocketOptions());
        this.setSocketProvider(tcpDeps.getSocketProviderBuilder().realize(null, null, null));
        ParameterizedBuilder bldr = tcpDeps.getRemoteAddressProviderBuilder();
        if (bldr == null && (factory = this.getOperationalContext().getAddressProviderMap().get("cluster-discovery")) != null) {
            bldr = factory instanceof ParameterizedBuilder ? (ParameterizedBuilder)((Object)factory) : new FactoryBasedAddressProviderBuilder(factory);
        }
        if (bldr != null) {
            this.setRemoteAddressProvider(bldr.realize(new NullParameterResolver(), this.getContextClassLoader(), null));
        }
    }

    @Override
    public void onInit() {
        super.onInit();
        try {
            SocketOptions options = this.getSocketOptions();
            options.setOption(8, Boolean.TRUE);
            options.setOption(1, Boolean.TRUE);
            options.setOption(128, 0);
        }
        catch (SocketException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected com.tangosol.coherence.component.net.extend.Connection openConnection() {
        Exception cause;
        LinkedList<String> listAddr;
        block14: {
            TcpConnection connection;
            SocketAddressProvider provider = this.getRemoteAddressProvider();
            TcpInitiator._assert(provider != null);
            int cMillis = Math.max(0, (int)this.getConnectTimeout());
            listAddr = new LinkedList<String>();
            Iterator iterRedirect = null;
            cause = null;
            while (true) {
                SocketAddress addr;
                connection = (TcpConnection)this.instantiateConnection();
                if (iterRedirect == null || !iterRedirect.hasNext()) {
                    addr = provider.getNextAddress();
                    iterRedirect = null;
                } else {
                    addr = (SocketAddress)iterRedirect.next();
                    connection.setRedirect(true);
                }
                if (addr == null) break block14;
                if (((InetSocketAddress32)addr).getAddress().isMulticastAddress()) continue;
                String sAddr = TcpUtil.toString(addr);
                listAddr.add(sAddr);
                Socket socket = this.instantiateSocket();
                SafeHashSet setClose = this.getCloseOnExit();
                setClose.add(socket);
                try {
                    if (iterRedirect == null) {
                        TcpInitiator._trace("Connecting Socket to " + sAddr, 6);
                    } else {
                        TcpInitiator._trace("Redirecting Socket to " + sAddr, 6);
                    }
                    Blocking.connect(socket, addr, cMillis);
                    connection.setSocket(socket);
                }
                catch (Exception e) {
                    TcpInitiator._trace("Error connecting Socket to " + sAddr + ": " + String.valueOf(e), 6);
                    TcpUtil.close(socket);
                    if (iterRedirect != null && iterRedirect.hasNext()) continue;
                    provider.reject(e);
                    continue;
                }
                finally {
                    setClose.remove(socket);
                    continue;
                }
                try {
                    connection.open();
                }
                catch (Exception e) {
                    if (iterRedirect == null && connection.isRedirect()) {
                        List list = connection.getRedirectList();
                        ArrayList<InetSocketAddress32> listRedirect = new ArrayList<InetSocketAddress32>(list.size());
                        for (Object[] ao : list) {
                            String s = (String)ao[0];
                            int n = (Integer)ao[1];
                            listRedirect.add(new InetSocketAddress32(s, n));
                        }
                        iterRedirect = listRedirect.iterator();
                        continue;
                    }
                    cause = e;
                    TcpInitiator._trace("Error establishing a connection with " + sAddr + ": " + String.valueOf(e), 6);
                    if (iterRedirect != null && iterRedirect.hasNext()) continue;
                    provider.reject(e);
                    continue;
                }
                break;
            }
            provider.accept();
            return connection;
        }
        String sMessage = "could not establish a connection to one of the following addresses: " + String.valueOf(listAddr);
        throw cause == null ? new ConnectionException(sMessage) : new ConnectionException(sMessage, cause);
    }

    protected void setLocalAddress(SocketAddress addr) {
        this.__m_LocalAddress = addr;
    }

    public void setRemoteAddressProvider(SocketAddressProvider provider) {
        this.__m_RemoteAddressProvider = provider;
    }

    protected void setSocketOptions(SocketOptions options) {
        TcpInitiator._assert(options != null);
        this.__m_SocketOptions = options;
    }

    public void setSocketProvider(SocketProvider pSocketProvider) {
        this.__m_SocketProvider = pSocketProvider;
    }

    public void setSocketProviderFactory(SocketProviderFactory factory) {
        this.__m_SocketProviderFactory = factory;
    }

    static {
        TcpInitiator.__initStatic();
    }

    public static class MessageFactory
    extends Initiator.MessageFactory {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("AcceptChannel", Peer.MessageFactory.AcceptChannel.get_CLASS());
            __mapChildren.put("AcceptChannelRequest", Peer.MessageFactory.AcceptChannelRequest.get_CLASS());
            __mapChildren.put("AcceptChannelResponse", Peer.MessageFactory.AcceptChannelResponse.get_CLASS());
            __mapChildren.put("CloseChannel", Peer.MessageFactory.CloseChannel.get_CLASS());
            __mapChildren.put("CloseConnection", Peer.MessageFactory.CloseConnection.get_CLASS());
            __mapChildren.put("CreateChannel", Peer.MessageFactory.CreateChannel.get_CLASS());
            __mapChildren.put("EncodedMessage", Peer.MessageFactory.EncodedMessage.get_CLASS());
            __mapChildren.put("NotifyChannelClosed", Peer.MessageFactory.NotifyChannelClosed.get_CLASS());
            __mapChildren.put("NotifyConnectionClosed", Peer.MessageFactory.NotifyConnectionClosed.get_CLASS());
            __mapChildren.put("NotifyShutdown", Peer.MessageFactory.NotifyShutdown.get_CLASS());
            __mapChildren.put("NotifyStartup", Peer.MessageFactory.NotifyStartup.get_CLASS());
            __mapChildren.put("OpenChannel", Peer.MessageFactory.OpenChannel.get_CLASS());
            __mapChildren.put("OpenChannelRequest", Peer.MessageFactory.OpenChannelRequest.get_CLASS());
            __mapChildren.put("OpenChannelResponse", Peer.MessageFactory.OpenChannelResponse.get_CLASS());
            __mapChildren.put("OpenConnection", Initiator.MessageFactory.OpenConnection.get_CLASS());
            __mapChildren.put("OpenConnectionRequest", OpenConnectionRequest.get_CLASS());
            __mapChildren.put("OpenConnectionResponse", OpenConnectionResponse.get_CLASS());
            __mapChildren.put("PingRequest", Peer.MessageFactory.PingRequest.get_CLASS());
            __mapChildren.put("PingResponse", Peer.MessageFactory.PingResponse.get_CLASS());
            __mapChildren.put("Response", Peer.MessageFactory.Response.get_CLASS());
        }

        public MessageFactory() {
            this(null, null, true);
        }

        public MessageFactory(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MessageFactory();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/initiator/TcpInitiator$MessageFactory".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        static {
            MessageFactory.__initStatic();
        }

        public static class OpenConnectionRequest
        extends Initiator.MessageFactory.OpenConnectionRequest {
            private boolean __m_Redirect;
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Status", Peer.MessageFactory.OpenConnectionRequest.Status.get_CLASS());
            }

            public OpenConnectionRequest() {
                this(null, null, true);
            }

            public OpenConnectionRequest(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new OpenConnectionRequest();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/initiator/TcpInitiator$MessageFactory$OpenConnectionRequest".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            @Override
            protected String getDescription() {
                return super.getDescription() + ", RedirectSupported=" + this.isRedirectSupported() + ", Redirect=" + this.isRedirect();
            }

            public boolean isRedirect() {
                return this.__m_Redirect;
            }

            public boolean isRedirectSupported() {
                return true;
            }

            @Override
            public void readExternal(PofReader in) throws IOException {
                super.readExternal(in);
                if (in.readBoolean(10)) {
                    this.setRedirect(in.readBoolean(11));
                }
            }

            @Override
            public void setConnectionOpen(com.tangosol.coherence.component.net.extend.Connection connection) {
                this.setRedirect(((TcpConnection)connection).isRedirect());
                super.setConnectionOpen(connection);
            }

            public void setRedirect(boolean f) {
                this.__m_Redirect = f;
            }

            @Override
            public void writeExternal(PofWriter out) throws IOException {
                super.writeExternal(out);
                out.writeBoolean(10, this.isRedirectSupported());
                out.writeBoolean(11, this.isRedirect());
            }

            static {
                OpenConnectionRequest.__initStatic();
            }
        }

        public static class OpenConnectionResponse
        extends Initiator.MessageFactory.OpenConnectionResponse {
            private boolean __m_Redirect;
            private List __m_RedirectList;

            public OpenConnectionResponse() {
                this(null, null, true);
            }

            public OpenConnectionResponse(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new OpenConnectionResponse();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/initiator/TcpInitiator$MessageFactory$OpenConnectionResponse".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected String getDescription() {
                return super.getDescription() + ", Redirect=" + this.isRedirect() + ", RedirectList=" + String.valueOf(this.getRedirectList());
            }

            public List getRedirectList() {
                return this.__m_RedirectList;
            }

            public boolean isRedirect() {
                return this.__m_Redirect;
            }

            @Override
            public void readExternal(PofReader in) throws IOException {
                super.readExternal(in);
                this.setRedirect(in.readBoolean(10));
                if (this.isRedirect()) {
                    this.setRedirectList(in.readCollection(11, new ArrayList()));
                }
            }

            @Override
            public void run() {
                TcpConnection connection = (TcpConnection)this.getChannel().getConnection();
                connection.setRedirect(this.isRedirect());
                connection.setRedirectList(this.getRedirectList());
                super.run();
            }

            public void setRedirect(boolean f) {
                this.__m_Redirect = f;
            }

            public void setRedirectList(List list) {
                this.__m_RedirectList = list;
            }

            @Override
            public void writeExternal(PofWriter out) throws IOException {
                super.writeExternal(out);
                out.writeBoolean(10, this.isRedirect());
                if (this.isRedirect()) {
                    out.writeCollection(11, this.getRedirectList());
                }
            }
        }
    }

    public static class TcpConnection
    extends com.tangosol.coherence.component.net.extend.connection.TcpConnection {
        private DataInputStream __m_DataInputStream;
        private DataOutputStream __m_DataOutputStream;
        private transient ReentrantLock __m_DataOutputStreamLock;
        private TcpReader __m_Reader;
        private boolean __m_Redirect;
        private List __m_RedirectList;
        private long __m_RequestSendTimeout;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("TcpReader", TcpReader.get_CLASS());
        }

        public TcpConnection() {
            this(null, null, true);
        }

        public TcpConnection(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setChannelArray(new SparseArray());
                this.setChannelPendingArray(new SparseArray());
                this.setDataOutputStreamLock(new ReentrantLock());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new TcpConnection();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/initiator/TcpInitiator$TcpConnection".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public boolean closeInternal(boolean fNotify, Throwable e, long cMillis) {
            if (super.closeInternal(fNotify, e, cMillis)) {
                DataOutputStream out;
                DataInputStream in;
                TcpReader reader = this.getReader();
                if (reader != null) {
                    reader.stop();
                    this.setReader(null);
                }
                if ((in = this.getDataInputStream()) != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.setDataInputStream(null);
                }
                if ((out = this.getDataOutputStream()) != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.setDataOutputStream(null);
                }
                TcpUtil.close(this.getSocket());
                return true;
            }
            return false;
        }

        public DataInputStream getDataInputStream() {
            return this.__m_DataInputStream;
        }

        public DataOutputStream getDataOutputStream() {
            return this.__m_DataOutputStream;
        }

        public ReentrantLock getDataOutputStreamLock() {
            return this.__m_DataOutputStreamLock;
        }

        public TcpReader getReader() {
            return this.__m_Reader;
        }

        public List getRedirectList() {
            return this.__m_RedirectList;
        }

        public long getRequestSendTimeout() {
            return this.__m_RequestSendTimeout;
        }

        public boolean isRedirect() {
            return this.__m_Redirect;
        }

        @Override
        public void openInternal() {
            super.openInternal();
            Socket socket = this.getSocket();
            TcpConnection._assert(socket != null);
            try {
                this.setDataInputStream(new DataInputStream(new BufferedInputStream(socket.getInputStream(), 5)));
                this.setDataOutputStream(new DataOutputStream(new BufferedOutputStream(socket.getOutputStream(), 5)));
            }
            catch (IOException e) {
                this.closeInternal(false, e, -1L);
                throw TcpConnection.ensureRuntimeException(e, "error opening connection");
            }
            TcpReader reader = (TcpReader)this._newChild("TcpReader");
            reader.start();
            this.setReader(reader);
        }

        @Override
        public void send(WriteBuffer wb) throws ConnectionException {
            super.send(wb);
            byte[] ab = ((ByteArrayWriteBuffer)wb).getRawByteArray();
            int cb = wb.length();
            DataOutputStream out = this.getDataOutputStream();
            ReentrantLock lock = this.getDataOutputStreamLock();
            boolean fLock = false;
            long cMillis = this.getRequestSendTimeout();
            try {
                if (cMillis > 0L) {
                    fLock = lock.tryLock(cMillis, TimeUnit.MILLISECONDS);
                } else {
                    lock.lockInterruptibly();
                    fLock = true;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            if (fLock) {
                try {
                    ExternalizableHelper.writeInt(out, cb);
                    out.write(ab, 0, cb);
                    out.flush();
                }
                catch (IOException e) {
                    throw new ConnectionException(e, (Connection)this);
                }
                finally {
                    lock.unlock();
                }
            } else {
                throw new RequestTimeoutException("socket write timed out after " + cMillis);
            }
        }

        protected void setDataInputStream(DataInputStream in) {
            this.__m_DataInputStream = in;
        }

        protected void setDataOutputStream(DataOutputStream out) {
            this.__m_DataOutputStream = out;
        }

        protected void setDataOutputStreamLock(ReentrantLock out) {
            this.__m_DataOutputStreamLock = out;
        }

        protected void setReader(TcpReader reader) {
            this.__m_Reader = reader;
        }

        public void setRedirect(boolean f) {
            this.__m_Redirect = f;
        }

        public void setRedirectList(List list) {
            this.__m_RedirectList = list;
        }

        public void setRequestSendTimeout(long ldt) {
            this.__m_RequestSendTimeout = ldt;
        }

        static {
            TcpConnection.__initStatic();
        }

        public static class TcpReader
        extends Daemon {
            public TcpReader() {
                this(null, null, true);
            }

            public TcpReader(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setDaemonState(0);
                    this.setDefaultGuardRecovery(0.9f);
                    this.setDefaultGuardTimeout(60000L);
                    this.setNotifier(new SingleWaiterMultiNotifier());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this._addChild(new Daemon.Guard("Guard", this, true), "Guard");
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new TcpReader();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/initiator/TcpInitiator$TcpConnection$TcpReader".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public String getThreadName() {
                return ((TcpInitiator)this.get_Module()).getServiceName() + ":" + super.getThreadName();
            }

            @Override
            protected void onException(Throwable e) {
                if (!this.isExiting()) {
                    try {
                        TcpConnection connection = (TcpConnection)this.get_Parent();
                        connection.close(false, e, false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                super.onException(e);
            }

            @Override
            protected void onNotify() {
                TcpInitiator manager = (TcpInitiator)this.get_Module();
                TcpConnection connection = (TcpConnection)this.get_Parent();
                DataInputStream in = connection.getDataInputStream();
                while (!this.isExiting()) {
                    try {
                        int cb = ExternalizableHelper.readInt(in);
                        manager.enforceMaxIncomingMessageSize(cb);
                        if (cb < 0) {
                            throw new IOException("Received a message with a negative length");
                        }
                        if (cb == 0) {
                            throw new IOException("Received a message with a length of zero");
                        }
                        byte[] ab = new byte[cb];
                        in.readFully(ab);
                        connection.setStatsBytesReceived(connection.getStatsBytesReceived() + (long)cb);
                        connection.setStatsReceived(connection.getStatsReceived() + 1L);
                        manager.receive(new ByteArrayReadBuffer(ab), connection);
                    }
                    catch (IOException e) {
                        if (this.isExiting()) continue;
                        try {
                            connection.close(false, new ConnectionException(e, (Connection)connection), false);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.stop();
                    }
                }
            }

            @Override
            protected void onWait() throws InterruptedException {
            }
        }
    }
}

