/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.oracle.coherence.common.net.SocketProvider;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.Util;
import com.tangosol.coherence.component.net.extend.message.Response;
import com.tangosol.coherence.component.net.extend.util.TcpUtil;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.QueueProcessor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ProxyService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor;
import com.tangosol.coherence.component.util.pool.simplePool.GrowablePool;
import com.tangosol.coherence.component.util.queue.concurrentQueue.DualQueue;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.internal.net.service.DefaultServiceDependencies;
import com.tangosol.internal.net.service.peer.acceptor.DefaultTcpAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.LegacyXmlTcpAcceptorHelper;
import com.tangosol.internal.net.service.peer.acceptor.TcpAcceptorDependencies;
import com.tangosol.io.MultiBufferReadBuffer;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.nio.ByteBufferReadBuffer;
import com.tangosol.io.nio.ByteBufferWriteBuffer;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.SocketAddressProvider;
import com.tangosol.net.SocketOptions;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.Connection;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.Message;
import com.tangosol.net.messaging.SuspectConnectionException;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ByteSequence;
import com.tangosol.util.Filter;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.SparseArray;
import com.tangosol.util.ThreadGate;
import com.tangosol.util.WrapperException;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.net.ssl.SSLException;

public class TcpAcceptor
extends Acceptor {
    private Filter __m_AuthorizedHostFilter;
    private transient BufferPool __m_BufferPoolIn;
    private transient BufferPool __m_BufferPoolOut;
    private Queue __m_ConnectionFlushQueue;
    private Queue __m_ConnectionReleaseQueue;
    private long __m_DefaultLimitBytes;
    private int __m_DefaultLimitLength;
    private long __m_DefaultNominalBytes;
    private int __m_DefaultNominalLength;
    private long __m_DefaultSuspectBytes;
    private int __m_DefaultSuspectLength;
    private transient long __m_LastThrottleWarningTimestamp;
    private int __m_ListenBacklog;
    private SocketAddress __m_LocalAddress;
    private SocketAddressProvider __m_LocalAddressProvider;
    private transient TcpProcessor __m_Processor;
    private transient SocketOptions __m_SocketOptions;
    private SocketProvider __m_SocketProvider;
    private SocketProviderFactory __m_SocketProviderFactory;
    private long __m_StatsUnauthorizedConnectionAttempts;
    private boolean __m_SuspectProtocolEnabled;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("BufferPool", BufferPool.get_CLASS());
        __mapChildren.put("DispatchEvent", Peer.DispatchEvent.get_CLASS());
        __mapChildren.put("MessageBuffer", MessageBuffer.get_CLASS());
        __mapChildren.put("MessageFactory", MessageFactory.get_CLASS());
        __mapChildren.put("Queue", QueueProcessor.Queue.get_CLASS());
        __mapChildren.put("TcpConnection", TcpConnection.get_CLASS());
    }

    public TcpAcceptor() {
        this(null, null, true);
    }

    public TcpAcceptor(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setConnectionPendingSet(new SafeHashSet());
            this.setConnectionSet(new SafeHashSet());
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setDefaultLimitBytes(100000000L);
            this.setDefaultLimitLength(60000);
            this.setDefaultNominalBytes(2000000L);
            this.setDefaultNominalLength(2000);
            this.setDefaultSuspectBytes(10000000L);
            this.setDefaultSuspectLength(10000);
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setProtocolMap(new HashMap());
            this.setReceiverMap(new HashMap());
            this.setRequestTimeout(30000L);
            this.setSerializerMap(new WeakHashMap());
            this.setSocketOptions(new SocketOptions());
            this.setSuspectProtocolEnabled(true);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Acceptor.DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Service.EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Daemon.Guard("Guard", this, true), "Guard");
        this._addChild(new Peer.Protocol("Protocol", this, true), "Protocol");
        this._addChild(new TcpProcessor("TcpProcessor", this, true), "TcpProcessor");
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new TcpAcceptor();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/acceptor/TcpAcceptor".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    protected WriteBuffer allocateWriteBuffer() {
        return new MultiBufferWriteBuffer(this.getBufferPoolOut());
    }

    protected void bind(ServerSocket socket, SocketAddress addr, int nBacklog) throws IOException {
        socket.bind(addr, nBacklog);
    }

    @Override
    protected DefaultServiceDependencies cloneDependencies(ServiceDependencies deps) {
        return new DefaultTcpAcceptorDependencies((TcpAcceptorDependencies)deps);
    }

    @Override
    public synchronized void configure(XmlElement xml) {
        this.setDependencies(LegacyXmlTcpAcceptorHelper.fromXml(xml, new DefaultTcpAcceptorDependencies(), this.getOperationalContext(), this.getContextClassLoader()));
        this.setServiceConfig(xml);
    }

    private void configureBufferPool(BufferPool pool, TcpAcceptorDependencies.BufferPoolConfig config) {
        pool.setBufferSize(config.getBufferSize());
        pool.setBufferType(config.getBufferType());
        pool.setCapacity(config.getCapacity());
    }

    public void configureSocket(ServerSocket socket) {
        SocketAddress address;
        try {
            this.getSocketOptions().apply(socket);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "error configuring ServerSocket");
        }
        SocketAddressProvider provider = this.getLocalAddressProvider();
        Exception eLast = null;
        while ((address = provider.getNextAddress()) != null) {
            try {
                this.bind(socket, address, this.getListenBacklog());
                TcpAcceptor.validateLocalAddress(socket.getInetAddress());
                this.setLocalAddress(socket.getLocalSocketAddress());
                provider.accept();
                break;
            }
            catch (Exception e) {
                provider.reject(e);
                eLast = e;
            }
        }
        if (address == null || !socket.isBound()) {
            throw Base.ensureRuntimeException(eLast, "Error binding ServerSocket to any of the supplied ports: " + String.valueOf(provider));
        }
    }

    public void configureSocket(Socket socket) {
        try {
            this.getSocketOptions().apply(socket);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "error configuring Socket");
        }
    }

    @Override
    protected void encodeMessage(Message message, WriteBuffer.BufferOutput out, boolean fFilter) throws IOException {
        for (int i = 0; i < 5; ++i) {
            out.write(0);
        }
        super.encodeMessage(message, out, fFilter);
    }

    public Filter getAuthorizedHostFilter() {
        return this.__m_AuthorizedHostFilter;
    }

    public BufferPool getBufferPoolIn() {
        return this.__m_BufferPoolIn;
    }

    public BufferPool getBufferPoolOut() {
        return this.__m_BufferPoolOut;
    }

    public Queue getConnectionFlushQueue() {
        return this.__m_ConnectionFlushQueue;
    }

    public Queue getConnectionReleaseQueue() {
        return this.__m_ConnectionReleaseQueue;
    }

    public long getDefaultLimitBytes() {
        return this.__m_DefaultLimitBytes;
    }

    public int getDefaultLimitLength() {
        return this.__m_DefaultLimitLength;
    }

    public long getDefaultNominalBytes() {
        return this.__m_DefaultNominalBytes;
    }

    public int getDefaultNominalLength() {
        return this.__m_DefaultNominalLength;
    }

    public long getDefaultSuspectBytes() {
        return this.__m_DefaultSuspectBytes;
    }

    public int getDefaultSuspectLength() {
        return this.__m_DefaultSuspectLength;
    }

    @Override
    public String getDescription() {
        StringBuffer sb = new StringBuffer(super.getDescription());
        sb.append(", SocketProvider=").append(this.getSocketProvider());
        sb.append(", LocalAddress=").append(this.getLocalAddressProvider());
        SocketOptions options = this.getSocketOptions();
        if (options != null) {
            sb.append(", ").append(options);
        }
        sb.append(", ListenBacklog=").append(this.getListenBacklog()).append(", BufferPoolIn=").append(this.getBufferPoolIn()).append(", BufferPoolOut=").append(this.getBufferPoolOut());
        return sb.toString();
    }

    public long getLastThrottleWarningTimestamp() {
        return this.__m_LastThrottleWarningTimestamp;
    }

    public int getListenBacklog() {
        return this.__m_ListenBacklog;
    }

    public SocketAddress getLocalAddress() {
        return this.__m_LocalAddress;
    }

    public SocketAddressProvider getLocalAddressProvider() {
        return this.__m_LocalAddressProvider;
    }

    public TcpProcessor getProcessor() {
        TcpProcessor processor = this.__m_Processor;
        if (processor == null) {
            processor = (TcpProcessor)this._findChild("TcpProcessor");
            this.setProcessor(processor);
        }
        return processor;
    }

    public SocketOptions getSocketOptions() {
        return this.__m_SocketOptions;
    }

    public SocketProvider getSocketProvider() {
        return this.__m_SocketProvider;
    }

    public SocketProviderFactory getSocketProviderFactory() {
        SocketProviderFactory factory = this.__m_SocketProviderFactory;
        if (factory == null) {
            OperationalContext ctx = this.getOperationalContext();
            factory = ctx == null ? new SocketProviderFactory() : ctx.getSocketProviderFactory();
            this.setSocketProviderFactory(factory);
        }
        return factory;
    }

    public long getStatsUnauthorizedConnectionAttempts() {
        return this.__m_StatsUnauthorizedConnectionAttempts;
    }

    @Override
    public com.tangosol.coherence.component.net.extend.Connection instantiateConnection() {
        TcpConnection connection = (TcpConnection)this._newChild("TcpConnection");
        connection.setConnectionManager(this);
        return connection;
    }

    @Override
    public boolean isAcceptingConnections() {
        return super.isAcceptingConnections() && this.getBufferPoolOut().getOverflow() <= 0;
    }

    public boolean isAuthorizedHost(InetAddress addr) {
        Filter filterHost = this.getAuthorizedHostFilter();
        if (filterHost == null) {
            return true;
        }
        try {
            if (filterHost.evaluate(addr)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public boolean isSuspectProtocolEnabled() {
        return this.__m_SuspectProtocolEnabled;
    }

    @Override
    public void onConnectionClosed(com.tangosol.coherence.component.net.extend.Connection connection) {
        super.onConnectionClosed(connection);
        if (this.get_Connection() == connection) {
            return;
        }
        this.getConnectionReleaseQueue().add(connection);
        this.getProcessor().wakeup();
    }

    @Override
    public void onConnectionError(com.tangosol.coherence.component.net.extend.Connection connection, Throwable e) {
        super.onConnectionError(connection, e);
        if (this.get_Connection() == connection) {
            return;
        }
        this.getConnectionReleaseQueue().add(connection);
        this.getProcessor().wakeup();
    }

    @Override
    protected void onDependencies(ServiceDependencies deps) {
        super.onDependencies(deps);
        TcpAcceptorDependencies tcpDeps = (TcpAcceptorDependencies)deps;
        ParameterizedBuilder<Filter> bldrFilter = tcpDeps.getAuthorizedHostFilterBuilder();
        if (bldrFilter != null) {
            this.setAuthorizedHostFilter(bldrFilter.realize(new NullParameterResolver(), this.getContextClassLoader(), null));
        }
        this.setDefaultLimitBytes(tcpDeps.getDefaultLimitBytes());
        this.setDefaultLimitLength(tcpDeps.getDefaultLimitMessages());
        this.setDefaultNominalBytes(tcpDeps.getDefaultNominalBytes());
        this.setDefaultNominalLength(tcpDeps.getDefaultNominalMessages());
        this.setDefaultSuspectBytes(tcpDeps.getDefaultSuspectBytes());
        this.setDefaultSuspectLength(tcpDeps.getDefaultSuspectMessages());
        this.setListenBacklog(tcpDeps.getListenBacklog());
        this.setSocketOptions(tcpDeps.getSocketOptions());
        this.setSocketProvider(tcpDeps.getSocketProviderBuilder().realize(null, null, null));
        this.setSuspectProtocolEnabled(tcpDeps.isSuspectProtocolEnabled());
        ParameterizedBuilder<SocketAddressProvider> bldr = tcpDeps.getLocalAddressProviderBuilder();
        if (bldr != null) {
            this.setLocalAddressProvider(bldr.realize(new NullParameterResolver(), this.getContextClassLoader(), null));
        }
        this.configureBufferPool(this.getBufferPoolIn(), tcpDeps.getIncomingBufferPoolConfig());
        this.configureBufferPool(this.getBufferPoolOut(), tcpDeps.getOutgoingBufferPoolConfig());
    }

    @Override
    protected void onExit() {
        super.onExit();
        this.getProcessor().stop();
    }

    @Override
    public void onInit() {
        this.setBufferPoolIn((BufferPool)this._newChild("BufferPool"));
        this.setBufferPoolOut((BufferPool)this._newChild("BufferPool"));
        this.setConnectionFlushQueue(new DualQueue());
        this.setConnectionReleaseQueue(new DualQueue());
        this.getBufferPoolIn().setName("Incoming");
        this.getBufferPoolOut().setName("Outgoing");
        super.onInit();
        try {
            SocketOptions options = this.getSocketOptions();
            options.setOption(8, Boolean.TRUE);
            options.setOption(1, Boolean.TRUE);
            options.setOption(128, 0);
        }
        catch (SocketException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    @Override
    protected void onServiceStarting() {
        super.onServiceStarting();
        TcpProcessor processor = this.getProcessor();
        processor.start();
        TcpAcceptor._trace("TcpAcceptor now listening for connections on " + this.getSocketProvider().getAddressString(processor.getServerSocket()), 3);
    }

    @Override
    protected void onServiceStopping() {
        TcpUtil.cancel(this.getProcessor().getServerSocketKey());
        super.onServiceStopping();
    }

    @Override
    protected void releaseReadBuffer(ReadBuffer rb) {
        TcpAcceptor._assert(rb instanceof MessageBuffer);
        ((MessageBuffer)rb).release();
    }

    @Override
    protected void releaseWriteBuffer(WriteBuffer wb, Throwable e) {
        TcpAcceptor._assert(wb instanceof MultiBufferWriteBuffer);
        if (e != null) {
            BufferPool pool = this.getBufferPoolOut();
            MultiBufferWriteBuffer mwb = (MultiBufferWriteBuffer)wb;
            int c = mwb.getBufferCount();
            for (int i = 0; i < c; ++i) {
                pool.release(mwb.getBuffer(i));
            }
        }
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.setStatsUnauthorizedConnectionAttempts(0L);
    }

    protected void setAuthorizedHostFilter(Filter filter) {
        this.__m_AuthorizedHostFilter = filter;
    }

    protected void setBufferPoolIn(BufferPool pool) {
        this.__m_BufferPoolIn = pool;
    }

    protected void setBufferPoolOut(BufferPool pool) {
        this.__m_BufferPoolOut = pool;
    }

    protected void setConnectionFlushQueue(Queue queue) {
        this.__m_ConnectionFlushQueue = queue;
    }

    protected void setConnectionReleaseQueue(Queue queue) {
        this.__m_ConnectionReleaseQueue = queue;
    }

    protected void setDefaultLimitBytes(long cb) {
        this.__m_DefaultLimitBytes = cb;
    }

    protected void setDefaultLimitLength(int cMsgs) {
        this.__m_DefaultLimitLength = cMsgs;
    }

    protected void setDefaultNominalBytes(long cb) {
        this.__m_DefaultNominalBytes = cb;
    }

    protected void setDefaultNominalLength(int cMsgs) {
        this.__m_DefaultNominalLength = cMsgs;
    }

    protected void setDefaultSuspectBytes(long cb) {
        this.__m_DefaultSuspectBytes = cb;
    }

    protected void setDefaultSuspectLength(int cMsgs) {
        this.__m_DefaultSuspectLength = cMsgs;
    }

    public void setLastThrottleWarningTimestamp(long ldt) {
        this.__m_LastThrottleWarningTimestamp = ldt;
    }

    protected void setListenBacklog(int cConn) {
        this.__m_ListenBacklog = cConn;
    }

    public void setLocalAddress(SocketAddress addr) {
        this.__m_LocalAddress = addr;
    }

    public void setLocalAddressProvider(SocketAddressProvider pLocalAddressProvider) {
        this.__m_LocalAddressProvider = pLocalAddressProvider;
    }

    protected void setProcessor(TcpProcessor processor) {
        this.__m_Processor = processor;
    }

    protected void setSocketOptions(SocketOptions options) {
        TcpAcceptor._assert(options != null);
        this.__m_SocketOptions = options;
    }

    protected void setSocketProvider(SocketProvider provider) {
        this.__m_SocketProvider = provider;
    }

    public void setSocketProviderFactory(SocketProviderFactory factory) {
        this.__m_SocketProviderFactory = factory;
    }

    public void setStatsUnauthorizedConnectionAttempts(long cMillis) {
        this.__m_StatsUnauthorizedConnectionAttempts = cMillis;
    }

    public void setSuspectProtocolEnabled(boolean pSuspectProtocolEnabled) {
        this.__m_SuspectProtocolEnabled = pSuspectProtocolEnabled;
    }

    protected static void validateLocalAddress(InetAddress addr) {
        if (InetAddressHelper.isLoopbackAddress(addr)) {
            TcpAcceptor._trace("The specified local address \"" + String.valueOf(addr) + "\" is a loopback address; clients running on remote machines will not be able to connect to this TcpAcceptor", 3);
        } else {
            byte[] abAddr = addr.getAddress();
            if (abAddr.length == 16) {
                boolean fSuspect = true;
                List<InetAddress> listLocal = InetAddressHelper.getAllLocalAddresses();
                for (InetAddress addrLocal : listLocal) {
                    if (!InetAddressHelper.virtuallyEqual(addrLocal.getAddress(), abAddr)) continue;
                    fSuspect = false;
                    break;
                }
                if (fSuspect) {
                    TcpAcceptor._trace("The local IPv6 address \"" + InetAddressHelper.toString(addr) + "\" does not correspond to any of the local interface addresses; this address may not be reachable by IPv4-bound nodes", 2);
                }
            }
        }
    }

    static {
        TcpAcceptor.__initStatic();
    }

    public static class BufferPool
    extends GrowablePool
    implements MultiBufferWriteBuffer.WriteBufferPool {
        private int __m_BufferSize;
        private int __m_BufferType;
        private String __m_Name;
        private int __m_Overflow;
        public static final int TYPE_DIRECT = 0;
        public static final int TYPE_HEAP = 1;

        public BufferPool() {
            this(null, null, true);
        }

        public BufferPool(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setBufferSize(2048);
                this.setBufferType(0);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new BufferPool();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/acceptor/TcpAcceptor$BufferPool".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object acquire() {
            ByteBufferWriteBuffer wb = (ByteBufferWriteBuffer)this.getStorage().removeNoWait();
            if (wb == null) {
                boolean fGrow;
                BufferPool bufferPool = this;
                synchronized (bufferPool) {
                    int cSize = this.getSize();
                    int cCapacity = this.getCapacity();
                    if (cSize < cCapacity || cCapacity <= 0) {
                        this.setSize(cSize + 1);
                        fGrow = true;
                    } else {
                        this.setOverflow(this.getOverflow() + 1);
                        fGrow = false;
                    }
                }
                wb = (ByteBufferWriteBuffer)this.instantiateResource();
                if (BufferPool._isTraceEnabled(9)) {
                    if (fGrow) {
                        BufferPool._trace(this.getName() + "BufferPool increased to " + this.getSize() * this.getBufferSize() + " bytes total", 9);
                    } else {
                        BufferPool._trace(this.getName() + "BufferPool allocated " + this.getBufferSize() + " bytes", 9);
                    }
                }
            } else {
                wb.getByteBuffer().clear();
            }
            return wb;
        }

        @Override
        public WriteBuffer allocate(int cbPreviousTotal) {
            return (ByteBufferWriteBuffer)this.acquire();
        }

        public int getBufferSize() {
            return this.__m_BufferSize;
        }

        public int getBufferType() {
            return this.__m_BufferType;
        }

        @Override
        public int getMaximumCapacity() {
            return this.getBufferSize() * this.getCapacity();
        }

        public String getName() {
            String sName = this.__m_Name;
            return sName == null ? "" : sName;
        }

        public int getOverflow() {
            return this.__m_Overflow;
        }

        public static int getType(String sType) {
            if (sType.equalsIgnoreCase("HEAP")) {
                return 1;
            }
            return 0;
        }

        @Override
        protected Object instantiateResource() {
            return new ByteBufferWriteBuffer(switch (this.getBufferType()) {
                case 0 -> ByteBuffer.allocateDirect(this.getBufferSize());
                default -> ByteBuffer.allocate(this.getBufferSize());
            });
        }

        @Override
        protected Queue instantiateStorage() {
            return new DualQueue();
        }

        public boolean isCapacityLimited() {
            return this.getCapacity() > 0;
        }

        public synchronized void release() {
            Queue queue = this.getStorage();
            while (!queue.isEmpty()) {
                queue.removeNoWait();
            }
            this.setOverflow(0);
            this.setSize(0);
        }

        @Override
        public void release(WriteBuffer wb) {
            this.release((Object)wb);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release(Object oElement) {
            boolean fRelease;
            int cOverflow;
            BufferPool._assert(oElement instanceof ByteBufferWriteBuffer);
            BufferPool bufferPool = this;
            synchronized (bufferPool) {
                cOverflow = this.getOverflow();
                if (cOverflow == 0) {
                    fRelease = true;
                } else {
                    this.setOverflow(--cOverflow);
                    fRelease = false;
                }
            }
            if (fRelease) {
                super.release(oElement);
            } else {
                if (this.getBufferType() == 0 && cOverflow == 0) {
                    System.gc();
                }
                if (BufferPool._isTraceEnabled(9)) {
                    BufferPool._trace(this.getName() + "BufferPool released " + ((ByteBufferWriteBuffer)oElement).getCapacity() + " bytes", 9);
                }
            }
        }

        public void setBufferSize(int cb) {
            BufferPool._assert(cb > 0);
            this.__m_BufferSize = cb;
        }

        public void setBufferType(int nType) {
            BufferPool._assert(nType == 0 || nType == 1);
            this.__m_BufferType = nType;
        }

        public void setName(String sName) {
            if (sName != null && ((String)sName).length() > 0 && !((String)sName).endsWith(" ")) {
                sName = (String)sName + " ";
            }
            this.__m_Name = sName;
        }

        public void setOverflow(int cElements) {
            this.__m_Overflow = cElements;
        }

        @Override
        public String toString() {
            String sCapacity = this.getMaximumCapacity() == 0 ? "Unlimited" : Base.toMemorySizeString(this.getMaximumCapacity());
            return this.get_Name() + "(BufferSize=" + Base.toMemorySizeString(this.getBufferSize()) + ", BufferType=" + (this.getBufferType() == 0 ? "DIRECT" : "HEAP") + ", Capacity=" + sCapacity + ")";
        }
    }

    public static class MessageBuffer
    extends Util
    implements ReadBuffer {
        private ReadBuffer __m__ReadBuffer;
        private WriteBuffer[] __m__WriteBuffer;
        private BufferPool __m_BufferPool;

        public MessageBuffer() {
            this(null, null, true);
        }

        public MessageBuffer(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MessageBuffer();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/acceptor/TcpAcceptor$MessageBuffer".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public byte byteAt(int of) {
            return this.get_ReadBuffer().byteAt(of);
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new WrapperException(e);
            }
        }

        @Override
        public void copyBytes(int ofBegin, int ofEnd, byte[] abDest, int ofDest) {
            this.get_ReadBuffer().copyBytes(ofBegin, ofEnd, abDest, ofDest);
        }

        public ReadBuffer get_ReadBuffer() {
            return this.__m__ReadBuffer;
        }

        public WriteBuffer[] get_WriteBuffer() {
            return this.__m__WriteBuffer;
        }

        protected WriteBuffer get_WriteBuffer(int i) {
            return this.get_WriteBuffer()[i];
        }

        @Override
        public ReadBuffer.BufferInput getBufferInput() {
            return this.get_ReadBuffer().getBufferInput();
        }

        public BufferPool getBufferPool() {
            return this.__m_BufferPool;
        }

        @Override
        public ReadBuffer getReadBuffer(int of, int cb) {
            return this.get_ReadBuffer().getReadBuffer(of, cb);
        }

        @Override
        public int length() {
            return this.get_ReadBuffer().length();
        }

        @Override
        public void onInit() {
        }

        public void release() {
            BufferPool pool = this.getBufferPool();
            for (WriteBuffer wb : this.get_WriteBuffer()) {
                if (wb == null) continue;
                pool.release(wb);
            }
        }

        public void set_ReadBuffer(ReadBuffer rb) {
            this.__m__ReadBuffer = rb;
        }

        public void set_WriteBuffer(WriteBuffer[] awb) {
            this.__m__WriteBuffer = awb;
        }

        protected void set_WriteBuffer(int i, WriteBuffer wb) {
            this.get_WriteBuffer()[i] = wb;
        }

        public void setBufferPool(BufferPool pool) {
            this.__m_BufferPool = pool;
        }

        @Override
        public ByteSequence subSequence(int ofStart, int ofEnd) {
            return this.get_ReadBuffer().subSequence(ofStart, ofEnd);
        }

        @Override
        public Binary toBinary() {
            return this.get_ReadBuffer().toBinary();
        }

        @Override
        public Binary toBinary(int of, int cb) {
            return this.get_ReadBuffer().toBinary(of, cb);
        }

        @Override
        public byte[] toByteArray() {
            return this.get_ReadBuffer().toByteArray();
        }

        @Override
        public byte[] toByteArray(int of, int cb) {
            return this.get_ReadBuffer().toByteArray(of, cb);
        }

        @Override
        public ByteBuffer toByteBuffer() {
            return null;
        }

        @Override
        public ByteBuffer toByteBuffer(int of, int cb) {
            return null;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            this.get_ReadBuffer().writeTo(out);
        }

        @Override
        public void writeTo(DataOutput out, int of, int cb) throws IOException {
            this.get_ReadBuffer().writeTo(out, of, cb);
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            this.get_ReadBuffer().writeTo(out);
        }

        @Override
        public void writeTo(OutputStream out, int of, int cb) throws IOException {
            this.get_ReadBuffer().writeTo(out, of, cb);
        }

        @Override
        public void writeTo(ByteBuffer buf) {
            this.get_ReadBuffer().writeTo(buf);
        }

        @Override
        public void writeTo(ByteBuffer buf, int of, int cb) throws IOException {
            this.get_ReadBuffer().writeTo(buf, of, cb);
        }
    }

    public static class MessageFactory
    extends Acceptor.MessageFactory {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("AcceptChannel", Peer.MessageFactory.AcceptChannel.get_CLASS());
            __mapChildren.put("AcceptChannelRequest", Peer.MessageFactory.AcceptChannelRequest.get_CLASS());
            __mapChildren.put("AcceptChannelResponse", Peer.MessageFactory.AcceptChannelResponse.get_CLASS());
            __mapChildren.put("CloseChannel", Peer.MessageFactory.CloseChannel.get_CLASS());
            __mapChildren.put("CloseConnection", Peer.MessageFactory.CloseConnection.get_CLASS());
            __mapChildren.put("CreateChannel", Peer.MessageFactory.CreateChannel.get_CLASS());
            __mapChildren.put("EncodedMessage", Peer.MessageFactory.EncodedMessage.get_CLASS());
            __mapChildren.put("NotifyChannelClosed", Peer.MessageFactory.NotifyChannelClosed.get_CLASS());
            __mapChildren.put("NotifyConnectionClosed", Peer.MessageFactory.NotifyConnectionClosed.get_CLASS());
            __mapChildren.put("NotifyShutdown", Peer.MessageFactory.NotifyShutdown.get_CLASS());
            __mapChildren.put("NotifyStartup", Peer.MessageFactory.NotifyStartup.get_CLASS());
            __mapChildren.put("OpenChannel", Peer.MessageFactory.OpenChannel.get_CLASS());
            __mapChildren.put("OpenChannelRequest", Peer.MessageFactory.OpenChannelRequest.get_CLASS());
            __mapChildren.put("OpenChannelResponse", Peer.MessageFactory.OpenChannelResponse.get_CLASS());
            __mapChildren.put("OpenConnection", Acceptor.MessageFactory.OpenConnection.get_CLASS());
            __mapChildren.put("OpenConnectionRequest", OpenConnectionRequest.get_CLASS());
            __mapChildren.put("OpenConnectionResponse", OpenConnectionResponse.get_CLASS());
            __mapChildren.put("PingRequest", PingRequest.get_CLASS());
            __mapChildren.put("PingResponse", Peer.MessageFactory.PingResponse.get_CLASS());
            __mapChildren.put("Response", Peer.MessageFactory.Response.get_CLASS());
        }

        public MessageFactory() {
            this(null, null, true);
        }

        public MessageFactory(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MessageFactory();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/acceptor/TcpAcceptor$MessageFactory".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        static {
            MessageFactory.__initStatic();
        }

        public static class OpenConnectionRequest
        extends Acceptor.MessageFactory.OpenConnectionRequest {
            private boolean __m_Redirect;
            private boolean __m_RedirectSupported;
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Status", Peer.MessageFactory.OpenConnectionRequest.Status.get_CLASS());
            }

            public OpenConnectionRequest() {
                this(null, null, true);
            }

            public OpenConnectionRequest(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new OpenConnectionRequest();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/acceptor/TcpAcceptor$MessageFactory$OpenConnectionRequest".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            @Override
            protected String getDescription() {
                return super.getDescription() + ", RedirectSupported=" + this.isRedirectSupported() + ", Redirect=" + this.isRedirect();
            }

            public boolean isRedirect() {
                return this.__m_Redirect;
            }

            public boolean isRedirectSupported() {
                return this.__m_RedirectSupported;
            }

            @Override
            protected void onRun(Response response) {
                Channel channel0 = this.getChannel();
                OpenConnectionRequest._assert(channel0.getId() == 0);
                TcpConnection connection = (TcpConnection)channel0.getConnection();
                OpenConnectionRequest._assert(connection != null);
                connection.setRedirect(this.isRedirect());
                connection.setRedirectSupported(this.isRedirectSupported());
                connection.setClusterName(this.getClusterName());
                connection.setServiceName(this.getServiceName());
                super.onRun(response);
                OpenConnectionResponse responseImpl = (OpenConnectionResponse)response;
                responseImpl.setRedirect(connection.isRedirect());
                responseImpl.setRedirectList(connection.getRedirectList());
            }

            @Override
            public void readExternal(PofReader in) throws IOException {
                super.readExternal(in);
                this.setRedirectSupported(in.readBoolean(10));
                this.setRedirect(in.readBoolean(11));
            }

            public void setRedirect(boolean f) {
                this.__m_Redirect = f;
            }

            public void setRedirectSupported(boolean f) {
                this.__m_RedirectSupported = f;
            }

            @Override
            public void writeExternal(PofWriter out) throws IOException {
                super.writeExternal(out);
                out.writeBoolean(10, this.isRedirectSupported());
                out.writeBoolean(11, this.isRedirect());
            }

            static {
                OpenConnectionRequest.__initStatic();
            }
        }

        public static class OpenConnectionResponse
        extends Acceptor.MessageFactory.OpenConnectionResponse {
            private boolean __m_Redirect;
            private List __m_RedirectList;

            public OpenConnectionResponse() {
                this(null, null, true);
            }

            public OpenConnectionResponse(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new OpenConnectionResponse();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/acceptor/TcpAcceptor$MessageFactory$OpenConnectionResponse".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected String getDescription() {
                return super.getDescription() + ", Redirect=" + this.isRedirect() + ", RedirectList=" + String.valueOf(this.getRedirectList());
            }

            public List getRedirectList() {
                return this.__m_RedirectList;
            }

            public boolean isRedirect() {
                return this.__m_Redirect;
            }

            @Override
            public void readExternal(PofReader in) throws IOException {
                super.readExternal(in);
                this.setRedirect(in.readBoolean(10));
                if (this.isRedirect()) {
                    this.setRedirectList(in.readCollection(11, new ArrayList()));
                }
            }

            public void setRedirect(boolean f) {
                this.__m_Redirect = f;
            }

            public void setRedirectList(List list) {
                this.__m_RedirectList = list;
            }

            @Override
            public void writeExternal(PofWriter out) throws IOException {
                super.writeExternal(out);
                out.writeBoolean(10, this.isRedirect());
                if (this.isRedirect()) {
                    out.writeCollection(11, this.getRedirectList());
                }
            }
        }

        public static class PingRequest
        extends Peer.MessageFactory.PingRequest {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Status", Peer.MessageFactory.PingRequest.Status.get_CLASS());
            }

            public PingRequest() {
                this(null, null, true);
            }

            public PingRequest(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new PingRequest();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/acceptor/TcpAcceptor$MessageFactory$PingRequest".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            @Override
            protected void onRun(Response response) {
                com.tangosol.coherence.component.net.extend.connection.TcpConnection conn;
                Service service;
                super.onRun(response);
                if (this.getId() == 1L && (service = ((TcpAcceptor)(conn = (com.tangosol.coherence.component.net.extend.connection.TcpConnection)this.getChannel().getConnection()).getConnectionManager()).getParentService()) instanceof ProxyService) {
                    response.setResultAsCollection(((ProxyService)service).getRoutableMemberAddresses(conn.getSocket()));
                }
            }

            static {
                PingRequest.__initStatic();
            }
        }
    }

    public static class TcpConnection
    extends com.tangosol.coherence.component.net.extend.connection.TcpConnection {
        private String __m_ClusterName;
        private transient long __m_ConnectTimeMillis;
        public static final int IN_DECODED = 1;
        public static final int IN_INITIAL = 0;
        public static final int IN_PREPARED = 2;
        private ByteBuffer __m_IncomingByteBuffer;
        private int __m_IncomingBytesRead;
        private int __m_IncomingBytesTotal;
        private boolean __m_IncomingDisabled;
        private int __m_IncomingState;
        private ByteBufferWriteBuffer[] __m_IncomingWriteBufferArray;
        private int __m_IncomingWriteBufferIndex;
        public static final int OUT_ENCODED = 2;
        public static final int OUT_INITIAL = 0;
        public static final int OUT_PREPARED = 1;
        private ByteBuffer __m_OutgoingByteBuffer;
        private int __m_OutgoingBytesTotal;
        private int __m_OutgoingBytesWritten;
        private boolean __m_OutgoingDisabled;
        private MultiBufferWriteBuffer __m_OutgoingMessage;
        private Queue __m_OutgoingQueue;
        private int __m_OutgoingState;
        private ByteBufferWriteBuffer[] __m_OutgoingWriteBufferArray;
        private int __m_OutgoingWriteBufferIndex;
        private boolean __m_Redirect;
        private List __m_RedirectList;
        private boolean __m_RedirectSupported;
        private SelectionKey __m_SelectionKey;
        private String __m_ServiceName;
        private SocketChannel __m_SocketChannel;
        private transient long __m_StatsBytesQueued;
        private transient long __m_StatsQueued;
        private boolean __m_Suspect;
        private int __m_SuspectBytesWorseCount;
        private int __m_SuspectCheckCount;
        private long __m_SuspectInitialBytes;
        private long __m_SuspectInitialLength;
        private long __m_SuspectInitialMillis;
        private long __m_SuspectLatestBytes;
        private long __m_SuspectLatestLength;
        private long __m_SuspectLatestMillis;
        private int __m_SuspectLengthWorseCount;
        private long __m_SuspectTargetBytes;
        private long __m_SuspectTargetLength;

        public TcpConnection() {
            this(null, null, true);
        }

        public TcpConnection(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setChannelArray(new SparseArray());
                this.setChannelPendingArray(new SparseArray());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new TcpConnection();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/acceptor/TcpAcceptor$TcpConnection".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void assertOpen() {
            super.assertOpen();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkSuspect(boolean fSuspect, long cQueued, long cbQueued, long cSent, long cbSent) {
            TcpAcceptor acceptor = (TcpAcceptor)this.getConnectionManager();
            BufferPool pool = acceptor.getBufferPoolOut();
            Queue queue = this.getOutgoingQueue();
            long cBehind = cQueued - cSent;
            long cbBehind = cbQueued - cbSent;
            if (cQueued < 0L || cSent < 0L || cBehind < 0L || cBehind > Integer.MAX_VALUE || cbQueued < 0L || cbSent < 0L || cbBehind < 0L || cbBehind > Integer.MAX_VALUE) {
                return;
            }
            if (fSuspect) {
                Queue queue2 = queue;
                synchronized (queue2) {
                    if (this.isSuspect() && this.isSuspectEvaluate()) {
                        long LIMIT_BYTES = acceptor.getDefaultLimitBytes();
                        long LIMIT_LENGTH = acceptor.getDefaultLimitLength();
                        boolean fKill = false;
                        boolean fClear = false;
                        String sCause = null;
                        long cTarget = this.getSuspectTargetLength();
                        long cbTarget = this.getSuspectTargetBytes();
                        int cMax = pool.getCapacity();
                        if (pool.isCapacityLimited() && (cBehind > (long)cMax || cbBehind > (long)(cMax * pool.getBufferSize()))) {
                            fKill = true;
                            sCause = "This one connection has used up the entire configured capacity of the buffer pool; the connection is " + cBehind + " messages behind (" + cbBehind + " bytes); the buffer pool is configured for " + cMax + " messages (" + cMax * pool.getBufferSize() + " bytes).";
                        } else if (!(pool.isCapacityLimited() || cBehind <= LIMIT_LENGTH && cbBehind <= LIMIT_BYTES)) {
                            fKill = true;
                            sCause = "This connection is " + cBehind + " messages behind (" + cbBehind + " bytes); the limit is " + LIMIT_LENGTH + " messages (" + LIMIT_BYTES + " bytes).";
                        } else if (cbBehind < cbTarget) {
                            fClear = true;
                            sCause = "The connection has reduced its backlog to " + cbBehind + " bytes; the target was " + cbTarget + " bytes.";
                        } else {
                            boolean fLengthWorse;
                            long cMillis = this.getSuspectLatestMillis();
                            int cElapsedSecs = (int)((cMillis - this.getSuspectInitialMillis()) / 1000L);
                            long cOrigLength = this.getSuspectInitialLength();
                            long cbOrigBytes = this.getSuspectInitialBytes();
                            long cPrevLength = this.getSuspectLatestLength();
                            long cbPrevBytes = this.getSuspectLatestBytes();
                            int cChecks = this.getSuspectCheckCount();
                            int cBytesWorse = this.getSuspectBytesWorseCount();
                            int cLengthWorse = this.getSuspectLengthWorseCount();
                            boolean fBytesWorse = cbBehind > cbPrevBytes;
                            if (fBytesWorse) {
                                ++cBytesWorse;
                            }
                            if (fLengthWorse = cBehind > cPrevLength) {
                                ++cLengthWorse;
                            }
                            int cPctBytesChange = (int)(cbBehind * 100L / cbOrigBytes);
                            int cPctLengthChange = (int)(cBehind * 100L / cOrigLength);
                            int cPctBytesWorse = cBytesWorse * 100 / ++cChecks;
                            int cPctLengthWorse = cLengthWorse * 100 / cChecks;
                            if (cbBehind > cbOrigBytes && (cChecks > 20 && cElapsedSecs > 60 && (cPctBytesWorse > 90 || cPctLengthWorse > 90) || cChecks > 6 && cElapsedSecs > 20 && (cPctBytesWorse == 100 || cPctLengthWorse == 100))) {
                                fKill = true;
                                sCause = "The connection has been monitored as a suspect for the past " + cElapsedSecs + " seconds and its backlog has increased with alarming consistency; the backlog length has increased " + cPctLengthWorse + "% of the time and the backlog memory usage has increased " + cPctBytesWorse + "% of the time; the connection is now " + cBehind + " messages behind (" + cbBehind + " bytes).";
                            } else if (cbBehind < cbOrigBytes && cChecks > 20 && cElapsedSecs > 60 && (cPctBytesWorse < 10 || cPctLengthWorse < 10)) {
                                fClear = true;
                                sCause = "The connection has been monitored as a suspect for the past " + cElapsedSecs + " seconds and its backlog has decreased with reassuring consistency; the backlog length has decreased " + (100 - cPctLengthWorse) + "% of the time and the backlog memory usage has decreased " + (100 - cPctBytesWorse) + "% of the time; the connection is now only " + cBehind + " messages behind (" + cbBehind + " bytes).";
                            }
                            this.setSuspectLatestBytes(cbBehind);
                            this.setSuspectLatestLength(cBehind);
                            this.setSuspectCheckCount(cChecks);
                            this.setSuspectLengthWorseCount(cLengthWorse);
                            this.setSuspectBytesWorseCount(cBytesWorse);
                        }
                        if (fClear) {
                            TcpConnection._trace("Extend*TCP has determined that " + this.toString() + " is no longer a suspect: " + sCause, 3);
                            this.setSuspect(false);
                        } else if (fKill) {
                            TcpConnection._trace("Extend*TCP has determined that " + this.toString() + " must be closed to maintain system stability: " + sCause, 1);
                            this.setSuspect(false);
                            this.setCloseOnExit(true);
                            this.setCloseNotify(false);
                            this.setCloseThrowable(new SuspectConnectionException(sCause, (Connection)this));
                        }
                    }
                }
            }
            if ((pool.getOverflow() > 0 || cBehind > (long)acceptor.getDefaultSuspectLength() || cbBehind > acceptor.getDefaultSuspectBytes()) && this.isSuspectEvaluate()) {
                long NOMINAL_BYTES = acceptor.getDefaultNominalBytes();
                long NOMINAL_LENGTH = acceptor.getDefaultNominalLength();
                long SUSPECT_BYTES = acceptor.getDefaultSuspectBytes();
                long SUSPECT_LENGTH = acceptor.getDefaultSuspectLength();
                long cTarget = NOMINAL_LENGTH;
                long cbTarget = NOMINAL_BYTES;
                String sCause = null;
                if (cBehind > SUSPECT_LENGTH || cbBehind > SUSPECT_BYTES) {
                    fSuspect = true;
                    sCause = "The connection has fallen " + cBehind + " messages (" + cbBehind + " bytes) behind; the threshold is " + SUSPECT_LENGTH + " messages or " + SUSPECT_BYTES + " bytes.";
                }
                int cAliveSecs = (int)((this.getSuspectLatestMillis() - this.getConnectTimeMillis()) / 1000L);
                if (pool.isCapacityLimited() && cAliveSecs > 30) {
                    int cConnections = acceptor.getConnectionSet().size();
                    int cbCapacity = pool.getCapacity() * pool.getBufferSize();
                    int cbSuspect = (int)Math.min(SUSPECT_BYTES, Math.max(NOMINAL_BYTES, (long)(cbCapacity / cConnections / 2 * 3)));
                    if (cbBehind > (long)cbSuspect) {
                        cbTarget = Math.min(SUSPECT_BYTES, Math.max(NOMINAL_BYTES, (long)(cbCapacity / cConnections)));
                        fSuspect = true;
                        sCause = "The connection has fallen " + cBehind + " messages (" + cbBehind + " bytes) behind; with " + cConnections + " connections, the fair share per connection is" + cbTarget + " bytes.";
                    }
                }
                if (fSuspect) {
                    int cConns = 0;
                    int cWorse = 0;
                    try {
                        for (TcpConnection conn : acceptor.getConnectionSet()) {
                            if (conn == null || conn == this) continue;
                            ++cConns;
                            long cThatBehind = conn.getStatsQueued() - conn.getStatsSent();
                            long cbThatBehind = conn.getStatsBytesQueued() - conn.getStatsBytesSent();
                            if ((cThatBehind <= 0L || cThatBehind >= Integer.MAX_VALUE || cThatBehind <= cBehind) && (cbThatBehind <= 0L || cbThatBehind >= Integer.MAX_VALUE || cbThatBehind <= cbBehind)) continue;
                            ++cWorse;
                        }
                    }
                    catch (ConcurrentModificationException e) {
                        return;
                    }
                    if (cWorse < Math.max(3, cConns / 20)) {
                        Queue queue3 = queue;
                        synchronized (queue3) {
                            this.setSuspect(true);
                            this.setSuspectInitialMillis(this.getSuspectLatestMillis());
                            this.setSuspectInitialBytes(cbBehind);
                            this.setSuspectInitialLength(cBehind);
                            this.setSuspectLatestBytes(cbBehind);
                            this.setSuspectLatestLength(cBehind);
                            this.setSuspectCheckCount(0);
                            this.setSuspectLengthWorseCount(0);
                            this.setSuspectBytesWorseCount(0);
                            this.setSuspectTargetBytes(cbTarget);
                            this.setSuspectTargetLength(cTarget);
                        }
                        TcpConnection._trace("Extend*TCP has marked " + this.toString() + " as suspect: " + sCause, 3);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean closeInternal(boolean fNotify, Throwable e, long cMillis) {
            ThreadGate gate = this.getThreadGate();
            gate.barEntry(-1L);
            try {
                this.notifyWaitingThreads();
                boolean bl = super.closeInternal(fNotify, e, cMillis);
                return bl;
            }
            finally {
                gate.open();
            }
        }

        public String getClusterName() {
            return this.__m_ClusterName;
        }

        public long getConnectTimeMillis() {
            return this.__m_ConnectTimeMillis;
        }

        public ByteBuffer getIncomingByteBuffer() {
            return this.__m_IncomingByteBuffer;
        }

        public int getIncomingBytesRead() {
            return this.__m_IncomingBytesRead;
        }

        public int getIncomingBytesTotal() {
            return this.__m_IncomingBytesTotal;
        }

        public int getIncomingState() {
            return this.__m_IncomingState;
        }

        public ByteBufferWriteBuffer[] getIncomingWriteBufferArray() {
            return this.__m_IncomingWriteBufferArray;
        }

        public int getIncomingWriteBufferIndex() {
            return this.__m_IncomingWriteBufferIndex;
        }

        public ByteBuffer getOutgoingByteBuffer() {
            return this.__m_OutgoingByteBuffer;
        }

        public int getOutgoingBytesTotal() {
            return this.__m_OutgoingBytesTotal;
        }

        public int getOutgoingBytesWritten() {
            return this.__m_OutgoingBytesWritten;
        }

        public MultiBufferWriteBuffer getOutgoingMessage() {
            return this.__m_OutgoingMessage;
        }

        public Queue getOutgoingQueue() {
            return this.__m_OutgoingQueue;
        }

        public int getOutgoingState() {
            return this.__m_OutgoingState;
        }

        public ByteBufferWriteBuffer[] getOutgoingWriteBufferArray() {
            return this.__m_OutgoingWriteBufferArray;
        }

        public int getOutgoingWriteBufferIndex() {
            return this.__m_OutgoingWriteBufferIndex;
        }

        public List getRedirectList() {
            return this.__m_RedirectList;
        }

        public SelectionKey getSelectionKey() {
            return this.__m_SelectionKey;
        }

        public String getServiceName() {
            return this.__m_ServiceName;
        }

        public SocketChannel getSocketChannel() {
            return this.__m_SocketChannel;
        }

        public long getStatsBytesQueued() {
            return this.__m_StatsBytesQueued;
        }

        public long getStatsQueued() {
            return this.__m_StatsQueued;
        }

        public int getSuspectBytesBetterCount() {
            return this.getSuspectCheckCount() - this.getSuspectBytesWorseCount();
        }

        public int getSuspectBytesWorseCount() {
            return this.__m_SuspectBytesWorseCount;
        }

        public int getSuspectCheckCount() {
            return this.__m_SuspectCheckCount;
        }

        public long getSuspectInitialBytes() {
            return this.__m_SuspectInitialBytes;
        }

        public long getSuspectInitialLength() {
            return this.__m_SuspectInitialLength;
        }

        public long getSuspectInitialMillis() {
            return this.__m_SuspectInitialMillis;
        }

        public long getSuspectLatestBytes() {
            return this.__m_SuspectLatestBytes;
        }

        public long getSuspectLatestLength() {
            return this.__m_SuspectLatestLength;
        }

        public long getSuspectLatestMillis() {
            return this.__m_SuspectLatestMillis;
        }

        public int getSuspectLengthBetterCount() {
            return this.getSuspectCheckCount() - this.getSuspectLengthWorseCount();
        }

        public int getSuspectLengthWorseCount() {
            return this.__m_SuspectLengthWorseCount;
        }

        public long getSuspectTargetBytes() {
            return this.__m_SuspectTargetBytes;
        }

        public long getSuspectTargetLength() {
            return this.__m_SuspectTargetLength;
        }

        public boolean isIncomingDisabled() {
            return this.__m_IncomingDisabled;
        }

        public boolean isOutgoingDisabled() {
            return this.__m_OutgoingDisabled;
        }

        public boolean isRedirect() {
            return this.__m_Redirect;
        }

        public boolean isRedirectSupported() {
            return this.__m_RedirectSupported;
        }

        public boolean isSuspect() {
            return this.__m_Suspect;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean isSuspectEvaluate() {
            boolean fEvaluate = false;
            Queue queue = this.getOutgoingQueue();
            synchronized (queue) {
                long ldtCurrent = Base.getSafeTimeMillis();
                long ldtPrevious = this.getSuspectLatestMillis();
                if (ldtCurrent > ldtPrevious + 3000L) {
                    this.setSuspectLatestMillis(ldtCurrent);
                    fEvaluate = true;
                }
            }
            return fEvaluate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyWaitingThreads() {
            MultiBufferWriteBuffer o = this.getOutgoingMessage();
            if (o != null) {
                MultiBufferWriteBuffer multiBufferWriteBuffer = o;
                synchronized (multiBufferWriteBuffer) {
                    o.notify();
                }
            }
            Iterator iter = this.getOutgoingQueue().iterator();
            while (iter.hasNext()) {
                MultiBufferWriteBuffer multiBufferWriteBuffer = o = iter.next();
                synchronized (multiBufferWriteBuffer) {
                    o.notify();
                }
            }
        }

        @Override
        public void onInit() {
            this.setOutgoingQueue(new DualQueue());
            this.setConnectTimeMillis(System.currentTimeMillis());
            super.onInit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(WriteBuffer wb) throws ConnectionException {
            this.assertOpen();
            TcpAcceptor acceptor = (TcpAcceptor)this.getConnectionManager();
            Queue queue = this.getOutgoingQueue();
            WriteBuffer writeBuffer = wb;
            synchronized (writeBuffer) {
                boolean fSuspect;
                long cbSent;
                long cSent;
                long cbQueued;
                long cQueued;
                boolean fFlush;
                int cb = wb.length();
                queue.lock();
                try {
                    queue.add(wb);
                    fFlush = queue.size() == 1;
                    cQueued = this.getStatsQueued() + 1L;
                    cbQueued = this.getStatsBytesQueued() + (long)cb;
                    this.setStatsQueued(cQueued);
                    this.setStatsBytesQueued(cbQueued);
                    cSent = this.getStatsSent();
                    cbSent = this.getStatsBytesSent();
                    fSuspect = this.isSuspect();
                }
                finally {
                    queue.unlock();
                }
                if (fFlush) {
                    acceptor.getConnectionFlushQueue().add(this);
                    acceptor.getProcessor().wakeup();
                }
                if (acceptor.isSuspectProtocolEnabled()) {
                    this.checkSuspect(fSuspect, cQueued, cbQueued, cSent, cbSent);
                }
            }
        }

        public void setClusterName(String sName) {
            this.__m_ClusterName = sName;
        }

        protected void setConnectTimeMillis(long cMillis) {
            this.__m_ConnectTimeMillis = cMillis;
        }

        public void setIncomingByteBuffer(ByteBuffer bb) {
            this.__m_IncomingByteBuffer = bb;
        }

        public void setIncomingBytesRead(int cb) {
            this.__m_IncomingBytesRead = cb;
        }

        public void setIncomingBytesTotal(int cb) {
            this.__m_IncomingBytesTotal = cb;
        }

        public void setIncomingDisabled(boolean fDisabled) {
            SelectionKey key;
            if (fDisabled != this.isIncomingDisabled() && (key = this.getSelectionKey()) != null) {
                if (fDisabled) {
                    key.interestOps(key.interestOps() & 0xFFFFFFFE);
                } else {
                    key.interestOps(key.interestOps() | 1);
                }
                this.__m_IncomingDisabled = fDisabled;
            }
        }

        public void setIncomingState(int nState) {
            this.__m_IncomingState = nState;
        }

        public void setIncomingWriteBufferArray(ByteBufferWriteBuffer[] awb) {
            this.__m_IncomingWriteBufferArray = awb;
        }

        public void setIncomingWriteBufferIndex(int i) {
            this.__m_IncomingWriteBufferIndex = i;
        }

        public void setOutgoingByteBuffer(ByteBuffer bb) {
            this.__m_OutgoingByteBuffer = bb;
        }

        public void setOutgoingBytesTotal(int cb) {
            this.__m_OutgoingBytesTotal = cb;
        }

        public void setOutgoingBytesWritten(int cb) {
            this.__m_OutgoingBytesWritten = cb;
        }

        public void setOutgoingDisabled(boolean fDisabled) {
            SelectionKey key;
            if (fDisabled != this.isOutgoingDisabled() && (key = this.getSelectionKey()) != null) {
                if (fDisabled) {
                    key.interestOps(key.interestOps() & 0xFFFFFFFB);
                } else {
                    key.interestOps(key.interestOps() | 4);
                }
                this.__m_OutgoingDisabled = fDisabled;
            }
        }

        public void setOutgoingMessage(MultiBufferWriteBuffer mwb) {
            this.__m_OutgoingMessage = mwb;
        }

        public void setOutgoingQueue(Queue queue) {
            this.__m_OutgoingQueue = queue;
        }

        public void setOutgoingState(int nState) {
            this.__m_OutgoingState = nState;
        }

        public void setOutgoingWriteBufferArray(ByteBufferWriteBuffer[] awb) {
            this.__m_OutgoingWriteBufferArray = awb;
        }

        public void setOutgoingWriteBufferIndex(int i) {
            this.__m_OutgoingWriteBufferIndex = i;
        }

        public void setRedirect(boolean f) {
            this.__m_Redirect = f;
        }

        public void setRedirectList(List list) {
            this.__m_RedirectList = list;
        }

        public void setRedirectSupported(boolean f) {
            this.__m_RedirectSupported = f;
        }

        public void setSelectionKey(SelectionKey key) {
            this.__m_SelectionKey = key;
        }

        public void setServiceName(String sName) {
            this.__m_ServiceName = sName;
        }

        public void setSocketChannel(SocketChannel channel) {
            this.__m_SocketChannel = channel;
        }

        public void setStatsBytesQueued(long cb) {
            this.__m_StatsBytesQueued = cb;
        }

        public void setStatsQueued(long cMessage) {
            this.__m_StatsQueued = cMessage;
        }

        protected void setSuspect(boolean fSuspect) {
            this.__m_Suspect = fSuspect;
        }

        protected void setSuspectBytesWorseCount(int cChecks) {
            this.__m_SuspectBytesWorseCount = cChecks;
        }

        protected void setSuspectCheckCount(int cChecks) {
            this.__m_SuspectCheckCount = cChecks;
        }

        protected void setSuspectInitialBytes(long cb) {
            this.__m_SuspectInitialBytes = cb;
        }

        protected void setSuspectInitialLength(long c) {
            this.__m_SuspectInitialLength = c;
        }

        protected void setSuspectInitialMillis(long cMillis) {
            this.__m_SuspectInitialMillis = cMillis;
        }

        protected void setSuspectLatestBytes(long cb) {
            this.__m_SuspectLatestBytes = cb;
        }

        protected void setSuspectLatestLength(long c) {
            this.__m_SuspectLatestLength = c;
        }

        protected void setSuspectLatestMillis(long cMillis) {
            this.__m_SuspectLatestMillis = cMillis;
        }

        protected void setSuspectLengthWorseCount(int cChecks) {
            this.__m_SuspectLengthWorseCount = cChecks;
        }

        protected void setSuspectTargetBytes(long cb) {
            this.__m_SuspectTargetBytes = cb;
        }

        protected void setSuspectTargetLength(long c) {
            this.__m_SuspectTargetLength = c;
        }
    }

    public static class TcpProcessor
    extends Daemon {
        private transient TcpAcceptor __m_Acceptor;
        private Selector __m_Selector;
        private ServerSocket __m_ServerSocket;
        private ServerSocketChannel __m_ServerSocketChannel;

        public TcpProcessor() {
            this(null, null, true);
        }

        public TcpProcessor(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setDaemonState(0);
                this.setDefaultGuardRecovery(0.9f);
                this.setDefaultGuardTimeout(60000L);
                this.setNotifier(new SingleWaiterMultiNotifier());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new Daemon.Guard("Guard", this, true), "Guard");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new TcpProcessor();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/acceptor/TcpAcceptor$TcpProcessor".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public ServerSocketChannel ensureServerSocketChannel() {
            ServerSocketChannel channel = this.getServerSocketChannel();
            if (channel == null) {
                try {
                    channel = this.getAcceptor().getSocketProvider().openServerSocketChannel();
                }
                catch (IOException e) {
                    throw Base.ensureRuntimeException(e, "error opening ServerSocketChannel");
                }
                try {
                    channel.configureBlocking(false);
                    ServerSocket socket = channel.socket();
                    this.getAcceptor().configureSocket(socket);
                    this.setServerSocket(socket);
                    this.setServerSocketChannel(channel);
                }
                catch (Exception e) {
                    TcpUtil.close(channel);
                    throw Base.ensureRuntimeException(e);
                }
            }
            return channel;
        }

        protected void flushConnections() {
            Queue queue = this.getAcceptor().getConnectionFlushQueue();
            TcpConnection connection = (TcpConnection)queue.removeNoWait();
            while (connection != null) {
                SelectionKey key = connection.getSelectionKey();
                if (key != null) {
                    try {
                        key.interestOps(key.interestOps() | 4);
                    }
                    catch (CancelledKeyException cancelledKeyException) {
                        // empty catch block
                    }
                }
                connection = (TcpConnection)queue.removeNoWait();
            }
        }

        public TcpAcceptor getAcceptor() {
            TcpAcceptor acceptor = this.__m_Acceptor;
            if (acceptor == null) {
                acceptor = (TcpAcceptor)this.get_Module();
                this.setAcceptor(acceptor);
            }
            return acceptor;
        }

        public Selector getSelector() {
            return this.__m_Selector;
        }

        public ServerSocket getServerSocket() {
            return this.__m_ServerSocket;
        }

        public synchronized ServerSocketChannel getServerSocketChannel() {
            return this.__m_ServerSocketChannel;
        }

        public SelectionKey getServerSocketKey() {
            return this.getServerSocketChannel().keyFor(this.getSelector());
        }

        @Override
        public String getThreadName() {
            return ((TcpAcceptor)this.get_Module()).getServiceName() + ":" + super.getThreadName();
        }

        protected void onAccept(SelectionKey key) {
            TcpConnection connection;
            SelectionKey keyConnection;
            SocketChannel channel;
            if (!key.isValid()) {
                return;
            }
            TcpAcceptor acceptor = this.getAcceptor();
            try {
                ServerSocketChannel channelServer = (ServerSocketChannel)key.channel();
                channel = channelServer.accept();
                if (channel == null) {
                    return;
                }
            }
            catch (ClosedChannelException e) {
                if (!this.isExiting()) {
                    TcpProcessor._trace(e, "Caught an exception while accepting a Socket connection");
                }
                return;
            }
            catch (SSLException e) {
                TcpProcessor._trace("Could not accept a Socket connection due to: " + String.valueOf(e), 2);
                return;
            }
            catch (IOException e) {
                TcpProcessor._trace(e, "Error accepting a Socket connection");
                return;
            }
            TcpUtil.setBlockingMode(channel, false);
            Socket socket = channel.socket();
            InetAddress remoteAddress = socket.getInetAddress();
            if (!acceptor.isAuthorizedHost(remoteAddress)) {
                acceptor.setStatsUnauthorizedConnectionAttempts(acceptor.getStatsUnauthorizedConnectionAttempts() + 1L);
                TcpProcessor._trace("Received a connection attempt from remote address " + InetAddressHelper.toString(remoteAddress) + " that was not an authorized host", 6);
                TcpUtil.close(socket);
                TcpUtil.close(channel);
                return;
            }
            try {
                acceptor.configureSocket(socket);
            }
            catch (RuntimeException e) {
                TcpProcessor._trace(e, "Error accepting a connection for \"" + String.valueOf(socket) + "\"");
                TcpUtil.close(socket);
                TcpUtil.close(channel);
                return;
            }
            try {
                keyConnection = channel.register(this.getSelector(), 1);
            }
            catch (ClosedChannelException e) {
                TcpUtil.close(socket);
                TcpUtil.close(channel);
                return;
            }
            try {
                connection = (TcpConnection)acceptor.instantiateConnection();
                connection.setSelectionKey(keyConnection);
                connection.setSocket(socket);
                connection.setSocketChannel(channel);
                connection.open();
            }
            catch (Throwable e) {
                TcpProcessor._trace(e, "An error occurred while creating a TcpConnection");
                TcpUtil.cancel(keyConnection);
                TcpUtil.close(socket);
                TcpUtil.close(channel);
                return;
            }
            keyConnection.attach(connection);
        }

        @Override
        protected void onEnter() {
            super.onEnter();
            ServerSocketChannel channel = this.ensureServerSocketChannel();
            try {
                AbstractSelector selector = channel.provider().openSelector();
                this.setSelector(selector);
                channel.register(selector, 16);
            }
            catch (Throwable t) {
                throw Base.ensureRuntimeException(t, "error opening Selector");
            }
        }

        public void onEOS(SelectionKey key, TcpConnection connection) {
            key.cancel();
            connection.close(false, null, false);
        }

        @Override
        protected void onException(Throwable e) {
            if (this.isExiting()) {
                super.onException(e);
            } else {
                ((TcpAcceptor)this.get_Module()).onException(e);
            }
        }

        @Override
        protected void onExit() {
            TcpUtil.cancel(this.getServerSocketKey());
            TcpUtil.close(this.getServerSocketChannel());
            TcpUtil.close(this.getServerSocket());
            Selector selector = this.getSelector();
            if (selector != null) {
                this.releaseConnections();
                for (SelectionKey key : selector.keys()) {
                    Object o = key.attachment();
                    if (o instanceof TcpConnection) {
                        this.getAcceptor().getConnectionReleaseQueue().add(o);
                        continue;
                    }
                    TcpUtil.close(key.channel());
                }
                this.releaseConnections();
            }
            TcpUtil.close(selector);
        }

        @Override
        protected void onNotify() {
            Selector selector = this.getSelector();
            TcpProcessor._assert(selector != null);
            while (!this.isExiting()) {
                try {
                    Blocking.select(selector, 500L);
                    this.onSelect(selector.selectedKeys());
                    this.flushConnections();
                    this.releaseConnections();
                }
                catch (IOException e) {
                    if (this.isExiting()) continue;
                    TcpProcessor._trace(e, "Caught an I/O exception while processing a Socket; the exception has been logged and will be ignored");
                }
                catch (ClosedSelectorException e) {
                    this.onException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onRead(SelectionKey key) {
            if (!key.isValid()) {
                return;
            }
            TcpConnection connection = (TcpConnection)key.attachment();
            if (connection == null || !connection.isOpen()) {
                key.interestOps(key.interestOps() & 0xFFFFFFFE);
                return;
            }
            TcpAcceptor acceptor = this.getAcceptor();
            SocketChannel channel = (SocketChannel)key.channel();
            BufferPool pool = acceptor.getBufferPoolIn();
            ByteBuffer bb = connection.getIncomingByteBuffer();
            int cbRead = connection.getIncomingBytesRead();
            int cbTotal = connection.getIncomingBytesTotal();
            int nState = connection.getIncomingState();
            WriteBuffer[] awb = connection.getIncomingWriteBufferArray();
            int iBuffer = connection.getIncomingWriteBufferIndex();
            try {
                do {
                    switch (nState) {
                        default: {
                            throw new IllegalStateException("unknown state: " + nState);
                        }
                        case 0: {
                            if (bb == null) {
                                bb = ByteBuffer.allocate(5);
                                connection.setIncomingByteBuffer(bb);
                            }
                            if (channel.read(bb) == -1) {
                                this.onEOS(key, connection);
                                return;
                            }
                            cbTotal = TcpProcessor.readMessageLength(bb);
                            if (cbTotal < 0) {
                                return;
                            }
                            acceptor.enforceMaxIncomingMessageSize(cbTotal);
                            nState = 1;
                        }
                        case 1: {
                            int cbBuffer = pool.getBufferSize();
                            int cBuffer = cbTotal / cbBuffer;
                            int cbLast = cbTotal % cbBuffer;
                            if (cbLast > 0) {
                                ++cBuffer;
                            }
                            awb = new ByteBufferWriteBuffer[cBuffer];
                            awb[0] = (ByteBufferWriteBuffer)pool.acquire();
                            if (cBuffer == 1 && cbLast > 0) {
                                awb[0].getByteBuffer().limit(cbLast);
                            }
                            if ((cbRead = bb.remaining()) <= cbTotal) {
                                awb[0].getByteBuffer().put(bb);
                                bb.clear();
                            } else {
                                TcpProcessor.slide(bb, awb[0].getByteBuffer(), cbTotal);
                            }
                            nState = 2;
                        }
                        case 2: 
                    }
                    int cBuffers = awb.length - iBuffer;
                    ByteBuffer[] aBuffers = new ByteBuffer[cBuffers];
                    for (int indx = 0; indx < cBuffers; ++indx) {
                        ByteBufferWriteBuffer wb = awb[iBuffer + indx];
                        if (wb == null) {
                            int nRemainder;
                            awb[iBuffer + indx] = wb = (ByteBufferWriteBuffer)pool.acquire();
                            if (indx == cBuffers - 1 && (nRemainder = cbTotal % pool.getBufferSize()) > 0) {
                                wb.getByteBuffer().limit(nRemainder);
                            }
                        }
                        aBuffers[indx] = wb.getByteBuffer();
                    }
                    long cb = 0L;
                    int of = 0;
                    do {
                        if ((cb = channel.read(aBuffers, of, cBuffers)) == -1L) {
                            this.onEOS(key, connection);
                            return;
                        }
                        cbRead = (int)((long)cbRead + cb);
                        while (cBuffers > 0 && !aBuffers[of].hasRemaining()) {
                            ++of;
                            --cBuffers;
                            ++iBuffer;
                        }
                    } while (cBuffers > 0 && cb > 0L);
                    if (cbRead == cbTotal) {
                        MessageBuffer mb = new MessageBuffer();
                        mb.setBufferPool(pool);
                        mb.set_WriteBuffer(awb);
                        int cBuffer = awb.length;
                        if (cBuffer == 1) {
                            mb.set_ReadBuffer(((ByteBufferWriteBuffer)awb[0]).getUnsafeReadBuffer());
                        } else {
                            ReadBuffer[] arb = new ByteBufferReadBuffer[cBuffer];
                            for (int i = 0; i < cBuffer; ++i) {
                                arb[i] = (ByteBufferReadBuffer)((ByteBufferWriteBuffer)awb[i]).getUnsafeReadBuffer();
                            }
                            mb.set_ReadBuffer(new MultiBufferReadBuffer(arb));
                        }
                        acceptor.receive(mb, connection);
                        awb = null;
                        iBuffer = 0;
                        cbTotal = 0;
                        cbRead = 0;
                        nState = 0;
                        continue;
                    }
                    if (cbRead < cbTotal) {
                        TcpProcessor._assert(iBuffer < awb.length);
                        continue;
                    }
                    TcpProcessor._assert(false, "expected to read " + cbTotal + " bytes; read " + cbRead + " bytes instead");
                } while (bb.position() > 0);
            }
            catch (SSLException e) {
                Socket socket = connection.getSocket();
                if (socket == null) {
                    TcpProcessor._trace("Exception receiving from peer: " + String.valueOf(e), 2);
                } else {
                    TcpProcessor._trace("Exception regarding peer " + String.valueOf(socket.getRemoteSocketAddress()) + ": " + String.valueOf(e), 2);
                }
                connection.close(false, new ConnectionException(e, (Connection)connection), false);
            }
            catch (Throwable e) {
                connection.close(false, new ConnectionException(e, (Connection)connection), false);
            }
            finally {
                connection.setIncomingBytesRead(cbRead);
                connection.setIncomingBytesTotal(cbTotal);
                connection.setIncomingState(nState);
                connection.setIncomingWriteBufferArray((ByteBufferWriteBuffer[])awb);
                connection.setIncomingWriteBufferIndex(iBuffer);
            }
        }

        protected void onSelect(Set setKey) {
            Iterator iter = setKey.iterator();
            while (iter.hasNext()) {
                SelectionKey key = (SelectionKey)iter.next();
                iter.remove();
                if (!key.isValid()) continue;
                if (key.readyOps() == 0) {
                    TcpConnection connection = (TcpConnection)key.attachment();
                    if (connection == null || !connection.isOpen()) {
                        TcpUtil.close(key.channel());
                        continue;
                    }
                    this.onEOS(key, connection);
                    continue;
                }
                try {
                    if (key.isAcceptable()) {
                        this.onAccept(key);
                    }
                    if (key.isReadable()) {
                        this.onRead(key);
                    }
                    if (!key.isWritable()) continue;
                    this.onWrite(key);
                }
                catch (CancelledKeyException cancelledKeyException) {}
            }
        }

        @Override
        protected void onWait() throws InterruptedException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void onWrite(SelectionKey key) {
            if (!key.isValid()) {
                return;
            }
            TcpConnection connection = (TcpConnection)key.attachment();
            if (connection == null || !connection.isOpen()) {
                key.interestOps(key.interestOps() & 0xFFFFFFFB);
                return;
            }
            TcpAcceptor acceptor = this.getAcceptor();
            SocketChannel channel = (SocketChannel)key.channel();
            BufferPool pool = acceptor.getBufferPoolOut();
            ByteBuffer bb = connection.getOutgoingByteBuffer();
            int cbTotal = connection.getOutgoingBytesTotal();
            int cbWritten = connection.getOutgoingBytesWritten();
            MultiBufferWriteBuffer mwb = connection.getOutgoingMessage();
            Queue queue = connection.getOutgoingQueue();
            int nState = connection.getOutgoingState();
            ByteBufferWriteBuffer[] awb = connection.getOutgoingWriteBufferArray();
            int iBuffer = connection.getOutgoingWriteBufferIndex();
            long cSent = connection.getStatsSent();
            long cbSent = connection.getStatsBytesSent();
            try {
                block16: while (true) {
                    switch (nState) {
                        default: {
                            throw new IllegalStateException("unknown state: " + nState);
                        }
                        case 0: {
                            if (bb == null) {
                                bb = ByteBuffer.allocate(5);
                                connection.setOutgoingByteBuffer(bb);
                            }
                            if ((mwb = (MultiBufferWriteBuffer)queue.removeNoWait()) == null) {
                                key.interestOps(key.interestOps() & 0xFFFFFFFB);
                                return;
                            }
                            cbTotal = mwb.length() - 5;
                            if (cbTotal <= 0) continue block16;
                            int cBuffer = mwb.getBufferCount();
                            awb = new ByteBufferWriteBuffer[cBuffer];
                            for (int i = 0; i < cBuffer; ++i) {
                                ByteBufferWriteBuffer wb = (ByteBufferWriteBuffer)mwb.getBuffer(i);
                                wb.getByteBuffer().flip();
                                awb[i] = wb;
                            }
                            TcpProcessor.writeMessageLength(bb, cbTotal);
                            nState = 1;
                        }
                        case 1: {
                            int cb = bb.remaining();
                            int of = bb.capacity() - cb;
                            ByteBuffer bbMsg = awb[0].getByteBuffer();
                            bbMsg.position(of);
                            bbMsg.put(bb);
                            bbMsg.position(of);
                            cbTotal += cb;
                            cbSent += (long)of;
                            bb.clear();
                            nState = 2;
                            break;
                        }
                        case 2: 
                    }
                    int cBuffers = awb.length - iBuffer;
                    ByteBuffer[] aBuffers = new ByteBuffer[cBuffers];
                    for (int indx = 0; indx < cBuffers; ++indx) {
                        aBuffers[indx] = awb[iBuffer + indx].getByteBuffer();
                    }
                    long cbSum = 0L;
                    long cb = 0L;
                    int of = 0;
                    do {
                        cb = cBuffers == 1 ? (long)channel.write(aBuffers[of]) : channel.write(aBuffers, of, cBuffers);
                        cbSum += cb;
                        while (cBuffers > 0 && !aBuffers[of].hasRemaining()) {
                            pool.release(awb[iBuffer]);
                            awb[iBuffer++] = null;
                            ++of;
                            --cBuffers;
                        }
                    } while (cBuffers > 0 && cb > 0L);
                    if (cbSum == 0L) {
                        return;
                    }
                    cbWritten = (int)((long)cbWritten + cbSum);
                    cbSent += cbSum;
                    if (cbWritten != cbTotal) break;
                    ++cSent;
                    mwb = null;
                    awb = null;
                    iBuffer = 0;
                    cbTotal = 0;
                    cbWritten = 0;
                    nState = 0;
                    continue;
                    break;
                }
            }
            catch (SSLException e) {
                Socket socket = connection.getSocket();
                if (socket == null) {
                    TcpProcessor._trace("Exception sending to peer: " + String.valueOf(e), 2);
                } else {
                    TcpProcessor._trace("Exception regarding peer " + String.valueOf(socket.getRemoteSocketAddress()) + ": " + String.valueOf(e), 2);
                }
                connection.close(false, new ConnectionException(e, (Connection)connection), false);
                return;
            }
            catch (Exception e) {
                connection.close(false, new ConnectionException(e, (Connection)connection), false);
                return;
            }
            if (cbWritten >= cbTotal) {
                TcpProcessor._assert(false, "expected to write " + cbTotal + " bytes; wrote " + cbWritten + " bytes instead");
                return;
            }
            TcpProcessor._assert(iBuffer < awb.length);
            return;
            finally {
                connection.setOutgoingBytesTotal(cbTotal);
                connection.setOutgoingBytesWritten(cbWritten);
                connection.setOutgoingMessage(mwb);
                connection.setOutgoingState(nState);
                connection.setOutgoingWriteBufferArray(awb);
                connection.setOutgoingWriteBufferIndex(iBuffer);
                connection.setStatsSent(cSent);
                connection.setStatsBytesSent(cbSent);
            }
        }

        protected static int readMessageLength(ByteBuffer bb) {
            int nPos = bb.position();
            if (nPos == 0) {
                return -1;
            }
            int b = bb.get(0) & 0xFF;
            if ((b & 0x40) != 0) {
                throw new IllegalArgumentException("Received a message with a negative length");
            }
            int cb = b & 0x3F;
            int i = 1;
            int cBits = 6;
            while ((b & 0x80) != 0) {
                if (cBits > 31) {
                    cb = -1;
                    break;
                }
                if (i == nPos) {
                    return -1;
                }
                b = bb.get(i++) & 0xFF;
                cb |= (b & 0x7F) << cBits;
                cBits += 7;
            }
            bb.limit(bb.position());
            bb.position(i);
            if (cb <= 0) {
                throw new IllegalArgumentException("Received a message with an invalid length");
            }
            return cb;
        }

        protected void releaseConnections() {
            TcpAcceptor acceptor = this.getAcceptor();
            BufferPool poolIn = acceptor.getBufferPoolIn();
            BufferPool poolOut = acceptor.getBufferPoolOut();
            Queue queue = acceptor.getConnectionReleaseQueue();
            TcpConnection connection = (TcpConnection)queue.removeNoWait();
            while (connection != null) {
                TcpUtil.cancel(connection.getSelectionKey());
                TcpUtil.close(connection.getSocket());
                TcpUtil.close(connection.getSocketChannel());
                ByteBufferWriteBuffer[] awb = connection.getIncomingWriteBufferArray();
                if (awb != null) {
                    int c = awb.length;
                    for (int i = 0; i < c; ++i) {
                        ByteBufferWriteBuffer wb = awb[i];
                        if (wb == null) continue;
                        poolIn.release(wb);
                    }
                }
                if ((awb = connection.getOutgoingWriteBufferArray()) != null) {
                    for (ByteBufferWriteBuffer wb : awb) {
                        if (wb == null) continue;
                        poolOut.release(wb);
                    }
                }
                Queue queueOut = connection.getOutgoingQueue();
                MultiBufferWriteBuffer mwb = (MultiBufferWriteBuffer)queueOut.removeNoWait();
                while (mwb != null) {
                    int c = mwb.getBufferCount();
                    for (int i = 0; i < c; ++i) {
                        poolOut.release(mwb.getBuffer(i));
                    }
                    mwb = (MultiBufferWriteBuffer)queueOut.removeNoWait();
                }
                if (TcpProcessor._isTraceEnabled(6) && connection.getId() != null) {
                    TcpProcessor._trace("Released: " + String.valueOf(connection), 6);
                }
                connection = (TcpConnection)queue.removeNoWait();
            }
        }

        protected void setAcceptor(TcpAcceptor acceptor) {
            this.__m_Acceptor = acceptor;
        }

        protected void setSelector(Selector selector) {
            this.__m_Selector = selector;
        }

        protected void setServerSocket(ServerSocket socket) {
            this.__m_ServerSocket = socket;
        }

        protected void setServerSocketChannel(ServerSocketChannel channel) {
            this.__m_ServerSocketChannel = channel;
        }

        public static void slide(ByteBuffer bufSrc, ByteBuffer bufDst, int cb) {
            int nLimit = bufSrc.limit();
            bufSrc.limit(bufSrc.position() + cb);
            bufDst.put(bufSrc);
            bufSrc.limit(nLimit);
            int nPos = 0;
            while (bufSrc.hasRemaining()) {
                bufSrc.put(nPos++, bufSrc.get());
            }
            bufSrc.position(nPos).limit(bufSrc.capacity());
        }

        @Override
        public void stop() {
            if (this.isStarted()) {
                this.setExiting(true);
                Thread thread = this.getThread();
                if (thread != null && thread != Thread.currentThread()) {
                    this.wakeup();
                }
            }
        }

        public void wakeup() {
            Selector selector = this.getSelector();
            if (selector != null) {
                selector.wakeup();
            }
        }

        protected static void writeMessageLength(ByteBuffer bb, int cb) {
            TcpProcessor._assert(cb >= 0);
            int b = cb & 0x3F;
            cb >>>= 6;
            while (cb != 0) {
                bb.put((byte)(b |= 0x80));
                b = cb & 0x7F;
                cb >>>= 7;
            }
            bb.put((byte)b);
            bb.flip();
        }
    }
}

