/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor;

import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.Connection;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.daemon.QueueProcessor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor;
import com.tangosol.internal.net.service.DefaultServiceDependencies;
import com.tangosol.internal.net.service.peer.acceptor.DefaultGrpcAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.GrpcAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.LegacyXmlGrpcAcceptorHelper;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.grpc.GrpcAcceptorController;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.WrapperException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class GrpcAcceptor
extends Acceptor {
    private GrpcAcceptorController __m_Controller;
    private String __m_ListenAddress;
    private int __m_ListenPort;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("DispatchEvent", Peer.DispatchEvent.get_CLASS());
        __mapChildren.put("MessageFactory", Acceptor.MessageFactory.get_CLASS());
        __mapChildren.put("Queue", QueueProcessor.Queue.get_CLASS());
    }

    public GrpcAcceptor() {
        this(null, null, true);
    }

    public GrpcAcceptor(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setConnectionPendingSet(new SafeHashSet());
            this.setConnectionSet(new SafeHashSet());
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setProtocolMap(new HashMap());
            this.setReceiverMap(new HashMap());
            this.setRequestTimeout(30000L);
            this.setSerializerMap(new WeakHashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Acceptor.DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Service.EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Daemon.Guard("Guard", this, true), "Guard");
        this._addChild(new Peer.Protocol("Protocol", this, true), "Protocol");
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new GrpcAcceptor();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/acceptor/GrpcAcceptor".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    protected DefaultServiceDependencies cloneDependencies(ServiceDependencies deps) {
        return new DefaultGrpcAcceptorDependencies((GrpcAcceptorDependencies)deps);
    }

    @Override
    public synchronized void configure(XmlElement xml) {
        this.setDependencies(LegacyXmlGrpcAcceptorHelper.fromXml(xml, new DefaultGrpcAcceptorDependencies(), this.getOperationalContext(), this.getContextClassLoader()));
        this.setServiceConfig(xml);
    }

    public GrpcAcceptorController getController() {
        return this.__m_Controller;
    }

    @Override
    public String getDescription() {
        GrpcAcceptorController controller = this.getController();
        if (controller == null) {
            return "GrpcAcceptor : LocalAddress=0.0.0.0,LocalPort=0";
        }
        return "GrpcAcceptor : LocalAddress=" + this.getListenAddress() + ",LocalPort=" + this.getListenPort();
    }

    public String getListenAddress() {
        return this.__m_ListenAddress;
    }

    public int getListenPort() {
        return this.__m_ListenPort;
    }

    @Override
    protected Connection instantiateConnection() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void onDependencies(ServiceDependencies deps) {
        super.onDependencies(deps);
        GrpcAcceptorDependencies grpcDeps = (GrpcAcceptorDependencies)deps;
        this.setController(grpcDeps.getController());
    }

    @Override
    protected void onServiceStarting() {
        GrpcAcceptorController controller = this.getController();
        GrpcAcceptor._assert(controller != null);
        GrpcAcceptorDependencies grpcDeps = (GrpcAcceptorDependencies)this.getDependencies();
        controller.setDependencies(grpcDeps);
        this.getParentService().getResourceRegistry().registerResource(GrpcAcceptorController.class, controller);
        super.onServiceStarting();
        controller.start();
        String sAddr = controller.getLocalAddress();
        int nPort = controller.getLocalPort();
        this.setListenAddress(sAddr);
        this.setListenPort(nPort);
        GrpcAcceptor._trace("GrpcAcceptor now listening for connections on " + sAddr + ":" + nPort, 3);
    }

    @Override
    protected void onServiceStopped() {
        super.onServiceStopped();
        GrpcAcceptorController controller = this.getController();
        if (controller != null) {
            controller.stop();
        }
    }

    @Override
    protected void onServiceStopping() {
        super.onServiceStopping();
        GrpcAcceptorController controller = this.getController();
        if (controller != null) {
            controller.stop();
        }
    }

    public void setController(GrpcAcceptorController controller) {
        this.__m_Controller = controller;
    }

    public void setListenAddress(String sAddress) {
        this.__m_ListenAddress = sAddress;
    }

    public void setListenPort(int nPort) {
        this.__m_ListenPort = nPort;
    }

    static {
        GrpcAcceptor.__initStatic();
    }
}

