/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.Channel;
import com.tangosol.coherence.component.net.extend.RemoteService;
import com.tangosol.coherence.component.net.extend.message.Response;
import com.tangosol.coherence.component.util.daemon.QueueProcessor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer;
import com.tangosol.internal.net.service.peer.initiator.InitiatorDependencies;
import com.tangosol.internal.net.service.peer.initiator.TcpInitiatorDependencies;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.messaging.Connection;
import com.tangosol.net.messaging.ConnectionInitiator;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.net.messaging.Request;
import com.tangosol.net.security.SecurityHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.UUID;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;

public abstract class Initiator
extends Peer
implements ConnectionInitiator {
    private SafeHashSet __m_CloseOnExit;
    private com.tangosol.coherence.component.net.extend.Connection __m_Connection;
    private long __m_ConnectTimeout;
    private long __m_RequestSendTimeout;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("DispatchEvent", Peer.DispatchEvent.get_CLASS());
        __mapChildren.put("MessageFactory", MessageFactory.get_CLASS());
        __mapChildren.put("Queue", QueueProcessor.Queue.get_CLASS());
    }

    public Initiator(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/Initiator".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    protected void checkPingTimeouts() {
        com.tangosol.coherence.component.net.extend.Connection connection = this.getConnection();
        if (connection != null) {
            this.checkPingTimeout(connection);
        }
    }

    public static ConnectionInitiator createInitiator(InitiatorDependencies deps, OperationalContext ctx) {
        if (!(deps instanceof TcpInitiatorDependencies)) {
            throw new IllegalArgumentException("unsupported initiator dependencies :\n" + String.valueOf(deps));
        }
        Initiator initiator = (Initiator)Initiator._newInstance("Component.Util.Daemon.QueueProcessor.Service.Peer.Initiator.TcpInitiator");
        initiator.setOperationalContext(ctx);
        initiator.setDependencies(deps);
        return initiator;
    }

    @Override
    public synchronized Connection ensureConnection() {
        if (!this.isRunning()) {
            throw new IllegalStateException(this.getServiceName() + " is not running");
        }
        com.tangosol.coherence.component.net.extend.Connection connection = this.getConnection();
        if (connection == null || !connection.isOpen()) {
            connection = this.openConnection();
        }
        return connection;
    }

    public SafeHashSet getCloseOnExit() {
        return this.__m_CloseOnExit;
    }

    public com.tangosol.coherence.component.net.extend.Connection getConnection() {
        return this.__m_Connection;
    }

    public long getConnectTimeout() {
        return this.__m_ConnectTimeout;
    }

    @Override
    public String getDescription() {
        return super.getDescription() + ", ConnectTimeout=" + this.getConnectTimeout();
    }

    public long getRequestSendTimeout() {
        return this.__m_RequestSendTimeout;
    }

    @Override
    public void onConnectionClosed(com.tangosol.coherence.component.net.extend.Connection connection) {
        if (this.getConnection() == connection) {
            this.setConnection(null);
            super.onConnectionClosed(connection);
        }
    }

    @Override
    public void onConnectionError(com.tangosol.coherence.component.net.extend.Connection connection, Throwable e) {
        if (this.getConnection() == connection) {
            this.setConnection(null);
            super.onConnectionError(connection, e);
        }
    }

    @Override
    public void onConnectionOpened(com.tangosol.coherence.component.net.extend.Connection connection) {
        if (this.get_Connection() == connection) {
            return;
        }
        if (this.getConnection() == null) {
            this.setConnection(connection);
            super.onConnectionOpened(connection);
        }
    }

    @Override
    protected void onDependencies(ServiceDependencies deps) {
        super.onDependencies(deps);
        InitiatorDependencies initiatorDeps = (InitiatorDependencies)deps;
        this.setConnectTimeout(initiatorDeps.getConnectTimeoutMillis());
        this.setRequestSendTimeout(initiatorDeps.getRequestSendTimeoutMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onExit() {
        SafeHashSet setClose;
        SafeHashSet safeHashSet = setClose = this.getCloseOnExit();
        synchronized (safeHashSet) {
            Iterator iter = setClose.iterator();
            while (iter.hasNext()) {
                try {
                    ((AutoCloseable)iter.next()).close();
                }
                catch (Exception exception) {}
            }
        }
        super.onExit();
    }

    @Override
    protected void onServiceStopped() {
        com.tangosol.coherence.component.net.extend.Connection connection = this.getConnection();
        if (connection != null) {
            connection.closeInternal(true, null, 100L);
            if (connection.isOpen()) {
                this.getDaemonPool().stop();
                connection.closeInternal(true, null, 1000L);
                if (connection.isOpen()) {
                    Initiator._trace("Unable to close \"" + String.valueOf(connection) + "\"; this Connection will be abandoned", 1);
                }
            }
        }
        super.onServiceStopped();
    }

    @Override
    protected void onServiceStopping() {
        com.tangosol.coherence.component.net.extend.Connection connection = this.getConnection();
        if (connection != null) {
            connection.closeInternal(true, null, 0L);
        }
        super.onServiceStopping();
    }

    protected com.tangosol.coherence.component.net.extend.Connection openConnection() {
        com.tangosol.coherence.component.net.extend.Connection connection = this.instantiateConnection();
        connection.open();
        return connection;
    }

    @Override
    public void openConnection(com.tangosol.coherence.component.net.extend.Connection connection) {
        Initiator._assert(connection != null);
        Channel channel0 = this.get_Channel();
        Protocol.MessageFactory factory0 = channel0.getMessageFactory();
        MessageFactory.OpenConnection request = (MessageFactory.OpenConnection)factory0.createMessage(-8);
        Subject subject = SecurityHelper.getCurrentSubject();
        request.setConnectionOpen(connection);
        request.setIdentityToken(this.serializeIdentityToken(this.generateIdentityToken(subject)));
        request.setSubject(subject);
        Request.Status status = (Request.Status)channel0.request(request);
        if (status != null) {
            try {
                status.waitForResponse(this.getConnectTimeout());
            }
            catch (RequestTimeoutException e) {
                connection.close(false, e);
                throw e;
            }
        }
    }

    @Override
    protected void ping() {
        com.tangosol.coherence.component.net.extend.Connection connection = this.getConnection();
        if (connection != null) {
            connection.ping();
        }
    }

    public void setCloseOnExit(SafeHashSet setExit) {
        this.__m_CloseOnExit = setExit;
    }

    public void setConnection(com.tangosol.coherence.component.net.extend.Connection connection) {
        this.__m_Connection = connection;
    }

    protected void setConnectTimeout(long cMillis) {
        this.__m_ConnectTimeout = cMillis;
    }

    protected void setRequestSendTimeout(long cMillis) {
        this.__m_RequestSendTimeout = cMillis;
    }

    static {
        Initiator.__initStatic();
    }

    public static class MessageFactory
    extends Peer.MessageFactory {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("AcceptChannel", Peer.MessageFactory.AcceptChannel.get_CLASS());
            __mapChildren.put("AcceptChannelRequest", Peer.MessageFactory.AcceptChannelRequest.get_CLASS());
            __mapChildren.put("AcceptChannelResponse", Peer.MessageFactory.AcceptChannelResponse.get_CLASS());
            __mapChildren.put("CloseChannel", Peer.MessageFactory.CloseChannel.get_CLASS());
            __mapChildren.put("CloseConnection", Peer.MessageFactory.CloseConnection.get_CLASS());
            __mapChildren.put("CreateChannel", Peer.MessageFactory.CreateChannel.get_CLASS());
            __mapChildren.put("EncodedMessage", Peer.MessageFactory.EncodedMessage.get_CLASS());
            __mapChildren.put("NotifyChannelClosed", Peer.MessageFactory.NotifyChannelClosed.get_CLASS());
            __mapChildren.put("NotifyConnectionClosed", Peer.MessageFactory.NotifyConnectionClosed.get_CLASS());
            __mapChildren.put("NotifyShutdown", Peer.MessageFactory.NotifyShutdown.get_CLASS());
            __mapChildren.put("NotifyStartup", Peer.MessageFactory.NotifyStartup.get_CLASS());
            __mapChildren.put("OpenChannel", Peer.MessageFactory.OpenChannel.get_CLASS());
            __mapChildren.put("OpenChannelRequest", Peer.MessageFactory.OpenChannelRequest.get_CLASS());
            __mapChildren.put("OpenChannelResponse", Peer.MessageFactory.OpenChannelResponse.get_CLASS());
            __mapChildren.put("OpenConnection", OpenConnection.get_CLASS());
            __mapChildren.put("OpenConnectionRequest", OpenConnectionRequest.get_CLASS());
            __mapChildren.put("OpenConnectionResponse", OpenConnectionResponse.get_CLASS());
            __mapChildren.put("PingRequest", Peer.MessageFactory.PingRequest.get_CLASS());
            __mapChildren.put("PingResponse", Peer.MessageFactory.PingResponse.get_CLASS());
            __mapChildren.put("Response", Peer.MessageFactory.Response.get_CLASS());
        }

        public MessageFactory() {
            this(null, null, true);
        }

        public MessageFactory(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MessageFactory();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/Initiator$MessageFactory".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        static {
            MessageFactory.__initStatic();
        }

        public static class OpenConnection
        extends Peer.MessageFactory.OpenConnection {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Status", Peer.MessageFactory.OpenConnection.Status.get_CLASS());
            }

            public OpenConnection() {
                this(null, null, true);
            }

            public OpenConnection(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new OpenConnection();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/Initiator$MessageFactory$OpenConnection".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            @Override
            protected void onRun(Response response) {
                com.tangosol.coherence.component.net.extend.Connection connection = this.getConnectionOpen();
                OpenConnection._assert(!connection.isOpen());
                Initiator module = (Initiator)this.getChannel().getReceiver();
                connection.openInternal();
                try {
                    com.tangosol.net.messaging.Channel channel0 = connection.getChannel(0);
                    Protocol.MessageFactory factory0 = channel0.getMessageFactory();
                    OpenConnectionRequest request = (OpenConnectionRequest)factory0.createMessage(1);
                    request.setClientId(module.getProcessId());
                    request.setConnectionOpen(connection);
                    request.setEdition(module.getOperationalContext().getEdition());
                    request.setIdentityToken(this.getIdentityToken());
                    request.setMember(module.getOperationalContext().getLocalMember());
                    request.setProtocolVersionMap(module.getProtocolVersionMap());
                    request.setSubject(this.getSubject());
                    Service svcParent = module.getParentService();
                    if (svcParent instanceof RemoteService) {
                        RemoteService svcRemote = (RemoteService)svcParent;
                        request.setClusterName(svcRemote.getRemoteClusterName());
                        request.setServiceName(svcRemote.getRemoteServiceName());
                    }
                    response.setResult(channel0.send(request));
                }
                catch (Throwable e) {
                    connection.closeInternal(false, e, -1L);
                    throw Base.ensureRuntimeException(e);
                }
            }

            static {
                OpenConnection.__initStatic();
            }
        }

        public static class OpenConnectionRequest
        extends Peer.MessageFactory.OpenConnectionRequest {
            private transient com.tangosol.coherence.component.net.extend.Connection __m_ConnectionOpen;
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Status", Peer.MessageFactory.OpenConnectionRequest.Status.get_CLASS());
            }

            public OpenConnectionRequest() {
                this(null, null, true);
            }

            public OpenConnectionRequest(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new OpenConnectionRequest();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/Initiator$MessageFactory$OpenConnectionRequest".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            public com.tangosol.coherence.component.net.extend.Connection getConnectionOpen() {
                return this.__m_ConnectionOpen;
            }

            @Override
            protected void onRun(Response response) {
                OpenConnectionRequest._assert(this.getChannel().getId() == 0);
            }

            public void setConnectionOpen(com.tangosol.coherence.component.net.extend.Connection connection) {
                this.__m_ConnectionOpen = connection;
            }

            static {
                OpenConnectionRequest.__initStatic();
            }
        }

        public static class OpenConnectionResponse
        extends Peer.MessageFactory.OpenConnectionResponse {
            public OpenConnectionResponse() {
                this(null, null, true);
            }

            public OpenConnectionResponse(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new OpenConnectionResponse();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/Initiator$MessageFactory$OpenConnectionResponse".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public void run() {
                String sName;
                Channel channel0 = (Channel)this.getChannel();
                OpenConnectionResponse._assert(channel0.getId() == 0);
                if (this.isFailure()) {
                    com.tangosol.coherence.component.net.extend.Connection connection = (com.tangosol.coherence.component.net.extend.Connection)channel0.getConnection();
                    Object oResult = this.getResult();
                    Throwable eResult = oResult instanceof Throwable ? (Throwable)oResult : null;
                    connection.closeInternal(false, eResult, -1L);
                    return;
                }
                com.tangosol.coherence.component.net.extend.Connection connection = (com.tangosol.coherence.component.net.extend.Connection)channel0.getConnection();
                Initiator module = (Initiator)channel0.getReceiver();
                Object[] ao = (Object[])this.getResult();
                OpenConnectionResponse._assert(ao != null && ao.length == 2);
                OpenConnectionRequest request = (OpenConnectionRequest)channel0.getRequest(this.getRequestId());
                if (request == null) {
                    return;
                }
                connection.setId((UUID)ao[0]);
                connection.setMember(request.getMember());
                connection.setPeerId((UUID)ao[1]);
                channel0.setSubject(request.getSubject());
                Map mapProtocol = module.getProtocolMap();
                HashMap<String, Protocol.MessageFactory> mapFactory = new HashMap<String, Protocol.MessageFactory>(mapProtocol.size());
                Map mapVersion = this.getProtocolVersionMap();
                if (mapVersion != null) {
                    for (Map.Entry entry : mapVersion.entrySet()) {
                        sName = (String)entry.getKey();
                        Integer IVersion = (Integer)entry.getValue();
                        Protocol protocol = (Protocol)mapProtocol.get(sName);
                        mapFactory.put(sName, protocol.getMessageFactory(IVersion));
                    }
                }
                for (Map.Entry entry : mapProtocol.entrySet()) {
                    sName = (String)entry.getKey();
                    if (mapFactory.containsKey(sName)) continue;
                    Protocol protocol = (Protocol)entry.getValue();
                    mapFactory.put(sName, protocol.getMessageFactory(protocol.getCurrentVersion()));
                }
                connection.setMessageFactoryMap(Collections.unmodifiableMap(mapFactory));
                module.onConnectionOpened(connection);
            }
        }
    }
}

