/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.Channel;
import com.tangosol.coherence.component.net.extend.Connection;
import com.tangosol.coherence.component.net.extend.message.Response;
import com.tangosol.coherence.component.util.daemon.QueueProcessor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer;
import com.tangosol.internal.net.service.peer.acceptor.AcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.GrpcAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.HttpAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.MemcachedAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.TcpAcceptorDependencies;
import com.tangosol.license.CoherenceCachingEdition;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.messaging.ConnectionAcceptor;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.ConnectionFilter;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.util.ListMap;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public abstract class Acceptor
extends Peer
implements ConnectionAcceptor {
    private volatile boolean __m_AcceptingConnections;
    private ConnectionFilter __m_ConnectionFilter;
    private int __m_ConnectionLimit;
    private Set __m_ConnectionPendingSet;
    private Set __m_ConnectionSet;
    private static ListMap __mapChildren;

    private static void _initStatic$Default() {
        Acceptor.__initStatic();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("DispatchEvent", Peer.DispatchEvent.get_CLASS());
        __mapChildren.put("MessageFactory", MessageFactory.get_CLASS());
        __mapChildren.put("Queue", QueueProcessor.Queue.get_CLASS());
    }

    public Acceptor(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/Acceptor".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    protected void checkPingTimeouts() {
        for (Connection connection : this.getConnectionSet()) {
            this.checkPingTimeout(connection);
        }
    }

    public static ConnectionAcceptor createAcceptor(AcceptorDependencies deps, OperationalContext ctx) {
        Acceptor acceptor;
        if (deps instanceof HttpAcceptorDependencies) {
            acceptor = (Acceptor)Acceptor._newInstance("Component.Util.Daemon.QueueProcessor.Service.Peer.Acceptor.HttpAcceptor");
        } else if (deps instanceof TcpAcceptorDependencies) {
            acceptor = (Acceptor)Acceptor._newInstance("Component.Util.Daemon.QueueProcessor.Service.Peer.Acceptor.TcpAcceptor");
        } else if (deps instanceof MemcachedAcceptorDependencies) {
            acceptor = (Acceptor)Acceptor._newInstance("Component.Util.Daemon.QueueProcessor.Service.Peer.Acceptor.MemcachedAcceptor");
        } else if (deps instanceof GrpcAcceptorDependencies) {
            acceptor = (Acceptor)Acceptor._newInstance("Component.Util.Daemon.QueueProcessor.Service.Peer.Acceptor.GrpcAcceptor");
        } else {
            throw new IllegalArgumentException("unsupported acceptor dependencies :\n" + String.valueOf(deps));
        }
        acceptor.setOperationalContext(ctx);
        acceptor.setDependencies(deps);
        return acceptor;
    }

    @Override
    public String formatStats() {
        return "Connections=" + this.getConnectionSet().size() + ", " + super.formatStats();
    }

    @Override
    public ConnectionFilter getConnectionFilter() {
        return this.__m_ConnectionFilter;
    }

    public int getConnectionLimit() {
        return this.__m_ConnectionLimit;
    }

    public Set getConnectionPendingSet() {
        return this.__m_ConnectionPendingSet;
    }

    @Override
    public Collection getConnections() {
        return Collections.unmodifiableSet(this.getConnectionSet());
    }

    public Set getConnectionSet() {
        return this.__m_ConnectionSet;
    }

    @Override
    public com.tangosol.coherence.component.util.DaemonPool getDaemonPool() {
        return (DaemonPool)this._findChild("DaemonPool");
    }

    @Override
    public String getDescription() {
        int cLimit = this.getConnectionLimit();
        if (cLimit > 0) {
            return super.getDescription() + ", ConnectionLimit=" + cLimit;
        }
        return super.getDescription();
    }

    public boolean isAcceptingConnections() {
        int cLimit = this.getConnectionLimit();
        if (cLimit > 0 && this.getConnectionSet().size() >= cLimit) {
            return false;
        }
        return this.__m_AcceptingConnections;
    }

    public Map negotiateProtocols(Connection connection, Map mapRequired) {
        Acceptor._assert(connection != null);
        Acceptor._assert(mapRequired != null);
        Map mapProtcol = this.getProtocolMap();
        HashMap<String, Integer> mapReturn = new HashMap<String, Integer>();
        HashMap<String, Protocol.MessageFactory> mapFactory = new HashMap<String, Protocol.MessageFactory>(mapRequired);
        for (Map.Entry entry : mapRequired.entrySet()) {
            int nVersion;
            String sName = (String)entry.getKey();
            Object oVersion = entry.getValue();
            Protocol protocol = this.getProtocol(sName);
            if (protocol == null) {
                throw new RuntimeException("unsupported protocol: " + sName);
            }
            if (oVersion instanceof Integer) {
                nVersion = (Integer)oVersion;
            } else {
                int nRequestSupport;
                int nRequestCurrent;
                if (oVersion instanceof int[]) {
                    aVersions = (int[])oVersion;
                    nRequestCurrent = aVersions[0];
                    nRequestSupport = aVersions[1];
                } else {
                    aVersions = (Object[])oVersion;
                    nRequestCurrent = aVersions[0];
                    nRequestSupport = aVersions[1];
                }
                int nVersionCurrent = protocol.getCurrentVersion();
                int nVersionSupport = protocol.getSupportedVersion();
                nVersion = Math.min(nRequestCurrent, nVersionCurrent);
                if (nVersion < nRequestSupport || nVersion < nVersionSupport) {
                    throw new RuntimeException("could not negotiate protocol: " + sName);
                }
                if (nVersion != nRequestCurrent) {
                    mapReturn.put(sName, nVersion);
                }
            }
            mapFactory.put(sName, protocol.getMessageFactory(nVersion));
        }
        connection.setMessageFactoryMap(Collections.unmodifiableMap(mapFactory));
        return mapReturn.isEmpty() ? null : mapReturn;
    }

    @Override
    public void onConnectionClosed(Connection connection) {
        if (this.get_Connection() == connection) {
            return;
        }
        if (!this.getConnectionPendingSet().remove(connection) && this.getConnectionSet().remove(connection)) {
            super.onConnectionClosed(connection);
        }
    }

    @Override
    public void onConnectionError(Connection connection, Throwable e) {
        if (this.get_Connection() == connection) {
            return;
        }
        if (!this.getConnectionPendingSet().remove(connection) && this.getConnectionSet().remove(connection)) {
            super.onConnectionError(connection, e);
        }
    }

    @Override
    public void onConnectionOpened(Connection connection) {
        if (this.get_Connection() == connection) {
            return;
        }
        if (this.getConnectionPendingSet().remove(connection) && this.getConnectionSet().add(connection)) {
            super.onConnectionOpened(connection);
        }
    }

    @Override
    protected void onDependencies(ServiceDependencies deps) {
        super.onDependencies(deps);
        AcceptorDependencies acceptorDeps = (AcceptorDependencies)deps;
        this.setConnectionLimit(acceptorDeps.getConnectionLimit());
    }

    @Override
    public void onServiceStarted() {
        this.setAcceptingConnections(true);
        super.onServiceStarted();
    }

    @Override
    protected void onServiceStopped() {
        Connection connection2;
        this.setAcceptingConnections(false);
        Iterator iter = this.getConnectionPendingSet().iterator();
        while (iter.hasNext()) {
            connection2 = (Connection)iter.next();
            iter.remove();
            connection2.closeInternal(true, null, 0L);
        }
        for (Connection connection2 : new HashSet(this.getConnectionSet())) {
            connection2.closeInternal(true, null, 0L);
        }
        iter = this.getConnectionSet().iterator();
        while (iter.hasNext()) {
            connection2 = (Connection)iter.next();
            iter.remove();
            connection2.closeInternal(true, null, 100L);
            if (!connection2.isOpen()) continue;
            this.getDaemonPool().stop();
            connection2.closeInternal(true, null, 1000L);
            if (!connection2.isOpen()) continue;
            Acceptor._trace("Unable to close \"" + String.valueOf(connection2) + "\"; this Connection will be abandoned", 1);
        }
        super.onServiceStopped();
    }

    @Override
    protected void onServiceStopping() {
        Connection connection;
        this.setAcceptingConnections(false);
        Iterator iter = this.getConnectionPendingSet().iterator();
        while (iter.hasNext()) {
            connection = (Connection)iter.next();
            iter.remove();
            connection.closeInternal(true, null, 0L);
        }
        iter = this.getConnectionSet().iterator();
        while (iter.hasNext()) {
            connection = (Connection)iter.next();
            iter.remove();
            connection.closeInternal(true, null, 0L);
        }
        super.onServiceStopping();
    }

    @Override
    protected void ping() {
        for (Connection connection : this.getConnectionSet()) {
            connection.ping();
        }
    }

    protected void setAcceptingConnections(boolean fAccepting) {
        this.__m_AcceptingConnections = fAccepting;
    }

    @Override
    public void setConnectionFilter(ConnectionFilter filter) {
        this.__m_ConnectionFilter = filter;
    }

    protected void setConnectionLimit(int cLimit) {
        this.__m_ConnectionLimit = cLimit;
    }

    protected void setConnectionPendingSet(Set set) {
        this.__m_ConnectionPendingSet = set;
    }

    protected void setConnectionSet(Set set) {
        this.__m_ConnectionSet = set;
    }

    static {
        Acceptor._initStatic$Default();
        try {
            new CoherenceCachingEdition();
        }
        catch (RuntimeException e) {
            Acceptor.setLicenseError(e.getMessage());
        }
    }

    public static class MessageFactory
    extends Peer.MessageFactory {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("AcceptChannel", Peer.MessageFactory.AcceptChannel.get_CLASS());
            __mapChildren.put("AcceptChannelRequest", Peer.MessageFactory.AcceptChannelRequest.get_CLASS());
            __mapChildren.put("AcceptChannelResponse", Peer.MessageFactory.AcceptChannelResponse.get_CLASS());
            __mapChildren.put("CloseChannel", Peer.MessageFactory.CloseChannel.get_CLASS());
            __mapChildren.put("CloseConnection", Peer.MessageFactory.CloseConnection.get_CLASS());
            __mapChildren.put("CreateChannel", Peer.MessageFactory.CreateChannel.get_CLASS());
            __mapChildren.put("EncodedMessage", Peer.MessageFactory.EncodedMessage.get_CLASS());
            __mapChildren.put("NotifyChannelClosed", Peer.MessageFactory.NotifyChannelClosed.get_CLASS());
            __mapChildren.put("NotifyConnectionClosed", Peer.MessageFactory.NotifyConnectionClosed.get_CLASS());
            __mapChildren.put("NotifyShutdown", Peer.MessageFactory.NotifyShutdown.get_CLASS());
            __mapChildren.put("NotifyStartup", Peer.MessageFactory.NotifyStartup.get_CLASS());
            __mapChildren.put("OpenChannel", Peer.MessageFactory.OpenChannel.get_CLASS());
            __mapChildren.put("OpenChannelRequest", Peer.MessageFactory.OpenChannelRequest.get_CLASS());
            __mapChildren.put("OpenChannelResponse", Peer.MessageFactory.OpenChannelResponse.get_CLASS());
            __mapChildren.put("OpenConnection", OpenConnection.get_CLASS());
            __mapChildren.put("OpenConnectionRequest", OpenConnectionRequest.get_CLASS());
            __mapChildren.put("OpenConnectionResponse", OpenConnectionResponse.get_CLASS());
            __mapChildren.put("PingRequest", Peer.MessageFactory.PingRequest.get_CLASS());
            __mapChildren.put("PingResponse", Peer.MessageFactory.PingResponse.get_CLASS());
            __mapChildren.put("Response", Peer.MessageFactory.Response.get_CLASS());
        }

        public MessageFactory() {
            this(null, null, true);
        }

        public MessageFactory(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MessageFactory();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/Acceptor$MessageFactory".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        static {
            MessageFactory.__initStatic();
        }

        public static class OpenConnection
        extends Peer.MessageFactory.OpenConnection {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Status", Peer.MessageFactory.OpenConnection.Status.get_CLASS());
            }

            public OpenConnection() {
                this(null, null, true);
            }

            public OpenConnection(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new OpenConnection();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/Acceptor$MessageFactory$OpenConnection".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            @Override
            protected void onRun(Response response) {
                Connection connection = this.getConnectionOpen();
                OpenConnection._assert(!connection.isOpen());
                Acceptor module = (Acceptor)this.getChannel().getReceiver();
                connection.openInternal();
                module.getConnectionPendingSet().add(connection);
            }

            static {
                OpenConnection.__initStatic();
            }
        }

        public static class OpenConnectionRequest
        extends Peer.MessageFactory.OpenConnectionRequest {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Status", Peer.MessageFactory.OpenConnectionRequest.Status.get_CLASS());
            }

            public OpenConnectionRequest() {
                this(null, null, true);
            }

            public OpenConnectionRequest(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new OpenConnectionRequest();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/Acceptor$MessageFactory$OpenConnectionRequest".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            @Override
            protected void onException(RuntimeException e) {
                super.onException(e);
                com.tangosol.net.messaging.Channel channel = this.getChannel();
                Acceptor module = (Acceptor)channel.getReceiver();
                module.getConnectionPendingSet().remove(channel.getConnection());
            }

            @Override
            protected void onRun(Response response) {
                Channel channel0 = (Channel)this.getChannel();
                OpenConnectionRequest._assert(channel0.getId() == 0);
                Connection connection = (Connection)channel0.getConnection();
                OpenConnectionRequest._assert(connection != null);
                Acceptor module = (Acceptor)this.getChannel().getReceiver();
                UUID uuid = this.getClientId();
                Map mapVersion = this.getProtocolVersionMap();
                OpenConnectionRequest._assert(uuid != null);
                OpenConnectionRequest._assert(mapVersion != null && !mapVersion.isEmpty());
                try {
                    connection.setId(new UUID());
                    connection.setMember(this.getMember());
                    connection.setPeerEdition(this.getEdition());
                    connection.setPeerId(uuid);
                    channel0.setSubject(module.assertIdentityToken(module.deserializeIdentityToken(this.getIdentityToken())));
                    channel0.setAccessAdapter(module.getAccessAdapter());
                    ConnectionFilter filter = module.getConnectionFilter();
                    if (filter != null) {
                        filter.checkConnection(connection);
                    }
                    if (!module.isAcceptingConnections()) {
                        throw new ConnectionException("connection rejected");
                    }
                    Map map = module.negotiateProtocols(connection, mapVersion);
                    ((OpenConnectionResponse)response).setProtocolVersionMap(map);
                    UUID[] uUIDArray = new UUID[2];
                    uUIDArray[0] = connection.getId();
                    uUIDArray[1] = module.getProcessId();
                    UUID[] auuid = uUIDArray;
                    response.setResult(auuid);
                    module.onConnectionOpened(connection);
                }
                catch (ConnectionException e) {
                    response.setFailure(true);
                    response.setResult(e);
                }
                catch (SecurityException e) {
                    OpenConnectionRequest._trace("An exception occurred while processing the identity token: " + String.valueOf(e), 2);
                    response.setFailure(true);
                    response.setResult(new SecurityException("connection rejected"));
                }
                catch (RuntimeException e) {
                    response.setFailure(true);
                    response.setResult(new ConnectionException("connection rejected", e));
                }
                if (response.isFailure()) {
                    module.getConnectionPendingSet().remove(connection);
                }
            }

            static {
                OpenConnectionRequest.__initStatic();
            }
        }

        public static class OpenConnectionResponse
        extends Peer.MessageFactory.OpenConnectionResponse {
            public OpenConnectionResponse() {
                this(null, null, true);
            }

            public OpenConnectionResponse(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new OpenConnectionResponse();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/Acceptor$MessageFactory$OpenConnectionResponse".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public void run() {
                OpenConnectionResponse._assert(this.getChannel().getId() == 0);
            }
        }
    }

    public static class DaemonPool
    extends Peer.DaemonPool {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Daemon", Service.DaemonPool.Daemon.get_CLASS());
            __mapChildren.put("ResizeTask", Service.DaemonPool.ResizeTask.get_CLASS());
            __mapChildren.put("ScheduleTask", Service.DaemonPool.ScheduleTask.get_CLASS());
            __mapChildren.put("StartTask", Service.DaemonPool.StartTask.get_CLASS());
            __mapChildren.put("StopTask", Service.DaemonPool.StopTask.get_CLASS());
            __mapChildren.put("WorkSlot", Service.DaemonPool.WorkSlot.get_CLASS());
            __mapChildren.put("WrapperTask", Peer.DaemonPool.WrapperTask.get_CLASS());
        }

        public DaemonPool() {
            this(null, null, true);
        }

        public DaemonPool(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setAbandonThreshold(8);
                this.setDaemonCountMax(Integer.MAX_VALUE);
                this.setDaemonCountMin(1);
                this.setScheduledTasks(new HashSet());
                this.setStatsTaskAddCount(new AtomicLong());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new DaemonPool();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/peer/Acceptor$DaemonPool".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public boolean isDynamic() {
            return this.getDaemonCount() > 0 && this.getDaemonCountMax() != this.getDaemonCountMin();
        }

        static {
            DaemonPool.__initStatic();
        }
    }
}

