/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.replicatedCache;

import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Lease;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.SimpleResourceRegistry;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class Optimistic
extends ReplicatedCache {
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Acknowledgement", Grid.Acknowledgement.get_CLASS());
        __mapChildren.put("BackingMapContext", ReplicatedCache.BackingMapContext.get_CLASS());
        __mapChildren.put("BusEventMessage", Grid.BusEventMessage.get_CLASS());
        __mapChildren.put("CacheHandler", CacheHandler.get_CLASS());
        __mapChildren.put("CacheUpdate", ReplicatedCache.CacheUpdate.get_CLASS());
        __mapChildren.put("CacheUpdateRequest", ReplicatedCache.CacheUpdateRequest.get_CLASS());
        __mapChildren.put("ConfigRequest", Grid.ConfigRequest.get_CLASS());
        __mapChildren.put("ConfigResponse", Grid.ConfigResponse.get_CLASS());
        __mapChildren.put("ConfigSync", Grid.ConfigSync.get_CLASS());
        __mapChildren.put("ConfigUpdate", Grid.ConfigUpdate.get_CLASS());
        __mapChildren.put("ConverterFromInternal", ReplicatedCache.ConverterFromInternal.get_CLASS());
        __mapChildren.put("ConverterToInternal", ReplicatedCache.ConverterToInternal.get_CLASS());
        __mapChildren.put("DispatchEvent", ReplicatedCache.DispatchEvent.get_CLASS());
        __mapChildren.put("DispatchNotification", Grid.DispatchNotification.get_CLASS());
        __mapChildren.put("LeaseIssue", ReplicatedCache.LeaseIssue.get_CLASS());
        __mapChildren.put("LeaseIssueRequest", ReplicatedCache.LeaseIssueRequest.get_CLASS());
        __mapChildren.put("LeaseLock", ReplicatedCache.LeaseLock.get_CLASS());
        __mapChildren.put("LeaseLockRequest", ReplicatedCache.LeaseLockRequest.get_CLASS());
        __mapChildren.put("LeaseRemove", ReplicatedCache.LeaseRemove.get_CLASS());
        __mapChildren.put("LeaseRemoveAll", LeaseRemoveAll.get_CLASS());
        __mapChildren.put("LeaseRemoveRequest", ReplicatedCache.LeaseRemoveRequest.get_CLASS());
        __mapChildren.put("LeaseUnlock", ReplicatedCache.LeaseUnlock.get_CLASS());
        __mapChildren.put("LeaseUnlockRequest", ReplicatedCache.LeaseUnlockRequest.get_CLASS());
        __mapChildren.put("LeaseUpdate", ReplicatedCache.LeaseUpdate.get_CLASS());
        __mapChildren.put("LeaseUpdateRequest", ReplicatedCache.LeaseUpdateRequest.get_CLASS());
        __mapChildren.put("MemberConfigUpdate", Grid.MemberConfigUpdate.get_CLASS());
        __mapChildren.put("MemberJoined", Grid.MemberJoined.get_CLASS());
        __mapChildren.put("MemberWelcome", Grid.MemberWelcome.get_CLASS());
        __mapChildren.put("MemberWelcomeRequest", Grid.MemberWelcomeRequest.get_CLASS());
        __mapChildren.put("MemberWelcomeRequestTask", Grid.MemberWelcomeRequestTask.get_CLASS());
        __mapChildren.put("NotifyConnectionClose", Grid.NotifyConnectionClose.get_CLASS());
        __mapChildren.put("NotifyConnectionOpen", Grid.NotifyConnectionOpen.get_CLASS());
        __mapChildren.put("NotifyMemberJoined", Grid.NotifyMemberJoined.get_CLASS());
        __mapChildren.put("NotifyMemberLeaving", Grid.NotifyMemberLeaving.get_CLASS());
        __mapChildren.put("NotifyMemberLeft", Grid.NotifyMemberLeft.get_CLASS());
        __mapChildren.put("NotifyMessageReceipt", Grid.NotifyMessageReceipt.get_CLASS());
        __mapChildren.put("NotifyPollClosed", Grid.NotifyPollClosed.get_CLASS());
        __mapChildren.put("NotifyResponse", Grid.NotifyResponse.get_CLASS());
        __mapChildren.put("NotifyServiceAnnounced", Grid.NotifyServiceAnnounced.get_CLASS());
        __mapChildren.put("NotifyServiceJoining", Grid.NotifyServiceJoining.get_CLASS());
        __mapChildren.put("NotifyServiceLeaving", Grid.NotifyServiceLeaving.get_CLASS());
        __mapChildren.put("NotifyServiceLeft", Grid.NotifyServiceLeft.get_CLASS());
        __mapChildren.put("NotifyServiceQuiescence", Grid.NotifyServiceQuiescence.get_CLASS());
        __mapChildren.put("NotifyShutdown", Grid.NotifyShutdown.get_CLASS());
        __mapChildren.put("NotifyStartup", Grid.NotifyStartup.get_CLASS());
        __mapChildren.put("PingRequest", Grid.PingRequest.get_CLASS());
        __mapChildren.put("ProtocolContext", Grid.ProtocolContext.get_CLASS());
        __mapChildren.put("Response", Grid.Response.get_CLASS());
        __mapChildren.put("WrapperGuardable", Grid.WrapperGuardable.get_CLASS());
    }

    public Optimistic() {
        this(null, null, true);
    }

    public Optimistic(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setLockingNextMillis(Long.MAX_VALUE);
            this.setLockRequestQueue(new LinkedList());
            this.setMessageClassMap(new HashMap());
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setOldestPendingRequestSUIDCounter(new AtomicLong());
            this.setResourceRegistry(new SimpleResourceRegistry());
            this.setSerializerMap(new WeakHashMap());
            this.setSuspendPollLimit(new AtomicLong());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new ReplicatedCache.CatalogHandler("CatalogHandler", this, true), "CatalogHandler");
        this._addChild(new Grid.DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Grid.EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Grid.Guard("Guard", this, true), "Guard");
        this._addChild(new Grid.MemberConfigListener("MemberConfigListener", this, true), "MemberConfigListener");
        this._addChild(new Grid.PollArray("PollArray", this, true), "PollArray");
        this._addChild(new Grid.ReceiveQueue("ReceiveQueue", this, true), "ReceiveQueue");
        this._addChild(new Grid.ServiceConfig("ServiceConfig", this, true), "ServiceConfig");
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    @Override
    public String getServiceType() {
        return "OptimisticCache";
    }

    public static Component get_Instance() {
        return new Optimistic();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/replicatedCache/Optimistic".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOptimistically(com.tangosol.coherence.component.util.CacheHandler handler) {
        LeaseRemoveAll msg = (LeaseRemoveAll)this.instantiateMessage("LeaseRemoveAll");
        msg.setCacheIndex(handler.getCacheIndex());
        msg.ensureToMemberSet().addAll((Collection)this.getServiceMemberSet());
        com.tangosol.coherence.component.util.CacheHandler cacheHandler = handler;
        synchronized (cacheHandler) {
            this.send(msg);
            try {
                handler.wait(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCacheClear(int iCache) {
        Optimistic._assert(iCache > 0);
        com.tangosol.coherence.component.util.CacheHandler handler = this.getCacheHandler(iCache);
        if (handler != null) {
            Map map;
            Map mapLease = handler.getLeaseMap();
            try {
                map = mapLease;
                synchronized (map) {
                    mapLease.clear();
                }
                handler.getResourceMap().clear();
            }
            finally {
                map = handler;
                synchronized (map) {
                    handler.notifyAll();
                }
            }
        }
    }

    public Object removeResourceOptimistically(com.tangosol.coherence.component.util.CacheHandler handler, Object oKey) {
        Lease lease = handler.ensureLease(oKey);
        Member memberThis = this.getThisMember();
        lease.setIssuerId(memberThis.getId());
        Object oValueOld = handler.getCachedResource(oKey);
        this.requestRemove(lease, memberThis);
        return oValueOld;
    }

    public Object updateResourceOptimistically(com.tangosol.coherence.component.util.CacheHandler handler, Object oKey, Object oValue, long cExpireMillis) {
        Lease lease = handler.ensureLease(oKey);
        Member memberThis = this.getThisMember();
        lease.setIssuerId(memberThis.getId());
        Object oValueOld = handler.getCachedResource(oKey);
        this.requestUpdate(lease, memberThis, oValue, cExpireMillis, true, false);
        return oValueOld;
    }

    static {
        Optimistic.__initStatic();
    }

    public static class CacheHandler
    extends ReplicatedCache.CacheHandler {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("BackingMapListener", ReplicatedCache.CacheHandler.BackingMapListener.get_CLASS());
            __mapChildren.put("EntrySet", ReplicatedCache.CacheHandler.EntrySet.get_CLASS());
            __mapChildren.put("KeySet", ReplicatedCache.CacheHandler.KeySet.get_CLASS());
            __mapChildren.put("Validator", ReplicatedCache.CacheHandler.Validator.get_CLASS());
        }

        public CacheHandler() {
            this(null, null, true);
        }

        public CacheHandler(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setCacheIndex(-1);
                this.setDeactivationListeners(new Listeners());
                this.setIgnoreKey(new Object());
                this.setPutExpiryWarned(false);
                this.setStandardLeaseMillis(20000L);
                this.setUseEventDaemon(true);
                this.setValid(true);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new CacheHandler();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/replicatedCache/Optimistic$CacheHandler".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public void clear() {
            this.checkAccess();
            ((Optimistic)this.get_Module()).clearOptimistically(this);
        }

        @Override
        public boolean lock(Object oKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object put(Object oKey, Object oValue) {
            this.checkAccess();
            return ((Optimistic)this.get_Module()).updateResourceOptimistically(this, oKey, oValue, 0L);
        }

        @Override
        public Object put(Object oKey, Object oValue, long cMillis) {
            this.checkAccess();
            return ((Optimistic)this.get_Module()).updateResourceOptimistically(this, oKey, oValue, cMillis);
        }

        @Override
        public Object putFinal(Object oKey, Object oValue, boolean fReturn) {
            return this.put(oKey, oValue);
        }

        @Override
        public Object remove(Object oKey) {
            this.checkAccess();
            return ((Optimistic)this.get_Module()).removeResourceOptimistically(this, oKey);
        }

        @Override
        public boolean unlock(Object oKey) {
            throw new UnsupportedOperationException();
        }

        static {
            CacheHandler.__initStatic();
        }
    }

    public static class LeaseRemoveAll
    extends Message {
        private int __m_CacheIndex;

        public LeaseRemoveAll() {
            this(null, null, true);
        }

        public LeaseRemoveAll(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(129);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new LeaseRemoveAll();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/replicatedCache/Optimistic$LeaseRemoveAll".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public int getCacheIndex() {
            return this.__m_CacheIndex;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            Optimistic service = (Optimistic)this.getService();
            service.onCacheClear(this.getCacheIndex());
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setCacheIndex(input.readInt());
        }

        public void setCacheIndex(int pCacheIndex) {
            this.__m_CacheIndex = pCacheIndex;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeInt(this.getCacheIndex());
        }
    }
}

