/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.partitionedCache;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.persistence.PersistentStore;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Lease;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.RequestContext;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.collections.AdvancingIterator;
import com.tangosol.coherence.component.util.collections.WrapperSet;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.tracing.Span;
import com.tangosol.internal.tracing.TracingHelper;
import com.tangosol.internal.util.BMEventFabric;
import com.tangosol.internal.util.Daemons;
import com.tangosol.internal.util.HeuristicCommitException;
import com.tangosol.internal.util.KeyIndexManager;
import com.tangosol.internal.util.LockContentionException;
import com.tangosol.internal.util.PartitionedIndexMap;
import com.tangosol.internal.util.QueryResult;
import com.tangosol.internal.util.SimpleBinaryEntry;
import com.tangosol.internal.util.SimpleQueryContext;
import com.tangosol.internal.util.UnsafeSubSet;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.SerializationSupport;
import com.tangosol.io.Serializer;
import com.tangosol.io.nio.BinaryMap;
import com.tangosol.io.nio.ByteBufferManager;
import com.tangosol.io.nio.MappedBufferManager;
import com.tangosol.net.BackingMapContext;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.cache.BinaryMemoryCalculator;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.cache.ReadWriteBackingMap;
import com.tangosol.net.events.Event;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.internal.StorageDispatcher;
import com.tangosol.net.events.partition.cache.EntryEvent;
import com.tangosol.net.internal.EntryInfo;
import com.tangosol.net.internal.StorageVersion;
import com.tangosol.net.internal.Trint;
import com.tangosol.net.management.Registry;
import com.tangosol.net.partition.ObservableSplittingBackingMap;
import com.tangosol.net.partition.PartitionAwareBackingMap;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.net.partition.PartitionSplittingBackingMap;
import com.tangosol.net.partition.PartitionStatistics;
import com.tangosol.net.partition.ReadWriteSplittingBackingMap;
import com.tangosol.net.security.LocalPermission;
import com.tangosol.net.security.StorageAccessAuthorizer;
import com.tangosol.persistence.CachePersistenceHelper;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.CopyOnWriteLongArray;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.FilterEnumerator;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.ImmutableMultiList;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.LiteSet;
import com.tangosol.util.LongArray;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapEventTransformer;
import com.tangosol.util.MapIndex;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapTrigger;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.QueryContext;
import com.tangosol.util.QueryRecord;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.SafeLinkedList;
import com.tangosol.util.SegmentedHashMap;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.SimpleMapIndex;
import com.tangosol.util.SimpleQueryRecord;
import com.tangosol.util.Streamer;
import com.tangosol.util.SubSet;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import com.tangosol.util.WrapperException;
import com.tangosol.util.WrapperObservableMap;
import com.tangosol.util.comparator.EntryComparator;
import com.tangosol.util.comparator.SafeComparator;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.extractor.IndexAwareExtractor;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.FilterTrigger;
import com.tangosol.util.filter.IndexAwareFilter;
import com.tangosol.util.filter.LimitFilter;
import com.tangosol.util.filter.NeverFilter;
import com.tangosol.util.filter.QueryRecorderFilter;
import com.tangosol.util.filter.ScriptFilter;
import com.tangosol.util.filter.WrapperQueryRecorderFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.Subject;

public class Storage
extends Util
implements BackingMapContext {
    private StorageAccessAuthorizer __m_AccessAuthorizer;
    private boolean __m_AdjustPartitionSize;
    private transient ConfigurableCacheMap __m_BackingConfigurableCache;
    private ObservableMap __m_BackingInternalCache;
    private PrivilegedAction __m_BackingMapAction;
    private transient int __m_BackingMapExpiryDelay;
    private ObservableMap __m_BackingMapInternal;
    private transient Map __m_BackupKeyListenerMap;
    private Map __m_BackupLeaseMap;
    private Map __m_BackupMap;
    private long __m_CacheId;
    private String __m_CacheName;
    private transient Map __m_ConfiguredBackupListeners;
    private transient Converter __m_ConverterKeyDown;
    private transient Converter __m_ConverterUp;
    private transient Converter __m_ConverterValueDown;
    private ConcurrentMap __m_EntryStatusMap;
    private EntryToBinaryEntryConverter __m_EntryToBinaryEntryConverter;
    private StorageDispatcher __m_EventDispatcher;
    private DispatcherInterceptor __m_EventDispatcherInterceptor;
    private EvictionTask __m_EvictionTask;
    private boolean __m_ExpirySliding;
    private Map __m_FilterIdMap;
    private Map __m_IndexExtractorMap;
    private boolean __m_InternBackupKeys;
    private boolean __m_InternPrimaryKeys;
    private Map __m_KeyListenerMap;
    private KeyToBinaryEntryConverter __m_KeyToBinaryEntryConverter;
    private Map __m_LeaseMap;
    private transient Map __m_ListenerMap;
    private boolean __m_MisconfigLoggedBackup;
    private boolean __m_MisconfigLoggedPrimary;
    private volatile transient boolean __m_OldValueRequired;
    private PartitionAwareBackingMap __m_PartitionAwareBackingMap;
    private PartitionAwareBackingMap __m_PartitionAwareBackupMap;
    private volatile Map __m_PartitionedIndexMap;
    private PartitionAwareBackingMap __m_PartitionedKeyIndex;
    private List __m_PendingLockRequest;
    private boolean __m_Persistent;
    private transient boolean __m_PotentiallyEvicting;
    private boolean __m_PreferPutAllBackup;
    private boolean __m_PreferPutAllPrimary;
    private transient MapListener __m_PrimaryListener;
    public static final int QUERY_AGGREGATE = 4;
    public static final int QUERY_ENTRIES = 2;
    public static final int QUERY_INVOKE = 3;
    public static final int QUERY_KEYS = 1;
    private int __m_QueryRetries;
    private Map __m_QuerySizeCache;
    private com.tangosol.util.ConcurrentMap __m_ResourceControlMap;
    private long __m_StatsEventsDispatched;
    private transient AtomicLong __m_StatsEvictions;
    private AtomicLong __m_StatsIndexingTotalMillis;
    private transient AtomicLong __m_StatsInserts;
    private AtomicLong __m_StatsListenerRegistrations;
    private String __m_StatsMaxQueryDescription;
    private long __m_StatsMaxQueryDurationMillis;
    private long __m_StatsMaxQueryThresholdMillis;
    private AtomicLong __m_StatsNonOptimizedQueryCount;
    private transient AtomicLong __m_StatsNonOptimizedQueryTotalMillis;
    private transient AtomicLong __m_StatsOptimizedQueryCount;
    private transient AtomicLong __m_StatsOptimizedQueryTotalMillis;
    private AtomicLong __m_StatsQueryContentionCount;
    private transient AtomicLong __m_StatsRemoves;
    private transient AtomicLong __m_StatsClears;
    private transient BinaryEntry __m_TempBinaryEntry;
    private volatile transient Set __m_TriggerSet;
    private volatile boolean __m_Valid;
    private StorageVersion __m_Version;
    private static ListMap __mapChildren;
    private static final Object[] EMPTY_OBJECT_ARRAY;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Advancer", Advancer.get_CLASS());
        __mapChildren.put("BackingManager", BackingManager.get_CLASS());
        __mapChildren.put("BackingMapAction", BackingMapAction.get_CLASS());
        __mapChildren.put("BinaryEntry", BinaryEntry.get_CLASS());
        __mapChildren.put("DeferredEvent", DeferredEvent.get_CLASS());
        __mapChildren.put("EnlistingConverter", EnlistingConverter.get_CLASS());
        __mapChildren.put("EntryStatus", EntryStatus.get_CLASS());
        __mapChildren.put("EntryToBinaryEntryConverter", EntryToBinaryEntryConverter.get_CLASS());
        __mapChildren.put("EvictionTask", EvictionTask.get_CLASS());
        __mapChildren.put("KeyToBinaryEntryConverter", KeyToBinaryEntryConverter.get_CLASS());
        __mapChildren.put("LazyKeySet", LazyKeySet.get_CLASS());
        __mapChildren.put("PrimaryListener", PrimaryListener.get_CLASS());
        __mapChildren.put("Scanner", Scanner.get_CLASS());
    }

    public Storage() {
        this(null, null, true);
    }

    public Storage(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setAdjustPartitionSize(true);
            this.setEntryStatusMap(new ConcurrentHashMap());
            this.setFilterIdMap(new SafeHashMap());
            this.setIndexExtractorMap(new SafeHashMap());
            this.setInternBackupKeys(false);
            this.setInternPrimaryKeys(false);
            this.setLeaseMap(new SegmentedHashMap());
            this.setPartitionedIndexMap(new ConcurrentHashMap());
            this.setPendingLockRequest(new SafeLinkedList());
            this.setStatsEvictions(new AtomicLong());
            this.setStatsIndexingTotalMillis(new AtomicLong());
            this.setStatsInserts(new AtomicLong());
            this.setStatsListenerRegistrations(new AtomicLong());
            this.setStatsMaxQueryThresholdMillis(30L);
            this.setStatsNonOptimizedQueryCount(new AtomicLong());
            this.setStatsNonOptimizedQueryTotalMillis(new AtomicLong());
            this.setStatsOptimizedQueryCount(new AtomicLong());
            this.setStatsOptimizedQueryTotalMillis(new AtomicLong());
            this.setStatsQueryContentionCount(new AtomicLong());
            this.setStatsRemoves(new AtomicLong());
            this.setStatsClears(new AtomicLong());
            this.setValid(false);
            this.setVersion(new StorageVersion());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new DispatcherInterceptor("DispatcherInterceptor", this, true), "DispatcherInterceptor");
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_PotentiallyEvicting = false;
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    public static Component get_Instance() {
        return new Storage();
    }

    public static Class get_CLASS() {
        return Storage.class;
    }

    private Component get_Module() {
        return this.get_Parent();
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Object accumulateMapEvents(Object oEvtHolderOld, Object oEvtHolderNew) {
        LinkedList<Object> listEvents = null;
        if (oEvtHolderOld == null) {
            return oEvtHolderNew;
        }
        if (oEvtHolderNew == null) {
            return oEvtHolderOld;
        }
        if (oEvtHolderOld instanceof PartitionedCache.MapEvent) {
            listEvents = new LinkedList<Object>();
            listEvents.add(oEvtHolderOld);
        } else {
            listEvents = (LinkedList<Object>)oEvtHolderOld;
        }
        if (oEvtHolderNew instanceof PartitionedCache.MapEvent) {
            listEvents.add(oEvtHolderNew);
        } else {
            listEvents.addAll((List)oEvtHolderNew);
        }
        return listEvents;
    }

    public void addIndex(ValueExtractor extractor) {
        int cEntries = 0;
        BinaryEntry entryTemp = this.instantiateBinaryEntry(null, null, true);
        for (Map.Entry entry : this.getBackingMapInternal().entrySet()) {
            entryTemp.reset((Binary)entry.getKey(), (Binary)entry.getValue());
            int nPart = this.getService().getKeyPartition(entryTemp.getBinaryKey());
            MapIndex index = (MapIndex)this.getPartitionIndexMap(nPart).get(extractor);
            if (index != null) {
                index.insert(entryTemp);
            }
            if ((++cEntries & 0x3FF) != 1023) continue;
            GuardSupport.heartbeat();
        }
    }

    public void addIndex(RequestContext context, PartitionSet partsMask, ValueExtractor extractor, Comparator comparator) {
        block8: {
            if (this.checkIndexExists(extractor, comparator, true)) break block8;
            this.checkAccess(context, 49152, 10);
            Object index = null;
            int iPart = partsMask.next(0);
            while (iPart >= 0) {
                this.createMapIndex(this.getPartitionIndexMap(iPart), extractor, comparator);
                iPart = partsMask.next(iPart + 1);
            }
            this.getIndexExtractorMap().put(extractor, comparator);
            this.persistIndexRegistration(partsMask, extractor, comparator, true);
            if (extractor instanceof IndexAwareExtractor) {
                ValueExtractor extractorReal = this.createMapIndex(new HashMap(), extractor, comparator).getValueExtractor();
                if (extractorReal == null) {
                    this.getIndexExtractorMap().remove(extractor);
                    throw new RuntimeException("IndexAwareExtractor \"" + extractor.getClass().getName() + "\" failed to obtain the underlying extractor");
                }
                extractor = extractorReal;
            }
            PartitionedCache service = this.getService();
            if (this.getService().getDaemonPool().isStarted()) {
                int iPart2 = partsMask.next(0);
                while (iPart2 >= 0) {
                    service.scheduleInitialIndexUpdate(iPart2, 1, this, extractor, (MapIndex)this.getPartitionIndexMap(iPart2).get(extractor));
                    iPart2 = partsMask.next(iPart2 + 1);
                }
            } else {
                try {
                    this.addIndex(extractor);
                }
                catch (Throwable e) {
                    Storage._trace("Exception occurred during index creation: " + Storage.getStackTrace(e), 1);
                    this.removeIndex(context, partsMask, extractor, comparator);
                    Storage.rethrow(e);
                }
            }
        }
    }

    public void addKeyListener(Member member, Binary binKey, boolean fLite, boolean fPrimary) {
        binKey = this.getCanonicalKey(binKey);
        this.addListenerProxy(fPrimary ? this.ensureKeyListenerMap() : this.ensureBackupKeyListenerMap(), binKey, member, fLite);
        if (fPrimary) {
            this.getStatsListenerRegistrations().incrementAndGet();
            if (!fLite) {
                this.ensureOldValueRequired();
            }
        }
    }

    public void addListener(Member member, Filter filter, long lFilterId, boolean fLite) {
        Set setFilterId;
        Serializable oFilter = filter == null ? Binary.EMPTY : filter;
        this.addListenerProxy(this.ensureListenerMap(), oFilter, member, fLite);
        Map mapFilterId = this.getFilterIdMap();
        SafeHashMap<Filter, SafeHashSet> mapMemberFilterId = (SafeHashMap<Filter, SafeHashSet>)mapFilterId.get(member);
        if (mapMemberFilterId == null) {
            mapMemberFilterId = new SafeHashMap<Filter, SafeHashSet>();
            mapFilterId.put(member, mapMemberFilterId);
        }
        if ((setFilterId = (Set)mapMemberFilterId.get(filter)) == null) {
            setFilterId = new SafeHashSet();
            mapMemberFilterId.put(filter, (SafeHashSet)setFilterId);
        }
        setFilterId.add(lFilterId);
        this.getStatsListenerRegistrations().incrementAndGet();
        if (!fLite) {
            this.ensureOldValueRequired();
        }
    }

    protected void addListenerProxy(Map map, Object anyKey, Member member, boolean fLite) {
        ConcurrentHashMap<Member, Boolean> mapMembers = (ConcurrentHashMap<Member, Boolean>)map.get(anyKey);
        if (mapMembers == null) {
            mapMembers = new ConcurrentHashMap<Member, Boolean>();
            map.put(anyKey, mapMembers);
        }
        if (!fLite || !mapMembers.containsKey(member)) {
            mapMembers.put(member, fLite);
        }
    }

    public void addTrigger(PartitionSet partsMask, MapTrigger trigger) {
        Set set = this.getTriggerSet();
        if (set == null) {
            set = new SafeHashSet();
            this.setTriggerSet(set);
        }
        set.add(trigger);
    }

    protected void adjustStorageStats(MapEvent evt, PartitionStatistics stats) {
        int nEvtType = evt.getId();
        BinaryMemoryCalculator calculator = BinaryMemoryCalculator.INSTANCE;
        switch (nEvtType) {
            case 1: {
                stats.adjustIndirectStorageSize(calculator.calculateUnits((Binary)evt.getKey(), (Binary)evt.getNewValue()));
                break;
            }
            case 2: {
                Binary binValueNew = (Binary)evt.getNewValue();
                Binary binValueOld = (Binary)evt.getOldValue();
                stats.adjustIndirectStorageSize(binValueNew.length() - binValueOld.length());
                break;
            }
            case 3: {
                stats.adjustIndirectStorageSize(-calculator.calculateUnits((Binary)evt.getKey(), (Binary)evt.getOldValue()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregateByProbe(Filter filter, InvocableMap.EntryAggregator agent, PartitionSet partMask, PartitionedCache.AggregateFilterRequest msgRequest, PartitionedCache.PartialValueResponse msgResponse) {
        PartitionedCache service = this.getService();
        int cPartitions = service.getPartitionCount();
        long cbScratch = service.reserveScratchSpace();
        boolean fPartial = agent instanceof InvocableMap.ParallelAwareAggregator.PartialResultAggregator;
        Long cbSize = (Long)this.getQuerySizeCache().get(filter);
        long cbPart = cbSize == null ? -1L : cbSize;
        int nProbePart = -1;
        if (TracingHelper.isEnabled()) {
            TracingHelper.augmentSpan().setMetadata("agent.class", agent.getClass().getName());
        }
        try {
            LinkedList listResult = new LinkedList();
            Converter converter = service.getBackingMapContext().getValueToInternalConverter();
            PartitionSet partQuery = new PartitionSet(cPartitions);
            if (cbPart == -1L && !partMask.isEmpty()) {
                nProbePart = partMask.rnd();
                partQuery.add(nProbePart);
                partMask.remove(nProbePart);
                QueryResult result = this.query(filter, 2, partQuery, msgRequest.checkTimeoutRemaining());
                Object[] aEntry = result.getResults();
                cbPart = 1L;
                int cEntries = result.getCount();
                for (int i = 0; i < cEntries; ++i) {
                    Binary binValue = ((BinaryEntry)aEntry[i]).getBinaryValue();
                    cbPart += binValue == null ? 0L : (long)binValue.length();
                }
                Object oResult = agent.aggregate(new ImmutableArrayList(aEntry, 0, cEntries).getSet());
                listResult.add(fPartial ? oResult : converter.convert(oResult));
                this.getQuerySizeCache().put(filter, cbPart);
            }
            int cPartsMax = Math.min(cPartitions, Math.max(1, (int)(cbScratch / (cbPart * 2L))));
            int nPartNext = partMask.next(0);
            while (nPartNext >= 0) {
                int nPartPrev = nPartNext;
                partQuery.clear();
                for (int i = 0; i < cPartsMax && nPartNext >= 0; ++i) {
                    partQuery.add(nPartNext);
                    nPartNext = partMask.next(nPartNext + 1);
                }
                if (partQuery.isEmpty()) break;
                try {
                    QueryResult result = this.query(filter, 2, partQuery, msgRequest.checkTimeoutRemaining());
                    Object oResult = agent.aggregate(new ImmutableArrayList(result.getResults(), 0, result.getCount()).getSet());
                    listResult.add(fPartial ? oResult : converter.convert(oResult));
                    service.checkInterrupt();
                }
                catch (OutOfMemoryError e) {
                    Storage._trace("Memory exhausted during aggregation of " + partQuery.cardinality() + " partitions: " + String.valueOf(filter), 2);
                    if (cPartsMax == 1) {
                        throw e;
                    }
                    cPartsMax = 1;
                    nPartNext = nPartPrev;
                }
            }
            if (fPartial) {
                Object oResult = null;
                int cResults = listResult.size();
                if (cResults > 1) {
                    oResult = ((InvocableMap.ParallelAwareAggregator.PartialResultAggregator)((Object)agent)).aggregatePartialResults(listResult);
                } else if (cResults == 1) {
                    oResult = listResult.get(0);
                }
                msgResponse.setResult(converter.convert(oResult));
            } else {
                msgResponse.setCollectionResult(listResult);
            }
        }
        finally {
            if (nProbePart != -1) {
                partMask.add(nProbePart);
            }
            service.releaseScratchSpace(cbScratch);
        }
    }

    public Object aggregateByStreaming(Filter filter, InvocableMap.StreamingAggregator agent, PartitionSet partMask, long cTimeoutMillis) {
        Span span = TracingHelper.getActiveSpan();
        if (!TracingHelper.isNoop(span)) {
            span.setMetadata("agent.class", agent.getClass().getName());
            if (filter != null) {
                span.setMetadata("filter", filter.toString());
            }
        }
        if (AlwaysFilter.INSTANCE.equals(filter)) {
            filter = null;
        }
        Object result = null;
        if (agent.isByPartition() && agent.isParallel() && Daemons.isForkJoinPoolEnabled()) {
            ForkJoinTask future = Daemons.forkJoinPool().submit(new PartitionedAggregateTask(this, filter, agent, partMask));
            try {
                result = (cTimeoutMillis == 0L ? future.get() : future.get(cTimeoutMillis, TimeUnit.MILLISECONDS));
            }
            catch (TimeoutException e) {
                future.cancel(true);
                throw new RequestTimeoutException("Aggregation request has timed out");
            }
            catch (InterruptedException e) {
                future.cancel(true);
                Thread.currentThread().interrupt();
                throw new RequestTimeoutException("Aggregation request has been interrupted");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            agent.accumulate(this.createStreamer(filter, agent, partMask));
            result = agent.getPartialResult();
        }
        return result;
    }

    public Object aggregateByStreaming(Set setKeys, InvocableMap.StreamingAggregator agent) {
        if (TracingHelper.isEnabled()) {
            TracingHelper.augmentSpan().setMetadata("agent.class", agent.getClass().getName());
        }
        agent.accumulate(this.createStreamer(setKeys, agent));
        return agent.getPartialResult();
    }

    protected QueryResult applyIndex(Filter filter, PartitionSet partMask) {
        Object[] aoResult = null;
        Filter<?> filterRemaining = filter;
        if (filter instanceof IndexAwareFilter) {
            IndexAwareFilter filterIx = (IndexAwareFilter)filter;
            try {
                UnsafeSubSet setKeys = new UnsafeSubSet(this.instantiateLazyKeySet(partMask, false), this.getManagerContext(), partMask);
                if (setKeys.isEmpty()) {
                    filterRemaining = null;
                    aoResult = EMPTY_OBJECT_ARRAY;
                } else {
                    filterRemaining = filterIx.applyIndex(this.getIndexMap(partMask), setKeys);
                    aoResult = setKeys.toArray();
                }
            }
            catch (ConcurrentModificationException e) {
                Storage._trace("Excessive concurrent updates while querying " + this.getCacheName() + ":\n" + Storage.getStackTrace(e) + "\nIgnoring exception and running snapshot-based query", 3);
                UnsafeSubSet setKeys = new UnsafeSubSet(this.instantiateLazyKeySet(partMask, true), this.getManagerContext(), partMask);
                filterRemaining = filterIx.applyIndex(this.getIndexMap(partMask), setKeys);
                aoResult = setKeys.toArray();
            }
            catch (Throwable e) {
                Storage._trace("Exception occurred during query processing: " + Storage.getStackTrace(e), 1);
                Storage.rethrow(e);
            }
        }
        return new QueryResult(partMask, aoResult, aoResult == null ? 0 : aoResult.length, filterRemaining);
    }

    public int calculateSize(PartitionSet partMask, boolean fStrict) {
        ConfigurableCacheMap mapCCM;
        PartitionedCache service = this.getService();
        PartitionAwareBackingMap mapKeys = this.getPartitionAwareBackingMap();
        if (mapKeys == null && (mapKeys = this.getPartitionedKeyIndex()) != null && fStrict && (mapCCM = this.getBackingConfigurableCache()) != null) {
            mapCCM.evict();
            service.processChanges();
        }
        if (mapKeys != null) {
            return mapKeys.getPartitionMap(partMask).size();
        }
        ObservableMap mapPrime = this.getBackingMapInternal();
        if (partMask.equals(service.collectOwnedPartitions(true))) {
            return mapPrime.size();
        }
        ConfigurableCacheMap mapCCM2 = this.getBackingConfigurableCache();
        if (fStrict && mapCCM2 != null) {
            mapCCM2.evict();
        }
        while (true) {
            int cSize = 0;
            try {
                Iterator iter = mapPrime.keySet().iterator();
                while (iter.hasNext()) {
                    if (!partMask.contains(service.getKeyPartition((Binary)iter.next()))) continue;
                    ++cSize;
                }
                return cSize;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    public void checkAccess(RequestContext context, int nAccessRequired, int nReason) {
        StorageAccessAuthorizer authorizer = this.getAccessAuthorizer();
        if (authorizer != null) {
            Subject subject = context == null ? null : context.getSubject();
            switch (nAccessRequired) {
                case 40960: {
                    authorizer.checkReadAny(this, subject, nReason);
                    break;
                }
                case 49152: {
                    authorizer.checkWriteAny(this, subject, nReason);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid access: " + nAccessRequired);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long checkBackingMapVersion(Map mapPrime, PartitionSet partMask) {
        PartitionAwareBackingMap pabm = this.getPartitionAwareBackingMap();
        if (pabm == null) {
            Map map = mapPrime;
            synchronized (map) {
                return this.getVersion().getSubmittedVersion();
            }
        }
        Map map = pabm.getPartitionMap(partMask.first());
        if (map != null) {
            Map map2 = map;
            synchronized (map2) {
                return this.getVersion().getSubmittedVersion();
            }
        }
        return this.getVersion().getSubmittedVersion();
    }

    protected int checkIndexConsistency(Filter filter, Object[] aoResult, int cResults, int nQueryType, PartitionSet partMask, long lIdxVersion) {
        PartitionedCache service = (PartitionedCache)this.get_Module();
        ObservableMap mapPrime = this.getBackingMapInternal();
        long lBMVersion = -1L;
        StorageVersion version = this.getVersion();
        if (lIdxVersion != -1L) {
            lBMVersion = this.checkBackingMapVersion(mapPrime, partMask);
        }
        if (lIdxVersion < lBMVersion) {
            partMask = version.getModifiedPartitions(lIdxVersion, partMask);
            HashMap mapEval = new HashMap();
            boolean fInvoke = nQueryType == 3;
            for (int i = 0; i < cResults; ++i) {
                int nPartition;
                Binary binKey;
                if (fInvoke) {
                    EntryStatus status = (EntryStatus)aoResult[i];
                    binKey = status.getKey();
                    nPartition = status.getPartition();
                } else {
                    binKey = ((BinaryEntry)aoResult[i]).getBinaryKey();
                    nPartition = service.getKeyPartition(binKey);
                }
                if (!partMask.contains(nPartition)) continue;
                mapEval.put(binKey, null);
                aoResult[i] = binKey;
            }
            if (!mapEval.isEmpty()) {
                this.reevaluateQueryResults(filter, mapEval, nQueryType, partMask);
                int iW = 0;
                for (int iR = 0; iR < cResults; ++iR) {
                    Object oTest = aoResult[iR];
                    if (!(oTest instanceof Binary)) {
                        aoResult[iW++] = oTest;
                        continue;
                    }
                    Binary binKey = (Binary)oTest;
                    Object oValue = mapEval.get(binKey);
                    if (oValue == null) {
                        aoResult[iR] = null;
                        continue;
                    }
                    aoResult[iW++] = oValue;
                }
                cResults = iW;
            }
        }
        return cResults;
    }

    protected boolean checkIndexExists(ValueExtractor extractor, Comparator comparator, boolean fValidate) {
        Map mapIndexExtractor = this.getIndexExtractorMap();
        if (!mapIndexExtractor.isEmpty() && mapIndexExtractor.containsKey(extractor)) {
            if (fValidate && !Base.equals(comparator, mapIndexExtractor.get(extractor))) {
                throw new IllegalArgumentException("An incompatible index for " + String.valueOf(extractor) + " already exists; remove the index and add it with the new settings");
            }
            return true;
        }
        return false;
    }

    public void clear(PartitionedCache.InvocationContext ctxInvoke, PartitionSet partMask) {
        ObservableMap mapResource = this.getBackingMapInternal();
        PartitionAwareBackingMap mapPABM = this.getPartitionAwareBackingMap();
        Set setKeys = this.collectKeySet(partMask, false);
        FilterTrigger triggerRemove = new FilterTrigger(NeverFilter.INSTANCE, 4);
        Map mapEntries = Collections.singletonMap(this, ConverterCollections.getCollection(setKeys, this.instantiateEnlistingConverter(ctxInvoke, triggerRemove), NullImplementation.getConverter()));
        ctxInvoke.processInterceptors(mapEntries);
        if (mapPABM == null || mapPABM instanceof ReadWriteSplittingBackingMap || ctxInvoke.hasEntriesEnlisted(this)) {
            for (Binary binKey : setKeys) {
                if (ctxInvoke.hasEntryEnlisted(this, binKey)) continue;
                mapResource.remove(binKey);
            }
        } else {
            int iPart = partMask.next(0);
            while (iPart >= 0) {
                mapPABM.getPartitionMap(iPart).clear();
                iPart = partMask.next(iPart + 1);
            }
        }
        ctxInvoke.postInvoke();
        this.getStatsClears().incrementAndGet();
    }

    public Object[] collectKeys(int iPartition, Object[] aoKeys) {
        Set setKeys = this.getKeySet(iPartition);
        return setKeys == null ? this.collectKeySet(iPartition).toArray(aoKeys) : setKeys.toArray(aoKeys);
    }

    protected Object[] collectKeys(PartitionSet partMask) {
        PartitionAwareBackingMap pabmPrime = this.getPartitionAwareBackingMap();
        if (pabmPrime != null) {
            return Storage.extractPartitionedKeys(pabmPrime, partMask);
        }
        PartitionAwareBackingMap mapKeyIndex = this.getPartitionedKeyIndex();
        if (mapKeyIndex != null) {
            return Storage.extractPartitionedKeys(mapKeyIndex, partMask);
        }
        return this.extractKeysDirect(this.getBackingMapInternal(), partMask).toArray();
    }

    public Set collectKeySet(int iPartition) {
        Set setKeys = this.getKeySet(iPartition);
        if (setKeys == null) {
            ObservableMap mapPrime = this.getBackingMapInternal();
            if (mapPrime.isEmpty()) {
                return Collections.EMPTY_SET;
            }
            Storage._trace("Collecting keys for partition " + iPartition + ": " + this.getCacheName(), 4);
            return this.extractKeysDirect(mapPrime, this.getService().instantiatePartitionSet(iPartition));
        }
        return new ImmutableArrayList(setKeys.toArray());
    }

    public Set collectKeySet(PartitionSet partMask, boolean fSnapshot) {
        ObservableMap mapPrime = this.getBackingMapInternal();
        PartitionAwareBackingMap mapKeys = this.getPartitionAwareBackingMap();
        PartitionAwareBackingMap partitionAwareBackingMap = mapKeys = mapKeys == null ? this.getPartitionedKeyIndex() : mapKeys;
        if (mapKeys != null) {
            return fSnapshot ? Storage.extractPartitionedKeySet(mapKeys, partMask) : mapKeys.getPartitionMap(partMask).keySet();
        }
        return this.extractKeysDirect(mapPrime, partMask);
    }

    public static Binary compressResult(ReadBuffer bufResult, ReadBuffer bufValueOld, ReadBuffer bufValueNew) {
        return Base.equals(bufResult, bufValueOld) ? Binary.EMPTY : ExternalizableHelper.asBinary(bufResult);
    }

    public boolean containsKey(Binary binKey) {
        return this.getBackingMapInternal().containsKey(binKey);
    }

    public boolean containsValue(Binary binValue) {
        return this.getBackingMapInternal().containsValue(binValue);
    }

    protected ConverterCollections.ConverterMapEvent createConverterEvent(int nEventType, Binary binKey, Binary binValueOld, Binary binValueNew, BinaryEntry binEntry) {
        Converter conv = this.getConverterUp();
        ObservableMap mapProxy = NullImplementation.getObservableMap();
        CacheEvent<Binary, Binary> evtProxy = new CacheEvent<Binary, Binary>(mapProxy, nEventType & 7, binKey, binValueOld, binValueNew, (nEventType & 8) != 0, CacheEvent.TransformationState.TRANSFORMABLE, false, (nEventType & 0x80) != 0);
        ConverterCollections.ConverterMapEvent evt = (ConverterCollections.ConverterMapEvent)ConverterCollections.getMapEvent(mapProxy, evtProxy, conv, conv, this.getService().getBackingMapContext());
        if (binEntry != null && binEntry.isValueConverted()) {
            Binary binValue = binEntry.getBinaryValue();
            if (binValueNew == binValue) {
                evt.setNewValue(binEntry.getValue());
            } else if (binValueOld == binValue) {
                evt.setOldValue(binEntry.getValue());
            }
        }
        return evt;
    }

    protected List createIndexBatch(BinaryEntry[] aEntry, int cEntries, int nPartition, Map mapIndex, long lIdxVersion) {
        int i;
        StorageVersion version = this.getVersion();
        for (i = 0; i < cEntries; ++i) {
            List listFailed = this.updateIndex(1, aEntry[i], mapIndex);
            if (listFailed == null) continue;
            return listFailed;
        }
        if (!version.isPartitionModified(lIdxVersion, nPartition)) {
            return null;
        }
        for (i = 0; i < cEntries; ++i) {
            this.updateIndex(3, aEntry[i], mapIndex);
        }
        PartitionedCache service = this.getService();
        service.processChanges();
        lIdxVersion = version.waitForPendingCommit(nPartition);
        ObservableMap map = this.getBackingMapInternal();
        block2: for (int i2 = 0; i2 < cEntries; ++i2) {
            Binary binVal;
            BinaryEntry entry = aEntry[i2];
            Binary binKey = entry.getBinaryKey();
            while ((binVal = (Binary)map.get(binKey)) != null) {
                entry.reset(binKey, binVal);
                List listFailed = this.updateIndex(1, entry, mapIndex);
                if (listFailed != null) {
                    return listFailed;
                }
                if (!version.isPartitionModified(lIdxVersion, nPartition)) continue block2;
                this.updateIndex(3, entry, mapIndex);
                service.processChanges();
                lIdxVersion = version.waitForPendingCommit(nPartition);
            }
        }
        service.processChanges();
        return null;
    }

    public MapIndex createMapIndex(Map mapIndex, ValueExtractor extractor, Comparator comparator) {
        MapIndex index;
        boolean fOrdered;
        boolean bl = fOrdered = comparator != null;
        if (extractor instanceof IndexAwareExtractor) {
            index = ((IndexAwareExtractor)extractor).createIndex(fOrdered, comparator, mapIndex, this);
            if (index == null) {
                return null;
            }
            if (!(index instanceof SimpleMapIndex) || !((SimpleMapIndex)index).isForwardIndexSupported()) {
                this.ensureOldValueRequired();
            }
        } else {
            index = new SimpleMapIndex(extractor, fOrdered, comparator, this);
            mapIndex.put(extractor, index);
        }
        return index;
    }

    public List createPartitionIndex(int nPartition, Map mapIndex) {
        List listFailed;
        int cBatchMax;
        StorageVersion version = this.getVersion();
        long lIdxVersion = version.waitForPendingCommit(nPartition);
        Set setKeys = this.getKeySet(nPartition);
        if (setKeys == null) {
            setKeys = this.collectKeySet(nPartition);
        }
        if ((cBatchMax = Math.min(setKeys.size(), 16)) == 0) {
            return null;
        }
        BinaryEntry[] aEntry = new BinaryEntry[cBatchMax];
        for (int i = 0; i < cBatchMax; ++i) {
            aEntry[i] = this.instantiateBinaryEntry(null, null, true);
        }
        ObservableMap mapInternal = this.getBackingMapInternal();
        int cProcessed = 0;
        int cBatch = 0;
        for (Binary binKey : setKeys) {
            Binary binVal = (Binary)mapInternal.get(binKey);
            if (binVal == null) continue;
            aEntry[cBatch++].reset(binKey, binVal);
            if (cBatch == cBatchMax) {
                List listFailed2 = this.createIndexBatch(aEntry, cBatch, nPartition, mapIndex, lIdxVersion);
                if (listFailed2 != null) {
                    return listFailed2;
                }
                lIdxVersion = version.waitForPendingCommit(nPartition);
                cBatch = 0;
            }
            if ((++cProcessed & 0x3FF) != 1023) continue;
            GuardSupport.heartbeat();
        }
        if (cBatch > 0 && (listFailed = this.createIndexBatch(aEntry, cBatch, nPartition, mapIndex, lIdxVersion)) != null) {
            return listFailed;
        }
        return null;
    }

    protected int createQueryResult(Filter filterOrig, Object[] aoResult, int nQueryType, PartitionSet partMask, long lIdxVersion) {
        if (nQueryType == 1 || nQueryType == 4) {
            return aoResult.length;
        }
        ObservableMap mapPrime = this.getBackingInternalCache();
        int cResults = 0;
        boolean fInvoke = nQueryType == 3;
        PartitionedCache.InvocationContext ctxInvoke = fInvoke ? this.getService().getInvocationContext() : null;
        int c = aoResult.length;
        for (int i = 0; i < c; ++i) {
            Binary binKey = (Binary)aoResult[i];
            Binary binValue = (Binary)mapPrime.get(binKey);
            if (binValue != null) {
                BinaryEntry entry;
                EntryStatus status = fInvoke ? ctxInvoke.lockEntry(this, binKey, false) : null;
                BinaryEntry binaryEntry = entry = fInvoke ? status.getBinaryEntry().setBinaryValue(binValue) : this.instantiateBinaryEntry(binKey, binValue, true);
                if (filterOrig == null || InvocableMapHelper.evaluateEntry(filterOrig, entry)) {
                    Object object = aoResult[cResults++] = fInvoke ? status : entry;
                }
            }
            if ((i & 0x3FF) != 1023) continue;
            this.getService().checkInterrupt();
        }
        return this.checkIndexConsistency(filterOrig, aoResult, cResults, nQueryType, partMask, lIdxVersion);
    }

    protected int createQueryResult(Filter filter, Filter filterOrig, Object[] aoResult, int nQueryType, PartitionSet partMask, long lIdxVersion) {
        ObservableMap mapPrime = this.getBackingInternalCache();
        boolean fKeys = nQueryType == 1 || nQueryType == 4;
        boolean fInvoke = nQueryType == 3;
        boolean fSame = filter == filterOrig;
        int cLimit = Integer.MAX_VALUE;
        if (filterOrig instanceof LimitFilter) {
            LimitFilter filterLimit = (LimitFilter)filterOrig;
            if (nQueryType == 1 || filterLimit.getComparator() == null) {
                Object oAnchorTop = filterLimit.getTopAnchor();
                int cPageSize = filterLimit.getPageSize();
                cLimit = cPageSize + (oAnchorTop instanceof Integer ? (Integer)oAnchorTop : filterLimit.getPage() * cPageSize);
            }
            filterOrig = filterLimit.getFilter();
        }
        PartitionedCache.InvocationContext ctxInvoke = fInvoke ? this.getService().getInvocationContext() : null;
        BinaryEntry tmpEntry = this.instantiateBinaryEntry(null, null, true);
        int cResults = 0;
        int c = aoResult.length;
        for (int i = 0; i < c && cResults < cLimit; ++i) {
            Binary binKey = (Binary)aoResult[i];
            Binary binValue = (Binary)mapPrime.get(binKey);
            if (binValue != null && InvocableMapHelper.evaluateEntry(filter, tmpEntry.reset(binKey, binValue))) {
                if (fKeys) {
                    aoResult[cResults++] = binKey;
                } else {
                    BinaryEntry entry;
                    EntryStatus status = fInvoke ? ctxInvoke.lockEntry(this, binKey, false) : null;
                    BinaryEntry binaryEntry = entry = fInvoke ? status.getBinaryEntry().setBinaryValue(binValue) : this.instantiateBinaryEntry(binKey, binValue, true);
                    if (tmpEntry.isKeyConverted()) {
                        entry.setConvertedKey(tmpEntry.getConvertedKey()).setState(entry.getState() | 2);
                    }
                    if (tmpEntry.isValueConverted()) {
                        entry.setConvertedValue(tmpEntry.getConvertedValue()).setState(entry.getState() | 8);
                    }
                    if (fSame || InvocableMapHelper.evaluateEntry(filterOrig, entry)) {
                        Object object = aoResult[cResults++] = fInvoke ? status : entry;
                    }
                }
            }
            if ((i & 0x3FF) != 1023) continue;
            this.getService().checkInterrupt();
        }
        return fKeys ? cResults : this.checkIndexConsistency(filterOrig, aoResult, cResults, nQueryType, partMask, lIdxVersion);
    }

    protected Streamer createStreamer(Filter filter, InvocableMap.StreamingAggregator agent, PartitionSet partMask) {
        if (filter == null || !this.isIndexed()) {
            Scanner scanner = (Scanner)this._newChild("Scanner");
            scanner.setFilter(filter);
            scanner.setPartitions(partMask);
            scanner.setReuseAllowed(!agent.isRetainsEntries());
            return scanner;
        }
        long lVersion = this.getVersion().getCommittedVersion();
        QueryResult result = this.query(filter, 4, partMask, 0L);
        Advancer advancer = (Advancer)this._newChild("Advancer");
        advancer.setIterator(new SimpleEnumerator<Object>(result.getResults()));
        advancer.setSize(result.getCount());
        advancer.setFilter(result.getFilterRemaining());
        advancer.setFilterOriginal(filter);
        advancer.setVersion(lVersion);
        advancer.setPresentOnly(true);
        advancer.setReuseAllowed(!agent.isRetainsEntries());
        advancer.setCheckVersion(!agent.isAllowInconsistencies() && this.getQueryRetries() > 0);
        return advancer;
    }

    protected Streamer createStreamer(Set setKeys, InvocableMap.StreamingAggregator agent) {
        Advancer advancer = (Advancer)this._newChild("Advancer");
        advancer.setIterator(setKeys.iterator());
        advancer.setVersion(Long.MAX_VALUE);
        advancer.setReuseAllowed(!agent.isRetainsEntries());
        boolean fPresentOnly = agent.isPresentOnly();
        advancer.setPresentOnly(fPresentOnly);
        if (fPresentOnly) {
            advancer.setSize(-setKeys.size());
            this.getService().getInvocationContext().setAllowReadThrough(false);
        } else {
            advancer.setSize(setKeys.size());
        }
        return advancer;
    }

    protected long decodeExpiry(Binary binValue) {
        long cExpiry = ExternalizableHelper.decodeExpiry(binValue);
        return cExpiry == -1L || cExpiry == 0L ? cExpiry : Math.max(cExpiry - this.getService().getClusterTime(), 1L);
    }

    public static Binary decompressResult(Binary binResult, Binary binValueOld, Binary binValueNew) {
        return Binary.EMPTY.equals(binResult) ? binValueOld : binResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBackingMapEvent(MapEvent evt) {
        block20: {
            PartitionedCache service = this.getService();
            Binary binKey = (Binary)evt.getKey();
            int iPartition = service.getKeyPartition(binKey);
            int nOwner = service.getPartitionAssignments()[iPartition][0];
            int nMemberThis = service.getThisMember().getId();
            int nEvent = evt.getId();
            if (nOwner == nMemberThis) {
                PartitionedCache.ResourceCoordinator coordinator = this.getResourceCoordinator();
                BMEventFabric.EventQueue queueByThd = coordinator.getEventQueue();
                switch (nEvent) {
                    case 1: {
                        this.getStatsInserts().incrementAndGet();
                        break;
                    }
                    case 3: {
                        if (evt instanceof CacheEvent && ((CacheEvent)evt).isSynthetic()) {
                            this.getStatsEvictions().incrementAndGet();
                        } else {
                            this.getStatsRemoves().incrementAndGet();
                        }
                    }
                    default: {
                        if (!this.isOldValueRequired()) break;
                        evt.getOldValue();
                    }
                }
                while (true) {
                    EntryStatus status;
                    EntryStatus entryStatus = status = coordinator.ensureStatus(this, binKey);
                    synchronized (entryStatus) {
                        if (status.isActive()) {
                            boolean fExpiryOnly;
                            PartitionedCache.InvocationContext ctxInvoke = service.getInvocationContext();
                            BinaryEntry binEntry = status.getBinaryEntry();
                            if (ctxInvoke != null && ctxInvoke.hasEntryEnlisted(this, binKey) && binEntry != null && !binEntry.isValueChanged() && nEvent == 1) {
                                binEntry.updateLoadedValue((Binary)evt.getNewValue());
                            }
                            boolean bl = fExpiryOnly = ctxInvoke != null && (ctxInvoke.isReadOnlyRequest() || status.isExpiryOnly()) && Base.equals(evt.getOldValue(), evt.getNewValue());
                            if (!fExpiryOnly) {
                                long lPartVersion = this.getVersion().submit(iPartition);
                                evt = evt.with(iPartition, lPartVersion);
                                status.addRawMapEvent(evt);
                            }
                            BMEventFabric fabric = coordinator.getEventFabric();
                            BMEventFabric.EventHolder holder = BMEventFabric.createEventHolder(status, evt, coordinator.getIdCounter().incrementAndGet());
                            fabric.add(holder, queueByThd, status.getEventQueue());
                            break block20;
                        }
                    }
                }
            }
            if (nEvent != 3) {
                Binary binValueOld = (Binary)evt.getOldValue();
                Binary binValueNew = (Binary)evt.getNewValue();
                if (binValueOld != null && binValueNew != null && (ExternalizableHelper.isDecorated(binValueOld) || ExternalizableHelper.isDecorated(binValueNew)) && ExternalizableHelper.getUndecorated(binValueOld).equals(ExternalizableHelper.getUndecorated(binValueNew))) {
                    if (ExternalizableHelper.isDecorated(binValueOld, 2) && !ExternalizableHelper.isDecorated(binValueNew, 2)) {
                        Storage._trace("Asynchronous write-behind operation for key " + String.valueOf(binKey) + " in partition " + iPartition + " of the partitioned cache \"" + this.getCacheName() + "\" has completed after the partition has been moved, which may cause a duplicate \"store\" operation by the new owner.\n", 1);
                    }
                } else {
                    Storage._trace("An entry was inserted into the backing map for the partitioned cache \"" + this.getCacheName() + "\" in partition " + iPartition + " which is not owned by this member; the entry will be removed.\n" + String.valueOf(evt) + "\n" + Storage.get_StackTrace(), 1);
                }
                try {
                    evt.getMap().keySet().remove(binKey);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public Binary encodeExpiry(Binary binValue, long cMillis) {
        if (cMillis < 0L) {
            cMillis = -1L;
        }
        if (cMillis != 0L && cMillis != -1L) {
            cMillis += this.getService().getClusterTime();
        }
        return ExternalizableHelper.asBinary(ExternalizableHelper.encodeExpiry(binValue, cMillis));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map ensureBackupKeyListenerMap() {
        SafeHashMap map = this.getBackupKeyListenerMap();
        if (map == null) {
            Storage storage = this;
            synchronized (storage) {
                map = this.getBackupKeyListenerMap();
                if (map == null) {
                    map = new SafeHashMap();
                    this.setBackupKeyListenerMap(map);
                }
            }
        }
        return map;
    }

    public void ensureInitialized(String sName) {
        this.ensureInitialized(sName, false);
    }

    public void ensureInitialized(String sName, boolean fRegisterExtents) {
        Storage._assert(sName != null);
        if (this.is_Constructed()) {
            Registry registry;
            PartitionedCache service = this.getService();
            Storage._assert(Thread.currentThread() == service.getThread());
            String sNameOld = this.getCacheName();
            if (sNameOld != null) {
                if (sNameOld.equals(sName)) {
                    return;
                }
                throw new IllegalStateException("Attempt to modify the CacheName: " + String.valueOf(this) + " to " + sName);
            }
            this.instantiateBackingMap(sName);
            if (service.getBackupCount() > 0) {
                this.instantiateBackupMap(sName);
            }
            this.setCacheName(sName);
            if (fRegisterExtents) {
                this.preparePersistentExtent();
            }
            if ((registry = service.getCluster().getManagement()) != null) {
                String sBean = "type=StorageManager" + ",service=" + service.getServiceName() + ",cache=" + sName;
                registry.register(registry.ensureGlobalName(sBean), this);
            }
            service.getEventsHelper().onCacheConfigured(this);
            this.setValid(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map ensureKeyListenerMap() {
        SafeHashMap map = this.getKeyListenerMap();
        if (map == null) {
            Storage storage = this;
            synchronized (storage) {
                map = this.getKeyListenerMap();
                if (map == null) {
                    map = new SafeHashMap();
                    this.setKeyListenerMap(map);
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map ensureListenerMap() {
        ConcurrentHashMap map = this.getListenerMap();
        if (map == null) {
            Storage storage = this;
            synchronized (storage) {
                map = this.getListenerMap();
                if (map == null) {
                    map = new ConcurrentHashMap();
                    this.setListenerMap(map);
                }
            }
        }
        return map;
    }

    public void ensureOldValueRequired() {
        if (!this.isOldValueRequired()) {
            this.setOldValueRequired(true);
        }
    }

    public static void ensurePartition(PartitionAwareBackingMap mapPartitioned, int iPartition) {
        if (mapPartitioned.getPartitionMap(iPartition) == null) {
            mapPartitioned.createPartition(iPartition);
        }
    }

    public QueryRecord.PartialResult explain(Filter filter, PartitionSet partMask) {
        SimpleQueryContext ctx = new SimpleQueryContext(this);
        SimpleQueryRecord.PartialResult result = new SimpleQueryRecord.PartialResult(ctx, partMask);
        Set setKeys = this.collectKeySet(partMask, true);
        if (!setKeys.isEmpty()) {
            QueryRecorderFilter filterRecorder = filter instanceof QueryRecorderFilter ? (QueryRecorderFilter)filter : new WrapperQueryRecorderFilter(filter);
            filterRecorder.explain(ctx, result.instantiateExplainStep(filter), setKeys);
        }
        return result;
    }

    protected Object[] extractBinaryEntries(Object[] aEntry, LimitFilter filterLimit) {
        EntryComparator comparator = new EntryComparator(filterLimit.getComparator(), 3);
        Arrays.sort(aEntry, comparator);
        filterLimit = (LimitFilter)filterLimit.clone();
        filterLimit.setComparator(comparator);
        aEntry = filterLimit.extractPage(aEntry);
        return aEntry;
    }

    protected Set extractKeysDirect(Map map, PartitionSet partMask) {
        PartitionedCache service = this.getService();
        HashSet<Binary> setKeys = new HashSet<Binary>();
        while (true) {
            try {
                for (Binary binKey : map.keySet()) {
                    if (!partMask.contains(service.getKeyPartition(binKey))) continue;
                    setKeys.add(binKey);
                }
                return setKeys;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    private static Object[] extractPartitionedKeys(PartitionAwareBackingMap mapPartitioned, PartitionSet partMask) {
        int cPartitions = partMask.cardinality();
        if (cPartitions == 1) {
            return mapPartitioned.getPartitionMap(partMask.next(0)).keySet().toArray();
        }
        if (cPartitions == 0) {
            return ClassHelper.VOID;
        }
        Object[][] aaoKeys = new Object[cPartitions][];
        int cTotal = 0;
        int i = 0;
        int iPartition = partMask.next(0);
        while (iPartition >= 0) {
            Object[] ao = mapPartitioned.getPartitionMap(iPartition).keySet().toArray();
            aaoKeys[i] = ao;
            cTotal += ao.length;
            ++i;
            iPartition = partMask.next(iPartition + 1);
        }
        return ImmutableMultiList.flatten(aaoKeys, cTotal, null);
    }

    private static Set extractPartitionedKeySet(PartitionAwareBackingMap mapPartitioned, PartitionSet partMask) {
        int cPartitions = partMask.cardinality();
        if (cPartitions == 1) {
            return new ImmutableArrayList(mapPartitioned.getPartitionMap(partMask.next(0)).keySet().toArray()).getSet();
        }
        if (cPartitions == 0) {
            return NullImplementation.getSet();
        }
        Object[][] aaoKeys = new Object[cPartitions][];
        int i = 0;
        int iPartition = partMask.next(0);
        while (iPartition >= 0) {
            aaoKeys[i] = mapPartitioned.getPartitionMap(iPartition).keySet().toArray();
            ++i;
            iPartition = partMask.next(iPartition + 1);
        }
        return new ImmutableMultiList(aaoKeys).getSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePendingLocks(int iPartition) {
        List listPending;
        PartitionedCache service = this.getService();
        ArrayList<PartitionedCache.LockRequest> listFire = null;
        List list = listPending = this.getPendingLockRequest();
        synchronized (list) {
            if (!listPending.isEmpty()) {
                listFire = new ArrayList<PartitionedCache.LockRequest>(listPending.size());
                Iterator iter = listPending.iterator();
                while (iter.hasNext()) {
                    PartitionedCache.LockRequest msgLock = (PartitionedCache.LockRequest)iter.next();
                    if (service.getKeyPartition(msgLock.getKey()) != iPartition) continue;
                    iter.remove();
                    listFire.add(msgLock);
                }
            }
        }
        if (listFire != null && !listFire.isEmpty()) {
            for (PartitionedCache.LockRequest msgLock : listFire) {
                try {
                    msgLock.onReceived();
                }
                catch (EventDeathException eventDeathException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePendingLocks(Binary binKey) {
        List listPending;
        ArrayList<PartitionedCache.LockRequest> listFire = null;
        List list = listPending = this.getPendingLockRequest();
        synchronized (list) {
            if (!listPending.isEmpty()) {
                listFire = new ArrayList<PartitionedCache.LockRequest>(listPending.size());
                Iterator iter = listPending.iterator();
                while (iter.hasNext()) {
                    PartitionedCache.LockRequest msgLock = (PartitionedCache.LockRequest)iter.next();
                    if (!msgLock.getKey().equals(binKey)) continue;
                    iter.remove();
                    listFire.add(msgLock);
                }
            }
        }
        if (listFire != null && !listFire.isEmpty()) {
            PartitionedCache service = this.getService();
            for (PartitionedCache.LockRequest msgLock : listFire) {
                try {
                    if (Thread.currentThread() == service.getThread()) {
                        msgLock.onReceived();
                        continue;
                    }
                    service.onLockRequest(msgLock);
                }
                catch (EventDeathException eventDeathException) {}
            }
        }
    }

    public Binary get(PartitionedCache.InvocationContext ctxInvoke, EntryStatus status, Binary binKey) {
        ObservableMap mapPrime = this.getBackingMapInternal();
        Binary binValue = (Binary)mapPrime.get(binKey);
        boolean fRWBM = mapPrime instanceof ReadWriteBackingMap;
        if (fRWBM) {
            BinaryEntry binEntry = status.getBinaryEntry();
            if (binEntry.isValueLoaded()) {
                binEntry.ensureReadOnly();
            }
            ctxInvoke.processInterceptors();
        }
        if (fRWBM || this.isExpirySliding()) {
            ctxInvoke.postInvoke();
        }
        return binValue;
    }

    public StorageAccessAuthorizer getAccessAuthorizer() {
        return this.__m_AccessAuthorizer;
    }

    public Map getAll(PartitionedCache.InvocationContext ctxInvoke, Collection colKeys) {
        Map<Binary, Binary> mapResult;
        ObservableMap mapPrime = this.getBackingMapInternal();
        if (mapPrime instanceof CacheMap) {
            mapResult = ((CacheMap)mapPrime).getAll(colKeys);
        } else {
            mapResult = new HashMap(colKeys.size());
            for (Binary binKey : colKeys) {
                Binary binVal = (Binary)mapPrime.get(binKey);
                if (binVal == null) continue;
                mapResult.put(binKey, binVal);
            }
        }
        boolean fRWBM = mapPrime instanceof ReadWriteBackingMap;
        if (fRWBM) {
            for (EntryStatus status : ctxInvoke.getEntryStatuses()) {
                BinaryEntry binEntry = status.getBinaryEntry();
                if (!binEntry.isValueLoaded()) continue;
                binEntry.ensureReadOnly();
            }
            ctxInvoke.processInterceptors();
        }
        if (fRWBM || this.isExpirySliding()) {
            ctxInvoke.postInvoke();
        }
        return mapResult;
    }

    public Map getAllFromBackup(Map mapPartKeys, PartitionSet partsReject) {
        PartitionAwareBackingMap mapPABM = this.getPartitionAwareBackupMap();
        Map mapBackup = this.getBackupMap();
        HashMap<Binary, Binary> mapResult = null;
        PartitionedCache service = this.getService();
        for (Map.Entry entry : mapPartKeys.entrySet()) {
            int iPart = (Integer)entry.getKey();
            Collection colPartKeys = (Collection)entry.getValue();
            Map mapSrc = mapPABM == null ? mapBackup : mapPABM.getPartitionMap(iPart);
            HashMap<Binary, Binary> mapResultTmp = new HashMap<Binary, Binary>(colPartKeys.size());
            for (Binary binKey : colPartKeys) {
                Binary binVal = (Binary)mapSrc.get(binKey);
                if (binVal == null) continue;
                mapResultTmp.put(binKey, binVal);
            }
            if (service.isBackupOwner(iPart)) {
                if (mapResult == null) {
                    mapResult = mapResultTmp;
                    continue;
                }
                mapResult.putAll(mapResultTmp);
                continue;
            }
            partsReject.add(iPart);
        }
        return mapResult;
    }

    public ConfigurableCacheMap getBackingConfigurableCache() {
        return this.__m_BackingConfigurableCache;
    }

    public ObservableMap getBackingInternalCache() {
        return this.__m_BackingInternalCache;
    }

    @Override
    public ObservableMap getBackingMap() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(LocalPermission.BACKING_MAP);
        }
        return this.getBackingMapInternal();
    }

    public PrivilegedAction getBackingMapAction() {
        return this.__m_BackingMapAction;
    }

    @Override
    public InvocableMap.Entry getBackingMapEntry(Object oKey) {
        throw new IllegalStateException("Context is not transactional");
    }

    public int getBackingMapExpiryDelay() {
        return this.__m_BackingMapExpiryDelay;
    }

    public ObservableMap getBackingMapInternal() {
        return this.__m_BackingMapInternal;
    }

    public Map getBackupKeyListenerMap() {
        return this.__m_BackupKeyListenerMap;
    }

    public Map getBackupLeaseMap() {
        return this.__m_BackupLeaseMap;
    }

    public Map getBackupMap() {
        return this.__m_BackupMap;
    }

    public long getCacheId() {
        return this.__m_CacheId;
    }

    @Override
    public String getCacheName() {
        return this.__m_CacheName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Binary getCanonicalKey(Binary binKey) {
        PartitionedCache service = this.getService();
        int nPartition = service.getKeyPartition(binKey);
        boolean fPrimary = service.isPrimaryOwner(nPartition);
        Binary binKeyInterned = null;
        ConfigurableCacheMap mapIntern = null;
        if (fPrimary && this.isInternPrimaryKeys()) {
            mapIntern = (ConfigurableCacheMap)((PartitionAwareBackingMap)((Object)this.getBackingMapInternal())).getPartitionMap(nPartition);
        } else if (!fPrimary && this.isInternBackupKeys()) {
            mapIntern = (ConfigurableCacheMap)this.getBackupMap();
        }
        if (mapIntern == null) {
            PartitionAwareBackingMap mapPKI;
            if (fPrimary && (mapPKI = this.getPartitionedKeyIndex()) != null) {
                binKeyInterned = (Binary)mapPKI.get(binKey);
            }
        } else {
            ConfigurableCacheMap.Entry entry = mapIntern.getCacheEntry(binKey);
            if (entry != null) {
                binKeyInterned = (Binary)entry.getKey();
            }
        }
        if (binKeyInterned == null) {
            SafeHashMap.Entry entry;
            SafeHashMap mapListeners = (SafeHashMap)(fPrimary ? this.getKeyListenerMap() : this.getBackupKeyListenerMap());
            if (mapListeners != null && (entry = mapListeners.getEntry(binKey)) != null) {
                SafeHashMap safeHashMap = mapListeners;
                synchronized (safeHashMap) {
                    entry = mapListeners.getEntry(binKey);
                    if (entry != null) {
                        binKey = (Binary)entry.getKey();
                    }
                }
            }
        } else {
            binKey = binKeyInterned;
        }
        return binKey;
    }

    public ConfigurableCacheMap getConfigurableCacheMap(int iPartition) {
        PartitionAwareBackingMap pabmPrime = this.getPartitionAwareBackingMap();
        Map mapPart = pabmPrime == null ? null : pabmPrime.getPartitionMap(iPartition);
        return mapPart != null && mapPart instanceof ConfigurableCacheMap ? (ConfigurableCacheMap)mapPart : this.getBackingConfigurableCache();
    }

    public Map getConfiguredBackupListeners() {
        IdentityHashMap mapListeners = this.__m_ConfiguredBackupListeners;
        if (mapListeners == null) {
            mapListeners = new IdentityHashMap();
            this.setConfiguredBackupListeners(mapListeners);
        }
        return mapListeners;
    }

    public Converter getConverterKeyDown() {
        return this.__m_ConverterKeyDown;
    }

    public Converter getConverterUp() {
        return this.__m_ConverterUp;
    }

    public Converter getConverterValueDown() {
        return this.__m_ConverterValueDown;
    }

    public MapIndex getDeserializationAccelerator() {
        return (MapIndex)this.getIndexMap().get(IdentityExtractor.INSTANCE);
    }

    public MapIndex getDeserializationAccelerator(int nPart) {
        return this.getIndexMap(nPart).get(IdentityExtractor.INSTANCE);
    }

    public ConcurrentMap getEntryStatusMap() {
        return this.__m_EntryStatusMap;
    }

    public EntryToBinaryEntryConverter getEntryToBinaryEntryConverter() {
        EntryToBinaryEntryConverter converter = this.__m_EntryToBinaryEntryConverter;
        if (converter == null) {
            converter = (EntryToBinaryEntryConverter)this._newChild("EntryToBinaryEntryConverter");
            this.setEntryToBinaryEntryConverter(converter);
        }
        return converter;
    }

    public StorageDispatcher getEventDispatcher() {
        return this.__m_EventDispatcher;
    }

    public DispatcherInterceptor getEventDispatcherInterceptor() {
        return this.__m_EventDispatcherInterceptor;
    }

    public EvictionTask getEvictionTask() {
        return this.__m_EvictionTask;
    }

    public Map getFilterIdMap() {
        return this.__m_FilterIdMap;
    }

    public Binary getFromBackup(Binary binKey) {
        return (Binary)this.getBackupMap().get(binKey);
    }

    public Map getIndexExtractorMap() {
        return this.__m_IndexExtractorMap;
    }

    public Map getIndexMap() {
        return this.getIndexMap(null);
    }

    public Map getIndexMap(PartitionSet partitions) {
        if (partitions == null || partitions.cardinality() > 1) {
            return new PartitionedIndexMap(this, this.getPartitionedIndexMap(), partitions);
        }
        if (partitions.cardinality() == 1) {
            return this.getPartitionIndexMap(partitions.first());
        }
        return null;
    }

    @Override
    public Map<ValueExtractor, MapIndex> getIndexMap(int nPartition) {
        return this.getPartitionIndexMap(nPartition);
    }

    public Map getKeyListenerMap() {
        return this.__m_KeyListenerMap;
    }

    protected Set getKeySet(int iPartition) {
        Map mapPartition = null;
        PartitionAwareBackingMap pabmPrime = this.getPartitionAwareBackingMap();
        if (pabmPrime == null) {
            PartitionAwareBackingMap mapKeyIndex = this.getPartitionedKeyIndex();
            if (mapKeyIndex != null) {
                mapPartition = mapKeyIndex.getPartitionMap(iPartition);
            }
        } else {
            mapPartition = pabmPrime.getPartitionMap(iPartition);
        }
        return mapPartition == null ? null : mapPartition.keySet();
    }

    public KeyToBinaryEntryConverter getKeyToBinaryEntryConverter() {
        KeyToBinaryEntryConverter converter = this.__m_KeyToBinaryEntryConverter;
        if (converter == null) {
            converter = (KeyToBinaryEntryConverter)this._newChild("KeyToBinaryEntryConverter");
            this.setKeyToBinaryEntryConverter(converter);
        }
        return converter;
    }

    public Map getLeaseMap() {
        return this.__m_LeaseMap;
    }

    public Map getListenerMap() {
        return this.__m_ListenerMap;
    }

    @Override
    public BackingMapManagerContext getManagerContext() {
        return this.getService().getBackingMapContext();
    }

    public PartitionAwareBackingMap getPartitionAwareBackingMap() {
        return this.__m_PartitionAwareBackingMap;
    }

    protected PartitionAwareBackingMap getPartitionAwareBackupMap() {
        return this.__m_PartitionAwareBackupMap;
    }

    public Map getPartitionedBackupMap(int iPartition) {
        HashMap<Binary, Binary> mapFrom;
        PartitionedCache service = this.getService();
        PartitionAwareBackingMap pabmBackup = this.getPartitionAwareBackupMap();
        HashMap<Binary, Binary> mapEntries = mapFrom = pabmBackup == null ? this.getBackupMap() : pabmBackup.getPartitionMap(iPartition);
        if (pabmBackup == null) {
            mapEntries = new HashMap<Binary, Binary>();
            for (Map.Entry entry : mapFrom.entrySet()) {
                Binary binKey = (Binary)entry.getKey();
                Binary binVal = (Binary)entry.getValue();
                if (service.getKeyPartition(binKey) != iPartition) continue;
                mapEntries.put(binKey, binVal);
            }
        }
        return mapEntries;
    }

    public Map getPartitionedIndexMap() {
        return this.__m_PartitionedIndexMap;
    }

    public PartitionAwareBackingMap getPartitionedKeyIndex() {
        return this.__m_PartitionedKeyIndex;
    }

    public Map getPartitionIndexMap(int nPartition) {
        Map mapIndex = this.getPartitionedIndexMap();
        ConcurrentHashMap mapPartIndex = (ConcurrentHashMap)mapIndex.get(nPartition);
        if (mapPartIndex == null) {
            mapPartIndex = new ConcurrentHashMap();
            Map mapPrev = mapIndex.putIfAbsent(nPartition, mapPartIndex);
            if (mapPrev != null) {
                return mapPrev;
            }
        }
        return mapPartIndex;
    }

    public Set getPartitionKeys(int nPartition) {
        PartitionAwareBackingMap pabmPrime = this.getPartitionAwareBackingMap();
        PartitionAwareBackingMap pabmKeys = pabmPrime == null ? this.getPartitionedKeyIndex() : pabmPrime;
        Map mapKeys = pabmKeys == null ? null : pabmKeys.getPartitionMap(nPartition);
        return mapKeys == null ? Collections.EMPTY_SET : mapKeys.keySet();
    }

    public List getPendingLockRequest() {
        return this.__m_PendingLockRequest;
    }

    public Object getPreviousEvents(Member member, Binary binKey, int iPart, long lVersion) {
        return this.getPreviousEvents(member, Collections.singleton(binKey), iPart, lVersion, null);
    }

    public Object getPreviousEvents(Member member, Filter filter, int iPart, long lVersion, boolean fLite, long lFilterId, Object oHolder) {
        PartitionedCache.PartitionControl ctrlPart = (PartitionedCache.PartitionControl)this.getService().getPartitionControl(iPart);
        PersistentStore storeEvents = ctrlPart.getPersistentEventsStore();
        if (lVersion == 0L) {
            lVersion = this.getVersion().getSubmittedVersion(iPart);
            if (lVersion == 0L) {
                lVersion = -2L;
            }
            return this.prepareEventMessage(SingleMemberSet.instantiate(member), 74, null, null, null, new long[]{lFilterId}, iPart, lVersion);
        }
        TreeMap<Long, MapEvent> mapEvents = new TreeMap<Long, MapEvent>();
        if (storeEvents != null) {
            storeEvents.iterate(CachePersistenceHelper.instantiateEventsVisitor(this.getCacheId(), filter, lVersion, mapEvents, CachePersistenceHelper.LONG_CONVERTER_DOWN, CachePersistenceHelper.LONG_CONVERTER_UP, (Converter<Object, ReadBuffer>)this.getConverterValueDown(), (Converter<ReadBuffer, Object>)this.getConverterUp()));
        }
        for (MapEvent event : mapEvents.values()) {
            oHolder = Storage.accumulateMapEvents(oHolder, this.prepareDispatch(event, filter, member, fLite, lFilterId));
        }
        return oHolder;
    }

    public Object getPreviousEvents(Member member, Set setKeys, int iPart, long lVersion, Object oHolder) {
        PartitionedCache.PartitionControl ctrlPart = (PartitionedCache.PartitionControl)this.getService().getPartitionControl(iPart);
        PersistentStore storeEvents = ctrlPart.getPersistentEventsStore();
        if (lVersion == 0L) {
            lVersion = this.getVersion().getSubmittedVersion(iPart);
            if (lVersion == 0L) {
                lVersion = -2L;
            }
            return this.prepareEventMessage(SingleMemberSet.instantiate(member), 74, null, null, null, null, iPart, lVersion);
        }
        TreeMap<Long, MapEvent> mapEvents = new TreeMap<Long, MapEvent>();
        if (storeEvents != null) {
            storeEvents.iterate(CachePersistenceHelper.instantiateEventsVisitor(this.getCacheId(), setKeys, lVersion, mapEvents, CachePersistenceHelper.LONG_CONVERTER_DOWN, CachePersistenceHelper.LONG_CONVERTER_UP, (Converter<Object, ReadBuffer>)this.getConverterValueDown(), (Converter<ReadBuffer, Object>)this.getConverterUp()));
        }
        for (MapEvent event : mapEvents.values()) {
            PartitionedCache.MapEvent eventMsg = this.prepareEventMessage(SingleMemberSet.instantiate(member), event.getId() | 8 | 0x40, (Binary)event.getKey(), (Binary)event.getOldValue(), (Binary)event.getNewValue(), null, iPart, event.getVersion());
            oHolder = Storage.accumulateMapEvents(oHolder, eventMsg);
        }
        return oHolder;
    }

    public MapListener getPrimaryListener() {
        return this.__m_PrimaryListener;
    }

    public Object getPrimingEvent(Member member, Binary binKey, Binary binValue, int iPart) {
        return this.prepareEventMessage(SingleMemberSet.instantiate(member), 74, binKey, null, binValue, null, iPart, this.getVersion().getSubmittedVersion(iPart));
    }

    public Object getPrimingEvent(Member member, EntryStatus status) {
        return this.getPrimingEvent(member, status.getKey(), status.getBinaryEntry().getBinaryValue(), status.getPartition());
    }

    public Object getPrimingEvents(Member member, Map map) {
        Object oHolder = null;
        PartitionedCache service = this.getService();
        for (Map.Entry entry : map.entrySet()) {
            Binary binKey = (Binary)entry.getKey();
            oHolder = Storage.accumulateMapEvents(oHolder, this.getPrimingEvent(member, binKey, (Binary)entry.getValue(), service.getKeyPartition(binKey)));
        }
        return oHolder;
    }

    public int getQueryRetries() {
        return this.__m_QueryRetries;
    }

    public Map getQuerySizeCache() {
        return this.__m_QuerySizeCache;
    }

    @Override
    public InvocableMap.Entry getReadOnlyEntry(Object oKey) {
        ObservableMap map = this.getBackingInternalCache();
        Binary binKey = (Binary)oKey;
        Binary binVal = this.isPotentiallyEvicting() ? (Binary)map.get(binKey) : null;
        return this.instantiateBinaryEntry(binKey, binVal, true);
    }

    public com.tangosol.util.ConcurrentMap getResourceControlMap() {
        return this.__m_ResourceControlMap;
    }

    public PartitionedCache.ResourceCoordinator getResourceCoordinator() {
        return this.getService().getResourceCoordinator();
    }

    public PartitionedCache getService() {
        return (PartitionedCache)this.get_Module();
    }

    public long getStatsEventsDispatched() {
        return this.__m_StatsEventsDispatched;
    }

    public AtomicLong getStatsEvictions() {
        return this.__m_StatsEvictions;
    }

    public AtomicLong getStatsIndexingTotalMillis() {
        return this.__m_StatsIndexingTotalMillis;
    }

    public AtomicLong getStatsInserts() {
        return this.__m_StatsInserts;
    }

    public AtomicLong getStatsListenerRegistrations() {
        return this.__m_StatsListenerRegistrations;
    }

    public String getStatsMaxQueryDescription() {
        return this.__m_StatsMaxQueryDescription;
    }

    public long getStatsMaxQueryDurationMillis() {
        return this.__m_StatsMaxQueryDurationMillis;
    }

    public long getStatsMaxQueryThresholdMillis() {
        return this.__m_StatsMaxQueryThresholdMillis;
    }

    public long getStatsNonOptimizedQueryAverageMillis() {
        long cCount = this.getStatsNonOptimizedQueryCount().get();
        return cCount == 0L ? 0L : this.getStatsNonOptimizedQueryTotalMillis().get() / cCount;
    }

    public AtomicLong getStatsNonOptimizedQueryCount() {
        return this.__m_StatsNonOptimizedQueryCount;
    }

    public AtomicLong getStatsNonOptimizedQueryTotalMillis() {
        return this.__m_StatsNonOptimizedQueryTotalMillis;
    }

    public long getStatsOptimizedQueryAverageMillis() {
        long cCount = this.getStatsOptimizedQueryCount().get();
        return cCount == 0L ? 0L : this.getStatsOptimizedQueryTotalMillis().get() / cCount;
    }

    public AtomicLong getStatsOptimizedQueryCount() {
        return this.__m_StatsOptimizedQueryCount;
    }

    public AtomicLong getStatsOptimizedQueryTotalMillis() {
        return this.__m_StatsOptimizedQueryTotalMillis;
    }

    public AtomicLong getStatsQueryContentionCount() {
        return this.__m_StatsQueryContentionCount;
    }

    public AtomicLong getStatsRemoves() {
        return this.__m_StatsRemoves;
    }

    public AtomicLong getStatsClears() {
        return this.__m_StatsClears;
    }

    protected BinaryEntry getTempBinaryEntry() {
        BinaryEntry binEntry = this.__m_TempBinaryEntry;
        if (binEntry == null) {
            binEntry = new BinaryEntry();
            this._linkChild(binEntry);
            this.setTempBinaryEntry(binEntry);
        }
        return binEntry;
    }

    public Set getTriggerSet() {
        return this.__m_TriggerSet;
    }

    public ReadBuffer getValueForTransfer(Binary binKey, boolean fRemove) {
        ReadBuffer bufValue = null;
        ObservableMap mapResource = this.getBackingMapInternal();
        try {
            ConfigurableCacheMap mapConfigurable = this.getBackingConfigurableCache();
            if (mapConfigurable == null) {
                bufValue = fRemove ? (ReadBuffer)mapResource.remove(binKey) : (ReadBuffer)mapResource.get(binKey);
            } else {
                ConfigurableCacheMap.Entry entry = mapConfigurable.getCacheEntry(binKey);
                if (entry != null) {
                    Object oValue = entry.getValue();
                    long ldtExpiry = entry.getExpiryMillis();
                    bufValue = (ReadBuffer)(oValue instanceof ReadBuffer ? oValue : mapResource.get(binKey));
                    if (ldtExpiry != 0L || (long)mapConfigurable.getExpiryDelay() != 0L) {
                        ldtExpiry = ldtExpiry == 0L ? -1L : this.getService().getClusterService().calcTimestamp(ldtExpiry);
                        bufValue = ExternalizableHelper.asBinary(ExternalizableHelper.encodeExpiry(bufValue, ldtExpiry));
                    }
                    if (fRemove) {
                        mapResource.remove(binKey);
                    }
                }
            }
        }
        catch (Throwable e) {
            String sOp = fRemove ? "remove" : "load";
            Storage._trace("Failed " + sOp + " during transfer: key=" + String.valueOf(binKey) + "\n" + String.valueOf(e) + "\n" + Base.getStackTrace(e), 1);
        }
        return bufValue;
    }

    public StorageVersion getVersion() {
        return this.__m_Version;
    }

    public boolean hasData(int iPartition) {
        Set setKeys = this.collectKeySet(this.getService().instantiatePartitionSet(iPartition), false);
        Map mapKeyListener = this.getKeyListenerMap();
        Map mapLease = this.getLeaseMap();
        return setKeys.size() > 0 || mapKeyListener != null && !Collections.disjoint(mapKeyListener.keySet(), setKeys) || mapLease != null && !Collections.disjoint(mapLease.keySet(), setKeys);
    }

    public boolean hasInterceptors() {
        return this.getEventDispatcherInterceptor().getInterceptorCount().get() > 0L;
    }

    public boolean hasListeners() {
        Map mapListeners = this.getListenerMap();
        Map mapKeyListeners = this.getKeyListenerMap();
        return this.getService().isPersistEvents() || mapListeners != null && !mapListeners.isEmpty() || mapKeyListeners != null && !mapKeyListeners.isEmpty();
    }

    protected void initializePartitions(PartitionAwareBackingMap mapPartitioned, int iStore) {
        PartitionedCache service = this.getService();
        Member memberThis = service.getThisMember();
        PartitionSet partitions = service.calculatePartitionSet(memberThis, iStore);
        if (iStore == 0 && service.isTransferInProgress()) {
            PartitionedService.TransferControl.TransferIterator iter = service.getTransferControl().iterateTransfersInProgress();
            while (iter.hasNext()) {
                iter.next();
                if (iter.getBackup() != 0) continue;
                partitions.add(iter.getPartition());
            }
        }
        int iPartition = partitions.next(0);
        while (iPartition >= 0) {
            mapPartitioned.createPartition(iPartition);
            iPartition = partitions.next(iPartition + 1);
        }
    }

    public void insertBackupLeaseTransfer(int iPartition, Lease[] aLease) {
        Map map = this.getBackupLeaseMap();
        for (Lease lease : aLease) {
            map.put(lease.getResourceKey(), lease);
        }
    }

    public void insertBackupListenerTransfer(int iPartition, Map.Entry[] aEntry) {
        Map map = this.ensureBackupKeyListenerMap();
        for (Map.Entry entry : aEntry) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public void insertBackupTransfer(int iPartition, Map.Entry[] aEntry) {
        PartitionedCache service = this.getService();
        boolean fPutAll = this.isPreferPutAllBackup();
        int cEntries = aEntry.length;
        Map map = fPutAll ? new HashMap(cEntries) : this.getBackupMap();
        long lExtentId = this.getCacheId();
        try {
            if (this.isPersistent() && service.isBackupPersistence()) {
                PartitionedCache.PartitionControl ctrl = (PartitionedCache.PartitionControl)service.getPartitionControl(iPartition);
                PersistentStore store = ctrl.ensureOpenPersistentStore(null, true, true);
                ctrl.ensureBackupPersistentExtent(lExtentId);
                Object oToken = store.begin();
                try {
                    for (int i = 0; i < cEntries; ++i) {
                        Map.Entry entry = aEntry[i];
                        store.store(lExtentId, (ReadBuffer)entry.getKey(), (ReadBuffer)entry.getValue(), oToken);
                        map.put(entry.getKey(), entry.getValue());
                    }
                    store.commit(oToken);
                }
                catch (Throwable t) {
                    store.abort(oToken);
                    throw Base.ensureRuntimeException(t);
                }
            } else {
                for (int i = 0; i < cEntries; ++i) {
                    Map.Entry entry = aEntry[i];
                    map.put(entry.getKey(), entry.getValue());
                }
            }
            if (fPutAll) {
                this.getBackupMap().putAll(map);
            }
        }
        catch (RuntimeException e) {
            this.reportTransferFailure(e, "backup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertPrimaryData(int iPartition, Iterator iter) {
        int cEntries;
        PartitionedCache service;
        block17: {
            if (!iter.hasNext()) {
                return;
            }
            service = this.getService();
            cEntries = 0;
            ConfigurableCacheMap.EvictionApprover approver = null;
            ConfigurableCacheMap mapCCM = this.getConfigurableCacheMap(iPartition);
            long lCacheId = this.getCacheId();
            boolean fScheduledBackups = service.isScheduledBackups();
            try {
                if (mapCCM != null) {
                    approver = mapCCM.getEvictionApprover();
                    mapCCM.setEvictionApprover(ConfigurableCacheMap.EvictionApprover.DISAPPROVER);
                }
                PartitionedCache.PartitionControl ctrlPartition = (PartitionedCache.PartitionControl)service.getPartitionControl(iPartition);
                if (this.isPersistent()) {
                    PersistentStore store = ctrlPartition.ensureOpenPersistentStore();
                    Object oToken = store.begin();
                    long lExtentId = this.getCacheId();
                    ctrlPartition.ensurePersistentExtent(lExtentId);
                    try {
                        while (iter.hasNext()) {
                            Map.Entry entry = (Map.Entry)iter.next();
                            Binary binKey = (Binary)entry.getKey();
                            Binary binValue = (Binary)entry.getValue();
                            boolean fScheduleBackup = false;
                            if (fScheduledBackups && ExternalizableHelper.isDecorated(binValue, 5)) {
                                fScheduleBackup = true;
                                binValue = ExternalizableHelper.undecorate(binValue, 5);
                            }
                            if (binValue != Binary.EMPTY) {
                                this.putPrimaryResource(binKey, binValue);
                            }
                            store.store(lExtentId, binKey, binValue, oToken);
                            if (fScheduleBackup) {
                                service.scheduleBackup(iPartition, lCacheId, binKey);
                            }
                            ++cEntries;
                        }
                        store.commit(oToken);
                        break block17;
                    }
                    catch (Throwable t) {
                        store.abort(oToken);
                        throw Base.ensureRuntimeException(t);
                    }
                }
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    Binary binKey = (Binary)entry.getKey();
                    Binary binValue = (Binary)entry.getValue();
                    boolean fScheduleBackup = false;
                    if (fScheduledBackups && ExternalizableHelper.isDecorated(binValue, 5)) {
                        fScheduleBackup = true;
                        binValue = ExternalizableHelper.undecorate(binValue, 5);
                    }
                    if (binValue != Binary.EMPTY) {
                        this.putPrimaryResource(binKey, binValue);
                    }
                    if (fScheduleBackup) {
                        service.scheduleBackup(iPartition, lCacheId, binKey);
                    }
                    ++cEntries;
                }
            }
            finally {
                if (mapCCM != null) {
                    mapCCM.setEvictionApprover(approver);
                }
            }
        }
        service.processChanges();
        this.getStatsInserts().addAndGet(cEntries);
    }

    protected void insertPrimaryKeyListeners(int iPartition, Iterator iter) {
        PartitionedCache service = this.getService();
        Map mapKeyListeners = this.ensureKeyListenerMap();
        boolean fLiteOnly = true;
        if (this.isPersistent()) {
            PartitionedCache.PartitionControl ctrlPartition = (PartitionedCache.PartitionControl)service.getPartitionControl(iPartition);
            long lExtentId = this.getCacheId();
            ctrlPartition.ensurePersistentExtent(lExtentId);
            PersistentStore store = ctrlPartition.ensureOpenPersistentStore();
            Object oToken = store.begin();
            try {
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    Binary binKey = (Binary)entry.getKey();
                    Map mapMembers = (Map)entry.getValue();
                    mapKeyListeners.put(binKey, mapMembers);
                    for (Map.Entry entryMember : mapMembers.entrySet()) {
                        com.tangosol.net.Member member = (com.tangosol.net.Member)entryMember.getKey();
                        Boolean FLite = (Boolean)entryMember.getValue();
                        CachePersistenceHelper.registerListener(store, lExtentId, binKey, service.getServiceMemberSet().getServiceJoinTime(member.getId()), FLite, oToken);
                        if (!fLiteOnly || FLite != Boolean.FALSE) continue;
                        fLiteOnly = false;
                        this.ensureOldValueRequired();
                    }
                }
                store.commit(oToken);
            }
            catch (Throwable t) {
                store.abort(oToken);
                throw Base.ensureRuntimeException(t);
            }
        } else {
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                Map mapMembers = (Map)entry.getValue();
                mapKeyListeners.put(entry.getKey(), mapMembers);
                if (!fLiteOnly || !mapMembers.containsValue(Boolean.FALSE)) continue;
                fLiteOnly = false;
                this.ensureOldValueRequired();
            }
        }
    }

    protected void insertPrimaryLeases(int iPartition, Iterator iter) {
        if (!iter.hasNext()) {
            return;
        }
        PartitionedCache service = this.getService();
        Map mapLease = this.getLeaseMap();
        if (this.isPersistent()) {
            PartitionedCache.PartitionControl ctrlPartition = (PartitionedCache.PartitionControl)service.getPartitionControl(iPartition);
            long lExtentId = this.getCacheId();
            ctrlPartition.ensurePersistentExtent(lExtentId);
            PersistentStore store = ctrlPartition.ensureOpenPersistentStore();
            Object oToken = store.begin();
            try {
                while (iter.hasNext()) {
                    Lease lease = (Lease)iter.next();
                    Binary binKey = (Binary)lease.getResourceKey();
                    mapLease.put(binKey, lease);
                    CachePersistenceHelper.registerLock(store, lExtentId, binKey, service.getServiceMemberSet().getServiceJoinTime(lease.getHolderId()), lease.getHolderThreadId(), oToken);
                }
                store.commit(oToken);
            }
            catch (Throwable t) {
                store.abort(oToken);
                throw Base.ensureRuntimeException(t);
            }
        } else {
            while (iter.hasNext()) {
                Lease lease = (Lease)iter.next();
                mapLease.put(lease.getResourceKey(), lease);
            }
        }
    }

    public void insertPrimaryLeaseTransfer(int iPartition, Lease[] aLease) {
        this.insertPrimaryLeases(iPartition, new SimpleEnumerator<Lease>(aLease));
    }

    public void insertPrimaryListenerTransfer(int iPartition, Map.Entry[] aEntry) {
        if (aEntry.length == 0) {
            return;
        }
        this.insertPrimaryKeyListeners(iPartition, new SimpleEnumerator<Map.Entry>(aEntry));
    }

    public void insertPrimaryTransfer(int iPartition, Map.Entry[] aEntry) {
        try {
            this.insertPrimaryData(iPartition, new SimpleEnumerator<Map.Entry>(aEntry));
        }
        catch (RuntimeException e) {
            this.reportTransferFailure(e, "primary");
        }
    }

    protected void instantiateBackingMap(String sCacheName) {
        PartitionedCache service = this.getService();
        ObservableMap mapResource = this.getBackingMapInternal();
        BackingMapManager manager = service.getBackingMapManager();
        if (manager != null) {
            Map mapNew = null;
            try {
                this.setAccessAuthorizer(manager.getStorageAccessAuthorizer(sCacheName));
                mapNew = manager.instantiateBackingMap(sCacheName);
                if (mapNew == null) {
                    Storage._trace("BackingMapManager " + manager.getClass().getName() + ": returned \"null\" for a cache: " + sCacheName, 1);
                } else if (!mapNew.isEmpty()) {
                    mapNew.clear();
                }
            }
            catch (RuntimeException e) {
                Storage._trace("BackingMapManager " + manager.getClass().getName() + ": failed to instantiate a cache: " + sCacheName, 1);
                Storage._trace(e);
            }
            if (mapNew != null) {
                mapResource = mapNew instanceof ObservableMap ? (ObservableMap)mapNew : (mapNew instanceof PartitionAwareBackingMap ? new ObservableSplittingBackingMap((PartitionAwareBackingMap)mapNew) : new WrapperObservableMap(mapNew, true));
                mapResource.addMapListener(this.instantiatePrimaryListener());
                this.setPersistent(service.getPersistenceManager() != null && manager.isBackingMapPersistent(sCacheName));
                this.setPreferPutAllPrimary(DefaultConfigurableCacheFactory.isPutAllOptimized(mapResource));
                this.setBackingMapInternal(mapResource);
                this.setBackingInternalCache(mapResource);
                int cDefaultExpiry = 0;
                if (mapResource instanceof ReadWriteBackingMap) {
                    this.setPotentiallyEvicting(true);
                    ObservableMap mapInternal = ((ReadWriteBackingMap)mapResource).getInternalCache();
                    this.setBackingInternalCache(mapInternal);
                    if (mapInternal instanceof ConfigurableCacheMap) {
                        ConfigurableCacheMap mapCCM = (ConfigurableCacheMap)mapInternal;
                        this.setBackingConfigurableCache(mapCCM);
                        cDefaultExpiry = mapCCM.getExpiryDelay();
                    }
                } else if (mapResource instanceof ConfigurableCacheMap) {
                    ConfigurableCacheMap mapConfigurable = (ConfigurableCacheMap)mapResource;
                    int cHighUnits = mapConfigurable.getHighUnits();
                    int cExpiryDelay = mapConfigurable.getExpiryDelay();
                    this.setPotentiallyEvicting(cHighUnits > 0 && cHighUnits < Integer.MAX_VALUE || cExpiryDelay > 0);
                    this.setBackingConfigurableCache(mapConfigurable);
                    cDefaultExpiry = mapConfigurable.getExpiryDelay();
                } else {
                    if (mapResource instanceof CacheMap) {
                        Storage._trace("Cache \"" + sCacheName + "\" is configured with a backing-map  implementation (" + ClassHelper.getSimpleName(mapResource.getClass()) + ") which does not implement the ConfigurableCacheMap interface; some advanced expiry functionality may not be available.", 3);
                    }
                    this.setPotentiallyEvicting(true);
                }
                this.setBackingMapExpiryDelay(cDefaultExpiry == 0 ? -1 : cDefaultExpiry);
                if (cDefaultExpiry > 0) {
                    this.scheduleEviction(cDefaultExpiry);
                    this.setExpirySliding(manager.isBackingMapSlidingExpiry(sCacheName));
                }
            }
        }
        if (mapResource instanceof PartitionAwareBackingMap) {
            PartitionAwareBackingMap mapPrime = (PartitionAwareBackingMap)((Object)mapResource);
            this.initializePartitions(mapPrime, 0);
            this.setPartitionAwareBackingMap(mapPrime);
            this.setInternPrimaryKeys(DefaultConfigurableCacheFactory.isCanonicalKeySupported(mapResource));
            if (mapResource instanceof ConfigurableCacheMap && ((ConfigurableCacheMap)mapResource).getUnitCalculator() instanceof BinaryMemoryCalculator) {
                this.setAdjustPartitionSize(false);
            }
        } else {
            KeyIndexManager mgr = new KeyIndexManager();
            mgr.init(service.getBackingMapContext());
            PartitionSplittingBackingMap mapKeyIndex = new PartitionSplittingBackingMap(mgr, sCacheName + "$KeyIndex");
            mapKeyIndex.setStrict(service.isStrictPartitioning());
            this.initializePartitions(mapKeyIndex, 0);
            this.setPartitionedKeyIndex(mapKeyIndex);
        }
    }

    protected void instantiateBackupMap(String sCacheName) {
        PartitionedCache service = this.getService();
        Map mapBackup = null;
        if (this.getBackingMapInternal() instanceof ReadWriteBackingMap && service.getBackupCountOpt() < service.getBackupCount()) {
            mapBackup = new ReadWriteBackingMap.EvictingBackupMap();
        }
        BackingManager mgr = (BackingManager)this._newChild("BackingManager");
        try {
            Map mapOld;
            if (mapBackup == null) {
                mgr.setCacheName(sCacheName);
                mgr.parseConfiguration();
                if (mgr.isPartitioned()) {
                    PartitionSplittingBackingMap mapPartitioned = new PartitionSplittingBackingMap(mgr, sCacheName + "$Backup");
                    mapPartitioned.setStrict(service.isStrictPartitioning());
                    for (int iStore = 1; iStore <= service.getBackupCount(); ++iStore) {
                        this.initializePartitions(mapPartitioned, iStore);
                    }
                    mapBackup = mapPartitioned;
                } else {
                    mapBackup = mgr.instantiateBackingMap(sCacheName);
                }
            }
            if (!(mapOld = this.getBackupMap()).isEmpty()) {
                try {
                    Storage._trace("Transferring " + mapOld.size() + " to backup for: " + sCacheName, 3);
                    mapBackup.putAll(mapOld);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                mapOld.clear();
            }
            this.setPreferPutAllBackup(DefaultConfigurableCacheFactory.isPutAllOptimized(mapBackup));
            this.setInternBackupKeys(DefaultConfigurableCacheFactory.isCanonicalKeySupported(mapBackup));
            this.setPartitionAwareBackupMap(mapBackup instanceof PartitionAwareBackingMap ? (PartitionAwareBackingMap)mapBackup : null);
            this.setBackupMap(mapBackup);
        }
        catch (RuntimeException e) {
            Storage._trace("BackingMapManager " + String.valueOf(mgr) + ": failed to instantiate a backup map for cache: " + sCacheName, 1);
            Storage._trace(e);
        }
    }

    public BinaryEntry instantiateBinaryEntry(Binary binKey, Binary binValue, boolean fReadOnly) {
        BinaryEntry entry = new BinaryEntry();
        entry.setBinaryKey(binKey);
        entry.setBinaryValue(binValue);
        if (fReadOnly) {
            entry.ensureReadOnly();
        }
        this._linkChild(entry);
        return entry;
    }

    protected DeferredEvent instantiateDeferredEvent(MapEvent evt, boolean fReapply) {
        DeferredEvent deferred = (DeferredEvent)this._newChild("DeferredEvent");
        deferred.setEvent(evt);
        deferred.setReapply(fReapply);
        int nEvent = evt.getId();
        if ((nEvent == 3 || nEvent == 2) && this.isOldValueRequired()) {
            evt.getOldValue();
        }
        return deferred;
    }

    protected Converter instantiateEnlistingConverter(PartitionedCache.InvocationContext ctxInvoke, MapTrigger trigger) {
        EnlistingConverter conv = new EnlistingConverter();
        this._linkChild(conv);
        conv.setInvocationContext(ctxInvoke);
        conv.setTrigger(trigger);
        return conv;
    }

    protected LazyKeySet instantiateLazyKeySet(PartitionSet parts, boolean fSnapshot) {
        LazyKeySet set = new LazyKeySet();
        this._linkChild(set);
        set.setPartitionMask(parts);
        set.setSnapshot(fSnapshot);
        return set;
    }

    protected MapListener instantiatePrimaryListener() {
        PrimaryListener listener = (PrimaryListener)this._newChild("PrimaryListener");
        this.setPrimaryListener(listener);
        return listener;
    }

    public void invalidate() {
        PartitionedCache service = this.getService();
        ObservableMap mapPrime = this.getBackingMapInternal();
        MapListener listener = this.getPrimaryListener();
        if (listener != null) {
            mapPrime.removeMapListener(listener);
        }
        this.setListenerMap(null);
        this.setKeyListenerMap(null);
        String sName = this.getCacheName();
        BackingMapManager manager = service.getBackingMapManager();
        if (sName != null) {
            Registry registry;
            if (manager != null) {
                try {
                    manager.releaseBackingMap(sName, mapPrime);
                }
                catch (RuntimeException e) {
                    Storage._trace("BackingMapManager " + manager.getClass().getName() + ": failed to release a cache: " + sName, 1);
                    Storage._trace(e);
                }
            }
            if ((registry = service.getCluster().getManagement()) != null) {
                String sBean = "type=StorageManager" + ",service=" + service.getServiceName() + ",cache=" + sName;
                registry.unregister(registry.ensureGlobalName(sBean));
            }
        }
        if (service.getBackupCount() > 0) {
            this.setBackupKeyListenerMap(null);
            this.invalidateBackupMap();
        }
        this.getLeaseMap().clear();
        this.setBackingMapInternal(NullImplementation.getObservableMap());
        this.setBackingInternalCache(NullImplementation.getObservableMap());
        this.setBackingConfigurableCache(null);
        this.setPartitionAwareBackingMap(null);
        this.setIndexExtractorMap(NullImplementation.getMap());
        this.setFilterIdMap(null);
        this.setAdjustPartitionSize(true);
        EvictionTask taskEvict = this.getEvictionTask();
        if (taskEvict != null) {
            taskEvict.cancel();
            this.setEvictionTask(null);
        }
        service.getEventsHelper().unregisterStorageDispatcher(this);
        this.setValid(false);
    }

    protected void invalidateBackupMap() {
        Map mapBackup = this.getBackupMap();
        PartitionAwareBackingMap pabmBackup = this.getPartitionAwareBackupMap();
        if (pabmBackup == null) {
            String sCacheName = this.getCacheName();
            if (sCacheName != null) {
                BackingManager mgr = (BackingManager)this._newChild("BackingManager");
                mgr.setCacheName(sCacheName);
                mgr.parseConfiguration();
                mgr.releaseBackingMap(sCacheName, mapBackup);
            }
        } else {
            PartitionSet partitions = this.getService().collectOwnedPartitions(false);
            int iPartition = partitions.next(0);
            while (iPartition >= 0) {
                pabmBackup.destroyPartition(iPartition);
                iPartition = partitions.next(iPartition + 1);
            }
        }
        this.setBackupMap(NullImplementation.getObservableMap());
    }

    public EntryStatus invoke(PartitionedCache.InvocationContext ctxInvoke, EntryStatus status, InvocableMap.EntryProcessor agent) {
        if (TracingHelper.isEnabled()) {
            TracingHelper.augmentSpan().setMetadata("agent.class", agent.getClass().getName());
        }
        PartitionedCache.EventsHelper evtHelper = this.getService().getEventsHelper();
        Set<BinaryEntry> setEntries = Collections.singleton(status.getBinaryEntry());
        evtHelper.onInvoking(this, setEntries, agent, null);
        Object oResult = agent.process(status.getBinaryEntry());
        status.setResult((Binary)this.getConverterValueDown().convert(oResult));
        ctxInvoke.processInterceptors();
        ctxInvoke.postInvoke();
        evtHelper.onInvoked(this, setEntries, agent, null);
        return status;
    }

    public void invokeAll(PartitionedCache.InvocationContext ctxInvoke, Object[] aoStatus, int iFrom, int iTo, InvocableMap.EntryProcessor agent) {
        Throwable tError;
        LinkedHashSet<EntryStatus> setRemoved;
        AbstractSet setEntries;
        PartitionedCache.EventsHelper evtHelper;
        block15: {
            if (iFrom == iTo) {
                return;
            }
            if (TracingHelper.isEnabled()) {
                TracingHelper.augmentSpan().setMetadata("agent.class", agent.getClass().getName());
            }
            evtHelper = this.getService().getEventsHelper();
            Converter convDown = this.getConverterValueDown();
            Converter convKeyDown = this.getConverterKeyDown();
            setEntries = new LinkedHashSet<BinaryEntry>();
            setRemoved = null;
            for (int i = iFrom; i < iTo; ++i) {
                setEntries.add(((EntryStatus)aoStatus[i]).getBinaryEntry());
            }
            setEntries = new SubSet(setEntries);
            tError = null;
            Map mapResult = null;
            try {
                evtHelper.onInvoking(this, setEntries, agent, null);
                mapResult = agent.processAll(setEntries);
                if (mapResult == null || mapResult.isEmpty()) break block15;
                int cResults = mapResult.size();
                for (int i = iFrom; i < iTo; ++i) {
                    Object oKey;
                    EntryStatus status = (EntryStatus)aoStatus[i];
                    BinaryEntry entry = status.getBinaryEntry();
                    if (!entry.isKeyConverted() || !mapResult.containsKey(oKey = entry.getKey())) continue;
                    Object oValue = mapResult.get(oKey);
                    status.setResult(oValue instanceof Binary ? (Binary)oValue : (Binary)convDown.convert(oValue));
                    mapResult.remove(oKey);
                }
                if (!mapResult.isEmpty()) {
                    for (Map.Entry entry : mapResult.entrySet()) {
                        Object oKey = entry.getKey();
                        boolean fConverted = oKey instanceof Binary && ExternalizableHelper.isIntDecorated((Binary)oKey);
                        Binary binKey = fConverted ? (Binary)oKey : (Binary)convKeyDown.convert(oKey);
                        EntryStatus status = ctxInvoke.getEntryStatus(this, binKey);
                        if (status == null) continue;
                        Object oValue = entry.getValue();
                        status.setResult(oValue instanceof Binary ? (Binary)oValue : (Binary)convDown.convert(oValue));
                        mapResult.remove(oKey);
                    }
                }
                if (mapResult.isEmpty()) break block15;
                Iterator iter = mapResult.keySet().iterator();
                while (iter.hasNext()) {
                    Storage._trace("Unexpected key: \"" + String.valueOf(iter.next()) + "\" is  returned from processAll() invocation", 2);
                }
            }
            catch (LockContentionException e) {
                throw e;
            }
            catch (Throwable e) {
                tError = e;
                Set setEntriesRemoved = ((SubSet)setEntries).getRemoved();
                setRemoved = new LinkedHashSet<EntryStatus>();
                for (int i = iFrom; i < iTo; ++i) {
                    EntryStatus status = (EntryStatus)aoStatus[i];
                    BinaryEntry entry = status.getBinaryEntry();
                    if (entry == null) continue;
                    if (setEntriesRemoved.contains(entry)) {
                        setRemoved.add(status);
                        continue;
                    }
                    aoStatus[i] = null;
                    entry.reset(entry.getBinaryKey());
                }
            }
        }
        Set setEntriesAdded = ctxInvoke.processInterceptors();
        if (setRemoved == null) {
            ctxInvoke.postInvoke();
        } else {
            ctxInvoke.postInvokeAll(setRemoved);
            ctxInvoke.postInvokeAll(setEntriesAdded);
        }
        evtHelper.onInvoked(this, ((SubSet)setEntries).getRemoved(), agent, null);
        if (tError != null) {
            throw Base.ensureRuntimeException(tError);
        }
    }

    public boolean isAdjustPartitionSize() {
        return this.__m_AdjustPartitionSize;
    }

    public boolean isExpirySliding() {
        return this.__m_ExpirySliding;
    }

    public boolean isIndexed() {
        return !this.getIndexExtractorMap().isEmpty();
    }

    public boolean isInternBackupKeys() {
        return this.__m_InternBackupKeys;
    }

    public boolean isInternPrimaryKeys() {
        return this.__m_InternPrimaryKeys;
    }

    public boolean isMisconfigLoggedBackup() {
        return this.__m_MisconfigLoggedBackup;
    }

    public boolean isMisconfigLoggedPrimary() {
        return this.__m_MisconfigLoggedPrimary;
    }

    protected boolean isOldValueRequired() {
        return this.__m_OldValueRequired;
    }

    public boolean isPersistent() {
        return this.__m_Persistent;
    }

    public boolean isPotentiallyEvicting() {
        return this.__m_PotentiallyEvicting;
    }

    public boolean isPreferPutAllBackup() {
        return this.__m_PreferPutAllBackup;
    }

    public boolean isPreferPutAllPrimary() {
        return this.__m_PreferPutAllPrimary;
    }

    public boolean isValid() {
        return this.__m_Valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock(Lease lease) {
        Map mapLease = this.getLeaseMap();
        Binary binKey = (Binary)lease.getResourceKey();
        Lease leaseCurrent = (Lease)mapLease.get(binKey);
        int nHolderId = lease.getHolderId();
        long lHolderThreadId = lease.getHolderThreadId();
        PartitionedCache service = this.getService();
        if (leaseCurrent == null || leaseCurrent.getHolderId() == nHolderId && leaseCurrent.getHolderThreadId() == lHolderThreadId) {
            Map map = mapLease;
            synchronized (map) {
                if (!service.getServiceMemberSet().contains(nHolderId)) {
                    return false;
                }
                mapLease.put(binKey, lease);
                if (this.isPersistent()) {
                    int nPartition = service.getKeyPartition(binKey);
                    PartitionedCache.PartitionControl ctrl = (PartitionedCache.PartitionControl)service.getPartitionControl(nPartition);
                    PersistentStore store = ctrl.ensureOpenPersistentStore(null, true);
                    long ldtJoined = service.getServiceMemberSet().getServiceJoinTime(nHolderId);
                    CachePersistenceHelper.registerLock(store, this.getCacheId(), binKey, ldtJoined, lHolderThreadId, null);
                }
            }
            return true;
        }
        return false;
    }

    protected void moveData(int iPartition, Map mapFrom, Map mapTo, String sDescr) {
        PartitionedCache service = this.getService();
        PartitionedCache.PartitionControl ctrl = (PartitionedCache.PartitionControl)service.getPartitionControl(iPartition);
        PersistentStore store = ctrl.getPersistentBackupStore();
        long lExtentId = this.getCacheId();
        Object oToken = null;
        while (true) {
            try {
                Iterator iter = mapFrom.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    Binary binKey = (Binary)entry.getKey();
                    if (service.getKeyPartition(binKey) != iPartition) continue;
                    mapTo.put(binKey, entry.getValue());
                    if (this.isPersistent() && service.isBackupPersistence()) {
                        oToken = store.begin();
                        if ("locks".equals(sDescr)) {
                            Lease lease = (Lease)((Object)iter.next());
                            Binary binLeaseKey = (Binary)lease.getResourceKey();
                            CachePersistenceHelper.registerLock(store, lExtentId, binLeaseKey, service.getServiceMemberSet().getServiceJoinTime(lease.getHolderId()), lease.getHolderThreadId(), oToken);
                        } else if ("listeners".equals(sDescr)) {
                            com.tangosol.net.Member member = (com.tangosol.net.Member)entry.getKey();
                            Boolean FLite = (Boolean)entry.getValue();
                            CachePersistenceHelper.registerListener(store, lExtentId, binKey, service.getServiceMemberSet().getServiceJoinTime(member.getId()), FLite, oToken);
                        }
                        store.commit(oToken);
                    }
                    iter.remove();
                }
            }
            catch (ConcurrentModificationException e) {
                Storage._trace("Failed to move " + sDescr + ": " + String.valueOf(e) + "; trying again", 2);
                continue;
            }
            catch (Throwable t) {
                store.abort(oToken);
                throw Base.ensureRuntimeException(t);
            }
            break;
        }
    }

    public void movePartition(int iPartition, boolean fToBackup) {
        PartitionedCache service = this.getService();
        if (fToBackup) {
            this.moveData(iPartition, this.getLeaseMap(), this.getBackupLeaseMap(), "locks");
            this.firePendingLocks(iPartition);
            Map mapListeners = this.getKeyListenerMap();
            if (mapListeners != null && !mapListeners.isEmpty()) {
                this.moveData(iPartition, mapListeners, this.ensureBackupKeyListenerMap(), "listeners");
            }
            try {
                this.moveResourcesToBackup(iPartition);
            }
            catch (RuntimeException e) {
                this.reportTransferFailure(e, "backup");
            }
            if (this.isPersistent() && service.isBackupPersistence()) {
                this.persistGlobalMetadata(iPartition, true, null);
            }
        } else {
            try {
                this.moveResourcesToPrimary(iPartition);
            }
            catch (RuntimeException e) {
                this.reportTransferFailure(e, "primary");
            }
            this.insertPrimaryLeases(iPartition, ConverterCollections.getIterator(new FilterEnumerator(this.getBackupLeaseMap().entrySet().iterator(), (Filter)service.instantiatePartitionFilter(iPartition)), InvocableMapHelper.ENTRY_TO_VALUE_CONVERTER));
            Map mapListeners = this.getBackupKeyListenerMap();
            if (mapListeners != null && !mapListeners.isEmpty()) {
                this.insertPrimaryKeyListeners(iPartition, new FilterEnumerator(mapListeners.entrySet().iterator(), (Filter)service.instantiatePartitionFilter(iPartition)));
            }
            if (this.isPersistent()) {
                this.persistGlobalMetadata(iPartition, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveResourcesToBackup(int iPartition) {
        PartitionedCache service = this.getService();
        ObservableMap mapPrime = this.getBackingMapInternal();
        Map mapBackup = this.getBackupMap();
        boolean fPutAll = this.isPreferPutAllBackup();
        Set setKeys = this.collectKeySet(iPartition);
        PartitionAwareBackingMap pabmPrime = this.getPartitionAwareBackingMap();
        PartitionAwareBackingMap pabmBackup = this.getPartitionAwareBackupMap();
        if (pabmBackup != null) {
            Storage.ensurePartition(pabmBackup, iPartition);
        }
        ConfigurableCacheMap.EvictionApprover approver = null;
        ConfigurableCacheMap mapCCM = this.getConfigurableCacheMap(iPartition);
        int cRemoved = 0;
        long lExtentId = this.getCacheId();
        try {
            if (mapCCM != null) {
                approver = mapCCM.getEvictionApprover();
                mapCCM.setEvictionApprover(ConfigurableCacheMap.EvictionApprover.DISAPPROVER);
            }
            for (Binary binKey : setKeys) {
                Binary binValue = ExternalizableHelper.asBinary(this.getValueForTransfer(binKey, true));
                if (binValue == null) continue;
                if (fPutAll) {
                    mapBackup.putAll(Collections.singletonMap(binKey, binValue));
                } else {
                    mapBackup.put(binKey, binValue);
                }
                if (this.isPersistent() && service.isBackupPersistence()) {
                    PartitionedCache.PartitionControl ctrl = (PartitionedCache.PartitionControl)service.getPartitionControl(iPartition);
                    PersistentStore store = ctrl.ensureOpenPersistentStore(null, true, true);
                    ctrl.ensureBackupPersistentExtent(lExtentId);
                    Object oToken = store.begin(null, ctrl);
                    try {
                        store.store(lExtentId, binKey, binValue, oToken);
                        store.commit(oToken);
                    }
                    catch (Throwable t) {
                        store.abort(oToken);
                        throw Base.ensureRuntimeException(t);
                    }
                }
                ++cRemoved;
            }
        }
        finally {
            if (mapCCM != null) {
                mapCCM.setEvictionApprover(approver);
            }
        }
        service.processChanges();
        this.getStatsInserts().addAndGet(-cRemoved);
        if (pabmPrime == null) {
            PartitionAwareBackingMap mapKeyIndex = this.getPartitionedKeyIndex();
            if (mapKeyIndex != null) {
                mapKeyIndex.destroyPartition(iPartition);
            }
        } else {
            pabmPrime.destroyPartition(iPartition);
        }
    }

    protected void moveResourcesToPrimary(int iPartition) {
        PartitionedCache service = this.getService();
        HashMap<Binary, Binary> mapFrom = this.getBackupMap();
        PartitionAwareBackingMap pabmBackup = this.getPartitionAwareBackupMap();
        if (pabmBackup != null) {
            mapFrom = pabmBackup.getPartitionMap(iPartition);
        }
        this.preparePartition(iPartition, true);
        HashMap<Binary, Binary> mapEntries = mapFrom;
        if (pabmBackup == null) {
            mapEntries = new HashMap<Binary, Binary>();
            for (Map.Entry entry : mapFrom.entrySet()) {
                Binary binKey = (Binary)entry.getKey();
                Binary binVal = (Binary)entry.getValue();
                if (service.getKeyPartition(binKey) != iPartition) continue;
                mapEntries.put(binKey, binVal);
            }
        }
        if (mapEntries == null) {
            Storage._trace("Backup storage for partition " + iPartition + " is missing", 2);
            return;
        }
        this.insertPrimaryData(iPartition, mapEntries.entrySet().iterator());
        if (pabmBackup == null) {
            mapFrom.keySet().removeAll(mapEntries.keySet());
        } else {
            pabmBackup.destroyPartition(iPartition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBackingMapEvent(MapEvent evt) {
        Binary binKey = (Binary)evt.getKey();
        PartitionedCache service = this.getService();
        int iPartition = service.getKeyPartition(binKey);
        PartitionedCache.PartitionControl ctrlPartition = (PartitionedCache.PartitionControl)service.getPartitionControl(iPartition);
        PartitionedCache.TransferControl ctrlTransfer = (PartitionedCache.TransferControl)service.getTransferControl();
        while (true) {
            block21: {
                if (ctrlPartition == null) {
                    this.doBackingMapEvent(evt);
                    return;
                }
                int nLockState = ctrlPartition.getLockType();
                boolean fEnter = ctrlPartition.enter(0L);
                if (fEnter || service.isRecoveryThread() && ctrlPartition.isRecovering()) {
                    try {
                        if (this.isAdjustPartitionSize()) {
                            this.adjustStorageStats(evt, ctrlPartition.getStatistics());
                        }
                        if (ctrlPartition.isLocked()) {
                            boolean fPartIn;
                            int nEvtType = evt.getId();
                            boolean bl = fPartIn = nLockState == 2 || nLockState == 4;
                            if (nEvtType == 1 && fPartIn || nLockState == 3 && ctrlPartition.getTransferState() == 2 && nEvtType == 3) {
                                if (this.isIndexed() && (nEvtType == 3 || !service.getDaemonPool().isStarted())) {
                                    BinaryEntry binEntry = this.getTempBinaryEntry();
                                    binEntry.reset(binKey, (Binary)evt.getNewValue());
                                    binEntry.updateOriginalBinaryValue((Binary)evt.getOldValue());
                                    binEntry.ensureReadOnly();
                                    this.updateIndex(nEvtType, binEntry, null);
                                }
                                this.updateKeyIndex(evt);
                                return;
                            }
                            break block21;
                        }
                        this.doBackingMapEvent(evt);
                        return;
                    }
                    finally {
                        if (fEnter) {
                            ctrlPartition.exit();
                        }
                    }
                }
            }
            PartitionedCache.PartitionControl partitionControl = ctrlPartition;
            synchronized (partitionControl) {
                switch (ctrlPartition.getLockType()) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        ctrlPartition.addUnlockAction(this.instantiateDeferredEvent(evt, false));
                        return;
                    }
                    case 3: {
                        if (ctrlPartition.getTransferState() == 2) {
                            ctrlPartition.addUnlockAction(this.instantiateDeferredEvent(evt, false));
                        } else {
                            ctrlTransfer.deferEvent(this.instantiateDeferredEvent(evt, true));
                        }
                        return;
                    }
                }
            }
        }
    }

    @Override
    public void onInit() {
        PartitionedCache service = this.getService();
        if (service.getBackupCount() > 0) {
            this.setBackupMap(new SegmentedHashMap());
            this.setBackupLeaseMap(new SafeHashMap());
        }
        PartitionedCache.BackingMapContext ctx = service.getBackingMapContext();
        this.setConverterUp(ctx.getValueFromInternalConverter());
        this.setConverterKeyDown(ctx.getKeyToInternalConverter());
        this.setConverterValueDown(ctx.getValueToInternalConverter());
        this.setBackingMapInternal(new WrapperObservableMap(Collections.EMPTY_MAP));
        this.setResourceControlMap(service.getResourceCoordinator().instantiateControlMap());
        this.setStatsMaxQueryThresholdMillis(Config.getLong("coherence.distributed.query.statistics.threshold", this.getStatsMaxQueryThresholdMillis()));
        this.setQueryRetries(Config.getInteger("coherence.query.retry", 10));
        this.setQuerySizeCache(new LocalCache(1000, 600000));
        this.setEventDispatcherInterceptor((DispatcherInterceptor)this._findChild("DispatcherInterceptor"));
        this.setBackingMapAction((BackingMapAction)this._newChild("BackingMapAction"));
        super.onInit();
    }

    public void persistGlobalMetadata(int nPartition, PersistentStore store, Object oToken) {
        if (CachePersistenceHelper.isGlobalPartitioningSchemePID(nPartition)) {
            Set setTriggers;
            Map mapExtractor;
            PartitionedCache service = this.getService();
            Serializer serializer = service.getSerializer();
            if (store == null || !store.isOpen()) {
                store = service.getPartitionControl(nPartition).ensureOpenPersistentStore();
            }
            if (!(mapExtractor = this.getIndexExtractorMap()).isEmpty()) {
                for (Map.Entry entry : mapExtractor.entrySet()) {
                    Binary binExtractor = ExternalizableHelper.toBinary(entry.getKey(), serializer);
                    Binary binComparator = ExternalizableHelper.toBinary(entry.getValue(), serializer);
                    CachePersistenceHelper.registerIndex(store, this.getCacheId(), binExtractor, binComparator, oToken);
                }
            }
            if ((setTriggers = this.getTriggerSet()) != null) {
                Iterator iter = setTriggers.iterator();
                while (iter.hasNext()) {
                    Binary binTrigger = ExternalizableHelper.toBinary(iter.next(), serializer);
                    CachePersistenceHelper.registerTrigger(store, this.getCacheId(), binTrigger, oToken);
                }
            }
        }
    }

    public void persistGlobalMetadata(int nPartition, Object oToken) {
        this.persistGlobalMetadata(nPartition, null, oToken);
    }

    public void persistGlobalMetadata(int nPartition, boolean fBackup, Object oToken) {
        this.persistGlobalMetadata(nPartition, this.getService().getPartitionControl(nPartition).ensurePersistentStore(null, false, fBackup), oToken);
    }

    protected void persistIndexRegistration(PartitionSet parts, ValueExtractor extractor, Comparator comparator, boolean fAdd) {
        if (this.isPersistent()) {
            PartitionedCache service = this.getService();
            PartitionSet partsGlobal = CachePersistenceHelper.getGlobalPartitions(service);
            partsGlobal.retain(parts);
            if (!partsGlobal.isEmpty()) {
                Serializer serializer = service.getSerializer();
                Binary binExtractor = ExternalizableHelper.toBinary(extractor, serializer);
                int iPart = partsGlobal.next(0);
                while (iPart >= 0) {
                    PartitionedCache.PartitionControl ctrlPart = (PartitionedCache.PartitionControl)service.getPartitionControl(iPart);
                    PersistentStore store = ctrlPart.ensureOpenPersistentStore(null, true);
                    if (store != null) {
                        if (fAdd) {
                            ctrlPart.ensurePersistentExtent(this.getCacheId());
                            CachePersistenceHelper.registerIndex(store, this.getCacheId(), binExtractor, ExternalizableHelper.toBinary(comparator, serializer), null);
                        } else {
                            CachePersistenceHelper.unregisterIndex(store, this.getCacheId(), binExtractor, null);
                        }
                    }
                    iPart = partsGlobal.next(iPart + 1);
                }
            }
        }
    }

    public void persistListenerRegistration(Member member, Binary binKey, boolean fLite, boolean fAdd) {
        if (this.isPersistent()) {
            PartitionedCache service = this.getService();
            int nPartition = service.getKeyPartition(binKey);
            PartitionedCache.PartitionControl ctrlPartition = (PartitionedCache.PartitionControl)service.getPartitionControl(nPartition);
            long ldtJoined = service.getServiceMemberSet().getServiceJoinTime(member.getId());
            PersistentStore store = ctrlPartition.ensureOpenPersistentStore(null, true);
            long lExtentId = this.getCacheId();
            ctrlPartition.ensurePersistentExtent(lExtentId);
            if (fAdd) {
                CachePersistenceHelper.registerListener(store, lExtentId, binKey, ldtJoined, fLite, null);
            } else {
                CachePersistenceHelper.unregisterListener(store, lExtentId, binKey, ldtJoined, null);
            }
        }
    }

    public void persistTriggerRegistration(PartitionSet parts, MapTrigger trigger, boolean fAdd) {
        if (this.isPersistent()) {
            PartitionedCache service = this.getService();
            Serializer serializer = service.getSerializer();
            PartitionSet partsGlobal = CachePersistenceHelper.getGlobalPartitions(service);
            partsGlobal.retain(parts);
            int iPart = partsGlobal.next(0);
            while (iPart >= 0) {
                Binary binTrigger = ExternalizableHelper.toBinary(trigger, serializer);
                PersistentStore store = service.getPartitionControl(iPart).ensureOpenPersistentStore(null, true);
                if (fAdd) {
                    CachePersistenceHelper.registerTrigger(store, this.getCacheId(), binTrigger, null);
                } else {
                    CachePersistenceHelper.unregisterTrigger(store, this.getCacheId(), binTrigger, null);
                }
                iPart = partsGlobal.next(iPart + 1);
            }
        }
    }

    public void postInvoke(BinaryEntry entry) {
        if (entry.isValueChanged()) {
            entry.ensureReadOnly();
            Binary binKey = entry.getBinaryKey();
            try {
                if (entry.isValueRemoved()) {
                    this.removePrimaryResource(binKey, true, entry.isSynthetic());
                } else {
                    boolean fSynthetic;
                    Binary binValueNew = entry.getBinaryValue();
                    Binary binValueOld = entry.getOriginalBinaryValue();
                    long cExpiry = entry.getExpiry();
                    boolean bl = fSynthetic = entry.isSynthetic() || entry.isExpireChanged() && !entry.isValueUpdated();
                    if (!(Base.equals(binValueNew, binValueOld) && cExpiry == 0L || !entry.isValueUpdated() && binValueOld == null)) {
                        this.putPrimaryResource(binKey, binValueNew, cExpiry, true, fSynthetic);
                    }
                }
            }
            catch (Throwable e) {
                throw new HeuristicCommitException(e);
            }
        }
    }

    public void postInvokeAll(Collection colEntries) {
        HashMap<Binary, Binary> mapUpdates = new HashMap<Binary, Binary>(colEntries.size());
        HashSet<Binary> setRemove = null;
        for (BinaryEntry entry : colEntries) {
            if (!entry.isValueChanged()) continue;
            entry.ensureReadOnly();
            Binary binKey = entry.getBinaryKey();
            try {
                boolean fSynthetic;
                if (entry.isValueRemoved()) {
                    boolean fSynthetic2 = entry.isSynthetic();
                    if (fSynthetic2) {
                        this.removePrimaryResource(binKey, true, fSynthetic2);
                        continue;
                    }
                    if (setRemove == null) {
                        setRemove = new HashSet<Binary>(colEntries.size());
                    }
                    setRemove.add(binKey);
                    continue;
                }
                Binary binValueNew = entry.getBinaryValue();
                Binary binValueOld = entry.getOriginalBinaryValue();
                long cExpiry = entry.getExpiry();
                boolean bl = fSynthetic = entry.isSynthetic() || entry.isExpireChanged() && !entry.isValueUpdated();
                if (Base.equals(binValueNew, binValueOld) && cExpiry == 0L || !entry.isValueUpdated() && binValueOld == null) continue;
                if (entry.isExpireChanged() || fSynthetic) {
                    this.putPrimaryResource(binKey, binValueNew, cExpiry, true, fSynthetic);
                    continue;
                }
                mapUpdates.put(this.getCanonicalKey(binKey), binValueNew);
            }
            catch (Throwable e) {
                throw new HeuristicCommitException(e);
            }
        }
        if (!mapUpdates.isEmpty()) {
            this.putAllPrimaryResource(mapUpdates);
        }
        if (setRemove != null) {
            this.removeAllPrimaryResource(setRemove);
        }
    }

    protected void postPut(BinaryEntry entry, EntryStatus status, boolean fBlind) {
        entry.ensureReadOnly();
        Binary binKey = entry.getBinaryKey();
        Binary binValueReturn = null;
        try {
            if (entry.isValueRemoved()) {
                binValueReturn = this.removePrimaryResource(binKey, fBlind, entry.isSynthetic());
            } else {
                Binary binValueNew = entry.getBinaryValue();
                long cExpiry = entry.getExpiry();
                binValueReturn = this.putPrimaryResource(binKey, binValueNew, cExpiry, fBlind, entry.isSynthetic());
            }
        }
        catch (Throwable e) {
            throw new HeuristicCommitException(e);
        }
        if (!fBlind) {
            status.setResult(binValueReturn);
        }
    }

    protected void postPutAll(EntryStatus[] aStatus) {
        int cSize = aStatus.length;
        HashMap<Binary, Binary> map = new HashMap<Binary, Binary>(cSize);
        for (int i = 0; i < cSize; ++i) {
            EntryStatus status = aStatus[i];
            BinaryEntry binEntry = status.getBinaryEntry();
            if (binEntry.isExpireChanged() || binEntry.isValueRemoved()) {
                this.postPut(binEntry, status, true);
                continue;
            }
            map.put(this.getCanonicalKey(binEntry.getBinaryKey()), binEntry.getBinaryValue());
        }
        this.putAllPrimaryResource(map);
    }

    protected void postRemove(BinaryEntry entry, EntryStatus status, boolean fBlind) {
        if (entry.isValueChanged()) {
            entry.ensureReadOnly();
            Binary binKey = entry.getBinaryKey();
            Binary binValueReturn = null;
            boolean fExists = false;
            try {
                if (fBlind) {
                    fExists = this.getBackingMapInternal().containsKey(binKey);
                }
                if (entry.isValueRemoved()) {
                    binValueReturn = this.removePrimaryResource(binKey, fBlind, entry.isSynthetic());
                } else {
                    Binary binValueNew = entry.getBinaryValue();
                    long cExpiry = entry.getExpiry();
                    boolean fSynthetic = entry.isSynthetic() || entry.isExpireChanged() && !entry.isValueUpdated();
                    binValueReturn = this.putPrimaryResource(binKey, binValueNew, cExpiry, fBlind, fSynthetic);
                }
                if (fBlind) {
                    binValueReturn = fExists ? Binary.EMPTY : null;
                }
            }
            catch (Throwable e) {
                throw new HeuristicCommitException(e);
            }
            status.setResult(binValueReturn);
        }
    }

    protected boolean postRemoveAll(EntryStatus[] aStatus) {
        int cSize = aStatus.length;
        HashSet<Binary> setRemove = null;
        HashMap<Binary, Binary> mapUpdates = null;
        boolean fRemoved = false;
        for (int i = 0; i < cSize; ++i) {
            EntryStatus status = aStatus[i];
            BinaryEntry binEntry = status.getBinaryEntry();
            if (!binEntry.isValueChanged()) continue;
            Binary binKey = binEntry.getBinaryKey();
            binEntry.ensureReadOnly();
            try {
                boolean fSynthetic;
                if (binEntry.isValueRemoved()) {
                    if (setRemove == null) {
                        setRemove = new HashSet<Binary>(cSize);
                    }
                    setRemove.add(binEntry.getBinaryKey());
                    fRemoved |= true;
                    continue;
                }
                Binary binValueNew = binEntry.getBinaryValue();
                Binary binValueOld = binEntry.getOriginalBinaryValue();
                long cExpiry = binEntry.getExpiry();
                boolean bl = fSynthetic = binEntry.isSynthetic() || binEntry.isExpireChanged() && !binEntry.isValueUpdated();
                if (Base.equals(binValueNew, binValueOld) && cExpiry == 0L || !binEntry.isValueUpdated() && binValueOld == null) continue;
                if (binEntry.isExpireChanged() || fSynthetic) {
                    this.putPrimaryResource(binKey, binValueNew, cExpiry, true, fSynthetic);
                    continue;
                }
                if (mapUpdates == null) {
                    mapUpdates = new HashMap<Binary, Binary>(cSize);
                }
                mapUpdates.put(this.getCanonicalKey(binKey), binValueNew);
                continue;
            }
            catch (Throwable e) {
                throw new HeuristicCommitException(e);
            }
        }
        if (mapUpdates != null) {
            this.putAllPrimaryResource(mapUpdates);
        }
        if (setRemove != null) {
            this.removeAllPrimaryResource(setRemove);
        }
        return fRemoved;
    }

    public PartitionedCache.MapEvent prepareDispatch(MapEvent event, Filter filter, Member member, boolean fLite, long lFilterId) {
        int nEventType = event.getId();
        Binary binKey = (Binary)event.getKey();
        Binary binValueOld = (Binary)event.getOldValue();
        Binary binValueNew = (Binary)event.getNewValue();
        boolean fTransformed = false;
        ConverterCollections.ConverterMapEvent evtConv = this.createConverterEvent(nEventType, binKey, binValueOld, binValueNew, null);
        if (filter instanceof MapEventTransformer) {
            boolean fNew;
            MapEvent evtTrans = ((MapEventTransformer)((Object)filter)).transform(evtConv);
            if (evtTrans == null) {
                return null;
            }
            boolean bl = fNew = evtTrans != evtConv;
            if (fNew || evtConv.isKeyConverted()) {
                binKey = (Binary)this.getConverterKeyDown().convert(evtTrans.getKey());
                fTransformed = true;
            }
            if (fNew || evtConv.isOldValueConverted()) {
                binValueOld = (Binary)this.getConverterValueDown().convert(evtTrans.getOldValue());
                fTransformed = true;
            }
            if (fNew || evtConv.isNewValueConverted()) {
                binValueNew = (Binary)this.getConverterValueDown().convert(evtTrans.getNewValue());
                fTransformed = true;
            }
        }
        if (fTransformed) {
            nEventType |= 0x20;
        }
        return this.prepareEventMessage(SingleMemberSet.instantiate(member), nEventType, binKey, fLite || fTransformed ? null : binValueOld, fLite || fTransformed ? null : binValueNew, new long[]{lFilterId}, event.getPartition(), event.getVersion());
    }

    public Object prepareDispatch(MapEvent event, BinaryEntry binEntry) {
        Map mapMembers;
        int cKeys;
        Object oEvtHolder = null;
        Map mapListeners = this.getListenerMap();
        Map mapKeyListeners = this.getKeyListenerMap();
        int cFilters = mapListeners == null ? 0 : mapListeners.size();
        int n = cKeys = mapKeyListeners == null ? 0 : mapKeyListeners.size();
        if (cFilters == 0 && cKeys == 0) {
            return oEvtHolder;
        }
        int nEventType = event.getId() | (binEntry.isSynthetic() ? 8 : 0) | (event instanceof CacheEvent ? (((CacheEvent)event).isExpired() ? 128 : 0) : 0);
        Binary binKey = (Binary)event.getKey();
        Binary binValueOld = (Binary)event.getOldValue();
        Binary binValueNew = (Binary)event.getNewValue();
        MemberSet setStd = new MemberSet();
        MemberSet setLite = new MemberSet();
        if (cKeys > 0 && (mapMembers = (Map)mapKeyListeners.get(binKey)) != null) {
            for (Map.Entry entry : mapMembers.entrySet()) {
                com.tangosol.net.Member member = (com.tangosol.net.Member)entry.getKey();
                Boolean FLite = (Boolean)entry.getValue();
                if (FLite.booleanValue()) {
                    setLite.add(member);
                    continue;
                }
                setStd.add(member);
            }
        }
        long[] alFilterId = null;
        if (cFilters > 0) {
            Map mapFilterId = this.getFilterIdMap();
            HashSet setIds = new HashSet();
            ConverterCollections.ConverterMapEvent evtConv = null;
            Iterator iterFilter = mapListeners.entrySet().iterator();
            while (iterFilter.hasNext()) {
                Binary binValueNewTrans;
                Binary binValueOldTrans;
                Binary binKeyTrans;
                boolean fTransformed;
                Map mapMembers2;
                Object filter;
                block23: {
                    Map.Entry entry = iterFilter.next();
                    filter = entry.getKey();
                    mapMembers2 = (Map)entry.getValue();
                    fTransformed = false;
                    binKeyTrans = binKey;
                    binValueOldTrans = binValueOld;
                    binValueNewTrans = binValueNew;
                    if (filter instanceof Filter) {
                        block22: {
                            if (evtConv == null) {
                                evtConv = this.createConverterEvent(nEventType, binKey, binValueOld, binValueNew, binEntry);
                            }
                            try {
                                if (!((Filter)filter).evaluate(evtConv)) {
                                }
                                break block22;
                            }
                            catch (RuntimeException e) {
                                Storage._trace("Exception occurred during filter evaluation: " + String.valueOf(filter) + "; removing the filter...", 1);
                                Storage._trace(e);
                                iterFilter.remove();
                            }
                            continue;
                        }
                        if (filter instanceof MapEventTransformer) {
                            try {
                                boolean fNew;
                                evtConv.clearConverted();
                                MapEvent evtTrans = ((MapEventTransformer)filter).transform(evtConv);
                                if (evtTrans == null) continue;
                                boolean bl = fNew = evtTrans != evtConv;
                                if (fNew || evtConv.isKeyConverted()) {
                                    binKeyTrans = (Binary)this.getConverterKeyDown().convert(evtTrans.getKey());
                                    fTransformed = true;
                                }
                                if (fNew || evtConv.isOldValueConverted()) {
                                    binValueOldTrans = (Binary)this.getConverterValueDown().convert(evtTrans.getOldValue());
                                    fTransformed = true;
                                }
                                if (!fNew && !evtConv.isNewValueConverted()) break block23;
                                binValueNewTrans = (Binary)this.getConverterValueDown().convert(evtTrans.getNewValue());
                                fTransformed = true;
                            }
                            catch (RuntimeException e) {
                                Storage._trace("Exception occurred during event transformation: " + String.valueOf(filter) + "; removing the filter...", 1);
                                Storage._trace(e);
                                iterFilter.remove();
                                continue;
                            }
                        }
                    }
                }
                MemberSet setStdTrans = fTransformed ? new MemberSet() : setStd;
                MemberSet setLiteTrans = fTransformed ? new MemberSet() : setLite;
                HashSet setIdsTrans = fTransformed ? new HashSet() : setIds;
                for (Map.Entry entryMember : mapMembers2.entrySet()) {
                    com.tangosol.net.Member member = (com.tangosol.net.Member)entryMember.getKey();
                    Boolean FLite = (Boolean)entryMember.getValue();
                    Map mapMemberFilterId = (Map)mapFilterId.get(member);
                    Set setFilterId = mapMemberFilterId == null ? null : (Set)mapMemberFilterId.get(filter == Binary.EMPTY ? null : filter);
                    if (setFilterId == null) continue;
                    setIdsTrans.addAll(setFilterId);
                    if (FLite.booleanValue()) {
                        if (setStdTrans.contains(member)) continue;
                        setLiteTrans.add(member);
                        continue;
                    }
                    setStdTrans.add(member);
                    setLiteTrans.remove(member);
                }
                if (!fTransformed) continue;
                long[] alFilterIdTrans = Storage.toLongArray(setIdsTrans);
                if (!setLiteTrans.isEmpty()) {
                    oEvtHolder = Storage.accumulateMapEvents(oEvtHolder, this.prepareEventMessage(setLiteTrans, nEventType | 0x20, binKeyTrans, null, null, alFilterIdTrans, event.getPartition(), event.getVersion()));
                }
                if (!setStdTrans.isEmpty()) {
                    oEvtHolder = Storage.accumulateMapEvents(oEvtHolder, this.prepareEventMessage(setStdTrans, nEventType | 0x20, binKeyTrans, binValueOldTrans, binValueNewTrans, alFilterIdTrans, event.getPartition(), event.getVersion()));
                }
                evtConv.clearConverted();
            }
            alFilterId = Storage.toLongArray(setIds);
        }
        if (!setLite.isEmpty()) {
            oEvtHolder = Storage.accumulateMapEvents(oEvtHolder, this.prepareEventMessage(setLite, nEventType, binKey, null, binEntry.isValueStale() ? binValueNew : null, alFilterId, event.getPartition(), event.getVersion()));
        }
        if (!setStd.isEmpty()) {
            oEvtHolder = Storage.accumulateMapEvents(oEvtHolder, this.prepareEventMessage(setStd, nEventType, binKey, binValueOld, binValueNew, alFilterId, event.getPartition(), event.getVersion()));
        }
        return oEvtHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PartitionedCache.MapEvent prepareEventMessage(MemberSet setMembers, int nEventType, Binary binKey, Binary binValueOld, Binary binValueNew, long[] alFilterId, int iPartition, long lVersion) {
        long lOldestEventSUID;
        long lEventSUID;
        PartitionedCache service = this.getService();
        LongArray laPending = service.getPendingEvents();
        PartitionedCache.MapEvent msg = (PartitionedCache.MapEvent)service.instantiateMessage("MapEvent");
        LongArray longArray = laPending;
        synchronized (longArray) {
            lEventSUID = service.getSUID(2);
            laPending.set(lEventSUID, msg);
            lOldestEventSUID = service.getOldestPendingEventSUID();
        }
        msg.setEventSUID(lEventSUID);
        msg.setOldestPendingEventSUID(lOldestEventSUID);
        msg.setToMemberSet(setMembers);
        msg.setCacheId(this.getCacheId());
        msg.setEventType(nEventType);
        msg.setKey(binKey);
        msg.setOldValue(binValueOld);
        msg.setNewValue(binValueNew);
        msg.setFilterId(alFilterId);
        msg.setPartition(iPartition);
        msg.setVersion(lVersion);
        Span span = TracingHelper.getActiveSpan();
        if (span != null) {
            msg.setTracingSpanContext(span.getContext());
        }
        this.setStatsEventsDispatched(this.getStatsEventsDispatched() + 1L);
        return msg;
    }

    public void preparePartition(int iPartition, boolean fPrimary) {
        PartitionAwareBackingMap mapKeyIndex;
        Map map;
        Map map2 = map = fPrimary ? this.getBackingMapInternal() : this.getBackupMap();
        if (map instanceof PartitionAwareBackingMap) {
            Storage.ensurePartition((PartitionAwareBackingMap)map, iPartition);
        } else if (fPrimary && (mapKeyIndex = this.getPartitionedKeyIndex()) != null) {
            Storage.ensurePartition(mapKeyIndex, iPartition);
        }
    }

    public void preparePersistentExtent() {
        if (this.isPersistent()) {
            PartitionedCache service = this.getService();
            LongArray laCaches = service.getPersistentCacheIds();
            long lCacheId = this.getCacheId();
            PartitionSet parts = service.calculatePartitionSet(service.getThisMember(), 0);
            int i = parts.next(0);
            while (i >= 0) {
                service.getPartitionControl(i).preparePersistentExtent(lCacheId, laCaches, false);
                i = parts.next(i + 1);
            }
            if (service.isBackupPersistence()) {
                for (i = 1; i <= service.getBackupCount(); ++i) {
                    PartitionSet partsBackup = service.calculatePartitionSet(service.getThisMember(), i);
                    int j = partsBackup.next(0);
                    while (j >= 0) {
                        service.getPartitionControl(j).preparePersistentExtent(lCacheId, laCaches, true);
                        j = partsBackup.next(j + 1);
                    }
                }
            }
        }
    }

    protected List processIndexFailure(Throwable e, ValueExtractor extractor, BinaryEntry binEntry, List list) {
        String sKey = "";
        try {
            sKey = String.valueOf(binEntry.getKey());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Storage._trace("Exception occurred during index update of key " + sKey + " (" + String.valueOf(binEntry.getBinaryKey()) + "); removing index (" + String.valueOf(extractor) + ")", 1);
        Storage._trace(e);
        this.removeIndex(null, this.getService().collectOwnedPartitions(true), extractor, (Comparator)this.getIndexExtractorMap().get(extractor));
        if (list == null) {
            list = new LinkedList<ValueExtractor>();
        }
        list.add(extractor);
        return list;
    }

    public void processInterceptors(Collection colEntries) {
        PartitionedCache.EventsHelper evtHelper = this.getService().getEventsHelper();
        if (this.getTriggerSet() != null || evtHelper.hasPreCommitInterceptors(this)) {
            for (BinaryEntry entry : colEntries) {
                if (entry == null || !entry.isValueChanged() && !entry.isValueLoaded()) continue;
                this.processTriggers(entry);
                evtHelper.onEntryChanging(entry, null);
            }
        }
    }

    public void processTriggers(BinaryEntry binEntry) {
        Set setTriggers = this.getTriggerSet();
        if (setTriggers != null) {
            for (MapTrigger trigger : setTriggers) {
                trigger.process(binEntry);
            }
        }
    }

    public void put(PartitionedCache.InvocationContext ctxInvoke, EntryStatus status, Binary binValueNew, long cMillis, boolean fBlind) {
        ObservableMap mapResource = this.getBackingMapInternal();
        BinaryEntry entry = status.getBinaryEntry();
        entry.updateBinaryValue(binValueNew);
        if (cMillis != 0L) {
            if (cMillis > 0L && !(mapResource instanceof CacheMap)) {
                throw new UnsupportedOperationException("Class \"" + mapResource.getClass().getName() + "\" does not implement CacheMap interface");
            }
            entry.expire(cMillis);
        }
        Set setEntriesAdded = ctxInvoke.processInterceptors();
        if (entry.getBinaryValue() != binValueNew) {
            entry.markStale();
        }
        this.postPut(entry, status, fBlind);
        ctxInvoke.postInvokeAll(setEntriesAdded);
    }

    public void putAll(PartitionedCache.InvocationContext ctxInvoke, EntryStatus[] aStatus, Binary[] aBinValuesNew) {
        int cSize = aStatus.length;
        for (int i = 0; i < cSize; ++i) {
            EntryStatus status = aStatus[i];
            BinaryEntry entry = status.getBinaryEntry();
            entry.updateBinaryValue(aBinValuesNew[i]);
        }
        Set setEntriesAdded = ctxInvoke.processInterceptors();
        for (int i = 0; i < cSize; ++i) {
            EntryStatus status = aStatus[i];
            BinaryEntry entry = status.getBinaryEntry();
            if (entry.getBinaryValue() == aBinValuesNew[i]) continue;
            entry.markStale();
        }
        this.postPutAll(aStatus);
        ctxInvoke.postInvokeAll(setEntriesAdded);
    }

    protected void putAllPrimaryResource(Map mapEntries) {
        if (!mapEntries.isEmpty()) {
            try {
                ObservableMap map = this.getBackingMapInternal();
                map.putAll(mapEntries);
            }
            catch (Throwable e) {
                throw new HeuristicCommitException(e);
            }
        }
    }

    public void putPrimaryResource(Binary binKey, Binary binValue) {
        this.putPrimaryResource(binKey, binValue, this.decodeExpiry(binValue), true, false);
    }

    protected Binary putPrimaryResource(Binary binKey, Binary binValue, long cExpiry, boolean fBlind, boolean fSynthetic) {
        ObservableMap map = this.getBackingMapInternal();
        Binary binValueReturn = null;
        if (fSynthetic) {
            map = this.getBackingInternalCache();
        }
        binKey = this.getCanonicalKey(binKey);
        if (cExpiry != 0L) {
            if (map instanceof CacheMap) {
                ConfigurableCacheMap mapCCM = this.getBackingConfigurableCache();
                if (mapCCM == null) {
                    if (!ExternalizableHelper.isDecorated(binValue, 1)) {
                        binValue = this.encodeExpiry(binValue, cExpiry);
                    }
                } else {
                    binValue = ExternalizableHelper.undecorate(binValue, 1);
                    if (cExpiry > 0L && cExpiry != (long)mapCCM.getExpiryDelay()) {
                        this.scheduleEviction(cExpiry);
                    }
                }
                binValueReturn = ((CacheMap)map).put(binKey, binValue, cExpiry);
                if (cExpiry != -1L) {
                    this.setPotentiallyEvicting(true);
                }
            } else {
                Storage._trace("Dropping an entry expiry attribute due to incompatible backing map configuration (cache=" + this.getCacheName() + ")", 1);
            }
        } else if (fBlind && this.isPreferPutAllPrimary()) {
            map.putAll(Collections.singletonMap(binKey, binValue));
        } else {
            binValueReturn = map.put(binKey, binValue);
        }
        return binValueReturn;
    }

    public QueryResult query(Filter filter, int nQueryType, PartitionSet partMask, long cTimeoutMillis) {
        QueryResult result;
        Span span = TracingHelper.getActiveSpan();
        if (!TracingHelper.isNoop(span) && filter != null) {
            span.setMetadata("filter", filter.toString());
        }
        if (AlwaysFilter.INSTANCE.equals(filter)) {
            filter = null;
        }
        long ldtStart = Base.getSafeTimeMillis();
        long lIdxVersion = nQueryType == 1 ? -1L : this.getVersion().getCommittedVersion();
        int cTotal = this.calculateSize(partMask, false);
        if (partMask.cardinality() == 1 || filter instanceof LimitFilter) {
            result = this.queryInternal(filter, nQueryType == 3 ? 1 : nQueryType, partMask, lIdxVersion);
        } else if (!Daemons.isForkJoinPoolEnabled() || filter instanceof ScriptFilter) {
            QueryResult[] aResult = new QueryResult[partMask.cardinality()];
            int nPos = 0;
            for (int nPart : partMask) {
                aResult[nPos++] = this.queryInternal(filter, nQueryType == 3 ? 1 : nQueryType, new PartitionSet(partMask.getPartitionCount(), nPart), lIdxVersion);
            }
            result = new QueryResult(aResult);
        } else {
            ForkJoinTask<QueryResult> future = Daemons.forkJoinPool().submit(new PartitionedQueryTask(this, filter, nQueryType, partMask, lIdxVersion));
            try {
                result = cTimeoutMillis == 0L ? (QueryResult)future.get() : (QueryResult)future.get(cTimeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                future.cancel(true);
                throw new RequestTimeoutException("Query request has timed out");
            }
            catch (InterruptedException e) {
                future.cancel(true);
                Thread.currentThread().interrupt();
                throw new RequestTimeoutException("Query request has been interrupted");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (nQueryType == 3) {
            Object[] aoResult = result.getResults();
            Arrays.sort(aoResult, SafeComparator.INSTANCE);
            int cResults = this.createQueryResult(filter, aoResult, nQueryType, partMask, lIdxVersion);
            result = new QueryResult(partMask, aoResult, cResults);
        }
        this.updateQueryStatistics(filter, result.isOptimized(), ldtStart, cTotal, result.getScannedCount(), result.getCount(), nQueryType, partMask);
        return result;
    }

    protected QueryResult queryInternal(Filter filter, int nQueryType, PartitionSet partMask, long lIdxVersion) {
        int cResults;
        Filter<?> filterOrig = filter;
        QueryResult result = this.applyIndex(filter, partMask);
        Object[] aoResult = result.getResults();
        if (aoResult == null) {
            aoResult = this.collectKeys(partMask);
            result.setResults(aoResult);
        }
        filter = result.getFilterRemaining();
        if (filterOrig instanceof LimitFilter) {
            Arrays.sort(aoResult, SafeComparator.INSTANCE);
        }
        int n = cResults = filter == null ? this.createQueryResult(filterOrig, aoResult, nQueryType, partMask, lIdxVersion) : this.createQueryResult(filter, filterOrig, aoResult, nQueryType, partMask, lIdxVersion);
        if (filterOrig instanceof LimitFilter) {
            if (cResults < aoResult.length) {
                Object[] ao = new Object[cResults];
                System.arraycopy(aoResult, 0, ao, 0, cResults);
                aoResult = ao;
            }
            LimitFilter filterLimit = (LimitFilter)filterOrig;
            int cAvailable = aoResult.length;
            filterLimit.setCookie(cAvailable);
            aoResult = nQueryType == 1 || filterLimit.getComparator() == null ? filterLimit.extractPage(aoResult) : this.extractBinaryEntries(aoResult, filterLimit);
            result.setResults(aoResult);
        } else {
            result.setResults(aoResult, cResults);
        }
        return result;
    }

    public void reevaluateQueryResults(Filter filterOrig, Map mapEval, int nQueryType, PartitionSet partMask) {
        PartitionedCache service = (PartitionedCache)this.get_Module();
        ObservableMap mapPrime = this.getBackingMapInternal();
        StorageVersion version = this.getVersion();
        Filter<?> filter = null;
        int cRetry = 0;
        int cRetryMax = this.getQueryRetries();
        long lIdxVerPrev = -1L;
        boolean fInvoke = nQueryType == 3;
        Set setKeysEval = mapEval.keySet();
        SubSet setKeys = new SubSet(setKeysEval);
        while (!setKeys.isEmpty()) {
            long lIdxVersion = version.getCommittedVersion();
            if (lIdxVersion == lIdxVerPrev) {
                if (++cRetry >= cRetryMax) break;
                service.processChanges();
                version.waitForPendingCommit(partMask.first());
                continue;
            }
            this.getStatsQueryContentionCount().incrementAndGet();
            try {
                for (int nPart : partMask) {
                    filter = filterOrig instanceof IndexAwareFilter ? ((IndexAwareFilter)filterOrig).applyIndex(this.getIndexMap(nPart), setKeys) : filterOrig;
                }
            }
            catch (ConcurrentModificationException e) {
                continue;
            }
            catch (Throwable e) {
                Storage._trace("Exception occurred during query processing: " + Storage.getStackTrace(e), 1);
                Storage.rethrow(e);
            }
            Set setRemoved = setKeys.getRemoved();
            Set setRetained = setKeys.getRetained();
            mapEval.keySet().removeAll(setRemoved);
            Iterator iter = setRetained.iterator();
            while (iter.hasNext()) {
                Binary binVal;
                BinaryEntry entry;
                Binary binKey = (Binary)iter.next();
                if (fInvoke) {
                    EntryStatus status = service.getResourceCoordinator().getStatus(this, binKey);
                    entry = status.getBinaryEntry();
                    mapEval.put(binKey, status);
                    if (entry.isValueStale()) {
                        entry.reset(binKey);
                        entry.ensureWriteable();
                    }
                } else {
                    entry = (BinaryEntry)mapEval.get(binKey);
                    if (entry == null) {
                        entry = this.instantiateBinaryEntry(binKey, null, true);
                        mapEval.put(binKey, entry);
                    } else {
                        entry.reset(binKey);
                    }
                }
                if ((binVal = entry.getBinaryValue()) != null) continue;
                iter.remove();
                mapEval.remove(binKey);
            }
            if (lIdxVersion == this.checkBackingMapVersion(mapPrime, partMask)) {
                setKeys.clear();
                break;
            }
            HashSet<Binary> setStable = new HashSet<Binary>();
            ConcurrentMap mapStatus = this.getEntryStatusMap();
            if ((partMask = version.getModifiedPartitions(lIdxVersion, partMask)).isEmpty()) {
                setKeys.clear();
                break;
            }
            if (setRetained == setKeysEval) {
                setRetained = new HashSet(setRetained);
            }
            Iterator iter2 = setRetained.iterator();
            while (iter2.hasNext()) {
                Binary binKey = (Binary)iter2.next();
                if (!partMask.contains(service.getKeyPartition(binKey))) {
                    iter2.remove();
                    continue;
                }
                if (mapStatus.containsKey(binKey)) continue;
                setStable.add(binKey);
            }
            if (lIdxVersion == version.getCommittedVersion()) {
                setRetained.removeAll(setStable);
            }
            setKeys = new SubSet(setRetained);
            lIdxVerPrev = lIdxVersion;
            service.checkInterrupt();
        }
        if (!setKeys.isEmpty()) {
            Storage._trace("Performing partial entry scan (" + setKeys.size() + " out of " + mapEval.size() + ") due to concurrent updates during query execution", 3);
            for (Binary binKey : setKeys) {
                BinaryEntry binEntry = fInvoke ? ((EntryStatus)mapEval.get(binKey)).getBinaryEntry() : (BinaryEntry)mapEval.get(binKey);
                binEntry.setForceExtract(true);
                try {
                    if (!InvocableMapHelper.evaluateEntry(filterOrig, binEntry)) {
                        mapEval.remove(binKey);
                    }
                }
                catch (RuntimeException e) {
                    Storage._trace("Skipping potential entry match for " + String.valueOf(binKey) + "\n" + Storage.getStackTrace(e), 1);
                    mapEval.remove(binKey);
                }
                binEntry.setForceExtract(false);
            }
        }
        if (filter != null) {
            Iterator iter = mapEval.values().iterator();
            while (iter.hasNext()) {
                BinaryEntry entry = fInvoke ? ((EntryStatus)iter.next()).getBinaryEntry() : (BinaryEntry)iter.next();
                if (InvocableMapHelper.evaluateEntry(filter, entry)) continue;
                iter.remove();
            }
        }
    }

    protected void releaseBackupResources(int iPartition) {
        PartitionedCache service = this.getService();
        PartitionAwareBackingMap pabmBackup = this.getPartitionAwareBackupMap();
        if (pabmBackup != null) {
            pabmBackup.destroyPartition(iPartition);
        } else {
            Iterator iter = this.getBackupMap().keySet().iterator();
            while (iter.hasNext()) {
                Binary binKey = (Binary)iter.next();
                if (service.getKeyPartition(binKey) != iPartition) continue;
                iter.remove();
            }
        }
    }

    protected void releaseData(int iPartition, Map map, String sDescr) {
        PartitionedCache service = this.getService();
        while (true) {
            try {
                Iterator iter = map.keySet().iterator();
                while (iter.hasNext()) {
                    Binary binKey = (Binary)iter.next();
                    if (service.getKeyPartition(binKey) != iPartition) continue;
                    iter.remove();
                }
            }
            catch (ConcurrentModificationException e) {
                Storage._trace("Failed to release " + sDescr + ": " + String.valueOf(e) + "; trying again", 2);
                continue;
            }
            break;
        }
    }

    public void releasePartition(int iPartition, boolean fPrimary) {
        Map map;
        Map map2 = map = fPrimary ? this.getKeyListenerMap() : this.getBackupKeyListenerMap();
        if (map != null && !map.isEmpty()) {
            this.releaseData(iPartition, map, "listeners");
        }
        map = fPrimary ? this.getLeaseMap() : this.getBackupLeaseMap();
        this.releaseData(iPartition, map, "locks");
        if (fPrimary) {
            this.firePendingLocks(iPartition);
        }
        if (fPrimary) {
            this.releasePrimaryResources(iPartition);
        } else {
            this.releaseBackupResources(iPartition);
        }
    }

    protected void releasePrimaryResources(int iPartition) {
        int cRemoves;
        Map mapPart;
        ObservableMap mapPrime = this.getBackingMapInternal();
        PartitionAwareBackingMap pabmPrime = this.getPartitionAwareBackingMap();
        Map map = mapPart = pabmPrime == null ? null : pabmPrime.getPartitionMap(iPartition);
        if (mapPart instanceof ObservableMap) {
            cRemoves = mapPart.size();
            mapPart.clear();
        } else {
            Set setKeys = this.collectKeySet(iPartition);
            Iterator iter = setKeys.iterator();
            while (iter.hasNext()) {
                mapPrime.remove(iter.next());
            }
            cRemoves = setKeys.size();
        }
        this.getService().processChanges();
        this.getStatsInserts().addAndGet(-cRemoves);
        if (pabmPrime == null) {
            PartitionAwareBackingMap mapKeyIndex = this.getPartitionedKeyIndex();
            if (mapKeyIndex != null) {
                mapKeyIndex.destroyPartition(iPartition);
            }
        } else {
            pabmPrime.destroyPartition(iPartition);
        }
    }

    public void remove(PartitionedCache.InvocationContext ctxInvoke, EntryStatus status, boolean fBlind) {
        status.getBinaryEntry().remove(false);
        Set setEntriesAdded = ctxInvoke.processInterceptors();
        this.postRemove(status.getBinaryEntry(), status, fBlind);
        ctxInvoke.postInvokeAll(setEntriesAdded);
    }

    public boolean removeAll(PartitionedCache.InvocationContext ctxInvoke, EntryStatus[] aStatus) {
        boolean fRemoved = false;
        int cSize = aStatus.length;
        for (int i = 0; i < cSize; ++i) {
            EntryStatus status = aStatus[i];
            status.getBinaryEntry().remove(false);
        }
        Set setEntriesAdded = ctxInvoke.processInterceptors();
        fRemoved = this.postRemoveAll(aStatus);
        ctxInvoke.postInvokeAll(setEntriesAdded);
        return fRemoved;
    }

    protected void removeAllPrimaryResource(Set setKeys) {
        if (!setKeys.isEmpty()) {
            try {
                this.getBackingMapInternal().keySet().removeAll(setKeys);
            }
            catch (Throwable e) {
                throw new HeuristicCommitException(e);
            }
        }
    }

    public void removeIndex(RequestContext context, PartitionSet partsMask, ValueExtractor extractor, Comparator comparator) {
        if (this.checkIndexExists(extractor, comparator, false)) {
            if (context != null) {
                this.checkAccess(context, 49152, 11);
            }
            int iPart = partsMask.next(0);
            while (iPart >= 0) {
                Map mapIndex = this.getPartitionIndexMap(iPart);
                MapIndex mapIndex2 = extractor instanceof IndexAwareExtractor ? ((IndexAwareExtractor)extractor).destroyIndex(mapIndex) : (MapIndex)mapIndex.remove(extractor);
                iPart = partsMask.next(iPart + 1);
            }
            this.getIndexExtractorMap().remove(extractor);
            this.persistIndexRegistration(partsMask, extractor, comparator, false);
        }
    }

    public void removeKeyListener(Member member, Binary binKey, boolean fPrimary) {
        this.removeListenerProxy(fPrimary ? this.getKeyListenerMap() : this.getBackupKeyListenerMap(), binKey, member);
    }

    public void removeListener(Member member, Filter filter, long lFilterId) {
        Set setFilterId;
        Map mapMemberFilterId;
        Serializable oFilter = filter == null ? Binary.EMPTY : filter;
        this.removeListenerProxy(this.getListenerMap(), oFilter, member);
        Map mapFilterId = this.getFilterIdMap();
        if (mapFilterId != null && (mapMemberFilterId = (Map)mapFilterId.get(member)) != null && (setFilterId = (Set)mapMemberFilterId.get(filter)) != null) {
            setFilterId.remove(lFilterId);
            if (setFilterId.isEmpty()) {
                mapMemberFilterId.remove(filter);
                if (mapMemberFilterId.isEmpty()) {
                    mapFilterId.remove(member);
                }
            }
        }
    }

    protected void removeListenerProxy(Map map, Object anyKey, Member member) {
        Map mapMembers;
        if (map != null && (mapMembers = (Map)map.get(anyKey)) != null) {
            mapMembers.remove(member);
            if (mapMembers.isEmpty()) {
                map.remove(anyKey);
            }
        }
    }

    protected Binary removePrimaryResource(Binary binKey, boolean fBlind, boolean fSynthetic) {
        Binary binValReturn = null;
        ObservableMap map = this.getBackingMapInternal();
        if (fSynthetic) {
            ConfigurableCacheMap mapCCM = this.getBackingConfigurableCache();
            if (mapCCM != null) {
                if (!fBlind) {
                    binValReturn = (Binary)mapCCM.get(binKey);
                }
                mapCCM.evict(binKey);
                ConfigurableCacheMap.Entry entry = mapCCM.getCacheEntry(binKey);
                if (entry != null) {
                    entry.setExpiryMillis(Base.getSafeTimeMillis());
                }
                return binValReturn;
            }
            map = this.getBackingInternalCache();
        }
        if (fBlind) {
            map.keySet().remove(binKey);
        } else {
            binValReturn = (Binary)map.remove(binKey);
        }
        return binValReturn;
    }

    protected Binary removeSafe(Binary binKey) {
        try {
            return (Binary)this.getBackingMapInternal().remove(binKey);
        }
        catch (Throwable e) {
            Storage._trace("Failed remove during transfer: key=" + String.valueOf(binKey) + " " + String.valueOf(e), 1);
            return null;
        }
    }

    public void removeTrigger(PartitionSet partsMask, MapTrigger trigger) {
        Set setTriggers = this.getTriggerSet();
        if (setTriggers != null) {
            setTriggers.remove(trigger);
            if (setTriggers.isEmpty()) {
                this.setTriggerSet(null);
            }
        }
    }

    public String reportIndexes() {
        Map mapIndex = this.getIndexMap();
        return mapIndex.isEmpty() ? "No indexes" : Base.toDelimitedString(mapIndex.values().iterator(), "\n");
    }

    public String reportKeys(Set setKeys) {
        Converter conv = this.getService().getBackingMapContext().getKeyFromInternalConverter();
        return String.valueOf(ConverterCollections.getSet(setKeys, conv, NullImplementation.getConverter()));
    }

    protected void reportTransferFailure(RuntimeException e, String sTransferType) {
        if (e instanceof UnsupportedOperationException) {
            if (sTransferType.equals("primary") && !this.isMisconfigLoggedPrimary()) {
                Storage._trace("Unable to complete primary transfer into cache: " + this.getCacheName() + " due to misconfigured cache", 1);
                this.setMisconfigLoggedPrimary(true);
            }
            if (sTransferType.equals("backup") && !this.isMisconfigLoggedBackup()) {
                Storage._trace("Unable to complete backup transfer into cache: " + this.getCacheName() + " due to misconfigured cache", 1);
                this.setMisconfigLoggedBackup(true);
            }
        } else {
            Storage._trace("Unable to complete " + sTransferType + " transfer into cache: " + this.getCacheName() + " due to " + String.valueOf(e) + "\n" + Storage.get_StackTrace(), 1);
        }
    }

    public void resetStats() {
        this.setStatsEventsDispatched(0L);
        this.getStatsListenerRegistrations().set(0L);
        this.setStatsMaxQueryDescription("");
        this.setStatsMaxQueryDurationMillis(0L);
        this.getStatsNonOptimizedQueryCount().set(0L);
        this.getStatsNonOptimizedQueryTotalMillis().set(0L);
        this.getStatsOptimizedQueryTotalMillis().set(0L);
        this.getStatsOptimizedQueryCount().set(0L);
        this.getStatsQueryContentionCount().set(0L);
        this.getStatsClears().set(0L);
        this.getStatsIndexingTotalMillis().set(0L);
        StorageDispatcher dispatcher = this.getEventDispatcher();
        if (dispatcher != null) {
            dispatcher.getStats().reset();
        }
    }

    protected static void rethrow(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw (RuntimeException)e;
    }

    public synchronized void scheduleEviction(long cExpiryMillis) {
        DaemonPool pool = this.getService().getDaemonPool();
        if (!pool.isStarted()) {
            return;
        }
        EvictionTask task = this.getEvictionTask();
        if (task == null) {
            task = (EvictionTask)this._newChild("EvictionTask");
            task.setEvictionTime(0L);
            this.setEvictionTask(task);
        }
        long ldtOldNext = task.getEvictionTime();
        long ldtNewNext = Base.getSafeTimeMillis() + cExpiryMillis;
        task.setPrune(cExpiryMillis == 0L);
        if (ldtOldNext > 0L) {
            if (cExpiryMillis == 0L || ldtNewNext + 250L < ldtOldNext) {
                task.cancel();
                task = (EvictionTask)this._newChild("EvictionTask");
                this.setEvictionTask(task);
                task.setPrune(cExpiryMillis == 0L);
            } else {
                return;
            }
        }
        task.setEvictionTime(ldtNewNext);
        pool.schedule(task, cExpiryMillis);
    }

    protected void setAccessAuthorizer(StorageAccessAuthorizer authorizer) {
        if (this.getAccessAuthorizer() != null) {
            throw new IllegalStateException("Authorizer is not resettable");
        }
        this.__m_AccessAuthorizer = authorizer;
    }

    public void setAdjustPartitionSize(boolean fSkip) {
        this.__m_AdjustPartitionSize = fSkip;
    }

    protected void setBackingConfigurableCache(ConfigurableCacheMap mapCCM) {
        this.__m_BackingConfigurableCache = mapCCM;
    }

    protected void setBackingInternalCache(ObservableMap mapCache) {
        this.__m_BackingInternalCache = mapCache;
    }

    protected void setBackingMapAction(PrivilegedAction action) {
        this.__m_BackingMapAction = action;
    }

    protected void setBackingMapExpiryDelay(int cMillis) {
        this.__m_BackingMapExpiryDelay = cMillis;
    }

    protected void setBackingMapInternal(ObservableMap map) {
        this.__m_BackingMapInternal = map;
    }

    protected void setBackupKeyListenerMap(Map map) {
        this.__m_BackupKeyListenerMap = map;
    }

    protected void setBackupLeaseMap(Map map) {
        this.__m_BackupLeaseMap = map;
    }

    protected void setBackupMap(Map map) {
        this.__m_BackupMap = map;
    }

    public void setCacheId(long lCacheId) {
        this.__m_CacheId = lCacheId;
    }

    public void setCacheName(String sName) {
        this.__m_CacheName = sName;
    }

    protected void setConfiguredBackupListeners(Map map) {
        this.__m_ConfiguredBackupListeners = map;
    }

    protected void setConverterKeyDown(Converter converter) {
        this.__m_ConverterKeyDown = converter;
    }

    protected void setConverterUp(Converter converter) {
        this.__m_ConverterUp = converter;
    }

    protected void setConverterValueDown(Converter converter) {
        this.__m_ConverterValueDown = converter;
    }

    public void setEntryStatusMap(ConcurrentMap pEntryStatusMap) {
        this.__m_EntryStatusMap = pEntryStatusMap;
    }

    protected void setEntryToBinaryEntryConverter(EntryToBinaryEntryConverter converter) {
        this.__m_EntryToBinaryEntryConverter = converter;
    }

    public void setEventDispatcher(StorageDispatcher dispatcher) {
        this.__m_EventDispatcher = dispatcher;
    }

    protected void setEventDispatcherInterceptor(DispatcherInterceptor listener) {
        this.__m_EventDispatcherInterceptor = listener;
    }

    public void setEvictionTask(EvictionTask taskEviction) {
        this.__m_EvictionTask = taskEviction;
    }

    public void setExpirySliding(boolean fSliding) {
        this.__m_ExpirySliding = fSliding;
    }

    protected void setFilterIdMap(Map map) {
        this.__m_FilterIdMap = map;
    }

    protected void setIndexExtractorMap(Map map) {
        this.__m_IndexExtractorMap = map;
    }

    protected void setInternBackupKeys(boolean fIntern) {
        this.__m_InternBackupKeys = fIntern;
    }

    protected void setInternPrimaryKeys(boolean fIntern) {
        this.__m_InternPrimaryKeys = fIntern;
    }

    protected void setKeyListenerMap(Map map) {
        this.__m_KeyListenerMap = map;
    }

    public void setKeyToBinaryEntryConverter(KeyToBinaryEntryConverter converter) {
        this.__m_KeyToBinaryEntryConverter = converter;
    }

    protected void setLeaseMap(Map map) {
        this.__m_LeaseMap = map;
    }

    protected void setListenerMap(Map map) {
        this.__m_ListenerMap = map;
    }

    protected void setMisconfigLoggedBackup(boolean fLogged) {
        this.__m_MisconfigLoggedBackup = fLogged;
    }

    protected void setMisconfigLoggedPrimary(boolean fLogged) {
        this.__m_MisconfigLoggedPrimary = fLogged;
    }

    protected void setOldValueRequired(boolean fRequired) {
        this.__m_OldValueRequired = fRequired;
    }

    protected void setPartitionAwareBackingMap(PartitionAwareBackingMap mapPrime) {
        this.__m_PartitionAwareBackingMap = mapPrime;
    }

    protected void setPartitionAwareBackupMap(PartitionAwareBackingMap mapBackup) {
        this.__m_PartitionAwareBackupMap = mapBackup;
    }

    protected void setPartitionedIndexMap(Map pIndexMap) {
        this.__m_PartitionedIndexMap = pIndexMap;
    }

    protected void setPartitionedKeyIndex(PartitionAwareBackingMap map) {
        this.__m_PartitionedKeyIndex = map;
    }

    protected void setPendingLockRequest(List list) {
        this.__m_PendingLockRequest = list;
    }

    protected void setPersistent(boolean fPersistent) {
        this.__m_Persistent = fPersistent;
    }

    private void setPotentiallyEvicting(boolean fPotentiallyEvicting) {
        this.__m_PotentiallyEvicting = fPotentiallyEvicting;
    }

    protected void setPreferPutAllBackup(boolean fPrefer) {
        this.__m_PreferPutAllBackup = fPrefer;
    }

    protected void setPreferPutAllPrimary(boolean fPrefer) {
        this.__m_PreferPutAllPrimary = fPrefer;
    }

    protected void setPrimaryListener(MapListener listener) {
        this.__m_PrimaryListener = listener;
    }

    public void setQueryRetries(int nRetries) {
        this.__m_QueryRetries = nRetries;
    }

    protected void setQuerySizeCache(Map map) {
        this.__m_QuerySizeCache = map;
    }

    public void setResourceControlMap(com.tangosol.util.ConcurrentMap mapResourceControl) {
        this.__m_ResourceControlMap = mapResourceControl;
    }

    protected void setStatsEventsDispatched(long cEvents) {
        this.__m_StatsEventsDispatched = cEvents;
    }

    protected void setStatsEvictions(AtomicLong counter) {
        this.__m_StatsEvictions = counter;
    }

    public void setStatsIndexingTotalMillis(AtomicLong atomicMillis) {
        this.__m_StatsIndexingTotalMillis = atomicMillis;
    }

    protected void setStatsInserts(AtomicLong counter) {
        this.__m_StatsInserts = counter;
    }

    protected void setStatsListenerRegistrations(AtomicLong cRequests) {
        this.__m_StatsListenerRegistrations = cRequests;
    }

    public void setStatsMaxQueryDescription(String sQueryDescription) {
        this.__m_StatsMaxQueryDescription = sQueryDescription;
    }

    public void setStatsMaxQueryDurationMillis(long cMillis) {
        this.__m_StatsMaxQueryDurationMillis = cMillis;
    }

    public void setStatsMaxQueryThresholdMillis(long cMillis) {
        this.__m_StatsMaxQueryThresholdMillis = cMillis;
    }

    public void setStatsNonOptimizedQueryCount(AtomicLong atomicLong) {
        this.__m_StatsNonOptimizedQueryCount = atomicLong;
    }

    public void setStatsNonOptimizedQueryTotalMillis(AtomicLong atomicLong) {
        this.__m_StatsNonOptimizedQueryTotalMillis = atomicLong;
    }

    public void setStatsOptimizedQueryCount(AtomicLong atmomicLong) {
        this.__m_StatsOptimizedQueryCount = atmomicLong;
    }

    public void setStatsOptimizedQueryTotalMillis(AtomicLong atomicLong) {
        this.__m_StatsOptimizedQueryTotalMillis = atomicLong;
    }

    public void setStatsQueryContentionCount(AtomicLong atomicLong) {
        this.__m_StatsQueryContentionCount = atomicLong;
    }

    protected void setStatsRemoves(AtomicLong counter) {
        this.__m_StatsRemoves = counter;
    }

    protected void setStatsClears(AtomicLong counter) {
        this.__m_StatsClears = counter;
    }

    protected void setTempBinaryEntry(BinaryEntry binEntry) {
        this.__m_TempBinaryEntry = binEntry;
    }

    protected void setTriggerSet(Set set) {
        this.__m_TriggerSet = set;
    }

    protected void setValid(boolean fValid) {
        this.__m_Valid = fValid;
    }

    protected void setVersion(StorageVersion version) {
        this.__m_Version = version;
    }

    public int size() {
        return this.getBackingMapInternal().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snapshotPartition(int iPartition, PersistentStore store, Object oToken) {
        PartitionAwareBackingMap pabmPrime;
        long lCacheId = this.getCacheId();
        PartitionedCache service = this.getService();
        ServiceMemberSet setMembers = service.getServiceMemberSet();
        Map mapLeases = this.getLeaseMap();
        for (Lease lease : mapLeases.values()) {
            Binary binKey = (Binary)lease.getResourceKey();
            if (service.getKeyPartition(binKey) != iPartition) continue;
            long ldtJoined = setMembers.getServiceJoinTime(lease.getHolderId());
            CachePersistenceHelper.registerLock(store, lCacheId, binKey, ldtJoined, lease.getHolderThreadId(), oToken);
        }
        Map mapListeners = this.getKeyListenerMap();
        if (mapListeners != null && !mapListeners.isEmpty()) {
            for (Map.Entry entry : mapListeners.entrySet()) {
                Binary binKey = (Binary)entry.getKey();
                if (service.getKeyPartition(binKey) != iPartition) continue;
                Map mapMembers = (Map)entry.getValue();
                for (Map.Entry entryMember : mapMembers.entrySet()) {
                    com.tangosol.net.Member member = (com.tangosol.net.Member)entryMember.getKey();
                    long ldtJoined = setMembers.getServiceJoinTime(member.getId());
                    boolean fLite = (Boolean)entryMember.getValue();
                    CachePersistenceHelper.registerListener(store, lCacheId, binKey, ldtJoined, fLite, oToken);
                }
            }
        }
        Map mapPart = (pabmPrime = this.getPartitionAwareBackingMap()) == null ? null : pabmPrime.getPartitionMap(iPartition);
        ConfigurableCacheMap mapCCM = mapPart != null && mapPart instanceof ConfigurableCacheMap ? (ConfigurableCacheMap)mapPart : this.getBackingConfigurableCache();
        ConfigurableCacheMap.EvictionApprover approver = null;
        try {
            if (mapCCM != null) {
                approver = mapCCM.getEvictionApprover();
                mapCCM.setEvictionApprover(ConfigurableCacheMap.EvictionApprover.DISAPPROVER);
            }
            if (mapPart != null) {
                for (Map.Entry entry : mapPart.entrySet()) {
                    Binary binKey = (Binary)entry.getKey();
                    Binary binValue = (Binary)entry.getValue();
                    store.store(lCacheId, binKey, binValue, oToken);
                }
            } else {
                ObservableMap mapResource = this.getBackingMapInternal();
                for (Binary binKey : this.getPartitionKeys(iPartition)) {
                    Binary binValue = (Binary)mapResource.get(binKey);
                    store.store(lCacheId, binKey, binValue, oToken);
                }
            }
        }
        finally {
            if (mapCCM != null) {
                mapCCM.setEvictionApprover(approver);
            }
        }
        this.persistGlobalMetadata(iPartition, store, oToken);
    }

    protected static long[] toLongArray(Set setLong) {
        int c = setLong.size();
        if (c == 0) {
            return null;
        }
        long[] al = new long[c];
        Iterator iter = setLong.iterator();
        int i = 0;
        while (iter.hasNext()) {
            al[i] = (Long)iter.next();
            ++i;
        }
        return al;
    }

    @Override
    public String toString() {
        return this.get_Name() + " (CacheName=" + this.getCacheName() + ", CacheId=" + this.getCacheId() + ")";
    }

    public QueryRecord.PartialResult trace(Filter filter, PartitionSet partMask) {
        QueryRecord.PartialResult.TraceStep step;
        QueryRecorderFilter filterRecorder;
        SimpleQueryContext ctx = new SimpleQueryContext(this);
        SimpleQueryRecord.PartialResult result = new SimpleQueryRecord.PartialResult(ctx, partMask);
        SubSet setKeys = new SubSet(this.collectKeySet(partMask, true));
        if (!setKeys.isEmpty() && (filter = (filterRecorder = filter instanceof QueryRecorderFilter ? (QueryRecorderFilter)filter : new WrapperQueryRecorderFilter(filter)).trace((QueryContext)ctx, step = result.instantiateTraceStep(filter), setKeys)) != null) {
            ObservableMap mapPrime = this.getBackingMapInternal();
            step = result.instantiateTraceStep(filter);
            filterRecorder = filter instanceof QueryRecorderFilter ? (QueryRecorderFilter)filter : new WrapperQueryRecorderFilter(filter);
            BinaryEntry entryTemp = this.instantiateBinaryEntry(null, null, true);
            for (Binary binKey : setKeys) {
                Binary binValue = (Binary)mapPrime.get(binKey);
                if (binValue == null) continue;
                entryTemp.reset(binKey, binValue);
                filterRecorder.trace((QueryContext)ctx, step, entryTemp);
            }
        }
        return result;
    }

    public Storage truncate() {
        Map mapListener;
        Map mapFilter;
        Map mapExtractor = this.getIndexExtractorMap();
        String sCacheName = this.getCacheName();
        PartitionedCache service = this.getService();
        Storage storageNew = (Storage)service._newChild("Storage");
        storageNew.setCacheId(this.getCacheId());
        storageNew.setIndexExtractorMap(mapExtractor);
        Set setTrigger = this.getTriggerSet();
        if (setTrigger != null) {
            storageNew.setTriggerSet(setTrigger);
        }
        if ((mapFilter = this.getFilterIdMap()) != null) {
            storageNew.setFilterIdMap(mapFilter);
        }
        if ((mapListener = this.getListenerMap()) != null) {
            storageNew.setListenerMap(mapListener);
        }
        service.truncatePersistentExtent(this);
        this.invalidate();
        storageNew.ensureInitialized(sCacheName);
        for (Map.Entry entry : mapExtractor.entrySet()) {
            ValueExtractor extractor = (ValueExtractor)entry.getKey();
            Comparator comparator = (Comparator)entry.getValue();
            for (Integer nPart : this.getPartitionedIndexMap().keySet()) {
                storageNew.createMapIndex(storageNew.getPartitionIndexMap(nPart), extractor, comparator);
            }
        }
        return storageNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock(Lease lease) {
        List listPending;
        Map mapLease = this.getLeaseMap();
        Binary binKey = (Binary)lease.getResourceKey();
        Lease leaseCurrent = (Lease)mapLease.get(binKey);
        int nHolderId = lease.getHolderId();
        long lHolderThreadId = lease.getHolderThreadId();
        if (leaseCurrent == null || leaseCurrent.getHolderId() == nHolderId && leaseCurrent.getHolderThreadId() == lHolderThreadId) {
            mapLease.remove(binKey);
            if (this.isPersistent()) {
                PartitionedCache service = this.getService();
                int nPartition = service.getKeyPartition(binKey);
                PartitionedCache.PartitionControl ctrlPartition = (PartitionedCache.PartitionControl)service.getPartitionControl(nPartition);
                PersistentStore store = ctrlPartition.getPersistentStore();
                long ldtJoined = service.getServiceMemberSet().getServiceJoinTime(nHolderId);
                CachePersistenceHelper.unregisterLock(store, this.getCacheId(), binKey, ldtJoined, lHolderThreadId, null);
            }
            return true;
        }
        List list = listPending = this.getPendingLockRequest();
        synchronized (list) {
            PartitionedCache service = this.getService();
            Iterator iter = listPending.iterator();
            while (iter.hasNext()) {
                PartitionedCache.LockRequest msgRequest = (PartitionedCache.LockRequest)iter.next();
                if (!msgRequest.getKey().equals(binKey) || msgRequest.getLeaseHolderId() != lease.getHolderId() || msgRequest.getLeaseThreadId() != lease.getHolderThreadId()) continue;
                iter.remove();
                Grid.Response msgResponse = (Grid.Response)service.instantiateMessage("Response");
                msgResponse.respondTo(msgRequest);
                msgResponse.setResult(1);
                service.post(msgResponse);
            }
        }
        return false;
    }

    public void updateConverters() {
        PartitionedCache.BackingMapContext ctx = this.getService().getBackingMapContext();
        this.setConverterUp(ctx.getValueFromInternalConverter());
        this.setConverterKeyDown(ctx.getKeyToInternalConverter());
        this.setConverterValueDown(ctx.getValueToInternalConverter());
    }

    public List updateIndex(int nEventId, int nPartition, Map mapIndex) {
        ObservableMap map = this.getBackingMapInternal();
        BinaryEntry entryTemp = this.instantiateBinaryEntry(null, null, true);
        Set setKeys = this.getKeySet(nPartition);
        if (setKeys == null) {
            setKeys = this.collectKeySet(nPartition);
        }
        int cEntries = 0;
        Iterator iter = setKeys.iterator();
        while (iter.hasNext()) {
            List listFailed;
            entryTemp.reset((Binary)iter.next());
            if (entryTemp.isPresent() && (listFailed = this.updateIndex(nEventId, entryTemp, mapIndex)) != null) {
                return listFailed;
            }
            if ((++cEntries & 0x3FF) != 1023) continue;
            GuardSupport.heartbeat();
        }
        return null;
    }

    public List updateIndex(int nEventId, BinaryEntry binEntry, Map mapIndex) {
        int nPart = this.getService().getKeyPartition(binEntry.getBinaryKey());
        if (mapIndex == null) {
            mapIndex = this.getPartitionIndexMap(nPart);
        }
        List listFailed = null;
        if (!mapIndex.isEmpty()) {
            for (ValueExtractor extractor : Base.randomize(mapIndex.keySet())) {
                MapIndex index = (MapIndex)this.getPartitionIndexMap(nPart).get(extractor);
                binEntry.setForceExtract(true);
                try {
                    if (index != null) {
                        switch (nEventId) {
                            case 1: {
                                index.insert(binEntry);
                                break;
                            }
                            case 2: {
                                index.update(binEntry);
                                break;
                            }
                            case 3: {
                                index.delete(binEntry);
                            }
                        }
                    }
                }
                catch (RuntimeException e) {
                    listFailed = this.processIndexFailure(e, extractor, binEntry, listFailed);
                }
                binEntry.setForceExtract(false);
            }
        }
        return listFailed;
    }

    public void updateIndexStatistics(long ldtStart) {
        this.getStatsIndexingTotalMillis().getAndAdd(Base.getSafeTimeMillis() - ldtStart);
    }

    public void updateKeyIndex(MapEvent event) {
        PartitionAwareBackingMap mapKeyIndex = this.getPartitionedKeyIndex();
        if (mapKeyIndex != null) {
            Binary binKey = (Binary)event.getKey();
            switch (event.getId()) {
                case 1: {
                    mapKeyIndex.put(binKey, binKey);
                    break;
                }
                case 3: {
                    mapKeyIndex.remove(binKey);
                }
            }
        }
    }

    protected void updateQueryStatistics(Filter filterOrig, boolean fOptimized, long ldtStart, int cTotal, int cScanned, int cResults, int nQueryType, PartitionSet partMask) {
        boolean fPartial;
        long cMillis = Base.getSafeTimeMillis() - ldtStart;
        boolean bl = fPartial = cTotal > cScanned;
        if (fOptimized) {
            this.getStatsOptimizedQueryCount().incrementAndGet();
            this.getStatsOptimizedQueryTotalMillis().getAndAdd(cMillis);
        } else {
            this.getStatsNonOptimizedQueryCount().incrementAndGet();
            this.getStatsNonOptimizedQueryTotalMillis().getAndAdd(cMillis);
        }
        if (cMillis >= this.getStatsMaxQueryDurationMillis() && cMillis >= this.getStatsMaxQueryThresholdMillis()) {
            String sFilterDesc;
            String sItem = nQueryType == 1 ? " keys" : " entries";
            String string = sFilterDesc = filterOrig == null ? "" : Base.truncateString(filterOrig.toString(), 1024);
            if (filterOrig == null) {
                this.setStatsMaxQueryDescription("Full key set retrieval for " + partMask.cardinality() + " partitions (" + cTotal + " " + sItem + ") - duration " + cMillis + "ms.");
            } else if (fOptimized) {
                this.setStatsMaxQueryDescription("Optimized query (" + cTotal + " " + sItem + ", " + cResults + " matches for " + sFilterDesc + ") - duration " + cMillis + "ms.");
            } else if (fPartial) {
                this.setStatsMaxQueryDescription("Partially optimized query (" + cTotal + " " + sItem + ", scan of " + cScanned + ", " + cResults + " matches for " + sFilterDesc + ") - duration " + cMillis + "ms.");
            } else {
                this.setStatsMaxQueryDescription("Non optimized query (" + cTotal + " " + sItem + ", full scan, " + cResults + " matches for " + sFilterDesc + ") - duration " + cMillis + "ms.");
            }
            this.setStatsMaxQueryDurationMillis(cMillis);
        }
    }

    public void validateListeners() {
        PartitionedCache service = this.getService();
        ServiceMemberSet setMembers = service.getServiceMemberSet();
        block2: for (Map map : new Map[]{this.getListenerMap(), this.getKeyListenerMap(), this.getBackupKeyListenerMap()}) {
            while (map != null) {
                try {
                    Iterator iter = map.values().iterator();
                    while (iter.hasNext()) {
                        Map mapMembers = (Map)iter.next();
                        mapMembers.keySet().retainAll(setMembers);
                        if (!mapMembers.isEmpty()) continue;
                        iter.remove();
                    }
                    continue block2;
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                }
            }
        }
        Map mapFilterId = this.getFilterIdMap();
        if (mapFilterId != null) {
            mapFilterId.keySet().retainAll(setMembers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateLocks() {
        Object lease;
        Iterator<Object> iter;
        PartitionedCache service = this.getService();
        ServiceMemberSet setMembers = service.getServiceMemberSet();
        LiteSet<Object> setKeys = new LiteSet<Object>();
        while (true) {
            try {
                Map mapLease;
                Map map = mapLease = this.getLeaseMap();
                synchronized (map) {
                    iter = this.getLeaseMap().values().iterator();
                    while (iter.hasNext()) {
                        Lease lease2 = (Lease)iter.next();
                        if (setMembers.contains(lease2.getHolderId())) continue;
                        setKeys.add(lease2.getResourceKey());
                        iter.remove();
                    }
                }
            }
            catch (ConcurrentModificationException mapLease) {
                continue;
            }
            break;
        }
        while (service.getBackupCount() > 0) {
            try {
                Iterator iter2 = this.getBackupLeaseMap().values().iterator();
                while (iter2.hasNext()) {
                    lease = (Lease)iter2.next();
                    if (setMembers.contains(((Lease)lease).getHolderId())) continue;
                    iter2.remove();
                }
                break;
            }
            catch (ConcurrentModificationException iter2) {
            }
        }
        List listPending = this.getPendingLockRequest();
        lease = listPending;
        synchronized (lease) {
            if (!listPending.isEmpty()) {
                iter = listPending.iterator();
                while (iter.hasNext()) {
                    PartitionedCache.LockRequest msgLock = (PartitionedCache.LockRequest)iter.next();
                    if (setMembers.contains(msgLock.getFromMember())) continue;
                    iter.remove();
                }
            }
        }
        Iterator iter3 = setKeys.iterator();
        while (iter3.hasNext()) {
            this.firePendingLocks((Binary)iter3.next());
        }
    }

    public PartitionSet validatePartitionedContent(boolean fPrimary, boolean fFix) {
        int iPartition;
        PartitionedCache service = this.getService();
        Map map = fPrimary ? this.getBackingMapInternal() : this.getBackupMap();
        PartitionSet partsInvalid = service.collectOwnedPartitions(fPrimary);
        partsInvalid.invert();
        if (map instanceof PartitionAwareBackingMap) {
            PartitionAwareBackingMap mapPartitioned = (PartitionAwareBackingMap)map;
            iPartition = partsInvalid.next(0);
            while (iPartition >= 0) {
                if (mapPartitioned.getPartitionMap(iPartition) == null) {
                    partsInvalid.remove(iPartition);
                    if (fFix) {
                        mapPartitioned.destroyPartition(iPartition);
                    }
                }
                iPartition = partsInvalid.next(iPartition + 1);
            }
        } else {
            PartitionSet partsTemp = new PartitionSet(partsInvalid.getPartitionCount());
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                Binary binKey = (Binary)iter.next();
                int iPartition2 = service.getKeyPartition(binKey);
                if (!partsInvalid.contains(iPartition2)) continue;
                partsTemp.add(iPartition2);
                if (!fFix) continue;
                iter.remove();
            }
            partsInvalid = partsTemp;
        }
        if (!partsInvalid.isEmpty()) {
            PartitionAwareBackingMap mapKeyIndex = this.getPartitionedKeyIndex();
            if (fFix && mapKeyIndex != null) {
                iPartition = partsInvalid.next(0);
                while (iPartition >= 0) {
                    if (mapKeyIndex.getPartitionMap(iPartition) != null) {
                        mapKeyIndex.destroyPartition(iPartition);
                    }
                    iPartition = partsInvalid.next(iPartition + 1);
                }
            }
            Storage._trace("Discovered non-owned " + (fPrimary ? "primary" : "backup") + " " + String.valueOf(partsInvalid), 1);
            return partsInvalid;
        }
        return null;
    }

    static {
        EMPTY_OBJECT_ARRAY = new Object[0];
        Storage.__initStatic();
    }

    public static class Advancer
    extends AdvancingIterator
    implements Streamer {
        private boolean __m_CheckVersion;
        private int __m_Count;
        private Map __m_DeferredEntries;
        private PartitionSet __m_DeferredPartitions;
        private BinaryEntry __m_EntryTemp;
        private Filter __m_Filter;
        private Filter __m_FilterOriginal;
        private Iterator __m_Iterator;
        private boolean __m_PresentOnly;
        private boolean __m_ReuseAllowed;
        private int __m_Size;
        private long __m_Version;

        public Advancer() {
            this(null, null, true);
        }

        public Advancer(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Advancer();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/Storage$Advancer".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent().get_Parent();
        }

        @Override
        protected Object advance() {
            Iterator iterator = this.getIterator();
            Filter filter = this.getFilter();
            long lVersion = this.getVersion();
            Storage storage = this.getStorage();
            StorageVersion version = storage.getVersion();
            BinaryEntry entry = this.getEntryTemp();
            boolean fInit = storage.isPotentiallyEvicting() || this.isPresentOnly() || filter != null;
            ObservableMap mapPrime = storage.getBackingInternalCache();
            while (iterator.hasNext()) {
                Object oNext = iterator.next();
                int c = this.getCount();
                this.setCount(c + 1);
                if ((c & 0x3FF) == 1023) {
                    storage.getService().checkInterrupt();
                }
                if (oNext instanceof Binary) {
                    Binary binKey = (Binary)oNext;
                    Binary binValue = null;
                    if (fInit && (binValue = (Binary)mapPrime.get(binKey)) == null && this.isPresentOnly()) continue;
                    if (entry == null) {
                        entry = storage.instantiateBinaryEntry(binKey, binValue, true);
                        if (this.isReuseAllowed()) {
                            this.setEntryTemp(entry);
                        }
                    } else {
                        entry.reset(binKey, binValue);
                    }
                    int nPart = entry.getKeyPartition();
                    if (!this.isCheckVersion() || version.getCommittedVersion() <= lVersion || !version.isPartitionModified(lVersion, nPart)) {
                        entry.setVersionTrint(Trint.makeTrint14(lVersion));
                        if (filter != null && !InvocableMapHelper.evaluateEntry(filter, entry)) continue;
                        return entry;
                    }
                    if (storage.getDeserializationAccelerator(nPart) != null) {
                        entry.setForceExtract(true);
                        if (!InvocableMapHelper.evaluateEntry(this.getFilterOriginal(), entry)) continue;
                        return entry;
                    }
                    HashMap<Binary, BinaryEntry> mapDefer = this.getDeferredEntries();
                    if (mapDefer == null) {
                        mapDefer = new HashMap<Binary, BinaryEntry>();
                        this.setDeferredEntries(mapDefer);
                    }
                    mapDefer.put(binKey, entry);
                    PartitionSet partsDefer = this.getDeferredPartitions();
                    if (partsDefer == null) {
                        partsDefer = new PartitionSet(storage.getService().getPartitionCount());
                        this.setDeferredPartitions(partsDefer);
                    }
                    partsDefer.add(nPart);
                    entry = null;
                    continue;
                }
                if (oNext == null) continue;
                return (BinaryEntry)oNext;
            }
            Map mapDeferred = this.getDeferredEntries();
            if (mapDeferred != null) {
                storage.reevaluateQueryResults(this.getFilterOriginal(), mapDeferred, 1, this.getDeferredPartitions());
                this.setIterator(mapDeferred.values().iterator());
                this.setDeferredEntries(null);
                this.setDeferredPartitions(null);
                this.setCheckVersion(false);
                return this.advance();
            }
            this.setEntryTemp(null);
            return null;
        }

        @Override
        public int characteristics() {
            return this.getFilter() == null && this.getSize() >= 0 ? 1 : 0;
        }

        private int getCount() {
            return this.__m_Count;
        }

        private Map getDeferredEntries() {
            return this.__m_DeferredEntries;
        }

        private PartitionSet getDeferredPartitions() {
            return this.__m_DeferredPartitions;
        }

        private BinaryEntry getEntryTemp() {
            return this.__m_EntryTemp;
        }

        protected Filter getFilter() {
            return this.__m_Filter;
        }

        protected Filter getFilterOriginal() {
            return this.__m_FilterOriginal;
        }

        protected Iterator getIterator() {
            return this.__m_Iterator;
        }

        protected int getSize() {
            return this.__m_Size;
        }

        protected Storage getStorage() {
            return (Storage)this.get_Parent();
        }

        protected long getVersion() {
            return this.__m_Version;
        }

        public boolean isCheckVersion() {
            return this.__m_CheckVersion;
        }

        protected boolean isPresentOnly() {
            return this.__m_PresentOnly;
        }

        protected boolean isReuseAllowed() {
            return this.__m_ReuseAllowed;
        }

        public void setCheckVersion(boolean fVersion) {
            this.__m_CheckVersion = fVersion;
        }

        private void setCount(int c) {
            this.__m_Count = c;
        }

        private void setDeferredEntries(Map map) {
            this.__m_DeferredEntries = map;
        }

        private void setDeferredPartitions(PartitionSet parts) {
            this.__m_DeferredPartitions = parts;
        }

        private void setEntryTemp(BinaryEntry entry) {
            this.__m_EntryTemp = entry;
        }

        public void setFilter(Filter filter) {
            this.__m_Filter = filter;
        }

        public void setFilterOriginal(Filter filter) {
            this.__m_FilterOriginal = filter;
        }

        public void setIterator(Iterator iter) {
            this.__m_Iterator = iter;
        }

        public void setPresentOnly(boolean fOnly) {
            this.__m_PresentOnly = fOnly;
        }

        public void setReuseAllowed(boolean fReuse) {
            this.__m_ReuseAllowed = fReuse;
        }

        public void setSize(int c) {
            this.__m_Size = c;
        }

        public void setVersion(long lVersion) {
            this.__m_Version = lVersion;
        }

        @Override
        public long size() {
            return Math.abs(this.getSize());
        }
    }

    public static class BackingManager
    extends Util
    implements BackingMapManager {
        public static final int BACKUP_CUSTOM = 3;
        public static final int BACKUP_FILE = 2;
        public static final int BACKUP_FLASHJOURNAL = 7;
        public static final int BACKUP_OFFHEAP = 1;
        public static final int BACKUP_ONHEAP = 0;
        public static final int BACKUP_RAMJOURNAL = 8;
        public static final int BACKUP_SCHEME = 4;
        private Class __m_BackupClass;
        private File __m_BackupDir;
        private int __m_BackupInitSize;
        private int __m_BackupMaxSize;
        private String __m_BackupScheme;
        private String __m_CacheName;
        private boolean __m_Partitioned;
        private int __m_Type;

        public BackingManager() {
            this(null, null, true);
        }

        public BackingManager(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setBackupInitSize(0x100000);
                this.setBackupMaxSize(0x40000000);
                this.setPartitioned(true);
                this.setType(-1);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new BackingManager();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/Storage$BackingManager".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent().get_Parent();
        }

        protected Class getBackupClass() {
            return this.__m_BackupClass;
        }

        protected File getBackupDir() {
            return this.__m_BackupDir;
        }

        protected int getBackupInitSize() {
            return this.__m_BackupInitSize;
        }

        protected int getBackupMaxSize() {
            return this.__m_BackupMaxSize;
        }

        protected String getBackupScheme() {
            return this.__m_BackupScheme;
        }

        @Override
        public ConfigurableCacheFactory getCacheFactory() {
            return null;
        }

        public String getCacheName() {
            return this.__m_CacheName;
        }

        @Override
        public BackingMapManagerContext getContext() {
            return this.getService().getBackingMapContext();
        }

        public DefaultConfigurableCacheFactory getDefaultFactory() {
            DefaultConfigurableCacheFactory.Manager mgr = (DefaultConfigurableCacheFactory.Manager)this.getService().getBackingMapManager();
            return mgr.getCacheFactory();
        }

        public PartitionedCache getService() {
            return (PartitionedCache)this.get_Module();
        }

        public Storage getStorage() {
            return (Storage)this.get_Parent();
        }

        @Override
        public StorageAccessAuthorizer getStorageAccessAuthorizer(String sName) {
            return null;
        }

        public int getType() {
            return this.__m_Type;
        }

        @Override
        public void init(BackingMapManagerContext context) {
        }

        @Override
        public Map instantiateBackingMap(String sName) {
            PartitionedCache service = this.getService();
            BackingMapManager mgr = service.getBackingMapManager();
            if (mgr instanceof ExtensibleConfigurableCacheFactory.Manager) {
                return ((ExtensibleConfigurableCacheFactory.Manager)mgr).instantiateBackupMap(this.getCacheName());
            }
            Map map = null;
            switch (this.getType()) {
                case 3: {
                    try {
                        map = (Map)this.getBackupClass().newInstance();
                    }
                    catch (Exception e) {
                        BackingManager._trace("Failed to create a 'custom' backup map: " + String.valueOf(e) + "\nusing the 'on-heap' type instead", 1);
                    }
                    break;
                }
                case 2: {
                    map = new BinaryMap(new MappedBufferManager(this.getBackupInitSize(), this.getBackupMaxSize(), this.getBackupDir()));
                    break;
                }
                case 4: {
                    try {
                        DefaultConfigurableCacheFactory factory = this.getDefaultFactory();
                        DefaultConfigurableCacheFactory.CacheInfo info = factory.findSchemeMapping(this.getCacheName());
                        XmlElement xmlScheme = factory.resolveScheme(new DefaultConfigurableCacheFactory.CacheInfo(sName, this.getBackupScheme(), info.getAttributes()));
                        xmlScheme.addAttribute("target").setString("backup");
                        xmlScheme.addAttribute("partitioned").setString("false");
                        map = factory.configureBackingMap(info, xmlScheme, service.getBackingMapContext(), null, this.getStorage().getConfiguredBackupListeners());
                    }
                    catch (ClassCastException e) {
                        BackingManager._trace("\"Scheme\" backup is only supported by the com.tangosol.net.DefaultConfigurableCacheFactory\nusing the 'on-heap' type instead", 1);
                    }
                    break;
                }
                case 7: 
                case 8: {
                    String sScheme = this.getType() == 7 ? "flashjournal-scheme" : "ramjournal-scheme";
                    try {
                        DefaultConfigurableCacheFactory factory = this.getDefaultFactory();
                        SimpleElement xmlScheme = new SimpleElement(sScheme);
                        DefaultConfigurableCacheFactory.CacheInfo info = new DefaultConfigurableCacheFactory.CacheInfo(sName, sScheme, null);
                        xmlScheme.addAttribute("target").setString("backup");
                        xmlScheme.addAttribute("partitioned").setString("false");
                        map = factory.configureBackingMap(info, xmlScheme, service.getBackingMapContext(), null, this.getStorage().getConfiguredBackupListeners());
                    }
                    catch (Exception e) {
                        BackingManager._trace("Failed to create backup map of type " + sScheme + " due to exception " + String.valueOf(e), 1);
                    }
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown type: " + this.getType());
                }
            }
            return map == null ? new SafeHashMap() : map;
        }

        @Override
        public boolean isBackingMapPersistent(String sName) {
            return false;
        }

        @Override
        public boolean isBackingMapSlidingExpiry(String sName) {
            return false;
        }

        public boolean isPartitioned() {
            return this.__m_Partitioned;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void parseConfiguration() {
            String sCacheName = this.getCacheName();
            BackingMapManager mgr = this.getService().getBackingMapManager();
            if (mgr instanceof ExtensibleConfigurableCacheFactory.Manager) {
                this.setPartitioned(((ExtensibleConfigurableCacheFactory.Manager)mgr).isBackupPartitioned(sCacheName));
                return;
            }
            DefaultConfigurableCacheFactory factory = this.getDefaultFactory();
            DefaultConfigurableCacheFactory.CacheInfo info = factory.findSchemeMapping(sCacheName);
            XmlElement xmlCache = factory.resolveScheme(info);
            XmlElement xmlBackingMap = factory.resolveBackingMapScheme(info, xmlCache);
            XmlElement xmlBackup = xmlCache.getElement("backup-storage");
            if (xmlBackup != null) {
                String sType = xmlBackup.getSafeElement("type").getString("on-heap");
                if (sType.equals("on-heap")) {
                    this.setType(0);
                    return;
                }
                if (sType.equals("file-mapped")) {
                    File dir;
                    long cbInit = Base.parseMemorySize(xmlBackup.getSafeElement("initial-size").getString("1"), 20);
                    long cbMax = Base.parseMemorySize(xmlBackup.getSafeElement("maximum-size").getString("1024"), 20);
                    int cbMaxSize = (int)Math.min(Math.max(cbMax, 1L), 2147482624L);
                    int cbInitSize = (int)Math.min(Math.max(cbInit, 1L), (long)cbMaxSize);
                    this.setBackupInitSize(cbInitSize);
                    this.setBackupMaxSize(cbMaxSize);
                    this.setPartitioned(false);
                    String sPath = xmlBackup.getSafeElement("directory").getString();
                    if (sPath.length() > 0 && (dir = new File(sPath)).isDirectory()) {
                        this.setBackupDir(dir);
                    }
                    this.setType(2);
                    return;
                }
                if (sType.equals("custom")) {
                    String sBackupClass = xmlBackup.getSafeElement("class-name").getString();
                    try {
                        Class<?> clzBackup = this.getService().getContextClassLoader().loadClass(sBackupClass);
                        BackingManager._assert(Map.class.isAssignableFrom(clzBackup));
                        this.setBackupClass(clzBackup);
                    }
                    catch (Exception e) {
                        throw Base.ensureRuntimeException(e, "Invalid backup class: " + sBackupClass);
                    }
                    this.setType(3);
                    return;
                }
                if (!sType.equals("scheme")) throw new IllegalArgumentException("Unknown backup type: " + sType);
                String sSchemeName = xmlBackup.getSafeElement("scheme-name").getString();
                this.setBackupScheme(sSchemeName);
                this.setType(4);
                return;
            }
            this.setType(0);
            if (xmlBackingMap == null) return;
            String sName = xmlBackingMap.getName();
            if (sName.equals("ramjournal-scheme")) {
                this.setType(Boolean.parseBoolean(Config.getProperty("coherence.journal.backuptoflash", "true")) ? 7 : 8);
                return;
            } else {
                if (!sName.equals("flashjournal-scheme")) return;
                this.setType(7);
            }
        }

        @Override
        public void releaseBackingMap(String sName, Map map) {
            BackingMapManager mgr = this.getService().getBackingMapManager();
            if (mgr instanceof ExtensibleConfigurableCacheFactory.Manager) {
                ((ExtensibleConfigurableCacheFactory.Manager)mgr).releaseBackupMap(sName, map, this.getStorage().getConfiguredBackupListeners());
                return;
            }
            if (!(map instanceof SafeHashMap)) {
                try {
                    switch (this.getType()) {
                        case 3: {
                            break;
                        }
                        case 2: {
                            map.clear();
                            try {
                                ByteBufferManager bufferMgr = ((BinaryMap)map).getBufferManager();
                                ((MappedBufferManager)bufferMgr).close();
                            }
                            catch (ClassCastException bufferMgr) {}
                            break;
                        }
                        case 1: {
                            map.clear();
                            break;
                        }
                        case 4: 
                        case 7: 
                        case 8: {
                            try {
                                this.getDefaultFactory().release(map, this.getStorage().getConfiguredBackupListeners());
                            }
                            catch (ClassCastException bufferMgr) {}
                            break;
                        }
                        case 0: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown type: " + this.getType());
                        }
                    }
                }
                catch (Exception e) {
                    BackingManager._trace("Failed to invalidate backing map: " + String.valueOf(e), 2);
                }
            }
        }

        protected void setBackupClass(Class clzBackupClass) {
            this.__m_BackupClass = clzBackupClass;
        }

        protected void setBackupDir(File dir) {
            this.__m_BackupDir = dir;
        }

        protected void setBackupInitSize(int cInitSize) {
            this.__m_BackupInitSize = cInitSize;
        }

        protected void setBackupMaxSize(int cMaxSize) {
            this.__m_BackupMaxSize = cMaxSize;
        }

        protected void setBackupScheme(String sBackupScheme) {
            this.__m_BackupScheme = sBackupScheme;
        }

        public void setCacheName(String sCacheName) {
            this.__m_CacheName = sCacheName;
        }

        public void setPartitioned(boolean fPartitioned) {
            this.__m_Partitioned = fPartitioned;
        }

        public void setType(int iType) {
            this.__m_Type = iType;
        }

        @Override
        public String toString() {
            Class<?> clz = BackingManager.get_CLASS();
            BackingMapManager mgr = this.getService().getBackingMapManager();
            if (mgr instanceof ExtensibleConfigurableCacheFactory.Manager) {
                clz = mgr.getClass();
                return clz.getName();
            }
            return ClassHelper.getSimpleName(clz);
        }
    }

    public static class BackingMapAction
    extends Util
    implements PrivilegedAction {
        public BackingMapAction() {
            this(null, null, true);
        }

        public BackingMapAction(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new BackingMapAction();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/Storage$BackingMapAction".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent().get_Parent();
        }

        public Object run() {
            return ((Storage)this.get_Parent()).getBackingMap();
        }
    }

    public static class BinaryEntry
    extends Util
    implements SerializationSupport,
    com.tangosol.util.BinaryEntry,
    MapTrigger.Entry {
        public static final int ACCESS_MASK = 57344;
        public static final int ACCESS_READ = 8192;
        public static final int ACCESS_READ_ANY = 40960;
        public static final int ACCESS_WRITE = 16384;
        public static final int ACCESS_WRITE_ANY = 49152;
        private Binary __m_BinaryKey;
        private Binary __m_BinaryValue;
        private transient Object __m_ConvertedKey;
        private transient Object __m_ConvertedValue;
        protected static final int EXPIRE_UPDATED = 4;
        private long __m_ExpiryValue;
        protected static final int KEY_CONVERTED = 2;
        protected static final int ORIG_MASK = 6144;
        protected static final int ORIG_NONE = 2048;
        protected static final int ORIG_PRESENT = 4096;
        public static final int STATE_MASK = 65535;
        protected static final int VALUE_CONVERTED = 8;
        protected static final int VALUE_FORCE_EXTRACT = 1024;
        protected static final int VALUE_LOADED = 16;
        protected static final int VALUE_NONE = 32;
        protected static final int VALUE_READONLY = 64;
        protected static final int VALUE_REMOVED = 128;
        protected static final int VALUE_STALE = 1;
        protected static final int VALUE_SYNTHETIC = 256;
        protected static final int VALUE_UPDATED = 512;
        public static final int VERSION_MASK = 0x3FFF0000;
        public static final int VERSION_OFFSET = 16;

        public BinaryEntry() {
            this(null, null, true);
        }

        public BinaryEntry(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.set_Order(-2.0f);
                this.setExpiryValue(-2L);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new BinaryEntry();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/Storage$BinaryEntry".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent().get_Parent();
        }

        protected void checkAccess(int nAccess) {
            Storage storage = this.getStorage();
            if (storage == null) {
                return;
            }
            StorageAccessAuthorizer authorizer = storage.getAccessAuthorizer();
            if (authorizer != null) {
                int nState = this.getState();
                if ((nState & nAccess) == nAccess) {
                    return;
                }
                PartitionedCache.InvocationContext ctxInvoke = this.getService().getInvocationContext();
                if (ctxInvoke == null || ctxInvoke.getAccessReason() == 0) {
                    return;
                }
                if ((ctxInvoke.getAccessGranted() & nAccess) == nAccess && ctxInvoke.getAccessStorage() == storage) {
                    return;
                }
                this.setState(nState | nAccess);
                switch (nAccess) {
                    case 8192: {
                        authorizer.checkRead(this, ctxInvoke.getAccessSubject(), ctxInvoke.getAccessReason());
                        break;
                    }
                    case 16384: {
                        authorizer.checkWrite(this, ctxInvoke.getAccessSubject(), ctxInvoke.getAccessReason());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid entry access: " + nAccess);
                    }
                }
            }
        }

        protected void checkMutable() {
            if (this.isReadOnly()) {
                throw new UnsupportedOperationException("Read-only entry does not allow Map modifications");
            }
        }

        protected boolean checkVersion() {
            int nTrint = this.getVersionTrint();
            if (nTrint == 0) {
                return true;
            }
            Storage storage = this.getStorage();
            StorageVersion version = storage.getVersion();
            long lCurrent = version.getSubmittedVersion();
            long lVersion = Trint.translateTrint14(nTrint, lCurrent);
            return lVersion == lCurrent || !version.isPartitionModified(lVersion, storage.getService().getKeyPartition(this.getBinaryKey()));
        }

        @Override
        public int compareTo(Object o) {
            return SafeComparator.compareSafe(null, this.getBinaryKey(), ((BinaryEntry)o).getBinaryKey());
        }

        public void disableConversion() {
        }

        public void ensureReadOnly() {
            this.setState(this.getState() | 0x40);
        }

        public void ensureWriteable() {
            this.setState(this.getState() & 0xFFFFFFBF);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof BinaryEntry && Base.equals(this.getBinaryKey(), ((BinaryEntry)obj).getBinaryKey()) && Base.equals(this.getStorage(), ((BinaryEntry)obj).getStorage());
        }

        @Override
        public void expire(long cMillis) {
            this.checkMutable();
            this.setExpiryValue(cMillis >= 0L ? cMillis : -1L);
            this.setState(this.getState() | 4);
        }

        @Override
        public Object extract(ValueExtractor extractor) {
            Object oValue;
            MapIndex index;
            int nState = this.getState();
            if ((nState & 0x690) == 0 && (index = (MapIndex)this.getStorage().getPartitionIndexMap(this.getStorage().getManagerContext().getKeyPartition(this.getBinaryKey())).get(extractor)) != null && (oValue = index.get(this.getBinaryKey())) != MapIndex.NO_VALUE) {
                if (this.checkVersion()) {
                    this.checkAccess(8192);
                    return oValue;
                }
                this.setForceExtract(true);
            }
            return InvocableMapHelper.extractFromEntry(extractor, this);
        }

        public static String formatState(int nState) {
            StringBuilder sb = new StringBuilder();
            if ((nState & 2) != 0) {
                sb.append(" | KEY_CONVERTED");
            }
            if ((nState & 8) != 0) {
                sb.append(" | VALUE_CONVERTED");
            }
            if ((nState & 0x400) != 0) {
                sb.append(" | VALUE_FORCE_EXTRACT");
            }
            if ((nState & 0x20) != 0) {
                sb.append(" | VALUE_NONE");
            }
            if ((nState & 0x40) != 0) {
                sb.append(" | VALUE_READONLY");
            }
            if ((nState & 0x80) != 0) {
                sb.append(" | VALUE_REMOVED");
            }
            if ((nState & 0x100) != 0) {
                sb.append(" | VALUE_SYNTHETIC");
            }
            if ((nState & 4) != 0) {
                sb.append(" | EXPIRE_UPDATED");
            }
            if ((nState & 0x200) != 0) {
                sb.append(" | VALUE_UPDATED");
            }
            if ((nState & 0x10) != 0) {
                sb.append(" | VALUE_LOADED");
            }
            if ((nState & 0x1000) != 0) {
                sb.append(" | ORIG_PRESENT");
            }
            if ((nState & 0x800) != 0) {
                sb.append(" | ORIG_NONE");
            }
            return sb.length() > 0 ? sb.substring(3) : "";
        }

        public ObservableMap getBackingMap() {
            return this.getStorage().getBackingMap();
        }

        @Override
        public BackingMapContext getBackingMapContext() {
            PartitionedCache.InvocationContext ctx = this.getInvocationContext();
            Storage storage = this.getStorage();
            return ctx == null ? storage : ctx.ensureBackingMapContext(storage);
        }

        protected ObservableMap getBackingMapInternal() {
            if (System.getSecurityManager() == null) {
                return this.getStorage().getBackingMap();
            }
            return (ObservableMap)AccessController.doPrivileged(this.getStorage().getBackingMapAction());
        }

        @Override
        public Binary getBinaryKey() {
            return this.__m_BinaryKey;
        }

        @Override
        public Binary getBinaryValue() {
            int nState;
            Binary binValue = this.__m_BinaryValue;
            if (binValue == null && ((nState = this.getState()) & 0x20) == 0) {
                if ((nState & 8) != 0) {
                    binValue = (Binary)this.getStorage().getConverterValueDown().convert(this.getConvertedValue());
                } else if (this.isOriginalPresent()) {
                    binValue = this.getOriginalBinaryValue();
                } else {
                    binValue = (Binary)this.getBackingMapInternal().get(this.getBinaryKey());
                    if (binValue != null) {
                        this.setState(this.getState() | 0x10);
                    }
                }
                if (binValue == null) {
                    this.setState(this.getState() | 0x20);
                } else {
                    this.setBinaryValue(binValue);
                }
            }
            this.checkAccess(8192);
            return binValue;
        }

        @Override
        public BackingMapManagerContext getContext() {
            PartitionedCache.InvocationContext ctx = this.getInvocationContext();
            if (ctx == null) {
                return this.getService().getBackingMapContext();
            }
            ctx.ensureBackingMapContext(this.getStorage());
            return ctx;
        }

        protected Object getConvertedKey() {
            return this.__m_ConvertedKey;
        }

        protected Object getConvertedValue() {
            return this.__m_ConvertedValue;
        }

        @Override
        public long getExpiry() {
            long cExpiry;
            if (this.isExpiryInitialized()) {
                cExpiry = this.getExpiryValue();
            } else if (this.isValueChanged() || this.isValueRemoved() || !this.isOriginalPresent()) {
                cExpiry = 0L;
                this.setExpiryValue(0L);
            } else {
                this.getOriginalBinaryValue();
                cExpiry = this.getExpiryValue();
            }
            if (cExpiry == 0L) {
                ConfigurableCacheMap mapCCM = this.getStorage().getBackingConfigurableCache();
                if (mapCCM != null) {
                    cExpiry = mapCCM.getExpiryDelay();
                }
            } else if (cExpiry != -1L && !this.isExpireChanged()) {
                long ldtNow = this.getService().getClusterTime();
                cExpiry = Math.max(1L, cExpiry - ldtNow);
            }
            return cExpiry;
        }

        private long getExpiryValue() {
            return this.__m_ExpiryValue;
        }

        protected PartitionedCache.InvocationContext getInvocationContext() {
            PartitionedCache.InvocationContext ctx = this.getService().getInvocationContext();
            return ctx != null && (ctx.isReadOnly() || !this.isReadOnly() || this.isValueLoaded()) ? ctx : null;
        }

        @Override
        public Object getKey() {
            int nState = this.getState();
            if ((nState & 2) != 0) {
                return this.getConvertedKey();
            }
            Object oKey = this.getStorage().getConverterUp().convert(this.getBinaryKey());
            this.setConvertedKey(oKey);
            this.setState(nState | 2);
            return oKey;
        }

        @Override
        public Binary getOriginalBinaryValue() {
            long ldtExpiry;
            Object binValue = this.get_Sink();
            boolean fExpirySet = this.isExpiryInitialized();
            long l = ldtExpiry = fExpirySet ? this.getExpiryValue() : 0L;
            if (binValue != null && fExpirySet) {
                return (Binary)binValue;
            }
            if (this.isOriginalPresent()) {
                Binary binKey = this.getBinaryKey();
                Storage storage = this.getStorage();
                ConfigurableCacheMap ccm = storage.getBackingConfigurableCache();
                if (ccm == null) {
                    if (binValue == null) {
                        binValue = this.getBackingMapInternal().get(binKey);
                    }
                    if (binValue != null && !fExpirySet) {
                        ldtExpiry = ExternalizableHelper.decodeExpiry((Binary)binValue);
                    }
                } else {
                    ConfigurableCacheMap.Entry entry = ccm.getCacheEntry(binKey);
                    if (entry != null) {
                        if (binValue == null) {
                            Object oValue = entry.getValue();
                            Object object = binValue = oValue instanceof ReadBuffer ? oValue : ccm.get(binKey);
                        }
                        if (!fExpirySet) {
                            ldtExpiry = entry.getExpiryMillis();
                            ldtExpiry = ldtExpiry == 0L ? -1L : this.getService().getClusterService().calcTimestamp(ldtExpiry);
                        }
                    }
                }
                this.set_Sink(binValue);
                this.setExpiryValue(ldtExpiry);
            }
            return (Binary)binValue;
        }

        public Object getOriginalValue() {
            Object oValue = this.get_Feed();
            if (oValue == null) {
                oValue = this.getStorage().getConverterUp().convert(this.getOriginalBinaryValue());
                this.set_Feed(oValue);
            }
            return oValue;
        }

        @Override
        public Serializer getSerializer() {
            return this.getService().getSerializer();
        }

        public PartitionedCache getService() {
            return (PartitionedCache)this.get_Module();
        }

        protected int getState() {
            return this.get_StateAux() & 0xFFFF;
        }

        public Storage getStorage() {
            return (Storage)this.get_Parent();
        }

        @Override
        public Object getValue() {
            Object oValue;
            int nState = this.getState();
            if ((nState & 8) != 0) {
                return this.getConvertedValue();
            }
            Storage storage = this.getStorage();
            MapIndex indexFwd = storage.getDeserializationAccelerator(this.getKeyPartition());
            Object object = oValue = indexFwd == null || (nState & 0x680) != 0 ? MapIndex.NO_VALUE : indexFwd.get(this.getBinaryKey());
            if (oValue == MapIndex.NO_VALUE) {
                oValue = storage.getConverterUp().convert(this.getBinaryValue());
            } else {
                this.checkAccess(8192);
            }
            this.setConvertedValue(oValue);
            this.setState(this.getState() | 8);
            return oValue;
        }

        public int getVersionTrint() {
            return (this.get_StateAux() & 0x3FFF0000) >>> 16;
        }

        @Override
        public int hashCode() {
            Binary binKey = this.getBinaryKey();
            return binKey == null ? 0 : binKey.hashCode();
        }

        public boolean isExpireChanged() {
            return (this.getState() & 4) != 0;
        }

        public boolean isExpiryInitialized() {
            return this.getExpiryValue() != -2L;
        }

        public boolean isKeyConverted() {
            return (this.getState() & 2) != 0;
        }

        @Override
        public boolean isOriginalPresent() {
            int nState = this.getState();
            if ((nState & 0x1800) != 0) {
                return (nState & 0x1000) != 0;
            }
            if (this.getBackingMapInternal().containsKey(this.getBinaryKey())) {
                this.setState(nState | 0x1000);
                return true;
            }
            this.setState(nState | 0x800);
            return false;
        }

        @Override
        public boolean isPresent() {
            int nState = this.getState();
            if ((nState & 0xA0) != 0) {
                return false;
            }
            return (nState & 0x210) != 0 || this.isOriginalPresent();
        }

        @Override
        public boolean isReadOnly() {
            return (this.getState() & 0x40) != 0;
        }

        @Override
        public boolean isSynthetic() {
            return (this.getState() & 0x100) != 0;
        }

        @Override
        public boolean isValueChanged() {
            return (this.getState() & 0x284) != 0;
        }

        public boolean isValueConverted() {
            return (this.getState() & 8) != 0;
        }

        @Override
        public boolean isValueLoaded() {
            return (this.getState() & 0x10) != 0;
        }

        @Override
        public boolean isValueRemoved() {
            return (this.getState() & 0x80) != 0;
        }

        public boolean isValueStale() {
            return (this.getState() & 1) != 0;
        }

        @Override
        public boolean isValueUpdated() {
            return (this.getState() & 0x200) != 0;
        }

        public BinaryEntry markStale() {
            return this.setState(this.getState() | 1);
        }

        @Override
        public void remove(boolean fSynthetic) {
            this.checkMutable();
            this.setConvertedValue(null);
            this.setBinaryValue(null);
            int nState = this.getState() & 0xFFFFFCFF;
            this.setState(nState | 8 | 0x80 | 0x20 | (fSynthetic ? 256 : 0));
        }

        public BinaryEntry reset(Binary binKey) {
            return this.reset(binKey, null);
        }

        public BinaryEntry reset(Binary binKey, Binary binValue) {
            BinaryEntry._assert(binKey != null);
            this.setState(this.getState() & 0x40);
            this.setBinaryKey(binKey);
            this.setBinaryValue(binValue);
            this.set_Feed(null);
            this.set_Sink(null);
            this.setExpiryValue(-2L);
            return this;
        }

        public BinaryEntry setBinaryKey(Binary binKey) {
            this.__m_BinaryKey = binKey;
            return this;
        }

        public BinaryEntry setBinaryValue(Binary binValue) {
            this.__m_BinaryValue = binValue;
            this.checkAccess(16384);
            return this;
        }

        protected BinaryEntry setConvertedKey(Object oKey) {
            this.__m_ConvertedKey = oKey;
            return this;
        }

        protected BinaryEntry setConvertedValue(Object oValue) {
            this.__m_ConvertedValue = oValue;
            return this;
        }

        public BinaryEntry setExpiryValue(long lValue) {
            this.__m_ExpiryValue = lValue;
            return this;
        }

        public BinaryEntry setForceExtract(boolean fForce) {
            return fForce ? this.setState(this.getState() | 0x400) : this.setState(this.getState() & 0xFFFFFBFF);
        }

        protected BinaryEntry setState(int nState) {
            this.set_StateAux(this.get_StateAux() & 0xFFFF0000 | nState & 0xFFFF);
            return this;
        }

        public BinaryEntry setSynthetic(boolean fSynthetic) {
            return fSynthetic ? this.setState(this.getState() | 0x100) : this.setState(this.getState() & 0xFFFFFEFF);
        }

        @Override
        public Object setValue(Object oValue) {
            this.checkMutable();
            Object oValueOld = this.getValue();
            this.setValue(oValue, false);
            return oValueOld;
        }

        @Override
        public void setValue(Object oValue, boolean fSynthetic) {
            this.checkMutable();
            this.setConvertedValue(oValue);
            this.setBinaryValue(null);
            if (!this.isExpireChanged()) {
                this.setExpiryValue(0L);
            }
            int nState = (this.getState() | 8 | 0x200) & 0xFFFFFF5F;
            nState = fSynthetic ? (nState |= 0x100) : (nState &= 0xFFFFFEFF);
            this.setState(nState);
        }

        public void setVersionTrint(int nTrint) {
            this.set_StateAux(this.get_StateAux() & 0xC000FFFF | nTrint << 16);
        }

        @Override
        public String toString() {
            int nState = this.getState();
            return this.get_Name() + "{Key=" + ((nState & 2) != 0 ? String.valueOf(this.getKey()) : this.toString(this.getBinaryKey())) + ", Value=" + ((nState & 8) != 0 ? String.valueOf(this.getValue()) : this.toString(this.getBinaryValue())) + ", State=" + BinaryEntry.formatState(nState) + "}";
        }

        protected String toString(Binary binValue) {
            int MAX_BYTES = 512;
            int cb = binValue == null ? 0 : binValue.length();
            return cb <= 512 ? String.valueOf(binValue) : "Binary(length=" + binValue.length() + ", value=" + Base.toHexEscape(binValue.toByteArray(0, 512)) + "...)";
        }

        @Override
        public void update(ValueUpdater updater, Object oValue) {
            InvocableMapHelper.updateEntry(updater, this, oValue);
        }

        @Override
        public void updateBinaryValue(Binary binValue) {
            this.updateBinaryValue(binValue, false);
        }

        @Override
        public void updateBinaryValue(Binary binValue, boolean fSynthetic) {
            this.checkMutable();
            if (binValue == null) {
                this.remove(fSynthetic);
            } else {
                int nState = this.getState() & 0xFFFFFE57;
                this.setState(nState | 0x200 | (fSynthetic ? 256 : 0));
                this.setBinaryValue(binValue);
                this.setConvertedValue(null);
                if (!this.isExpireChanged()) {
                    this.setExpiryValue(0L);
                }
            }
        }

        public void updateLoadedValue(Binary binValue) {
            this.checkMutable();
            if (binValue == null) {
                throw new IllegalArgumentException();
            }
            this.setState(this.getState() | 0x1110);
            this.setBinaryValue(binValue);
        }

        public void updateOriginalBinaryValue(Binary binValue) {
            this.set_Sink(binValue);
            if (binValue == null) {
                this.setState(this.getState() & 0xFFFFE7FF | 0x800);
            } else {
                this.setState(this.getState() & 0xFFFFE7FF | 0x1000);
            }
        }

        @Override
        public Object writeReplace() throws ObjectStreamException {
            return new SimpleBinaryEntry(this.getBinaryKey(), this.getBinaryValue());
        }
    }

    public static class DeferredEvent
    extends Util
    implements Continuation {
        private MapEvent __m_Event;
        private boolean __m_Reapply;

        public DeferredEvent() {
            this(null, null, true);
        }

        public DeferredEvent(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new DeferredEvent();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/Storage$DeferredEvent".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent().get_Parent();
        }

        public long getCacheId() {
            return this.getStorage().getCacheId();
        }

        public MapEvent getEvent() {
            return this.__m_Event;
        }

        public Storage getStorage() {
            return (Storage)this.get_Parent();
        }

        public boolean isReapply() {
            return this.__m_Reapply;
        }

        public void proceed(Object oResult) {
            MapEvent evt = this.getEvent();
            Storage storage = this.getStorage();
            if (evt == null) {
                return;
            }
            if (this.isReapply()) {
                ObservableMap map = storage.getBackingMap();
                Binary binKey = (Binary)evt.getKey();
                switch (evt.getId()) {
                    case 3: {
                        map.remove(binKey);
                        break;
                    }
                    case 1: 
                    case 2: {
                        map.put(binKey, evt.getNewValue());
                        break;
                    }
                    default: {
                        DeferredEvent._assert(false);
                    }
                }
            }
            storage.doBackingMapEvent(evt);
        }

        public void read(DataInput stream) throws IOException {
            this.setReapply(stream.readBoolean());
            int nEvtId = ExternalizableHelper.readInt(stream);
            Binary binKey = (Binary)ExternalizableHelper.readObject(stream);
            Binary binValueOld = (Binary)ExternalizableHelper.readObject(stream);
            Binary binValueNew = (Binary)ExternalizableHelper.readObject(stream);
            ObservableMap mapResource = this.getStorage().getBackingMap();
            if (mapResource instanceof ObservableMap) {
                this.setEvent(new MapEvent<Binary, Binary>(mapResource, nEvtId, binKey, binValueOld, binValueNew));
            } else {
                DeferredEvent._trace("Deferred \"" + MapEvent.getDescription(nEvtId) + "\" event cannot be applied for " + String.valueOf(binKey), 2);
            }
        }

        public void setEvent(MapEvent pEvent) {
            this.__m_Event = pEvent;
        }

        public void setReapply(boolean pReapply) {
            this.__m_Reapply = pReapply;
        }

        @Override
        public String toString() {
            return "DeferredEvent{CacheId=" + this.getCacheId() + " Event=" + String.valueOf(this.getEvent()) + "}";
        }

        public void write(DataOutput stream) throws IOException {
            stream.writeBoolean(this.isReapply());
            MapEvent event = this.getEvent();
            ExternalizableHelper.writeInt(stream, event.getId());
            ExternalizableHelper.writeObject(stream, event.getKey());
            ExternalizableHelper.writeObject(stream, event.getOldValue());
            ExternalizableHelper.writeObject(stream, event.getNewValue());
        }
    }

    public static class EnlistingConverter
    extends Util
    implements Converter {
        private PartitionedCache.InvocationContext __m_InvocationContext;
        private MapTrigger __m_Trigger;

        public EnlistingConverter() {
            this(null, null, true);
        }

        public EnlistingConverter(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new EnlistingConverter();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/Storage$EnlistingConverter".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent().get_Parent();
        }

        @Override
        public Object convert(Object oKey) {
            Binary binKey = (Binary)oKey;
            PartitionedCache.InvocationContext ctxInvoke = this.getInvocationContext();
            EnlistingConverter._assert(ctxInvoke != null && binKey != null);
            EntryStatus status = ctxInvoke.enlistSynthetic(this.getStorage(), binKey);
            BinaryEntry binEntry = status.getBinaryEntry();
            MapTrigger trigger = this.getTrigger();
            if (trigger != null) {
                trigger.process(binEntry);
            }
            return binEntry;
        }

        public PartitionedCache.InvocationContext getInvocationContext() {
            return this.__m_InvocationContext;
        }

        protected Storage getStorage() {
            return (Storage)this.get_Parent();
        }

        public MapTrigger getTrigger() {
            return this.__m_Trigger;
        }

        public void setInvocationContext(PartitionedCache.InvocationContext ctxInvoke) {
            this.__m_InvocationContext = ctxInvoke;
        }

        public void setTrigger(MapTrigger trigger) {
            this.__m_Trigger = trigger;
        }
    }

    public static class EntryStatus
    extends Util {
        private boolean __m_Active;
        private volatile boolean __m_AnyAction;
        private BinaryEntry __m_BinaryEntry;
        private boolean __m_ExpiryOnly;
        private volatile boolean __m_Managed;
        private Object __m_MapEventHolder;
        private volatile Object __m_MapEventsRaw;
        private volatile ReadBuffer __m_MergedNewValue;
        private Binary __m_OldValue;
        private transient boolean __m_Pending;
        private Binary __m_Result;
        private boolean __m_SuppressEvents;
        private transient int __m_WaitingThreadCount;

        public EntryStatus() {
            this(null, null, true);
        }

        public EntryStatus(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setActive(true);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new EntryStatus();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/Storage$EntryStatus".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent().get_Parent();
        }

        public void addEventMessages(Object oEvtHolder) {
            this.setMapEventHolder(Storage.accumulateMapEvents(this.getMapEventHolder(), oEvtHolder));
        }

        public void addRawMapEvent(MapEvent event) {
            Object oEvent = this.getMapEventsRaw();
            CopyOnWriteLongArray<MapEvent> laEvents = null;
            if (oEvent == null) {
                this.setMapEventsRaw(event);
            } else if (oEvent instanceof MapEvent) {
                laEvents = new CopyOnWriteLongArray<MapEvent>();
                this.setMapEventsRaw(laEvents);
                laEvents.set(((MapEvent)oEvent).getVersion(), (MapEvent)oEvent);
            } else {
                laEvents = (CopyOnWriteLongArray<MapEvent>)oEvent;
            }
            if (laEvents != null) {
                laEvents.set(event.getVersion(), event);
            }
        }

        public BinaryEntry getBinaryEntry() {
            return this.__m_BinaryEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BMEventFabric.EventQueue getEventQueue() {
            BMEventFabric.EventQueue queue = (BMEventFabric.EventQueue)this.get_Feed();
            if (queue == null) {
                EntryStatus entryStatus = this;
                synchronized (entryStatus) {
                    queue = (BMEventFabric.EventQueue)this.get_Feed();
                    if (queue == null) {
                        queue = this.getStorage().getResourceCoordinator().instantiateEventQueue(false);
                        this.set_Feed(queue);
                    }
                }
            }
            return queue;
        }

        public EntryEvent.Type getEventType() {
            return this.isValueRemoved() ? EntryEvent.Type.REMOVED : (this.isValueUpdated() ? (this.getOldValue() == null ? EntryEvent.Type.INSERTED : EntryEvent.Type.UPDATED) : null);
        }

        public Binary getKey() {
            return (Binary)this.get_Sink();
        }

        public Object getMapEventHolder() {
            return this.__m_MapEventHolder;
        }

        public Object getMapEventsRaw() {
            return this.__m_MapEventsRaw;
        }

        public long getMaxMapEventVersion() {
            Object oEvent = this.getMapEventsRaw();
            return oEvent instanceof LongArray ? ((LongArray)oEvent).floorIndex(Long.MAX_VALUE) : (oEvent == null ? -1L : ((MapEvent)oEvent).getVersion());
        }

        public ReadBuffer getMergedNewValue() {
            return this.__m_MergedNewValue;
        }

        public Binary getOldValue() {
            return this.__m_OldValue;
        }

        public int getPartition() {
            return Float.floatToRawIntBits(this.get_Order());
        }

        public synchronized BinaryEntry getReadOnlyEntry() {
            Storage storage = this.getStorage();
            Binary binKey = this.getKey();
            boolean fConc = storage.getService().isConcurrent();
            com.tangosol.util.ConcurrentMap mapCtrl = storage.getResourceControlMap();
            if (this.isManaged() && (!fConc || mapCtrl.lock(binKey, 0L))) {
                BinaryEntry entry = this.getBinaryEntry();
                if (entry == null) {
                    entry = storage.instantiateBinaryEntry(binKey, ExternalizableHelper.asBinary(this.getMergedNewValue()), true);
                    this.setBinaryEntry(entry);
                } else {
                    entry.ensureReadOnly();
                }
                if (fConc) {
                    mapCtrl.unlock(binKey);
                }
                return entry;
            }
            return storage.instantiateBinaryEntry(binKey, ExternalizableHelper.asBinary(this.getMergedNewValue()), true);
        }

        public Binary getResult() {
            return this.__m_Result;
        }

        public Storage getStorage() {
            return (Storage)this.get_Parent();
        }

        private int getWaitingThreadCount() {
            return this.__m_WaitingThreadCount;
        }

        public synchronized boolean hasEvent(MapEvent event) {
            Object oEvent = this.getMapEventsRaw();
            return oEvent != null && (oEvent instanceof MapEvent ? (MapEvent)oEvent == event : ((LongArray)oEvent).contains(event));
        }

        public EntryInfo instantiateEntryInfo() {
            return new EntryInfo(this.getEventType(), this.getReadOnlyEntry());
        }

        public static EntryStatus instantiateStatus(Binary binKey) {
            EntryStatus status = new EntryStatus();
            status.set_Sink(binKey);
            return status;
        }

        public boolean isActive() {
            return this.__m_Active;
        }

        public boolean isAnyAction() {
            return this.__m_AnyAction;
        }

        public boolean isAnyEvent() {
            return this.getMapEventHolder() != null;
        }

        public boolean isExpiryOnly() {
            return this.__m_ExpiryOnly;
        }

        public boolean isManaged() {
            return this.__m_Managed;
        }

        private boolean isPending() {
            return this.__m_Pending;
        }

        public boolean isSuppressEvents() {
            return this.__m_SuppressEvents;
        }

        public boolean isValueRemoved() {
            return this.isAnyAction() && this.getMergedNewValue() == null;
        }

        public boolean isValueUpdated() {
            return this.isAnyAction() && this.getMergedNewValue() != null;
        }

        public void preparePublish() {
            ReadBuffer bufValueNew = this.getMergedNewValue();
            Binary binValueOld = this.getOldValue();
            this.setMapEventHolder(PartitionedCache.MapEvent.compressEventHolder(this.getMapEventHolder(), binValueOld, ExternalizableHelper.asBinary(bufValueNew)));
            if (bufValueNew != null) {
                BinaryEntry binEntry = this.getBinaryEntry();
                Storage storage = this.getStorage();
                long cEntryExpiry = 0L;
                if (binEntry != null) {
                    binEntry.updateOriginalBinaryValue(binValueOld);
                    binEntry.setBinaryValue(ExternalizableHelper.asBinary(bufValueNew));
                    cEntryExpiry = binEntry.getExpiry();
                }
                if (storage.getBackingConfigurableCache() != null) {
                    long cBMExpiry = storage.getBackingMapExpiryDelay();
                    if (cEntryExpiry != -1L && cEntryExpiry != 0L || cBMExpiry != -1L) {
                        long cExpiry = cEntryExpiry == 0L ? cBMExpiry : cEntryExpiry;
                        bufValueNew = ExternalizableHelper.encodeExpiry(bufValueNew, cExpiry == -1L ? cExpiry : storage.getService().getClusterTime() + cExpiry);
                        this.setMergedNewValue(bufValueNew);
                    }
                }
            }
        }

        public void reset() {
            this.setManaged(false);
            this.setBinaryEntry(null);
            this.setMapEventHolder(null);
            this.setOldValue(null);
            this.setMergedNewValue(null);
            this.setResult(null);
            this.setAnyAction(false);
            this.setExpiryOnly(false);
        }

        public void setActive(boolean fActive) {
            if (fActive && this.is_Constructed()) {
                EntryStatus._assert(this.isActive());
            }
            this.__m_Active = fActive;
        }

        public void setAnyAction(boolean fAnyAction) {
            this.__m_AnyAction = fAnyAction;
        }

        public void setBinaryEntry(BinaryEntry binEntry) {
            this.__m_BinaryEntry = binEntry;
        }

        public void setExpiryOnly(boolean fOnly) {
            this.__m_ExpiryOnly = fOnly;
        }

        public synchronized void setManaged(boolean fManaged) {
            this.__m_Managed = fManaged;
        }

        protected void setMapEventHolder(Object oHolder) {
            this.__m_MapEventHolder = oHolder;
        }

        public void setMapEventsRaw(Object oRaw) {
            this.__m_MapEventsRaw = oRaw;
        }

        public void setMergedNewValue(ReadBuffer bufValue) {
            this.__m_MergedNewValue = bufValue;
        }

        public void setOldValue(Binary binValueOld) {
            this.__m_OldValue = binValueOld;
        }

        public void setPartition(int nPartition) {
            this.set_Order(Float.intBitsToFloat(nPartition));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void setPending(boolean fPending) {
            if (fPending) {
                boolean fInterrupted = false;
                while (this.isPending()) {
                    int nWaitingThreads;
                    this.setWaitingThreadCount(this.getWaitingThreadCount() + 1);
                    try {
                        Blocking.wait(this);
                        nWaitingThreads = this.getWaitingThreadCount();
                        EntryStatus._assert(nWaitingThreads > 0);
                    }
                    catch (InterruptedException e) {
                        try {
                            fInterrupted = true;
                            nWaitingThreads = this.getWaitingThreadCount();
                            EntryStatus._assert(nWaitingThreads > 0);
                        }
                        catch (Throwable throwable) {
                            int nWaitingThreads2 = this.getWaitingThreadCount();
                            EntryStatus._assert(nWaitingThreads2 > 0);
                            this.setWaitingThreadCount(--nWaitingThreads2);
                            throw throwable;
                        }
                        this.setWaitingThreadCount(--nWaitingThreads);
                        continue;
                    }
                    this.setWaitingThreadCount(--nWaitingThreads);
                }
                this.__m_Pending = true;
                if (fInterrupted) {
                    Thread.currentThread().interrupt();
                }
            } else {
                this.__m_Pending = false;
                if (this.getWaitingThreadCount() > 0) {
                    this.notify();
                }
            }
        }

        public void setResult(Binary binResult) {
            this.__m_Result = binResult;
        }

        public void setSuppressEvents(boolean fEvents) {
            this.__m_SuppressEvents = fEvents;
        }

        private void setWaitingThreadCount(int nCount) {
            this.__m_WaitingThreadCount = nCount;
        }
    }

    public static class EntryToBinaryEntryConverter
    extends Util
    implements Converter {
        public EntryToBinaryEntryConverter() {
            this(null, null, true);
        }

        public EntryToBinaryEntryConverter(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new EntryToBinaryEntryConverter();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/Storage$EntryToBinaryEntryConverter".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent().get_Parent();
        }

        @Override
        public Object convert(Object o) {
            Map.Entry entry = (Map.Entry)o;
            return ((Storage)this.get_Parent()).instantiateBinaryEntry((Binary)entry.getKey(), (Binary)entry.getValue(), true);
        }
    }

    public static class EvictionTask
    extends Util
    implements Runnable {
        public static final long EVICTION_DELAY = 250L;
        private long __m_EvictionTime;
        private boolean __m_Prune;

        public EvictionTask() {
            this(null, null, true);
        }

        public EvictionTask(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new EvictionTask();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/Storage$EvictionTask".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent().get_Parent();
        }

        public void cancel() {
            this.get_Parent()._unlinkChild(this);
        }

        public long getEvictionTime() {
            return this.__m_EvictionTime;
        }

        protected boolean isPrune() {
            return this.__m_Prune;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Storage storage = (Storage)this.get_Parent();
            if (storage == null) {
                return;
            }
            PartitionedCache service = storage.getService();
            ConfigurableCacheMap mapCCM = storage.getBackingConfigurableCache();
            if (mapCCM != null) {
                if (this.isPrune()) {
                    mapCCM.setHighUnits(mapCCM.getHighUnits());
                }
                mapCCM.evict();
                service.processChanges();
                long cMillisReschedule = -1L;
                Storage storage2 = storage;
                synchronized (storage2) {
                    long ldtNow = Base.getSafeTimeMillis();
                    long ldtNext = mapCCM.getNextExpiryTime();
                    if (ldtNext > 0L) {
                        cMillisReschedule = Math.max(250L, ldtNext - ldtNow);
                    } else {
                        long cDefaultExpiry = mapCCM.getExpiryDelay();
                        if (cDefaultExpiry > 0L) {
                            ldtNext = ldtNow + cDefaultExpiry;
                            cMillisReschedule = cDefaultExpiry;
                        }
                    }
                    this.setEvictionTime(ldtNext);
                }
                if (cMillisReschedule != -1L) {
                    service.getDaemonPool().schedule(this, cMillisReschedule);
                }
            }
        }

        public void setEvictionTime(long lTime) {
            this.__m_EvictionTime = lTime;
        }

        public void setPrune(boolean fPrune) {
            this.__m_Prune = fPrune;
        }
    }

    public static class KeyToBinaryEntryConverter
    extends Util
    implements Converter {
        public KeyToBinaryEntryConverter() {
            this(null, null, true);
        }

        public KeyToBinaryEntryConverter(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new KeyToBinaryEntryConverter();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/Storage$KeyToBinaryEntryConverter".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent().get_Parent();
        }

        @Override
        public Object convert(Object binKey) {
            return ((Storage)this.get_Parent()).instantiateBinaryEntry((Binary)binKey, null, true);
        }
    }

    public static class LazyKeySet
    extends WrapperSet {
        private PartitionSet __m_PartitionMask;
        private boolean __m_Snapshot;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Iterator", Iterator.get_CLASS());
        }

        public LazyKeySet() {
            this(null, null, true);
        }

        public LazyKeySet(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new LazyKeySet();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/Storage$LazyKeySet".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent().get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public PartitionSet getPartitionMask() {
            return this.__m_PartitionMask;
        }

        @Override
        public Set getSet() {
            Set set = super.getSet();
            if (set == null) {
                set = ((Storage)this.get_Parent()).collectKeySet(this.getPartitionMask(), this.isSnapshot());
                this.setSet(set);
            }
            return set;
        }

        public boolean isSnapshot() {
            return this.__m_Snapshot;
        }

        public void setPartitionMask(PartitionSet parts) {
            this.__m_PartitionMask = parts;
        }

        public void setSnapshot(boolean fSnapshot) {
            this.__m_Snapshot = fSnapshot;
        }

        static {
            LazyKeySet.__initStatic();
        }

        public static class Iterator
        extends WrapperSet.Iterator {
            public Iterator() {
                this(null, null, true);
            }

            public Iterator(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Iterator();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/Storage$LazyKeySet$Iterator".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent().get_Parent();
            }
        }
    }

    public static class PrimaryListener
    extends Util
    implements MapListener {
        public PrimaryListener() {
            this(null, null, true);
        }

        public PrimaryListener(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PrimaryListener();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/Storage$PrimaryListener".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent().get_Parent();
        }

        public void entryDeleted(MapEvent evt) {
            ((Storage)this.get_Parent()).onBackingMapEvent(evt);
        }

        public void entryInserted(MapEvent evt) {
            ((Storage)this.get_Parent()).onBackingMapEvent(evt);
        }

        public void entryUpdated(MapEvent evt) {
            ((Storage)this.get_Parent()).onBackingMapEvent(evt);
        }
    }

    public static class Scanner
    extends AdvancingIterator
    implements Streamer {
        private int __m_Count;
        private BinaryEntry __m_EntryTemp;
        private Filter __m_Filter;
        private Iterator __m_Iterator;
        private Object[] __m_Keys;
        private int __m_NextPartition;
        private PartitionSet __m_Partitions;
        private boolean __m_ReuseAllowed;

        public Scanner() {
            this(null, null, true);
        }

        public Scanner(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Scanner();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/Storage$Scanner".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent().get_Parent();
        }

        @Override
        protected Object advance() {
            Storage storage = this.getStorage();
            Filter filter = this.getFilter();
            BinaryEntry entry = this.getEntryTemp();
            Iterator iterator = this.getIterator();
            boolean fInit = storage.isPotentiallyEvicting();
            ObservableMap mapPrime = storage.getBackingInternalCache();
            if (iterator == null) {
                iterator = this.advanceIterator();
            }
            while (iterator != null) {
                Binary binKey;
                while (iterator.hasNext() && (binKey = (Binary)iterator.next()) != null) {
                    int c = this.getCount();
                    this.setCount(c + 1);
                    if ((c & 0x3FF) == 1023) {
                        storage.getService().checkInterrupt();
                    }
                    Binary binValue = null;
                    if (fInit && (binValue = (Binary)mapPrime.get(binKey)) == null) continue;
                    if (entry == null) {
                        entry = storage.instantiateBinaryEntry(binKey, binValue, true);
                        if (this.isReuseAllowed()) {
                            this.setEntryTemp(entry);
                        }
                    } else {
                        entry.reset(binKey, binValue);
                    }
                    if (filter != null && !InvocableMapHelper.evaluateEntry(filter, entry)) continue;
                    return entry;
                }
                iterator = this.advanceIterator();
            }
            this.setEntryTemp(null);
            return null;
        }

        protected Iterator advanceIterator() {
            int iPart = this.getPartitions().next(this.getNextPartition());
            while (iPart >= 0) {
                Object[] aoKeys = this.getStorage().collectKeys(iPart, this.getKeys());
                if (aoKeys.length > 0) {
                    this.setNextPartition(iPart + 1);
                    this.setKeys(aoKeys);
                    SimpleEnumerator<Object> iterator = new SimpleEnumerator<Object>(aoKeys);
                    this.setIterator(iterator);
                    return iterator;
                }
                iPart = this.getPartitions().next(iPart + 1);
            }
            this.setKeys(null);
            this.setIterator(null);
            return null;
        }

        @Override
        public int characteristics() {
            return this.getFilter() == null ? 3 : 0;
        }

        private int getCount() {
            return this.__m_Count;
        }

        private BinaryEntry getEntryTemp() {
            return this.__m_EntryTemp;
        }

        protected Filter getFilter() {
            return this.__m_Filter;
        }

        private Iterator getIterator() {
            return this.__m_Iterator;
        }

        private Object[] getKeys() {
            return this.__m_Keys;
        }

        private int getNextPartition() {
            return this.__m_NextPartition;
        }

        protected PartitionSet getPartitions() {
            return this.__m_Partitions;
        }

        protected Storage getStorage() {
            return (Storage)this.get_Parent();
        }

        protected boolean isReuseAllowed() {
            return this.__m_ReuseAllowed;
        }

        @Override
        public void onInit() {
            this.setKeys(new Object[0]);
            super.onInit();
        }

        private void setCount(int c) {
            this.__m_Count = c;
        }

        private void setEntryTemp(BinaryEntry entryTemp) {
            this.__m_EntryTemp = entryTemp;
        }

        public void setFilter(Filter filter) {
            this.__m_Filter = filter;
        }

        private void setIterator(Iterator iter) {
            this.__m_Iterator = iter;
        }

        private void setKeys(Object[] aoKeys) {
            this.__m_Keys = aoKeys;
        }

        private void setNextPartition(int nPart) {
            this.__m_NextPartition = nPart;
        }

        public void setPartitions(PartitionSet parts) {
            this.__m_Partitions = parts;
        }

        public void setReuseAllowed(boolean fReuse) {
            this.__m_ReuseAllowed = fReuse;
        }

        @Override
        public long size() {
            return this.getStorage().calculateSize(this.getPartitions(), true);
        }
    }

    public static class DispatcherInterceptor
    extends Util
    implements EventInterceptor {
        private transient AtomicLong __m_InterceptorCount;

        public DispatcherInterceptor() {
            this(null, null, true);
        }

        public DispatcherInterceptor(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setInterceptorCount(new AtomicLong());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new DispatcherInterceptor();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/Storage$DispatcherInterceptor".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent().get_Parent();
        }

        public AtomicLong getInterceptorCount() {
            return this.__m_InterceptorCount;
        }

        public Storage getStorage() {
            return (Storage)this.get_Parent();
        }

        public void onEvent(Event event) {
            EventDispatcher.InterceptorRegistrationEvent evtDisp = (EventDispatcher.InterceptorRegistrationEvent)event;
            if (evtDisp.getInterceptor() != this) {
                Object type = evtDisp.getType();
                if (type == EventDispatcher.InterceptorRegistrationEvent.Type.INSERTED) {
                    this.getInterceptorCount().incrementAndGet();
                    this.getStorage().ensureOldValueRequired();
                } else if (type == EventDispatcher.InterceptorRegistrationEvent.Type.REMOVED) {
                    this.getInterceptorCount().decrementAndGet();
                }
            }
        }

        public void setInterceptorCount(AtomicLong atomicCount) {
            this.__m_InterceptorCount = atomicCount;
        }
    }

    public static class PartitionedAggregateTask<P>
    extends RecursiveTask<P> {
        private final Storage f_storage;
        private final Filter f_filter;
        private final InvocableMap.StreamingAggregator<?, ?, P, ?> f_agent;
        private final PartitionSet f_parts;

        public PartitionedAggregateTask(Storage storage, Filter filter, InvocableMap.StreamingAggregator<?, ?, P, ?> agent, PartitionSet parts) {
            this.f_storage = storage;
            this.f_filter = filter;
            this.f_agent = agent;
            this.f_parts = parts;
        }

        @Override
        protected P compute() {
            if (this.f_parts.cardinality() == 1) {
                this.f_agent.accumulate(this.f_storage.createStreamer(this.f_filter, this.f_agent, this.f_parts));
                return this.f_agent.getPartialResult();
            }
            PartitionSet partMask = this.f_parts;
            PartitionedAggregateTask[] aTasks = new PartitionedAggregateTask[partMask.cardinality()];
            int nPos = 0;
            for (int nPart : partMask) {
                PartitionSet part = new PartitionSet(partMask.getPartitionCount(), nPart);
                aTasks[nPos++] = new PartitionedAggregateTask<P>(this.f_storage, this.f_filter, this.f_agent.supply(), part);
            }
            PartitionedAggregateTask.invokeAll(aTasks);
            for (int i = 0; i < aTasks.length; ++i) {
                this.f_agent.combine(aTasks[i].join());
            }
            return this.f_agent.getPartialResult();
        }
    }

    public static class PartitionedQueryTask
    extends RecursiveTask<QueryResult> {
        private final Storage f_storage;
        private final Filter f_filter;
        private final int f_nQueryType;
        private final PartitionSet f_parts;
        private final long f_lIdxVersion;

        public PartitionedQueryTask(Storage storage, Filter filter, int nQueryType, PartitionSet parts, long lIdxVersion) {
            this.f_storage = storage;
            this.f_filter = filter;
            this.f_nQueryType = nQueryType;
            this.f_parts = parts;
            this.f_lIdxVersion = lIdxVersion;
        }

        @Override
        protected QueryResult compute() {
            if (this.f_parts.cardinality() == 1) {
                return this.f_storage.queryInternal(this.f_filter, this.f_nQueryType == 3 ? 1 : this.f_nQueryType, this.f_parts, this.f_lIdxVersion);
            }
            PartitionSet partMask = this.f_parts;
            PartitionedQueryTask[] aTasks = new PartitionedQueryTask[partMask.cardinality()];
            int nPos = 0;
            for (int nPart : partMask) {
                PartitionSet part = new PartitionSet(partMask.getPartitionCount(), nPart);
                aTasks[nPos++] = new PartitionedQueryTask(this.f_storage, this.f_filter, this.f_nQueryType == 3 ? 1 : this.f_nQueryType, part, this.f_lIdxVersion);
            }
            PartitionedQueryTask.invokeAll(aTasks);
            QueryResult[] aPartResults = new QueryResult[aTasks.length];
            for (int i = 0; i < aTasks.length; ++i) {
                QueryResult result;
                aPartResults[i] = result = (QueryResult)aTasks[i].join();
            }
            return new QueryResult(aPartResults);
        }
    }
}

