/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.partitionedCache;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.oracle.coherence.common.base.TimeHelper;
import com.oracle.coherence.common.base.Timeout;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.net.message.requestMessage.distributedCacheRequest.PartialRequest;
import com.tangosol.coherence.component.util.ServiceConfig;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.partitionedCache.BinaryMap;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.partitionedCache.Storage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.partitionedCache.ViewMap;
import com.tangosol.internal.net.topic.ChannelAllocationStrategy;
import com.tangosol.internal.net.topic.SimpleChannelAllocationStrategy;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicBackingMapManager;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicCaches;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicConfigMap;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicDependencies;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicSubscriber;
import com.tangosol.internal.net.topic.impl.paged.agent.CloseSubscriptionProcessor;
import com.tangosol.internal.net.topic.impl.paged.model.PagedTopicSubscription;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberGroupId;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberId;
import com.tangosol.internal.net.topic.impl.paged.model.Subscription;
import com.tangosol.internal.net.topic.impl.paged.model.Usage;
import com.tangosol.internal.net.topic.impl.paged.statistics.PagedTopicStatistics;
import com.tangosol.internal.util.Daemons;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.PagedTopicService;
import com.tangosol.net.RequestPolicyException;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.internal.ServiceDispatcher;
import com.tangosol.net.events.partition.TransferEvent;
import com.tangosol.net.internal.ScopedCacheReferenceStore;
import com.tangosol.net.internal.ScopedTopicReferenceStore;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.net.topic.Subscriber;
import com.tangosol.net.topic.TopicException;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.CopyOnWriteLongArray;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.LiteMap;
import com.tangosol.util.LongArray;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.SimpleResourceRegistry;
import com.tangosol.util.SparseArray;
import com.tangosol.util.TaskDaemon;
import com.tangosol.util.UUID;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

public class PagedTopic
extends PartitionedCache
implements PagedTopicService {
    private ChannelAllocationStrategy __m_ChannelAllocationStrategy;
    private TaskDaemon __m_ChannelCountExecutor;
    public static final int CONFIG_MAP_TOPIC = 3;
    private ScopedTopicReferenceStore __m_ScopedTopicStore;
    private LongArray __m_SubscriptionArray;
    private Map __m_SubscriptionGraveyard;
    private ReentrantLock __m_SubscriptionLock;
    public static final int SUID_SUBSCRIPTION = 4;
    private TopicConfig.Map __m_TopicConfigMap;
    private ReentrantLock __m_TopicStoreLock;
    private final Set<PagedTopicSubscription.Listener> __m_subscriptionListener = new HashSet<PagedTopicSubscription.Listener>();
    private static ListMap __mapChildren;
    public static final int TOPIC_API_v0 = 0;
    public static final int TOPIC_API_v1 = 1;
    public static final int TOPIC_API_v2 = 2;
    private static final int VERSION_22_06_3;
    private static final int VERSION_22_06_4;
    private static final int VERSION_22_06_5;
    private static final int VERSION_22_09_0;
    private static final int VERSION_23_03_0;
    private static final int VERSION_23_03_1;
    private static final int VERSION_23_03_2;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Acknowledgement", Grid.Acknowledgement.get_CLASS());
        __mapChildren.put("AggregateAllRequest", PartitionedCache.AggregateAllRequest.get_CLASS());
        __mapChildren.put("AggregateFilterRequest", PartitionedCache.AggregateFilterRequest.get_CLASS());
        __mapChildren.put("BackingMapContext", PartitionedCache.BackingMapContext.get_CLASS());
        __mapChildren.put("BackupAllRequest", PartitionedCache.BackupAllRequest.get_CLASS());
        __mapChildren.put("BackupAssignment", PartitionedService.BackupAssignment.get_CLASS());
        __mapChildren.put("BackupConfirmRequest", PartitionedCache.BackupConfirmRequest.get_CLASS());
        __mapChildren.put("BackupListenerAllRequest", PartitionedCache.BackupListenerAllRequest.get_CLASS());
        __mapChildren.put("BackupListenerRequest", PartitionedCache.BackupListenerRequest.get_CLASS());
        __mapChildren.put("BackupLockRequest", PartitionedCache.BackupLockRequest.get_CLASS());
        __mapChildren.put("BackupSingleRequest", PartitionedCache.BackupSingleRequest.get_CLASS());
        __mapChildren.put("BatchContext", PartitionedCache.BatchContext.get_CLASS());
        __mapChildren.put("BinaryMap", BinaryMap.get_CLASS());
        __mapChildren.put("BusEventMessage", Grid.BusEventMessage.get_CLASS());
        __mapChildren.put("CentralDistribution", PartitionedService.CentralDistribution.get_CLASS());
        __mapChildren.put("ChannelCountConfirmRequest", ChannelCountConfirmRequest.get_CLASS());
        __mapChildren.put("ClearRequest", PartitionedCache.ClearRequest.get_CLASS());
        __mapChildren.put("ConfigRequest", Grid.ConfigRequest.get_CLASS());
        __mapChildren.put("ConfigResponse", Grid.ConfigResponse.get_CLASS());
        __mapChildren.put("ConfigSync", Grid.ConfigSync.get_CLASS());
        __mapChildren.put("ConfigUpdate", Grid.ConfigUpdate.get_CLASS());
        __mapChildren.put("ContainsAllRequest", PartitionedCache.ContainsAllRequest.get_CLASS());
        __mapChildren.put("ContainsKeyRequest", PartitionedCache.ContainsKeyRequest.get_CLASS());
        __mapChildren.put("ContainsValueRequest", PartitionedCache.ContainsValueRequest.get_CLASS());
        __mapChildren.put("Contention", PartitionedService.Contention.get_CLASS());
        __mapChildren.put("ConverterFromBinary", PartitionedCache.ConverterFromBinary.get_CLASS());
        __mapChildren.put("ConverterKeyToBinary", PartitionedService.ConverterKeyToBinary.get_CLASS());
        __mapChildren.put("ConverterValueToBinary", PartitionedCache.ConverterValueToBinary.get_CLASS());
        __mapChildren.put("DispatchEvent", PartitionedService.DispatchEvent.get_CLASS());
        __mapChildren.put("DispatchNotification", Grid.DispatchNotification.get_CLASS());
        __mapChildren.put("DistributionPlanUpdate", PartitionedService.DistributionPlanUpdate.get_CLASS());
        __mapChildren.put("DistributionRequest", PartitionedCache.DistributionRequest.get_CLASS());
        __mapChildren.put("EnsureChannelCountTask", EnsureChannelCountTask.get_CLASS());
        __mapChildren.put("GetAllRequest", PartitionedCache.GetAllRequest.get_CLASS());
        __mapChildren.put("GetRequest", PartitionedCache.GetRequest.get_CLASS());
        __mapChildren.put("IndexRequest", PartitionedCache.IndexRequest.get_CLASS());
        __mapChildren.put("InvocationContext", PartitionedCache.InvocationContext.get_CLASS());
        __mapChildren.put("InvokeAllRequest", PartitionedCache.InvokeAllRequest.get_CLASS());
        __mapChildren.put("InvokeFilterRequest", PartitionedCache.InvokeFilterRequest.get_CLASS());
        __mapChildren.put("InvokeRequest", PartitionedCache.InvokeRequest.get_CLASS());
        __mapChildren.put("KeyIteratorRequest", PartitionedCache.KeyIteratorRequest.get_CLASS());
        __mapChildren.put("KeyListenerAllRequest", PartitionedCache.KeyListenerAllRequest.get_CLASS());
        __mapChildren.put("KeyListenerRequest", PartitionedCache.KeyListenerRequest.get_CLASS());
        __mapChildren.put("ListenerRequest", PartitionedCache.ListenerRequest.get_CLASS());
        __mapChildren.put("LockRequest", PartitionedCache.LockRequest.get_CLASS());
        __mapChildren.put("MapEvent", PartitionedCache.MapEvent.get_CLASS());
        __mapChildren.put("MemberConfigUpdate", PartitionedService.MemberConfigUpdate.get_CLASS());
        __mapChildren.put("MemberJoined", Grid.MemberJoined.get_CLASS());
        __mapChildren.put("MemberWelcome", MemberWelcome.get_CLASS());
        __mapChildren.put("MemberWelcomeRequest", MemberWelcomeRequest.get_CLASS());
        __mapChildren.put("MemberWelcomeRequestTask", Grid.MemberWelcomeRequestTask.get_CLASS());
        __mapChildren.put("NotifyConnectionClose", Grid.NotifyConnectionClose.get_CLASS());
        __mapChildren.put("NotifyConnectionOpen", Grid.NotifyConnectionOpen.get_CLASS());
        __mapChildren.put("NotifyMemberJoined", Grid.NotifyMemberJoined.get_CLASS());
        __mapChildren.put("NotifyMemberLeaving", Grid.NotifyMemberLeaving.get_CLASS());
        __mapChildren.put("NotifyMemberLeft", Grid.NotifyMemberLeft.get_CLASS());
        __mapChildren.put("NotifyMessageReceipt", Grid.NotifyMessageReceipt.get_CLASS());
        __mapChildren.put("NotifyPollClosed", Grid.NotifyPollClosed.get_CLASS());
        __mapChildren.put("NotifyResponse", Grid.NotifyResponse.get_CLASS());
        __mapChildren.put("NotifyServiceAnnounced", Grid.NotifyServiceAnnounced.get_CLASS());
        __mapChildren.put("NotifyServiceJoining", Grid.NotifyServiceJoining.get_CLASS());
        __mapChildren.put("NotifyServiceLeaving", PartitionedService.NotifyServiceLeaving.get_CLASS());
        __mapChildren.put("NotifyServiceLeft", Grid.NotifyServiceLeft.get_CLASS());
        __mapChildren.put("NotifyServiceQuiescence", PartitionedService.NotifyServiceQuiescence.get_CLASS());
        __mapChildren.put("NotifyShutdown", PartitionedService.NotifyShutdown.get_CLASS());
        __mapChildren.put("NotifySnapshotRecoverRequest", PartitionedService.NotifySnapshotRecoverRequest.get_CLASS());
        __mapChildren.put("NotifyStartup", Grid.NotifyStartup.get_CLASS());
        __mapChildren.put("OwnershipRequest", PartitionedCache.OwnershipRequest.get_CLASS());
        __mapChildren.put("OwnershipResponse", PartitionedService.OwnershipResponse.get_CLASS());
        __mapChildren.put("PartialMapResponse", PartitionedCache.PartialMapResponse.get_CLASS());
        __mapChildren.put("PartialValueResponse", PartitionedCache.PartialValueResponse.get_CLASS());
        __mapChildren.put("PartitionAbandonRequest", PartitionedCache.PartitionAbandonRequest.get_CLASS());
        __mapChildren.put("PartitionControl", PartitionedCache.PartitionControl.get_CLASS());
        __mapChildren.put("PartitionFilter", PartitionedService.PartitionFilter.get_CLASS());
        __mapChildren.put("PartitionRecoverCleanup", PartitionedService.PartitionRecoverCleanup.get_CLASS());
        __mapChildren.put("PartitionRecoverRequest", PartitionedCache.PartitionRecoverRequest.get_CLASS());
        __mapChildren.put("PartitionStatsUpdate", PartitionedService.PartitionStatsUpdate.get_CLASS());
        __mapChildren.put("PartitionSwapRequest", PartitionedCache.PartitionSwapRequest.get_CLASS());
        __mapChildren.put("PartitionVersionSyncRequest", PartitionedCache.PartitionVersionSyncRequest.get_CLASS());
        __mapChildren.put("PersistenceControl", PartitionedCache.PersistenceControl.get_CLASS());
        __mapChildren.put("PingRequest", Grid.PingRequest.get_CLASS());
        __mapChildren.put("PinningIterator", PartitionedCache.PinningIterator.get_CLASS());
        __mapChildren.put("ProtocolContext", Grid.ProtocolContext.get_CLASS());
        __mapChildren.put("PutAllRequest", PartitionedCache.PutAllRequest.get_CLASS());
        __mapChildren.put("PutRequest", PartitionedCache.PutRequest.get_CLASS());
        __mapChildren.put("QueryRequest", PartitionedCache.QueryRequest.get_CLASS());
        __mapChildren.put("PartitionedQueryRequest", PartitionedCache.PartitionedQueryRequest.get_CLASS());
        __mapChildren.put("QueryResponse", PartitionedCache.QueryResponse.get_CLASS());
        __mapChildren.put("PartitionedQueryResponse", PartitionedCache.PartitionedQueryResponse.get_CLASS());
        __mapChildren.put("RemoveAllRequest", PartitionedCache.RemoveAllRequest.get_CLASS());
        __mapChildren.put("RemoveRequest", PartitionedCache.RemoveRequest.get_CLASS());
        __mapChildren.put("Response", Grid.Response.get_CLASS());
        __mapChildren.put("ResultInfo", PartitionedCache.ResultInfo.get_CLASS());
        __mapChildren.put("SendBackupsTask", PartitionedCache.SendBackupsTask.get_CLASS());
        __mapChildren.put("SetChannelCountRequest", SetChannelCountRequest.get_CLASS());
        __mapChildren.put("SizeRequest", PartitionedCache.SizeRequest.get_CLASS());
        __mapChildren.put("SnapshotArchiveRequest", PartitionedService.SnapshotArchiveRequest.get_CLASS());
        __mapChildren.put("SnapshotListRequest", PartitionedCache.SnapshotListRequest.get_CLASS());
        __mapChildren.put("SnapshotRequest", PartitionedCache.SnapshotRequest.get_CLASS());
        __mapChildren.put("Storage", Storage.get_CLASS());
        __mapChildren.put("StorageConfirmRequest", PartitionedCache.StorageConfirmRequest.get_CLASS());
        __mapChildren.put("StorageIdRequest", StorageIdRequest.get_CLASS());
        __mapChildren.put("SubscriberConfirmRequest", SubscriberConfirmRequest.get_CLASS());
        __mapChildren.put("SubscriberIdRequest", SubscriberIdRequest.get_CLASS());
        __mapChildren.put("TransferRequest", PartitionedCache.TransferRequest.get_CLASS());
        __mapChildren.put("TransferResponse", PartitionedService.TransferResponse.get_CLASS());
        __mapChildren.put("UnlockRequest", PartitionedCache.UnlockRequest.get_CLASS());
        __mapChildren.put("UpdateIndexRequest", PartitionedCache.UpdateIndexRequest.get_CLASS());
        __mapChildren.put("ViewMap", ViewMap.get_CLASS());
        __mapChildren.put("WrapperGuardable", Grid.WrapperGuardable.get_CLASS());
    }

    public PagedTopic() {
        this(null, null, true);
    }

    public PagedTopic(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setAcceptingClients(false);
            this.setAcceptingOthers(false);
            this.setBackupAllEnvelopeSize(new AtomicInteger());
            this.setBackupCount(0);
            this.setBackupCountOpt(0);
            this.setBackupSingleEnvelopeSize(new AtomicInteger());
            this.setBinaryMapArray(new CopyOnWriteLongArray());
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setDistributionNextMillis(Long.MAX_VALUE);
            this.setDistributionRepeatMillis(2000);
            this.setDistributionSynchronized(true);
            this.setFinalizing(false);
            this.setLeaseGranularity(0);
            this.setLockingNextMillis(Long.MAX_VALUE);
            this.setMessageClassMap(new HashMap());
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setOldestPendingRequestSUIDCounter(new AtomicLong());
            this.setOwnershipEnabled(true);
            this.setPartitionListeners(new Listeners());
            this.setPendingIndexUpdate(new ConcurrentLinkedQueue());
            this.setProcessedEvents(new SparseArray());
            this.setReferencesBinaryMap(new ConcurrentHashMap());
            this.setResourceRegistry(new SimpleResourceRegistry());
            this.setScopedCacheStore(new ScopedCacheReferenceStore());
            this.setScopedTopicStore(new ScopedTopicReferenceStore());
            this.setSerializerMap(new WeakHashMap());
            this.setStandardLeaseMillis(0L);
            this.setStatsIndexingTime(new AtomicLong());
            this.setStorageArray(new CopyOnWriteLongArray());
            this.setStrictPartitioning(true);
            this.setSubscriptionArray(new CopyOnWriteLongArray());
            this.setSubscriptionLock(new ReentrantLock());
            this.setSuspendPollLimit(new AtomicLong());
            this.setTLOContext(new ThreadLocal());
            this.setTLORecoveryThread(new ThreadLocal());
            this.setTopicStoreLock(new ReentrantLock());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new PartitionedCache.Continuations("Continuations", this, true), "Continuations");
        this._addChild(new PartitionedCache.DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Grid.EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new PartitionedCache.EventsHelper("EventsHelper", this, true), "EventsHelper");
        this._addChild(new Grid.Guard("Guard", this, true), "Guard");
        this._addChild(new PartitionedCache.LazyLookup("LazyLookup", this, true), "LazyLookup");
        this._addChild(new PartitionedService.MemberConfigListener("MemberConfigListener", this, true), "MemberConfigListener");
        this._addChild(new PartitionedService.PartitionConfig("PartitionConfig", this, true), "PartitionConfig");
        this._addChild(new Grid.PollArray("PollArray", this, true), "PollArray");
        this._addChild(new Grid.ReceiveQueue("ReceiveQueue", this, true), "ReceiveQueue");
        this._addChild(new PartitionedCache.RequestCoordinator("RequestCoordinator", this, true), "RequestCoordinator");
        this._addChild(new PartitionedCache.ResourceCoordinator("ResourceCoordinator", this, true), "ResourceCoordinator");
        this._addChild(new PartitionedCache.ServiceConfig("ServiceConfig", this, true), "ServiceConfig");
        this._addChild(new TopicConfig("TopicConfig", this, true), "TopicConfig");
        this._addChild(new PartitionedCache.TransferControl("TransferControl", this, true), "TransferControl");
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    @Override
    public String getServiceType() {
        return "PagedTopic";
    }

    @Override
    public int getSUIDCounterLength() {
        return 6;
    }

    public static Component get_Instance() {
        return new PagedTopic();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/PagedTopic".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    protected boolean confirmSubscriber(long lSubscription, SubscriberId subscriberId) {
        return PagedTopicConfigMap.hasSubscription(this.getTopicConfigMap(), lSubscription, subscriberId);
    }

    protected boolean confirmSubscriber(String sTopicName, long lSubscription, SubscriberId subscriberId) {
        boolean fConfirmed = false;
        if (lSubscription != 0L) {
            String sCacheName = PagedTopicCaches.Names.SUBSCRIPTIONS.cacheNameForTopicName(sTopicName);
            Map mapRefsBinary = this.getReferencesBinaryMap();
            BinaryMap mapBinary = (BinaryMap)mapRefsBinary.get(sCacheName);
            fConfirmed = mapBinary != null && mapBinary.confirmSubscriber(lSubscription, subscriberId);
        }
        return fConfirmed;
    }

    protected boolean confirmChannelCount(String sTopicName, int cChannel) {
        boolean fConfirmed = false;
        String sCacheName = PagedTopicCaches.Names.PAGES.cacheNameForTopicName(sTopicName);
        Map mapRefsBinary = this.getReferencesBinaryMap();
        BinaryMap mapBinary = (BinaryMap)mapRefsBinary.get(sCacheName);
        return mapBinary != null && mapBinary.confirmChannelCount(sTopicName, cChannel);
    }

    @Override
    public XmlElement createCacheInfo(String sCacheName, long lCacheId) {
        XmlElement xmlCacheInfo = super.createCacheInfo(sCacheName, lCacheId);
        String sTopicName = PagedTopicCaches.Names.getTopicName(sCacheName);
        PagedTopicBackingMapManager mgr = this.getTopicBackingMapManager();
        PagedTopicDependencies deps = mgr.getTopicDependencies(sTopicName);
        xmlCacheInfo.addAttribute("channels").setInt(deps.getConfiguredChannelCount());
        return xmlCacheInfo;
    }

    protected PagedTopicSubscription createSubscription(String sTopicName, SubscriberGroupId groupId, long lSubscriptionId, Filter filter, ValueExtractor extractor) {
        PagedTopicSubscription subscription = new PagedTopicSubscription();
        subscription.setKey(sTopicName, groupId);
        subscription.setSubscriptionId(lSubscriptionId);
        subscription.setFilter(filter);
        subscription.setConverter(extractor);
        return subscription;
    }

    @Override
    public void destroySubscriberGroup(String sTopicName, String sGroupName) {
        SubscriberGroupId groupId = SubscriberGroupId.withName(sGroupName);
        long lSubscription = this.getSubscriptionId(sTopicName, groupId);
        if (lSubscription > 0L) {
            this.destroySubscription(lSubscription);
        }
    }

    @Override
    public void destroySubscription(long lSubscriptionId) {
        this.destroySubscription(lSubscriptionId, null);
    }

    @Override
    public void destroySubscription(long lSubscriptionId, Subscriber.Id id) {
        if (id == null || id instanceof SubscriberId) {
            Member memberCoordinator = this.getServiceOldestMember();
            if (this.isTopicsApiVersionCompatible(memberCoordinator, 1)) {
                SubscriberId subscriberId = (SubscriberId)id;
                SubscriberIdRequest msg = (SubscriberIdRequest)this.instantiateMessage("SubscriberIdRequest");
                msg.addToMember(this.getServiceOldestMember());
                msg.setSubscriptionId(lSubscriptionId);
                msg.setSubscriberAction(2);
                if (subscriberId == null) {
                    msg.setSubscriberIds(new SubscriberId[0]);
                } else {
                    msg.setSubscriberIds(new SubscriberId[]{subscriberId});
                }
                this.poll(msg);
            }
        } else {
            throw new IllegalArgumentException("Id must be an instance of " + String.valueOf(SubscriberId.class) + " but is " + String.valueOf(id.getClass()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroySubscriptionInternal(long lSubscriptionId) {
        PagedTopic._assert(lSubscriptionId != 0L);
        PagedTopic service = (PagedTopic)this.get_Module();
        LongArray aSubscription = this.getSubscriptionArray();
        PagedTopicSubscription subscription = (PagedTopicSubscription)aSubscription.get(lSubscriptionId);
        if (subscription != null) {
            ReentrantLock lock = this.getSubscriptionLock();
            lock.lock();
            try {
                subscription = (PagedTopicSubscription)aSubscription.get(lSubscriptionId);
                if (subscription != null) {
                    MBeanHelper.unregisterSubscriberGroupMBean(this, subscription);
                    this.getSubscriptionGraveyard().put(lSubscriptionId, subscription.getKey());
                    aSubscription.remove(lSubscriptionId);
                    boolean bl = true;
                    return bl;
                }
                for (PagedTopicSubscription.Listener listener : this.__m_subscriptionListener) {
                    try {
                        listener.onDelete(subscription);
                    }
                    catch (Throwable e) {
                        Logger.err(e);
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
        return false;
    }

    @Override
    public void destroyTopic(NamedTopic topic) {
        ReentrantLock lock = this.getTopicStoreLock();
        lock.lock();
        try {
            this.getScopedTopicStore().releaseTopic(topic);
        }
        finally {
            lock.unlock();
        }
        topic.destroy();
    }

    @Override
    public int ensureChannelCount(String sTopic, int cChannel) {
        return this.ensureChannelCount(sTopic, cChannel, cChannel);
    }

    @Override
    public int ensureChannelCount(String sTopic, int cRequired, int cChannel) {
        int cActual = this.getChannelCountFromConfigMap(sTopic);
        if (cActual < cRequired) {
            SetChannelCountRequest msg = (SetChannelCountRequest)this.instantiateMessage("SetChannelCountRequest");
            Member member = this.getServiceOldestMember();
            if (this.isTopicsApiVersionCompatible(member, 1)) {
                long cTimeout;
                msg.addToMember(this.getServiceOldestMember());
                msg.setTopicName(sTopic);
                msg.setRequiredCount(cRequired);
                msg.setChannelCount(cChannel);
                this.send(msg);
                Logger.config("Request for increase of channel count for topic \"" + sTopic + "\" from " + cActual + " to " + cChannel + " sent to senior member " + String.valueOf(member));
                ServiceDependencies deps = this.getDependencies();
                long cRequestTimeout = deps == null ? 0L : deps.getRequestTimeoutMillis();
                long cStart = TimeHelper.getSafeTimeMillis();
                long l = cTimeout = Timeout.isSet() ? Timeout.remainingTimeoutMillis() : cRequestTimeout;
                if (cTimeout <= 0L) {
                    cTimeout = 300000L;
                }
                cActual = this.getChannelCountFromConfigMap(sTopic);
                while (cActual < cRequired) {
                    if (TimeHelper.getSafeTimeMillis() - cStart > cTimeout) {
                        throw new RequestTimeoutException("Timed out waiting for config map update of channel count to be set to " + cRequired + " for topic " + sTopic + " (actual=" + cActual + ")");
                    }
                    try {
                        Blocking.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw Exceptions.ensureRuntimeException(e);
                    }
                    cActual = this.getChannelCountFromConfigMap(sTopic);
                }
                cStart = TimeHelper.getSafeTimeMillis();
                long nThirtySecs = 30000L;
                long nLog = cStart + nThirtySecs;
                int cFinalActual = cActual;
                while (!this.confirmChannelCount(sTopic, cActual)) {
                    long nTime = TimeHelper.getSafeTimeMillis() - cStart;
                    if (nTime > nLog) {
                        long cSeconds = nTime / 1000L;
                        Logger.info(() -> String.format("This member has been waiting %d seconds for the channel count of topic %s to be set to %d across all storage members", cSeconds, sTopic, cFinalActual));
                    }
                    try {
                        Blocking.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw Exceptions.ensureRuntimeException(e);
                    }
                }
            } else {
                Logger.fine("Cannot ensure publisher channel count, senior member is not version compatible " + String.valueOf(member));
                cActual = this.getChannelCount(sTopic);
            }
        }
        return cActual;
    }

    public void ensureKnownTopics() {
        TopicConfig.Map map = this.getTopicConfigMap();
        for (Object oKey : map.keySet()) {
            if (!(oKey instanceof PagedTopicSubscription.Key)) continue;
            PagedTopicSubscription subscription = (PagedTopicSubscription)map.get(oKey);
            this.ensureSubscription(subscription);
        }
    }

    @Override
    public void ensureStorageInternal(String sName, long lCacheId, boolean fInit) {
        super.ensureStorageInternal(sName, lCacheId, fInit);
        if (PagedTopicCaches.Names.SUBSCRIPTIONS.isA(sName)) {
            this.ensureBinaryMap(sName, lCacheId);
        } else if (PagedTopicCaches.Names.USAGE.isA(sName)) {
            BinaryMap binaryMap = (BinaryMap)this.ensureBinaryMap(sName, lCacheId);
        } else if (PagedTopicCaches.Names.CONTENT.isA(sName)) {
            this.ensureBinaryMap(sName, lCacheId);
            if (this.isOwnershipEnabled()) {
                String sTopicName = PagedTopicCaches.Names.getTopicName(sName);
                MBeanHelper.registerPagedTopicMBean(this, sTopicName);
            }
        }
    }

    @Override
    public void addSubscriptionListener(PagedTopicSubscription.Listener listener) {
        ReentrantLock lock = this.getSubscriptionLock();
        lock.lock();
        try {
            this.__m_subscriptionListener.add(listener);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void removeSubscriptionListener(PagedTopicSubscription.Listener listener) {
        ReentrantLock lock = this.getSubscriptionLock();
        lock.lock();
        try {
            this.__m_subscriptionListener.remove(listener);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long ensureSubscription(PagedTopicSubscription subscription) {
        long lSubscriptionId = subscription.getSubscriptionId();
        PagedTopic._assert(lSubscriptionId != 0L);
        PagedTopic service = (PagedTopic)this.get_Module();
        LongArray aSubscription = this.getSubscriptionArray();
        ReentrantLock lock = this.getSubscriptionLock();
        lock.lock();
        try {
            PagedTopicSubscription subCurrent = (PagedTopicSubscription)aSubscription.get(lSubscriptionId);
            if (subCurrent == null) {
                subCurrent = new PagedTopicSubscription(subscription);
                aSubscription.set(lSubscriptionId, subCurrent);
                if (this.isOwnershipEnabled() && !subscription.isAnonymous()) {
                    MBeanHelper.registerSubscriberGroupMBean(this, subCurrent);
                }
            } else {
                subCurrent.update(subscription);
            }
            for (PagedTopicSubscription.Listener listener : this.__m_subscriptionListener) {
                try {
                    listener.onUpdate(subCurrent);
                }
                catch (Throwable e) {
                    Logger.err(e);
                }
            }
        }
        finally {
            lock.unlock();
        }
        return lSubscriptionId;
    }

    @Override
    public void ensureSubscription(String sTopicName, long lSubscription, Subscriber.Id id) {
        this.ensureSubscription(sTopicName, lSubscription, id, false);
    }

    @Override
    public void ensureSubscription(String sTopicName, long lSubscription, Subscriber.Id id, boolean fForceReconnect) {
        if (id == null || id instanceof SubscriberId) {
            SubscriberId subscriberId = (SubscriberId)id;
            PagedTopicSubscription subscription = this.getSubscription(lSubscription);
            if (!fForceReconnect && subscription != null && subscription.hasSubscriber(subscriberId)) {
                return;
            }
            do {
                SubscriberIdRequest msg = (SubscriberIdRequest)this.instantiateMessage("SubscriberIdRequest");
                msg.addToMember(this.getThisMember());
                msg.setTopicName(sTopicName);
                msg.setSubscriptionId(lSubscription);
                msg.setSubscriberAction(1);
                if (id == null || SubscriberId.NullSubscriber.equals(id)) {
                    msg.setSubscriberIds(new SubscriberId[0]);
                } else {
                    msg.setSubscriberIds(new SubscriberId[]{subscriberId});
                }
                Object oResult = this.poll(msg);
                if (oResult instanceof Long) {
                    lSubscription = (Long)oResult;
                } else if (oResult instanceof Throwable) {
                    throw Exceptions.ensureRuntimeException((Throwable)oResult);
                }
                if (lSubscription != -1L) continue;
                return;
            } while (!this.confirmSubscriber(sTopicName, lSubscription, subscriberId));
        } else {
            throw new IllegalArgumentException("Id must be an instance of " + String.valueOf(SubscriberId.class) + " but is " + String.valueOf(id.getClass()));
        }
    }

    public long ensureSubscription(String sTopicName, SubscriberGroupId groupId, Subscriber.Id id, Filter filter, ValueExtractor extractor) {
        if (id == null || id instanceof SubscriberId) {
            long start;
            SubscriberId subscriberId = (SubscriberId)id;
            PagedTopicSubscription subscription = this.getSubscription(sTopicName, groupId);
            if (subscription != null) {
                if (filter != null && !Objects.equals(filter, subscription.getFilter())) {
                    throw new TopicException("Cannot change the Filter in existing Subscriber group \"" + String.valueOf(groupId) + "\" current=" + String.valueOf(subscription.getFilter()) + " new=" + String.valueOf(filter));
                }
                if (extractor != null && !Objects.equals(subscription.getConverter(), extractor)) {
                    throw new TopicException("Cannot change the ValueExtractor in existing Subscriber group \"" + String.valueOf(groupId) + "\" current=" + String.valueOf(subscription.getConverter()) + " new=" + String.valueOf(extractor));
                }
                if (subscription.hasSubscriber(subscriberId)) {
                    return subscription.getSubscriptionId();
                }
            }
            long lSubscription = 0L;
            long lastTime = start = System.currentTimeMillis();
            int cAttempt = 0;
            do {
                lSubscription = this.getSubscriptionId(sTopicName, groupId);
                SubscriberIdRequest msg = (SubscriberIdRequest)this.instantiateMessage("SubscriberIdRequest");
                msg.addToMember(this.getThisMember());
                msg.setTopicName(sTopicName);
                msg.setGroupId(groupId);
                msg.setSubscriptionId(lSubscription);
                msg.setFilter(filter);
                msg.setConverter(extractor);
                msg.setSubscriberAction(1);
                if (id == null || SubscriberId.NullSubscriber.equals(id)) {
                    msg.setSubscriberIds(new SubscriberId[0]);
                } else {
                    msg.setSubscriberIds(new SubscriberId[]{subscriberId});
                }
                Object oResult = this.poll(msg);
                if (oResult instanceof Long) {
                    lSubscription = (Long)oResult;
                } else if (oResult instanceof Throwable) {
                    throw Exceptions.ensureRuntimeException((Throwable)oResult);
                }
                if (lSubscription == -1L) {
                    PagedTopic._trace("Could not request subscription id for subscription on topic " + sTopicName + " group " + String.valueOf(groupId) + " subscriber " + String.valueOf(id) + " from senior member " + String.valueOf(this.getServiceOldestMember()), 6);
                    return lSubscription;
                }
                ++cAttempt;
                long now = System.currentTimeMillis();
                long nTime = now - start;
                long cSeconds = nTime / 1000L;
                if (nTime > 300000L) {
                    throw new RequestTimeoutException("This member has been waiting for subscription confirmation for " + cSeconds + " seconds (attempts " + cAttempt + ") for subscription " + lSubscription + " on topic " + sTopicName + " group " + String.valueOf(groupId) + " subscriber " + String.valueOf(id));
                }
                if (now - lastTime <= 30000L) continue;
                lastTime = now;
                PagedTopic._trace("This member has been waiting for subscription confirmation for " + cSeconds + " seconds (attempts " + cAttempt + ") for subscription " + lSubscription + " on topic " + sTopicName + " group " + String.valueOf(groupId) + " subscriber " + String.valueOf(id), 7);
            } while (!this.confirmSubscriber(sTopicName, lSubscription, subscriberId));
            return this.getSubscriptionId(sTopicName, groupId);
        }
        throw new IllegalArgumentException("Id must be an instance of " + String.valueOf(SubscriberId.class) + " but is " + String.valueOf(id.getClass()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PagedTopicSubscription ensureSubscriptionInternal(String sTopicName, SubscriberGroupId groupId, long lSubscriptionId, Filter filter, ValueExtractor extractor) {
        if (lSubscriptionId == 0L) {
            lSubscriptionId = this.getSubscriptionId(sTopicName, groupId);
        }
        if (lSubscriptionId == 0L) {
            lSubscriptionId = this.generateSubscriptionId();
        }
        PagedTopic service = (PagedTopic)this.get_Module();
        LongArray aSubscription = this.getSubscriptionArray();
        PagedTopicSubscription subscription = (PagedTopicSubscription)aSubscription.get(lSubscriptionId);
        if (subscription == null) {
            ReentrantLock lock = this.getSubscriptionLock();
            lock.lock();
            try {
                subscription = (PagedTopicSubscription)aSubscription.get(lSubscriptionId);
                if (subscription == null) {
                    subscription = this.createSubscription(sTopicName, groupId, lSubscriptionId, filter, extractor);
                    aSubscription.set(lSubscriptionId, subscription);
                    if (this.isOwnershipEnabled() && !subscription.isAnonymous()) {
                        MBeanHelper.registerSubscriberGroupMBean(this, subscription);
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
        return (PagedTopicSubscription)aSubscription.get(lSubscriptionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamedTopic ensureTopic(String sName, ClassLoader loader) {
        if (!this.isRunning()) {
            throw new IllegalStateException("Service is not running: " + String.valueOf(this));
        }
        if (sName == null || sName.length() == 0) {
            sName = "Default";
        }
        if (loader == null) {
            loader = this.getContextClassLoader();
            PagedTopic._assert(loader != null, "ContextClassLoader is missing");
        }
        com.tangosol.internal.net.topic.impl.paged.PagedTopic topic = null;
        ScopedTopicReferenceStore store = this.getScopedTopicStore();
        topic = (com.tangosol.internal.net.topic.impl.paged.PagedTopic)store.get(sName, loader);
        if (topic != null) {
            return topic;
        }
        ReentrantLock lock = this.getTopicStoreLock();
        lock.lock();
        try {
            PagedTopicCaches topicCaches = new PagedTopicCaches(sName, this);
            com.tangosol.internal.net.topic.impl.paged.PagedTopic pagedTopic = new com.tangosol.internal.net.topic.impl.paged.PagedTopic(topicCaches);
            store.put(pagedTopic, loader);
            topic = pagedTopic;
        }
        finally {
            lock.unlock();
        }
        return topic;
    }

    public long generateSubscriptionId() {
        long lSubscriptionId;
        LongArray laSubscription = this.getSubscriptionArray();
        PagedTopic service = (PagedTopic)this.get_Module();
        while (laSubscription.exists(lSubscriptionId = service.getSUIDRange(4, 1))) {
        }
        return lSubscriptionId;
    }

    public long getCacheId(String sTopicName, PagedTopicCaches.Names name) {
        String sCacheName = name.cacheNameForTopicName(sTopicName);
        Grid.ServiceConfig.Map mapConfig = this.getServiceConfigMap();
        XmlElement xmlCacheInfo = (XmlElement)mapConfig.get(sCacheName);
        return xmlCacheInfo == null ? 0L : xmlCacheInfo.getAttribute("id").getLong();
    }

    public ChannelAllocationStrategy getChannelAllocationStrategy() {
        return this.__m_ChannelAllocationStrategy;
    }

    @Override
    public int getChannelCount(String sName) {
        int cChannelMap = this.getChannelCountFromConfigMap(sName);
        int cChannelConfig = this.getConfiguredChannelCount(sName);
        return Math.max(cChannelMap, cChannelConfig);
    }

    protected int getConfiguredChannelCount(String sName) {
        PagedTopicBackingMapManager mgr = this.getTopicBackingMapManager();
        PagedTopicDependencies deps = mgr.getTopicDependencies(sName);
        return deps.getConfiguredChannelCount();
    }

    public TaskDaemon getChannelCountExecutor() {
        TaskDaemon daemon = this.__m_ChannelCountExecutor;
        if (daemon == null) {
            daemon = new TaskDaemon("PagedTopic:" + this.getServiceName() + ":ChannelCountExecutor", 5, true);
            this.setChannelCountExecutor(daemon);
        }
        return daemon;
    }

    public int getChannelCountFromConfigMap(String sName) {
        String sCacheName = PagedTopicCaches.Names.CONTENT.cacheNameForTopicName(sName);
        XmlElement xmlElement = (XmlElement)this.getServiceConfigMap().get(sCacheName);
        return xmlElement == null ? 0 : xmlElement.getSafeAttribute("channels").getInt();
    }

    @Override
    public ServiceConfig.Map getConfigMap(int nMapType) {
        if (nMapType == 3) {
            return this.getTopicConfigMap();
        }
        return super.getConfigMap(nMapType);
    }

    @Override
    public MemberSet getConfigMapUpdateMembers(ServiceConfig.Map map) {
        MemberSet setMember = super.getConfigMapUpdateMembers(map);
        if (map.getMapType() == 3 && setMember.size() != 0) {
            Iterator it = setMember.iterator();
            while (it.hasNext()) {
                Member member = (Member)it.next();
                if (this.isVersionCompatible(member, 22, 6, 4)) continue;
                it.remove();
            }
        }
        return setMember;
    }

    public ScopedTopicReferenceStore getScopedTopicStore() {
        return this.__m_ScopedTopicStore;
    }

    public Set getSubscriberGroups(String sTopicName) {
        return PagedTopicConfigMap.getSubscriberGroups(this.getTopicConfigMap(), sTopicName);
    }

    public Set getSubscribers(String sTopicName, SubscriberGroupId groupId) {
        return PagedTopicConfigMap.getSubscribers(this.getTopicConfigMap(), sTopicName, groupId);
    }

    @Override
    public boolean hasSubscribers(String sTopicName) {
        return PagedTopicConfigMap.hasSubscriptions(this.getTopicConfigMap(), sTopicName);
    }

    @Override
    public long getSubscriptionCount(String sTopicName) {
        return PagedTopicConfigMap.getSubscriptionCount(this.getTopicConfigMap(), sTopicName);
    }

    @Override
    public PagedTopicSubscription getSubscription(long lSubscriptionId) {
        LongArray aSubscription = this.getSubscriptionArray();
        return (PagedTopicSubscription)aSubscription.get(lSubscriptionId);
    }

    public PagedTopicSubscription getSubscription(String sTopicName, SubscriberGroupId groupId) {
        if (groupId == null) {
            return null;
        }
        return PagedTopicConfigMap.getSubscription(this.getTopicConfigMap(), sTopicName, groupId);
    }

    public LongArray getSubscriptionArray() {
        return this.__m_SubscriptionArray;
    }

    public Map getSubscriptionGraveyard() {
        return this.__m_SubscriptionGraveyard;
    }

    @Override
    public long getSubscriptionId(String sTopicName, SubscriberGroupId groupId) {
        return PagedTopicConfigMap.getSubscriptionId(this.getTopicConfigMap(), sTopicName, groupId);
    }

    public long getSubscriptionId(String sTopicName, String sGroupName) {
        return 0L;
    }

    public ReentrantLock getSubscriptionLock() {
        return this.__m_SubscriptionLock;
    }

    @Override
    public PagedTopicBackingMapManager getTopicBackingMapManager() {
        return (PagedTopicBackingMapManager)this.getBackingMapManager();
    }

    public TopicConfig.Map getTopicConfigMap() {
        TopicConfig.Map map = this.__m_TopicConfigMap;
        if (map == null) {
            map = (TopicConfig.Map)((TopicConfig)this._findChild("TopicConfig")).getMap();
            this.setTopicConfigMap(map);
        }
        return map;
    }

    public Set getTopicNames() {
        return PagedTopicConfigMap.getTopicNames(this.getTopicConfigMap());
    }

    @Override
    public PagedTopicStatistics getTopicStatistics(String sTopicName) {
        return this.getTopicBackingMapManager().getStatistics(sTopicName);
    }

    public ReentrantLock getTopicStoreLock() {
        return this.__m_TopicStoreLock;
    }

    @Override
    public boolean hasSubscription(long lSubscriptionId) {
        LongArray aSubscription = this.getSubscriptionArray();
        return aSubscription != null && aSubscription.exists(lSubscriptionId);
    }

    @Override
    public boolean isCompatibleServiceType(String sType) {
        return this.getServiceType().equals(sType) || "DistributedCache".equals(sType);
    }

    @Override
    public boolean isSubscriptionDestroyed(long lSubscriptionId) {
        return this.getSubscriptionGraveyard().containsKey(lSubscriptionId);
    }

    public boolean isTopicsApiVersionCompatible(MemberSet setMembers, int nVersion) {
        MasterMemberSet setMaster = this.getClusterMemberSet();
        switch (setMembers.size()) {
            case 0: {
                return true;
            }
            case 1: {
                return this.isTopicsApiVersionCompatible(setMembers.getFirstId(), nVersion);
            }
        }
        int[] anMember = setMembers.toIdArray();
        int c = anMember.length;
        for (int i = 0; i < c; ++i) {
            if (this.getTopicsApiVersion(anMember[i]) >= nVersion) continue;
            return false;
        }
        return true;
    }

    public boolean isTopicsApiVersionCompatible(Member member, int nVersion) {
        return this.isTopicsApiVersionCompatible(member.getId(), nVersion);
    }

    public boolean isTopicsApiVersionCompatible(int nMemberId, int nVersion) {
        return this.getTopicsApiVersion(nMemberId) >= nVersion;
    }

    public int getTopicsApiVersion(int nMemberId) {
        MasterMemberSet memberSet = this.getClusterMemberSet();
        int nVersion = memberSet.getServiceVersionInt(nMemberId);
        if (nVersion < VERSION_22_06_3 || nVersion == VERSION_22_09_0) {
            return 0;
        }
        if (nVersion <= VERSION_22_06_5 || nVersion == VERSION_23_03_0 || nVersion == VERSION_23_03_1) {
            return 1;
        }
        return 2;
    }

    @Override
    protected void onExit() {
        this.getTopicConfigMap().getConfig().removeConfigListener();
        super.onExit();
    }

    @Override
    protected void onFinalizeStartup() {
        super.onFinalizeStartup();
        ServiceDispatcher dispatcher = this.getEventsHelper().getServiceDispatcher();
        if (dispatcher != null) {
            TransferInterceptor interceptor = new TransferInterceptor(this);
            dispatcher.addEventInterceptor("$Recovery$", interceptor, Set.of(TransferEvent.Type.RECOVERED, TransferEvent.Type.ARRIVED), true);
        }
        this.ensureKnownTopics();
    }

    @Override
    public void onInit() {
        super.onInit();
        this.setChannelAllocationStrategy(new SimpleChannelAllocationStrategy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOwnershipSeniority(Member memberPreviousSenior) {
        super.onOwnershipSeniority(memberPreviousSenior);
        this.cleanupSubscribers();
        ReentrantLock lock = this.getSubscriptionLock();
        lock.lock();
        try {
            TopicConfig.Map configMap = this.getTopicConfigMap();
            ChannelAllocationStrategy strategy = this.getChannelAllocationStrategy();
            for (String sTopic : PagedTopicConfigMap.getTopicNames(configMap)) {
                int cChannel = this.getChannelCount(sTopic);
                PagedTopicConfigMap.setChannelCount(configMap, sTopic, cChannel, strategy);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void onNotifyServiceLeft(Member member) {
        super.onNotifyServiceLeft(member);
        this.cleanupSubscribers();
    }

    public void cleanupSubscribers() {
        Member memberCoordinator;
        Member memberThis = this.getThisMember();
        if (memberThis == (memberCoordinator = this.getServiceOldestMember())) {
            Daemons.commonPool().add(() -> {
                try {
                    HashSet<UUID> setUuid = new HashSet<UUID>();
                    ServiceMemberSet memberSet = this.getServiceMemberSet();
                    for (int nId : memberSet.toIdArray()) {
                        Member member = memberSet.getMember(nId);
                        if (member == null) continue;
                        setUuid.add(member.getUuid());
                    }
                    TopicConfig.Map configMap = this.getTopicConfigMap();
                    Map<String, Map<PagedTopicConfigMap.SubscriptionAndGroup, Set<SubscriberId>>> mapDeparted = PagedTopicConfigMap.getDepartedSubscriptions(configMap, setUuid);
                    if (!mapDeparted.isEmpty()) {
                        for (Map.Entry<String, Map<PagedTopicConfigMap.SubscriptionAndGroup, Set<SubscriberId>>> entry : mapDeparted.entrySet()) {
                            String sTopicName = entry.getKey();
                            for (Map.Entry<PagedTopicConfigMap.SubscriptionAndGroup, Set<SubscriberId>> entrySub : entry.getValue().entrySet()) {
                                PagedTopicConfigMap.SubscriptionAndGroup sg = entrySub.getKey();
                                long lSubscriptionId = sg.getSubscriptionId();
                                SubscriberGroupId groupId = sg.getSubscriberGroupId();
                                for (SubscriberId id : entrySub.getValue()) {
                                    this.notifySubscriberClosed(sTopicName, groupId, lSubscriptionId, id);
                                }
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    Logger.err(t);
                }
            });
        }
    }

    void notifySubscriberClosed(String sTopicName, SubscriberGroupId subscriberGroupId, long lSubscriptionId, SubscriberId subscriberId) {
        block10: {
            PagedTopicSubscription subscription;
            String sCacheName = PagedTopicCaches.Names.SUBSCRIPTIONS.cacheNameForTopicName(sTopicName);
            long lCacheId = this.getCacheId(sTopicName, PagedTopicCaches.Names.SUBSCRIPTIONS);
            Map mapRefsBinary = this.getReferencesBinaryMap();
            BinaryMap mapBinary = (BinaryMap)mapRefsBinary.get(sCacheName);
            if (mapBinary == null) {
                mapBinary = (BinaryMap)this.ensureBinaryMap(sCacheName, lCacheId);
            }
            if (mapBinary == null || !mapBinary.isActive()) {
                return;
            }
            if (lSubscriptionId == 0L) {
                lSubscriptionId = this.getSubscriptionId(sTopicName, subscriberGroupId);
            }
            if ((subscription = this.getSubscription(lSubscriptionId)) != null && subscription.hasSubscriber(subscriberId)) {
                this.destroySubscription(lSubscriptionId, subscriberId);
            }
            try {
                int cParts = this.getPartitionCount();
                ArrayList<Subscription.Key> listSubParts = new ArrayList<Subscription.Key>(cParts);
                for (int i = 0; i < cParts; ++i) {
                    listSubParts.add(new Subscription.Key(i, 0, subscriberGroupId));
                }
                if (mapBinary.isActive()) {
                    try {
                        mapBinary.invokeAll(listSubParts, (InvocableMap.EntryProcessor)new CloseSubscriptionProcessor(subscriberId));
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable t) {
                if (!mapBinary.isActive()) break block10;
                String sId = SubscriberId.NullSubscriber.equals(subscriberId) ? "<ALL>" : PagedTopicSubscriber.idToString(subscriberId.getId());
                Logger.fine("Caught exception closing subscription for subscriber " + sId + " in group " + subscriberGroupId.getGroupName(), t);
            }
        }
    }

    @Override
    public void onServiceStarted() {
        this.getTopicConfigMap().getConfig().attachConfigListener();
        long cExpiry = ((Cluster)this.getCluster()).getClusterService().getDeliveryTimeoutMillis();
        this.setSubscriptionGraveyard(new LocalCache(Integer.MAX_VALUE, (int)cExpiry));
        super.onServiceStarted();
    }

    public void onSetChannelCountRequest(SetChannelCountRequest msgRequest) {
        int cRequired = msgRequest.getRequiredCount();
        String sTopic = msgRequest.getTopicName();
        int cConfigMap = this.getChannelCountFromConfigMap(sTopic);
        if (cConfigMap == 0) {
            int cActual = this.getChannelCount(sTopic);
        } else {
            int cActual = cConfigMap;
        }
        if (cRequired > cConfigMap) {
            EnsureChannelCountTask task = (EnsureChannelCountTask)this._newChild("EnsureChannelCountTask");
            task.setTopicName(sTopic);
            task.setRequiredChannelCount(cRequired);
            task.setChannelCount(msgRequest.getChannelCount());
            task.setMember(msgRequest.getFromMember());
            this.getChannelCountExecutor().executeTask(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChannelCount(EnsureChannelCountTask task) {
        block11: {
            String sTopic = task.getTopicName();
            int cRequired = task.getRequiredChannelCount();
            int cChannel = task.getChannelCount();
            int cConfigMap = this.getChannelCountFromConfigMap(sTopic);
            int cActual = cConfigMap == 0 ? this.getChannelCount(sTopic) : cConfigMap;
            if (cRequired > cConfigMap) {
                ReentrantLock lock = this.getTopicStoreLock();
                lock.lock();
                try {
                    cConfigMap = this.getChannelCountFromConfigMap(sTopic);
                    if (cRequired <= cConfigMap) break block11;
                    String sServiceName = this.getServiceName();
                    boolean fSuspend = !this.isSuspendedFully();
                    try {
                        if (fSuspend) {
                            ((Cluster)this.getCluster()).suspendService(sServiceName, true);
                        }
                        String sCacheName = PagedTopicCaches.Names.CONTENT.cacheNameForTopicName(sTopic);
                        Grid.ServiceConfig.Map map = this.getServiceConfigMap();
                        XmlElement xmlElement = (XmlElement)map.get(sCacheName);
                        XmlValue xmlChannels = xmlElement.getAttribute("channels");
                        if (xmlChannels == null) {
                            xmlChannels = xmlElement.addAttribute("channels");
                        }
                        xmlChannels.setInt(cChannel);
                        map.put(sCacheName, xmlElement);
                        if (cConfigMap != cChannel) {
                            Logger.config("Increased channel count for topic \"" + sTopic + "\" from " + cActual + " to " + cChannel + " requested by " + String.valueOf(task.getMember()));
                        }
                        PagedTopicConfigMap.setChannelCount(this.getTopicConfigMap(), sTopic, cChannel, this.getChannelAllocationStrategy());
                    }
                    finally {
                        if (fSuspend) {
                            this.getCluster().resumeService(sServiceName);
                        }
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    public void onChannelCountConfirmRequest(ChannelCountConfirmRequest request) {
        int cActual;
        int cRequired = request.getChannelCount();
        String sTopic = request.getTopicName();
        int cConfigMap = this.getChannelCountFromConfigMap(sTopic);
        boolean fHasCount = cConfigMap == 0 ? (cActual = this.getChannelCount(sTopic)) >= cRequired : cConfigMap >= cRequired;
        PartitionedCache.PartialValueResponse msgResponse = (PartitionedCache.PartialValueResponse)this.instantiateMessage("PartialValueResponse");
        msgResponse.respondTo(request);
        PartitionSet partsMask = request.getRequestMaskSafe();
        if (fHasCount) {
            partsMask.remove(this.collectOwnedPartitions(true));
            msgResponse.setResult(Boolean.TRUE);
        }
        msgResponse.setRejectPartitions(partsMask);
        this.post(msgResponse);
    }

    public void onSubscriberConfirm(SubscriberConfirmRequest request) {
        PartitionedCache.PartialValueResponse msgResponse = (PartitionedCache.PartialValueResponse)this.instantiateMessage("PartialValueResponse");
        msgResponse.respondTo(request);
        PartitionSet partsMask = request.getRequestMaskSafe();
        long lSubscriptionId = request.getSubscriptionId();
        SubscriberId subscriberId = request.getSubscriberId();
        PagedTopicSubscription subscription = this.getSubscription(lSubscriptionId);
        if (subscription == null) {
            if (this.getSubscriptionGraveyard().containsKey(lSubscriptionId)) {
                partsMask.clear();
                msgResponse.setException(new RequestPolicyException("Group \"" + String.valueOf(request.getGroupId()) + "\" (id=" + lSubscriptionId + ") has been concurrently destroyed"));
            }
        } else if (subscriberId == null || subscription.hasSubscriber(subscriberId)) {
            partsMask.remove(this.collectOwnedPartitions(true));
            msgResponse.setResult(Boolean.TRUE);
        }
        msgResponse.setRejectPartitions(partsMask);
        this.post(msgResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onSubscriberId(SubscriberIdRequest request) {
        long lSubscriptionId = request.getSubscriptionId();
        Object[] aSubscriberId = request.getSubscriberIds();
        String sTopicName = request.getTopicName();
        Grid.Response msgResponse = (Grid.Response)this.instantiateMessage("Response");
        msgResponse.respondTo(request);
        Member memberThis = this.getThisMember();
        Member memberFrom = request.getFromMember();
        Member memberCoordinator = this.getServiceOldestMember();
        if (memberThis == memberCoordinator) {
            ReentrantLock lock = this.getSubscriptionLock();
            lock.lock();
            try {
                TopicConfig.Map configMap = this.getTopicConfigMap();
                msgResponse.respondTo(request);
                PagedTopicSubscription subscription = null;
                switch (request.getSubscriberAction()) {
                    case 1: {
                        Filter filter = request.getFilter();
                        ValueExtractor converter = request.getConverter();
                        if (lSubscriptionId == 0L) {
                            SubscriberGroupId groupId = request.getGroupId();
                            subscription = this.ensureSubscriptionInternal(sTopicName, groupId, lSubscriptionId, filter, converter);
                        } else {
                            subscription = this.getSubscription(lSubscriptionId);
                        }
                        if (subscription != null) {
                            try {
                                subscription.assertFilterAndConverter(filter, converter);
                                if (aSubscriberId.length > 0) {
                                    if (subscription.addSubscribers((SubscriberId[])aSubscriberId) || subscription.getChannelCount() != this.getChannelCount(sTopicName)) {
                                        subscription.updateChannelAllocations(this.getChannelAllocationStrategy(), this.getChannelCount(subscription.getTopicName()));
                                        Logger.finest("Added subscribers " + Arrays.toString(aSubscriberId) + " to subscription " + String.valueOf(subscription));
                                        PagedTopicConfigMap.updateSubscription(configMap, subscription);
                                    }
                                } else {
                                    PagedTopicConfigMap.updateSubscription(configMap, subscription);
                                }
                                msgResponse.setResult(0);
                                msgResponse.setValue(subscription.getSubscriptionId());
                            }
                            catch (TopicException error) {
                                msgResponse.setResult(2);
                                msgResponse.setValue(error);
                            }
                        } else {
                            String sReason = this.isSubscriptionDestroyed(lSubscriptionId) ? "has been destroyed" : "is invalid";
                            IllegalStateException error = new IllegalStateException("The subscriber group id=" + lSubscriptionId + ") " + sReason);
                            msgResponse.setResult(2);
                            msgResponse.setValue(error);
                        }
                        this.post(msgResponse);
                        return;
                    }
                    case 2: {
                        subscription = this.getSubscription(lSubscriptionId);
                        if (subscription != null) {
                            if (aSubscriberId.length == 0) {
                                this.destroySubscriptionInternal(lSubscriptionId);
                                PagedTopicConfigMap.removeSubscription(configMap, subscription.getKey());
                                Logger.finest("Destroyed subscription " + String.valueOf(subscription.getKey()));
                            } else if (aSubscriberId.length == 1 && SubscriberId.NullSubscriber.equals(aSubscriberId[0])) {
                                if (subscription.removeAllSubscribers()) {
                                    Logger.finest("Removed all subscribers from subscription " + String.valueOf(subscription.getKey()));
                                    PagedTopicConfigMap.updateSubscription(configMap, subscription);
                                }
                            } else if (subscription.removeSubscribers((SubscriberId[])aSubscriberId)) {
                                subscription.updateChannelAllocations(this.getChannelAllocationStrategy());
                                PagedTopicConfigMap.updateSubscription(configMap, subscription);
                                Logger.finest("Removed subscribers from " + Arrays.toString(aSubscriberId) + " from subscription " + String.valueOf(subscription.getKey()));
                            }
                        }
                        msgResponse.setResult(0);
                        msgResponse.setValue(lSubscriptionId);
                        this.post(msgResponse);
                        return;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            finally {
                lock.unlock();
            }
        } else if (this.isVersionCompatible(memberCoordinator, 22, 6, 4)) {
            SubscriberIdRequest msg = (SubscriberIdRequest)request.cloneMessage();
            msg.addToMember(memberCoordinator);
            msg.setResponse(msgResponse);
            this.post(msg);
            return;
        } else {
            msgResponse.setResult(0);
            msgResponse.setValue(-1L);
            this.post(msgResponse);
        }
    }

    @Override
    public void releaseTopic(NamedTopic topic) {
        ReentrantLock lock = this.getTopicStoreLock();
        lock.lock();
        try {
            this.getScopedTopicStore().releaseTopic(topic);
            MBeanHelper.unregisterPagedTopicMBean((Service)this, topic);
        }
        finally {
            lock.unlock();
        }
        topic.release();
    }

    @Override
    public Storage removeStorage(long lCacheId) {
        String sName;
        Storage storage = super.removeStorage(lCacheId);
        if (storage != null && this.isOwnershipEnabled() && PagedTopicCaches.Names.CONTENT.isA(sName = storage.getCacheName())) {
            String sTopicName = PagedTopicCaches.Names.getTopicName(sName);
            MBeanHelper.unregisterPagedTopicMBean((Service)this, sTopicName);
        }
        return storage;
    }

    public void setChannelAllocationStrategy(ChannelAllocationStrategy strategyAllocation) {
        this.__m_ChannelAllocationStrategy = strategyAllocation;
    }

    public void setChannelCountExecutor(TaskDaemon daemonExecutor) {
        this.__m_ChannelCountExecutor = daemonExecutor;
    }

    public void setScopedTopicStore(ScopedTopicReferenceStore sProperty) {
        this.__m_ScopedTopicStore = sProperty;
    }

    public void setSubscriptionArray(LongArray arraySubscription) {
        this.__m_SubscriptionArray = arraySubscription;
    }

    public void setSubscriptionGraveyard(Map mapGraveyard) {
        this.__m_SubscriptionGraveyard = mapGraveyard;
    }

    public void setSubscriptionLock(ReentrantLock lockSubscription) {
        this.__m_SubscriptionLock = lockSubscription;
    }

    public void setTopicConfigMap(TopicConfig.Map mapConfig) {
        this.__m_TopicConfigMap = mapConfig;
    }

    public void setTopicStoreLock(ReentrantLock lockStore) {
        this.__m_TopicStoreLock = lockStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        ReentrantLock lock = this.getTopicStoreLock();
        lock.lock();
        try {
            ScopedTopicReferenceStore store = this.getScopedTopicStore();
            Collection topics = store.getAll();
            for (NamedTopic topic : topics) {
                store.releaseTopic(topic);
            }
        }
        finally {
            lock.unlock();
        }
    }

    static {
        VERSION_22_06_3 = MasterMemberSet.encodeVersion(22, 6, 3);
        VERSION_22_06_4 = MasterMemberSet.encodeVersion(22, 6, 4);
        VERSION_22_06_5 = MasterMemberSet.encodeVersion(22, 6, 5);
        VERSION_22_09_0 = MasterMemberSet.encodeVersion(22, 9, 0);
        VERSION_23_03_0 = MasterMemberSet.encodeVersion(23, 3, 0);
        VERSION_23_03_1 = MasterMemberSet.encodeVersion(23, 3, 1);
        VERSION_23_03_2 = MasterMemberSet.encodeVersion(23, 3, 2);
        PagedTopic.__initStatic();
    }

    public static class BinaryMap
    extends com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.partitionedCache.BinaryMap {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Entry", BinaryMap.Entry.get_CLASS());
            __mapChildren.put("EntryAdvancer", BinaryMap.EntryAdvancer.get_CLASS());
            __mapChildren.put("KeyAdvancer", BinaryMap.KeyAdvancer.get_CLASS());
            __mapChildren.put("KeyRequestStatus", BinaryMap.KeyRequestStatus.get_CLASS());
            __mapChildren.put("KeySetRequestStatus", BinaryMap.KeySetRequestStatus.get_CLASS());
            __mapChildren.put("MapRequestStatus", BinaryMap.MapRequestStatus.get_CLASS());
            __mapChildren.put("PartialRequestStatus", BinaryMap.PartialRequestStatus.get_CLASS());
        }

        public BinaryMap() {
            this(null, null, true);
        }

        public BinaryMap(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setFilterArray(new SparseArray());
                this.setListenerSupport(new MapListenerSupport());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new BinaryMap.EntrySet("EntrySet", this, true), "EntrySet");
            this._addChild(new BinaryMap.KeySet("KeySet", this, true), "KeySet");
            this._addChild(new BinaryMap.Values("Values", this, true), "Values");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new BinaryMap();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/PagedTopic$BinaryMap".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public boolean confirmSubscriber(long lSubscriptionId, SubscriberId subscriberId) {
            SubscriberConfirmRequest msg = (SubscriberConfirmRequest)this.getService().instantiateMessage("SubscriberConfirmRequest");
            msg.setCacheId(this.getCacheId());
            msg.setSubscriptionId(lSubscriptionId);
            msg.setSubscriberId(subscriberId);
            try {
                this.mergePartialResponse(this.sendPartitionedRequest(msg, this.makePartitionSet(), true));
            }
            catch (RequestPolicyException e) {
                return false;
            }
            return true;
        }

        protected boolean confirmChannelCount(String sTopicName, int cChannel) {
            MemberSet memberSet;
            PagedTopic service = (PagedTopic)this.getService();
            if (service.isTopicsApiVersionCompatible(memberSet = service.getOwnershipMemberSet(), 2)) {
                ChannelCountConfirmRequest msg = (ChannelCountConfirmRequest)this.getService().instantiateMessage("ChannelCountConfirmRequest");
                msg.setCacheId(this.getCacheId());
                msg.setTopicName(sTopicName);
                msg.setChannelCount(cChannel);
                try {
                    this.mergePartialResponse(this.sendPartitionedRequest(msg, this.makePartitionSet(), true));
                }
                catch (RequestPolicyException e) {
                    return false;
                }
                return true;
            }
            return true;
        }

        static {
            BinaryMap.__initStatic();
        }
    }

    public static class ChannelCountConfirmRequest
    extends PartialRequest {
        private int m_cChannel;
        private String m_sTopicName;
        public static final int MESSAGE_TYPE = 1003;
        private static ListMap s_mapChildren;

        private static void __initStatic() {
            s_mapChildren = new ListMap();
            s_mapChildren.put("Poll", Poll.get_CLASS());
        }

        public ChannelCountConfirmRequest() {
            this(null, null, true);
        }

        public ChannelCountConfirmRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(1003);
            }
            catch (Exception e) {
                throw Exceptions.ensureRuntimeException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ChannelCountConfirmRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/PagedTopic$ChannelCountConfirmRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return s_mapChildren;
        }

        @Override
        public Message cloneMessage() {
            ChannelCountConfirmRequest msg = (ChannelCountConfirmRequest)super.cloneMessage();
            msg.m_sTopicName = this.m_sTopicName;
            msg.m_cChannel = this.m_cChannel;
            return msg;
        }

        public int getChannelCount() {
            return this.m_cChannel;
        }

        public void setChannelCount(int cChannel) {
            this.m_cChannel = cChannel;
        }

        public String getTopicName() {
            return this.m_sTopicName;
        }

        public void setTopicName(String sTopicName) {
            this.m_sTopicName = sTopicName;
        }

        @Override
        public void onReceived() {
            ((PagedTopic)this.getService()).onChannelCountConfirmRequest(this);
        }

        @Override
        public boolean preprocess() {
            return false;
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.m_sTopicName = ExternalizableHelper.readSafeUTF(input);
            this.m_cChannel = ExternalizableHelper.readInt(input);
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            ExternalizableHelper.writeSafeUTF(output, this.m_sTopicName);
            ExternalizableHelper.writeInt(output, this.m_cChannel);
        }

        static {
            ChannelCountConfirmRequest.__initStatic();
        }

        public static class Poll
        extends PartialRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/PagedTopic$ChannelCountConfirmRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class EnsureChannelCountTask
    extends Component
    implements Runnable {
        private int __m_ChannelCount;
        private Member __m_Member;
        private int __m_RequiredChannelCount;
        private String __m_TopicName;

        public EnsureChannelCountTask() {
            this(null, null, true);
        }

        public EnsureChannelCountTask(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new EnsureChannelCountTask();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/PagedTopic$EnsureChannelCountTask".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public int getChannelCount() {
            return this.__m_ChannelCount;
        }

        public Member getMember() {
            return this.__m_Member;
        }

        public int getRequiredChannelCount() {
            return this.__m_RequiredChannelCount;
        }

        public PagedTopic getService() {
            return (PagedTopic)this.get_Module();
        }

        public String getTopicName() {
            return this.__m_TopicName;
        }

        @Override
        public void run() {
            PagedTopic service = this.getService();
            service.onChannelCount(this);
        }

        public void setChannelCount(int nCount) {
            this.__m_ChannelCount = nCount;
        }

        public void setMember(Member member) {
            this.__m_Member = member;
        }

        public void setRequiredChannelCount(int nCount) {
            this.__m_RequiredChannelCount = nCount;
        }

        public void setTopicName(String sName) {
            this.__m_TopicName = sName;
        }

        @Override
        public String toString() {
            return "EnsureChannelCountTask(topic=" + this.getTopicName() + ", requiredCount=" + this.getRequiredChannelCount() + ", channelCount=" + this.getChannelCount() + ")";
        }
    }

    public static class MemberWelcome
    extends PartitionedCache.MemberWelcome {
        private Map __m_TopicConfigMap;

        public MemberWelcome() {
            this(null, null, true);
        }

        public MemberWelcome(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-2);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MemberWelcome();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/PagedTopic$MemberWelcome".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return super.getDescription() + ", TopicConfig=" + String.valueOf(this.getTopicConfigMap());
        }

        public Map getTopicConfigMap() {
            return this.__m_TopicConfigMap;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            PagedTopic service = (PagedTopic)this.getService();
            Map mapConfig = this.getTopicConfigMap();
            MemberWelcome._trace("Received MemberWelcome from member " + this.getFromMember().getId() + ", topicConfigMap: " + String.valueOf(mapConfig), 7);
            if (mapConfig != null) {
                service.getTopicConfigMap().updateInternal(mapConfig, false);
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            if (this.isRejected()) {
                return;
            }
            PagedTopic service = (PagedTopic)this.getService();
            try {
                boolean fTopicConfig;
                HashMap<Object, Object> mapConfig = new HashMap<Object, Object>();
                boolean bl = fTopicConfig = input.available() > 0 && input.readBoolean();
                if (fTopicConfig) {
                    ServiceConfig cfgTopic = service.getTopicConfigMap().getConfig();
                    int c = input.readInt();
                    for (int i = 0; i < c; ++i) {
                        Object oKey = cfgTopic.readObject(input);
                        Object oValue = cfgTopic.readObject(input);
                        mapConfig.put(oKey, oValue);
                    }
                }
                this.setTopicConfigMap(mapConfig);
            }
            catch (IOException e) {
                service.onConfigIOException(e, this.getFromMember());
            }
        }

        public void setTopicConfigMap(Map mapConfig) {
            this.__m_TopicConfigMap = mapConfig;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            if (this.isRejected()) {
                return;
            }
            PagedTopic service = (PagedTopic)this.getService();
            Map mapConfig = this.getTopicConfigMap();
            if (mapConfig == null) {
                output.writeBoolean(false);
            } else {
                ServiceConfig cfgTopic = service.getTopicConfigMap().getConfig();
                output.writeBoolean(true);
                output.writeInt(mapConfig.size());
                for (Map.Entry entry : mapConfig.entrySet()) {
                    cfgTopic.writeObject(output, entry.getKey());
                    cfgTopic.writeObject(output, entry.getValue());
                }
            }
        }
    }

    public static class MemberWelcomeRequest
    extends PartitionedCache.MemberWelcomeRequest {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", PartitionedCache.MemberWelcomeRequest.Poll.get_CLASS());
        }

        public MemberWelcomeRequest() {
            this(null, null, true);
        }

        public MemberWelcomeRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-1);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MemberWelcomeRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/PagedTopic$MemberWelcomeRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        protected Grid.MemberWelcome populateWelcomeMessage() {
            MemberWelcome msgWelcome = (MemberWelcome)super.populateWelcomeMessage();
            if (!msgWelcome.isRejected()) {
                PagedTopic service = (PagedTopic)this.getService();
                TopicConfig.Map mapTopicConfig = service.getTopicConfigMap();
                if (service.getThisMember() == mapTopicConfig.getConfigCoordinator()) {
                    msgWelcome.setTopicConfigMap(mapTopicConfig);
                }
            }
            return msgWelcome;
        }

        static {
            MemberWelcomeRequest.__initStatic();
        }
    }

    public static class SetChannelCountRequest
    extends RequestMessage {
        private int __m_ChannelCount;
        private int __m_RequiredCount;
        public static final int MESSAGE_TYPE = 1000;
        private String __m_TopicName;

        public SetChannelCountRequest() {
            this(null, null, true);
        }

        public SetChannelCountRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(1000);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new SetChannelCountRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/PagedTopic$SetChannelCountRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public Message cloneMessage() {
            SetChannelCountRequest msg = (SetChannelCountRequest)super.cloneMessage();
            msg.setTopicName(this.getTopicName());
            msg.setChannelCount(this.getChannelCount());
            msg.setRequiredCount(this.getRequiredCount());
            return msg;
        }

        public int getChannelCount() {
            return this.__m_ChannelCount;
        }

        public int getRequiredCount() {
            return this.__m_RequiredCount;
        }

        public String getTopicName() {
            return this.__m_TopicName;
        }

        @Override
        public void onReceived() {
            PagedTopic service = (PagedTopic)this.getService();
            service.onSetChannelCountRequest(this);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setTopicName(input.readUTF());
            this.setRequiredCount(ExternalizableHelper.readInt(input));
            this.setChannelCount(ExternalizableHelper.readInt(input));
        }

        public void setChannelCount(int nCount) {
            this.__m_ChannelCount = nCount;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        public void setRequiredCount(int nCount) {
            this.__m_RequiredCount = nCount;
        }

        public void setTopicName(String sName) {
            this.__m_TopicName = sName;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeUTF(this.getTopicName());
            ExternalizableHelper.writeInt(output, this.getRequiredCount());
            ExternalizableHelper.writeInt(output, this.getChannelCount());
        }
    }

    public static class StorageIdRequest
    extends PartitionedCache.StorageIdRequest {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", PartitionedCache.StorageIdRequest.Poll.get_CLASS());
        }

        public StorageIdRequest() {
            this(null, null, true);
        }

        public StorageIdRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(78);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new StorageIdRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/PagedTopic$StorageIdRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            PagedTopic service = (PagedTopic)this.getService();
            TopicConfig.Map mapConfig = service.getTopicConfigMap();
            String[] asCacheNames = this.getCacheNames();
            Member memberThis = service.getThisMember();
            Member memberCoordinator = service.getServiceOldestMember();
            if (memberThis == memberCoordinator) {
                switch (this.getCacheAction()) {
                    case 1: {
                        HashMap<String, XmlElement> mapXml = null;
                        int cNames = asCacheNames.length;
                        for (int i = 0; i < cNames; ++i) {
                            String sTopicName;
                            XmlElement xmlTopicInfo;
                            String sCacheName = asCacheNames[i];
                            if (sCacheName == null || (xmlTopicInfo = (XmlElement)mapConfig.get(sTopicName = PagedTopicCaches.Names.getTopicName(sCacheName))) != null) continue;
                            xmlTopicInfo = new SimpleElement("topic-info");
                            if (mapXml == null) {
                                mapXml = new HashMap<String, XmlElement>(cNames);
                            }
                            mapXml.put(sTopicName, xmlTopicInfo);
                        }
                        if (mapXml == null) break;
                        mapConfig.putAll(mapXml);
                        break;
                    }
                    case 2: {
                        for (String sCacheName : asCacheNames) {
                            if (sCacheName == null) continue;
                            String sTopicName = PagedTopicCaches.Names.getTopicName(sCacheName);
                            PagedTopicConfigMap.removeTopic(mapConfig, sTopicName);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }

        static {
            StorageIdRequest.__initStatic();
        }
    }

    public static class SubscriberConfirmRequest
    extends PartialRequest {
        private SubscriberGroupId __m_GroupId;
        private SubscriberId __m_SubscriberId;
        private long __m_SubscriptionId;
        private static ListMap __mapChildren;
        public static final int MESSAGE_TYPE = 1002;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public SubscriberConfirmRequest() {
            this(null, null, true);
        }

        public SubscriberConfirmRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(1002);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new SubscriberConfirmRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/PagedTopic$SubscriberConfirmRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            SubscriberConfirmRequest msg = (SubscriberConfirmRequest)super.cloneMessage();
            msg.setSubscriberId(this.getSubscriberId());
            msg.setSubscriptionId(this.getSubscriptionId());
            return msg;
        }

        public SubscriberGroupId getGroupId() {
            return this.__m_GroupId;
        }

        public SubscriberId getSubscriberId() {
            return this.__m_SubscriberId;
        }

        public long getSubscriptionId() {
            return this.__m_SubscriptionId;
        }

        @Override
        public void onReceived() {
            ((PagedTopic)this.getService()).onSubscriberConfirm(this);
        }

        @Override
        public boolean preprocess() {
            return false;
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setSubscriptionId(input.readLong());
            this.setSubscriberId((SubscriberId)ExternalizableHelper.readObject(input));
        }

        public void setGroupId(SubscriberGroupId idGroup) {
            this.__m_GroupId = idGroup;
        }

        public void setSubscriberId(SubscriberId idSubscriber) {
            this.__m_SubscriberId = idSubscriber;
        }

        public void setSubscriptionId(long lId) {
            this.__m_SubscriptionId = lId;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeLong(this.getSubscriptionId());
            ExternalizableHelper.writeObject(output, this.getSubscriberId());
        }

        static {
            SubscriberConfirmRequest.__initStatic();
        }

        public static class Poll
        extends PartialRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/PagedTopic$SubscriberConfirmRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class SubscriberIdRequest
    extends RequestMessage {
        private long[] __m_ChannelAllocations;
        private ValueExtractor __m_Converter;
        private Filter __m_Filter;
        private SubscriberGroupId __m_GroupId;
        private Message __m_Response;
        public static final int SUBSCRIBER_CREATE = 1;
        public static final int SUBSCRIBER_DESTROY = 2;
        public static final int SUBSCRIBER_UPDATE = 3;
        private int __m_SubscriberAction;
        private SubscriberId[] __m_SubscriberIds;
        private long __m_SubscriptionId;
        private String __m_TopicName;
        private static ListMap __mapChildren;
        public static final int MESSAGE_TYPE = 1001;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public SubscriberIdRequest() {
            this(null, null, true);
        }

        public SubscriberIdRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(1001);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new SubscriberIdRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/PagedTopic$SubscriberIdRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            SubscriberIdRequest msg = (SubscriberIdRequest)super.cloneMessage();
            msg.setSubscriberAction(this.getSubscriberAction());
            msg.setTopicName(this.getTopicName());
            msg.setGroupId(this.getGroupId());
            msg.setSubscriberIds(this.getSubscriberIds());
            msg.setSubscriptionId(this.getSubscriptionId());
            msg.setFilter(this.getFilter());
            msg.setConverter(this.getConverter());
            msg.setChannelAllocations(this.getChannelAllocations());
            return msg;
        }

        public long[] getChannelAllocations() {
            return this.__m_ChannelAllocations;
        }

        public long getChannelAllocations(int i) {
            return this.getChannelAllocations()[i];
        }

        public ValueExtractor getConverter() {
            return this.__m_Converter;
        }

        public Filter getFilter() {
            return this.__m_Filter;
        }

        public SubscriberGroupId getGroupId() {
            return this.__m_GroupId;
        }

        public Message getResponse() {
            return this.__m_Response;
        }

        public int getSubscriberAction() {
            return this.__m_SubscriberAction;
        }

        public SubscriberId[] getSubscriberIds() {
            return this.__m_SubscriberIds;
        }

        public SubscriberId getSubscriberIds(int i) {
            return this.getSubscriberIds()[i];
        }

        public long getSubscriptionId() {
            return this.__m_SubscriptionId;
        }

        public String getTopicName() {
            return this.__m_TopicName;
        }

        @Override
        protected com.tangosol.coherence.component.net.Poll instantiatePoll() {
            return (Poll)this._newChild("Poll");
        }

        @Override
        public void onReceived() {
            super.onReceived();
            PagedTopic service = (PagedTopic)this.getService();
            service.onSubscriberId(this);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setTopicName(ExternalizableHelper.readSafeUTF(input));
            this.setGroupId((SubscriberGroupId)ExternalizableHelper.readObject(input));
            this.setSubscriptionId(ExternalizableHelper.readLong(input));
            this.setSubscriberIds((SubscriberId[])ExternalizableHelper.readObject(input));
            this.setSubscriberAction(ExternalizableHelper.readInt(input));
            this.setChannelAllocations((long[])ExternalizableHelper.readObject(input));
            this.setFilter((Filter)ExternalizableHelper.readObject(input));
            this.setConverter((ValueExtractor)ExternalizableHelper.readObject(input));
            this.readTracing(input);
        }

        public void setChannelAllocations(long[] alAllocations) {
            this.__m_ChannelAllocations = alAllocations;
        }

        public void setChannelAllocations(int i, long lAllocations) {
            this.getChannelAllocations()[i] = lAllocations;
        }

        public void setConverter(ValueExtractor extractorConverter) {
            this.__m_Converter = extractorConverter;
        }

        public void setFilter(Filter filter) {
            this.__m_Filter = filter;
        }

        public void setGroupId(SubscriberGroupId idGroup) {
            this.__m_GroupId = idGroup;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        public void setResponse(Message msgResponse) {
            this.__m_Response = msgResponse;
        }

        public void setSubscriberAction(int nAction) {
            this.__m_SubscriberAction = nAction;
        }

        public void setSubscriberIds(SubscriberId[] aidIds) {
            this.__m_SubscriberIds = aidIds;
        }

        public void setSubscriberIds(int i, SubscriberId idIds) {
            this.getSubscriberIds()[i] = idIds;
        }

        public void setSubscriptionId(long lId) {
            this.__m_SubscriptionId = lId;
        }

        public void setTopicName(String sName) {
            this.__m_TopicName = sName;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            ExternalizableHelper.writeSafeUTF(output, this.getTopicName());
            ExternalizableHelper.writeObject(output, this.getGroupId());
            ExternalizableHelper.writeLong(output, this.getSubscriptionId());
            ExternalizableHelper.writeObject(output, this.getSubscriberIds());
            ExternalizableHelper.writeInt(output, this.getSubscriberAction());
            ExternalizableHelper.writeObject(output, this.getChannelAllocations());
            ExternalizableHelper.writeObject(output, this.getFilter());
            ExternalizableHelper.writeObject(output, this.getConverter());
            this.writeTracing(output);
        }

        static {
            SubscriberIdRequest.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/PagedTopic$SubscriberIdRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected void onCompletion() {
                super.onCompletion();
                SubscriberIdRequest msgRequest = (SubscriberIdRequest)this.get_Parent();
                Grid.Response msgResponse = (Grid.Response)msgRequest.getResponse();
                if (msgResponse != null) {
                    PagedTopic service = (PagedTopic)this.getService();
                    Long lSubscriberId = (Long)this.getResult();
                    if (lSubscriberId == null) {
                        if (!service.isExiting() && service.getServiceState() < 3) {
                            SubscriberIdRequest msg = (SubscriberIdRequest)msgRequest.cloneMessage();
                            msg.addToMember(service.getServiceOldestMember());
                            service.post(msg);
                        }
                    } else {
                        msgResponse.setValue(lSubscriberId);
                        service.post(msgResponse);
                    }
                }
            }

            @Override
            public void onResponse(Message msg) {
                Grid.Response response = (Grid.Response)msg;
                this.setResult(response.getValue());
                super.onResponse(msg);
            }
        }
    }

    public static class TopicConfig
    extends ServiceConfig {
        public static final int TYPE_ANY = 0;
        public static final int TYPE_LONG = 1;
        public static final int TYPE_SUBSCRIPTION = 2;
        public static final int TYPE_SUBSCRIPTION_KEY = 3;

        public TopicConfig() {
            this(null, null, true);
        }

        public TopicConfig(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setPendingConfigUpdates(new LinkedList());
                this.setPendingPolls(new LiteMap());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new ConfigListener("ConfigListener", this, true), "ConfigListener");
            this._addChild(new Map("Map", this, true), "Map");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new TopicConfig();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/PagedTopic$TopicConfig".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public Object readObject(DataInput in) throws IOException {
            byte nType = in.readByte();
            switch (nType) {
                case 2: {
                    PagedTopicSubscription subscription = new PagedTopicSubscription();
                    subscription.readExternal(in);
                    return subscription;
                }
                case 3: {
                    PagedTopicSubscription.Key key = new PagedTopicSubscription.Key();
                    key.readExternal(in);
                    return key;
                }
                case 1: {
                    return in.readLong();
                }
                case 0: {
                    return super.readObject(in);
                }
            }
            throw new IOException("invalid type: " + nType);
        }

        @Override
        public void writeObject(DataOutput out, Object o) throws IOException {
            if (o instanceof PagedTopicSubscription) {
                out.write(2);
                ((PagedTopicSubscription)o).writeExternal(out);
            } else if (o instanceof PagedTopicSubscription.Key) {
                out.write(3);
                ((PagedTopicSubscription.Key)o).writeExternal(out);
            } else if (o instanceof Long) {
                out.write(1);
                out.writeLong((Long)o);
            } else {
                out.write(0);
                super.writeObject(out, o);
            }
        }

        public static class ConfigListener
        extends ServiceConfig.ConfigListener {
            public ConfigListener() {
                this(null, null, true);
            }

            public ConfigListener(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ConfigListener();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/PagedTopic$TopicConfig$ConfigListener".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public void entryDeleted(MapEvent evt) {
                super.entryDeleted(evt);
                PagedTopic service = (PagedTopic)this.get_Module();
                Object oKey = evt.getKey();
                if (oKey instanceof PagedTopicSubscription.Key) {
                    PagedTopicSubscription subscription = (PagedTopicSubscription)evt.getOldValue();
                    service.destroySubscriptionInternal(subscription.getSubscriptionId());
                }
            }

            @Override
            public void entryInserted(MapEvent evt) {
                super.entryInserted(evt);
                PagedTopic service = (PagedTopic)this.get_Module();
                Object oKey = evt.getKey();
                if (oKey instanceof PagedTopicSubscription.Key) {
                    PagedTopicSubscription.Key key = (PagedTopicSubscription.Key)oKey;
                    PagedTopicSubscription subscription = (PagedTopicSubscription)evt.getNewValue();
                    service.ensureSubscription(subscription);
                }
            }

            @Override
            public void entryUpdated(MapEvent evt) {
                super.entryUpdated(evt);
                PagedTopic service = (PagedTopic)this.get_Module();
                Object oKey = evt.getKey();
                if (oKey instanceof PagedTopicSubscription.Key) {
                    PagedTopicSubscription.Key key = (PagedTopicSubscription.Key)oKey;
                    PagedTopicSubscription subscription = (PagedTopicSubscription)evt.getNewValue();
                    service.ensureSubscription(subscription);
                }
            }
        }

        public static class Map
        extends ServiceConfig.Map {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("EntrySet", EntrySet.get_CLASS());
                __mapChildren.put("KeySet", KeySet.get_CLASS());
                __mapChildren.put("Values", Values.get_CLASS());
            }

            public Map() {
                this(null, null, true);
            }

            public Map(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Map();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/PagedTopic$TopicConfig$Map".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected java.util.Map get_ChildClasses() {
                return __mapChildren;
            }

            @Override
            public int getMapType() {
                return 3;
            }

            @Override
            public Object updateInternal(Object oKey, Object oValue, boolean fRemove) {
                return super.updateInternal(oKey, oValue, fRemove);
            }

            @Override
            public void updateInternal(java.util.Map mapUpdate, boolean fRemove) {
                super.updateInternal(mapUpdate, fRemove);
            }

            static {
                Map.__initStatic();
            }

            public static class EntrySet
            extends ServiceConfig.Map.EntrySet {
                private static ListMap __mapChildren;

                private static void __initStatic() {
                    __mapChildren = new ListMap();
                    __mapChildren.put("Entry", Entry.get_CLASS());
                    __mapChildren.put("Iterator", Iterator.get_CLASS());
                }

                public EntrySet() {
                    this(null, null, true);
                }

                public EntrySet(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new EntrySet();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/PagedTopic$TopicConfig$Map$EntrySet".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                @Override
                protected java.util.Map get_ChildClasses() {
                    return __mapChildren;
                }

                static {
                    EntrySet.__initStatic();
                }

                public static class Entry
                extends ServiceConfig.Map.EntrySet.Entry {
                    public Entry() {
                        this(null, null, true);
                    }

                    public Entry(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Entry();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/PagedTopic$TopicConfig$Map$EntrySet$Entry".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }

                public static class Iterator
                extends ServiceConfig.Map.EntrySet.Iterator {
                    public Iterator() {
                        this(null, null, true);
                    }

                    public Iterator(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Iterator();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/PagedTopic$TopicConfig$Map$EntrySet$Iterator".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }
            }

            public static class KeySet
            extends ServiceConfig.Map.KeySet {
                private static ListMap __mapChildren;

                private static void __initStatic() {
                    __mapChildren = new ListMap();
                    __mapChildren.put("Iterator", Iterator.get_CLASS());
                }

                public KeySet() {
                    this(null, null, true);
                }

                public KeySet(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new KeySet();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/PagedTopic$TopicConfig$Map$KeySet".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                @Override
                protected java.util.Map get_ChildClasses() {
                    return __mapChildren;
                }

                static {
                    KeySet.__initStatic();
                }

                public static class Iterator
                extends ServiceConfig.Map.KeySet.Iterator {
                    public Iterator() {
                        this(null, null, true);
                    }

                    public Iterator(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Iterator();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/PagedTopic$TopicConfig$Map$KeySet$Iterator".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }
            }

            public static class Values
            extends ServiceConfig.Map.Values {
                private static ListMap __mapChildren;

                private static void __initStatic() {
                    __mapChildren = new ListMap();
                    __mapChildren.put("Iterator", Iterator.get_CLASS());
                }

                public Values() {
                    this(null, null, true);
                }

                public Values(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Values();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/PagedTopic$TopicConfig$Map$Values".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                @Override
                protected java.util.Map get_ChildClasses() {
                    return __mapChildren;
                }

                static {
                    Values.__initStatic();
                }

                public static class Iterator
                extends ServiceConfig.Map.Values.Iterator {
                    public Iterator() {
                        this(null, null, true);
                    }

                    public Iterator(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Iterator();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/PagedTopic$TopicConfig$Map$Values$Iterator".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }
            }
        }
    }

    protected static class TransferInterceptor
    implements EventInterceptor<TransferEvent> {
        private final PagedTopic f_service;

        protected TransferInterceptor(PagedTopic service) {
            this.f_service = service;
        }

        @Override
        public void onEvent(TransferEvent event) {
            Map<String, Set<BinaryEntry>> entries = event.getEntries();
            PagedTopicService service = (PagedTopicService)event.getService();
            for (Map.Entry<String, Set<BinaryEntry>> entry : entries.entrySet()) {
                String sCacheName = entry.getKey();
                if (!PagedTopicCaches.Names.USAGE.equals(PagedTopicCaches.Names.fromCacheName(sCacheName))) continue;
                String sTopic = PagedTopicCaches.Names.getTopicName(sCacheName);
                int cChannel = 0;
                for (BinaryEntry binaryEntry : entry.getValue()) {
                    Usage.Key key = (Usage.Key)binaryEntry.getKey();
                    cChannel = Math.max(cChannel, 1 + key.getChannelId());
                }
                int cActual = service.getChannelCount(sTopic);
                if (cChannel <= cActual) continue;
                int cFinal = cChannel;
                Daemons.commonPool().execute(() -> {
                    Logger.config("Post partition recovery, increasing channel count for topic \"" + sTopic + "\" from " + cActual + " to " + cFinal);
                    this.f_service.ensureChannelCount(sTopic, cFinal, cFinal);
                });
            }
        }
    }
}

