/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.partitionedCache;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.NonBlocking;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Lease;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.RequestContext;
import com.tangosol.coherence.component.net.RequestStatus;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.net.message.ResponseMessage;
import com.tangosol.coherence.component.net.message.requestMessage.DistributedCacheKeyRequest;
import com.tangosol.coherence.component.net.message.requestMessage.distributedCacheRequest.KeySetRequest;
import com.tangosol.coherence.component.net.message.requestMessage.distributedCacheRequest.MapRequest;
import com.tangosol.coherence.component.net.message.requestMessage.distributedCacheRequest.PartialRequest;
import com.tangosol.coherence.component.net.message.requestMessage.distributedCacheRequest.StorageRequest;
import com.tangosol.coherence.component.net.message.responseMessage.DistributedPartialResponse;
import com.tangosol.coherence.component.net.message.responseMessage.SimpleResponse;
import com.tangosol.coherence.component.net.requestContext.AsyncContext;
import com.tangosol.coherence.component.net.requestStatus.MultiPartStatus;
import com.tangosol.coherence.component.net.requestStatus.SinglePartStatus;
import com.tangosol.coherence.component.util.CacheEvent;
import com.tangosol.coherence.component.util.Collections;
import com.tangosol.coherence.component.util.collections.WrapperEntry;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Logger;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.tracing.Scope;
import com.tangosol.internal.tracing.SpanContext;
import com.tangosol.internal.tracing.TracingHelper;
import com.tangosol.internal.util.VersionHelper;
import com.tangosol.net.ActionPolicy;
import com.tangosol.net.CacheService;
import com.tangosol.net.Member;
import com.tangosol.net.NamedCache;
import com.tangosol.net.PriorityTask;
import com.tangosol.net.RequestIncompleteException;
import com.tangosol.net.RequestPolicyException;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.ServiceStoppedException;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.events.internal.StorageDispatcher;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.net.partition.VersionedPartitions;
import com.tangosol.net.security.SecurityHelper;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.LiteMap;
import com.tangosol.util.LiteSet;
import com.tangosol.util.LongArray;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MapTrigger;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.PagedIterator;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.SparseArray;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import com.tangosol.util.aggregator.AbstractAsynchronousAggregator;
import com.tangosol.util.filter.LimitFilter;
import com.tangosol.util.processor.AbstractAsynchronousProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

public class BinaryMap
extends Util
implements NamedCache {
    private boolean __m_AuthorizationEnabled;
    private long __m_CacheId;
    private String __m_CacheName;
    private volatile transient boolean __m_Confirmed;
    private StorageDispatcher __m_Dispatcher;
    private LongArray __m_FilterArray;
    private transient MapListenerSupport __m_ListenerSupport;
    private BiFunction __m_ReadLocator;
    public static final int RESPONSE_MAP = 3;
    public static final int RESPONSE_SET = 2;
    public static final int RESPONSE_SIMPLE = 1;
    public static final int RESPONSE_VOID = 0;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Entry", Entry.get_CLASS());
        __mapChildren.put("EntryAdvancer", EntryAdvancer.get_CLASS());
        __mapChildren.put("KeyAdvancer", KeyAdvancer.get_CLASS());
        __mapChildren.put("KeyRequestStatus", KeyRequestStatus.get_CLASS());
        __mapChildren.put("KeySetRequestStatus", KeySetRequestStatus.get_CLASS());
        __mapChildren.put("MapRequestStatus", MapRequestStatus.get_CLASS());
        __mapChildren.put("PartialRequestStatus", PartialRequestStatus.get_CLASS());
    }

    public BinaryMap() {
        this(null, null, true);
    }

    public BinaryMap(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setFilterArray(new SparseArray());
            this.setListenerSupport(new MapListenerSupport());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new EntrySet("EntrySet", this, true), "EntrySet");
        this._addChild(new KeySet("KeySet", this, true), "KeySet");
        this._addChild(new Values("Values", this, true), "Values");
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new BinaryMap();
    }

    public static Class get_CLASS() {
        return BinaryMap.class;
    }

    private Component get_Module() {
        return this.get_Parent();
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        PartitionedCache service = this.getService();
        RequestContext context = this.registerRequestContext(false);
        try {
            PartitionedCache.IndexRequest msg = (PartitionedCache.IndexRequest)service.instantiateMessage("IndexRequest");
            msg.setRequestContext(context);
            msg.setCacheId(this.getCacheId());
            msg.setAdd(true);
            msg.setExtractor(extractor);
            msg.setOrdered(fOrdered);
            msg.setComparator(comparator);
            this.sendStorageRequest(msg);
        }
        finally {
            service.unregisterRequestContext(context);
        }
    }

    @Override
    public void addMapListener(MapListener listener) {
        this.addMapListener(listener, (Filter)null, null, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMapListener(MapListener listener, Filter filter, MapTrigger trigger, boolean fLite, VersionedPartitions versions) {
        MapListenerSupport support = this.getListenerSupport();
        long lFilterId = 0L;
        if (trigger == null) {
            MapListenerSupport mapListenerSupport = support;
            synchronized (mapListenerSupport) {
                boolean fWasEmpty = support.isEmpty(filter);
                if (!support.addListenerWithCheck(listener, filter, fLite)) {
                    return;
                }
                lFilterId = fWasEmpty ? this.registerFilter(filter) : this.getFilterId(filter);
            }
        }
        try {
            this.sendMapListenerRequest(lFilterId, filter, trigger, fLite, versions);
        }
        catch (RuntimeException e) {
            if (lFilterId > 0L) {
                MapListenerSupport mapListenerSupport = support;
                synchronized (mapListenerSupport) {
                    support.removeListener(listener, filter);
                    this.getFilterArray().remove(lFilterId);
                }
            }
            throw e;
        }
    }

    @Override
    public void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        throw new UnsupportedOperationException();
    }

    public void addMapListener(MapListener listener, Object oKey, boolean fLite, boolean fPriming, boolean fVersioned, long lVersion) {
        Binary binKey = (Binary)oKey;
        boolean fNew = this.getListenerSupport().addListenerWithCheck(listener, binKey, fLite);
        if (fNew || fPriming || fVersioned) {
            try {
                this.sendMapListenerRequest(binKey, fLite, fPriming, fVersioned, lVersion);
            }
            catch (RuntimeException e) {
                if (fNew) {
                    this.getListenerSupport().removeListener(listener, binKey);
                }
                throw e;
            }
        }
    }

    public void addMapListener(MapListener listener, Set setBinKeys, boolean fLite, boolean fPriming, VersionedPartitions versions) {
        MapListenerSupport support = this.getListenerSupport();
        HashMap<Binary, Boolean> mapKeys = new HashMap<Binary, Boolean>();
        for (Binary binKey : setBinKeys) {
            boolean fNew = support.addListenerWithCheck(listener, binKey, fLite);
            if (!fNew && !fPriming) continue;
            mapKeys.put(binKey, fNew);
        }
        if (!mapKeys.isEmpty()) {
            try {
                this.sendMapListenerAllRequest(listener, mapKeys.keySet(), fLite, fPriming, true, versions);
            }
            catch (RuntimeException e) {
                for (Map.Entry entry : mapKeys.entrySet()) {
                    if (entry.getValue() != Boolean.TRUE) continue;
                    support.removeListener(listener, entry.getKey());
                }
                throw e;
            }
        }
    }

    public Object aggregate(Filter filter, Binary binAgent, PartitionSet partitions, PriorityTask task) {
        PartitionedCache service = this.getService();
        RequestContext context = this.registerRequestContext(false);
        try {
            PartitionedCache.AggregateFilterRequest msg = (PartitionedCache.AggregateFilterRequest)service.instantiateMessage("AggregateFilterRequest");
            msg.setRequestContext(context);
            msg.setCacheId(this.getCacheId());
            msg.setFilter(filter);
            msg.setAggregatorBinary(binAgent);
            msg.copyPriorityAttributes(task);
            List list = this.mergePartialResponse(this.sendPartitionedRequest(msg, partitions, false));
            return list;
        }
        catch (RequestTimeoutException e) {
            throw this.processPartitionedRequestTimeout(e, 1);
        }
        finally {
            service.unregisterRequestContext(context);
        }
    }

    public Object aggregate(Filter filter, Binary binAgent, PriorityTask task) {
        return this.aggregate(filter, binAgent, this.makePartitionSet(), task);
    }

    @Override
    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        throw new UnsupportedOperationException();
    }

    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent, PartitionSet partitions) {
        throw new UnsupportedOperationException();
    }

    public Object aggregate(Collection colKeys, Binary binAgent, PriorityTask task) {
        Set setKeys = colKeys instanceof Set ? (Set)colKeys : new HashSet(colKeys);
        int cKeys = setKeys.size();
        if (cKeys == 0) {
            return java.util.Collections.EMPTY_LIST;
        }
        PartitionedCache service = this.getService();
        RequestContext context = this.registerRequestContext(false);
        try {
            PartitionedCache.AggregateAllRequest msg = (PartitionedCache.AggregateAllRequest)service.instantiateMessage("AggregateAllRequest");
            msg.setRequestContext(context);
            msg.setCacheId(this.getCacheId());
            msg.setAggregatorBinary(binAgent);
            msg.copyPriorityAttributes(task);
            List list = this.mergePartialResponse(this.sendPartitionedRequest(msg, setKeys));
            return list;
        }
        catch (RequestTimeoutException e) {
            throw this.processPartitionedRequestTimeout(e, 1);
        }
        finally {
            service.unregisterRequestContext(context);
        }
    }

    @Override
    public Object aggregate(Collection colKeys, InvocableMap.EntryAggregator agent) {
        throw new UnsupportedOperationException();
    }

    public void aggregateAsync(Filter filter, Binary binAgent, PartitionSet partitions, PriorityTask task, AbstractAsynchronousAggregator asyncAggr, Converter convUp) {
        long lOrderId = asyncAggr.getUnitOfOrderId();
        PartitionedCache service = this.getService();
        PartitionedCache.RequestCoordinator coordinator = service.getRequestCoordinator();
        AsyncContext context = coordinator.createContext(this, asyncAggr, convUp);
        if (partitions.isEmpty()) {
            context.processCompletion();
            return;
        }
        PartitionedCache.AggregateFilterRequest msg = (PartitionedCache.AggregateFilterRequest)service.instantiateMessage("AggregateFilterRequest");
        msg.setRequestContext(context);
        msg.setCacheId(this.getCacheId());
        msg.setFilter(filter);
        msg.setAggregatorBinary(binAgent);
        msg.copyPriorityAttributes(task);
        msg.setOrderId(lOrderId | (long)service.getThisMember().getId() << 32);
        context.setPartitionSet(partitions);
        boolean fSubmitted = coordinator.submitPartialRequest(msg, partitions, false);
        if (fSubmitted) {
            if (!NonBlocking.isNonBlockingCaller()) {
                service.flush();
                try {
                    coordinator.drainBacklog(partitions, msg.checkTimeoutRemaining());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Base.ensureRuntimeException(e);
                }
            }
        } else {
            context.processCompletion();
        }
    }

    public void aggregateAsync(Collection colBinKeys, Binary binAgent, PriorityTask task, AbstractAsynchronousAggregator asyncAggr, Converter convUp) {
        Set setKeys;
        long lOrderId = asyncAggr.getUnitOfOrderId();
        PartitionedCache service = this.getService();
        PartitionedCache.RequestCoordinator coordinator = service.getRequestCoordinator();
        AsyncContext context = coordinator.createContext(this, asyncAggr, convUp);
        if (colBinKeys.size() == 0) {
            context.processCompletion();
            return;
        }
        PartitionedCache.AggregateAllRequest msg = (PartitionedCache.AggregateAllRequest)service.instantiateMessage("AggregateAllRequest");
        msg.setRequestContext(context);
        msg.setCacheId(this.getCacheId());
        msg.setAggregatorBinary(binAgent);
        msg.copyPriorityAttributes(task);
        msg.setOrderId(lOrderId | (long)service.getThisMember().getId() << 32);
        PartitionSet partitions = new PartitionSet(service.getPartitionCount());
        context.setPartitionSet(partitions);
        Set set = setKeys = colBinKeys instanceof Set ? (Set)colBinKeys : new HashSet(colBinKeys);
        if (coordinator.submitKeySetRequest(msg, setKeys, partitions, false)) {
            if (!NonBlocking.isNonBlockingCaller()) {
                service.flush();
                try {
                    coordinator.drainBacklog(partitions, msg.checkTimeoutRemaining());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Base.ensureRuntimeException(e);
                }
            }
        } else {
            context.processCompletion();
        }
    }

    protected boolean checkResponse(DistributedCacheKeyRequest msgRequest, Object oResponse) {
        try {
            return msgRequest.checkResponse(oResponse);
        }
        catch (RuntimeException e) {
            Throwable eOrig = Base.getOriginalException(e);
            if (eOrig instanceof RequestPolicyException) {
                e = (RuntimeException)eOrig;
            }
            throw BinaryMap.logRemoteException(e);
        }
    }

    protected boolean checkResponse(StorageRequest msgRequest, Object oResponse) {
        try {
            return msgRequest.checkResponse(oResponse);
        }
        catch (RuntimeException e) {
            Throwable eOrig = Base.getOriginalException(e);
            if (eOrig instanceof RequestPolicyException) {
                e = (RuntimeException)eOrig;
            }
            throw BinaryMap.logRemoteException(e);
        }
    }

    @Override
    public void clear() {
        PartitionedCache service = this.getService();
        RequestContext context = this.registerRequestContext(false);
        try {
            PartitionedCache.ClearRequest msg = (PartitionedCache.ClearRequest)service.instantiateMessage("ClearRequest");
            msg.setRequestContext(context);
            msg.setCacheId(this.getCacheId());
            this.mergePartialResponse(this.sendPartitionedRequest(msg, this.makePartitionSet(), false));
        }
        catch (RequestTimeoutException e) {
            throw this.processPartitionedRequestTimeout(e, 0);
        }
        finally {
            service.unregisterRequestContext(context);
        }
    }

    protected void clearStatus(RequestStatus status) {
        if (status != null) {
            status.reset();
        }
    }

    protected Map collectRejectedPartitions(Set setRejectedKeys, Map mapByOwner) {
        PartitionedCache service = this.getService();
        HashMap<Integer, Member> mapRejected = new HashMap<Integer, Member>();
        setRejectedKeys = new HashSet(setRejectedKeys);
        for (Map.Entry entry : mapByOwner.entrySet()) {
            Member member = (Member)entry.getKey();
            Object oKeys = entry.getValue();
            Set setKeys = oKeys instanceof Set ? (Set)oKeys : ((Map)oKeys).keySet();
            Iterator iter = setRejectedKeys.iterator();
            while (iter.hasNext()) {
                Binary binRejectedKey = (Binary)iter.next();
                if (!setKeys.contains(binRejectedKey)) continue;
                mapRejected.put(service.getKeyPartition(binRejectedKey), member);
                iter.remove();
            }
        }
        if (!setRejectedKeys.isEmpty()) {
            for (Binary binRejectedKey : setRejectedKeys) {
                mapRejected.put(service.getKeyPartition(binRejectedKey), null);
            }
        }
        return mapRejected;
    }

    public boolean confirmCache() {
        if (!this.isConfirmed()) {
            block3: {
                PartitionedCache.StorageConfirmRequest msg = (PartitionedCache.StorageConfirmRequest)this.getService().instantiateMessage("StorageConfirmRequest");
                msg.setCacheId(this.getCacheId());
                try {
                    this.mergePartialResponse(this.sendPartitionedRequest(msg, this.makePartitionSet(), true));
                }
                catch (RequestPolicyException e) {
                    if (this.isActive()) break block3;
                    return false;
                }
            }
            this.setConfirmed(true);
        }
        return true;
    }

    public boolean containsAll(Collection colKeys) {
        List listResponse;
        RequestTimeoutException eTimeout;
        block7: {
            Set setKeys = colKeys instanceof Set ? (Set)colKeys : new HashSet(colKeys);
            int cKeys = setKeys.size();
            if (cKeys == 0) {
                return true;
            }
            if (cKeys == 1) {
                Binary binKey = (Binary)setKeys.iterator().next();
                return this.containsKey(binKey);
            }
            PartitionedCache.ContainsAllRequest msg = (PartitionedCache.ContainsAllRequest)this.getService().instantiateMessage("ContainsAllRequest");
            msg.setCacheId(this.getCacheId());
            eTimeout = null;
            try {
                listResponse = this.sendPartitionedRequest(msg, setKeys);
            }
            catch (RequestTimeoutException e) {
                eTimeout = e;
                listResponse = (List)e.getPartialResult();
                if (listResponse != null) break block7;
                throw e;
            }
        }
        for (PartitionedCache.PartialValueResponse response : listResponse) {
            RuntimeException exception = response.getException();
            if (exception != null) {
                throw exception;
            }
            Object oResult = response.getResult();
            if (!(oResult instanceof Boolean) || ((Boolean)oResult).booleanValue()) continue;
            return false;
        }
        if (eTimeout != null) {
            eTimeout.setPartialResult(null);
            throw eTimeout;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean containsKey(Object oKey) {
        KeyRequestStatus status = null;
        try {
            PartitionedCache service = this.getService();
            Binary binKey = (Binary)oKey;
            PartitionedCache.ContainsKeyRequest msg = (PartitionedCache.ContainsKeyRequest)service.instantiateMessage("ContainsKeyRequest");
            msg.setCacheId(this.getCacheId());
            msg.setKey(binKey);
            while (true) {
                if ((status = this.ensureRequestTarget(binKey, status, msg)).isTargetMissing()) {
                    boolean bl = false;
                    this.clearStatus(status);
                    return bl;
                }
                msg.setToMemberSet(status.getOwnerSet());
                Object oResponse = service.poll(msg);
                if (this.checkResponse(msg, oResponse)) {
                    boolean bl = (Boolean)oResponse;
                    this.clearStatus(status);
                    return bl;
                }
                msg = (PartitionedCache.ContainsKeyRequest)msg.cloneMessage();
            }
        }
        catch (Throwable throwable) {
            this.clearStatus(status);
            throw throwable;
        }
    }

    @Override
    public boolean containsValue(Object oValue) {
        List listResponse;
        RequestTimeoutException eTimeout;
        block5: {
            PartitionedCache.ContainsValueRequest msg = (PartitionedCache.ContainsValueRequest)this.getService().instantiateMessage("ContainsValueRequest");
            msg.setCacheId(this.getCacheId());
            msg.setValue((Binary)oValue);
            eTimeout = null;
            try {
                listResponse = this.sendPartitionedRequest(msg, this.makePartitionSet(), false);
            }
            catch (RequestTimeoutException e) {
                eTimeout = e;
                listResponse = (List)e.getPartialResult();
                if (listResponse != null) break block5;
                throw e;
            }
        }
        for (PartitionedCache.PartialValueResponse msgResponse : listResponse) {
            RuntimeException exception = msgResponse.getException();
            if (exception != null) {
                throw exception;
            }
            Object oResult = msgResponse.getResult();
            if (!(oResult instanceof Boolean) || !((Boolean)oResult).booleanValue()) continue;
            return true;
        }
        if (eTimeout != null) {
            eTimeout.setPartialResult(null);
            throw eTimeout;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        MapListenerSupport support;
        this.ensureWriteAllowed();
        MapListenerSupport mapListenerSupport = support = this.getListenerSupport();
        synchronized (mapListenerSupport) {
            support.clear();
            this.getFilterArray().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(PartitionedCache.MapEvent msgEvent) {
        Object laFilters;
        MapEvent event;
        Listeners listeners;
        int nEventType = msgEvent.getEventType() & 7;
        Binary binKey = msgEvent.getKey();
        boolean fSynthetic = msgEvent.isSynthetic();
        boolean fExpired = msgEvent.isExpired();
        boolean fPriming = msgEvent.isPriming();
        long[] alFilterId = msgEvent.getFilterId();
        int cFilters = alFilterId == null ? 0 : alFilterId.length;
        int iPartition = msgEvent.getPartition();
        MapListenerSupport support = this.getListenerSupport();
        SpanContext spanContext = msgEvent.getTracingSpanContext();
        PartitionedCache service = this.getService();
        Listeners listeners2 = listeners = msgEvent.isTransformed() || binKey == null ? null : support.getListeners(binKey);
        if (cFilters == 0) {
            event = new com.tangosol.net.cache.CacheEvent<Binary, Binary>(this, nEventType, binKey, msgEvent.getOldValue(), msgEvent.getNewValue(), fSynthetic, CacheEvent.TransformationState.NON_TRANSFORMABLE, fPriming, fExpired);
            if (((com.tangosol.net.cache.CacheEvent)(event = ((com.tangosol.net.cache.CacheEvent)event).with(iPartition, msgEvent.getVersion()))).isVersionUpdate()) {
                MapListenerSupport mapListenerSupport = support;
                synchronized (mapListenerSupport) {
                    for (Binary binKeyCheck : support.getKeySet()) {
                        if (service.getKeyPartition(binKeyCheck) != iPartition) continue;
                        if (listeners == null) {
                            listeners = new Listeners();
                        }
                        listeners.addAll(support.getListeners(binKeyCheck));
                    }
                }
            }
        } else {
            laFilters = this.getFilterArray();
            LiteSet<Filter> setFilters = new LiteSet<Filter>();
            for (int i = 0; i < cFilters; ++i) {
                long lFilterId = alFilterId[i];
                if (!laFilters.exists(lFilterId)) continue;
                Filter filter = (Filter)laFilters.get(lFilterId);
                Listeners listenersTemp = new Listeners();
                if (listeners != null) {
                    listenersTemp.addAll(listeners);
                }
                listeners = listenersTemp;
                listeners.addAll(support.getListeners(filter));
                setFilters.add(filter);
            }
            Filter[] aFilter = (Filter[])setFilters.toArray(new Filter[setFilters.size()]);
            event = new MapListenerSupport.FilterEvent(this, nEventType, binKey, msgEvent.getOldValue(), msgEvent.getNewValue(), fSynthetic, msgEvent.isTransformed() ? CacheEvent.TransformationState.TRANSFORMED : CacheEvent.TransformationState.NON_TRANSFORMABLE, fPriming, fExpired, aFilter);
            event = ((com.tangosol.net.cache.CacheEvent)event).with(iPartition, msgEvent.getVersion());
        }
        if (listeners == null || listeners.isEmpty()) {
            laFilters = support;
            synchronized (laFilters) {
                com.tangosol.coherence.component.net.Member memberOwner;
                if (cFilters == 0 && binKey != null && support.getListeners(binKey) == null && (memberOwner = service.getPrimaryOwner(binKey)) != null) {
                    PartitionedCache.KeyListenerRequest msg = (PartitionedCache.KeyListenerRequest)service.instantiateMessage("KeyListenerRequest");
                    msg.setCacheId(this.getCacheId());
                    msg.setKey(binKey);
                    msg.setAdd(false);
                    msg.addToMember(memberOwner);
                    service.post(msg);
                }
            }
        }
        if (spanContext == null) {
            CacheEvent.dispatchSafe(event, listeners, this.getService().ensureEventDispatcher().getQueue());
        } else {
            PartitionedCache svc = this.getService();
            com.tangosol.coherence.component.net.Member memberFrom = msgEvent.getFromMember();
            try (Scope scope = TracingHelper.isEnabled() ? TracingHelper.getTracer().withSpan(svc.newTracingSpan("dispatch", msgEvent).withAssociation("follows_from", spanContext).withMetadata("member.source", memberFrom == null ? -1L : (long)memberFrom.getId()).startSpan()) : null;){
                CacheEvent.dispatchSafe(event, listeners, svc.ensureEventDispatcher().getQueue());
            }
        }
    }

    protected PartialRequestStatus ensureRequestTarget(PartitionSet partitions, RequestMessage msg) {
        PartitionedCache service = this.getService();
        PartialRequestStatus status = new PartialRequestStatus();
        this._linkChild(status);
        while (true) {
            if (!this.isActive()) {
                this.clearStatus(status);
                throw this.onMissingStorage(partitions);
            }
            Map mapByOwner = service.splitByOwner(partitions, 0, service.getPartitionAssignments());
            status.setOrphanedPartitions((PartitionSet)mapByOwner.remove(null));
            status.setPartitionsByOwner(mapByOwner);
            if (status.getOrphanedPartitions() == null) {
                return status;
            }
            if (service.getOwnershipMemberSet().isEmpty()) {
                PartitionSet setOrphans = status.getOrphanedPartitions();
                this.clearStatus(status);
                throw this.onMissingStorage(setOrphans);
            }
            BinaryMap._assert(!status.getOrphanedPartitions().isEmpty());
            this.waitForRedistribution(partitions, status, msg.getRequestTimeout());
        }
    }

    protected PartialRequestStatus ensureRequestTarget(PartitionSet partitions, PartialRequestStatus status, PartialRequest msg) {
        PartitionedCache service = this.getService();
        while (true) {
            if (status == null) {
                status = new PartialRequestStatus();
                this._linkChild(status);
            } else {
                this.waitForRedistribution(partitions, status, msg.getRequestTimeout());
                if (!this.isActive()) {
                    this.clearStatus(status);
                    throw this.onMissingStorage(partitions);
                }
            }
            service.checkQuorum(msg, msg.isReadOnly());
            int[][] aaiOwners = service.getPartitionAssignments();
            Map mapByOwner = service.splitByOwner(partitions, 0, aaiOwners);
            PartitionSet partsOrphan = (PartitionSet)mapByOwner.remove(null);
            status.setPartitionsByOwner(mapByOwner);
            if (partsOrphan == null) {
                status.setOrphanedPartitions(null);
                return status;
            }
            status.setOrphanedPartitions(partsOrphan);
            if (service.getPartitionConfigMap().isAssignmentCompleted()) {
                if (aaiOwners == service.getPartitionAssignments()) {
                    if (!mapByOwner.isEmpty()) {
                        return status;
                    }
                } else {
                    status = null;
                    continue;
                }
            }
            if (service.getOwnershipMemberSet().isEmpty()) break;
        }
        PartitionSet setOrphans = status.getOrphanedPartitions();
        this.clearStatus(status);
        throw this.onMissingStorage(setOrphans);
    }

    protected KeyRequestStatus ensureRequestTarget(Binary binKey, KeyRequestStatus status, DistributedCacheKeyRequest msg) {
        int iPartition;
        PartitionedCache service = this.getService();
        do {
            if (status == null) {
                iPartition = service.getKeyPartition(binKey);
                status = new KeyRequestStatus();
                status.setPartition(iPartition);
                this._linkChild(status);
            } else {
                iPartition = status.getPartition();
                this.waitForRedistribution(status, msg.getRequestTimeout());
                if (!this.isActive()) {
                    this.clearStatus(status);
                    throw this.onMissingStorage(service.instantiatePartitionSet(iPartition));
                }
            }
            service.checkQuorum(msg, msg.isReadOnly());
            com.tangosol.coherence.component.net.Member memberTarget = this.getTarget(iPartition, msg);
            if (memberTarget == null) continue;
            status.setOwner(memberTarget);
            return status;
        } while (!service.getOwnershipMemberSet().isEmpty());
        this.clearStatus(status);
        throw this.onMissingStorage(service.instantiatePartitionSet(iPartition));
    }

    protected MapRequestStatus ensureRequestTarget(Map map, MapRequestStatus status, MapRequest msg) {
        PartitionedCache service = this.getService();
        boolean fRetry = false;
        if (status == null) {
            status = new MapRequestStatus();
            this._linkChild(status);
        } else {
            fRetry = true;
            this.waitForRedistribution(map, status, msg.getRequestTimeout());
            if (!this.isActive()) {
                this.clearStatus(status);
                throw this.onMissingStorage(service.getKeyPartitions(map.keySet()));
            }
        }
        service.checkQuorum(msg, msg.isReadOnly());
        if (fRetry) {
            status.setEntriesByPartition(map);
        } else {
            Map mapByPartition;
            ConverterCollections.ConverterMap mapConv = (ConverterCollections.ConverterMap)map;
            if (mapConv.getMap() instanceof ConverterCollections.ConverterMap) {
                mapConv = ConverterCollections.getMap(new HashMap(mapConv.getMap()), mapConv.getConverterKeyUp(), mapConv.getConverterKeyDown(), mapConv.getConverterValueUp(), mapConv.getConverterValueDown());
            }
            if ((mapByPartition = service.splitKeysByPartition(mapConv.keySet().iterator())).isEmpty() && map.isEmpty()) {
                throw new ConcurrentModificationException();
            }
            for (Map.Entry entry : mapByPartition.entrySet()) {
                entry.setValue(mapConv.subMap((Set)entry.getValue()));
            }
            status.setEntriesByPartition(mapByPartition);
        }
        status.setOrphanedEntries(new HashMap());
        status.setOrphanedPartitions(null);
        return status;
    }

    protected KeySetRequestStatus ensureRequestTarget(Set setKeys, KeySetRequestStatus status, KeySetRequest msg) {
        PartitionedCache service = this.getService();
        while (true) {
            if (status == null) {
                status = new KeySetRequestStatus();
                this._linkChild(status);
            } else {
                this.waitForRedistribution(setKeys, status, msg.getRequestTimeout());
                if (!this.isActive()) {
                    this.clearStatus(status);
                    throw this.onMissingStorage(service.getKeyPartitions(setKeys));
                }
            }
            service.checkQuorum(msg, msg.isReadOnly());
            int[][] aaiOwners = service.getPartitionAssignments();
            int iStore = msg.isCoherentResult() ? 0 : -1;
            Map mapByOwner = service.splitKeysByOwner(setKeys.iterator(), iStore, aaiOwners);
            Set setOrphan = (Set)mapByOwner.remove(null);
            status.setOrphanedKeys(setOrphan);
            status.setKeysByOwner(mapByOwner);
            if (setOrphan == null && !mapByOwner.isEmpty()) {
                status.setOrphanedPartitions(null);
                return status;
            }
            status.setOrphanedPartitions(service.getKeyPartitions(setOrphan));
            if (service.getPartitionConfigMap().isAssignmentCompleted()) {
                if (aaiOwners == service.getPartitionAssignments()) {
                    if (!mapByOwner.isEmpty()) {
                        return status;
                    }
                } else {
                    status = null;
                    continue;
                }
            }
            if (setKeys.isEmpty()) {
                throw new ConcurrentModificationException();
            }
            if (service.getOwnershipMemberSet().isEmpty()) break;
        }
        PartitionSet setOrphans = status.getOrphanedPartitions();
        this.clearStatus(status);
        throw this.onMissingStorage(setOrphans);
    }

    protected void ensureWriteAllowed() {
        PartitionedCache service = this.getService();
        ActionPolicy policy = service.getActionPolicy();
        if (!policy.isAllowed(service, CacheService.CacheAction.WRITE)) {
            throw new RequestPolicyException("Cache writes are disallowed by " + String.valueOf(policy));
        }
    }

    @Override
    public Set entrySet() {
        return (EntrySet)this._findChild("EntrySet");
    }

    @Override
    public Set entrySet(Filter filter) {
        return this.entrySet(filter, this.makePartitionSet());
    }

    public Set entrySet(Filter filter, PartitionSet partitions) {
        try {
            return filter instanceof LimitFilter ? this.limitQuerySequential(partitions, (LimitFilter)filter, false) : this.mergeQueryResponse(this.query(partitions, filter, false));
        }
        catch (RequestTimeoutException e) {
            throw this.processPartitionedRequestTimeout(e, filter instanceof LimitFilter ? 0 : 2);
        }
    }

    @Override
    public Set entrySet(Filter filter, Comparator comparator) {
        return this.entrySet(filter, comparator, this.makePartitionSet());
    }

    public Set entrySet(Filter filter, Comparator comparator, PartitionSet partitions) {
        try {
            return filter instanceof LimitFilter ? this.limitQueryDistributed(partitions, (LimitFilter)filter) : this.mergeQueryResponse(this.query(partitions, filter, false));
        }
        catch (RequestTimeoutException e) {
            throw this.processPartitionedRequestTimeout(e, filter instanceof LimitFilter ? 0 : 2);
        }
    }

    protected void estimateBatchSize(PartitionedCache.QueryResponse msgResponse, LimitFilter filter, long cbScratch) {
        if (msgResponse.getException() != null) {
            throw BinaryMap.logRemoteException(msgResponse.getException());
        }
        long cbPage = msgResponse.getBinarySize();
        int cMembers = this.getService().getOwnershipMemberSet().size();
        int cBatch = cbPage == 0L ? 1 : (int)Math.min((long)cMembers, Math.max(1L, (cbScratch + cbPage) / cbPage));
        filter.setBatchSize(cBatch);
    }

    @Override
    public Object get(Object oKey) {
        Object var7_7;
        PartitionedCache.GetRequest msg;
        PartitionedCache service = this.getService();
        RequestContext context = this.registerRequestContext(false);
        KeyRequestStatus status = null;
        try {
            Binary binKey = (Binary)oKey;
            msg = (PartitionedCache.GetRequest)service.instantiateMessage("GetRequest");
            msg.setRequestContext(context);
            msg.setCacheId(this.getCacheId());
            msg.setKey(binKey);
            msg.setAllowBackupRead(this.getReadLocator() != null);
            while (true) {
                if (!(status = this.ensureRequestTarget(binKey, status, msg)).isTargetMissing()) break block5;
                var7_7 = null;
                this.clearStatus(status);
                break;
            }
        }
        catch (Throwable throwable) {
            this.clearStatus(status);
            service.unregisterRequestContext(context);
            throw throwable;
        }
        {
            block6: {
                block5: {
                    service.unregisterRequestContext(context);
                    return var7_7;
                }
                msg.setToMemberSet(status.getOwnerSet());
                Object oResponse = service.poll(msg);
                if (!this.checkResponse(msg, oResponse)) break block6;
                Binary binary = (Binary)oResponse;
                this.clearStatus(status);
                service.unregisterRequestContext(context);
                return binary;
            }
            msg = (PartitionedCache.GetRequest)msg.cloneMessage();
            continue;
        }
    }

    @Override
    public Map getAll(Collection colKeys) {
        Set setKeys = colKeys instanceof Set ? (Set)colKeys : new HashSet(colKeys);
        int cKeys = setKeys.size();
        if (cKeys == 0) {
            return new LiteMap();
        }
        return this.getAll(setKeys, 0);
    }

    public Map getAll(Set setKeys, int cSizeThreshold) {
        PartitionedCache service = this.getService();
        RequestContext context = this.registerRequestContext(false);
        try {
            PartitionedCache.GetAllRequest msg = (PartitionedCache.GetAllRequest)service.instantiateMessage("GetAllRequest");
            msg.setRequestContext(context);
            msg.setCacheId(this.getCacheId());
            msg.setSizeThreshold(cSizeThreshold);
            msg.setAllowBackupRead(this.getReadLocator() != null);
            Map map = this.mergePartialMapResponse(this.sendPartitionedRequest(msg, setKeys));
            return map;
        }
        catch (RequestTimeoutException e) {
            throw this.processPartitionedRequestTimeout(e, 3);
        }
        finally {
            service.unregisterRequestContext(context);
        }
    }

    public long getCacheId() {
        return this.__m_CacheId;
    }

    @Override
    public String getCacheName() {
        return this.__m_CacheName;
    }

    @Override
    public CacheService getCacheService() {
        return (PartitionedCache)this.get_Module();
    }

    public StorageDispatcher getDispatcher() {
        return this.__m_Dispatcher;
    }

    public LongArray getFilterArray() {
        return this.__m_FilterArray;
    }

    public long getFilterId(Filter filter) {
        Iterator iter = this.getFilterArray().iterator();
        while (iter.hasNext()) {
            Filter filterThat = (Filter)iter.next();
            if (!Base.equals(filter, filterThat)) continue;
            return iter.getIndex();
        }
        return 0L;
    }

    public MapListenerSupport getListenerSupport() {
        return this.__m_ListenerSupport;
    }

    public PartitionSet getPartitions(Map map, int cMembers) {
        PartitionSet parts = new PartitionSet(this.getService().getPartitionCount());
        cMembers = Math.max(1, cMembers);
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            parts.add((PartitionSet)iter.next());
            if (--cMembers != 0) continue;
            break;
        }
        return parts;
    }

    public BiFunction getReadLocator() {
        return this.__m_ReadLocator;
    }

    @Override
    public PartitionedCache getService() {
        return (PartitionedCache)this.get_Module();
    }

    public com.tangosol.coherence.component.net.Member getTarget(int iPartition, DistributedCacheKeyRequest msg) {
        BiFunction functionTarget = this.getReadLocator();
        if (msg.isCoherentResult() || functionTarget == null) {
            return this.getService().getPrimaryOwner(iPartition);
        }
        PartitionedCache service = this.getService();
        return (com.tangosol.coherence.component.net.Member)functionTarget.apply(service.getPartitionOwnership(iPartition), service);
    }

    public Object invoke(Binary binKey, Binary binAgent, PriorityTask task) {
        Object var8_8;
        PartitionedCache.InvokeRequest msg;
        PartitionedCache service = this.getService();
        KeyRequestStatus status = null;
        RequestContext context = this.registerRequestContext(true);
        try {
            msg = (PartitionedCache.InvokeRequest)service.instantiateMessage("InvokeRequest");
            msg.setRequestContext(context);
            msg.setCacheId(this.getCacheId());
            msg.setKey(binKey);
            msg.setProcessorBinary(binAgent);
            msg.copyPriorityAttributes(task);
            while (true) {
                if (!(status = this.ensureRequestTarget(binKey, status, msg)).isTargetMissing()) break block5;
                var8_8 = null;
                break;
            }
        }
        catch (Throwable throwable) {
            service.unregisterRequestContext(context);
            this.clearStatus(status);
            throw throwable;
        }
        {
            block6: {
                block5: {
                    service.unregisterRequestContext(context);
                    this.clearStatus(status);
                    return var8_8;
                }
                msg.setToMemberSet(status.getOwnerSet());
                Object oResponse = service.poll(msg);
                if (!this.checkResponse(msg, oResponse)) break block6;
                Binary binary = (Binary)oResponse;
                service.unregisterRequestContext(context);
                this.clearStatus(status);
                return binary;
            }
            context.setOldestPendingSUID(service.getOldestPendingRequestSUID());
            msg = (PartitionedCache.InvokeRequest)msg.cloneMessage();
            continue;
        }
    }

    @Override
    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        throw new UnsupportedOperationException();
    }

    public Map invokeAll(Filter filter, Binary binAgent, PartitionSet partitions, PriorityTask task) {
        PartitionedCache service = this.getService();
        RequestContext context = this.registerRequestContext(true);
        try {
            PartitionedCache.InvokeFilterRequest msg = (PartitionedCache.InvokeFilterRequest)service.instantiateMessage("InvokeFilterRequest");
            msg.setRequestContext(context);
            msg.setCacheId(this.getCacheId());
            msg.setFilter(filter);
            msg.setProcessorBinary(binAgent);
            msg.copyPriorityAttributes(task);
            try {
                Map map = this.mergePartialMapResponse(this.sendPartitionedRequest(msg, partitions, false));
                return map;
            }
            catch (RequestTimeoutException e) {
                throw this.processPartitionedRequestTimeout(e, 3);
            }
        }
        finally {
            service.unregisterRequestContext(context);
        }
    }

    @Override
    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        throw new UnsupportedOperationException();
    }

    public Map invokeAll(Collection colBinKeys, Binary binAgent, PriorityTask task) {
        if (colBinKeys.size() == 0) {
            return new LiteMap();
        }
        PartitionedCache service = this.getService();
        RequestContext context = this.registerRequestContext(true);
        try {
            PartitionedCache.InvokeAllRequest msg = (PartitionedCache.InvokeAllRequest)service.instantiateMessage("InvokeAllRequest");
            msg.setRequestContext(context);
            msg.setCacheId(this.getCacheId());
            msg.setProcessorBinary(binAgent);
            msg.copyPriorityAttributes(task);
            try {
                Set setBinKeys = colBinKeys instanceof Set ? (Set)colBinKeys : new HashSet(colBinKeys);
                Map map = this.mergePartialMapResponse(this.sendPartitionedRequest(msg, setBinKeys));
                return map;
            }
            catch (RequestTimeoutException e) {
                throw this.processPartitionedRequestTimeout(e, 3);
            }
        }
        finally {
            service.unregisterRequestContext(context);
        }
    }

    @Override
    public Map invokeAll(Collection colKeys, InvocableMap.EntryProcessor agent) {
        throw new UnsupportedOperationException();
    }

    public void invokeAllAsync(Filter filter, Binary binAgent, PartitionSet partitions, PriorityTask task, AbstractAsynchronousProcessor asyncProc, Converter convUp) {
        long lOrderId = asyncProc.getUnitOfOrderId();
        PartitionedCache service = this.getService();
        PartitionedCache.RequestCoordinator coordinator = service.getRequestCoordinator();
        AsyncContext context = coordinator.createContext(this, asyncProc, convUp);
        if (partitions.isEmpty()) {
            context.processCompletion();
            return;
        }
        PartitionedCache.InvokeFilterRequest msg = (PartitionedCache.InvokeFilterRequest)service.instantiateMessage("InvokeFilterRequest");
        msg.setRequestContext(context);
        msg.setCacheId(this.getCacheId());
        msg.setFilter(filter);
        msg.setProcessorBinary(binAgent);
        msg.copyPriorityAttributes(task);
        msg.setOrderId(lOrderId | (long)service.getThisMember().getId() << 32);
        context.setPartitionSet(partitions);
        if (coordinator.submitPartialRequest(msg, partitions, false)) {
            if (!NonBlocking.isNonBlockingCaller()) {
                service.flush();
                try {
                    coordinator.drainBacklog(partitions, msg.checkTimeoutRemaining());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Base.ensureRuntimeException(e);
                }
            }
        } else {
            context.processCompletion();
        }
    }

    public void invokeAllAsync(Collection colBinKeys, Binary binAgent, PriorityTask task, AbstractAsynchronousProcessor asyncProc, Converter convUp) {
        Set setKeys;
        long lOrderId = asyncProc.getUnitOfOrderId();
        PartitionedCache service = this.getService();
        PartitionedCache.RequestCoordinator coordinator = service.getRequestCoordinator();
        AsyncContext context = coordinator.createContext(this, asyncProc, convUp);
        if (colBinKeys.size() == 0) {
            context.processCompletion();
            return;
        }
        PartitionedCache.InvokeAllRequest msg = (PartitionedCache.InvokeAllRequest)service.instantiateMessage("InvokeAllRequest");
        msg.setRequestContext(context);
        msg.setCacheId(this.getCacheId());
        msg.setProcessorBinary(binAgent);
        msg.copyPriorityAttributes(task);
        msg.setOrderId(lOrderId | (long)service.getThisMember().getId() << 32);
        PartitionSet partitions = new PartitionSet(service.getPartitionCount());
        context.setPartitionSet(partitions);
        Set set = setKeys = colBinKeys instanceof Set ? (Set)colBinKeys : new HashSet(colBinKeys);
        if (coordinator.submitKeySetRequest(msg, setKeys, partitions, false)) {
            if (!NonBlocking.isNonBlockingCaller()) {
                service.flush();
                try {
                    coordinator.drainBacklog(partitions, msg.checkTimeoutRemaining());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Base.ensureRuntimeException(e);
                }
            }
        } else {
            context.processCompletion();
        }
    }

    public void invokeAsync(Binary binKey, Binary binAgent, PriorityTask task, AbstractAsynchronousProcessor asyncProc, Converter convUp) {
        long lOrderId = asyncProc.getUnitOfOrderId();
        PartitionedCache service = this.getService();
        PartitionedCache.RequestCoordinator coordinator = service.getRequestCoordinator();
        AsyncContext context = coordinator.createContext(this, asyncProc, convUp);
        PartitionedCache.InvokeRequest msg = (PartitionedCache.InvokeRequest)service.instantiateMessage("InvokeRequest");
        msg.setRequestContext(context);
        msg.setCacheId(this.getCacheId());
        msg.setKey(binKey);
        msg.setProcessorBinary(binAgent);
        msg.copyPriorityAttributes(task);
        msg.setOrderId(lOrderId | (long)service.getThisMember().getId() << 32);
        int nPartition = service.getKeyPartition(binKey);
        context.setPartition(nPartition);
        if (coordinator.submitKeyRequest(msg, nPartition)) {
            if (!NonBlocking.isNonBlockingCaller()) {
                service.flush();
                try {
                    coordinator.drainBacklog(nPartition, msg.checkTimeoutRemaining());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Base.ensureRuntimeException(e);
                }
            }
        } else {
            context.processCompletion();
        }
    }

    @Override
    public boolean isActive() {
        return this.getService().getBinaryMapArray().exists(this.getCacheId());
    }

    @Override
    public boolean isReady() {
        return this.isActive() && this.getService().getPartitionOwner(0) != null && this.getService().getOwnershipSenior() != null;
    }

    public boolean isAuthorizationEnabled() {
        return this.__m_AuthorizationEnabled;
    }

    public boolean isConfirmed() {
        return this.__m_Confirmed;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected static boolean isPartitionedQueryCompatible(int nVersion) {
        return VersionHelper.isVersionCompatible(VersionHelper.VERSION_14_1_2_0, nVersion) && nVersion != VersionHelper.VERSION_23_09 || VersionHelper.isPatchCompatible(VersionHelper.VERSION_23_09_1, nVersion) || VersionHelper.isPatchCompatible(VersionHelper.VERSION_14_1_1_2206_7, nVersion) || VersionHelper.isPatchCompatible(VersionHelper.VERSION_14_1_1_0_16, nVersion) || VersionHelper.isPatchCompatible(VersionHelper.VERSION_12_2_1_4_20, nVersion) || VersionHelper.isPatchCompatible(VersionHelper.VERSION_12_2_1_6_6, nVersion);
    }

    @Override
    public Set keySet() {
        return (KeySet)this._findChild("KeySet");
    }

    @Override
    public Set keySet(Filter filter) {
        return this.keySet(filter, this.makePartitionSet());
    }

    public Set keySet(Filter filter, PartitionSet partitions) {
        try {
            return filter instanceof LimitFilter ? this.limitQuerySequential(partitions, (LimitFilter)filter, true) : this.mergeQueryResponse(this.query(partitions, filter, true));
        }
        catch (RequestTimeoutException e) {
            throw this.processPartitionedRequestTimeout(e, filter instanceof LimitFilter ? 0 : 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySetPage(PartitionSet partitions) {
        PartitionedCache.QueryResponse msgResponse;
        PartitionSet partRequest;
        PartitionSet partMember;
        PartialRequestStatus status;
        RequestContext context;
        PartitionedCache service;
        block8: {
            com.tangosol.coherence.component.net.Member member;
            PartitionedCache.KeyIteratorRequest msg;
            block7: {
                Set set;
                service = this.getService();
                context = this.registerRequestContext(false);
                status = null;
                try {
                    msg = (PartitionedCache.KeyIteratorRequest)service.instantiateMessage("KeyIteratorRequest");
                    msg.setRequestContext(context);
                    msg.setCacheId(this.getCacheId());
                    status = this.ensureRequestTarget(partitions, status, msg);
                    if (!status.isTargetMissing()) break block7;
                    partitions.clear();
                    set = NullImplementation.getSet();
                    this.clearStatus(status);
                }
                catch (Throwable throwable) {
                    this.clearStatus(status);
                    service.unregisterRequestContext(context);
                    throw throwable;
                }
                service.unregisterRequestContext(context);
                return set;
            }
            Map mapByOwner = status.getPartitionsByOwner();
            com.tangosol.coherence.component.net.Member memberThis = service.getThisMember();
            if (mapByOwner.containsKey(memberThis)) {
                member = memberThis;
                partMember = (PartitionSet)mapByOwner.get(member);
            } else {
                Map.Entry entry = (Map.Entry)Base.randomize(mapByOwner.entrySet()).get(0);
                member = (com.tangosol.coherence.component.net.Member)entry.getKey();
                partMember = (PartitionSet)entry.getValue();
            }
            PartitionSet partMask = new PartitionSet(partMember);
            partRequest = new PartitionSet(partMember);
            msg.setToMemberSet(SingleMemberSet.instantiate(member));
            msg.setRequestMask(partMask);
            msg.setPartitions(partMember);
            msgResponse = (PartitionedCache.QueryResponse)service.poll(msg);
            if (msgResponse != null) break block8;
            Set set = NullImplementation.getSet();
            this.clearStatus(status);
            service.unregisterRequestContext(context);
            return set;
        }
        if (msgResponse.getException() != null) {
            throw msgResponse.getException();
        }
        partRequest.remove(partMember);
        partitions.remove(partRequest);
        ImmutableArrayList immutableArrayList = new ImmutableArrayList(msgResponse.getResult(), 0, msgResponse.getSize());
        this.clearStatus(status);
        service.unregisterRequestContext(context);
        return immutableArrayList;
    }

    protected Set limitQueryDistributed(PartitionSet partitions, LimitFilter filterLimit) {
        BinaryMap._assert(filterLimit.getComparator() != null);
        PartitionedCache service = this.getService();
        int cPageSize = filterLimit.getPageSize();
        Map mapByMember = service.splitByOwner(partitions, 0, service.getPartitionAssignments());
        if (mapByMember.size() == 0) {
            return NullImplementation.getSet();
        }
        int cBatch = filterLimit.getBatchSize();
        PartitionSet parts = this.getPartitions(mapByMember, Math.max(1, cBatch));
        LimitFilter filterPart = (LimitFilter)filterLimit.clone();
        PartitionSet partsQuery = new PartitionSet(parts);
        List listResponse = this.query(new PartitionSet(parts), filterPart, false);
        int cActual = 0;
        int cAvail = 0;
        for (PartitionedCache.QueryResponse response : listResponse) {
            if (response.getException() != null) {
                throw response.getException();
            }
            cActual += response.getSize();
            cAvail += response.getAvailable();
        }
        if (cActual < cPageSize && cAvail > cActual) {
            filterPart.setPageSize(cPageSize);
            for (PartitionedCache.QueryResponse response : listResponse) {
                int cPartAvail;
                int cPartActual = response.getSize();
                if (cPartActual != (cPartAvail = response.getAvailable())) continue;
                parts.remove(service.calculatePartitionSet(response.getFromMember(), 0));
            }
            if (!parts.isEmpty()) {
                listResponse.addAll(this.query(parts, filterPart, false));
            }
        }
        partitions.remove(partsQuery);
        long cbScratch = 0L;
        if (!partitions.isEmpty() && cBatch == 0) {
            cbScratch = service.reserveScratchSpace();
            this.estimateBatchSize((PartitionedCache.QueryResponse)listResponse.iterator().next(), filterLimit, cbScratch);
        }
        if (partitions.isEmpty() && cbScratch > 0L) {
            service.releaseScratchSpace(cbScratch);
        }
        return this.mergeQueryResponse(listResponse);
    }

    protected Set limitQuerySequential(PartitionSet partitions, LimitFilter filterLimit, boolean fKeysOnly) {
        Object[] objectArray;
        BinaryMap._assert(filterLimit.getComparator() == null);
        BinaryMap._assert(filterLimit.getTopAnchor() == null);
        BinaryMap._assert(filterLimit.getBottomAnchor() == null);
        PartitionedCache service = this.getService();
        int cPageSize = filterLimit.getPageSize();
        Object[] aoCookie = (Object[])filterLimit.getCookie();
        ArrayList<Object> listMember = java.util.Collections.emptyList();
        int cSkipMember = -1;
        int cSkipGlobal = -1;
        int cSkipActual = cPageSize * filterLimit.getPage();
        int cAdjustment = 0;
        if (aoCookie != null) {
            listMember = (ArrayList<Object>)aoCookie[0];
            cSkipMember = (Integer)aoCookie[1];
            cSkipGlobal = (Integer)aoCookie[2];
        }
        int cAvail = cSkipGlobal - cSkipMember;
        if (cSkipGlobal == cSkipActual) {
            cAdjustment = cAvail;
        } else if (cSkipGlobal != -1 && cSkipActual - cAvail >= 0) {
            cSkipMember += cSkipActual - cSkipGlobal;
            cSkipGlobal = cSkipActual;
            cAdjustment = cAvail;
        } else {
            Object[] aMember = service.getOwnershipMemberSet().toArray();
            int cMembers = aMember.length;
            int ofShuffle = Base.mod(System.identityHashCode(filterLimit), cMembers);
            if (ofShuffle != 0) {
                Object[] ao = new Object[cMembers];
                System.arraycopy(aMember, ofShuffle, ao, 0, cMembers - ofShuffle);
                System.arraycopy(aMember, 0, ao, cMembers - ofShuffle, ofShuffle);
                aMember = ao;
            }
            listMember = java.util.Collections.list(new SimpleEnumerator<Object>(aMember));
            cSkipMember = cSkipActual;
            cSkipGlobal = cSkipActual;
        }
        int cPartSize = cPageSize;
        HashSet setResult = new HashSet();
        int cEstimateAvail = 0;
        int cSample = 0;
        while (!listMember.isEmpty()) {
            int cParallelism = 1;
            if (cEstimateAvail < cPartSize && cEstimateAvail > 0 && cSkipMember == 0) {
                cParallelism = cPartSize / cEstimateAvail + 1;
            }
            List listQueryMember = listMember.subList(0, Math.min(listMember.size(), cParallelism));
            int cQueryMember = listQueryMember.size();
            PartitionSet partMember = new PartitionSet(service.getPartitionCount());
            Iterator iter = listQueryMember.iterator();
            while (iter.hasNext()) {
                partMember.add(service.calculatePartitionSet((Member)iter.next(), 0));
            }
            partMember.retain(partitions);
            if (partMember.isEmpty()) {
                listQueryMember.clear();
                continue;
            }
            LimitFilter filterPart = (LimitFilter)filterLimit.clone();
            filterPart.setPageSize(cPartSize);
            filterPart.setTopAnchor(cSkipMember);
            List listPart = this.query(partMember, filterPart, fKeysOnly);
            int cPartActual = 0;
            int cPartAvail = 0;
            LinkedList<PartitionedCache.QueryResponse> listResponse = new LinkedList<PartitionedCache.QueryResponse>();
            for (PartitionedCache.QueryResponse response : listPart) {
                if (response.getException() != null) {
                    throw response.getException();
                }
                listResponse.add(response);
                com.tangosol.coherence.component.net.Member member = response.getFromMember();
                listMember.remove(member);
                int cMemberAvail = response.getAvailable();
                int cMemberActual = response.getSize();
                cPartAvail += cMemberAvail;
                if ((cPartActual += cMemberActual) >= cPartSize) {
                    listMember.add(0, member);
                    cSkipMember += cMemberActual - (cPartActual - cPartSize);
                    break;
                }
                double dRatio = 1.0 / (double)(++cSample);
                cEstimateAvail = (int)Math.round((double)cMemberAvail * dRatio + (double)cEstimateAvail * (1.0 - dRatio));
            }
            if (cPartActual > 0) {
                Set setPart = this.mergeQueryResponse(listResponse, 0, cPartSize);
                int cMergeSize = setPart.size();
                setResult.addAll(setPart);
                cSkipGlobal += cMergeSize;
                if (listPart.size() != cQueryMember) {
                    listMember.clear();
                    break;
                }
                if (cPartActual >= cPartSize) break;
                cPartSize -= cMergeSize;
                cSkipActual = 0;
                cSkipMember = 0;
                continue;
            }
            cSkipMember = cSkipActual -= cAdjustment + cPartAvail;
            cAdjustment = 0;
        }
        if (listMember.isEmpty()) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = null;
            objectArray2[1] = -1;
            objectArray = objectArray2;
            objectArray2[2] = -1;
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = listMember;
            objectArray3[1] = cSkipMember;
            objectArray = objectArray3;
            objectArray3[2] = cSkipGlobal;
        }
        filterLimit.setCookie(objectArray);
        return setResult;
    }

    @Override
    public boolean lock(Object oKey) {
        return this.lock(oKey, 0L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean lock(Object oKey, long cWaitMillis) {
        KeyRequestStatus status = null;
        try {
            PartitionedCache service = this.getService();
            Binary binKey = (Binary)oKey;
            int nMemberId = service.getThisMember().getId();
            long cLeaseMillis = service.getStandardLeaseMillis();
            long lThreadId = service.getLeaseGranularity() == 0 ? Lease.getCurrentThreadId() : 0L;
            PartitionedCache.LockRequest msg = (PartitionedCache.LockRequest)service.instantiateMessage("LockRequest");
            msg.setCacheId(this.getCacheId());
            msg.setKey(binKey);
            msg.setLeaseHolderId(nMemberId);
            msg.setLeaseThreadId(lThreadId);
            msg.setLeaseMillis(cLeaseMillis);
            msg.setLeaseWaitMillis(cWaitMillis);
            while (true) {
                Object oResponse;
                if ((status = this.ensureRequestTarget(binKey, status, msg)).isTargetMissing()) {
                    boolean bl = false;
                    this.clearStatus(status);
                    return bl;
                }
                msg.setToMemberSet(status.getOwnerSet());
                try {
                    oResponse = service.poll(msg);
                }
                catch (RuntimeException e) {
                    boolean fInterrupt = Thread.interrupted();
                    try {
                        this.unlock(oKey);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    if (fInterrupt) {
                        Thread.currentThread().interrupt();
                    }
                    throw e;
                }
                if (this.checkResponse(msg, oResponse)) {
                    boolean bl = (Boolean)oResponse;
                    this.clearStatus(status);
                    return bl;
                }
                msg = (PartitionedCache.LockRequest)msg.cloneMessage();
            }
        }
        catch (Throwable throwable) {
            this.clearStatus(status);
            throw throwable;
        }
    }

    protected static RuntimeException logRemoteException(RuntimeException e) {
        if (Logger.isDiagnosabilityEnabled()) {
            BinaryMap._trace("Received a remote exception " + String.valueOf(e) + ": " + BinaryMap.getStackTrace(e), 2);
        }
        return e;
    }

    public PagedIterator.Advancer makeEntryAdvancer(boolean fValues, boolean fStrict) {
        EntryAdvancer advancer = (EntryAdvancer)this._newChild("EntryAdvancer");
        advancer.setKeyAdvancer(this.makeKeyAdvancer());
        advancer.setValues(fValues);
        advancer.setStrict(fStrict);
        return advancer;
    }

    public PagedIterator.Advancer makeKeyAdvancer() {
        return (KeyAdvancer)this._newChild("KeyAdvancer");
    }

    public PartitionSet makePartitionSet() {
        return this.getService().instantiatePartitionSet(true);
    }

    protected Map mergePartialMapResponse(List listResponse) {
        HashMap<Object, Object> mapResult = new HashMap<Object, Object>();
        HashSet setFailedKeys = null;
        RuntimeException exception = null;
        for (Message msg : listResponse) {
            RuntimeException ePartial;
            DistributedPartialResponse msgResponse;
            if (msg instanceof PartitionedCache.PartialMapResponse) {
                msgResponse = (PartitionedCache.PartialMapResponse)msg;
                ePartial = msgResponse.getException();
                if (ePartial != null) {
                    exception = ePartial;
                    Collection col = ((PartitionedCache.PartialMapResponse)msgResponse).getFailedKeys();
                    if (col != null) {
                        if (setFailedKeys == null) {
                            setFailedKeys = new HashSet();
                        }
                        setFailedKeys.addAll(col);
                    }
                }
                if (exception != null) continue;
                int cSize = ((PartitionedCache.PartialMapResponse)msgResponse).getSize();
                Object[] aoKey = ((PartitionedCache.PartialMapResponse)msgResponse).getKey();
                Object[] aoVal = ((PartitionedCache.PartialMapResponse)msgResponse).getValue();
                for (int i = 0; i < cSize; ++i) {
                    if (aoKey[i] == null || aoVal[i] == null) continue;
                    mapResult.put(aoKey[i], aoVal[i]);
                }
                continue;
            }
            msgResponse = (PartitionedCache.QueryResponse)msg;
            ePartial = msgResponse.getException();
            if (ePartial != null) {
                throw ePartial;
            }
            Object[] aoEntry = ((PartitionedCache.QueryResponse)msgResponse).getResult();
            int cEntries = ((PartitionedCache.QueryResponse)msgResponse).getSize();
            for (int i = 0; i < cEntries; ++i) {
                Map.Entry entry = (Map.Entry)aoEntry[i];
                Object oKey = PartitionedCache.QueryResponse.extractBinaryKey(entry);
                Object oVal = PartitionedCache.QueryResponse.extractBinaryValue(entry);
                if (oKey == null || oVal == null) continue;
                mapResult.put(oKey, oVal);
            }
        }
        if (exception != null) {
            RequestIncompleteException e = new RequestIncompleteException("Partial failure", exception);
            e.setPartialResult(setFailedKeys);
            throw e;
        }
        return mapResult;
    }

    protected List mergePartialResponse(List listResponse) {
        ArrayList<Object> listResults = new ArrayList<Object>(listResponse.size());
        for (Message msg : listResponse) {
            ResponseMessage msgResponse;
            if (msg instanceof Grid.Response) {
                msgResponse = (Grid.Response)msg;
                switch (((SimpleResponse)msgResponse).getResult()) {
                    case 0: {
                        listResults.add(((SimpleResponse)msgResponse).getValue());
                        break;
                    }
                    case 2: {
                        throw BinaryMap.logRemoteException(((SimpleResponse)msgResponse).getFailure());
                    }
                    default: {
                        throw new IllegalStateException("Invalid partial response: " + String.valueOf(msgResponse));
                    }
                }
                continue;
            }
            msgResponse = (PartitionedCache.PartialValueResponse)msg;
            RuntimeException exception = ((DistributedPartialResponse)msgResponse).getException();
            if (exception != null) {
                throw BinaryMap.logRemoteException(exception);
            }
            Object oResult = ((PartitionedCache.PartialValueResponse)msgResponse).getResult();
            if (oResult == null) continue;
            if (((PartitionedCache.PartialValueResponse)msgResponse).isCollection()) {
                listResults.addAll((Collection)oResult);
                continue;
            }
            listResults.add(oResult);
        }
        return listResults;
    }

    protected Set mergeQueryResponse(List listResponse) {
        return this.mergeQueryResponse(listResponse, 0, 0);
    }

    protected Set mergeQueryResponse(List listResponse, int cSkip, int cLimit) {
        int cSize = 0;
        for (PartitionedCache.QueryResponse msgResponse : listResponse) {
            cSize += msgResponse.getSize();
        }
        ArrayList<Object> listMerge = new ArrayList<Object>(cLimit > 0 ? cLimit : cSize);
        int cMerge = 0;
        block1: for (PartitionedCache.QueryResponse msgResponse : listResponse) {
            if (msgResponse.getException() != null) {
                throw BinaryMap.logRemoteException(msgResponse.getException());
            }
            Object[] aoEntry = msgResponse.getResult();
            int cEntries = msgResponse.getSize();
            if (cSkip >= cEntries) {
                cSkip -= cEntries;
                continue;
            }
            for (int i = 0; i < cEntries; ++i) {
                if (cSkip > 0) {
                    --cSkip;
                    continue;
                }
                Object oValue = aoEntry[i];
                listMerge.add(oValue instanceof Map.Entry ? PartitionedCache.QueryResponse.ensureSimpleEntry((Map.Entry)oValue) : oValue);
                if (++cMerge == cLimit) break block1;
            }
        }
        return new ImmutableArrayList(listMerge).getSet();
    }

    protected RuntimeException onMissingStorage(PartitionSet setOrphan) {
        PartitionedCache service = this.getService();
        if (service.isRunning()) {
            Object sMsg = service.getOwnershipMemberSet().isEmpty() ? "No storage-enabled nodes exist for service " + service.getServiceName() : (!this.isActive() ? "The reference to cache \"" + this.getCacheName() + "\" has been released" : "The storage is not available to complete the request");
            return new RequestPolicyException((String)sMsg);
        }
        return new ServiceStoppedException("Service " + service.getServiceName() + " has been terminated");
    }

    protected void postPartitionedRequest(KeySetRequest msgRequest, Set setKeys) {
        PartitionedCache service = this.getService();
        Map mapByOwner = service.splitKeysByOwner(setKeys.iterator(), 0, service.getPartitionAssignments());
        boolean fClone = false;
        for (Map.Entry entry : mapByOwner.entrySet()) {
            com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)entry.getKey();
            Set setMember = (Set)entry.getValue();
            if (fClone) {
                msgRequest = (KeySetRequest)msgRequest.cloneMessage();
            } else {
                fClone = true;
            }
            msgRequest.setToMemberSet(SingleMemberSet.instantiate(member));
            msgRequest.setKeySet(setMember);
            service.post(msgRequest);
        }
    }

    protected RequestTimeoutException processPartitionedRequestTimeout(RequestTimeoutException eTimeout, int nResponseType) {
        Object oResult = null;
        List listParts = (List)eTimeout.getPartialResult();
        try {
            switch (nResponseType) {
                case 1: {
                    oResult = this.mergePartialResponse(listParts);
                    break;
                }
                case 2: {
                    oResult = this.mergeQueryResponse(listParts);
                    break;
                }
                case 3: {
                    oResult = this.mergePartialMapResponse(listParts);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        eTimeout.setPartialResult(oResult);
        return eTimeout;
    }

    @Override
    public Object put(Object oKey, Object oValue) {
        return this.put(oKey, oValue, 0L, true);
    }

    @Override
    public Object put(Object oKey, Object oValue, long cMillis) {
        return this.put(oKey, oValue, cMillis, true);
    }

    public Object put(Object oKey, Object oValue, long cMillis, boolean fReturn) {
        Object var12_11;
        PartitionedCache.PutRequest msg;
        PartitionedCache service = this.getService();
        KeyRequestStatus status = null;
        RequestContext context = this.registerRequestContext(true);
        try {
            Binary binKey = (Binary)oKey;
            Binary binValue = (Binary)oValue;
            msg = (PartitionedCache.PutRequest)service.instantiateMessage("PutRequest");
            msg.setRequestContext(context);
            msg.setCacheId(this.getCacheId());
            msg.setKey(binKey);
            msg.setValue(binValue);
            msg.setExpiryDelay(cMillis);
            msg.setReturnRequired(fReturn);
            while (true) {
                if (!(status = this.ensureRequestTarget(binKey, status, msg)).isTargetMissing()) break block5;
                var12_11 = null;
                break;
            }
        }
        catch (Throwable throwable) {
            service.unregisterRequestContext(context);
            this.clearStatus(status);
            throw throwable;
        }
        {
            block6: {
                block5: {
                    service.unregisterRequestContext(context);
                    this.clearStatus(status);
                    return var12_11;
                }
                msg.setToMemberSet(status.getOwnerSet());
                Object oResponse = service.poll(msg);
                if (!this.checkResponse(msg, oResponse)) break block6;
                Binary binary = (Binary)oResponse;
                service.unregisterRequestContext(context);
                this.clearStatus(status);
                return binary;
            }
            context.setOldestPendingSUID(service.getOldestPendingRequestSUID());
            msg = (PartitionedCache.PutRequest)msg.cloneMessage();
            continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void putAll(Map map) {
        block14: {
            cItems = map.size();
            if (cItems <= 1) {
                if (cItems != 1) return;
                entry = map.entrySet().iterator().next();
                this.put(entry.getKey(), entry.getValue(), 0L, false);
                return;
            }
            service = this.getService();
            status = null;
            context = this.registerRequestContext(true);
            try {
                listParts = new LinkedList<E>();
                msg = (PartitionedCache.PutAllRequest)service.instantiateMessage("PutAllRequest");
                msg.setRequestContext(context);
                msg.setCacheId(this.getCacheId());
lbl16:
                // 2 sources

                while (true) {
                    if ((status = this.ensureRequestTarget(map, status, msg)).isTargetMissing()) {
                    }
                    ** GOTO lbl-1000
                    break;
                }
            }
            catch (Throwable var16_18) {
                service.unregisterRequestContext(context);
                this.clearStatus(status);
                throw var16_18;
            }
            service.unregisterRequestContext(context);
            this.clearStatus(status);
            return;
lbl-1000:
            // 1 sources

            {
                mapByPartition = status.getEntriesByPartition();
                lstMsg = new LinkedList<PartitionedCache.PutAllRequest>();
                cTotal = 0;
                for (Map.Entry<K, V> entry : mapByPartition.entrySet()) {
                    nPart = (Integer)entry.getKey();
                    mapPart = (Map)entry.getValue();
                    owner = service.getPrimaryOwner(nPart);
                    if (owner == null) {
                        status.getOrphanedEntries().put(nPart, mapPart);
                    } else {
                        msg = (PartitionedCache.PutAllRequest)msg.cloneMessage();
                        msg.setToMemberSet(SingleMemberSet.instantiate(owner));
                        msg.setMap(mapPart);
                        msg.setPartResults(listParts);
                        lstMsg.add(msg);
                    }
                    cTotal += mapPart.size();
                }
                service.poll(lstMsg, msg.checkTimeoutRemaining());
                mapResend = status.getOrphanedEntries();
                for (PartitionedCache.PutAllRequest msg : lstMsg) {
                    mapPart = msg.getMap();
                    if (mapPart == null || mapPart.isEmpty()) continue;
                    mapResend.put(service.getKeyPartition((Binary)mapPart.keySet().iterator().next()), mapPart);
                }
                cResend = 0;
                iter = mapResend.values().iterator();
                while (iter.hasNext()) {
                    cResend += ((Map)iter.next()).size();
                }
                if (cResend == 0) {
                    this.validatePartialResponse(listParts);
                    break block14;
                }
                partOrphaned = new PartitionSet(service.getPartitionCount());
                iter = mapResend.keySet().iterator();
                while (iter.hasNext()) {
                    partOrphaned.add((Integer)iter.next());
                }
                status.setOrphanedPartitions(partOrphaned);
                if (service.getOwnershipMemberSet().isEmpty()) {
                    setOrphans = status.getOrphanedPartitions();
                    this.clearStatus(status);
                    throw this.onMissingStorage(setOrphans);
                }
                BinaryMap.reportRepeat("PutAllRequest", cResend, cTotal, partOrphaned);
                map = mapResend;
                context.setOldestPendingSUID(service.getOldestPendingRequestSUID());
                ** continue;
            }
        }
        service.unregisterRequestContext(context);
        this.clearStatus(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List query(PartitionSet partitions, Filter filter, boolean fKeysOnly) {
        PartitionedCache service = this.getService();
        RequestContext context = this.registerRequestContext(false);
        try {
            PartitionedCache.QueryRequest msg = service.isVersionCompatible(BinaryMap::isPartitionedQueryCompatible) ? (PartitionedCache.QueryRequest)service.instantiateMessage("PartitionedQueryRequest") : (PartitionedCache.QueryRequest)service.instantiateMessage("QueryRequest");
            msg.setRequestContext(context);
            msg.setCacheId(this.getCacheId());
            msg.setFilter(filter);
            msg.setKeysOnly(fKeysOnly);
            if (filter instanceof PriorityTask) {
                msg.copyPriorityAttributes((PriorityTask)((Object)filter));
            }
            List list = this.sendPartitionedRequest(msg, partitions, false);
            return list;
        }
        finally {
            service.unregisterRequestContext(context);
        }
    }

    protected long registerFilter(Filter filter) {
        long lFilterId = this.getService().getSUID(1);
        this.getFilterArray().set(lFilterId, filter);
        return lFilterId;
    }

    protected RequestContext registerRequestContext(boolean fRequired) {
        RequestContext context = null;
        if (this.isAuthorizationEnabled()) {
            context = this.getService().registerRequestContext(null);
            context.setSubject(SecurityHelper.getCurrentSubject());
        } else if (fRequired) {
            context = this.getService().registerRequestContext(null);
        }
        return context;
    }

    @Override
    public void release() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object oKey) {
        return this.remove(oKey, true);
    }

    public Object remove(Object oKey, boolean fReturn) {
        Object var8_8;
        PartitionedCache.RemoveRequest msg;
        PartitionedCache service = this.getService();
        KeyRequestStatus status = null;
        RequestContext context = this.registerRequestContext(true);
        try {
            Binary binKey = (Binary)oKey;
            msg = (PartitionedCache.RemoveRequest)service.instantiateMessage("RemoveRequest");
            msg.setRequestContext(context);
            msg.setCacheId(this.getCacheId());
            msg.setKey(binKey);
            msg.setReturnRequired(fReturn);
            while (true) {
                if (!(status = this.ensureRequestTarget(binKey, status, msg)).isTargetMissing()) break block5;
                var8_8 = null;
                break;
            }
        }
        catch (Throwable throwable) {
            service.unregisterRequestContext(context);
            this.clearStatus(status);
            throw throwable;
        }
        {
            block6: {
                block5: {
                    service.unregisterRequestContext(context);
                    this.clearStatus(status);
                    return var8_8;
                }
                msg.setToMemberSet(status.getOwnerSet());
                Object oResponse = service.poll(msg);
                if (!this.checkResponse(msg, oResponse)) break block6;
                Binary binary = (Binary)oResponse;
                service.unregisterRequestContext(context);
                this.clearStatus(status);
                return binary;
            }
            context.setOldestPendingSUID(service.getOldestPendingRequestSUID());
            msg = (PartitionedCache.RemoveRequest)msg.cloneMessage();
            continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection colKeys) {
        Set setKeys = colKeys instanceof Set ? (Set)colKeys : new HashSet(colKeys);
        int cKeys = setKeys.size();
        if (cKeys == 0) {
            return false;
        }
        if (cKeys == 1) {
            Binary binKey = (Binary)setKeys.iterator().next();
            return this.remove((Object)binKey, false) != null;
        }
        PartitionedCache service = this.getService();
        RequestContext context = this.registerRequestContext(true);
        try {
            List listResponse;
            RequestTimeoutException eTimeout;
            block11: {
                PartitionedCache.RemoveAllRequest msg = (PartitionedCache.RemoveAllRequest)service.instantiateMessage("RemoveAllRequest");
                msg.setRequestContext(context);
                msg.setCacheId(this.getCacheId());
                eTimeout = null;
                try {
                    listResponse = this.sendPartitionedRequest(msg, setKeys);
                }
                catch (RequestTimeoutException e) {
                    eTimeout = e;
                    listResponse = (List)e.getPartialResult();
                    if (listResponse != null) break block11;
                    throw e;
                }
            }
            for (PartitionedCache.PartialValueResponse response : listResponse) {
                RuntimeException exception = response.getException();
                if (exception != null) {
                    throw exception;
                }
                Object oResult = response.getResult();
                if (oResult == null) continue;
                boolean bl = true;
                return bl;
            }
            if (eTimeout != null) {
                eTimeout.setPartialResult(null);
                throw eTimeout;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            service.unregisterRequestContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIndex(ValueExtractor extractor) {
        PartitionedCache service = this.getService();
        RequestContext context = this.registerRequestContext(false);
        try {
            PartitionedCache.IndexRequest msg = (PartitionedCache.IndexRequest)service.instantiateMessage("IndexRequest");
            msg.setRequestContext(context);
            msg.setCacheId(this.getCacheId());
            msg.setAdd(false);
            msg.setExtractor(extractor);
            this.sendStorageRequest(msg);
        }
        finally {
            service.unregisterRequestContext(context);
        }
    }

    @Override
    public void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, (Filter)null, null);
    }

    @Override
    public void removeMapListener(MapListener listener, Filter filter) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMapListener(MapListener listener, Filter filter, MapTrigger trigger) {
        PartitionedCache service;
        MemberSet setOwners;
        long lFilterId = 0L;
        if (trigger == null) {
            MapListenerSupport support;
            MapListenerSupport mapListenerSupport = support = this.getListenerSupport();
            synchronized (mapListenerSupport) {
                if (!support.removeListenerWithCheck(listener, filter)) {
                    return;
                }
                lFilterId = this.getFilterId(filter);
                this.getFilterArray().remove(lFilterId);
            }
        }
        if ((setOwners = (service = this.getService()).getOwnershipMemberSet()).isEmpty()) {
            return;
        }
        RequestContext context = this.registerRequestContext(false);
        try {
            PartitionedCache.ListenerRequest msg = (PartitionedCache.ListenerRequest)service.instantiateMessage("ListenerRequest");
            msg.setToMemberSet(setOwners);
            msg.setRequestContext(context);
            msg.setCacheId(this.getCacheId());
            msg.setAdd(false);
            msg.setFilter(filter);
            msg.setFilterId(lFilterId);
            msg.setTrigger(trigger);
            msg.setMemberId(service.getThisMember().getId());
            msg.setPartitions(this.makePartitionSet());
            service.checkQuorum(msg, msg.isReadOnly());
            if (listener instanceof MapListenerSupport.SynchronousListener) {
                service.send(msg);
            } else {
                this.sendStorageRequest(msg);
            }
        }
        finally {
            service.unregisterRequestContext(context);
        }
    }

    @Override
    public void removeMapListener(MapListener listener, Object oKey) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeMapListener(MapListener listener, Object oKey, boolean fPriming) {
        binKey = (Binary)oKey;
        if (!this.getListenerSupport().removeListenerWithCheck(listener, binKey)) {
            return;
        }
        status = null;
        try {
            service = this.getService();
            iPartition = service.getKeyPartition(binKey);
            msg = (PartitionedCache.KeyListenerRequest)service.instantiateMessage("KeyListenerRequest");
            msg.setCacheId(this.getCacheId());
            msg.setKey(binKey);
            msg.setAdd(false);
            msg.setPriming(fPriming);
lbl13:
            // 3 sources

            while (true) {
                if (status == null) {
                    status = new KeyRequestStatus();
                    status.setPartition(iPartition);
                    this._linkChild(status);
                } else {
                    this.waitForRedistribution(status, msg.getRequestTimeout());
                }
                service.checkQuorum(msg, msg.isReadOnly());
                memberOwner = service.getPrimaryOwner(iPartition);
                if (memberOwner == null) {
                    if (service.getOwnershipMemberSet().isEmpty()) {
                        this.clearStatus(status);
                        return;
                    }
                }
                ** GOTO lbl-1000
                break;
            }
        }
        catch (Throwable var11_11) {
            this.clearStatus(status);
            throw var11_11;
        }
        {
            if (Thread.currentThread() != service.getThread()) ** GOTO lbl-1000
            this.clearStatus(status);
            return;
        }
lbl-1000:
        // 1 sources

        {
            if (!(listener instanceof MapListenerSupport.SynchronousListener)) ** GOTO lbl13
            this.clearStatus(status);
            return;
        }
lbl-1000:
        // 1 sources

        {
            status.setOwner(memberOwner);
            msg.setToMemberSet(status.getOwnerSet());
            if (listener instanceof MapListenerSupport.SynchronousListener) {
                service.send(msg);
            } else {
                oResponse = service.poll(msg);
                if (!this.checkResponse(msg, oResponse)) {
                    msg = (PartitionedCache.KeyListenerRequest)msg.cloneMessage();
                    ** continue;
                }
            }
            this.clearStatus(status);
            return;
        }
    }

    public void removeMapListener(MapListener listener, Set setBinKeys, boolean fPriming) {
        setBinKeys = new HashSet(setBinKeys);
        this.getListenerSupport().removeListenerWithCheck(listener, setBinKeys);
        if (!setBinKeys.isEmpty()) {
            this.sendMapListenerAllRequest(listener, setBinKeys, true, fPriming, false, null);
        }
    }

    public static void reportRepeat(String sRequest, int cItems, int cTotal, PartitionSet partitions) {
        StringBuilder sb = new StringBuilder();
        sb.append("Repeating ").append(sRequest);
        if (cItems > 0) {
            sb.append(" for ").append(cItems);
            if (cTotal > 0) {
                sb.append(" out of ").append(cTotal);
            }
            sb.append(" items");
        }
        if (partitions != null) {
            sb.append(" due to the re-distribution of ").append(partitions);
        }
        BinaryMap._trace(sb.toString(), 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMapListenerAllRequest(MapListener listener, Set setBinKeys, boolean fLite, boolean fPriming, boolean fAdd, VersionedPartitions versions) {
        PartitionedCache service = this.getService();
        RequestContext context = this.registerRequestContext(false);
        try {
            PartitionedCache.KeyListenerAllRequest msg = (PartitionedCache.KeyListenerAllRequest)service.instantiateMessage("KeyListenerAllRequest");
            msg.setRequestContext(context);
            msg.setCacheId(this.getCacheId());
            msg.setAdd(fAdd);
            msg.setLite(fLite);
            msg.setPriming(fPriming);
            msg.setPartitionVersions(versions);
            if (fAdd || !(listener instanceof MapListenerSupport.SynchronousListener)) {
                this.mergePartialMapResponse(this.sendPartitionedRequest(msg, setBinKeys));
            } else {
                this.postPartitionedRequest(msg, setBinKeys);
            }
        }
        finally {
            service.unregisterRequestContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMapListenerRequest(long lFilterId, Filter filter, MapTrigger trigger, boolean fLite, VersionedPartitions versions) {
        PartitionedCache service = this.getService();
        RequestContext context = this.registerRequestContext(true);
        try {
            PartitionedCache.ListenerRequest msg = (PartitionedCache.ListenerRequest)service.instantiateMessage("ListenerRequest");
            msg.setRequestContext(context);
            msg.setCacheId(this.getCacheId());
            msg.setAdd(true);
            msg.setFilter(filter);
            msg.setFilterId(lFilterId);
            msg.setLite(fLite);
            msg.setTrigger(trigger);
            msg.setPartitionVersions(versions);
            msg.setMemberId(service.getThisMember().getId());
            msg.setPartitions(this.makePartitionSet());
            this.sendStorageRequest(msg);
        }
        finally {
            service.unregisterRequestContext(context);
        }
    }

    /*
     * Loose catch block
     */
    protected void sendMapListenerRequest(Binary binKey, boolean fLite, boolean fPriming, boolean fVersioned, long lVersion) {
        PartitionedCache.KeyListenerRequest msg;
        PartitionedCache service = this.getService();
        RequestContext context = this.registerRequestContext(false);
        KeyRequestStatus status = null;
        while (true) {
            msg = (PartitionedCache.KeyListenerRequest)service.instantiateMessage("KeyListenerRequest");
            msg.setRequestContext(context);
            msg.setCacheId(this.getCacheId());
            msg.setKey(binKey);
            msg.setAdd(true);
            msg.setLite(fLite);
            msg.setPriming(fPriming);
            if (fVersioned) {
                msg.setPartitionVersion(lVersion);
            }
            if (!(status = this.ensureRequestTarget(binKey, status, msg)).isTargetMissing()) break block6;
            this.clearStatus(status);
            break;
        }
        catch (Throwable throwable) {
            this.clearStatus(status);
            service.unregisterRequestContext(context);
            throw throwable;
        }
        {
            block7: {
                block6: {
                    service.unregisterRequestContext(context);
                    return;
                }
                msg.setToMemberSet(status.getOwnerSet());
                Object oResponse = service.poll(msg);
                if (!this.checkResponse(msg, oResponse)) break block7;
                this.clearStatus(status);
                service.unregisterRequestContext(context);
                return;
            }
            continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List sendPartitionedRequest(KeySetRequest msgRequest, Set setKeys) {
        KeySetRequestStatus status = null;
        try {
            LinkedList linkedList;
            PartitionedCache service = this.getService();
            LinkedList listParts = new LinkedList();
            Set setResend = setKeys;
            boolean fClone = false;
            while (true) {
                int iMsg;
                if ((status = this.ensureRequestTarget(setResend, status, msgRequest)).isTargetMissing()) {
                    linkedList = listParts;
                    this.clearStatus(status);
                    return linkedList;
                }
                Map mapByOwner = status.getKeysByOwner();
                int cMsgs = mapByOwner.size();
                RequestMessage[] aMsg = new KeySetRequest[cMsgs];
                com.tangosol.coherence.component.net.Member memberThis = service.getThisMember();
                int iMsgThis = -1;
                Iterator iter = mapByOwner.entrySet().iterator();
                for (iMsg = 0; iMsg < cMsgs; ++iMsg) {
                    Map.Entry entry = iter.next();
                    com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)entry.getKey();
                    Set setMember = (Set)entry.getValue();
                    if (member == memberThis) {
                        iMsgThis = iMsg;
                    }
                    if (fClone) {
                        msgRequest = (KeySetRequest)msgRequest.cloneMessage();
                    } else {
                        fClone = true;
                    }
                    msgRequest.setToMemberSet(SingleMemberSet.instantiate(member));
                    msgRequest.setKeySet(setMember);
                    msgRequest.setPartResults(listParts);
                    aMsg[iMsg] = msgRequest;
                }
                if (iMsgThis != -1) {
                    KeySetRequest msgSwap = aMsg[cMsgs - 1];
                    aMsg[cMsgs - 1] = aMsg[iMsgThis];
                    aMsg[iMsgThis] = msgSwap;
                }
                try {
                    service.poll(aMsg, msgRequest.checkTimeoutRemaining());
                }
                catch (RequestTimeoutException e) {
                    e.setPartialResult(listParts);
                    throw e;
                }
                setResend = status.getOrphanedKeys();
                for (iMsg = 0; iMsg < cMsgs; ++iMsg) {
                    Set setReject = ((KeySetRequest)aMsg[iMsg]).getKeySet();
                    if (setReject == null || setReject.isEmpty()) continue;
                    if (setResend == null) {
                        setResend = new HashSet();
                    }
                    setResend.addAll(setReject);
                }
                if (setResend == null || setResend.isEmpty()) break;
                BinaryMap.reportRepeat(msgRequest.get_Name(), setResend.size(), setKeys.size(), service.calculatePartitionSet(setResend));
                RequestContext context = msgRequest.getRequestContext();
                if (context == null) continue;
                context.setOldestPendingSUID(service.getOldestPendingRequestSUID());
            }
            linkedList = listParts;
            this.clearStatus(status);
            return linkedList;
        }
        catch (Throwable throwable) {
            this.clearStatus(status);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List sendPartitionedRequest(PartialRequest msgRequest, PartitionSet partitions, boolean fInternal) {
        LinkedList listParts = new LinkedList();
        if (partitions.isEmpty()) {
            return listParts;
        }
        PartialRequestStatus status = null;
        try {
            PartitionedCache service = this.getService();
            boolean fClone = false;
            while (true) {
                RequestContext context;
                LinkedList linkedList;
                if ((status = this.ensureRequestTarget(partitions, status, msgRequest)).isTargetMissing()) {
                    linkedList = listParts;
                    this.clearStatus(status);
                    return linkedList;
                }
                Map mapByOwner = status.getPartitionsByOwner();
                if (mapByOwner.size() == 1) {
                    if (fClone) {
                        msgRequest = (PartialRequest)msgRequest.cloneMessage();
                    } else {
                        fClone = true;
                    }
                    com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)mapByOwner.keySet().iterator().next();
                    PartitionSet partMember = (PartitionSet)mapByOwner.get(member);
                    msgRequest.setToMemberSet(SingleMemberSet.instantiate(member));
                    msgRequest.setPartResults(listParts);
                    msgRequest.setRequestMask(partMember);
                    msgRequest.setRepliesMask(new PartitionSet(partMember));
                    msgRequest.setPartitions(partitions);
                    service.poll(msgRequest);
                } else {
                    int cMsgs = mapByOwner.size();
                    RequestMessage[] aMsg = new PartialRequest[cMsgs];
                    com.tangosol.coherence.component.net.Member memberThis = service.getThisMember();
                    int iMsgThis = -1;
                    Iterator iter = mapByOwner.entrySet().iterator();
                    for (int iMsg = 0; iMsg < cMsgs; ++iMsg) {
                        Map.Entry entry = iter.next();
                        com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)entry.getKey();
                        PartitionSet partMember = (PartitionSet)entry.getValue();
                        if (member == memberThis) {
                            iMsgThis = iMsg;
                        }
                        if (fClone) {
                            msgRequest = (PartialRequest)msgRequest.cloneMessage();
                        } else {
                            fClone = true;
                        }
                        msgRequest.setToMemberSet(SingleMemberSet.instantiate(member));
                        msgRequest.setRequestMask(partMember);
                        msgRequest.setPartResults(listParts);
                        msgRequest.setRepliesMask(new PartitionSet(partMember));
                        msgRequest.setPartitions(partitions);
                        aMsg[iMsg] = msgRequest;
                    }
                    if (iMsgThis != -1) {
                        PartialRequest msgSwap = aMsg[cMsgs - 1];
                        aMsg[cMsgs - 1] = aMsg[iMsgThis];
                        aMsg[iMsgThis] = msgSwap;
                    }
                    try {
                        service.poll(aMsg, msgRequest.checkTimeoutRemaining());
                    }
                    catch (RequestTimeoutException e) {
                        e.setPartialResult(listParts);
                        throw e;
                    }
                }
                if (partitions.isEmpty()) {
                    linkedList = listParts;
                    this.clearStatus(status);
                    return linkedList;
                }
                if (!fInternal) {
                    BinaryMap.reportRepeat(msgRequest.get_Name(), 0, 0, partitions);
                }
                if ((context = msgRequest.getRequestContext()) == null) continue;
                context.setOldestPendingSUID(service.getOldestPendingRequestSUID());
            }
        }
        catch (Throwable throwable) {
            this.clearStatus(status);
            throw throwable;
        }
    }

    protected Object sendStorageRequest(StorageRequest msgRequest) {
        PartitionedCache service = this.getService();
        PartitionSet parts = msgRequest.getRequestPartitions();
        if (parts == null) {
            parts = this.makePartitionSet();
        }
        while (true) {
            com.tangosol.coherence.component.net.Member memberSenior;
            if ((memberSenior = service.getOwnershipSenior(true)) == null || !this.isActive()) {
                throw this.onMissingStorage(parts);
            }
            this.ensureRequestTarget(parts, msgRequest);
            service.checkQuorum(msgRequest, msgRequest.isReadOnly());
            msgRequest.addToMember(memberSenior);
            Object oResult = service.poll(msgRequest);
            if (this.checkResponse(msgRequest, oResult)) {
                parts.remove((PartitionSet)oResult);
                if (parts.isEmpty()) {
                    return oResult;
                }
            }
            BinaryMap._trace("Repeating " + msgRequest.get_Name(), 5);
            msgRequest = (StorageRequest)msgRequest.cloneMessage();
        }
    }

    protected void setAuthorizationEnabled(boolean fEnabled) {
        this.__m_AuthorizationEnabled = fEnabled;
    }

    public void setCacheId(long lCacheId) {
        this.__m_CacheId = lCacheId;
    }

    public void setCacheName(String sCacheName) {
        this.__m_CacheName = sCacheName;
        try {
            this.setAuthorizationEnabled(this.getService().getBackingMapManager().getStorageAccessAuthorizer(sCacheName) != null);
        }
        catch (RuntimeException e) {
            BinaryMap._trace("BackingMapManager " + this.getService().getBackingMapManager().getClass().getName() + ": disabling StorageAccessAuthorizer due to failure to access it for cache: " + sCacheName, 1);
            this.setAuthorizationEnabled(false);
        }
    }

    public void setConfirmed(boolean fConfirmed) {
        this.__m_Confirmed = fConfirmed;
    }

    public void setDispatcher(StorageDispatcher dispatcher) {
        this.__m_Dispatcher = dispatcher;
    }

    protected void setFilterArray(LongArray array) {
        this.__m_FilterArray = array;
    }

    protected void setListenerSupport(MapListenerSupport support) {
        this.__m_ListenerSupport = support;
    }

    public void setReadLocator(BiFunction function) {
        this.__m_ReadLocator = function;
    }

    @Override
    public int size() {
        List listResponse;
        RequestTimeoutException eTimeout;
        block5: {
            PartitionedCache.SizeRequest msg = (PartitionedCache.SizeRequest)this.getService().instantiateMessage("SizeRequest");
            msg.setCacheId(this.getCacheId());
            eTimeout = null;
            try {
                listResponse = this.sendPartitionedRequest(msg, this.makePartitionSet(), false);
            }
            catch (RequestTimeoutException e) {
                eTimeout = e;
                listResponse = (List)e.getPartialResult();
                if (listResponse != null) break block5;
                throw e;
            }
        }
        int cSize = 0;
        for (PartitionedCache.PartialValueResponse response : listResponse) {
            RuntimeException exception = response.getException();
            if (exception != null) {
                throw exception;
            }
            Object oResult = response.getResult();
            if (!(oResult instanceof Integer)) continue;
            cSize += ((Integer)oResult).intValue();
        }
        if (eTimeout != null) {
            eTimeout.setPartialResult(cSize);
            throw eTimeout;
        }
        return cSize;
    }

    @Override
    public void truncate() {
        PartitionedCache service = this.getService();
        RequestContext context = this.registerRequestContext(false);
        try {
            PartitionedCache.ClearRequest msg = (PartitionedCache.ClearRequest)service.instantiateMessage("ClearRequest");
            msg.setRequestContext(context);
            msg.setCacheId(this.getCacheId());
            msg.setTruncate(true);
            this.mergePartialResponse(this.sendPartitionedRequest(msg, this.makePartitionSet(), false));
        }
        catch (RequestTimeoutException e) {
            throw this.processPartitionedRequestTimeout(e, 0);
        }
        finally {
            service.unregisterRequestContext(context);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean unlock(Object oKey) {
        PartitionedCache service = this.getService();
        Binary binKey = (Binary)oKey;
        int nMemberId = service.getThisMember().getId();
        long lThreadId = service.getLeaseGranularity() == 0 ? Lease.getCurrentThreadId() : 0L;
        KeyRequestStatus status = null;
        try {
            PartitionedCache.UnlockRequest msg = (PartitionedCache.UnlockRequest)service.instantiateMessage("UnlockRequest");
            msg.setCacheId(this.getCacheId());
            msg.setKey(binKey);
            msg.setLeaseHolderId(nMemberId);
            msg.setLeaseThreadId(lThreadId);
            while (true) {
                if ((status = this.ensureRequestTarget(binKey, status, msg)).isTargetMissing()) {
                    boolean bl = false;
                    this.clearStatus(status);
                    return bl;
                }
                msg.setToMemberSet(status.getOwnerSet());
                Object oResponse = service.poll(msg);
                if (this.checkResponse(msg, oResponse)) {
                    boolean bl = (Boolean)oResponse;
                    this.clearStatus(status);
                    return bl;
                }
                msg = (PartitionedCache.UnlockRequest)msg.cloneMessage();
            }
        }
        catch (Throwable throwable) {
            this.clearStatus(status);
            throw throwable;
        }
    }

    protected void validatePartialResponse(List listResponse) {
        RuntimeException exception = null;
        HashSet setFailedKeys = null;
        for (Message msg : listResponse) {
            ResponseMessage msgResponse;
            if (msg instanceof Grid.Response) {
                msgResponse = (Grid.Response)msg;
                switch (((SimpleResponse)msgResponse).getResult()) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        throw ((SimpleResponse)msgResponse).getFailure();
                    }
                    default: {
                        throw new IllegalStateException("Invalid partial response: " + String.valueOf(msgResponse));
                    }
                }
                continue;
            }
            msgResponse = (PartitionedCache.PartialValueResponse)msg;
            RuntimeException ePartial = ((DistributedPartialResponse)msgResponse).getException();
            if (ePartial == null) continue;
            exception = ePartial;
            Collection col = ((PartitionedCache.PartialValueResponse)msgResponse).getFailedKeys();
            if (col == null) continue;
            if (setFailedKeys == null) {
                setFailedKeys = new HashSet();
            }
            setFailedKeys.addAll(col);
        }
        if (exception != null) {
            RequestIncompleteException e = new RequestIncompleteException("Partial failure", exception);
            e.setPartialResult(setFailedKeys);
            throw e;
        }
    }

    @Override
    public Collection values() {
        return (Values)this._findChild("Values");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void waitForPartitionRedistribution(Map mapRejected, long ldtTimeout) {
        service = this.getService();
        aContention = service.getPartitionContention();
        nBaseMonitor = System.identityHashCode(aContention);
        threadThis = Thread.currentThread();
        WAIT_MILLIS = 200L;
        cRejected = mapRejected.size();
        if (cRejected == 0) {
            return;
        }
        cCleared = 0;
        cChanged = 0;
        block8: while (true) {
            listContentions = new LinkedList<PartitionedService.Contention>();
            partsProcessed = new PartitionSet(aContention.length);
            iter = mapRejected.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                iPartition = (Integer)entry.getKey();
                if (partsProcessed.contains(iPartition)) continue;
                partsProcessed.add(iPartition);
                var19_19 = Base.getCommonMonitor(nBaseMonitor + iPartition);
                synchronized (var19_19) {
                    contention = aContention[iPartition];
                }
                if (contention == null) {
                    ++cCleared;
                    iter.remove();
                    continue;
                }
                memberOld = (Member)entry.getValue();
                memberNew = service.getPrimaryOwner(iPartition);
                if (memberNew != null && memberNew != memberOld) {
                    ++cChanged;
                    iter.remove();
                    continue;
                }
                listContentions.add(contention);
            }
            if (2 * (cCleared + cChanged) >= cRejected) {
                return;
            }
            iter = listContentions.iterator();
            do {
                if (!iter.hasNext()) continue block8;
                contention = (PartitionedService.Contention)iter.next();
                listThreads = contention.getWaitingThreads();
                fTrickle = false;
                var19_19 = contention;
                synchronized (var19_19) {
                    if (!listThreads.contains(threadThis)) {
                        listThreads.add(threadThis);
                    }
                    try {
                        if (!contention.isCleared()) {
                            Blocking.wait(contention, 200L);
                            if (Base.getSafeTimeMillis() >= ldtTimeout) {
                                listThreads.remove(threadThis);
                                throw new RequestTimeoutException("Request timed-out due to a redistribution delay");
                            }
                            fTrickle = listThreads.isEmpty() == false && threadThis == listThreads.get(0);
                        }
                    }
                    catch (InterruptedException e) {
                        threadThis.interrupt();
                        throw Base.ensureRuntimeException(e);
                    }
                }
                if (!contention.isCleared()) ** break;
                continue block8;
            } while (!fTrickle);
            break;
        }
    }

    protected void waitForRedistribution(PartitionSet partsRejected, PartialRequestStatus status, long ldtTimeout) {
        Map mapByOwner = status.getPartitionsByOwner();
        HashMap<Integer, Member> mapRejected = new HashMap<Integer, Member>();
        for (Map.Entry entry : mapByOwner.entrySet()) {
            Member member = (Member)entry.getKey();
            PartitionSet partsMember = (PartitionSet)entry.getValue();
            if (!partsMember.intersects(partsRejected)) continue;
            partsMember = new PartitionSet(partsMember);
            partsMember.retain(partsRejected);
            int iPartition = partsMember.next(0);
            while (iPartition >= 0) {
                mapRejected.put(iPartition, member);
                iPartition = partsMember.next(iPartition + 1);
            }
        }
        if (mapRejected.isEmpty()) {
            PartitionedCache service = this.getService();
            int iPartition = partsRejected.next(0);
            while (iPartition >= 0) {
                mapRejected.put(iPartition, service.getPrimaryOwner(iPartition));
                iPartition = partsRejected.next(iPartition + 1);
            }
        }
        status.markInTransition(new PartitionSet(partsRejected));
        this.waitForPartitionRedistribution(mapRejected, ldtTimeout);
        status.setOrphanedPartitions(null);
    }

    protected void waitForRedistribution(Map mapRejectedEntries, MapRequestStatus status, long ldtTimeout) {
        Set setPartitions = mapRejectedEntries.keySet();
        status.markInTransition(status.getOrphanedPartitions());
        HashMap<Integer, Object> mapParts = new HashMap<Integer, Object>();
        for (Integer nPart : setPartitions) {
            mapParts.put(nPart, null);
        }
        this.waitForPartitionRedistribution(mapParts, ldtTimeout);
        status.setOrphanedEntries(null);
        status.setOrphanedPartitions(null);
    }

    protected void waitForRedistribution(Set setRejectedKeys, KeySetRequestStatus status, long ldtTimeout) {
        Map mapByOwner = status.getKeysByOwner();
        status.markInTransition(this.getService().calculatePartitionSet(setRejectedKeys));
        this.waitForPartitionRedistribution(this.collectRejectedPartitions(setRejectedKeys, mapByOwner), ldtTimeout);
        status.setOrphanedKeys(null);
        status.setOrphanedPartitions(null);
    }

    protected void waitForRedistribution(KeyRequestStatus status, long ldtTimeout) {
        LiteMap<Integer, com.tangosol.coherence.component.net.Member> mapRejected = new LiteMap<Integer, com.tangosol.coherence.component.net.Member>();
        mapRejected.put(status.getPartition(), status.getOwner());
        status.markInTransition();
        this.waitForPartitionRedistribution(mapRejected, ldtTimeout);
    }

    static {
        BinaryMap.__initStatic();
    }

    public static class Entry
    extends WrapperEntry {
        public Entry() {
            this(null, null, true);
        }

        public Entry(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Entry();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/BinaryMap$Entry".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent().get_Parent();
        }

        public BinaryMap getBinaryMap() {
            return (BinaryMap)this.get_Parent();
        }

        @Override
        public Object setValue(Object oValue) {
            this.getBinaryMap().put(this.getKey(), (Binary)oValue, 0L, false);
            return (Binary)super.setValue(oValue);
        }
    }

    public static class EntryAdvancer
    extends Util
    implements PagedIterator.Advancer {
        private transient int __m_EntrySetSize;
        private PagedIterator.Advancer __m_KeyAdvancer;
        private Set __m_KeySet;
        private boolean __m_Strict;
        private boolean __m_Values;

        public EntryAdvancer() {
            this(null, null, true);
        }

        public EntryAdvancer(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setKeySet(new HashSet());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new EntryAdvancer();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/BinaryMap$EntryAdvancer".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent().get_Parent();
        }

        protected Map entrySetPage(Set setKeys) {
            Set setKeysPage;
            BinaryMap mapBinary = this.getBinaryMap();
            int cKeys = setKeys.size();
            int cLimit = this.getEntrySetSize();
            if (cLimit > 0 && cKeys > cLimit) {
                Object[] aoKey = new Object[cLimit];
                Iterator iter = setKeys.iterator();
                for (int i = 0; iter.hasNext() && i < cLimit; ++i) {
                    aoKey[i] = iter.next();
                }
                setKeysPage = new ImmutableArrayList(aoKey);
            } else {
                setKeysPage = setKeys;
            }
            Map mapPart = mapBinary.getAll(setKeysPage, mapBinary.getService().getTransferThreshold());
            int cActual = mapPart.size();
            if (cActual == cKeys || cActual == 0) {
                setKeys.clear();
            } else {
                Iterator iter = mapPart.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    Binary binKey = (Binary)entry.getKey();
                    Binary binValue = (Binary)entry.getValue();
                    if (binValue == null) {
                        iter.remove();
                    }
                    setKeys.remove(binKey);
                }
                cLimit = cLimit == 0 ? cActual : (cActual < cLimit ? (cLimit -= (cLimit - cActual) / 2) : (cLimit += (cActual - cLimit) / 2));
                this.setEntrySetSize(cLimit);
            }
            return mapPart;
        }

        public BinaryMap getBinaryMap() {
            return (BinaryMap)this.get_Parent();
        }

        public int getEntrySetSize() {
            return this.__m_EntrySetSize;
        }

        public PagedIterator.Advancer getKeyAdvancer() {
            return this.__m_KeyAdvancer;
        }

        public Set getKeySet() {
            return this.__m_KeySet;
        }

        public boolean isStrict() {
            return this.__m_Strict;
        }

        public boolean isValues() {
            return this.__m_Values;
        }

        protected Map.Entry makeEntry(Map.Entry binEntry) {
            Entry entry = new Entry();
            entry.setEntry(binEntry);
            this.getBinaryMap()._linkChild(entry);
            return entry;
        }

        @Override
        public Collection nextPage() {
            Set setKeys = this.getKeySet();
            while (setKeys.isEmpty()) {
                Set setPage = (Set)this.getKeyAdvancer().nextPage();
                if (setPage == null) {
                    return null;
                }
                setKeys.addAll(setPage);
            }
            Map mapEntries = this.entrySetPage(setKeys);
            if (this.isStrict()) {
                HashSet<Map.Entry> setStrict = new HashSet<Map.Entry>();
                for (Map.Entry entry : mapEntries.entrySet()) {
                    setStrict.add(this.makeEntry(entry));
                }
                return setStrict;
            }
            return this.isValues() ? mapEntries.values() : mapEntries.entrySet();
        }

        @Override
        public void remove(Object oCurr) {
            if (this.isValues()) {
                throw new UnsupportedOperationException();
            }
            this.getBinaryMap().remove(((Map.Entry)oCurr).getKey(), false);
        }

        protected void setEntrySetSize(int c) {
            this.__m_EntrySetSize = c;
        }

        public void setKeyAdvancer(PagedIterator.Advancer advancer) {
            this.__m_KeyAdvancer = advancer;
        }

        protected void setKeySet(Set set) {
            this.__m_KeySet = set;
        }

        public void setStrict(boolean fStrict) {
            this.__m_Strict = fStrict;
        }

        public void setValues(boolean fValues) {
            this.__m_Values = fValues;
        }
    }

    public static class KeyAdvancer
    extends Util
    implements PagedIterator.Advancer {
        private PartitionSet __m_Partitions;

        public KeyAdvancer() {
            this(null, null, true);
        }

        public KeyAdvancer(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new KeyAdvancer();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/BinaryMap$KeyAdvancer".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent().get_Parent();
        }

        public BinaryMap getBinaryMap() {
            return (BinaryMap)this.get_Parent();
        }

        public PartitionSet getPartitions() {
            return this.__m_Partitions;
        }

        @Override
        public Collection nextPage() {
            PartitionSet parts = this.getPartitions();
            return parts.isEmpty() ? null : this.getBinaryMap().keySetPage(parts);
        }

        @Override
        public void onInit() {
            this.setPartitions(this.getBinaryMap().makePartitionSet());
            super.onInit();
        }

        @Override
        public void remove(Object binKey) {
            this.getBinaryMap().remove((Object)((Binary)binKey), false);
        }

        protected void setPartitions(PartitionSet parts) {
            this.__m_Partitions = parts;
        }
    }

    public static class KeyRequestStatus
    extends SinglePartStatus {
        public KeyRequestStatus() {
            this(null, null, true);
        }

        public KeyRequestStatus(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setPartition(-1);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new KeyRequestStatus();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/BinaryMap$KeyRequestStatus".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent().get_Parent();
        }

        @Override
        public PartitionedService getService() {
            return (PartitionedCache)this.get_Module();
        }
    }

    public static class KeySetRequestStatus
    extends MultiPartStatus {
        private Map __m_KeysByOwner;
        private Set __m_OrphanedKeys;

        public KeySetRequestStatus() {
            this(null, null, true);
        }

        public KeySetRequestStatus(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new KeySetRequestStatus();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/BinaryMap$KeySetRequestStatus".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent().get_Parent();
        }

        public Map getKeysByOwner() {
            return this.__m_KeysByOwner;
        }

        public Set getOrphanedKeys() {
            return this.__m_OrphanedKeys;
        }

        @Override
        public PartitionedService getService() {
            return (PartitionedCache)this.get_Module();
        }

        @Override
        public boolean isTargetMissing() {
            return this.getKeysByOwner() == null;
        }

        @Override
        public void reset() {
            this.setKeysByOwner(null);
            this.setOrphanedKeys(null);
            super.reset();
        }

        public void setKeysByOwner(Map map) {
            this.__m_KeysByOwner = map;
        }

        public void setOrphanedKeys(Set set) {
            this.__m_OrphanedKeys = set;
        }
    }

    public static class MapRequestStatus
    extends MultiPartStatus {
        private Map __m_EntriesByPartition;
        private Map __m_OrphanedEntries;

        public MapRequestStatus() {
            this(null, null, true);
        }

        public MapRequestStatus(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MapRequestStatus();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/BinaryMap$MapRequestStatus".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent().get_Parent();
        }

        public Map getEntriesByPartition() {
            return this.__m_EntriesByPartition;
        }

        public Map getOrphanedEntries() {
            return this.__m_OrphanedEntries;
        }

        @Override
        public PartitionedService getService() {
            return (PartitionedCache)this.get_Module();
        }

        @Override
        public boolean isTargetMissing() {
            return this.getEntriesByPartition() == null;
        }

        @Override
        public void reset() {
            this.setEntriesByPartition(null);
            this.setOrphanedEntries(new HashMap());
            super.reset();
        }

        public void setEntriesByPartition(Map map) {
            this.__m_EntriesByPartition = map;
        }

        public void setOrphanedEntries(Map map) {
            this.__m_OrphanedEntries = map;
        }
    }

    public static class PartialRequestStatus
    extends MultiPartStatus {
        private Map __m_PartitionsByOwner;

        public PartialRequestStatus() {
            this(null, null, true);
        }

        public PartialRequestStatus(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PartialRequestStatus();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/BinaryMap$PartialRequestStatus".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent().get_Parent();
        }

        public Map getPartitionsByOwner() {
            return this.__m_PartitionsByOwner;
        }

        @Override
        public PartitionedService getService() {
            return (PartitionedCache)this.get_Module();
        }

        @Override
        public boolean isTargetMissing() {
            return this.getPartitionsByOwner() == null;
        }

        @Override
        public void reset() {
            this.setPartitionsByOwner(null);
            super.reset();
        }

        public void setPartitionsByOwner(Map map) {
            this.__m_PartitionsByOwner = map;
        }
    }

    public static class EntrySet
    extends Collections
    implements Set {
        private boolean __m_Strict;

        public EntrySet() {
            this(null, null, true);
        }

        public EntrySet(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new EntrySet();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/BinaryMap$EntrySet".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent().get_Parent();
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection col) {
            return EntrySet.addAll(this, col);
        }

        @Override
        public void clear() {
            this.getBinaryMap().clear();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Binary binKey;
                Map.Entry entryThat = (Map.Entry)o;
                BinaryMap mapThis = this.getBinaryMap();
                return mapThis.containsKey(binKey = (Binary)entryThat.getKey()) && Base.equals(mapThis.get(binKey), entryThat.getValue());
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection col) {
            return EntrySet.containsAll(this, col);
        }

        public BinaryMap getBinaryMap() {
            return (BinaryMap)this.get_Parent();
        }

        @Override
        public boolean isEmpty() {
            return this.getBinaryMap().isEmpty();
        }

        public boolean isStrict() {
            return this.__m_Strict;
        }

        @Override
        public Iterator iterator() {
            return new PagedIterator(this.getBinaryMap().makeEntryAdvancer(false, this.isStrict()));
        }

        @Override
        public void onInit() {
            try {
                this.setStrict(Config.getBoolean("coherence.entryset.strict"));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            super.onInit();
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                return this.getBinaryMap().remove((Object)((Binary)entry.getKey()), false) != null;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection col) {
            HashSet setKeys = new HashSet();
            for (Map.Entry entry : col) {
                setKeys.add(entry.getKey());
            }
            return this.getBinaryMap().removeAll(setKeys);
        }

        @Override
        public boolean retainAll(Collection col) {
            return EntrySet.retainAll(this, col);
        }

        protected void setStrict(boolean fStrict) {
            this.__m_Strict = fStrict;
        }

        @Override
        public int size() {
            return this.getBinaryMap().size();
        }

        @Override
        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        @Override
        public Object[] toArray(Object[] ao) {
            while (true) {
                try {
                    return EntrySet.toArray(this, ao);
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    continue;
                }
                break;
            }
        }
    }

    public static class KeySet
    extends Collections
    implements Set {
        public KeySet() {
            this(null, null, true);
        }

        public KeySet(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new KeySet();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/BinaryMap$KeySet".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent().get_Parent();
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection col) {
            return KeySet.addAll(this, col);
        }

        @Override
        public void clear() {
            this.getBinaryMap().clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.getBinaryMap().containsKey((Binary)o);
        }

        @Override
        public boolean containsAll(Collection col) {
            return this.getBinaryMap().containsAll(col);
        }

        public BinaryMap getBinaryMap() {
            return (BinaryMap)this.get_Parent();
        }

        @Override
        public boolean isEmpty() {
            return this.getBinaryMap().isEmpty();
        }

        @Override
        public Iterator iterator() {
            return new PagedIterator(this.getBinaryMap().makeKeyAdvancer());
        }

        @Override
        public boolean remove(Object o) {
            return this.getBinaryMap().remove((Object)((Binary)o), false) != null;
        }

        @Override
        public boolean removeAll(Collection col) {
            return this.getBinaryMap().removeAll(col);
        }

        @Override
        public boolean retainAll(Collection col) {
            return KeySet.retainAll(this, col);
        }

        @Override
        public int size() {
            return this.getBinaryMap().size();
        }

        @Override
        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        @Override
        public Object[] toArray(Object[] ao) {
            while (true) {
                try {
                    return KeySet.toArray(this, ao);
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    continue;
                }
                break;
            }
        }
    }

    public static class Values
    extends Collections
    implements Collection {
        public Values() {
            this(null, null, true);
        }

        public Values(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Values();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/partitionedCache/BinaryMap$Values".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent().get_Parent();
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection col) {
            return Values.addAll(this, col);
        }

        @Override
        public void clear() {
            this.getBinaryMap().clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.getBinaryMap().containsValue((Binary)o);
        }

        public boolean containsAll(Collection col) {
            return Values.containsAll(this, col);
        }

        public BinaryMap getBinaryMap() {
            return (BinaryMap)this.get_Parent();
        }

        @Override
        public boolean isEmpty() {
            return this.getBinaryMap().isEmpty();
        }

        @Override
        public Iterator iterator() {
            return new PagedIterator(this.getBinaryMap().makeEntryAdvancer(true, false));
        }

        @Override
        public boolean remove(Object o) {
            return Values.remove(this, o);
        }

        public boolean removeAll(Collection col) {
            return Values.removeAll(this, col);
        }

        public boolean retainAll(Collection col) {
            return Values.retainAll(this, col);
        }

        @Override
        public int size() {
            return this.getBinaryMap().size();
        }

        @Override
        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        public Object[] toArray(Object[] ao) {
            while (true) {
                try {
                    return Values.toArray(this, ao);
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    continue;
                }
                break;
            }
        }
    }
}

