/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Collector;
import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.oracle.coherence.common.collections.NullableSortedMap;
import com.oracle.coherence.common.internal.Platform;
import com.oracle.coherence.common.util.CommonMonitor;
import com.oracle.coherence.common.util.Duration;
import com.oracle.coherence.common.util.MemorySize;
import com.oracle.coherence.persistence.AsyncPersistenceException;
import com.oracle.coherence.persistence.PersistenceException;
import com.oracle.coherence.persistence.PersistenceManager;
import com.oracle.coherence.persistence.PersistentStore;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Lease;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.RequestContext;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.MapEventMessage;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.net.message.ResponseMessage;
import com.tangosol.coherence.component.net.message.requestMessage.DistributedCacheKeyRequest;
import com.tangosol.coherence.component.net.message.requestMessage.DistributedCacheRequest;
import com.tangosol.coherence.component.net.message.requestMessage.chainedRequest.BackupRequest;
import com.tangosol.coherence.component.net.message.requestMessage.chainedRequest.backupRequest.BackupMultiRequest;
import com.tangosol.coherence.component.net.message.requestMessage.chainedRequest.backupRequest.BackupSingleRequest;
import com.tangosol.coherence.component.net.message.requestMessage.distributedCacheRequest.KeySetRequest;
import com.tangosol.coherence.component.net.message.requestMessage.distributedCacheRequest.MapRequest;
import com.tangosol.coherence.component.net.message.requestMessage.distributedCacheRequest.PartialRequest;
import com.tangosol.coherence.component.net.message.requestMessage.distributedCacheRequest.StorageRequest;
import com.tangosol.coherence.component.net.message.requestMessage.distributedCacheRequest.partialRequest.FilterRequest;
import com.tangosol.coherence.component.net.message.responseMessage.DistributedPartialResponse;
import com.tangosol.coherence.component.net.message.responseMessage.SimpleResponse;
import com.tangosol.coherence.component.net.requestContext.AsyncContext;
import com.tangosol.coherence.component.net.requestContext.asyncContext.AsyncAggregatorContext;
import com.tangosol.coherence.component.net.requestContext.asyncContext.AsyncProcessorContext;
import com.tangosol.coherence.component.util.BackingMapManagerContext;
import com.tangosol.coherence.component.util.CacheEvent;
import com.tangosol.coherence.component.util.Converter;
import com.tangosol.coherence.component.util.PartialJob;
import com.tangosol.coherence.component.util.ServiceConfig;
import com.tangosol.coherence.component.util.WrapperContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.partitionedCache.BinaryMap;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.partitionedCache.Storage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.partitionedCache.ViewMap;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.config.expression.Parameter;
import com.tangosol.internal.net.service.DefaultServiceDependencies;
import com.tangosol.internal.net.service.grid.DefaultPartitionedCacheDependencies;
import com.tangosol.internal.net.service.grid.LegacyXmlPartitionedCacheHelper;
import com.tangosol.internal.net.service.grid.PartitionedCacheDependencies;
import com.tangosol.internal.tracing.Span;
import com.tangosol.internal.tracing.TracingHelper;
import com.tangosol.internal.util.BMEventFabric;
import com.tangosol.internal.util.ConversionHelper;
import com.tangosol.internal.util.HeuristicCommitException;
import com.tangosol.internal.util.LockContentionException;
import com.tangosol.internal.util.QueryResult;
import com.tangosol.io.DeltaCompressor;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.SizeEstimatingBufferOutput;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.ActionPolicy;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheService;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.NamedCache;
import com.tangosol.net.PriorityTask;
import com.tangosol.net.RequestIncompleteException;
import com.tangosol.net.RequestPolicyException;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.ServiceStoppedException;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.cache.ReadWriteBackingMap;
import com.tangosol.net.events.Event;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventDispatcherRegistry;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.internal.InterceptorManager;
import com.tangosol.net.events.internal.ServiceDispatcher;
import com.tangosol.net.events.internal.StorageDispatcher;
import com.tangosol.net.events.partition.TransactionEvent;
import com.tangosol.net.events.partition.TransferEvent;
import com.tangosol.net.events.partition.UnsolicitedCommitEvent;
import com.tangosol.net.events.partition.cache.CacheLifecycleEvent;
import com.tangosol.net.events.partition.cache.EntryEvent;
import com.tangosol.net.events.partition.cache.EntryProcessorEvent;
import com.tangosol.net.internal.CopyOnWriteLongList;
import com.tangosol.net.internal.EntryInfo;
import com.tangosol.net.internal.MemberInfo;
import com.tangosol.net.internal.PartitionInfo;
import com.tangosol.net.internal.PartitionVersionExclusionList;
import com.tangosol.net.internal.PartitionVersions;
import com.tangosol.net.internal.ScopedCacheReferenceStore;
import com.tangosol.net.internal.StorageVersion;
import com.tangosol.net.partition.DefaultVersionedPartitions;
import com.tangosol.net.partition.PartitionAwareBackingMap;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.net.partition.PartitionStatistics;
import com.tangosol.net.partition.VersionedOwnership;
import com.tangosol.net.partition.VersionedPartitions;
import com.tangosol.net.security.DoAsAction;
import com.tangosol.net.security.SecurityHelper;
import com.tangosol.net.security.StorageAccessAuthorizer;
import com.tangosol.persistence.CachePersistenceHelper;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.AsynchronousAgent;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.ByteSequence;
import com.tangosol.util.ChainedCollection;
import com.tangosol.util.ChainedMap;
import com.tangosol.util.CircularArrayList;
import com.tangosol.util.ClassFilter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.CopyOnWriteLongArray;
import com.tangosol.util.CopyOnWriteMap;
import com.tangosol.util.EntrySetMap;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.FilterEnumerator;
import com.tangosol.util.HashHelper;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.KeyValueArrayMap;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.LiteMap;
import com.tangosol.util.LiteSet;
import com.tangosol.util.LongArray;
import com.tangosol.util.MapIndex;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MapTrigger;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.PrimitiveSparseArray;
import com.tangosol.util.QueryRecord;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SafeLinkedList;
import com.tangosol.util.SegmentedConcurrentMap;
import com.tangosol.util.SetMap;
import com.tangosol.util.SimpleMapEntry;
import com.tangosol.util.SimpleResourceRegistry;
import com.tangosol.util.SparseArray;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import com.tangosol.util.aggregator.AbstractAsynchronousAggregator;
import com.tangosol.util.aggregator.QueryRecorder;
import com.tangosol.util.comparator.SafeComparator;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.LimitFilter;
import com.tangosol.util.processor.AbstractAsynchronousProcessor;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.LongSupplier;
import javax.security.auth.Subject;

public class PartitionedCache
extends PartitionedService
implements CacheService,
DistributedCacheService {
    private int __m_AddedDaemons;
    private transient BackingMapContext __m_BackingMapContext;
    private transient BackingMapManager __m_BackingMapManager;
    private AtomicInteger __m_BackupAllEnvelopeSize;
    private int __m_BackupCountOpt;
    private transient DeltaCompressor __m_BackupDeltaCompressor;
    private AtomicInteger __m_BackupSingleEnvelopeSize;
    private com.tangosol.util.Converter __m_BinaryEntryConverter;
    private LongArray __m_BinaryMapArray;
    private transient DeltaCompressor __m_EventDeltaCompressor;
    private EventsHelper __m_EventsHelper;
    private transient long __m_EventResendInterval;
    private long __m_IndexingStartTime;
    private volatile PartitionSet __m_IndexPendingPartitions;
    private volatile PartitionSet __m_IndexProcessingPartitions;
    private int __m_IndexUpdateCount;
    private LazyLookup __m_LazyLookupReadBuffer;
    private int __m_LeaseGranularity;
    private transient long __m_LockingNextMillis;
    private transient long __m_OldestEventResendNextMillis;
    private transient LongArray __m_PendingEvents;
    private ConcurrentLinkedQueue __m_PendingIndexUpdate;
    private transient SparseArray[] __m_PendingResultInfo;
    private transient LongArray __m_ProcessedEvents;
    private Map __m_ReferencesBinaryMap;
    private RequestCoordinator __m_RequestCoordinator;
    private ResourceCoordinator __m_ResourceCoordinator;
    private int __m_ScheduledBackupsThreshold;
    private MemorySize __m_MaxPartialResponseSize;
    private ScopedCacheReferenceStore __m_ScopedCacheStore;
    private SendBackupsTask __m_SendBackupsTask;
    private long __m_StandardLeaseMillis;
    private AtomicLong __m_StatsIndexingTime;
    private LongArray __m_StorageArray;
    private Map __m_StorageGraveyard;
    private boolean __m_StrictPartitioning;
    public static final int SUID_CACHE = 3;
    public static final int SUID_EVENT = 2;
    public static final int SUID_FILTER = 1;
    private int __m_TaskSplitThreshold;
    private ThreadLocal __m_TLOContext;
    private static ListMap __mapChildren;
    private long m_lOldestSUIDtemp = -1L;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Acknowledgement", Grid.Acknowledgement.get_CLASS());
        __mapChildren.put("AggregateAllRequest", AggregateAllRequest.get_CLASS());
        __mapChildren.put("AggregateFilterRequest", AggregateFilterRequest.get_CLASS());
        __mapChildren.put("BackingMapContext", BackingMapContext.get_CLASS());
        __mapChildren.put("BackupAllRequest", BackupAllRequest.get_CLASS());
        __mapChildren.put("BackupAssignment", PartitionedService.BackupAssignment.get_CLASS());
        __mapChildren.put("BackupConfirmRequest", BackupConfirmRequest.get_CLASS());
        __mapChildren.put("BackupListenerAllRequest", BackupListenerAllRequest.get_CLASS());
        __mapChildren.put("BackupListenerRequest", BackupListenerRequest.get_CLASS());
        __mapChildren.put("BackupLockRequest", BackupLockRequest.get_CLASS());
        __mapChildren.put("BackupSingleRequest", BackupSingleRequest.get_CLASS());
        __mapChildren.put("BatchContext", BatchContext.get_CLASS());
        __mapChildren.put("BinaryMap", BinaryMap.get_CLASS());
        __mapChildren.put("BusEventMessage", Grid.BusEventMessage.get_CLASS());
        __mapChildren.put("CentralDistribution", PartitionedService.CentralDistribution.get_CLASS());
        __mapChildren.put("ClearRequest", ClearRequest.get_CLASS());
        __mapChildren.put("ConfigRequest", Grid.ConfigRequest.get_CLASS());
        __mapChildren.put("ConfigResponse", Grid.ConfigResponse.get_CLASS());
        __mapChildren.put("ConfigSync", Grid.ConfigSync.get_CLASS());
        __mapChildren.put("ConfigUpdate", Grid.ConfigUpdate.get_CLASS());
        __mapChildren.put("ContainsAllRequest", ContainsAllRequest.get_CLASS());
        __mapChildren.put("ContainsKeyRequest", ContainsKeyRequest.get_CLASS());
        __mapChildren.put("ContainsValueRequest", ContainsValueRequest.get_CLASS());
        __mapChildren.put("Contention", PartitionedService.Contention.get_CLASS());
        __mapChildren.put("ConverterFromBinary", ConverterFromBinary.get_CLASS());
        __mapChildren.put("ConverterKeyToBinary", PartitionedService.ConverterKeyToBinary.get_CLASS());
        __mapChildren.put("ConverterValueToBinary", ConverterValueToBinary.get_CLASS());
        __mapChildren.put("DispatchEvent", PartitionedService.DispatchEvent.get_CLASS());
        __mapChildren.put("DispatchNotification", Grid.DispatchNotification.get_CLASS());
        __mapChildren.put("DistributionPlanUpdate", PartitionedService.DistributionPlanUpdate.get_CLASS());
        __mapChildren.put("DistributionRequest", DistributionRequest.get_CLASS());
        __mapChildren.put("GetAllRequest", GetAllRequest.get_CLASS());
        __mapChildren.put("GetRequest", GetRequest.get_CLASS());
        __mapChildren.put("IndexRequest", IndexRequest.get_CLASS());
        __mapChildren.put("InvocationContext", InvocationContext.get_CLASS());
        __mapChildren.put("InvokeAllRequest", InvokeAllRequest.get_CLASS());
        __mapChildren.put("InvokeFilterRequest", InvokeFilterRequest.get_CLASS());
        __mapChildren.put("InvokeRequest", InvokeRequest.get_CLASS());
        __mapChildren.put("KeyIteratorRequest", KeyIteratorRequest.get_CLASS());
        __mapChildren.put("KeyListenerAllRequest", KeyListenerAllRequest.get_CLASS());
        __mapChildren.put("KeyListenerRequest", KeyListenerRequest.get_CLASS());
        __mapChildren.put("ListenerRequest", ListenerRequest.get_CLASS());
        __mapChildren.put("LockRequest", LockRequest.get_CLASS());
        __mapChildren.put("MapEvent", MapEvent.get_CLASS());
        __mapChildren.put("MemberConfigUpdate", PartitionedService.MemberConfigUpdate.get_CLASS());
        __mapChildren.put("MemberJoined", Grid.MemberJoined.get_CLASS());
        __mapChildren.put("MemberRecovered", Grid.MemberRecovered.get_CLASS());
        __mapChildren.put("MemberWelcome", MemberWelcome.get_CLASS());
        __mapChildren.put("MemberWelcomeRequest", MemberWelcomeRequest.get_CLASS());
        __mapChildren.put("MemberWelcomeRequestTask", Grid.MemberWelcomeRequestTask.get_CLASS());
        __mapChildren.put("NotifyConnectionClose", Grid.NotifyConnectionClose.get_CLASS());
        __mapChildren.put("NotifyConnectionOpen", Grid.NotifyConnectionOpen.get_CLASS());
        __mapChildren.put("NotifyMemberJoined", Grid.NotifyMemberJoined.get_CLASS());
        __mapChildren.put("NotifyMemberLeaving", Grid.NotifyMemberLeaving.get_CLASS());
        __mapChildren.put("NotifyMemberLeft", Grid.NotifyMemberLeft.get_CLASS());
        __mapChildren.put("NotifyMessageReceipt", Grid.NotifyMessageReceipt.get_CLASS());
        __mapChildren.put("NotifyPollClosed", Grid.NotifyPollClosed.get_CLASS());
        __mapChildren.put("NotifyResponse", Grid.NotifyResponse.get_CLASS());
        __mapChildren.put("NotifyServiceAnnounced", Grid.NotifyServiceAnnounced.get_CLASS());
        __mapChildren.put("NotifyServiceJoining", Grid.NotifyServiceJoining.get_CLASS());
        __mapChildren.put("NotifyServiceLeaving", PartitionedService.NotifyServiceLeaving.get_CLASS());
        __mapChildren.put("NotifyServiceLeft", Grid.NotifyServiceLeft.get_CLASS());
        __mapChildren.put("NotifyServiceQuiescence", PartitionedService.NotifyServiceQuiescence.get_CLASS());
        __mapChildren.put("NotifyShutdown", PartitionedService.NotifyShutdown.get_CLASS());
        __mapChildren.put("NotifySnapshotRecoverRequest", PartitionedService.NotifySnapshotRecoverRequest.get_CLASS());
        __mapChildren.put("NotifyStartup", Grid.NotifyStartup.get_CLASS());
        __mapChildren.put("OwnershipRequest", OwnershipRequest.get_CLASS());
        __mapChildren.put("OwnershipResponse", PartitionedService.OwnershipResponse.get_CLASS());
        __mapChildren.put("PartialMapResponse", PartialMapResponse.get_CLASS());
        __mapChildren.put("PartialValueResponse", PartialValueResponse.get_CLASS());
        __mapChildren.put("PartitionAbandonRequest", PartitionAbandonRequest.get_CLASS());
        __mapChildren.put("PartitionControl", PartitionControl.get_CLASS());
        __mapChildren.put("PartitionFilter", PartitionedService.PartitionFilter.get_CLASS());
        __mapChildren.put("PartitionRecoverCleanup", PartitionedService.PartitionRecoverCleanup.get_CLASS());
        __mapChildren.put("PartitionRecoverRequest", PartitionRecoverRequest.get_CLASS());
        __mapChildren.put("PartitionStatsUpdate", PartitionedService.PartitionStatsUpdate.get_CLASS());
        __mapChildren.put("PartitionSwapRequest", PartitionSwapRequest.get_CLASS());
        __mapChildren.put("PartitionVersionSyncRequest", PartitionVersionSyncRequest.get_CLASS());
        __mapChildren.put("PersistenceControl", PersistenceControl.get_CLASS());
        __mapChildren.put("PingRequest", Grid.PingRequest.get_CLASS());
        __mapChildren.put("PinningIterator", PinningIterator.get_CLASS());
        __mapChildren.put("ProtocolContext", Grid.ProtocolContext.get_CLASS());
        __mapChildren.put("PutAllRequest", PutAllRequest.get_CLASS());
        __mapChildren.put("PutRequest", PutRequest.get_CLASS());
        __mapChildren.put("QueryRequest", QueryRequest.get_CLASS());
        __mapChildren.put("PartitionedQueryRequest", PartitionedQueryRequest.get_CLASS());
        __mapChildren.put("QueryResponse", QueryResponse.get_CLASS());
        __mapChildren.put("PartitionedQueryResponse", PartitionedQueryResponse.get_CLASS());
        __mapChildren.put("RemoveAllRequest", RemoveAllRequest.get_CLASS());
        __mapChildren.put("RemoveRequest", RemoveRequest.get_CLASS());
        __mapChildren.put("Response", Grid.Response.get_CLASS());
        __mapChildren.put("ResultInfo", ResultInfo.get_CLASS());
        __mapChildren.put("SendBackupsTask", SendBackupsTask.get_CLASS());
        __mapChildren.put("SizeRequest", SizeRequest.get_CLASS());
        __mapChildren.put("SnapshotArchiveRequest", PartitionedService.SnapshotArchiveRequest.get_CLASS());
        __mapChildren.put("SnapshotListRequest", SnapshotListRequest.get_CLASS());
        __mapChildren.put("SnapshotRequest", SnapshotRequest.get_CLASS());
        __mapChildren.put("Storage", Storage.get_CLASS());
        __mapChildren.put("StorageConfirmRequest", StorageConfirmRequest.get_CLASS());
        __mapChildren.put("StorageIdRequest", StorageIdRequest.get_CLASS());
        __mapChildren.put("TransferRequest", TransferRequest.get_CLASS());
        __mapChildren.put("TransferResponse", PartitionedService.TransferResponse.get_CLASS());
        __mapChildren.put("UnlockRequest", UnlockRequest.get_CLASS());
        __mapChildren.put("UpdateIndexRequest", UpdateIndexRequest.get_CLASS());
        __mapChildren.put("ViewMap", ViewMap.get_CLASS());
        __mapChildren.put("WrapperGuardable", Grid.WrapperGuardable.get_CLASS());
    }

    public PartitionedCache() {
        this(null, null, true);
    }

    public PartitionedCache(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setAcceptingClients(false);
            this.setAcceptingOthers(false);
            this.setBackupAllEnvelopeSize(new AtomicInteger());
            this.setBackupCount(0);
            this.setBackupCountOpt(0);
            this.setBackupSingleEnvelopeSize(new AtomicInteger());
            this.setBinaryMapArray(new CopyOnWriteLongArray());
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setDistributionNextMillis(Long.MAX_VALUE);
            this.setDistributionRepeatMillis(2000);
            this.setDistributionSynchronized(true);
            this.setFinalizing(false);
            this.setLeaseGranularity(0);
            this.setLockingNextMillis(Long.MAX_VALUE);
            this.setMessageClassMap(new HashMap());
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setOldestPendingRequestSUIDCounter(new AtomicLong());
            this.setOwnershipEnabled(true);
            this.setPartitionListeners(new Listeners());
            this.setPendingIndexUpdate(new ConcurrentLinkedQueue());
            this.setProcessedEvents(new SparseArray());
            this.setReferencesBinaryMap(new SafeHashMap());
            this.setResourceRegistry(new SimpleResourceRegistry());
            this.setScopedCacheStore(new ScopedCacheReferenceStore());
            this.setSerializerMap(new WeakHashMap());
            this.setStandardLeaseMillis(0L);
            this.setStatsIndexingTime(new AtomicLong());
            this.setStorageArray(new CopyOnWriteLongArray());
            this.setStrictPartitioning(true);
            this.setSuspendPollLimit(new AtomicLong());
            this.setTLOContext(new ThreadLocal());
            this.setTLORecoveryThread(new ThreadLocal());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Continuations("Continuations", this, true), "Continuations");
        this._addChild(new DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Grid.EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new EventsHelper("EventsHelper", this, true), "EventsHelper");
        this._addChild(new Grid.Guard("Guard", this, true), "Guard");
        this._addChild(new LazyLookup("LazyLookup", this, true), "LazyLookup");
        this._addChild(new PartitionedService.MemberConfigListener("MemberConfigListener", this, true), "MemberConfigListener");
        this._addChild(new PartitionedService.PartitionConfig("PartitionConfig", this, true), "PartitionConfig");
        this._addChild(new Grid.PollArray("PollArray", this, true), "PollArray");
        this._addChild(new Grid.ReceiveQueue("ReceiveQueue", this, true), "ReceiveQueue");
        this._addChild(new RequestCoordinator("RequestCoordinator", this, true), "RequestCoordinator");
        this._addChild(new ResourceCoordinator("ResourceCoordinator", this, true), "ResourceCoordinator");
        this._addChild(new ServiceConfig("ServiceConfig", this, true), "ServiceConfig");
        this._addChild(new TransferControl("TransferControl", this, true), "TransferControl");
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    @Override
    public String getServiceType() {
        return "DistributedCache";
    }

    @Override
    public int getSUIDCounterLength() {
        return 4;
    }

    public static Component get_Instance() {
        return new PartitionedCache();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    protected void abandonPartitions(PartitionSet parts) {
        super.abandonPartitions(parts);
        if (this.collectOwnedPartitions(true).isEmpty()) {
            this.getStorageGraveyard().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Binary applyDelta(Map mapBackup, Binary binKey, Binary binDelta) {
        LazyLookup lazyLookup = this.getLazyLookup(mapBackup, binKey);
        try {
            Binary binary = this.getBackupDeltaCompressor().applyDelta(lazyLookup, binDelta).toBinary();
            return binary;
        }
        catch (RuntimeException e) {
            PartitionedCache._trace("Failed to apply delta: partition=" + this.getKeyPartition(binKey) + "; key=" + String.valueOf(binKey) + "; old=" + String.valueOf(lazyLookup.toBinary()) + "; new=" + String.valueOf(binDelta) + "; " + PartitionedCache.getStackTrace(e), 1);
            this.doBackupRemove(mapBackup, binKey);
            Binary binary = null;
            return binary;
        }
        finally {
            lazyLookup.reset();
        }
    }

    @Override
    protected void assignOrphan(int iPartition) {
        if (this.isActivePersistence()) {
            PartitionControl ctrl = (PartitionControl)this.ensurePartitionControl(iPartition);
            ctrl.preparePersistentExtents();
        }
        super.assignOrphan(iPartition);
    }

    public void checkInterrupt() {
        if (Thread.currentThread().isInterrupted()) {
            throw new RequestTimeoutException("Request processing has been interrupted");
        }
        this.heartbeat();
    }

    @Override
    public boolean checkLockRequired() {
        return super.checkLockRequired() || this.getEventsHelper().hasServiceInterceptors(TransferEvent.Type.ASSIGNED);
    }

    public void checkQuorum(RequestMessage msg, boolean fReadOnly) {
        ActionPolicy policy = this.getActionPolicy();
        if (!policy.isAllowed(this, fReadOnly ? CacheService.CacheAction.READ : CacheService.CacheAction.WRITE)) {
            throw new RequestPolicyException("Cache " + (fReadOnly ? "reads" : "writes") + " are disallowed by " + String.valueOf(policy));
        }
    }

    private void clearIterator(Iterator iter) {
        iter.remove();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    @Override
    protected DefaultServiceDependencies cloneDependencies(ServiceDependencies deps) {
        return new DefaultPartitionedCacheDependencies((PartitionedCacheDependencies)deps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object collectPendingEvents(int iPartition) {
        Object oCollected = null;
        LongArray laPending = this.getPendingEvents();
        int lMemberId = this.getThisMember().getId();
        LongArray longArray = laPending;
        synchronized (longArray) {
            long lOldestSUID = this.getOldestPendingEventSUID();
            if (lOldestSUID == -1L) {
                return null;
            }
            LongArray.Iterator crawler = laPending.iterator(lOldestSUID);
            while (crawler.hasNext()) {
                MapEvent event = (MapEvent)crawler.next();
                long lSUID = crawler.getIndex();
                int lEventMemberId = PartitionedCache.getMemberId(lSUID);
                if (lEventMemberId != lMemberId) break;
                if (event == null || this.getKeyPartition(event.getKey()) != iPartition) continue;
                oCollected = Storage.accumulateMapEvents(oCollected, event);
            }
        }
        return oCollected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LongArray collectPendingResults(int iPartition) {
        SparseArray<Map> laCollected = null;
        SparseArray[] alaPending = this.getPendingResultInfo();
        int c = alaPending.length;
        for (int i = 0; i < c; ++i) {
            SparseArray laPending;
            SparseArray sparseArray = laPending = alaPending[i];
            synchronized (sparseArray) {
                for (ResultInfo info : laPending) {
                    Map mapResult = info.extractResults(iPartition);
                    if (mapResult == null) continue;
                    if (laCollected == null) {
                        laCollected = new SparseArray<Map>();
                    }
                    laCollected.set(info.getSUID(), mapResult);
                }
                continue;
            }
        }
        return laCollected;
    }

    protected Collection collectResultOnException(Collection colResult, Object[] aoStatus, Object[] aoKey, int iFrom, int iTo, Throwable e) {
        if (colResult == null) {
            colResult = new SafeLinkedList();
        }
        for (int i = iFrom; i < iTo; ++i) {
            if (aoStatus != null && (Storage.EntryStatus)aoStatus[i] != null) continue;
            colResult.add(aoKey[i]);
        }
        return colResult;
    }

    public Map collectValidStorages() {
        HashMap<String, Storage> mapStorage = new HashMap<String, Storage>();
        for (Storage storage : this.getStorageArray()) {
            if (!storage.isValid()) continue;
            mapStorage.put(storage.getCacheName(), storage);
        }
        return mapStorage;
    }

    @Override
    public synchronized void configure(XmlElement xml) {
        this.setDependencies(LegacyXmlPartitionedCacheHelper.fromXml(xml, new DefaultPartitionedCacheDependencies(), this.getOperationalContext(), this.getContextClassLoader()));
        this.setServiceConfig(xml);
    }

    public XmlElement createCacheInfo(String sCacheName, long lCacheId) {
        if (lCacheId == 0L) {
            lCacheId = this.generateCacheId();
        }
        SimpleElement xmlCacheInfo = new SimpleElement("cache-info");
        xmlCacheInfo.addAttribute("id").setLong(lCacheId);
        xmlCacheInfo.addAttribute("name").setString(sCacheName);
        return xmlCacheInfo;
    }

    @Override
    protected ResolvableParameterList createResolver() {
        ResolvableParameterList resolver = super.createResolver();
        resolver.add(new Parameter("manager-context", this.getBackingMapManager().getContext()));
        return resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List createWelcomeRequests(Member member) {
        LinkedList<StorageRequest> listRequests = new LinkedList<StorageRequest>();
        if (this.isAcceptingClients() && !this.isOwnershipDisabled(member)) {
            StorageRequest msg;
            Member memberThis = this.getThisMember();
            int nMemberThis = memberThis.getId();
            Object[] aMap = this.getReferencesBinaryMap().values().toArray();
            int c = aMap.length;
            for (int i = 0; i < c; ++i) {
                MapListenerSupport support;
                BinaryMap mapBinary = (BinaryMap)aMap[i];
                MapListenerSupport mapListenerSupport = support = mapBinary.getListenerSupport();
                synchronized (mapListenerSupport) {
                    if (support.isEmpty()) {
                        continue;
                    }
                    for (Filter filter : support.getFilterSet()) {
                        msg = (ListenerRequest)this.instantiateMessage("ListenerRequest");
                        msg.setCacheId(mapBinary.getCacheId());
                        ((ListenerRequest)msg).setAdd(true);
                        ((ListenerRequest)msg).setFilter(filter);
                        ((ListenerRequest)msg).setFilterId(mapBinary.getFilterId(filter));
                        ((ListenerRequest)msg).setLite(!support.containsStandardListeners(filter));
                        ((ListenerRequest)msg).setMemberId(nMemberThis);
                        listRequests.add(msg);
                    }
                    continue;
                }
            }
            if (this.getThisMember() == this.getOwnershipSenior()) {
                for (Storage storage : this.getStorageArray()) {
                    this.lockSynthetic(storage);
                    try {
                        Set setTriggers;
                        Map mapExtractor = storage.getIndexExtractorMap();
                        if (!mapExtractor.isEmpty()) {
                            for (Map.Entry entry : mapExtractor.entrySet()) {
                                ValueExtractor extractor = (ValueExtractor)entry.getKey();
                                Comparator comparator = (Comparator)entry.getValue();
                                msg = (IndexRequest)this.instantiateMessage("IndexRequest");
                                msg.setCacheId(storage.getCacheId());
                                ((IndexRequest)msg).setAdd(true);
                                ((IndexRequest)msg).setExtractor(extractor);
                                ((IndexRequest)msg).setOrdered(comparator != null);
                                ((IndexRequest)msg).setComparator(comparator);
                                listRequests.add(msg);
                            }
                        }
                        if ((setTriggers = storage.getTriggerSet()) == null) continue;
                        for (MapTrigger trigger : setTriggers) {
                            ListenerRequest msg2 = (ListenerRequest)this.instantiateMessage("ListenerRequest");
                            msg2.setCacheId(storage.getCacheId());
                            msg2.setAdd(true);
                            msg2.setTrigger(trigger);
                            listRequests.add(msg2);
                        }
                    }
                    finally {
                        this.unlockSynthetic(storage);
                    }
                }
            }
        }
        return listRequests;
    }

    protected void deferBackup(RequestContext ctx, int iPartition, long lCacheId, Map mapEntries, Map mapEvents, Member memberOwner) {
        PartitionedCache._trace("Deferring the backup request for partition " + iPartition + ", cache id=" + lCacheId, 3);
    }

    protected void deferBackup(RequestContext ctx, PartitionSet parts, long lCacheId, Map mapEntries, Map mapEvents, Member memberOwner) {
        PartitionedCache._trace("Deferring the backup request for " + String.valueOf(parts) + ", cache id=" + lCacheId, 3);
    }

    protected PersistentStore deserializeStore(String sGUID, ReadBuffer bufStore) {
        PersistenceControl ctrlPersistence = (PersistenceControl)this.getPersistenceControl();
        PersistenceManager mgrEvents = ctrlPersistence.getEventsManager();
        if (mgrEvents != null) {
            try {
                mgrEvents.read(sGUID, bufStore.getBufferInput());
            }
            catch (IOException e) {
                PartitionedCache._trace("Unable to read previous MapEvents store from old primary owner of partition.", 1);
                PartitionedCache._trace(e);
            }
        }
        return null;
    }

    @Override
    public void destroyCache(NamedCache cache) {
        if (cache.getCacheService() != this) {
            throw new IllegalArgumentException("The cache to destroy is not owned by this service: " + String.valueOf(this));
        }
        this.releaseCache(cache);
        String sName = cache.getCacheName();
        BinaryMap mapBinary = (BinaryMap)this.getReferencesBinaryMap().get(sName);
        if (mapBinary != null) {
            StorageIdRequest msg = (StorageIdRequest)this.instantiateMessage("StorageIdRequest");
            msg.addToMember(this.getServiceOldestMember());
            msg.setCacheNames(new String[]{sName});
            msg.setCacheAction(2);
            this.poll(msg);
            mapBinary.setConfirmed(false);
        }
    }

    public void destroyPersistentExtent(Storage storage) {
        if (this.getPersistenceManager() != null && storage != null) {
            LongArray laCaches = this.getPersistentCacheIds();
            long lCacheId = storage.getCacheId();
            PartitionSet parts = this.calculatePartitionSet(this.getThisMember(), 0);
            laCaches.remove(lCacheId);
            int iPart = parts.next(0);
            while (iPart >= 0) {
                this.getPartitionControl(iPart).deletePersistentExtent(lCacheId, laCaches);
                iPart = parts.next(iPart + 1);
            }
        }
    }

    public void dispatchServerEvents(Set setEntryInfo, Set setEntryInfoOOB) {
        HashSet<BinaryEntry> setEntries;
        EventsHelper evtHelper = this.getEventsHelper();
        if (setEntryInfoOOB != null) {
            setEntries = new HashSet<BinaryEntry>(setEntryInfoOOB.size());
            for (EntryInfo info : setEntryInfoOOB) {
                evtHelper.onEntryChanged(info, null);
                setEntries.add(info.getBinaryEntry());
            }
            evtHelper.onOutOfBandChanges(setEntries);
        }
        if (setEntryInfo != null) {
            setEntries = new HashSet(setEntryInfo.size());
            for (EntryInfo info : setEntryInfo) {
                evtHelper.onEntryChanged(info, null);
                setEntries.add(info.getBinaryEntry());
            }
            evtHelper.onTransactionPostCommit(setEntries);
        }
    }

    protected void doBackupAll(RequestContext ctx, PartitionSet partsSkip, long lCacheId, Map mapEntries, Map mapEvents, Map mapResults, Member memberOwner) {
        Storage storage = this.getKnownStorage(lCacheId);
        PartitionedCache._assert(storage != null);
        Map mapBackup = storage.getBackupMap();
        boolean fPreferPutAll = storage.isPreferPutAllBackup();
        HashMap<Binary, Binary> mapUpdate = null;
        HashSet<Binary> setRemove = null;
        for (Map.Entry entry : mapEntries.entrySet()) {
            Binary binResult;
            Binary binKey = (Binary)entry.getKey();
            Binary binValue = (Binary)entry.getValue();
            Binary binValueOld = null;
            Object oEvent = null;
            boolean fRemove = Binary.EMPTY.equals(binValue);
            boolean fBlind = fPreferPutAll;
            int nPartition = this.getKeyPartition(binKey);
            if (partsSkip != null && partsSkip.contains(nPartition) || !this.isBackupOwner(nPartition)) continue;
            binKey = storage.getCanonicalKey(binKey);
            if (mapEvents != null) {
                oEvent = mapEvents.get(binKey);
                fBlind &= !MapEvent.isCompressedOldValue(oEvent);
            }
            if (binValue == null) {
                binValue = binValueOld = (Binary)mapBackup.get(binKey);
            } else if (fRemove) {
                if (fBlind) {
                    if (setRemove == null) {
                        setRemove = new HashSet<Binary>(mapEntries.size());
                    }
                    setRemove.add(binKey);
                } else {
                    binValueOld = this.doBackupRemove(mapBackup, binKey);
                }
            } else {
                if ((binValue = this.applyDelta(mapBackup, binKey, binValue)) == null) {
                    return;
                }
                if (fBlind) {
                    if (mapUpdate == null) {
                        mapUpdate = new HashMap<Binary, Binary>(mapEntries.size());
                    }
                    mapUpdate.put(binKey, binValue);
                } else {
                    binValueOld = this.doBackupPut(mapBackup, binKey, binValue);
                }
            }
            if (!fBlind && this.isBackupPersistence()) {
                this.persistBackup(nPartition, lCacheId, binKey, binValue, fRemove);
            }
            if (mapResults != null && (binResult = (Binary)mapResults.get(binKey)) != null) {
                mapResults.put(binKey, Storage.decompressResult(binResult, binValueOld, binValue));
            }
            this.registerEvent(MapEvent.decompressEventHolder(oEvent, lCacheId, binKey, binValueOld, binValue), memberOwner);
        }
        if (mapUpdate != null) {
            this.doBackupPutAll(mapBackup, mapUpdate);
            if (this.isBackupPersistence()) {
                this.persistBackup(lCacheId, mapUpdate);
            }
        }
        if (setRemove != null) {
            this.doBackupRemoveAll(mapBackup, setRemove);
            if (this.isBackupPersistence()) {
                this.persistBackup(lCacheId, setRemove);
            }
        }
    }

    protected Binary doBackupPut(Map mapBackup, Binary binKey, Binary binValue) {
        try {
            return mapBackup.put(binKey, binValue);
        }
        catch (IllegalStateException e) {
            PartitionedCache._trace("Deferring backup update operation for partition " + this.getKeyPartition(binKey) + " during partition transfer", 2);
            return null;
        }
    }

    protected void doBackupPutAll(Map mapBackup, Map mapUpdate) {
        try {
            mapBackup.putAll(mapUpdate);
        }
        catch (IllegalStateException e) {
            PartitionSet parts = new PartitionSet(this.getPartitionCount());
            for (Map.Entry entry : mapUpdate.entrySet()) {
                Binary binKey = (Binary)entry.getKey();
                int nPartition = this.getKeyPartition(binKey);
                if (parts.contains(nPartition)) continue;
                try {
                    mapBackup.put(binKey, entry.getValue());
                }
                catch (IllegalStateException e2) {
                    parts.add(nPartition);
                }
            }
            PartitionedCache._trace("Deferred backup update operation for partitions " + String.valueOf(parts) + " during partition transfer", 2);
        }
    }

    protected Binary doBackupRemove(Map mapBackup, Binary binKey) {
        try {
            return (Binary)mapBackup.remove(binKey);
        }
        catch (IllegalStateException e) {
            PartitionedCache._trace("Deferring backup remove operation for partition " + this.getKeyPartition(binKey) + " during partition transfer", 2);
            return null;
        }
    }

    protected void doBackupRemoveAll(Map mapBackup, Set setKeys) {
        try {
            mapBackup.keySet().removeAll(setKeys);
        }
        catch (IllegalStateException e) {
            PartitionSet parts = new PartitionSet(this.getPartitionCount());
            for (Binary binKey : setKeys) {
                int nPartition = this.getKeyPartition(binKey);
                if (parts.contains(nPartition)) continue;
                try {
                    mapBackup.remove(binKey);
                }
                catch (IllegalStateException e2) {
                    parts.add(nPartition);
                }
            }
            PartitionedCache._trace("Deferred backup remove operation for partitions " + String.valueOf(parts) + " during partition transfer", 2);
        }
    }

    public BinaryMap ensureBinaryMap(String sCacheName, long lCacheId) {
        Map mapRefsBinary = this.getReferencesBinaryMap();
        BinaryMap mapBinary = (BinaryMap)mapRefsBinary.get(sCacheName);
        if (mapBinary == null) {
            mapBinary = (BinaryMap)mapRefsBinary.computeIfAbsent(sCacheName, k -> this.instantiateBinaryMap(sCacheName, lCacheId));
            this.getBinaryMapArray().set(lCacheId, mapBinary);
        }
        return mapBinary;
    }

    protected BinaryMap ensureCache(String sName) {
        BinaryMap mapBinary;
        if (sName == null || sName.length() == 0) {
            sName = "Default";
        }
        Map mapRefsBinary = this.getReferencesBinaryMap();
        do {
            if ((mapBinary = (BinaryMap)mapRefsBinary.get(sName)) != null) continue;
            StorageIdRequest msg = (StorageIdRequest)this.instantiateMessage("StorageIdRequest");
            msg.addToMember(this.getThisMember());
            msg.setCacheNames(new String[]{sName});
            msg.setCacheAction(1);
            msg.setCreateBinaryMap(true);
            this.poll(msg);
            mapBinary = (BinaryMap)mapRefsBinary.get(sName);
        } while (!mapBinary.confirmCache());
        return mapBinary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedCache ensureCache(String sName, ClassLoader loader) {
        if (!this.isRunning()) {
            throw new IllegalStateException("Service is not running: " + String.valueOf(this));
        }
        if (sName == null || sName.length() == 0) {
            sName = "Default";
        }
        if (loader == null) {
            loader = this.getContextClassLoader();
            PartitionedCache._assert(loader != null, "ContextClassLoader is missing");
        }
        ViewMap mapCache = null;
        ScopedCacheReferenceStore store = this.getScopedCacheStore();
        mapCache = (ViewMap)store.getCache(sName, loader);
        if (mapCache != null) {
            return mapCache;
        }
        BinaryMap mapBinary = this.ensureCache(sName);
        PartitionedCache partitionedCache = this;
        synchronized (partitionedCache) {
            mapCache = (ViewMap)store.getCache(sName, loader);
            if (mapCache != null) {
                return mapCache;
            }
            mapCache = (ViewMap)this._newChild("ViewMap");
            mapCache.setBinaryMap(mapBinary);
            mapCache.setClassLoader(loader);
            store.putCache(mapCache, loader);
        }
        return mapCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureIndexReady(int nPartition) {
        long cMax = 1L;
        long cSoftTimeout = (long)((float)this.getDefaultGuardTimeout() * this.getDefaultGuardRecovery());
        long ldtStartTime = Base.getSafeTimeMillis();
        long ldtSoftTimeout = ldtStartTime + cSoftTimeout;
        while (this.getIndexPendingPartitions().contains(nPartition)) {
            try {
                CommonMonitor oMonitor;
                CommonMonitor commonMonitor = oMonitor = Base.getCommonMonitor(System.identityHashCode(this) + nPartition);
                synchronized (commonMonitor) {
                    Blocking.wait(oMonitor, 100L);
                }
                long ldtNow = Base.getSafeTimeMillis();
                if (ldtNow + ((cMax = Math.max(cMax, ldtNow - ldtStartTime)) << 4) <= ldtSoftTimeout) continue;
                this.heartbeat();
                ldtSoftTimeout = ldtNow + cSoftTimeout;
                ldtStartTime = ldtNow;
                cMax = 1L;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Base.ensureRuntimeException(e);
            }
        }
    }

    public InvocationContext ensureInvocationContext() {
        ThreadLocal tloCtx = this.getTLOContext();
        InvocationContext ctx = (InvocationContext)tloCtx.get();
        if (ctx == null) {
            ctx = this.instantiateInvocationContext();
            tloCtx.set(ctx);
        }
        ctx.setActive(true);
        return ctx;
    }

    public InvocationContext ensureInvocationContext(int nPartition) {
        InvocationContext ctx = this.ensureInvocationContext();
        ctx.getPrePinnedPartitions().add(nPartition);
        return ctx;
    }

    public InvocationContext ensureInvocationContext(PartitionSet partMask) {
        InvocationContext ctx = this.ensureInvocationContext();
        ctx.getPrePinnedPartitions().add(partMask);
        return ctx;
    }

    protected void ensureKnownStorage() {
        PartitionedCache._assert(this.isOwnershipEnabled() || this.getServiceState() >= 3);
        Grid.ServiceConfig.Map mapConfig = this.getServiceConfigMap();
        Enumeration e = this.getCacheNames();
        while (e.hasMoreElements()) {
            String sCacheName = (String)e.nextElement();
            XmlElement xmlCacheInfo = (XmlElement)mapConfig.get(sCacheName);
            long lCacheId = xmlCacheInfo.getSafeAttribute("id").getLong();
            PartitionedCache._assert(sCacheName.equals(xmlCacheInfo.getSafeAttribute("name").getString()));
            this.ensureStorageInternal(sCacheName, lCacheId, false);
        }
    }

    protected void ensurePersistentExtents(PersistentStore store) {
        this.ensurePersistentExtents(store, false);
    }

    protected void ensurePersistentExtents(PersistentStore store, boolean fSnapshot) {
        LongArray laCaches = this.getPersistentCacheIds(fSnapshot);
        Iterator iter = laCaches.iterator();
        while (iter.hasNext()) {
            iter.next();
            long lCacheId = iter.getIndex();
            store.ensureExtent(lCacheId);
        }
        CachePersistenceHelper.storeCacheNames(store, laCaches);
    }

    protected ResultInfo ensureResultInfo(RequestContext context) {
        return this.ensureResultInfo(context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultInfo ensureResultInfo(RequestContext context, boolean fOnlyIfPending) {
        ResultInfo resultInfo = this.getResultInfo(context);
        if (resultInfo == null && !fOnlyIfPending) {
            long lSUID = context.getRequestSUID();
            LongArray laSUID = this.getPendingResultInfo(lSUID);
            resultInfo = new ResultInfo();
            this._linkChild(resultInfo);
            resultInfo.ensurePartitions();
            resultInfo.setSUID(lSUID);
            LongArray longArray = laSUID;
            synchronized (longArray) {
                ResultInfo infoPrev = laSUID.set(lSUID, resultInfo);
                if (infoPrev != null) {
                    laSUID.set(lSUID, infoPrev);
                    resultInfo = infoPrev;
                }
            }
        }
        return resultInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Storage ensureStorage(long lCacheId) {
        PartitionedCache._assert(this.isOwnershipEnabled());
        LongArray aStorage = this.getStorageArray();
        Storage storage = (Storage)aStorage.get(lCacheId);
        if (storage == null) {
            LongArray longArray = aStorage;
            synchronized (longArray) {
                storage = (Storage)aStorage.get(lCacheId);
                if (storage == null) {
                    storage = (Storage)this._newChild("Storage");
                    storage.setCacheId(lCacheId);
                    aStorage.set(lCacheId, storage);
                }
            }
        }
        return storage;
    }

    public Storage ensureStorage(long lCacheId, boolean fCheckGraveyard) {
        return fCheckGraveyard && this.getStorageGraveyard().containsKey(lCacheId) ? null : this.ensureStorage(lCacheId);
    }

    public void ensureStorage(LongArray laCaches) {
        String[] asCacheNames = new String[laCaches.getSize()];
        long[] alCacheIds = new long[asCacheNames.length];
        int i = 0;
        Iterator crawler = laCaches.iterator();
        while (crawler.hasNext()) {
            String sCache = (String)crawler.next();
            if (sCache == null) {
                PartitionedCache._trace("Unexpected null cache name in caches to create: " + String.valueOf(laCaches), 2);
                continue;
            }
            if (this.getStorage(sCache) != null) continue;
            asCacheNames[i] = sCache;
            alCacheIds[i++] = crawler.getIndex();
        }
        if (i > 0) {
            StorageIdRequest msg = (StorageIdRequest)this.instantiateMessage("StorageIdRequest");
            msg.addToMember(this.getThisMember());
            msg.setCacheNames(asCacheNames);
            msg.setCacheIds(alCacheIds);
            msg.setCacheAction(1);
            msg.setCreateBinaryMap(false);
            msg.compressCacheNames();
            this.poll(msg);
        }
    }

    public void ensureStorageInternal(String sName, long lCacheId, boolean fInit) {
        StorageDispatcher dispatcher;
        EventsHelper events = this.getEventsHelper();
        if (this.isOwnershipEnabled()) {
            Storage storage = fInit ? this.ensureUniqueStorage(lCacheId, sName) : this.ensureStorage(lCacheId);
            storage.ensureInitialized(sName, fInit);
            dispatcher = storage.getEventDispatcher();
        } else {
            BinaryMap mapBinary = this.ensureBinaryMap(sName, lCacheId);
            events.onCacheConfigured(mapBinary);
            dispatcher = mapBinary.getDispatcher();
        }
        events.onCacheLifecycle(dispatcher, CacheLifecycleEvent.Type.CREATED);
    }

    public Storage ensureUniqueStorage(long lCacheId, String sName) {
        PartitionedCache._assert(this.isOwnershipEnabled());
        Storage storage = this.getStorage(lCacheId);
        if (storage != null) {
            return storage;
        }
        Storage storageOld = this.getStorage(sName);
        if (storageOld != null && storageOld.getCacheId() != lCacheId) {
            this.removeStorage(storageOld.getCacheId());
            storageOld.invalidate();
            PartitionedCache._trace("Removing a stale storage for cache \"" + sName + "\"", 1);
        }
        return this.ensureStorage(lCacheId);
    }

    public Storage ensureUniqueStorage(long lCacheId, String sName, boolean fCheckGraveyard) {
        return fCheckGraveyard && this.getStorageGraveyard().containsKey(lCacheId) ? null : this.ensureUniqueStorage(lCacheId, sName);
    }

    public int estimateEventByteSize(MapEventMessage msgEvent) {
        long[] alFilterId;
        int PLONG_SIZE = 10;
        int PINT_SIZE = 5;
        int INT_SIZE = 4;
        int SHORT_SIZE = 2;
        int BIN_SIZE = 5;
        boolean BYTE_SIZE = true;
        int cb = 25;
        MemberSet set = msgEvent.ensureToMemberSet();
        int cMembers = set.size();
        cb += 2;
        cb += cMembers == 1 ? 2 : (cMembers < 255 ? 1 + cMembers * 2 : 1 + set.getBitSetCount() * 4);
        int nType = msgEvent.getEventType();
        int nEvent = nType & 7;
        if (nEvent != 1 && (nType & 0xC00) == 0) {
            Binary binOldVal = msgEvent.getOldValue();
            cb += binOldVal == null ? 1 : binOldVal.length() + 5;
        }
        if (nEvent != 3 && (nType & 0x300) == 0) {
            Binary binNewVal = msgEvent.getNewValue();
            cb += binNewVal == null ? 1 : binNewVal.length() + 5;
        }
        int cFilters = (alFilterId = msgEvent.getFilterId()) == null ? 0 : alFilterId.length;
        return cb += 2 + cFilters * 10 + 10 + 5;
    }

    public int estimateEventHolderByteSize(Object oEventHolder) {
        int PINT_SIZE = 5;
        int cb = 0;
        if (oEventHolder == null) {
            cb += 5;
        } else if (oEventHolder instanceof MapEventMessage) {
            MapEventMessage msgEvent = (MapEventMessage)oEventHolder;
            cb = 10 + this.estimateEventByteSize(msgEvent);
        } else {
            List listEvents = (List)oEventHolder;
            cb += 5;
            for (MapEventMessage msgEvent : listEvents) {
                cb += 5 + this.estimateEventByteSize(msgEvent);
            }
        }
        return cb;
    }

    @Override
    public int estimateMessageSize(Message msg) throws IOException {
        int cbMsg;
        int nMessageType = msg.getMessageType();
        if (nMessageType == 80 && this.getBackupSingleEnvelopeSize().get() == 0 || nMessageType == 53 && this.getBackupAllEnvelopeSize().get() == 0) {
            BackupRequest msgBackup = (BackupRequest)msg;
            msgBackup.setEstimating(true);
            AtomicInteger atomicEnvelopeSize = nMessageType == 80 ? this.getBackupSingleEnvelopeSize() : this.getBackupAllEnvelopeSize();
            atomicEnvelopeSize.compareAndSet(0, this.serializeMessage(msgBackup, new SizeEstimatingBufferOutput()));
            msgBackup.setEstimating(false);
        }
        return (cbMsg = msg.getEstimatedByteSize()) < 0 ? this.serializeMessage(msg, new SizeEstimatingBufferOutput()) : cbMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evaluateLockRequests() {
        long lTime = this.getClusterTime();
        long lVariance = this.getClusterTimeVariance();
        long lNext = Long.MAX_VALUE;
        PartitionedCache partitionedCache = this;
        synchronized (partitionedCache) {
            this.setLockingNextMillis(lNext);
        }
        for (Storage storage : this.getStorageArray()) {
            List listPending;
            if (!storage.isValid()) continue;
            ArrayList<LockRequest> listRetry = null;
            List list = listPending = storage.getPendingLockRequest();
            synchronized (list) {
                int cPending = listPending.size();
                if (cPending > 0) {
                    listRetry = new ArrayList<LockRequest>(cPending);
                    Iterator iter = listPending.iterator();
                    while (iter.hasNext()) {
                        LockRequest msgLock = (LockRequest)iter.next();
                        long lTimeout = msgLock.getLeaseWaitTimeout();
                        if (lTimeout <= lTime + lVariance) {
                            iter.remove();
                            listRetry.add(msgLock);
                            continue;
                        }
                        if (lTimeout == Long.MAX_VALUE) continue;
                        lNext = Math.min(lNext, lTimeout);
                    }
                }
            }
            if (listRetry == null) continue;
            for (LockRequest msgLock : listRetry) {
                try {
                    msgLock.onReceived();
                }
                catch (EventDeathException eventDeathException) {}
            }
        }
        if (lNext != Long.MAX_VALUE) {
            this.scheduleLockEvaluation(lNext - lTime);
        }
    }

    public ReadBuffer extractDelta(ReadBuffer bufOld, ReadBuffer bufNew) {
        return this.getBackupDeltaCompressor().extractDelta(bufOld, bufNew);
    }

    protected void flushEvents() {
        BMEventFabric.EventQueue queue = (BMEventFabric.EventQueue)this.getResourceCoordinator().getTloEventQueue().get();
        if (!this.flushOOBEvents() && queue != null && !queue.isEmpty()) {
            this.processChanges();
        }
    }

    protected boolean flushOOBEvents() {
        if (!this.getResourceCoordinator().getUnmanagedEventQueue().isEmpty()) {
            this.processChanges();
            return true;
        }
        return false;
    }

    public long generateCacheId() {
        long lCacheId;
        LongArray laBinaryMap = this.getBinaryMapArray();
        while (laBinaryMap.exists(lCacheId = this.getSUIDRange(3, 8))) {
        }
        return lCacheId;
    }

    public int getAddedDaemons() {
        return this.__m_AddedDaemons;
    }

    public BackingMapContext getBackingMapContext() {
        return this.__m_BackingMapContext;
    }

    @Override
    public BackingMapManager getBackingMapManager() {
        return this.__m_BackingMapManager;
    }

    public AtomicInteger getBackupAllEnvelopeSize() {
        return this.__m_BackupAllEnvelopeSize;
    }

    public int getBackupCountOpt() {
        return this.__m_BackupCountOpt;
    }

    public DeltaCompressor getBackupDeltaCompressor() {
        return this.__m_BackupDeltaCompressor;
    }

    public AtomicInteger getBackupSingleEnvelopeSize() {
        return this.__m_BackupSingleEnvelopeSize;
    }

    public com.tangosol.util.Converter getBinaryEntryConverter() {
        return this.__m_BinaryEntryConverter;
    }

    public LongArray getBinaryMapArray() {
        return this.__m_BinaryMapArray;
    }

    public String getCacheName(long lCacheId) {
        if (this.isOwnershipEnabled()) {
            Storage storage = this.getKnownStorage(lCacheId);
            return storage == null ? null : storage.getCacheName();
        }
        Grid.ServiceConfig.Map mapConfig = this.getServiceConfigMap();
        Enumeration e = this.getCacheNames();
        while (e.hasMoreElements()) {
            String sCacheName = (String)e.nextElement();
            XmlElement xmlElement = (XmlElement)mapConfig.get(sCacheName);
            if (xmlElement == null || xmlElement.getSafeAttribute("id").getLong() != lCacheId) continue;
            return sCacheName;
        }
        return null;
    }

    @Override
    public Enumeration getCacheNames() {
        Grid.ServiceConfig.Map mapConfig = this.getServiceConfigMap();
        while (true) {
            try {
                return new FilterEnumerator(mapConfig.keySet().iterator(), (Filter)new ClassFilter(String.class));
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    @Override
    public long getDistributionContendMillis() {
        PartitionSet partsPending = this.getIndexPendingPartitions();
        return partsPending == null || partsPending.isEmpty() ? super.getDistributionContendMillis() : 0L;
    }

    public DeltaCompressor getEventDeltaCompressor() {
        return this.__m_EventDeltaCompressor;
    }

    public EventsHelper getEventsHelper() {
        return this.__m_EventsHelper;
    }

    public long getEventResendInterval() {
        return this.__m_EventResendInterval;
    }

    public long getIndexingStartTime() {
        return this.__m_IndexingStartTime;
    }

    public PartitionSet getIndexPendingPartitions() {
        return this.__m_IndexPendingPartitions;
    }

    public PartitionSet getIndexProcessingPartitions() {
        return this.__m_IndexProcessingPartitions;
    }

    public int getIndexUpdateCount() {
        return this.__m_IndexUpdateCount;
    }

    public InvocationContext getInvocationContext() {
        InvocationContext ctx = (InvocationContext)this.getTLOContext().get();
        return ctx != null && ctx.isActive() ? ctx : null;
    }

    public Storage getKnownStorage(long lCacheId) {
        Storage storage;
        if (this.isOwnershipEnabled() && (storage = this.getStorage(lCacheId)) != null && storage.isValid()) {
            return storage;
        }
        return null;
    }

    protected LazyLookup getLazyLookup(Map mapLookup, Object oKey) {
        LazyLookup lazyLookup = this.getLazyLookupReadBuffer();
        lazyLookup.setLookupMap(mapLookup);
        lazyLookup.setLookupKey(oKey);
        return lazyLookup;
    }

    public LazyLookup getLazyLookupReadBuffer() {
        return this.__m_LazyLookupReadBuffer;
    }

    public int getLeaseGranularity() {
        return this.__m_LeaseGranularity;
    }

    public long getLockingNextMillis() {
        return this.__m_LockingNextMillis;
    }

    public long getOldestEventResendNextMillis() {
        return this.__m_OldestEventResendNextMillis;
    }

    public long getOldestPendingEventSUID() {
        return PartitionedCache.calculateOldestSUID(this.getPendingEvents(), this.getThisMember().getId());
    }

    public LongArray getPendingEvents() {
        return this.__m_PendingEvents;
    }

    public ConcurrentLinkedQueue getPendingIndexUpdate() {
        return this.__m_PendingIndexUpdate;
    }

    public SparseArray[] getPendingResultInfo() {
        return this.__m_PendingResultInfo;
    }

    public LongArray getPendingResultInfo(long lSUID) {
        SparseArray[] ala = this.getPendingResultInfo();
        return ala[PartitionedCache.getMemberId(lSUID) % ala.length];
    }

    public LongArray getPersistentCacheIds() {
        return this.getPersistentCacheIds(false);
    }

    public LongArray getPersistentCacheIds(boolean fSnapshot) {
        BackingMapManager manager = this.getBackingMapManager();
        SparseArray<String> laCaches = new SparseArray<String>();
        for (Storage storage : this.getStorageArray()) {
            String sCache = storage.getCacheName();
            long lCacheId = storage.getCacheId();
            if (!storage.isValid() || !manager.isBackingMapPersistent(sCache, fSnapshot)) continue;
            laCaches.set(lCacheId, sCache);
        }
        return laCaches;
    }

    public LongArray getProcessedEvents() {
        return this.__m_ProcessedEvents;
    }

    public Map getReferencesBinaryMap() {
        return this.__m_ReferencesBinaryMap;
    }

    public RequestCoordinator getRequestCoordinator() {
        return this.__m_RequestCoordinator;
    }

    public ResourceCoordinator getResourceCoordinator() {
        return this.__m_ResourceCoordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultInfo getResultInfo(RequestContext context) {
        LongArray laPending;
        if (context == null) {
            return null;
        }
        long lSUID = context.getRequestSUID();
        long lSUIDPending = context.getOldestPendingSUID();
        LongArray longArray = laPending = this.getPendingResultInfo(lSUID);
        synchronized (longArray) {
            PartitionedCache.removeSUIDRange(laPending, PartitionedCache.getBaseSUID(lSUIDPending), lSUIDPending, false);
            return (ResultInfo)laPending.get(lSUID);
        }
    }

    public int getScheduledBackupsThreshold() {
        return this.__m_ScheduledBackupsThreshold;
    }

    public MemorySize getMaxPartialResponseSize() {
        return this.__m_MaxPartialResponseSize;
    }

    public ScopedCacheReferenceStore getScopedCacheStore() {
        return this.__m_ScopedCacheStore;
    }

    public SendBackupsTask getSendBackupsTask() {
        return this.__m_SendBackupsTask;
    }

    public long getStandardLeaseMillis() {
        return this.__m_StandardLeaseMillis;
    }

    public AtomicLong getStatsIndexingTime() {
        return this.__m_StatsIndexingTime;
    }

    public Storage getStorage(long lCacheId) {
        return (Storage)this.getStorageArray().get(lCacheId);
    }

    public Storage getStorage(String sCacheName) {
        BinaryMap mapBinary = (BinaryMap)this.getReferencesBinaryMap().get(sCacheName);
        if (mapBinary == null) {
            for (Storage storage : this.getStorageArray()) {
                if (!sCacheName.equals(storage.getCacheName())) continue;
                return storage;
            }
            return null;
        }
        Storage storage = this.getStorage(mapBinary.getCacheId());
        return storage != null && sCacheName.equals(storage.getCacheName()) ? storage : null;
    }

    public LongArray getStorageArray() {
        return this.__m_StorageArray;
    }

    @Override
    public Set getStorageEnabledMembers() {
        return this.getOwnershipMemberSet();
    }

    public Map getStorageGraveyard() {
        return this.__m_StorageGraveyard;
    }

    public int getTaskSplitThreshold() {
        return this.__m_TaskSplitThreshold;
    }

    public ThreadLocal getTLOContext() {
        return this.__m_TLOContext;
    }

    @Override
    public long getWaitMillis() {
        long cWait1 = super.getWaitMillis();
        long ldtNow = Base.getLastSafeTimeMillis();
        long cWait2 = this.getLockingNextMillis() - ldtNow;
        return cWait1 <= 0L ? cWait2 : Math.min(cWait1, cWait2);
    }

    @Override
    public boolean hasPersistentData(int iPartition) {
        if (super.hasPersistentData(iPartition)) {
            return true;
        }
        BackingMapManager manager = this.getBackingMapManager();
        for (Storage storage : this.getStorageArray()) {
            if (!storage.isValid() || !manager.isBackingMapPersistent(storage.getCacheName()) || !storage.hasData(iPartition)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected XmlElement initServiceConfig() {
        XmlElement xmlConfig = super.initServiceConfig();
        String sCompressor = this.getEventDeltaCompressor().getClass().getName();
        xmlConfig.addAttribute("delta-compressor").setString(sCompressor);
        return xmlConfig;
    }

    public BatchContext instantiateBatchContext(Message msgResponse) {
        BatchContext ctxBatch = new BatchContext();
        this._linkChild(ctxBatch);
        ctxBatch.setPrimaryResponse(msgResponse);
        ctxBatch.setOutstandingOperationCounter(new AtomicInteger(1));
        return ctxBatch;
    }

    public BinaryMap instantiateBinaryMap(String sName, long lCacheId) {
        BinaryMap mapBinary = (BinaryMap)this._newChild("BinaryMap");
        BackingMapManager mgr = this.getBackingMapManager();
        PartitionedCache._assert(mgr != null);
        mapBinary.setCacheId(lCacheId);
        mapBinary.setCacheName(sName);
        mapBinary.setReadLocator(mgr.getReadLocator(sName));
        return mapBinary;
    }

    public ConverterFromBinary instantiateFromBinaryConverter(ClassLoader loader) {
        ConverterFromBinary conv = (ConverterFromBinary)this._newChild("ConverterFromBinary");
        conv.setSerializer(this.ensureSerializer(loader));
        return conv;
    }

    protected InvocationContext instantiateInvocationContext() {
        InvocationContext ctx = new InvocationContext();
        this._linkChild(ctx);
        ctx.initialize();
        return ctx;
    }

    public ConverterValueToBinary instantiateValueToBinaryConverter(ClassLoader loader) {
        ConverterValueToBinary conv = (ConverterValueToBinary)this._newChild("ConverterValueToBinary");
        conv.setSerializer(this.ensureSerializer(loader));
        return conv;
    }

    @Override
    public boolean isAllAllowed() {
        return super.isAllAllowed() && this.getActionPolicy().isAllowed(this, CacheService.CacheAction.READ) && this.getActionPolicy().isAllowed(this, CacheService.CacheAction.WRITE);
    }

    @Override
    public boolean isCompatibleServiceType(String sType) {
        return this.getServiceType().equals(sType) || "PagedTopic".equals(sType);
    }

    public boolean isIndexed() {
        for (Storage storage : this.getStorageArray()) {
            if (!storage.isIndexed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLocalStorageEnabled() {
        return this.isOwnershipEnabled();
    }

    protected boolean isPartitionIndexPending(int nPartition) {
        return this.getIndexPendingPartitions().contains(nPartition) && !this.getIndexProcessingPartitions().contains(nPartition);
    }

    protected boolean isStorageCreated(Iterator iter) {
        while (iter.hasNext()) {
            if (this.getStorage((String)iter.next()) != null) continue;
            return false;
        }
        return true;
    }

    public boolean isStrictPartitioning() {
        return this.__m_StrictPartitioning;
    }

    @Override
    public boolean isSuspendedFully() {
        if (super.isSuspendedFully()) {
            for (Storage storage : this.getStorageArray()) {
                ReadWriteBackingMap.WriteQueue queue;
                ObservableMap map = storage.getBackingMap();
                if (!(map instanceof ReadWriteBackingMap) || (queue = ((ReadWriteBackingMap)map).getWriteQueue()) == null || queue.isFlushed()) continue;
                queue.flush();
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isTaskSplitWorthy(int cEntries) {
        return cEntries > this.getTaskSplitThreshold() && this.getDaemonPool().getDaemonCount() > 1;
    }

    public boolean lockKey(Storage storage, Binary binKey, boolean fEnter) {
        return this.lockKey(storage, binKey, fEnter, -1L);
    }

    public boolean lockKey(Storage storage, Binary binKey, boolean fEnter, long cWait) {
        int nPartition = this.getKeyPartition(binKey);
        boolean fEntered = false;
        PartitionControl ctrl = (PartitionControl)this.getPartitionControl(nPartition);
        if (fEnter && cWait == 0L && (ctrl == null || ctrl.isLocked())) {
            return false;
        }
        if ((!fEnter || (fEntered = this.enterPartition(nPartition, cWait))) && this.isPrimaryOwner(nPartition) && this.getResourceCoordinator().lock(storage, binKey, cWait)) {
            return true;
        }
        if (fEntered) {
            this.exitPartition(nPartition);
        }
        return false;
    }

    protected void lockSynthetic(Storage storage) {
        this.getResourceCoordinator().lock(storage, new Binary(), -1L);
    }

    protected Message[] merge(Message[] aMsgOne, Message[] aMsgTwo) {
        if (aMsgOne == null) {
            return aMsgTwo;
        }
        if (aMsgTwo == null) {
            return aMsgOne;
        }
        if (aMsgOne.length == 0) {
            return aMsgTwo;
        }
        if (aMsgTwo.length == 0) {
            return aMsgOne;
        }
        Message[] aMsgAll = new Message[aMsgOne.length + aMsgTwo.length];
        System.arraycopy(aMsgOne, 0, aMsgAll, 0, aMsgOne.length);
        System.arraycopy(aMsgTwo, 0, aMsgAll, aMsgOne.length, aMsgTwo.length);
        return aMsgAll;
    }

    protected void mergeTransferredResults(long lSUID, int iPart, Map mapResult) {
        RequestContext context = this.instantiateRequestContext();
        context.setOldestPendingSUID(-1L);
        context.setRequestSUID(lSUID);
        boolean fOnlyIfPending = PartitionedCache.getMemberId(lSUID) == this.getThisMember().getId();
        ResultInfo resultInfo = this.ensureResultInfo(context, fOnlyIfPending);
        if (resultInfo != null) {
            resultInfo.mergeResults(iPart, mapResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void movePartition(int iPartition, int iBackupTo) {
        AutoCloseable closeable = null;
        if (this.isActivePersistence()) {
            PartitionControl ctrl = (PartitionControl)this.getPartitionControl(iPartition);
            PersistentStore store = null;
            if (iBackupTo == 0) {
                store = ctrl.ensurePersistentStore();
            } else if (this.isBackupPersistence()) {
                store = ctrl.ensurePersistentStore(null, false, true);
            }
            if (store != null && store.isOpen()) {
                closeable = store.exclusively();
            }
            if (iBackupTo == 0) {
                ctrl.preparePersistentExtents();
            } else if (this.isBackupPersistence()) {
                ctrl.preparePersistentBackupExtents();
            }
        }
        try {
            for (Storage storage : this.getStorageArray()) {
                if (!storage.isValid()) continue;
                storage.movePartition(iPartition, iBackupTo > 0);
            }
            super.movePartition(iPartition, iBackupTo);
        }
        finally {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void onAggregateAllRequest(AggregateAllRequest msgRequest) {
        PartialValueResponse msgResponse = (PartialValueResponse)this.instantiateMessage("PartialValueResponse");
        msgResponse.respondTo(msgRequest);
        Storage storage = this.validateRequestForStorage(msgRequest, msgResponse, true);
        if (storage == null) {
            return;
        }
        Set setKeys = msgRequest.getKeySetSafe();
        PartitionedService.PinningIterator pinner = this.createPinningIterator(setKeys);
        HashSet<Binary> setKeysPinned = new HashSet<Binary>(setKeys.size());
        while (pinner.hasNext()) {
            Binary binKey = (Binary)pinner.next();
            setKeysPinned.add(binKey);
        }
        PartitionSet partsPinned = pinner.getPinnedPartitions();
        InvocationContext ctxInvoke = this.ensureInvocationContext(partsPinned);
        ctxInvoke.markReadOnlyRequest();
        try {
            InvocableMap.EntryAggregator agent = msgRequest.deserializeAggregator();
            ctxInvoke.prepareAccess(msgRequest.getRequestContext(), storage, 40960, 9);
            Object oResult = agent instanceof InvocableMap.StreamingAggregator ? storage.aggregateByStreaming(setKeysPinned, (InvocableMap.StreamingAggregator)agent) : agent.aggregate(ConverterCollections.getSet(setKeysPinned, storage.getKeyToBinaryEntryConverter(), NullImplementation.getConverter()));
            msgResponse.setResult(this.getBackingMapContext().getValueToInternalConverter().convert(oResult));
            msgResponse.setRejectPartitions(pinner.getRejectedPartitions());
        }
        catch (Throwable e) {
            msgResponse.setException(this.tagException(e));
        }
        GuardSupport.reset();
        this.processChanges(msgResponse);
        this.releaseInvocationContext(ctxInvoke);
        msgRequest.setProcessedPartitions(partsPinned);
        this.unpinPartitions(partsPinned);
    }

    public void onAggregateFilterRequest(AggregateFilterRequest msgRequest) {
        PartialValueResponse msgResponse = (PartialValueResponse)this.instantiateMessage("PartialValueResponse");
        msgResponse.respondTo(msgRequest);
        Storage storage = this.validateRequestForStorage(msgRequest, msgResponse, true);
        if (storage == null) {
            return;
        }
        this.flushOOBEvents();
        PartitionSet partMask = msgRequest.getRequestMaskSafe();
        Filter filter = msgRequest.getFilter();
        PartitionSet partReject = this.pinOwnedPartitions(partMask);
        InvocationContext ctxInvoke = this.ensureInvocationContext(partMask);
        ctxInvoke.markReadOnlyRequest();
        try {
            InvocableMap.EntryAggregator agent = msgRequest.deserializeAggregator();
            ctxInvoke.prepareAccess(msgRequest.getRequestContext(), storage, 40960, 9);
            if (agent instanceof QueryRecorder) {
                QueryRecord.PartialResult oResult = ((QueryRecorder)agent).getType() == QueryRecorder.RecordType.TRACE ? storage.trace(filter, partMask) : storage.explain(filter, partMask);
                msgResponse.setResult(this.getBackingMapContext().getValueToInternalConverter().convert(oResult));
            } else if (agent instanceof InvocableMap.StreamingAggregator) {
                Object oResult = storage.aggregateByStreaming(filter, (InvocableMap.StreamingAggregator)agent, partMask, msgRequest.checkTimeoutRemaining());
                msgResponse.setResult(this.getBackingMapContext().getValueToInternalConverter().convert(oResult));
            } else {
                storage.aggregateByProbe(filter, agent, partMask, msgRequest, msgResponse);
            }
            msgResponse.setRejectPartitions(partReject);
        }
        catch (Throwable e) {
            msgResponse.setException(this.tagException(e));
        }
        GuardSupport.reset();
        this.processChanges(msgResponse);
        this.releaseInvocationContext(ctxInvoke);
        msgRequest.setProcessedPartitions(partMask);
        this.unpinPartitions(partMask);
    }

    public void onBackupAllRequest(BackupAllRequest msgRequest, PartitionSet partsSkip) {
        if (this.isOwnershipEnabled()) {
            long lCacheId = msgRequest.getCacheId();
            Map mapEntries = msgRequest.getMap();
            Map mapEvents = msgRequest.getEventHolderMap();
            Map mapResults = msgRequest.getResultMap();
            Member memberOwner = msgRequest.getOriginatingMember();
            RequestContext ctx = msgRequest.getRequestContext();
            Map mapGraveYard = this.getStorageGraveyard();
            if (lCacheId == -1L) {
                long lCacheIdResults = msgRequest.getResultsCacheId();
                for (Long l : mapEntries.keySet()) {
                    long lId = l;
                    if (this.getKnownStorage(lId) == null) {
                        if (mapGraveYard.containsKey(l)) continue;
                        this.deferBackup(ctx, msgRequest.getPartitionSet(), lId, (Map)mapEntries.get(l), (Map)mapEvents.get(l), memberOwner);
                        continue;
                    }
                    this.doBackupAll(ctx, partsSkip, lId, (Map)mapEntries.get(l), (Map)mapEvents.get(l), lId == lCacheIdResults ? mapResults : null, memberOwner);
                }
            } else if (this.getKnownStorage(lCacheId) == null) {
                if (!mapGraveYard.containsKey(lCacheId)) {
                    this.deferBackup(ctx, msgRequest.getPartitionSet(), lCacheId, mapEntries, mapEvents, memberOwner);
                }
            } else {
                this.doBackupAll(ctx, partsSkip, lCacheId, mapEntries, mapEvents, mapResults, memberOwner);
            }
            PrimitiveSparseArray paVersions = msgRequest.getPartitionVersions();
            if (paVersions.getSize() == 1 && partsSkip == null) {
                this.registerMultiResult(ctx, (int)paVersions.getFirstIndex(), mapResults);
            } else {
                PartitionSet parts = msgRequest.getPartitionSet();
                if (partsSkip != null) {
                    parts.remove(partsSkip);
                }
                this.registerMultiResult(ctx, parts, mapResults);
            }
            Map mapVersions = msgRequest.getMapEventVersions();
            for (Map.Entry entry : mapVersions.entrySet()) {
                long lCacheIdCur = (Long)entry.getKey();
                Storage storage = this.getKnownStorage(lCacheIdCur);
                if (storage == null) continue;
                VersionedPartitions versions = (VersionedPartitions)entry.getValue();
                StorageVersion storageVersion = storage.getVersion();
                VersionedPartitions.VersionedIterator iterPart = versions.iterator();
                while (iterPart.hasNext()) {
                    long lVersion = iterPart.nextVersion();
                    storageVersion.resetSubmitted(iterPart.getPartition(), lVersion);
                }
            }
        } else {
            PartitionedCache._assert(this.getServiceState() >= 3);
        }
    }

    public void onBackupListenerAllRequest(BackupListenerAllRequest msgRequest, PartitionSet partsSkip) {
        long lExtentId = msgRequest.getCacheId();
        Storage storage = this.getKnownStorage(lExtentId);
        Member member = this.getServiceMemberSet().getMember(msgRequest.getMemberId());
        if (storage != null && member != null) {
            boolean fAdd = msgRequest.isAdd();
            boolean fLite = msgRequest.isLite();
            Set setKeys = msgRequest.getKeySet();
            long ldtJoined = this.getServiceMemberSet().getServiceJoinTime(member.getId());
            for (Binary binKey : setKeys) {
                PersistentStore store;
                int nPartition = this.getKeyPartition(binKey);
                PartitionControl ctrl = (PartitionControl)this.getPartitionControl(nPartition);
                PersistentStore persistentStore = store = storage.isPersistent() && this.isBackupPersistence() ? ctrl.getPersistentBackupStore() : null;
                if (partsSkip != null && partsSkip.contains(nPartition)) continue;
                if (msgRequest.isAdd()) {
                    storage.addKeyListener(member, binKey, fLite, false);
                    if (store == null) continue;
                    CachePersistenceHelper.registerListener(store, lExtentId, binKey, ldtJoined, fLite, null);
                    continue;
                }
                storage.removeKeyListener(member, binKey, false);
                if (store == null) continue;
                CachePersistenceHelper.unregisterListener(store, lExtentId, binKey, ldtJoined, null);
            }
        }
    }

    public void onBackupListenerRequest(BackupListenerRequest msgRequest) {
        long lExtentId = msgRequest.getCacheId();
        Storage storage = this.getKnownStorage(lExtentId);
        Member member = this.getServiceMemberSet().getMember(msgRequest.getMemberId());
        if (storage != null && member != null) {
            long ldtJoined;
            PartitionControl ctrl = (PartitionControl)this.getPartitionControl(msgRequest.getPartition());
            PersistentStore store = storage.isPersistent() && this.isBackupPersistence() ? ctrl.getPersistentBackupStore() : null;
            boolean fLite = msgRequest.isLite();
            Binary binKey = msgRequest.getKey();
            long l = ldtJoined = store == null ? 0L : this.getServiceMemberSet().getServiceJoinTime(member.getId());
            if (msgRequest.isAdd()) {
                storage.addKeyListener(member, binKey, fLite, false);
                if (store != null) {
                    CachePersistenceHelper.registerListener(store, lExtentId, binKey, ldtJoined, fLite, null);
                }
            } else {
                storage.removeKeyListener(member, binKey, false);
                if (store != null) {
                    CachePersistenceHelper.unregisterListener(store, lExtentId, binKey, ldtJoined, null);
                }
            }
        }
    }

    public void onBackupLockRequest(BackupLockRequest msgRequest) {
        Storage storage = this.getKnownStorage(msgRequest.getCacheId());
        if (storage != null) {
            Lease lease = msgRequest.getLease();
            long lExtentId = msgRequest.getCacheId();
            PartitionControl ctrl = (PartitionControl)this.getPartitionControl(msgRequest.getPartition());
            PersistentStore store = storage.isPersistent() && this.isBackupPersistence() ? ctrl.getPersistentBackupStore() : null;
            long ldtJoined = store == null ? 0L : this.getServiceMemberSet().getServiceJoinTime(lease.getHolderId());
            Binary binKey = msgRequest.getKey();
            Map mapLease = storage.getBackupLeaseMap();
            if (msgRequest.isLock()) {
                if (this.getServiceMemberSet().contains(lease.getHolderId())) {
                    mapLease.put(binKey, lease);
                    if (store != null) {
                        CachePersistenceHelper.registerLock(store, lExtentId, binKey, ldtJoined, lease.getHolderThreadId(), null);
                    }
                }
            } else {
                mapLease.remove(binKey);
                if (store != null) {
                    CachePersistenceHelper.unregisterLock(store, lExtentId, binKey, ldtJoined, lease.getHolderThreadId(), null);
                }
            }
        }
    }

    public void onBackupSingleRequest(BackupSingleRequest msgRequest) {
        if (this.isOwnershipEnabled()) {
            long lCacheId = msgRequest.getCacheId();
            Storage storage = this.getKnownStorage(lCacheId);
            Object oEvent = msgRequest.getEventHolder();
            Binary binKey = msgRequest.getKey();
            Binary binValue = ExternalizableHelper.asBinary(msgRequest.getValue());
            boolean fRemove = Binary.EMPTY.equals(binValue);
            Member memberOwner = msgRequest.getOriginatingMember();
            RequestContext ctx = msgRequest.getRequestContext();
            int iPartition = msgRequest.getPartition();
            long lVersion = msgRequest.getMapEventVersion();
            if (storage == null) {
                if (!this.getStorageGraveyard().containsKey(lCacheId)) {
                    this.deferBackup(ctx, iPartition, lCacheId, Collections.singletonMap(binKey, binValue), Collections.singletonMap(binKey, oEvent), memberOwner);
                }
            } else {
                Map mapBackup = storage.getBackupMap();
                boolean fResult = msgRequest.getResult() != null;
                boolean fEvent = oEvent != null;
                Binary binValueOld = null;
                binKey = storage.getCanonicalKey(binKey);
                if (binValue == null) {
                    binValue = binValueOld = (Binary)mapBackup.get(binKey);
                } else if (fRemove) {
                    binValueOld = this.doBackupRemove(mapBackup, binKey);
                } else {
                    if ((binValue = this.applyDelta(mapBackup, binKey, binValue)) == null) {
                        return;
                    }
                    if (fEvent || fResult || !storage.isPreferPutAllBackup()) {
                        binValueOld = this.doBackupPut(mapBackup, binKey, binValue);
                    } else {
                        this.doBackupPutAll(mapBackup, Collections.singletonMap(binKey, binValue));
                    }
                }
                if (this.isBackupPersistence()) {
                    this.persistBackup(iPartition, lCacheId, binKey, binValue, fRemove);
                }
                this.registerSingleResult(ctx, binKey, Storage.decompressResult(msgRequest.getResult(), binValueOld, binValue));
                if (fEvent) {
                    this.registerEvent(MapEvent.decompressEventHolder(oEvent, lCacheId, binKey, binValueOld, binValue), memberOwner);
                }
                if (lVersion > 0L) {
                    storage.getVersion().resetSubmitted(iPartition, lVersion);
                }
            }
        } else {
            PartitionedCache._assert(this.getServiceState() >= 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClearRequest(ClearRequest msgRequest) {
        InvocationContext ctxInvoke;
        PartitionSet partMask;
        PartialValueResponse msgResponse;
        block8: {
            msgResponse = (PartialValueResponse)this.instantiateMessage("PartialValueResponse");
            msgResponse.respondTo(msgRequest);
            Storage storage = this.validateRequestForStorage(msgRequest, msgResponse, false);
            if (storage == null) {
                return;
            }
            partMask = msgRequest.getRequestMaskSafe();
            PartitionSet partReject = this.pinOwnedPartitions(partMask);
            msgResponse.setRejectPartitions(partReject);
            ctxInvoke = this.ensureInvocationContext(partMask);
            try {
                ctxInvoke.lockStorage(storage);
                ctxInvoke.prepareAccess(msgRequest.getRequestContext(), storage, 49152, 7);
                if (msgRequest.isTruncate()) {
                    LongArray laStorage;
                    Storage storageNew = storage.truncate();
                    LongArray longArray = laStorage = this.getStorageArray();
                    synchronized (longArray) {
                        laStorage.set(storageNew.getCacheId(), storageNew);
                    }
                    if (this.getThisMember() == this.getOwnershipSenior(true)) {
                        String sCacheName = storageNew.getCacheName();
                        Grid.ServiceConfig.Map mapConfig = this.getServiceConfigMap();
                        XmlElement xmlCacheInfo = (XmlElement)((XmlElement)mapConfig.get(sCacheName)).clone();
                        XmlValue xmlAttr = xmlCacheInfo.getAttribute("truncateTime");
                        xmlCacheInfo.addAttribute("truncateTime").setInt(xmlAttr == null ? 1 : xmlAttr.getInt() + 1);
                        mapConfig.put(sCacheName, xmlCacheInfo);
                    }
                    break block8;
                }
                storage.clear(ctxInvoke, partMask);
            }
            catch (Throwable e) {
                msgResponse.setException(this.tagException(e));
            }
        }
        GuardSupport.reset();
        this.processChanges(null, null, -1L, ctxInvoke.getEntryStatuses(), this.instantiateBatchContext(msgResponse));
        ctxInvoke.release(false);
        this.unpinPartitions(partMask);
    }

    public void onContainsAllRequest(ContainsAllRequest msgRequest) {
        PartialValueResponse msgResponse = (PartialValueResponse)this.instantiateMessage("PartialValueResponse");
        msgResponse.respondTo(msgRequest);
        msgResponse.setResult(Boolean.TRUE);
        Storage storage = this.validateRequestForStorage(msgRequest, msgResponse, false);
        if (storage == null) {
            return;
        }
        Set setKeys = msgRequest.getKeySetSafe();
        PartitionedService.PinningIterator pinner = this.createPinningIterator(setKeys);
        try {
            while (pinner.hasNext()) {
                if (storage.containsKey((Binary)pinner.next())) continue;
                msgResponse.setResult(Boolean.FALSE);
                break;
            }
            msgResponse.setRejectPartitions(pinner.getRejectedPartitions());
        }
        catch (Throwable e) {
            msgResponse.setException(this.tagException(e));
        }
        this.processChanges(msgResponse);
        PartitionSet partsPinned = pinner.getPinnedPartitions();
        msgRequest.setProcessedPartitions(partsPinned);
        this.unpinPartitions(partsPinned);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onContainsKeyRequest(ContainsKeyRequest msgRequest) {
        Grid.Response msgResponse;
        block8: {
            msgResponse = (Grid.Response)this.instantiateMessage("Response");
            msgResponse.respondTo(msgRequest);
            Storage storage = this.validateRequestForStorage(msgRequest, msgResponse, false);
            if (storage == null) {
                return;
            }
            try {
                Binary binKey = msgRequest.getKey();
                int nPartition = this.getKeyPartition(binKey);
                if (this.pinOwnedPartition(nPartition)) {
                    try {
                        boolean fContains = storage.containsKey(binKey);
                        msgResponse.setValue(fContains);
                    }
                    finally {
                        this.unpinPartition(nPartition);
                    }
                    msgRequest.setProcessedPartition(nPartition);
                    break block8;
                }
                msgResponse.setResult(1);
            }
            catch (Throwable e) {
                msgResponse.setResult(2);
                msgResponse.setValue(this.tagException(e));
            }
        }
        this.processChanges(msgResponse);
    }

    public void onContainsValueRequest(ContainsValueRequest msgRequest) {
        PartialValueResponse msgResponse = (PartialValueResponse)this.instantiateMessage("PartialValueResponse");
        msgResponse.respondTo(msgRequest);
        Storage storage = this.validateRequestForStorage(msgRequest, msgResponse, false);
        if (storage == null) {
            return;
        }
        PartitionSet partMask = msgRequest.getRequestMaskSafe();
        PartitionSet partReject = this.pinOwnedPartitions(partMask);
        Binary binValue = msgRequest.getValue();
        try {
            boolean fContains = storage.containsValue(binValue);
            msgResponse.setResult(fContains);
            msgResponse.setRejectPartitions(partReject);
        }
        catch (Throwable e) {
            msgResponse.setException(this.tagException(e));
        }
        this.processChanges(msgResponse);
        msgRequest.setProcessedPartitions(partMask);
        this.unpinPartitions(partMask);
    }

    @Override
    protected void onDependencies(ServiceDependencies deps) {
        super.onDependencies(deps);
        PartitionedCacheDependencies partitionedDeps = (PartitionedCacheDependencies)deps;
        this.setBackupCountOpt(partitionedDeps.getBackupCountAfterWriteBehind());
        this.setLeaseGranularity(partitionedDeps.getLeaseGranularity());
        this.setStrictPartitioning(partitionedDeps.isStrictPartitioning());
        this.setStandardLeaseMillis(partitionedDeps.getStandardLeaseMillis());
        DeltaCompressor compressor = partitionedDeps.getDeltaCompressor();
        this.setEventDeltaCompressor(compressor);
        this.setBackupDeltaCompressor(partitionedDeps.getBackupCountAfterWriteBehind() == 0 ? NullImplementation.getDeltaCompressor() : compressor);
        int cDaemons = deps.getWorkerThreadCountMin();
        SparseArray[] alaPending = new SparseArray[cDaemons == 0 ? 1 : 3 * (cDaemons > 0 ? cDaemons : Platform.getPlatform().getFairShareProcessors())];
        int c = alaPending.length;
        for (int i = 0; i < c; ++i) {
            alaPending[i] = new SparseArray();
        }
        this.setPendingResultInfo(alaPending);
    }

    @Override
    protected void onExit() {
        this.releaseAllCache();
        this.releaseAllStorage();
        super.onExit();
        this.getEventsHelper().unregisterServiceDispatcher();
        this.getRequestCoordinator().clearBacklog();
    }

    @Override
    protected void onFinalizeStartup() {
        if (this.isOwnershipEnabled()) {
            this.setIndexPendingPartitions(new PartitionSet(this.getPartitionCount()));
            this.setIndexProcessingPartitions(new PartitionSet(this.getPartitionCount()));
        }
        super.onFinalizeStartup();
        this.getEventsHelper().onServiceStarted();
        if (this.isOwnershipEnabled()) {
            this.ensureKnownStorage();
        }
    }

    public void onGetAllRequest(GetAllRequest msgRequest) {
        int iPart;
        PartialMapResponse msgResponse = (PartialMapResponse)this.instantiateMessage("PartialMapResponse");
        msgResponse.respondTo(msgRequest);
        Storage storage = this.validateRequestForStorage(msgRequest, msgResponse, false);
        if (storage == null) {
            return;
        }
        Collection colKeys = msgRequest.getKeySetSafe();
        int cKeys = colKeys.size();
        int cbLimit = msgRequest.getSizeThreshold();
        boolean cStatus = false;
        Map mapPartKeys = this.splitKeysByPartition(colKeys.iterator());
        PartitionSet partsPinned = this.instantiatePartitionSet(false);
        PartitionSet partsRejected = null;
        boolean fBackupRead = !msgRequest.isCoherentResult();
        Iterator iter = mapPartKeys.keySet().iterator();
        while (iter.hasNext()) {
            iPart = (Integer)iter.next();
            if (this.isPrimaryOwner(iPart) && this.pinOwnedPartition(iPart)) {
                partsPinned.add(iPart);
                continue;
            }
            if (fBackupRead && this.isBackupOwner(iPart)) continue;
            if (partsRejected == null) {
                partsRejected = this.instantiatePartitionSet(false);
            }
            partsRejected.add(iPart);
            colKeys.removeAll((Collection)mapPartKeys.get(iPart));
        }
        if (fBackupRead && !partsPinned.isEmpty()) {
            Collection[] acol = new Collection[partsPinned.cardinality()];
            iPart = partsPinned.next(0);
            int i = 0;
            while (iPart >= 0) {
                acol[i++] = (Collection)mapPartKeys.remove(iPart);
                iPart = partsPinned.next(iPart + 1);
            }
            colKeys = acol.length == 1 ? acol[0] : new ChainedCollection(acol);
        }
        InvocationContext ctxInvoke = this.ensureInvocationContext();
        try {
            while (true) {
                Iterator iterKeys = fBackupRead && partsPinned.isEmpty() ? NullImplementation.getIterator() : colKeys.iterator();
                try {
                    while (iterKeys.hasNext()) {
                        ctxInvoke.lockEntry(storage, (Binary)iterKeys.next(), false);
                    }
                }
                catch (LockContentionException e) {
                    ctxInvoke.rollback(e, msgRequest);
                    continue;
                }
                break;
            }
            ctxInvoke.getPrePinnedPartitions().add(partsPinned);
            ctxInvoke.prepareAccess(msgRequest.getRequestContext(), storage, 40960, 1);
            Map mapResult = Collections.emptyMap();
            if (!partsPinned.isEmpty()) {
                mapResult = storage.getAll(ctxInvoke, colKeys);
            }
            if (fBackupRead && !mapPartKeys.isEmpty()) {
                if (partsRejected == null) {
                    partsRejected = this.instantiatePartitionSet(false);
                }
                Map mapTemp = storage.getAllFromBackup(mapPartKeys, partsRejected);
                mapResult = mapResult.isEmpty() ? mapTemp : new ChainedMap(mapResult, mapTemp);
            }
            int cResult = mapResult.size();
            int cEntries = 0;
            int cbSize = 0;
            Object[] abinKey = new Binary[cResult];
            Object[] abinVal = new Binary[cResult];
            for (Map.Entry entry : mapResult.entrySet()) {
                Binary binKey = (Binary)entry.getKey();
                Binary binVal = (Binary)entry.getValue();
                abinKey[cEntries] = binKey;
                abinVal[cEntries] = binVal;
                ++cEntries;
                if (cbLimit == 0 || (cbSize += binKey.length() + binVal.length()) <= cbLimit) continue;
                break;
            }
            msgResponse.setKey(abinKey);
            msgResponse.setValue(abinVal);
            msgResponse.setSize(cEntries);
            msgResponse.setRejectPartitions(partsRejected);
        }
        catch (Throwable e) {
            msgResponse.setException(this.tagException(e));
        }
        GuardSupport.reset();
        this.processChanges(null, null, msgRequest.getCacheId(), ctxInvoke.getEntryStatuses(), this.instantiateBatchContext(msgResponse));
        this.releaseInvocationContext(ctxInvoke);
        msgRequest.setProcessedPartitions(partsPinned);
        this.unpinPartitions(partsPinned);
    }

    public void onGetRequest(GetRequest msgRequest) {
        Grid.Response msgResponse = (Grid.Response)this.instantiateMessage("Response");
        msgResponse.respondTo(msgRequest);
        Storage storage = this.validateRequestForStorage(msgRequest, msgResponse, false);
        if (storage == null) {
            return;
        }
        InvocationContext ctxInvoke = this.ensureInvocationContext();
        RequestContext context = msgRequest.getRequestContext();
        Binary binKey = msgRequest.getKey();
        Storage.EntryStatus status = null;
        int iPart = this.getKeyPartition(binKey);
        try {
            boolean fBackup;
            status = fBackup ? null : ctxInvoke.lockEntry(storage, binKey, this.isConcurrent());
            Binary binValue = Binary.NO_BINARY;
            for (fBackup = !msgRequest.isCoherentResult() && this.isBackupOwner(iPart) ? true : false; binValue == Binary.NO_BINARY || status == null && !fBackup; fBackup &= this.isBackupOwner(iPart)) {
                if (status == null && !fBackup) {
                    msgResponse.setResult(1);
                    this.post(msgResponse);
                    return;
                }
                binValue = fBackup ? storage.getFromBackup(binKey) : storage.get(ctxInvoke, status, binKey);
            }
            msgResponse.setValue(binValue);
            StorageAccessAuthorizer authorizer = storage.getAccessAuthorizer();
            if (authorizer != null) {
                authorizer.checkRead(storage.instantiateBinaryEntry(binKey, binValue, true), context == null ? null : context.getSubject(), 1);
            }
            msgRequest.setProcessedPartition(this.getKeyPartition(binKey));
        }
        catch (Throwable e) {
            msgResponse.setResult(2);
            msgResponse.setValue(this.tagException(e));
        }
        GuardSupport.reset();
        Collection colStatus = ctxInvoke.getEntryStatuses();
        if (colStatus.size() == 1) {
            this.processChanges(context, binKey, status, msgRequest.getCacheId(), msgResponse);
        } else {
            this.processChanges(context, null, msgRequest.getCacheId(), colStatus, this.instantiateBatchContext(msgResponse));
        }
        this.releaseInvocationContext(ctxInvoke);
    }

    public void onIndexRequest(IndexRequest msgRequest) {
        Grid.Response msgResponse = (Grid.Response)this.instantiateMessage("Response");
        msgResponse.respondTo(msgRequest);
        Storage storage = this.validateRequestForStorage(msgRequest, msgResponse, false);
        if (storage == null) {
            return;
        }
        try {
            Comparator comparator = msgRequest.getComparator();
            ValueExtractor extractor = msgRequest.getExtractor();
            boolean fAdd = msgRequest.isAdd();
            comparator = msgRequest.isOrdered() ? (comparator == null ? SafeComparator.INSTANCE : comparator) : null;
            PartitionSet partsMask = this.calculatePartitionSet(this.getThisMember(), 0);
            RequestContext context = msgRequest.getRequestContext();
            if (fAdd) {
                storage.addIndex(context, partsMask, extractor, comparator);
            } else {
                storage.removeIndex(context, partsMask, extractor, comparator);
            }
            msgResponse.setValue(partsMask);
            if (this.getThisMember() == this.getOwnershipSenior()) {
                msgRequest.relayRequest(msgResponse);
                return;
            }
        }
        catch (Throwable e) {
            msgResponse.setResult(2);
            msgResponse.setValue(this.tagException(e));
        }
        this.post(msgResponse);
    }

    @Override
    public void onInit() {
        super.onInit();
        this.setBinaryEntryConverter(new EventsHelper.BinaryEntryConverter());
        this.setEventsHelper((EventsHelper)this._findChild("EventsHelper"));
        this.setLazyLookupReadBuffer((LazyLookup)this._findChild("LazyLookup"));
        this.setRequestCoordinator((RequestCoordinator)this._findChild("RequestCoordinator"));
        this.setResourceCoordinator((ResourceCoordinator)this._findChild("ResourceCoordinator"));
        this.setTaskSplitThreshold(Integer.parseInt(Config.getProperty("coherence.distributed.tasksplitthreshold", "1")));
        this.setScheduledBackupsThreshold(Integer.parseInt(Config.getProperty("coherence.distributed.scheduledbackupsthreshold", "60")));
        this.setMaxPartialResponseSize(Config.getMemorySize("coherence.distributed.max.response.size", "1m"));
        this.setEventResendInterval(Config.getDuration("coherence.distributed.event.resend.interval", new Duration("30s")).as(Duration.Magnitude.MILLI));
    }

    @Override
    protected void onInterval() {
        super.onInterval();
        this.getRequestCoordinator().onInterval();
        LongArray laPending = this.getPendingEvents();
        if (laPending == null) {
            return;
        }
        long ldtNow = Base.getSafeTimeMillis();
        long lOldestSUID = this.getOldestPendingEventSUID();
        if (ldtNow > this.getOldestEventResendNextMillis()) {
            MapEvent msgEvent;
            if (lOldestSUID > 0L && this.m_lOldestSUIDtemp == lOldestSUID && this.getSUIDCounter(2).get() - lOldestSUID > 100L && (msgEvent = (MapEvent)laPending.get(lOldestSUID)) != null && !msgEvent.isDelivered()) {
                msgEvent.setNotifyDelivery(true);
                this.post(msgEvent);
            }
            this.m_lOldestSUIDtemp = lOldestSUID;
            this.setOldestEventResendNextMillis(ldtNow + this.getEventResendInterval());
        }
    }

    public void onInvokeAllRequest(InvokeAllRequest msgRequest) {
        Map mapPrev;
        PartialMapResponse msgResponse = (PartialMapResponse)this.instantiateMessage("PartialMapResponse");
        msgResponse.respondTo(msgRequest);
        Storage storage = this.validateRequestForStorage(msgRequest, msgResponse, true);
        if (storage == null) {
            return;
        }
        Set setKeys = msgRequest.getKeySetSafe();
        Object[] aoKeyPrev = null;
        Object[] aoValPrev = null;
        int cKeys = setKeys.size();
        int cEntriesPrev = 0;
        RequestContext context = msgRequest.getRequestContext();
        ResultInfo resultInfo = this.getResultInfo(context);
        if (resultInfo != null && (mapPrev = resultInfo.extractResults(this.getKeyPartitions(setKeys))) != null) {
            cEntriesPrev = mapPrev.size();
            aoKeyPrev = new Object[cEntriesPrev];
            aoValPrev = new Object[cEntriesPrev];
            int i = 0;
            for (Map.Entry entry : mapPrev.entrySet()) {
                Object oKey = entry.getKey();
                aoKeyPrev[i] = oKey;
                aoValPrev[i++] = entry.getValue();
                setKeys.remove(oKey);
            }
            if (setKeys.isEmpty()) {
                msgResponse.setSize(cEntriesPrev);
                msgResponse.setKey(aoKeyPrev);
                msgResponse.setValue(aoValPrev);
                this.post(msgResponse);
                return;
            }
        }
        int cEntries = 0;
        int cResults = 0;
        Object[] aoKey = new Binary[cKeys];
        Object[] aoVal = new Object[cKeys];
        Object[] aoStatus = null;
        Object[] aoResult = null;
        PartitionedService.PinningIterator pinner = this.createPinningIterator(setKeys, msgRequest.getOwnershipVersions());
        while (pinner.hasNext()) {
            aoKey[cEntries++] = (Binary)pinner.next();
        }
        PartitionSet partsPinned = pinner.getPinnedPartitions();
        InvocationContext ctxInvoke = this.ensureInvocationContext(partsPinned);
        try {
            ctxInvoke.prepareAccess(context, storage, 49152, 8);
            while (true) {
                InvocableMap.EntryProcessor agent = msgRequest.deserializeProcessor();
                try {
                    aoStatus = ctxInvoke.lockEntries(storage, (Binary[])aoKey, cEntries);
                    storage.invokeAll(ctxInvoke, aoStatus, 0, cEntries, agent);
                }
                catch (LockContentionException e) {
                    ctxInvoke.rollback(e, msgRequest, "processor = " + agent.getClass().getName());
                    msgRequest.setProcessor(null);
                    continue;
                }
                break;
            }
            aoResult = aoVal;
            for (int i = 0; i < cEntries; ++i) {
                Storage.EntryStatus status = (Storage.EntryStatus)aoStatus[i];
                aoKey[cResults] = status.getKey();
                aoResult[cResults++] = status.getResult();
            }
        }
        catch (HeuristicCommitException e) {
            if (this.isExiting()) {
                return;
            }
            this.onPartialCommit(msgResponse, e);
        }
        catch (Throwable e) {
            msgResponse.setException(this.tagException(e));
            msgResponse.setFailedKeys(this.collectResultOnException(null, aoStatus, aoKey, 0, cEntries, e));
        }
        if (cEntriesPrev > 0) {
            System.arraycopy(aoKeyPrev, 0, aoKey, cResults, cEntriesPrev);
            System.arraycopy(aoValPrev, 0, aoResult, cResults, cEntriesPrev);
        }
        msgResponse.setSize(cResults + cEntriesPrev);
        msgResponse.setKey(aoKey);
        msgResponse.setValue(aoResult);
        msgResponse.setRejectPartitions(pinner.getRejectedPartitions());
        GuardSupport.reset();
        ctxInvoke.resetAccess();
        this.registerMultiResult(context, partsPinned, (Map)(aoResult == null ? Collections.emptyMap() : new KeyValueArrayMap(aoKey, 0, aoResult, 0, cResults)));
        this.processChanges(context, null, msgRequest.getCacheId(), ctxInvoke.getEntryStatuses(), this.instantiateBatchContext(msgResponse));
        this.releaseInvocationContext(ctxInvoke);
        msgRequest.setProcessedPartitions(partsPinned);
        this.unpinPartitions(partsPinned);
    }

    /*
     * Exception decompiling
     */
    public void onInvokeAllRequest(InvokeAllRequest.InvokeJob job) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[CATCHBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void onInvokeFilterRequest(InvokeFilterRequest msgRequest) {
        int cResultsPrev;
        QueryResponse msgResponse = (QueryResponse)this.instantiateMessage("QueryResponse");
        msgResponse.respondTo(msgRequest);
        Storage storage = this.validateRequestForStorage(msgRequest, msgResponse, true);
        if (storage == null) {
            return;
        }
        RequestContext context = msgRequest.getRequestContext();
        PartitionSet partMask = msgRequest.getRequestMaskSafe();
        ResultInfo resultInfo = this.getResultInfo(context);
        Map mapPrev = resultInfo == null ? null : resultInfo.extractResults(partMask);
        Object[] aoResultPrev = mapPrev == null ? null : mapPrev.entrySet().toArray();
        int n = cResultsPrev = aoResultPrev == null ? 0 : aoResultPrev.length;
        if (partMask.isEmpty()) {
            msgResponse.setResult(aoResultPrev);
            msgResponse.setSize(cResultsPrev);
            this.post(msgResponse);
            return;
        }
        this.flushOOBEvents();
        PartitionSet partReject = this.pinOwnedPartitions(partMask, msgRequest.getOwnershipVersions());
        msgResponse.setRejectPartitions(partReject);
        Object[] aoResult = null;
        int cResults = 0;
        InvocationContext ctxInvoke = this.ensureInvocationContext(partMask);
        try {
            ctxInvoke.prepareAccess(context, storage, 49152, 8);
            Object[] aoStatus = null;
            int cEntries = 0;
            while (true) {
                InvocableMap.EntryProcessor agent = msgRequest.deserializeProcessor();
                try {
                    QueryResult result = storage.query(msgRequest.getFilter(), 3, partMask, msgRequest.checkTimeoutRemaining());
                    aoStatus = result.getResults();
                    cEntries = result.getCount();
                    storage.invokeAll(ctxInvoke, aoStatus, 0, cEntries, agent);
                }
                catch (LockContentionException e) {
                    ctxInvoke.rollback(e, msgRequest, "processor = " + agent.getClass().getName());
                    msgRequest.setProcessor(null);
                    continue;
                }
                break;
            }
            aoResult = aoStatus;
            for (int i = 0; i < cEntries; ++i) {
                Storage.EntryStatus status = (Storage.EntryStatus)aoStatus[i];
                Binary binResult = status.getResult();
                if (binResult == null) continue;
                aoResult[cResults++] = new SimpleMapEntry<Binary, Binary>(status.getKey(), binResult);
            }
        }
        catch (HeuristicCommitException e) {
            if (this.isExiting()) {
                return;
            }
            this.onPartialCommit(msgResponse, e);
        }
        catch (Throwable e) {
            msgResponse.setException(this.tagException(e));
        }
        if (cResultsPrev > 0) {
            Object[] aoResultTmp = aoResult;
            aoResult = new Object[cResultsPrev + cResults];
            System.arraycopy(aoResultPrev, 0, aoResult, 0, cResultsPrev);
            System.arraycopy(aoResultTmp, 0, aoResult, cResultsPrev, cResults);
        }
        msgResponse.setResult(aoResult);
        msgResponse.setSize(cResults + cResultsPrev);
        GuardSupport.reset();
        ctxInvoke.resetAccess();
        this.registerMultiResult(context, partMask, (Map)(aoResult == null ? Collections.emptyMap() : new EntrySetMap(new ImmutableArrayList(aoResult, cResultsPrev, cResults).getSet())));
        this.processChanges(context, null, msgRequest.getCacheId(), ctxInvoke.getEntryStatuses(), this.instantiateBatchContext(msgResponse));
        this.releaseInvocationContext(ctxInvoke);
        msgRequest.setProcessedPartitions(partMask);
        this.unpinPartitions(partMask);
    }

    /*
     * Exception decompiling
     */
    public void onInvokeRequest(InvokeRequest msgRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void onKeyIteratorRequest(KeyIteratorRequest msgRequest) {
        QueryResponse msgResponse = (QueryResponse)this.instantiateMessage("QueryResponse");
        msgResponse.respondTo(msgRequest);
        msgResponse.setKeysOnly(true);
        Storage storage = this.validateRequestForStorage(msgRequest, msgResponse, false);
        if (storage == null) {
            return;
        }
        PartitionSet partMask = msgRequest.getRequestMaskSafe();
        this.flushOOBEvents();
        PartitionSet partReject = this.pinOwnedPartitions(partMask);
        try {
            storage.checkAccess(msgRequest.getRequestContext(), 40960, 4);
            QueryResult result = storage.query(null, 1, partMask, msgRequest.checkTimeoutRemaining());
            msgResponse.setResult(result.getResults());
            msgResponse.setSize(result.getCount());
            msgResponse.setRejectPartitions(partReject);
        }
        catch (Throwable e) {
            msgResponse.setException(this.tagException(e));
        }
        this.processChanges(msgResponse);
        msgRequest.setProcessedPartitions(partMask);
        this.unpinPartitions(partMask);
    }

    public void onKeyListenerAllRequest(KeyListenerAllRequest msgRequest) {
        PartialMapResponse msgResponse = (PartialMapResponse)this.instantiateMessage("PartialMapResponse");
        msgResponse.respondTo(msgRequest);
        Storage storage = this.validateRequestForStorage(msgRequest, msgResponse, false);
        if (storage == null) {
            return;
        }
        RequestContext context = msgRequest.getRequestContext();
        Set setKeys = msgRequest.getKeySetSafe();
        boolean fAdd = msgRequest.isAdd();
        boolean fLite = msgRequest.isLite();
        boolean fPriming = msgRequest.isPriming();
        Member member = msgRequest.getFromMember();
        Binary[] abinKey = new Binary[setKeys.size()];
        PartitionedService.PinningIterator pinner = this.createPinningIterator(setKeys);
        int cEntries = 0;
        while (pinner.hasNext()) {
            abinKey[cEntries++] = (Binary)pinner.next();
        }
        PartitionSet partsPinned = pinner.getPinnedPartitions();
        InvocationContext ctxInvoke = this.ensureInvocationContext(partsPinned);
        BatchContext ctxBatch = null;
        try {
            if (fAdd && !fLite) {
                ctxInvoke.prepareAccess(context, storage, 40960, 12);
            }
            ctxInvoke.lockEntries(storage, abinKey, cEntries);
            ctxBatch = this.instantiateBatchContext(msgResponse);
            if (this.getBackupCount() > 0) {
                this.postAll(this.prepareBackupListenerAllRequests(storage.getCacheId(), fLite, fAdd, member, abinKey, cEntries, ctxBatch));
            }
            VersionedPartitions versions = msgRequest.getPartitionVersions();
            if ((fPriming || versions != null) && fAdd) {
                ctxBatch.getOutstandingOperationCounter().incrementAndGet();
                Map mapResult = storage.getAll(ctxInvoke, Arrays.asList(abinKey));
                if (fPriming) {
                    this.postEvents(storage.getPrimingEvents(member, new ChainedMap(mapResult, new SetMap(setKeys))));
                } else {
                    int iPart;
                    int cParts = partsPinned.cardinality();
                    int cMapInit = (mapResult.size() + cParts) / cParts;
                    SparseArray laPartMaps = new SparseArray();
                    for (Map.Entry entry : mapResult.entrySet()) {
                        Binary binKey = (Binary)entry.getKey();
                        iPart = this.getKeyPartition(binKey);
                        HashMap partMap = (HashMap)laPartMaps.get(iPart);
                        if (partMap == null) {
                            partMap = new HashMap();
                            laPartMaps.set(iPart, partMap);
                        }
                        partMap.put(entry.getKey(), entry.getValue());
                    }
                    Object oHolder = null;
                    Iterator iter = laPartMaps.iterator();
                    while (iter.hasNext()) {
                        Map mapPart = (Map)iter.next();
                        iPart = (int)iter.getIndex();
                        long lVersion = versions.getVersion(iPart);
                        oHolder = lVersion == -1L ? storage.getPrimingEvents(member, mapPart) : storage.getPreviousEvents(member, mapPart.keySet(), iPart, lVersion, oHolder);
                    }
                    this.postEvents(oHolder);
                }
                this.processChanges(context, null, msgRequest.getCacheId(), ctxInvoke.getEntryStatuses(), ctxBatch);
            }
            for (int i = 0; i < cEntries; ++i) {
                Binary binKey = abinKey[i];
                if (fAdd) {
                    storage.addKeyListener(member, binKey, fLite, true);
                } else {
                    storage.removeKeyListener(member, abinKey[i], true);
                }
                storage.persistListenerRegistration(member, binKey, fLite, fAdd);
            }
        }
        catch (Throwable e) {
            msgResponse.setException(this.tagException(e));
            msgResponse.setFailedKeys(setKeys);
        }
        msgResponse.setRejectPartitions(pinner.getRejectedPartitions());
        if (ctxBatch != null) {
            ctxBatch.onJobCompleted(null);
        }
        this.releaseInvocationContext(ctxInvoke);
        this.unpinPartitions(partsPinned);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onKeyListenerAllRequest(KeyListenerAllRequest.KeyListenerJob job) {
        PartialMapResponse msgResponse = (PartialMapResponse)job.getResponse();
        InvocationContext ctxInvoke = this.ensureInvocationContext();
        BatchContext ctxBatch = job.getBatchContext();
        int iPartition = job.getPartition();
        RequestContext context = job.getRequestContext();
        long lCacheId = job.getCacheId();
        boolean fAdd = job.isAdd();
        boolean fLite = job.isLite();
        boolean fPriming = job.isPriming();
        Member member = job.getFromMember();
        Map map = job.getMap();
        Set setKeys = map.keySet();
        boolean fEntered = this.pinOwnedPartition(iPartition);
        Storage storage = this.getKnownStorage(lCacheId);
        try {
            if (storage == null || !fEntered) {
                msgResponse.rejectPartition(iPartition);
                this.processChanges(context, job, lCacheId, null, ctxBatch);
                return;
            }
            ctxInvoke.getPrePinnedPartitions().add(iPartition);
            if (fAdd && !fLite) {
                storage.checkAccess(context, 40960, 12);
            }
            int cEntries = 0;
            int cKeys = setKeys.size();
            Binary[] abinKey = new Binary[map.size()];
            Iterator iter = setKeys.iterator();
            while (iter.hasNext()) {
                abinKey[cEntries++] = (Binary)iter.next();
            }
            ctxInvoke.lockEntries(storage, abinKey, cEntries);
            Collection colStatuses = null;
            if ((fPriming || job.isVersioned()) && fAdd) {
                Map mapResult = storage.getAll(ctxInvoke, setKeys);
                long lVersion = job.getPartitionVersion();
                this.postEvents(fPriming || lVersion == -1L ? storage.getPrimingEvents(member, new ChainedMap(mapResult, map)) : storage.getPreviousEvents(member, setKeys, iPartition, lVersion, null));
                colStatuses = ctxInvoke.getEntryStatuses();
            }
            if (this.getBackupCount() > 0) {
                this.postAll(this.prepareBackupListenerAllRequests(storage.getCacheId(), fLite, fAdd, member, abinKey, cKeys, ctxBatch));
            }
            for (int i = 0; i < cKeys; ++i) {
                Binary binKey = abinKey[i];
                if (fAdd) {
                    storage.addKeyListener(member, binKey, fLite, true);
                } else {
                    storage.removeKeyListener(member, binKey, true);
                }
                storage.persistListenerRegistration(member, binKey, fLite, fAdd);
            }
            this.processChanges(context, null, lCacheId, colStatuses, ctxBatch);
        }
        catch (Throwable e) {
            msgResponse.setException(this.tagException(e));
            PartialMapResponse partialMapResponse = msgResponse;
            synchronized (partialMapResponse) {
                Collection colFailed = msgResponse.getFailedKeys();
                if (colFailed == null) {
                    colFailed = new SafeLinkedList();
                    msgResponse.setFailedKeys(colFailed);
                }
                colFailed.addAll(setKeys);
            }
        }
        finally {
            this.releaseInvocationContext(ctxInvoke);
            if (fEntered) {
                this.unpinPartition(iPartition);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onKeyListenerRequest(KeyListenerRequest msgRequest) {
        Grid.Response msgResponse = (Grid.Response)this.instantiateMessage("Response");
        msgResponse.respondTo(msgRequest);
        Storage storage = this.validateRequestForStorage(msgRequest, msgResponse, false);
        if (storage == null) {
            return;
        }
        long lCacheId = msgRequest.getCacheId();
        RequestContext context = msgRequest.getRequestContext();
        Binary binKey = msgRequest.getKey();
        boolean fAdd = msgRequest.isAdd();
        boolean fLite = msgRequest.isLite();
        boolean fRespond = true;
        InvocationContext ctxInvoke = this.ensureInvocationContext();
        try {
            Storage.EntryStatus status = ctxInvoke.lockEntry(storage, binKey, this.isConcurrent());
            if (status != null) {
                List listBackups;
                long lVersion;
                if (fAdd && !fLite) {
                    ctxInvoke.prepareAccess(context, storage, 40960, 12);
                }
                Member member = msgRequest.getFromMember();
                if (fAdd) {
                    storage.addKeyListener(member, binKey, fLite, true);
                } else {
                    storage.removeKeyListener(member, binKey, true);
                }
                storage.persistListenerRegistration(member, binKey, fLite, fAdd);
                if ((msgRequest.isPriming() || msgRequest.isVersioned()) && fAdd) {
                    Binary binValue = storage.get(ctxInvoke, status, binKey);
                    lVersion = msgRequest.getPartitionVersion();
                    StorageAccessAuthorizer authorizer = storage.getAccessAuthorizer();
                    if (authorizer != null) {
                        authorizer.checkRead(storage.instantiateBinaryEntry(binKey, binValue, true), context == null ? null : context.getSubject(), 1);
                    }
                    this.postEvents(msgRequest.isPriming() || lVersion == -1L ? storage.getPrimingEvent(member, binKey, binValue, status.getPartition()) : storage.getPreviousEvents(member, binKey, status.getPartition(), lVersion));
                    this.processChanges(null, binKey, status, lCacheId, null);
                }
                int iPartition = this.getKeyPartition(binKey);
                lVersion = this.getPartitionControl(iPartition).getVersionCounter().incrementAndGet();
                if (this.getBackupCount() > 0 && !(listBackups = this.getBackupOwners(binKey)).isEmpty()) {
                    BackupListenerRequest msg = (BackupListenerRequest)this.instantiateMessage("BackupListenerRequest");
                    msg.setCacheId(lCacheId);
                    msg.setKey(binKey);
                    msg.setPartition(iPartition);
                    msg.setPartitionVersion(lVersion);
                    msg.setAdd(fAdd);
                    msg.setLite(fLite);
                    msg.setMemberId(member.getId());
                    msg.setPrimaryResponse(msgResponse);
                    msg.setMemberList(listBackups);
                    this.post(msg);
                    fRespond &= this.isAsyncBackup();
                }
            } else {
                msgResponse.setResult(1);
            }
        }
        catch (Throwable e) {
            msgResponse.setResult(2);
            msgResponse.setValue(this.tagException(e));
        }
        finally {
            this.releaseInvocationContext(ctxInvoke);
        }
        if (fRespond) {
            this.post(msgResponse);
        }
    }

    public void onListenerRequest(ListenerRequest msgRequest) {
        PartitionSet partsProcessed;
        Grid.Response msgResponse = (Grid.Response)this.instantiateMessage("Response");
        msgResponse.respondTo(msgRequest);
        Storage storage = this.validateRequestForStorage(msgRequest, msgResponse, false);
        if (storage == null) {
            return;
        }
        RequestContext context = msgRequest.getRequestContext();
        Filter filter = msgRequest.getFilter();
        long lFilterId = msgRequest.getFilterId();
        MapTrigger trigger = msgRequest.getTrigger();
        boolean fAdd = msgRequest.isAdd();
        int nMember = msgRequest.getMemberId();
        PartitionSet partsMask = msgRequest.getPartitions();
        PartitionSet partsOwned = this.calculatePartitionSet(this.getThisMember(), 0, true);
        partsMask = partsMask == null ? partsOwned : new PartitionSet(partsMask);
        partsMask.retain(partsOwned);
        ResultInfo resultInfo = this.getResultInfo(context);
        PartitionSet partitionSet = partsProcessed = resultInfo == null ? null : resultInfo.getPartitions();
        if (partsProcessed != null) {
            partsMask.remove(partsProcessed);
        }
        this.pinOwnedPartitions(partsMask);
        try {
            if (trigger == null) {
                Member member = this.getServiceMemberSet().getMember(nMember);
                if (member == null) {
                    PartitionedCache._trace("Ignoring a request to " + (msgRequest.isAdd() ? "add" : "remove") + " a map listener for member " + nMember + " which does not belong to this service", 6);
                } else {
                    storage.checkAccess(msgRequest.getRequestContext(), 40960, fAdd ? 12 : 13);
                    if (fAdd) {
                        boolean fLite = msgRequest.isLite();
                        storage.addListener(member, filter, lFilterId, fLite);
                        VersionedPartitions versions = msgRequest.getPartitionVersions();
                        if (versions != null && this.isPersistEvents()) {
                            int iPart = partsMask.next(0);
                            while (iPart >= 0) {
                                long lVersion = versions.getVersion(iPart);
                                this.postEvents(storage.getPreviousEvents(member, filter, iPart, lVersion, fLite, lFilterId, null));
                                iPart = partsMask.next(iPart + 1);
                            }
                        }
                    } else {
                        storage.removeListener(member, filter, lFilterId);
                    }
                }
            } else {
                storage.checkAccess(msgRequest.getRequestContext(), 49152, fAdd ? 14 : 15);
                if (fAdd) {
                    storage.addTrigger(partsMask, trigger);
                } else {
                    storage.removeTrigger(partsMask, trigger);
                }
                storage.persistTriggerRegistration(partsMask, trigger, fAdd);
            }
            this.registerMultiResult(context, partsMask, Collections.emptyMap());
            msgResponse.setValue(resultInfo == null ? partsMask : resultInfo.getPartitions());
        }
        catch (Throwable e) {
            msgResponse.setResult(2);
            msgResponse.setValue(this.tagException(e));
        }
        this.unpinPartitions(partsMask);
        if (this.getThisMember() == this.getOwnershipSenior() && msgResponse.getResult() != 2) {
            msgRequest.relayRequest(msgResponse);
            return;
        }
        this.post(msgResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onLockRequest(LockRequest msgRequest) {
        Grid.Response msgResponse;
        block17: {
            msgResponse = (Grid.Response)this.instantiateMessage("Response");
            msgResponse.respondTo(msgRequest);
            Storage storage = this.validateRequestForStorage(msgRequest, msgResponse, false);
            if (storage == null) {
                return;
            }
            Binary binKey = msgRequest.getKey();
            try {
                boolean fEnter = this.isConcurrent();
                if (this.lockKey(storage, binKey, fEnter)) {
                    Lease lease = msgRequest.toLease();
                    try {
                        if (storage.lock(lease)) {
                            List listBackups;
                            int iPartition = this.getKeyPartition(binKey);
                            long lVersion = this.getPartitionControl(iPartition).getVersionCounter().incrementAndGet();
                            msgResponse.setValue(Boolean.TRUE);
                            if (this.getBackupCount() > 0 && !(listBackups = this.getBackupOwners(binKey)).isEmpty()) {
                                BackupLockRequest msgBackup = (BackupLockRequest)this.instantiateMessage("BackupLockRequest");
                                msgBackup.setCacheId(msgRequest.getCacheId());
                                msgBackup.setKey(binKey);
                                msgBackup.setPartition(iPartition);
                                msgBackup.setPartitionVersion(lVersion);
                                msgBackup.setLock(true);
                                msgBackup.setLease(lease);
                                msgBackup.setPrimaryResponse(msgResponse);
                                msgBackup.setMemberList(listBackups);
                                this.post(msgBackup);
                                return;
                            }
                            break block17;
                        } else {
                            List listPending;
                            List list = listPending = storage.getPendingLockRequest();
                            synchronized (list) {
                                if (this.getServiceMemberSet().contains(lease.getHolderId())) {
                                    long lVariance;
                                    long lWaitTimeout = msgRequest.getLeaseWaitTimeout();
                                    long lTime = this.getClusterTime();
                                    if (lTime + (lVariance = (long)this.getClusterTimeVariance()) < lWaitTimeout) {
                                        listPending.add(msgRequest);
                                        if (lWaitTimeout == Long.MAX_VALUE) return;
                                        this.scheduleLockEvaluation(lWaitTimeout - lTime);
                                        return;
                                    }
                                }
                            }
                            msgResponse.setValue(Boolean.FALSE);
                        }
                        break block17;
                    }
                    finally {
                        this.unlockKey(storage, binKey, fEnter);
                    }
                }
                msgResponse.setResult(1);
            }
            catch (Throwable e) {
                msgResponse.setResult(2);
                msgResponse.setValue(this.tagException(e));
            }
        }
        this.post(msgResponse);
    }

    public void onMapEvent(MapEvent msgEvent) {
        BinaryMap mapBinary;
        boolean fSkip;
        LongArray laProcessed = this.getProcessedEvents();
        long lEventSUID = msgEvent.getEventSUID();
        long lOldestPending = msgEvent.getOldestPendingEventSUID();
        int nSender = msgEvent.getFromMember().getId();
        int nOriginator = PartitionedCache.getMemberId(lEventSUID);
        long lOldestKnown = PartitionedCache.calculateOldestSUID(laProcessed, nOriginator);
        boolean bl = fSkip = laProcessed.exists(lEventSUID) && laProcessed.get(lEventSUID) == null;
        if (nOriginator == nSender) {
            if (fSkip) {
                PartitionedCache._trace("Ignoring duplicate event", 2);
                return;
            }
            PartitionedCache.removeSUIDRange(laProcessed, PartitionedCache.getBaseSUID(nSender), lOldestPending, false);
            laProcessed.set(lEventSUID, null);
        } else {
            if (!fSkip) {
                boolean bl2 = fSkip = lEventSUID < lOldestKnown;
            }
            if (fSkip) {
                return;
            }
            laProcessed.set(lEventSUID, null);
        }
        if (lOldestPending > lOldestKnown && lOldestPending < lEventSUID && !laProcessed.exists(lOldestPending)) {
            laProcessed.set(lOldestPending, Boolean.TRUE);
        }
        if ((mapBinary = (BinaryMap)this.getBinaryMapArray().get(msgEvent.getCacheId())) != null) {
            mapBinary.dispatch(msgEvent);
        }
    }

    @Override
    protected void onNotify() {
        super.onNotify();
        if (!this.isExiting()) {
            long lTime = Base.getSafeTimeMillis();
            if (lTime >= this.getLockingNextMillis()) {
                this.evaluateLockRequests();
            }
            if (this.isOwnershipEnabled()) {
                this.flushEvents();
            }
        }
    }

    @Override
    public void onNotifyServiceLeft(Member member) {
        super.onNotifyServiceLeft(member);
        if (this.isAcceptingClients() && this.getServiceState() != 3 && this.isOwnershipEnabled()) {
            this.validateStorages(member);
            int nId = member.getId();
            PartitionedCache.removeSUIDRange(this.getPendingResultInfo(PartitionedCache.getBaseSUID(nId)), nId, false);
            List listEvents = PartitionedCache.removeSUIDRange(this.getPendingEvents(), nId, true);
            for (MapEvent msgEvent : listEvents) {
                this.post(msgEvent);
            }
        }
    }

    @Override
    public void onNotifyServiceQuiescence(boolean fResume, boolean fResumeOnFailover) {
        if (this.isAcceptingClients()) {
            if (fResume) {
                super.onNotifyServiceQuiescence(fResume, fResumeOnFailover);
                this.getRequestCoordinator().onServiceResumed();
            } else {
                this.getRequestCoordinator().onServiceSuspended();
                super.onNotifyServiceQuiescence(fResume, fResumeOnFailover);
            }
        } else {
            super.onNotifyServiceQuiescence(fResume, fResumeOnFailover);
        }
    }

    protected void onPartialCommit(Message msgResponse, Throwable e) {
        PartitionedCache._trace("Partial commit due to the backing map exception " + PartitionedCache.getStackTrace(e), 2);
        RuntimeException exception = this.tagException(e.getCause());
        if (msgResponse instanceof DistributedPartialResponse) {
            ((DistributedPartialResponse)msgResponse).setException(exception);
        } else if (msgResponse instanceof Grid.Response) {
            Grid.Response response = (Grid.Response)msgResponse;
            response.setResult(2);
            response.setValue(exception);
        } else {
            throw new IllegalStateException("Unknown response message: " + String.valueOf(msgResponse));
        }
    }

    @Override
    protected void onPartitionsAssigned(PartitionSet partsAssigned, PartitionSet partsLost, Continuation continuation) {
        boolean fEmitLost;
        boolean fEmitAssigned = partsAssigned != null && !partsAssigned.isEmpty();
        boolean bl = fEmitLost = partsLost != null && !partsLost.isEmpty();
        if (fEmitAssigned || fEmitLost) {
            int iPartNext;
            int iPart;
            Map mapStorage = this.collectValidStorages();
            int n = iPart = fEmitAssigned ? partsAssigned.next(0) : -1;
            while (iPart >= 0) {
                iPartNext = partsAssigned.next(iPart + 1);
                this.getEventsHelper().onPartitionAssigned(mapStorage, iPart, fEmitLost || iPartNext >= 0 ? null : continuation);
                iPart = iPartNext;
            }
            int n2 = iPart = fEmitLost ? partsLost.next(0) : -1;
            while (iPart >= 0) {
                iPartNext = partsLost.next(iPart + 1);
                this.getEventsHelper().onPartitionLost(mapStorage, iPart, iPartNext >= 0 ? null : continuation);
                iPart = iPartNext;
            }
        } else if (continuation != null) {
            continuation.proceed(null);
        }
    }

    @Override
    public void onPartitionsRecovered(PartitionSet partsRecovered, String sSnapshotName, Continuation continuation) {
        if (!partsRecovered.isEmpty()) {
            Map mapStorage = this.collectValidStorages();
            int iPart = partsRecovered.next(0);
            while (iPart >= 0) {
                this.getEventsHelper().onEntriesRecovered(mapStorage, iPart, sSnapshotName, partsRecovered.next(iPart + 1) >= 0 ? null : continuation);
                iPart = partsRecovered.next(iPart + 1);
            }
        } else if (continuation != null) {
            continuation.proceed(null);
        }
    }

    @Override
    protected void onPartitionsRestored(PartitionSet partsRestored, Continuation continuation) {
        if (!partsRestored.isEmpty()) {
            Map mapStorage = this.collectValidStorages();
            for (Storage storage : mapStorage.values()) {
                ConfigurableCacheMap mapCCM = storage.getBackingConfigurableCache();
                int cMax = mapCCM == null ? 0 : mapCCM.getHighUnits();
                if (cMax <= 0 || mapCCM.getUnits() <= cMax) continue;
                storage.scheduleEviction(0L);
            }
            int iPart = partsRestored.next(0);
            while (iPart >= 0) {
                if (this.isIndexed()) {
                    PartitionedCache service = (PartitionedCache)this.get_Module();
                    for (Storage storage : service.getStorageArray()) {
                        if (!storage.isIndexed()) continue;
                        for (Map.Entry index : storage.getIndexExtractorMap().entrySet()) {
                            ValueExtractor extractor = (ValueExtractor)index.getKey();
                            Comparator comparator = (Comparator)index.getValue();
                            storage.createMapIndex(storage.getPartitionIndexMap(iPart), extractor, comparator);
                        }
                        if (service.getDaemonPool().isStarted()) continue;
                        storage.createPartitionIndex(iPart, null);
                    }
                    if (this.getDaemonPool().isStarted()) {
                        this.scheduleIndexUpdate(iPart, 1);
                    }
                }
                this.getEventsHelper().onEntriesRestored(mapStorage, iPart, partsRestored.next(iPart + 1) >= 0 ? null : continuation);
                iPart = partsRestored.next(iPart + 1);
            }
        } else if (continuation != null) {
            continuation.proceed(null);
        }
    }

    @Override
    public void onPrimaryOwnershipChanged(int nPartition) {
        super.onPrimaryOwnershipChanged(nPartition);
        this.getRequestCoordinator().updatePartitionOwner(nPartition, this.getPrimaryOwner(nPartition));
    }

    public void onPutAllRequest(PutAllRequest msgRequest) {
        PartitionSet partsResult;
        PartitionSet partsMask;
        PartialValueResponse msgResponse = (PartialValueResponse)this.instantiateMessage("PartialValueResponse");
        msgResponse.respondTo(msgRequest);
        Storage storage = this.validateRequestForStorage(msgRequest, msgResponse, false);
        if (storage == null) {
            return;
        }
        Map map = msgRequest.getMapSafe();
        Set setKeys = map.keySet();
        RequestContext context = msgRequest.getRequestContext();
        ResultInfo resultInfo = this.getResultInfo(context);
        if (resultInfo != null && (partsMask = this.getKeyPartitions(setKeys)).intersects(partsResult = resultInfo.getPartitions())) {
            partsMask.remove(partsResult);
            if (partsMask.isEmpty()) {
                this.post(msgResponse);
                return;
            }
            Iterator iter = setKeys.iterator();
            while (iter.hasNext()) {
                int nPartition = this.getKeyPartition((Binary)iter.next());
                if (partsMask.contains(nPartition)) continue;
                iter.remove();
            }
            PartitionedCache._assert(!setKeys.isEmpty());
        }
        int cEntries = 0;
        int cSize = map.size();
        Binary[] aKeys = new Binary[cSize];
        Binary[] aValues = new Binary[cSize];
        PartitionedService.PinningIterator pinner = this.createPinningIterator(map.entrySet());
        while (pinner.hasNext()) {
            Map.Entry entry = (Map.Entry)pinner.next();
            aKeys[cEntries] = (Binary)entry.getKey();
            aValues[cEntries] = (Binary)entry.getValue();
            ++cEntries;
        }
        PartitionSet partsPinned = pinner.getPinnedPartitions();
        InvocationContext ctxInvoke = this.ensureInvocationContext(partsPinned);
        try {
            ctxInvoke.prepareAccess(context, storage, 49152, 2);
            while (true) {
                try {
                    Storage.EntryStatus[] aStatus = ctxInvoke.lockEntries(storage, aKeys, cEntries);
                    storage.putAll(ctxInvoke, aStatus, aValues);
                }
                catch (LockContentionException e) {
                    ctxInvoke.rollback(e, msgRequest);
                    continue;
                }
                break;
            }
        }
        catch (HeuristicCommitException e) {
            if (this.isExiting()) {
                return;
            }
            this.onPartialCommit(msgResponse, e);
        }
        catch (Throwable e) {
            msgResponse.setException(this.tagException(e));
            SafeLinkedList col = new SafeLinkedList();
            col.addAll(Arrays.asList(aKeys));
            msgResponse.setFailedKeys(col);
        }
        msgResponse.setRejectPartitions(pinner.getRejectedPartitions());
        GuardSupport.reset();
        this.registerMultiResult(context, partsPinned, Collections.emptyMap());
        this.processChanges(context, null, msgRequest.getCacheId(), ctxInvoke.getEntryStatuses(), this.instantiateBatchContext(msgResponse));
        this.releaseInvocationContext(ctxInvoke);
        msgRequest.setProcessedPartitions(partsPinned);
        this.unpinPartitions(partsPinned);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPutRequest(PutRequest msgRequest) {
        Grid.Response msgResponse = (Grid.Response)this.instantiateMessage("Response");
        msgResponse.respondTo(msgRequest);
        Storage storage = this.validateRequestForStorage(msgRequest, msgResponse, false);
        if (storage == null) {
            return;
        }
        Binary binKey = msgRequest.getKey();
        RequestContext context = msgRequest.getRequestContext();
        if (this.postPriorResult(context, binKey, msgResponse)) {
            return;
        }
        boolean fReturn = msgRequest.isReturnRequired();
        Storage.EntryStatus status = null;
        Binary binValue = msgRequest.getValue();
        int nPartition = this.getKeyPartition(binKey);
        boolean fEntered = this.pinOwnedPartition(nPartition);
        if (!fEntered) {
            msgResponse.setResult(1);
            this.post(msgResponse);
            return;
        }
        InvocationContext ctxInvoke = this.ensureInvocationContext(nPartition);
        try {
            while (true) {
                status = ctxInvoke.lockEntry(storage, binKey, false);
                try {
                    StorageAccessAuthorizer authorizer = storage.getAccessAuthorizer();
                    if (authorizer != null) {
                        authorizer.checkWrite(status.getBinaryEntry(), context.getSubject(), 2);
                    }
                    storage.put(ctxInvoke, status, binValue, msgRequest.getExpiryDelay(), !fReturn);
                    Binary binResult = status.getResult();
                    msgResponse.setValue(fReturn ? binResult : null);
                    this.registerSingleResult(context, binKey, binResult);
                    msgRequest.setProcessedPartition(nPartition);
                }
                catch (LockContentionException e) {
                    ctxInvoke.rollback(e, msgRequest);
                    continue;
                }
                break;
            }
        }
        catch (HeuristicCommitException e) {
            if (this.isExiting()) {
                return;
            }
            this.onPartialCommit(msgResponse, e);
        }
        catch (Throwable e) {
            msgResponse.setResult(2);
            msgResponse.setValue(this.tagException(e));
        }
        finally {
            GuardSupport.reset();
            Collection colEntryStatus = ctxInvoke.getEntryStatuses();
            switch (colEntryStatus.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.processChanges(context, binKey, status, msgRequest.getCacheId(), msgResponse);
                    break;
                }
                default: {
                    this.processChanges(context, null, msgRequest.getCacheId(), colEntryStatus, this.instantiateBatchContext(msgResponse));
                }
            }
            this.releaseInvocationContext(ctxInvoke);
            if (fEntered) {
                this.unpinPartition(nPartition);
            }
        }
    }

    public void onQueryRequest(QueryRequest msgRequest) {
        boolean fPartitioned = msgRequest instanceof PartitionedQueryRequest;
        QueryResponse msgResponse = fPartitioned ? (QueryResponse)this.instantiateMessage("PartitionedQueryResponse") : (QueryResponse)this.instantiateMessage("QueryResponse");
        msgResponse.respondTo(msgRequest);
        Storage storage = this.validateRequestForStorage(msgRequest, msgResponse, true);
        if (storage == null) {
            return;
        }
        PartitionSet partMask = msgRequest.getRequestMaskSafe();
        Filter filter = msgRequest.getFilter();
        boolean fKeySet = msgRequest.isKeysOnly();
        boolean fFirst = true;
        this.flushOOBEvents();
        PartitionSet partReject = this.pinOwnedPartitions(partMask);
        InvocationContext ctxInvoke = this.ensureInvocationContext(partMask);
        ctxInvoke.markReadOnlyRequest();
        try {
            storage.checkAccess(msgRequest.getRequestContext(), 40960, fKeySet ? 4 : 5);
            QueryResult result = storage.query(filter, fKeySet ? 1 : 2, partMask, msgRequest.checkTimeoutRemaining());
            QueryResult[] aoQueryResult = partMask.cardinality() == 1 || !fPartitioned || filter instanceof LimitFilter ? new QueryResult[]{result} : result.split(this.getMaxPartialResponseSize());
            for (QueryResult queryResult : aoQueryResult) {
                Object oCookie;
                if (fFirst) {
                    fFirst = false;
                } else {
                    msgResponse = (QueryResponse)msgResponse.cloneMessage();
                    msgResponse.respondTo(msgRequest);
                }
                msgResponse.setKeysOnly(fKeySet);
                msgResponse.setResult(queryResult.getResults());
                msgResponse.setSize(queryResult.getCount());
                msgResponse.setRejectPartitions(partReject);
                msgResponse.setResponsePartitions(queryResult.getPartitionSet());
                if (filter instanceof LimitFilter && (oCookie = ((LimitFilter)filter).getCookie()) instanceof Integer) {
                    msgResponse.setAvailable((Integer)oCookie);
                }
                this.post(msgResponse);
            }
        }
        catch (Throwable e) {
            msgResponse.setException(this.tagException(e));
            this.post(msgResponse);
        }
        GuardSupport.reset();
        this.processChanges();
        this.releaseInvocationContext(ctxInvoke);
        msgRequest.setProcessedPartitions(partMask);
        this.unpinPartitions(partMask);
    }

    public void onRemoveAllRequest(RemoveAllRequest msgRequest) {
        PartitionSet partsResult;
        PartitionSet partsMask;
        PartialValueResponse msgResponse = (PartialValueResponse)this.instantiateMessage("PartialValueResponse");
        msgResponse.respondTo(msgRequest);
        Storage storage = this.validateRequestForStorage(msgRequest, msgResponse, false);
        if (storage == null) {
            return;
        }
        Set setKeys = msgRequest.getKeySetSafe();
        RequestContext context = msgRequest.getRequestContext();
        ResultInfo resultInfo = this.getResultInfo(context);
        if (resultInfo != null && (partsMask = this.getKeyPartitions(setKeys)).intersects(partsResult = resultInfo.getPartitions())) {
            partsMask.remove(partsResult);
            if (partsMask.isEmpty()) {
                this.post(msgResponse);
                return;
            }
            Iterator iter = setKeys.iterator();
            while (iter.hasNext()) {
                int nPartition = this.getKeyPartition((Binary)iter.next());
                if (partsMask.contains(nPartition)) continue;
                iter.remove();
            }
            PartitionedCache._assert(!setKeys.isEmpty());
        }
        int cEntries = 0;
        Binary[] aKeys = new Binary[setKeys.size()];
        PartitionedService.PinningIterator pinner = this.createPinningIterator(setKeys);
        while (pinner.hasNext()) {
            aKeys[cEntries++] = (Binary)pinner.next();
        }
        PartitionSet partsPinned = pinner.getPinnedPartitions();
        InvocationContext ctxInvoke = this.ensureInvocationContext(partsPinned);
        try {
            ctxInvoke.prepareAccess(context, storage, 49152, 3);
            while (true) {
                try {
                    Storage.EntryStatus[] aStatus = ctxInvoke.lockEntries(storage, aKeys, cEntries);
                    if (storage.removeAll(ctxInvoke, aStatus)) {
                        msgResponse.setResult(Binary.EMPTY);
                    }
                }
                catch (LockContentionException e) {
                    ctxInvoke.rollback(e, msgRequest);
                    continue;
                }
                break;
            }
        }
        catch (HeuristicCommitException e) {
            if (this.isExiting()) {
                return;
            }
            this.onPartialCommit(msgResponse, e);
        }
        catch (Throwable e) {
            msgResponse.setException(this.tagException(e));
        }
        msgResponse.setRejectPartitions(pinner.getRejectedPartitions());
        GuardSupport.reset();
        this.registerMultiResult(context, partsPinned, Collections.emptyMap());
        this.processChanges(context, null, msgRequest.getCacheId(), ctxInvoke.getEntryStatuses(), this.instantiateBatchContext(msgResponse));
        this.releaseInvocationContext(ctxInvoke);
        msgRequest.setProcessedPartitions(partsPinned);
        this.unpinPartitions(partsPinned);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemoveAllRequest(RemoveAllRequest.RemoveJob job) {
        block17: {
            PartialValueResponse msgResponse = (PartialValueResponse)job.getResponse();
            int iPartition = job.getPartition();
            RequestContext context = job.getRequestContext();
            boolean fEntered = this.pinOwnedPartition(iPartition);
            long lCacheId = job.getCacheId();
            Storage storage = this.getKnownStorage(lCacheId);
            try {
                block18: {
                    if (!fEntered || storage == null) break block18;
                    ResultInfo resultInfo = this.getResultInfo(context);
                    if (resultInfo != null && resultInfo.getPartitions().contains(iPartition)) {
                        this.processChanges(context, job, lCacheId, null, job.getBatchContext());
                        return;
                    }
                    Map map = job.getMap();
                    int cEntries = 0;
                    Binary[] aKeys = new Binary[map.size()];
                    InvocationContext ctxInvoke = this.ensureInvocationContext(iPartition);
                    for (Map.Entry entry : map.entrySet()) {
                        aKeys[cEntries++] = (Binary)entry.getKey();
                    }
                    try {
                        ctxInvoke.prepareAccess(context, storage, 49152, 3);
                        while (true) {
                            try {
                                Storage.EntryStatus[] aStatus = ctxInvoke.lockEntries(storage, aKeys, cEntries);
                                if (storage.removeAll(ctxInvoke, aStatus)) {
                                    msgResponse.setResult(Binary.EMPTY);
                                }
                            }
                            catch (LockContentionException e) {
                                ctxInvoke.rollback(e, job.getRequest());
                                continue;
                            }
                            break;
                        }
                    }
                    catch (HeuristicCommitException e) {
                        if (this.isExiting()) {
                            if (fEntered) {
                                this.unpinPartition(iPartition);
                            }
                            return;
                        }
                        this.onPartialCommit(msgResponse, e);
                    }
                    catch (Throwable e) {
                        msgResponse.setException(this.tagException(e));
                    }
                    {
                        GuardSupport.reset();
                        this.registerMultiResult(context, iPartition, Collections.emptyMap());
                        this.processChanges(context, job, lCacheId, ctxInvoke.getEntryStatuses(), job.getBatchContext());
                        this.releaseInvocationContext(ctxInvoke);
                        break block17;
                    }
                }
                msgResponse.rejectPartition(iPartition);
                this.processChanges(context, job, lCacheId, null, job.getBatchContext());
            }
            finally {
                if (fEntered) {
                    this.unpinPartition(iPartition);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemoveRequest(RemoveRequest msgRequest) {
        Grid.Response msgResponse = (Grid.Response)this.instantiateMessage("Response");
        msgResponse.respondTo(msgRequest);
        Storage storage = this.validateRequestForStorage(msgRequest, msgResponse, false);
        if (storage == null) {
            return;
        }
        Binary binKey = msgRequest.getKey();
        RequestContext context = msgRequest.getRequestContext();
        if (this.postPriorResult(context, binKey, msgResponse)) {
            return;
        }
        int nPartition = this.getKeyPartition(binKey);
        boolean fEntered = this.pinOwnedPartition(nPartition);
        if (!fEntered) {
            msgResponse.setResult(1);
            this.post(msgResponse);
            return;
        }
        InvocationContext ctxInvoke = this.ensureInvocationContext(nPartition);
        Storage.EntryStatus status = null;
        try {
            while (true) {
                status = ctxInvoke.lockEntry(storage, binKey, false);
                try {
                    StorageAccessAuthorizer authorizer = storage.getAccessAuthorizer();
                    if (authorizer != null) {
                        authorizer.checkWrite(status.getBinaryEntry(), context.getSubject(), 3);
                    }
                    storage.remove(ctxInvoke, status, !msgRequest.isReturnRequired());
                    Binary binResult = status.getResult();
                    msgResponse.setValue(binResult);
                    this.registerSingleResult(context, binKey, binResult);
                    msgRequest.setProcessedPartition(nPartition);
                }
                catch (LockContentionException e) {
                    ctxInvoke.rollback(e, msgRequest);
                    continue;
                }
                break;
            }
        }
        catch (HeuristicCommitException e) {
            if (this.isExiting()) {
                return;
            }
            this.onPartialCommit(msgResponse, e);
        }
        catch (Throwable e) {
            msgResponse.setResult(2);
            msgResponse.setValue(this.tagException(e));
        }
        finally {
            GuardSupport.reset();
            Collection colEntryStatus = ctxInvoke.getEntryStatuses();
            switch (colEntryStatus.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.processChanges(context, binKey, status, msgRequest.getCacheId(), msgResponse);
                    break;
                }
                default: {
                    this.processChanges(context, null, msgRequest.getCacheId(), colEntryStatus, this.instantiateBatchContext(msgResponse));
                }
            }
            this.releaseInvocationContext(ctxInvoke);
            if (fEntered) {
                this.unpinPartition(nPartition);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSendBackups(Continuation contProceed) {
        PartitionSet partsOwned = this.collectOwnedPartitions(true);
        int iPart = partsOwned.next(0);
        while (iPart != -1) {
            if (!((PartitionControl)this.getPartitionControl(iPart)).hasScheduledBackups() || !this.pinOwnedPartition(iPart, -1)) {
                partsOwned.remove(iPart);
            }
            iPart = partsOwned.next(iPart + 1);
        }
        Map mapMemberParts = this.splitByBackupOwners(partsOwned);
        for (Map.Entry entry : mapMemberParts.entrySet()) {
            List listMembers = (List)entry.getKey();
            PartitionSet parts = (PartitionSet)entry.getValue();
            BackupAllRequest msg = null;
            PrimitiveSparseArray laVersions = null;
            HashMap<Object, Object> mapCaches = null;
            if (!listMembers.isEmpty()) {
                msg = (BackupAllRequest)this.instantiateMessage("BackupAllRequest");
                mapCaches = new HashMap();
                laVersions = msg.getPartitionVersions();
                msg.setMemberList(listMembers);
            }
            long lCacheId = 0L;
            int iPart2 = parts.next(0);
            while (iPart2 >= 0) {
                LongArray laPendingBackups;
                PartitionControl ctrlPart = (PartitionControl)this.getPartitionControl(iPart2);
                if (laVersions != null) {
                    PartitionedCache._assert(!laVersions.exists(iPart2));
                    laVersions.setPrimitive(iPart2, ctrlPart.getVersionCounter().incrementAndGet());
                }
                if ((laPendingBackups = ctrlPart.getPendingBackups()).isEmpty() || msg == null) {
                    if (msg == null) {
                        ctrlPart.setPendingBackups(null);
                    }
                } else {
                    for (long lCacheIdCur : laPendingBackups.keys()) {
                        Set setKeys;
                        ObservableMap mapResource = this.getStorage(lCacheIdCur).getBackingInternalCache();
                        Map mapPendingBackupTotalSize = ctrlPart.getPendingBackupTotalSize();
                        if (mapPendingBackupTotalSize != null && (Long)mapPendingBackupTotalSize.get(lCacheIdCur) == Long.MAX_VALUE) {
                            setKeys = this.getStorage(lCacheIdCur).collectKeySet(iPart2);
                            var24_23 = laPendingBackups;
                            synchronized (var24_23) {
                                laPendingBackups.remove(lCacheIdCur);
                            }
                            mapPendingBackupTotalSize.put(lCacheIdCur, 0L);
                        } else {
                            var24_23 = laPendingBackups;
                            synchronized (var24_23) {
                                setKeys = ((Map)laPendingBackups.remove(lCacheIdCur)).keySet();
                            }
                        }
                        Map<Binary, Binary> mapData = null;
                        if (lCacheId == 0L) {
                            lCacheId = lCacheIdCur;
                            mapData = mapCaches;
                        } else if (lCacheId == lCacheIdCur) {
                            mapData = mapCaches;
                        } else {
                            if (lCacheId != -1L) {
                                mapCaches = new HashMap(Collections.singletonMap(lCacheId, mapData));
                                lCacheId = -1L;
                            }
                            if ((mapData = (Map)mapCaches.get(lCacheIdCur)) == null) {
                                mapData = new HashMap(setKeys.size());
                                mapCaches.put(lCacheIdCur, mapData);
                            }
                        }
                        Iterator iterKeys = setKeys.iterator();
                        while (iterKeys.hasNext()) {
                            Binary binKey;
                            Binary binValue = (Binary)mapResource.get(binKey = (Binary)iterKeys.next());
                            mapData.put(binKey, binValue == null ? Binary.EMPTY : binValue);
                        }
                    }
                }
                iPart2 = parts.next(iPart2 + 1);
            }
            if (msg == null) continue;
            msg.setCacheId(lCacheId);
            msg.setMap(mapCaches);
            msg.setSyncMsg(false);
            this.post(msg);
        }
        this.unpinPartitions(partsOwned);
        contProceed.proceed(null);
    }

    @Override
    public void onServiceStarted() {
        BackingMapContext context = (BackingMapContext)this._newChild("BackingMapContext");
        this.setBackingMapContext(context);
        BackingMapManager manager = this.getBackingMapManager();
        if (manager != null) {
            context.setManager(manager);
        }
        if (this.isOwnershipEnabled()) {
            this.setPendingEvents(new SparseArray());
            long cExpiry = ((Cluster)this.getCluster()).getClusterService().getDeliveryTimeoutMillis();
            this.setStorageGraveyard(new LocalCache(Integer.MAX_VALUE, (int)cExpiry));
        }
        super.onServiceStarted();
    }

    @Override
    protected void onServiceStopping() {
        super.onServiceStopping();
        this.releaseAllCache();
    }

    public void onSizeRequest(SizeRequest msgRequest) {
        PartialValueResponse msgResponse = (PartialValueResponse)this.instantiateMessage("PartialValueResponse");
        msgResponse.respondTo(msgRequest);
        Storage storage = this.validateRequestForStorage(msgRequest, msgResponse, false);
        if (storage == null) {
            return;
        }
        this.flushOOBEvents();
        PartitionSet partMask = msgRequest.getRequestMaskSafe();
        PartitionSet partReject = this.pinOwnedPartitions(partMask);
        try {
            int cSize = -1;
            if (partReject == null && !this.isRestoreInProgress() && !this.isDistributionInProgress() && !this.isTransferInProgress() && partMask.equals(this.collectOwnedPartitions(true))) {
                cSize = storage.size();
                if (!partMask.equals(this.collectOwnedPartitions(true))) {
                    cSize = -1;
                }
            }
            if (cSize < 0) {
                cSize = storage.calculateSize(partMask, true);
            }
            msgResponse.setResult(cSize);
            msgResponse.setRejectPartitions(partReject);
        }
        catch (Throwable e) {
            msgResponse.setException(this.tagException(e));
        }
        this.processChanges(msgResponse);
        this.unpinPartitions(partMask);
    }

    public void onStorageConfirmRequest(StorageConfirmRequest msgRequest) {
        PartialValueResponse msgResponse = (PartialValueResponse)this.instantiateMessage("PartialValueResponse");
        msgResponse.respondTo(msgRequest);
        PartitionSet partsMask = msgRequest.getRequestMaskSafe();
        long lCacheId = msgRequest.getCacheId();
        if (this.getKnownStorage(lCacheId) == null) {
            String sCache = (String)this.getStorageGraveyard().get(lCacheId);
            if (sCache != null) {
                partsMask.clear();
                msgResponse.setException(new RequestPolicyException("Cache \"" + sCache + "\" has been concurrently destroyed"));
            }
        } else {
            partsMask.remove(this.collectOwnedPartitions(true));
            msgResponse.setResult(Boolean.TRUE);
        }
        msgResponse.setRejectPartitions(partsMask);
        this.post(msgResponse);
    }

    @Override
    public void onTransferCompleted(boolean fSuccess, Object oResult, PartitionedService.TransferRequest msg) {
        Continuation continuation = this.getContinuations().instantiateFinalizeTransferPrimary(msg);
        EventsHelper helper = this.getEventsHelper();
        if (fSuccess) {
            Map mapResponses = (Map)oResult;
            Iterator iter = mapResponses.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                int iPartition = (Integer)entry.getKey();
                boolean fMore = iter.hasNext();
                helper.onTransferCompleted(fSuccess, iPartition, fMore ? null : continuation);
                if (fMore) continue;
                continuation = null;
            }
        } else {
            int[][] aaiOwner = this.getPartitionAssignments();
            int nMemberThis = this.getThisMember().getId();
            TransferControl ctrlTransfer = (TransferControl)this.getTransferControl();
            PartitionedService.TransferControl.TransferIterator iter = ctrlTransfer.iterateTransfersInProgress();
            while (iter.hasNext()) {
                iter.next();
                int iPartition = iter.getPartition();
                boolean fMore = iter.hasNext();
                if (aaiOwner[iPartition][0] == nMemberThis) continue;
                helper.onTransferCompleted(fSuccess, iPartition, fMore ? null : continuation);
                if (fMore) continue;
                continuation = null;
            }
        }
        if (continuation != null) {
            continuation.proceed(null);
        }
    }

    @Override
    public void onTransferRequest(PartitionedService.TransferRequest msgRequest) {
        LongArray laResultInfo = msgRequest.getPendingResults();
        if (laResultInfo != null) {
            int nPartition = msgRequest.getPartition();
            Iterator crawler = laResultInfo.iterator();
            while (crawler.hasNext()) {
                Map mapResult = (Map)crawler.next();
                this.mergeTransferredResults(crawler.getIndex(), nPartition, mapResult);
            }
        }
        this.registerEvent(msgRequest.getPendingEvents(), msgRequest.getFromMember());
        super.onTransferRequest(msgRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUnlockRequest(UnlockRequest msgRequest) {
        Grid.Response msgResponse;
        block11: {
            msgResponse = (Grid.Response)this.instantiateMessage("Response");
            msgResponse.respondTo(msgRequest);
            Storage storage = this.validateRequestForStorage(msgRequest, msgResponse, true);
            if (storage == null) {
                return;
            }
            Binary binKey = msgRequest.getKey();
            try {
                boolean fEnter = this.isConcurrent();
                if (this.lockKey(storage, binKey, fEnter)) {
                    try {
                        Lease lease = msgRequest.toLease();
                        if (storage.unlock(lease)) {
                            List listBackups;
                            int iPartition = this.getKeyPartition(binKey);
                            long lVersion = this.getPartitionControl(iPartition).getVersionCounter().incrementAndGet();
                            msgResponse.setValue(Boolean.TRUE);
                            if (this.getBackupCount() > 0 && !(listBackups = this.getBackupOwners(binKey)).isEmpty()) {
                                BackupLockRequest msgBackup = (BackupLockRequest)this.instantiateMessage("BackupLockRequest");
                                msgBackup.setCacheId(msgRequest.getCacheId());
                                msgBackup.setKey(binKey);
                                msgBackup.setPartition(iPartition);
                                msgBackup.setPartitionVersion(lVersion);
                                msgBackup.setLock(false);
                                msgBackup.setPrimaryResponse(msgResponse);
                                msgBackup.setMemberList(listBackups);
                                this.post(msgBackup);
                                storage.firePendingLocks(binKey);
                                return;
                            }
                            storage.firePendingLocks(binKey);
                        } else {
                            msgResponse.setValue(Boolean.FALSE);
                        }
                        break block11;
                    }
                    finally {
                        this.unlockKey(storage, binKey, fEnter);
                    }
                }
                msgResponse.setResult(1);
            }
            catch (Throwable e) {
                msgResponse.setResult(2);
                msgResponse.setValue(this.tagException(e));
            }
        }
        this.post(msgResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpdateIndexRequest(UpdateIndexRequest msgRequest) {
        int nPartition;
        block4: {
            Grid.Response msgResponse = (Grid.Response)this.instantiateMessage("Response");
            msgResponse.respondTo(msgRequest);
            ConcurrentLinkedQueue queue = this.getPendingIndexUpdate();
            do {
                CommonMonitor oMonitor;
                nPartition = msgRequest.getPartition();
                this.updateProcessingIndexPartition(nPartition, true);
                if (!this.processIndexRequest(msgRequest, msgResponse)) break block4;
                this.updateProcessingIndexPartition(nPartition, false);
                this.updatePendingIndexPartition(nPartition, false);
                CommonMonitor commonMonitor = oMonitor = Base.getCommonMonitor(System.identityHashCode(this) + nPartition);
                synchronized (commonMonitor) {
                    oMonitor.notifyAll();
                }
            } while ((msgRequest = (UpdateIndexRequest)queue.poll()) != null);
            msgResponse.setResult(0);
            this.post(msgResponse);
            return;
        }
        this.updateProcessingIndexPartition(nPartition, false);
    }

    protected void persistBackup(int nPartition, long lCacheId, Binary binKey, Binary binValue, boolean fRemove) {
        PartitionControl ctrlPart;
        PersistentStore store;
        if (binValue == null) {
            return;
        }
        if (!this.isBackupOwner(nPartition)) {
            return;
        }
        Storage storage = this.getKnownStorage(lCacheId);
        if (storage != null && storage.isPersistent() && (store = (ctrlPart = (PartitionControl)this.getPartitionControl(nPartition)).ensureOpenPersistentStore(null, true, true)) != null) {
            ctrlPart.ensureBackupPersistentExtent(lCacheId);
            Object oToken = store.begin(null, ctrlPart);
            try {
                if (fRemove) {
                    store.erase(lCacheId, binKey, oToken);
                } else {
                    store.store(lCacheId, binKey, binValue, oToken);
                }
                store.commit(oToken);
            }
            catch (Throwable t) {
                store.abort(oToken);
                throw Base.ensureRuntimeException(t);
            }
            return;
        }
    }

    protected void persistBackup(long lCacheId, Map mapEntries) {
        Storage storage = this.getKnownStorage(lCacheId);
        if (storage != null && storage.isPersistent()) {
            Map mapByPartKeys = this.splitKeysByPartition(mapEntries.keySet().iterator());
            for (Map.Entry entry : mapByPartKeys.entrySet()) {
                int iPart = (Integer)entry.getKey();
                Set setPartKeys = (Set)entry.getValue();
                PartitionControl ctrlPart = (PartitionControl)this.getPartitionControl(iPart);
                PersistentStore store = ctrlPart.ensureOpenPersistentStore(null, true, true);
                if (store == null) continue;
                ctrlPart.ensureBackupPersistentExtent(lCacheId);
                Object oToken = store.begin(null, ctrlPart);
                try {
                    for (Binary binKey : setPartKeys) {
                        Binary binValue = (Binary)mapEntries.get(binKey);
                        store.store(lCacheId, binKey, binValue, oToken);
                    }
                    store.commit(oToken);
                }
                catch (Throwable t) {
                    store.abort(oToken);
                    throw Base.ensureRuntimeException(t);
                }
            }
        }
    }

    protected void persistBackup(long lCacheId, Set setRemove) {
        Storage storage = this.getKnownStorage(lCacheId);
        if (storage != null && storage.isPersistent()) {
            Map mapByPartKeys = this.splitKeysByPartition(setRemove.iterator());
            for (Map.Entry entry : mapByPartKeys.entrySet()) {
                int iPart = (Integer)entry.getKey();
                Set setPartKeys = (Set)entry.getValue();
                PartitionControl ctrlPart = (PartitionControl)this.getPartitionControl(iPart);
                PersistentStore store = ctrlPart.ensureOpenPersistentStore(null, true, true);
                if (store == null) continue;
                ctrlPart.ensureBackupPersistentExtent(lCacheId);
                Object oToken = store.begin(null, ctrlPart);
                try {
                    for (Binary binKey : setPartKeys) {
                        store.erase(lCacheId, binKey, oToken);
                    }
                    store.commit(oToken);
                }
                catch (Throwable t) {
                    store.abort(oToken);
                    throw Base.ensureRuntimeException(t);
                }
            }
        }
    }

    protected boolean persistChanges(RequestContext ctx, Collector collector, Map mapStatusByPart) {
        if (mapStatusByPart == null) {
            return false;
        }
        this.flush();
        boolean fPersisted = false;
        for (Map.Entry entry : mapStatusByPart.entrySet()) {
            int nPartition = (Integer)entry.getKey();
            Collection colPartStatus = (Collection)entry.getValue();
            PartitionControl ctrlPartition = (PartitionControl)this.getPartitionControl(nPartition);
            PersistentStore store = ctrlPartition.ensureOpenPersistentStore(null, true);
            Object oToken = store.begin(collector, ctrlPartition);
            try {
                for (Storage.EntryStatus status : colPartStatus) {
                    Storage storage = status.getStorage();
                    if (!storage.isPersistent() || !status.isAnyAction()) continue;
                    long lExtentId = storage.getCacheId();
                    Binary bufKey = status.getKey();
                    ReadBuffer bufValue = status.getMergedNewValue();
                    ctrlPartition.ensurePersistentExtent(lExtentId);
                    if (bufValue == null) {
                        store.erase(lExtentId, bufKey, oToken);
                    } else {
                        store.store(lExtentId, bufKey, bufValue, oToken);
                    }
                    fPersisted = true;
                }
                store.commit(oToken);
            }
            catch (Throwable t) {
                store.abort(oToken);
                throw Base.ensureRuntimeException(t);
            }
        }
        return fPersisted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean persistChanges(RequestContext ctx, Collector collector, Storage.EntryStatus status) {
        Storage storage = status.getStorage();
        boolean fPersist = storage.isPersistent();
        if (fPersist) {
            long lExtentId = status.getStorage().getCacheId();
            Binary bufKey = status.getKey();
            ReadBuffer bufValue = status.getMergedNewValue();
            this.flush();
            PartitionControl ctrl = (PartitionControl)this.getPartitionControl(status.getPartition());
            PersistentStore store = ctrl.ensureOpenPersistentStore(null, true);
            PersistentStore storeEvents = ctrl.getPersistentEventsStore();
            boolean fPersistEvents = storeEvents != null && status.getMapEventsRaw() != null;
            ctrl.ensurePersistentExtent(lExtentId);
            List<Object> oToken = store.begin(fPersistEvents ? null : collector, ctrl);
            try {
                if (bufValue == null) {
                    store.erase(lExtentId, bufKey, oToken);
                } else {
                    store.store(lExtentId, bufKey, bufValue, oToken);
                }
                if (fPersistEvents) {
                    Object oMapEventsRaw;
                    store = ctrl.getPersistentEventsStore();
                    Object oTokenEvents = store.begin(collector, ctrl);
                    Storage.EntryStatus entryStatus = status;
                    synchronized (entryStatus) {
                        oMapEventsRaw = status.getMapEventsRaw();
                        status.setMapEventsRaw(null);
                    }
                    this.persistMapEvents(oMapEventsRaw, store, oTokenEvents, lExtentId);
                    oToken = Arrays.asList(oToken, oTokenEvents);
                }
                store.commit(oToken);
            }
            catch (Throwable t) {
                store.abort(oToken);
                throw Base.ensureRuntimeException(t);
            }
            return true;
        }
        return false;
    }

    protected void persistMapEvents(Object oEvent, PersistentStore store, Object oToken, long lExtentId) {
        if (oEvent instanceof LongArray) {
            Iterator iter = ((LongArray)oEvent).iterator();
            while (iter.hasNext()) {
                this.persistMapEvents(iter.next(), store, oToken, lExtentId);
            }
        } else {
            com.tangosol.util.MapEvent event = (com.tangosol.util.MapEvent)oEvent;
            com.tangosol.util.Converter convDown = this.getBackingMapContext().getValueToInternalConverter();
            ReadBuffer bufEventKey = (ReadBuffer)CachePersistenceHelper.LONG_CONVERTER_DOWN.convert(event.getVersion());
            ReadBuffer bufEvent = (ReadBuffer)convDown.convert(event);
            store.store(lExtentId, bufEventKey, bufEvent, oToken);
        }
    }

    @Override
    protected boolean pinOwnedPartition(int nPartition, int nVersion) {
        boolean fPinned = super.pinOwnedPartition(nPartition, nVersion);
        if (fPinned) {
            this.ensureIndexReady(nPartition);
        }
        return fPinned;
    }

    protected void postAll(Message[] aMsg) {
        int c;
        long cbPending = 0L;
        int n = c = aMsg == null ? 0 : aMsg.length;
        for (int i = 0; i < c; ++i) {
            Message msg = aMsg[i];
            if (msg == null) continue;
            cbPending = this.post(aMsg[i], cbPending);
        }
        this.flush();
    }

    protected void postEvent(MapEvent msgEvent) {
        if (msgEvent == null) {
            return;
        }
        this.post(msgEvent);
    }

    public void postEvents(Object oHolder) {
        if (oHolder == null) {
            return;
        }
        if (oHolder instanceof MapEvent) {
            this.postEvent((MapEvent)oHolder);
        } else if (oHolder instanceof Map) {
            Iterator iter = ((Map)oHolder).values().iterator();
            while (iter.hasNext()) {
                this.postEvents(iter.next());
            }
        } else if (oHolder instanceof Collection) {
            Iterator iter = ((Collection)oHolder).iterator();
            while (iter.hasNext()) {
                this.postEvents(iter.next());
            }
        } else if (oHolder instanceof Storage.EntryStatus) {
            this.postEvents(((Storage.EntryStatus)oHolder).getMapEventHolder());
        } else {
            throw new IllegalArgumentException("Unknown event holder: " + String.valueOf(oHolder));
        }
    }

    protected boolean postPriorResult(RequestContext ctx, Binary binKey, Grid.Response msgResponse) {
        Map mapPrev;
        ResultInfo resultInfo = this.getResultInfo(ctx);
        Map map = mapPrev = resultInfo == null ? null : resultInfo.extractResults(binKey);
        if (mapPrev == null) {
            return false;
        }
        msgResponse.setValue(mapPrev.get(binKey));
        this.post(msgResponse);
        return true;
    }

    protected BackupAllRequest prepareBackupAllRequest(RequestContext ctx, BackupAllRequest msg, Collection colStatus) {
        long lCacheId;
        LiteMap<Long, DefaultVersionedPartitions> mapVersions;
        HashMap<Comparable<Long>, Cloneable> mapEvents;
        HashMap<Binary, Binary> mapData;
        long lResultsCacheId;
        HashMap<Comparable<Long>, Cloneable> mapResults;
        HashMap<Comparable<Long>, Cloneable> mapEmpty = Collections.emptyMap();
        int cStatus = colStatus.size();
        DefaultVersionedPartitions versionsCache = null;
        if (msg == null) {
            msg = (BackupAllRequest)this.instantiateMessage("BackupAllRequest");
            mapResults = mapEmpty;
            lResultsCacheId = -1L;
            mapData = null;
            mapEvents = null;
            mapVersions = null;
            lCacheId = -1L;
        } else {
            mapResults = msg.getResultMap();
            lResultsCacheId = msg.getResultsCacheId();
            lCacheId = msg.getCacheId();
            mapData = msg.getMap();
            mapEvents = msg.getEventHolderMap();
            mapVersions = msg.getMapEventVersions();
        }
        for (Storage.EntryStatus status : colStatus) {
            HashMap<Comparable<Long>, Cloneable> mapCacheEvents;
            Map<Binary, Binary> mapCacheData;
            Binary binKey = status.getKey();
            Binary binValueOld = status.getOldValue();
            ReadBuffer bufValueNew = status.getMergedNewValue();
            long lCacheIdCur = status.getStorage().getCacheId();
            int nPartition = status.getPartition();
            if (mapData == null) {
                lCacheId = lCacheIdCur;
                mapCacheData = mapData = new HashMap<Binary, Binary>(cStatus + cStatus / 3);
                mapCacheEvents = mapEvents = mapEmpty;
                mapVersions = new LiteMap<Long, DefaultVersionedPartitions>();
                versionsCache = new DefaultVersionedPartitions();
                mapVersions.put(lCacheId, versionsCache);
            } else if (lCacheId == lCacheIdCur) {
                mapCacheData = mapData;
                mapCacheEvents = mapEvents;
                versionsCache = versionsCache == null ? (DefaultVersionedPartitions)mapVersions.get(lCacheId) : versionsCache;
            } else {
                Long LCacheIdCur;
                if (lCacheId != -1L) {
                    Long LCacheIdOld = lCacheId;
                    HashMap<Comparable<Long>, Cloneable> mapTemp = new HashMap<Comparable<Long>, Cloneable>();
                    mapTemp.put(LCacheIdOld, mapData);
                    mapData = mapTemp;
                    mapTemp = new HashMap();
                    mapTemp.put(LCacheIdOld, mapEvents);
                    mapEvents = mapTemp;
                    lCacheId = -1L;
                }
                if ((mapCacheData = (Map)mapData.get(LCacheIdCur = Long.valueOf(lCacheIdCur))) == null) {
                    mapCacheData = new HashMap();
                    mapData.put((Binary)((Object)LCacheIdCur), (Binary)((Object)mapCacheData));
                }
                if ((mapCacheEvents = (HashMap<Comparable<Long>, Cloneable>)mapEvents.get(LCacheIdCur)) == null) {
                    mapCacheEvents = mapEmpty;
                    mapEvents.put(LCacheIdCur, mapCacheEvents);
                }
                if ((versionsCache = (DefaultVersionedPartitions)mapVersions.get(LCacheIdCur)) == null) {
                    versionsCache = new DefaultVersionedPartitions();
                    mapVersions.put(LCacheIdCur, versionsCache);
                }
            }
            mapCacheData.put(binKey, (Binary)(status.isAnyAction() ? (bufValueNew == null ? Binary.EMPTY : this.extractDelta(binValueOld, bufValueNew)) : null));
            Object oHolder = status.getMapEventHolder();
            if (oHolder != null) {
                if (mapCacheEvents == mapEmpty) {
                    if (lCacheId == -1L) {
                        mapCacheEvents = new HashMap();
                        mapEvents.put(Long.valueOf(lCacheIdCur), mapCacheEvents);
                    } else {
                        mapEvents = mapCacheEvents = new HashMap(cStatus + cStatus / 3);
                    }
                }
                mapCacheEvents.put(binKey, (Cloneable)oHolder);
            }
            Binary binResult = status.getResult();
            if (ctx != null && binResult != null) {
                if (lResultsCacheId == -1L) {
                    lResultsCacheId = lCacheIdCur;
                } else {
                    PartitionedCache._assert(lResultsCacheId == lCacheIdCur);
                }
                if (mapResults == mapEmpty) {
                    mapResults = new HashMap();
                }
                mapResults.put(binKey, Storage.compressResult(binResult, binValueOld, bufValueNew));
            }
            versionsCache.setPartitionVersion(nPartition, Math.max(status.getMaxMapEventVersion(), versionsCache.getVersion(nPartition)));
        }
        msg.setCacheId(lCacheId);
        msg.setMap(mapData);
        msg.setEventHolderMap(mapEvents);
        msg.setMapEventVersions(mapVersions);
        msg.setResultsCacheId(lResultsCacheId);
        if (ctx != null) {
            msg.setResultMap(mapResults);
        }
        return msg;
    }

    protected BackupAllRequest[] prepareBackupAllRequests(RequestContext ctx, BatchContext ctxBatch, Map mapStatuses, Map mapVersions, boolean fExpiryOnly) {
        BackupAllRequest msgBackup;
        Map<List, BackupAllRequest> mapMsg;
        boolean fSyncBackup = false;
        if (this.isScheduledBackups()) {
            this.scheduleBackups(new ChainedCollection(mapStatuses.values()));
            mapMsg = Collections.emptyMap();
            mapStatuses = mapMsg;
        } else {
            mapMsg = new HashMap(mapStatuses.size());
        }
        for (Map.Entry entry : mapStatuses.entrySet()) {
            Integer NPartition = (Integer)entry.getKey();
            int nPartition = NPartition;
            List listBackups = this.getBackupOwners(nPartition);
            if (listBackups.isEmpty()) continue;
            fSyncBackup |= this.getPartitionControl(nPartition).initiateBackup();
            Collection colPartStatus = (Collection)entry.getValue();
            msgBackup = (BackupAllRequest)mapMsg.get(listBackups);
            boolean fNew = msgBackup == null;
            long lVersion = (Long)mapVersions.get(NPartition);
            msgBackup = this.prepareBackupAllRequest(ctx, msgBackup, colPartStatus);
            msgBackup.getPartitionVersions().setPrimitive(nPartition, lVersion);
            if (!fNew) continue;
            mapMsg.put(listBackups, msgBackup);
        }
        int cMsg = mapMsg.size();
        if (cMsg == 0) {
            return null;
        }
        BackupAllRequest[] aMsg = new BackupAllRequest[cMsg];
        int iMsg = 0;
        if (fExpiryOnly) {
            fSyncBackup = false;
        }
        for (Map.Entry entry : mapMsg.entrySet()) {
            List listBackups = (List)entry.getKey();
            msgBackup = (BackupAllRequest)entry.getValue();
            msgBackup.setRequestContext(ctx);
            msgBackup.setBatchContext(ctxBatch);
            msgBackup.setMemberList(listBackups);
            msgBackup.setSyncMsg(fSyncBackup);
            aMsg[iMsg++] = msgBackup;
        }
        if (fSyncBackup) {
            ctxBatch.getOutstandingOperationCounter().getAndAdd(cMsg);
        }
        return aMsg;
    }

    protected BackupListenerAllRequest[] prepareBackupListenerAllRequests(long lCacheId, boolean fLite, boolean fAdd, Member member, Binary[] aoKey, int cSize, BatchContext ctxBatch) {
        HashMap<List, BackupListenerAllRequest> mapMsg = new HashMap<List, BackupListenerAllRequest>(cSize);
        LiteMap<Integer, Long> mapVersions = new LiteMap<Integer, Long>();
        boolean fSyncBackup = this.isAsyncBackup();
        for (int i = 0; i < cSize; ++i) {
            long lVersion;
            Binary binKey = aoKey[i];
            int nPartition = this.getKeyPartition(binKey);
            List listBackups = this.getBackupOwners(nPartition);
            if (listBackups.isEmpty()) continue;
            BackupListenerAllRequest msg = (BackupListenerAllRequest)mapMsg.get(listBackups);
            Integer NPartition = nPartition;
            Long LVersion = (Long)mapVersions.get(NPartition);
            if (LVersion == null) {
                lVersion = this.getPartitionControl(nPartition).getVersionCounter().incrementAndGet();
                mapVersions.put(NPartition, lVersion);
            } else {
                lVersion = LVersion;
            }
            if (msg == null) {
                msg = (BackupListenerAllRequest)this.instantiateMessage("BackupListenerAllRequest");
                msg.setCacheId(lCacheId);
                msg.setAdd(fAdd);
                msg.setLite(fLite);
                msg.setMemberId(member.getId());
                msg.setBatchContext(ctxBatch);
                msg.setMemberList(listBackups);
                msg.setSyncMsg(fSyncBackup);
                mapMsg.put(listBackups, msg);
            }
            msg.addKey(binKey);
            msg.getPartitionVersions().setPrimitive(nPartition, lVersion);
        }
        if (fSyncBackup) {
            ctxBatch.getOutstandingOperationCounter().getAndAdd(mapMsg.size());
        } else {
            ctxBatch.setLastBackupCompletedTime(System.currentTimeMillis());
        }
        return mapMsg.values().toArray(new BackupListenerAllRequest[mapMsg.size()]);
    }

    protected BackupSingleRequest prepareBackupSingleRequest(RequestContext ctx, Storage.EntryStatus status, long lPartVersion, Message msgResponse) {
        BackupSingleRequest msg = null;
        int nPartition = status.getPartition();
        List listBackups = this.getBackupOwners(nPartition);
        if (!listBackups.isEmpty()) {
            boolean fSyncBackup = this.getPartitionControl(nPartition).initiateBackup();
            Binary binValueOld = status.getOldValue();
            ReadBuffer bufValueNew = status.getMergedNewValue();
            Storage storage = status.getStorage();
            if (status.isExpiryOnly()) {
                fSyncBackup = false;
            }
            msg = (BackupSingleRequest)this.instantiateMessage("BackupSingleRequest");
            msg.setPartitionVersion(lPartVersion);
            msg.setMapEventVersion(status.getMaxMapEventVersion());
            msg.setSyncMsg(fSyncBackup);
            msg.setOutstandingOperationCounter(new AtomicInteger(fSyncBackup ? 2 : 1));
            msg.setCacheId(storage.getCacheId());
            msg.setKey(status.getKey());
            msg.setPartition(nPartition);
            msg.setPrimaryResponse(msgResponse);
            msg.setEventHolder(status.getMapEventHolder());
            msg.setRequestContext(ctx);
            msg.setMemberList(listBackups);
            if (!fSyncBackup) {
                msg.setBackupCompletedTime(Base.getSafeTimeMillis());
            }
            if (status.isValueRemoved()) {
                msg.setValue(Binary.EMPTY);
            } else if (status.isValueUpdated()) {
                msg.setValue(this.extractDelta(binValueOld, bufValueNew));
            }
            if (ctx != null) {
                msg.setResult(Storage.compressResult(status.getResult(), binValueOld, bufValueNew));
            }
        }
        return msg;
    }

    protected BackupSingleRequest prepareBackupSingleRequest(RequestContext ctx, Storage.EntryStatus status, LongSupplier supplierVersion, Message msgResponse) {
        if (this.isScheduledBackups()) {
            this.scheduleBackup(status.getPartition(), status.getStorage().getCacheId(), status.getKey());
            return null;
        }
        return this.prepareBackupSingleRequest(ctx, status, supplierVersion.getAsLong(), msgResponse);
    }

    @Override
    protected void preparePartition(int iPartition, int iBackup) {
        super.preparePartition(iPartition, iBackup);
        for (Storage storage : this.getStorageArray()) {
            if (!storage.isValid()) continue;
            storage.preparePartition(iPartition, iBackup == 0);
        }
    }

    public void processChanges() {
        this.processChanges(null, null, -1L, null, null);
    }

    protected void processChanges(Message msgResponse) {
        this.processChanges(null, null, -1L, null, this.instantiateBatchContext(msgResponse));
    }

    protected void processChanges(RequestContext ctx, Binary binKey, Storage.EntryStatus status, long lCacheId, Message msgResponse) {
        Set setStatusOOB = this.getResourceCoordinator().finalizeInvoke();
        if (setStatusOOB == null || setStatusOOB.isEmpty()) {
            this.publishChanges(ctx, status, msgResponse);
        } else {
            Set<Storage.EntryStatus> setStatus = status == null ? null : Collections.singleton(status);
            this.publishChanges(ctx, null, setStatus, setStatusOOB, this.instantiateBatchContext(msgResponse));
        }
    }

    protected void processChanges(RequestContext ctx, PartialJob job, long lCacheId, Collection colStatus, BatchContext ctxBatch) {
        Set setStatusOOB = this.getResourceCoordinator().finalizeInvoke();
        if (ctxBatch == null) {
            if ((colStatus == null || colStatus.isEmpty()) && (setStatusOOB == null || setStatusOOB.isEmpty())) {
                return;
            }
            ctxBatch = this.instantiateBatchContext(null);
        }
        this.publishChanges(ctx, job, colStatus, setStatusOOB, ctxBatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processIndexRequest(UpdateIndexRequest msgRequest, Grid.Response msgResponse) {
        int nPartition = msgRequest.getPartition();
        int nEventId = msgRequest.getEventId();
        PartitionControl ctrlPartition;
        while ((ctrlPartition = (PartitionControl)this.getPartitionControl(nPartition)) != null) {
            if (ctrlPartition.enter(0L)) {
                try {
                    if (ctrlPartition.isLocked()) {
                        msgResponse.setValue(msgRequest);
                        if (ctrlPartition.deferResponse(msgResponse)) {
                            boolean bl = false;
                            return bl;
                        }
                        msgResponse.setValue(null);
                    }
                    if (this.isPrimaryOwner(nPartition)) {
                        PrimitiveIterator.OfLong iterCaches;
                        Map mapUpdate = msgRequest.getUpdateMap();
                        if (mapUpdate == null) {
                            long[] al = Base.randomize(this.getStorageArray().keys());
                            iterCaches = Arrays.stream(al).iterator();
                        } else {
                            iterCaches = Base.randomize(mapUpdate.keySet()).iterator();
                        }
                        ctrlPartition.beginEvent();
                        while (iterCaches.hasNext()) {
                            List listFailed;
                            Storage storage = mapUpdate == null ? this.getStorage((Long)iterCaches.next()) : (Storage)iterCaches.next();
                            if (storage == null || !storage.isValid() || !storage.isIndexed()) continue;
                            Map mapIndex = mapUpdate == null ? null : (Map)mapUpdate.get(storage);
                            long ldtStart = Base.getSafeTimeMillis();
                            while ((listFailed = storage.createPartitionIndex(nPartition, mapIndex)) != null) {
                                if (mapUpdate == null) continue;
                                int cFailed = listFailed.size();
                                for (int i = 0; i < cFailed; ++i) {
                                    mapIndex.remove(listFailed.get(i));
                                }
                                if (!mapIndex.isEmpty()) continue;
                                mapUpdate.remove(storage);
                                if (!mapUpdate.isEmpty()) continue;
                                break;
                            }
                            storage.updateIndexStatistics(ldtStart);
                        }
                        ctrlPartition.endEvent(nPartition, 11, false);
                        this.processChanges();
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    ctrlPartition.exit();
                }
                continue;
            }
            msgResponse.setValue(msgRequest);
            if (ctrlPartition.deferResponse(msgResponse)) {
                return false;
            }
            msgResponse.setValue(null);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishChanges(RequestContext ctx, Storage.EntryStatus status, Message msgResponse) {
        if (status == null) {
            return;
        }
        Object oHolder = null;
        BackupSingleRequest msgBackup = null;
        BatchContext ctxBatch = null;
        Set<EntryInfo> setEntryInfo = null;
        Storage storage = status.getStorage();
        try {
            status.setPending(true);
            if (status.isAnyAction()) {
                EventsHelper evtHelper;
                status.preparePublish();
                oHolder = status.getMapEventHolder();
                int nPartition = status.getPartition();
                PartitionControl ctrlPart = (PartitionControl)this.getPartitionControl(nPartition);
                if (!status.isExpiryOnly() && !status.isSuppressEvents() && ((evtHelper = this.getEventsHelper()).hasServiceInterceptors(TransactionEvent.Type.COMMITTED) || evtHelper.hasStorageInterceptors(storage, status.getEventType()))) {
                    setEntryInfo = Collections.singleton(status.instantiateEntryInfo());
                }
                if ((msgBackup = this.prepareBackupSingleRequest(ctx, status, ctrlPart.getVersionIncrementer(), msgResponse)) != null) {
                    msgBackup.setEntryInfos(setEntryInfo);
                    this.post(msgBackup);
                }
                if (storage.isPersistent()) {
                    boolean fSync = ctrlPart.initiatePersist();
                    Span span = this.newTracingSpan("persistence.write", null).startSpan();
                    Component collector = null;
                    if (msgBackup == null ? !this.isAsyncBackup() : msgBackup.isSyncMsg()) {
                        if (msgBackup == null) {
                            ctxBatch = this.instantiateBatchContext(msgResponse);
                            ctxBatch.setPersistenceTracingSpan(span);
                            ctxBatch.setEvents(oHolder);
                            ctxBatch.setEntryInfos(setEntryInfo);
                            if (ctxBatch.completeOnPersist(fSync, nPartition)) {
                                ctxBatch.getOutstandingOperationCounter().incrementAndGet();
                            }
                            ctxBatch.setLastBackupCompletedTime(Base.getSafeTimeMillis());
                            collector = ctxBatch;
                        } else {
                            msgBackup.setCompleteOnPersist(fSync);
                            msgBackup.setPersistenceTracingSpan(span);
                            if (fSync) {
                                msgBackup.getOutstandingOperationCounter().incrementAndGet();
                            }
                            collector = msgBackup;
                        }
                    } else {
                        BatchContext ctxFinish = this.instantiateBatchContext(null);
                        ctxFinish.setPersistenceTracingSpan(span);
                        ctxFinish.setLastBackupCompletedTime(Base.getSafeTimeMillis());
                        collector = ctxFinish;
                    }
                    this.persistChanges(ctx, (Collector)((Object)collector), status);
                }
            }
        }
        finally {
            status.reset();
            status.setPending(false);
        }
        if (msgBackup == null) {
            if (ctxBatch == null) {
                this.dispatchServerEvents(setEntryInfo, null);
                this.publishToClients(msgResponse, oHolder);
            } else {
                ctxBatch.onJobCompleted(null);
            }
        } else {
            msgBackup.onPublishCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishChanges(RequestContext ctx, PartialJob job, Collection colStatus, Collection colStatusOOB, BatchContext ctxBatch) {
        int cStatus = colStatus == null ? 0 : colStatus.size();
        int cStatusOOB = colStatusOOB == null ? 0 : colStatusOOB.size();
        Collection[] acolStatus = new Collection[]{colStatus == null ? Collections.emptySet() : colStatus, colStatusOOB == null ? Collections.emptySet() : colStatusOOB};
        boolean cSyncBackupMsgs = false;
        if (cStatus + cStatusOOB > 0) {
            BackupAllRequest[] aMsg = null;
            LiteMap<Integer, LinkedList<Component>> mapStatuses = null;
            boolean fPersist = this.getPersistenceManager() != null;
            boolean fPersistSync = true;
            boolean fChangedAny = false;
            EventsHelper evtHelper = this.getEventsHelper();
            boolean fServiceInterceptors = evtHelper.hasServiceInterceptors(TransactionEvent.Type.COMMITTED);
            boolean fStorageInterceptors = false;
            try {
                int nPartition;
                Component status;
                int cBackups = this.getBackupCount();
                Object oHolder = null;
                boolean fExpiryOnly = true;
                HashSet<EntryInfo> setEntryInfo = new HashSet<EntryInfo>();
                HashSet setEntryInfoOOB = new HashSet();
                int cPersistCompletes = 0;
                int i = 0;
                Iterator iter = acolStatus[i].iterator();
                while (iter.hasNext() || i == 0 && (iter = acolStatus[++i].iterator()).hasNext()) {
                    boolean fResult;
                    status = (Storage.EntryStatus)iter.next();
                    ((Storage.EntryStatus)status).setPending(true);
                    boolean fChange = ((Storage.EntryStatus)status).isAnyAction();
                    boolean bl = fResult = ((Storage.EntryStatus)status).getResult() != null;
                    if ((fChange || fResult) && (cBackups > 0 || fPersist)) {
                        LinkedList<Component> colPartStatus;
                        nPartition = ((Storage.EntryStatus)status).getPartition();
                        Integer NPartition = nPartition;
                        if (mapStatuses == null) {
                            mapStatuses = new LiteMap<Integer, LinkedList<Component>>();
                        }
                        if ((colPartStatus = (LinkedList<Component>)mapStatuses.get(NPartition)) == null) {
                            colPartStatus = new LinkedList<Component>();
                            mapStatuses.put(NPartition, colPartStatus);
                        }
                        ((Storage.EntryStatus)status).preparePublish();
                        colPartStatus.add(status);
                    }
                    if (!fChange) continue;
                    oHolder = Storage.accumulateMapEvents(oHolder, ((Storage.EntryStatus)status).getMapEventHolder());
                    if (!((Storage.EntryStatus)status).isExpiryOnly() && !((Storage.EntryStatus)status).isSuppressEvents()) {
                        fExpiryOnly = false;
                        if ((fStorageInterceptors |= evtHelper.hasStorageInterceptors(((Storage.EntryStatus)status).getStorage(), ((Storage.EntryStatus)status).getEventType())) || fServiceInterceptors) {
                            (i == 0 ? setEntryInfo : setEntryInfoOOB).add(((Storage.EntryStatus)status).instantiateEntryInfo());
                        }
                    }
                    fChangedAny = true;
                }
                if (fChangedAny) {
                    if (oHolder != null) {
                        status = ctxBatch;
                        synchronized (status) {
                            ctxBatch.setEvents(Storage.accumulateMapEvents(oHolder, ctxBatch.getEvents()));
                        }
                    }
                    if ((cStatus > 0 || cStatusOOB > 0) && (fServiceInterceptors || fStorageInterceptors)) {
                        ctxBatch.accumulateEntryInfos(setEntryInfo, false);
                        ctxBatch.accumulateEntryInfos(setEntryInfoOOB, true);
                    }
                    if (mapStatuses != null) {
                        LiteMap<Integer, Long> mapVersions = this.isScheduledBackups() ? null : new LiteMap<Integer, Long>();
                        for (Integer NPartition : mapStatuses.keySet()) {
                            nPartition = NPartition;
                            PartitionControl ctrlPartition = (PartitionControl)this.getPartitionControl(nPartition);
                            if (mapVersions != null) {
                                long lVersion = ctrlPartition.getVersionCounter().incrementAndGet();
                                mapVersions.put(NPartition, lVersion);
                            }
                            if (!fPersist || !ctxBatch.completeOnPersist(ctrlPartition.initiatePersist(), nPartition)) continue;
                            ++cPersistCompletes;
                        }
                        aMsg = this.prepareBackupAllRequests(ctx, ctxBatch, mapStatuses, mapVersions, fExpiryOnly);
                    }
                }
                this.postAll(aMsg);
                if (fPersist && mapStatuses != null) {
                    BatchContext collector = null;
                    Span span = this.newTracingSpan("persistence.write", null).startSpan();
                    if (aMsg == null || aMsg.length == 0 ? !this.isAsyncBackup() : aMsg[0].isSyncMsg()) {
                        ctxBatch.getOutstandingOperationCounter().addAndGet(cPersistCompletes);
                        ctxBatch.setLastBackupCompletedTime(Base.getSafeTimeMillis());
                        ctxBatch.setPersistenceTracingSpan(span);
                        collector = ctxBatch;
                    } else {
                        BatchContext ctxFinish = this.instantiateBatchContext(null);
                        ctxFinish.setPersistenceTracingSpan(span);
                        ctxFinish.getOutstandingOperationCounter().addAndGet(cPersistCompletes - 1);
                        ctxFinish.setLastBackupCompletedTime(Base.getSafeTimeMillis());
                        collector = ctxFinish;
                    }
                    this.persistChanges(ctx, (Collector)collector, mapStatuses);
                }
            }
            finally {
                int i = 0;
                Iterator iter = acolStatus[i].iterator();
                while (iter.hasNext() || i == 0 && (iter = acolStatus[++i].iterator()).hasNext()) {
                    Storage.EntryStatus status = (Storage.EntryStatus)iter.next();
                    status.reset();
                    status.setPending(false);
                }
            }
        }
        ctxBatch.onJobCompleted(job);
        if (cStatusOOB > 0) {
            ResourceCoordinator coordinator = this.getResourceCoordinator();
            for (Storage.EntryStatus status : colStatusOOB) {
                this.unlockKey(status.getStorage(), status.getKey(), true);
            }
        }
    }

    public void publishToClients(Message msgResponse, Object oEvtHolder) {
        if (oEvtHolder != null) {
            this.postEvents(oEvtHolder);
        }
        if (msgResponse != null) {
            this.post(msgResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void receivePartition(int iPartition, int iBackup, List listXferRequests) {
        AutoCloseable closeable = null;
        if (this.isActivePersistence()) {
            PartitionControl ctrl = (PartitionControl)this.getPartitionControl(iPartition);
            PersistentStore store = null;
            if (iBackup == 0) {
                store = ctrl.ensurePersistentStore(null, false);
            } else if (this.isBackupPersistence()) {
                store = ctrl.ensurePersistentStore(null, false, true);
            }
            if (store != null && store.isOpen()) {
                closeable = store.exclusively();
            }
            if (iBackup == 0 && this.isPersistEvents()) {
                TransferRequest msgLast = (TransferRequest)listXferRequests.get(listXferRequests.size() - 1);
                ReadBuffer bufEvents = msgLast.getEventsStoreBinary();
                if (bufEvents == null) {
                    Iterator iter = listXferRequests.iterator();
                    while (iter.hasNext() && bufEvents == null) {
                        TransferRequest msgXfer = (TransferRequest)iter.next();
                        bufEvents = msgXfer.getEventsStoreBinary();
                    }
                }
                if (bufEvents != null) {
                    this.deserializeStore(store.getId(), bufEvents);
                }
            }
            if (iBackup == 0) {
                ctrl.preparePersistentExtents();
            } else if (this.isBackupPersistence()) {
                ctrl.preparePersistentBackupExtents();
            }
        }
        try {
            for (TransferRequest msgTransfer : listXferRequests) {
                long lCacheId = msgTransfer.getCacheId();
                Storage storage = this.getStorage(lCacheId);
                if (storage == null) {
                    PartitionedCache._assert(lCacheId == -1L || this.getStorageGraveyard().containsKey(lCacheId));
                    continue;
                }
                if (iBackup == 0) {
                    storage.insertPrimaryTransfer(iPartition, msgTransfer.getResource());
                    storage.insertPrimaryLeaseTransfer(iPartition, msgTransfer.getLease());
                    storage.insertPrimaryListenerTransfer(iPartition, msgTransfer.getListener());
                    if (storage.isPersistent()) {
                        storage.persistGlobalMetadata(iPartition, null);
                    }
                } else {
                    storage.insertBackupTransfer(iPartition, msgTransfer.getResource());
                    storage.insertBackupLeaseTransfer(iPartition, msgTransfer.getLease());
                    storage.insertBackupListenerTransfer(iPartition, msgTransfer.getListener());
                    if (storage.isPersistent() && this.isBackupPersistence()) {
                        storage.persistGlobalMetadata(iPartition, true, null);
                    }
                }
                storage.getVersion().resetSubmitted(iPartition, msgTransfer.getMapEventVersion());
            }
            super.receivePartition(iPartition, iBackup, listXferRequests);
        }
        finally {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public boolean recoverPartition(int iPartition, PersistentStore storeFrom, PersistentStore storeTo, List listRequests) {
        LongArray<String> laStoragePrev = CachePersistenceHelper.getCacheNames(storeFrom);
        SparseArray<Storage> laStorage = new SparseArray<Storage>();
        boolean fWriteCacheNames = false;
        PersistentStore storeEvents = this.getPartitionControl(iPartition).getPersistentEventsStore();
        Iterator iter = laStoragePrev.iterator();
        while (iter.hasNext()) {
            Storage storage = this.getStorage((String)iter.next());
            if (storage == null) continue;
            long lCacheIdPrev = iter.getIndex();
            long lCacheId = storage.getCacheId();
            if (!storage.isPersistent()) {
                CachePersistenceHelper.deleteExtents(storeTo, lCacheIdPrev);
                if (storeEvents != null) {
                    CachePersistenceHelper.deleteExtents(storeEvents, lCacheIdPrev);
                }
            }
            if (lCacheIdPrev != lCacheId) {
                if (storage.isPersistent()) {
                    CachePersistenceHelper.moveExtents(storeTo, lCacheIdPrev, lCacheId);
                    if (storeEvents != null) {
                        CachePersistenceHelper.moveExtents(storeEvents, lCacheIdPrev, lCacheId);
                    }
                    fWriteCacheNames = true;
                } else {
                    lCacheId = lCacheIdPrev;
                }
            }
            laStorage.set(lCacheId, storage);
        }
        if (this.isActivePersistence()) {
            this.getPartitionControl(iPartition).preparePersistentExtents();
            if (fWriteCacheNames) {
                LongArray<String> laCacheNames = ConverterCollections.getLongArray(laStorage, ConversionHelper.getCacheNameConverter(), NullImplementation.getConverter());
                CachePersistenceHelper.storeCacheNames(storeTo, laCacheNames);
                if (storeEvents != null) {
                    CachePersistenceHelper.storeCacheNames(storeTo, laCacheNames);
                }
            }
        }
        int cRecovered = 0;
        PersistenceControl ctrl = (PersistenceControl)this.getPersistenceControl();
        PersistenceControl.RecoveryVisitor visitor = ctrl.instantiateRecoveryVisitor(listRequests);
        boolean fSuccess = true;
        try {
            visitor.setStorageArray(laStorage);
            visitor.setStorageArrayPrev(laStoragePrev);
            visitor.setPartition(iPartition);
            storeFrom.iterate(CachePersistenceHelper.instantiatePersistenceVisitor(visitor));
            cRecovered = visitor.getStatsEntriesRecovered();
            if (storeEvents != null) {
                for (Storage storage : laStorage) {
                    LiteMap<Long, com.tangosol.util.MapEvent> mapEventLast = new LiteMap<Long, com.tangosol.util.MapEvent>();
                    storeEvents.iterate(CachePersistenceHelper.instantiateEventsVisitor(storage.getCacheId(), AlwaysFilter.INSTANCE, -1L, mapEventLast, CachePersistenceHelper.LONG_CONVERTER_DOWN, CachePersistenceHelper.LONG_CONVERTER_UP, (com.tangosol.util.Converter<Object, ReadBuffer>)storage.getConverterValueDown(), (com.tangosol.util.Converter<ReadBuffer, Object>)storage.getConverterUp()));
                    if (mapEventLast.isEmpty()) continue;
                    long lVersionLatest = (Long)mapEventLast.keySet().iterator().next();
                    storage.getVersion().resetSubmitted(iPartition, lVersionLatest);
                }
            }
            boolean iter2 = super.recoverPartition(iPartition, storeFrom, storeTo, listRequests);
            return iter2;
        }
        catch (Throwable t) {
            fSuccess = false;
            throw Base.ensureRuntimeException(t);
        }
        finally {
            if (cRecovered > 0 && this.isIndexed() && this.getDaemonPool().isStarted()) {
                this.scheduleIndexUpdate(iPartition, 1);
            }
            if (fSuccess && ctrl.isDisabled()) {
                throw new PersistenceException("Persistence is disabled");
            }
        }
    }

    @Override
    public void recoverPartitions(PartitionedService.PartitionRecoverRequest.RecoverJob job, Map mapStoresFrom, Map mapStoresTo, PartitionSet partsFail, PartitionSet partsFailEvents) {
        Map mapGraveYard = this.getStorageGraveyard();
        SparseArray<String> laCaches = new SparseArray<String>();
        for (PersistentStore store : mapStoresTo.values()) {
            LongArray<String> laStoreCaches = CachePersistenceHelper.getCacheNames(store);
            Iterator crawler = laStoreCaches.iterator();
            while (crawler.hasNext()) {
                String sCache = (String)crawler.next();
                if (sCache == null) {
                    PartitionedCache._trace("Skipping unexpected cache name/id: " + sCache + "/" + crawler.getIndex() + " from store: " + String.valueOf(store), 3);
                    continue;
                }
                if (this.getStorage(sCache) != null || mapGraveYard.containsValue(sCache)) continue;
                laCaches.set(crawler.getIndex(), sCache);
            }
        }
        if (!laCaches.isEmpty()) {
            do {
                this.ensureStorage(laCaches);
            } while (!this.isStorageCreated(laCaches.iterator()));
        }
        super.recoverPartitions(job, mapStoresFrom, mapStoresTo, partsFail, partsFailEvents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerEvent(Object oEvent, Member memberOwner) {
        if (oEvent == null || memberOwner == null) {
            return;
        }
        if (oEvent instanceof MapEvent) {
            MapEvent msgEvent = (MapEvent)oEvent;
            long lEventSUID = msgEvent.getEventSUID();
            int nMember = memberOwner.getId();
            long lOldestSUID = msgEvent.getOldestPendingEventSUID();
            LongArray laPending = this.getPendingEvents();
            PartitionedCache._assert(lOldestSUID != -1L && lOldestSUID <= lEventSUID);
            LongArray longArray = laPending;
            synchronized (longArray) {
                PartitionedCache.removeSUIDRange(laPending, PartitionedCache.getBaseSUID(nMember), lOldestSUID, false);
                laPending.set(lEventSUID, msgEvent);
            }
        } else {
            Iterator iter = ((Collection)oEvent).iterator();
            while (iter.hasNext()) {
                this.registerEvent(iter.next(), memberOwner);
            }
        }
    }

    protected void registerMultiResult(RequestContext ctx, int nPartition, Map mapResults) {
        if (ctx != null) {
            this.ensureResultInfo(ctx).mergeResults(nPartition, mapResults);
        }
    }

    protected void registerMultiResult(RequestContext ctx, PartitionSet partsResults, Map mapResults) {
        if (ctx != null && !partsResults.isEmpty()) {
            this.ensureResultInfo(ctx).mergeResults(partsResults, mapResults);
        }
    }

    protected void registerSingleResult(RequestContext ctx, Binary binKey, Binary binResult) {
        if (ctx != null) {
            this.ensureResultInfo(ctx).mergeResults(this.getKeyPartition(binKey), Collections.singletonMap(binKey, binResult));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseAllCache() {
        PartitionedCache partitionedCache = this;
        synchronized (partitionedCache) {
            ScopedCacheReferenceStore store = this.getScopedCacheStore();
            for (ViewMap mapCache : store.getAllCaches()) {
                mapCache.invalidate(false);
            }
            store.clear();
            this.getReferencesBinaryMap().clear();
            this.getBinaryMapArray().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseAllStorage() {
        LongArray aStorage;
        this.setPartitionAssignments(new int[this.getPartitionCount()][1 + this.getBackupCount()]);
        LongArray longArray = aStorage = this.getStorageArray();
        synchronized (longArray) {
            Iterator iter = aStorage.iterator();
            while (iter.hasNext()) {
                ((Storage)iter.next()).invalidate();
            }
            aStorage.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseCache(NamedCache cache) {
        if (cache.getCacheService() != this) {
            throw new IllegalArgumentException("The cache to release is not owned by this service: " + String.valueOf(this));
        }
        ViewMap mapCache = (ViewMap)cache;
        if (mapCache.isActive()) {
            PartitionedCache partitionedCache = this;
            synchronized (partitionedCache) {
                ScopedCacheReferenceStore store = this.getScopedCacheStore();
                store.releaseCache(cache, mapCache.getClassLoader());
            }
            mapCache.invalidate(false);
        }
    }

    public void releaseInvocationContext(InvocationContext ctxInvoke) {
        ctxInvoke.release(true);
    }

    @Override
    protected void releasePartition(int iPartition, int iBackup) {
        super.releasePartition(iPartition, iBackup);
        for (Storage storage : this.getStorageArray()) {
            if (!storage.isValid()) continue;
            storage.releasePartition(iPartition, iBackup == 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Storage removeStorage(long lCacheId) {
        PartitionedCache._assert(this.isOwnershipEnabled());
        LongArray aStorage = this.getStorageArray();
        Storage storage = null;
        LongArray longArray = aStorage;
        synchronized (longArray) {
            storage = (Storage)aStorage.remove(lCacheId);
        }
        if (storage != null) {
            this.getStorageGraveyard().put(lCacheId, storage.getCacheName());
        }
        return storage;
    }

    public String reportPartitionContent(int iPartition) {
        StringBuilder sb = new StringBuilder();
        for (Storage storage : this.getStorageArray()) {
            if (!storage.isValid()) continue;
            sb.append('\n').append(storage.getCacheName()).append('{');
            for (Binary binKey : storage.collectKeySet(iPartition)) {
                try {
                    sb.append(ExternalizableHelper.fromBinary(binKey, this.getSerializer()));
                }
                catch (RuntimeException e) {
                    sb.append(e);
                }
                sb.append(", ");
            }
            sb.append('}');
        }
        if (this.isConcurrent()) {
            PartitionControl control = (PartitionControl)this.getPartitionControl(iPartition);
            sb.append('\n').append(control);
        }
        return sb.length() == 0 ? "" : sb.substring(1);
    }

    @Override
    public void resetStats() {
        this.getStatsIndexingTime().set(0L);
        super.resetStats();
        ServiceDispatcher dispatcher = this.getEventsHelper().getServiceDispatcher();
        if (dispatcher != null) {
            dispatcher.getStats().reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleBackup(int nPartition, long lCacheId, Binary binKey) {
        long lPendingBackupTotalSize;
        com.tangosol.coherence.component.util.DaemonPool pool = this.getDaemonPool();
        PartitionedCache._assert(pool.isStarted());
        PartitionControl ctrlPartition = (PartitionControl)this.getPartitionControl(nPartition);
        ConcurrentHashMap mapPendingBackupTotalSize = (ConcurrentHashMap)ctrlPartition.ensurePendingBackupTotalSize();
        if (mapPendingBackupTotalSize.get(lCacheId) == null) {
            mapPendingBackupTotalSize.put(lCacheId, 0L);
        }
        if ((lPendingBackupTotalSize = ((Long)mapPendingBackupTotalSize.get(lCacheId)).longValue()) != Long.MAX_VALUE) {
            LongArray laPendingBackups = ctrlPartition.ensurePendingBackups();
            ConcurrentHashMap map = (ConcurrentHashMap)laPendingBackups.get(lCacheId);
            Storage storage = this.getStorage(lCacheId);
            PartitionAwareBackingMap mapPABM = storage.getPartitionAwareBackingMap();
            ConfigurableCacheMap mapCCM = (ConfigurableCacheMap)(mapPABM == null ? null : mapPABM.getPartitionMap(nPartition));
            if (mapCCM != null && lPendingBackupTotalSize > (long)(mapCCM.getUnits() * this.getScheduledBackupsThreshold() / 100)) {
                mapPendingBackupTotalSize.put(lCacheId, Long.MAX_VALUE);
                if (map == null) {
                    var15_13 = laPendingBackups;
                    synchronized (var15_13) {
                        map = (ConcurrentHashMap)laPendingBackups.get(lCacheId);
                        if (map != null) {
                            laPendingBackups.set(lCacheId, null);
                        }
                    }
                }
            } else {
                ConfigurableCacheMap.Entry entry;
                if (map == null) {
                    var15_13 = laPendingBackups;
                    synchronized (var15_13) {
                        map = (ConcurrentHashMap)laPendingBackups.get(lCacheId);
                        if (map == null) {
                            map = new ConcurrentHashMap();
                            laPendingBackups.set(lCacheId, map);
                        }
                    }
                }
                map.put(binKey, binKey);
                if (mapCCM != null && (entry = mapCCM.getCacheEntry(binKey)) != null) {
                    mapPendingBackupTotalSize.put(lCacheId, lPendingBackupTotalSize + (long)entry.getUnits());
                }
            }
            SendBackupsTask task = this.getSendBackupsTask();
            long cNextBackupMillis = 0L;
            CommonMonitor oMonitor = Base.getCommonMonitor(System.identityHashCode(this));
            if (task == null) {
                CommonMonitor commonMonitor = oMonitor;
                synchronized (commonMonitor) {
                    task = this.getSendBackupsTask();
                    if (task == null) {
                        task = (SendBackupsTask)this._newChild("SendBackupsTask");
                        this.setSendBackupsTask(task);
                        cNextBackupMillis = this.getAsyncBackupInterval();
                    }
                }
            }
            if (cNextBackupMillis > 0L) {
                pool.schedule(task, cNextBackupMillis);
            }
        }
    }

    protected void scheduleBackups(Collection colStatus) {
        for (Storage.EntryStatus status : colStatus) {
            Binary binKey = status.getKey();
            this.scheduleBackup(status.getPartition(), status.getStorage().getCacheId(), status.getKey());
        }
    }

    public void scheduleIndexUpdate(int nPartition, int nEventId) {
        this.scheduleIndexUpdate(nPartition, nEventId, null);
    }

    public void scheduleIndexUpdate(int nPartition, int nEventId, Map mapUpdate) {
        this.updatePendingIndexPartition(nPartition, true);
        UpdateIndexRequest msg = (UpdateIndexRequest)this.instantiateMessage("UpdateIndexRequest");
        msg.setPartition(nPartition);
        msg.setEventId(nEventId);
        msg.setUpdateMap(mapUpdate);
        msg.addToMember(this.getThisMember());
        int cUpdates = this.getIndexUpdateCount();
        int cFair = Platform.getPlatform().getFairShareProcessors();
        if (cUpdates == 0) {
            this.setIndexingStartTime(Base.getSafeTimeMillis());
        }
        if (cUpdates < cFair) {
            this.setIndexUpdateCount(cUpdates + 1);
            this.post(msg);
        } else {
            this.getPendingIndexUpdate().add(msg);
        }
    }

    public void scheduleInitialIndexUpdate(int nPartition, int nEventId, Storage storage, ValueExtractor extractor, MapIndex index) {
        ConcurrentLinkedQueue queuePending;
        if (this.isPartitionIndexPending(nPartition) && (queuePending = this.getPendingIndexUpdate()) != null && !queuePending.isEmpty()) {
            for (UpdateIndexRequest msgPending : queuePending) {
                if (msgPending.getPartition() != nPartition) continue;
                Map mapPrev = msgPending.getUpdateMap();
                if (mapPrev == null) {
                    return;
                }
                CopyOnWriteMap<ValueExtractor, MapIndex> mapIndex = (CopyOnWriteMap<ValueExtractor, MapIndex>)mapPrev.get(storage);
                if (mapIndex == null) {
                    mapIndex = new CopyOnWriteMap<ValueExtractor, MapIndex>(HashMap.class);
                    mapPrev.put(storage, mapIndex);
                }
                mapIndex.put(extractor, index);
                if (!this.isPartitionIndexPending(nPartition)) break;
                return;
            }
        }
        CopyOnWriteMap<ValueExtractor, MapIndex> mapIndex = new CopyOnWriteMap<ValueExtractor, MapIndex>(HashMap.class);
        mapIndex.put(extractor, index);
        CopyOnWriteMap<Storage, CopyOnWriteMap<ValueExtractor, MapIndex>> mapUpdate = new CopyOnWriteMap<Storage, CopyOnWriteMap<ValueExtractor, MapIndex>>(HashMap.class);
        mapUpdate.put(storage, mapIndex);
        this.scheduleIndexUpdate(nPartition, nEventId, mapUpdate);
    }

    protected synchronized void scheduleLockEvaluation(long cMillis) {
        long lNext = cMillis == Long.MAX_VALUE ? cMillis : Base.getSafeTimeMillis() + cMillis;
        this.setLockingNextMillis(Math.min(this.getLockingNextMillis(), lNext));
    }

    protected ReadBuffer serializeStore(PersistentStore store) {
        BinaryWriteBuffer buf = new BinaryWriteBuffer(1024);
        PersistenceManager mgrEvents = this.getPersistenceControl().getEventsManager();
        if (mgrEvents != null) {
            try {
                mgrEvents.write(store.getId(), buf.getBufferOutput());
            }
            catch (IOException e) {
                PartitionedCache._trace("Unable to send previous MapEvents in " + String.valueOf(store) + " to new primary owner of partition.", 1);
                PartitionedCache._trace(e);
            }
            return buf.toBinary();
        }
        return null;
    }

    public void setAddedDaemons(int nDaemons) {
        this.__m_AddedDaemons = nDaemons;
    }

    protected void setBackingMapContext(BackingMapContext ctx) {
        this.__m_BackingMapContext = ctx;
    }

    @Override
    public synchronized void setBackingMapManager(BackingMapManager manager) {
        if (this.isRunning()) {
            throw new IllegalStateException("Service is already running");
        }
        this.__m_BackingMapManager = manager;
    }

    public void setBackupAllEnvelopeSize(AtomicInteger atomicSize) {
        this.__m_BackupAllEnvelopeSize = atomicSize;
    }

    protected void setBackupCountOpt(int cBackups) {
        this.__m_BackupCountOpt = cBackups;
    }

    protected void setBackupDeltaCompressor(DeltaCompressor compressor) {
        if (this.isAcceptingClients()) {
            throw new IllegalStateException("Service is already running");
        }
        this.__m_BackupDeltaCompressor = compressor;
    }

    public void setBackupSingleEnvelopeSize(AtomicInteger atomicSize) {
        this.__m_BackupSingleEnvelopeSize = atomicSize;
    }

    protected void setBinaryEntryConverter(com.tangosol.util.Converter convEntry) {
        this.__m_BinaryEntryConverter = convEntry;
    }

    protected void setBinaryMapArray(LongArray aBinMap) {
        this.__m_BinaryMapArray = aBinMap;
    }

    @Override
    public void setContextClassLoader(ClassLoader loader) {
        super.setContextClassLoader(loader);
        BackingMapContext ctx = this.getBackingMapContext();
        if (ctx != null) {
            ctx.setClassLoader(loader);
        }
        for (Storage storage : this.getStorageArray()) {
            storage.updateConverters();
        }
    }

    protected void setEventDeltaCompressor(DeltaCompressor compressor) {
        if (this.isAcceptingClients()) {
            throw new IllegalStateException("Service is already running");
        }
        this.__m_EventDeltaCompressor = compressor;
    }

    protected void setEventsHelper(EventsHelper evtHelper) {
        this.__m_EventsHelper = evtHelper;
    }

    public void setEventResendInterval(long ltMillis) {
        this.__m_EventResendInterval = ltMillis;
    }

    public void setIndexingStartTime(long lTime) {
        this.__m_IndexingStartTime = lTime;
    }

    protected void setIndexPendingPartitions(PartitionSet parts) {
        this.__m_IndexPendingPartitions = parts;
    }

    protected void setIndexProcessingPartitions(PartitionSet parts) {
        this.__m_IndexProcessingPartitions = parts;
    }

    public void setIndexUpdateCount(int nCount) {
        this.__m_IndexUpdateCount = nCount;
    }

    protected void setLazyLookupReadBuffer(LazyLookup lazyReadBuffer) {
        this.__m_LazyLookupReadBuffer = lazyReadBuffer;
    }

    protected void setLeaseGranularity(int nHeldBy) {
        this.__m_LeaseGranularity = nHeldBy;
    }

    public void setLockingNextMillis(long ltMillis) {
        this.__m_LockingNextMillis = ltMillis;
    }

    public void setOldestEventResendNextMillis(long ltMillis) {
        this.__m_OldestEventResendNextMillis = ltMillis;
    }

    protected void setPendingEvents(LongArray array) {
        this.__m_PendingEvents = array;
    }

    protected void setPendingIndexUpdate(ConcurrentLinkedQueue queueUpdate) {
        this.__m_PendingIndexUpdate = queueUpdate;
    }

    private void setPendingResultInfo(SparseArray[] aLa) {
        PartitionedCache._assert(this.getPendingResultInfo() == null);
        this.__m_PendingResultInfo = aLa;
    }

    protected void setProcessedEvents(LongArray map) {
        this.__m_ProcessedEvents = map;
    }

    protected void setReferencesBinaryMap(Map map) {
        this.__m_ReferencesBinaryMap = map;
    }

    protected void setRequestCoordinator(RequestCoordinator coordinator) {
        this.__m_RequestCoordinator = coordinator;
    }

    protected void setResourceCoordinator(ResourceCoordinator ctrlResource) {
        this.__m_ResourceCoordinator = ctrlResource;
    }

    public void setScheduledBackupsThreshold(int nThreshold) {
        this.__m_ScheduledBackupsThreshold = nThreshold;
    }

    public void setMaxPartialResponseSize(MemorySize size) {
        this.__m_MaxPartialResponseSize = size;
    }

    protected void setScopedCacheStore(ScopedCacheReferenceStore store) {
        this.__m_ScopedCacheStore = store;
    }

    public void setSendBackupsTask(SendBackupsTask taskBackups) {
        this.__m_SendBackupsTask = taskBackups;
    }

    protected void setStandardLeaseMillis(long cMillis) {
        this.__m_StandardLeaseMillis = Math.max(0L, cMillis);
    }

    public void setStatsIndexingTime(AtomicLong atomicTime) {
        this.__m_StatsIndexingTime = atomicTime;
    }

    protected void setStorageArray(LongArray aStorage) {
        this.__m_StorageArray = aStorage;
    }

    public void setStorageGraveyard(Map pStorageGraveyard) {
        this.__m_StorageGraveyard = pStorageGraveyard;
    }

    protected void setStrictPartitioning(boolean fStrict) {
        this.__m_StrictPartitioning = fStrict;
    }

    public void setTaskSplitThreshold(int nThreshold) {
        this.__m_TaskSplitThreshold = nThreshold;
    }

    public void setTLOContext(ThreadLocal localContext) {
        this.__m_TLOContext = localContext;
    }

    @Override
    public void snapshotPartition(int iPartition, PersistentStore store, Object oToken) {
        this.ensurePersistentExtents(store, true);
        BackingMapManager manager = this.getBackingMapManager();
        for (Storage storage : this.getStorageArray()) {
            if (!storage.isValid() || !manager.isBackingMapPersistent(storage.getCacheName(), true)) continue;
            storage.snapshotPartition(iPartition, store, oToken);
        }
        super.snapshotPartition(iPartition, store, oToken);
    }

    public Map splitEntryStatusByOwner(Iterator iterStatus, int iStore, boolean fIgnoreUnchanged) {
        LiteMap mapByOwner = null;
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        int cPartitions = this.getPartitionCount();
        int[][] aaiOwner = this.getPartitionAssignments();
        while (iterStatus.hasNext()) {
            LiteSet<Storage.EntryStatus> setMember;
            Storage.EntryStatus status = (Storage.EntryStatus)iterStatus.next();
            if (fIgnoreUnchanged && !status.isAnyAction()) continue;
            Binary binKey = status.getKey();
            int iPartition = this.getKeyPartition(binKey);
            int nOwner = aaiOwner[iPartition][iStore];
            Member member = nOwner > 0 && !setMembers.isServiceLeaving(nOwner) ? setMembers.getMember(nOwner) : null;
            LiteSet<Storage.EntryStatus> liteSet = setMember = mapByOwner != null ? (LiteSet<Storage.EntryStatus>)mapByOwner.get(member) : null;
            if (setMember == null) {
                setMember = new LiteSet<Storage.EntryStatus>();
                if (mapByOwner == null) {
                    mapByOwner = new LiteMap();
                }
                mapByOwner.put(member, setMember);
            }
            setMember.add(status);
        }
        return mapByOwner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void transferPartition(int iPartition, int iStore, boolean fLastInTransfer) {
        boolean fInterceptor;
        this.processChanges();
        super.transferPartition(iPartition, iStore, fLastInTransfer);
        TransferControl control = (TransferControl)this.getTransferControl();
        LongArray aStorage = this.getStorageArray();
        VersionedOwnership owners = this.getPartitionConfig(iPartition);
        PartitionControl ctrlPartition = (PartitionControl)this.getPartitionControl(iPartition);
        long lVersion = ctrlPartition.getVersionCounter().get();
        EventsHelper evtHelper = this.getEventsHelper();
        boolean fPrimary = iStore == 0;
        boolean bl = fInterceptor = fPrimary && evtHelper.hasServiceInterceptors(TransferEvent.Type.DEPARTING);
        if (aStorage.isEmpty()) {
            TransferRequest msgTransfer = (TransferRequest)this.instantiateMessage("TransferRequest");
            msgTransfer.setPartition(iPartition);
            msgTransfer.setPartitionVersion(lVersion);
            msgTransfer.setStore(iStore);
            msgTransfer.setOwners(owners);
            msgTransfer.setCacheId(-1L);
            msgTransfer.setResource(new Map.Entry[0]);
            msgTransfer.setLease(new Lease[0]);
            msgTransfer.setListener(new Map.Entry[0]);
            msgTransfer.setPendingResults(this.collectPendingResults(iPartition));
            msgTransfer.setPendingEvents(this.collectPendingEvents(iPartition));
            msgTransfer.setLastInPartition(true);
            msgTransfer.setLastInTransfer(fLastInTransfer |= control.recordTransfer(msgTransfer, 1L));
            control.onTransmitCommitted(msgTransfer);
            if (fInterceptor) {
                evtHelper.onEntriesDeparting(Collections.singletonList(msgTransfer), this.getContinuations().instantiateMessagePost(msgTransfer));
            } else {
                this.post(msgTransfer);
            }
        } else {
            ArrayList<TransferRequest> listTransfer = fInterceptor ? new ArrayList<TransferRequest>(aStorage.getSize()) : null;
            Iterator iterStore = aStorage.iterator();
            while (iterStore.hasNext()) {
                Storage storage = (Storage)iterStore.next();
                ArrayList<SimpleMapEntry<Binary, ReadBuffer>> listResource = new ArrayList<SimpleMapEntry<Binary, ReadBuffer>>();
                int cbResource = 0;
                ConfigurableCacheMap.EvictionApprover approver = null;
                ConfigurableCacheMap mapCCM = storage.getConfigurableCacheMap(iPartition);
                Map mapPendingBackups = fPrimary && this.isScheduledBackups() && ctrlPartition.hasScheduledBackups() ? (Map)ctrlPartition.getPendingBackups().get(storage.getCacheId()) : Collections.emptyMap();
                try {
                    if (mapCCM != null) {
                        approver = mapCCM.getEvictionApprover();
                        mapCCM.setEvictionApprover(ConfigurableCacheMap.EvictionApprover.DISAPPROVER);
                    }
                    for (Binary binKey : storage.collectKeySet(iPartition)) {
                        ReadBuffer bufValue = storage.getValueForTransfer(binKey, false);
                        if (mapPendingBackups.containsKey(binKey)) {
                            bufValue = ExternalizableHelper.decorate(bufValue == null ? Binary.EMPTY : bufValue, 5, (ReadBuffer)Binary.TRUE);
                        }
                        if (bufValue == null) continue;
                        cbResource += binKey.length() + bufValue.length();
                        listResource.add(new SimpleMapEntry<Binary, ReadBuffer>(binKey, bufValue));
                    }
                }
                finally {
                    if (mapCCM != null) {
                        mapCCM.setEvictionApprover(approver);
                    }
                }
                ArrayList<Lease> listLease = new ArrayList<Lease>();
                int cbLease = 0;
                Map mapLease = storage.getLeaseMap();
                while (!mapLease.isEmpty()) {
                    try {
                        for (Lease lease : mapLease.values()) {
                            Binary binKey = (Binary)lease.getResourceKey();
                            if (this.getKeyPartition(binKey) != iPartition) continue;
                            cbLease += binKey.length() + 28;
                            listLease.add(lease);
                        }
                        break;
                    }
                    catch (ConcurrentModificationException e) {
                        listLease.clear();
                        cbLease = 0;
                    }
                }
                ArrayList listListen = new ArrayList();
                int cbListen = 0;
                Map mapListen = storage.getKeyListenerMap();
                while (mapListen != null && !mapListen.isEmpty()) {
                    try {
                        for (Map.Entry entry : mapListen.entrySet()) {
                            Binary binKey = (Binary)entry.getKey();
                            if (this.getKeyPartition(binKey) != iPartition) continue;
                            cbListen += binKey.length() + ((Map)entry.getValue()).size() * 8;
                            listListen.add(entry);
                        }
                        break;
                    }
                    catch (ConcurrentModificationException e) {
                        listListen.clear();
                        cbListen = 0;
                    }
                }
                int cbTransfer = cbResource + cbLease + cbListen;
                boolean fLastInPart = !iterStore.hasNext();
                TransferRequest msgTransfer = (TransferRequest)this.instantiateMessage("TransferRequest");
                msgTransfer.setPartition(iPartition);
                msgTransfer.setPartitionVersion(lVersion);
                msgTransfer.setStore(iStore);
                msgTransfer.setOwners(owners);
                msgTransfer.setCacheId(storage.getCacheId());
                msgTransfer.setCacheName(storage.getCacheName());
                msgTransfer.setResource(listResource.toArray(new Map.Entry[listResource.size()]));
                msgTransfer.setLease(listLease.toArray(new Lease[listLease.size()]));
                msgTransfer.setListener(listListen.toArray(new Map.Entry[listListen.size()]));
                msgTransfer.setMapEventVersion(storage.getVersion().getSubmittedVersion(iPartition));
                msgTransfer.setLastInPartition(fLastInPart);
                msgTransfer.setLastInTransfer(fLastInPart && (fLastInTransfer |= control.recordTransfer(msgTransfer, cbTransfer)));
                if (fLastInPart) {
                    msgTransfer.setPendingResults(this.collectPendingResults(iPartition));
                    msgTransfer.setPendingEvents(this.collectPendingEvents(iPartition));
                    if (fPrimary && this.isPersistEvents()) {
                        msgTransfer.setEventsStoreBinary(this.serializeStore(ctrlPartition.getPersistentEventsStore()));
                    }
                    control.onTransmitCommitted(msgTransfer);
                }
                if (fInterceptor) {
                    listTransfer.add(msgTransfer);
                    if (!fLastInPart) continue;
                    evtHelper.onEntriesDeparting(listTransfer, this.getContinuations().instantiateMessagePost(listTransfer));
                    continue;
                }
                this.post(msgTransfer);
            }
        }
    }

    public void truncatePersistentExtent(Storage storage) {
        if (this.getPersistenceManager() != null && storage.isPersistent()) {
            long lCacheId = storage.getCacheId();
            PartitionSet parts = this.calculatePartitionSet(this.getThisMember(), 0);
            int iPart = parts.next(0);
            while (iPart >= 0) {
                this.getPartitionControl(iPart).truncatePersistentExtent(lCacheId);
                iPart = parts.next(iPart + 1);
            }
        }
    }

    public void unlockKey(Storage storage, Binary binKey, boolean fExit) {
        this.getResourceCoordinator().unlock(storage, binKey);
        if (fExit) {
            this.exitPartition(this.getKeyPartition(binKey));
        }
    }

    protected void unlockKeys(Storage storage, Object[] aEntry, int ofStart, int ofEnd, boolean fExit) {
        for (int i = ofStart; i < ofEnd; ++i) {
            Object entry = aEntry[i];
            if (entry == null) continue;
            Binary binKey = entry instanceof Storage.BinaryEntry ? ((Storage.BinaryEntry)entry).getBinaryKey() : (Binary)entry;
            this.unlockKey(storage, binKey, fExit);
        }
    }

    protected void unlockSynthetic(Storage storage) {
        this.getResourceCoordinator().unlock(storage, new Binary());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEvent(MapEvent msgEvent) {
        LongArray laPending;
        LongArray longArray = laPending = this.getPendingEvents();
        synchronized (longArray) {
            laPending.remove(msgEvent.getEventSUID());
        }
    }

    public void updateIndexBuildTime() {
        this.getStatsIndexingTime().getAndAdd(Base.getSafeTimeMillis() - this.getIndexingStartTime());
        this.setIndexingStartTime(0L);
    }

    public synchronized void updatePendingIndexPartition(int nPartition, boolean fAdd) {
        PartitionSet parts = this.getIndexPendingPartitions();
        if (fAdd ^ parts.contains(nPartition)) {
            parts = new PartitionSet(parts);
            if (fAdd) {
                parts.add(nPartition);
            } else {
                parts.remove(nPartition);
            }
            this.setIndexPendingPartitions(parts);
        }
    }

    public synchronized void updateProcessingIndexPartition(int nPartition, boolean fAdd) {
        PartitionSet parts = this.getIndexProcessingPartitions();
        if (fAdd ^ parts.contains(nPartition)) {
            parts = new PartitionSet(parts);
            if (fAdd) {
                parts.add(nPartition);
            } else {
                parts.remove(nPartition);
            }
            this.setIndexProcessingPartitions(parts);
        }
    }

    @Override
    public void validatePartitionAssignments(MemberSet setOwners) {
        super.validatePartitionAssignments(setOwners);
        this.getRequestCoordinator().syncAssignments();
    }

    @Override
    protected boolean validatePartitionConfig() {
        boolean fSuccess = super.validatePartitionConfig();
        if (fSuccess) {
            this.getRequestCoordinator().syncAssignments();
        }
        return fSuccess;
    }

    public void validatePartitionedContent() {
        for (Storage storage : this.getStorageArray()) {
            if (!storage.isValid()) continue;
            storage.validatePartitionedContent(true, false);
            storage.validatePartitionedContent(false, false);
        }
    }

    protected Storage validateRequestForStorage(RequestMessage msgRequest, Message msgResponse, boolean fEnsureSupport) {
        Exception exception = null;
        long lCacheId = 0L;
        if (msgRequest instanceof DistributedCacheKeyRequest) {
            lCacheId = ((DistributedCacheKeyRequest)msgRequest).getCacheId();
        } else {
            DistributedCacheRequest cacheReq = (DistributedCacheRequest)msgRequest;
            Exception exception2 = exception = fEnsureSupport ? this.ensureSupport(cacheReq, "InvocableMap") : cacheReq.getReadException();
            if (exception == null) {
                lCacheId = cacheReq.getCacheId();
            }
        }
        if (exception == null) {
            Storage storage = this.getStorage(lCacheId);
            if (storage == null) {
                String sCache = (String)this.getStorageGraveyard().get(lCacheId);
                exception = new RequestPolicyException("The reference to " + (String)(sCache == null ? "the cache" : "cache \"" + sCache + "\"") + " has been released");
            } else {
                TracingHelper.augmentSpan().setMetadata("cache", storage.getCacheName());
                return storage;
            }
        }
        if (msgResponse instanceof DistributedPartialResponse) {
            ((DistributedPartialResponse)msgResponse).setException(this.tagException(exception));
        } else if (msgResponse instanceof Grid.Response) {
            ((Grid.Response)msgResponse).setValue(this.tagException(exception));
        }
        this.post(msgResponse);
        return null;
    }

    @Override
    protected boolean validateServiceConfig() {
        boolean fSuccess = super.validateServiceConfig();
        this.getRequestCoordinator().initialize();
        return fSuccess;
    }

    @Override
    protected boolean validateServiceConfig(XmlElement xmlConfig) {
        String sCompressor = this.getEventDeltaCompressor().getClass().getName();
        return super.validateServiceConfig(xmlConfig) && this.verifyFeature("BinaryDelta", sCompressor, xmlConfig.getSafeAttribute("delta-compressor").getString());
    }

    protected void validateStorages(Member memberLeft) {
        for (Storage storage : this.getStorageArray()) {
            if (!storage.isValid()) continue;
            storage.validateLocks();
            storage.validateListeners();
        }
    }

    static {
        PartitionedCache.__initStatic();
    }

    public static class AggregateAllRequest
    extends KeySetRequest {
        private transient InvocableMap.EntryAggregator __m_Aggregator;
        private Binary __m_AggregatorBinary;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public AggregateAllRequest() {
            this(null, null, true);
        }

        public AggregateAllRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(51);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new AggregateAllRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$AggregateAllRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            AggregateAllRequest msg = (AggregateAllRequest)super.cloneMessage();
            msg.setAggregatorBinary(this.getAggregatorBinary());
            return msg;
        }

        public InvocableMap.EntryAggregator deserializeAggregator() {
            InvocableMap.EntryAggregator aggregator = this.getAggregator();
            if (aggregator == null) {
                aggregator = (InvocableMap.EntryAggregator)ExternalizableHelper.fromBinary(this.getAggregatorBinary(), this.getService().getSerializer());
                this.setAggregator(aggregator);
            }
            return aggregator;
        }

        public InvocableMap.EntryAggregator getAggregator() {
            return this.__m_Aggregator;
        }

        public Binary getAggregatorBinary() {
            return this.__m_AggregatorBinary;
        }

        @Override
        public String getDescription() {
            return super.getDescription() + ", Aggregator=" + String.valueOf(this.getAggregator());
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setAggregatorBinary((Binary)this.readObject(input));
            this.readTracing(input);
        }

        @Override
        public void run() {
            ((PartitionedCache)this.getService()).onAggregateAllRequest(this);
        }

        public void setAggregator(InvocableMap.EntryAggregator agent) {
            this.__m_Aggregator = agent;
        }

        public void setAggregatorBinary(Binary binAgent) {
            this.__m_AggregatorBinary = binAgent;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            this.writeObject(output, this.getAggregatorBinary());
            this.writeTracing(output);
        }

        static {
            AggregateAllRequest.__initStatic();
        }

        public static class Poll
        extends KeySetRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            @Override
            public boolean isPreprocessable() {
                return true;
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$AggregateAllRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected void processAsyncResponse(Message msg) {
                AggregateAllRequest msgRequest = (AggregateAllRequest)this.get_Parent();
                AsyncAggregatorContext context = (AsyncAggregatorContext)msgRequest.getRequestContext();
                PartialValueResponse msgResponse = (PartialValueResponse)msg;
                if (msgResponse.getException() == null) {
                    Object oResult = msgResponse.getResult();
                    if (oResult != null) {
                        if (msgResponse.isCollection()) {
                            Iterator iter = ((Collection)oResult).iterator();
                            while (iter.hasNext()) {
                                context.processPartialResult(iter.next());
                            }
                        } else {
                            context.processPartialResult(oResult);
                        }
                    }
                } else {
                    context.processException(msgResponse.getException());
                }
            }
        }
    }

    public static class AggregateFilterRequest
    extends FilterRequest {
        private transient InvocableMap.EntryAggregator __m_Aggregator;
        private Binary __m_AggregatorBinary;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public AggregateFilterRequest() {
            this(null, null, true);
        }

        public AggregateFilterRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(52);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new AggregateFilterRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$AggregateFilterRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            AggregateFilterRequest msg = (AggregateFilterRequest)super.cloneMessage();
            msg.setAggregatorBinary(this.getAggregatorBinary());
            return msg;
        }

        public InvocableMap.EntryAggregator deserializeAggregator() {
            InvocableMap.EntryAggregator aggregator = this.getAggregator();
            if (aggregator == null) {
                aggregator = (InvocableMap.EntryAggregator)ExternalizableHelper.fromBinary(this.getAggregatorBinary(), this.getService().getSerializer());
                this.setAggregator(aggregator);
            }
            return aggregator;
        }

        public InvocableMap.EntryAggregator getAggregator() {
            return this.__m_Aggregator;
        }

        public Binary getAggregatorBinary() {
            return this.__m_AggregatorBinary;
        }

        @Override
        public String getDescription() {
            return super.getDescription() + ", Aggregator=" + String.valueOf(this.getAggregator()) + ", Filter=" + String.valueOf(this.getFilter());
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            if (this.getReadException() == null) {
                this.setAggregatorBinary((Binary)this.readObject(input));
                this.readTracing(input);
            }
        }

        @Override
        public void run() {
            ((PartitionedCache)this.getService()).onAggregateFilterRequest(this);
        }

        @Override
        public void runCanceled(boolean fAbandoned) {
            InvocableMap.EntryAggregator agent = this.getAggregator();
            if (agent instanceof PriorityTask) {
                ((PriorityTask)((Object)agent)).runCanceled(fAbandoned);
            } else {
                super.runCanceled(fAbandoned);
            }
        }

        public void setAggregator(InvocableMap.EntryAggregator agent) {
            this.__m_Aggregator = agent;
        }

        public void setAggregatorBinary(Binary binAgent) {
            this.__m_AggregatorBinary = binAgent;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            this.writeObject(output, this.getAggregatorBinary());
            this.writeTracing(output);
        }

        static {
            AggregateFilterRequest.__initStatic();
        }

        public static class Poll
        extends PartialRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            @Override
            public boolean isPreprocessable() {
                return true;
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$AggregateFilterRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public void processAsyncResponse(Message msg) {
                AggregateFilterRequest msgRequest = (AggregateFilterRequest)this.get_Parent();
                AsyncAggregatorContext context = (AsyncAggregatorContext)msgRequest.getRequestContext();
                PartialValueResponse msgResponse = (PartialValueResponse)msg;
                if (msgResponse.getException() == null) {
                    Object oResult = msgResponse.getResult();
                    if (oResult != null) {
                        if (msgResponse.isCollection()) {
                            Iterator iter = ((Collection)oResult).iterator();
                            while (iter.hasNext()) {
                                context.processPartialResult(iter.next());
                            }
                        } else {
                            context.processPartialResult(oResult);
                        }
                    }
                } else {
                    context.processException(msgResponse.getException());
                }
            }
        }
    }

    public static class BackingMapContext
    extends BackingMapManagerContext {
        private transient ConverterFromBinary __m_FromBinaryConverter;
        private transient PartitionedService.ConverterKeyToBinary __m_KeyToBinaryConverter;
        private transient ConverterValueToBinary __m_ValueToBinaryConverter;

        public BackingMapContext() {
            this(null, null, true);
        }

        public BackingMapContext(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new BackingMapContext();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$BackingMapContext".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public Map getBackingMap(String sCacheName) {
            Storage storage = ((PartitionedCache)this.get_Module()).getStorage(sCacheName);
            return storage == null ? null : storage.getBackingMap();
        }

        @Override
        public com.tangosol.net.BackingMapContext getBackingMapContext(String sCacheName) {
            return ((PartitionedCache)this.get_Module()).getStorage(sCacheName);
        }

        public ConverterFromBinary getFromBinaryConverter() {
            return this.__m_FromBinaryConverter;
        }

        @Override
        public com.tangosol.util.Converter getKeyFromInternalConverter() {
            return this.getFromBinaryConverter();
        }

        @Override
        public int getKeyPartition(Object oKey) {
            return ((PartitionedCache)this.get_Module()).getKeyPartition((Binary)oKey);
        }

        public PartitionedService.ConverterKeyToBinary getKeyToBinaryConverter() {
            PartitionedService.ConverterKeyToBinary converter = this.__m_KeyToBinaryConverter;
            if (converter == null) {
                converter = this.getService().getKeyToBinaryConverter();
                this.setKeyToBinaryConverter(converter);
            }
            return converter;
        }

        @Override
        public com.tangosol.util.Converter getKeyToInternalConverter() {
            return this.getKeyToBinaryConverter();
        }

        @Override
        public Set getPartitionKeys(String sCacheName, int nPartition) {
            Storage storage = ((PartitionedCache)this.get_Module()).getStorage(sCacheName);
            return storage == null ? null : storage.getPartitionKeys(nPartition);
        }

        public PartitionedCache getService() {
            return (PartitionedCache)this.get_Module();
        }

        @Override
        public com.tangosol.util.Converter getValueFromInternalConverter() {
            return this.getFromBinaryConverter();
        }

        public ConverterValueToBinary getValueToBinaryConverter() {
            return this.__m_ValueToBinaryConverter;
        }

        @Override
        public com.tangosol.util.Converter getValueToInternalConverter() {
            return this.getValueToBinaryConverter();
        }

        @Override
        public boolean isKeyOwned(Object oKey) {
            return this.getService().isPrimaryOwner((Binary)oKey);
        }

        @Override
        public void onInit() {
            this.setConfigKey(64);
            this.setClassLoader(this.getService().getContextClassLoader());
            super.onInit();
        }

        @Override
        public synchronized void setClassLoader(ClassLoader loader) {
            super.setClassLoader(loader);
            PartitionedCache service = this.getService();
            this.setFromBinaryConverter(service.instantiateFromBinaryConverter(loader));
            this.setValueToBinaryConverter(service.instantiateValueToBinaryConverter(loader));
        }

        protected void setFromBinaryConverter(ConverterFromBinary conv) {
            this.__m_FromBinaryConverter = conv;
        }

        public void setKeyToBinaryConverter(PartitionedService.ConverterKeyToBinary pKeyToBinaryConverter) {
            this.__m_KeyToBinaryConverter = pKeyToBinaryConverter;
        }

        @Override
        public void setManager(BackingMapManager manager) {
            super.setManager(manager);
            manager.init(this);
        }

        protected void setValueToBinaryConverter(ConverterValueToBinary conv) {
            this.__m_ValueToBinaryConverter = conv;
        }

        @Override
        public String toString() {
            return super.toString() + "@" + this.hashCode();
        }
    }

    public static class BackupAllRequest
    extends BackupMultiRequest {
        private transient BatchContext __m_BatchContext;
        private long __m_CacheId;
        private Map __m_EventHolderMap;
        private Map __m_Map;
        private Map __m_MapEventVersions;
        public static final int MESSAGE_TYPE = 53;
        private Map __m_ResultMap;
        private long __m_ResultsCacheId;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public BackupAllRequest() {
            this(null, null, true);
        }

        public BackupAllRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(53);
                this.setPartitionVersions(new PrimitiveSparseArray());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new BackupAllRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$BackupAllRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            BackupAllRequest msg = (BackupAllRequest)super.cloneMessage();
            msg.setCacheId(this.getCacheId());
            msg.setResultsCacheId(this.getResultsCacheId());
            msg.setBatchContext(this.getBatchContext());
            msg.setMap(this.getMap());
            msg.setResultMap(this.getResultMap());
            msg.setEventHolderMap(this.getEventHolderMap());
            msg.setMapEventVersions(this.getMapEventVersions());
            return msg;
        }

        @Override
        public void doBackup(PartitionSet partsSkip) {
            ((PartitionedCache)this.getService()).onBackupAllRequest(this, partsSkip);
        }

        public int estimateCacheBackupByteSize(Map mapEntries, Map mapEvents, Map mapResults) {
            int PINT_SIZE = 5;
            int BIN_SIZE = 5;
            boolean BYTE_SIZE = true;
            int cEntries = mapEntries.size();
            int cEvents = mapEvents == null ? 0 : mapEvents.size();
            int cResults = mapResults == null ? 0 : mapResults.size();
            int cb = 15;
            for (Map.Entry entry : mapEntries.entrySet()) {
                Binary binKey = (Binary)entry.getKey();
                ReadBuffer binVal = (ReadBuffer)entry.getValue();
                if (binKey != null) {
                    cb += binKey.length() + 5;
                }
                cb += binVal == null ? 1 : binVal.length() + 5;
                if (cEvents > 0) {
                    Object oEventHolder = mapEvents.get(binKey);
                    cb += ((PartitionedCache)this.getService()).estimateEventHolderByteSize(oEventHolder);
                }
                if (cResults <= 0) continue;
                Binary binResult = (Binary)mapResults.get(binKey);
                cb += binResult == null ? 1 : binResult.length() + 5;
            }
            return cb;
        }

        public BatchContext getBatchContext() {
            return this.__m_BatchContext;
        }

        public long getCacheId() {
            return this.__m_CacheId;
        }

        @Override
        public String getDescription() {
            PartitionedCache service = (PartitionedCache)this.getService();
            Object sCacheData = "";
            long lCacheId = this.getCacheId();
            Map<Long, Map> mapCacheData = lCacheId != -1L ? Collections.singletonMap(lCacheId, this.getMap()) : this.getMap();
            String sDelimiter = "";
            for (Map.Entry<Long, Map> entry : mapCacheData.entrySet()) {
                String sCacheName = service.getCacheName(entry.getKey());
                sCacheData = (String)sCacheData + sDelimiter + sCacheName + "(" + entry.getValue().size() + ")";
                sDelimiter = ", ";
            }
            return super.getDescription() + "\nData = " + (String)sCacheData;
        }

        @Override
        public int getEstimatedByteSize() {
            Map mapEventVersions;
            int cCaches;
            int PLONG_SIZE = 10;
            int PINT_SIZE = 5;
            int BIN_SIZE = 5;
            boolean BYTE_SIZE = true;
            int cb = ((PartitionedCache)this.getService()).getBackupAllEnvelopeSize().get();
            int cParts = this.getPartitionVersions().getSize();
            cb += cParts * 15;
            PartitionedCache service = (PartitionedCache)this.getService();
            long lCacheId = this.getCacheId();
            Map mapEntries = this.getMap();
            Map mapEvents = this.getEventHolderMap();
            Map mapResults = this.getResultMap();
            if (lCacheId == -1L) {
                Set setCacheIds = mapEntries.keySet();
                long lResultsCacheId = this.getResultsCacheId();
                cb += 15;
                for (Long LCacheIdCur : setCacheIds) {
                    cb += 10;
                    cb += this.estimateCacheBackupByteSize((Map)mapEntries.get(LCacheIdCur), mapEvents == null ? null : (Map)mapEvents.get(LCacheIdCur), LCacheIdCur == lResultsCacheId ? mapResults : null);
                }
            } else {
                cb += this.estimateCacheBackupByteSize(mapEntries, mapEvents, mapResults);
            }
            int n = cCaches = (mapEventVersions = this.getMapEventVersions()) == null ? 0 : mapEventVersions.size();
            if (cCaches > 0) {
                VersionedPartitions versions = (VersionedPartitions)mapEventVersions.values().iterator().next();
                int cClass = 5 + versions.getClass().getName().length();
                int cObject = 1 + cClass + 5;
                cb += cCaches * ((cCaches == 1 ? 0 : 10) + cObject + cParts * 15);
            }
            return cb;
        }

        public Map getEventHolderMap() {
            return this.__m_EventHolderMap;
        }

        public Map getMap() {
            return this.__m_Map;
        }

        public Map getMapEventVersions() {
            return this.__m_MapEventVersions;
        }

        public Map getResultMap() {
            return this.__m_ResultMap;
        }

        public long getResultsCacheId() {
            return this.__m_ResultsCacheId;
        }

        @Override
        public void onRequestCompleted() {
            if (this.isSyncMsg()) {
                this.getBatchContext().onBackupCompleted(this);
            }
            PartitionedCache service = (PartitionedCache)this.getService();
            PrimitiveSparseArray.Iterator iter = this.getPartitionVersions().iterator();
            while (iter.hasNext()) {
                iter.nextPrimitive();
                PartitionControl control = (PartitionControl)service.getPartitionControl((int)iter.getIndex());
                if (control == null) continue;
                control.finishBackup(iter.getPrimitiveValue());
            }
            super.onRequestCompleted();
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            long lCacheId = ExternalizableHelper.readLong(input);
            this.setCacheId(lCacheId);
            HashMap mapEntries = new HashMap();
            HashMap mapEvents = new HashMap();
            HashMap mapResults = new HashMap();
            if (lCacheId == -1L) {
                long lResultsCacheId = ExternalizableHelper.readLong(input);
                this.setResultsCacheId(lResultsCacheId);
                int cCaches = ExternalizableHelper.readInt(input);
                for (int i = 0; i < cCaches; ++i) {
                    HashMap mapCacheEntries = new HashMap();
                    HashMap mapCacheEvents = new HashMap();
                    long lCacheIdCur = ExternalizableHelper.readLong(input);
                    Long LCacheIdCur = lCacheIdCur;
                    this.readCacheBackup(input, mapCacheEntries, mapCacheEvents, lCacheIdCur == lResultsCacheId ? mapResults : null);
                    mapEntries.put(LCacheIdCur, mapCacheEntries);
                    if (mapCacheEvents.isEmpty()) continue;
                    mapEvents.put(LCacheIdCur, mapCacheEvents);
                }
            } else {
                this.readCacheBackup(input, mapEntries, mapEvents, mapResults);
                if (mapEvents.isEmpty()) {
                    mapEvents = null;
                }
            }
            this.readTracing(input);
            Map mapEventVersions = Collections.emptyMap();
            if (input.available() > 0) {
                int cCaches = ExternalizableHelper.readInt(input);
                if (cCaches > 1) {
                    mapEventVersions = new HashMap(cCaches);
                    for (int i = 0; i < cCaches; ++i) {
                        mapEventVersions.put(ExternalizableHelper.readLong(input), ExternalizableHelper.readObject(input));
                    }
                } else if (cCaches == 1) {
                    BackupAllRequest._assert(lCacheId != -1L);
                    mapEventVersions = Collections.singletonMap(lCacheId, ExternalizableHelper.readObject(input));
                }
            }
            this.setMap(mapEntries);
            this.setEventHolderMap(mapEvents);
            this.setResultMap(mapResults);
            this.setMapEventVersions(mapEventVersions);
        }

        protected void readCacheBackup(ReadBuffer.BufferInput input, Map mapEntries, Map mapEvents, Map mapResults) throws IOException {
            int cEntries = ExternalizableHelper.readInt(input);
            int cEvents = ExternalizableHelper.readInt(input);
            int cResults = ExternalizableHelper.readInt(input);
            PartitionedCache service = (PartitionedCache)this.getService();
            for (int i = 0; i < cEntries; ++i) {
                Object binResult;
                Object oHolder;
                Object binKey = ExternalizableHelper.readObject(input);
                Object binVal = ExternalizableHelper.readObject(input);
                mapEntries.put(binKey, binVal);
                if (cEvents > 0 && (oHolder = MapEventMessage.readSupplemental(input, service)) != null) {
                    mapEvents.put(binKey, oHolder);
                }
                if (cResults <= 0 || (binResult = this.readObject(input)) == null) continue;
                mapResults.put(binKey, binResult);
            }
        }

        public void setBatchContext(BatchContext contextBatch) {
            this.__m_BatchContext = contextBatch;
        }

        public void setCacheId(long lId) {
            this.__m_CacheId = lId;
        }

        public void setEventHolderMap(Map mapEvents) {
            this.__m_EventHolderMap = mapEvents;
        }

        public void setMap(Map map) {
            this.__m_Map = map;
        }

        public void setMapEventVersions(Map map) {
            this.__m_MapEventVersions = map;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        public void setResultMap(Map mapResults) {
            this.__m_ResultMap = mapResults;
        }

        public void setResultsCacheId(long lId) {
            this.__m_ResultsCacheId = lId;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            long lCacheId = this.getCacheId();
            ExternalizableHelper.writeLong(output, lCacheId);
            Map mapEntries = this.getMap();
            Map mapEvents = this.getEventHolderMap();
            Map mapResults = this.getResultMap();
            PartitionedCache service = (PartitionedCache)this.getService();
            if (!this.isEstimating()) {
                if (lCacheId == -1L) {
                    Set setCacheIds = mapEntries.keySet();
                    long lResultsCacheId = this.getResultsCacheId();
                    ExternalizableHelper.writeLong(output, lResultsCacheId);
                    ExternalizableHelper.writeInt(output, setCacheIds.size());
                    for (Long LCacheIdCur : setCacheIds) {
                        long lCacheIdCur = LCacheIdCur;
                        ExternalizableHelper.writeLong(output, lCacheIdCur);
                        this.writeCacheBackup(output, (Map)mapEntries.get(LCacheIdCur), mapEvents == null ? null : (Map)mapEvents.get(LCacheIdCur), lCacheIdCur == lResultsCacheId ? mapResults : null);
                    }
                } else {
                    this.writeCacheBackup(output, mapEntries, mapEvents, mapResults);
                }
            }
            this.writeTracing(output);
            Map mapEventVersions = this.getMapEventVersions();
            int cCaches = mapEventVersions == null ? 0 : mapEventVersions.size();
            ExternalizableHelper.writeInt(output, cCaches);
            if (!this.isEstimating()) {
                if (cCaches > 1) {
                    for (Map.Entry entry : mapEventVersions.entrySet()) {
                        long lCacheIdCur = (Long)entry.getKey();
                        ExternalizableHelper.writeLong(output, lCacheIdCur);
                        ExternalizableHelper.writeObject(output, entry.getValue());
                    }
                } else if (cCaches == 1) {
                    BackupAllRequest._assert(lCacheId != -1L);
                    ExternalizableHelper.writeObject(output, mapEventVersions.values().iterator().next());
                }
            }
        }

        protected void writeCacheBackup(WriteBuffer.BufferOutput output, Map mapEntries, Map mapEvents, Map mapResults) throws IOException {
            int cEntries = mapEntries.size();
            int cEvents = mapEvents == null ? 0 : mapEvents.size();
            int cResults = mapResults == null ? 0 : mapResults.size();
            ExternalizableHelper.writeInt(output, cEntries);
            ExternalizableHelper.writeInt(output, cEvents);
            ExternalizableHelper.writeInt(output, cResults);
            for (Map.Entry entry : mapEntries.entrySet()) {
                Object binKey = entry.getKey();
                ExternalizableHelper.writeObject(output, binKey);
                ExternalizableHelper.writeObject(output, entry.getValue());
                if (cEvents > 0) {
                    MapEventMessage.writeSupplemental(output, mapEvents.get(binKey));
                }
                if (cResults <= 0) continue;
                this.writeObject(output, mapResults.get(binKey));
            }
        }

        static {
            BackupAllRequest.__initStatic();
        }

        public static class Poll
        extends BackupMultiRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$BackupAllRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class BackupConfirmRequest
    extends PartitionedService.BackupConfirmRequest {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", PartitionedService.BackupConfirmRequest.Poll.get_CLASS());
        }

        public BackupConfirmRequest() {
            this(null, null, true);
        }

        public BackupConfirmRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(40);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new BackupConfirmRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$BackupConfirmRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        static {
            BackupConfirmRequest.__initStatic();
        }
    }

    public static class BackupListenerAllRequest
    extends BackupMultiRequest {
        private boolean __m_Add;
        private BatchContext __m_BatchContext;
        private long __m_CacheId;
        private Set __m_KeySet;
        private boolean __m_Lite;
        private int __m_MemberId;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public BackupListenerAllRequest() {
            this(null, null, true);
        }

        public BackupListenerAllRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(86);
                this.setPartitionVersions(new PrimitiveSparseArray());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new BackupListenerAllRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$BackupListenerAllRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public void addKey(Binary binKey) {
            HashSet<Binary> setKeys = this.getKeySet();
            if (setKeys == null) {
                setKeys = new HashSet<Binary>();
                this.setKeySet(setKeys);
            }
            setKeys.add(binKey);
        }

        @Override
        public Message cloneMessage() {
            BackupListenerAllRequest msg = (BackupListenerAllRequest)super.cloneMessage();
            msg.setAdd(this.isAdd());
            msg.setCacheId(this.getCacheId());
            msg.setLite(this.isLite());
            msg.setMemberId(this.getMemberId());
            msg.setBatchContext(this.getBatchContext());
            msg.setKeySet(this.getKeySet());
            return msg;
        }

        @Override
        public void doBackup(PartitionSet partsSkip) {
            ((PartitionedCache)this.getService()).onBackupListenerAllRequest(this, partsSkip);
        }

        public BatchContext getBatchContext() {
            return this.__m_BatchContext;
        }

        public long getCacheId() {
            return this.__m_CacheId;
        }

        public Set getKeySet() {
            return this.__m_KeySet;
        }

        public int getMemberId() {
            return this.__m_MemberId;
        }

        public boolean isAdd() {
            return this.__m_Add;
        }

        public boolean isLite() {
            return this.__m_Lite;
        }

        @Override
        public void onRequestCompleted() {
            BatchContext ctxBatch;
            if (this.isSyncMsg() && (ctxBatch = this.getBatchContext()) != null) {
                ctxBatch.onBackupCompleted(this);
            }
            super.onRequestCompleted();
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setCacheId(ExternalizableHelper.readLong(input));
            this.setAdd(input.readBoolean());
            this.setLite(input.readBoolean());
            this.setMemberId(ExternalizableHelper.readInt(input));
            int cKeys = ExternalizableHelper.readInt(input);
            HashSet<Object> setKeys = new HashSet<Object>(cKeys);
            for (int i = 0; i < cKeys; ++i) {
                Object binKey = this.readObject(input);
                setKeys.add(binKey);
            }
            this.readTracing(input);
            this.setKeySet(setKeys);
        }

        public void setAdd(boolean fAdd) {
            this.__m_Add = fAdd;
        }

        public void setBatchContext(BatchContext contextBatch) {
            this.__m_BatchContext = contextBatch;
        }

        public void setCacheId(long lId) {
            this.__m_CacheId = lId;
        }

        public void setKeySet(Set setKey) {
            this.__m_KeySet = setKey;
        }

        public void setLite(boolean fLite) {
            this.__m_Lite = fLite;
        }

        public void setMemberId(int nId) {
            this.__m_MemberId = nId;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            ExternalizableHelper.writeLong(output, this.getCacheId());
            output.writeBoolean(this.isAdd());
            output.writeBoolean(this.isLite());
            ExternalizableHelper.writeInt(output, this.getMemberId());
            Set setKeys = this.getKeySet();
            ExternalizableHelper.writeInt(output, setKeys.size());
            Iterator iter = setKeys.iterator();
            while (iter.hasNext()) {
                this.writeObject(output, iter.next());
            }
            this.writeTracing(output);
        }

        static {
            BackupListenerAllRequest.__initStatic();
        }

        public static class Poll
        extends BackupMultiRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$BackupListenerAllRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class BackupListenerRequest
    extends com.tangosol.coherence.component.net.message.requestMessage.chainedRequest.backupRequest.BackupSingleRequest {
        private boolean __m_Add;
        private long __m_CacheId;
        private Binary __m_Key;
        private boolean __m_Lite;
        private int __m_MemberId;
        private Message __m_PrimaryResponse;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public BackupListenerRequest() {
            this(null, null, true);
        }

        public BackupListenerRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(82);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new BackupListenerRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$BackupListenerRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            BackupListenerRequest msg = (BackupListenerRequest)super.cloneMessage();
            msg.setAdd(this.isAdd());
            msg.setCacheId(this.getCacheId());
            msg.setKey(this.getKey());
            msg.setLite(this.isLite());
            msg.setMemberId(this.getMemberId());
            msg.setPrimaryResponse(this.getPrimaryResponse());
            return msg;
        }

        @Override
        public void doBackup() {
            ((PartitionedCache)this.getService()).onBackupListenerRequest(this);
        }

        public long getCacheId() {
            return this.__m_CacheId;
        }

        @Override
        public int getEstimatedByteSize() {
            return -1;
        }

        public Binary getKey() {
            return this.__m_Key;
        }

        public int getMemberId() {
            return this.__m_MemberId;
        }

        public Message getPrimaryResponse() {
            return this.__m_PrimaryResponse;
        }

        public boolean isAdd() {
            return this.__m_Add;
        }

        public boolean isLite() {
            return this.__m_Lite;
        }

        @Override
        public void onRequestCompleted() {
            PartitionedCache service = (PartitionedCache)this.getService();
            if (!service.isAsyncBackup()) {
                service.publishToClients(this.getPrimaryResponse(), null);
            }
            super.onRequestCompleted();
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setCacheId(ExternalizableHelper.readLong(input));
            this.setKey((Binary)this.readObject(input));
            this.setAdd(input.readBoolean());
            this.setLite(input.readBoolean());
            this.setMemberId(ExternalizableHelper.readInt(input));
            this.readTracing(input);
        }

        public void setAdd(boolean fAdd) {
            this.__m_Add = fAdd;
        }

        public void setCacheId(long lId) {
            this.__m_CacheId = lId;
        }

        public void setKey(Binary binKey) {
            this.__m_Key = binKey;
        }

        public void setLite(boolean fLite) {
            this.__m_Lite = fLite;
        }

        public void setMemberId(int nId) {
            this.__m_MemberId = nId;
        }

        public void setPrimaryResponse(Message msgResponse) {
            this.__m_PrimaryResponse = msgResponse;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            ExternalizableHelper.writeLong(output, this.getCacheId());
            this.writeObject(output, this.getKey());
            output.writeBoolean(this.isAdd());
            output.writeBoolean(this.isLite());
            ExternalizableHelper.writeInt(output, this.getMemberId());
            this.writeTracing(output);
        }

        static {
            BackupListenerRequest.__initStatic();
        }

        public static class Poll
        extends BackupSingleRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$BackupListenerRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class BackupLockRequest
    extends com.tangosol.coherence.component.net.message.requestMessage.chainedRequest.backupRequest.BackupSingleRequest {
        private long __m_CacheId;
        private Binary __m_Key;
        private Lease __m_Lease;
        private boolean __m_Lock;
        private Message __m_PrimaryResponse;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public BackupLockRequest() {
            this(null, null, true);
        }

        public BackupLockRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(81);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new BackupLockRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$BackupLockRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            BackupLockRequest msg = (BackupLockRequest)super.cloneMessage();
            msg.setCacheId(this.getCacheId());
            msg.setKey(this.getKey());
            msg.setLease(this.getLease());
            msg.setLock(this.isLock());
            msg.setPrimaryResponse(this.getPrimaryResponse());
            return msg;
        }

        @Override
        public void doBackup() {
            ((PartitionedCache)this.getService()).onBackupLockRequest(this);
        }

        protected void doLockBackup() {
        }

        public long getCacheId() {
            return this.__m_CacheId;
        }

        @Override
        public int getEstimatedByteSize() {
            return -1;
        }

        public Binary getKey() {
            return this.__m_Key;
        }

        public Lease getLease() {
            return this.__m_Lease;
        }

        public Message getPrimaryResponse() {
            return this.__m_PrimaryResponse;
        }

        public boolean isLock() {
            return this.__m_Lock;
        }

        @Override
        public void onRequestCompleted() {
            ((PartitionedCache)this.getService()).publishToClients(this.getPrimaryResponse(), null);
            super.onRequestCompleted();
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            long lCacheId = ExternalizableHelper.readLong(input);
            Binary binKey = (Binary)this.readObject(input);
            boolean fLock = input.readBoolean();
            this.setCacheId(lCacheId);
            this.setKey(binKey);
            this.setLock(fLock);
            if (fLock) {
                Lease lease = Lease.instantiate(0, binKey, this.getService());
                lease.read(input);
                this.setLease(lease);
            }
            this.readTracing(input);
        }

        public void setCacheId(long lId) {
            this.__m_CacheId = lId;
        }

        public void setKey(Binary binKey) {
            this.__m_Key = binKey;
        }

        public void setLease(Lease lease) {
            this.__m_Lease = lease;
        }

        public void setLock(boolean fLock) {
            this.__m_Lock = fLock;
        }

        public void setPrimaryResponse(Message msgResponse) {
            this.__m_PrimaryResponse = msgResponse;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            ExternalizableHelper.writeLong(output, this.getCacheId());
            this.writeObject(output, this.getKey());
            boolean fLock = this.isLock();
            output.writeBoolean(fLock);
            if (fLock) {
                this.getLease().write(output);
            }
            this.writeTracing(output);
        }

        static {
            BackupLockRequest.__initStatic();
        }

        public static class Poll
        extends BackupSingleRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$BackupLockRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class BackupSingleRequest
    extends com.tangosol.coherence.component.net.message.requestMessage.chainedRequest.backupRequest.BackupSingleRequest
    implements Collector {
        private long __m_BackupCompletedTime;
        private long __m_CacheId;
        private boolean __m_CompleteOnPersist;
        private Set __m_EntryInfos;
        private Set __m_EntryInfosOOB;
        private Object __m_EventHolder;
        private Binary __m_Key;
        private long __m_MapEventVersion;
        public static final int MESSAGE_TYPE = 80;
        private AtomicInteger __m_OutstandingOperationCounter;
        private Span __m_PersistenceTracingSpan;
        private Message __m_PrimaryResponse;
        private Binary __m_Result;
        private ReadBuffer __m_Value;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public BackupSingleRequest() {
            this(null, null, true);
        }

        public BackupSingleRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setBackupCompletedTime(-1L);
                this.setMessageType(80);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new BackupSingleRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$BackupSingleRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public void add(Object oValue) {
            long ldtBackupEndTime;
            PartitionControl ctrlPartition;
            PartitionedCache service = (PartitionedCache)this.getService();
            PersistenceControl ctrlPersistence = (PersistenceControl)service.getPersistenceControl();
            if (oValue instanceof PartitionControl) {
                ctrlPartition = (PartitionControl)oValue;
            } else {
                String sGUIDCurrent;
                String sGUIDFailed;
                AsyncPersistenceException eAsync = (AsyncPersistenceException)oValue;
                ctrlPartition = (PartitionControl)eAsync.getReceipt();
                int iPart = this.getPartition();
                if (service.isPrimaryOwner(iPart) && (sGUIDFailed = eAsync.getPersistentStore().getId()).equals(sGUIDCurrent = service.getPartitionControl(iPart).getPersistentStore().getId())) {
                    ctrlPersistence.onActivePersistenceFailure(new PersistenceException("Asynchronous persistence operation failed for partition " + iPart, eAsync));
                }
            }
            ctrlPartition.finishPersist();
            if (this.isCompleteOnPersist()) {
                this.onOperationCompleted();
            }
            long cLatency = (ldtBackupEndTime = this.getBackupCompletedTime()) == -1L ? 0L : Base.getSafeTimeMillis() - ldtBackupEndTime;
            ctrlPersistence.recordLatencyStats(cLatency);
            Span span = this.getPersistenceTracingSpan();
            if (span != null) {
                span.end();
            }
        }

        @Override
        public Message cloneMessage() {
            BackupSingleRequest msg = (BackupSingleRequest)super.cloneMessage();
            msg.setCacheId(this.getCacheId());
            msg.setKey(this.getKey());
            msg.setPrimaryResponse(this.getPrimaryResponse());
            msg.setEventHolder(this.getEventHolder());
            msg.setValue(this.getValue());
            msg.setResult(this.getResult());
            msg.setOutstandingOperationCounter(this.getOutstandingOperationCounter());
            msg.setMapEventVersion(this.getMapEventVersion());
            return msg;
        }

        @Override
        public void doBackup() {
            ((PartitionedCache)this.getService()).onBackupSingleRequest(this);
        }

        @Override
        public void flush() {
            ((PartitionedCache)this.get_Module()).flush();
        }

        public long getBackupCompletedTime() {
            return this.__m_BackupCompletedTime;
        }

        public long getCacheId() {
            return this.__m_CacheId;
        }

        public Set getEntryInfos() {
            return this.__m_EntryInfos;
        }

        public Set getEntryInfosOOB() {
            return this.__m_EntryInfosOOB;
        }

        @Override
        public int getEstimatedByteSize() {
            PartitionedCache service = (PartitionedCache)this.getService();
            int cb = service.getBackupSingleEnvelopeSize().get();
            int BIN_SIZE = 5;
            boolean BYTE_SIZE = true;
            cb += this.getKey().length() + 5;
            ReadBuffer binVal = this.getValue();
            cb += binVal == null ? 1 : binVal.length() + 5;
            Binary binResult = this.getResult();
            cb += binResult == null ? 1 : binResult.length() + 5;
            return cb += service.estimateEventHolderByteSize(this.getEventHolder());
        }

        public Object getEventHolder() {
            return this.__m_EventHolder;
        }

        public Binary getKey() {
            return this.__m_Key;
        }

        public long getMapEventVersion() {
            return this.__m_MapEventVersion;
        }

        public AtomicInteger getOutstandingOperationCounter() {
            return this.__m_OutstandingOperationCounter;
        }

        public Span getPersistenceTracingSpan() {
            return this.__m_PersistenceTracingSpan;
        }

        public Message getPrimaryResponse() {
            return this.__m_PrimaryResponse;
        }

        public Binary getResult() {
            return this.__m_Result;
        }

        public ReadBuffer getValue() {
            return this.__m_Value;
        }

        public boolean isCompleteOnPersist() {
            return this.__m_CompleteOnPersist;
        }

        protected void onOperationCompleted() {
            PartitionedCache service = (PartitionedCache)this.getService();
            if (this.getOutstandingOperationCounter().decrementAndGet() == 0 && service.getServiceState() != 4) {
                service.dispatchServerEvents(this.getEntryInfos(), this.getEntryInfosOOB());
                service.publishToClients(this.getPrimaryResponse(), this.getEventHolder());
            }
        }

        public void onPublishCompleted() {
            this.onOperationCompleted();
        }

        @Override
        public void onRequestCompleted() {
            PartitionedCache service = (PartitionedCache)this.getService();
            PartitionControl ctrlPartition = (PartitionControl)service.getPartitionControl(this.getPartition());
            if (this.isSyncMsg()) {
                this.onOperationCompleted();
                this.setBackupCompletedTime(Base.getSafeTimeMillis());
            }
            if (ctrlPartition != null) {
                ctrlPartition.finishBackup(this.getPartitionVersion());
            }
            super.onRequestCompleted();
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setCacheId(ExternalizableHelper.readLong(input));
            this.setKey((Binary)ExternalizableHelper.readObject(input));
            this.setEventHolder(MapEventMessage.readSupplemental(input, this.getService()));
            this.setValue((Binary)ExternalizableHelper.readObject(input));
            this.setResult((Binary)ExternalizableHelper.readObject(input));
            this.readTracing(input);
            if (input.available() > 0) {
                this.setMapEventVersion(ExternalizableHelper.readLong(input));
            }
        }

        public void setBackupCompletedTime(long ldtMillis) {
            this.__m_BackupCompletedTime = ldtMillis;
        }

        public void setCacheId(long lId) {
            this.__m_CacheId = lId;
        }

        public void setCompleteOnPersist(boolean fPersist) {
            this.__m_CompleteOnPersist = fPersist;
        }

        public void setEntryInfos(Set setInfos) {
            this.__m_EntryInfos = setInfos;
        }

        public void setEntryInfosOOB(Set setB) {
            this.__m_EntryInfosOOB = setB;
        }

        public void setEventHolder(Object oHolder) {
            this.__m_EventHolder = oHolder;
        }

        public void setKey(Binary binKey) {
            this.__m_Key = binKey;
        }

        public void setMapEventVersion(long bufValue) {
            this.__m_MapEventVersion = bufValue;
        }

        public void setOutstandingOperationCounter(AtomicInteger atomic) {
            this.__m_OutstandingOperationCounter = atomic;
        }

        public void setPersistenceTracingSpan(Span spanTracing) {
            this.__m_PersistenceTracingSpan = spanTracing;
        }

        public void setPrimaryResponse(Message msgResponse) {
            this.__m_PrimaryResponse = msgResponse;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        public void setResult(Binary binResult) {
            this.__m_Result = binResult;
        }

        public void setValue(ReadBuffer bufValue) {
            this.__m_Value = bufValue;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            ExternalizableHelper.writeLong(output, this.getCacheId());
            PartitionedCache service = (PartitionedCache)this.getService();
            if (!this.isEstimating()) {
                ExternalizableHelper.writeObject(output, this.getKey());
                MapEventMessage.writeSupplemental(output, this.getEventHolder());
                ExternalizableHelper.writeObject(output, this.getValue());
                ExternalizableHelper.writeObject(output, this.getResult());
            }
            this.writeTracing(output);
            ExternalizableHelper.writeLong(output, this.getMapEventVersion());
        }

        static {
            BackupSingleRequest.__initStatic();
        }

        public static class Poll
        extends BackupSingleRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$BackupSingleRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class BatchContext
    extends Component
    implements Collector {
        private Set __m_EntryInfos;
        private Set __m_EntryInfosOOB;
        private Object __m_Events;
        private long __m_LastBackupCompletedTime;
        private AtomicInteger __m_OutstandingOperationCounter;
        private Span __m_PersistenceTracingSpan;
        private Message __m_PrimaryResponse;
        private SparseArray __m_SkipCompleteArray;

        public BatchContext() {
            this(null, null, true);
        }

        public BatchContext(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setLastBackupCompletedTime(-1L);
                this.setSkipCompleteArray(new SparseArray());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new BatchContext();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$BatchContext".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public synchronized void accumulateEntryInfos(Set setInfo, boolean fOOB) {
            Set set;
            Set set2 = set = fOOB ? this.getEntryInfosOOB() : this.getEntryInfos();
            if (set == null) {
                set = setInfo;
            } else {
                set.addAll(setInfo);
            }
            if (fOOB) {
                this.setEntryInfosOOB(set);
            } else {
                this.setEntryInfos(set);
            }
        }

        public void add(Object oValue) {
            Span span;
            PartitionControl ctrlPartition;
            PartitionedCache service = (PartitionedCache)this.get_Module();
            PersistenceControl ctrlPersistence = (PersistenceControl)service.getPersistenceControl();
            if (oValue instanceof PartitionControl) {
                ctrlPartition = (PartitionControl)oValue;
            } else {
                String sGUIDCurrent;
                String sGUIDFailed;
                AsyncPersistenceException eAsync = (AsyncPersistenceException)oValue;
                ctrlPartition = (PartitionControl)eAsync.getReceipt();
                int iPart = ctrlPartition.getPartitionId();
                if (service.isPrimaryOwner(iPart) && (sGUIDFailed = eAsync.getPersistentStore().getId()).equals(sGUIDCurrent = service.getPartitionControl(iPart).getPersistentStore().getId())) {
                    ctrlPersistence.onActivePersistenceFailure(new PersistenceException("Asynchronous persistence operation failed for partition " + iPart, eAsync));
                }
            }
            ctrlPartition.finishPersist();
            long cLatency = 0L;
            if (this.isCompleteOnPersist(ctrlPartition.getPartitionId())) {
                if (this.tryBatchCompletion()) {
                    cLatency = Base.getSafeTimeMillis() - this.getLastBackupCompletedTime();
                }
                ctrlPersistence.recordLatencyStats(cLatency);
            }
            if ((span = this.getPersistenceTracingSpan()) != null) {
                span.end();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean completeOnPersist(boolean fSync, int nPartition) {
            Boolean FSkipComplete;
            SparseArray laSkipComplete;
            SparseArray sparseArray = laSkipComplete = this.getSkipCompleteArray();
            synchronized (sparseArray) {
                FSkipComplete = (Boolean)laSkipComplete.get(nPartition);
                if (FSkipComplete == null) {
                    FSkipComplete = !fSync;
                    laSkipComplete.set(nPartition, FSkipComplete);
                }
            }
            return FSkipComplete == false;
        }

        @Override
        public void flush() {
            ((PartitionedCache)this.get_Module()).flush();
        }

        public Set getEntryInfos() {
            return this.__m_EntryInfos;
        }

        public Set getEntryInfosOOB() {
            return this.__m_EntryInfosOOB;
        }

        public Object getEvents() {
            return this.__m_Events;
        }

        public long getLastBackupCompletedTime() {
            return this.__m_LastBackupCompletedTime;
        }

        public AtomicInteger getOutstandingOperationCounter() {
            return this.__m_OutstandingOperationCounter;
        }

        public Span getPersistenceTracingSpan() {
            return this.__m_PersistenceTracingSpan;
        }

        public Message getPrimaryResponse() {
            return this.__m_PrimaryResponse;
        }

        public SparseArray getSkipCompleteArray() {
            return this.__m_SkipCompleteArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean isCompleteOnPersist(int nPartition) {
            SparseArray laSkipComplete;
            SparseArray sparseArray = laSkipComplete = this.getSkipCompleteArray();
            synchronized (sparseArray) {
                Boolean FSkipComplete = (Boolean)laSkipComplete.get(nPartition);
                return FSkipComplete == null ? false : FSkipComplete == false;
            }
        }

        public void onBackupCompleted(BackupRequest msgBackup) {
            if (!this.tryBatchCompletion() && msgBackup.isSyncMsg()) {
                this.setLastBackupCompletedTime(Base.getSafeTimeMillis());
            }
        }

        protected void onCompleted() {
        }

        public void onJobCompleted(PartialJob job) {
            this.tryBatchCompletion();
        }

        public void setEntryInfos(Set setInfos) {
            this.__m_EntryInfos = setInfos;
        }

        public void setEntryInfosOOB(Set setB) {
            this.__m_EntryInfosOOB = setB;
        }

        public void setEvents(Object oEvents) {
            this.__m_Events = oEvents;
        }

        public void setLastBackupCompletedTime(long ldtTime) {
            this.__m_LastBackupCompletedTime = ldtTime;
        }

        public void setOutstandingOperationCounter(AtomicInteger atomic) {
            this.__m_OutstandingOperationCounter = atomic;
        }

        public void setPersistenceTracingSpan(Span spanTracing) {
            this.__m_PersistenceTracingSpan = spanTracing;
        }

        public void setPrimaryResponse(Message msgResponse) {
            this.__m_PrimaryResponse = msgResponse;
        }

        public void setSkipCompleteArray(SparseArray arrayComplete) {
            this.__m_SkipCompleteArray = arrayComplete;
        }

        protected boolean tryBatchCompletion() {
            PartitionedCache service;
            if (this.getOutstandingOperationCounter().decrementAndGet() == 0 && (service = (PartitionedCache)this.get_Module()).getServiceState() != 4) {
                service.dispatchServerEvents(this.getEntryInfos(), this.getEntryInfosOOB());
                service.publishToClients(this.getPrimaryResponse(), this.getEvents());
                return true;
            }
            return false;
        }
    }

    public static class ClearRequest
    extends PartialRequest {
        private boolean __m_Truncate;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public ClearRequest() {
            this(null, null, true);
        }

        public ClearRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(54);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        public static Component get_Instance() {
            return new ClearRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$ClearRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            ClearRequest msg = (ClearRequest)super.cloneMessage();
            msg.setTruncate(this.isTruncate());
            return msg;
        }

        public boolean isTruncate() {
            return this.__m_Truncate;
        }

        @Override
        public void onReceived() {
            if (this.isTruncate()) {
                ((PartitionedCache)this.getService()).onClearRequest(this);
            } else {
                super.onReceived();
            }
        }

        @Override
        public boolean preprocess() {
            if (this.isTruncate()) {
                return false;
            }
            return super.preprocess();
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setTruncate(input.readBoolean());
            this.readTracing(input);
        }

        @Override
        public void run() {
            ((PartitionedCache)this.getService()).onClearRequest(this);
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        public void setTruncate(boolean fTruncate) {
            this.__m_Truncate = fTruncate;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeBoolean(this.isTruncate());
            this.writeTracing(output);
        }

        static {
            ClearRequest.__initStatic();
        }

        public static class Poll
        extends PartialRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            @Override
            public boolean isPreprocessable() {
                return true;
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$ClearRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class ContainsAllRequest
    extends KeySetRequest {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public ContainsAllRequest() {
            this(null, null, true);
        }

        public ContainsAllRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(55);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ContainsAllRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$ContainsAllRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public int getEstimatedByteSize() {
            return -1;
        }

        @Override
        public void run() {
            ((PartitionedCache)this.getService()).onContainsAllRequest(this);
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        static {
            ContainsAllRequest.__initStatic();
        }

        public static class Poll
        extends KeySetRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            @Override
            public boolean isPreprocessable() {
                return true;
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$ContainsAllRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class ContainsKeyRequest
    extends DistributedCacheKeyRequest {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public ContainsKeyRequest() {
            this(null, null, true);
        }

        public ContainsKeyRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(56);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ContainsKeyRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$ContainsKeyRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public int getEstimatedByteSize() {
            return -1;
        }

        @Override
        public void run() {
            ((PartitionedCache)this.getService()).onContainsKeyRequest(this);
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        static {
            ContainsKeyRequest.__initStatic();
        }

        public static class Poll
        extends DistributedCacheKeyRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            @Override
            public boolean isPreprocessable() {
                return true;
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$ContainsKeyRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class ContainsValueRequest
    extends PartialRequest {
        private Binary __m_Value;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public ContainsValueRequest() {
            this(null, null, true);
        }

        public ContainsValueRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(57);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ContainsValueRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$ContainsValueRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            ContainsValueRequest msg = (ContainsValueRequest)super.cloneMessage();
            msg.setValue(this.getValue());
            return msg;
        }

        @Override
        public int getEstimatedByteSize() {
            return -1;
        }

        public Binary getValue() {
            return this.__m_Value;
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setValue((Binary)this.readObject(input));
            this.readTracing(input);
        }

        @Override
        public void run() {
            ((PartitionedCache)this.getService()).onContainsValueRequest(this);
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        public void setValue(Binary binValue) {
            this.__m_Value = binValue;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            this.writeObject(output, this.getValue());
            this.writeTracing(output);
        }

        static {
            ContainsValueRequest.__initStatic();
        }

        public static class Poll
        extends PartialRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            @Override
            public boolean isPreprocessable() {
                return true;
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$ContainsValueRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class ConverterFromBinary
    extends Converter {
        public ConverterFromBinary() {
            this(null, null, true);
        }

        public ConverterFromBinary(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ConverterFromBinary();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$ConverterFromBinary".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public Object convert(Object o) {
            return o == null ? null : ExternalizableHelper.fromBinary((Binary)o, this.getSerializer());
        }
    }

    public static class ConverterValueToBinary
    extends Converter {
        private static transient ThreadLocal __s_WriteBuffer;

        private static void __initStatic() {
            try {
                __s_WriteBuffer = new ThreadLocal();
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
        }

        public ConverterValueToBinary() {
            this(null, null, true);
        }

        public ConverterValueToBinary(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ConverterValueToBinary();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$ConverterValueToBinary".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public Object convert(Object o) {
            WriteBuffer buf = (WriteBuffer)ConverterValueToBinary.getWriteBuffer().get();
            if (buf != null) {
                buf.retain(0, 0);
            }
            return ExternalizableHelper.toBinary(o, this.getSerializer(), buf);
        }

        private static ThreadLocal getWriteBuffer() {
            return __s_WriteBuffer;
        }

        public static void setWriteBuffer(WriteBuffer buf) {
            ConverterValueToBinary.getWriteBuffer().set(buf);
        }

        private static void setWriteBuffer(ThreadLocal tlBuf) {
            __s_WriteBuffer = tlBuf;
        }

        static {
            ConverterValueToBinary.__initStatic();
        }
    }

    public static class DistributionRequest
    extends PartitionedService.DistributionRequest {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", PartitionedService.DistributionRequest.Poll.get_CLASS());
        }

        public DistributionRequest() {
            this(null, null, true);
        }

        public DistributionRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(35);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new DistributionRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$DistributionRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        static {
            DistributionRequest.__initStatic();
        }
    }

    public static class GetAllRequest
    extends KeySetRequest {
        private boolean __m_AllowBackupRead;
        private int __m_SizeThreshold;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public GetAllRequest() {
            this(null, null, true);
        }

        public GetAllRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(58);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new GetAllRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$GetAllRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            GetAllRequest msg = (GetAllRequest)super.cloneMessage();
            msg.setAllowBackupRead(this.isAllowBackupRead());
            return msg;
        }

        @Override
        public int getEstimatedByteSize() {
            return -1;
        }

        public int getSizeThreshold() {
            return this.__m_SizeThreshold;
        }

        @Override
        protected Set instantiateKeySet(int cKeys) {
            return ((PartitionedCache)this.get_Module()).isConcurrent() ? Collections.newSetFromMap(new NullableSortedMap()) : super.instantiateKeySet(cKeys);
        }

        public boolean isAllowBackupRead() {
            return this.__m_AllowBackupRead;
        }

        @Override
        public boolean isCoherentResult() {
            return !this.isAllowBackupRead();
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setSizeThreshold(ExternalizableHelper.readInt(input));
            this.readTracing(input);
            if (input.available() > 0) {
                this.setAllowBackupRead(input.readBoolean());
            }
        }

        @Override
        public void run() {
            ((PartitionedCache)this.getService()).onGetAllRequest(this);
        }

        public void setAllowBackupRead(boolean fRead) {
            this.__m_AllowBackupRead = fRead;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        public void setSizeThreshold(int cbLimit) {
            this.__m_SizeThreshold = cbLimit;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            ExternalizableHelper.writeInt(output, this.getSizeThreshold());
            this.writeTracing(output);
            output.writeBoolean(this.isAllowBackupRead());
        }

        static {
            GetAllRequest.__initStatic();
        }

        public static class Poll
        extends KeySetRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            @Override
            public boolean isPreprocessable() {
                return true;
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$GetAllRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class GetRequest
    extends DistributedCacheKeyRequest {
        private boolean __m_AllowBackupRead;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public GetRequest() {
            this(null, null, true);
        }

        public GetRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(59);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new GetRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$GetRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            GetRequest msg = (GetRequest)super.cloneMessage();
            msg.setAllowBackupRead(this.isAllowBackupRead());
            return msg;
        }

        @Override
        public int getEstimatedByteSize() {
            return -1;
        }

        public boolean isAllowBackupRead() {
            return this.__m_AllowBackupRead;
        }

        @Override
        public boolean isCoherentResult() {
            return !this.isAllowBackupRead();
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            if (input.available() > 0) {
                this.setAllowBackupRead(input.readBoolean());
            }
        }

        @Override
        public void run() {
            ((PartitionedCache)this.getService()).onGetRequest(this);
        }

        public void setAllowBackupRead(boolean fRead) {
            this.__m_AllowBackupRead = fRead;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeBoolean(this.isAllowBackupRead());
        }

        static {
            GetRequest.__initStatic();
        }

        public static class Poll
        extends DistributedCacheKeyRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            @Override
            public boolean isPreprocessable() {
                return true;
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$GetRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class IndexRequest
    extends StorageRequest {
        private boolean __m_Add;
        private Comparator __m_Comparator;
        private ValueExtractor __m_Extractor;
        private boolean __m_Ordered;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public IndexRequest() {
            this(null, null, true);
        }

        public IndexRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(60);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        public static Component get_Instance() {
            return new IndexRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$IndexRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            IndexRequest msg = (IndexRequest)super.cloneMessage();
            msg.setAdd(this.isAdd());
            msg.setOrdered(this.isOrdered());
            msg.setExtractor(this.getExtractor());
            msg.setComparator(this.getComparator());
            return msg;
        }

        public Comparator getComparator() {
            return this.__m_Comparator;
        }

        public ValueExtractor getExtractor() {
            return this.__m_Extractor;
        }

        public boolean isAdd() {
            return this.__m_Add;
        }

        public boolean isOrdered() {
            return this.__m_Ordered;
        }

        @Override
        public void onReceived() {
            ((PartitionedCache)this.getService()).onIndexRequest(this);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setAdd(input.readBoolean());
            this.setOrdered(input.readBoolean());
            try {
                this.setExtractor((ValueExtractor)this.readObject(input));
                this.setComparator((Comparator)this.readObject(input));
            }
            catch (Throwable t) {
                this.setReadException(Base.ensureRuntimeException(t));
            }
            this.readTracing(input);
        }

        @Override
        public void run() {
            throw new IllegalStateException();
        }

        public void setAdd(boolean fAdd) {
            this.__m_Add = fAdd;
        }

        public void setComparator(Comparator comparator) {
            this.__m_Comparator = comparator;
        }

        public void setExtractor(ValueExtractor extractor) {
            this.__m_Extractor = extractor;
        }

        public void setOrdered(boolean fOrdered) {
            this.__m_Ordered = fOrdered;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeBoolean(this.isAdd());
            output.writeBoolean(this.isOrdered());
            try {
                this.writeObject(output, this.getExtractor());
            }
            catch (IOException e) {
                IndexRequest._trace("Extractor is not serializable: " + String.valueOf(this.getExtractor()), 1);
                throw e;
            }
            try {
                this.writeObject(output, this.getComparator());
            }
            catch (IOException e) {
                IndexRequest._trace("Comparator is not serializable: " + String.valueOf(this.getComparator()), 1);
                throw e;
            }
            this.writeTracing(output);
        }

        static {
            IndexRequest.__initStatic();
        }

        public static class Poll
        extends StorageRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$IndexRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class InvocationContext
    extends WrapperContext {
        private int __m_AccessGranted;
        private int __m_AccessReason;
        private Storage __m_AccessStorage;
        private Subject __m_AccessSubject;
        private boolean __m_Active;
        private boolean __m_AllowReadThrough;
        private transient int __m_Attempt;
        private boolean __m_Committed;
        private Map __m_EnlistedStatuses;
        private Set __m_LockedStorage;
        protected static final int MAX_ATTEMPTS = 15;
        private PartitionSet __m_PinnedPartitions;
        private boolean __m_ReadOnlyRequest;
        private Map __m_StorageEntries;
        private Map __m_StorageStatusMap;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("StorageContext", StorageContext.get_CLASS());
        }

        public InvocationContext() {
            this(null, null, true);
        }

        public InvocationContext(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setAllowReadThrough(true);
                this.setLockedStorage(new LiteSet());
                this.setStorageMap(new LiteMap());
                this.setStorageStatusMap(new LiteMap());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new InvocationContext();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$InvocationContext".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        protected static void checkSlidingExpiry(Storage storage, Storage.EntryStatus status, Storage.BinaryEntry entry) {
            if (storage.isExpirySliding() && !entry.isValueChanged() && !entry.isReadOnly()) {
                status.setPending(true);
                try {
                    if (!status.isAnyAction()) {
                        entry.expire(storage.getBackingConfigurableCache().getExpiryDelay());
                        status.setExpiryOnly(true);
                    }
                }
                finally {
                    status.setPending(false);
                }
            }
        }

        protected void clearStatuses() {
            PartitionedCache service = this.getService();
            Set setLockedStorage = this.getLockedStorage();
            Map mapStorageStatus = this.getStorageStatusMap();
            for (Map.Entry entry : mapStorageStatus.entrySet()) {
                Storage storage = (Storage)entry.getKey();
                Map mapKeyStatus = (Map)entry.getValue();
                if (setLockedStorage.contains(storage)) continue;
                for (Storage.EntryStatus status : mapKeyStatus.values()) {
                    service.unlockKey(storage, status.getKey(), false);
                }
            }
            mapStorageStatus.clear();
        }

        protected Map createEntryView(Map mapStatuses) {
            com.tangosol.util.Converter convNull = NullImplementation.getConverter();
            com.tangosol.util.Converter convUp = this.getService().getBinaryEntryConverter();
            return ConverterCollections.getMap(mapStatuses, convNull, convNull, ConversionHelper.getCollectionConverter(convUp, convNull), convNull);
        }

        public Storage.EntryStatus enlistSynthetic(Storage storage, Binary binKey) {
            Storage.EntryStatus status;
            Map mapStorage = this.getStorageStatusMap();
            LiteMap<Binary, Storage.EntryStatus> mapKeyStatus = (LiteMap<Binary, Storage.EntryStatus>)mapStorage.get(storage);
            Storage.EntryStatus entryStatus = status = mapKeyStatus == null ? null : (Storage.EntryStatus)mapKeyStatus.get(binKey);
            if (status == null) {
                status = this.getService().getResourceCoordinator().ensureStatus(storage, binKey);
                status.setManaged(true);
                if (mapKeyStatus == null) {
                    mapKeyStatus = new LiteMap<Binary, Storage.EntryStatus>();
                    mapStorage.put(storage, mapKeyStatus);
                }
                mapKeyStatus.put(binKey, status);
                status.setBinaryEntry(storage.instantiateBinaryEntry(binKey, null, false));
            }
            return status;
        }

        public int getAccessGranted() {
            return this.__m_AccessGranted;
        }

        public int getAccessReason() {
            return this.__m_AccessReason;
        }

        public Storage getAccessStorage() {
            return this.__m_AccessStorage;
        }

        public Subject getAccessSubject() {
            return this.__m_AccessSubject;
        }

        protected int getAttempt() {
            return this.__m_Attempt;
        }

        protected Map getEnlistedStatuses() {
            return this.__m_EnlistedStatuses;
        }

        public Storage.EntryStatus getEntryStatus(Storage storage, Binary binKey) {
            Map mapStatuses = (Map)this.getStorageStatusMap().get(storage);
            return mapStatuses == null ? null : (Storage.EntryStatus)mapStatuses.get(binKey);
        }

        public Collection getEntryStatuses() {
            Collection collMaps = this.getStorageStatusMap().values();
            if (collMaps.size() == 1) {
                Map mapStatus = (Map)collMaps.iterator().next();
                return mapStatus.values();
            }
            return new ChainedCollection(ConverterCollections.getCollection(collMaps, ConversionHelper.getMapValuesConverter(), NullImplementation.getConverter()));
        }

        protected Set getLockedStorage() {
            return this.__m_LockedStorage;
        }

        public PartitionSet getPinnedPartitions() {
            PartitionSet parts = this.__m_PinnedPartitions;
            if (parts == null) {
                parts = new PartitionSet(this.getService().getPartitionCount());
                this.setPinnedPartitions(parts);
            }
            return parts;
        }

        @Override
        public PartitionedCache getService() {
            return (PartitionedCache)this.get_Module();
        }

        @Override
        public Storage getStorage(String sCacheName) {
            return ((PartitionedCache)this.get_Module()).getStorage(sCacheName);
        }

        protected Map getStorageEntries() {
            return this.__m_StorageEntries;
        }

        public Map getStorageStatusMap() {
            return this.__m_StorageStatusMap;
        }

        public boolean hasEntriesEnlisted(Storage storage) {
            Map mapStatuses = (Map)this.getStorageStatusMap().get(storage);
            return mapStatuses != null && !mapStatuses.isEmpty();
        }

        public boolean hasEntryEnlisted(Storage storage, Binary binKey) {
            Map mapStatuses = (Map)this.getStorageStatusMap().get(storage);
            return mapStatuses != null && mapStatuses.containsKey(binKey);
        }

        public void initialize() {
            com.tangosol.util.Converter convNull = NullImplementation.getConverter();
            PartitionedCache service = this.getService();
            ConverterCollections.ConverterMap mapStorageEntries = ConverterCollections.getMap(this.getStorageStatusMap(), convNull, convNull, ConversionHelper.getMapValuesConverter(service.getBinaryEntryConverter(), convNull), convNull);
            this.setStorageEntries(mapStorageEntries);
            this.setPrePinnedPartitions(new PartitionSet(service.getPartitionCount()));
        }

        @Override
        protected WrapperContext.StorageContext instantiateStorageContext(Storage storage) {
            StorageContext ctx = new StorageContext();
            this._linkChild(ctx);
            ctx.setStorage(storage);
            return ctx;
        }

        public boolean isActive() {
            return this.__m_Active;
        }

        public boolean isAllowReadThrough() {
            return this.__m_AllowReadThrough;
        }

        public boolean isCommitted() {
            return this.__m_Committed;
        }

        public boolean isReadOnly() {
            return this.isReadOnlyRequest() || this.isCommitted();
        }

        public boolean isReadOnlyRequest() {
            return this.__m_ReadOnlyRequest;
        }

        public Storage.EntryStatus[] lockEntries(Storage storage, Binary[] aKeys, int cSize) {
            Map mapStorage = this.getStorageStatusMap();
            LiteMap<Binary, Storage.EntryStatus> mapKeyStatus = (LiteMap<Binary, Storage.EntryStatus>)mapStorage.get(storage);
            PartitionedCache service = this.getService();
            ResourceCoordinator coordinator = service.getResourceCoordinator();
            Storage.EntryStatus[] aStatus = new Storage.EntryStatus[cSize];
            if (mapKeyStatus == null) {
                mapKeyStatus = new LiteMap<Binary, Storage.EntryStatus>();
                mapStorage.put(storage, mapKeyStatus);
            }
            for (int i = 0; i < cSize; ++i) {
                Binary binKey = aKeys[i];
                service.lockKey(storage, binKey, false);
                Storage.EntryStatus status = coordinator.getStatus(storage, binKey);
                InvocationContext._assert(status != null && status.getBinaryEntry() == null);
                mapKeyStatus.put(binKey, status);
                status.setBinaryEntry(storage.instantiateBinaryEntry(binKey, null, false));
                aStatus[i] = status;
            }
            return aStatus;
        }

        public Storage.EntryStatus lockEntry(Storage storage, Binary binKey, boolean fEnter) {
            return this.lockEntry(storage, storage.instantiateBinaryEntry(binKey, null, false), fEnter);
        }

        public Storage.EntryStatus lockEntry(Storage storage, Storage.BinaryEntry binEntry, boolean fEnter) {
            Map mapStorage = this.getStorageStatusMap();
            LiteMap<Binary, Storage.EntryStatus> mapKeyStatus = (LiteMap<Binary, Storage.EntryStatus>)mapStorage.get(storage);
            Binary binKey = binEntry.getBinaryKey();
            PartitionedCache service = this.getService();
            PartitionSet partsPinned = this.getPinnedPartitions();
            Storage.EntryStatus status = mapKeyStatus == null ? null : (Storage.EntryStatus)mapKeyStatus.get(binKey);
            int nPartition = status == null ? this.getKeyPartition(binKey) : status.getPartition();
            boolean bl = fEnter = fEnter && !partsPinned.contains(nPartition);
            if (status == null && service.lockKey(storage, binKey, fEnter)) {
                if (fEnter || !service.isConcurrent()) {
                    partsPinned.add(nPartition);
                }
                InvocationContext._assert((status = service.getResourceCoordinator().getStatus(storage, binKey)) != null && status.getBinaryEntry() == null);
                if (mapKeyStatus == null) {
                    mapKeyStatus = new LiteMap<Binary, Storage.EntryStatus>();
                    mapStorage.put(storage, mapKeyStatus);
                }
                mapKeyStatus.put(binKey, status);
                status.setBinaryEntry(binEntry);
                Map mapEnlisted = this.getEnlistedStatuses();
                if (mapEnlisted != null) {
                    LiteSet<Storage.EntryStatus> setStatus = (LiteSet<Storage.EntryStatus>)mapEnlisted.get(storage);
                    if (setStatus == null) {
                        setStatus = new LiteSet<Storage.EntryStatus>();
                        mapEnlisted.put(storage, setStatus);
                    }
                    setStatus.add(status);
                }
            }
            return status;
        }

        public void lockStorage(Storage storage) {
            this.getService().getResourceCoordinator().lockAll(storage, -1L);
            this.getLockedStorage().add(storage);
        }

        public void markCommitted() {
            this.setCommitted(true);
        }

        public void markReadOnlyRequest() {
            this.setReadOnlyRequest(true);
        }

        public void postInvoke() {
            this.postInvokeAll(this.getEntryStatuses());
        }

        public void postInvokeAll(Collection colEntries) {
            int cEntries = colEntries.size();
            if (cEntries == 0) {
                return;
            }
            if (cEntries == 1) {
                Storage.EntryStatus status = (Storage.EntryStatus)colEntries.iterator().next();
                Storage.BinaryEntry entry = status.getBinaryEntry();
                if (entry != null) {
                    Storage storage = entry.getStorage();
                    InvocationContext.checkSlidingExpiry(storage, status, entry);
                    storage.postInvoke(entry);
                }
                return;
            }
            HashMap<Storage, LinkedList<Storage.BinaryEntry>> mapStorage = new HashMap<Storage, LinkedList<Storage.BinaryEntry>>(cEntries);
            for (Storage.EntryStatus status : colEntries) {
                Storage.BinaryEntry entry = status.getBinaryEntry();
                if (entry == null) continue;
                Storage storage = entry.getStorage();
                InvocationContext.checkSlidingExpiry(storage, status, entry);
                LinkedList<Storage.BinaryEntry> listEntries = (LinkedList<Storage.BinaryEntry>)mapStorage.get(storage);
                if (listEntries == null) {
                    listEntries = new LinkedList<Storage.BinaryEntry>();
                    mapStorage.put(storage, listEntries);
                }
                listEntries.add(entry);
            }
            for (Map.Entry entry : mapStorage.entrySet()) {
                ((Storage)entry.getKey()).postInvokeAll((List)entry.getValue());
            }
        }

        public void prepareAccess(RequestContext context, Storage storage, int nAccessRequired, int nReason) {
            StorageAccessAuthorizer authorizer = storage.getAccessAuthorizer();
            if (authorizer != null) {
                if (nAccessRequired != 0) {
                    storage.checkAccess(context, nAccessRequired, nReason);
                }
                this.setAccessSubject(context == null ? null : context.getSubject());
                this.setAccessStorage(storage);
                this.setAccessReason(nReason);
                this.setAccessGranted(nAccessRequired);
            }
        }

        public Set processInterceptors() {
            return this.processInterceptors(this.getStorageEntries());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set processInterceptors(Map mapStorageEntries) {
            EventsHelper evtHelper = this.getService().getEventsHelper();
            LiteSet setEnlisted = null;
            try {
                boolean fPrecommit = true;
                Map mapEnlistedEntries = mapStorageEntries;
                LiteMap mapEnlistedStatuses = null;
                LiteMap mapEnlistedExtra = null;
                while (true) {
                    for (Map.Entry entry : mapEnlistedEntries.entrySet()) {
                        Storage storage = (Storage)entry.getKey();
                        if (storage.getTriggerSet() != null || evtHelper.hasPreCommitInterceptors(storage)) {
                            if (setEnlisted == null) {
                                setEnlisted = new LiteSet();
                                mapEnlistedExtra = new LiteMap();
                                this.setEnlistedStatuses(mapEnlistedExtra);
                            }
                            Collection colEntry = (Collection)entry.getValue();
                            storage.processInterceptors(colEntry);
                        }
                        if (mapEnlistedStatuses == null) continue;
                        setEnlisted.addAll((Collection)mapEnlistedStatuses.get(storage));
                    }
                    if (mapEnlistedExtra == null) {
                        break;
                    }
                    if (mapEnlistedExtra.isEmpty()) {
                        if (!fPrecommit) break;
                        evtHelper.onTransactionPreCommit(this.getEntryStatuses());
                        if (mapEnlistedExtra.isEmpty()) {
                            break;
                        }
                        fPrecommit = false;
                    }
                    mapEnlistedStatuses = mapEnlistedExtra;
                    mapEnlistedEntries = this.createEntryView(mapEnlistedStatuses);
                    mapEnlistedExtra = new LiteMap();
                    this.setEnlistedStatuses(mapEnlistedExtra);
                }
            }
            finally {
                this.setEnlistedStatuses(null);
                this.markCommitted();
            }
            return setEnlisted == null ? Collections.EMPTY_SET : setEnlisted;
        }

        public void release(boolean fUnpin) {
            this.setAttempt(0);
            this.clearStatuses();
            this.setActive(false);
            this.setReadOnlyRequest(false);
            this.setAllowReadThrough(true);
            this.setCommitted(false);
            this.getStorageMap().clear();
            ResourceCoordinator coordinator = this.getService().getResourceCoordinator();
            Set setLockedStorage = this.getLockedStorage();
            Iterator iter = setLockedStorage.iterator();
            while (iter.hasNext()) {
                coordinator.unlockAll((Storage)iter.next());
            }
            setLockedStorage.clear();
            PartitionSet partsPinned = this.getPinnedPartitions();
            if (fUnpin) {
                this.getService().unpinPartitions(partsPinned);
            }
            PartitionSet partsPinnedPre = this.getPrePinnedPartitions();
            Span span = TracingHelper.getActiveSpan();
            if (!TracingHelper.isNoop(span)) {
                partsPinned.add(partsPinnedPre);
                span.setMetadata("partitions", partsPinned.toString(false));
            }
            partsPinned.clear();
            partsPinnedPre.clear();
        }

        public void resetAccess() {
            this.setAccessSubject(null);
            this.setAccessStorage(null);
            this.setAccessGranted(0);
            this.setAccessReason(0);
        }

        public void rollback(RuntimeException e, RequestMessage msgRequest) {
            this.rollback(e, msgRequest, "");
        }

        public void rollback(RuntimeException e, RequestMessage msgRequest, String sMsg) {
            int nAttempt = this.getAttempt() + 1;
            boolean fFail = nAttempt == 15;
            String sName = msgRequest.get_Name();
            int iRequest = sName.lastIndexOf("Request");
            sName = iRequest > 0 ? sName.substring(0, iRequest) : sName;
            this.setAttempt(nAttempt);
            InvocationContext._trace(String.format("%s %s %s request originating from member %d%s.", e.getMessage(), fFail ? "Failed" : "Retrying", sName, msgRequest.getFromMember().getId(), sMsg.isEmpty() ? sMsg : " (" + sMsg + ")"), fFail ? 1 : 2);
            if (fFail) {
                GuardSupport.logStackTraces();
                throw e;
            }
            this.clearStatuses();
            Base.sleep(1L);
        }

        protected void setAccessGranted(int nReason) {
            this.__m_AccessGranted = nReason;
        }

        protected void setAccessReason(int nReason) {
            this.__m_AccessReason = nReason;
        }

        protected void setAccessStorage(Storage storage) {
            this.__m_AccessStorage = storage;
        }

        protected void setAccessSubject(Subject subject) {
            this.__m_AccessSubject = subject;
        }

        public void setActive(boolean fActive) {
            this.__m_Active = fActive;
        }

        public void setAllowReadThrough(boolean fThrough) {
            this.__m_AllowReadThrough = fThrough;
        }

        protected void setAttempt(int nAttempt) {
            this.__m_Attempt = nAttempt;
        }

        public void setCommitted(boolean fRequest) {
            this.__m_Committed = fRequest;
        }

        protected void setEnlistedStatuses(Map mapStatuses) {
            this.__m_EnlistedStatuses = mapStatuses;
        }

        protected void setLockedStorage(Set setStorage) {
            this.__m_LockedStorage = setStorage;
        }

        protected void setPinnedPartitions(PartitionSet parts) {
            this.__m_PinnedPartitions = parts;
        }

        protected void setReadOnlyRequest(boolean fReadOnly) {
            this.__m_ReadOnlyRequest = fReadOnly;
        }

        protected void setStorageEntries(Map mapEntries) {
            this.__m_StorageEntries = mapEntries;
        }

        protected void setStorageStatusMap(Map map) {
            this.__m_StorageStatusMap = map;
        }

        @Override
        public String toString() {
            return this.get_Name() + " (Active=" + !this.isReadOnly() + " StorageMap=" + String.valueOf(this.getStorageMap()) + ")";
        }

        static {
            InvocationContext.__initStatic();
        }

        public static class StorageContext
        extends WrapperContext.StorageContext {
            public StorageContext() {
                this(null, null, true);
            }

            public StorageContext(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new StorageContext();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$InvocationContext$StorageContext".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public InvocableMap.Entry getBackingMapEntry(Object oKey) {
                InvocationContext ctx = (InvocationContext)this.get_Parent();
                Binary binKey = (Binary)oKey;
                int iPart = ctx.getKeyPartition(binKey);
                if (ctx.isReadOnly()) {
                    throw new IllegalStateException("Context is read-only");
                }
                if (ctx != ctx.getService().getInvocationContext()) {
                    throw new IllegalStateException("Context can only be used on the orginal invocation thread");
                }
                if (this.isPartitionEnlisted(iPart)) {
                    try {
                        Storage.EntryStatus status = ctx.lockEntry(this.getStorage(), binKey, false);
                        return status == null ? null : status.getBinaryEntry();
                    }
                    catch (ClassCastException e) {
                        throw new ClassCastException("This BackingMapManagerContext operates on  keys and values in Binary format.");
                    }
                }
                throw new IllegalArgumentException("Attempted to enlist an entry belonging to a partition outside of this transaction: " + iPart);
            }

            @Override
            public InvocableMap.Entry getReadOnlyEntry(Object oKey) {
                Storage.EntryStatus status;
                InvocationContext ctx = (InvocationContext)this.get_Parent();
                Storage storage = this.getStorage();
                Map mapStatus = (Map)ctx.getStorageStatusMap().get(storage);
                ObservableMap mapResource = System.getSecurityManager() == null ? storage.getBackingMapInternal() : (Map)AccessController.doPrivileged(new DoAsAction(storage.getBackingMapAction()));
                Storage.EntryStatus entryStatus = status = mapStatus == null ? null : (Storage.EntryStatus)mapStatus.get((Binary)oKey);
                if (status == null) {
                    return ctx.isAllowReadThrough() || mapResource.containsKey(oKey) ? super.getReadOnlyEntry(oKey) : null;
                }
                return status.getBinaryEntry();
            }

            @Override
            protected boolean isPartitionEnlisted(int iPart) {
                InvocationContext ctx = (InvocationContext)this.get_Parent();
                return super.isPartitionEnlisted(iPart) || ctx.getPinnedPartitions().contains(iPart);
            }
        }
    }

    public static class InvokeAllRequest
    extends KeySetRequest {
        private transient InvocableMap.EntryProcessor __m_Processor;
        private Binary __m_ProcessorBinary;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("InvokeJob", InvokeJob.get_CLASS());
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public InvokeAllRequest() {
            this(null, null, true);
        }

        public InvokeAllRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(61);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        public static Component get_Instance() {
            return new InvokeAllRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$InvokeAllRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            InvokeAllRequest msg = (InvokeAllRequest)super.cloneMessage();
            msg.setProcessorBinary(this.getProcessorBinary());
            msg.setOwnershipVersions(this.getOwnershipVersions());
            return msg;
        }

        public InvocableMap.EntryProcessor deserializeProcessor() {
            InvocableMap.EntryProcessor processor = this.getProcessor();
            if (processor == null) {
                processor = (InvocableMap.EntryProcessor)ExternalizableHelper.fromBinary(this.getProcessorBinary(), this.getService().getSerializer());
                this.setProcessor(processor);
            }
            return processor;
        }

        @Override
        public int getEstimatedByteSize() {
            return -1;
        }

        public InvocableMap.EntryProcessor getProcessor() {
            return this.__m_Processor;
        }

        public Binary getProcessorBinary() {
            return this.__m_ProcessorBinary;
        }

        @Override
        protected Set instantiateKeySet(int cKeys) {
            PartitionedCache service = (PartitionedCache)this.get_Module();
            return service.isConcurrent() && !this.isTaskSplitWorthy(cKeys) ? Collections.newSetFromMap(new NullableSortedMap()) : super.instantiateKeySet(cKeys);
        }

        protected boolean isTaskSplitWorthy(int cKeys) {
            return !this.isAsyncOperation() && ((PartitionedCache)this.getService()).isTaskSplitWorthy(cKeys);
        }

        @Override
        public void onReceived() {
            PartitionedCache service = (PartitionedCache)this.getService();
            if (this.isTaskSplitWorthy(this.getKeySet().size())) {
                this.scheduleJobs();
            } else {
                service.getDaemonPool().add(this);
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setProcessorBinary((Binary)this.readObject(input));
            if (this.isAsyncOperation()) {
                PartitionVersions versions = new PartitionVersions();
                versions.readExternal(input);
                this.setOwnershipVersions(versions);
            }
            this.readTracing(input);
        }

        @Override
        public void run() {
            ((PartitionedCache)this.get_Module()).onInvokeAllRequest(this);
        }

        protected void scheduleJobs() {
            PartitionedCache service = (PartitionedCache)this.getService();
            com.tangosol.coherence.component.util.DaemonPool pool = service.getDaemonPool();
            Set setKeys = this.getKeySet();
            int cEntries = setKeys.size();
            PartialMapResponse msgResponse = (PartialMapResponse)service.instantiateMessage("PartialMapResponse");
            msgResponse.respondTo(this);
            if (this.getReadException() != null) {
                msgResponse.setException(service.tagException(this.getReadException()));
                service.post(msgResponse);
                return;
            }
            Object[] aoKey = new Object[cEntries];
            Object[] aoVal = new Object[cEntries];
            msgResponse.setKey(aoKey);
            msgResponse.setValue(aoVal);
            msgResponse.setSize(cEntries);
            Binary binProcessor = this.getProcessorBinary();
            RequestContext context = this.getRequestContext();
            BatchContext ctxBatch = service.instantiateBatchContext(msgResponse);
            SparseArray<InvokeJob> laJob = new SparseArray<InvokeJob>();
            for (Binary binKey : setKeys) {
                int iPartition = service.getKeyPartition(binKey);
                InvokeJob job = (InvokeJob)laJob.get(iPartition);
                if (job == null) {
                    job = new InvokeJob();
                    job.setRequest(this);
                    job.setService(service);
                    job.setBatchContext(ctxBatch);
                    job.setPartition(iPartition);
                    job.setProcessorBinary(binProcessor);
                    job.setRequestContext(context);
                    laJob.set(iPartition, job);
                }
                job.getMap().put(binKey, null);
            }
            ctxBatch.getOutstandingOperationCounter().set(laJob.getSize());
            int iEntry = 0;
            for (InvokeJob job : laJob) {
                job.setResultIndex(iEntry);
                iEntry += job.getMap().size();
                pool.add(job);
            }
        }

        public void setProcessor(InvocableMap.EntryProcessor processor) {
            this.__m_Processor = processor;
        }

        public void setProcessorBinary(Binary binProcessor) {
            this.__m_ProcessorBinary = binProcessor;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            this.writeObject(output, this.getProcessorBinary());
            if (this.isAsyncOperation()) {
                this.getOwnershipVersions().writeExternal(output);
            }
            this.writeTracing(output);
        }

        static {
            InvokeAllRequest.__initStatic();
        }

        public static class InvokeJob
        extends PartialJob {
            private transient Map __m_Map;
            private transient InvocableMap.EntryProcessor __m_Processor;
            private Binary __m_ProcessorBinary;
            private transient int __m_ResultIndex;
            private transient Grid __m_Service;

            public InvokeJob() {
                this(null, null, true);
            }

            public InvokeJob(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMap(new NullableSortedMap());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new InvokeJob();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$InvokeAllRequest$InvokeJob".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public InvocableMap.EntryProcessor deserializeProcessor() {
                InvocableMap.EntryProcessor processor = this.getProcessor();
                if (processor == null) {
                    processor = (InvocableMap.EntryProcessor)ExternalizableHelper.fromBinary(this.getProcessorBinary(), this.getService().getSerializer());
                    this.setProcessor(processor);
                }
                return processor;
            }

            @Override
            public String getDescription() {
                String sCacheName = ((PartitionedCache)this.get_Module()).getCacheName(this.getCacheId());
                if (sCacheName == null) {
                    sCacheName = "<unknown>";
                }
                return super.getDescription() + ", Agent=" + String.valueOf(this.getProcessor()) + ", CacheName=" + sCacheName;
            }

            public Map getMap() {
                return this.__m_Map;
            }

            public int getOwnershipVersion() {
                PartitionVersions versions = ((InvokeAllRequest)this.getRequest()).getOwnershipVersions();
                return versions == null ? -1 : versions.getVersion(this.getPartition());
            }

            public InvocableMap.EntryProcessor getProcessor() {
                return this.__m_Processor;
            }

            public Binary getProcessorBinary() {
                return this.__m_ProcessorBinary;
            }

            public int getResultIndex() {
                return this.__m_ResultIndex;
            }

            public Grid getService() {
                return this.__m_Service;
            }

            @Override
            public void run() {
                ((PartitionedCache)this.getResponse().getService()).onInvokeAllRequest(this);
            }

            protected void setMap(Map set) {
                this.__m_Map = set;
            }

            public void setProcessor(InvocableMap.EntryProcessor processor) {
                this.__m_Processor = processor;
            }

            public void setProcessorBinary(Binary binProcessor) {
                this.__m_ProcessorBinary = binProcessor;
            }

            public void setResultIndex(int iStart) {
                this.__m_ResultIndex = iStart;
            }

            public void setService(Grid service) {
                this.__m_Service = service;
            }
        }

        public static class Poll
        extends KeySetRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            @Override
            public boolean isPreprocessable() {
                return true;
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$InvokeAllRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected void processAsyncResponse(Message msg) {
                InvokeAllRequest msgRequest = (InvokeAllRequest)this.get_Parent();
                AsyncProcessorContext context = (AsyncProcessorContext)msgRequest.getRequestContext();
                PartialMapResponse msgResponse = (PartialMapResponse)msg;
                RuntimeException t = msgResponse.getException();
                if (t == null) {
                    int cSize = msgResponse.getSize();
                    Object[] aoKey = msgResponse.getKey();
                    Object[] aoVal = msgResponse.getValue();
                    for (int i = 0; i < cSize; ++i) {
                        Binary binKey = (Binary)aoKey[i];
                        Binary binVal = (Binary)aoVal[i];
                        if (binKey == null || binVal == null) continue;
                        context.processPartialResult(binKey, binVal);
                    }
                } else {
                    RequestIncompleteException e = new RequestIncompleteException("Partial failure", t);
                    List colFailedKeys = msgResponse.getFailedKeys();
                    if (colFailedKeys == null) {
                        colFailedKeys = Collections.emptyList();
                    }
                    ConverterCollections.ConverterSet setFailedKeys = new ConverterCollections.ConverterSet(colFailedKeys, context.getValueConverter(), NullImplementation.getConverter());
                    e.setPartialResult(setFailedKeys);
                    context.processPartialResult(null, e);
                }
            }
        }
    }

    public static class InvokeFilterRequest
    extends FilterRequest {
        private transient InvocableMap.EntryProcessor __m_Processor;
        private Binary __m_ProcessorBinary;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public InvokeFilterRequest() {
            this(null, null, true);
        }

        public InvokeFilterRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(62);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        public static Component get_Instance() {
            return new InvokeFilterRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$InvokeFilterRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            InvokeFilterRequest msg = (InvokeFilterRequest)super.cloneMessage();
            msg.setProcessorBinary(this.getProcessorBinary());
            msg.setOwnershipVersions(this.getOwnershipVersions());
            return msg;
        }

        public InvocableMap.EntryProcessor deserializeProcessor() {
            InvocableMap.EntryProcessor processor = this.getProcessor();
            if (processor == null) {
                processor = (InvocableMap.EntryProcessor)ExternalizableHelper.fromBinary(this.getProcessorBinary(), this.getService().getSerializer());
                this.setProcessor(processor);
            }
            return processor;
        }

        @Override
        public String getDescription() {
            return super.getDescription() + ", Agent=" + String.valueOf(this.getProcessor()) + ", Filter=" + String.valueOf(this.getFilter());
        }

        public InvocableMap.EntryProcessor getProcessor() {
            return this.__m_Processor;
        }

        public Binary getProcessorBinary() {
            return this.__m_ProcessorBinary;
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            if (this.getReadException() == null) {
                this.setProcessorBinary((Binary)this.readObject(input));
                if (this.isAsyncOperation()) {
                    PartitionVersions versions = new PartitionVersions();
                    versions.readExternal(input);
                    this.setOwnershipVersions(versions);
                }
            }
            this.readTracing(input);
        }

        @Override
        public void run() {
            ((PartitionedCache)this.getService()).onInvokeFilterRequest(this);
        }

        public void setProcessor(InvocableMap.EntryProcessor processor) {
            this.__m_Processor = processor;
        }

        public void setProcessorBinary(Binary binProcessor) {
            this.__m_ProcessorBinary = binProcessor;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            this.writeObject(output, this.getProcessorBinary());
            if (this.isAsyncOperation()) {
                this.getOwnershipVersions().writeExternal(output);
            }
            this.writeTracing(output);
        }

        static {
            InvokeFilterRequest.__initStatic();
        }

        public static class Poll
        extends PartialRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            @Override
            public boolean isPreprocessable() {
                return true;
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$InvokeFilterRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public void processAsyncResponse(Message msg) {
                InvokeFilterRequest msgRequest = (InvokeFilterRequest)this.get_Parent();
                AsyncProcessorContext context = (AsyncProcessorContext)msgRequest.getRequestContext();
                QueryResponse msgResponse = (QueryResponse)msg;
                if (msgResponse.getException() == null) {
                    int cSize = msgResponse.getSize();
                    Object[] aoResult = msgResponse.getResult();
                    for (int i = 0; i < cSize; ++i) {
                        Map.Entry entry = (Map.Entry)aoResult[i];
                        context.processPartialResult((Binary)entry.getKey(), (Binary)entry.getValue());
                    }
                } else {
                    context.processPartialResult(null, msgResponse.getException());
                }
            }
        }
    }

    public static class InvokeRequest
    extends DistributedCacheKeyRequest {
        private long __m_OrderId;
        private int __m_OwnershipVersion;
        private transient InvocableMap.EntryProcessor __m_Processor;
        private Binary __m_ProcessorBinary;
        private transient Exception __m_ReadException;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public InvokeRequest() {
            this(null, null, true);
        }

        public InvokeRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(63);
                this.setOwnershipVersion(-1);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        public static Component get_Instance() {
            return new InvokeRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$InvokeRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            InvokeRequest msg = (InvokeRequest)super.cloneMessage();
            msg.setProcessorBinary(this.getProcessorBinary());
            msg.setOrderId(this.getOrderId());
            msg.setOwnershipVersion(this.getOwnershipVersion());
            return msg;
        }

        public InvocableMap.EntryProcessor deserializeProcessor() {
            InvocableMap.EntryProcessor processor = this.getProcessor();
            if (processor == null) {
                processor = (InvocableMap.EntryProcessor)ExternalizableHelper.fromBinary(this.getProcessorBinary(), this.getService().getSerializer());
                this.setProcessor(processor);
            }
            return processor;
        }

        @Override
        public Object getAssociatedKey() {
            long lOrderId = this.getOrderId();
            return lOrderId == 0L ? super.getAssociatedKey() : Long.valueOf(lOrderId);
        }

        @Override
        public String getDescription() {
            return super.getDescription() + ", Agent=" + String.valueOf(this.getProcessor());
        }

        @Override
        public int getEstimatedByteSize() {
            return -1;
        }

        public long getOrderId() {
            return this.__m_OrderId;
        }

        public int getOwnershipVersion() {
            return this.__m_OwnershipVersion;
        }

        public InvocableMap.EntryProcessor getProcessor() {
            return this.__m_Processor;
        }

        public Binary getProcessorBinary() {
            return this.__m_ProcessorBinary;
        }

        public Exception getReadException() {
            return this.__m_ReadException;
        }

        public boolean isAsyncOperation() {
            return this.getOrderId() != 0L;
        }

        @Override
        public void post() {
            if (this.isAsyncOperation()) {
                PartitionedCache service = (PartitionedCache)this.getService();
                this.setOwnershipVersion(service.getOwnershipVersion(service.getKeyPartition(this.getKey())));
            }
            super.post();
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setProcessorBinary((Binary)this.readObject(input));
            this.setOrderId(ExternalizableHelper.readLong(input));
            if (this.isAsyncOperation()) {
                this.setOwnershipVersion(ExternalizableHelper.readInt(input));
            }
            this.readTracing(input);
        }

        @Override
        public void run() {
            ((PartitionedCache)this.getService()).onInvokeRequest(this);
        }

        public void setOrderId(long lId) {
            this.__m_OrderId = lId;
        }

        public void setOwnershipVersion(int nVersion) {
            this.__m_OwnershipVersion = nVersion;
        }

        public void setProcessor(InvocableMap.EntryProcessor agent) {
            this.__m_Processor = agent;
        }

        public void setProcessorBinary(Binary binProcessor) {
            this.__m_ProcessorBinary = binProcessor;
        }

        public void setReadException(Exception exception) {
            this.__m_ReadException = exception;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            this.writeObject(output, this.getProcessorBinary());
            ExternalizableHelper.writeLong(output, this.getOrderId());
            if (this.isAsyncOperation()) {
                ExternalizableHelper.writeInt(output, this.getOwnershipVersion());
            }
            this.writeTracing(output);
        }

        static {
            InvokeRequest.__initStatic();
        }

        public static class Poll
        extends DistributedCacheKeyRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            @Override
            public boolean isPreprocessable() {
                return true;
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$InvokeRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected void onCompletion() {
                super.onCompletion();
                InvokeRequest msgRequest = (InvokeRequest)this.get_Parent();
                if (msgRequest.isAsyncOperation()) {
                    PartitionedCache service = (PartitionedCache)this.getService();
                    RequestCoordinator coordinator = service.getRequestCoordinator();
                    Binary binKey = msgRequest.getKey();
                    int nPartition = service.getKeyPartition(binKey);
                    Object oResult = this.getResult();
                    if (oResult == RESPONSE_UNKNOWN) {
                        MemberSet setMembers = this.getRespondedMemberSet();
                        if (!coordinator.resubmitRequest((InvokeRequest)msgRequest.cloneMessage(), nPartition, !setMembers.isEmpty() && !setMembers.contains(service.getPrimaryOwner(nPartition)))) {
                            ((AsyncProcessorContext)msgRequest.getRequestContext()).processCompletion();
                        }
                    } else {
                        ((AsyncProcessorContext)msgRequest.getRequestContext()).processSingleResult(binKey, oResult);
                    }
                    coordinator.finalizeResponse(nPartition);
                }
            }

            @Override
            public void onException(Throwable eReason) {
                InvokeRequest msgRequest = (InvokeRequest)this.get_Parent();
                if (msgRequest.isAsyncOperation()) {
                    AsyncProcessorContext context = (AsyncProcessorContext)msgRequest.getRequestContext();
                    context.processException(eReason);
                }
            }

            @Override
            public boolean preprocessResponse(Message msgResponse) {
                InvokeRequest msgRequest = (InvokeRequest)this.get_Parent();
                return !msgRequest.isAsyncOperation() && super.preprocessResponse(msgResponse);
            }
        }
    }

    public static class KeyIteratorRequest
    extends PartialRequest {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public KeyIteratorRequest() {
            this(null, null, true);
        }

        public KeyIteratorRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(64);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new KeyIteratorRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$KeyIteratorRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public void run() {
            ((PartitionedCache)this.getService()).onKeyIteratorRequest(this);
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        static {
            KeyIteratorRequest.__initStatic();
        }

        public static class Poll
        extends PartialRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            @Override
            public boolean isPreprocessable() {
                return true;
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$KeyIteratorRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class KeyListenerAllRequest
    extends KeySetRequest {
        private boolean __m_Add;
        private boolean __m_Lite;
        private int __m_MemberId;
        private VersionedPartitions __m_PartitionVersions;
        private boolean __m_Priming;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("KeyListenerJob", KeyListenerJob.get_CLASS());
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public KeyListenerAllRequest() {
            this(null, null, true);
        }

        public KeyListenerAllRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(85);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new KeyListenerAllRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$KeyListenerAllRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            KeyListenerAllRequest msg = (KeyListenerAllRequest)super.cloneMessage();
            msg.setAdd(this.isAdd());
            msg.setLite(this.isLite());
            msg.setPriming(this.isPriming());
            msg.setMemberId(this.getMemberId());
            return msg;
        }

        public int getMemberId() {
            return this.__m_MemberId;
        }

        public VersionedPartitions getPartitionVersions() {
            return this.__m_PartitionVersions;
        }

        @Override
        protected Set instantiateKeySet(int cKeys) {
            return ((PartitionedCache)this.get_Module()).isConcurrent() ? Collections.newSetFromMap(new NullableSortedMap()) : super.instantiateKeySet(cKeys);
        }

        public boolean isAdd() {
            return this.__m_Add;
        }

        public boolean isLite() {
            return this.__m_Lite;
        }

        public boolean isPriming() {
            return this.__m_Priming;
        }

        @Override
        public void onReceived() {
            if (((PartitionedCache)this.getService()).getDaemonPool().getDaemonCount() > 0) {
                this.scheduleJobs();
            } else {
                super.onReceived();
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setAdd(input.readBoolean());
            this.setLite(input.readBoolean());
            this.setPriming(input.readBoolean());
            this.setMemberId(input.readUnsignedShort());
            this.readTracing(input);
            if (input.available() > 0) {
                this.setPartitionVersions((VersionedPartitions)this.readObject(input));
            }
        }

        @Override
        public void run() {
            ((PartitionedCache)this.getService()).onKeyListenerAllRequest(this);
        }

        public void scheduleJobs() {
            PartitionedCache service = (PartitionedCache)this.getService();
            com.tangosol.coherence.component.util.DaemonPool pool = service.getDaemonPool();
            Set setKeys = this.getKeySetSafe();
            int cKeys = setKeys.size();
            PartialMapResponse msgResponse = (PartialMapResponse)service.instantiateMessage("PartialMapResponse");
            msgResponse.respondTo(this);
            long lCacheId = this.getCacheId();
            BatchContext ctxBatch = service.instantiateBatchContext(msgResponse);
            RequestContext context = this.getRequestContext();
            boolean fAdd = this.isAdd();
            boolean fLite = this.isLite();
            boolean fPriming = this.isPriming();
            boolean fAsync = this.isAsyncOperation();
            Member member = this.getFromMember();
            VersionedPartitions versions = this.getPartitionVersions();
            SparseArray<KeyListenerJob> laJob = new SparseArray<KeyListenerJob>();
            for (Binary binKey : setKeys) {
                int iPartition = service.getKeyPartition(binKey);
                KeyListenerJob job = (KeyListenerJob)laJob.get(iPartition);
                if (job == null) {
                    job = new KeyListenerJob();
                    job.setBatchContext(ctxBatch);
                    job.setRequest(this);
                    job.setPartition(iPartition);
                    job.setService(service);
                    job.setRequestContext(context);
                    job.setAdd(fAdd);
                    job.setLite(fLite);
                    job.setFromMember(member);
                    job.setPriming(fPriming);
                    if (versions != null) {
                        job.setPartitionVersion(versions.getVersion(iPartition));
                    }
                    laJob.set(iPartition, job);
                }
                job.getMap().put(binKey, null);
            }
            ctxBatch.getOutstandingOperationCounter().set(laJob.getSize());
            Iterator iter = laJob.iterator();
            while (iter.hasNext()) {
                pool.add((Runnable)iter.next());
            }
        }

        public void setAdd(boolean fAdd) {
            this.__m_Add = fAdd;
        }

        public void setLite(boolean fLite) {
            this.__m_Lite = fLite;
        }

        public void setMemberId(int nId) {
            this.__m_MemberId = nId;
        }

        public void setPartitionVersions(VersionedPartitions version) {
            this.__m_PartitionVersions = version;
        }

        public void setPriming(boolean fPriming) {
            this.__m_Priming = fPriming;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeBoolean(this.isAdd());
            output.writeBoolean(this.isLite());
            output.writeBoolean(this.isPriming());
            output.writeShort(this.getMemberId());
            this.writeTracing(output);
            this.writeObject(output, this.getPartitionVersions());
        }

        static {
            KeyListenerAllRequest.__initStatic();
        }

        public static class KeyListenerJob
        extends PartialJob {
            private boolean __m_Add;
            private boolean __m_AsyncOperation;
            private Member __m_FromMember;
            private boolean __m_Lite;
            private Map __m_Map;
            private int __m_MemberId;
            private long __m_PartitionVersion;
            private boolean __m_Priming;
            private Grid __m_Service;

            public KeyListenerJob() {
                this(null, null, true);
            }

            public KeyListenerJob(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMap(new NullableSortedMap());
                    this.setPartitionVersion(Long.MIN_VALUE);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new KeyListenerJob();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$KeyListenerAllRequest$KeyListenerJob".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public boolean equals(Object obj) {
                Grid service = null;
                long lCacheId = 0L;
                int nPartition = -1;
                if (obj instanceof KeyListenerRequest) {
                    KeyListenerRequest that = (KeyListenerRequest)obj;
                    service = that.getService();
                    lCacheId = that.getCacheId();
                    nPartition = that.getPartition();
                } else if (obj instanceof KeyListenerJob) {
                    KeyListenerJob that = (KeyListenerJob)obj;
                    service = that.getService();
                    lCacheId = that.getCacheId();
                    nPartition = that.getPartition();
                }
                return this.getService() == service && this.getCacheId() == lCacheId && this.getPartition() == nPartition;
            }

            @Override
            public Object getAssociatedKey() {
                return this;
            }

            public Member getFromMember() {
                return this.__m_FromMember;
            }

            public Map getMap() {
                return this.__m_Map;
            }

            public int getMemberId() {
                return this.__m_MemberId;
            }

            public long getPartitionVersion() {
                return this.__m_PartitionVersion;
            }

            public Grid getService() {
                return this.__m_Service;
            }

            public int hashCode() {
                return HashHelper.hash(this.getCacheId(), this.getPartition());
            }

            public boolean isAdd() {
                return this.__m_Add;
            }

            public boolean isAsyncOperation() {
                return this.__m_AsyncOperation;
            }

            public boolean isLite() {
                return this.__m_Lite;
            }

            public boolean isPriming() {
                return this.__m_Priming;
            }

            public boolean isVersioned() {
                return this.getPartitionVersion() != Long.MIN_VALUE;
            }

            @Override
            public void run() {
                ((PartitionedCache)this.getResponse().getService()).onKeyListenerAllRequest(this);
            }

            public void setAdd(boolean fAdd) {
                this.__m_Add = fAdd;
            }

            public void setAsyncOperation(boolean fOperation) {
                this.__m_AsyncOperation = fOperation;
            }

            public void setFromMember(Member memberFrom) {
                this.__m_FromMember = memberFrom;
            }

            public void setLite(boolean fLite) {
                this.__m_Lite = fLite;
            }

            public void setMap(Map map) {
                this.__m_Map = map;
            }

            public void setMemberId(int nId) {
                this.__m_MemberId = nId;
            }

            public void setPartitionVersion(long lVersion) {
                this.__m_PartitionVersion = lVersion;
            }

            public void setPriming(boolean fPriming) {
                this.__m_Priming = fPriming;
            }

            public void setService(Grid gridService) {
                this.__m_Service = gridService;
            }
        }

        public static class Poll
        extends KeySetRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$KeyListenerAllRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class KeyListenerRequest
    extends DistributedCacheKeyRequest {
        private boolean __m_Add;
        private boolean __m_Lite;
        private int __m_MemberId;
        public static final long NOT_VERSIONED = Long.MIN_VALUE;
        private int __m_Partition;
        private long __m_PartitionVersion;
        private boolean __m_Priming;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public KeyListenerRequest() {
            this(null, null, true);
        }

        public KeyListenerRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(65);
                this.setPartitionVersion(Long.MIN_VALUE);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        public static Component get_Instance() {
            return new KeyListenerRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$KeyListenerRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            KeyListenerRequest msg = (KeyListenerRequest)super.cloneMessage();
            msg.setAdd(this.isAdd());
            msg.setLite(this.isLite());
            msg.setPriming(this.isPriming());
            msg.setMemberId(this.getMemberId());
            msg.setPartitionVersion(this.getPartitionVersion());
            return msg;
        }

        @Override
        public boolean equals(Object obj) {
            Grid service = null;
            long lCacheId = 0L;
            int nPartition = -1;
            if (obj instanceof KeyListenerRequest) {
                KeyListenerRequest that = (KeyListenerRequest)obj;
                service = that.getService();
                lCacheId = that.getCacheId();
                nPartition = that.getPartition();
            } else if (obj instanceof KeyListenerAllRequest.KeyListenerJob) {
                KeyListenerAllRequest.KeyListenerJob that = (KeyListenerAllRequest.KeyListenerJob)obj;
                service = that.getService();
                lCacheId = that.getCacheId();
                nPartition = that.getPartition();
            }
            return this.getService() == service && this.getCacheId() == lCacheId && this.getPartition() == nPartition;
        }

        @Override
        public int getEstimatedByteSize() {
            return -1;
        }

        public int getMemberId() {
            return this.__m_MemberId;
        }

        public int getPartition() {
            return this.__m_Partition;
        }

        public long getPartitionVersion() {
            return this.__m_PartitionVersion;
        }

        @Override
        public int hashCode() {
            return HashHelper.hash(this.getCacheId(), this.getPartition());
        }

        public boolean isAdd() {
            return this.__m_Add;
        }

        public boolean isLite() {
            return this.__m_Lite;
        }

        public boolean isPriming() {
            return this.__m_Priming;
        }

        public boolean isVersioned() {
            return this.getPartitionVersion() != Long.MIN_VALUE;
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setAdd(input.readBoolean());
            this.setLite(input.readBoolean());
            this.setPriming(input.readBoolean());
            this.setMemberId(input.readUnsignedShort());
            this.readTracing(input);
            if (input.available() > 0) {
                this.setPartitionVersion(ExternalizableHelper.readLong(input));
            }
        }

        @Override
        public void run() {
            ((PartitionedCache)this.getService()).onKeyListenerRequest(this);
        }

        public void setAdd(boolean fAdd) {
            this.__m_Add = fAdd;
        }

        public void setLite(boolean fLite) {
            this.__m_Lite = fLite;
        }

        public void setMemberId(int nMemberId) {
            this.__m_MemberId = nMemberId;
        }

        public void setPartition(int nPartition) {
            this.__m_Partition = nPartition;
        }

        public void setPartitionVersion(long lVersion) {
            this.__m_PartitionVersion = lVersion;
        }

        public void setPriming(boolean fLite) {
            this.__m_Priming = fLite;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeBoolean(this.isAdd());
            output.writeBoolean(this.isLite());
            output.writeBoolean(this.isPriming());
            output.writeShort(this.getMemberId());
            this.writeTracing(output);
            ExternalizableHelper.writeLong(output, this.getPartitionVersion());
        }

        static {
            KeyListenerRequest.__initStatic();
        }

        public static class Poll
        extends DistributedCacheKeyRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$KeyListenerRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class ListenerRequest
    extends StorageRequest {
        private boolean __m_Add;
        private Filter __m_Filter;
        private long __m_FilterId;
        private boolean __m_Lite;
        private int __m_MemberId;
        private PartitionSet __m_Partitions;
        private VersionedPartitions __m_PartitionVersions;
        private MapTrigger __m_Trigger;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public ListenerRequest() {
            this(null, null, true);
        }

        public ListenerRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(66);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        public static Component get_Instance() {
            return new ListenerRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$ListenerRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            ListenerRequest msg = (ListenerRequest)super.cloneMessage();
            msg.setFilter(this.getFilter());
            msg.setTrigger(this.getTrigger());
            msg.setFilterId(this.getFilterId());
            msg.setAdd(this.isAdd());
            msg.setLite(this.isLite());
            msg.setMemberId(this.getMemberId());
            msg.setPartitionVersions(this.getPartitionVersions());
            msg.setPartitions(this.getPartitions());
            msg.setRequestContext(this.getRequestContext());
            return msg;
        }

        @Override
        public Object getAssociatedKey() {
            return this.getCacheId();
        }

        public Filter getFilter() {
            return this.__m_Filter;
        }

        public long getFilterId() {
            return this.__m_FilterId;
        }

        public int getMemberId() {
            return this.__m_MemberId;
        }

        public PartitionSet getPartitions() {
            return this.__m_Partitions;
        }

        public VersionedPartitions getPartitionVersions() {
            return this.__m_PartitionVersions;
        }

        @Override
        public PartitionSet getRequestPartitions() {
            return this.getPartitions();
        }

        public MapTrigger getTrigger() {
            return this.__m_Trigger;
        }

        public boolean isAdd() {
            return this.__m_Add;
        }

        public boolean isLite() {
            return this.__m_Lite;
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            try {
                this.setFilter((Filter)this.readObject(input));
                this.setTrigger((MapTrigger)this.readObject(input));
            }
            catch (Throwable t) {
                this.setReadException(Base.ensureRuntimeException(t));
            }
            this.setFilterId(ExternalizableHelper.readLong(input));
            this.setAdd(input.readBoolean());
            this.setLite(input.readBoolean());
            this.setMemberId(input.readInt());
            this.readTracing(input);
            if (input.available() > 0) {
                this.setPartitionVersions((VersionedPartitions)this.readObject(input));
                this.setPartitions((PartitionSet)this.readObject(input));
            }
        }

        @Override
        public void run() {
            ((PartitionedCache)this.getService()).onListenerRequest(this);
        }

        public void setAdd(boolean fAdd) {
            this.__m_Add = fAdd;
        }

        public void setFilter(Filter filter) {
            this.__m_Filter = filter;
        }

        public void setFilterId(long lFilterId) {
            this.__m_FilterId = lFilterId;
        }

        public void setLite(boolean fLite) {
            this.__m_Lite = fLite;
        }

        public void setMemberId(int nMember) {
            this.__m_MemberId = nMember;
        }

        public void setPartitions(PartitionSet parts) {
            this.__m_Partitions = parts;
        }

        public void setPartitionVersions(VersionedPartitions partitionsVersions) {
            this.__m_PartitionVersions = partitionsVersions;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        @Override
        public void setResponse(SimpleResponse msgResponse) {
            super.setResponse(msgResponse);
        }

        public void setTrigger(MapTrigger trigger) {
            this.__m_Trigger = trigger;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            try {
                this.writeObject(output, this.getFilter());
            }
            catch (IOException e) {
                ListenerRequest._trace("Filter is not serializable: " + String.valueOf(this.getFilter()), 1);
                throw e;
            }
            try {
                this.writeObject(output, this.getTrigger());
            }
            catch (IOException e) {
                ListenerRequest._trace("MapTrigger is not serializable: " + String.valueOf(this.getTrigger()), 1);
                throw e;
            }
            ExternalizableHelper.writeLong(output, this.getFilterId());
            output.writeBoolean(this.isAdd());
            output.writeBoolean(this.isLite());
            output.writeInt(this.getMemberId());
            this.writeTracing(output);
            this.writeObject(output, this.getPartitionVersions());
            this.writeObject(output, this.getPartitions());
        }

        static {
            ListenerRequest.__initStatic();
        }

        public static class Poll
        extends StorageRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$ListenerRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class LockRequest
    extends DistributedCacheKeyRequest {
        private transient long __m_LeaseExpiration;
        private int __m_LeaseHolderId;
        private long __m_LeaseMillis;
        private long __m_LeaseThreadId;
        private long __m_LeaseWaitMillis;
        private transient long __m_LeaseWaitTimeout;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public LockRequest() {
            this(null, null, true);
        }

        public LockRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(67);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        public static Component get_Instance() {
            return new LockRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$LockRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            LockRequest msg = (LockRequest)super.cloneMessage();
            msg.fromLease(this.toLease());
            msg.setLeaseWaitMillis(this.getRequestTimeoutMillis());
            return msg;
        }

        public void fromLease(Lease lease) {
            this.setKey((Binary)lease.getResourceKey());
            this.setLeaseHolderId(lease.getHolderId());
            this.setLeaseThreadId(lease.getHolderThreadId());
            long ldtExpiry = lease.getExpirationTime();
            if (ldtExpiry > 0L) {
                this.setLeaseMillis(Math.max(0L, ldtExpiry - ((PartitionedCache)this.get_Module()).getClusterTime()));
            }
        }

        @Override
        public String getDescription() {
            return super.getDescription() + "\nWaitTimeout=" + this.getLeaseWaitTimeout() + ", LeaseExpiration=" + this.getLeaseExpiration();
        }

        @Override
        public int getEstimatedByteSize() {
            return -1;
        }

        public long getLeaseExpiration() {
            long ldtExpiry = this.__m_LeaseExpiration;
            if (ldtExpiry == 0L) {
                PartitionedCache service = (PartitionedCache)this.getService();
                ldtExpiry = service.adjustWaitTime(this.getLeaseMillis() - 1L, -3L);
                this.setLeaseExpiration(ldtExpiry);
            }
            return ldtExpiry;
        }

        public int getLeaseHolderId() {
            return this.__m_LeaseHolderId;
        }

        public long getLeaseMillis() {
            return this.__m_LeaseMillis;
        }

        public long getLeaseThreadId() {
            return this.__m_LeaseThreadId;
        }

        public long getLeaseWaitMillis() {
            return this.__m_LeaseWaitMillis;
        }

        public long getLeaseWaitTimeout() {
            long ldtTimeout = this.__m_LeaseWaitTimeout;
            if (ldtTimeout == 0L) {
                PartitionedCache service = (PartitionedCache)this.getService();
                ldtTimeout = service.adjustWaitTime(this.getLeaseWaitMillis(), -3L);
                this.setLeaseWaitTimeout(ldtTimeout);
            }
            return ldtTimeout;
        }

        @Override
        public long getRequestTimeoutMillis() {
            long cWait = this.getLeaseWaitMillis();
            if (cWait < 0L) {
                return cWait;
            }
            long cDefault = this.getService().getRequestTimeout();
            if (cDefault <= 0L) {
                return cDefault;
            }
            if (cWait < cDefault) {
                return cDefault;
            }
            return Math.min(cWait, Long.MAX_VALUE - cDefault) + cDefault;
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setLeaseHolderId(input.readUnsignedShort());
            this.setLeaseThreadId(ExternalizableHelper.readLong(input));
            this.setLeaseMillis(ExternalizableHelper.readLong(input));
            this.setLeaseWaitMillis(ExternalizableHelper.readLong(input));
            this.readTracing(input);
        }

        @Override
        public void run() {
            ((PartitionedCache)this.getService()).onLockRequest(this);
        }

        protected void setLeaseExpiration(long ltExpiration) {
            this.__m_LeaseExpiration = ltExpiration;
        }

        public void setLeaseHolderId(int nHolderId) {
            this.__m_LeaseHolderId = nHolderId;
        }

        public void setLeaseMillis(long cMillis) {
            this.__m_LeaseMillis = cMillis;
            this.setLeaseExpiration(0L);
        }

        public void setLeaseThreadId(long lThreadId) {
            this.__m_LeaseThreadId = lThreadId;
        }

        public void setLeaseWaitMillis(long cMillis) {
            this.__m_LeaseWaitMillis = cMillis;
            this.setLeaseWaitTimeout(0L);
        }

        protected void setLeaseWaitTimeout(long ldtTimeout) {
            this.__m_LeaseWaitTimeout = ldtTimeout;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        public Lease toLease() {
            Lease lease = Lease.instantiate(0, this.getKey(), this.getService());
            lease.setHolderId(this.getLeaseHolderId());
            lease.setHolderThreadId(this.getLeaseThreadId());
            lease.setExpirationTime(this.getLeaseExpiration());
            return lease;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeShort(this.getLeaseHolderId());
            ExternalizableHelper.writeLong(output, this.getLeaseThreadId());
            ExternalizableHelper.writeLong(output, this.getLeaseMillis());
            ExternalizableHelper.writeLong(output, this.getLeaseWaitMillis());
            this.writeTracing(output);
        }

        static {
            LockRequest.__initStatic();
        }

        public static class Poll
        extends DistributedCacheKeyRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$LockRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class MapEvent
    extends MapEventMessage {
        public MapEvent() {
            this(null, null, true);
        }

        public MapEvent(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(68);
                this.setNotifyDelivery(true);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MapEvent();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$MapEvent".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getCacheName() {
            PartitionedCache service = (PartitionedCache)this.getService();
            BinaryMap mapBinary = (BinaryMap)service.getBinaryMapArray().get(this.getCacheId());
            return mapBinary == null ? super.getCacheName() : mapBinary.getCacheName();
        }

        @Override
        public DeltaCompressor getDeltaCompressor() {
            return ((PartitionedCache)this.getService()).getEventDeltaCompressor();
        }

        @Override
        public int getEstimatedByteSize() {
            return -1;
        }

        @Override
        public void onDelivery() {
            ((PartitionedCache)this.getService()).unregisterEvent(this);
            super.onDelivery();
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ((PartitionedCache)this.getService()).onMapEvent(this);
        }
    }

    public static class MemberWelcome
    extends PartitionedService.MemberWelcome {
        private List __m_PostWelcomeRequests;

        public MemberWelcome() {
            this(null, null, true);
        }

        public MemberWelcome(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-2);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MemberWelcome();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$MemberWelcome".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return super.getDescription() + ", PostWelcomeRequests=" + String.valueOf(this.getPostWelcomeRequests());
        }

        public List getPostWelcomeRequests() {
            return this.__m_PostWelcomeRequests;
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            if (this.isRejected()) {
                return;
            }
            PartitionedCache service = (PartitionedCache)this.getService();
            Member memberThis = service.getThisMember();
            int cRequests = input.readInt();
            if (cRequests > 0) {
                LinkedList<Message> listRequests = new LinkedList<Message>();
                for (int i = 0; i < cRequests; ++i) {
                    int nMsgType = input.readInt();
                    Message msgRegister = service.instantiateMessage(nMsgType);
                    Binary binMsg = new Binary();
                    binMsg.readExternal(input);
                    msgRegister.read(binMsg.getBufferInput());
                    msgRegister.addToMember(memberThis);
                    listRequests.add(msgRegister);
                }
                this.setPostWelcomeRequests(listRequests);
            }
        }

        public void setPostWelcomeRequests(List listRequests) {
            this.__m_PostWelcomeRequests = listRequests;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            if (this.isRejected()) {
                return;
            }
            List listRequests = this.getPostWelcomeRequests();
            if (listRequests == null) {
                output.writeInt(0);
            } else {
                output.writeInt(listRequests.size());
                for (Message msgRequest : listRequests) {
                    output.writeInt(msgRequest.getMessageType());
                    BinaryWriteBuffer bufTemp = new BinaryWriteBuffer(1024);
                    msgRequest.write(bufTemp.getBufferOutput());
                    bufTemp.toBinary().writeExternal(output);
                }
            }
        }
    }

    public static class MemberWelcomeRequest
    extends PartitionedService.MemberWelcomeRequest {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public MemberWelcomeRequest() {
            this(null, null, true);
        }

        public MemberWelcomeRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-1);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MemberWelcomeRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$MemberWelcomeRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            PartitionedCache service = (PartitionedCache)this.getService();
            PartitionedCache.removeSUIDRange(service.getProcessedEvents(), this.getFromMember().getId(), false);
        }

        @Override
        protected Grid.MemberWelcome populateWelcomeMessage() {
            MemberWelcome msgWelcome = (MemberWelcome)super.populateWelcomeMessage();
            if (!msgWelcome.isRejected()) {
                msgWelcome.setPostWelcomeRequests(((PartitionedCache)this.getService()).createWelcomeRequests(this.getFromMember()));
            }
            return msgWelcome;
        }

        static {
            MemberWelcomeRequest.__initStatic();
        }

        public static class Poll
        extends Grid.MemberWelcomeRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$MemberWelcomeRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public void onResponse(Message msg) {
                List listRequests;
                MemberWelcome msgWelcome = (MemberWelcome)msg;
                if (!msgWelcome.isRejected() && (listRequests = msgWelcome.getPostWelcomeRequests()) != null) {
                    PartitionedCache service = (PartitionedCache)this.getService();
                    MemberSet setThis = SingleMemberSet.instantiate(service.getThisMember());
                    for (Message msgRequest : listRequests) {
                        msgRequest.setToMemberSet(setThis);
                        service.post(msgRequest);
                    }
                }
                super.onResponse(msg);
            }
        }
    }

    public static class OwnershipRequest
    extends PartitionedService.OwnershipRequest {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", PartitionedService.OwnershipRequest.Poll.get_CLASS());
        }

        public OwnershipRequest() {
            this(null, null, true);
        }

        public OwnershipRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(33);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new OwnershipRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$OwnershipRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        static {
            OwnershipRequest.__initStatic();
        }
    }

    public static class PartialMapResponse
    extends DistributedPartialResponse {
        private Collection __m_FailedKeys;
        private Object[] __m_Key;
        private int __m_Size;
        private Object[] __m_Value;

        public PartialMapResponse() {
            this(null, null, true);
        }

        public PartialMapResponse(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(69);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PartialMapResponse();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$PartialMapResponse".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public int getEstimatedByteSize() {
            return this.getValue() instanceof Binary[] ? -1 : 0;
        }

        public Collection getFailedKeys() {
            return this.__m_FailedKeys;
        }

        public Object[] getKey() {
            return this.__m_Key;
        }

        public int getSize() {
            return this.__m_Size;
        }

        public Object[] getValue() {
            return this.__m_Value;
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            if (this.getException() == null) {
                int cSize = ExternalizableHelper.readInt(input);
                Object[] aoKey = new Object[cSize];
                Object[] aoVal = new Object[cSize];
                for (int i = 0; i < cSize; ++i) {
                    aoKey[i] = (Binary)this.readObject(input);
                    aoVal[i] = (Binary)this.readObject(input);
                }
                this.setSize(cSize);
                this.setKey(aoKey);
                this.setValue(aoVal);
            } else {
                int cColSize = input.readPackedInt();
                if (cColSize > 0) {
                    ArrayList<Object> list = new ArrayList<Object>(cColSize);
                    for (int i = 0; i < cColSize; ++i) {
                        list.add(this.readObject(input));
                    }
                    this.setFailedKeys(list);
                }
            }
        }

        public void setFailedKeys(Collection colKeys) {
            this.__m_FailedKeys = colKeys;
        }

        public void setKey(Object[] abin) {
            this.__m_Key = abin;
        }

        public void setSize(int c) {
            this.__m_Size = c;
        }

        public void setValue(Object[] abin) {
            this.__m_Value = abin;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            if (this.getException() == null) {
                int cSize = this.getSize();
                Object[] aoKey = this.getKey();
                Object[] aoVal = this.getValue();
                int cKeys = aoKey == null ? 0 : aoKey.length;
                int cValues = aoVal == null ? 0 : aoVal.length;
                PartialMapResponse._assert(cKeys == cValues && cSize <= cKeys);
                ExternalizableHelper.writeInt(output, cSize);
                int cActualSize = 0;
                for (int i = 0; i < cKeys; ++i) {
                    Binary binKey = (Binary)aoKey[i];
                    if (binKey == null) continue;
                    this.writeObject(output, binKey);
                    this.writeObject(output, aoVal[i]);
                    ++cActualSize;
                }
                if (cActualSize != cSize) {
                    PartialMapResponse._trace("Invalid response size: expected=" + cSize + ", actual=" + cActualSize, 1);
                }
            } else {
                Collection colResult = this.getFailedKeys();
                if (colResult == null) {
                    output.writePackedInt(-1);
                } else {
                    output.writePackedInt(colResult.size());
                    Iterator iter = colResult.iterator();
                    while (iter.hasNext()) {
                        this.writeObject(output, iter.next());
                    }
                }
            }
        }
    }

    public static class PartialValueResponse
    extends DistributedPartialResponse {
        private boolean __m_Collection;
        private Collection __m_FailedKeys;
        private Object __m_Result;

        public PartialValueResponse() {
            this(null, null, true);
        }

        public PartialValueResponse(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setCollection(false);
                this.setMessageType(70);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PartialValueResponse();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$PartialValueResponse".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public int getEstimatedByteSize() {
            return -1;
        }

        public Collection getFailedKeys() {
            return this.__m_FailedKeys;
        }

        public Object getResult() {
            return this.__m_Result;
        }

        public boolean isCollection() {
            return this.__m_Collection;
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            if (this.getException() == null) {
                int cSize = input.readPackedInt();
                if (cSize >= 0) {
                    ArrayList<Object> list = new ArrayList<Object>(cSize);
                    for (int i = 0; i < cSize; ++i) {
                        list.add(this.readObject(input));
                    }
                    this.setCollectionResult(list);
                } else {
                    this.setResult(this.readObject(input));
                }
            } else {
                int cSize = input.readPackedInt();
                if (cSize >= 0) {
                    ArrayList<Object> list = new ArrayList<Object>(cSize);
                    for (int i = 0; i < cSize; ++i) {
                        list.add(this.readObject(input));
                    }
                    this.setFailedKeys(list);
                }
            }
        }

        protected void setCollection(boolean fCollection) {
            this.__m_Collection = fCollection;
        }

        public void setCollectionResult(Collection colResult) {
            this.setCollection(true);
            this.setResult(colResult);
        }

        public void setFailedKeys(Collection colKeys) {
            this.__m_FailedKeys = colKeys;
        }

        public void setResult(Object oResult) {
            this.__m_Result = oResult;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            if (this.getException() == null) {
                if (this.isCollection()) {
                    Collection col = (Collection)this.getResult();
                    output.writePackedInt(col.size());
                    Iterator iter = col.iterator();
                    while (iter.hasNext()) {
                        this.writeObject(output, iter.next());
                    }
                } else {
                    output.writePackedInt(-1);
                    this.writeObject(output, this.getResult());
                }
            } else {
                Collection col = this.getFailedKeys();
                if (col == null) {
                    output.writePackedInt(-1);
                } else {
                    output.writePackedInt(col.size());
                    Iterator iter = col.iterator();
                    while (iter.hasNext()) {
                        this.writeObject(output, iter.next());
                    }
                }
            }
        }
    }

    public static class PartitionAbandonRequest
    extends PartitionedService.PartitionAbandonRequest {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", PartitionedService.PartitionAbandonRequest.Poll.get_CLASS());
        }

        public PartitionAbandonRequest() {
            this(null, null, true);
        }

        public PartitionAbandonRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(46);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PartitionAbandonRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$PartitionAbandonRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        static {
            PartitionAbandonRequest.__initStatic();
        }
    }

    public static class PartitionControl
    extends PartitionedService.PartitionControl {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("GuardContinuation", PartitionedService.PartitionControl.GuardContinuation.get_CLASS());
        }

        public PartitionControl() {
            this(null, null, true);
        }

        public PartitionControl(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setDeferredBackups(new CircularArrayList());
                this.setPersistentBackupExtents(new CopyOnWriteLongList());
                this.setPersistentExtents(new CopyOnWriteLongList());
                this.setVersionCounter(new AtomicLong());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PartitionControl();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$PartitionControl".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public void deletePersistentExtent(long lExtentId, LongArray laCaches) {
            for (PersistentStore store : new PersistentStore[]{this.getPersistentStore(), this.getPersistentEventsStore()}) {
                if (store == null) continue;
                CachePersistenceHelper.deleteExtents(store, lExtentId);
                CachePersistenceHelper.storeCacheNames(store, laCaches);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean ensureBackupPersistentExtent(long lExtentId) {
            CopyOnWriteLongList listExtents = this.getPersistentBackupExtents();
            Map mapGraveyard = ((PartitionedCache)this.get_Module()).getStorageGraveyard();
            if (mapGraveyard.containsKey(lExtentId)) {
                return false;
            }
            if (listExtents.contains(lExtentId)) {
                boolean fCreatedExtent = false;
                PartitionControl partitionControl = this;
                synchronized (partitionControl) {
                    fCreatedExtent = listExtents.contains(lExtentId);
                    if (fCreatedExtent) {
                        LongArray laCaches = null;
                        PersistentStore store = this.ensureOpenPersistentStore(null, true, true);
                        if (store != null && store.ensureExtent(lExtentId)) {
                            if (laCaches == null) {
                                laCaches = ((PartitionedCache)this.get_Module()).getPersistentCacheIds();
                            }
                            CachePersistenceHelper.storeCacheNames(store, laCaches);
                        }
                        listExtents.remove(lExtentId);
                    }
                }
                if (fCreatedExtent && mapGraveyard.containsKey(lExtentId)) {
                    CachePersistenceHelper.deleteExtents(this.ensurePersistentStore(null, false, true), lExtentId);
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean ensurePersistentExtent(long lExtentId) {
            CopyOnWriteLongList listExtents = this.getPersistentExtents();
            Map mapGraveyard = ((PartitionedCache)this.get_Module()).getStorageGraveyard();
            if (mapGraveyard.containsKey(lExtentId)) {
                return false;
            }
            if (listExtents.contains(lExtentId) && !this.isRecovering()) {
                PersistentStore storeEvents = this.getPersistentEventsStore();
                boolean fCreatedExtent = false;
                PartitionControl partitionControl = this;
                synchronized (partitionControl) {
                    fCreatedExtent = listExtents.contains(lExtentId);
                    if (fCreatedExtent) {
                        LongArray laCaches = null;
                        PersistentStore[] aStore = new PersistentStore[]{this.ensureOpenPersistentStore(), storeEvents};
                        int c = aStore.length;
                        for (int i = 0; i < c; ++i) {
                            PersistentStore store = aStore[i];
                            if (store == null || !store.ensureExtent(lExtentId)) continue;
                            if (laCaches == null) {
                                laCaches = ((PartitionedCache)this.get_Module()).getPersistentCacheIds();
                            }
                            CachePersistenceHelper.storeCacheNames(aStore[i], laCaches);
                        }
                        listExtents.remove(lExtentId);
                    }
                }
                if (fCreatedExtent && mapGraveyard.containsKey(lExtentId)) {
                    CachePersistenceHelper.deleteExtents(this.ensureOpenPersistentStore(), lExtentId);
                    if (storeEvents != null) {
                        storeEvents.deleteExtent(lExtentId);
                    }
                    return false;
                }
            }
            return true;
        }

        @Override
        public void onProcessedActions() {
            super.onProcessedActions();
            ((PartitionedCache)this.getService()).processChanges();
        }

        public void preparePersistentBackupExtents() {
            LongArray laCaches = ((PartitionedCache)this.get_Module()).getPersistentCacheIds();
            CopyOnWriteLongList listExtents = this.getPersistentBackupExtents();
            Iterator iter = laCaches.iterator();
            while (iter.hasNext()) {
                iter.next();
                long lCacheId = iter.getIndex();
                listExtents.add(lCacheId);
            }
        }

        @Override
        public void preparePersistentExtent(long lExtentId, LongArray laCaches, boolean fBackup) {
            if (fBackup) {
                this.getPersistentBackupExtents().add(lExtentId);
            } else {
                this.getPersistentExtents().add(lExtentId);
            }
        }

        @Override
        public void preparePersistentExtents() {
            this.preparePersistentExtents(null);
        }

        @Override
        public void preparePersistentExtents(LongArray laExtentsExclude) {
            LongArray laCaches = ((PartitionedCache)this.get_Module()).getPersistentCacheIds();
            CopyOnWriteLongList listExtents = this.getPersistentExtents();
            Iterator iter = laCaches.iterator();
            while (iter.hasNext()) {
                iter.next();
                long lCacheId = iter.getIndex();
                if (laExtentsExclude != null && laExtentsExclude.exists(lCacheId)) continue;
                listExtents.add(lCacheId);
            }
        }

        @Override
        public void truncatePersistentExtent(long lExtentId) {
            if (!this.getPersistentExtents().contains(lExtentId)) {
                this.getPersistentStore().truncateExtent(lExtentId);
                PersistentStore storeEvents = this.getPersistentEventsStore();
                if (storeEvents != null) {
                    storeEvents.truncateExtent(lExtentId);
                }
            }
        }

        @Override
        public PartitionStatistics updateDirectStorageSize() {
            PartitionedCache service = (PartitionedCache)this.get_Module();
            long cbStorage = 0L;
            int nPart = this.getPartitionId();
            for (Storage storage : service.getStorageArray()) {
                PartitionAwareBackingMap mapPABM;
                if (storage.isAdjustPartitionSize() || (mapPABM = storage.getPartitionAwareBackingMap()) == null) continue;
                ConfigurableCacheMap mapCCM = (ConfigurableCacheMap)mapPABM.getPartitionMap(nPart);
                cbStorage += (long)(mapCCM.getUnits() * mapCCM.getUnitFactor());
            }
            return this.getStatistics().setDirectStorageSize(cbStorage);
        }

        static {
            PartitionControl.__initStatic();
        }
    }

    public static class PartitionRecoverRequest
    extends PartitionedService.PartitionRecoverRequest {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", PartitionedService.PartitionRecoverRequest.Poll.get_CLASS());
            __mapChildren.put("RecoverJob", PartitionedService.PartitionRecoverRequest.RecoverJob.get_CLASS());
        }

        public PartitionRecoverRequest() {
            this(null, null, true);
        }

        public PartitionRecoverRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(43);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PartitionRecoverRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$PartitionRecoverRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        static {
            PartitionRecoverRequest.__initStatic();
        }
    }

    public static class PartitionSwapRequest
    extends PartitionedService.PartitionSwapRequest {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", PartitionedService.PartitionSwapRequest.Poll.get_CLASS());
        }

        public PartitionSwapRequest() {
            this(null, null, true);
        }

        public PartitionSwapRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(39);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PartitionSwapRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$PartitionSwapRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        static {
            PartitionSwapRequest.__initStatic();
        }
    }

    public static class PartitionVersionSyncRequest
    extends PartitionedService.PartitionVersionSyncRequest {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", PartitionedService.PartitionVersionSyncRequest.Poll.get_CLASS());
        }

        public PartitionVersionSyncRequest() {
            this(null, null, true);
        }

        public PartitionVersionSyncRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(41);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PartitionVersionSyncRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$PartitionVersionSyncRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        static {
            PartitionVersionSyncRequest.__initStatic();
        }
    }

    public static class PersistenceControl
    extends PartitionedService.PersistenceControl {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("EventsVisitor", EventsVisitor.get_CLASS());
            __mapChildren.put("RecoveryVisitor", RecoveryVisitor.get_CLASS());
            __mapChildren.put("SnapshotBuilder", SnapshotBuilder.get_CLASS());
            __mapChildren.put("SnapshotController", PartitionedService.PersistenceControl.SnapshotController.get_CLASS());
        }

        public PersistenceControl() {
            this(null, null, true);
        }

        public PersistenceControl(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setActiveRecoveryRequests(new AtomicInteger());
                this.setPartitionVersionExclusionList(new PartitionVersionExclusionList());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PersistenceControl();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$PersistenceControl".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public RecoveryVisitor instantiateRecoveryVisitor(List listRequests) {
            RecoveryVisitor visitor = (RecoveryVisitor)this._newChild("RecoveryVisitor");
            visitor.setRequestList(listRequests);
            return visitor;
        }

        static {
            PersistenceControl.__initStatic();
        }

        public static class EventsVisitor
        extends Util
        implements PersistentStore.Visitor {
            private int __m_Partition;
            private List __m_RequestList;
            private transient int __m_StatsEntriesRecovered;
            private LongArray __m_StorageArray;
            private LongArray __m_StorageArrayPrev;

            public EventsVisitor() {
                this(null, null, true);
            }

            public EventsVisitor(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new EventsVisitor();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$PersistenceControl$EventsVisitor".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            protected Member getJoinedMember(long ldtJoined) {
                PartitionedCache service = (PartitionedCache)this.get_Module();
                return service.getServiceMemberSet().getJoinedMember(ldtJoined);
            }

            public int getPartition() {
                return this.__m_Partition;
            }

            public PartitionedService.PartitionControl getPartitionControl() {
                return ((PartitionedCache)this.get_Module()).getPartitionControl(this.getPartition());
            }

            public List getRequestList() {
                return this.__m_RequestList;
            }

            public int getStatsEntriesRecovered() {
                return this.__m_StatsEntriesRecovered;
            }

            protected Storage getStorage(long lOldCacheId) {
                return (Storage)this.getStorageArray().get(lOldCacheId);
            }

            public LongArray getStorageArray() {
                return this.__m_StorageArray;
            }

            public LongArray getStorageArrayPrev() {
                return this.__m_StorageArrayPrev;
            }

            public void setPartition(int nPartition) {
                this.__m_Partition = nPartition;
            }

            public void setRequestList(List listRequest) {
                this.__m_RequestList = listRequest;
            }

            public void setStatsEntriesRecovered(int sProperty) {
                this.__m_StatsEntriesRecovered = sProperty;
            }

            public void setStorageArray(LongArray laStorage) {
                this.__m_StorageArray = laStorage;
            }

            public void setStorageArrayPrev(LongArray laStorage) {
                this.__m_StorageArrayPrev = laStorage;
            }

            public boolean visit(long Param_1, Object Param_2, Object Param_3) {
                return false;
            }
        }

        public static class RecoveryVisitor
        extends Util
        implements CachePersistenceHelper.Visitor {
            private int __m_Partition;
            private List __m_RequestList;
            private transient int __m_StatsEntriesRecovered;
            private LongArray __m_StorageArray;
            private LongArray __m_StorageArrayPrev;

            public RecoveryVisitor() {
                this(null, null, true);
            }

            public RecoveryVisitor(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new RecoveryVisitor();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$PersistenceControl$RecoveryVisitor".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            protected Member getJoinedMember(long ldtJoined) {
                PartitionedCache service = (PartitionedCache)this.get_Module();
                return service.getServiceMemberSet().getJoinedMember(ldtJoined);
            }

            public int getPartition() {
                return this.__m_Partition;
            }

            public PartitionedService.PartitionControl getPartitionControl() {
                return ((PartitionedCache)this.get_Module()).getPartitionControl(this.getPartition());
            }

            public List getRequestList() {
                return this.__m_RequestList;
            }

            public int getStatsEntriesRecovered() {
                return this.__m_StatsEntriesRecovered;
            }

            protected Storage getStorage(long lOldCacheId) {
                return (Storage)this.getStorageArray().get(lOldCacheId);
            }

            public LongArray getStorageArray() {
                return this.__m_StorageArray;
            }

            public LongArray getStorageArrayPrev() {
                return this.__m_StorageArrayPrev;
            }

            public void setPartition(int nPartition) {
                this.__m_Partition = nPartition;
            }

            public void setRequestList(List listRequest) {
                this.__m_RequestList = listRequest;
            }

            public void setStatsEntriesRecovered(int sProperty) {
                this.__m_StatsEntriesRecovered = sProperty;
            }

            public void setStorageArray(LongArray laStorage) {
                this.__m_StorageArray = laStorage;
            }

            public void setStorageArrayPrev(LongArray laStorage) {
                this.__m_StorageArrayPrev = laStorage;
            }

            @Override
            public boolean visitCacheEntry(long lOldCacheId, Binary binKey, Binary binValue) {
                Storage storage = this.getStorage(lOldCacheId);
                if (storage != null) {
                    this.getPartitionControl().ensurePersistentExtent(storage.getCacheId());
                    storage.putPrimaryResource(binKey, binValue);
                    this.setStatsEntriesRecovered(this.getStatsEntriesRecovered() + 1);
                } else {
                    PartitionedCache service = (PartitionedCache)this.get_Module();
                    Object oValue = this.getStorageArrayPrev().get(lOldCacheId);
                    if (!(oValue instanceof Boolean)) {
                        String sCacheName = (String)oValue;
                        boolean fDestroyed = sCacheName != null && service.getStorageGraveyard().containsValue(sCacheName);
                        RecoveryVisitor._trace("Unable to locate Storage instance for cache '" + sCacheName + "'; old-cache-ids: " + String.valueOf(this.getStorageArrayPrev()) + ", new-cache-ids: " + String.valueOf(this.getStorageArray()) + ", cache-destroyed: " + fDestroyed, 2);
                        this.getStorageArrayPrev().set(lOldCacheId, true);
                    }
                }
                return true;
            }

            @Override
            public boolean visitIndex(long lOldCacheId, Binary binExtractor, Binary binComparator) {
                Storage storage = this.getStorage(lOldCacheId);
                if (storage != null) {
                    PartitionedCache service = (PartitionedCache)this.get_Module();
                    Serializer serializer = service.getSerializer();
                    ValueExtractor extractor = (ValueExtractor)ExternalizableHelper.fromBinary(binExtractor, serializer);
                    Comparator comparator = (Comparator)ExternalizableHelper.fromBinary(binComparator, serializer);
                    long lCacheId = storage.getCacheId();
                    List listRequests = this.getRequestList();
                    if (listRequests != null) {
                        IndexRequest msgRequest = (IndexRequest)service.instantiateMessage("IndexRequest");
                        msgRequest.setCacheId(lCacheId);
                        msgRequest.setAdd(true);
                        msgRequest.setExtractor(extractor);
                        msgRequest.setOrdered(comparator != null);
                        msgRequest.setComparator(comparator);
                        msgRequest.addToMember(service.getOwnershipSenior(true));
                        listRequests.add(msgRequest);
                    }
                }
                return true;
            }

            @Override
            public boolean visitListener(long lOldCacheId, Binary binKey, long lMemberId, boolean fLite) {
                Member memberListener;
                Storage storage = this.getStorage(lOldCacheId);
                if (storage != null && (memberListener = this.getJoinedMember(lMemberId)) != null) {
                    this.getPartitionControl().ensurePersistentExtent(storage.getCacheId());
                    storage.addKeyListener(memberListener, binKey, fLite, true);
                }
                return true;
            }

            @Override
            public boolean visitLock(long lOldCacheId, Binary binKey, long lHolderId, long lHolderThreadId) {
                Member memberHolder;
                Storage storage = this.getStorage(lOldCacheId);
                if (storage != null && (memberHolder = this.getJoinedMember(lHolderId)) != null) {
                    Lease lease = Lease.instantiate(0, binKey, storage.getService());
                    lease.setHolderId(memberHolder.getId());
                    lease.setHolderThreadId(lHolderThreadId);
                    if (!storage.lock(lease)) {
                        // empty if block
                    }
                }
                return true;
            }

            @Override
            public boolean visitTrigger(long lOldCacheId, Binary binTrigger) {
                Storage storage = this.getStorage(lOldCacheId);
                if (storage != null) {
                    PartitionedCache service = (PartitionedCache)this.get_Module();
                    Serializer serializer = service.getSerializer();
                    MapTrigger trigger = (MapTrigger)ExternalizableHelper.fromBinary(binTrigger, serializer);
                    long lCacheId = storage.getCacheId();
                    List listRequests = this.getRequestList();
                    if (listRequests != null) {
                        ListenerRequest msgRequest = (ListenerRequest)service.instantiateMessage("ListenerRequest");
                        msgRequest.setCacheId(lCacheId);
                        msgRequest.setAdd(true);
                        msgRequest.setTrigger(trigger);
                        msgRequest.addToMember(service.getOwnershipSenior(true));
                        listRequests.add(msgRequest);
                    }
                }
                return true;
            }
        }

        public static class SnapshotBuilder
        extends PartitionedService.PersistenceControl.SnapshotBuilder {
            public SnapshotBuilder() {
                this(null, null, true);
            }

            public SnapshotBuilder(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setPartition(-1);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new SnapshotBuilder();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$PersistenceControl$SnapshotBuilder".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public void removeTransientCaches(PersistentStore store) {
                PartitionedCache service = (PartitionedCache)this.getService();
                BackingMapManager manager = service.getBackingMapManager();
                long[] alCacheId = store.extents();
                LongArray<String> laCaches = CachePersistenceHelper.getCacheNames(store);
                boolean fWriteCacheName = false;
                for (long lCacheId : alCacheId) {
                    String sName = laCaches.get(lCacheId);
                    if (sName == null || manager.isBackingMapPersistent(sName, true)) continue;
                    CachePersistenceHelper.deleteExtents(store, lCacheId);
                    laCaches.remove(lCacheId);
                    fWriteCacheName = true;
                }
                if (fWriteCacheName) {
                    CachePersistenceHelper.storeCacheNames(store, laCaches);
                }
            }
        }
    }

    public static class PinningIterator
    extends PartitionedService.PinningIterator {
        public PinningIterator() {
            this(null, null, true);
        }

        public PinningIterator(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PinningIterator();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$PinningIterator".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected boolean enterPartition(int nPartition) {
            boolean fEntered = super.enterPartition(nPartition);
            if (fEntered) {
                ((PartitionedCache)this.get_Module()).ensureIndexReady(nPartition);
            }
            return fEntered;
        }

        @Override
        public void setRejectedPartitions(PartitionSet partitions) {
            super.setRejectedPartitions(partitions);
        }
    }

    public static class PutAllRequest
    extends MapRequest {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public PutAllRequest() {
            this(null, null, true);
        }

        public PutAllRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(71);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        public static Component get_Instance() {
            return new PutAllRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$PutAllRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        protected Map instantiateEntryMap(int cEntries) {
            PartitionedCache service = (PartitionedCache)this.get_Module();
            return service.isConcurrent() ? new NullableSortedMap() : super.instantiateEntryMap(cEntries);
        }

        @Override
        public void onReceived() {
            PartitionedCache service = (PartitionedCache)this.getService();
            service.getDaemonPool().add(this);
        }

        @Override
        public void run() {
            ((PartitionedCache)this.get_Module()).onPutAllRequest(this);
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        static {
            PutAllRequest.__initStatic();
        }

        public static class Poll
        extends MapRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            @Override
            public boolean isPreprocessable() {
                return true;
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$PutAllRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class PutRequest
    extends DistributedCacheKeyRequest {
        private long __m_ExpiryDelay;
        private boolean __m_ReturnRequired;
        private Binary __m_Value;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public PutRequest() {
            this(null, null, true);
        }

        public PutRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(72);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        public static Component get_Instance() {
            return new PutRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$PutRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            PutRequest msg = (PutRequest)super.cloneMessage();
            msg.setReturnRequired(this.isReturnRequired());
            msg.setExpiryDelay(this.getExpiryDelay());
            msg.setValue(this.getValue());
            return msg;
        }

        @Override
        public int getEstimatedByteSize() {
            return -1;
        }

        public long getExpiryDelay() {
            return this.__m_ExpiryDelay;
        }

        public Binary getValue() {
            return this.__m_Value;
        }

        public boolean isReturnRequired() {
            return this.__m_ReturnRequired;
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setReturnRequired(input.readBoolean());
            this.setValue((Binary)this.readObject(input));
            this.setExpiryDelay(ExternalizableHelper.readLong(input));
            this.readTracing(input);
        }

        @Override
        public void run() {
            ((PartitionedCache)this.getService()).onPutRequest(this);
        }

        public void setExpiryDelay(long cMillis) {
            this.__m_ExpiryDelay = cMillis;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        public void setReturnRequired(boolean fRequired) {
            this.__m_ReturnRequired = fRequired;
        }

        public void setValue(Binary binValue) {
            this.__m_Value = binValue;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeBoolean(this.isReturnRequired());
            this.writeObject(output, this.getValue());
            ExternalizableHelper.writeLong(output, this.getExpiryDelay());
            this.writeTracing(output);
        }

        static {
            PutRequest.__initStatic();
        }

        public static class Poll
        extends DistributedCacheKeyRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            @Override
            public boolean isPreprocessable() {
                return true;
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$PutRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class QueryRequest
    extends FilterRequest {
        private boolean __m_KeysOnly;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public QueryRequest() {
            this(null, null, true);
        }

        public QueryRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(73);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new QueryRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$QueryRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            QueryRequest msg = (QueryRequest)super.cloneMessage();
            msg.setKeysOnly(this.isKeysOnly());
            return msg;
        }

        public boolean isKeysOnly() {
            return this.__m_KeysOnly;
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setKeysOnly(input.readBoolean());
            this.readTracing(input);
        }

        @Override
        public void run() {
            ((PartitionedCache)this.getService()).onQueryRequest(this);
        }

        public void setKeysOnly(boolean fKeysOnly) {
            this.__m_KeysOnly = fKeysOnly;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeBoolean(this.isKeysOnly());
            this.writeTracing(output);
        }

        static {
            QueryRequest.__initStatic();
        }

        public static class Poll
        extends PartialRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            @Override
            public boolean isPreprocessable() {
                return true;
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$QueryRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class PartitionedQueryRequest
    extends QueryRequest {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public PartitionedQueryRequest() {
            this(null, null, true);
        }

        public PartitionedQueryRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(87);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PartitionedQueryRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$PartitionedQueryRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            PartitionedQueryRequest msg = (PartitionedQueryRequest)super.cloneMessage();
            return msg;
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.readTracing(input);
        }

        @Override
        public void run() {
            ((PartitionedCache)this.getService()).onQueryRequest(this);
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            this.writeTracing(output);
        }

        static {
            PartitionedQueryRequest.__initStatic();
        }

        public static class Poll
        extends PartialRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            @Override
            public boolean isPreprocessable() {
                return true;
            }

            public static Component get_Instance() {
                return new QueryRequest.Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$PartitionedQueryRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class QueryResponse
    extends DistributedPartialResponse {
        private int __m_Available;
        private long __m_BinarySize;
        private boolean __m_KeysOnly;
        private Object[] __m_Result;
        private int __m_Size;

        public QueryResponse() {
            this(null, null, true);
        }

        public QueryResponse(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(74);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new QueryResponse();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$QueryResponse".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public static Map.Entry ensureSimpleEntry(Map.Entry entry) {
            if (entry instanceof BinaryEntry) {
                BinaryEntry binEntry = (BinaryEntry)((Object)entry);
                entry = new SimpleMapEntry<Binary, Binary>(binEntry.getBinaryKey(), binEntry.getBinaryValue());
            }
            return entry;
        }

        public static Object extractBinaryKey(Map.Entry entry) {
            return entry instanceof BinaryEntry ? ((BinaryEntry)entry).getBinaryKey() : entry.getKey();
        }

        public static Object extractBinaryValue(Map.Entry entry) {
            return entry instanceof BinaryEntry ? ((BinaryEntry)entry).getBinaryValue() : entry.getValue();
        }

        public int getAvailable() {
            return this.__m_Available;
        }

        public long getBinarySize() {
            return this.__m_BinarySize;
        }

        @Override
        public int getEstimatedByteSize() {
            return -1;
        }

        public Object[] getResult() {
            return this.__m_Result;
        }

        public int getSize() {
            return this.__m_Size;
        }

        public boolean isKeysOnly() {
            return this.__m_KeysOnly;
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            if (this.getException() == null) {
                int cEntries = ExternalizableHelper.readInt(input);
                boolean fKeysOnly = input.readBoolean();
                Object[] aoResult = new Object[cEntries];
                long cb = 0L;
                for (int i = 0; i < cEntries; ++i) {
                    if (fKeysOnly) {
                        aoResult[i] = this.readObject(input);
                        continue;
                    }
                    Binary binKey = (Binary)this.readObject(input);
                    Binary binVal = (Binary)this.readObject(input);
                    cb = cb + (long)binKey.length() + (long)(binVal == null ? 0 : binVal.length());
                    aoResult[i] = new SimpleMapEntry<Binary, Binary>(binKey, binVal);
                }
                this.setSize(cEntries);
                this.setBinarySize(cb);
                this.setKeysOnly(fKeysOnly);
                this.setResult(aoResult);
                this.setAvailable(ExternalizableHelper.readInt(input));
            }
        }

        public void setAvailable(int cAvailable) {
            this.__m_Available = cAvailable;
        }

        public void setBinarySize(long lSize) {
            this.__m_BinarySize = lSize;
        }

        public void setKeysOnly(boolean fKeysOnly) {
            this.__m_KeysOnly = fKeysOnly;
        }

        public void setResult(Object[] ao) {
            this.__m_Result = ao;
        }

        public void setSize(int c) {
            this.__m_Size = c;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            if (this.getException() == null) {
                Object[] aoResult = this.getResult();
                int cEntries = this.getSize();
                ExternalizableHelper.writeInt(output, cEntries);
                boolean fKeysOnly = this.isKeysOnly();
                output.writeBoolean(fKeysOnly);
                for (int i = 0; i < cEntries; ++i) {
                    if (fKeysOnly) {
                        this.writeObject(output, aoResult[i]);
                        continue;
                    }
                    Map.Entry entry = (Map.Entry)aoResult[i];
                    this.writeObject(output, QueryResponse.extractBinaryKey(entry));
                    this.writeObject(output, QueryResponse.extractBinaryValue(entry));
                }
                ExternalizableHelper.writeInt(output, this.getAvailable());
            }
        }
    }

    public static class PartitionedQueryResponse
    extends QueryResponse {
        public PartitionedQueryResponse() {
            this(null, null, true);
        }

        public PartitionedQueryResponse(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(88);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PartitionedQueryResponse();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$PartitionedQueryResponse".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            if (input.readBoolean()) {
                PartitionSet partsResponse = new PartitionSet();
                partsResponse.readExternal(input);
                this.setResponsePartitions(partsResponse);
            }
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            PartitionSet partsResponse = this.getResponsePartitions();
            if (partsResponse == null) {
                output.writeBoolean(false);
            } else {
                output.writeBoolean(true);
                partsResponse.writeExternal(output);
            }
        }
    }

    public static class RemoveAllRequest
    extends KeySetRequest {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
            __mapChildren.put("RemoveJob", RemoveJob.get_CLASS());
        }

        public RemoveAllRequest() {
            this(null, null, true);
        }

        public RemoveAllRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(75);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        public static Component get_Instance() {
            return new RemoveAllRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$RemoveAllRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public int getEstimatedByteSize() {
            return -1;
        }

        @Override
        protected Set instantiateKeySet(int cKeys) {
            PartitionedCache service = (PartitionedCache)this.get_Module();
            return service.isConcurrent() && !service.isTaskSplitWorthy(cKeys) ? Collections.newSetFromMap(new NullableSortedMap()) : super.instantiateKeySet(cKeys);
        }

        @Override
        public void onReceived() {
            PartitionedCache service = (PartitionedCache)this.getService();
            if (service.isTaskSplitWorthy(this.getKeySet().size())) {
                this.scheduleJobs();
            } else {
                service.getDaemonPool().add(this);
            }
        }

        @Override
        public void run() {
            ((PartitionedCache)this.get_Module()).onRemoveAllRequest(this);
        }

        protected void scheduleJobs() {
            PartitionedCache service = (PartitionedCache)this.getService();
            com.tangosol.coherence.component.util.DaemonPool pool = service.getDaemonPool();
            Set setKeys = this.getKeySet();
            int cKeys = setKeys.size();
            PartialValueResponse msgResponse = (PartialValueResponse)service.instantiateMessage("PartialValueResponse");
            msgResponse.respondTo(this);
            long lCacheId = this.getCacheId();
            BatchContext ctxBatch = service.instantiateBatchContext(msgResponse);
            SparseArray<RemoveJob> laJob = new SparseArray<RemoveJob>();
            for (Binary binKey : setKeys) {
                int iPartition = service.getKeyPartition(binKey);
                RemoveJob job = (RemoveJob)laJob.get(iPartition);
                if (job == null) {
                    job = new RemoveJob();
                    job.setBatchContext(ctxBatch);
                    job.setRequest(this);
                    job.setPartition(iPartition);
                    laJob.set(iPartition, job);
                }
                job.getMap().put(binKey, null);
            }
            ctxBatch.getOutstandingOperationCounter().set(laJob.getSize());
            Iterator iter = laJob.iterator();
            while (iter.hasNext()) {
                pool.add((Runnable)iter.next());
            }
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        static {
            RemoveAllRequest.__initStatic();
        }

        public static class Poll
        extends KeySetRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            @Override
            public boolean isPreprocessable() {
                return true;
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$RemoveAllRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class RemoveJob
        extends PartialJob {
            private transient Map __m_Map;

            public RemoveJob() {
                this(null, null, true);
            }

            public RemoveJob(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMap(new NullableSortedMap());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new RemoveJob();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$RemoveAllRequest$RemoveJob".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public String getDescription() {
                String sCacheName = ((PartitionedCache)this.get_Module()).getCacheName(this.getCacheId());
                if (sCacheName == null) {
                    sCacheName = "<unknown>";
                }
                return super.getDescription() + ", CacheName=" + sCacheName;
            }

            public Map getMap() {
                return this.__m_Map;
            }

            @Override
            public void run() {
                ((PartitionedCache)this.getResponse().getService()).onRemoveAllRequest(this);
            }

            protected void setMap(Map map) {
                this.__m_Map = map;
            }
        }
    }

    public static class RemoveRequest
    extends DistributedCacheKeyRequest {
        private boolean __m_ReturnRequired;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public RemoveRequest() {
            this(null, null, true);
        }

        public RemoveRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(76);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        public static Component get_Instance() {
            return new RemoveRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$RemoveRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            RemoveRequest msg = (RemoveRequest)super.cloneMessage();
            msg.setReturnRequired(this.isReturnRequired());
            return msg;
        }

        @Override
        public int getEstimatedByteSize() {
            return -1;
        }

        public boolean isReturnRequired() {
            return this.__m_ReturnRequired;
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setReturnRequired(input.readBoolean());
            this.readTracing(input);
        }

        @Override
        public void run() {
            ((PartitionedCache)this.getService()).onRemoveRequest(this);
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        public void setReturnRequired(boolean fRequired) {
            this.__m_ReturnRequired = fRequired;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeBoolean(this.isReturnRequired());
            this.writeTracing(output);
        }

        static {
            RemoveRequest.__initStatic();
        }

        public static class Poll
        extends DistributedCacheKeyRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            @Override
            public boolean isPreprocessable() {
                return true;
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$RemoveRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class ResultInfo
    extends Util {
        private Map __m_PartitionResultMap;
        private volatile PartitionSet __m_Partitions;
        private long __m_SUID;

        public ResultInfo() {
            this(null, null, true);
        }

        public ResultInfo(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setPartitionResultMap(new LiteMap());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ResultInfo();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$ResultInfo".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        protected Map collectEntries(PartitionSet partMask) {
            Map mapPartResults = this.getPartitionResultMap();
            if (mapPartResults == null || !this.getPartitions().intersects(partMask)) {
                return null;
            }
            PartitionedCache service = this.getService();
            HashMap mapCollect = new HashMap();
            for (Map.Entry entryPartResult : mapPartResults.entrySet()) {
                Object oKey = entryPartResult.getKey();
                Map mapResults = (Map)entryPartResult.getValue();
                if (oKey instanceof Integer) {
                    int nPartition = (Integer)oKey;
                    if (!partMask.contains(nPartition)) continue;
                    mapCollect.putAll(mapResults);
                    continue;
                }
                PartitionSet partsThis = (PartitionSet)oKey;
                if (!partsThis.intersects(partMask)) continue;
                for (Map.Entry entry : mapResults.entrySet()) {
                    Binary binKey = (Binary)entry.getKey();
                    if (!partMask.contains(service.getKeyPartition(binKey))) continue;
                    mapCollect.put(binKey, entry.getValue());
                }
            }
            return mapCollect;
        }

        public synchronized PartitionSet ensurePartitions() {
            PartitionSet parts = this.getPartitions();
            if (parts == null) {
                parts = new PartitionSet(this.getService().getPartitionCount());
                this.setPartitions(parts);
            }
            return parts;
        }

        public synchronized Map extractResults(int nPartition) {
            PartitionSet partsPrev = this.getPartitions();
            if (partsPrev != null && partsPrev.contains(nPartition)) {
                partsPrev = new PartitionSet(partsPrev.getPartitionCount());
                partsPrev.add(nPartition);
                return this.collectEntries(partsPrev);
            }
            return null;
        }

        public synchronized Map extractResults(PartitionSet partMask) {
            PartitionSet partPrev = this.getPartitions();
            if (partPrev != null && partPrev.intersects(partMask)) {
                partPrev = new PartitionSet(partPrev);
                partPrev.retain(partMask);
                partMask.remove(partPrev);
                return this.collectEntries(partPrev);
            }
            return null;
        }

        public synchronized Map extractResults(Binary binKey) {
            int nPartition = this.getService().getKeyPartition(binKey);
            return this.extractResults(nPartition);
        }

        public Map getPartitionResultMap() {
            return this.__m_PartitionResultMap;
        }

        public PartitionSet getPartitions() {
            return this.__m_Partitions;
        }

        public PartitionedCache getService() {
            return (PartitionedCache)this.get_Parent();
        }

        public long getSUID() {
            return this.__m_SUID;
        }

        public synchronized void mergeResults(int nPartition, Map mapResults) {
            this.getPartitionResultMap().put(nPartition, mapResults);
            this.ensurePartitions().add(nPartition);
        }

        public synchronized void mergeResults(PartitionSet parts, Map mapResults) {
            this.getPartitionResultMap().put(parts, mapResults);
            this.ensurePartitions().add(parts);
        }

        protected void setPartitionResultMap(Map map) {
            this.__m_PartitionResultMap = map;
        }

        protected void setPartitions(PartitionSet parts) {
            this.__m_Partitions = parts;
        }

        public void setSUID(long lD) {
            this.__m_SUID = lD;
        }

        @Override
        public String toString() {
            return this.get_Name() + "{Partitions=" + String.valueOf(this.getPartitions()) + ", Results=" + String.valueOf(this.collectEntries(this.getService().instantiatePartitionSet(true))) + "}";
        }
    }

    public static class SendBackupsTask
    extends Util
    implements Continuation,
    Runnable {
        public SendBackupsTask() {
            this(null, null, true);
        }

        public SendBackupsTask(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new SendBackupsTask();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$SendBackupsTask".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public void proceed(Object oResult) {
            PartitionedCache service = (PartitionedCache)this.get_Module();
            com.tangosol.coherence.component.util.DaemonPool pool = service.getDaemonPool();
            long cNextBackupMillis = service.getAsyncBackupInterval();
            SendBackupsTask._assert(pool.isStarted());
            pool.schedule(this, cNextBackupMillis);
        }

        @Override
        public void run() {
            ((PartitionedCache)this.get_Module()).onSendBackups(this);
        }
    }

    public static class SizeRequest
    extends PartialRequest {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public SizeRequest() {
            this(null, null, true);
        }

        public SizeRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(77);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new SizeRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$SizeRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public void run() {
            ((PartitionedCache)this.getService()).onSizeRequest(this);
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        static {
            SizeRequest.__initStatic();
        }

        public static class Poll
        extends PartialRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            @Override
            public boolean isPreprocessable() {
                return true;
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$SizeRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class SnapshotListRequest
    extends PartitionedService.SnapshotListRequest {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", PartitionedService.SnapshotListRequest.Poll.get_CLASS());
        }

        public SnapshotListRequest() {
            this(null, null, true);
        }

        public SnapshotListRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(48);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new SnapshotListRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$SnapshotListRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        static {
            SnapshotListRequest.__initStatic();
        }
    }

    public static class SnapshotRequest
    extends PartitionedService.SnapshotRequest {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", PartitionedService.SnapshotRequest.Poll.get_CLASS());
        }

        public SnapshotRequest() {
            this(null, null, true);
        }

        public SnapshotRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setAttempt(10);
                this.setMessageType(47);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new SnapshotRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$SnapshotRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        static {
            SnapshotRequest.__initStatic();
        }
    }

    public static class StorageConfirmRequest
    extends PartialRequest {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public StorageConfirmRequest() {
            this(null, null, true);
        }

        public StorageConfirmRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(83);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new StorageConfirmRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$StorageConfirmRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public void onReceived() {
            ((PartitionedCache)this.getService()).onStorageConfirmRequest(this);
        }

        @Override
        public boolean preprocess() {
            return false;
        }

        static {
            StorageConfirmRequest.__initStatic();
        }

        public static class Poll
        extends PartialRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$StorageConfirmRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class StorageIdRequest
    extends RequestMessage {
        public static final int CACHE_CREATE = 1;
        public static final int CACHE_DESTROY = 2;
        private int __m_CacheAction;
        private long[] __m_CacheIds;
        private String[] __m_CacheNames;
        private boolean __m_CreateBinaryMap;
        private Message __m_Response;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public StorageIdRequest() {
            this(null, null, true);
        }

        public StorageIdRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(78);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new StorageIdRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$StorageIdRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            StorageIdRequest msg = (StorageIdRequest)super.cloneMessage();
            msg.setCacheAction(this.getCacheAction());
            msg.setCacheIds(this.getCacheIds());
            msg.setCacheNames(this.getCacheNames());
            msg.setCreateBinaryMap(this.isCreateBinaryMap());
            msg.setResponse(this.getResponse());
            return msg;
        }

        public void compressCacheNames() {
            String[] asCacheNames = this.getCacheNames();
            int cCacheNames = asCacheNames.length;
            while (asCacheNames[cCacheNames - 1] == null) {
                --cCacheNames;
            }
            if (cCacheNames != asCacheNames.length) {
                String[] asCacheNamesNew = new String[cCacheNames];
                System.arraycopy(asCacheNames, 0, asCacheNamesNew, 0, cCacheNames);
                this.setCacheNames(asCacheNamesNew);
                long[] alCacheIds = this.getCacheIds();
                if (alCacheIds != null) {
                    long[] alCacheIdsNew = new long[cCacheNames];
                    System.arraycopy(alCacheIds, 0, alCacheIdsNew, 0, cCacheNames);
                    this.setCacheIds(alCacheIdsNew);
                }
            }
        }

        public int getCacheAction() {
            return this.__m_CacheAction;
        }

        public long[] getCacheIds() {
            return this.__m_CacheIds;
        }

        public String[] getCacheNames() {
            return this.__m_CacheNames;
        }

        public Message getResponse() {
            return this.__m_Response;
        }

        @Override
        protected com.tangosol.coherence.component.net.Poll instantiatePoll() {
            return (Poll)this._newChild("Poll");
        }

        public boolean isCreateBinaryMap() {
            return this.__m_CreateBinaryMap;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            PartitionedCache service = (PartitionedCache)this.getService();
            Grid.ServiceConfig.Map mapConfig = service.getServiceConfigMap();
            Object[] asCacheNames = this.getCacheNames();
            Grid.Response msgResponse = (Grid.Response)service.instantiateMessage("Response");
            msgResponse.respondTo(this);
            Member memberThis = service.getThisMember();
            Member memberFrom = this.getFromMember();
            Member memberCoordinator = service.getServiceOldestMember();
            switch (this.getCacheAction()) {
                case 1: {
                    long[] alCacheIds = this.getCacheIds();
                    HashMap<String, XmlElement> mapXml = null;
                    String[] asCachesCreate = null;
                    long[] alIdsCreate = null;
                    int j = 0;
                    int cNames = asCacheNames.length;
                    for (int i = 0; i < cNames; ++i) {
                        long lCacheId;
                        String sCacheName = asCacheNames[i];
                        long l = lCacheId = alCacheIds == null ? 0L : alCacheIds[i];
                        if (sCacheName == null) {
                            StorageIdRequest._trace("Unexpected null cache name: " + Arrays.toString(asCacheNames), 2);
                            continue;
                        }
                        XmlElement xmlCacheInfo = (XmlElement)mapConfig.get(sCacheName);
                        if (xmlCacheInfo == null) {
                            if (memberThis != memberCoordinator) {
                                if (asCachesCreate == null) {
                                    asCachesCreate = new String[cNames - i];
                                    alIdsCreate = new long[asCachesCreate.length];
                                }
                                asCachesCreate[j] = sCacheName;
                                alIdsCreate[j++] = lCacheId;
                                continue;
                            }
                            xmlCacheInfo = service.createCacheInfo(sCacheName, lCacheId);
                            if (mapXml == null) {
                                mapXml = new HashMap<String, XmlElement>(cNames);
                            }
                            mapXml.put(sCacheName, xmlCacheInfo);
                        }
                        if (alCacheIds == null) {
                            alCacheIds = new long[cNames];
                        }
                        lCacheId = alCacheIds[i] = xmlCacheInfo.getAttribute("id").getLong();
                        if (!this.isCreateBinaryMap()) continue;
                        service.ensureBinaryMap(sCacheName, lCacheId);
                    }
                    if (mapXml != null) {
                        mapConfig.putAll(mapXml);
                    }
                    if (asCachesCreate == null) {
                        msgResponse.setValue(alCacheIds);
                        service.post(msgResponse);
                        break;
                    }
                    StorageIdRequest msg = (StorageIdRequest)this.cloneMessage();
                    msg.setCacheNames(asCachesCreate);
                    msg.setCacheIds(alIdsCreate);
                    msg.addToMember(memberCoordinator);
                    msg.setResponse(msgResponse);
                    msg.compressCacheNames();
                    service.post(msg);
                    break;
                }
                case 2: {
                    int cNames = asCacheNames.length;
                    for (int i = 0; i < cNames; ++i) {
                        mapConfig.remove(asCacheNames[i]);
                    }
                    service.post(msgResponse);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setCacheNames(ExternalizableHelper.readStringArray(input));
            this.setCacheAction(input.readInt());
            try {
                if (ExternalizableHelper.isVersionCompatible(input, 12, 2, 1, 1, 0)) {
                    long[] alCacheIds = new long[input.readPackedInt()];
                    int c = alCacheIds.length;
                    for (int i = 0; i < c; ++i) {
                        alCacheIds[i] = input.readLong();
                    }
                    this.setCacheIds(alCacheIds);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.readTracing(input);
        }

        public void setCacheAction(int pCacheAction) {
            this.__m_CacheAction = pCacheAction;
        }

        public void setCacheIds(long[] asNames) {
            this.__m_CacheIds = asNames;
        }

        public void setCacheNames(String[] asNames) {
            this.__m_CacheNames = asNames;
        }

        public void setCreateBinaryMap(boolean fCreate) {
            this.__m_CreateBinaryMap = fCreate;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        public void setResponse(Message msgResponse) {
            this.__m_Response = msgResponse;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            ExternalizableHelper.writeStringArray(output, this.getCacheNames());
            output.writeInt(this.getCacheAction());
            if (this.getService().isVersionCompatible(this.getToMemberSet(), 12, 2, 1, 1, 0)) {
                long[] alCacheIds = this.getCacheIds();
                int cCacheIds = alCacheIds == null ? 0 : alCacheIds.length;
                output.writePackedInt(cCacheIds);
                for (int i = 0; i < cCacheIds; ++i) {
                    output.writeLong(alCacheIds[i]);
                }
            }
            this.writeTracing(output);
        }

        static {
            StorageIdRequest.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$StorageIdRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected void onCompletion() {
                super.onCompletion();
                StorageIdRequest msgRequest = (StorageIdRequest)this.get_Parent();
                Message msgResponse = msgRequest.getResponse();
                if (msgResponse != null) {
                    Poll._assert(msgRequest.getCacheAction() == 1);
                    PartitionedCache service = (PartitionedCache)this.getService();
                    long[] alCacheId = (long[])this.getResult();
                    if (alCacheId == null) {
                        if (!service.isExiting() && service.getServiceState() < 3) {
                            StorageIdRequest msg = (StorageIdRequest)msgRequest.cloneMessage();
                            msg.addToMember(service.getServiceOldestMember());
                            service.post(msg);
                        }
                    } else {
                        if (msgRequest.isCreateBinaryMap()) {
                            String[] asName = msgRequest.getCacheNames();
                            int c = asName.length;
                            for (int i = 0; i < c; ++i) {
                                service.ensureBinaryMap(asName[i], alCacheId[i]);
                            }
                        }
                        service.post(msgResponse);
                    }
                }
            }

            @Override
            public void onResponse(Message msg) {
                Grid.Response response = (Grid.Response)msg;
                this.setResult(response.getValue());
                super.onResponse(msg);
            }
        }
    }

    public static class TransferRequest
    extends PartitionedService.TransferRequest {
        private List __m_Addendums;
        private long __m_CacheId;
        private String __m_CacheName;
        private ReadBuffer __m_EventsStoreBinary;
        private boolean __m_LastCache;
        private Lease[] __m_Lease;
        private Map.Entry[] __m_Listener;
        private long __m_MapEventVersion;
        private Map.Entry[] __m_Resource;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", PartitionedService.TransferRequest.Poll.get_CLASS());
        }

        public TransferRequest() {
            this(null, null, true);
        }

        public TransferRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(34);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new TransferRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$TransferRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public List getAddendums() {
            return this.__m_Addendums;
        }

        public long getCacheId() {
            return this.__m_CacheId;
        }

        public String getCacheName() {
            return this.__m_CacheName;
        }

        public ReadBuffer getEventsStoreBinary() {
            return this.__m_EventsStoreBinary;
        }

        public Lease[] getLease() {
            return this.__m_Lease;
        }

        public Map.Entry[] getListener() {
            return this.__m_Listener;
        }

        public long getMapEventVersion() {
            return this.__m_MapEventVersion;
        }

        public Map.Entry[] getResource() {
            return this.__m_Resource;
        }

        public boolean isLastCache() {
            return this.__m_LastCache;
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            Object binKey;
            int i;
            super.read(input);
            PartitionedCache service = (PartitionedCache)this.getService();
            ServiceMemberSet setMembers = service.getServiceMemberSet();
            long lCacheId = ExternalizableHelper.readLong(input);
            this.setCacheId(lCacheId);
            if (lCacheId != -1L) {
                this.setCacheName(input.readUTF());
            }
            int cResources = ExternalizableHelper.readInt(input);
            Map.Entry[] aResource = new Map.Entry[cResources];
            for (i = 0; i < cResources; ++i) {
                binKey = ExternalizableHelper.readObject(input);
                Object binValue = ExternalizableHelper.readObject(input);
                aResource[i] = new SimpleMapEntry(binKey, binValue);
            }
            this.setResource(aResource);
            int cLeases = ExternalizableHelper.readInt(input);
            Lease[] aLease = new Lease[cLeases];
            for (i = 0; i < cLeases; ++i) {
                binKey = this.readObject(input);
                Lease lease = Lease.instantiate(0, binKey, service);
                lease.read(input);
                aLease[i] = lease;
            }
            this.setLease(aLease);
            int cListens = ExternalizableHelper.readInt(input);
            Map.Entry[] aListen = new Map.Entry[cListens];
            for (int iL = 0; iL < cListens; ++iL) {
                binKey = this.readObject(input);
                SafeHashMap<Member, Boolean> mapMembers = new SafeHashMap<Member, Boolean>();
                int cMembers = ExternalizableHelper.readInt(input);
                for (int iM = 0; iM < cMembers; ++iM) {
                    int nMember = input.readUnsignedShort();
                    boolean fLite = input.readBoolean();
                    Member member = ((MemberSet)setMembers).getMember(nMember);
                    if (member == null) continue;
                    mapMembers.put(member, fLite);
                }
                aListen[iL] = new SimpleMapEntry(binKey, mapMembers);
            }
            this.setListener(aListen);
            if (this.isLastInPartition()) {
                int cRequests = ExternalizableHelper.readInt(input);
                if (cRequests > 0) {
                    SparseArray laPending = new SparseArray();
                    for (i = 0; i < cRequests; ++i) {
                        long lSUID = ExternalizableHelper.readLong(input);
                        int cResults = ExternalizableHelper.readInt(input);
                        HashMap mapResult = new HashMap(cResults);
                        for (int iResult = 0; iResult < cResults; ++iResult) {
                            Object binKey2 = ExternalizableHelper.readObject(input);
                            Object binResult = ExternalizableHelper.readObject(input);
                            mapResult.put(binKey2, binResult);
                        }
                        laPending.set(lSUID, mapResult);
                    }
                    this.setPendingResults(laPending);
                }
                this.setPendingEvents(MapEventMessage.readSupplemental(input, this.getService()));
                int cAddendum = input.readInt();
                if (cAddendum > 0) {
                    ArrayList<Storage.DeferredEvent> listAddendum = new ArrayList<Storage.DeferredEvent>();
                    for (int i2 = 0; i2 < cAddendum; ++i2) {
                        lCacheId = input.readLong();
                        Storage storage = service.ensureStorage(lCacheId, true);
                        if (storage == null) continue;
                        Storage.DeferredEvent deferred = new Storage.DeferredEvent();
                        storage._linkChild(deferred);
                        deferred.read(input);
                        listAddendum.add(deferred);
                    }
                    this.setAddendums(listAddendum);
                }
                if (service.isVersionCompatible(this.getFromMember(), 21, 6, 0)) {
                    this.setEventsStoreBinary((ReadBuffer)this.readObject(input));
                }
            }
            if (service.isVersionCompatible(this.getFromMember(), 21, 6, 0)) {
                this.setMapEventVersion(ExternalizableHelper.readLong(input));
            }
        }

        public void setAddendums(List listAddendum) {
            this.__m_Addendums = listAddendum;
        }

        public void setCacheId(long lCacheId) {
            this.__m_CacheId = lCacheId;
        }

        public void setCacheName(String sCacheName) {
            this.__m_CacheName = sCacheName;
        }

        public void setEventsStoreBinary(ReadBuffer bufBinary) {
            this.__m_EventsStoreBinary = bufBinary;
        }

        public void setLastCache(boolean pLastCache) {
            this.__m_LastCache = pLastCache;
        }

        public void setLease(Lease[] pResource_) {
            this.__m_Lease = pResource_;
        }

        public void setListener(Map.Entry[] pResource_) {
            this.__m_Listener = pResource_;
        }

        public void setMapEventVersion(long lVersion) {
            this.__m_MapEventVersion = lVersion;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        public void setResource(Map.Entry[] pResource) {
            this.__m_Resource = pResource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            Map.Entry entry;
            int i;
            super.write(output);
            long lCacheId = this.getCacheId();
            ExternalizableHelper.writeLong(output, lCacheId);
            if (lCacheId != -1L) {
                output.writeUTF(this.getCacheName());
            }
            Map.Entry[] aResource = this.getResource();
            int cResources = aResource.length;
            ExternalizableHelper.writeInt(output, cResources);
            for (i = 0; i < cResources; ++i) {
                entry = aResource[i];
                ExternalizableHelper.writeObject(output, entry.getKey());
                ExternalizableHelper.writeObject(output, entry.getValue());
                aResource[i] = null;
            }
            this.setResource(null);
            Lease[] aLease = this.getLease();
            int cLeases = aLease.length;
            ExternalizableHelper.writeInt(output, cLeases);
            for (i = 0; i < cLeases; ++i) {
                Lease lease = aLease[i];
                this.writeObject(output, lease.getResourceKey());
                lease.write(output);
            }
            this.setLease(null);
            Map.Entry[] aListen = this.getListener();
            int cListens = aListen.length;
            ExternalizableHelper.writeInt(output, cListens);
            for (i = 0; i < cListens; ++i) {
                Map mapMembers;
                entry = aListen[i];
                this.writeObject(output, entry.getKey());
                Map map = mapMembers = (Map)entry.getValue();
                synchronized (map) {
                    ExternalizableHelper.writeInt(output, mapMembers.size());
                    for (Map.Entry entryMember : mapMembers.entrySet()) {
                        com.tangosol.net.Member member = (com.tangosol.net.Member)entryMember.getKey();
                        Boolean FLite = (Boolean)entryMember.getValue();
                        output.writeShort(member.getId());
                        output.writeBoolean(FLite);
                    }
                    continue;
                }
            }
            this.setListener(null);
            if (this.isLastInPartition()) {
                LongArray laPending = this.getPendingResults();
                int cRequests = laPending == null ? 0 : laPending.getSize();
                ExternalizableHelper.writeInt(output, cRequests);
                if (cRequests > 0) {
                    Iterator crawler = laPending.iterator();
                    while (crawler.hasNext()) {
                        Map mapResult = (Map)crawler.next();
                        long lSUID = crawler.getIndex();
                        ExternalizableHelper.writeLong(output, lSUID);
                        ExternalizableHelper.writeInt(output, mapResult.size());
                        for (Map.Entry entryResult : mapResult.entrySet()) {
                            ExternalizableHelper.writeObject(output, entryResult.getKey());
                            ExternalizableHelper.writeObject(output, entryResult.getValue());
                        }
                    }
                }
                MapEventMessage.writeSupplemental(output, this.getPendingEvents());
                List listAddendum = this.getAddendums();
                int cAddendum = listAddendum == null ? 0 : listAddendum.size();
                output.writeInt(cAddendum);
                if (cAddendum > 0) {
                    for (Storage.DeferredEvent deferred : listAddendum) {
                        output.writeLong(deferred.getCacheId());
                        deferred.write(output);
                    }
                }
                this.writeObject(output, this.getEventsStoreBinary());
            }
            ExternalizableHelper.writeLong(output, this.getMapEventVersion());
        }

        static {
            TransferRequest.__initStatic();
        }
    }

    public static class UnlockRequest
    extends DistributedCacheKeyRequest {
        private int __m_LeaseHolderId;
        private long __m_LeaseThreadId;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public UnlockRequest() {
            this(null, null, true);
        }

        public UnlockRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(79);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        public static Component get_Instance() {
            return new UnlockRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$UnlockRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            UnlockRequest msg = (UnlockRequest)super.cloneMessage();
            msg.fromLease(this.toLease());
            return msg;
        }

        public void fromLease(Lease lease) {
            this.setKey((Binary)lease.getResourceKey());
            this.setLeaseHolderId(lease.getHolderId());
            this.setLeaseThreadId(lease.getHolderThreadId());
        }

        @Override
        public int getEstimatedByteSize() {
            return -1;
        }

        public int getLeaseHolderId() {
            return this.__m_LeaseHolderId;
        }

        public long getLeaseThreadId() {
            return this.__m_LeaseThreadId;
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setLeaseHolderId(input.readUnsignedShort());
            this.setLeaseThreadId(ExternalizableHelper.readLong(input));
            this.readTracing(input);
        }

        @Override
        public void run() {
            ((PartitionedCache)this.getService()).onUnlockRequest(this);
        }

        public void setLeaseHolderId(int nHolderId) {
            this.__m_LeaseHolderId = nHolderId;
        }

        public void setLeaseThreadId(long nThreadId) {
            this.__m_LeaseThreadId = nThreadId;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        public Lease toLease() {
            Lease lease = Lease.instantiate(0, this.getKey(), this.getService());
            lease.setHolderId(this.getLeaseHolderId());
            lease.setHolderThreadId(this.getLeaseThreadId());
            return lease;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeShort(this.getLeaseHolderId());
            ExternalizableHelper.writeLong(output, this.getLeaseThreadId());
            this.writeTracing(output);
        }

        static {
            UnlockRequest.__initStatic();
        }

        public static class Poll
        extends DistributedCacheKeyRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$UnlockRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class UpdateIndexRequest
    extends RequestMessage
    implements PriorityTask,
    Runnable {
        private int __m_EventId;
        private int __m_Partition;
        private Map __m_UpdateMap;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public UpdateIndexRequest() {
            this(null, null, true);
        }

        public UpdateIndexRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(84);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new UpdateIndexRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$UpdateIndexRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public int getEventId() {
            return this.__m_EventId;
        }

        @Override
        public long getExecutionTimeoutMillis() {
            return 0L;
        }

        public int getPartition() {
            return this.__m_Partition;
        }

        @Override
        public long getRequestTimeoutMillis() {
            return 0L;
        }

        @Override
        public int getSchedulingPriority() {
            return 2;
        }

        public Map getUpdateMap() {
            return this.__m_UpdateMap;
        }

        @Override
        protected com.tangosol.coherence.component.net.Poll instantiatePoll() {
            return (Poll)this._newChild("Poll");
        }

        @Override
        public void onReceived() {
            super.onReceived();
            this.getService().getDaemonPool().add(this);
        }

        @Override
        public void run() {
            ((PartitionedCache)this.getService()).onUpdateIndexRequest(this);
        }

        @Override
        public void runCanceled(boolean fAbandoned) {
        }

        public void setEventId(int nId) {
            this.__m_EventId = nId;
        }

        public void setPartition(int nPartition) {
            this.__m_Partition = nPartition;
        }

        public void setUpdateMap(Map mapUpdate) {
            this.__m_UpdateMap = mapUpdate;
        }

        static {
            UpdateIndexRequest.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            @Override
            public boolean isPreprocessable() {
                return false;
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$UpdateIndexRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public void onResponse(Message msg) {
                UpdateIndexRequest msgRetry;
                Grid.Response msgResponse = (Grid.Response)msg;
                PartitionedCache service = (PartitionedCache)this.getService();
                UpdateIndexRequest msgRequest = (UpdateIndexRequest)service.getPendingIndexUpdate().poll();
                int cIndexUpdates = service.getIndexUpdateCount() - 1;
                if (msgRequest == null) {
                    service.setIndexUpdateCount(cIndexUpdates);
                } else {
                    service.post(msgRequest);
                }
                if (msgResponse.getResult() == 1 && (msgRetry = (UpdateIndexRequest)msgResponse.getValue()) != null) {
                    int nPartition = msgRetry.getPartition();
                    if (service.getIndexPendingPartitions().contains(nPartition)) {
                        service.scheduleIndexUpdate(nPartition, msgRetry.getEventId(), msgRetry.getUpdateMap());
                    }
                }
                if (cIndexUpdates == 0) {
                    service.updateIndexBuildTime();
                }
                super.onResponse(msg);
            }
        }
    }

    public static class Continuations
    extends PartitionedService.Continuations {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Continuation", Continuation.get_CLASS());
            __mapChildren.put("Message", PartitionedService.Continuations.Message.get_CLASS());
            __mapChildren.put("Task", PartitionedService.Continuations.Task.get_CLASS());
        }

        public Continuations() {
            this(null, null, true);
        }

        public Continuations(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Continuations();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$Continuations".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        protected com.oracle.coherence.common.base.Continuation instantiate(int nType, Object oContext, com.oracle.coherence.common.base.Continuation contNext) {
            Continuation continuation = new Continuation();
            this._linkChild(continuation);
            continuation.setType(nType);
            continuation.setContext(oContext);
            continuation.setNext(contNext);
            return continuation;
        }

        public com.oracle.coherence.common.base.Continuation instantiateEnsureStorage(LongArray laCaches, com.oracle.coherence.common.base.Continuation contNext) {
            return this.instantiate(11, laCaches, contNext);
        }

        static {
            Continuations.__initStatic();
        }

        public static class Continuation
        extends PartitionedService.Continuations.Continuation {
            public static final int TYPE_ENSURE_STORAGE = 11;

            public Continuation() {
                this(null, null, true);
            }

            public Continuation(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Continuation();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$Continuations$Continuation".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public void proceed(Object oResult) {
                PartitionedCache service = (PartitionedCache)this.get_Module();
                Object oContext = this.getContext();
                switch (this.getType()) {
                    case 11: {
                        service.ensureStorage((LongArray)oContext);
                        this.proceedNext(oResult);
                        break;
                    }
                    default: {
                        super.proceed(oResult);
                    }
                }
            }
        }
    }

    public static class DaemonPool
    extends PartitionedService.DaemonPool {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Daemon", Grid.DaemonPool.Daemon.get_CLASS());
            __mapChildren.put("ResizeTask", Service.DaemonPool.ResizeTask.get_CLASS());
            __mapChildren.put("ScheduleTask", Service.DaemonPool.ScheduleTask.get_CLASS());
            __mapChildren.put("StartTask", Service.DaemonPool.StartTask.get_CLASS());
            __mapChildren.put("StopTask", Service.DaemonPool.StopTask.get_CLASS());
            __mapChildren.put("WorkSlot", Service.DaemonPool.WorkSlot.get_CLASS());
            __mapChildren.put("WrapperTask", PartitionedService.DaemonPool.WrapperTask.get_CLASS());
        }

        public DaemonPool() {
            this(null, null, true);
        }

        public DaemonPool(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setAbandonThreshold(8);
                this.setDaemonCountMax(Integer.MAX_VALUE);
                this.setDaemonCountMin(1);
                this.setScheduledTasks(new HashSet());
                this.setStatsTaskAddCount(new AtomicLong());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new DaemonPool();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$DaemonPool".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public void runCanceled(PriorityTask task, boolean fAbandoned) {
            ResponseMessage msgResponse;
            super.runCanceled(task, fAbandoned);
            PartitionedCache service = (PartitionedCache)this.get_Module();
            RequestMessage msgRequest = null;
            if (task instanceof RequestMessage) {
                msgRequest = (RequestMessage)((Object)task);
            } else if (task instanceof PartialJob) {
                msgRequest = ((PartialJob)task).getRequest();
            }
            RequestTimeoutException exception = null;
            try {
                String sMsg = (fAbandoned ? "Abandoned" : "Canceled") + " execution of \"" + (msgRequest == null ? String.valueOf(task) : msgRequest.get_Name()) + "\" for service \"" + service.getServiceName() + "\" on " + String.valueOf(service.getThisMember());
                exception = new RequestTimeoutException(sMsg);
                exception.setStackTrace(new StackTraceElement[0]);
            }
            catch (RuntimeException e) {
                exception = new RequestTimeoutException(e);
            }
            if (msgRequest == null) {
                DaemonPool._trace(exception);
                return;
            }
            if (msgRequest instanceof DistributedCacheKeyRequest || msgRequest instanceof UpdateIndexRequest) {
                Grid.Response msg = (Grid.Response)service.instantiateMessage("Response");
                msg.setResult(2);
                msg.setValue(exception);
                msgResponse = msg;
            } else if (msgRequest instanceof GetAllRequest || msgRequest instanceof InvokeAllRequest) {
                PartialMapResponse msg = (PartialMapResponse)service.instantiateMessage("PartialMapResponse");
                msg.setException(exception);
                msgResponse = msg;
            } else if (msgRequest instanceof InvokeFilterRequest || msgRequest instanceof KeyIteratorRequest || msgRequest instanceof QueryRequest) {
                QueryResponse msg = (QueryResponse)service.instantiateMessage("QueryResponse");
                msg.setException(exception);
                msgResponse = msg;
            } else {
                PartialValueResponse msg = (PartialValueResponse)service.instantiateMessage("PartialValueResponse");
                msg.setException(exception);
                msgResponse = msg;
            }
            msgResponse.respondTo(msgRequest);
            service.post(msgResponse);
        }

        static {
            DaemonPool.__initStatic();
        }
    }

    public static class EventsHelper
    extends Util
    implements EventInterceptor {
        private EventDispatcherRegistry __m_EventDispatcherRegistry;
        private transient AtomicLong __m_InterceptorCount;
        private InterceptorManager __m_InterceptorManager;
        private Filter __m_ModifiedBinaryEntryFilter;
        private ServiceDispatcher __m_ServiceDispatcher;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("BinaryEntryConverter", BinaryEntryConverter.get_CLASS());
            __mapChildren.put("ModifiedBinaryEntryFilter", ModifiedBinaryEntryFilter.get_CLASS());
            __mapChildren.put("StorageToEntriesConverter", StorageToEntriesConverter.get_CLASS());
        }

        public EventsHelper() {
            this(null, null, true);
        }

        public EventsHelper(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setInterceptorCount(new AtomicLong());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new EventsHelper();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$EventsHelper".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        protected void fireTransferEvent(Map mapStorage, int iPartition, Continuation continuation, TransferEvent.Type evtType) {
            this.fireTransferEvent(mapStorage, iPartition, continuation, evtType, null);
        }

        protected void fireTransferEvent(Map mapStorage, int iPartition, Continuation continuation, TransferEvent.Type evtType, String sSnapshotName) {
            ServiceDispatcher dispatcher = this.getServiceDispatcher();
            if (dispatcher != null && dispatcher.isSubscribed(evtType)) {
                PartitionedCache service = this.getService();
                Member memberLocal = service.getThisMember();
                Continuations contHelper = (Continuations)service.getContinuations();
                StorageToEntriesConverter convUp = new StorageToEntriesConverter();
                convUp.setPartitionId(iPartition);
                this._linkChild(convUp);
                com.tangosol.util.Converter convNull = NullImplementation.getConverter();
                Map<String, Set<BinaryEntry>> mapCaches = Collections.unmodifiableMap(ConverterCollections.getMap(mapStorage, convNull, convNull, convUp, convNull));
                if (continuation != null) {
                    continuation = contHelper.wrapAsMessage(continuation);
                }
                Continuation contEvent = evtType == TransferEvent.Type.RECOVERED ? dispatcher.getRecoveryTransferEventContinuation(iPartition, memberLocal, memberLocal, mapCaches, sSnapshotName, continuation) : dispatcher.getTransferEventContinuation(evtType, iPartition, memberLocal, memberLocal, mapCaches, continuation);
                contHelper.wrapAsTask(contEvent).proceed(Boolean.TRUE);
            } else if (continuation != null) {
                continuation.proceed(Boolean.FALSE);
            }
        }

        protected Set getBinaryEntries(Collection colStatus, boolean fPost) {
            if (fPost) {
                HashSet<Storage.BinaryEntry> setEntries = new HashSet<Storage.BinaryEntry>(colStatus.size());
                for (Storage.EntryStatus status : colStatus) {
                    if (!status.isAnyAction() || status.isExpiryOnly() || status.isSuppressEvents()) continue;
                    setEntries.add(status.getReadOnlyEntry());
                }
                return setEntries;
            }
            colStatus = ConversionHelper.getFilterCollection(colStatus, this.getModifiedBinaryEntryFilter());
            return new ConverterCollections.ConverterSet(colStatus, this.getService().getBinaryEntryConverter(), NullImplementation.getConverter());
        }

        public Set getBinaryEntries(Storage storage, Set setEntries) {
            Storage.EntryToBinaryEntryConverter convUp = storage.getEntryToBinaryEntryConverter();
            com.tangosol.util.Converter convNull = NullImplementation.getConverter();
            return ConverterCollections.getSet(setEntries, convUp, convNull);
        }

        protected Set getBinaryEntries(Storage storage, TransferRequest msgTransfer) {
            return this.getBinaryEntries(storage, new ImmutableArrayList(msgTransfer.getResource()).getSet());
        }

        protected EventDispatcherRegistry getEventDispatcherRegistry() {
            EventDispatcherRegistry reg = this.__m_EventDispatcherRegistry;
            if (reg == null) {
                ResourceRegistry registry = ((PartitionedCache)this.get_Parent()).getBackingMapManager().getCacheFactory().getResourceRegistry();
                reg = registry.getResource(EventDispatcherRegistry.class);
                this.setEventDispatcherRegistry(reg);
            }
            return reg;
        }

        protected AtomicLong getInterceptorCount() {
            return this.__m_InterceptorCount;
        }

        public InterceptorManager getInterceptorManager() {
            return this.__m_InterceptorManager;
        }

        protected Filter getModifiedBinaryEntryFilter() {
            return this.__m_ModifiedBinaryEntryFilter;
        }

        protected LongArray getPartitionedMapEntries(List listTransfer) {
            PartitionedCache service = this.getService();
            SparseArray<HashMap<String, Set>> laParts = new SparseArray<HashMap<String, Set>>();
            for (TransferRequest msg : listTransfer) {
                Storage storage = service.getStorage(msg.getCacheId());
                int iPart = msg.getPartition();
                HashMap<String, Set> mapCaches = (HashMap<String, Set>)laParts.get(iPart);
                if (mapCaches == null) {
                    mapCaches = new HashMap<String, Set>();
                    laParts.set(iPart, mapCaches);
                }
                if (storage == null) continue;
                mapCaches.put(storage.getCacheName(), this.getBinaryEntries(storage, msg));
            }
            return laParts;
        }

        public PartitionedCache getService() {
            return (PartitionedCache)this.get_Module();
        }

        public ServiceDispatcher getServiceDispatcher() {
            return this.__m_ServiceDispatcher;
        }

        protected StorageDispatcher getStorageDispatcher(Storage storage) {
            return storage.getEventDispatcher();
        }

        public boolean hasPreCommitInterceptors(Storage storage) {
            StorageDispatcher dispatcher = this.getStorageDispatcher(storage);
            return this.getInterceptorCount().get() > 0L && this.hasServiceInterceptors(TransactionEvent.Type.COMMITTING) || storage.hasInterceptors() && dispatcher != null && (dispatcher.isSubscribed(EntryEvent.Type.INSERTING) || dispatcher.isSubscribed(EntryEvent.Type.UPDATING) || dispatcher.isSubscribed(EntryEvent.Type.REMOVING));
        }

        public boolean hasServiceInterceptors() {
            ServiceDispatcher dispatcher = this.getServiceDispatcher();
            return dispatcher != null && !dispatcher.getInterceptorMap().isEmpty();
        }

        public boolean hasServiceInterceptors(Enum evtType) {
            ServiceDispatcher dispatcher = this.getServiceDispatcher();
            return this.getInterceptorCount().get() > 0L && dispatcher != null && dispatcher.isSubscribed(evtType);
        }

        public boolean hasStorageInterceptors(Storage storage, Enum evtType) {
            StorageDispatcher dispatcher = this.getStorageDispatcher(storage);
            return dispatcher != null && dispatcher.isSubscribed(evtType);
        }

        public StorageDispatcher instantiateStorageDispatcher(String sCacheName) {
            StorageDispatcher dispatcher = new StorageDispatcher(sCacheName, this.getService());
            EventDispatcherRegistry registry = this.getEventDispatcherRegistry();
            if (registry != null) {
                registry.registerEventDispatcher(dispatcher);
            }
            return dispatcher;
        }

        public StorageDispatcher instantiateStorageDispatcher(Storage storage) {
            StorageDispatcher dispatcher = new StorageDispatcher(storage);
            dispatcher.addEventInterceptor(this.get_Name(), storage.getEventDispatcherInterceptor(), new ImmutableArrayList(new Enum[]{EventDispatcher.InterceptorRegistrationEvent.Type.INSERTED, EventDispatcher.InterceptorRegistrationEvent.Type.REMOVED}), false);
            EventDispatcherRegistry registry = this.getEventDispatcherRegistry();
            if (registry != null) {
                registry.registerEventDispatcher(dispatcher);
            }
            if (this.hasServiceInterceptors(TransactionEvent.Type.COMMITTED) || this.hasServiceInterceptors(UnsolicitedCommitEvent.Type.COMMITTED)) {
                storage.ensureOldValueRequired();
            }
            return dispatcher;
        }

        public void onCacheConfigured(BinaryMap mapBinary) {
            String sCacheName = mapBinary.getCacheName();
            String sSvcName = this.getService().getServiceName();
            try {
                this.getInterceptorManager().instantiateCacheInterceptors(sCacheName, sSvcName);
            }
            catch (Exception e) {
                EventsHelper._trace("Failed to register event interceptors for cache " + sCacheName + " service " + sSvcName + ": " + String.valueOf(e) + "\n" + Base.getStackTrace(e), 1);
            }
            mapBinary.setDispatcher(this.instantiateStorageDispatcher(sCacheName));
        }

        public void onCacheConfigured(Storage storage) {
            PartitionedCache service = this.getService();
            if (service.getStorageArray().get(storage.getCacheId()) == storage) {
                String sCacheName = storage.getCacheName();
                String sSvcName = service.getServiceName();
                try {
                    this.getInterceptorManager().instantiateCacheInterceptors(sCacheName, sSvcName);
                }
                catch (Exception e) {
                    EventsHelper._trace("Failed to register event interceptors for cache " + sCacheName + " service " + sSvcName + ": " + String.valueOf(e), 1);
                }
            }
            storage.setEventDispatcher(this.instantiateStorageDispatcher(storage));
        }

        public void onCacheLifecycle(StorageDispatcher dispatcher, CacheLifecycleEvent.Type eventType) {
            if (dispatcher != null && dispatcher.isSubscribed(eventType)) {
                this.getService().getContinuations().wrapAsTask(dispatcher.getCacheLifecycleEventContinuation(eventType, null)).proceed(Boolean.TRUE);
            }
        }

        public void onEntriesArrived(List listTransfer, Continuation continuation) {
            ServiceDispatcher dispatcher = this.getServiceDispatcher();
            if (dispatcher != null && dispatcher.isSubscribed(TransferEvent.Type.ARRIVED) && !listTransfer.isEmpty()) {
                PartitionedCache service = this.getService();
                Continuations contHelper = (Continuations)service.getContinuations();
                TransferRequest msg = (TransferRequest)listTransfer.iterator().next();
                LongArray laPartMap = this.getPartitionedMapEntries(listTransfer);
                Member memberFrom = msg.getFromMember();
                Iterator iterPartMap = laPartMap.iterator();
                while (iterPartMap.hasNext()) {
                    Map<String, Set<BinaryEntry>> mapCaches = Collections.unmodifiableMap((Map)iterPartMap.next());
                    int iPart = (int)iterPartMap.getIndex();
                    contHelper.wrapAsTask(dispatcher.getTransferEventContinuation(TransferEvent.Type.ARRIVED, iPart, service.getThisMember(), memberFrom, mapCaches, iterPartMap.hasNext() ? null : contHelper.wrapAsMessage(continuation))).proceed(Boolean.TRUE);
                }
            } else if (continuation != null) {
                continuation.proceed(Boolean.FALSE);
            }
        }

        public void onEntriesDeparting(List listTransfer, Continuation continuation) {
            ServiceDispatcher dispatcher = this.getServiceDispatcher();
            if (dispatcher != null && dispatcher.isSubscribed(TransferEvent.Type.DEPARTING) && !listTransfer.isEmpty()) {
                PartitionedCache service = this.getService();
                Continuations contHelper = (Continuations)service.getContinuations();
                TransferRequest msg = (TransferRequest)listTransfer.iterator().next();
                LongArray laPartMap = this.getPartitionedMapEntries(listTransfer);
                Member memberTo = msg.getRecipient();
                Iterator iterPartMap = laPartMap.iterator();
                while (iterPartMap.hasNext()) {
                    Map<String, Set<BinaryEntry>> mapCaches = Collections.unmodifiableMap((Map)iterPartMap.next());
                    int iPart = (int)iterPartMap.getIndex();
                    contHelper.wrapAsTask(dispatcher.getTransferEventContinuation(TransferEvent.Type.DEPARTING, iPart, service.getThisMember(), memberTo, mapCaches, iterPartMap.hasNext() ? null : contHelper.wrapAsMessage(continuation))).proceed(Boolean.TRUE);
                }
            } else if (continuation != null) {
                continuation.proceed(Boolean.FALSE);
            }
        }

        public void onEntriesRecovered(Map mapStorage, int iPartition, String sSnapshotName, Continuation continuation) {
            this.fireTransferEvent(mapStorage, iPartition, continuation, TransferEvent.Type.RECOVERED, sSnapshotName);
        }

        public void onEntriesRestored(Map mapStorage, int iPartition, Continuation continuation) {
            this.fireTransferEvent(mapStorage, iPartition, continuation, TransferEvent.Type.ARRIVED);
        }

        public void onEntryChanged(EntryInfo entryInfo, Continuation continuation) {
            boolean fDispatch;
            PartitionedCache service = this.getService();
            BinaryEntry binEntry = entryInfo.getBinaryEntry();
            Storage storage = service.getStorage(binEntry.getBackingMapContext().getCacheName());
            EntryEvent.Type eventType = entryInfo.getEventType();
            StorageDispatcher dispatcher = this.getStorageDispatcher(storage);
            boolean bl = fDispatch = storage.hasInterceptors() && dispatcher != null;
            if (fDispatch && eventType == EntryEvent.Type.UPDATED && ReadWriteBackingMap.BIN_ERASE_PENDING.equals(binEntry.getBinaryValue())) {
                eventType = EntryEvent.Type.REMOVED;
            }
            if (storage.hasInterceptors() && dispatcher != null && dispatcher.isSubscribed(eventType)) {
                service.getContinuations().wrapAsTask(dispatcher.getEntryEventContinuation(eventType, Collections.singleton(binEntry), continuation)).proceed(Boolean.TRUE);
            } else if (continuation != null) {
                continuation.proceed(Boolean.FALSE);
            }
        }

        public void onEntryChanging(Storage.BinaryEntry binEntry, Continuation continuation) {
            EntryEvent.Type eventType = null;
            StorageDispatcher dispatcher = this.getStorageDispatcher(binEntry.getStorage());
            if (dispatcher != null && (binEntry.isValueRemoved() || ReadWriteBackingMap.BIN_ERASE_PENDING.equals(binEntry.getBinaryValue()) ? dispatcher.isSubscribed(eventType = EntryEvent.Type.REMOVING) : dispatcher.isSubscribed(EntryEvent.Type.INSERTING) || dispatcher.isSubscribed(EntryEvent.Type.UPDATING))) {
                if (eventType == null) {
                    eventType = binEntry.isValueLoaded() || binEntry.getOriginalBinaryValue() == null ? EntryEvent.Type.INSERTING : EntryEvent.Type.UPDATING;
                }
                dispatcher.getEntryEventContinuation(eventType, Collections.singleton(binEntry), continuation).proceed(Boolean.TRUE);
            } else if (continuation != null) {
                continuation.proceed(Boolean.FALSE);
            }
        }

        public void onEvent(Event event) {
            EventDispatcher.InterceptorRegistrationEvent evtDisp = (EventDispatcher.InterceptorRegistrationEvent)event;
            if (evtDisp.getInterceptor() != this && evtDisp.getType() == EventDispatcher.InterceptorRegistrationEvent.Type.INSERTED) {
                if (evtDisp.getEventTypes().contains((Object)TransactionEvent.Type.COMMITTED) || evtDisp.getEventTypes().contains((Object)UnsolicitedCommitEvent.Type.COMMITTED)) {
                    Iterator iter = this.getService().getStorageArray().iterator();
                    while (iter.hasNext()) {
                        ((Storage)iter.next()).ensureOldValueRequired();
                    }
                }
                this.getInterceptorCount().incrementAndGet();
            }
        }

        @Override
        public void onInit() {
            super.onInit();
            this.setModifiedBinaryEntryFilter(new ModifiedBinaryEntryFilter());
        }

        public void onInvoked(Storage storage, Set setEntries, InvocableMap.EntryProcessor agent, Continuation continuation) {
            StorageDispatcher dispatcher = this.getStorageDispatcher(storage);
            if (dispatcher != null && dispatcher.isSubscribed(EntryProcessorEvent.Type.EXECUTED)) {
                this.getService().getContinuations().wrapAsTask(dispatcher.getEntryProcessorEventContinuation(EntryProcessorEvent.Type.EXECUTED, agent, setEntries, continuation)).proceed(Boolean.TRUE);
            } else if (continuation != null) {
                continuation.proceed(Boolean.FALSE);
            }
        }

        public void onInvoking(Storage storage, Set setEntries, InvocableMap.EntryProcessor agent, Continuation continuation) {
            StorageDispatcher dispatcher = this.getStorageDispatcher(storage);
            if (dispatcher != null && dispatcher.isSubscribed(EntryProcessorEvent.Type.EXECUTING)) {
                dispatcher.getEntryProcessorEventContinuation(EntryProcessorEvent.Type.EXECUTING, agent, setEntries, continuation).proceed(Boolean.TRUE);
            } else if (continuation != null) {
                continuation.proceed(Boolean.FALSE);
            }
        }

        public final void onOutOfBandChanges(Set setEntries) {
            ServiceDispatcher dispatcher = this.getServiceDispatcher();
            if (dispatcher != null && !setEntries.isEmpty() && dispatcher.isSubscribed(UnsolicitedCommitEvent.Type.COMMITTED)) {
                this.getService().getContinuations().wrapAsTask(dispatcher.getUnsolicitedCommitEventContinuation(UnsolicitedCommitEvent.Type.COMMITTED, setEntries)).proceed(Boolean.TRUE);
            }
        }

        public void onPartitionAssigned(Map mapStorage, int iPartition, Continuation continuation) {
            this.fireTransferEvent(mapStorage, iPartition, continuation, TransferEvent.Type.ASSIGNED);
        }

        public void onPartitionLost(Map mapStorage, int iPartition, Continuation continuation) {
            this.fireTransferEvent(mapStorage, iPartition, continuation, TransferEvent.Type.LOST);
        }

        public void onServiceStarted() {
            ResourceRegistry registry = ((PartitionedCache)this.get_Module()).getBackingMapManager().getCacheFactory().getResourceRegistry();
            InterceptorManager manager = registry.getResource(InterceptorManager.class);
            this.setInterceptorManager(manager);
            PartitionedCache service = (PartitionedCache)this.get_Module();
            if (service.isOwnershipEnabled()) {
                String sSvcName = service.getServiceName();
                try {
                    manager.instantiateServiceInterceptors(sSvcName);
                }
                catch (Exception e) {
                    EventsHelper._trace("Failed to register event interceptors for service " + sSvcName + ": " + String.valueOf(e) + "\n" + Base.getStackTrace(e), 5);
                }
                this.registerServiceDispatcher();
            }
        }

        public final void onTransactionPostCommit(Set setEntries) {
            ServiceDispatcher dispatcher = this.getServiceDispatcher();
            if (this.getInterceptorCount().get() > 0L && dispatcher != null && dispatcher.isSubscribed(TransactionEvent.Type.COMMITTED) && !setEntries.isEmpty()) {
                this.getService().getContinuations().wrapAsTask(dispatcher.getTransactionEventContinuation(TransactionEvent.Type.COMMITTED, setEntries)).proceed(Boolean.TRUE);
            }
        }

        public final void onTransactionPreCommit(Collection colStatus) {
            Set setEntries;
            ServiceDispatcher dispatcher = this.getServiceDispatcher();
            if (dispatcher != null && !colStatus.isEmpty() && this.getInterceptorCount().get() > 0L && dispatcher.isSubscribed(TransactionEvent.Type.COMMITTING) && !(setEntries = this.getBinaryEntries(colStatus, false)).isEmpty()) {
                dispatcher.getTransactionEventContinuation(TransactionEvent.Type.COMMITTING, setEntries).proceed(Boolean.TRUE);
            }
        }

        public void onTransferCompleted(boolean fSuccess, int iPartition, Continuation continuation) {
            this.fireTransferEvent(this.getService().collectValidStorages(), iPartition, continuation, fSuccess ? TransferEvent.Type.DEPARTED : TransferEvent.Type.ROLLBACK);
        }

        protected void registerServiceDispatcher() {
            ServiceDispatcher dispatcher = new ServiceDispatcher(this.getService());
            this.setServiceDispatcher(dispatcher);
            dispatcher.addEventInterceptor(this.get_Name(), this, new ImmutableArrayList(new Enum[]{EventDispatcher.InterceptorRegistrationEvent.Type.INSERTED, EventDispatcher.InterceptorRegistrationEvent.Type.REMOVED}), false);
            EventDispatcherRegistry registry = this.getEventDispatcherRegistry();
            if (registry != null) {
                registry.registerEventDispatcher(dispatcher);
            }
        }

        protected void setEventDispatcherRegistry(EventDispatcherRegistry registryInterceptor) {
            this.__m_EventDispatcherRegistry = registryInterceptor;
        }

        protected void setInterceptorCount(AtomicLong atomicCount) {
            this.__m_InterceptorCount = atomicCount;
        }

        public void setInterceptorManager(InterceptorManager manager) {
            this.__m_InterceptorManager = manager;
        }

        protected void setModifiedBinaryEntryFilter(Filter filter) {
            this.__m_ModifiedBinaryEntryFilter = filter;
        }

        protected void setServiceDispatcher(ServiceDispatcher dispatcher) {
            this.__m_ServiceDispatcher = dispatcher;
        }

        public void unregisterServiceDispatcher() {
            ServiceDispatcher dispatcher = this.getServiceDispatcher();
            if (dispatcher != null) {
                EventDispatcherRegistry registry = this.getEventDispatcherRegistry();
                if (registry != null) {
                    registry.unregisterEventDispatcher(dispatcher);
                }
                dispatcher.removeEventInterceptor(this);
            }
        }

        public void unregisterStorageDispatcher(Storage storage) {
            StorageDispatcher dispatcher = storage.getEventDispatcher();
            if (dispatcher != null) {
                EventDispatcherRegistry registry = this.getEventDispatcherRegistry();
                if (registry != null) {
                    registry.unregisterEventDispatcher(dispatcher);
                }
                dispatcher.removeEventInterceptor(storage.getEventDispatcherInterceptor());
                storage.setEventDispatcher(null);
            }
        }

        static {
            EventsHelper.__initStatic();
        }

        public static class BinaryEntryConverter
        extends Util
        implements com.tangosol.util.Converter {
            public BinaryEntryConverter() {
                this(null, null, true);
            }

            public BinaryEntryConverter(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new BinaryEntryConverter();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$EventsHelper$BinaryEntryConverter".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public Object convert(Object o) {
                return ((Storage.EntryStatus)o).getBinaryEntry();
            }
        }

        public static class ModifiedBinaryEntryFilter
        extends Util
        implements Filter {
            public ModifiedBinaryEntryFilter() {
                this(null, null, true);
            }

            public ModifiedBinaryEntryFilter(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ModifiedBinaryEntryFilter();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$EventsHelper$ModifiedBinaryEntryFilter".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public boolean evaluate(Object oValue) {
                Storage.EntryStatus status = (Storage.EntryStatus)oValue;
                Storage.BinaryEntry binEntry = status.getBinaryEntry();
                return binEntry != null && (binEntry.isValueChanged() || binEntry.isValueLoaded()) && !status.isSuppressEvents();
            }
        }

        public static class StorageToEntriesConverter
        extends Util
        implements com.tangosol.util.Converter {
            private int __m_PartitionId;

            public StorageToEntriesConverter() {
                this(null, null, true);
            }

            public StorageToEntriesConverter(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new StorageToEntriesConverter();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$EventsHelper$StorageToEntriesConverter".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public Object convert(Object o) {
                if (o == null) {
                    return null;
                }
                Storage storage = (Storage)o;
                PartitionAwareBackingMap mapPABM = storage.getPartitionAwareBackingMap();
                if (mapPABM != null) {
                    Map mapPart = mapPABM.getPartitionMap(this.getPartitionId());
                    return this.getEventsHelper().getBinaryEntries(storage, mapPart.entrySet());
                }
                ObservableMap map = storage.getBackingMap();
                if (map == null) {
                    return Collections.emptySet();
                }
                Storage.KeyToBinaryEntryConverter convUp = storage.getKeyToBinaryEntryConverter();
                com.tangosol.util.Converter convNull = NullImplementation.getConverter();
                Set setKeys = storage.getPartitionedKeyIndex().getPartitionMap(this.getPartitionId()).keySet();
                return ConverterCollections.getSet(setKeys, convUp, convNull);
            }

            protected EventsHelper getEventsHelper() {
                return (EventsHelper)this.get_Parent();
            }

            public int getPartitionId() {
                return this.__m_PartitionId;
            }

            public void setPartitionId(int nId) {
                this.__m_PartitionId = nId;
            }
        }
    }

    public static class LazyLookup
    extends Component
    implements ReadBuffer {
        private Binary __m_Binary;
        private Object __m_LookupKey;
        private Map __m_LookupMap;

        public LazyLookup() {
            this(null, null, true);
        }

        public LazyLookup(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new LazyLookup();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$LazyLookup".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public byte byteAt(int of) {
            return this.getBinary().byteAt(of);
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new WrapperException(e);
            }
        }

        @Override
        public void copyBytes(int ofBegin, int ofEnd, byte[] abDest, int ofDest) {
            this.getBinary().copyBytes(ofBegin, ofEnd, abDest, ofDest);
        }

        public Binary getBinary() {
            Map mapLookup;
            Binary bin = this.__m_Binary;
            if (bin == null && (mapLookup = this.getLookupMap()) != null) {
                bin = (Binary)mapLookup.get(this.getLookupKey());
                this.setBinary(bin);
            }
            return bin;
        }

        @Override
        public ReadBuffer.BufferInput getBufferInput() {
            return this.getBinary().getBufferInput();
        }

        public Object getLookupKey() {
            return this.__m_LookupKey;
        }

        public Map getLookupMap() {
            return this.__m_LookupMap;
        }

        @Override
        public ReadBuffer getReadBuffer(int of, int cb) {
            return this.getBinary().getReadBuffer(of, cb);
        }

        @Override
        public int length() {
            Binary bin = this.getBinary();
            return bin == null ? 0 : bin.length();
        }

        public void reset() {
            this.setBinary(null);
            this.setLookupKey(null);
            this.setLookupMap(null);
        }

        protected void setBinary(Binary bin) {
            this.__m_Binary = bin;
        }

        public void setLookupKey(Object oKey) {
            this.__m_LookupKey = oKey;
        }

        public void setLookupMap(Map mapLookup) {
            this.__m_LookupMap = mapLookup;
        }

        @Override
        public ByteSequence subSequence(int ofStart, int ofEnd) {
            return this.getBinary().subSequence(ofStart, ofEnd);
        }

        @Override
        public Binary toBinary() {
            return this.getBinary();
        }

        @Override
        public Binary toBinary(int of, int cb) {
            return this.getBinary().toBinary(of, cb);
        }

        @Override
        public byte[] toByteArray() {
            return this.getBinary().toByteArray();
        }

        @Override
        public byte[] toByteArray(int of, int cb) {
            return this.getBinary().toByteArray(of, cb);
        }

        @Override
        public ByteBuffer toByteBuffer() {
            return this.getBinary().toByteBuffer();
        }

        @Override
        public ByteBuffer toByteBuffer(int of, int cb) {
            return this.getBinary().toByteBuffer(of, cb);
        }

        @Override
        public String toString() {
            return String.valueOf(this.getBinary());
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            this.getBinary().writeTo(out);
        }

        @Override
        public void writeTo(DataOutput out, int of, int cb) throws IOException {
            this.getBinary().writeTo(out, of, cb);
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            this.getBinary().writeTo(out);
        }

        @Override
        public void writeTo(OutputStream out, int of, int cb) throws IOException {
            this.getBinary().writeTo(out, of, cb);
        }

        @Override
        public void writeTo(ByteBuffer buf) {
            this.getBinary().writeTo(buf);
        }

        @Override
        public void writeTo(ByteBuffer buf, int of, int cb) throws IOException {
            this.getBinary().writeTo(buf, of, cb);
        }
    }

    public static class RequestCoordinator
    extends Util {
        private int __m_BacklogNormalCount;
        private int __m_CloggedCount;
        private AtomicInteger __m_DeferredRequestCounter;
        private Map __m_MemberInfoMap;
        private AtomicReferenceArray __m_PartitionInfoArray;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("BacklogContinuation", BacklogContinuation.get_CLASS());
        }

        public RequestCoordinator() {
            this(null, null, true);
        }

        public RequestCoordinator(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setDeferredRequestCounter(new AtomicInteger());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new RequestCoordinator();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$RequestCoordinator".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public boolean checkBacklog(int nPartition, Continuation continuation) {
            PartitionedCache service = this.getService();
            PartitionInfo infoPart = this.getPartitionInfo(nPartition);
            MemberInfo infoMember = (MemberInfo)this.getMemberInfoMap().get(infoPart.getTarget());
            if (infoMember.getCounter().get() >= this.getCloggedCount()) {
                if (continuation != null) {
                    SafeLinkedList list = infoMember.ensureBacklogContinuations();
                    list.add(continuation);
                    if (infoMember.getCounter().get() <= this.getBacklogNormalCount() || service.getServiceState() == 4) {
                        return !list.remove(continuation);
                    }
                }
                return true;
            }
            return service.ensureEventDispatcher().checkBacklog(continuation);
        }

        public boolean checkBacklog(PartitionSet partitions, Continuation continuation) {
            int iPart = partitions.next(0);
            while (iPart >= 0) {
                if (this.checkBacklog(iPart, continuation)) {
                    return true;
                }
                iPart = partitions.next(iPart + 1);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkDeferred() {
            if (this.getDeferredRequestCounter().get() > 0) {
                int c = this.getService().getPartitionCount();
                for (int i = 0; i < c; ++i) {
                    LongArray laDeferred = this.getPartitionInfo(i).getDeferredRequests();
                    if (laDeferred == null) continue;
                    LongArray longArray = laDeferred;
                    synchronized (longArray) {
                        Iterator iter = laDeferred.iterator();
                        while (iter.hasNext()) {
                            RequestMessage msgRequest = (RequestMessage)iter.next();
                            try {
                                this.validateRequest(msgRequest);
                            }
                            catch (Throwable e) {
                                AsyncContext ctx = (AsyncContext)msgRequest.getRequestContext();
                                ctx.processException(e);
                                ctx.processCompletion();
                                iter.remove();
                                this.getDeferredRequestCounter().decrementAndGet();
                            }
                        }
                        continue;
                    }
                }
            }
        }

        public void clearBacklog() {
            Map mapMemberInfo = this.getMemberInfoMap();
            if (mapMemberInfo != null) {
                for (MemberInfo info : mapMemberInfo.values()) {
                    PartitionedCache.notifyBacklogNormal(info.getBacklogContinuations());
                }
            }
            this.checkDeferred();
        }

        public AsyncContext createContext(BinaryMap mapBinary, AsynchronousAgent asyncAgent, com.tangosol.util.Converter convValue) {
            AsyncContext context;
            PartitionedCache service = this.getService();
            if (asyncAgent instanceof AbstractAsynchronousProcessor) {
                AsyncProcessorContext ctx = new AsyncProcessorContext();
                ctx.setAsyncProcessor((AbstractAsynchronousProcessor)asyncAgent);
                context = ctx;
            } else {
                AsyncAggregatorContext ctx = new AsyncAggregatorContext();
                ctx.setAsyncAggregator((AbstractAsynchronousAggregator)asyncAgent);
                context = ctx;
            }
            context.setValueConverter(convValue);
            if (mapBinary.isAuthorizationEnabled()) {
                context.setSubject(SecurityHelper.getCurrentSubject());
            }
            mapBinary._linkChild(context);
            service.registerRequestContext(context);
            asyncAgent.bind(context);
            return context;
        }

        protected void decrementBacklog(com.tangosol.net.Member member, int c) {
            SafeLinkedList list;
            int cNormal;
            MemberInfo info = (MemberInfo)this.getMemberInfoMap().get(member);
            int cBacklog = info.getCounter().addAndGet(-c);
            if (cBacklog + c > (cNormal = this.getBacklogNormalCount()) && cBacklog <= cNormal && (list = info.getBacklogContinuations()) != null && !list.isEmpty()) {
                PartitionedCache.notifyBacklogNormal(list);
            }
        }

        protected void doSubmit(RequestMessage msgRequest, Member member) {
            if (member != null) {
                msgRequest.setToMemberSet(SingleMemberSet.instantiate(member));
                msgRequest.ensureRequestPoll().setExpiryTimeMillis(msgRequest.getRequestTimeout());
                try {
                    this.getService().post(msgRequest);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public long drainBacklog(int nPartition, long cMillisTimeout) throws InterruptedException {
            BacklogContinuation continuation;
            if (this.checkBacklog(nPartition, null) && this.checkBacklog(nPartition, (Continuation)(continuation = new BacklogContinuation()))) {
                if (cMillisTimeout == 0L) {
                    continuation.getNotifier().await();
                } else {
                    long ldtTimeout = cMillisTimeout == 0L ? Long.MAX_VALUE : Base.getSafeTimeMillis() + cMillisTimeout;
                    continuation.getNotifier().await(cMillisTimeout);
                    cMillisTimeout = Base.computeSafeWaitTime(ldtTimeout);
                    if (cMillisTimeout < 0L) {
                        throw new RequestTimeoutException("Request timed out");
                    }
                }
            }
            return cMillisTimeout;
        }

        public long drainBacklog(PartitionSet partitions, long cMillisTimeout) throws InterruptedException {
            int iPart = partitions.next(0);
            while (iPart >= 0) {
                cMillisTimeout = this.drainBacklog(iPart, cMillisTimeout);
                iPart = partitions.next(iPart + 1);
            }
            return cMillisTimeout;
        }

        public void finalizeResponse(int nPartition) {
            Member memberOwner;
            PartitionInfo info = this.getPartitionInfo(nPartition);
            this.decrementBacklog(info.getTarget(), 1);
            if (info.getCounter().decrementAndGet() == 0 && info.getDeferredRequests() != null && (memberOwner = this.getService().getPrimaryOwner(nPartition)) != null && info.getOwnershipVersion() != this.getService().getOwnershipVersion(nPartition)) {
                this.transitionPartitionOwner(nPartition, memberOwner);
            }
        }

        public void finalizeResponse(PartitionSet partitions) {
            int iPart = partitions.next(0);
            while (iPart >= 0) {
                this.finalizeResponse(iPart);
                iPart = partitions.next(iPart + 1);
            }
        }

        public int getBacklogNormalCount() {
            return this.__m_BacklogNormalCount;
        }

        public int getCloggedCount() {
            return this.__m_CloggedCount;
        }

        public AtomicInteger getDeferredRequestCounter() {
            return this.__m_DeferredRequestCounter;
        }

        public Map getMemberInfoMap() {
            return this.__m_MemberInfoMap;
        }

        protected PartitionInfo getPartitionInfo(int nPartition) {
            return (PartitionInfo)this.getPartitionInfoArray().get(nPartition);
        }

        protected AtomicReferenceArray getPartitionInfoArray() {
            return this.__m_PartitionInfoArray;
        }

        public PartitionedCache getService() {
            return (PartitionedCache)this.get_Module();
        }

        protected void incrementBacklog(com.tangosol.net.Member member, int c) {
            MemberInfo info = (MemberInfo)this.getMemberInfoMap().get(member);
            info.getCounter().addAndGet(c);
        }

        public void initialize() {
            PartitionedCache service = this.getService();
            this.setPartitionInfoArray(new AtomicReferenceArray(service.getPartitionCount()));
            SafeHashMap<Object, MemberInfo> mapInfo = new SafeHashMap<Object, MemberInfo>();
            mapInfo.put(null, new MemberInfo());
            this.setMemberInfoMap(mapInfo);
            int cMaxPending = service.ensureEventDispatcher().getCloggedCount();
            try {
                String sMaxPending = Config.getProperty("coherence.async.limit");
                if (sMaxPending != null) {
                    cMaxPending = Integer.parseInt(sMaxPending);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            cMaxPending = Math.max(256, cMaxPending);
            this.setCloggedCount(cMaxPending);
            this.setBacklogNormalCount((cMaxPending >> 2) * 3);
        }

        protected PartitionInfo instantiatePartitionInfo(Member member, int nVersion) {
            PartitionInfo info = new PartitionInfo(member, nVersion);
            if (member == null) {
                info.setDeferredRequests(new SparseArray());
            } else {
                Map mapInfo = this.getMemberInfoMap();
                if (!mapInfo.containsKey(member)) {
                    mapInfo.put(member, new MemberInfo());
                }
            }
            return info;
        }

        public void onInterval() {
            this.checkDeferred();
        }

        public void onServiceResumed() {
            PartitionedCache service = this.getService();
            ServiceMemberSet setMembers = service.getServiceMemberSet();
            int[][] aaiOwners = service.getPartitionAssignments();
            int cParts = service.getPartitionCount();
            for (int iPart = 0; iPart < cParts; ++iPart) {
                this.updatePartitionOwner(iPart, ((MemberSet)setMembers).getMember(aaiOwners[iPart][0]), true);
            }
        }

        public void onServiceSuspended() {
            int cParts = this.getService().getPartitionCount();
            for (int iPart = 0; iPart < cParts; ++iPart) {
                this.updatePartitionOwner(iPart, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Member prepareSubmit(RequestMessage msgRequest, int nPartition, Map mapMsgByOwner) {
            boolean fFinalizeResponse;
            LongArray laDeferred;
            Member member;
            PartitionedCache service = (PartitionedCache)this.get_Module();
            block2: while (true) {
                PartitionInfo info = this.getPartitionInfo(nPartition);
                member = (Member)info.getTarget();
                laDeferred = info.getDeferredRequests();
                fFinalizeResponse = false;
                if (laDeferred == null) {
                    int cPending;
                    AtomicInteger counter = info.getCounter();
                    do {
                        if ((cPending = counter.get()) == -1) continue block2;
                    } while (!counter.compareAndSet(cPending, cPending + 1));
                    RequestCoordinator._assert(member != null);
                    this.incrementBacklog(member, 1);
                    DistributedCacheRequest msgFirst = mapMsgByOwner == null ? null : (DistributedCacheRequest)mapMsgByOwner.get(member);
                    msgRequest = msgFirst == null ? msgRequest : msgFirst;
                    Poll poll = msgRequest.ensureRequestPoll();
                    if (service.isSuspended() && msgRequest.isSuspendable() && poll.getPollId() > service.getSuspendPollLimit().get()) {
                        fFinalizeResponse = true;
                        laDeferred = info.getDeferredRequests();
                        RequestCoordinator._assert(laDeferred != null);
                    } else {
                        return member;
                    }
                }
                LongArray longArray = laDeferred;
                synchronized (longArray) {
                    this.validateRequest(msgRequest);
                    if (info == this.getPartitionInfo(nPartition)) break;
                }
            }
            {
                laDeferred.set(msgRequest.getRequestContext().getRequestSUID(), msgRequest);
            }
            this.getDeferredRequestCounter().incrementAndGet();
            this.incrementBacklog(member, 1);
            if (fFinalizeResponse) {
                this.finalizeResponse(nPartition);
            }
            return null;
        }

        public boolean resubmitRequest(DistributedCacheRequest msgRequest, PartitionSet partRequest, PartitionSet partUpdate) {
            if (partUpdate != null) {
                PartitionedCache service = (PartitionedCache)this.get_Module();
                PartitionVersions versions = msgRequest.getOwnershipVersions();
                int iPart = partUpdate.next(0);
                while (iPart >= 0) {
                    if (versions.getVersion(iPart) == service.getOwnershipVersion(iPart)) {
                        this.updatePartitionOwner(iPart, null);
                    }
                    iPart = partUpdate.next(iPart + 1);
                }
            }
            try {
                this.validateRequest(msgRequest);
            }
            catch (Throwable e) {
                ((AsyncContext)msgRequest.getRequestContext()).processException(e);
                return false;
            }
            if (msgRequest instanceof KeySetRequest) {
                KeySetRequest msgKSR = (KeySetRequest)msgRequest;
                Set setResend = msgKSR.getKeySet();
                return setResend == null || setResend.isEmpty() || this.submitKeySetRequest(msgKSR, setResend, null, true);
            }
            if (msgRequest instanceof FilterRequest) {
                return partRequest == null || partRequest.isEmpty() || this.submitPartialRequest((FilterRequest)msgRequest, partRequest, true);
            }
            throw new IllegalArgumentException("Invalid resubmit request: " + String.valueOf(msgRequest));
        }

        public boolean resubmitRequest(InvokeRequest msgRequest, int iPart, boolean fUpdatePart) {
            if (fUpdatePart && msgRequest.getOwnershipVersion() == this.getService().getOwnershipVersion(iPart)) {
                this.updatePartitionOwner(iPart, null);
            }
            try {
                this.validateRequest(msgRequest);
            }
            catch (Throwable e) {
                ((AsyncContext)msgRequest.getRequestContext()).processException(e);
                return false;
            }
            if (msgRequest instanceof InvokeRequest) {
                return this.submitKeyRequest(msgRequest, iPart);
            }
            throw new IllegalArgumentException("Invalid resubmit request: " + String.valueOf(msgRequest));
        }

        protected void setBacklogNormalCount(int c) {
            this.__m_BacklogNormalCount = c;
        }

        protected void setCloggedCount(int nCount) {
            this.__m_CloggedCount = nCount;
        }

        protected void setDeferredRequestCounter(AtomicInteger atomic) {
            this.__m_DeferredRequestCounter = atomic;
        }

        protected void setMemberInfoMap(Map map) {
            this.__m_MemberInfoMap = map;
        }

        protected void setPartitionInfo(int nPartition, PartitionInfo info) {
            this.getPartitionInfoArray().set(nPartition, info);
        }

        protected void setPartitionInfoArray(AtomicReferenceArray arrayInfo) {
            this.__m_PartitionInfoArray = arrayInfo;
        }

        public boolean submitKeyRequest(InvokeRequest msgRequest, int nPartition) {
            try {
                ((PartitionedCache)this.get_Module()).checkQuorum(msgRequest, msgRequest.isReadOnly());
                this.doSubmit(msgRequest, this.prepareSubmit(msgRequest, nPartition, null));
                return true;
            }
            catch (Throwable e) {
                ((AsyncContext)msgRequest.getRequestContext()).processException(e);
                return false;
            }
        }

        public boolean submitKeySetRequest(KeySetRequest msgRequest, Set setKeys, PartitionSet partitions, boolean fRepeat) {
            PartitionedCache service = this.getService();
            HashMap<Member, KeySetRequest> mapMsgByOwner = new HashMap<Member, KeySetRequest>();
            boolean fClone = false;
            try {
                service.checkQuorum(msgRequest, msgRequest.isReadOnly());
                Map mapKeysByPID = service.splitKeysByPartition(setKeys.iterator());
                for (Map.Entry entry : mapKeysByPID.entrySet()) {
                    int nPartition = (Integer)entry.getKey();
                    Set setPartKeys = (Set)entry.getValue();
                    if (fClone) {
                        msgRequest = (KeySetRequest)msgRequest.cloneMessage();
                    } else {
                        fClone = true;
                    }
                    msgRequest.setKeySet(setPartKeys);
                    msgRequest.setPartitions(service.instantiatePartitionSet(nPartition));
                    Member member = this.prepareSubmit(msgRequest, nPartition, mapMsgByOwner);
                    if (member != null) {
                        KeySetRequest msgFirst = (KeySetRequest)mapMsgByOwner.get(member);
                        if (msgFirst == null) {
                            mapMsgByOwner.put(member, msgRequest);
                        } else {
                            msgFirst.getKeySet().addAll(setPartKeys);
                            msgFirst.getPartitions().add(nPartition);
                        }
                    }
                    if (partitions == null) continue;
                    partitions.add(nPartition);
                }
            }
            catch (Throwable e) {
                ((AsyncContext)msgRequest.getRequestContext()).processException(e);
                return false;
            }
            if (!mapMsgByOwner.isEmpty()) {
                if (fRepeat) {
                    BinaryMap.reportRepeat(msgRequest.get_Name(), setKeys.size(), 0, ((PartitionedCache)this.get_Module()).calculatePartitionSet(setKeys));
                }
                for (Map.Entry entry : mapMsgByOwner.entrySet()) {
                    this.doSubmit((KeySetRequest)entry.getValue(), (Member)entry.getKey());
                }
            }
            return true;
        }

        public boolean submitPartialRequestByPartition(PartialRequest msgRequest, PartitionSet partitions, boolean fRepeat) {
            PartitionedCache service = this.getService();
            AsyncContext context = (AsyncContext)msgRequest.getRequestContext();
            HashMap<Integer, PartialRequest> mapMsgByPartition = new HashMap<Integer, PartialRequest>();
            try {
                service.checkQuorum(msgRequest, msgRequest.isReadOnly());
                boolean fClone = false;
                int iPart = partitions.next(0);
                while (iPart >= 0) {
                    PartitionSet partMember = new PartitionSet(partitions.getPartitionCount());
                    partMember.add(iPart);
                    if (fClone) {
                        msgRequest = (PartialRequest)msgRequest.cloneMessage();
                    } else {
                        fClone = true;
                    }
                    msgRequest.setRequestMask(partMember);
                    msgRequest.setPartitions(partitions);
                    Member member = this.prepareSubmit(msgRequest, iPart, mapMsgByPartition);
                    if (member != null) {
                        msgRequest.setToMemberSet(SingleMemberSet.instantiate(member));
                        mapMsgByPartition.put(iPart, msgRequest);
                    }
                    iPart = partitions.next(iPart + 1);
                }
            }
            catch (Throwable e) {
                context.processException(e);
                return false;
            }
            if (!mapMsgByPartition.isEmpty()) {
                if (fRepeat) {
                    BinaryMap.reportRepeat(msgRequest.get_Name(), 0, 0, partitions);
                }
                for (Map.Entry entry : mapMsgByPartition.entrySet()) {
                    PartialRequest msg = (PartialRequest)entry.getValue();
                    msg.ensureRequestPoll().setExpiryTimeMillis(msg.getRequestTimeout());
                    try {
                        this.getService().post(msg);
                    }
                    catch (Throwable throwable) {}
                }
            }
            return true;
        }

        public boolean submitPartialRequest(PartialRequest msgRequest, PartitionSet partitions, boolean fRepeat) {
            PartitionedCache service = this.getService();
            AsyncContext context = (AsyncContext)msgRequest.getRequestContext();
            HashMap<Member, PartialRequest> mapMsgByOwner = new HashMap<Member, PartialRequest>();
            try {
                service.checkQuorum(msgRequest, msgRequest.isReadOnly());
                boolean fClone = false;
                int iPart = partitions.next(0);
                while (iPart >= 0) {
                    if (fClone) {
                        msgRequest = (PartialRequest)msgRequest.cloneMessage();
                    } else {
                        fClone = true;
                    }
                    msgRequest.setRequestMask(service.instantiatePartitionSet(iPart));
                    msgRequest.setPartitions(context.getPartitionSet());
                    Member member = this.prepareSubmit(msgRequest, iPart, mapMsgByOwner);
                    if (member != null) {
                        PartialRequest msgFirst = (PartialRequest)mapMsgByOwner.get(member);
                        if (msgFirst == null) {
                            mapMsgByOwner.put(member, msgRequest);
                        } else {
                            msgFirst.getRequestMask().add(iPart);
                        }
                    }
                    iPart = partitions.next(iPart + 1);
                }
            }
            catch (Throwable e) {
                context.processException(e);
                return false;
            }
            if (!mapMsgByOwner.isEmpty()) {
                if (fRepeat) {
                    BinaryMap.reportRepeat(msgRequest.get_Name(), 0, 0, partitions);
                }
                for (Map.Entry entry : mapMsgByOwner.entrySet()) {
                    this.doSubmit((PartialRequest)entry.getValue(), (Member)entry.getKey());
                }
            }
            return true;
        }

        public void syncAssignments() {
            PartitionedCache service = this.getService();
            int cPartitions = service.getPartitionCount();
            int[][] aaiOwner = service.getPartitionAssignments();
            ServiceMemberSet setMember = service.getServiceMemberSet();
            RequestCoordinator._assert(Thread.currentThread() == service.getThread());
            for (int iPart = 0; iPart < cPartitions; ++iPart) {
                this.updatePartitionOwner(iPart, setMember.getMember(aaiOwner[iPart][0]));
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.get_Name());
            int c = this.getService().getPartitionCount();
            for (int i = 0; i < c; ++i) {
                PartitionInfo info = this.getPartitionInfo(i);
                int cPending = info.getCounter().get();
                LongArray laDeferred = info.getDeferredRequests();
                if (cPending == 0 && laDeferred == null) continue;
                sb.append("\n  Partition ").append(i).append(": pending=").append(cPending).append(", deferred=").append(laDeferred == null ? 0 : laDeferred.getSize());
            }
            for (Map.Entry entry : this.getMemberInfoMap().entrySet()) {
                com.tangosol.net.Member member = (com.tangosol.net.Member)entry.getKey();
                MemberInfo info = (MemberInfo)entry.getValue();
                int cPending = info.getCounter().get();
                SafeLinkedList list = info.getBacklogContinuations();
                if (cPending <= 0 && (list == null || list.isEmpty())) continue;
                sb.append("\n    Member ").append(member.getId()).append(": pending=").append(cPending).append(", awaiting=").append(list == null ? 0 : list.size());
            }
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void transitionPartitionOwner(int nPartition, Member memberNew) {
            PartitionedCache service = this.getService();
            PartitionInfo infoOld = this.getPartitionInfo(nPartition);
            if (infoOld.getCounter().compareAndSet(0, -1)) {
                LongArray laDeferred;
                RequestCoordinator._assert(memberNew != null);
                PartitionInfo infoNew = this.instantiatePartitionInfo(memberNew, service.getOwnershipVersion(nPartition));
                LongArray longArray = laDeferred = infoOld.getDeferredRequests();
                synchronized (longArray) {
                    int cDeferred = laDeferred.getSize();
                    if (service.isSuspended()) {
                        infoNew.setDeferredRequests(laDeferred);
                    } else {
                        for (RequestMessage msgRequest : laDeferred) {
                            this.doSubmit(msgRequest, memberNew);
                        }
                        this.getDeferredRequestCounter().addAndGet(-cDeferred);
                        infoNew.getCounter().addAndGet(cDeferred);
                    }
                    com.tangosol.net.Member memberOld = infoOld.getTarget();
                    if (memberOld != memberNew) {
                        this.incrementBacklog(memberNew, cDeferred);
                        this.decrementBacklog(memberOld, cDeferred);
                    }
                    this.setPartitionInfo(nPartition, infoNew);
                }
            }
        }

        public void updatePartitionOwner(int nPartition, Member member) {
            this.updatePartitionOwner(nPartition, member, false);
        }

        protected void updatePartitionOwner(int nPartition, Member member, boolean fResume) {
            RequestCoordinator._assert(Thread.currentThread() == this.getService().getThread());
            PartitionInfo info = this.getPartitionInfo(nPartition);
            if (info == null) {
                this.setPartitionInfo(nPartition, this.instantiatePartitionInfo(member, this.getService().getOwnershipVersion(nPartition)));
            } else if (info.getTarget() != member || info.getOwnershipVersion() != this.getService().getOwnershipVersion(nPartition) || fResume) {
                if (info.getDeferredRequests() == null) {
                    info.setDeferredRequests(new SparseArray());
                }
                if (member != null) {
                    this.transitionPartitionOwner(nPartition, member);
                }
            }
        }

        protected void validateRequest(RequestMessage msgRequest) {
            PartitionedCache service = (PartitionedCache)this.get_Module();
            AsyncContext ctx = (AsyncContext)msgRequest.getRequestContext();
            BinaryMap mapBinary = ctx.getCache();
            Object e = null;
            if (Base.getLastSafeTimeMillis() >= msgRequest.getRequestTimeout()) {
                throw new RequestTimeoutException("Async request timeout after " + service.calculateRequestTimeout(msgRequest) + "ms");
            }
            if (service.getServiceState() == 4) {
                throw new ServiceStoppedException("Service " + service.getServiceName() + " has been terminated");
            }
            if (!mapBinary.isActive()) {
                throw new RequestPolicyException("The reference to cache \"" + mapBinary.getCacheName() + "\" has been released");
            }
        }

        static {
            RequestCoordinator.__initStatic();
        }

        public static class BacklogContinuation
        extends Util
        implements Continuation {
            private SingleWaiterMultiNotifier __m_Notifier;

            public BacklogContinuation() {
                this(null, null, true);
            }

            public BacklogContinuation(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setNotifier(new SingleWaiterMultiNotifier());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new BacklogContinuation();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$RequestCoordinator$BacklogContinuation".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public SingleWaiterMultiNotifier getNotifier() {
                return this.__m_Notifier;
            }

            public void proceed(Object oResult) {
                this.getNotifier().signal();
            }

            protected void setNotifier(SingleWaiterMultiNotifier notifier) {
                this.__m_Notifier = notifier;
            }
        }
    }

    public static class ResourceCoordinator
    extends Util
    implements SegmentedConcurrentMap.ContentionObserver {
        private Map __m_ContentionMap;
        private BMEventFabric __m_EventFabric;
        private boolean __m_FinalizingRequest;
        private AtomicLong __m_IdCounter;
        private ThreadLocal __m_TloEventQueue;
        private ThreadLocal __m_TloFinalizingRequest;
        private BMEventFabric.EventQueue __m_UnmanagedEventQueue;

        public ResourceCoordinator() {
            this(null, null, true);
        }

        public ResourceCoordinator(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setContentionMap(new SafeHashMap());
                this.setEventFabric(new BMEventFabric());
                this.setTloEventQueue(new ThreadLocal());
                this.setTloFinalizingRequest(new ThreadLocal());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ResourceCoordinator();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$ResourceCoordinator".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        protected void checkResourceDeadlock(Object oContender) {
            Map mapContend = this.getContentionMap();
            LiteSet<Object> setHolders = new LiteSet<Object>();
            Object oHolder = oContender;
            do {
                Object oHolderPrev = oHolder;
                setHolders.add(oHolderPrev);
                SegmentedConcurrentMap.LockableEntry entry = (SegmentedConcurrentMap.LockableEntry)mapContend.get(oHolder);
                Object object = oHolder = entry == null ? null : entry.getLockHolder();
                if (!setHolders.contains(oHolder)) continue;
                SegmentedConcurrentMap.LockableEntry entryThis = (SegmentedConcurrentMap.LockableEntry)mapContend.get(oContender);
                if (oContender != oHolder && oContender != oHolderPrev || !entry.isContended() && System.identityHashCode(oContender) > System.identityHashCode(entryThis.getLockHolder())) break;
                Object oContenderThat = oContender == oHolder ? oHolderPrev : oHolder;
                Object[] aoContenders = new Object[]{oContender, oContenderThat};
                SegmentedConcurrentMap.LockableEntry[] aEntries = new SegmentedConcurrentMap.LockableEntry[]{entryThis, entry};
                this.reportContendingThreads(aoContenders, aEntries);
                throw new LockContentionException("A deadlock was detected while trying to lock cache resource " + this.getCacheKeyDescription(entryThis) + " which could be caused by unsafe use of the getBackingMapEntry() method. Threads under contention: " + String.valueOf(setHolders));
            } while (oHolder != null);
        }

        protected Set collectOOBStatus(Set setStatusOOB, BMEventFabric.EventHolder evtHolder) {
            if (setStatusOOB == null) {
                setStatusOOB = new LiteSet<Storage.EntryStatus>();
            }
            setStatusOOB.add((Storage.EntryStatus)evtHolder.getStatus());
            return setStatusOOB;
        }

        protected Set combineResults(Set set1, Set set2) {
            if (set1 == null || set1.isEmpty()) {
                return set2;
            }
            if (set2 == null || set2.isEmpty()) {
                return set1;
            }
            set1.addAll(set2);
            return set1;
        }

        public BMEventFabric.EventQueue ensureEventQueue() {
            ThreadLocal tloEventQueue = this.getTloEventQueue();
            BMEventFabric.EventQueue queue = (BMEventFabric.EventQueue)tloEventQueue.get();
            if (queue == null) {
                queue = this.instantiateEventQueue(true);
                tloEventQueue.set(queue);
            }
            return queue;
        }

        public Storage.EntryStatus ensureStatus(Storage storage, Binary binKey) {
            ConcurrentMap mapStatus = storage.getEntryStatusMap();
            Storage.EntryStatus status = (Storage.EntryStatus)mapStatus.get(binKey);
            if (status == null) {
                Storage.EntryStatus statusNew = Storage.EntryStatus.instantiateStatus(binKey);
                storage._linkChild(statusNew);
                statusNew.setPartition(this.getService().getKeyPartition(binKey));
                status = mapStatus.putIfAbsent(binKey, statusNew);
                if (status == null) {
                    status = statusNew;
                }
            }
            return status;
        }

        public Set finalizeInvoke() {
            BMEventFabric.EventQueue queueOOBEvents;
            BMEventFabric.EventQueue queueThdCurrent = this.ensureEventQueue();
            ResourceCoordinator._assert(queueThdCurrent != (queueOOBEvents = this.getUnmanagedEventQueue()));
            this.setFinalizingRequest(true);
            Set setStatus1 = this.finalizeInvokeSingleThreaded(queueThdCurrent);
            Set setStatus2 = this.finalizeInvokeSingleThreaded(queueOOBEvents);
            Set setTotal = null;
            if (setStatus1 == null || setStatus2 == null) {
                Set setStatus3 = this.finalizeInvokeMultiThreaded();
                setTotal = this.combineResults(this.combineResults(setStatus1, setStatus2), setStatus3);
            } else {
                setTotal = this.combineResults(setStatus1, setStatus2);
            }
            this.setFinalizingRequest(false);
            return setTotal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Set finalizeInvokeMultiThreaded() {
            Iterator iter;
            BMEventFabric.EventQueue queueThdCurrent = this.ensureEventQueue();
            BMEventFabric.EventQueue queueOOBEvents = this.getUnmanagedEventQueue();
            SparseArray<BMEventFabric.EventHolder> laEvents = new SparseArray<BMEventFabric.EventHolder>();
            boolean fLockAll = false;
            LinkedList<BMEventFabric.EventQueue> listThdQueues = new LinkedList<BMEventFabric.EventQueue>();
            LiteSet<BMEventFabric.EventQueue> setSeen = new LiteSet<BMEventFabric.EventQueue>();
            Set setStatusOOB = null;
            try {
                block3: while (true) {
                    listThdQueues.add(queueThdCurrent);
                    listThdQueues.add(queueOOBEvents);
                    while (!listThdQueues.isEmpty()) {
                        BMEventFabric.EventQueue queueThd = (BMEventFabric.EventQueue)listThdQueues.removeFirst();
                        if (!fLockAll && !queueThd.lock(0L)) {
                            iter = setSeen.iterator();
                            while (iter.hasNext()) {
                                ((BMEventFabric.EventQueue)iter.next()).unlock();
                            }
                            this.getEventFabric().lockAll(-1L);
                            fLockAll = true;
                            laEvents.clear();
                            setSeen.clear();
                            listThdQueues.clear();
                            continue block3;
                        }
                        setSeen.add(queueThd);
                        for (BMEventFabric.EventHolder holderByThd = queueThd.getFirstEvent(); holderByThd != null; holderByThd = holderByThd.getNextByThread()) {
                            Storage.EntryStatus status = (Storage.EntryStatus)holderByThd.getStatus();
                            laEvents.set(holderByThd.getEventId(), holderByThd);
                            BMEventFabric.EventQueue queueByKey = status.getEventQueue();
                            for (BMEventFabric.EventHolder holderByKey = queueByKey.getFirstEvent(); holderByKey != null; holderByKey = holderByKey.getNextByKey()) {
                                BMEventFabric.EventQueue queueThdOther = holderByKey.getThreadQueue();
                                if (setSeen.contains(queueThdOther) || listThdQueues.contains(queueThdOther)) continue;
                                listThdQueues.add(queueThdOther);
                            }
                        }
                    }
                    break;
                }
                for (BMEventFabric.EventHolder evtHolder : laEvents) {
                    if (this.processEvent(evtHolder)) continue;
                    setStatusOOB = this.collectOOBStatus(setStatusOOB, evtHolder);
                }
                Set set = setStatusOOB == null ? NullImplementation.getSet() : setStatusOOB;
                return set;
            }
            finally {
                if (fLockAll) {
                    this.getEventFabric().unlockAll();
                } else {
                    iter = setSeen.iterator();
                    while (iter.hasNext()) {
                        ((BMEventFabric.EventQueue)iter.next()).unlock();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Set finalizeInvokeSingleThreaded(BMEventFabric.EventQueue queueThd) {
            if (queueThd.isEmpty()) {
                return NullImplementation.getSet();
            }
            boolean fLock = this.getService().isConcurrent();
            if (fLock && !queueThd.lock(0L)) {
                return null;
            }
            Set setStatusOOB = null;
            try {
                BMEventFabric.EventHolder holderEnd = null;
                for (BMEventFabric.EventHolder holderByThd = queueThd.getFirstEvent(); holderByThd != null; holderByThd = holderByThd.getNextByThread()) {
                    Storage.EntryStatus status = (Storage.EntryStatus)holderByThd.getStatus();
                    BMEventFabric.EventQueue queueKey = status.getEventQueue();
                    if (queueKey.getFirstEvent() != queueKey.getLastEvent()) {
                        for (BMEventFabric.EventHolder holderByKey = queueKey.getFirstEvent(); holderByKey != null; holderByKey = holderByKey.getNextByKey()) {
                            if (holderByKey.getThreadQueue() == queueThd) continue;
                            Set set = null;
                            return set;
                        }
                    }
                    holderEnd = holderByThd;
                }
                BMEventFabric.EventHolder holderPrev = null;
                Object oMapEvtHolder = null;
                for (BMEventFabric.EventHolder holder = queueThd.getFirstEvent(); holder != null && holderPrev != holderEnd; holder = holder.getNextByThread()) {
                    if (!this.processEvent(holder)) {
                        setStatusOOB = this.collectOOBStatus(setStatusOOB, holder);
                    }
                    holderPrev = holder;
                }
                Set set = setStatusOOB == null ? NullImplementation.getSet() : setStatusOOB;
                return set;
            }
            finally {
                if (fLock) {
                    queueThd.unlock();
                }
            }
        }

        protected String getCacheKeyDescription(Map.Entry entry) {
            if (entry instanceof SegmentedConcurrentMap.LockableEntry) {
                Binary binKey = (Binary)entry.getKey();
                return this.getCacheName(entry) + "/BinaryKey(" + Base.toHexEscape(binKey, 0, binKey.length()) + ")";
            }
            return "";
        }

        protected String getCacheName(Map.Entry entry) {
            if (!(entry instanceof SegmentedConcurrentMap.LockableEntry)) {
                return "";
            }
            SegmentedConcurrentMap mapSource = ((SegmentedConcurrentMap.LockableEntry)entry).getSource();
            for (Storage storage : this.getService().getStorageArray()) {
                if (mapSource != storage.getResourceControlMap()) continue;
                return storage.getCacheName();
            }
            return "";
        }

        public Map getContentionMap() {
            return this.__m_ContentionMap;
        }

        public BMEventFabric getEventFabric() {
            return this.__m_EventFabric;
        }

        public BMEventFabric.EventQueue getEventQueue() {
            BMEventFabric.EventQueue queue = (BMEventFabric.EventQueue)this.getTloEventQueue().get();
            return queue == null || this.isFinalizingRequest() ? this.getUnmanagedEventQueue() : queue;
        }

        public AtomicLong getIdCounter() {
            return this.__m_IdCounter;
        }

        public PartitionedCache getService() {
            return (PartitionedCache)this.get_Module();
        }

        public Storage.EntryStatus getStatus(Storage storage, Binary binKey) {
            return (Storage.EntryStatus)storage.getEntryStatusMap().get(binKey);
        }

        public ThreadLocal getTloEventQueue() {
            return this.__m_TloEventQueue;
        }

        public ThreadLocal getTloFinalizingRequest() {
            return this.__m_TloFinalizingRequest;
        }

        public BMEventFabric.EventQueue getUnmanagedEventQueue() {
            return this.__m_UnmanagedEventQueue;
        }

        public com.tangosol.util.ConcurrentMap instantiateControlMap() {
            return new SegmentedConcurrentMap(this);
        }

        public BMEventFabric.EventQueue instantiateEventQueue(boolean fByThread) {
            return fByThread ? this.getEventFabric().createThreadQueue() : this.getEventFabric().createKeyQueue();
        }

        public boolean isFinalizingRequest() {
            Boolean fFinalizingRequest = (Boolean)this.getTloFinalizingRequest().get();
            return fFinalizingRequest != null && fFinalizingRequest != false;
        }

        public boolean lock(Storage storage, Binary binKey, long cWait) {
            this.ensureEventQueue();
            if (!this.getService().isConcurrent() || storage.getResourceControlMap().lock(binKey, cWait)) {
                this.ensureStatus(storage, binKey).setManaged(true);
                return true;
            }
            return false;
        }

        public boolean lockAll(Storage storage, long cWait) {
            this.ensureEventQueue();
            return storage.getResourceControlMap().lock(com.tangosol.util.ConcurrentMap.LOCK_ALL, cWait);
        }

        public void lockForTransfer(Storage storage, Binary binKey) {
            if (!this.lock(storage, binKey, 100L)) {
                ResourceCoordinator._trace("Failed to lock key for primary transfer", 2);
            }
        }

        @Override
        public void onContend(Object oContender, SegmentedConcurrentMap.LockableEntry entry) {
            this.getContentionMap().put(oContender, entry);
            this.checkResourceDeadlock(oContender);
        }

        @Override
        public void onInit() {
            this.setIdCounter(new AtomicLong());
            this.setUnmanagedEventQueue(this.instantiateEventQueue(true));
        }

        @Override
        public void onUncontend(Object oContender, SegmentedConcurrentMap.LockableEntry entry) {
            this.getContentionMap().remove(oContender);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean processEvent(BMEventFabric.EventHolder evtHolder) {
            Storage.BinaryEntry entryManaged;
            PartitionedCache service = this.getService();
            com.tangosol.util.MapEvent event = evtHolder.getEvent();
            Storage.EntryStatus status = (Storage.EntryStatus)evtHolder.getStatus();
            Storage storage = status.getStorage();
            Binary binKey = status.getKey();
            boolean fOOBEvent = false;
            Storage.BinaryEntry entry = null;
            boolean fSynthetic = false;
            if (!status.isManaged()) {
                if (this.getService().lockKey(storage, binKey, true, 0L)) {
                    fOOBEvent = true;
                } else if (!service.isPrimaryOwner(status.getPartition())) {
                    return true;
                }
            }
            if (event != null) {
                boolean fIncptrs;
                int nEventType = event.getId();
                Binary binValueOld = (Binary)event.getOldValue();
                Binary binValueNew = (Binary)event.getNewValue();
                EventsHelper evtHelper = service.getEventsHelper();
                boolean fKeyIndex = true;
                boolean fExpiryOnly = false;
                boolean fIndex = storage.isIndexed();
                boolean fEvents = storage.hasListeners();
                boolean bl = fIncptrs = storage.hasInterceptors() || evtHelper.hasServiceInterceptors(TransactionEvent.Type.COMMITTED) || evtHelper.hasServiceInterceptors(UnsolicitedCommitEvent.Type.COMMITTED);
                if (nEventType == 2) {
                    if (binValueOld != null && binValueNew != null) {
                        InvocationContext ctxInvoke = service.getInvocationContext();
                        boolean bl2 = fExpiryOnly = !status.hasEvent(event);
                        if (fExpiryOnly) {
                            fEvents = false;
                            fIndex = false;
                            fIncptrs = false;
                        }
                        if ((fIndex || fEvents || fIncptrs) && (ExternalizableHelper.isDecorated(binValueOld) || ExternalizableHelper.isDecorated(binValueNew)) && ExternalizableHelper.getUndecorated(binValueOld).equals(ExternalizableHelper.getUndecorated(binValueNew))) {
                            if (ExternalizableHelper.isDecorated(binValueOld, 2) && !ExternalizableHelper.isDecorated(binValueNew, 2)) {
                                fEvents = false;
                                fIncptrs = false;
                            }
                            fIndex = false;
                        }
                    }
                    fKeyIndex = false;
                }
                if (fIndex || fEvents || fIncptrs) {
                    fSynthetic = event instanceof com.tangosol.net.cache.CacheEvent && ((com.tangosol.net.cache.CacheEvent)event).isSynthetic();
                    entry = status.getReadOnlyEntry();
                    entry.updateOriginalBinaryValue(binValueOld);
                    status.setSuppressEvents(false);
                    if (!Base.equals(entry.isPresent() ? entry.getBinaryValue() : null, binValueNew)) {
                        entry.ensureWriteable();
                        entry.updateBinaryValue(binValueNew, fSynthetic);
                        entry.ensureReadOnly();
                    } else if (fSynthetic) {
                        entry.setSynthetic(true);
                    }
                    entry.ensureReadOnly();
                }
                if (fOOBEvent) {
                    status.setBinaryEntry(entry);
                }
                try {
                    if (fKeyIndex) {
                        storage.updateKeyIndex(event);
                    }
                    if (fIndex) {
                        storage.updateIndex(event.getId(), entry, null);
                    }
                }
                finally {
                    if (!fExpiryOnly) {
                        storage.getVersion().commit(status.getPartition());
                    }
                }
                Object oHolder = null;
                if (fEvents) {
                    oHolder = storage.prepareDispatch(event, entry);
                }
                status.setPending(true);
                try {
                    if (status.isAnyAction()) {
                        if (!fExpiryOnly) {
                            status.setExpiryOnly(false);
                        }
                    } else {
                        status.setAnyAction(true);
                        status.setOldValue(binValueOld);
                        status.setExpiryOnly(fExpiryOnly);
                    }
                    status.setMergedNewValue(binValueNew);
                    if (oHolder != null) {
                        status.addEventMessages(oHolder);
                    }
                }
                finally {
                    status.setPending(false);
                }
            }
            if (status.isManaged() && (entryManaged = status.getBinaryEntry()) != null && entryManaged != entry && fSynthetic && !entryManaged.isValueChanged()) {
                entryManaged.setSynthetic(true);
            }
            Storage.EntryStatus entryStatus = status;
            synchronized (entryStatus) {
                BMEventFabric fabric = this.getEventFabric();
                fabric.remove(evtHolder);
                if (!status.isManaged()) {
                    BMEventFabric.EventHolder holder = BMEventFabric.createEventHolder(status, null, this.getIdCounter().incrementAndGet());
                    fabric.add(holder, this.getUnmanagedEventQueue(), status.getEventQueue());
                }
            }
            return !fOOBEvent;
        }

        protected void removeStatus(Storage storage, Binary binKey, Storage.EntryStatus status) {
            status.setActive(false);
            storage.getEntryStatusMap().remove(binKey);
        }

        protected void reportContendingThreads(Object[] aoContenders, SegmentedConcurrentMap.LockableEntry[] aEntries) {
            if (!ResourceCoordinator._isTraceEnabled(5)) {
                return;
            }
            StringBuilder sb = new StringBuilder("\n");
            int c = aoContenders.length;
            for (int i = 0; i < c; ++i) {
                Object oThread = aoContenders[i];
                SegmentedConcurrentMap.LockableEntry entry = aEntries[i];
                if (entry == null) continue;
                sb.append(oThread);
                sb.append(" waiting on (").append(this.getCacheKeyDescription(entry));
                sb.append(")\n");
                if (!ResourceCoordinator._isTraceEnabled(8)) continue;
                StackTraceElement[] aoElement = ((Thread)oThread).getStackTrace();
                for (int j = 0; j < aoElement.length; ++j) {
                    sb.append("  at ").append(aoElement[j]).append("\n");
                }
                sb.append("\n");
            }
            ResourceCoordinator._trace("Key contention between threads detected on cache/key " + this.getCacheKeyDescription(aEntries[0]) + " that would result in deadlock" + String.valueOf(sb), 5);
        }

        protected void setContentionMap(Map map) {
            this.__m_ContentionMap = map;
        }

        public void setEventFabric(BMEventFabric pEventFabric) {
            this.__m_EventFabric = pEventFabric;
        }

        public void setFinalizingRequest(boolean fFinalizing) {
            this.getTloFinalizingRequest().set(fFinalizing);
        }

        protected void setIdCounter(AtomicLong atomicCounter) {
            this.__m_IdCounter = atomicCounter;
        }

        protected void setTloEventQueue(ThreadLocal tloEventQueue) {
            this.__m_TloEventQueue = tloEventQueue;
        }

        public void setTloFinalizingRequest(ThreadLocal localRequest) {
            this.__m_TloFinalizingRequest = localRequest;
        }

        protected void setUnmanagedEventQueue(BMEventFabric.EventQueue queue) {
            this.__m_UnmanagedEventQueue = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock(Storage storage, Binary binKey) {
            Storage.EntryStatus status = this.getStatus(storage, binKey);
            if (status != null) {
                Storage.EntryStatus entryStatus = status;
                synchronized (entryStatus) {
                    if (status.getEventQueue().isEmpty()) {
                        this.removeStatus(storage, binKey, status);
                    } else {
                        status.setBinaryEntry(null);
                    }
                    status.setManaged(false);
                }
            }
            if (this.getService().isConcurrent()) {
                storage.getResourceControlMap().unlock(binKey);
            }
        }

        public void unlockAll(Storage storage) {
            storage.getResourceControlMap().unlock(com.tangosol.util.ConcurrentMap.LOCK_ALL);
        }
    }

    public static class ServiceConfig
    extends Grid.ServiceConfig {
        public static final String TRUNCATE_TIME_ATTRIBUTE = "truncateTime";

        public ServiceConfig() {
            this(null, null, true);
        }

        public ServiceConfig(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setPendingConfigUpdates(new LinkedList());
                this.setPendingPolls(new LiteMap());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new ConfigListener("ConfigListener", this, true), "ConfigListener");
            this._addChild(new Grid.ServiceConfig.Map("Map", this, true), "Map");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ServiceConfig();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$ServiceConfig".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public static class ConfigListener
        extends ServiceConfig.ConfigListener {
            public ConfigListener() {
                this(null, null, true);
            }

            public ConfigListener(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ConfigListener();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$ServiceConfig$ConfigListener".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void entryDeleted(com.tangosol.util.MapEvent evt) {
                super.entryDeleted(evt);
                Object oKey = evt.getKey();
                if (oKey instanceof String) {
                    PartitionedCache service = (PartitionedCache)this.get_Module();
                    String sCacheName = (String)oKey;
                    XmlElement xmlCacheInfo = (XmlElement)evt.getOldValue();
                    StorageDispatcher dispatcher = null;
                    if (service.isAcceptingClients()) {
                        PartitionedCache partitionedCache = service;
                        synchronized (partitionedCache) {
                            ScopedCacheReferenceStore store = service.getScopedCacheStore();
                            for (ViewMap mapCache : store.getAllCaches(sCacheName)) {
                                mapCache.invalidate(true);
                            }
                            store.remove(sCacheName);
                            BinaryMap mapBinary = (BinaryMap)service.getReferencesBinaryMap().remove(sCacheName);
                            if (mapBinary != null) {
                                service.getBinaryMapArray().remove(mapBinary.getCacheId());
                                dispatcher = mapBinary.getDispatcher();
                                mapBinary.destroy();
                            }
                        }
                    }
                    if (service.isAcceptingOthers() && service.isOwnershipEnabled()) {
                        long lCacheId = xmlCacheInfo.getAttribute("id").getLong();
                        Storage storage = service.removeStorage(lCacheId);
                        if (storage == null) {
                            service.getStorageGraveyard().put(lCacheId, sCacheName);
                        } else {
                            dispatcher = storage.getEventDispatcher();
                            storage.invalidate();
                            service.destroyPersistentExtent(storage);
                        }
                    }
                    service.getEventsHelper().onCacheLifecycle(dispatcher, CacheLifecycleEvent.Type.DESTROYED);
                }
            }

            @Override
            public void entryInserted(com.tangosol.util.MapEvent evt) {
                super.entryInserted(evt);
                PartitionedCache service = (PartitionedCache)this.get_Module();
                Object oKey = evt.getKey();
                if (oKey instanceof String && service.isAcceptingOthers()) {
                    String sName = (String)oKey;
                    XmlElement xmlCacheInfo = (XmlElement)evt.getNewValue();
                    long lCacheId = xmlCacheInfo.getAttribute("id").getLong();
                    service.ensureStorageInternal(sName, lCacheId, true);
                }
            }

            @Override
            public void entryUpdated(com.tangosol.util.MapEvent evt) {
                super.entryUpdated(evt);
                PartitionedCache service = (PartitionedCache)this.get_Module();
                Object oKey = evt.getKey();
                XmlValue xmlValNew = ((XmlElement)evt.getNewValue()).getAttribute(ServiceConfig.TRUNCATE_TIME_ATTRIBUTE);
                XmlValue xmlValOld = ((XmlElement)evt.getOldValue()).getAttribute(ServiceConfig.TRUNCATE_TIME_ATTRIBUTE);
                if (oKey instanceof String && service.isAcceptingClients() && xmlValNew != null && (xmlValOld == null || xmlValNew.getInt() != xmlValOld.getInt())) {
                    String sName = (String)oKey;
                    Storage storage = service.getStorage(sName);
                    StorageDispatcher dispatcher = null;
                    if (storage == null) {
                        BinaryMap mapBinary = (BinaryMap)service.getReferencesBinaryMap().get(sName);
                        if (mapBinary != null) {
                            dispatcher = mapBinary.getDispatcher();
                        }
                    } else {
                        dispatcher = storage.getEventDispatcher();
                    }
                    service.getEventsHelper().onCacheLifecycle(dispatcher, CacheLifecycleEvent.Type.TRUNCATED);
                    ScopedCacheReferenceStore store = service.getScopedCacheStore();
                    for (ViewMap mapView : store.getAllCaches(sName)) {
                        Listeners listeners = mapView.getDeactivationListeners();
                        if (listeners.isEmpty()) continue;
                        com.tangosol.util.MapEvent<Object, Object> evtTruncated = new com.tangosol.util.MapEvent<Object, Object>(mapView, 2, null, null, null);
                        CacheEvent.dispatchSafe(evtTruncated, listeners, null);
                    }
                }
            }
        }
    }

    public static class TransferControl
    extends PartitionedService.TransferControl {
        private Map __m_Addendums;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("TransferIterator", PartitionedService.TransferControl.TransferIterator.get_CLASS());
        }

        public TransferControl() {
            this(null, null, true);
        }

        public TransferControl(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setAddendums(new LiteMap());
                this.setIncomingTransfers(new HashMap());
                this.setPartitionsOut(new PrimitiveSparseArray());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new TransferControl();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$TransferControl".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelTransmit(int iPartition) {
            List listAddendums;
            Map mapAddendums;
            Map map = mapAddendums = this.getAddendums();
            synchronized (map) {
                listAddendums = (List)mapAddendums.remove(iPartition);
            }
            if (listAddendums != null) {
                PartitionControl ctrlPartition = (PartitionControl)this.getPartitionControl(iPartition);
                for (Storage.DeferredEvent deferredEvt : listAddendums) {
                    deferredEvt.setReapply(false);
                    ctrlPartition.addUnlockAction(deferredEvt);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deferEvent(Storage.DeferredEvent evt) {
            Map mapAddendums;
            PartitionedCache service = (PartitionedCache)this.get_Module();
            com.tangosol.util.MapEvent mapEvt = evt.getEvent();
            Binary binKey = (Binary)mapEvt.getKey();
            int iPartition = service.getKeyPartition(binKey);
            Map map = mapAddendums = this.getAddendums();
            synchronized (map) {
                Integer IPartition = iPartition;
                List listAddendums = (List)mapAddendums.get(IPartition);
                if (listAddendums == null) {
                    listAddendums = new SafeLinkedList();
                    mapAddendums.put(IPartition, listAddendums);
                }
                listAddendums.add(evt);
            }
        }

        @Override
        public void finalizeReceivePartition(int iPartition, List listXferRequests) {
            super.finalizeReceivePartition(iPartition, listXferRequests);
            PartitionedCache service = (PartitionedCache)this.get_Module();
            if (service.isIndexed()) {
                for (Storage storage : service.getStorageArray()) {
                    if (!storage.isIndexed()) continue;
                    for (Map.Entry index : storage.getIndexExtractorMap().entrySet()) {
                        ValueExtractor extractor = (ValueExtractor)index.getKey();
                        Comparator comparator = (Comparator)index.getValue();
                        storage.createMapIndex(storage.getPartitionIndexMap(iPartition), extractor, comparator);
                    }
                    if (service.getDaemonPool().isStarted()) continue;
                    storage.createPartitionIndex(iPartition, null);
                }
                if (service.getDaemonPool().isStarted()) {
                    service.scheduleIndexUpdate(iPartition, 1);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void finalizeTransmit(PartitionedService.TransferRequest msgTransferLast) {
            Map mapAddendums;
            super.finalizeTransmit(msgTransferLast);
            Map map = mapAddendums = this.getAddendums();
            synchronized (map) {
                List listAddendums = (List)mapAddendums.get(msgTransferLast.getPartition());
                if (listAddendums != null) {
                    ((TransferRequest)msgTransferLast).setAddendums(listAddendums);
                }
            }
        }

        public Map getAddendums() {
            return this.__m_Addendums;
        }

        @Override
        public void onReceiveCommitted(PartitionedService.TransferRequest msgLastTransfer) {
            super.onReceiveCommitted(msgLastTransfer);
            if (msgLastTransfer.getStore() == 0) {
                this.processAddendums((TransferRequest)msgLastTransfer);
            }
        }

        @Override
        public void onReceiveStarted(PartitionedService.TransferRequest msgRequest, Continuation continuation) {
            String sName;
            Storage storage;
            PartitionedCache service = (PartitionedCache)this.get_Module();
            TransferRequest msgTransfer = (TransferRequest)msgRequest;
            long lCacheId = msgTransfer.getCacheId();
            if (lCacheId != -1L && (storage = service.ensureUniqueStorage(lCacheId, sName = msgTransfer.getCacheName(), true)) != null) {
                try {
                    storage.ensureInitialized(sName, true);
                }
                catch (IllegalArgumentException e) {
                    TransferControl._trace("The transfer request for cache \"" + msgTransfer.getCacheName() + "\" on partition " + msgTransfer.getPartition() + " is stale; discarding the transfer data", 1);
                    service.removeStorage(lCacheId);
                    storage.invalidate();
                }
            }
            if (msgRequest.getStore() == 0 && msgTransfer.isLastInTransfer()) {
                super.onReceiveStarted(msgRequest, null);
                service.getEventsHelper().onEntriesArrived(this.getQueuedTransfers(msgRequest.getFromMember()), continuation);
            } else {
                super.onReceiveStarted(msgRequest, continuation);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTransmitCompleted(int iPartition, int iStore) {
            super.onTransmitCompleted(iPartition, iStore);
            if (iStore == 0) {
                Map mapAddendums;
                Map map = mapAddendums = this.getAddendums();
                synchronized (map) {
                    mapAddendums.remove(iPartition);
                }
                PartitionedCache service = (PartitionedCache)this.get_Module();
                for (Storage storage : service.getStorageArray()) {
                    if (!storage.isIndexed()) continue;
                    storage.getPartitionedIndexMap().remove(iPartition);
                }
                service.updatePendingIndexPartition(iPartition, false);
            }
        }

        protected void processAddendums(TransferRequest msgLastTransfer) {
            List listAddendums = msgLastTransfer.getAddendums();
            if (listAddendums != null) {
                PartitionControl ctrlPart = (PartitionControl)this.getPartitionControl(msgLastTransfer.getPartition());
                Iterator iter = listAddendums.iterator();
                while (iter.hasNext()) {
                    ctrlPart.addUnlockAction((Continuation)iter.next());
                }
            }
        }

        protected void setAddendums(Map mapAddendum) {
            this.__m_Addendums = mapAddendum;
        }

        static {
            TransferControl.__initStatic();
        }
    }
}

