/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.oracle.coherence.common.io.BufferSequence;
import com.oracle.coherence.common.net.exabus.EndPoint;
import com.oracle.coherence.common.util.Duration;
import com.oracle.coherence.common.util.Threads;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.MessageHandler;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;

public abstract class TransportService
extends Grid {
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Acknowledgement", Grid.Acknowledgement.get_CLASS());
        __mapChildren.put("BusEventMessage", Grid.BusEventMessage.get_CLASS());
        __mapChildren.put("ConfigRequest", Grid.ConfigRequest.get_CLASS());
        __mapChildren.put("ConfigResponse", Grid.ConfigResponse.get_CLASS());
        __mapChildren.put("ConfigSync", Grid.ConfigSync.get_CLASS());
        __mapChildren.put("ConfigUpdate", Grid.ConfigUpdate.get_CLASS());
        __mapChildren.put("DispatchEvent", Grid.DispatchEvent.get_CLASS());
        __mapChildren.put("DispatchNotification", Grid.DispatchNotification.get_CLASS());
        __mapChildren.put("Heartbeat", Heartbeat.get_CLASS());
        __mapChildren.put("MemberConfigUpdate", Grid.MemberConfigUpdate.get_CLASS());
        __mapChildren.put("MemberJoined", Grid.MemberJoined.get_CLASS());
        __mapChildren.put("MemberWelcome", Grid.MemberWelcome.get_CLASS());
        __mapChildren.put("MemberWelcomeRequest", Grid.MemberWelcomeRequest.get_CLASS());
        __mapChildren.put("MemberWelcomeRequestTask", Grid.MemberWelcomeRequestTask.get_CLASS());
        __mapChildren.put("MessageHandler", MessageHandler.get_CLASS());
        __mapChildren.put("NotifyConnectionClose", Grid.NotifyConnectionClose.get_CLASS());
        __mapChildren.put("NotifyConnectionOpen", Grid.NotifyConnectionOpen.get_CLASS());
        __mapChildren.put("NotifyMemberJoined", Grid.NotifyMemberJoined.get_CLASS());
        __mapChildren.put("NotifyMemberLeaving", Grid.NotifyMemberLeaving.get_CLASS());
        __mapChildren.put("NotifyMemberLeft", Grid.NotifyMemberLeft.get_CLASS());
        __mapChildren.put("NotifyMessageReceipt", Grid.NotifyMessageReceipt.get_CLASS());
        __mapChildren.put("NotifyPollClosed", Grid.NotifyPollClosed.get_CLASS());
        __mapChildren.put("NotifyResponse", Grid.NotifyResponse.get_CLASS());
        __mapChildren.put("NotifyServiceAnnounced", Grid.NotifyServiceAnnounced.get_CLASS());
        __mapChildren.put("NotifyServiceJoining", Grid.NotifyServiceJoining.get_CLASS());
        __mapChildren.put("NotifyServiceLeaving", Grid.NotifyServiceLeaving.get_CLASS());
        __mapChildren.put("NotifyServiceLeft", Grid.NotifyServiceLeft.get_CLASS());
        __mapChildren.put("NotifyServiceQuiescence", Grid.NotifyServiceQuiescence.get_CLASS());
        __mapChildren.put("NotifyShutdown", Grid.NotifyShutdown.get_CLASS());
        __mapChildren.put("NotifyStartup", Grid.NotifyStartup.get_CLASS());
        __mapChildren.put("PingRequest", Grid.PingRequest.get_CLASS());
        __mapChildren.put("ProtocolContext", Grid.ProtocolContext.get_CLASS());
        __mapChildren.put("Response", Grid.Response.get_CLASS());
        __mapChildren.put("WrapperGuardable", Grid.WrapperGuardable.get_CLASS());
    }

    public TransportService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    @Override
    public String getServiceType() {
        return "Transport";
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/TransportService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    protected com.tangosol.coherence.component.net.MessageHandler instantiateMessageHandler() {
        return (MessageHandler)this._newChild("MessageHandler");
    }

    static {
        TransportService.__initStatic();
    }

    public static class Heartbeat
    extends Message {
        public Heartbeat() {
            this(null, null, true);
        }

        public Heartbeat(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(33);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Heartbeat();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/TransportService$Heartbeat".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }
    }

    public static abstract class MessageHandler
    extends com.tangosol.coherence.component.net.MessageHandler {
        private Set __m_PendingServiceFlush;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Connection", Connection.get_CLASS());
        }

        public MessageHandler(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/TransportService$MessageHandler".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public Set getPendingServiceFlush() {
            return this.__m_PendingServiceFlush;
        }

        @Override
        public void onInit() {
            super.onInit();
            this.setPendingServiceFlush(Collections.newSetFromMap(new ConcurrentHashMap()));
        }

        @Override
        public void processReceipt(EndPoint peer, Message msg, boolean fSuspect) {
            super.processReceipt(peer, msg, true);
        }

        protected void setPendingServiceFlush(Set setFlush) {
            this.__m_PendingServiceFlush = setFlush;
        }

        static {
            MessageHandler.__initStatic();
        }

        public static class Connection
        extends MessageHandler.Connection {
            public Connection() {
                this(null, null, true);
            }

            public Connection(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Connection();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/TransportService$MessageHandler$Connection".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public void onDeliveryTimeout() {
                Member member = this.getMember();
                if (member == null) {
                    super.onDeliveryTimeout();
                } else {
                    if (!member.isDeaf()) {
                        Connection._trace("Message delivery timeout to " + member.toString(2) + " after " + String.valueOf(new Duration(this.getDeliveryTimeoutMillis() * 1000000L)) + " via " + String.valueOf(this) + " on\n" + String.valueOf(((MessageHandler)this.get_Parent()).getMessageBus()) + "\n" + Threads.getThreadDump(), 5);
                    }
                    ((TransportService)this.get_Module()).getClusterService().doNotifyTcmpTimeout(null, SingleMemberSet.instantiate(member));
                }
            }

            @Override
            public void onIdle() {
                Member member;
                TransportService svc = (TransportService)this.get_Module();
                if (svc.isVersionCompatible(member = this.getMember(), 12, 2, 1, 2, 1)) {
                    long ldtNow = Base.getLastSafeTimeMillis();
                    long cMillisInterval = svc.getIntervalNextMillis() - ldtNow;
                    long cMillisWindow = ((MessageHandler)this.get_Parent()).getDeliveryTimeoutMillis() / 3L;
                    long cMillisIdle = ldtNow - this.getLastHealthyTimestamp();
                    int cIntervals = (int)(cMillisWindow / Math.max(1L, cMillisInterval));
                    if (cMillisIdle >= cMillisWindow || ThreadLocalRandom.current().nextInt(cIntervals) == 0) {
                        Heartbeat msg = (Heartbeat)svc.instantiateMessage("Heartbeat");
                        msg.setToMemberSet(SingleMemberSet.instantiate(member));
                        svc.post(msg);
                    }
                }
            }

            @Override
            public Message prepareMessage(BufferSequence bufseq) throws IOException {
                Message msg = super.prepareMessage(bufseq);
                if (msg != null) {
                    ((MessageHandler)this.get_Parent()).getPendingServiceFlush().add(msg.getService());
                }
                return msg;
            }

            @Override
            protected void setSuspectTimeoutTimestamp(long lTimestamp) {
            }
        }

        public static class EventCollector
        extends MessageHandler.EventCollector {
            public EventCollector() {
                this(null, null, true);
            }

            public EventCollector(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new EventCollector();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/TransportService$MessageHandler$EventCollector".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public void flush() {
                Set setService = ((MessageHandler)this.get_Parent()).getPendingServiceFlush();
                Iterator iter = setService.iterator();
                while (iter.hasNext()) {
                    Grid service = (Grid)iter.next();
                    iter.remove();
                    service.flush();
                }
                super.flush();
            }
        }
    }
}

