/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Lease;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.message.LeaseMessage;
import com.tangosol.coherence.component.net.message.leaseMessage.ResourceMessage;
import com.tangosol.coherence.component.util.Collections;
import com.tangosol.coherence.component.util.Converter;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.SimpleResourceRegistry;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;

public final class SimpleCache
extends Grid
implements CacheService,
NamedCache {
    private transient BackingMapManager __m_BackingMapManager;
    private transient com.tangosol.util.Converter __m_ConverterFromInternal;
    private transient com.tangosol.util.Converter __m_ConverterToInternal;
    private transient MapListenerSupport __m_ListenerSupport;
    private transient Map __m_ResourceMap;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Acknowledgement", Grid.Acknowledgement.get_CLASS());
        __mapChildren.put("BackingMapManagerContext", BackingMapManagerContext.get_CLASS());
        __mapChildren.put("BusEventMessage", Grid.BusEventMessage.get_CLASS());
        __mapChildren.put("ConfigRequest", Grid.ConfigRequest.get_CLASS());
        __mapChildren.put("ConfigResponse", Grid.ConfigResponse.get_CLASS());
        __mapChildren.put("ConfigSync", Grid.ConfigSync.get_CLASS());
        __mapChildren.put("ConfigUpdate", Grid.ConfigUpdate.get_CLASS());
        __mapChildren.put("ConverterFromInternal", ConverterFromInternal.get_CLASS());
        __mapChildren.put("ConverterToInternal", ConverterToInternal.get_CLASS());
        __mapChildren.put("DispatchEvent", Grid.DispatchEvent.get_CLASS());
        __mapChildren.put("DispatchNotification", Grid.DispatchNotification.get_CLASS());
        __mapChildren.put("MemberConfigUpdate", Grid.MemberConfigUpdate.get_CLASS());
        __mapChildren.put("MemberJoined", Grid.MemberJoined.get_CLASS());
        __mapChildren.put("MemberWelcome", Grid.MemberWelcome.get_CLASS());
        __mapChildren.put("MemberWelcomeRequest", Grid.MemberWelcomeRequest.get_CLASS());
        __mapChildren.put("MemberWelcomeRequestTask", Grid.MemberWelcomeRequestTask.get_CLASS());
        __mapChildren.put("NotifyConnectionClose", Grid.NotifyConnectionClose.get_CLASS());
        __mapChildren.put("NotifyConnectionOpen", Grid.NotifyConnectionOpen.get_CLASS());
        __mapChildren.put("NotifyMemberJoined", Grid.NotifyMemberJoined.get_CLASS());
        __mapChildren.put("NotifyMemberLeaving", Grid.NotifyMemberLeaving.get_CLASS());
        __mapChildren.put("NotifyMemberLeft", Grid.NotifyMemberLeft.get_CLASS());
        __mapChildren.put("NotifyMessageReceipt", Grid.NotifyMessageReceipt.get_CLASS());
        __mapChildren.put("NotifyPollClosed", Grid.NotifyPollClosed.get_CLASS());
        __mapChildren.put("NotifyResponse", Grid.NotifyResponse.get_CLASS());
        __mapChildren.put("NotifyServiceAnnounced", Grid.NotifyServiceAnnounced.get_CLASS());
        __mapChildren.put("NotifyServiceJoining", NotifyServiceJoining.get_CLASS());
        __mapChildren.put("NotifyServiceLeaving", Grid.NotifyServiceLeaving.get_CLASS());
        __mapChildren.put("NotifyServiceLeft", Grid.NotifyServiceLeft.get_CLASS());
        __mapChildren.put("NotifyServiceQuiescence", Grid.NotifyServiceQuiescence.get_CLASS());
        __mapChildren.put("NotifyShutdown", Grid.NotifyShutdown.get_CLASS());
        __mapChildren.put("NotifyStartup", Grid.NotifyStartup.get_CLASS());
        __mapChildren.put("PingRequest", Grid.PingRequest.get_CLASS());
        __mapChildren.put("ProtocolContext", Grid.ProtocolContext.get_CLASS());
        __mapChildren.put("ResourceRemove", ResourceRemove.get_CLASS());
        __mapChildren.put("ResourceRemoveAll", ResourceRemoveAll.get_CLASS());
        __mapChildren.put("ResourceUpdate", ResourceUpdate.get_CLASS());
        __mapChildren.put("Response", Grid.Response.get_CLASS());
        __mapChildren.put("WrapperGuardable", Grid.WrapperGuardable.get_CLASS());
    }

    public SimpleCache() {
        this(null, null, true);
    }

    public SimpleCache(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setMessageClassMap(new HashMap());
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setOldestPendingRequestSUIDCounter(new AtomicLong());
            this.setResourceMap(new SafeHashMap());
            this.setResourceRegistry(new SimpleResourceRegistry());
            this.setSerializerMap(new WeakHashMap());
            this.setSuspendPollLimit(new AtomicLong());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Grid.DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Grid.EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Grid.Guard("Guard", this, true), "Guard");
        this._addChild(new Grid.MemberConfigListener("MemberConfigListener", this, true), "MemberConfigListener");
        this._addChild(new Grid.PollArray("PollArray", this, true), "PollArray");
        this._addChild(new Grid.ReceiveQueue("ReceiveQueue", this, true), "ReceiveQueue");
        this._addChild(new Grid.ServiceConfig("ServiceConfig", this, true), "ServiceConfig");
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    @Override
    public String getServiceType() {
        return "SimpleCache";
    }

    public static Component get_Instance() {
        return new SimpleCache();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/SimpleCache".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addMapListener(MapListener listener) {
        this.addMapListener(listener, (Filter)null, false);
    }

    @Override
    public synchronized void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        SimpleCache._assert(listener != null);
        MapListenerSupport support = this.getListenerSupport();
        if (support == null) {
            support = new MapListenerSupport();
            this.setListenerSupport(support);
        }
        support.addListener(listener, filter, fLite);
    }

    @Override
    public synchronized void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        SimpleCache._assert(listener != null);
        MapListenerSupport support = this.getListenerSupport();
        if (support == null) {
            support = new MapListenerSupport();
            this.setListenerSupport(support);
        }
        support.addListener(listener, oKey, fLite);
    }

    @Override
    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        return this.aggregate((Collection)this.keySet(filter), agent);
    }

    @Override
    public Object aggregate(Collection collKeys, InvocableMap.EntryAggregator agent) {
        return agent.aggregate(InvocableMapHelper.makeEntrySet(this, collKeys, true));
    }

    protected void checkStatus() {
        if (this.getServiceState() != 2) {
            throw new IllegalStateException("Service is not running: " + String.valueOf(this));
        }
        if (!this.isActive()) {
            throw new IllegalStateException("Map has been invalidated:\n" + String.valueOf(this));
        }
    }

    @Override
    public void clear() {
        this.checkStatus();
        this.getResourceMap().clear();
        ResourceRemoveAll msg = (ResourceRemoveAll)this.instantiateMessage("ResourceRemoveAll");
        msg.setToMemberSet(this.getOthersMemberSet());
        this.send(msg);
    }

    @Override
    public boolean containsKey(Object oKey) {
        this.checkStatus();
        return this.getResourceMap().containsKey(oKey);
    }

    @Override
    public boolean containsValue(Object oValue) {
        this.checkStatus();
        return this.getResourceMap().containsValue(oValue);
    }

    @Override
    public void destroy() {
        this.clear();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.shutdown();
    }

    @Override
    public void destroyCache(NamedCache map) {
        SimpleCache._assert(map == this);
        this.destroy();
    }

    public void doResourceRemove(Object oKey) {
        Map map = this.getResourceMap();
        if (map.containsKey(oKey)) {
            MapListenerSupport support;
            Object oValueOld = map.remove(oKey);
            if (this.isActive() && (support = this.getListenerSupport()) != null) {
                MapEvent event = new MapEvent(this, 3, oKey, oValueOld, null);
                event = MapListenerSupport.convertEvent(event, this, null, this.getConverterFromInternal());
                support.fireEvent(event, true);
            }
        }
    }

    public void doResourceRemoveAll() {
        this.getResourceMap().clear();
    }

    public void doResourceUpdate(Object oKey, Object oValue) {
        MapListenerSupport support;
        Map map = this.getResourceMap();
        boolean fUpdate = map.containsKey(oKey);
        Object oValueOld = map.put(oKey, oValue);
        if (this.isActive() && (support = this.getListenerSupport()) != null) {
            MapEvent event = new MapEvent(this, fUpdate ? 2 : 1, oKey, oValueOld, oValue);
            event = MapListenerSupport.convertEvent(event, this, null, this.getConverterFromInternal());
            support.fireEvent(event, true);
        }
    }

    public void doWelcome(Member member) {
        if (this.getThisMember() == this.getServiceOldestMember()) {
            Enumeration e = this.getResourceKeys();
            while (e.hasMoreElements()) {
                Object oKey = e.nextElement();
                ResourceUpdate msg = (ResourceUpdate)this.instantiateMessage("ResourceUpdate");
                msg.addToMember(member);
                msg.setLease(Lease.instantiate(-1, oKey, this));
                msg.setResource(this.getResourceMap().get(oKey));
                this.send(msg);
            }
        }
    }

    @Override
    public synchronized NamedCache ensureCache(String sName, ClassLoader loader) {
        if (sName.equals(this.getServiceName())) {
            BackingMapManager manager = this.getBackingMapManager();
            if (manager != null) {
                Map map = manager.instantiateBackingMap(sName);
                if (map == null) {
                    throw new RuntimeException("BackingMapManager returned \"null\" for map " + sName);
                }
                map.putAll(this.getResourceMap());
                this.setResourceMap(map);
            }
            if (loader == null && (loader = this.getContextClassLoader()) == null) {
                loader = this.getClass().getClassLoader();
                SimpleCache._assert(loader != null, "ClassLoader must be specified");
            }
            if (loader != this.getContextClassLoader()) {
                this.releaseClassLoader();
                this.setContextClassLoader(loader);
            }
            return this;
        }
        throw new UnsupportedOperationException("Only one cache per service is allowed");
    }

    @Override
    public Set entrySet() {
        this.checkStatus();
        return java.util.Collections.unmodifiableSet(this.getResourceMap().entrySet());
    }

    @Override
    public Set entrySet(Filter filter) {
        return InvocableMapHelper.query(this, filter, true, false, null);
    }

    @Override
    public Set entrySet(Filter filter, Comparator comparator) {
        return InvocableMapHelper.query(this, filter, true, true, comparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object oKey) {
        this.checkStatus();
        Map mapResource = this.getResourceMap();
        Object oResource = mapResource.get(oKey);
        if (oResource instanceof Binary) {
            Binary binValue = (Binary)oResource;
            try {
                oResource = this.getConverterFromInternal().convert(binValue);
            }
            catch (WrapperException e) {
                throw new WrapperException(e.getOriginalException(), "CacheName=" + this.getCacheName() + ", Key=" + String.valueOf(oKey));
            }
            Map map = mapResource;
            synchronized (map) {
                if (binValue == mapResource.get(oKey)) {
                    mapResource.put(oKey, oResource);
                }
            }
        }
        return oResource;
    }

    @Override
    public Map getAll(Collection colKeys) {
        HashMap mapResult = new HashMap(colKeys.size());
        for (Object oKey : colKeys) {
            Object oVal = this.get(oKey);
            if (oVal == null && !this.containsKey(oKey)) continue;
            mapResult.put(oKey, oVal);
        }
        return mapResult;
    }

    @Override
    public BackingMapManager getBackingMapManager() {
        return this.__m_BackingMapManager;
    }

    @Override
    public String getCacheName() {
        return this.getServiceName();
    }

    @Override
    public Enumeration getCacheNames() {
        return new SimpleEnumerator<String>(new String[]{this.getServiceName()});
    }

    @Override
    public CacheService getCacheService() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.tangosol.util.Converter getConverterFromInternal() {
        com.tangosol.util.Converter conv = this.__m_ConverterFromInternal;
        if (conv == null) {
            SimpleCache simpleCache = this;
            synchronized (simpleCache) {
                conv = this.__m_ConverterFromInternal;
                if (conv == null) {
                    conv = this.instantiateConverterFromInternal(this.getContextClassLoader());
                    this.setConverterFromInternal(conv);
                }
            }
        }
        return conv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.tangosol.util.Converter getConverterToInternal() {
        com.tangosol.util.Converter conv = this.__m_ConverterToInternal;
        if (conv == null) {
            SimpleCache simpleCache = this;
            synchronized (simpleCache) {
                conv = this.__m_ConverterToInternal;
                if (conv == null) {
                    conv = this.instantiateConverterToInternal(this.getContextClassLoader());
                    this.setConverterToInternal(conv);
                }
            }
        }
        return conv;
    }

    public MapListenerSupport getListenerSupport() {
        return this.__m_ListenerSupport;
    }

    public Enumeration getResourceKeys() {
        return new SimpleEnumerator<Object>(this.getResourceMap().keySet().toArray());
    }

    public Map getResourceMap() {
        return this.__m_ResourceMap;
    }

    protected com.tangosol.util.Converter instantiateConverterFromInternal(ClassLoader loader) {
        ConverterFromInternal conv = (ConverterFromInternal)this._newChild("ConverterFromInternal");
        conv.setSerializer(this.ensureSerializer(loader));
        return conv;
    }

    protected com.tangosol.util.Converter instantiateConverterToInternal(ClassLoader loader) {
        ConverterToInternal conv = (ConverterToInternal)this._newChild("ConverterToInternal");
        conv.setSerializer(this.ensureSerializer(loader));
        return conv;
    }

    @Override
    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        return InvocableMapHelper.invokeLocked(this, InvocableMapHelper.makeEntry(this, oKey), agent);
    }

    @Override
    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        return this.invokeAll((Collection)this.keySet(filter), agent);
    }

    @Override
    public Map invokeAll(Collection collKeys, InvocableMap.EntryProcessor agent) {
        return InvocableMapHelper.invokeAllLocked(this, InvocableMapHelper.makeEntrySet(this, collKeys, false), agent);
    }

    @Override
    public boolean isActive() {
        return this.getContextClassLoader() != null;
    }

    @Override
    public boolean isEmpty() {
        this.checkStatus();
        return this.getResourceMap().isEmpty();
    }

    @Override
    public Set keySet() {
        this.checkStatus();
        return java.util.Collections.unmodifiableSet(this.getResourceMap().keySet());
    }

    @Override
    public Set keySet(Filter filter) {
        return InvocableMapHelper.query(this, filter, false, false, null);
    }

    @Override
    public boolean lock(Object oKey) {
        return this.lock(oKey, 0L);
    }

    @Override
    public boolean lock(Object oKey, long cWait) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onServiceStarted() {
        BackingMapManager manager = this.getBackingMapManager();
        if (manager != null) {
            BackingMapManagerContext ctx = (BackingMapManagerContext)this._newChild("BackingMapManagerContext");
            ctx.setManager(manager);
            manager.init(ctx);
        }
        super.onServiceStarted();
    }

    @Override
    public Object put(Object oKey, Object oValue) {
        return this.put(oKey, oValue, 0L);
    }

    @Override
    public Object put(Object oKey, Object oValue, long cMillis) {
        this.checkStatus();
        if (oValue != null && !(oValue instanceof Serializable)) {
            throw new IllegalArgumentException("Resource is not serializable: Key=" + String.valueOf(oKey) + ", Value=" + String.valueOf(oValue));
        }
        Object oValueOld = this.get(oKey);
        Map map = this.getResourceMap();
        if (map instanceof CacheMap) {
            ((CacheMap)map).put(oKey, oValue, cMillis);
        } else if (cMillis <= 0L) {
            map.put(oKey, oValue);
        } else {
            throw new UnsupportedOperationException("Class \"" + map.getClass().getName() + "\" does not implement CacheMap interface");
        }
        ResourceUpdate msg = (ResourceUpdate)this.instantiateMessage("ResourceUpdate");
        msg.setToMemberSet(this.getOthersMemberSet());
        msg.setLease(Lease.instantiate(-1, oKey, this));
        msg.setResource(oValue);
        this.send(msg);
        return oValueOld;
    }

    @Override
    public void putAll(Map map) {
        Collections.putAll(this, map);
    }

    @Override
    public void release() {
        this.shutdown();
    }

    @Override
    public void releaseCache(NamedCache map) {
        SimpleCache._assert(map == this);
        this.release();
    }

    protected void releaseClassLoader() {
        ClassLoader loader = this.getContextClassLoader();
        if (loader != null) {
            this.setContextClassLoader(null);
            Map map = this.getResourceMap();
            for (Object oKey : this.keySet()) {
                Object oValue = map.get(oKey);
                try {
                    Object oInternal = this.getConverterToInternal().convert(oValue);
                    if (oInternal == oValue) continue;
                    oValue = oInternal;
                    map.put(oKey, oValue);
                }
                catch (WrapperException e) {
                    throw new WrapperException(e.getOriginalException(), "CacheName=" + this.getCacheName() + ", Key=" + String.valueOf(oKey));
                }
            }
        }
    }

    @Override
    public Object remove(Object oKey) {
        this.checkStatus();
        Object oValue = this.get(oKey);
        this.getResourceMap().remove(oKey);
        ResourceRemove msg = (ResourceRemove)this.instantiateMessage("ResourceRemove");
        msg.setToMemberSet(this.getOthersMemberSet());
        msg.setLease(Lease.instantiate(-1, oKey, this));
        this.send(msg);
        return oValue;
    }

    @Override
    public void removeIndex(ValueExtractor extractor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, (Filter)null);
    }

    @Override
    public synchronized void removeMapListener(MapListener listener, Filter filter) {
        SimpleCache._assert(listener != null);
        MapListenerSupport support = this.getListenerSupport();
        if (support != null) {
            support.removeListener(listener, filter);
            if (support.isEmpty()) {
                this.setListenerSupport(null);
            }
        }
    }

    @Override
    public synchronized void removeMapListener(MapListener listener, Object oKey) {
        SimpleCache._assert(listener != null);
        MapListenerSupport support = this.getListenerSupport();
        if (support != null) {
            support.removeListener(listener, oKey);
            if (support.isEmpty()) {
                this.setListenerSupport(null);
            }
        }
    }

    @Override
    public void setBackingMapManager(BackingMapManager manager) {
        this.__m_BackingMapManager = manager;
    }

    protected void setConverterFromInternal(com.tangosol.util.Converter conv) {
        this.__m_ConverterFromInternal = conv;
    }

    protected void setConverterToInternal(com.tangosol.util.Converter pConverterToInternal) {
        this.__m_ConverterToInternal = pConverterToInternal;
    }

    protected void setListenerSupport(MapListenerSupport support) {
        this.__m_ListenerSupport = support;
    }

    protected void setResourceMap(Map map) {
        this.__m_ResourceMap = map;
    }

    @Override
    public int size() {
        this.checkStatus();
        return this.getResourceMap().size();
    }

    @Override
    public void stop() {
        super.stop();
        this.setContextClassLoader(null);
        this.setResourceMap(java.util.Collections.EMPTY_MAP);
    }

    @Override
    public boolean unlock(Object oKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection values() {
        this.checkStatus();
        return java.util.Collections.unmodifiableCollection(this.getResourceMap().values());
    }

    static {
        SimpleCache.__initStatic();
    }

    public static class BackingMapManagerContext
    extends com.tangosol.coherence.component.util.BackingMapManagerContext {
        public BackingMapManagerContext() {
            this(null, null, true);
        }

        public BackingMapManagerContext(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new BackingMapManagerContext();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/SimpleCache$BackingMapManagerContext".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public ClassLoader getClassLoader() {
            return ((SimpleCache)this.get_Module()).getContextClassLoader();
        }

        @Override
        public com.tangosol.util.Converter getKeyFromInternalConverter() {
            return NullImplementation.getConverter();
        }

        @Override
        public com.tangosol.util.Converter getKeyToInternalConverter() {
            return NullImplementation.getConverter();
        }

        @Override
        public com.tangosol.util.Converter getValueFromInternalConverter() {
            return ((SimpleCache)this.get_Module()).getConverterFromInternal();
        }

        @Override
        public com.tangosol.util.Converter getValueToInternalConverter() {
            return NullImplementation.getConverter();
        }

        @Override
        public void setClassLoader(ClassLoader loader) {
            ((SimpleCache)this.get_Module()).setContextClassLoader(loader);
        }
    }

    public static class ConverterFromInternal
    extends Converter {
        public ConverterFromInternal() {
            this(null, null, true);
        }

        public ConverterFromInternal(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ConverterFromInternal();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/SimpleCache$ConverterFromInternal".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public Object convert(Object o) {
            if (o instanceof Binary) {
                o = ExternalizableHelper.fromBinary((Binary)o, this.getSerializer());
            }
            return o;
        }
    }

    public static class ConverterToInternal
    extends Converter {
        public ConverterToInternal() {
            this(null, null, true);
        }

        public ConverterToInternal(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ConverterToInternal();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/SimpleCache$ConverterToInternal".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public Object convert(Object o) {
            return ExternalizableHelper.toBinary(o, this.getSerializer());
        }
    }

    public static class NotifyServiceJoining
    extends Grid.NotifyServiceJoining {
        public NotifyServiceJoining() {
            this(null, null, true);
        }

        public NotifyServiceJoining(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-10);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new Grid.NotifyServiceJoining.Poll("Poll", this, true), "Poll");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyServiceJoining();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/SimpleCache$NotifyServiceJoining".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void onReceived() {
            super.onReceived();
            SimpleCache service = (SimpleCache)this.getService();
            service.doWelcome(this.getNotifyMember());
        }
    }

    public static class ResourceRemove
    extends LeaseMessage {
        public ResourceRemove() {
            this(null, null, true);
        }

        public ResourceRemove(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(2);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ResourceRemove();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/SimpleCache$ResourceRemove".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void onReceived() {
            super.onReceived();
            SimpleCache service = (SimpleCache)this.getService();
            service.doResourceRemove(this.getLease().getResourceKey());
        }
    }

    public static class ResourceRemoveAll
    extends Message {
        private boolean __m_Shutdown;

        public ResourceRemoveAll() {
            this(null, null, true);
        }

        public ResourceRemoveAll(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(3);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ResourceRemoveAll();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/SimpleCache$ResourceRemoveAll".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public boolean isShutdown() {
            return this.__m_Shutdown;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            SimpleCache service = (SimpleCache)this.getService();
            if (this.isShutdown()) {
                service.shutdown();
            } else {
                service.doResourceRemoveAll();
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setShutdown(input.readBoolean());
        }

        public void setShutdown(boolean pShutdown) {
            this.__m_Shutdown = pShutdown;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeBoolean(this.isShutdown());
        }
    }

    public static class ResourceUpdate
    extends ResourceMessage {
        public ResourceUpdate() {
            this(null, null, true);
        }

        public ResourceUpdate(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(1);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ResourceUpdate();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/SimpleCache$ResourceUpdate".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void onReceived() {
            super.onReceived();
            SimpleCache service = (SimpleCache)this.getService();
            service.doResourceUpdate(this.getLease().getResourceKey(), this.getResource());
        }
    }
}

