/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Lease;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.memberSet.EmptyMemberSet;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.net.message.CacheMessage;
import com.tangosol.coherence.component.net.message.LeaseMessage;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.net.message.leaseMessage.ResourceMessage;
import com.tangosol.coherence.component.net.message.requestMessage.LeaseRequest;
import com.tangosol.coherence.component.util.BackingMapManagerContext;
import com.tangosol.coherence.component.util.CacheHandler;
import com.tangosol.coherence.component.util.Converter;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.internal.net.service.DefaultServiceDependencies;
import com.tangosol.internal.net.service.grid.DefaultReplicatedCacheDependencies;
import com.tangosol.internal.net.service.grid.LegacyXmlReplicatedCacheHelper;
import com.tangosol.internal.net.service.grid.ReplicatedCacheDependencies;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.FilterEnumerator;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.NullFilter;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SimpleResourceRegistry;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class ReplicatedCache
extends Grid
implements CacheService {
    private transient BackingMapContext __m_BackingMapContext;
    private transient BackingMapManager __m_BackingMapManager;
    private transient com.tangosol.coherence.component.util.CacheHandler[] __m_CacheHandler;
    private transient long __m_LockingNextMillis;
    private List __m_LockRequestQueue;
    private transient MemberSet __m_UpdatingMemberSet;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Acknowledgement", Grid.Acknowledgement.get_CLASS());
        __mapChildren.put("BackingMapContext", BackingMapContext.get_CLASS());
        __mapChildren.put("BusEventMessage", Grid.BusEventMessage.get_CLASS());
        __mapChildren.put("CacheHandler", CacheHandler.get_CLASS());
        __mapChildren.put("CacheUpdate", CacheUpdate.get_CLASS());
        __mapChildren.put("CacheUpdateRequest", CacheUpdateRequest.get_CLASS());
        __mapChildren.put("ConfigRequest", Grid.ConfigRequest.get_CLASS());
        __mapChildren.put("ConfigResponse", Grid.ConfigResponse.get_CLASS());
        __mapChildren.put("ConfigSync", Grid.ConfigSync.get_CLASS());
        __mapChildren.put("ConfigUpdate", Grid.ConfigUpdate.get_CLASS());
        __mapChildren.put("ConverterFromInternal", ConverterFromInternal.get_CLASS());
        __mapChildren.put("ConverterToInternal", ConverterToInternal.get_CLASS());
        __mapChildren.put("DispatchEvent", DispatchEvent.get_CLASS());
        __mapChildren.put("DispatchNotification", Grid.DispatchNotification.get_CLASS());
        __mapChildren.put("LeaseIssue", LeaseIssue.get_CLASS());
        __mapChildren.put("LeaseIssueRequest", LeaseIssueRequest.get_CLASS());
        __mapChildren.put("LeaseLock", LeaseLock.get_CLASS());
        __mapChildren.put("LeaseLockRequest", LeaseLockRequest.get_CLASS());
        __mapChildren.put("LeaseRemove", LeaseRemove.get_CLASS());
        __mapChildren.put("LeaseRemoveRequest", LeaseRemoveRequest.get_CLASS());
        __mapChildren.put("LeaseUnlock", LeaseUnlock.get_CLASS());
        __mapChildren.put("LeaseUnlockRequest", LeaseUnlockRequest.get_CLASS());
        __mapChildren.put("LeaseUpdate", LeaseUpdate.get_CLASS());
        __mapChildren.put("LeaseUpdateRequest", LeaseUpdateRequest.get_CLASS());
        __mapChildren.put("MemberConfigUpdate", Grid.MemberConfigUpdate.get_CLASS());
        __mapChildren.put("MemberJoined", Grid.MemberJoined.get_CLASS());
        __mapChildren.put("MemberWelcome", Grid.MemberWelcome.get_CLASS());
        __mapChildren.put("MemberWelcomeRequest", Grid.MemberWelcomeRequest.get_CLASS());
        __mapChildren.put("MemberWelcomeRequestTask", Grid.MemberWelcomeRequestTask.get_CLASS());
        __mapChildren.put("NotifyConnectionClose", Grid.NotifyConnectionClose.get_CLASS());
        __mapChildren.put("NotifyConnectionOpen", Grid.NotifyConnectionOpen.get_CLASS());
        __mapChildren.put("NotifyMemberJoined", Grid.NotifyMemberJoined.get_CLASS());
        __mapChildren.put("NotifyMemberLeaving", Grid.NotifyMemberLeaving.get_CLASS());
        __mapChildren.put("NotifyMemberLeft", Grid.NotifyMemberLeft.get_CLASS());
        __mapChildren.put("NotifyMessageReceipt", Grid.NotifyMessageReceipt.get_CLASS());
        __mapChildren.put("NotifyPollClosed", Grid.NotifyPollClosed.get_CLASS());
        __mapChildren.put("NotifyResponse", Grid.NotifyResponse.get_CLASS());
        __mapChildren.put("NotifyServiceAnnounced", Grid.NotifyServiceAnnounced.get_CLASS());
        __mapChildren.put("NotifyServiceJoining", Grid.NotifyServiceJoining.get_CLASS());
        __mapChildren.put("NotifyServiceLeaving", Grid.NotifyServiceLeaving.get_CLASS());
        __mapChildren.put("NotifyServiceLeft", Grid.NotifyServiceLeft.get_CLASS());
        __mapChildren.put("NotifyServiceQuiescence", Grid.NotifyServiceQuiescence.get_CLASS());
        __mapChildren.put("NotifyShutdown", Grid.NotifyShutdown.get_CLASS());
        __mapChildren.put("NotifyStartup", Grid.NotifyStartup.get_CLASS());
        __mapChildren.put("PingRequest", Grid.PingRequest.get_CLASS());
        __mapChildren.put("ProtocolContext", Grid.ProtocolContext.get_CLASS());
        __mapChildren.put("Response", Grid.Response.get_CLASS());
        __mapChildren.put("WrapperGuardable", Grid.WrapperGuardable.get_CLASS());
    }

    public ReplicatedCache() {
        this(null, null, true);
    }

    public ReplicatedCache(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setLockingNextMillis(Long.MAX_VALUE);
            this.setLockRequestQueue(new LinkedList());
            this.setMessageClassMap(new HashMap());
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setOldestPendingRequestSUIDCounter(new AtomicLong());
            this.setResourceRegistry(new SimpleResourceRegistry());
            this.setSerializerMap(new WeakHashMap());
            this.setSuspendPollLimit(new AtomicLong());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new CatalogHandler("CatalogHandler", this, true), "CatalogHandler");
        this._addChild(new Grid.DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Grid.EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Grid.Guard("Guard", this, true), "Guard");
        this._addChild(new Grid.MemberConfigListener("MemberConfigListener", this, true), "MemberConfigListener");
        this._addChild(new Grid.PollArray("PollArray", this, true), "PollArray");
        this._addChild(new Grid.ReceiveQueue("ReceiveQueue", this, true), "ReceiveQueue");
        this._addChild(new Grid.ServiceConfig("ServiceConfig", this, true), "ServiceConfig");
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    @Override
    public String getServiceType() {
        return "ReplicatedCache";
    }

    public static Component get_Instance() {
        return new ReplicatedCache();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    public void _imports() {
    }

    protected void checkStatus() {
        if (this.getServiceState() != 2) {
            throw new IllegalStateException("Service is not running: " + String.valueOf(this));
        }
    }

    protected com.tangosol.coherence.component.util.CacheHandler cloneCacheHandler(com.tangosol.coherence.component.util.CacheHandler handler, ClassLoader loader) {
        com.tangosol.coherence.component.util.CacheHandler handlerClone = (com.tangosol.coherence.component.util.CacheHandler)this._newChild("CacheHandler");
        handlerClone.setNextHandler(handler);
        handlerClone.setClassLoader(loader);
        handlerClone.setLeaseMap(handler.getLeaseMap());
        handlerClone.setResourceMap(handler.getResourceMap());
        handlerClone.setStandardLeaseMillis(handler.getStandardLeaseMillis());
        handlerClone.setCacheIndex(handler.getCacheIndex());
        handlerClone.setCacheName(handler.getCacheName());
        return handlerClone;
    }

    @Override
    protected DefaultServiceDependencies cloneDependencies(ServiceDependencies deps) {
        return new DefaultReplicatedCacheDependencies((ReplicatedCacheDependencies)deps);
    }

    @Override
    public synchronized void configure(XmlElement xml) {
        this.setServiceConfig(xml);
        this.setDependencies(LegacyXmlReplicatedCacheHelper.fromXml(xml, new DefaultReplicatedCacheDependencies(), this.getOperationalContext(), this.getContextClassLoader()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyCache(NamedCache map) {
        block7: {
            ReplicatedCache._assert(map instanceof com.tangosol.coherence.component.util.CacheHandler, "Invalid map");
            com.tangosol.coherence.component.util.CacheHandler handler = (com.tangosol.coherence.component.util.CacheHandler)map;
            com.tangosol.coherence.component.util.CacheHandler hCatalog = this.getCacheHandler(0);
            if (handler == hCatalog) {
                return;
            }
            if (this.getThread() == Thread.currentThread()) {
                while (true) {
                    handler.invalidate();
                    com.tangosol.coherence.component.util.CacheHandler hNext = handler.getNextHandler();
                    if (hNext != null) {
                        handler.setNextHandler(null);
                        handler = hNext;
                        continue;
                    }
                    break block7;
                    break;
                }
            }
            String sCacheName = handler.getCacheName();
            String sCatalogName = hCatalog.getCacheName();
            ReplicatedCache._assert(sCacheName != null && !sCacheName.equals(sCatalogName));
            this.lockResource(hCatalog, sCatalogName, 0L, -1L);
            try {
                this.removeResource(hCatalog, sCacheName, false);
            }
            finally {
                this.unlockResource(hCatalog, sCatalogName);
            }
        }
    }

    @Override
    public long drainOverflow(MemberSet setMembers, long cMillis) throws InterruptedException {
        return setMembers != null && setMembers.size() == 1 && setMembers.contains(this.getThisMember()) ? super.drainOverflow(this.getOthersMemberSet(), cMillis) : super.drainOverflow(setMembers, cMillis);
    }

    /*
     * Exception decompiling
     */
    @Override
    public NamedCache ensureCache(String sName, ClassLoader loader) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 15[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.tangosol.coherence.component.util.CacheHandler ensureCacheHandler(int iCache) {
        com.tangosol.coherence.component.util.CacheHandler handler = this.getCacheHandler(iCache);
        if (handler == null) {
            com.tangosol.coherence.component.util.CacheHandler hCatalog = this.getCacheHandler(0);
            ReplicatedCache._assert(hCatalog != null, "Catalog is missing");
            com.tangosol.coherence.component.util.CacheHandler cacheHandler = hCatalog;
            synchronized (cacheHandler) {
                handler = this.getCacheHandler(iCache);
                if (handler == null) {
                    handler = this.instantiateCacheHandler(iCache, null, this.getContextClassLoader());
                    this.setCacheHandler(iCache, handler);
                }
            }
        }
        return handler;
    }

    protected void evaluateLockRequests() {
        long lTime = this.getClusterTime();
        long lNext = Long.MAX_VALUE;
        this.setLockingNextMillis(lNext);
        List listPending = this.getLockRequestQueue();
        int cPending = listPending.size();
        if (cPending > 0) {
            ArrayList<LeaseLockRequest> listRetry = new ArrayList<LeaseLockRequest>(cPending);
            Iterator iter = listPending.iterator();
            block5: while (iter.hasNext()) {
                LeaseLockRequest msgLockRequest = (LeaseLockRequest)iter.next();
                Member member = msgLockRequest.getFromMember();
                if (!this.getServiceMemberSet().contains(member)) {
                    iter.remove();
                    continue;
                }
                long lTimeout = msgLockRequest.getWaitTimeout();
                if (lTimeout <= lTime) {
                    iter.remove();
                    listRetry.add(msgLockRequest);
                    continue;
                }
                Lease leaseRequest = msgLockRequest.getLease();
                Object oKey = leaseRequest.getResourceKey();
                int iCache = leaseRequest.getCacheIndex();
                Lease leaseCurrent = this.ensureCacheHandler(iCache).ensureLease(oKey);
                leaseCurrent.validate();
                switch (leaseCurrent.getStatus()) {
                    case 3: {
                        lTimeout = Math.min(lTimeout, leaseCurrent.getExpirationTime());
                        break;
                    }
                    default: {
                        iter.remove();
                        listRetry.add(msgLockRequest);
                        continue block5;
                    }
                }
                if (lTimeout == Long.MAX_VALUE) continue;
                lNext = Math.min(lNext, lTimeout);
            }
            for (LeaseLockRequest msgLockRequest : listRetry) {
                try {
                    this.onLeaseLockRequest(msgLockRequest);
                }
                catch (EventDeathException eventDeathException) {}
            }
        }
        if (lNext != Long.MAX_VALUE) {
            this.scheduleLockEvaluation(lNext - lTime);
        }
    }

    protected void firePendingLocks(Lease lease) {
        ArrayList<LeaseLockRequest> listRetry = null;
        List listPending = this.getLockRequestQueue();
        int cPending = listPending.size();
        if (cPending > 0) {
            listRetry = new ArrayList<LeaseLockRequest>(cPending);
            Iterator iter = listPending.iterator();
            while (iter.hasNext()) {
                LeaseLockRequest msgLockRequest = (LeaseLockRequest)iter.next();
                Lease leaseRequest = msgLockRequest.getLease();
                int iCache = leaseRequest.getCacheIndex();
                Object oKey = leaseRequest.getResourceKey();
                if (iCache != lease.getCacheIndex() || !Base.equals(oKey, lease.getResourceKey())) continue;
                iter.remove();
                leaseRequest.copyVersion(lease);
                listRetry.add(msgLockRequest);
            }
        }
        if (listRetry != null && !listRetry.isEmpty()) {
            for (LeaseLockRequest msgLockRequest : listRetry) {
                try {
                    this.onLeaseLockRequest(msgLockRequest);
                }
                catch (EventDeathException eventDeathException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackingMapContext getBackingMapContext() {
        BackingMapContext context = this.__m_BackingMapContext;
        if (context == null) {
            ReplicatedCache replicatedCache = this;
            synchronized (replicatedCache) {
                context = this.__m_BackingMapContext;
                if (context == null) {
                    context = (BackingMapContext)this._newChild("BackingMapContext");
                    this.setBackingMapContext(context);
                }
            }
        }
        return context;
    }

    @Override
    public BackingMapManager getBackingMapManager() {
        return this.__m_BackingMapManager;
    }

    protected com.tangosol.coherence.component.util.CacheHandler[] getCacheHandler() {
        return this.__m_CacheHandler;
    }

    public com.tangosol.coherence.component.util.CacheHandler getCacheHandler(int iCache) {
        com.tangosol.coherence.component.util.CacheHandler[] aHandler = this.getCacheHandler();
        int cHandlers = aHandler == null ? 0 : aHandler.length;
        return iCache >= cHandlers ? null : aHandler[iCache];
    }

    @Override
    public Enumeration getCacheNames() {
        this.checkStatus();
        com.tangosol.coherence.component.util.CacheHandler[] aHandler = this.getCacheHandler();
        int cHandlers = aHandler.length;
        Object[] aName = new String[cHandlers];
        for (int i = 1; i < cHandlers; ++i) {
            com.tangosol.coherence.component.util.CacheHandler handler = aHandler[i];
            if (handler == null || !handler.isValid()) continue;
            aName[i] = handler.getCacheName();
        }
        return new FilterEnumerator(aName, (Filter)NullFilter.getInstance());
    }

    public long getLockingNextMillis() {
        return this.__m_LockingNextMillis;
    }

    public List getLockRequestQueue() {
        return this.__m_LockRequestQueue;
    }

    public ReplicatedCacheDependencies getReplicatedCacheDependencies() {
        return (ReplicatedCacheDependencies)this.getDependencies();
    }

    public int getThreadStatus(Lease lease) {
        lease.validate();
        int nStatus = lease.getStatus();
        if (this.getReplicatedCacheDependencies().getLeaseGranularity() == 1) {
            return nStatus;
        }
        return nStatus == 3 && Lease.getCurrentThreadId() != lease.getHolderThreadId() ? 4 : nStatus;
    }

    public MemberSet getUpdatingMemberSet() {
        return this.__m_UpdatingMemberSet;
    }

    @Override
    public long getWaitMillis() {
        long cWait1 = super.getWaitMillis();
        long cWait2 = Math.max(1L, this.getLockingNextMillis() - Base.getSafeTimeMillis());
        return cWait1 <= 0L ? cWait2 : Math.min(cWait1, cWait2);
    }

    protected com.tangosol.coherence.component.util.CacheHandler instantiateCacheHandler(int iCache, String sName, ClassLoader loader) {
        com.tangosol.coherence.component.util.CacheHandler handler = (com.tangosol.coherence.component.util.CacheHandler)this._newChild("CacheHandler");
        if (iCache == -1) {
            com.tangosol.coherence.component.util.CacheHandler[] aHandler = this.getCacheHandler();
            int c = aHandler.length;
            for (iCache = 1; iCache < c && aHandler[iCache] != null; ++iCache) {
            }
        }
        handler.setCacheIndex(iCache);
        handler.setCacheName(sName);
        handler.setClassLoader(loader);
        return handler;
    }

    public com.tangosol.util.Converter instantiateConverterFromInternal(ClassLoader loader) {
        ConverterFromInternal conv = (ConverterFromInternal)this._newChild("ConverterFromInternal");
        conv.setSerializer(this.ensureSerializer(loader));
        return conv;
    }

    public com.tangosol.util.Converter instantiateConverterToInternal(ClassLoader loader) {
        ConverterToInternal conv = (ConverterToInternal)this._newChild("ConverterToInternal");
        conv.setSerializer(this.ensureSerializer(loader));
        return conv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean lockCache(com.tangosol.coherence.component.util.CacheHandler handler, long cLeaseMillis, long cWaitMillis) {
        String sCacheName;
        com.tangosol.coherence.component.util.CacheHandler hCatalog = this.getCacheHandler(0);
        if (this.lockResource(hCatalog, sCacheName = handler.getCacheName(), 0L, cWaitMillis)) {
            boolean fDirty = false;
            try {
                Enumeration e = handler.getLeaseKeys();
                while (e.hasMoreElements()) {
                    Object oKey = e.nextElement();
                    Lease lease = handler.getLease(oKey);
                    if (lease == null) continue;
                    while ((fDirty = this.getThreadStatus(lease) == 4) && cWaitMillis != 0L) {
                        cWaitMillis = this.waitForUnlock(lease, cWaitMillis);
                    }
                    if (!fDirty) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                if (fDirty) {
                    this.unlockResource(hCatalog, sCacheName);
                }
            }
            return true;
        }
        return false;
    }

    public boolean lockResource(com.tangosol.coherence.component.util.CacheHandler handler, Object oKey, long cLeaseMillis, long cWaitMillis) {
        if (oKey == ConcurrentMap.LOCK_ALL) {
            return this.lockCache(handler, cLeaseMillis, cWaitMillis);
        }
        com.tangosol.coherence.component.util.CacheHandler hCatalog = this.getCacheHandler(0);
        String sCacheName = handler.getCacheName();
        long lWaitTimeout = this.adjustWaitTime(cWaitMillis, -2L);
        block6: while (true) {
            Lease leaseCache;
            if ((leaseCache = hCatalog.getLease(sCacheName)) != null && this.getThreadStatus(leaseCache) == 4) {
                if (cWaitMillis == 0L) {
                    return false;
                }
                cWaitMillis = this.waitForUnlock(leaseCache, cWaitMillis);
                continue;
            }
            Lease lease = handler.ensureLease(oKey);
            switch (this.getThreadStatus(lease)) {
                case 1: {
                    this.requestIssue(lease);
                    break;
                }
                case 2: {
                    Member memberIssuer = this.getServiceMemberSet().getMember(lease.getIssuerId());
                    if (memberIssuer == null) continue block6;
                    if (!this.requestLock(lease, memberIssuer, cLeaseMillis, cWaitMillis, false)) continue block6;
                    return true;
                }
                case 3: {
                    Member memberIssuer = this.getServiceMemberSet().getMember(lease.getIssuerId());
                    if (memberIssuer == null) {
                        memberIssuer = this.getThisMember();
                    }
                    if (!this.requestLock(lease, memberIssuer, cLeaseMillis, cWaitMillis, true)) continue block6;
                    return true;
                }
                case 4: {
                    if (Base.getSafeTimeMillis() >= lWaitTimeout) {
                        return false;
                    }
                    Member memberIssuer = this.getServiceMemberSet().getMember(lease.getIssuerId());
                    if (memberIssuer == null && (memberIssuer = this.getServiceMemberSet().getMember(lease.getHolderId())) == null) continue block6;
                    if (!this.requestLock(lease, memberIssuer, cLeaseMillis, cWaitMillis, false)) continue block6;
                    return true;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    protected void notifyLease(Lease lease, LeaseRequest msgRequest, LeaseMessage msgResponse) {
        if (msgResponse == null) {
            msgResponse = (LeaseIssue)this.instantiateMessage("LeaseIssue");
        }
        msgResponse.respondTo(msgRequest);
        msgResponse.setLease(lease);
        this.post(msgResponse);
    }

    public void onCacheUpdateRequest(RequestMessage msgRequest) {
        com.tangosol.coherence.component.util.CacheHandler[] aHandler = this.getCacheHandler();
        int cHandlers = aHandler.length;
        MemberSet setTo = SingleMemberSet.instantiate(msgRequest.getFromMember());
        Message msg = null;
        int cbSize = 102400;
        for (int i = 0; i < cHandlers; ++i) {
            com.tangosol.coherence.component.util.CacheHandler handler = aHandler[i];
            if (handler == null || !handler.isValid()) continue;
            Enumeration enumMore = null;
            do {
                if (msg != null && ((CacheMessage)msg).getLeaseCount() > 0) {
                    this.send(msg);
                    Thread.yield();
                }
                msg = (CacheUpdate)this.instantiateMessage("CacheUpdate");
                msg.setToMemberSet(setTo);
                ((CacheMessage)msg).setCacheIndex(i);
            } while ((enumMore = handler.populateUpdateMessage((CacheMessage)msg, cbSize, enumMore)) != null);
        }
        ReplicatedCache._assert(msg != null);
        msg.respondTo(msgRequest);
        this.post(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCatalogRemove(XmlElement xml) {
        com.tangosol.coherence.component.util.CacheHandler hCatalog;
        com.tangosol.coherence.component.util.CacheHandler cacheHandler = hCatalog = this.getCacheHandler(0);
        synchronized (cacheHandler) {
            int iCache = xml.getElement("CacheIndex").getInt();
            ReplicatedCache._assert(iCache > 0, "Attempt to remove the catalog");
            com.tangosol.coherence.component.util.CacheHandler handler = this.getCacheHandler(iCache);
            if (handler != null) {
                this.destroyCache(handler);
            }
            hCatalog.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCatalogUpdate(XmlElement xml) {
        com.tangosol.coherence.component.util.CacheHandler hCatalog;
        com.tangosol.coherence.component.util.CacheHandler cacheHandler = hCatalog = this.getCacheHandler(0);
        synchronized (cacheHandler) {
            int iCache = xml.getElement("CacheIndex").getInt();
            String sName = xml.getElement("CacheName").getString();
            com.tangosol.coherence.component.util.CacheHandler handler = this.getCacheHandler(iCache);
            if (handler == null || !handler.isValid()) {
                handler = this.instantiateCacheHandler(iCache, sName, null);
                this.setCacheHandler(iCache, handler);
            }
            handler.fromXml(xml);
            hCatalog.notifyAll();
        }
    }

    @Override
    protected void onDependencies(ServiceDependencies deps) {
        super.onDependencies(deps);
    }

    @Override
    protected void onExit() {
        super.onExit();
        com.tangosol.coherence.component.util.CacheHandler[] aHandler = this.getCacheHandler();
        if (aHandler != null) {
            for (int i = aHandler.length - 1; i >= 0; --i) {
                com.tangosol.coherence.component.util.CacheHandler handler = aHandler[i];
                if (handler == null) continue;
                handler.invalidate();
            }
            this.setCacheHandler(new com.tangosol.coherence.component.util.CacheHandler[0]);
        }
    }

    public void onLeaseIssueRequest(LeaseIssueRequest msgRequest) {
        Lease leaseRequest = msgRequest.getLease();
        Object oKey = leaseRequest.getResourceKey();
        int iCache = leaseRequest.getCacheIndex();
        Lease leaseCurrent = this.ensureCacheHandler(iCache).ensureLease(oKey);
        leaseCurrent.validate();
        if (leaseCurrent.getStatus() == 1) {
            Member memberFrom = msgRequest.getFromMember();
            if (this.getReplicatedCacheDependencies().isMobileIssues()) {
                leaseCurrent.setIssuerId(memberFrom.getId());
            } else {
                leaseCurrent.setIssuerId(this.getThisMember().getId());
            }
            leaseCurrent.incrementLeaseVersion();
            MemberSet setOther = this.getOthersMemberSet();
            setOther.remove(memberFrom);
            if (!setOther.isEmpty()) {
                LeaseIssue msg = (LeaseIssue)this.instantiateMessage("LeaseIssue");
                msg.setToMemberSet(setOther);
                msg.setLease(leaseCurrent);
                this.post(msg);
            }
        }
        this.notifyLease(leaseCurrent, msgRequest, null);
    }

    public void onLeaseLockRequest(LeaseLockRequest msgRequest) {
        Lease leaseRequest = msgRequest.getLease();
        Object oKey = leaseRequest.getResourceKey();
        int iCache = leaseRequest.getCacheIndex();
        Lease leaseCurrent = this.ensureCacheHandler(iCache).ensureLease(oKey);
        int nThisId = this.getThisMember().getId();
        boolean fReject = false;
        leaseCurrent.validate();
        switch (leaseCurrent.getStatus()) {
            case 1: {
                leaseCurrent.setIssuerId(nThisId);
            }
            case 2: {
                if (leaseCurrent.getIssuerId() != nThisId) {
                    fReject = true;
                    break;
                }
                leaseRequest.copyVersion(leaseCurrent);
                fReject = !this.performLock(msgRequest);
                break;
            }
            case 3: 
            case 4: {
                long lVariance;
                if (leaseCurrent.getIssuerId() != nThisId) {
                    fReject = true;
                    break;
                }
                if (leaseCurrent.getHolderId() == msgRequest.getFromMember().getId() && leaseCurrent.getHolderThreadId() == leaseRequest.getHolderThreadId()) {
                    fReject = !this.performLock(msgRequest);
                    break;
                }
                long lWaitTimeout = msgRequest.getWaitTimeout();
                long lTime = this.getClusterTime();
                if (lTime + (lVariance = (long)this.getClusterTimeVariance()) < lWaitTimeout) {
                    this.getLockRequestQueue().add(msgRequest);
                    long lExpirationTime = leaseCurrent.getExpirationTime();
                    if (lWaitTimeout == Long.MAX_VALUE && lExpirationTime == Long.MAX_VALUE) break;
                    this.scheduleLockEvaluation(Math.min(lWaitTimeout - lTime, lExpirationTime - lTime));
                    break;
                }
                fReject = true;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (fReject) {
            ReplicatedCache._trace("Rejecting lock: " + String.valueOf(leaseCurrent) + "\n by member=" + msgRequest.getFromMember().getId() + ", " + String.valueOf(leaseRequest), 4);
            this.notifyLease(leaseCurrent, msgRequest, null);
        }
    }

    public void onLeaseRemoveRequest(LeaseRemoveRequest msgRequest) {
        Lease leaseRequest = msgRequest.getLease();
        Object oKey = leaseRequest.getResourceKey();
        int iCache = leaseRequest.getCacheIndex();
        Lease leaseCurrent = this.ensureCacheHandler(iCache).ensureLease(oKey);
        int nThisId = this.getThisMember().getId();
        leaseCurrent.validate();
        switch (leaseCurrent.getStatus()) {
            case 1: {
                leaseCurrent.setIssuerId(nThisId);
            }
            case 2: {
                if (leaseCurrent.getIssuerId() == nThisId && this.performRemove(msgRequest)) break;
                this.notifyLease(leaseCurrent, msgRequest, null);
                break;
            }
            case 3: 
            case 4: {
                if (leaseCurrent.getIssuerId() == nThisId && leaseCurrent.getHolderId() == msgRequest.getFromMember().getId() && this.performRemove(msgRequest)) break;
                this.notifyLease(leaseCurrent, msgRequest, null);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void onLeaseUnlockRequest(LeaseUnlockRequest msgRequest) {
        Lease leaseRequest = msgRequest.getLease();
        Object oKey = leaseRequest.getResourceKey();
        int iCache = leaseRequest.getCacheIndex();
        com.tangosol.coherence.component.util.CacheHandler handler = this.ensureCacheHandler(iCache);
        Lease leaseCurrent = handler.ensureLease(oKey);
        int nThisId = this.getThisMember().getId();
        boolean fReject = false;
        leaseCurrent.validate();
        switch (leaseCurrent.getStatus()) {
            case 1: {
                leaseCurrent.setIssuerId(nThisId);
            }
            case 2: {
                fReject = leaseCurrent.getIssuerId() != nThisId || !this.performUnlock(msgRequest);
                break;
            }
            case 3: 
            case 4: {
                if (leaseCurrent.getIssuerId() != nThisId) {
                    fReject = true;
                    break;
                }
                if (leaseCurrent.getHolderId() == msgRequest.getFromMember().getId() && leaseCurrent.getHolderThreadId() == leaseRequest.getHolderThreadId()) {
                    fReject = !this.performUnlock(msgRequest);
                    break;
                }
                List listPending = this.getLockRequestQueue();
                Iterator iter = listPending.iterator();
                while (iter.hasNext()) {
                    LeaseLockRequest msgLockRequest = (LeaseLockRequest)iter.next();
                    Lease leaseLockRequest = msgLockRequest.getLease();
                    if (leaseLockRequest.getCacheIndex() != iCache || !Base.equals(leaseLockRequest.getResourceKey(), oKey) || leaseLockRequest.getHolderId() != msgRequest.getFromMember().getId() || leaseLockRequest.getHolderThreadId() != leaseRequest.getHolderThreadId()) continue;
                    iter.remove();
                    this.notifyLease(leaseCurrent, msgLockRequest, null);
                }
                fReject = true;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (fReject) {
            ReplicatedCache._trace("Rejecting unlock: " + String.valueOf(leaseCurrent) + "\n by member=" + msgRequest.getFromMember().getId() + ", " + String.valueOf(leaseRequest), 4);
            this.notifyLease(leaseCurrent, msgRequest, null);
        }
    }

    public void onLeaseUpdateRequest(LeaseUpdateRequest msgRequest, Object oResource, Binary binResource) {
        Lease leaseRequest = msgRequest.getLease();
        Object oKey = leaseRequest.getResourceKey();
        int iCache = leaseRequest.getCacheIndex();
        Lease leaseCurrent = this.ensureCacheHandler(iCache).ensureLease(oKey);
        int nThisId = this.getThisMember().getId();
        boolean fReject = false;
        leaseCurrent.validate();
        switch (leaseCurrent.getStatus()) {
            case 1: {
                int nIssuerId = leaseRequest.getIssuerId();
                leaseCurrent.setIssuerId(nIssuerId == 0 ? nThisId : nIssuerId);
            }
            case 2: {
                fReject = leaseCurrent.getIssuerId() != nThisId || !this.performUpdate(msgRequest, oResource, binResource);
                break;
            }
            case 3: 
            case 4: {
                fReject = leaseCurrent.getIssuerId() != nThisId || leaseCurrent.getHolderId() != msgRequest.getFromMember().getId() || !this.performUpdate(msgRequest, oResource, binResource);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (fReject) {
            ReplicatedCache._trace("Rejecting update: " + String.valueOf(leaseCurrent) + "\n by member=" + msgRequest.getFromMember().getId() + ", " + String.valueOf(leaseRequest), 4);
            this.notifyLease(leaseCurrent, msgRequest, null);
        }
    }

    @Override
    protected void onNotify() {
        super.onNotify();
        if (this.isRunning() && Base.getSafeTimeMillis() >= this.getLockingNextMillis()) {
            this.evaluateLockRequests();
        }
    }

    @Override
    public void onNotifyServiceLeft(Member member) {
        super.onNotifyServiceLeft(member);
        for (com.tangosol.coherence.component.util.CacheHandler handler : this.getCacheHandler()) {
            if (handler == null || !handler.isValid()) continue;
            handler.onFarewell(member);
        }
        this.evaluateLockRequests();
    }

    @Override
    public void onServiceStarted() {
        BackingMapManager manager = this.getBackingMapManager();
        if (manager != null) {
            BackingMapContext ctx = this.getBackingMapContext();
            ctx.setManager(manager);
            manager.init(ctx);
        }
        this.setAcceptingOthers(true);
        this.notifyServiceJoined();
        this.requestCacheUpdate();
    }

    protected boolean performLock(LeaseLockRequest msgRequest) {
        Lease lease = msgRequest.getLease();
        long cLeaseMillis = msgRequest.getLeaseMillis();
        lease.incrementLeaseVersion();
        lease.setExpirationTime(this.adjustWaitTime(cLeaseMillis - 1L, -3L));
        try {
            this.ensureCacheHandler(lease.getCacheIndex()).onLeaseUpdate(lease, false, null, 0L);
        }
        catch (EventDeathException e) {
            return false;
        }
        MemberSet setOther = this.getOthersMemberSet();
        setOther.remove(msgRequest.getFromMember());
        if (!setOther.isEmpty()) {
            LeaseLock msg = (LeaseLock)this.instantiateMessage("LeaseLock");
            msg.setToMemberSet(setOther);
            msg.setLease(lease);
            this.post(msg);
        }
        this.notifyLease(lease, msgRequest, (LeaseLock)this.instantiateMessage("LeaseLock"));
        return true;
    }

    protected boolean performRemove(LeaseRemoveRequest msgRequest) {
        Lease lease = msgRequest.getLease();
        lease.incrementResourceVersion();
        try {
            this.ensureCacheHandler(lease.getCacheIndex()).onLeaseRemove(lease);
        }
        catch (EventDeathException e) {
            return false;
        }
        MemberSet setOther = this.getOthersMemberSet();
        setOther.remove(msgRequest.getFromMember());
        if (!setOther.isEmpty()) {
            LeaseRemove msg = (LeaseRemove)this.instantiateMessage("LeaseRemove");
            msg.setToMemberSet(setOther);
            msg.setLease(lease);
            this.post(msg);
        }
        this.notifyLease(lease, msgRequest, (LeaseRemove)this.instantiateMessage("LeaseRemove"));
        return true;
    }

    protected boolean performUnlock(LeaseUnlockRequest msgRequest) {
        Lease lease = msgRequest.getLease();
        lease.unlock();
        lease.incrementLeaseVersion();
        try {
            this.ensureCacheHandler(lease.getCacheIndex()).onLeaseUpdate(lease, false, null, 0L);
        }
        catch (EventDeathException e) {
            return false;
        }
        MemberSet setOther = this.getOthersMemberSet();
        setOther.remove(msgRequest.getFromMember());
        if (!setOther.isEmpty()) {
            LeaseUnlock msg = (LeaseUnlock)this.instantiateMessage("LeaseUnlock");
            msg.setToMemberSet(setOther);
            msg.setLease(lease);
            this.post(msg);
        }
        this.notifyLease(lease, msgRequest, (LeaseUnlock)this.instantiateMessage("LeaseUnlock"));
        this.firePendingLocks(lease);
        return true;
    }

    protected boolean performUpdate(LeaseUpdateRequest msgRequest, Object oResource, Binary binResource) {
        Lease lease = msgRequest.getLease();
        long cExpiry = msgRequest.getResourceExpiry();
        lease.incrementResourceVersion();
        try {
            this.ensureCacheHandler(lease.getCacheIndex()).onLeaseUpdate(lease, true, oResource, cExpiry);
        }
        catch (EventDeathException e) {
            return false;
        }
        MemberSet setOther = this.getOthersMemberSet();
        setOther.remove(msgRequest.getFromMember());
        if (!setOther.isEmpty()) {
            LeaseUpdate msg = (LeaseUpdate)this.instantiateMessage("LeaseUpdate");
            msg.setToMemberSet(setOther);
            msg.setLease(lease);
            msg.setResource(oResource);
            msg.setResourceBinary(binResource);
            msg.setResourceExpiry(cExpiry);
            this.post(msg);
        }
        LeaseUpdate msgResponse = (LeaseUpdate)this.instantiateMessage("LeaseUpdate");
        msgResponse.setResource(oResource);
        msgResponse.setResourceBinary(binResource);
        msgResponse.setResourceExpiry(cExpiry);
        this.notifyLease(lease, msgRequest, msgResponse);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseCache(NamedCache map) {
        com.tangosol.coherence.component.util.CacheHandler hCatalog;
        ReplicatedCache._assert(map instanceof com.tangosol.coherence.component.util.CacheHandler, "Invalid map");
        CacheHandler handler = (CacheHandler)map;
        com.tangosol.coherence.component.util.CacheHandler cacheHandler = hCatalog = this.getCacheHandler(0);
        synchronized (cacheHandler) {
            int iCache = handler.getCacheIndex();
            com.tangosol.coherence.component.util.CacheHandler[] aHandler = this.getCacheHandler();
            com.tangosol.coherence.component.util.CacheHandler hPrev = null;
            for (com.tangosol.coherence.component.util.CacheHandler hNext = aHandler[iCache]; hNext != null; hNext = hNext.getNextHandler()) {
                if (hNext == handler) {
                    hNext = hNext.getNextHandler();
                    if (hPrev == null) {
                        if (hNext != null) {
                            aHandler[iCache] = hNext;
                        }
                    } else {
                        hPrev.setNextHandler(hNext);
                    }
                    handler.releaseIndexMap();
                    handler.releaseClassLoader();
                    return;
                }
                hPrev = hNext;
            }
        }
    }

    public Object removeResource(com.tangosol.coherence.component.util.CacheHandler handler, Object oKey, boolean fReturn) throws ConcurrentModificationException {
        com.tangosol.coherence.component.util.CacheHandler hCatalog = this.getCacheHandler(0);
        String sCacheName = handler.getCacheName();
        block6: while (true) {
            Lease leaseCache;
            if ((leaseCache = hCatalog.getLease(sCacheName)) != null && this.getThreadStatus(leaseCache) == 4) {
                throw new ConcurrentModificationException("Cache \"" + sCacheName + "\" is locked by another thread or member: " + String.valueOf(leaseCache));
            }
            Lease lease = handler.ensureLease(oKey);
            switch (this.getThreadStatus(lease)) {
                case 1: {
                    this.requestIssue(lease);
                    break;
                }
                case 2: {
                    Object oValue;
                    Member memberIssuer = this.getServiceMemberSet().getMember(lease.getIssuerId());
                    if (memberIssuer == null) continue block6;
                    Object object = oValue = fReturn ? handler.getCachedResource(oKey) : null;
                    if (!this.requestRemove(lease, memberIssuer)) continue block6;
                    return oValue;
                }
                case 3: {
                    Object oValue;
                    Member memberIssuer = this.getServiceMemberSet().getMember(lease.getIssuerId());
                    if (memberIssuer == null) {
                        memberIssuer = this.getThisMember();
                    }
                    Object object = oValue = fReturn ? handler.getCachedResource(oKey) : null;
                    if (!this.requestRemove(lease, memberIssuer)) continue block6;
                    return oValue;
                }
                case 4: {
                    throw new ConcurrentModificationException("Cache \"" + sCacheName + "\": Resource is locked by another thread or member: " + String.valueOf(lease));
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public void requestCacheUpdate() {
        MemberSet setOther = this.getOthersMemberSet(2);
        if (setOther.isEmpty()) {
            this.setAcceptingClients(true);
        } else {
            DependentMemberSet setUpdating = new DependentMemberSet();
            setUpdating.setBaseSet(setOther);
            this.setUpdatingMemberSet(setUpdating);
            CacheUpdateRequest msg = (CacheUpdateRequest)this.instantiateMessage("CacheUpdateRequest");
            msg.setToMemberSet(setOther);
            this.post(msg);
        }
    }

    protected boolean requestIssue(Lease lease) {
        this.checkStatus();
        LeaseIssueRequest msg = (LeaseIssueRequest)this.instantiateMessage("LeaseIssueRequest");
        msg.addToMember(this.getServiceOldestMember());
        msg.setLease(lease);
        this.poll(msg);
        return msg.getRequestPoll().getLeftMemberSet().isEmpty();
    }

    protected boolean requestLock(Lease lease, Member memberIssuer, long cLeaseMillis, long cWaitMillis, boolean fRenew) {
        this.checkStatus();
        long lCurrentTime = this.getClusterTime();
        long lExpirationTime = this.adjustWaitTime(cLeaseMillis - 1L, lCurrentTime);
        if (fRenew && lExpirationTime <= lease.getExpirationTime()) {
            return true;
        }
        LeaseLockRequest msg = (LeaseLockRequest)this.instantiateMessage("LeaseLockRequest");
        msg.setToMemberSet(SingleMemberSet.instantiate(memberIssuer));
        msg.setWaitMillis(cWaitMillis);
        msg.setLeaseMillis(cLeaseMillis);
        msg.setLease(lease);
        Lease leaseMsg = msg.getLease();
        long lThreadId = this.getReplicatedCacheDependencies().getLeaseGranularity() == 0 ? Lease.getCurrentThreadId() : 0L;
        leaseMsg.setIssuerId(memberIssuer.getId());
        leaseMsg.setHolderId(this.getThisMember().getId());
        leaseMsg.setHolderThreadId(lThreadId);
        if (!fRenew) {
            leaseMsg.setEffectiveTime(lCurrentTime);
        }
        try {
            long cTimeout = this.getRequestTimeout();
            if (cTimeout > 0L) {
                cTimeout = this.adjustWaitTime(cWaitMillis, cTimeout);
            }
            this.poll(msg, cTimeout);
            return msg.getRequestPoll().getLeftMemberSet().isEmpty() && this.getThreadStatus(lease) == 3;
        }
        catch (RuntimeException e) {
            boolean fInterrupt = Thread.interrupted();
            try {
                this.requestUnlock(leaseMsg, memberIssuer, false);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (fInterrupt) {
                Thread.currentThread().interrupt();
            }
            throw e;
        }
    }

    protected boolean requestRemove(Lease lease, Member memberIssuer) {
        this.checkStatus();
        LeaseRemoveRequest msg = (LeaseRemoveRequest)this.instantiateMessage("LeaseRemoveRequest");
        msg.setToMemberSet(SingleMemberSet.instantiate(memberIssuer));
        msg.setLease(lease);
        this.poll(msg);
        return msg.getRequestPoll().getLeftMemberSet().isEmpty();
    }

    protected boolean requestUnlock(Lease lease, Member memberIssuer, boolean fWait) {
        this.checkStatus();
        LeaseUnlockRequest msg = (LeaseUnlockRequest)this.instantiateMessage("LeaseUnlockRequest");
        msg.setToMemberSet(SingleMemberSet.instantiate(memberIssuer));
        msg.setLease(lease);
        Lease leaseMsg = msg.getLease();
        long lThreadId = this.getReplicatedCacheDependencies().getLeaseGranularity() == 0 ? Lease.getCurrentThreadId() : 0L;
        leaseMsg.setIssuerId(memberIssuer.getId());
        leaseMsg.setHolderId(this.getThisMember().getId());
        leaseMsg.setHolderThreadId(lThreadId);
        if (fWait) {
            this.poll(msg);
        } else {
            this.send(msg);
        }
        return msg.getRequestPoll().getLeftMemberSet().isEmpty();
    }

    protected boolean requestUpdate(Lease lease, Member memberIssuer, Object oResource, long lResourceExpiry, boolean fResetEffective, boolean fResetExpire) {
        this.checkStatus();
        LeaseUpdateRequest msg = (LeaseUpdateRequest)this.instantiateMessage("LeaseUpdateRequest");
        msg.setToMemberSet(SingleMemberSet.instantiate(memberIssuer));
        msg.setLease(lease);
        msg.setResource(oResource);
        msg.setResourceExpiry(lResourceExpiry);
        if (this.getServiceMemberSet().size() > 1) {
            msg.setResourceBinary(oResource instanceof Binary ? (Binary)oResource : ExternalizableHelper.toBinary(oResource, this.ensureSerializer()));
        }
        Lease leaseMsg = msg.getLease();
        leaseMsg.setIssuerId(memberIssuer.getId());
        if (fResetEffective) {
            leaseMsg.setEffectiveTime(this.getClusterTime());
        }
        if (fResetExpire) {
            leaseMsg.setExpirationTime(this.getClusterTime());
        }
        this.poll(msg);
        return msg.getRequestPoll().getLeftMemberSet().isEmpty();
    }

    protected synchronized void scheduleLockEvaluation(long cMillis) {
        long lNext = cMillis == Long.MAX_VALUE ? cMillis : Base.getSafeTimeMillis() + cMillis;
        this.setLockingNextMillis(Math.min(this.getLockingNextMillis(), lNext));
    }

    @Override
    public void setAcceptingClients(boolean fAccepting) {
        this.setUpdatingMemberSet(fAccepting ? this.getServiceMemberSet() : (MemberSet)EmptyMemberSet.get_Instance());
        super.setAcceptingClients(fAccepting);
    }

    protected void setBackingMapContext(BackingMapContext ctx) {
        this.__m_BackingMapContext = ctx;
    }

    @Override
    public synchronized void setBackingMapManager(BackingMapManager manager) {
        if (this.isRunning()) {
            throw new IllegalStateException("Service is already running");
        }
        this.__m_BackingMapManager = manager;
    }

    protected void setCacheHandler(com.tangosol.coherence.component.util.CacheHandler[] aHandler) {
        this.__m_CacheHandler = aHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCacheHandler(int iCache, com.tangosol.coherence.component.util.CacheHandler handler) {
        com.tangosol.coherence.component.util.CacheHandler hCatalog;
        com.tangosol.coherence.component.util.CacheHandler cacheHandler = hCatalog = this.getCacheHandler(0);
        synchronized (cacheHandler) {
            boolean fBeyondBounds;
            com.tangosol.coherence.component.util.CacheHandler[] aHandler = this.getCacheHandler();
            boolean bl = fBeyondBounds = aHandler == null || iCache >= aHandler.length;
            if (handler != null && fBeyondBounds) {
                com.tangosol.coherence.component.util.CacheHandler[] aHandlerNew = new com.tangosol.coherence.component.util.CacheHandler[iCache + 2];
                if (aHandler != null) {
                    System.arraycopy(aHandler, 0, aHandlerNew, 0, aHandler.length);
                }
                aHandler = aHandlerNew;
                this.setCacheHandler(aHandler);
                fBeyondBounds = false;
            }
            if (!fBeyondBounds) {
                aHandler[iCache] = handler;
            }
        }
    }

    public void setLockingNextMillis(long ltMillis) {
        this.__m_LockingNextMillis = ltMillis;
    }

    protected void setLockRequestQueue(List list) {
        this.__m_LockRequestQueue = list;
    }

    public void setUpdatingMemberSet(MemberSet setMember) {
        this.__m_UpdatingMemberSet = setMember;
    }

    @Override
    public synchronized void start() {
        com.tangosol.coherence.component.util.CacheHandler[] aHandler = new com.tangosol.coherence.component.util.CacheHandler[2];
        com.tangosol.coherence.component.util.CacheHandler hCatalog = (com.tangosol.coherence.component.util.CacheHandler)this._findChild("CatalogHandler");
        ClassLoader loader = this.getContextClassLoader();
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = this.getClass().getClassLoader();
                ReplicatedCache._assert(loader != null, "ContextClassLoader is missing");
            }
            this.setContextClassLoader(loader);
        }
        hCatalog.setClassLoader(loader);
        aHandler[0] = hCatalog;
        this.setCacheHandler(aHandler);
        this.setUpdatingMemberSet((MemberSet)EmptyMemberSet.get_Instance());
        super.start();
    }

    public boolean unlockResource(com.tangosol.coherence.component.util.CacheHandler handler, Object oKey) {
        if (oKey == ConcurrentMap.LOCK_ALL) {
            com.tangosol.coherence.component.util.CacheHandler hCatalog = this.getCacheHandler(0);
            String sCacheName = handler.getCacheName();
            return this.unlockResource(hCatalog, sCacheName);
        }
        boolean fWasLocked = false;
        block5: while (true) {
            Lease lease;
            if ((lease = handler.getLease(oKey)) == null) {
                return true;
            }
            switch (this.getThreadStatus(lease)) {
                case 0: 
                case 1: 
                case 2: {
                    return true;
                }
                case 3: {
                    Member memberIssuer = this.getServiceMemberSet().getMember(lease.getIssuerId());
                    if (memberIssuer == null) {
                        memberIssuer = this.getThisMember();
                    }
                    if (this.requestUnlock(lease, memberIssuer, true)) {
                        return true;
                    }
                    fWasLocked = true;
                    continue block5;
                }
                case 4: {
                    return fWasLocked;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    public Object updateResource(com.tangosol.coherence.component.util.CacheHandler handler, Object oKey, Object oValue, long cExpireMillis, boolean fFinal, boolean fReturn) throws ConcurrentModificationException {
        com.tangosol.coherence.component.util.CacheHandler hCatalog = this.getCacheHandler(0);
        String sCacheName = handler.getCacheName();
        block6: while (true) {
            Lease leaseCache;
            if ((leaseCache = hCatalog.getLease(sCacheName)) != null && this.getThreadStatus(leaseCache) == 4) {
                throw new ConcurrentModificationException("Cache \"" + sCacheName + "\" is locked by another thread or member: " + String.valueOf(leaseCache));
            }
            Lease lease = handler.ensureLease(oKey);
            switch (this.getThreadStatus(lease)) {
                case 1: {
                    Member memberIssuer;
                    if (this.getReplicatedCacheDependencies().isMobileIssues()) {
                        memberIssuer = this.getThisMember();
                        if (!this.requestUpdate(lease, memberIssuer, oValue, cExpireMillis, true, false)) continue block6;
                        return null;
                    }
                    this.requestIssue(lease);
                    break;
                }
                case 2: {
                    Object oValueOld;
                    Member memberIssuer = this.getServiceMemberSet().getMember(lease.getIssuerId());
                    if (memberIssuer == null) continue block6;
                    Object object = oValueOld = fReturn ? handler.getCachedResource(oKey) : null;
                    if (!this.requestUpdate(lease, memberIssuer, oValue, cExpireMillis, true, false)) continue block6;
                    return oValueOld;
                }
                case 3: {
                    Object oValueOld;
                    Member memberIssuer = this.getServiceMemberSet().getMember(lease.getIssuerId());
                    if (memberIssuer == null) {
                        memberIssuer = this.getThisMember();
                    }
                    Object object = oValueOld = fReturn ? handler.getCachedResource(oKey) : null;
                    if (!this.requestUpdate(lease, memberIssuer, oValue, cExpireMillis, false, fFinal)) continue block6;
                    return oValueOld;
                }
                case 4: {
                    throw new ConcurrentModificationException("Cache \"" + sCacheName + "\": Resource is locked by another thread or member: " + String.valueOf(lease));
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long waitForUnlock(Lease lease, long cWaitMillis) {
        this.checkStatus();
        long lTime = Base.getSafeTimeMillis();
        Lease lease2 = lease;
        synchronized (lease2) {
            try {
                lease.wait(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Base.ensureRuntimeException(e);
            }
        }
        if (cWaitMillis > 0L) {
            cWaitMillis -= Base.getSafeTimeMillis() - lTime;
            cWaitMillis = Math.max(0L, cWaitMillis);
        }
        return cWaitMillis;
    }

    static {
        ReplicatedCache.__initStatic();
    }

    public static class BackingMapContext
    extends BackingMapManagerContext {
        private transient com.tangosol.util.Converter __m_ConverterFromInternal;
        private transient com.tangosol.util.Converter __m_ConverterToInternal;

        public BackingMapContext() {
            this(null, null, true);
        }

        public BackingMapContext(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new BackingMapContext();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$BackingMapContext".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected com.tangosol.util.Converter getConverterFromInternal() {
            com.tangosol.util.Converter conv = this.__m_ConverterFromInternal;
            if (conv == null) {
                BackingMapContext backingMapContext = this;
                synchronized (backingMapContext) {
                    conv = this.__m_ConverterFromInternal;
                    if (conv == null) {
                        conv = this.getService().instantiateConverterFromInternal(this.getClassLoader());
                        this.setConverterFromInternal(conv);
                    }
                }
            }
            return conv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected com.tangosol.util.Converter getConverterToInternal() {
            com.tangosol.util.Converter conv = this.__m_ConverterToInternal;
            if (conv == null) {
                BackingMapContext backingMapContext = this;
                synchronized (backingMapContext) {
                    conv = this.__m_ConverterToInternal;
                    if (conv == null) {
                        conv = this.getService().instantiateConverterToInternal(this.getClassLoader());
                        this.setConverterToInternal(conv);
                    }
                }
            }
            return conv;
        }

        public ReplicatedCache getService() {
            return (ReplicatedCache)this.get_Module();
        }

        @Override
        public com.tangosol.util.Converter getValueFromInternalConverter() {
            return this.getConverterFromInternal();
        }

        @Override
        public com.tangosol.util.Converter getValueToInternalConverter() {
            return this.getConverterToInternal();
        }

        @Override
        public void onInit() {
            this.setConfigKey(64);
            super.onInit();
        }

        @Override
        public synchronized void setClassLoader(ClassLoader loader) {
            if (loader != this.getClassLoader()) {
                super.setClassLoader(loader);
                this.setConverterFromInternal(null);
            }
        }

        protected void setConverterFromInternal(com.tangosol.util.Converter conv) {
            this.__m_ConverterFromInternal = conv;
        }

        protected void setConverterToInternal(com.tangosol.util.Converter pConverterToInternal) {
            this.__m_ConverterToInternal = pConverterToInternal;
        }
    }

    public static class CacheHandler
    extends com.tangosol.coherence.component.util.CacheHandler {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("BackingMapListener", BackingMapListener.get_CLASS());
            __mapChildren.put("EntrySet", EntrySet.get_CLASS());
            __mapChildren.put("KeySet", KeySet.get_CLASS());
            __mapChildren.put("Validator", Validator.get_CLASS());
        }

        public CacheHandler() {
            this(null, null, true);
        }

        public CacheHandler(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setCacheIndex(-1);
                this.setDeactivationListeners(new Listeners());
                this.setIgnoreKey(new Object());
                this.setPutExpiryWarned(false);
                this.setStandardLeaseMillis(20000L);
                this.setUseEventDaemon(true);
                this.setValid(true);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new CacheHandler();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$CacheHandler".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public com.tangosol.util.Converter getConverterFromInternal() {
            return super.getConverterFromInternal();
        }

        static {
            CacheHandler.__initStatic();
        }

        public static class BackingMapListener
        extends CacheHandler.BackingMapListener {
            public BackingMapListener() {
                this(null, null, true);
            }

            public BackingMapListener(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new BackingMapListener();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$CacheHandler$BackingMapListener".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class EntrySet
        extends CacheHandler.EntrySet {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Entry", Entry.get_CLASS());
                __mapChildren.put("Iterator", Iterator.get_CLASS());
            }

            public EntrySet() {
                this(null, null, true);
            }

            public EntrySet(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new EntrySet();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$CacheHandler$EntrySet".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                EntrySet.__initStatic();
            }

            public static class Entry
            extends CacheHandler.EntrySet.Entry {
                public Entry() {
                    this(null, null, true);
                }

                public Entry(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Entry();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$CacheHandler$EntrySet$Entry".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }

            public static class Iterator
            extends CacheHandler.EntrySet.Iterator {
                public Iterator() {
                    this(null, null, true);
                }

                public Iterator(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Iterator();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$CacheHandler$EntrySet$Iterator".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class KeySet
        extends CacheHandler.KeySet {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Iterator", Iterator.get_CLASS());
            }

            public KeySet() {
                this(null, null, true);
            }

            public KeySet(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new KeySet();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$CacheHandler$KeySet".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                KeySet.__initStatic();
            }

            public static class Iterator
            extends CacheHandler.KeySet.Iterator {
                public Iterator() {
                    this(null, null, true);
                }

                public Iterator(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Iterator();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$CacheHandler$KeySet$Iterator".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class Validator
        extends CacheHandler.Validator {
            public Validator() {
                this(null, null, true);
            }

            public Validator(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setLeaseMap(new SafeHashMap());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Validator();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$CacheHandler$Validator".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class CacheUpdate
    extends CacheMessage {
        public CacheUpdate() {
            this(null, null, true);
        }

        public CacheUpdate(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(43);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new CacheUpdate();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$CacheUpdate".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ReplicatedCache service = (ReplicatedCache)this.getService();
            service.ensureCacheHandler(this.getCacheIndex()).populateCache(this);
        }
    }

    public static class CacheUpdateRequest
    extends RequestMessage {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public CacheUpdateRequest() {
            this(null, null, true);
        }

        public CacheUpdateRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(44);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new CacheUpdateRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$CacheUpdateRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        protected com.tangosol.coherence.component.net.Poll instantiatePoll() {
            return (com.tangosol.coherence.component.net.Poll)this._newChild("Poll");
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ReplicatedCache service = (ReplicatedCache)this.getService();
            service.onCacheUpdateRequest(this);
        }

        @Override
        public void setRequestPoll(com.tangosol.coherence.component.net.Poll poll) {
            super.setRequestPoll(poll);
        }

        static {
            CacheUpdateRequest.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$CacheUpdateRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected void onCompletion() {
                ReplicatedCache service = (ReplicatedCache)this.getService();
                if (service.getServiceState() == 2) {
                    if (this.getLeftMemberSet().isEmpty()) {
                        service.setAcceptingClients(true);
                    } else {
                        service.requestCacheUpdate();
                    }
                }
                super.onCompletion();
            }

            @Override
            public void onResponded(Member member) {
                ((ReplicatedCache)this.getService()).getUpdatingMemberSet().add(member);
                super.onResponded(member);
            }
        }
    }

    public static class ConverterFromInternal
    extends Converter {
        public ConverterFromInternal() {
            this(null, null, true);
        }

        public ConverterFromInternal(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ConverterFromInternal();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$ConverterFromInternal".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public Object convert(Object o) {
            if (o instanceof Binary) {
                o = ExternalizableHelper.fromBinary((Binary)o, this.getSerializer());
            }
            return o;
        }
    }

    public static class ConverterToInternal
    extends Converter {
        public ConverterToInternal() {
            this(null, null, true);
        }

        public ConverterToInternal(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ConverterToInternal();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$ConverterToInternal".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public Object convert(Object o) {
            if (!(o instanceof Binary)) {
                o = ExternalizableHelper.toBinary(o, this.getSerializer());
            }
            return o;
        }
    }

    public static class DispatchEvent
    extends Grid.DispatchEvent {
        public DispatchEvent() {
            this(null, null, true);
        }

        public DispatchEvent(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new DispatchEvent();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$DispatchEvent".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }
    }

    public static class LeaseIssue
    extends LeaseMessage {
        public LeaseIssue() {
            this(null, null, true);
        }

        public LeaseIssue(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(33);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new LeaseIssue();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$LeaseIssue".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ReplicatedCache service = (ReplicatedCache)this.getService();
            Member memberFrom = this.getFromMember();
            Member memberThis = service.getThisMember();
            if (memberFrom != memberThis && service.getUpdatingMemberSet().contains(memberFrom)) {
                Lease lease = this.getLease();
                service.ensureCacheHandler(lease.getCacheIndex()).ensureLease(lease.getResourceKey()).copyFrom(lease);
            }
        }
    }

    public static class LeaseIssueRequest
    extends LeaseRequest {
        public LeaseIssueRequest() {
            this(null, null, true);
        }

        public LeaseIssueRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(34);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new LeaseIssueRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$LeaseIssueRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ((ReplicatedCache)this.getService()).onLeaseIssueRequest(this);
        }

        @Override
        public void setRequestPoll(Poll poll) {
            super.setRequestPoll(poll);
        }
    }

    public static class LeaseLock
    extends LeaseMessage {
        public LeaseLock() {
            this(null, null, true);
        }

        public LeaseLock(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(35);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new LeaseLock();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$LeaseLock".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ReplicatedCache service = (ReplicatedCache)this.getService();
            Member memberFrom = this.getFromMember();
            Member memberThis = service.getThisMember();
            if (memberFrom != memberThis && service.getUpdatingMemberSet().contains(memberFrom)) {
                Lease lease = this.getLease();
                service.ensureCacheHandler(lease.getCacheIndex()).ensureLease(lease.getResourceKey()).copyFrom(lease);
            }
        }
    }

    public static class LeaseLockRequest
    extends LeaseRequest {
        private long __m_LeaseMillis;
        private long __m_WaitMillis;
        private transient long __m_WaitTimeout;

        public LeaseLockRequest() {
            this(null, null, true);
        }

        public LeaseLockRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(36);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new LeaseLockRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$LeaseLockRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return super.getDescription() + "\nWaitTimeout=" + this.getWaitTimeout() + ", LeaseDuration=" + this.getLeaseMillis();
        }

        public long getLeaseMillis() {
            return this.__m_LeaseMillis;
        }

        public long getWaitMillis() {
            return this.__m_WaitMillis;
        }

        public long getWaitTimeout() {
            long ldtTimeout = this.__m_WaitTimeout;
            if (ldtTimeout == 0L) {
                ReplicatedCache service = (ReplicatedCache)this.getService();
                ldtTimeout = service.adjustWaitTime(this.getWaitMillis(), -3L);
                this.setWaitTimeout(ldtTimeout);
            }
            return ldtTimeout;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ReplicatedCache service = (ReplicatedCache)this.getService();
            service.onLeaseLockRequest(this);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setWaitMillis(ExternalizableHelper.readLong(input));
            this.setLeaseMillis(ExternalizableHelper.readLong(input));
        }

        public void setLeaseMillis(long pLeaseMillis) {
            this.__m_LeaseMillis = pLeaseMillis;
        }

        public void setWaitMillis(long cMillis) {
            this.__m_WaitMillis = cMillis;
            this.setWaitTimeout(0L);
        }

        protected void setWaitTimeout(long ldtTimeout) {
            this.__m_WaitTimeout = ldtTimeout;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            ExternalizableHelper.writeLong(output, this.getWaitMillis());
            ExternalizableHelper.writeLong(output, this.getLeaseMillis());
        }
    }

    public static class LeaseRemove
    extends LeaseMessage {
        public LeaseRemove() {
            this(null, null, true);
        }

        public LeaseRemove(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(37);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new LeaseRemove();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$LeaseRemove".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ReplicatedCache service = (ReplicatedCache)this.getService();
            Member memberFrom = this.getFromMember();
            Member memberThis = service.getThisMember();
            if (memberFrom != memberThis && service.getUpdatingMemberSet().contains(memberFrom)) {
                Lease lease = this.getLease();
                service.ensureCacheHandler(lease.getCacheIndex()).onLeaseRemove(lease);
            }
        }
    }

    public static class LeaseRemoveRequest
    extends LeaseRequest {
        public LeaseRemoveRequest() {
            this(null, null, true);
        }

        public LeaseRemoveRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(38);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new LeaseRemoveRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$LeaseRemoveRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ReplicatedCache service = (ReplicatedCache)this.getService();
            service.onLeaseRemoveRequest(this);
        }
    }

    public static class LeaseUnlock
    extends LeaseMessage {
        public LeaseUnlock() {
            this(null, null, true);
        }

        public LeaseUnlock(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(39);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new LeaseUnlock();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$LeaseUnlock".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ReplicatedCache service = (ReplicatedCache)this.getService();
            Member memberFrom = this.getFromMember();
            Member memberThis = service.getThisMember();
            if (memberFrom != memberThis && service.getUpdatingMemberSet().contains(memberFrom)) {
                Lease lease = this.getLease();
                service.ensureCacheHandler(lease.getCacheIndex()).onLeaseUpdate(lease, false, null, 0L);
            }
        }
    }

    public static class LeaseUnlockRequest
    extends LeaseRequest {
        public LeaseUnlockRequest() {
            this(null, null, true);
        }

        public LeaseUnlockRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(40);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new LeaseUnlockRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$LeaseUnlockRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ReplicatedCache service = (ReplicatedCache)this.getService();
            service.onLeaseUnlockRequest(this);
        }
    }

    public static class LeaseUpdate
    extends ResourceMessage {
        public LeaseUpdate() {
            this(null, null, true);
        }

        public LeaseUpdate(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(41);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new LeaseUpdate();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$LeaseUpdate".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ReplicatedCache service = (ReplicatedCache)this.getService();
            Member memberFrom = this.getFromMember();
            Member memberThis = service.getThisMember();
            if (memberFrom != memberThis && service.getUpdatingMemberSet().contains(memberFrom)) {
                Lease lease = this.getLease();
                service.ensureCacheHandler(lease.getCacheIndex()).onLeaseUpdate(lease, true, this.getResource(), this.getResourceExpiry());
            }
        }
    }

    public static class LeaseUpdateRequest
    extends LeaseRequest {
        private Object __m_Resource;
        private Binary __m_ResourceBinary;
        private long __m_ResourceExpiry;

        public LeaseUpdateRequest() {
            this(null, null, true);
        }

        public LeaseUpdateRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(42);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new LeaseUpdateRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$LeaseUpdateRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public Lease getLease() {
            Lease lease = super.getLease();
            Binary binResource = this.getResourceBinary();
            if (binResource != null) {
                lease.setResourceSize(binResource.length());
            } else {
                Object oResource = this.getResource();
                if (oResource instanceof Binary) {
                    Binary binValue = (Binary)oResource;
                    lease.setResourceSize(binValue.length());
                }
            }
            return lease;
        }

        public Object getResource() {
            return this.__m_Resource;
        }

        public Binary getResourceBinary() {
            return this.__m_ResourceBinary;
        }

        public long getResourceExpiry() {
            return this.__m_ResourceExpiry;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ReplicatedCache service = (ReplicatedCache)this.getService();
            service.onLeaseUpdateRequest(this, this.getResource(), this.getResourceBinary());
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setResourceExpiry(ExternalizableHelper.readLong(input));
            Binary binResource = new Binary(Base.read(input));
            this.setResourceBinary(binResource);
            this.setResource(binResource);
        }

        public void setResource(Object oResource) {
            this.__m_Resource = oResource;
        }

        public void setResourceBinary(Binary binResource) {
            this.__m_ResourceBinary = binResource;
        }

        public void setResourceExpiry(long cMillis) {
            this.__m_ResourceExpiry = cMillis;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            ExternalizableHelper.writeLong(output, this.getResourceExpiry());
            Binary bin = this.getResourceBinary();
            if (bin == null) {
                bin = ExternalizableHelper.toBinary(this.getResource(), this.getService().ensureSerializer());
            }
            bin.writeTo(output);
            this.setResource(null);
            this.setResourceBinary(null);
        }
    }

    public static class CatalogHandler
    extends com.tangosol.coherence.component.util.cacheHandler.CatalogHandler {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("BackingMapListener", BackingMapListener.get_CLASS());
            __mapChildren.put("EntrySet", EntrySet.get_CLASS());
            __mapChildren.put("KeySet", KeySet.get_CLASS());
            __mapChildren.put("Validator", Validator.get_CLASS());
        }

        public CatalogHandler() {
            this(null, null, true);
        }

        public CatalogHandler(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setCacheIndex(0);
                this.setCacheName("$$$");
                this.setDeactivationListeners(new Listeners());
                this.setIgnoreKey(new Object());
                this.setLeaseMap(new SafeHashMap());
                this.setPutExpiryWarned(false);
                this.setResourceMap(new SafeHashMap());
                this.setStandardLeaseMillis(0L);
                this.setUseEventDaemon(false);
                this.setValid(true);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new CatalogHandler();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$CatalogHandler".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public com.tangosol.util.Converter getConverterFromInternal() {
            return super.getConverterFromInternal();
        }

        static {
            CatalogHandler.__initStatic();
        }

        public static class BackingMapListener
        extends CacheHandler.BackingMapListener {
            public BackingMapListener() {
                this(null, null, true);
            }

            public BackingMapListener(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new BackingMapListener();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$CatalogHandler$BackingMapListener".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class EntrySet
        extends CacheHandler.EntrySet {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Entry", Entry.get_CLASS());
                __mapChildren.put("Iterator", Iterator.get_CLASS());
            }

            public EntrySet() {
                this(null, null, true);
            }

            public EntrySet(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new EntrySet();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$CatalogHandler$EntrySet".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                EntrySet.__initStatic();
            }

            public static class Entry
            extends CacheHandler.EntrySet.Entry {
                public Entry() {
                    this(null, null, true);
                }

                public Entry(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Entry();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$CatalogHandler$EntrySet$Entry".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }

            public static class Iterator
            extends CacheHandler.EntrySet.Iterator {
                public Iterator() {
                    this(null, null, true);
                }

                public Iterator(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Iterator();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$CatalogHandler$EntrySet$Iterator".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class KeySet
        extends CacheHandler.KeySet {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Iterator", Iterator.get_CLASS());
            }

            public KeySet() {
                this(null, null, true);
            }

            public KeySet(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new KeySet();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$CatalogHandler$KeySet".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                KeySet.__initStatic();
            }

            public static class Iterator
            extends CacheHandler.KeySet.Iterator {
                public Iterator() {
                    this(null, null, true);
                }

                public Iterator(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Iterator();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$CatalogHandler$KeySet$Iterator".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class Validator
        extends CacheHandler.Validator {
            public Validator() {
                this(null, null, true);
            }

            public Validator(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setLeaseMap(new SafeHashMap());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Validator();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$CatalogHandler$Validator".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }
}

