/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.oracle.coherence.common.net.InetSocketAddress32;
import com.oracle.coherence.common.net.SSLSocketProvider;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.ServiceInfo;
import com.tangosol.coherence.component.net.extend.protocol.CacheServiceProtocol;
import com.tangosol.coherence.component.net.extend.protocol.InvocationServiceProtocol;
import com.tangosol.coherence.component.net.extend.protocol.NamedCacheProtocol;
import com.tangosol.coherence.component.net.extend.proxy.serviceProxy.CacheServiceProxy;
import com.tangosol.coherence.component.net.extend.proxy.serviceProxy.InvocationServiceProxy;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.GrpcAcceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.HttpAcceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.MemcachedAcceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor;
import com.tangosol.coherence.config.builder.ServiceLoadBalancerBuilder;
import com.tangosol.internal.net.service.DefaultServiceDependencies;
import com.tangosol.internal.net.service.grid.DefaultProxyServiceDependencies;
import com.tangosol.internal.net.service.grid.LegacyXmlProxyServiceHelper;
import com.tangosol.internal.net.service.grid.ProxyServiceDependencies;
import com.tangosol.net.ActionPolicy;
import com.tangosol.net.CacheService;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.Member;
import com.tangosol.net.NameService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedCollection;
import com.tangosol.net.NamedMap;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.ProxyService;
import com.tangosol.net.RequestPolicyException;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.Session;
import com.tangosol.net.events.InterceptorRegistry;
import com.tangosol.net.management.Registry;
import com.tangosol.net.messaging.Connection;
import com.tangosol.net.messaging.ConnectionAcceptor;
import com.tangosol.net.messaging.ConnectionEvent;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.ConnectionFilter;
import com.tangosol.net.messaging.ConnectionListener;
import com.tangosol.net.proxy.ProxyServiceLoad;
import com.tangosol.net.proxy.ProxyServiceLoadBalancer;
import com.tangosol.net.proxy.RemoteMember;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.LiteMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SimpleResourceRegistry;
import com.tangosol.util.SynchronousListener;
import com.tangosol.util.WrapperException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.naming.NamingException;
import javax.security.auth.Subject;

public class ProxyService
extends Grid
implements NameService.Resolvable,
com.tangosol.net.ProxyService,
Session,
ConnectionFilter,
ConnectionListener,
SynchronousListener {
    private ConnectionAcceptor __m_Acceptor;
    private CacheServiceProxy __m_CacheServiceProxy;
    private InvocationServiceProxy __m_InvocationServiceProxy;
    private ProxyServiceLoadBalancer __m_LoadBalancer;
    private NavigableSet __m_MemberListenAddresses;
    private boolean __m_ResolveAllAddresses;
    private ServiceLoad __m_ServiceLoad;
    private Map __m_ServiceLoadMap;
    private ServiceLoad __m_ServiceLoadPublished;
    private long __m_ServiceLoadTimeMillis;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Acknowledgement", Grid.Acknowledgement.get_CLASS());
        __mapChildren.put("BusEventMessage", Grid.BusEventMessage.get_CLASS());
        __mapChildren.put("ConfigRequest", Grid.ConfigRequest.get_CLASS());
        __mapChildren.put("ConfigResponse", Grid.ConfigResponse.get_CLASS());
        __mapChildren.put("ConfigSync", Grid.ConfigSync.get_CLASS());
        __mapChildren.put("ConfigUpdate", Grid.ConfigUpdate.get_CLASS());
        __mapChildren.put("DispatchEvent", Grid.DispatchEvent.get_CLASS());
        __mapChildren.put("DispatchNotification", Grid.DispatchNotification.get_CLASS());
        __mapChildren.put("LoadBalancerActionGetList", LoadBalancerActionGetList.get_CLASS());
        __mapChildren.put("LoadBalancerActionUpdate", LoadBalancerActionUpdate.get_CLASS());
        __mapChildren.put("LookupCallback", LookupCallback.get_CLASS());
        __mapChildren.put("MemberConfigUpdate", Grid.MemberConfigUpdate.get_CLASS());
        __mapChildren.put("MemberJoined", Grid.MemberJoined.get_CLASS());
        __mapChildren.put("MemberWelcome", Grid.MemberWelcome.get_CLASS());
        __mapChildren.put("MemberWelcomeRequest", Grid.MemberWelcomeRequest.get_CLASS());
        __mapChildren.put("MemberWelcomeRequestTask", Grid.MemberWelcomeRequestTask.get_CLASS());
        __mapChildren.put("NotifyConnectionClose", Grid.NotifyConnectionClose.get_CLASS());
        __mapChildren.put("NotifyConnectionClosed", NotifyConnectionClosed.get_CLASS());
        __mapChildren.put("NotifyConnectionOpen", Grid.NotifyConnectionOpen.get_CLASS());
        __mapChildren.put("NotifyConnectionOpened", NotifyConnectionOpened.get_CLASS());
        __mapChildren.put("NotifyMemberJoined", Grid.NotifyMemberJoined.get_CLASS());
        __mapChildren.put("NotifyMemberLeaving", Grid.NotifyMemberLeaving.get_CLASS());
        __mapChildren.put("NotifyMemberLeft", Grid.NotifyMemberLeft.get_CLASS());
        __mapChildren.put("NotifyMessageReceipt", Grid.NotifyMessageReceipt.get_CLASS());
        __mapChildren.put("NotifyPollClosed", Grid.NotifyPollClosed.get_CLASS());
        __mapChildren.put("NotifyResponse", Grid.NotifyResponse.get_CLASS());
        __mapChildren.put("NotifyServiceAnnounced", Grid.NotifyServiceAnnounced.get_CLASS());
        __mapChildren.put("NotifyServiceJoining", Grid.NotifyServiceJoining.get_CLASS());
        __mapChildren.put("NotifyServiceLeaving", Grid.NotifyServiceLeaving.get_CLASS());
        __mapChildren.put("NotifyServiceLeft", Grid.NotifyServiceLeft.get_CLASS());
        __mapChildren.put("NotifyServiceQuiescence", Grid.NotifyServiceQuiescence.get_CLASS());
        __mapChildren.put("NotifyShutdown", Grid.NotifyShutdown.get_CLASS());
        __mapChildren.put("NotifyStartup", Grid.NotifyStartup.get_CLASS());
        __mapChildren.put("PingRequest", Grid.PingRequest.get_CLASS());
        __mapChildren.put("ProtocolContext", Grid.ProtocolContext.get_CLASS());
        __mapChildren.put("RedirectRequest", RedirectRequest.get_CLASS());
        __mapChildren.put("Response", Grid.Response.get_CLASS());
        __mapChildren.put("ServiceLoad", ServiceLoad.get_CLASS());
        __mapChildren.put("ServiceLoadListener", ServiceLoadListener.get_CLASS());
        __mapChildren.put("WrapperGuardable", Grid.WrapperGuardable.get_CLASS());
    }

    public ProxyService() {
        this(null, null, true);
    }

    public ProxyService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setMemberListenAddresses(new TreeSet());
            this.setMessageClassMap(new HashMap());
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setOldestPendingRequestSUIDCounter(new AtomicLong());
            this.setResolveAllAddresses(false);
            this.setResourceRegistry(new SimpleResourceRegistry());
            this.setSerializerMap(new WeakHashMap());
            this.setServiceLoadMap(new SafeHashMap());
            this.setSuspendPollLimit(new AtomicLong());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Grid.DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Grid.EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Grid.Guard("Guard", this, true), "Guard");
        this._addChild(new Grid.MemberConfigListener("MemberConfigListener", this, true), "MemberConfigListener");
        this._addChild(new Grid.PollArray("PollArray", this, true), "PollArray");
        this._addChild(new Grid.ReceiveQueue("ReceiveQueue", this, true), "ReceiveQueue");
        this._addChild(new Grid.ServiceConfig("ServiceConfig", this, true), "ServiceConfig");
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    @Override
    public String getServiceType() {
        return "Proxy";
    }

    public static Component get_Instance() {
        return new ProxyService();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ProxyService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    public void activate() {
    }

    @Override
    public void checkConnection(Connection connection) throws ConnectionException {
        if (connection instanceof TcpAcceptor.TcpConnection) {
            TcpAcceptor.TcpConnection connectionImpl = (TcpAcceptor.TcpConnection)connection;
            String sCluster = connectionImpl.getClusterName();
            if (sCluster != null && !sCluster.equals(this.getCluster().getClusterName())) {
                throw new ConnectionException("connection rejected, cluster mismatch");
            }
            String sService = connectionImpl.getServiceName();
            if (sService != null && !sService.equals(this.getServiceName())) {
                throw new ConnectionException("connection rejected, service mismatch");
            }
        }
        if (!this.getActionPolicy().isAllowed(this, ProxyService.ProxyAction.CONNECT)) {
            throw new ConnectionException("connection rejected", new RequestPolicyException("client connections are disallowed by the action policy"));
        }
        RedirectRequest request = (RedirectRequest)this.instantiateMessage("RedirectRequest");
        request.setConnection(connection);
        request.addToMember(this.getThisMember());
        Object oResult = this.poll(request);
        if (oResult instanceof Boolean && ((Boolean)oResult).booleanValue()) {
            throw new ConnectionException("connection redirected");
        }
    }

    @Override
    protected DefaultServiceDependencies cloneDependencies(ServiceDependencies deps) {
        return new DefaultProxyServiceDependencies((ProxyServiceDependencies)deps);
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public synchronized void configure(XmlElement xml) {
        this.setDependencies(LegacyXmlProxyServiceHelper.fromXml(xml, new DefaultProxyServiceDependencies(), this.getOperationalContext(), this.getContextClassLoader()));
        this.setServiceConfig(xml);
    }

    @Override
    public void connectionClosed(ConnectionEvent evt) {
        com.tangosol.coherence.component.net.extend.Connection con = (com.tangosol.coherence.component.net.extend.Connection)evt.getConnection();
        com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)con.getMember();
        NotifyConnectionClosed msg = (NotifyConnectionClosed)this.instantiateMessage("NotifyConnectionClosed");
        msg.setConnection(con);
        msg.addToMember(this.getThisMember());
        this.send(msg);
        this.doNotifyConnectionEvent(evt.getId(), member, 3);
    }

    @Override
    public void connectionError(ConnectionEvent evt) {
        this.connectionClosed(evt);
    }

    @Override
    public void connectionOpened(ConnectionEvent evt) {
        com.tangosol.coherence.component.net.extend.Connection con = (com.tangosol.coherence.component.net.extend.Connection)evt.getConnection();
        com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)con.getMember();
        NotifyConnectionOpened msg = (NotifyConnectionOpened)this.instantiateMessage("NotifyConnectionOpened");
        msg.setConnection(con);
        msg.addToMember(this.getThisMember());
        this.send(msg);
        this.doNotifyConnectionEvent(evt.getId(), member, 1);
    }

    protected void doNotifyConnectionEvent(int nConnectionEventType, com.tangosol.coherence.component.net.Member notifyMember, int nMemberEventType) {
        ClusterService clusterService = this.getClusterService();
        if (clusterService.isVersionCompatible(clusterService.getServiceMemberSet(), 22, 6, 0)) {
            int cServices = clusterService.getServiceCount();
            block4: for (int i = 0; i < cServices; ++i) {
                String sName;
                Grid service = ((Cluster)this.getCluster()).getClusterService().getService(i);
                String string = sName = service != null ? service.getInfo().getServiceName() : "";
                if (service == null || service == clusterService || sName.equals("TransportService") || sName.equals("Management") || service == this) continue;
                switch (nConnectionEventType) {
                    case 1: {
                        Grid.NotifyConnectionOpen msgOpen = (Grid.NotifyConnectionOpen)service.instantiateMessage("NotifyConnectionOpen");
                        msgOpen.setNotifyMember(notifyMember);
                        msgOpen.setToMemberSet(service.getServiceMemberSet());
                        service.send(msgOpen);
                        continue block4;
                    }
                    case 2: 
                    case 3: {
                        Grid.NotifyConnectionClose msgClose = (Grid.NotifyConnectionClose)service.instantiateMessage("NotifyConnectionClose");
                        msgClose.setNotifyMember(notifyMember);
                        msgClose.setToMemberSet(service.getServiceMemberSet());
                        service.send(msgClose);
                    }
                }
            }
            this.dispatchMemberEvent(notifyMember, nMemberEventType);
        }
    }

    @Override
    public String formatStats() {
        ConnectionAcceptor acceptor = this.getAcceptor();
        if (acceptor instanceof Acceptor) {
            return ((Acceptor)acceptor).formatStats();
        }
        return super.formatStats();
    }

    public ConnectionAcceptor getAcceptor() {
        return this.__m_Acceptor;
    }

    public NamedCache getCache(String sName, NamedMap.Option[] options) {
        CacheService service = this.getCacheServiceProxy().getCacheService();
        if (service instanceof Session) {
            return ((Session)((Object)service)).getCache(sName, options);
        }
        return service.ensureCache(sName, Base.ensureClassLoader(null));
    }

    public CacheServiceProxy getCacheServiceProxy() {
        return this.__m_CacheServiceProxy;
    }

    @Override
    public InterceptorRegistry getInterceptorRegistry() {
        return null;
    }

    public InvocationServiceProxy getInvocationServiceProxy() {
        return this.__m_InvocationServiceProxy;
    }

    protected String getListenAddress(Member member) {
        if (member instanceof RemoteMember) {
            return member.getAddress().getHostAddress();
        }
        ServiceMemberSet setMember = this.getServiceMemberSet();
        if (setMember == null) {
            return null;
        }
        ObservableMap map = setMember.getMemberConfigMap(member.getId());
        return map == null ? null : (String)map.get("listen-address");
    }

    protected Collection getListenAddresses(Member member) {
        if (member instanceof RemoteMember) {
            return Collections.singleton(member.getAddress());
        }
        ServiceMemberSet setMember = this.getServiceMemberSet();
        return setMember == null ? null : ProxyService.getListenAddresses(setMember.getMemberConfigMap(member.getId()));
    }

    public static Collection getListenAddresses(Map mapConfig) {
        if (mapConfig == null) {
            return null;
        }
        String sAddrList = (String)mapConfig.get("listen-addresses");
        if (sAddrList == null) {
            return null;
        }
        String[] saAddr = sAddrList.split(",");
        HashSet<InetAddress> colAddr = new HashSet<InetAddress>(saAddr.length);
        int i = 0;
        while (i < saAddr.length) {
            try {
                colAddr.add(InetAddress.getByName(saAddr[i++]));
            }
            catch (UnknownHostException unknownHostException) {}
        }
        return colAddr;
    }

    protected Integer getListenPort(Member member) {
        if (member instanceof RemoteMember) {
            return member.getPort();
        }
        ObservableMap map = this.getServiceMemberSet().getMemberConfigMap(member.getId());
        return (Integer)map.get("listen-port");
    }

    protected String getListenSocketAddress(Member member) {
        Object sAddress = this.getListenAddress(member);
        if (sAddress == null) {
            return null;
        }
        if (((String)sAddress).indexOf(58) >= 0 && ((String)sAddress).charAt(0) != '[') {
            sAddress = "[" + (String)sAddress + "]";
        }
        return (String)sAddress + ":" + this.getListenPort(member);
    }

    public ProxyServiceLoadBalancer getLoadBalancer() {
        return this.__m_LoadBalancer;
    }

    public NamedMap getMap(String Param_1, NamedMap.Option[] Param_2) {
        return null;
    }

    public NavigableSet getMemberListenAddresses() {
        return this.__m_MemberListenAddresses;
    }

    @Override
    public String getName() {
        return null;
    }

    protected NameService getNameService() {
        return this.getCluster().getResourceRegistry().getResource(NameService.class);
    }

    protected Object[] getRoutableAddress(Member member, NameService.RequestContext ctx) {
        return ProxyService.getRoutableAddress(member, member instanceof RemoteMember ? null : this.getServiceMemberSet().getMemberConfigMap(member.getId()), this.getCluster(), ctx);
    }

    protected Object[] getRoutableAddress(Member member, Socket socket) {
        InetAddress addrLocal;
        boolean fLocalSrc;
        if (socket == null) {
            fLocalSrc = true;
            addrLocal = null;
        } else {
            fLocalSrc = InetAddressHelper.isLocalAddress(InetAddressHelper.getAddress(socket.getRemoteSocketAddress()));
            addrLocal = socket.getLocalAddress();
        }
        return ProxyService.getRoutableAddress(member, member instanceof RemoteMember ? null : this.getServiceMemberSet().getMemberConfigMap(member.getId()), this.getCluster(), addrLocal, fLocalSrc);
    }

    public static Object[] getRoutableAddress(Member member, Map mapMemberConfig, com.tangosol.net.Cluster cluster, NameService.RequestContext ctx) {
        InetAddress addrSource = ctx.getSourceAddress();
        return ProxyService.getRoutableAddress(member, mapMemberConfig, cluster, ctx.getAcceptAddress(), addrSource == null ? false : InetAddressHelper.isLocalAddress(addrSource));
    }

    public static Object[] getRoutableAddress(Member member, Map mapMemberConfig, com.tangosol.net.Cluster cluster, InetAddress addrLocal, boolean fLocalSrc) {
        Object[] objectArray;
        if (member instanceof RemoteMember) {
            return new Object[]{member.getAddress().getHostAddress(), member.getPort()};
        }
        Collection<InetAddress> colAddresses = InetAddressHelper.getRoutableAddresses(addrLocal, fLocalSrc, ProxyService.getListenAddresses(mapMemberConfig), InetAddressHelper.isLocalAddress(member.getAddress()));
        String sProtocol = (String)mapMemberConfig.get("http-protocol");
        if (colAddresses == null || colAddresses.isEmpty()) {
            objectArray = null;
        } else if (sProtocol == null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = colAddresses.iterator().next().getHostAddress();
            objectArray = objectArray2;
            objectArray2[1] = mapMemberConfig.get("listen-port");
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = colAddresses.iterator().next().getHostAddress();
            objectArray3[1] = mapMemberConfig.get("listen-port");
            objectArray = objectArray3;
            objectArray3[2] = sProtocol;
        }
        return objectArray;
    }

    protected Object[] getRoutableAddress(Collection colMembers, NameService.RequestContext ctx) {
        Object[] result = null;
        Iterator iter = colMembers.iterator();
        while (iter.hasNext() && result == null) {
            result = this.getRoutableAddress((Member)iter.next(), ctx);
        }
        return result;
    }

    protected Object[] getRoutableAddresses(Collection colMembers, NameService.RequestContext ctx) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        Object[] result = null;
        Iterator iter = colMembers.iterator();
        while (iter.hasNext()) {
            result = this.getRoutableAddress((Member)iter.next(), ctx);
            if (result == null) continue;
            list.add(result);
        }
        if (!list.isEmpty()) {
            result = new Object[list.size() * 2];
            int i = 0;
            for (Object[] ao : list) {
                Integer nPort;
                if (ao == null || ao.length < 2 || (nPort = (Integer)ao[1]) == null || nPort <= 0) continue;
                result[i++] = ao[0];
                result[i++] = ao[1];
            }
        }
        return result;
    }

    public Set getRoutableMemberAddresses(Socket socket) {
        InetAddress addrLocal;
        boolean fLocalSrc;
        if (socket == null) {
            fLocalSrc = true;
            addrLocal = null;
        } else {
            fLocalSrc = InetAddressHelper.isLocalAddress(InetAddressHelper.getAddress(socket.getRemoteSocketAddress()));
            addrLocal = socket.getLocalAddress();
        }
        return ProxyService.getRoutableMemberAddresses(this.getServiceMemberSet(), this.getCluster(), addrLocal, fLocalSrc);
    }

    public static Set getRoutableMemberAddresses(ServiceMemberSet setMembers, com.tangosol.net.Cluster cluster, NameService.RequestContext ctx) {
        InetAddress addrSource = ctx.getSourceAddress();
        return ProxyService.getRoutableMemberAddresses(setMembers, cluster, ctx.getAcceptAddress(), addrSource == null ? false : InetAddressHelper.isLocalAddress(addrSource));
    }

    public static Set getRoutableMemberAddresses(ServiceMemberSet setMembers, com.tangosol.net.Cluster cluster, InetAddress addrLocal, boolean fLocalSrc) {
        TreeSet<String> setResult = new TreeSet<String>();
        for (Member member : setMembers) {
            int nMemberID;
            Object[] aoAddress = ProxyService.getRoutableAddress(member, setMembers.getMemberConfigMap(nMemberID = member.getId()), cluster, addrLocal, fLocalSrc);
            if (aoAddress == null) continue;
            if (aoAddress.length > 2) {
                setResult.add("" + aoAddress[0] + ':' + aoAddress[1] + ':' + aoAddress[2]);
                continue;
            }
            setResult.add("" + aoAddress[0] + ':' + aoAddress[1]);
        }
        return setResult;
    }

    @Override
    public String getScopeName() {
        return null;
    }

    @Override
    public Service getService(String Param_1) {
        return null;
    }

    public ServiceLoad getServiceLoad() {
        ServiceLoad load = this.__m_ServiceLoad;
        if (load == null) {
            load = new ServiceLoad();
            this.setServiceLoad(load);
        }
        return load;
    }

    public Map getServiceLoadMap() {
        return this.__m_ServiceLoadMap;
    }

    public ServiceLoad getServiceLoadPublished() {
        return this.__m_ServiceLoadPublished;
    }

    public long getServiceLoadTimeMillis() {
        return this.__m_ServiceLoadTimeMillis;
    }

    public NamedTopic getTopic(String Param_1, NamedCollection.Option[] Param_2) {
        return null;
    }

    @Override
    public void close(NamedCollection col) {
        if (col instanceof NamedCache) {
            CacheService service = this.getCacheServiceProxy().getCacheService();
            if (service instanceof Session) {
                ((Session)((Object)service)).close(col);
            } else {
                service.releaseCache((NamedCache)col);
            }
        }
    }

    @Override
    public void destroy(NamedCollection col) {
        if (col instanceof NamedCache) {
            CacheService service = this.getCacheServiceProxy().getCacheService();
            if (service instanceof Session) {
                ((Session)((Object)service)).destroy(col);
            } else {
                service.destroyCache((NamedCache)col);
            }
        }
    }

    @Override
    protected XmlElement initServiceConfig() {
        XmlElement xmlConfig = super.initServiceConfig();
        ActionPolicy quorumPolicy = this.getActionPolicy();
        String sQuorumPolicy = quorumPolicy == null ? "none" : quorumPolicy.getClass().getName();
        xmlConfig.addAttribute("quorum-policy").setString(sQuorumPolicy);
        return xmlConfig;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public boolean isCacheActive(String Param_1, ClassLoader Param_2) {
        return false;
    }

    @Override
    public boolean isMapActive(String Param_1, ClassLoader Param_2) {
        return false;
    }

    public boolean isResolveAllAddresses() {
        return this.__m_ResolveAllAddresses;
    }

    @Override
    public boolean isRunning() {
        ConnectionAcceptor acceptor;
        if (super.isRunning() && (acceptor = this.getAcceptor()) != null) {
            if (acceptor.isRunning()) {
                return true;
            }
            this.stop();
        }
        return false;
    }

    @Override
    public String getDescription() {
        return super.getDescription() + ", Serializer=" + this.getSerializer().getName();
    }

    @Override
    public boolean isTopicActive(String Param_1, ClassLoader Param_2) {
        return false;
    }

    @Override
    protected void onDependencies(ServiceDependencies deps) {
        ProxyServiceLoadBalancer balancer;
        super.onDependencies(deps);
        ProxyServiceDependencies proxyDeps = (ProxyServiceDependencies)deps;
        ActionPolicy policy = (ActionPolicy)proxyDeps.getActionPolicyBuilder().realize(this.createResolver(), this.getContextClassLoader(), null);
        this.setActionPolicy(policy);
        OperationalContext ctx = this.getOperationalContext();
        if (ctx == null) {
            throw new IllegalStateException("missing required OperationalContext");
        }
        CacheServiceProxy cacheServiceProxy = new CacheServiceProxy();
        this.setCacheServiceProxy(cacheServiceProxy);
        cacheServiceProxy.setDependencies(proxyDeps.getCacheServiceProxyDependencies());
        cacheServiceProxy.setContextClassLoader(this.getContextClassLoader());
        cacheServiceProxy.setCacheFactory(this.getResourceRegistry().getResource(ConfigurableCacheFactory.class, "ConfigurableCacheFactory"));
        InvocationServiceProxy invocationServiceProxy = new InvocationServiceProxy();
        this.setInvocationServiceProxy(invocationServiceProxy);
        invocationServiceProxy.setDependencies(proxyDeps.getInvocationServiceProxyDependencies());
        ConnectionAcceptor acceptor = Acceptor.createAcceptor(proxyDeps.getAcceptorDependencies(), ctx);
        this.setAcceptor(acceptor);
        if (acceptor instanceof Acceptor) {
            Acceptor acceptorImpl = (Acceptor)acceptor;
            String sAcceptorServiceName = this.getThreadName() + ":" + acceptorImpl.getServiceName();
            acceptorImpl.setServiceName(sAcceptorServiceName);
            acceptorImpl.setParentService(this);
            acceptorImpl.setDefaultGuardTimeout(this.getDefaultGuardTimeout());
            if (!(acceptor instanceof HttpAcceptor)) {
                Acceptor.DaemonPool pool = (Acceptor.DaemonPool)acceptorImpl.getDaemonPool();
                int cThreads = proxyDeps.getWorkerThreadCountMin();
                if (cThreads > 0) {
                    pool.setDaemonCount(cThreads);
                    pool.setDaemonCountMax(proxyDeps.getWorkerThreadCountMax());
                    pool.setDaemonCountMin(cThreads);
                    pool.setHungThreshold(proxyDeps.getTaskHungThresholdMillis());
                    pool.setName(sAcceptorServiceName);
                    pool.setTaskTimeout(proxyDeps.getTaskTimeoutMillis());
                    pool.setThreadPriority(proxyDeps.getWorkerThreadPriority());
                    cacheServiceProxy.setDaemonPool(pool);
                    invocationServiceProxy.setDaemonPool(pool);
                }
            }
        }
        acceptor.registerProtocol(CacheServiceProtocol.getInstance());
        acceptor.registerProtocol(InvocationServiceProtocol.getInstance());
        acceptor.registerProtocol(NamedCacheProtocol.getInstance());
        if (this.getCacheServiceProxy().isEnabled()) {
            acceptor.registerReceiver(this.getCacheServiceProxy());
        }
        if (this.getInvocationServiceProxy().isEnabled()) {
            acceptor.registerReceiver(this.getInvocationServiceProxy());
        }
        if (acceptor instanceof HttpAcceptor) {
            cacheServiceProxy.setPassThroughEnabled(false);
            ((HttpAcceptor)acceptor).setSession(this);
        } else if (acceptor instanceof MemcachedAcceptor) {
            cacheServiceProxy.setPassThroughEnabled(false);
        } else if (acceptor instanceof GrpcAcceptor) {
            cacheServiceProxy.setPassThroughEnabled(false);
        }
        ServiceLoadBalancerBuilder builder = proxyDeps.getLoadBalancerBuilder();
        if (builder != null && (balancer = (ProxyServiceLoadBalancer)builder.realize(this.createResolver(), this.getContextClassLoader(), null)) != null) {
            this.setLoadBalancer(balancer);
            try {
                balancer.init(this);
            }
            catch (RuntimeException e) {
                Base.ensureRuntimeException(e, "error initializing load balancer");
            }
        }
    }

    @Override
    protected void onNotify() {
        super.onNotify();
        long UPDATE_PERIOD = 10000L;
        if (this.getServiceLoadTimeMillis() + 10000L <= Base.getLastSafeTimeMillis()) {
            ServiceLoad load = this.getServiceLoad();
            ConnectionAcceptor acceptor = this.getAcceptor();
            if (acceptor instanceof Acceptor) {
                Acceptor acceptorImpl = (Acceptor)acceptor;
                load.setConnectionPendingCount(acceptorImpl.getConnectionPendingSet().size());
                DaemonPool pool = acceptorImpl.getDaemonPool();
                if (pool.isStarted()) {
                    load.setDaemonActiveCount(pool.getActiveDaemonCount());
                    load.setMessageBacklogIncoming(pool.getBacklog());
                }
                if (acceptor instanceof TcpAcceptor) {
                    int cBacklog = 0;
                    try {
                        for (TcpAcceptor.TcpConnection conn : acceptorImpl.getConnectionSet()) {
                            if (conn == null) continue;
                            cBacklog += conn.getOutgoingQueue().size();
                        }
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        // empty catch block
                    }
                    load.setMessageBacklogOutgoing(cBacklog);
                }
            }
            this.updateServiceLoad();
        }
    }

    public void onNotifyConnectionClosed(NotifyConnectionClosed msg) {
        Registry registry;
        Connection connection = msg.getConnection();
        if (connection instanceof TcpAcceptor.TcpConnection && (registry = this.getCluster().getManagement()) != null) {
            String sName = registry.ensureGlobalName("type=Connection,name=" + this.getServiceName()) + ",UUID=" + String.valueOf(connection.getId());
            registry.unregister(sName);
        }
        ServiceLoad load = this.getServiceLoad();
        load.updateConnectionCount(-1);
        this.updateServiceLoad();
        this.updateLoadBalancer(this.getThisMember(), load, connection);
    }

    public void onNotifyConnectionOpened(NotifyConnectionOpened msg) {
        Registry registry;
        Connection connection = msg.getConnection();
        if (connection instanceof TcpAcceptor.TcpConnection && (registry = this.getCluster().getManagement()) != null) {
            String sName = registry.ensureGlobalName("type=Connection,name=" + this.getServiceName()) + ",UUID=" + String.valueOf(connection.getId());
            registry.register(sName, connection);
        }
        ServiceLoad load = this.getServiceLoad();
        load.updateConnectionCount(1);
        this.updateServiceLoad();
        this.updateLoadBalancer(this.getThisMember(), load, connection);
    }

    @Override
    public void onNotifyServiceJoined(com.tangosol.coherence.component.net.Member member) {
        ConnectionAcceptor acceptor;
        super.onNotifyServiceJoined(member);
        ObservableMap map = this.getServiceMemberSet().getMemberConfigMap(member.getId());
        Map mapLoad = (Map)map.get("service-load");
        if (mapLoad != null) {
            ServiceLoadListener listener = (ServiceLoadListener)this._newChild("ServiceLoadListener");
            listener.setMember(member);
            ServiceLoad load = new ServiceLoad();
            load.fromMap(mapLoad);
            load.setListener(listener);
            this.getServiceLoadMap().put(member, load);
            map.addMapListener(listener);
            this.updateLoadBalancer(member, load, null);
        }
        if ((acceptor = this.getAcceptor()) instanceof TcpAcceptor || acceptor instanceof HttpAcceptor || acceptor instanceof GrpcAcceptor) {
            this.getMemberListenAddresses().add(this.getListenSocketAddress(member));
        }
    }

    @Override
    public void onNotifyServiceLeft(com.tangosol.coherence.component.net.Member member) {
        NavigableSet setAddr = this.getMemberListenAddresses();
        ConnectionAcceptor acceptor = this.getAcceptor();
        if (!setAddr.isEmpty() && (acceptor instanceof TcpAcceptor || acceptor instanceof HttpAcceptor || acceptor instanceof GrpcAcceptor)) {
            setAddr.remove(this.getListenSocketAddress(member));
        }
        super.onNotifyServiceLeft(member);
        ServiceLoad load = (ServiceLoad)this.getServiceLoadMap().remove(member);
        if (load != null) {
            ServiceLoadListener listener = load.getListener();
            if (listener != null) {
                this.getServiceMemberSet().getMemberConfigMap(member.getId()).removeMapListener(listener);
            }
            this.updateLoadBalancer(member, null, null);
        }
    }

    public void onRedirectRequest(RedirectRequest request) {
        boolean fRedirect = false;
        Connection connection = request.getConnection();
        if (connection instanceof TcpAcceptor.TcpConnection) {
            com.tangosol.coherence.component.net.Member memberThis;
            List list;
            TcpAcceptor.TcpConnection connectionImpl = (TcpAcceptor.TcpConnection)connection;
            ProxyServiceLoadBalancer balancer = this.getLoadBalancer();
            if (balancer == null || connectionImpl.isRedirect() || !connectionImpl.isRedirectSupported()) {
                list = null;
            } else {
                Subject subject = connection.getChannel(0).getSubject();
                if (subject == null) {
                    list = balancer.getMemberList(connectionImpl.getMember());
                } else {
                    LoadBalancerActionGetList action = new LoadBalancerActionGetList();
                    action.setBalancer(balancer);
                    action.setConnection(connectionImpl);
                    list = (List)Subject.doAs(subject, action);
                }
            }
            if (list != null && !list.isEmpty() && !Base.equals(memberThis = this.getThisMember(), list.get(0))) {
                Member member;
                boolean fConnectionPendingUpdated = false;
                ArrayList<Object[]> listAddr = new ArrayList<Object[]>(list.size());
                Socket socket = connectionImpl.getSocket();
                Iterator iter = list.iterator();
                while (iter.hasNext() && !Base.equals(memberThis, member = (Member)iter.next())) {
                    Object[] result = this.getRoutableAddress(member, socket);
                    if (result == null) continue;
                    listAddr.add(result);
                    if (fConnectionPendingUpdated) continue;
                    ServiceLoad load = (ServiceLoad)this.getServiceLoadMap().get(member);
                    if (load != null) {
                        load.updateConnectionPendingCount(1);
                        this.updateLoadBalancer(member, load, connectionImpl);
                    }
                    fConnectionPendingUpdated = true;
                }
                if (!listAddr.isEmpty()) {
                    connectionImpl.setRedirect(true);
                    connectionImpl.setRedirectList(listAddr);
                    fRedirect = true;
                }
            }
        }
        Grid.Response response = (Grid.Response)this.instantiateMessage("Response");
        request.ensureRequestPoll().setResult(fRedirect);
        response.respondTo(request);
        this.send(response);
    }

    @Override
    public void onServiceStarted() {
        com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
        for (com.tangosol.coherence.component.net.Member member : this.getServiceMemberSet()) {
            if (Base.equals(member, memberThis)) continue;
            this.onNotifyServiceJoined(member);
        }
        ConnectionAcceptor acceptor = this.getAcceptor();
        boolean fIsTcp = acceptor instanceof TcpAcceptor;
        boolean fIsHttp = !fIsTcp && acceptor instanceof HttpAcceptor;
        boolean fIsGrpc = !fIsTcp && !fIsHttp && acceptor instanceof GrpcAcceptor;
        this.setResolveAllAddresses(fIsGrpc);
        if (fIsTcp || fIsHttp || fIsGrpc) {
            this.getMemberListenAddresses().add(this.getListenSocketAddress(memberThis));
            try {
                NameService service = this.getNameService();
                if (service != null) {
                    String sServiceName = this.getServiceName();
                    service.bind(sServiceName, this);
                }
            }
            catch (Throwable e) {
                ProxyService._trace("Failed to bind \"" + this.getServiceName() + "\" to the NameService: " + String.valueOf(e), 2);
            }
        }
        super.onServiceStarted();
    }

    @Override
    protected void onServiceStarting() {
        boolean fIsGrpc;
        boolean fIsTcp;
        super.onServiceStarting();
        ConnectionAcceptor acceptor = this.getAcceptor();
        acceptor.setContextClassLoader(this.getContextClassLoader());
        acceptor.setConnectionFilter(this);
        if (acceptor instanceof Acceptor) {
            Acceptor acceptorImpl = (Acceptor)acceptor;
            this.getCacheServiceProxy().setSerializer(acceptorImpl.ensureSerializer());
            this.getInvocationServiceProxy().setSerializer(acceptorImpl.ensureSerializer());
        } else {
            this.getCacheServiceProxy().setSerializer(this.ensureSerializer());
            this.getInvocationServiceProxy().setSerializer(this.ensureSerializer());
        }
        ServiceLoad load = this.getServiceLoad();
        if (acceptor instanceof Acceptor) {
            Acceptor acceptorImpl = (Acceptor)acceptor;
            load.setConnectionLimit(acceptorImpl.getConnectionLimit());
            load.setDaemonCount(acceptorImpl.getDaemonPool().getDaemonCount());
        }
        this.updateServiceLoad();
        this.updateLoadBalancer(this.getThisMember(), load, null);
        if (acceptor instanceof TcpAcceptor) {
            ((TcpAcceptor)acceptor).addConnectionListener(this);
        }
        if (acceptor instanceof Acceptor) {
            this.guard(((Acceptor)acceptor).getGuardable());
        }
        acceptor.start();
        Registry registry = this.getCluster().getManagement();
        if (registry != null) {
            String sName = registry.ensureGlobalName("type=ConnectionManager,name=" + this.getServiceName());
            registry.register(sName, acceptor);
        }
        boolean fIsHttp = !(fIsTcp = acceptor instanceof TcpAcceptor) && acceptor instanceof HttpAcceptor;
        boolean bl = fIsGrpc = !fIsTcp && !fIsHttp && acceptor instanceof GrpcAcceptor;
        if (fIsTcp || fIsHttp || fIsGrpc) {
            InetSocketAddress32 sockAddr;
            LiteMap<String, Object> map = new LiteMap<String, Object>();
            String sProtocol = null;
            if (fIsTcp) {
                sockAddr = (InetSocketAddress32)((TcpAcceptor)acceptor).getProcessor().getServerSocket().getLocalSocketAddress();
            } else if (fIsHttp) {
                acceptorImpl = (HttpAcceptor)acceptor;
                sockAddr = new InetSocketAddress32(((HttpAcceptor)acceptorImpl).getListenAddress(), ((HttpAcceptor)acceptorImpl).getListenPort());
                sProtocol = ((HttpAcceptor)acceptorImpl).getSocketProvider() instanceof SSLSocketProvider ? "https" : "http";
            } else {
                acceptorImpl = (GrpcAcceptor)acceptor;
                sockAddr = new InetSocketAddress32(((GrpcAcceptor)acceptorImpl).getListenAddress(), ((GrpcAcceptor)acceptorImpl).getListenPort());
            }
            InetAddress addr = sockAddr.getAddress();
            map.put("listen-address", addr.getHostAddress());
            map.put("listen-port", sockAddr.getPort());
            if (sProtocol != null) {
                map.put("http-protocol", sProtocol);
            }
            Collection<InetAddress> colAddr = addr.isAnyLocalAddress() ? InetAddressHelper.getLocalBindableAddresses() : Collections.singletonList(addr);
            StringJoiner sjFull = new StringJoiner(",");
            Iterator<InetAddress> iter = colAddr.iterator();
            while (iter.hasNext()) {
                sjFull.add(iter.next().getHostAddress());
            }
            map.put("listen-addresses", sjFull.toString());
            this.getThisMemberConfigMap().putAll(map);
        }
    }

    @Override
    protected void onServiceStopped() {
        super.onServiceStopped();
        ConnectionAcceptor acceptor = this.getAcceptor();
        acceptor.stop();
        this.updateLoadBalancer(this.getThisMember(), null, null);
        Registry registry = this.getCluster().getManagement();
        if (registry != null) {
            String sName = registry.ensureGlobalName("type=ConnectionManager,name=" + this.getServiceName());
            registry.unregister(sName);
        }
        if (acceptor instanceof TcpAcceptor || acceptor instanceof HttpAcceptor || acceptor instanceof GrpcAcceptor) {
            NameService service;
            String sAddr = this.getListenSocketAddress(this.getThisMember());
            if (sAddr != null) {
                this.getMemberListenAddresses().remove(sAddr);
            }
            if ((service = this.getNameService()) != null) {
                try {
                    service.unbind(this.getServiceName());
                }
                catch (Throwable e) {
                    ProxyService._trace("Failed to unbind \"" + this.getServiceName() + "\" from the NameService: " + String.valueOf(e), 2);
                }
            }
        }
    }

    @Override
    protected void onServiceStopping() {
        super.onServiceStopping();
        this.getAcceptor().shutdown();
    }

    @Override
    public void resetStats() {
        ConnectionAcceptor acceptor = this.getAcceptor();
        if (acceptor instanceof Acceptor) {
            ((Acceptor)acceptor).resetStats();
        }
        super.resetStats();
    }

    @Override
    public Object resolve(NameService.RequestContext ctx) {
        List<Member> list;
        ProxyServiceLoadBalancer balancer = this.getLoadBalancer();
        Object[] result = null;
        List<Member> list2 = list = balancer == null ? null : balancer.getMemberList(ctx.getMember());
        if (list != null) {
            result = this.isResolveAllAddresses() ? this.getRoutableAddresses(list, ctx) : this.getRoutableAddress(list, ctx);
        }
        if (result == null) {
            Set setRemainingMembers;
            if (list == null) {
                setRemainingMembers = this.getServiceMemberSet();
            } else {
                setRemainingMembers = new HashSet(this.getServiceMemberSet());
                setRemainingMembers.removeAll(list);
            }
            result = this.getRoutableAddress(Base.randomize(setRemainingMembers), ctx);
        }
        if (result == null) {
            com.tangosol.coherence.component.net.Member member = this.getThisMember();
            result = new Object[]{this.getListenAddress(member), this.getListenPort(member)};
            ProxyService._trace("No route could be determined from " + String.valueOf(ctx.getMember()) + " to \"" + this.getServiceName() + "\".  Returning \"" + String.valueOf(result[0]) + ":" + InetAddressHelper.toString((Integer)result[1]) + "\"", 2);
        }
        return result;
    }

    protected void setAcceptor(ConnectionAcceptor acceptor) {
        ProxyService._assert(this.getAcceptor() == null);
        this.__m_Acceptor = acceptor;
    }

    protected void setCacheServiceProxy(CacheServiceProxy proxy) {
        ProxyService._assert(this.getCacheServiceProxy() == null);
        this.__m_CacheServiceProxy = proxy;
    }

    @Override
    public void setContextClassLoader(ClassLoader loader) {
        CacheServiceProxy proxy;
        super.setContextClassLoader(loader);
        ConnectionAcceptor acceptor = this.getAcceptor();
        if (acceptor != null) {
            acceptor.setContextClassLoader(loader);
        }
        if ((proxy = this.getCacheServiceProxy()) != null) {
            proxy.setContextClassLoader(loader);
        }
    }

    protected void setInvocationServiceProxy(InvocationServiceProxy proxy) {
        ProxyService._assert(this.getInvocationServiceProxy() == null);
        this.__m_InvocationServiceProxy = proxy;
    }

    protected void setLoadBalancer(ProxyServiceLoadBalancer balancer) {
        ProxyService._assert(balancer != null);
        this.__m_LoadBalancer = balancer;
    }

    protected void setMemberListenAddresses(NavigableSet setMember) {
        this.__m_MemberListenAddresses = setMember;
    }

    public void setResolveAllAddresses(boolean fAddresses) {
        this.__m_ResolveAllAddresses = fAddresses;
    }

    protected void setServiceLoad(ServiceLoad load) {
        this.__m_ServiceLoad = load;
    }

    protected void setServiceLoadMap(Map map) {
        ProxyService._assert(map != null);
        this.__m_ServiceLoadMap = map;
    }

    protected void setServiceLoadPublished(ServiceLoad load) {
        this.__m_ServiceLoadPublished = load;
    }

    protected void setServiceLoadTimeMillis(long c) {
        this.__m_ServiceLoadTimeMillis = c;
    }

    public void updateLoadBalancer(Member member, ServiceLoad load, Connection connection) {
        ProxyServiceLoadBalancer balancer = this.getLoadBalancer();
        if (balancer != null) {
            Subject subject;
            if (load != null) {
                ServiceLoad loadService = new ServiceLoad();
                loadService.fromMap(load.toMap());
                load = loadService;
            }
            Subject subject2 = subject = connection instanceof TcpAcceptor.TcpConnection ? ((TcpAcceptor.TcpConnection)connection).getChannel(0).getSubject() : null;
            if (subject == null) {
                balancer.update(member, load);
            } else {
                LoadBalancerActionUpdate action = new LoadBalancerActionUpdate();
                action.setBalancer(balancer);
                action.setLoad(load);
                action.setmember(member);
                Subject.doAs(subject, action);
            }
        }
    }

    protected void updateServiceLoad() {
        ServiceLoad load = this.getServiceLoad();
        ServiceLoad loadLast = this.getServiceLoadPublished();
        ProxyServiceLoadBalancer balancer = this.getLoadBalancer();
        if (loadLast == null || (balancer == null ? load.compareTo(loadLast) : balancer.compare(load, loadLast)) != 0) {
            Map mapLoad = load.toMap();
            this.getThisMemberConfigMap().put("service-load", mapLoad);
            if (loadLast == null) {
                loadLast = new ServiceLoad();
                this.setServiceLoadPublished(loadLast);
            }
            loadLast.fromMap(mapLoad);
        }
        this.setServiceLoadTimeMillis(Base.getSafeTimeMillis());
    }

    @Override
    protected boolean validateServiceConfig(XmlElement xmlConfig) {
        ActionPolicy quorumPolicy = this.getActionPolicy();
        String sQuorumPolicy = quorumPolicy == null ? "none" : quorumPolicy.getClass().getName();
        String QUORUM_DEFAULT_LEGACY = "com.tangosol.net.ConfigurableQuorumPolicy$WrapperQuorumPolicy";
        String QUORUM_DEFAULT_12211 = "com.tangosol.util.NullImplementation$NullActionPolicy";
        String sQuorumGlobal = xmlConfig.getSafeAttribute("quorum-policy").getString();
        if ("com.tangosol.net.ConfigurableQuorumPolicy$WrapperQuorumPolicy".equals(sQuorumGlobal)) {
            sQuorumGlobal = "com.tangosol.util.NullImplementation$NullActionPolicy";
        }
        return super.validateServiceConfig(xmlConfig) && this.verifyFeature("QuorumPolicy", sQuorumPolicy, sQuorumGlobal);
    }

    static {
        ProxyService.__initStatic();
    }

    public static class LoadBalancerActionGetList
    extends Util
    implements PrivilegedAction {
        private ProxyServiceLoadBalancer __m_Balancer;
        private Connection __m_Connection;

        public LoadBalancerActionGetList() {
            this(null, null, true);
        }

        public LoadBalancerActionGetList(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new LoadBalancerActionGetList();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ProxyService$LoadBalancerActionGetList".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public ProxyServiceLoadBalancer getBalancer() {
            return this.__m_Balancer;
        }

        public Connection getConnection() {
            return this.__m_Connection;
        }

        public Object run() {
            Connection connection = this.getConnection();
            return connection instanceof TcpAcceptor.TcpConnection ? this.getBalancer().getMemberList(((TcpAcceptor.TcpConnection)connection).getMember()) : null;
        }

        public void setBalancer(ProxyServiceLoadBalancer balancer) {
            this.__m_Balancer = balancer;
        }

        public void setConnection(Connection connection) {
            this.__m_Connection = connection;
        }
    }

    public static class LoadBalancerActionUpdate
    extends Util
    implements PrivilegedAction {
        private ProxyServiceLoadBalancer __m_Balancer;
        private ProxyServiceLoad __m_Load;
        private Member __m_member;

        public LoadBalancerActionUpdate() {
            this(null, null, true);
        }

        public LoadBalancerActionUpdate(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new LoadBalancerActionUpdate();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ProxyService$LoadBalancerActionUpdate".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public ProxyServiceLoadBalancer getBalancer() {
            return this.__m_Balancer;
        }

        public ProxyServiceLoad getLoad() {
            return this.__m_Load;
        }

        public Member getmember() {
            return this.__m_member;
        }

        public Object run() {
            this.getBalancer().update(this.getmember(), this.getLoad());
            return null;
        }

        public void setBalancer(ProxyServiceLoadBalancer balancer) {
            this.__m_Balancer = balancer;
        }

        public void setLoad(ProxyServiceLoad load) {
            this.__m_Load = load;
        }

        public void setmember(Member member) {
            this.__m_member = member;
        }
    }

    public static class LookupCallback
    extends Util
    implements NameService.LookupCallback {
        public LookupCallback() {
            this(null, null, true);
        }

        public LookupCallback(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new LookupCallback();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ProxyService$LookupCallback".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public Object lookup(String sName, com.tangosol.net.Cluster cluster, NameService.RequestContext ctx) throws NamingException {
            String serviceName;
            Object result = null;
            ServiceInfo serviceInfo = (ServiceInfo)cluster.getServiceInfo(sName);
            if (serviceInfo != null && Base.equals(serviceInfo.getServiceType(), "Proxy")) {
                ServiceMemberSet memberSet = serviceInfo.getMemberSet();
                int nMemberIdRandom = memberSet.random();
                if (nMemberIdRandom != 0 && (result = ProxyService.getRoutableAddress(memberSet.getMember(nMemberIdRandom), memberSet.getMemberConfigMap(nMemberIdRandom), cluster, ctx)) == null) {
                    Iterator iter = memberSet.iterator();
                    while (iter.hasNext() && result == null) {
                        Member member = (Member)iter.next();
                        int nMemberID = member.getId();
                        if (nMemberID == nMemberIdRandom) continue;
                        result = ProxyService.getRoutableAddress(member, memberSet.getMemberConfigMap(nMemberID), cluster, ctx);
                    }
                }
            } else if (sName.endsWith("/addresses") && (serviceInfo = (ServiceInfo)cluster.getServiceInfo(serviceName = sName.split("/")[0])) != null && Base.equals(serviceInfo.getServiceType(), "Proxy")) {
                ServiceMemberSet memberSet = serviceInfo.getMemberSet();
                result = ProxyService.getRoutableMemberAddresses(memberSet, cluster, ctx);
            }
            return result;
        }
    }

    public static class NotifyConnectionClosed
    extends Message {
        private Connection __m_Connection;

        public NotifyConnectionClosed() {
            this(null, null, true);
        }

        public NotifyConnectionClosed(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(258);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyConnectionClosed();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ProxyService$NotifyConnectionClosed".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public Connection getConnection() {
            return this.__m_Connection;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ((ProxyService)this.getService()).onNotifyConnectionClosed(this);
        }

        public void setConnection(Connection connection) {
            this.__m_Connection = connection;
        }
    }

    public static class NotifyConnectionOpened
    extends Message {
        private Connection __m_Connection;

        public NotifyConnectionOpened() {
            this(null, null, true);
        }

        public NotifyConnectionOpened(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(257);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyConnectionOpened();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ProxyService$NotifyConnectionOpened".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public Connection getConnection() {
            return this.__m_Connection;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ((ProxyService)this.getService()).onNotifyConnectionOpened(this);
        }

        public void setConnection(Connection connection) {
            this.__m_Connection = connection;
        }
    }

    public static class RedirectRequest
    extends RequestMessage {
        private Connection __m_Connection;

        public RedirectRequest() {
            this(null, null, true);
        }

        public RedirectRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(259);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new RedirectRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ProxyService$RedirectRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public Connection getConnection() {
            return this.__m_Connection;
        }

        @Override
        protected Poll instantiatePoll() {
            return new Poll();
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ((ProxyService)this.getService()).onRedirectRequest(this);
        }

        public void setConnection(Connection connection) {
            this.__m_Connection = connection;
        }
    }

    public static class ServiceLoad
    extends com.tangosol.coherence.component.net.ServiceLoad
    implements ProxyServiceLoad {
        private ServiceLoadListener __m_Listener;

        public ServiceLoad() {
            this(null, null, true);
        }

        public ServiceLoad(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setConnectionFactor(-1);
                this.setDaemonFactor(-1);
                this.setMessageBacklogFactor(-1);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ServiceLoad();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ProxyService$ServiceLoad".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ServiceLoad) {
                return this.compareTo(obj) == 0;
            }
            return false;
        }

        public ServiceLoadListener getListener() {
            return this.__m_Listener;
        }

        public int hashCode() {
            return this.getConnectionFactor();
        }

        public void setListener(ServiceLoadListener listener) {
            this.__m_Listener = listener;
        }
    }

    public static class ServiceLoadListener
    extends com.tangosol.coherence.component.net.extend.Util
    implements MapListener {
        private Member __m_Member;

        public ServiceLoadListener() {
            this(null, null, true);
        }

        public ServiceLoadListener(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ServiceLoadListener();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ProxyService$ServiceLoadListener".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public void entryDeleted(MapEvent evt) {
            this.entryUpdated(evt);
        }

        public void entryInserted(MapEvent evt) {
            this.entryUpdated(evt);
        }

        public void entryUpdated(MapEvent evt) {
            if ("service-load".equals(evt.getKey())) {
                ProxyService module = (ProxyService)this.get_Module();
                Member member = this.getMember();
                ServiceLoad load = null;
                if (evt.getNewValue() instanceof Map && (load = (ServiceLoad)module.getServiceLoadMap().get(member)) != null) {
                    load.fromMap((Map)evt.getNewValue());
                }
                module.updateLoadBalancer(member, load, null);
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ServiceLoadListener) {
                ServiceLoadListener that = (ServiceLoadListener)obj;
                return Base.equals(this.getMember(), that.getMember());
            }
            return false;
        }

        public Member getMember() {
            return this.__m_Member;
        }

        public void setMember(Member member) {
            ServiceLoadListener._assert(member != null);
            this.__m_Member = member;
        }
    }
}

