/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.common.base.MutableLong;
import com.oracle.coherence.common.internal.Platform;
import com.oracle.coherence.common.net.exabus.EndPoint;
import com.oracle.coherence.common.util.CommonMonitor;
import com.oracle.coherence.common.util.Duration;
import com.oracle.coherence.common.util.MemorySize;
import com.oracle.coherence.persistence.ConcurrentAccessException;
import com.oracle.coherence.persistence.FatalAccessException;
import com.oracle.coherence.persistence.PersistenceEnvironment;
import com.oracle.coherence.persistence.PersistenceException;
import com.oracle.coherence.persistence.PersistenceManager;
import com.oracle.coherence.persistence.PersistentStore;
import com.oracle.coherence.persistence.PersistentStoreInfo;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.memberSet.ActualMemberSet;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.net.message.requestMessage.ChainedRequest;
import com.tangosol.coherence.component.net.message.requestMessage.DistributedCacheKeyRequest;
import com.tangosol.coherence.component.net.message.requestMessage.DistributedCacheRequest;
import com.tangosol.coherence.component.net.message.requestMessage.chainedRequest.BackupRequest;
import com.tangosol.coherence.component.net.message.requestMessage.chainedRequest.backupRequest.BackupMultiRequest;
import com.tangosol.coherence.component.net.message.requestMessage.chainedRequest.backupRequest.BackupSingleRequest;
import com.tangosol.coherence.component.util.Converter;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.DistributionStrategy;
import com.tangosol.coherence.component.util.PartialJob;
import com.tangosol.coherence.component.util.ServiceConfig;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.internal.net.service.DefaultServiceDependencies;
import com.tangosol.internal.net.service.grid.DefaultPartitionedServiceDependencies;
import com.tangosol.internal.net.service.grid.LegacyXmlPartitionedServiceHelper;
import com.tangosol.internal.net.service.grid.PartitionedServiceDependencies;
import com.tangosol.internal.net.service.grid.PersistenceDependencies;
import com.tangosol.internal.tracing.Span;
import com.tangosol.internal.tracing.TracingHelper;
import com.tangosol.internal.util.AtomicsHelper;
import com.tangosol.internal.util.OwnershipConflictResolver;
import com.tangosol.internal.util.VersionHelper;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.pof.ConfigurablePofContext;
import com.tangosol.license.CoherenceCommunityEdition;
import com.tangosol.license.LicenseException;
import com.tangosol.net.ActionPolicy;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.Guardable;
import com.tangosol.net.Guardian;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.PriorityTask;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.internal.CopyOnWriteLongList;
import com.tangosol.net.internal.PartitionRecoverInfo;
import com.tangosol.net.internal.PartitionVersionExclusionList;
import com.tangosol.net.internal.PartitionVersions;
import com.tangosol.net.internal.QuorumInfo;
import com.tangosol.net.management.AnnotatedStandardEmitterMBean;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.net.management.Registry;
import com.tangosol.net.partition.DefaultKeyPartitioningStrategy;
import com.tangosol.net.partition.DistributionManager;
import com.tangosol.net.partition.KeyAssociator;
import com.tangosol.net.partition.KeyPartitioningStrategy;
import com.tangosol.net.partition.Ownership;
import com.tangosol.net.partition.PartitionAssignmentStrategy;
import com.tangosol.net.partition.PartitionEvent;
import com.tangosol.net.partition.PartitionListener;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.net.partition.PartitionStatistics;
import com.tangosol.net.partition.SimpleAssignmentStrategy;
import com.tangosol.net.partition.VersionedOwnership;
import com.tangosol.persistence.AbstractPersistenceEnvironment;
import com.tangosol.persistence.CachePersistenceHelper;
import com.tangosol.persistence.GUIDHelper;
import com.tangosol.persistence.PersistenceManagerMBean;
import com.tangosol.persistence.SafePersistenceWrappers;
import com.tangosol.persistence.Snapshot;
import com.tangosol.persistence.SnapshotArchiver;
import com.tangosol.persistence.SnapshotArchiverFactory;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.CopyOnWriteLongArray;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.Gate;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.LiteMap;
import com.tangosol.util.LiteSet;
import com.tangosol.util.LongArray;
import com.tangosol.util.MapEvent;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.PrimitiveSparseArray;
import com.tangosol.util.SparseArray;
import com.tangosol.util.ThreadGate;
import com.tangosol.util.ThreadGateLite;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;

public abstract class PartitionedService
extends Grid
implements com.tangosol.net.PartitionedService {
    private boolean __m_AsyncBackup;
    private long __m_AsyncBackupInterval;
    public static final int BACKUP_STRENGTH_ENDANGERED = 1;
    public static final int BACKUP_STRENGTH_MACHINE = 3;
    public static final int BACKUP_STRENGTH_NODE = 2;
    public static final int BACKUP_STRENGTH_ORPHANED = 0;
    public static final int BACKUP_STRENGTH_RACK = 4;
    public static final int BACKUP_STRENGTH_SITE = 5;
    private int __m_BackupCount;
    private boolean __m_Concurrent;
    public static final int CONFIG_MAP_PARTITION = 2;
    private transient KeyAssociator __m_ConfiguredKeyAssociator;
    private transient KeyPartitioningStrategy __m_ConfiguredKeyPartitioningStrategy;
    private Continuations __m_Continuations;
    private long __m_DeferredBackupTimeoutMillis;
    private int __m_DistributionAggressiveness;
    private volatile transient long __m_DistributionNextMillis;
    private int __m_DistributionRepeatMillis;
    private boolean __m_DistributionStable;
    private CentralDistribution __m_DistributionStrategy;
    private boolean __m_DistributionSynchronized;
    private boolean __m_Finalizing;
    private transient KeyAssociator __m_KeyAssociator;
    private transient KeyPartitioningStrategy __m_KeyPartitioningStrategy;
    private ConverterKeyToBinary __m_KeyToBinaryConverter;
    public static final int MAX_PENDING_BACKUP_POLL = 100;
    private long __m_MaxContendMillis;
    private int __m_MaxLockAttempt;
    private transient String __m_MsgCAE;
    public static final int OWNERSHIP_DISABLED = 1;
    public static final int OWNERSHIP_ENABLED = 4;
    public static final int OWNERSHIP_PENDING = 2;
    public static final int OWNERSHIP_UNKNOWN = 0;
    private boolean __m_OwnershipEnabled;
    private transient int __m_OwnershipInProgress;
    private int[] __m_OwnershipVersion;
    private volatile int[][] __m_PartitionAssignments;
    private PartitionConfig.Map __m_PartitionConfigMap;
    private transient Contention[] __m_PartitionContention;
    private transient PartitionControl[] __m_PartitionControl;
    private int __m_PartitionCount;
    private Map __m_PartitionEvents;
    private Listeners __m_PartitionListeners;
    private int __m_PartitionTraceEvents;
    private PersistenceControl __m_PersistenceControl;
    private PersistenceDependencies __m_PersistenceDependencies;
    private transient ThreadGate __m_PreprocessingGate;
    private String __m_RemainsOwnershipReport;
    private transient boolean __m_RestoreInProgress;
    private AtomicLong __m_ScratchSpaceCounter;
    private ThreadLocal __m_TLORecoveryThread;
    private TransferControl __m_TransferControl;
    private int __m_TransferThreshold;
    private static ListMap __mapChildren;
    protected static final int MAINTENANCE_INTERVAL = 120000;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Acknowledgement", Grid.Acknowledgement.get_CLASS());
        __mapChildren.put("BackupAssignment", BackupAssignment.get_CLASS());
        __mapChildren.put("BackupConfirmRequest", BackupConfirmRequest.get_CLASS());
        __mapChildren.put("BusEventMessage", Grid.BusEventMessage.get_CLASS());
        __mapChildren.put("CentralDistribution", CentralDistribution.get_CLASS());
        __mapChildren.put("ConfigRequest", Grid.ConfigRequest.get_CLASS());
        __mapChildren.put("ConfigResponse", Grid.ConfigResponse.get_CLASS());
        __mapChildren.put("ConfigSync", Grid.ConfigSync.get_CLASS());
        __mapChildren.put("ConfigUpdate", Grid.ConfigUpdate.get_CLASS());
        __mapChildren.put("Contention", Contention.get_CLASS());
        __mapChildren.put("ConverterKeyToBinary", ConverterKeyToBinary.get_CLASS());
        __mapChildren.put("DispatchEvent", DispatchEvent.get_CLASS());
        __mapChildren.put("DispatchNotification", Grid.DispatchNotification.get_CLASS());
        __mapChildren.put("DistributionPlanUpdate", DistributionPlanUpdate.get_CLASS());
        __mapChildren.put("DistributionRequest", DistributionRequest.get_CLASS());
        __mapChildren.put("MemberConfigUpdate", MemberConfigUpdate.get_CLASS());
        __mapChildren.put("MemberJoined", Grid.MemberJoined.get_CLASS());
        __mapChildren.put("MemberRecovered", Grid.MemberRecovered.get_CLASS());
        __mapChildren.put("MemberWelcome", MemberWelcome.get_CLASS());
        __mapChildren.put("MemberWelcomeRequest", MemberWelcomeRequest.get_CLASS());
        __mapChildren.put("MemberWelcomeRequestTask", Grid.MemberWelcomeRequestTask.get_CLASS());
        __mapChildren.put("NotifyConnectionClose", Grid.NotifyConnectionClose.get_CLASS());
        __mapChildren.put("NotifyConnectionOpen", Grid.NotifyConnectionOpen.get_CLASS());
        __mapChildren.put("NotifyMemberJoined", Grid.NotifyMemberJoined.get_CLASS());
        __mapChildren.put("NotifyMemberLeaving", Grid.NotifyMemberLeaving.get_CLASS());
        __mapChildren.put("NotifyMemberLeft", Grid.NotifyMemberLeft.get_CLASS());
        __mapChildren.put("NotifyMessageReceipt", Grid.NotifyMessageReceipt.get_CLASS());
        __mapChildren.put("NotifyPollClosed", Grid.NotifyPollClosed.get_CLASS());
        __mapChildren.put("NotifyResponse", Grid.NotifyResponse.get_CLASS());
        __mapChildren.put("NotifyServiceAnnounced", Grid.NotifyServiceAnnounced.get_CLASS());
        __mapChildren.put("NotifyServiceJoining", Grid.NotifyServiceJoining.get_CLASS());
        __mapChildren.put("NotifyServiceLeaving", NotifyServiceLeaving.get_CLASS());
        __mapChildren.put("NotifyServiceLeft", Grid.NotifyServiceLeft.get_CLASS());
        __mapChildren.put("NotifyServiceQuiescence", NotifyServiceQuiescence.get_CLASS());
        __mapChildren.put("NotifyShutdown", NotifyShutdown.get_CLASS());
        __mapChildren.put("NotifySnapshotRecoverRequest", NotifySnapshotRecoverRequest.get_CLASS());
        __mapChildren.put("NotifyStartup", Grid.NotifyStartup.get_CLASS());
        __mapChildren.put("OwnershipRequest", OwnershipRequest.get_CLASS());
        __mapChildren.put("OwnershipResponse", OwnershipResponse.get_CLASS());
        __mapChildren.put("PartitionAbandonRequest", PartitionAbandonRequest.get_CLASS());
        __mapChildren.put("PartitionControl", PartitionControl.get_CLASS());
        __mapChildren.put("PartitionFilter", PartitionFilter.get_CLASS());
        __mapChildren.put("PartitionRecoverCleanup", PartitionRecoverCleanup.get_CLASS());
        __mapChildren.put("PartitionRecoverRequest", PartitionRecoverRequest.get_CLASS());
        __mapChildren.put("PartitionStatsUpdate", PartitionStatsUpdate.get_CLASS());
        __mapChildren.put("PartitionSwapRequest", PartitionSwapRequest.get_CLASS());
        __mapChildren.put("PartitionVersionSyncRequest", PartitionVersionSyncRequest.get_CLASS());
        __mapChildren.put("PersistenceControl", PersistenceControl.get_CLASS());
        __mapChildren.put("PingRequest", Grid.PingRequest.get_CLASS());
        __mapChildren.put("PinningIterator", PinningIterator.get_CLASS());
        __mapChildren.put("ProtocolContext", Grid.ProtocolContext.get_CLASS());
        __mapChildren.put("Response", Grid.Response.get_CLASS());
        __mapChildren.put("SnapshotArchiveRequest", SnapshotArchiveRequest.get_CLASS());
        __mapChildren.put("SnapshotListRequest", SnapshotListRequest.get_CLASS());
        __mapChildren.put("SnapshotRequest", SnapshotRequest.get_CLASS());
        __mapChildren.put("TransferRequest", TransferRequest.get_CLASS());
        __mapChildren.put("TransferResponse", TransferResponse.get_CLASS());
        __mapChildren.put("WrapperGuardable", Grid.WrapperGuardable.get_CLASS());
    }

    public PartitionedService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_PreprocessingGate = new ThreadGate();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void abandonPartitions(PartitionSet parts) {
        int cBackups = this.getBackupCount();
        int nMemberThis = this.getThisMember().getId();
        LiteMap<Integer, VersionedOwnership> mapUpdate = new LiteMap<Integer, VersionedOwnership>();
        PartitionedService._trace("Abandoning the ownership of partitions " + String.valueOf(parts), 3);
        int iPart = parts.next(0);
        while (iPart >= 0) {
            int iStore = this.getOwnedIndex(iPart, nMemberThis);
            if (iStore >= 0) {
                if (iStore == 0) {
                    PartitionControl ctrlPart = this.getPartitionControl(iPart);
                    ctrlPart.lock(-1L, 3);
                    try {
                        ctrlPart.setTransferState(2);
                        this.assignPartitionOwner(iPart, iStore, 0);
                        this.releasePartition(iPart, iStore);
                    }
                    finally {
                        ctrlPart.setTransferState(0);
                        ctrlPart.unlock();
                        mapUpdate.put(iPart, new VersionedOwnership(cBackups, this.incrementOwnershipVersion(iPart)));
                    }
                } else {
                    this.assignPartitionOwner(iPart, iStore, 0);
                    this.releasePartition(iPart, iStore);
                }
                this.releasePartitionControl(iPart);
            } else {
                PartitionedService._trace("Ignoring PartitionAbandonRequest for un-owned partition " + iPart, 2);
            }
            iPart = parts.next(iPart + 1);
        }
        this.getDistributionStrategy().clearAdvice(parts);
        if (mapUpdate != null && !mapUpdate.isEmpty()) {
            this.putPartitionConfig(mapUpdate);
        }
    }

    @Override
    public void addPartitionListener(PartitionListener listener) {
        this.getPartitionListeners().add(listener);
    }

    protected void assignOrphan(int iPartition) {
        PartitionControl ctrl = this.ensurePartitionControl(iPartition);
        if (this.isActivePersistence()) {
            PersistentStore store = ctrl.ensurePersistentStore();
            this.saveQuorum(iPartition);
            if (!this.isExiting() && this.getServiceState() != 3) {
                PersistentStore storeEvents = ctrl.getPersistentEventsStore();
                if (storeEvents != null) {
                    CachePersistenceHelper.seal(storeEvents, this, null);
                }
                CachePersistenceHelper.seal(ctrl.ensurePersistentStore(), this, null);
            }
        }
        this.handlePartitionTrace(iPartition, PartitionControl.getPartitionEventDescription(10));
    }

    public void assignOrphans(PartitionSet parts, Message msgResponse) {
        int[][] aaiOwner = this.getPartitionAssignments();
        int cPartitions = aaiOwner.length;
        LiteMap<Integer, VersionedOwnership> mapUpdate = new LiteMap<Integer, VersionedOwnership>();
        PartitionSet partsAssigned = null;
        PartitionSet partsLost = null;
        boolean fActive = this.isActivePersistence();
        PartitionConfig.Map mapConfig = this.getPartitionConfigMap();
        int iPartition = parts.next(0);
        int c = 0;
        while (iPartition >= 0 && !this.isExiting() && this.getServiceState() != 3) {
            int nOwner = aaiOwner[iPartition][0];
            if (nOwner == 0) {
                VersionedOwnership owners = this.assignPrimaryPartition(iPartition, 'r');
                mapUpdate.put(iPartition, owners);
                this.assignOrphan(iPartition);
                if (fActive && (c++ & 0xF) == 15) {
                    this.heartbeat();
                }
                if (mapConfig.isAssignmentCompleted(iPartition)) {
                    if (partsLost == null) {
                        partsLost = new PartitionSet(cPartitions);
                    }
                    partsLost.add(iPartition);
                } else {
                    if (partsAssigned == null) {
                        partsAssigned = new PartitionSet(cPartitions);
                    }
                    partsAssigned.add(iPartition);
                }
            } else {
                PartitionedService._trace("Unable to assign orphaned partition " + iPartition + "; current owner is member " + nOwner, 2);
            }
            iPartition = parts.next(iPartition + 1);
        }
        if (partsLost != null) {
            PartitionedService._trace("Assigned " + partsLost.cardinality() + " orphaned primary partitions: " + String.valueOf(partsLost), 2);
            this.firePartitionEvent(1, partsLost, null, this.getThisMember());
        }
        if (partsAssigned != null) {
            this.firePartitionEvent(7, partsAssigned, null, this.getThisMember());
        }
        this.onPartitionsAssigned(partsAssigned, partsLost, this.getContinuations().instantiateFinalizeAssignPrimaries(mapUpdate, msgResponse));
    }

    protected int[][] assignPartitionOwner(int iPartition, int iStore, int nMember) {
        int[][] aaiOwner = this.getPartitionAssignments();
        int[] aiOwner = aaiOwner[iPartition];
        if (iStore == 0) {
            aaiOwner = (int[][])aaiOwner.clone();
            aiOwner = (int[])aiOwner.clone();
            aaiOwner[iPartition] = aiOwner;
        }
        aiOwner[iStore] = nMember;
        this.setPartitionAssignments(aaiOwner);
        return aaiOwner;
    }

    protected void assignPartitionOwners(int iPartition, int[] aiOwnerThat) {
        int[][] aaiOwner = this.getPartitionAssignments();
        int[] aiOwnerThis = aaiOwner[iPartition];
        ServiceMemberSet setService = this.getServiceMemberSet();
        int c = aiOwnerThis.length;
        for (int i = 0; i < c; ++i) {
            int nOwnerThat = aiOwnerThat[i];
            if (aiOwnerThis[i] == nOwnerThat) continue;
            if (i == 0) {
                aaiOwner = (int[][])aaiOwner.clone();
            }
            if (setService.contains(nOwnerThat)) continue;
            aiOwnerThat[i] = 0;
        }
        aaiOwner[iPartition] = aiOwnerThat;
        this.setPartitionAssignments(aaiOwner);
    }

    protected VersionedOwnership assignPrimaryPartition(int iPartition, char chBackupOp) {
        Member memberThis = this.getThisMember();
        int nMemberThis = memberThis.getId();
        int nMachineThis = memberThis.getMachineId();
        int[][] aaiOwner = this.getPartitionAssignments();
        int cBackups = this.getBackupCount();
        if (cBackups > 0) {
            int[] aiOwner = aaiOwner[iPartition];
            ServiceMemberSet setMember = this.getServiceMemberSet();
            int nPrimeOwner = aiOwner[0];
            if (nPrimeOwner == nMemberThis || !setMember.contains(nPrimeOwner) || setMember.isServiceLeaving(nPrimeOwner)) {
                nPrimeOwner = 0;
            }
            int iBackupSwap = 0;
            for (int iBackup = 1; iBackup <= cBackups; ++iBackup) {
                int nBackupOwner = aiOwner[iBackup];
                if (nBackupOwner == nMemberThis) {
                    if (chBackupOp != 'm') {
                        this.releasePartition(iPartition, iBackup);
                    }
                    iBackupSwap = iBackup;
                    continue;
                }
                if (iBackupSwap != 0 || setMember.contains(nBackupOwner)) continue;
                iBackupSwap = iBackup;
            }
            if (iBackupSwap > 0) {
                aiOwner = (int[])aiOwner.clone();
                aiOwner[iBackupSwap] = nPrimeOwner;
                aaiOwner[iPartition] = aiOwner;
            }
        }
        this.preparePartition(iPartition, 0);
        int nVersionNew = this.incrementOwnershipVersion(iPartition);
        aaiOwner = this.assignPartitionOwner(iPartition, 0, nMemberThis);
        VersionedOwnership owners = new VersionedOwnership(cBackups, nVersionNew);
        owners.setOwners(aaiOwner[iPartition]);
        return owners;
    }

    public int calculateEndangered() {
        int[][] aaiOwner = this.getPartitionAssignments();
        int cPartitions = aaiOwner.length;
        int cBackups = this.getBackupCount();
        if (cBackups == 0) {
            return cPartitions;
        }
        int cEndangered = 0;
        block0: for (int iPartition = 0; iPartition < cPartitions; ++iPartition) {
            int[] aiOwner = aaiOwner[iPartition];
            for (int iBackup = 1; iBackup <= cBackups; ++iBackup) {
                if (aiOwner[iBackup] != 0) continue;
                ++cEndangered;
                continue block0;
            }
        }
        return cEndangered;
    }

    public int calculateEndangeredMembers() {
        int[][] aaiOwner = this.getPartitionAssignments();
        int cPartitions = aaiOwner.length;
        int cBackups = this.getBackupCount();
        HashSet<Integer> setId = new HashSet<Integer>();
        for (int iPartition = 0; iPartition < cPartitions; ++iPartition) {
            int[] aiOwner = aaiOwner[iPartition];
            for (int iBackup = 1; iBackup <= cBackups; ++iBackup) {
                if (aiOwner[iBackup] != 0) continue;
                setId.add(aiOwner[0]);
            }
        }
        return setId.size();
    }

    public int[] calculateOwnership(MemberSet setOwners, boolean fPrimary) {
        if (setOwners == null) {
            setOwners = this.getOwnershipMemberSet();
        }
        int[][] aaiOwner = this.getPartitionAssignments();
        int cPartitions = aaiOwner.length;
        int nMaxMember = setOwners.getLastId();
        int[] acPartitions = new int[nMaxMember + 1];
        if (fPrimary) {
            for (int iPartition = 0; iPartition < cPartitions; ++iPartition) {
                int nMemberOwner = aaiOwner[iPartition][0];
                if (nMemberOwner > nMaxMember) continue;
                int n = nMemberOwner;
                acPartitions[n] = acPartitions[n] + 1;
            }
        } else {
            int cBackups = this.getBackupCount();
            for (int iPartition = 0; iPartition < cPartitions; ++iPartition) {
                int[] aiOwner = aaiOwner[iPartition];
                for (int iBackup = 1; iBackup <= cBackups; ++iBackup) {
                    int nMemberOwner = aiOwner[iBackup];
                    if (nMemberOwner > nMaxMember) continue;
                    int n = nMemberOwner;
                    acPartitions[n] = acPartitions[n] + 1;
                }
            }
        }
        return acPartitions;
    }

    public void calculateOwnershipConflicts(int nMemberThat, int[][] aaiOwnerThat, int cAttempts) {
        int nMemberThis = this.getThisMember().getId();
        int[][] aaiOwnerThis = this.getPartitionAssignments();
        int cBackups = this.getBackupCount();
        String sSubstToken = "{partitions}";
        HashMap<CallSite, PartitionSet> mapLogMsgs = null;
        int cPartitions = aaiOwnerThis.length;
        for (int iPartition = 0; iPartition < cPartitions; ++iPartition) {
            int[] aiOwnerThis = aaiOwnerThis[iPartition];
            int[] aiOwnerThat = aaiOwnerThat[iPartition];
            for (int iStore = 0; iStore <= cBackups; ++iStore) {
                PartitionSet parts;
                int nOwnerThis = aiOwnerThis[iStore];
                int nOwnerThat = aiOwnerThat[iStore];
                if (nOwnerThis == nOwnerThat) continue;
                String sLogTemplate = null;
                if (iStore == 0 && (nOwnerThat == nMemberThis && nOwnerThis == 0 || nOwnerThis == nMemberThis && nOwnerThat == 0)) {
                    sLogTemplate = "Re-publishing the ownership for " + sSubstToken + " [" + nOwnerThis + "]";
                    this.publishPartitionOwnership(iPartition, iStore, nOwnerThis);
                }
                if (cAttempts > 4) {
                    int nOwnerGlobal = this.getPartitionConfig(iPartition).getOwner(iStore);
                    sLogTemplate = cAttempts + "> Ownership conflict for " + sSubstToken + (String)(iStore == 0 ? "(primary)" : "(backup[" + iStore + "])") + " with member " + nMemberThat + " (" + nOwnerThis + "!=" + nOwnerThat + (String)(nOwnerGlobal == nOwnerThis ? "" : "; global=" + nOwnerGlobal) + ")";
                    if ((nOwnerThis == nMemberThis || nOwnerThat == nMemberThis) && nOwnerThat > 0) {
                        if (nMemberThis == Math.min(nOwnerThis, nOwnerThat)) {
                            this.publishPartitionOwnership(iPartition, iStore, nOwnerThis);
                        } else {
                            PartitionedService._trace("Unreconcilable ownership conflict; conceding the ownership.", 1);
                            this.assignPartitionOwner(iPartition, iStore, 0);
                            if (nOwnerThis == nMemberThis) {
                                this.releasePartition(iPartition, iStore);
                                this.releasePartitionControl(iPartition);
                            }
                            this.publishPartitionOwnership(iPartition, iStore, 0);
                        }
                    } else if (iStore == 0 && nMemberThis != this.getOwnershipSenior().getId()) {
                        PartitionedService._trace("Multi-way ownership conflict; requesting a republish of the ownership", 1);
                        this.assignPartitionOwner(iPartition, 0, 0);
                        this.publishPartitionOwnership(iPartition, 0, 0);
                    }
                }
                if (sLogTemplate == null) continue;
                if (mapLogMsgs == null) {
                    mapLogMsgs = new HashMap<CallSite, PartitionSet>();
                }
                if ((parts = (PartitionSet)mapLogMsgs.get(sLogTemplate)) == null) {
                    parts = new PartitionSet(cPartitions);
                    mapLogMsgs.put((CallSite)((Object)sLogTemplate), parts);
                }
                parts.add(iPartition);
            }
        }
        if (mapLogMsgs != null) {
            for (Map.Entry entry : mapLogMsgs.entrySet()) {
                String sLogTemplate = (String)entry.getKey();
                int ofStart = sLogTemplate.indexOf(sSubstToken);
                int ofEnd = ofStart + sSubstToken.length();
                PartitionedService._trace(sLogTemplate.substring(0, ofStart) + String.valueOf(entry.getValue()) + sLogTemplate.substring(ofEnd, sLogTemplate.length()), 2);
            }
        }
    }

    public PartitionSet calculatePartitionSet(com.tangosol.net.Member member, int iStore) {
        return this.calculatePartitionSet(member, iStore, false);
    }

    public PartitionSet calculatePartitionSet(com.tangosol.net.Member member, int iStore, boolean fCheckLocked) {
        PartitionedService._assert(iStore <= this.getBackupCount());
        int[][] aaiOwner = this.getPartitionAssignments();
        int cPartitions = aaiOwner.length;
        int nMember = member == null ? 0 : member.getId();
        PartitionSet partitions = new PartitionSet(cPartitions);
        for (int iPartition = 0; iPartition < cPartitions; ++iPartition) {
            if (aaiOwner[iPartition][iStore] != nMember || fCheckLocked && this.getPartitionControl(iPartition).isLocked()) continue;
            partitions.add(iPartition);
        }
        return partitions;
    }

    public PartitionSet calculatePartitionSet(Set setKeys) {
        PartitionSet partitions = new PartitionSet(this.getPartitionCount());
        Iterator iter = setKeys.iterator();
        while (iter.hasNext()) {
            partitions.add(this.getKeyPartition((Binary)iter.next()));
        }
        return partitions;
    }

    public int calculateThisOwnership(boolean fPrimary) {
        int nMemberThis = this.getThisMember().getId();
        int[][] aaiOwner = this.getPartitionAssignments();
        int cPartitionsTotal = aaiOwner.length;
        int cPartitionsThis = 0;
        if (fPrimary) {
            for (int iPartition = 0; iPartition < cPartitionsTotal; ++iPartition) {
                if (aaiOwner[iPartition][0] != nMemberThis) continue;
                ++cPartitionsThis;
            }
        } else {
            int cBackups = this.getBackupCount();
            for (int iPartition = 0; iPartition < cPartitionsTotal; ++iPartition) {
                int[] aiOwner = aaiOwner[iPartition];
                for (int iBackup = 1; iBackup <= cBackups; ++iBackup) {
                    if (aiOwner[iBackup] != nMemberThis) continue;
                    ++cPartitionsThis;
                }
            }
        }
        return cPartitionsThis;
    }

    public int calculateUnbalanced() {
        int cBuckets = this.getPartitionCount();
        int cBackups = this.getBackupCount();
        int cMembers = this.getOwnershipMemberSet().size();
        if (cMembers == 0) {
            return cBuckets * (cBackups + 1);
        }
        int[] acBucket = this.calculateOwnership(null, true);
        int cUnbalanced = acBucket[0];
        if (cMembers == 1) {
            return cUnbalanced;
        }
        if (cMembers == 2) {
            VersionedOwnership owners = this.getPartitionConfig(0);
            ServiceMemberSet setMembers = this.getServiceMemberSet();
            Member memberPrime = ((MemberSet)setMembers).getMember(owners.getPrimaryOwner());
            if (memberPrime != null && this.calculatePartitionSet(memberPrime, 0).isFull()) {
                if (cBackups == 0) {
                    return 0;
                }
                Member memberBackup = ((MemberSet)setMembers).getMember(owners.getOwner(1));
                if (memberBackup != null && this.calculatePartitionSet(memberBackup, 1).isFull()) {
                    return 0;
                }
            }
        }
        int cFairShare = Math.min(cBuckets / cMembers + 1, cBuckets);
        int c = acBucket.length;
        for (int i = 1; i < c; ++i) {
            cUnbalanced += Math.max(0, acBucket[i] - cFairShare);
        }
        if ((cBuckets *= cBackups) > 0) {
            cFairShare = Math.min(cBuckets / cMembers + 1, cBuckets);
            acBucket = this.calculateOwnership(null, false);
            cUnbalanced += acBucket[0];
            boolean fForgive = cBackups > 1;
            int c2 = acBucket.length;
            for (int i = 1; i < c2; ++i) {
                int cOverload = Math.max(0, acBucket[i] - cFairShare);
                cUnbalanced += fForgive && (double)cOverload < (double)cFairShare * 0.1 ? 0 : cOverload;
            }
        }
        return Math.min(cUnbalanced, cBuckets);
    }

    public int calculateVulnerable() {
        return this.calculateVulnerable(true);
    }

    public int calculateVulnerable(boolean fStrict) {
        int cPartitions = this.getPartitionCount();
        if (this.getBackupCount() == 0) {
            return cPartitions;
        }
        int cVulnerable = 0;
        for (int iPartition = 0; iPartition < cPartitions; ++iPartition) {
            if (!this.isPartitionVulnerable(iPartition, fStrict)) continue;
            ++cVulnerable;
        }
        return cVulnerable;
    }

    public boolean checkDeferredDistribution() {
        CentralDistribution strategy = this.getDistributionStrategy();
        if (this.isDistributionInProgress() || this.isOwnershipChangeInProgress() || this.isRecoveryInProgress() || this.isRestoreInProgress()) {
            strategy.reportLateDistributions();
            return true;
        }
        strategy.setDistributionsPendingStart(0L);
        strategy.setWarningNextMillis(0L);
        int cPending = this.getPartitionConfigMap().getPendingConfigRequestCount();
        if (this.isDistributionSynchronized() && cPending > 0) {
            PartitionedService._trace("Deferring the distribution due to " + cPending + " pending configuration updates", 3);
            return true;
        }
        return false;
    }

    protected void checkDistribution() {
        this.setDistributionNextMillis(Base.getSafeTimeMillis() + (long)this.getDistributionRepeatMillis());
        if (this.checkDeferredDistribution()) {
            this.setDistributionStable(false);
            return;
        }
        MemberSet setOwners = this.getOwnershipMemberSet();
        MemberSet setOthers = this.getOwnershipOtherMemberSet(setOwners);
        Set setLeaving = this.getOwnershipLeavingMembers(setOwners);
        if (this.getServiceState() == 3) {
            PartitionSet partsPrimary = this.collectOwnedPartitions(true);
            PartitionSet partsBackup = this.collectOwnedPartitions(false);
            int cRemainPrimary = partsPrimary.cardinality();
            int cRemainBackup = partsBackup.cardinality();
            if (cRemainPrimary == 0 && cRemainBackup == 0) {
                this.stop();
            } else if (setLeaving.size() == 1 + setOthers.size()) {
                this.stop();
            } else if (!this.isDistributionAllowed() || !this.isRestorePartitionAllowed()) {
                this.stop();
            } else {
                String sRemains;
                PartitionedService._trace("Remains to transfer before shutting down: " + cRemainPrimary + " primary partitions, " + cRemainBackup + " backup partitions", 3);
                String sRemainsPrev = this.getRemainsOwnershipReport();
                if (sRemainsPrev == null) {
                    sRemains = "";
                } else {
                    sRemains = this.reportOwnership(this.getThisMember().getId(), true);
                    if (!Base.equals(sRemainsPrev, sRemains)) {
                        PartitionedService._trace(sRemains, 5);
                    }
                }
                this.setRemainsOwnershipReport(sRemains);
            }
            return;
        }
        PartitionedService._assert(this.isOwnershipEnabled());
        int cOrphans = this.calculateOwnership(setOwners, true)[0];
        if (cOrphans > 0) {
            if (this.isRestorePartitionAllowed() && this.getThisMember() == this.getOwnershipSenior() && this.getOwnershipInProgress() <= 0) {
                this.doOwnershipProtocol(setOwners, null);
            }
            this.setDistributionStable(false);
            return;
        }
        this.setOwnershipInProgress(0);
        this.getDistributionStrategy().checkDistribution(setOwners, setLeaving);
        if (this.isDistributionInProgress() || this.isOwnershipChangeInProgress() || !this.isAllAllowed() || this.calculateUnbalanced() > 0) {
            this.setDistributionStable(false);
        } else if (!this.isDistributionStable()) {
            this.onOwnershipStable();
            this.setDistributionStable(true);
        }
    }

    public boolean checkLockRequired() {
        return this.isActivePersistence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearContention(int iPartition) {
        Contention contention;
        CommonMonitor oMonitor;
        Contention[] aContention = this.getPartitionContention();
        CommonMonitor commonMonitor = oMonitor = Base.getCommonMonitor(System.identityHashCode(aContention) + iPartition);
        synchronized (commonMonitor) {
            contention = aContention[iPartition];
            if (contention != null) {
                aContention[iPartition] = null;
            }
        }
        if (contention != null) {
            contention.clear();
        }
    }

    public void clearContention(PartitionSet partitions) {
        int iPartition = partitions.next(0);
        while (iPartition >= 0) {
            this.clearContention(iPartition);
            iPartition = partitions.next(iPartition + 1);
        }
    }

    @Override
    protected DefaultServiceDependencies cloneDependencies(ServiceDependencies deps) {
        return new DefaultPartitionedServiceDependencies((PartitionedServiceDependencies)deps);
    }

    public PartitionSet collectEndangeredPartitions(int iBackup) {
        int[][] aaiOwner = this.getPartitionAssignments();
        int cPartitions = aaiOwner.length;
        int nMemberThis = this.getThisMember().getId();
        PartitionSet setEndangered = new PartitionSet(cPartitions);
        for (int iPartition = 0; iPartition < cPartitions; ++iPartition) {
            if (aaiOwner[iPartition][0] != nMemberThis || aaiOwner[iPartition][iBackup] != 0) continue;
            setEndangered.add(iPartition);
        }
        return setEndangered;
    }

    public PartitionSet collectOrphanPartitions() {
        int[][] aaiOwner = this.getPartitionAssignments();
        int cPartitions = aaiOwner.length;
        PartitionSet parts = new PartitionSet(cPartitions);
        for (int iPartition = 0; iPartition < cPartitions; ++iPartition) {
            if (aaiOwner[iPartition][0] != 0) continue;
            parts.add(iPartition);
        }
        return parts;
    }

    public PartitionSet collectOwnedPartitions(boolean fPrimary) {
        Member memberThis = this.getThisMember();
        if (fPrimary) {
            return this.calculatePartitionSet(memberThis, 0);
        }
        int cBackups = this.getBackupCount();
        if (cBackups == 0) {
            return new PartitionSet(this.getPartitionCount());
        }
        PartitionSet setOwned = this.calculatePartitionSet(memberThis, 1);
        if (cBackups > 1) {
            for (int iStore = 2; iStore <= cBackups; ++iStore) {
                setOwned.add(this.calculatePartitionSet(memberThis, iStore));
            }
        }
        return setOwned;
    }

    public PartitionVersions collectOwnershipVersions(PartitionSet parts) {
        int[] anVersions = new int[parts.cardinality()];
        int iVersion = 0;
        int iPart = parts.next(0);
        while (iPart >= 0) {
            anVersions[iVersion++] = this.getOwnershipVersion(iPart);
            iPart = parts.next(iPart + 1);
        }
        return new PartitionVersions(parts, anVersions);
    }

    public PartitionSet collectVulnerablePartitions() {
        return this.collectVulnerablePartitions(false);
    }

    public PartitionSet collectVulnerablePartitions(boolean fStrict) {
        int[][] aaiOwner = this.getPartitionAssignments();
        int cPartitions = aaiOwner.length;
        int nMemberThis = this.getThisMember().getId();
        PartitionSet partsVulnerable = new PartitionSet(cPartitions);
        for (int iPartition = 0; iPartition < cPartitions; ++iPartition) {
            if (aaiOwner[iPartition][0] != nMemberThis || !this.isPartitionVulnerable(iPartition, fStrict)) continue;
            partsVulnerable.add(iPartition);
        }
        return partsVulnerable;
    }

    @Override
    public int compareImportance(Member memberThat) {
        if (!this.isAcceptingClients()) {
            return -1;
        }
        boolean fThisOwnership = this.isOwnershipEnabled();
        boolean fThatOwnership = this.isOwnershipEnabled(memberThat);
        int iResult = super.compareImportance(memberThat);
        if (iResult == 0 && fThisOwnership ^ fThatOwnership) {
            iResult = fThisOwnership ? 1 : -1;
        }
        return iResult;
    }

    @Override
    public synchronized void configure(XmlElement xml) {
        this.setDependencies(LegacyXmlPartitionedServiceHelper.fromXml(xml, new DefaultPartitionedServiceDependencies(), this.getOperationalContext(), this.getContextClassLoader()));
        this.setServiceConfig(xml);
    }

    public int convertHash(int nHash) {
        if (nHash == Integer.MIN_VALUE) {
            nHash += this.getPartitionCount();
        }
        return nHash;
    }

    protected PinningIterator createPinningIterator(Set set) {
        return this.createPinningIterator(set, null);
    }

    protected PinningIterator createPinningIterator(Set set, PartitionVersions versions) {
        PinningIterator pinner = (PinningIterator)this._newChild("PinningIterator");
        pinner.setFullSet(set);
        pinner.setPartitionVersions(versions);
        return pinner;
    }

    public void discardBackupOwnership(int nPartition) {
        int iStore = this.getOwnedIndex(nPartition, this.getThisMember().getId());
        if (iStore > 0) {
            this.assignPartitionOwner(nPartition, iStore, 0);
            this.releasePartition(nPartition, iStore);
            this.releasePartitionControl(nPartition);
            Member memberOwner = this.getPrimaryOwner(nPartition);
            this.getTransferControl().sendBackupRelease(nPartition, iStore, memberOwner.getId(), 0, memberOwner, null);
        }
    }

    public void doOwnershipProtocol(MemberSet setOwners, String sSnapshotToRecover) {
        OwnershipRequest msg = (OwnershipRequest)this.instantiateMessage("OwnershipRequest");
        msg.setSenderMemberSet(setOwners);
        msg.setQuery(true);
        msg.setSnapshotToRecover(sSnapshotToRecover);
        msg.setToMemberSet(setOwners);
        this.setOwnershipInProgress(-this.getOwnershipInProgress() + 1);
        this.post(msg);
    }

    protected PartitionControl ensurePartitionControl(int nPartition) {
        PartitionControl ctrl = this.getPartitionControl(nPartition);
        if (ctrl == null) {
            ctrl = (PartitionControl)this._newChild("PartitionControl");
            ctrl.setPartitionId(nPartition);
            ctrl.setStatistics(new PartitionStatistics(nPartition, Base.getLastSafeTimeMillis()));
            ctrl.setTLOEnterCounter(MutableLong.createThreadLocal());
            this.setPartitionControl(nPartition, ctrl);
        }
        return ctrl;
    }

    public List ensurePartitionEventsList(int iPartition) {
        Map mapEvents = this.getPartitionEvents();
        List listEvents = (List)mapEvents.get(iPartition);
        if (listEvents == null) {
            mapEvents.put(iPartition, new CopyOnWriteArrayList());
            listEvents = (List)mapEvents.get(iPartition);
        }
        return listEvents;
    }

    protected Exception ensureSupport(DistributedCacheRequest msgRequest, String sFeature) {
        Exception e;
        Exception exception = e = msgRequest == null ? null : msgRequest.getReadException();
        if (e == null && this.getMsgCAE() != null) {
            e = new LicenseException(sFeature + ": " + this.getMsgCAE());
        }
        return e;
    }

    public boolean enterPartition(int nPartition) {
        return this.enterPartition(nPartition, -1L);
    }

    public boolean enterPartition(int nPartition, long cWait) {
        PartitionControl ctrlPartition = this.getPartitionControl(nPartition);
        if (ctrlPartition == null) {
            return false;
        }
        if (ctrlPartition.enter(0L)) {
            return true;
        }
        if (cWait == 0L) {
            return false;
        }
        int nLockType = ctrlPartition.getLockType();
        if (nLockType == 1 || nLockType == 0 || nLockType == 4) {
            ctrlPartition.enter(-1L);
            return true;
        }
        return false;
    }

    public void exitPartition(int nPartition) {
        PartitionControl ctrlPart = this.getPartitionControl(nPartition);
        if (ctrlPart != null) {
            ctrlPart.exit();
        }
    }

    protected void scheduleEnvironmentMaintenance() {
        if (this.isRunning()) {
            this.getDaemonPool().schedule(new MaintenanceTask(), 120000L);
        }
    }

    protected void finalizeStartup() {
        PartitionedService._assert(!this.isAcceptingOthers());
        if (this.validateMemberConfig() && this.validatePartitionConfig()) {
            this.setAcceptingOthers(true);
            PartitionConfig.Map mapConfig = this.getPartitionConfigMap();
            mapConfig.initializePartitions();
            if (this.isOwnershipEnabled()) {
                this.getThisMemberConfigMap().put("ownership-enabled", 4);
                Member memberThis = this.getThisMember();
                if (this.getOwnershipSenior() == memberThis) {
                    PartitionedService._assert(mapConfig.getConfigCoordinator() == memberThis);
                    mapConfig.publishConfig(null);
                    this.onOwnershipSeniority(null);
                }
                if (this.isActivePersistence()) {
                    PartitionRecoverCleanup msg = (PartitionRecoverCleanup)this.instantiateMessage("PartitionRecoverCleanup");
                    msg.setPartitions(this.instantiatePartitionSet(true));
                    msg.setPrimary(true);
                    msg.addToMember(memberThis);
                    this.post(msg);
                }
                this.setDistributionNextMillis(0L);
            } else {
                this.setDistributionNextMillis(Long.MAX_VALUE);
            }
            this.onFinalizeStartup();
        } else {
            this.setFinalizing(true);
            long ldtStart = this.getStartTimestamp();
            long ldtCurrent = Base.getSafeTimeMillis();
            long lTimeout = this.getStartupTimeout();
            if (ldtCurrent > ldtStart + lTimeout - 1000L) {
                PartitionedService._trace("Failed to synchronize the service configuration; stopping the service", 1);
                this.stop();
            }
        }
    }

    protected void firePartitionEvent(int nEventId, int nPartition, Member memberFrom, Member memberTo) {
        PartitionSet partitions = new PartitionSet(this.getPartitionCount());
        if (nPartition == -1) {
            partitions.fill();
        } else {
            partitions.add(nPartition);
        }
        this.firePartitionEvent(nEventId, partitions, memberFrom, memberTo);
    }

    protected void firePartitionEvent(int nEventId, PartitionSet partitions, Member memberFrom, Member memberTo) {
        EventListener[] listeners = this.getPartitionListeners().listeners();
        int cListeners = listeners.length;
        if (cListeners > 0) {
            try {
                for (int i = 0; i < cListeners; ++i) {
                    ((PartitionListener)listeners[i]).onPartitionEvent(new PartitionEvent(this, nEventId, partitions, memberFrom, memberTo));
                }
            }
            catch (RuntimeException e) {
                PartitionedService._trace("The following exception was thrown by PartitionListener:\n" + PartitionedService.getStackTrace(e) + "\n(The service thread has logged the exception and is continuing.)", 1);
            }
        }
    }

    public long getAsyncBackupInterval() {
        return this.__m_AsyncBackupInterval;
    }

    @Override
    public int getBackupCount() {
        return this.__m_BackupCount;
    }

    @Override
    public com.tangosol.net.Member getBackupOwner(int iPartition, int nBackup) {
        if (nBackup <= 0 || nBackup > this.getBackupCount()) {
            throw new IllegalArgumentException("invalid backup: " + nBackup);
        }
        try {
            int nMember = this.getPartitionAssignments()[iPartition][nBackup];
            return nMember == 0 ? null : this.getServiceMemberSet().getMember(nMember);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("invalid partition: " + iPartition);
        }
    }

    public List getBackupOwners(int iPartition) {
        return this.getBackupOwners(iPartition, true);
    }

    public List getBackupOwners(int iPartition, boolean fIncludeTransitional) {
        int cBackups = this.getBackupCount();
        if (cBackups == 0) {
            return Collections.emptyList();
        }
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        int[] aiOwner = this.getPartitionAssignments()[iPartition];
        VersionedOwnership owners = this.getPartitionConfig(iPartition);
        ArrayList<Member> listOwners = new ArrayList<Member>(cBackups);
        for (int iStore = 1; iStore <= cBackups; ++iStore) {
            Member memberGlobal;
            Member memberOwner;
            int nOwner = aiOwner[iStore];
            if (nOwner > 0 && !setMembers.isServiceLeaving(nOwner) && (memberOwner = setMembers.getMember(nOwner)) != null) {
                listOwners.add(memberOwner);
            }
            int nOwnerGlobal = owners.getOwner(iStore);
            if (!fIncludeTransitional || nOwnerGlobal == nOwner || nOwnerGlobal <= 0 || setMembers.isServiceLeaving(nOwnerGlobal) || (memberGlobal = setMembers.getMember(nOwnerGlobal)) == null) continue;
            listOwners.add(memberGlobal);
        }
        return listOwners;
    }

    public List getBackupOwners(Binary binKey) {
        return this.getBackupOwners(this.getKeyPartition(binKey));
    }

    @Override
    public int getBackupStrength() {
        return this.getBackupStrength(false);
    }

    public int getBackupStrength(int[] aiOwners) {
        int cBackups = this.getBackupCount();
        if (cBackups == 0) {
            return 1;
        }
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        int nStrength = 5;
        for (int iStoreThis = 0; iStoreThis <= cBackups; ++iStoreThis) {
            Member memberThis = ((MemberSet)setMembers).getMember(aiOwners[iStoreThis]);
            if (memberThis == null) {
                return 0;
            }
            int iStoreThat = iStoreThis + 1;
            if (iStoreThat > cBackups) continue;
            Member memberThat = ((MemberSet)setMembers).getMember(aiOwners[iStoreThat]);
            if (memberThat == null) {
                return 1;
            }
            if (nStrength > 2 && memberThis.getMachineId() == memberThat.getMachineId()) {
                return 2;
            }
            if (nStrength > 3 && Base.equals(memberThis.getRackName(), memberThat.getRackName())) {
                return 3;
            }
            if (nStrength > 4 && Base.equals(memberThis.getSiteName(), memberThat.getSiteName())) {
                return 4;
            }
            return nStrength;
        }
        return nStrength;
    }

    public int getBackupStrength(int iPartition, boolean fLocal) {
        int[] aiOwners = fLocal ? this.getPartitionAssignments()[iPartition] : this.getPartitionConfig(iPartition).getOwners();
        return this.getBackupStrength(aiOwners);
    }

    public int getBackupStrength(boolean fLocal) {
        if (this.getBackupCount() == 0) {
            return 1;
        }
        int nStatusSvc = 5;
        int cPartitions = this.getPartitionCount();
        for (int iPartition = 0; iPartition < cPartitions; ++iPartition) {
            int nStatusPart = this.getBackupStrength(iPartition, fLocal);
            if (nStatusSvc <= nStatusPart) continue;
            nStatusSvc = nStatusPart;
        }
        return nStatusSvc;
    }

    @Override
    public String getBackupStrengthName() {
        switch (this.getBackupStrength()) {
            case 0: 
            case 1: {
                return "ENDANGERED";
            }
            case 2: {
                return "NODE-SAFE";
            }
            case 3: {
                return "MACHINE-SAFE";
            }
            case 4: {
                return "RACK-SAFE";
            }
            case 5: {
                return "SITE-SAFE";
            }
        }
        return null;
    }

    public Member getClosestOwner(int iPartition) {
        int[] anOwners = this.getPartitionAssignments()[iPartition];
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        Member memberThis = this.getThisMember();
        Member memberClosest = null;
        int c = anOwners.length;
        for (int i = 0; i < c; ++i) {
            Member member = setMembers.getMember(anOwners[i]);
            if (member == null) continue;
            if (memberClosest == null) {
                memberClosest = member;
            }
            if (memberThis.getMachineId() == member.getMachineId()) {
                return member;
            }
            if (Base.equals(memberThis.getRackName(), member.getRackName()) && !Base.equals(memberClosest.getRackName(), memberThis.getRackName())) {
                memberClosest = member;
                continue;
            }
            if (!Base.equals(memberThis.getSiteName(), member.getSiteName()) || Base.equals(memberClosest.getSiteName(), memberThis.getSiteName())) continue;
            memberClosest = member;
        }
        return memberClosest;
    }

    @Override
    public ServiceConfig.Map getConfigMap(int nMapType) {
        if (nMapType == 2) {
            return this.getPartitionConfigMap();
        }
        return super.getConfigMap(nMapType);
    }

    public KeyAssociator getConfiguredKeyAssociator() {
        return this.__m_ConfiguredKeyAssociator;
    }

    public KeyPartitioningStrategy getConfiguredKeyPartitioningStrategy() {
        return this.__m_ConfiguredKeyPartitioningStrategy;
    }

    public Continuations getContinuations() {
        return this.__m_Continuations;
    }

    public long getDeferredBackupTimeoutMillis() {
        return this.__m_DeferredBackupTimeoutMillis;
    }

    @Override
    public String getDescription() {
        if (this.isAcceptingClients()) {
            StringBuilder sb = new StringBuilder(super.getDescription()).append(", ");
            if (this.isOwnershipEnabled()) {
                sb.append("LocalStorage=enabled").append(", PartitionCount=").append(this.getPartitionCount()).append(", BackupCount=").append(this.getBackupCount()).append(", AssignedPartitions=").append(this.calculateThisOwnership(true));
                if (this.getBackupCount() > 0) {
                    sb.append(", BackupPartitions=").append(this.calculateThisOwnership(false));
                }
            } else {
                sb = new StringBuilder("LocalStorage=disabled");
            }
            com.tangosol.net.Member member = this.getOwnershipSenior();
            sb.append(", CoordinatorId=").append(member == null ? "n/a" : String.valueOf(member.getId())).append(", PersistenceMode=").append(this.getPersistenceMode()).append(", Serializer=").append(this.getSerializer().getName());
            return sb.toString();
        }
        return "Not initialized";
    }

    public int getDistributionAggressiveness() {
        return this.__m_DistributionAggressiveness;
    }

    public long getDistributionContendMillis() {
        return Math.max(100L, (long)this.getDistributionAggressiveness());
    }

    public long getDistributionNextMillis() {
        return this.__m_DistributionNextMillis;
    }

    public int getDistributionRepeatMillis() {
        return this.__m_DistributionRepeatMillis;
    }

    public CentralDistribution getDistributionStrategy() {
        return this.__m_DistributionStrategy;
    }

    public Member getGlobalPrimaryOwner(int iPartition) {
        int nMember = this.getPartitionConfig(iPartition).getPrimaryOwner();
        return nMember == 0 ? null : this.getServiceMemberSet().getMember(nMember);
    }

    @Override
    public KeyAssociator getKeyAssociator() {
        return this.__m_KeyAssociator;
    }

    @Override
    public com.tangosol.net.Member getKeyOwner(Object oKey) {
        return this.getPrimaryOwner((Binary)this.getKeyToBinaryConverter().convert(oKey));
    }

    public int getKeyPartition(Binary binKey) {
        if (binKey == null) {
            return 0;
        }
        return ExternalizableHelper.isIntDecorated(binKey) ? DefaultKeyPartitioningStrategy.calculatePartition(this, ExternalizableHelper.extractIntDecoration(binKey)) : binKey.calculateNaturalPartition(this.getPartitionCount());
    }

    @Override
    public KeyPartitioningStrategy getKeyPartitioningStrategy() {
        return this.__m_KeyPartitioningStrategy;
    }

    public PartitionSet getKeyPartitions(Set setKey) {
        PartitionSet setPartition = new PartitionSet(this.getPartitionCount());
        Iterator iter = setKey.iterator();
        while (iter.hasNext()) {
            setPartition.add(this.getKeyPartition((Binary)iter.next()));
        }
        return setPartition;
    }

    public ConverterKeyToBinary getKeyToBinaryConverter() {
        return this.__m_KeyToBinaryConverter;
    }

    public long getMaxContendMillis() {
        return this.__m_MaxContendMillis;
    }

    public int getMaxLockAttempt() {
        return this.__m_MaxLockAttempt;
    }

    private String getMsgCAE() {
        return this.__m_MsgCAE;
    }

    @Override
    public MemberSet getOthersMemberSet() {
        ActualMemberSet setOthers = new ActualMemberSet();
        setOthers.addAll((Collection)this.getServiceMemberSet());
        setOthers.remove(this.getThisMember());
        return setOthers;
    }

    public int getOwnedIndex(int iPartition, int nMember) {
        return this.getOwnedIndex(iPartition, nMember, true);
    }

    public int getOwnedIndex(int iPartition, int nMember, boolean fLocal) {
        int[] aiOwner = this.getPartitionAssignments()[iPartition];
        VersionedOwnership owners = this.getPartitionConfig(iPartition);
        int cBackups = this.getBackupCount();
        for (int iStore = 0; iStore <= cBackups; ++iStore) {
            int nOwner;
            int n = nOwner = fLocal ? aiOwner[iStore] : owners.getOwner(iStore);
            if (nOwner != nMember) continue;
            return iStore;
        }
        return -1;
    }

    @Override
    public PartitionSet getOwnedPartitions(com.tangosol.net.Member member) {
        return this.getServiceMemberSet().contains(member) ? this.calculatePartitionSet(member, 0) : null;
    }

    public Set getOwnershipEnabledMembers() {
        return this.getOwnershipMemberSet();
    }

    public int getOwnershipInProgress() {
        return this.__m_OwnershipInProgress;
    }

    public Set getOwnershipLeavingMembers() {
        return this.getOwnershipLeavingMembers(this.getOwnershipMemberSet());
    }

    public Set getOwnershipLeavingMembers(Set setOwners) {
        LiteSet<Member> setLeaving = new LiteSet<Member>();
        ServiceMemberSet setService = this.getServiceMemberSet();
        if (setOwners == null) {
            setOwners = this.getOwnershipMemberSet();
        }
        for (Member member : setOwners) {
            if (!setService.isServiceLeaving(member.getId())) continue;
            setLeaving.add(member);
        }
        return setLeaving;
    }

    public MemberSet getOwnershipMemberSet() {
        return this.getOwnershipMemberSet(false);
    }

    public MemberSet getOwnershipMemberSet(boolean fIncludePending) {
        ActualMemberSet setOwners = new ActualMemberSet();
        switch (this.getServiceState()) {
            case 2: 
            case 3: {
                ServiceMemberSet setMembers = this.getServiceMemberSet();
                if (setMembers == null) break;
                for (Member member : setMembers) {
                    int nStatus = this.getOwnershipStatus(member);
                    if (nStatus != 4 && (!fIncludePending || nStatus != 2)) continue;
                    setOwners.add(member);
                }
                break;
            }
        }
        return setOwners;
    }

    public MemberSet getOwnershipOtherMemberSet(MemberSet setOwners) {
        DependentMemberSet setOthers = new DependentMemberSet();
        setOthers.setBaseSet(setOwners == null ? this.getOwnershipMemberSet() : setOwners);
        setOthers.addAll();
        setOthers.remove(this.getThisMember());
        return setOthers;
    }

    @Override
    public com.tangosol.net.Member getOwnershipSenior() {
        return this.getOwnershipSenior(true);
    }

    public Member getOwnershipSenior(boolean fIncludeLeaving) {
        MemberSet setOwners = this.getOwnershipMemberSet();
        ServiceMemberSet setService = this.getServiceMemberSet();
        Member memberAnchor = null;
        long ldtJoinedAnchor = Long.MAX_VALUE;
        for (Member member : setOwners) {
            long ldtJoined;
            int nMember = member.getId();
            if (!fIncludeLeaving && setService.isServiceLeaving(nMember) || (ldtJoined = setService.getServiceJoinTime(nMember)) == 0L || ldtJoined >= ldtJoinedAnchor) continue;
            memberAnchor = member;
            ldtJoinedAnchor = ldtJoined;
        }
        return memberAnchor;
    }

    public int getOwnershipStatus(Member member) {
        Integer IOwnership = (Integer)this.getServiceMemberSet().getMemberConfigMap(member.getId()).get("ownership-enabled");
        return IOwnership == null ? 0 : IOwnership;
    }

    public int[] getOwnershipVersion() {
        return this.__m_OwnershipVersion;
    }

    @Override
    public int getOwnershipVersion(int i) {
        return this.getOwnershipVersion()[i];
    }

    public int[][] getPartitionAssignments() {
        return this.__m_PartitionAssignments;
    }

    @Override
    public PartitionAssignmentStrategy getPartitionAssignmentStrategy() {
        return this.getDistributionStrategy().getPartitionAssignmentStrategy();
    }

    public VersionedOwnership getPartitionConfig(int iPartition) {
        return (VersionedOwnership)this.getPartitionConfigMap().get(iPartition);
    }

    public PartitionConfig.Map getPartitionConfigMap() {
        return this.__m_PartitionConfigMap;
    }

    public Contention[] getPartitionContention() {
        return this.__m_PartitionContention;
    }

    public PartitionControl[] getPartitionControl() {
        return this.__m_PartitionControl;
    }

    public PartitionControl getPartitionControl(int i) {
        return this.getPartitionControl()[i];
    }

    @Override
    public int getPartitionCount() {
        return this.__m_PartitionCount;
    }

    public Map getPartitionEvents() {
        return this.__m_PartitionEvents;
    }

    public Listeners getPartitionListeners() {
        return this.__m_PartitionListeners;
    }

    @Override
    public com.tangosol.net.Member getPartitionOwner(int nPartition) {
        try {
            return this.getPrimaryOwner(nPartition);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("invalid partition: " + nPartition);
        }
    }

    public Ownership getPartitionOwnership(int nPartition) {
        Ownership owners = new Ownership(this.getBackupCount());
        owners.setOwners(this.getPartitionAssignments()[nPartition]);
        return owners;
    }

    public int getPartitionTraceEvents() {
        return this.__m_PartitionTraceEvents;
    }

    public PersistenceControl getPersistenceControl() {
        return this.__m_PersistenceControl;
    }

    public PersistenceDependencies getPersistenceDependencies() {
        return this.__m_PersistenceDependencies;
    }

    public PersistenceManager getPersistenceEventsManager() {
        return this.getPersistenceControl().getEventsManager();
    }

    public PersistenceManager getPersistenceManager() {
        return this.getPersistenceControl().getActiveManager();
    }

    @Override
    public String getPersistenceMode() {
        PersistenceControl ctrl = this.getPersistenceControl();
        PersistenceDependencies depsPersist = this.getPersistenceDependencies();
        String sMode = depsPersist == null ? null : depsPersist.getPersistenceMode();
        return ctrl != null && ctrl.isDisabled() ? "disabled" : sMode;
    }

    public ThreadGate getPreprocessingGate() {
        return this.__m_PreprocessingGate;
    }

    public Member getPrimaryOwner(int iPartition) {
        int nMember = this.getPartitionAssignments()[iPartition][0];
        return nMember == 0 ? null : this.getServiceMemberSet().getMember(nMember);
    }

    public Member getPrimaryOwner(Binary binKey) {
        return this.getPrimaryOwner(this.getKeyPartition(binKey));
    }

    public String getRemainsOwnershipReport() {
        return this.__m_RemainsOwnershipReport;
    }

    public AtomicLong getScratchSpaceCounter() {
        return this.__m_ScratchSpaceCounter;
    }

    public MemberSet getStatusMemberSet(int nMask) {
        ActualMemberSet setMembers = new ActualMemberSet();
        if (this.getServiceState() != 4) {
            for (Member member : this.getServiceMemberSet()) {
                if ((this.getOwnershipStatus(member) & nMask) == 0) continue;
                setMembers.add(member);
            }
        }
        return setMembers;
    }

    public ThreadLocal getTLORecoveryThread() {
        return this.__m_TLORecoveryThread;
    }

    public TransferControl getTransferControl() {
        TransferControl control = this.__m_TransferControl;
        if (control == null) {
            control = (TransferControl)this._findChild("TransferControl");
            this.setTransferControl(control);
        }
        return control;
    }

    public int getTransferThreshold() {
        return this.__m_TransferThreshold;
    }

    @Override
    public long getWaitMillis() {
        long cWait1 = super.getWaitMillis();
        long ldtNow = Base.getSafeTimeMillis();
        long cWait2 = Math.max(1L, this.getDistributionNextMillis() - ldtNow);
        return cWait1 <= 0L ? cWait2 : Math.min(cWait1, cWait2);
    }

    public void handlePartitionTrace(int iPartition, String sEventDescription) {
        this.handlePartitionTrace(iPartition, "PartitionId: " + iPartition, sEventDescription, 0L, true, false);
    }

    public void handlePartitionTrace(int iPartition, String sEventDescription, long ldtTimeSpent) {
        this.handlePartitionTrace(iPartition, "PartitionId: " + iPartition, sEventDescription, ldtTimeSpent, true, true);
    }

    protected void handlePartitionTrace(int iPartition, String sPartsDesc, String sEventDescription, long ldtTimeSpent, boolean fStore, boolean fLog) {
        List listMsgs;
        if (!this.isPartitionTraceEventsEnabled()) {
            return;
        }
        String sMsg = sPartsDesc + ", Owner: " + this.getThisMember().getId() + ", Action: " + sEventDescription + ", UnavailableTime: " + ldtTimeSpent;
        if (fStore && this.isStorePartitionTraceEvents() && (listMsgs = this.ensurePartitionEventsList(iPartition)) != null) {
            listMsgs.add(sMsg);
        }
        if (fLog && this.isLogPartitionTraceEvents()) {
            PartitionedService._trace(sMsg, 8);
        }
    }

    public void handlePartitionTrace(PartitionSet partsAssign, String sEventDescription) {
        this.handlePartitionTrace(0, partsAssign.toString(), sEventDescription, 0L, false, true);
    }

    @Override
    public void heartbeat() {
        super.heartbeat();
    }

    @Override
    public void heartbeat(long cMillis) {
        if (this.getThread() == Thread.currentThread()) {
            super.heartbeat(cMillis);
            return;
        }
        if (cMillis > 0L) {
            GuardSupport.heartbeat(cMillis);
        } else {
            GuardSupport.heartbeat();
        }
    }

    public boolean hasPersistentData(int iPartition) {
        return CachePersistenceHelper.isGlobalPartitioningSchemePID(iPartition);
    }

    public int incrementOwnershipVersion(int nPartition) {
        PartitionedService._assert(Thread.currentThread() == this.getThread());
        int[] nArray = this.getOwnershipVersion();
        int n = nPartition;
        int n2 = nArray[n] + 1;
        nArray[n] = n2;
        return n2;
    }

    protected void initPartitionConfig() {
        int cPartitions = this.getPartitionCount();
        int cBackups = this.getBackupCount();
        HashMap<Integer, VersionedOwnership> mapUpdates = new HashMap<Integer, VersionedOwnership>();
        for (int iPartition = 0; iPartition < cPartitions; ++iPartition) {
            mapUpdates.put(iPartition, new VersionedOwnership(cBackups, 0));
        }
        this.getPartitionConfigMap().updateInternal(mapUpdates, false);
    }

    @Override
    protected XmlElement initServiceConfig() {
        if (this.getThisMember() != this.getServiceOldestMember()) {
            throw new IllegalStateException("Missing ServiceConfigMap from senior=" + this.getServiceOldestMember().getId());
        }
        KeyAssociator associator = this.getConfiguredKeyAssociator();
        KeyPartitioningStrategy partitioning = this.getConfiguredKeyPartitioningStrategy();
        ActionPolicy quorumPolicy = this.getActionPolicy();
        String sAssociator = associator == null ? "none" : associator.getClass().getName();
        String sPartitioning = partitioning == null ? "none" : partitioning.getClass().getName();
        String sQuorumPolicy = quorumPolicy == null ? "none" : quorumPolicy.getClass().getName();
        XmlElement xmlConfig = super.initServiceConfig();
        xmlConfig.addAttribute("partition-count").setInt(this.getPartitionCount());
        xmlConfig.addAttribute("redundancy-count").setInt(this.getBackupCount());
        xmlConfig.addAttribute("key-associator").setString(sAssociator);
        xmlConfig.addAttribute("key-partitioning").setString(sPartitioning);
        xmlConfig.addAttribute("quorum-policy").setString(sQuorumPolicy);
        return xmlConfig;
    }

    public ConverterKeyToBinary instantiateKeyToBinaryConverter(ClassLoader loader, boolean fPassThrough) {
        ConfigurablePofContext cpc;
        ConverterKeyToBinary conv = (ConverterKeyToBinary)this._newChild("ConverterKeyToBinary");
        Serializer serializer = this.ensureSerializer(loader);
        if (serializer instanceof ConfigurablePofContext && (cpc = (ConfigurablePofContext)serializer).isReferenceEnabled()) {
            cpc = new ConfigurablePofContext(cpc);
            cpc.setReferenceEnabled(false);
            serializer = cpc;
        }
        conv.setSerializer(serializer);
        conv.setPassThrough(fPassThrough);
        return conv;
    }

    public PartitionFilter instantiatePartitionFilter(int nPartition) {
        PartitionFilter filter = (PartitionFilter)this._newChild("PartitionFilter");
        PartitionSet parts = this.instantiatePartitionSet(false);
        parts.add(nPartition);
        filter.setPartitionSet(parts);
        return filter;
    }

    public PartitionSet instantiatePartitionSet(int nPartition) {
        PartitionSet parts = new PartitionSet(this.getPartitionCount());
        parts.add(nPartition);
        return parts;
    }

    public PartitionSet instantiatePartitionSet(boolean fFill) {
        PartitionSet parts = new PartitionSet(this.getPartitionCount());
        if (fFill) {
            parts.fill();
        }
        return parts;
    }

    public boolean isActivePersistence() {
        return this.getPersistenceManager() != null;
    }

    public boolean isAdaptivePartitionLock() {
        return this.getMaxLockAttempt() > 1;
    }

    public boolean isAllAllowed() {
        return !this.isSuspended() && this.getActionPolicy().isAllowed(this, PartitionedService.PartitionedAction.DISTRIBUTE) && this.getActionPolicy().isAllowed(this, PartitionedService.PartitionedAction.RESTORE);
    }

    public boolean isAsyncBackup() {
        return this.__m_AsyncBackup;
    }

    public boolean isBackupOwner(int iPartition) {
        return this.isBackupOwner(iPartition, this.getThisMember().getId());
    }

    public boolean isBackupOwner(int iPartition, int nMember) {
        return this.getOwnedIndex(iPartition, nMember) > 0;
    }

    public boolean isBackupOwner(Binary binKey) {
        return this.isBackupOwner(this.getKeyPartition(binKey));
    }

    public boolean isBackupPersistence() {
        return this.getPersistenceControl().getBackupManager() != null;
    }

    public boolean isConcurrent() {
        return this.__m_Concurrent;
    }

    public boolean isDistributionAllowed() {
        return !this.isSuspended() && this.getActionPolicy().isAllowed(this, PartitionedService.PartitionedAction.DISTRIBUTE);
    }

    public boolean isDistributionInProgress() {
        return this.getDistributionStrategy().isDistributionInProgress();
    }

    public boolean isDistributionStable() {
        return this.__m_DistributionStable;
    }

    public boolean isDistributionSynchronized() {
        return this.__m_DistributionSynchronized;
    }

    protected boolean isFinalizing() {
        return this.__m_Finalizing;
    }

    public boolean isLogPartitionTraceEvents() {
        return (this.getPartitionTraceEvents() & 2) != 0;
    }

    public boolean isOwnershipChangeInProgress() {
        if (this.getTransferControl().isInProgress()) {
            return true;
        }
        PartitionSet parts = this.collectOwnedPartitions(true);
        int iPart = parts.next(0);
        while (iPart >= 0) {
            if (this.getPartitionControl(iPart).isTransferDisallowed()) {
                return true;
            }
            iPart = parts.next(iPart + 1);
        }
        return false;
    }

    public boolean isOwnershipDisabled(Member member) {
        return this.getOwnershipStatus(member) == 1;
    }

    public boolean isOwnershipEnabled() {
        return this.__m_OwnershipEnabled;
    }

    public boolean isOwnershipEnabled(Member member) {
        return this.getOwnershipStatus(member) == 4;
    }

    public boolean isOwnershipPending(Member member) {
        return this.getOwnershipStatus(member) == 2;
    }

    public boolean isPartitionTraceEventsEnabled() {
        return this.getPartitionTraceEvents() > 0;
    }

    public boolean isPartitionVulnerable(int iPartition, boolean fStrict) {
        return fStrict ? this.getBackupStrength(iPartition, false) < 3 : this.isPartitionVulnerableLegacy(iPartition);
    }

    protected boolean isPartitionVulnerableLegacy(int iPartition) {
        Member memberPrime;
        if (this.getBackupCount() > 0 && (memberPrime = this.getPrimaryOwner(iPartition)) != null) {
            for (Member memberBackup : this.getBackupOwners(iPartition)) {
                if (memberPrime.getMachineId() == memberBackup.getMachineId()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isPersistEvents() {
        return this.getPersistenceControl().getEventsManager() != null;
    }

    public boolean isPrimaryOwner(int iPartition) {
        if (this.getPartitionAssignments()[iPartition][0] == this.getThisMember().getId()) {
            PartitionControl control = this.getPartitionControl(iPartition);
            if (control.isLocked()) {
                int nLockType = control.getLockType();
                return nLockType != 4 && nLockType != 2 && nLockType != 3;
            }
            return true;
        }
        return false;
    }

    public boolean isPrimaryOwner(Binary binKey) {
        return this.isPrimaryOwner(this.getKeyPartition(binKey));
    }

    public boolean isRecovering(int nPartition) {
        return this.getPartitionControl(nPartition).isRecovering();
    }

    public boolean isRecoverPartitionsAllowed(PartitionSet partsOrphan, GUIDHelper.GUIDResolver resolver, QuorumInfo info) {
        if (this.isSuspended()) {
            return false;
        }
        if (!this.isActivePersistence() || this.getPersistenceControl().isForceRecovery()) {
            return true;
        }
        return this.getActionPolicy().isAllowed(this, new PartitionedService.PartitionRecoveryAction(partsOrphan, resolver, info));
    }

    public boolean isRecoveryInProgress() {
        return this.getPersistenceControl().getActiveRecoveryRequests().get() > 0;
    }

    public boolean isRecoveryThread() {
        Boolean fRecoveryThread = (Boolean)this.getTLORecoveryThread().get();
        return fRecoveryThread != null && fRecoveryThread != false;
    }

    public boolean isRestoreInProgress() {
        return this.__m_RestoreInProgress;
    }

    public boolean isRestorePartitionAllowed() {
        return !this.isSuspended() && this.getActionPolicy().isAllowed(this, PartitionedService.PartitionedAction.RESTORE);
    }

    public boolean isScheduledBackups() {
        return this.getAsyncBackupInterval() > 0L;
    }

    public boolean isSnapshotManager(PersistenceManager mgrRecover) {
        return mgrRecover != this.getPersistenceManager();
    }

    public boolean isStorePartitionTraceEvents() {
        return (this.getPartitionTraceEvents() & 1) != 0;
    }

    @Override
    public boolean isSuspendedFully() {
        if (super.isSuspendedFully()) {
            PartitionSet parts = this.getOwnedPartitions(this.getThisMember());
            PartitionControl[] actrlPartition = this.getPartitionControl();
            int nPartition = parts.next(0);
            while (nPartition >= 0) {
                PartitionControl ctrl = actrlPartition[nPartition];
                if (ctrl != null && ctrl.getPersistenceTasks().get() > 0) {
                    return false;
                }
                nPartition = parts.next(nPartition + 1);
            }
            return !this.isOwnershipEnabled() || !this.isDistributionInProgress() && !this.isOwnershipChangeInProgress();
        }
        return false;
    }

    public boolean isTransferInProgress() {
        return this.getTransferControl().isInProgress();
    }

    public boolean isTransferVulnerable(int iPartition, int iStorage, Member memberTo) {
        PartitionedService._assert(memberTo != null);
        if (this.getBackupCount() > 0) {
            int nMachineTo = memberTo.getMachineId();
            List listOwners = this.getBackupOwners(iPartition);
            switch (listOwners.size()) {
                case 0: {
                    return true;
                }
                case 1: {
                    if (iStorage > 0) {
                        Member memberPrimary = this.getThisMember();
                        return memberPrimary.getMachineId() == nMachineTo;
                    }
                    Member memberBackup = (Member)listOwners.iterator().next();
                    return memberBackup.getMachineId() == nMachineTo;
                }
            }
            if (iStorage > 0) {
                listOwners.add(this.getThisMember());
                Member memberBackup = (Member)this.getBackupOwner(iPartition, iStorage);
                if (memberBackup != null) {
                    listOwners.remove(memberBackup);
                }
            }
            for (Member member : listOwners) {
                if (member.getMachineId() != nMachineTo) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean isVulnerabilityAvoidable(MemberSet setOwners) {
        int cMembers = setOwners.size();
        int cBackups = this.getBackupCount();
        if (cMembers <= 1 || cBackups == 0) {
            return false;
        }
        HashMap<Integer, Integer> mapCount = new HashMap<Integer, Integer>();
        for (Member member : setOwners) {
            int nCount;
            Integer IMachine = member.getMachineId();
            Integer ICount = (Integer)mapCount.get(IMachine);
            int n = nCount = ICount == null ? 1 : ICount + 1;
            if (nCount * (cBackups + 1) >= cMembers) {
                return false;
            }
            mapCount.put(IMachine, nCount);
        }
        return true;
    }

    public Map lockForRecovery(PartitionRecoverRequest msgRequest) {
        String[] asGUIDs = msgRequest.getGUIDs();
        int cGUIDs = asGUIDs.length;
        HashMap<Integer, VersionedOwnership> mapUpdate = new HashMap<Integer, VersionedOwnership>(cGUIDs);
        for (int i = 0; i < cGUIDs; ++i) {
            String sGUID = asGUIDs[i];
            int nPartition = GUIDHelper.getPartition(sGUID);
            PartitionControl ctrlPart = this.ensurePartitionControl(nPartition);
            if (ctrlPart.isLocked() && ctrlPart.getLockType() == 4) continue;
            ctrlPart.lock(-1L, 4);
            PartitionedService._assert(this.getPrimaryOwner(nPartition) == null);
            if (this.getOwnershipVersion(nPartition) == 0) {
                this.setOwnershipVersion(nPartition, (int)GUIDHelper.getVersion(sGUID));
            }
            VersionedOwnership owners = this.assignPrimaryPartition(nPartition, 'r');
            mapUpdate.put(nPartition, owners);
        }
        LiteMap<Integer, VersionedOwnership> mapAssigned = new LiteMap<Integer, VersionedOwnership>();
        PartitionSet partsAssign = msgRequest.getPartsAssign();
        if (!partsAssign.isEmpty()) {
            int[][] aaiOwner = this.getPartitionAssignments();
            int cPartitions = aaiOwner.length;
            PartitionConfig.Map mapConfig = this.getPartitionConfigMap();
            PartitionSet partsAssigned = null;
            PartitionSet partsLost = null;
            int iPartition = partsAssign.next(0);
            while (iPartition >= 0) {
                int nOwner = aaiOwner[iPartition][0];
                if (nOwner == 0) {
                    PartitionControl ctrlPart = this.ensurePartitionControl(iPartition);
                    if (this.checkLockRequired()) {
                        ctrlPart.lock(-1L, 4);
                    }
                    VersionedOwnership owners = this.assignPrimaryPartition(iPartition, 'r');
                    mapAssigned.put(iPartition, owners);
                    if (mapConfig.isAssignmentCompleted(iPartition)) {
                        if (partsLost == null) {
                            partsLost = new PartitionSet(cPartitions);
                        }
                        partsLost.add(iPartition);
                    } else {
                        if (partsAssigned == null) {
                            partsAssigned = new PartitionSet(cPartitions);
                        }
                        partsAssigned.add(iPartition);
                    }
                } else {
                    PartitionedService._trace("Unable to assign orphaned partition " + iPartition + "; current owner is member " + nOwner, 2);
                    partsAssign.remove(iPartition);
                }
                iPartition = partsAssign.next(iPartition + 1);
            }
            msgRequest.setPartsAssigned(partsAssigned);
            msgRequest.setPartsLost(partsLost);
            msgRequest.setMapAssigned(mapAssigned);
        }
        return mapUpdate;
    }

    protected void movePartition(int iPartition, int iBackupTo) {
        if (this.isActivePersistence()) {
            PartitionControl ctrl = this.getPartitionControl(iPartition);
            if (iBackupTo > 0) {
                ctrl.deletePersistentStore();
                if (this.isBackupPersistence()) {
                    PersistentStore store = ctrl.ensurePersistentStore(null, false, true);
                    if (!this.isExiting() && this.getServiceState() != 3) {
                        CachePersistenceHelper.seal(store, this, null);
                    }
                }
            } else {
                if (this.isBackupPersistence()) {
                    ctrl.deleteBackupPersistentStore();
                }
                this.saveQuorum(iPartition);
                if (!this.isExiting() && this.getServiceState() != 3) {
                    PersistentStore storeEvents = ctrl.getPersistentEventsStore();
                    if (storeEvents != null) {
                        CachePersistenceHelper.seal(storeEvents, this, null);
                    }
                    CachePersistenceHelper.seal(ctrl.ensurePersistentStore(), this, null);
                }
            }
        }
    }

    public void onBackupAssignment(BackupAssignment msgAssignment) {
        int iPartition = msgAssignment.getPartition();
        int iStore = msgAssignment.getStore();
        Member memberFrom = msgAssignment.getFromMember();
        Member memberThis = this.getThisMember();
        int nMemberFrom = memberFrom.getId();
        int nMemberThis = memberThis.getId();
        int[][] aaiOwner = this.getPartitionAssignments();
        VersionedOwnership owners = this.getPartitionConfig(iPartition);
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        PartitionedService._assert(iStore != 0);
        if (msgAssignment.isRelease()) {
            if (aaiOwner[iPartition][iStore] == nMemberThis) {
                PartitionControl control = this.getPartitionControl(iPartition);
                int nBackupNew = msgAssignment.getNewBackupOwner();
                if (!setMembers.contains(nBackupNew)) {
                    nBackupNew = 0;
                }
                this.assignPartitionOwner(iPartition, iStore, nBackupNew);
                this.releasePartition(iPartition, iStore);
                this.releasePartitionControl(iPartition);
                Member memberOwner = ((MemberSet)setMembers).getMember(msgAssignment.getPrimaryOwner());
                if (memberOwner != null) {
                    this.getTransferControl().sendBackupAnnounce(iPartition, iStore, memberOwner, null);
                }
            } else if (aaiOwner[iPartition][0] == nMemberThis) {
                if (owners.getOwner(iStore) == nMemberFrom) {
                    aaiOwner[iPartition][iStore] = 0;
                    this.publishPartitionOwnership(iPartition, iStore, 0);
                } else {
                    PartitionedService._trace("Ignoring BackupAssignment for partition " + iPartition + " (" + iStore + ") received from member " + nMemberFrom, 2);
                }
            } else {
                PartitionedService._trace("Ignoring BackupAssignment for un-owned backup(" + iStore + ") of partition " + iPartition + " from member " + nMemberFrom, 2);
            }
        } else if (aaiOwner[iPartition][0] == nMemberThis) {
            if (iStore >= 0) {
                int nBackupLocal = aaiOwner[iPartition][iStore];
                int nBackupGlobal = owners.getOwner(iStore);
                if (nMemberFrom == nBackupGlobal || nMemberFrom == nBackupLocal) {
                    if (nBackupLocal != nBackupGlobal) {
                        owners = new VersionedOwnership(owners);
                        owners.setOwner(iStore, nBackupLocal);
                        this.putPartitionConfig(iPartition, owners);
                    }
                } else {
                    PartitionedService._trace("Ignoring unsolicited BackupAssignment announcement for partition " + iPartition + " (backup " + iStore + ") from member " + nMemberFrom + "; (local=" + nBackupLocal + ", global=" + nBackupGlobal + ")", 2);
                }
            } else {
                owners = new VersionedOwnership(owners);
                owners.setOwners(aaiOwner[iPartition]);
                this.putPartitionConfig(iPartition, owners);
            }
            this.getPartitionControl(iPartition).enableTransfer();
        } else {
            PartitionedService._trace("Ignoring BackupAssignment announcement for un-owned partition " + iPartition + " (backup " + iStore + ") from member " + nMemberFrom, 2);
        }
    }

    public void onBackupConfirmRequest(BackupConfirmRequest msgConfirm) {
        int iPartition = msgConfirm.getPartition();
        int iStore = msgConfirm.getStore();
        Member memberFrom = msgConfirm.getFromMember();
        PartitionedService._assert(iStore != 0);
        if (this.getPartitionAssignments()[iPartition][iStore] == this.getThisMember().getId()) {
            this.getTransferControl().sendBackupAnnounce(iPartition, iStore, memberFrom, msgConfirm);
        } else {
            this.getTransferControl().sendBackupRelease(iPartition, iStore, memberFrom.getId(), 0, memberFrom, msgConfirm);
        }
    }

    @Override
    protected void onDependencies(ServiceDependencies deps) {
        PartitionAssignmentStrategy pas;
        long cBackupInterval;
        super.onDependencies(deps);
        PartitionedServiceDependencies depsPS = (PartitionedServiceDependencies)deps;
        this.setBackupCount(depsPS.getPreferredBackupCount());
        this.setDistributionAggressiveness(depsPS.getDistributionAggressiveness());
        this.setDistributionSynchronized(depsPS.isDistributionSynchronized());
        this.setConfiguredKeyAssociator(depsPS.getKeyAssociator());
        this.setKeyAssociator(depsPS.getKeyAssociator());
        this.setConfiguredKeyPartitioningStrategy(depsPS.getKeyPartitioningStrategy());
        this.setKeyPartitioningStrategy(depsPS.getKeyPartitioningStrategy());
        this.setOwnershipEnabled(depsPS.isOwnershipCapable());
        this.setPartitionCount(depsPS.getPreferredPartitionCount());
        this.setTransferThreshold(depsPS.getTransferThreshold());
        this.setAsyncBackup(depsPS.isAsyncBackupEnabled());
        Duration asyncBackupInterval = depsPS.getAsyncBackupInterval();
        long l = cBackupInterval = asyncBackupInterval == null ? -1L : asyncBackupInterval.getNanos() / 1000000L;
        if (cBackupInterval > 0L && (long)this.getBackupCount() > 0L) {
            if (depsPS.getWorkerThreadCountMin() > 0) {
                this.setAsyncBackupInterval(cBackupInterval);
            } else {
                PartitionedService._trace("Reverting scheduled backups due to thread pool being disabled", 2);
            }
        }
        if ((pas = depsPS.getPartitionAssignmentStrategyBuilder().realize(this.createResolver(), this.getContextClassLoader(), null)) == null) {
            pas = new SimpleAssignmentStrategy();
        }
        CentralDistribution strategy = (CentralDistribution)this._newChild("CentralDistribution");
        strategy.setService(this);
        strategy.setPartitionAssignmentStrategy(pas);
        this.setDistributionStrategy(strategy);
        if (this.isOwnershipEnabled()) {
            List<ParameterizedBuilder<PartitionListener>> listBuilders = depsPS.getPartitionListenerBuilders();
            if (listBuilders != null) {
                for (ParameterizedBuilder<PartitionListener> bldr : listBuilders) {
                    this.addPartitionListener(bldr.realize(this.createResolver(), this.getContextClassLoader(), null));
                }
            }
            this.setPersistenceDependencies(depsPS.getPersistenceDependencies());
        }
        String sTraceEvents = Config.getProperty("coherence.distributed.partition.events", "store");
        String[] asTraceModes = sTraceEvents.toLowerCase().split(",");
        int nTraceEvents = 0;
        int c = asTraceModes.length;
        for (int i = 0; i < c; ++i) {
            if ("none".equals(asTraceModes[i])) {
                nTraceEvents |= 0;
            }
            if ("store".equals(asTraceModes[i])) {
                nTraceEvents |= 1;
                continue;
            }
            if (!"log".equals(asTraceModes[i])) continue;
            nTraceEvents |= 2;
        }
        this.setPartitionTraceEvents(nTraceEvents);
        long cLockWait = this.getDistributionContendMillis();
        long cMaxLockWait = Config.getLong("coherence.distributed.lock.wait", cLockWait);
        this.setMaxContendMillis(cMaxLockWait);
        this.setMaxLockAttempt(Config.getInteger("coherence.distributed.lock.attempt", cLockWait == cMaxLockWait ? 1 : 10));
    }

    @Override
    protected void onEnter() {
        try {
            new CoherenceCommunityEdition();
        }
        catch (Exception e) {
            this.setMsgCAE(e.getMessage());
        }
        boolean fOwnershipEnabled = this.isOwnershipEnabled();
        this.getThisMemberConfigMap().put("ownership-enabled", fOwnershipEnabled ? 2 : 1);
        String sDelayMillis = Config.getProperty("coherence.distributed.deferredbackuptimeout");
        this.setDeferredBackupTimeoutMillis(sDelayMillis == null ? (long)this.getClusterService().getDeliveryTimeoutMillis() : Long.parseLong(sDelayMillis));
        PersistenceControl ctrlPersistence = (PersistenceControl)this._newChild("PersistenceControl");
        this.setPersistenceControl(ctrlPersistence);
        if (fOwnershipEnabled) {
            ParameterizedBuilder bldr;
            PersistenceDependencies depsPersistence = this.getPersistenceDependencies();
            ParameterizedBuilder parameterizedBuilder = bldr = depsPersistence == null ? null : depsPersistence.getPersistenceEnvironmentBuilder();
            if (bldr != null) {
                PersistenceEnvironment env = (PersistenceEnvironment)bldr.realize(this.createResolver(), this.getContextClassLoader(), null);
                ctrlPersistence.setActiveFailureMode(depsPersistence.getFailureMode());
                ctrlPersistence.setAsync(depsPersistence.isAsync());
                ctrlPersistence.setPersistenceEnvironment(env);
                SnapshotArchiver archiver = null;
                SnapshotArchiverFactory factoryArchiver = depsPersistence.getArchiverFactory();
                if (factoryArchiver != null) {
                    archiver = factoryArchiver.createSnapshotArchiver(this.getCluster().getClusterName(), this.getServiceName());
                    ctrlPersistence.setSnapshotArchiver(archiver);
                }
            }
        }
        super.onEnter();
    }

    @Override
    protected void onExit() {
        if (!this.getPreprocessingGate().close(1000L)) {
            PartitionedService._trace("timeout waiting for " + this.getPreprocessingGate().getActiveCount() + " preprocessing threads to complete; abandoning", 2);
        }
        this.getPersistenceControl().release();
        super.onExit();
        this.getServiceConfigMap().getConfig().removeConfigListener();
        this.getPartitionConfigMap().getConfig().removeConfigListener();
    }

    public void onFinalizeAssignPrimary(Map mapConfig) {
        if (mapConfig != null && !mapConfig.isEmpty()) {
            if (this.checkLockRequired()) {
                Iterator iter = mapConfig.keySet().iterator();
                while (iter.hasNext()) {
                    int iPartition = (Integer)iter.next();
                    PartitionControl control = this.getPartitionControl(iPartition);
                    control.unlock();
                }
            }
            this.putPartitionConfig(mapConfig);
        }
        this.setOwnershipInProgress(0);
    }

    public void onFinalizeReceivePrimary(TransferRequest msgLastTransfer) {
        TransferResponse msgResponse = (TransferResponse)this.instantiateMessage("TransferResponse");
        msgResponse.respondTo(msgLastTransfer);
        PartitionSet partsLocked = new PartitionSet(this.getPartitionCount());
        TransferControl ctrlTransfer = this.getTransferControl();
        Member memberThis = this.getThisMember();
        Member memberFrom = msgLastTransfer.getFromMember();
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        int nMemberThis = memberThis.getId();
        int cBackup = this.getBackupCount();
        HashMap<Integer, Integer> mapResponse = new HashMap<Integer, Integer>();
        HashMap<Integer, VersionedOwnership> mapOwners = new HashMap<Integer, VersionedOwnership>();
        int iPart = -1;
        PartitionedService._assert(Thread.currentThread() == this.getThread());
        if (!ctrlTransfer.isIncomingTransfer(memberFrom)) {
            PartitionedService._trace("Unable to complete distribution from member " + memberFrom.getId(), 1);
            this.getDistributionStrategy().onDistributionCompleted(memberFrom, false);
            return;
        }
        int[][] aaiOwnerPrev = this.getPartitionAssignments();
        for (TransferRequest msgPending : ctrlTransfer.getQueuedTransfers(memberFrom)) {
            int nPrevBackup;
            Member memberTo;
            PartitionedService._assert(msgPending.getStore() == 0);
            int iPartPrev = iPart;
            iPart = msgPending.getPartition();
            if (iPart == iPartPrev) continue;
            int nMemberSender = msgPending.getFromMember().getId();
            Integer IPart = iPart;
            int[] aiOwnerPrev = aaiOwnerPrev[iPart];
            if (aiOwnerPrev[0] == nMemberThis) {
                PartitionedService._trace("Request to transfer already owned primary partition " + iPart + " from member " + nMemberSender, 1);
            }
            PartitionControl ctrlPart = this.ensurePartitionControl(iPart);
            ctrlPart.lock(-1L, 2);
            partsLocked.add(iPart);
            long lVersionNew = msgPending.getPartitionVersion() + 1L;
            ctrlPart.getVersionCounter().set(lVersionNew);
            VersionedOwnership ownersOld = msgPending.getOwners();
            this.assignPartitionOwners(iPart, ownersOld.getOwners());
            this.setOwnershipVersion(iPart, ownersOld.getVersion());
            VersionedOwnership owners = this.assignPrimaryPartition(iPart, 'r');
            mapOwners.put(IPart, owners);
            this.validateTransferStrength(ownersOld, owners, iPart);
            int iResponse = -2;
            for (int iBackup = 1; iBackup <= cBackup; ++iBackup) {
                if (owners.getOwner(iBackup) != nMemberSender) continue;
                iResponse = iBackup;
                break;
            }
            if (iResponse > 0 && (memberTo = ((MemberSet)setMembers).getMember(nPrevBackup = aiOwnerPrev[iResponse])) != null && memberTo != memberThis) {
                ctrlTransfer.sendBackupRelease(iPart, iResponse, nMemberThis, nMemberSender, memberTo, null);
            }
            mapResponse.put(IPart, iResponse);
            ctrlPart.preventTransfer();
        }
        msgResponse.setPrimaryPartitions(partsLocked);
        msgResponse.setValue(mapResponse);
        List listTransfers = ctrlTransfer.getQueuedTransfers(memberFrom);
        int iLeft = 0;
        int c = listTransfers.size();
        while (iLeft < c) {
            int iRight;
            int iPartition = ((TransferRequest)listTransfers.get(iLeft)).getPartition();
            for (iRight = iLeft + 1; iRight < c && ((TransferRequest)listTransfers.get(iRight)).getPartition() == iPartition; ++iRight) {
            }
            this.firePartitionEvent(5, iPartition, memberFrom, memberThis);
            List listXferRequests = listTransfers.subList(iLeft, iRight);
            this.receivePartition(iPartition, 0, listXferRequests);
            ctrlTransfer.finalizeReceivePartition(iPartition, listXferRequests);
            this.firePartitionEvent(6, iPartition, memberFrom, memberThis);
            iLeft = iRight;
        }
        ctrlTransfer.onReceiveCommitted(msgLastTransfer);
        this.post(msgResponse);
        PartitionControl[] aCtrlPartition = this.getPartitionControl();
        iPart = partsLocked.next(0);
        while (iPart >= 0) {
            PartitionControl ctrlPart = aCtrlPartition[iPart];
            ctrlPart.doSyncBackups();
            ctrlPart.unlock();
            iPart = partsLocked.next(iPart + 1);
        }
        this.putPartitionConfig(mapOwners);
        this.getDistributionStrategy().onDistributionCompleted(memberFrom, true);
    }

    public void onFinalizeRecoverPrimary(PartitionRecoverInfo info) {
        PartitionSet partsAssign;
        Object[] objectArray;
        PartitionRecoverRequest msgRequest = (PartitionRecoverRequest)info.getRequest();
        Map mapConfig = info.getMapConfig();
        PersistenceManager mgrRecover = info.getManager();
        PartitionSet partsRecovered = info.getRecoveredPartitions();
        Object[] partsFailed = info.getFailedPartitions();
        PartitionSet partsFailedEvents = info.getFailedEventPartitions();
        boolean fSnapshot = mgrRecover != this.getPersistenceManager();
        Grid.Response msgResponse = (Grid.Response)this.instantiateMessage("Response");
        int iPart = partsFailed.next(0);
        while (iPart >= 0) {
            mapConfig.remove(iPart);
            this.assignPartitionOwner(iPart, 0, 0);
            this.releasePartition(iPart, 0);
            this.getPartitionControl(iPart).unlock();
            this.releasePartitionControl(iPart);
            iPart = partsFailed.next(iPart + 1);
        }
        msgResponse.respondTo(msgRequest);
        if (this.isVersionCompatible(msgRequest.getFromMember(), 21, 6, 0)) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = partsFailed;
            objectArray = objectArray2;
            objectArray2[1] = partsFailedEvents;
        } else {
            objectArray = partsFailed;
        }
        msgResponse.setValue(objectArray);
        if (mapConfig != null && !mapConfig.isEmpty()) {
            Member memberThis = this.getThisMember();
            Iterator iter = mapConfig.keySet().iterator();
            while (iter.hasNext()) {
                int iPartition = (Integer)iter.next();
                PartitionControl control = this.getPartitionControl(iPartition);
                this.firePartitionEvent(8, iPartition, null, memberThis);
                control.setRecovered(false);
                control.unlock();
            }
            this.putPartitionConfig(mapConfig);
            PartitionedService._trace("Recovered " + String.valueOf(partsRecovered) + " from " + (fSnapshot ? "snapshot" : "active") + " persistent store", 3);
        }
        Iterator iter = info.getListRequests().iterator();
        while (iter.hasNext()) {
            this.post((Message)iter.next());
        }
        if (fSnapshot) {
            mgrRecover.release();
        }
        if ((partsAssign = msgRequest.getPartsAssign()).isEmpty()) {
            this.post(msgResponse);
        } else {
            PartitionSet partsAssigned;
            Map mapAssigned = msgRequest.getMapAssigned();
            PartitionSet partsLost = msgRequest.getPartsLost();
            if (partsLost != null) {
                PartitionedService._trace("Assigned " + partsLost.cardinality() + " orphaned primary partitions: " + String.valueOf(partsLost), 2);
                this.firePartitionEvent(1, partsLost, null, this.getThisMember());
            }
            if ((partsAssigned = msgRequest.getPartsAssigned()) != null) {
                this.firePartitionEvent(7, partsAssigned, null, this.getThisMember());
            }
            this.onPartitionsAssigned(partsAssigned, partsLost, this.getContinuations().instantiateFinalizeAssignPrimaries(msgRequest.getMapAssigned(), msgResponse));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinalizeRestorePrimary(OwnershipRequest msgRequest, Map mapUpdate) {
        OwnershipResponse msgResponse = (OwnershipResponse)this.instantiateMessage("OwnershipResponse");
        msgResponse.respondTo(msgRequest);
        PartitionSet partsRecover = msgRequest.getRecoveryPartitions();
        if (partsRecover != null) {
            PersistenceManager backupMgr;
            String sSnapshot = msgRequest.getSnapshotToRecover();
            PersistenceControl ctrl = this.getPersistenceControl();
            PersistenceManager mgr = sSnapshot == null ? this.getPersistenceManager() : ctrl.openSnapshot(sSnapshot);
            PersistenceManager persistenceManager = backupMgr = sSnapshot == null ? ctrl.getBackupManager() : ctrl.openSnapshot(sSnapshot);
            if (mgr != null) {
                PartitionSet partsGlobal = CachePersistenceHelper.getGlobalPartitions(this);
                PersistentStoreInfo[] aStoreInfo = mgr.listStoreInfo();
                PersistentStoreInfo[] aBackupStoreInfoAll = backupMgr != null ? backupMgr.listStoreInfo() : null;
                Object[] aBackupStoreInfo = null;
                if (aBackupStoreInfoAll != null) {
                    ArrayList<PersistentStoreInfo> listBackupGUIDs = new ArrayList<PersistentStoreInfo>();
                    for (int i = 0; i < aBackupStoreInfoAll.length; ++i) {
                        String sGUID = aBackupStoreInfoAll[i].getId();
                        int iPart = GUIDHelper.getPartition(sGUID);
                        if (GUIDHelper.getGUID(Arrays.asList(aStoreInfo), iPart) != null) continue;
                        listBackupGUIDs.add(aBackupStoreInfoAll[i]);
                    }
                    aBackupStoreInfo = listBackupGUIDs.toArray(new PersistentStoreInfo[listBackupGUIDs.size()]);
                    Arrays.sort(aBackupStoreInfo, Comparator.comparing(PersistentStoreInfo::getId));
                }
                PersistentStoreInfo[] aStoreInfoMerged = aBackupStoreInfo == null ? aStoreInfo : Base.mergeArray(aStoreInfo, aBackupStoreInfo);
                int cParts = this.getPartitionCount();
                int cGUID = aStoreInfoMerged.length;
                ArrayList<PersistentStoreInfo> listRecover = new ArrayList<PersistentStoreInfo>(cGUID);
                ArrayList<PersistentStoreInfo> listGlobal = new ArrayList<PersistentStoreInfo>(1);
                for (int i = 0; i < cGUID; ++i) {
                    PersistentStore store;
                    PersistentStoreInfo storeInfo = aStoreInfoMerged[i];
                    int iPart = GUIDHelper.getPartition(storeInfo.getId());
                    if (iPart >= cParts || !ctrl.isAllowed(storeInfo.getId())) continue;
                    if (partsRecover.contains(iPart)) {
                        listRecover.add(storeInfo);
                    }
                    if (!partsGlobal.contains(iPart) || sSnapshot != null || aBackupStoreInfo != null && (aBackupStoreInfo == null || Arrays.binarySearch(aBackupStoreInfo, storeInfo) >= 0)) continue;
                    PartitionControl ctrlPart = this.getPartitionControl(iPart);
                    PersistentStore persistentStore = store = ctrlPart == null ? null : ctrlPart.getPersistentStore();
                    if (store != null && store.getId().equals(storeInfo.getId())) continue;
                    listGlobal.add(storeInfo);
                }
                GUIDHelper.GUIDResolver resolver = new GUIDHelper.GUIDResolver(cParts);
                resolver.registerStoreInfo(this.getThisMember(), listRecover.toArray(new PersistentStoreInfo[listRecover.size()]));
                msgResponse.setStoreInfos(resolver.getNewestStoreInfos(partsRecover));
                if (sSnapshot == null) {
                    PartitionSet partsOwned = this.collectOwnedPartitions(true);
                    Binary binQuorum = null;
                    if (partsOwned.intersects(partsGlobal)) {
                        binQuorum = this.getPersistenceControl().getQuorumRaw();
                    }
                    if (binQuorum == null && !listGlobal.isEmpty()) {
                        resolver = new GUIDHelper.GUIDResolver(cParts);
                        resolver.registerStoreInfo(this.getThisMember(), listGlobal.toArray(new PersistentStoreInfo[listGlobal.size()]));
                        PersistentStore<ReadBuffer> storeGlobal = null;
                        PersistenceManager quorumMgr = mgr;
                        String sGUID = resolver.getNewestGUIDs(partsGlobal)[0];
                        try {
                            storeGlobal = quorumMgr.open(sGUID, null);
                            CachePersistenceHelper.validate(storeGlobal, this);
                            binQuorum = CachePersistenceHelper.readQuorumRaw(storeGlobal);
                        }
                        catch (ConcurrentAccessException concurrentAccessException) {
                        }
                        catch (PersistenceException e) {
                            PartitionedService._trace("Failed to open a global store: " + PartitionedService.getStackTrace(e), 1);
                        }
                        finally {
                            if (storeGlobal != null) {
                                quorumMgr.close(storeGlobal.getId());
                            }
                        }
                    }
                    msgResponse.setQuorumRaw(binQuorum);
                } else {
                    mgr.release();
                    if (backupMgr != null) {
                        backupMgr.release();
                    }
                }
            }
        }
        if (mapUpdate != null && !mapUpdate.isEmpty()) {
            PartitionSet parts = new PartitionSet(this.getPartitionCount());
            Iterator iter = mapUpdate.keySet().iterator();
            while (iter.hasNext()) {
                int iPart = (Integer)iter.next();
                PartitionControl control = this.getPartitionControl(iPart);
                control.doSyncBackups();
                this.firePartitionEvent(6, iPart, null, this.getThisMember());
                parts.add(iPart);
                control.unlock();
            }
            this.putPartitionConfig(mapUpdate);
            PartitionedService._trace("Restored from backup " + parts.cardinality() + " partitions: " + String.valueOf(parts), 3);
        }
        this.setRestoreInProgress(false);
        msgResponse.setAssignments(this.getPartitionAssignments());
        msgResponse.setSuccess(true);
        this.post(msgResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinalizeSendPrimary(PartitionSet parts) {
        PartitionControl[] aCtrlPartition = this.getPartitionControl();
        Continuations continuations = this.getContinuations();
        TransferControl ctrlTransfer = this.getTransferControl();
        DistributionRequest msgRequest = (DistributionRequest)ctrlTransfer.getDistributionRequest();
        int iPart = parts.next(0);
        while (iPart >= 0) {
            PartitionControl ctrl;
            PartitionControl partitionControl = ctrl = aCtrlPartition[iPart];
            synchronized (partitionControl) {
                int cPolls = ctrl.getBackupPolls().get();
                if (cPolls > 0) {
                    PartitionedService._trace("Deferring primary transfer for " + String.valueOf(parts) + " to member " + msgRequest.getFromMember().getId() + " due to " + cPolls + " outsdanding backups", 3);
                    ctrl.addBackupsCompletedAction(continuations.wrapAsMessage(continuations.instantiateFinalizeSendPrimary(parts)));
                    return;
                }
            }
            iPart = parts.next(iPart + 1);
        }
        Member memberTo = msgRequest.getFromMember();
        int cParts = parts.cardinality();
        int cSent = 0;
        int iPart2 = parts.next(0);
        while (iPart2 >= 0) {
            if (ctrlTransfer.isTransferFull()) {
                ctrlTransfer.cancelTransmit(iPart2);
                aCtrlPartition[iPart2].unlock(true);
                parts.remove(iPart2);
            } else {
                this.firePartitionEvent(2, iPart2, this.getThisMember(), memberTo);
                this.transferPartition(iPart2, 0, ++cSent == cParts);
            }
            iPart2 = parts.next(iPart2 + 1);
        }
        PartitionedService._trace("Transferring primary " + String.valueOf(parts) + " to member " + memberTo.getId() + " requesting " + msgRequest.getPartitionCount() + (ctrlTransfer.isTransferFull() ? "; transfer threshold exceeded" : ""), 3);
    }

    protected void onFinalizeStartup() {
        this.setAcceptingClients(true);
        this.notifyServiceJoined();
    }

    @Override
    public void onInit() {
        super.onInit();
        String sScratch = Config.getProperty("coherence.distributed.scratchspace", String.valueOf("50M"));
        this.setScratchSpaceCounter(new AtomicLong(new MemorySize(sScratch).getByteCount()));
        this.setContinuations((Continuations)this._findChild("Continuations"));
        this.setPartitionConfigMap((PartitionConfig.Map)((PartitionConfig)this._findChild("PartitionConfig")).getMap());
    }

    @Override
    protected void onInterval() {
        if (this.isAcceptingClients() && this.isOwnershipEnabled() && this.getBackupCount() > 0) {
            int nMemberThis = this.getThisMember().getId();
            int[][] aaiOwner = this.getPartitionAssignments();
            PartitionControl[] actrlPartition = this.getPartitionControl();
            int cParts = actrlPartition.length;
            for (int iPart = 0; iPart < cParts; ++iPart) {
                PartitionControl ctrlPartition = actrlPartition[iPart];
                if (ctrlPartition == null || aaiOwner[iPart][0] == nMemberThis) continue;
                ctrlPartition.checkDeferredBackups();
            }
        }
        super.onInterval();
    }

    @Override
    protected void onNotify() {
        super.onNotify();
        if (!this.isExiting()) {
            if (this.isAcceptingOthers()) {
                long ldtNow = Base.getLastSafeTimeMillis();
                if (ldtNow >= this.getDistributionNextMillis()) {
                    this.checkDistribution();
                }
            } else if (this.getServiceState() == 2 && this.isFinalizing()) {
                this.finalizeStartup();
            }
        }
    }

    public void onNotifyServiceLeaving(Member member) {
        if (this.isAcceptingClients() && this.isOwnershipEnabled(this.getThisMember()) && this.isOwnershipEnabled(member)) {
            this.getDistributionStrategy().onMembershipChanged(2);
            this.getPersistenceControl().onMembershipChanged(2);
        }
    }

    @Override
    public void onNotifyServiceLeft(Member member) {
        boolean fWasOwnershipSenior = member == this.getOwnershipSenior(true);
        boolean fOwner = this.isOwnershipEnabled(member);
        super.onNotifyServiceLeft(member);
        if (fOwner) {
            if (this.isAcceptingClients()) {
                this.validatePartitionAssignments(this.getOwnershipMemberSet(true));
                if (this.isOwnershipEnabled(this.getThisMember())) {
                    this.getTransferControl().onMemberLeft(member);
                    this.getDistributionStrategy().onMembershipChanged(3);
                    this.getPersistenceControl().onMembershipChanged(3);
                    if (fWasOwnershipSenior && this.getOwnershipSenior(true) == this.getThisMember()) {
                        this.onOwnershipSeniority(member);
                    }
                }
            }
            this.getPartitionConfigMap().onServiceLeft(member, fWasOwnershipSenior);
        }
    }

    @Override
    public void onNotifyServiceQuiescence(boolean fResume, boolean fResumeOnFailover) {
        super.onNotifyServiceQuiescence(fResume, fResumeOnFailover);
        if (this.isOwnershipEnabled() && this.isAcceptingClients()) {
            if (fResume) {
                this.getDistributionStrategy().scheduleImmediate();
                this.getPersistenceControl().onServiceResume();
            } else {
                this.setDistributionNextMillis(Long.MAX_VALUE);
                this.getPersistenceControl().onServiceSuspend(fResumeOnFailover);
            }
        }
    }

    public void onNotifyShutdown() {
        this.setServiceState(3);
        if (!this.isOwnershipEnabled()) {
            this.stop();
        } else {
            this.setOwnershipEnabled(false);
        }
    }

    public void onNotifySnapshotRecoverRequest(String sSnapshot) {
        if (this.getOwnershipInProgress() <= 0) {
            this.doOwnershipProtocol(this.getOwnershipMemberSet(), sSnapshot);
        } else {
            this.getPersistenceControl().getSnapshotController().onRecoveryCompleted(sSnapshot, this.instantiatePartitionSet(true), null);
        }
    }

    public void onOwnershipRequest(OwnershipRequest msgRequest) {
        MemberSet setMemberThis = this.getOwnershipMemberSet();
        MemberSet setMemberThat = msgRequest.getSenderMemberSet();
        OwnershipResponse msgResponse = (OwnershipResponse)this.instantiateMessage("OwnershipResponse");
        if (this.isOwnershipChangeInProgress() || this.isDistributionInProgress()) {
            PartitionedService._trace("Unable to determine the ownership due to in-progress transfer", 3);
        } else if (!setMemberThis.equals(setMemberThat)) {
            StringBuilder sb = new StringBuilder();
            MemberSet setDelta = new MemberSet();
            setDelta.addAll((Collection)setMemberThis);
            setDelta.removeAll((Collection)setMemberThat);
            if (!setDelta.isEmpty()) {
                sb.append("; requestor's member set is missing " + String.valueOf(setDelta));
            }
            setDelta.clear();
            setDelta.addAll((Collection)setMemberThat);
            setDelta.removeAll((Collection)setMemberThis);
            if (!setDelta.isEmpty()) {
                sb.append("; requestor's member set has extra " + String.valueOf(setDelta));
            }
            PartitionedService._trace("Deferring the ownership reconciliation prematurely requested by member " + msgRequest.getFromMember().getId() + " due to pending membership change" + sb.toString(), 3);
        } else {
            int[][] aaiOwner;
            int[][] aaiOwnerThat = msgRequest.getRequestAssignments();
            if (msgRequest.isQuery()) {
                if (aaiOwnerThat != null) {
                    this.calculateOwnershipConflicts(msgRequest.getFromMember().getId(), aaiOwnerThat, msgRequest.getRequestCount());
                }
                aaiOwner = this.getPartitionAssignments();
                if (msgRequest.getSnapshotToRecover() != null) {
                    PartitionSet partsAbandon = this.collectOwnedPartitions(true);
                    partsAbandon.add(this.collectOwnedPartitions(false));
                    this.abandonPartitions(partsAbandon);
                    aaiOwner = new int[this.getPartitionCount()][this.getBackupCount() + 1];
                }
            } else {
                this.restoreOrphans(msgRequest);
                return;
            }
            msgResponse.setAssignments(aaiOwner);
            msgResponse.setSuccess(true);
        }
        msgResponse.respondTo(msgRequest);
        this.post(msgResponse);
    }

    public void onOwnershipRequestCompleted(OwnershipRequest msgRequest, int cConflicts) {
        String sSnapshot = msgRequest.getSnapshotToRecover();
        long ldtNow = Base.getSafeTimeMillis();
        if (cConflicts == 0) {
            if (this.getServiceState() == 2) {
                PartitionedService._assert(this.getThisMember() == this.getOwnershipSenior());
                if (msgRequest.isQuery()) {
                    int[][] aaiOwnersResolved = msgRequest.getConflictResolver().getResolvedAssignments();
                    int cPartitions = this.getPartitionCount();
                    int cBackups = this.getBackupCount();
                    PartitionSet partsRecover = null;
                    for (int iPart = 0; iPart < cPartitions; ++iPart) {
                        int[] aiOwners = aaiOwnersResolved[iPart];
                        boolean fOrphan = true;
                        for (int iStore = 0; iStore <= cBackups; ++iStore) {
                            if (aiOwners[iStore] == 0) continue;
                            fOrphan = false;
                            break;
                        }
                        if (!fOrphan) continue;
                        if (partsRecover == null) {
                            partsRecover = this.instantiatePartitionSet(false);
                        }
                        partsRecover.add(iPart);
                    }
                    MemberSet setOwners = this.getOwnershipMemberSet();
                    OwnershipRequest msg = (OwnershipRequest)this.instantiateMessage("OwnershipRequest");
                    msg.setSenderMemberSet(setOwners);
                    msg.setSnapshotToRecover(sSnapshot);
                    msg.setQuery(false);
                    msg.setRecoveryPartitions(partsRecover);
                    msg.setToMemberSet(setOwners);
                    msg.setRequestAssignments(aaiOwnersResolved);
                    this.post(msg);
                } else {
                    this.setOwnershipInProgress(0);
                    PartitionSet partsRecover = msgRequest.getRecoveryPartitions();
                    if (partsRecover == null) {
                        this.setDistributionNextMillis(0L);
                    } else {
                        GUIDHelper.GUIDResolver resolver = msgRequest.getPersistentIdResolver();
                        if (sSnapshot != null || this.isRecoverPartitionsAllowed(partsRecover, resolver, msgRequest.getQuorumInfo())) {
                            MemberSet setOwners = this.getOwnershipMemberSet();
                            Set setLeaving = this.getOwnershipLeavingMembers(setOwners);
                            this.getDistributionStrategy().recoverOrphans(partsRecover, setOwners, setLeaving, resolver, sSnapshot);
                        } else {
                            this.setDistributionNextMillis(ldtNow + (long)this.getDistributionRepeatMillis());
                            return;
                        }
                    }
                    if (this.isActivePersistence()) {
                        PartitionSet parts = this.instantiatePartitionSet(false);
                        int[][] aaiOwnersOld = msgRequest.getRequestAssignments();
                        int[][] aaiOwnersNew = this.getPartitionAssignments();
                        int cPart = aaiOwnersOld.length;
                        for (int iPart = 0; iPart < cPart; ++iPart) {
                            if (aaiOwnersOld[iPart][0] != 0 || aaiOwnersNew[iPart][0] == 0) continue;
                            parts.add(iPart);
                        }
                        if (!parts.isEmpty()) {
                            PartitionRecoverCleanup msg = (PartitionRecoverCleanup)this.instantiateMessage("PartitionRecoverCleanup");
                            msg.setPartitions(parts);
                            msg.setToMemberSet(this.getOwnershipMemberSet());
                            this.post(msg);
                        }
                    }
                }
            }
        } else if (sSnapshot == null) {
            this.setDistributionNextMillis(ldtNow + 500L);
            this.setOwnershipInProgress(cConflicts <= 0 ? 0 : -this.getOwnershipInProgress());
        } else {
            PartitionSet partsOrphan = this.collectOrphanPartitions();
            if (!partsOrphan.isEmpty()) {
                PartitionedService._trace("Encountered " + cConflicts + " unexpected ownership conflicts while attempting to recover " + String.valueOf(partsOrphan) + " from snapshot", 2);
                this.getPersistenceControl().getSnapshotController().onRecoveryCompleted(sSnapshot, partsOrphan, null);
            }
        }
    }

    public void onOwnershipSeniority(Member memberPreviousSenior) {
        PersistenceEnvironment env = null;
        SnapshotArchiver arch = null;
        PersistenceControl ctrl = this.getPersistenceControl();
        if (ctrl.isValid()) {
            env = SafePersistenceWrappers.unwrap(ctrl.getPersistenceEnvironment());
            arch = ctrl.getSnapshotArchiver();
            ctrl.onOwnershipSeniority();
        }
        SimpleElement xmlConfig = new SimpleElement("persistence-config");
        xmlConfig.addAttribute("persistence-active-failure-mode").setString(this.isActivePersistence() && ctrl != null ? (ctrl.getActiveFailureMode() == 0 ? "stop-service" : "stop-persistence") : "none");
        xmlConfig.addAttribute("persistence-environment").setString(env == null ? "none" : env.getClass().getName());
        xmlConfig.addAttribute("persistence-mode").setString(this.isActivePersistence() ? "active" : "on-demand");
        xmlConfig.addAttribute("persistence-snapshot-archiver").setString(arch == null ? "none" : arch.getClass().getName());
        this.getThisMemberConfigMap().put("persistence-config", xmlConfig);
    }

    protected void onOwnershipStable() {
        if (this.isActivePersistence()) {
            PartitionSet partsGlobal = CachePersistenceHelper.getGlobalPartitions(this);
            PartitionSet partsOwned = this.collectOwnedPartitions(true);
            partsGlobal.retain(partsOwned);
            int iPart = partsGlobal.next(0);
            while (iPart >= 0) {
                Binary binQuorum = CachePersistenceHelper.writeQuorum(this.ensurePartitionControl(iPart).ensureOpenPersistentStore(), this);
                if (this.isVersionCompatible(this.getOwnershipMemberSet(), 12, 2, 1, 1, 0)) {
                    this.getPartitionConfigMap().put(PartitionConfig.KEY_QUORUM, binQuorum);
                }
                iPart = partsGlobal.next(iPart + 1);
            }
            this.getPersistenceControl().setForceRecovery(false);
        }
        PartitionedService._trace("Partition ownership has stabilized with " + this.getOwnershipMemberSet().size() + " nodes", 3);
    }

    public void onPartitionAbandonRequest(PartitionAbandonRequest msgRequest) {
        this.abandonPartitions(msgRequest.getPartitionSet());
    }

    public void onPartitionConfigUpdate(MapEvent event) {
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        int nMemberThis = this.getThisMember().getId();
        int cBackups = this.getBackupCount();
        int iPartition = (Integer)event.getKey();
        VersionedOwnership owners = (VersionedOwnership)event.getNewValue();
        VersionedOwnership ownersPrev = (VersionedOwnership)event.getOldValue();
        int[][] aaiOwner = this.getPartitionAssignments();
        int nOwnedIndex = this.getOwnedIndex(iPartition, nMemberThis);
        boolean fPrimeOwner = nOwnedIndex == 0;
        boolean fBackupOwner = nOwnedIndex > 0;
        boolean fRepublish = false;
        for (int iStore = 0; iStore <= cBackups; ++iStore) {
            int nOwnerLocal = aaiOwner[iPartition][iStore];
            int nOwnerGlobal = ownersPrev == null ? 0 : ownersPrev.getOwner(iStore);
            int nOwnerNew = owners.getOwner(iStore);
            int nVersionLocal = this.getOwnershipVersion(iPartition);
            int nVersionGlobal = ownersPrev == null ? 0 : ownersPrev.getVersion();
            int nVersionNew = owners.getVersion();
            if (fPrimeOwner) {
                if (nOwnerNew != nOwnerLocal && nOwnerNew != nOwnerGlobal || iStore == 0 && nVersionNew != nVersionLocal && nVersionNew != nVersionGlobal) {
                    PartitionedService._trace("Obsolete partition info; restoring " + (String)(iStore == 0 ? "primary" : "backup[" + iStore + "]") + " owner for partition " + iPartition + " from member " + nOwnerNew + " at version " + nVersionNew + " to " + nOwnerGlobal + (String)(nOwnerLocal == nOwnerGlobal ? "" : " (local=" + nOwnerLocal + ")") + " at version " + nVersionGlobal + (String)(nVersionLocal == nVersionGlobal ? "" : " (local=" + nVersionLocal + ")"), 3);
                    owners.setOwner(iStore, nOwnerGlobal);
                    owners.setVersion(nVersionGlobal);
                    fRepublish = true;
                    continue;
                }
                if (iStore != 0) continue;
                this.onPrimaryOwnershipChanged(iPartition);
                continue;
            }
            if (iStore == 0 && nOwnerNew == nMemberThis) {
                PartitionedService._trace("Rejecting obsolete ownership update for partition " + iPartition + "[" + nOwnerLocal + "]", 3);
                if (nOwnerLocal == 0) {
                    owners.setPrimaryOwner(0);
                    fRepublish = true;
                    break;
                }
                owners.setOwners(ownersPrev);
                continue;
            }
            if (nOwnerNew > 0 && ((MemberSet)setMembers).getMember(nOwnerNew) == null) {
                PartitionedService._trace("Ignoring obsolete " + (String)(iStore == 0 ? "primary" : "backup[" + iStore + "]") + " partition info for partition " + iPartition + "; member " + nOwnerNew + " has departed", 3);
                if (nOwnerLocal == nMemberThis) {
                    owners.setOwner(iStore, nOwnerGlobal);
                    continue;
                }
                owners.setOwner(iStore, 0);
                aaiOwner = this.assignPartitionOwner(iPartition, iStore, 0);
                if (iStore != 0) continue;
                this.onPrimaryOwnershipChanged(iPartition);
                continue;
            }
            if (nOwnerNew != nOwnerLocal) {
                if (this.getServiceState() != 3) {
                    if (nOwnerNew == nMemberThis) {
                        int nOwner;
                        Member memberOwner;
                        PartitionedService._trace("Deferring backup[" + iStore + "] partition ownership for partition " + iPartition + " (owners=" + String.valueOf(owners) + ")", 3);
                        if (this.isBackupOwner(iPartition)) continue;
                        owners.setOwner(iStore, 0);
                        fRepublish = true;
                        TransferControl ctrlTransfer = this.getTransferControl();
                        if (ctrlTransfer.isTransferInProgress(iPartition) || (memberOwner = ((MemberSet)setMembers).getMember(nOwner = aaiOwner[iPartition][0])) == null) continue;
                        ctrlTransfer.sendBackupRelease(iPartition, iStore, nOwner, 0, memberOwner, null);
                        continue;
                    }
                    if (nOwnerLocal == nMemberThis) {
                        PartitionedService._trace("Deferring backup[" + iStore + "] release for partition " + iPartition + " (owners=" + String.valueOf(owners) + ")", 3);
                        continue;
                    }
                    if (iStore == 0 && nOwnerNew == 0 && nOwnerLocal != 0 && this.isOwnershipEnabled()) {
                        this.setDistributionNextMillis(0L);
                    }
                }
                this.setOwnershipVersion(iPartition, nVersionNew);
                aaiOwner = this.assignPartitionOwner(iPartition, iStore, nOwnerNew);
                if (iStore != 0) continue;
                this.onPrimaryOwnershipChanged(iPartition);
                continue;
            }
            if (nVersionNew == nVersionLocal) continue;
            this.setOwnershipVersion(iPartition, nVersionNew);
            this.onPrimaryOwnershipChanged(iPartition);
        }
        if (fRepublish && this.isOwnershipEnabled()) {
            this.putPartitionConfig(iPartition, owners);
        }
    }

    public void onPartitionRecoverCleanup(PartitionRecoverCleanup msg) {
        PersistenceManager mgrActive = this.getPersistenceManager();
        PersistenceManager mgrBackup = this.getPersistenceControl().getBackupManager();
        PersistenceManager mgrEvents = this.getPersistenceEventsManager();
        boolean fPrimary = msg.isPrimary();
        PartitionedService._assert(mgrActive != null);
        PartitionSet parts = msg.getPartitions();
        if (!parts.isEmpty()) {
            long ldtJoinStore;
            int nMemberThis;
            int nMemberStore;
            int c;
            ServiceMemberSet setMembers = this.getServiceMemberSet();
            PersistentStoreInfo[] aInfos = mgrActive.listStoreInfo();
            int n = c = aInfos == null ? 0 : aInfos.length;
            for (int i = 0; i < c; ++i) {
                boolean fEligible;
                String sGUID = aInfos[i].getId();
                int iPart = GUIDHelper.getPartition(sGUID);
                if (iPart >= this.getPartitionCount() || !parts.contains(iPart)) continue;
                VersionedOwnership owners = this.getPartitionConfig(iPart);
                int nMemberOwner = owners.getPrimaryOwner();
                nMemberStore = GUIDHelper.getMemberId(sGUID);
                nMemberThis = this.getThisMember().getId();
                ldtJoinStore = GUIDHelper.getServiceJoinTime(sGUID);
                boolean bl = fEligible = nMemberOwner > 0 && nMemberStore != nMemberOwner && ldtJoinStore != setMembers.getServiceJoinTime(nMemberOwner) && GUIDHelper.getVersion(sGUID) < (long)owners.getVersion();
                if (!fEligible || (nMemberThis != nMemberStore || setMembers.getServiceJoinTime(nMemberThis) != ldtJoinStore) && ldtJoinStore == setMembers.getServiceJoinTime(nMemberStore)) continue;
                Object sSource = null;
                if (mgrActive.delete(sGUID, false)) {
                    sSource = "active";
                }
                if (mgrEvents != null && mgrEvents.delete(sGUID, false)) {
                    Object object = sSource = sSource == null ? "event" : (String)sSource + " and event";
                }
                if (sSource == null) continue;
                PartitionedService._trace("Removed old partition (" + sGUID + ") from " + (String)sSource + " persistent directory store", 7);
            }
            if (!msg.isPrimary() && mgrBackup != null) {
                int c2;
                PersistentStoreInfo[] aBackupInfos = mgrBackup.listStoreInfo();
                int n2 = c2 = aBackupInfos == null ? 0 : aBackupInfos.length;
                for (int i = 0; i < c2; ++i) {
                    String sGUID = aBackupInfos[i].getId();
                    int iPart = GUIDHelper.getPartition(sGUID);
                    if (iPart >= this.getPartitionCount()) continue;
                    VersionedOwnership owners = this.getPartitionConfig(iPart);
                    nMemberStore = GUIDHelper.getMemberId(sGUID);
                    if (this.isInOwnerMembers(nMemberStore, owners)) continue;
                    nMemberThis = this.getThisMember().getId();
                    ldtJoinStore = GUIDHelper.getServiceJoinTime(sGUID);
                    if (nMemberStore == nMemberThis || ldtJoinStore == setMembers.getServiceJoinTime(nMemberThis) || ldtJoinStore == setMembers.getServiceJoinTime(nMemberStore) || !mgrBackup.delete(sGUID, false)) continue;
                    PartitionedService._trace("Removed old partition (" + sGUID + ") from backup persistent directory store", 7);
                }
            }
        }
    }

    private boolean isInOwnerMembers(int nMemberStore, VersionedOwnership owners) {
        for (int i = 1; i < owners.getBackupCount() + 1; ++i) {
            if (owners.getOwner(i) != nMemberStore) continue;
            return true;
        }
        return false;
    }

    public void onPartitionRecoverJob(PartitionRecoverRequest.RecoverJob job) {
        boolean fSnapshot;
        PartitionRecoverInfo info = job.getRecoverInfo();
        List listGUID = job.getListGUID();
        int cGUID = listGUID.size();
        HashMap<Integer, Object[]> mapStoresFrom = new HashMap<Integer, Object[]>(cGUID);
        PartitionSet partsFail = this.instantiatePartitionSet(false);
        PartitionSet partsEventsFail = this.instantiatePartitionSet(false);
        PersistenceManager mgrRecover = info.getManager();
        PartitionRecoverRequest msgRequest = (PartitionRecoverRequest)info.getRequest();
        String[] asInvalidGUIDs = msgRequest.getInvalidPersistentIds();
        String[] asGUID = listGUID.toArray(new String[cGUID]);
        PersistenceControl ctrl = this.getPersistenceControl();
        boolean bl = fSnapshot = ctrl.getActiveManager() != mgrRecover;
        if (mgrRecover != null) {
            int i;
            PersistenceManager backupMgr = fSnapshot ? null : ctrl.getBackupManager();
            PersistentStoreInfo[] aBackupStores = backupMgr == null ? null : backupMgr.listStoreInfo();
            PersistentStoreInfo[] aPrimaryStores = null;
            MemberSet ownershipMembers = this.getOwnershipMemberSet();
            if (asInvalidGUIDs != null) {
                int c = asInvalidGUIDs.length;
                for (i = 0; i < c; ++i) {
                    String sGUID = asInvalidGUIDs[i];
                    if (fSnapshot) {
                        mgrRecover.close(sGUID);
                        continue;
                    }
                    mgrRecover.delete(sGUID, false);
                }
            }
            if (aBackupStores != null) {
                Arrays.sort(aBackupStores, PersistentStoreInfo::compareTo);
                aPrimaryStores = mgrRecover.listStoreInfo();
                Arrays.sort(aPrimaryStores, PersistentStoreInfo::compareTo);
            }
            for (i = 0; i < cGUID && this.getServiceState() < 3; ++i) {
                String sGUID = asGUID[i];
                int iPart = GUIDHelper.getPartition(sGUID);
                long lJoinTime = GUIDHelper.getServiceJoinTime(sGUID);
                int nMember = GUIDHelper.getMemberId(sGUID);
                if (!fSnapshot && this.getThisMember().getId() != nMember && ownershipMembers.contains(nMember) && lJoinTime == this.getServiceMemberSet().getServiceJoinTime(nMember)) {
                    partsFail.add(iPart);
                    this.onStoreOpenFailed(mgrRecover, iPart, sGUID, null);
                    continue;
                }
                boolean fBackup = aBackupStores != null && Arrays.stream(aBackupStores).anyMatch(s -> sGUID.equals(s.getId())) && !Arrays.stream(aPrimaryStores).anyMatch(s -> sGUID.equals(s.getId()));
                try {
                    mapStoresFrom.put(iPart, new Object[]{ctrl.openStoreForRead(fBackup ? backupMgr : mgrRecover, sGUID), fBackup});
                    if ((i & 0xF) != 15) continue;
                    this.heartbeat();
                    continue;
                }
                catch (PersistenceException e) {
                    partsFail.add(iPart);
                    this.onStoreOpenFailed(mgrRecover, iPart, sGUID, e);
                }
            }
        }
        Map mapStoresTo = this.openStores(mgrRecover, mapStoresFrom, partsFail, partsEventsFail);
        this.recoverPartitions(job, mapStoresFrom, mapStoresTo, partsFail, partsEventsFail);
    }

    protected void onPartitionsAssigned(PartitionSet partsAssigned, PartitionSet partsLost, Continuation continuation) {
    }

    public void onPartitionsRecovered(PartitionSet partsRecovered, String sSnapshotName, Continuation continuation) {
    }

    protected void onPartitionsRestored(PartitionSet partsRestored, Continuation continuation) {
    }

    public void onPartitionSwapRequest(PartitionSwapRequest msgRequest) {
        PartitionedService._assert(this.isOwnershipEnabled());
        int iPartition = msgRequest.getPartition();
        int iStoreLow = msgRequest.getPromoteIndex();
        int iStoreHigh = iStoreLow + 1;
        this.assignPartitionOwners(iPartition, msgRequest.getOwners().getOwners());
        int[] aiOwner = this.getPartitionAssignments()[iPartition];
        int nMemberToPromote = aiOwner[iStoreHigh];
        aiOwner[iStoreHigh] = aiOwner[iStoreLow];
        aiOwner[iStoreLow] = nMemberToPromote;
    }

    public void onPrimaryOwnershipChanged(int nPartition) {
        if (this.getPartitionAssignments()[nPartition][0] != 0) {
            this.clearContention(nPartition);
        }
        if (this.isOwnershipEnabled(this.getThisMember())) {
            this.getPersistenceControl().onPrimaryOwnershipChanged(nPartition);
            this.setDistributionStable(false);
        }
    }

    public void onRecoverFailed(PersistenceManager mgrRecover, String sGUID, boolean fDelete) {
        if (this.getServiceState() < 3) {
            if (this.isSnapshotManager(mgrRecover)) {
                mgrRecover.close(sGUID);
            } else if (fDelete) {
                mgrRecover.delete(sGUID, true);
            }
        }
    }

    @Override
    public void onServiceStarted() {
        if (!this.validateServiceConfig()) {
            this.setOwnershipEnabled(false);
            this.post(this.instantiateMessage("NotifyShutdown"));
            return;
        }
        KeyAssociator associator = this.getKeyAssociator();
        KeyPartitioningStrategy partitioning = this.getKeyPartitioningStrategy();
        int cPartitions = this.getPartitionCount();
        this.setPartitionContention(new Contention[cPartitions]);
        this.setPartitionAssignments(new int[cPartitions][this.getBackupCount() + 1]);
        this.setOwnershipVersion(new int[cPartitions]);
        ConverterKeyToBinary convKeyDown = this.instantiateKeyToBinaryConverter(null, false);
        this.setKeyToBinaryConverter(convKeyDown);
        associator.init(this);
        if (partitioning == null) {
            this.setKeyPartitioningStrategy(convKeyDown);
        } else {
            partitioning.init(this);
        }
        if (this.isOwnershipEnabled()) {
            int cDaemonsMax;
            PersistenceManager mgrActive;
            this.setPartitionControl(new PartitionControl[cPartitions]);
            PersistenceControl ctrlPersistence = this.getPersistenceControl();
            com.tangosol.coherence.component.util.DaemonPool pool = null;
            int cDaemons = this.getDependencies().getWorkerThreadCountMin();
            this.setConcurrent(cDaemons != 0);
            if (cDaemons > 0) {
                pool = this.getDaemonPool();
                pool.setThreadGroup(new ThreadGroup(this.getServiceName()));
                PersistenceEnvironment env = SafePersistenceWrappers.unwrap(ctrlPersistence.getPersistenceEnvironment());
                if (env instanceof AbstractPersistenceEnvironment) {
                    ((AbstractPersistenceEnvironment)env).setDaemonPool(pool);
                }
            }
            if ((mgrActive = ctrlPersistence.openActiveManager()) != null && cDaemons == 1 && (cDaemonsMax = pool.getDaemonCountMax()) > 2) {
                pool.setDaemonCountMin(Math.min(Math.max(Platform.getPlatform().getFairShareProcessors(), 2), cDaemonsMax - 1));
            }
            if (pool != null) {
                pool.start();
            }
            this.ensureEventDispatcher();
        }
        this.getServiceConfigMap().getConfig().attachConfigListener();
        this.getPartitionConfigMap().getConfig().attachConfigListener();
        this.getDistributionStrategy().initialize();
        this.setPartitionEvents(new LocalCache(Integer.MAX_VALUE, 3600000));
        this.finalizeStartup();
        if (this.isActivePersistence()) {
            this.scheduleEnvironmentMaintenance();
        }
    }

    @Override
    protected void onServiceStopping() {
        if (this.getThisMember() == this.getOwnershipSenior()) {
            this.setDistributionNextMillis(0L);
        }
    }

    public void onStoreOpenFailed(PersistenceManager mgrRecover, int nPartition, String sGUID, PersistenceException e) {
        String sMsg = "Failed to recover partition " + nPartition + " from the persistent storage (GUID=" + sGUID + ")";
        int nLogLevel = 2;
        if (e instanceof FatalAccessException) {
            sMsg = sMsg + "; " + e.getMessage();
            if (this.getServiceState() < 3) {
                if (this.isSnapshotManager(mgrRecover)) {
                    mgrRecover.close(sGUID);
                } else {
                    mgrRecover.delete(sGUID, true);
                    sMsg = sMsg + "; reinstate persistent store from trash once validation errors have been resolved";
                }
            }
        } else if (this.getServiceState() < 3) {
            if (this.isSnapshotManager(mgrRecover)) {
                mgrRecover.close(sGUID);
            } else {
                mgrRecover.writeSafe(sGUID);
            }
            this.getPersistenceControl().onTransientException(sGUID);
            sMsg = sMsg + "; excluded from future recovery requests";
            nLogLevel = 3;
        }
        PartitionedService._trace(sMsg + (String)(e == null ? "" : "\n" + Base.getStackTrace(e)), nLogLevel);
    }

    public void onTransferCompleted(boolean fSuccess, Object oResult, TransferRequest msg) {
    }

    public void onTransferRequest(TransferRequest msgRequest) {
        PartitionedService._assert(this.isDistributionInProgress() || msgRequest.getStore() > 0);
        TransferControl ctrlTransfer = this.getTransferControl();
        Member memberThis = this.getThisMember();
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        boolean fLastInPartition = msgRequest.isLastInPartition();
        boolean fLastInTransfer = msgRequest.isLastInTransfer();
        int iPartition = msgRequest.getPartition();
        PartitionControl ctrlPart = this.getPartitionControl(iPartition);
        if (this.isAcceptingClients() && this.isOwnershipEnabled() && (ctrlPart == null || !ctrlPart.isLocked())) {
            int iStore = msgRequest.getStore();
            Span augmentSpan = TracingHelper.augmentSpan();
            augmentSpan.setMetadata("partition", iPartition);
            augmentSpan.setMetadata("replica", iStore);
            if (iStore == 0) {
                Continuation continuation = null;
                if (fLastInTransfer) {
                    continuation = this.getContinuations().instantiateFinalizeReceivePrimary(msgRequest);
                } else {
                    TransferResponse msgResponse = (TransferResponse)this.instantiateMessage("TransferResponse");
                    msgResponse.respondTo(msgRequest);
                    msgResponse.setValue(0);
                    this.post(msgResponse);
                }
                ctrlTransfer.onReceiveStarted(msgRequest, continuation);
            } else {
                int[][] aaiOwner = this.getPartitionAssignments();
                ctrlTransfer.onReceiveStarted(msgRequest, null);
                if (fLastInPartition) {
                    this.preparePartition(iPartition, iStore);
                    Member memberPrimary = msgRequest.getFromMember();
                    List listXfersIn = ctrlTransfer.getQueuedTransfers(memberPrimary);
                    PartitionControl ctrlPartition = this.ensurePartitionControl(iPartition);
                    this.receivePartition(iPartition, iStore, listXfersIn);
                    listXfersIn.clear();
                    ctrlPartition.getVersionCounter().set(msgRequest.getPartitionVersion());
                    aaiOwner[iPartition][iStore] = memberThis.getId();
                    int nPrevBackup = msgRequest.getOwners().getOwner(iStore);
                    Member memberPrev = ((MemberSet)setMembers).getMember(nPrevBackup);
                    if (memberPrev == null) {
                        ctrlTransfer.sendBackupAnnounce(iPartition, iStore, memberPrimary, null);
                    } else {
                        ctrlTransfer.sendBackupRelease(iPartition, iStore, memberPrimary.getId(), memberThis.getId(), memberPrev, null);
                    }
                }
                if (fLastInTransfer) {
                    ctrlTransfer.onReceiveCommitted(msgRequest);
                }
                TransferResponse msgResponse = (TransferResponse)this.instantiateMessage("TransferResponse");
                msgResponse.respondTo(msgRequest);
                msgResponse.setValue(fLastInPartition ? -2 : 0);
                this.post(msgResponse);
            }
        } else {
            TransferResponse msgResponse = (TransferResponse)this.instantiateMessage("TransferResponse");
            msgResponse.respondTo(msgRequest);
            msgResponse.setValue(-1);
            this.post(msgResponse);
        }
    }

    public void onTransferRequestCompleted(TransferRequest msgRequest) {
        if (this.getServiceState() == 4) {
            return;
        }
        Object oResult = msgRequest.getResponse();
        int[][] aaiOwner = this.getPartitionAssignments();
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        Member memberThis = this.getThisMember();
        int nMemberThis = memberThis.getId();
        TransferControl ctrlTransfer = this.getTransferControl();
        PartitionControl[] aCtrlPartition = this.getPartitionControl();
        boolean fPrimary = msgRequest.getStore() == 0;
        if (fPrimary) {
            if (oResult instanceof Integer) {
                int iResult = (Integer)oResult;
                if (iResult == -1) {
                    if (msgRequest.isLastInTransfer()) {
                        HashMap<Integer, VersionedOwnership> mapOwners = new HashMap<Integer, VersionedOwnership>();
                        PartitionSet partsLocked = new PartitionSet(this.getPartitionCount());
                        TransferControl.TransferIterator iter = ctrlTransfer.iterateTransfersInProgress();
                        while (iter.hasNext()) {
                            iter.next();
                            int iPartition = iter.getPartition();
                            int iStore = iter.getBackup();
                            int nOwner = aaiOwner[iPartition][0];
                            PartitionedService._assert(iStore == 0);
                            if (nOwner == nMemberThis) continue;
                            int nMemberRecipient = msgRequest.getRecipient().getId();
                            PartitionedService._trace("Failed primary transfer for partition " + iPartition + " to member " + nMemberRecipient + "; reclaiming the ownership from member " + nOwner, 3);
                            this.incrementOwnershipVersion(iPartition);
                            int nVersionNew = this.incrementOwnershipVersion(iPartition);
                            this.assignPartitionOwner(iPartition, 0, nMemberThis);
                            if (this.isActivePersistence()) {
                                aCtrlPartition[iPartition].updatePersistentStoreVersion();
                            }
                            this.firePartitionEvent(4, iPartition, null, memberThis);
                            VersionedOwnership owners = new VersionedOwnership(this.getPartitionConfig(iPartition));
                            owners.setOwner(0, nMemberThis);
                            owners.setVersion(nVersionNew);
                            mapOwners.put(iPartition, owners);
                            ctrlTransfer.onTransmitRejected(iPartition, 0);
                            partsLocked.add(iPartition);
                            if (setMembers.contains(nMemberRecipient)) continue;
                            int cBackups = this.getBackupCount();
                            for (int iBackup = 1; iBackup <= cBackups; ++iBackup) {
                                int nBackupOwner = owners.getOwner(iBackup);
                                Member memberBackup = ((MemberSet)setMembers).getMember(nBackupOwner);
                                if (memberBackup == null) continue;
                                ctrlTransfer.requestBackupConfirmation(iPartition, iBackup, nMemberRecipient, memberBackup);
                            }
                        }
                        int iPart = partsLocked.next(0);
                        while (iPart >= 0) {
                            aCtrlPartition[iPart].unlock();
                            iPart = partsLocked.next(iPart + 1);
                        }
                        PartitionedService._assert(!this.isTransferInProgress());
                        this.putPartitionConfig(mapOwners);
                    }
                } else {
                    PartitionedService._assert(iResult == 0);
                }
            } else {
                Map mapResponses = (Map)oResult;
                for (Map.Entry entry : mapResponses.entrySet()) {
                    int iPartition = (Integer)entry.getKey();
                    int iResult = (Integer)entry.getValue();
                    if (iResult == -2) {
                        this.releasePartition(iPartition, 0);
                    } else {
                        PartitionedService._assert(iResult > 0);
                        this.movePartition(iPartition, iResult);
                        aaiOwner[iPartition][iResult] = nMemberThis;
                    }
                    int nMemberTo = msgRequest.getRecipient().getId();
                    this.firePartitionEvent(3, iPartition, memberThis, ((MemberSet)setMembers).getMember(nMemberTo));
                    ctrlTransfer.onTransmitCompleted(iPartition, 0);
                    PartitionControl control = aCtrlPartition[iPartition];
                    control.flushDeferredBackups();
                    control.unlock();
                    if (iResult == -2) {
                        this.releasePartitionControl(iPartition);
                        continue;
                    }
                    control.reset();
                }
                PartitionedService._assert(!this.isTransferInProgress());
            }
        } else {
            int iPartition = msgRequest.getPartition();
            int iStore = msgRequest.getStore();
            if (aaiOwner[iPartition][0] == nMemberThis) {
                int iResult = (Integer)oResult;
                if (iResult == -1) {
                    if (msgRequest.isLastInPartition()) {
                        VersionedOwnership owners = this.getPartitionConfig(iPartition);
                        int nBackupLocal = aaiOwner[iPartition][iStore];
                        int nBackupGlobal = owners.getOwner(iStore);
                        int nMemberRecipient = msgRequest.getRecipient().getId();
                        PartitionedService._assert(nBackupLocal == nMemberRecipient);
                        PartitionedService._trace("Failed backup transfer for partition " + iPartition + " to member " + nMemberRecipient, 3);
                        ctrlTransfer.onTransmitRejected(iPartition, iStore);
                        if (nBackupLocal != nBackupGlobal) {
                            Member memberOwnerPrev = ((MemberSet)setMembers).getMember(nBackupGlobal);
                            if (memberOwnerPrev == null) {
                                aaiOwner[iPartition][iStore] = 0;
                                this.publishPartitionOwnership(iPartition, iStore, 0);
                                this.getPartitionControl(iPartition).enableTransfer();
                            } else {
                                aaiOwner[iPartition][iStore] = nBackupGlobal;
                                if (setMembers.contains(nMemberRecipient)) {
                                    this.getPartitionControl(iPartition).enableTransfer();
                                } else {
                                    ctrlTransfer.requestBackupConfirmation(iPartition, iStore, nMemberRecipient, memberOwnerPrev);
                                }
                            }
                        }
                    }
                } else if (iResult == -2) {
                    if (msgRequest.isLastInPartition()) {
                        ctrlTransfer.onTransmitCompleted(iPartition, iStore);
                        aCtrlPartition[iPartition].reset();
                    }
                } else {
                    PartitionedService._assert(iResult == 0);
                }
                if (msgRequest.isLastInTransfer()) {
                    PartitionedService._assert(!this.isTransferInProgress());
                }
            } else {
                PartitionedService._trace("Partition " + iPartition + " ownership was transferred to member " + aaiOwner[iPartition][0] + " without consent:\n" + String.valueOf(this.getPartitionConfig(iPartition)), 1);
            }
        }
        if (!this.isTransferInProgress()) {
            this.setDistributionNextMillis(Base.getSafeTimeMillis() + (long)(fPrimary ? 0 : this.getDistributionRepeatMillis() / this.getDistributionAggressiveness()));
            this.getDistributionStrategy().setStatsSampleNextMillis(Base.getSafeTimeMillis() + 1000L);
        }
    }

    protected PersistentStore openStoreForRead(PersistenceManager mgr, String sGUID, boolean fOpen) {
        if (fOpen) {
            if (mgr.isEmpty(sGUID)) {
                return mgr.createStore(sGUID);
            }
            int cRetry = 0;
            while (true) {
                try {
                    PersistentStore store = mgr.open(sGUID, null);
                    CachePersistenceHelper.validate(store, this);
                    return store;
                }
                catch (ConcurrentAccessException e) {
                    if (cRetry > 100) {
                        throw new FatalAccessException((Throwable)e);
                    }
                    PartitionedService.sleep(10L);
                    ++cRetry;
                    continue;
                }
                break;
            }
        }
        return mgr.createStore(sGUID);
    }

    public Map openStores(PersistenceManager mgrRecover, Map mapStores, PartitionSet partsFail, PartitionSet partsEventsFail) {
        HashMap<Integer, PersistentStore> mapStoresTo = new HashMap<Integer, PersistentStore>(mapStores.size());
        if (!mapStores.isEmpty()) {
            boolean fSnapshot = mgrRecover != this.getPersistenceManager();
            PartitionedService._trace("Recovering " + mapStores.size() + " partitions", 5);
            Iterator iter = mapStores.entrySet().iterator();
            while (iter.hasNext() && this.getServiceState() < 3) {
                PersistentStore storeTo;
                Integer IPartition;
                block12: {
                    Map.Entry entry = iter.next();
                    IPartition = (Integer)entry.getKey();
                    int nPartition = IPartition;
                    PersistentStore storeFrom = (PersistentStore)((Object[])entry.getValue())[0];
                    String sGUID = storeFrom.getId();
                    PartitionControl ctrlPart = this.getPartitionControl(nPartition);
                    PersistenceControl ctrlPersistence = this.getPersistenceControl();
                    this.heartbeat();
                    storeTo = null;
                    boolean fFailed = false;
                    if (this.isActivePersistence()) {
                        try {
                            storeTo = ctrlPart.ensureOpenPersistentStore(storeFrom, false);
                            CachePersistenceHelper.validate(storeTo, this);
                            CachePersistenceHelper.unseal(storeTo);
                        }
                        catch (PersistenceException e) {
                            PersistentStore<?> storeFailed;
                            String sGUIDFailed;
                            partsFail.add(nPartition);
                            this.onStoreOpenFailed(mgrRecover, nPartition, sGUID, e);
                            if (storeTo == null && !(sGUIDFailed = (storeFailed = e.getPersistentStore()).getId()).equals(sGUID)) {
                                mgrRecover.delete(sGUIDFailed, false);
                            }
                            storeTo = null;
                        }
                        if (this.isPersistEvents()) {
                            PersistentStore storeEvents = null;
                            try {
                                storeEvents = ctrlPart.getPersistentEventsStore();
                                if (storeEvents == null) {
                                    partsEventsFail.add(nPartition);
                                    break block12;
                                }
                                CachePersistenceHelper.validate(storeEvents, this);
                            }
                            catch (PersistenceException e) {
                                PersistentStore<?> storeFailed;
                                partsEventsFail.add(nPartition);
                                if (storeEvents == null && (storeFailed = e.getPersistentStore()) != null) {
                                    ctrlPersistence.getEventsManager().delete(storeFailed.getId(), false);
                                }
                            }
                        }
                    } else {
                        storeTo = storeFrom;
                    }
                }
                if (storeTo == null) continue;
                mapStoresTo.put(IPartition, storeTo);
            }
        }
        return mapStoresTo;
    }

    protected boolean pinOwnedPartition(int nPartition) {
        return this.pinOwnedPartition(nPartition, -1);
    }

    protected boolean pinOwnedPartition(int nPartition, int nVersion) {
        boolean fEntered = false;
        if (!(this.isConcurrent() && !(fEntered = this.enterPartition(nPartition)) || !this.isPrimaryOwner(nPartition) || nVersion != -1 && nVersion != this.getOwnershipVersion(nPartition))) {
            return true;
        }
        if (fEntered) {
            this.exitPartition(nPartition);
        }
        return false;
    }

    protected PartitionSet pinOwnedPartitions(PartitionSet partitions) {
        return this.pinOwnedPartitions(partitions, null);
    }

    protected PartitionSet pinOwnedPartitions(PartitionSet partitions, PartitionVersions versions) {
        boolean fConcurrent = this.isConcurrent();
        PartitionSet partsOther = null;
        int nPartition = partitions.next(0);
        while (nPartition >= 0) {
            int nVersion;
            int n = nVersion = versions == null ? -1 : versions.getVersion(nPartition);
            if (!this.pinOwnedPartition(nPartition, nVersion)) {
                if (partsOther == null) {
                    partsOther = new PartitionSet(this.getPartitionCount());
                }
                partsOther.add(nPartition);
                partitions.remove(nPartition);
            }
            nPartition = partitions.next(nPartition + 1);
        }
        return partsOther;
    }

    protected void preparePartition(int iPartition, int iBackup) {
    }

    public void processBackup(BackupSingleRequest msgBackup) {
        long lVersionNew;
        int iPartition = msgBackup.getPartition();
        PartitionControl control = this.getPartitionControl(iPartition);
        AtomicLong counter = control.getVersionCounter();
        long lVersionExpect = counter.get() + 1L;
        if (lVersionExpect > (lVersionNew = msgBackup.getPartitionVersion())) {
            PartitionedService._trace("Ignoring repeated backup update (version " + lVersionNew + ") for partition " + msgBackup.getPartition() + "; current version is " + lVersionExpect, 5);
            msgBackup.forwardOrReply(msgBackup);
        } else if (lVersionExpect < lVersionNew || !this.isBackupOwner(iPartition) && control.isTransferringOut()) {
            control.deferBackup(msgBackup, lVersionNew);
        } else {
            msgBackup.forwardOrReply(msgBackup);
            msgBackup.doBackup();
            counter.set(lVersionNew);
            control.flushDeferredBackups();
        }
    }

    public void processBackupMulti(BackupMultiRequest msgBackup) {
        PartitionSet parts = msgBackup.getPartitionSet();
        PartitionSet partsDefer = null;
        PrimitiveSparseArray paVersions = msgBackup.getPartitionVersions();
        int iPartition = parts.next(0);
        while (iPartition >= 0) {
            long lVersionNew;
            PartitionControl control = this.getPartitionControl(iPartition);
            long lVersionExpect = control.getVersionCounter().get() + 1L;
            if (lVersionExpect > (lVersionNew = paVersions.getPrimitive(iPartition))) {
                PartitionedService._trace("Ignoring repeated backup update (version " + lVersionNew + ") for partition " + iPartition + "; current version is " + lVersionExpect, 5);
                parts.remove(iPartition);
                msgBackup.skipPartition(iPartition);
            } else if (lVersionExpect < lVersionNew || !this.isBackupOwner(iPartition) && control.isTransferringOut()) {
                if (partsDefer == null) {
                    partsDefer = new PartitionSet(parts.getPartitionCount());
                }
                partsDefer.add(iPartition);
            }
            iPartition = parts.next(iPartition + 1);
        }
        PartitionSet partsSkip = msgBackup.getSkipPartitions();
        if (partsDefer == null) {
            msgBackup.forwardOrReply(msgBackup);
        } else {
            parts.remove(partsDefer);
            int iPartition2 = partsDefer.next(0);
            PartitionControl control = this.getPartitionControl(iPartition2);
            control.deferBackup(msgBackup, paVersions.getPrimitive(iPartition2));
            if (partsSkip != null) {
                partsDefer.add(partsSkip);
            }
            partsSkip = partsDefer;
        }
        if (!parts.isEmpty()) {
            msgBackup.doBackup(partsSkip);
            msgBackup.skipPartitions(parts);
            int iPartition3 = parts.next(0);
            while (iPartition3 >= 0) {
                PartitionControl control = this.getPartitionControl(iPartition3);
                control.getVersionCounter().incrementAndGet();
                control.flushDeferredBackups();
                iPartition3 = parts.next(iPartition3 + 1);
            }
        }
    }

    public void publishPartitionOwnership(int iPartition, int iStore, int nOwner) {
        VersionedOwnership owners = this.getPartitionConfig(iPartition);
        owners.setOwner(iStore, nOwner);
        this.putPartitionConfig(iPartition, owners);
    }

    public void putPartitionConfig(int iPartition, Ownership owners) {
        this.getPartitionConfigMap().put((Object)iPartition, owners);
    }

    protected void putPartitionConfig(Map mapOwners) {
        this.getPartitionConfigMap().putAll(mapOwners);
    }

    protected void receivePartition(int iPartition, int iBackup, List listXferRequests) {
        if (this.isActivePersistence()) {
            PartitionControl ctrl = this.getPartitionControl(iPartition);
            if (iBackup == 0) {
                PersistentStore store = ctrl.ensurePersistentStore();
                this.saveQuorum(iPartition);
                if (!this.isExiting() && this.getServiceState() != 3) {
                    PersistentStore storeEvents = ctrl.getPersistentEventsStore();
                    if (storeEvents != null) {
                        CachePersistenceHelper.seal(storeEvents, this, null);
                    }
                    CachePersistenceHelper.seal(store, this, null);
                }
            } else if (this.isBackupPersistence()) {
                PersistentStore store = ctrl.ensurePersistentStore(null, false, true);
                this.saveQuorum(iPartition, true);
                if (!this.isExiting() && this.getServiceState() != 3) {
                    CachePersistenceHelper.seal(store, this, null);
                }
            }
        }
    }

    public boolean recoverPartition(int iPartition, PersistentStore storeFrom, PersistentStore storeTo, List listRequests) {
        Binary binQuorum;
        if (CachePersistenceHelper.isGlobalPartitioningSchemePID(iPartition) && (binQuorum = CachePersistenceHelper.readQuorumRaw(storeFrom)) != null) {
            CachePersistenceHelper.writeQuorumRaw(storeTo, binQuorum);
            this.getPersistenceControl().setQuorumRaw(binQuorum);
        }
        if (this.getServiceState() >= 3) {
            return false;
        }
        PartitionControl ctrl = this.getPartitionControl(iPartition);
        PersistentStore storeEvents = ctrl.getPersistentEventsStore();
        if (storeEvents != null) {
            CachePersistenceHelper.seal(storeEvents, this, null);
        }
        CachePersistenceHelper.seal(storeTo, this, null);
        ctrl.setRecovered(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverPartitions(PartitionRecoverRequest.RecoverJob job, Map mapStoresFrom, Map mapStoresTo, PartitionSet partsFail, PartitionSet partsFailEvents) {
        Object iter;
        PartitionRecoverInfo info = job.getRecoverInfo();
        List listGUID = job.getListGUID();
        int cGUIDs = listGUID.size();
        ArrayList listRequests = new ArrayList();
        PartitionSet partsRecovered = this.instantiatePartitionSet(false);
        PersistenceManager mgrRecover = info.getManager();
        PersistenceManager mgrBackup = this.getPersistenceControl().getBackupManager();
        if (!mapStoresTo.isEmpty()) {
            iter = mapStoresTo.entrySet().iterator();
            while (iter.hasNext() && !this.isExiting() && this.getServiceState() != 3) {
                Map.Entry entry = (Map.Entry)iter.next();
                Integer IPartition = (Integer)entry.getKey();
                int nPartition = IPartition;
                PersistentStore storeFrom = (PersistentStore)entry.getValue();
                String sGUID = ((PersistentStore)((Object[])mapStoresFrom.get(IPartition))[0]).getId();
                boolean fFromBackup = (Boolean)((Object[])mapStoresFrom.get(IPartition))[1];
                PartitionedService._assert(this.getPartitionControl(nPartition).isLocked(), "Partition must be locked");
                try {
                    PersistentStore storeTo;
                    PersistentStore persistentStore = storeTo = this.isActivePersistence() ? storeFrom : NullImplementation.getPersistentStore();
                    if (this.recoverPartition(nPartition, storeFrom, storeTo, listRequests)) {
                        if (this.isSnapshotManager(mgrRecover)) {
                            mgrRecover.close(sGUID);
                        } else if (mgrBackup != null && fFromBackup) {
                            mgrBackup.delete(sGUID, false);
                        } else {
                            mgrRecover.delete(sGUID, false);
                        }
                        partsRecovered.add(nPartition);
                    } else {
                        this.onRecoverFailed(mgrRecover, sGUID, true);
                        partsFail.add(nPartition);
                    }
                    this.heartbeat();
                }
                catch (Throwable t) {
                    this.onRecoverFailed(mgrRecover, sGUID, t instanceof PersistenceException);
                    partsFail.add(nPartition);
                    PartitionedService._trace("Failed to recover partition " + nPartition + "\n" + t.getMessage() + "\n" + PartitionedService.getStackTrace(t), 2);
                }
            }
        }
        iter = info;
        synchronized (iter) {
            info.getRecoveredPartitions().add(partsRecovered);
            info.getFailedPartitions().add(partsFail);
            info.getFailedEventPartitions().add(partsFailEvents);
            info.getListRequests().addAll(listRequests);
        }
        PartitionRecoverRequest request = (PartitionRecoverRequest)info.getRequest();
        if (request.getRecoverJobs().decrementAndGet() == 0) {
            PartitionSet partsAssign = request.getPartsAssign();
            if (!partsAssign.isEmpty()) {
                int iPartition = partsAssign.next(0);
                int c = 0;
                while (iPartition >= 0 && this.getServiceState() < 3) {
                    this.assignOrphan(iPartition);
                    if ((c++ & 0xF) == 15) {
                        this.heartbeat();
                    }
                    iPartition = partsAssign.next(iPartition + 1);
                }
                this.handlePartitionTrace(partsAssign, PartitionControl.getPartitionEventDescription(10));
            }
            Continuations continuations = this.getContinuations();
            this.onPartitionsRecovered(info.getRecoveredPartitions(), ((PartitionRecoverRequest)info.getRequest()).getSnapshotToRecover(), continuations.thenOnServiceThread(continuations.instantiateFinalizeRecoverPrimary(info)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerContention(int iPartition) {
        CommonMonitor oMonitor;
        Contention[] aContention = this.getPartitionContention();
        CommonMonitor commonMonitor = oMonitor = Base.getCommonMonitor(System.identityHashCode(aContention) + iPartition);
        synchronized (commonMonitor) {
            Contention contention = aContention[iPartition];
            if (contention == null) {
                contention = aContention[iPartition] = new Contention();
                contention.setPartition(iPartition);
            } else {
                contention.setAccessCount(contention.getAccessCount() + 1);
            }
        }
    }

    public void registerContention(PartitionSet partitions) {
        int iPartition = partitions.next(0);
        while (iPartition >= 0) {
            this.registerContention(iPartition);
            iPartition = partitions.next(iPartition + 1);
        }
    }

    protected void releasePartition(int iPartition, int iBackup) {
        if (this.isActivePersistence()) {
            if (iBackup == 0) {
                this.getPartitionControl(iPartition).deletePersistentStore();
            } else if (this.isBackupPersistence()) {
                this.getPartitionControl(iPartition).deleteBackupPersistentStore();
            }
        }
    }

    protected void releasePartitionControl(int nPartition) {
        Guardian.GuardContext ctx;
        PartitionControl ctrlPartition = this.getPartitionControl(nPartition);
        if (ctrlPartition != null && (ctx = ctrlPartition.getContext()) != null) {
            ctx.release();
        }
        this.setPartitionControl(nPartition, null);
    }

    public void releaseScratchSpace(long cb) {
        this.getScratchSpaceCounter().addAndGet(cb);
    }

    @Override
    public void removePartitionListener(PartitionListener listener) {
        this.getPartitionListeners().remove(listener);
    }

    public String reportContentions() {
        StringBuffer sb = new StringBuffer();
        Contention[] aContention = this.getPartitionContention();
        int cPartitions = this.getPartitionCount();
        for (int iPartition = 0; iPartition < cPartitions; ++iPartition) {
            Contention contention = aContention[iPartition];
            if (contention == null) continue;
            sb.append("\n*** ").append(contention);
        }
        return sb.toString();
    }

    public String reportOwnership(int nMember, boolean fVerbose) {
        StringBuffer sb = new StringBuffer();
        int[][] aaiOwner = this.getPartitionAssignments();
        int cPartitions = aaiOwner.length;
        int cBackups = this.getBackupCount();
        int nMemberThis = this.getThisMember().getId();
        for (int iStore = 0; iStore < 1 + cBackups; ++iStore) {
            if (iStore == 0) {
                sb.append("Primary[]");
            } else {
                sb.append("\nBackup[").append(iStore).append("]");
            }
            StringBuffer sbStore = new StringBuffer();
            int cDigits = cPartitions > 9999 ? 5 : (cPartitions > 999 ? 4 : 3);
            int cOwned = 0;
            for (int iPartition = 0; iPartition < cPartitions; ++iPartition) {
                int nOwnerLocal = aaiOwner[iPartition][iStore];
                int nOwnerGlobal = this.getPartitionConfig(iPartition).getOwner(iStore);
                if (nOwnerLocal != nMember && nOwnerGlobal != nMember) continue;
                if (fVerbose) {
                    sbStore.append(',').append(this.isPartitionVulnerable(iPartition, true) ? (char)' ' : '+');
                    Object sCtrl = null;
                    if (nOwnerLocal == nMemberThis) {
                        PartitionControl ctrl = this.getPartitionControl(iPartition);
                        if (ctrl == null) {
                            sCtrl = Base.toDecString(iPartition, cDigits) + "; missing control";
                        } else if (ctrl.getLockType() != 0) {
                            sCtrl = String.valueOf(ctrl);
                        }
                    }
                    sbStore.append((String)(sCtrl == null ? Base.toDecString(iPartition, cDigits) : sCtrl));
                    if (nOwnerLocal != nOwnerGlobal) {
                        if (nOwnerLocal != nMember) {
                            sbStore.append("?local=").append(nOwnerLocal);
                        } else {
                            sbStore.append("?global=").append(nOwnerGlobal);
                        }
                    }
                }
                ++cOwned;
            }
            sb.append('#').append(Base.toDecString(cOwned, cDigits));
            if (cOwned <= 0 || !fVerbose) continue;
            sb.append(':').append(sbStore.substring(1));
        }
        return sb.toString();
    }

    public String reportOwnership(boolean fVerbose) {
        int cPartitions = this.getPartitionCount();
        int cBackups = this.getBackupCount();
        MemberSet setOwners = this.getOwnershipMemberSet();
        int cMembers = setOwners.size();
        if (cMembers == 0) {
            return "No ownership-enabled members";
        }
        int[] acPrimary = this.calculateOwnership(setOwners, true);
        int[] acBackup = this.calculateOwnership(setOwners, false);
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDistributionStrategy().reportLocalDistributionState(fVerbose));
        for (Member member : setOwners) {
            int nMember = member.getId();
            sb.append("\n*** Member: ");
            if (nMember < 10) {
                sb.append(' ');
            }
            sb.append(nMember).append(" total=").append(acPrimary[nMember] + acBackup[nMember]).append(" (primary=").append(acPrimary[nMember]).append(", backup=").append(acBackup[nMember]).append(")\n").append(this.reportOwnership(nMember, fVerbose)).append('\n');
        }
        sb.append("\n*** Orphans:\n").append(this.reportOwnership(0, fVerbose)).append('\n');
        PartitionControl[] aControl = this.getPartitionControl();
        if (aControl != null) {
            StringBuilder sbStates = null;
            int c = aControl.length;
            for (int i = 0; i < c; ++i) {
                PartitionControl ctrl = aControl[i];
                if (ctrl == null || ctrl.getPartitionState() == 0) continue;
                if (sbStates == null) {
                    sbStates = new StringBuilder("\n*** Partition States:\n");
                }
                sbStates.append(i).append(": ").append(ctrl).append(", ");
            }
            if (sbStates != null) {
                sb.append((CharSequence)sbStates);
            }
        }
        return sb.toString();
    }

    public String reportPartitionOwnership(int iPartition) {
        StringBuffer sb = new StringBuffer("Partition " + iPartition + ": ");
        int[] aiOwner = this.getPartitionAssignments()[iPartition];
        VersionedOwnership owners = this.getPartitionConfig(iPartition);
        int nMemberThis = this.getThisMember().getId();
        PartitionControl ctrl = this.getPartitionControl(iPartition);
        int c = 1 + this.getBackupCount();
        for (int iStore = 0; iStore < c; ++iStore) {
            int nOwnerLocal = aiOwner[iStore];
            int nOwnerGlobal = owners.getOwner(iStore);
            if (iStore == 0) {
                sb.append("owner=");
            } else {
                sb.append(", backup[").append(iStore).append("]=");
            }
            sb.append(nOwnerLocal);
            if (nOwnerLocal != nOwnerGlobal) {
                sb.append("?global=").append(nOwnerGlobal);
            }
            if (nOwnerLocal != nMemberThis) continue;
            if (ctrl == null) {
                sb.append("; missing control");
                continue;
            }
            if (ctrl.getLockType() == 0) continue;
            sb.append("; ").append(ctrl);
        }
        return sb.toString();
    }

    public String reportVulnerability(int nMember, boolean fVerbose) {
        if (this.getBackupCount() == 0) {
            return "No backup";
        }
        StringBuffer sbEndangered = new StringBuffer();
        StringBuffer sbVulnerable = new StringBuffer();
        int cEndangered = 0;
        int cVulnerable = 0;
        int cPartitions = this.getPartitionCount();
        for (int iPartition = 0; iPartition < cPartitions; ++iPartition) {
            if (this.getPrimaryOwner(iPartition).getId() != nMember) continue;
            if (this.getBackupOwners(iPartition).isEmpty()) {
                sbEndangered.append(',').append(iPartition);
                ++cEndangered;
                continue;
            }
            if (!this.isPartitionVulnerable(iPartition, true)) continue;
            sbVulnerable.append(',').append(iPartition);
            ++cVulnerable;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("*** Endangered partitions: (").append(cEndangered).append(") ");
        if (fVerbose && sbEndangered.length() > 0) {
            sb.append(sbEndangered.substring(1));
        }
        sb.append("\n*** Vulnerable partitions: (").append(cVulnerable).append(") ");
        if (fVerbose && sbVulnerable.length() > 0) {
            sb.append(sbVulnerable.substring(1));
        }
        return sb.toString();
    }

    public String reportVulnerability(boolean fVerbose) {
        if (this.getBackupCount() == 0) {
            return "No backup";
        }
        StringBuffer sbEndangered = new StringBuffer();
        StringBuffer sbVulnerable = new StringBuffer();
        int cEndangered = 0;
        int cVulnerable = 0;
        int cPartitions = this.getPartitionCount();
        for (int iPartition = 0; iPartition < cPartitions; ++iPartition) {
            if (this.getPrimaryOwner(iPartition) == null || this.getBackupOwners(iPartition).isEmpty()) {
                sbEndangered.append(',').append(iPartition);
                ++cEndangered;
                continue;
            }
            if (!this.isPartitionVulnerable(iPartition, true)) continue;
            sbVulnerable.append(',').append(iPartition);
            ++cVulnerable;
        }
        StringBuffer sb = new StringBuffer();
        if (cVulnerable > 0) {
            sb.append("Vulnerability is ").append(this.isVulnerabilityAvoidable(this.getOwnershipMemberSet()) ? "avoidable" : "unavoidable");
        }
        sb.append("\n*** Endangered partitions: (").append(cEndangered).append(") ");
        if (fVerbose && sbEndangered.length() > 0) {
            sb.append(sbEndangered.substring(1));
        }
        sb.append("\n*** Vulnerable partitions: (").append(cVulnerable).append(") ");
        if (fVerbose && sbVulnerable.length() > 0) {
            sb.append(sbVulnerable.substring(1));
        }
        return sb.toString();
    }

    public long reserveScratchSpace() {
        long cbReserve;
        long cbScratch;
        AtomicLong atomicScratch = this.getScratchSpaceCounter();
        while (!atomicScratch.compareAndSet(cbScratch = atomicScratch.get(), cbScratch - (cbReserve = Math.max(cbScratch / 2L, 2048L)))) {
        }
        return cbReserve;
    }

    @Override
    public void resetStats() {
        this.getPersistenceControl().resetStats();
        if (this.getPartitionEvents() != null) {
            this.getPartitionEvents().clear();
        }
        super.resetStats();
    }

    @Override
    public EndPoint resolveEndPoint(String sEndPoint, Member member, Map mapMemberConfig) {
        if (!this.isOwnershipEnabled() && (Integer)mapMemberConfig.get("ownership-enabled") == 1) {
            return null;
        }
        return super.resolveEndPoint(sEndPoint, member, mapMemberConfig);
    }

    protected void restoreOrphans(OwnershipRequest msgRequest) {
        int[][] aaiOwner = msgRequest.getRequestAssignments();
        Member memberThis = this.getThisMember();
        int nMemberThis = memberThis.getId();
        int cPartitions = aaiOwner.length;
        int cBackups = this.getBackupCount();
        PartitionSet partsRestore = new PartitionSet(cPartitions);
        this.setRestoreInProgress(true);
        block0: for (int iPartition = 0; iPartition < cPartitions; ++iPartition) {
            int[] aiOwner = aaiOwner[iPartition];
            if (aiOwner[0] != 0) continue;
            for (int iBackup = 1; iBackup <= cBackups; ++iBackup) {
                int nBackupOwner = aiOwner[iBackup];
                if (nBackupOwner == nMemberThis) {
                    PartitionControl control = this.getPartitionControl(iPartition);
                    control.lock(-1L, 2);
                    this.firePartitionEvent(5, iPartition, null, memberThis);
                    while (++iBackup <= cBackups) {
                        this.assignPartitionOwner(iPartition, iBackup, aiOwner[iBackup]);
                    }
                    partsRestore.add(iPartition);
                    continue block0;
                }
                if (nBackupOwner != 0) continue block0;
            }
        }
        if (partsRestore.isEmpty()) {
            this.onFinalizeRestorePrimary(msgRequest, null);
        } else {
            LiteMap<Integer, VersionedOwnership> mapUpdate = new LiteMap<Integer, VersionedOwnership>();
            boolean fActive = this.isActivePersistence();
            int iPartition = partsRestore.next(0);
            int c = 0;
            while (iPartition >= 0 && !this.isExiting() && this.getServiceState() != 3) {
                mapUpdate.put(iPartition, this.assignPrimaryPartition(iPartition, 'm'));
                this.getPartitionControl(iPartition).getVersionCounter().incrementAndGet();
                this.movePartition(iPartition, 0);
                partsRestore.add(iPartition);
                if (fActive && (c++ & 0xF) == 15) {
                    this.heartbeat();
                }
                iPartition = partsRestore.next(iPartition + 1);
            }
            this.onPartitionsRestored(partsRestore, this.getContinuations().instantiateFinalizeRestorePrimaries(msgRequest, mapUpdate));
        }
    }

    public void saveQuorum(int iPartition) {
        this.saveQuorum(iPartition, false);
    }

    public void saveQuorum(int iPartition, boolean fBackup) {
        if (CachePersistenceHelper.isGlobalPartitioningSchemePID(iPartition)) {
            PersistentStore store = fBackup ? this.getPartitionControl(iPartition).ensureOpenPersistentStore(null, false, true) : this.getPartitionControl(iPartition).ensureOpenPersistentStore();
            Binary binQuorum = this.getPersistenceControl().getQuorumRaw();
            if (binQuorum != null) {
                CachePersistenceHelper.writeQuorumRaw(store, binQuorum);
            }
        }
    }

    public void saveQuorum(int iPartition, PersistentStore store) {
        Binary binQuorum;
        if (iPartition < 0) {
            iPartition = GUIDHelper.getPartition(store.getId());
        }
        if (CachePersistenceHelper.isGlobalPartitioningSchemePID(iPartition) && (binQuorum = this.getPersistenceControl().getQuorumRaw()) != null) {
            CachePersistenceHelper.writeQuorumRaw(store, binQuorum);
        }
    }

    protected void setAsyncBackup(boolean fAsync) {
        this.__m_AsyncBackup = fAsync;
    }

    protected void setAsyncBackupInterval(long fAsync) {
        this.__m_AsyncBackupInterval = fAsync;
    }

    protected void setBackupCount(int cBackups) {
        PartitionedService._assert(!this.isAcceptingClients(), "The backup count is immutable once the service has started");
        this.__m_BackupCount = cBackups;
    }

    public void setConcurrent(boolean fConcurrent) {
        this.__m_Concurrent = fConcurrent;
    }

    protected void setConfiguredKeyAssociator(KeyAssociator associator) {
        if (this.isAcceptingClients()) {
            throw new IllegalStateException("Service is already running");
        }
        this.__m_ConfiguredKeyAssociator = associator;
    }

    protected void setConfiguredKeyPartitioningStrategy(KeyPartitioningStrategy strategy) {
        if (this.isAcceptingClients()) {
            throw new IllegalStateException("Service is already running");
        }
        this.__m_ConfiguredKeyPartitioningStrategy = strategy;
    }

    protected void setContinuations(Continuations continuations) {
        this.__m_Continuations = continuations;
    }

    protected void setDeferredBackupTimeoutMillis(long cMillis) {
        this.__m_DeferredBackupTimeoutMillis = cMillis;
    }

    public void setDistributionAggressiveness(int iFactor) {
        this.__m_DistributionAggressiveness = Math.max(iFactor, 1);
    }

    public void setDistributionNextMillis(long ldtNext) {
        this.__m_DistributionNextMillis = ldtNext;
    }

    public void setDistributionRepeatMillis(int cMillis) {
        this.__m_DistributionRepeatMillis = cMillis;
    }

    protected void setDistributionStable(boolean fSync) {
        this.__m_DistributionStable = fSync;
    }

    protected void setDistributionStrategy(CentralDistribution strategy) {
        this.__m_DistributionStrategy = strategy;
    }

    protected void setDistributionSynchronized(boolean fSync) {
        this.__m_DistributionSynchronized = fSync;
    }

    protected void setFinalizing(boolean fFinalizing) {
        this.__m_Finalizing = fFinalizing;
    }

    protected void setKeyAssociator(KeyAssociator associator) {
        if (this.isAcceptingClients()) {
            throw new IllegalStateException("Service is already running");
        }
        this.__m_KeyAssociator = associator;
    }

    protected void setKeyPartitioningStrategy(KeyPartitioningStrategy strategy) {
        if (this.isAcceptingClients()) {
            throw new IllegalStateException("Service is already running");
        }
        this.__m_KeyPartitioningStrategy = strategy;
    }

    public void setKeyToBinaryConverter(ConverterKeyToBinary pKeyToBinaryConverter) {
        this.__m_KeyToBinaryConverter = pKeyToBinaryConverter;
    }

    public void setMaxContendMillis(long lMillis) {
        this.__m_MaxContendMillis = lMillis;
    }

    public void setMaxLockAttempt(int nAttempt) {
        this.__m_MaxLockAttempt = nAttempt;
    }

    private void setMsgCAE(String sMsg) {
        this.__m_MsgCAE = sMsg;
    }

    protected void setOwnershipEnabled(boolean fEnabled) {
        this.__m_OwnershipEnabled = fEnabled;
    }

    public void setOwnershipInProgress(int c) {
        this.__m_OwnershipInProgress = c;
    }

    public void setOwnershipVersion(int[] anVersion) {
        this.__m_OwnershipVersion = anVersion;
    }

    public void setOwnershipVersion(int i, int nVersion) {
        this.getOwnershipVersion()[i] = nVersion;
    }

    protected void setPartitionAssignments(int[][] aai) {
        this.__m_PartitionAssignments = aai;
    }

    protected void setPartitionConfigMap(PartitionConfig.Map mapConfig) {
        this.__m_PartitionConfigMap = mapConfig;
    }

    private void setPartitionContention(Contention[] aContention) {
        this.__m_PartitionContention = aContention;
    }

    protected void setPartitionControl(PartitionControl[] control) {
        this.__m_PartitionControl = control;
    }

    protected void setPartitionControl(int i, PartitionControl control) {
        this.getPartitionControl()[i] = control;
    }

    protected void setPartitionCount(int cPartitions) {
        PartitionedService._assert(!this.isAcceptingClients(), "The partition count is immutable once the service has started");
        this.__m_PartitionCount = cPartitions;
    }

    public void setPartitionEvents(Map mapEvents) {
        this.__m_PartitionEvents = mapEvents;
    }

    protected void setPartitionListeners(Listeners listeners) {
        this.__m_PartitionListeners = listeners;
    }

    public void setPartitionTraceEvents(int nEvents) {
        this.__m_PartitionTraceEvents = nEvents;
    }

    protected void setPersistenceControl(PersistenceControl control) {
        this.__m_PersistenceControl = control;
    }

    protected void setPersistenceDependencies(PersistenceDependencies deps) {
        this.__m_PersistenceDependencies = deps;
    }

    private void setPreprocessingGate(ThreadGate gatePreprocessing) {
        this.__m_PreprocessingGate = gatePreprocessing;
    }

    public void setRecoveryThread(boolean fRecoveryThread) {
        this.getTLORecoveryThread().set(fRecoveryThread);
    }

    public void setRemainsOwnershipReport(String sReport) {
        this.__m_RemainsOwnershipReport = sReport;
    }

    protected void setRestoreInProgress(boolean fProgress) {
        this.__m_RestoreInProgress = fProgress;
    }

    protected void setScratchSpaceCounter(AtomicLong cbScratch) {
        this.__m_ScratchSpaceCounter = cbScratch;
    }

    public void setTLORecoveryThread(ThreadLocal localThread) {
        this.__m_TLORecoveryThread = localThread;
    }

    protected void setTransferControl(TransferControl control) {
        this.__m_TransferControl = control;
    }

    protected void setTransferThreshold(int cbThreshold) {
        this.__m_TransferThreshold = cbThreshold;
    }

    @Override
    public void shutdown() {
        if (this.getThread() != Thread.currentThread()) {
            long ldtTimeout = Base.getSafeTimeMillis() + 5000L;
            while (this.isStarted() && !this.isAcceptingClients() && this.getServiceState() < 4) {
                Thread.yield();
                if (Base.getSafeTimeMillis() <= ldtTimeout) continue;
                PartitionedService._trace("Timeout during shutdown; stopping service " + String.valueOf(this), 2);
                this.stop();
                return;
            }
        }
        super.shutdown();
    }

    public void snapshotPartition(int iPartition, PersistentStore store, Object oToken) {
        CachePersistenceHelper.seal(store, this, oToken);
    }

    public List sortMembers(MemberSet setOthers, int[] aiPrimaryWeight, int[] aiSecondaryWeight) {
        Object[] aMember = (Member[])setOthers.toArray();
        int cOthers = aMember.length;
        if (cOthers > 1) {
            Random rand = Base.getRandom();
            TreeMap<Long, Object> mapSorted = new TreeMap<Long, Object>();
            int nMachineThis = this.getThisMember().getMachineId();
            for (int i = 0; i < cOthers; ++i) {
                Object member = aMember[i];
                int nId = ((Member)member).getId();
                if (nId >= aiPrimaryWeight.length) continue;
                long nM = ((Member)member).getMachineId() == nMachineThis ? 0x4000000000000000L : 0L;
                long nP = (long)aiPrimaryWeight[nId] << 24;
                long nS = 0L;
                if (aiSecondaryWeight != null && nId < aiSecondaryWeight.length) {
                    nS = (long)aiSecondaryWeight[nId] << 8;
                }
                long nR = rand.nextInt() & 0xFF;
                mapSorted.put(nM | nP | nS | nR, member);
            }
            return new ImmutableArrayList(mapSorted.values());
        }
        return new ImmutableArrayList(aMember);
    }

    public Map splitByBackupOwners(PartitionSet partitions) {
        AbstractMap mapByOwners = partitions.cardinality() > 1 ? new HashMap() : new LiteMap();
        int cPartitions = this.getPartitionCount();
        int iPartition = partitions.next(0);
        while (iPartition >= 0) {
            List listBackups = this.getBackupOwners(iPartition);
            PartitionSet partsOwners = (PartitionSet)mapByOwners.get(listBackups);
            if (partsOwners == null) {
                partsOwners = new PartitionSet(cPartitions);
                mapByOwners.put(listBackups, partsOwners);
            }
            partsOwners.add(iPartition);
            iPartition = partitions.next(iPartition + 1);
        }
        return mapByOwners;
    }

    public Map splitByOwner(PartitionSet partitions, int iStore, int[][] aaiOwner) {
        AbstractMap mapByOwner = partitions.cardinality() > 1 ? new HashMap() : new LiteMap();
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        int cPartitions = this.getPartitionCount();
        if (aaiOwner == null) {
            aaiOwner = this.getPartitionAssignments();
        }
        int iPartition = partitions.next(0);
        while (iPartition >= 0) {
            int nOwner = aaiOwner[iPartition][iStore];
            Member member = nOwner > 0 && !setMembers.isServiceLeaving(nOwner) ? setMembers.getMember(nOwner) : null;
            PartitionSet partMember = (PartitionSet)mapByOwner.get(member);
            if (partMember == null) {
                partMember = new PartitionSet(cPartitions);
                mapByOwner.put(member, partMember);
            }
            partMember.add(iPartition);
            iPartition = partitions.next(iPartition + 1);
        }
        return mapByOwner;
    }

    public Map splitEntriesByOwner(Iterator iterEntries, int iStore, int[][] aaiOwner) {
        HashMap mapByOwner = new HashMap();
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        if (aaiOwner == null) {
            aaiOwner = this.getPartitionAssignments();
        }
        while (iterEntries.hasNext()) {
            Map.Entry entry = (Map.Entry)iterEntries.next();
            Binary binKey = (Binary)entry.getKey();
            int iPartition = this.getKeyPartition(binKey);
            int nOwner = aaiOwner[iPartition][iStore];
            Member member = nOwner > 0 && !setMembers.isServiceLeaving(nOwner) ? setMembers.getMember(nOwner) : null;
            HashMap mapMember = (HashMap)mapByOwner.get(member);
            if (mapMember == null) {
                mapMember = new HashMap();
                mapByOwner.put(member, mapMember);
            }
            mapMember.put(binKey, entry.getValue());
        }
        return mapByOwner;
    }

    public Map splitKeysByOwner(Iterator iterKeys, int iStore, int[][] aaiOwner) {
        HashMap<Member, HashSet<Binary>> mapByOwner = new HashMap<Member, HashSet<Binary>>();
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        if (aaiOwner == null) {
            aaiOwner = this.getPartitionAssignments();
        }
        while (iterKeys.hasNext()) {
            int nOwner;
            Binary binKey = (Binary)iterKeys.next();
            int iPartition = this.getKeyPartition(binKey);
            Member member = null;
            member = iStore >= 0 ? ((nOwner = aaiOwner[iPartition][iStore]) > 0 && !setMembers.isServiceLeaving(nOwner) ? setMembers.getMember(nOwner) : null) : this.getClosestOwner(iPartition);
            HashSet<Binary> setMember = (HashSet<Binary>)mapByOwner.get(member);
            if (setMember == null) {
                setMember = new HashSet<Binary>();
                mapByOwner.put(member, setMember);
            }
            setMember.add(binKey);
        }
        return mapByOwner;
    }

    public Map splitKeysByPartition(Iterator iterKeys) {
        HashMap<Integer, HashSet<Binary>> mapByPID = new HashMap<Integer, HashSet<Binary>>();
        while (iterKeys.hasNext()) {
            Binary binKey = (Binary)iterKeys.next();
            Integer IPartition = this.getKeyPartition(binKey);
            HashSet<Binary> setPart = (HashSet<Binary>)mapByPID.get(IPartition);
            if (setPart == null) {
                setPart = new HashSet<Binary>();
                mapByPID.put(IPartition, setPart);
            }
            setPart.add(binKey);
        }
        return mapByPID;
    }

    public boolean swapBackupIndex(int iPartition, int iStore0, int iStore1) {
        int iStoreHigh;
        int iStoreLow;
        PartitionControl ctrlPartition = this.getPartitionControl(iPartition);
        if (ctrlPartition.isTransferDisallowed()) {
            return false;
        }
        int[] aiOwner = this.getPartitionAssignments()[iPartition];
        PartitionedService._assert(aiOwner[0] == this.getThisMember().getId(), "not a primary owner");
        PartitionedService._assert(iStore0 > 0 && iStore1 > 0);
        if (iStore0 == iStore1) {
            return true;
        }
        if (iStore0 < iStore1) {
            iStoreLow = iStore1 - 1;
            iStoreHigh = iStore1;
        } else {
            iStoreLow = iStore1;
            iStoreHigh = iStore1 + 1;
        }
        ctrlPartition.preventTransfer();
        int nMemberToPromote = aiOwner[iStoreHigh];
        aiOwner[iStoreHigh] = aiOwner[iStoreLow];
        aiOwner[iStoreLow] = nMemberToPromote;
        VersionedOwnership owners = this.getPartitionConfig(iPartition);
        PartitionedService._trace("Exchanging the ownership for partition " + iPartition + " for backup indices " + iStoreLow + " and " + iStoreHigh + ", owners=" + String.valueOf(owners), 3);
        PartitionSwapRequest msg = (PartitionSwapRequest)this.instantiateMessage("PartitionSwapRequest");
        msg.setPartition(iPartition);
        msg.setPromoteIndex(iStoreLow);
        msg.setOwners(owners);
        msg.setMemberList(this.getBackupOwners(iPartition, false));
        this.post(msg);
        return Math.abs(iStore0 - iStore1) == 1;
    }

    public int transferBackup(Member member, PartitionSet parts, int iBackup, int cPartsLimit) {
        TransferControl ctrlTransfer = this.getTransferControl();
        PartitionControl[] aCtrlPartition = this.getPartitionControl();
        long cContendMillis = this.getDistributionContendMillis();
        int iPart = parts.next(0);
        while (iPart >= 0) {
            PartitionControl ctrl = aCtrlPartition[iPart];
            if (ctrl.lockWithAdaptiveTime(cContendMillis, 1, member.getId())) {
                cContendMillis = 0L;
            } else {
                parts.remove(iPart);
                if (!this.isAdaptivePartitionLock()) {
                    cContendMillis >>= 1;
                }
            }
            iPart = parts.next(iPart + 1);
        }
        int cPartitions = parts.cardinality();
        if (cPartitions == 0) {
            return 0;
        }
        ctrlTransfer.prepareBackupTransfer(member, this.getTransferThreshold(), Math.min(cPartsLimit, cPartitions));
        int cSent = 0;
        int iPart2 = parts.next(0);
        while (iPart2 >= 0) {
            PartitionControl ctrlPart = aCtrlPartition[iPart2];
            if (ctrlTransfer.isTransferFull()) {
                parts.remove(iPart2);
                ctrlPart.unlock(true);
            } else {
                this.validateTransferStrength(member, iPart2, iBackup);
                this.transferPartition(iPart2, iBackup, ++cSent == cPartitions);
                ctrlPart.unlock();
                ctrlPart.preventTransfer();
            }
            iPart2 = parts.next(iPart2 + 1);
        }
        PartitionedService._trace("Transferring " + String.valueOf(new MemorySize(ctrlTransfer.getTransferredBytes())) + " of backup[" + iBackup + "] for " + String.valueOf(parts) + " to member " + member.getId() + (ctrlTransfer.isTransferFull() ? "; transfer threshold exceeded" : ""), 3);
        return cSent;
    }

    protected void transferPartition(int iPartition, int iStore, boolean fLastInTransfer) {
        this.assignPartitionOwner(iPartition, iStore, this.getTransferControl().getToMember().getId());
    }

    public boolean transferPrimary(Member member, RequestMessage msgRequest, PartitionSet parts, int cPartsLimit) {
        int cLocked = 0;
        PartitionControl[] aCtrlPartition = this.getPartitionControl();
        long cContendMillis = this.getDistributionContendMillis();
        int iPart = parts.next(0);
        while (iPart >= 0) {
            PartitionControl ctrl = aCtrlPartition[iPart];
            if (cLocked >= cPartsLimit) {
                parts.remove(iPart);
            } else if (ctrl.lockWithAdaptiveTime(cContendMillis, 3, member.getId())) {
                ++cLocked;
                cContendMillis = 0L;
            } else {
                parts.remove(iPart);
                if (!this.isAdaptivePartitionLock()) {
                    cContendMillis >>= 1;
                }
            }
            iPart = parts.next(iPart + 1);
        }
        if (parts.isEmpty()) {
            return false;
        }
        this.getTransferControl().preparePrimaryTransfer(msgRequest, this.getTransferThreshold());
        this.onFinalizeSendPrimary(parts);
        return true;
    }

    public void unpinPartition(int iPartition) {
        if (this.isConcurrent() && this.isPrimaryOwner(iPartition)) {
            this.exitPartition(iPartition);
        }
    }

    public void unpinPartitions(PartitionSet partitions) {
        if (this.isConcurrent()) {
            PartitionControl[] aControl = this.getPartitionControl();
            int nPartition = partitions.next(0);
            while (nPartition >= 0) {
                aControl[nPartition].exit();
                nPartition = partitions.next(nPartition + 1);
            }
        }
    }

    protected boolean validateMemberConfig() {
        com.tangosol.net.Member memberSenior;
        int nThisMember = this.getThisMember().getId();
        boolean fValid = true;
        ServiceMemberSet setService = this.getServiceMemberSet();
        long ldtJoinedThis = setService.getServiceJoinTime(nThisMember);
        StringBuilder sbMembers = null;
        for (com.tangosol.net.Member memberThat : setService) {
            Integer IOwnership;
            int nMemberThat = memberThat.getId();
            long ldtJoinedThat = setService.getServiceJoinTime(nMemberThat);
            if (ldtJoinedThat >= ldtJoinedThis || (IOwnership = (Integer)setService.getMemberConfigMap(nMemberThat).get("ownership-enabled")) != null && IOwnership != 2) continue;
            if (sbMembers == null) {
                sbMembers = new StringBuilder();
            } else {
                sbMembers.append(", ");
            }
            sbMembers.append(nMemberThat);
            fValid = false;
        }
        if (fValid && this.isOwnershipEnabled() && (memberSenior = this.getOwnershipSenior()) != null) {
            ObservableMap mapSenior = setService.getMemberConfigMap(memberSenior.getId());
            XmlElement xmlConfig = (XmlElement)mapSenior.get("persistence-config");
            if (xmlConfig == null) {
                sbMembers = new StringBuilder().append(memberSenior.getId());
                fValid = false;
            } else {
                PersistenceEnvironment env = null;
                SnapshotArchiver arch = null;
                PersistenceControl ctrl = this.getPersistenceControl();
                if (ctrl.isValid()) {
                    env = SafePersistenceWrappers.unwrap(ctrl.getPersistenceEnvironment());
                    arch = ctrl.getSnapshotArchiver();
                }
                if (!(this.verifyFeature("PersistenceActiveFailureMode", !this.isActivePersistence() || ctrl == null ? "none" : (ctrl.getActiveFailureMode() == 0 ? "stop-service" : "stop-persistence"), xmlConfig.getSafeAttribute("persistence-active-failure-mode").getString("none")) && this.verifyFeature("PersistenceEnvironment", env == null ? "none" : env.getClass().getName(), xmlConfig.getSafeAttribute("persistence-environment").getString("none")) && this.verifyFeature("PersistenceMode", this.isActivePersistence() ? "active" : "on-demand", xmlConfig.getSafeAttribute("persistence-mode").getString("none")) && this.verifyFeature("PersistenceSnapshotArchiver", arch == null ? "none" : arch.getClass().getName(), xmlConfig.getSafeAttribute("persistence-snapshot-archiver").getString("none")))) {
                    fValid = false;
                    this.setOwnershipEnabled(false);
                    this.post(this.instantiateMessage("NotifyShutdown"));
                }
            }
        }
        if (sbMembers != null) {
            PartitionedService._trace("Waiting for member config update from members [" + sbMembers.toString() + "] that are in the process of joining", 3);
        }
        return fValid;
    }

    public void validatePartitionAssignments(MemberSet setOwners) {
        int nMemberThis = this.getThisMember().getId();
        int cPartitions = this.getPartitionCount();
        int cBackups = this.getBackupCount();
        int[][] aaiOwner = this.getPartitionAssignments();
        boolean fModified = false;
        for (int iPartition = 0; iPartition < cPartitions; ++iPartition) {
            int[] aiOwner = aaiOwner[iPartition];
            VersionedOwnership owners = this.getPartitionConfig(iPartition);
            int nPrimaryOwner = aiOwner[0];
            boolean fPrimaryOwner = nPrimaryOwner == nMemberThis;
            for (int iStore = 0; iStore <= cBackups; ++iStore) {
                boolean fGlobalOwnerDeparted;
                int nOwnerLocal = aiOwner[iStore];
                int nOwnerGlobal = owners.getOwner(iStore);
                boolean fLocalOwnerDeparted = nOwnerLocal > 0 && nOwnerLocal != nMemberThis && !setOwners.contains(nOwnerLocal);
                boolean bl = fGlobalOwnerDeparted = nOwnerGlobal > 0 && nOwnerGlobal != nMemberThis && !setOwners.contains(nOwnerGlobal);
                if (nOwnerLocal == nOwnerGlobal || nOwnerLocal == 0 && fGlobalOwnerDeparted || nOwnerGlobal == 0 && fLocalOwnerDeparted) {
                    if (!fLocalOwnerDeparted && !fGlobalOwnerDeparted) continue;
                    if (!fModified) {
                        aaiOwner = (int[][])aaiOwner.clone();
                        fModified = true;
                    }
                    aiOwner = (int[])aiOwner.clone();
                    aiOwner[iStore] = 0;
                    aaiOwner[iPartition] = aiOwner;
                    owners.setOwner(iStore, 0);
                    if (!fPrimaryOwner || iStore <= 0 || nOwnerLocal != 0 || !fGlobalOwnerDeparted) continue;
                    this.getPartitionControl(iPartition).enableTransfer();
                    continue;
                }
                if (iStore == 0) {
                    if (!fLocalOwnerDeparted) continue;
                    if (nOwnerGlobal == nMemberThis) {
                        if (!fModified) {
                            aaiOwner = (int[][])aaiOwner.clone();
                            fModified = true;
                        }
                        aiOwner = (int[])aiOwner.clone();
                        aiOwner[0] = 0;
                        aaiOwner[iPartition] = aiOwner;
                        this.publishPartitionOwnership(iPartition, 0, 0);
                        continue;
                    }
                    throw new IllegalStateException("Unrecoverable ownership de-synchronization for partition " + iPartition + "(" + nOwnerLocal + "!=" + nOwnerGlobal + ")");
                }
                PartitionedService._assert(fPrimaryOwner || nOwnerLocal == nMemberThis || nOwnerGlobal == nMemberThis || nOwnerGlobal == 0 || this.getOwnedIndex(iPartition, nMemberThis, false) != -1, "Unrecoverable backup[" + iStore + "] ownership de-synchronization for partition " + iPartition + "(" + nOwnerLocal + "!=" + nOwnerGlobal + ", primary=" + nPrimaryOwner + ")");
                if (fLocalOwnerDeparted) {
                    boolean fEndanger = false;
                    if (fPrimaryOwner) {
                        Member memberBackupPrev = setOwners.getMember(nOwnerGlobal);
                        if (memberBackupPrev == null) {
                            fEndanger = true;
                        } else {
                            aiOwner[iStore] = nOwnerGlobal;
                            this.getTransferControl().requestBackupConfirmation(iPartition, iStore, nOwnerLocal, memberBackupPrev);
                        }
                    } else {
                        fEndanger = true;
                    }
                    if (!fEndanger) continue;
                    aiOwner[iStore] = 0;
                    owners.setOwner(iStore, 0);
                    continue;
                }
                if (!fGlobalOwnerDeparted || !fPrimaryOwner) continue;
                TransferControl ctrlTransfer = this.getTransferControl();
                if (ctrlTransfer.isTransferInProgress(iPartition)) {
                    Member memberBackupNew = setOwners.getMember(nOwnerLocal);
                    PartitionedService._assert(memberBackupNew != null);
                    PartitionedService._trace("Transfer of partition " + iPartition + " (backup[" + iStore + "]) to member " + nOwnerLocal + " (previously owned by member " + nOwnerGlobal + ") is still in progress.", 3);
                    ctrlTransfer.requestBackupConfirmation(iPartition, iStore, nOwnerGlobal, memberBackupNew);
                    continue;
                }
                this.publishPartitionOwnership(iPartition, iStore, nOwnerLocal);
                this.getPartitionControl(iPartition).enableTransfer();
            }
        }
        if (fModified) {
            this.setPartitionAssignments(aaiOwner);
        }
    }

    protected boolean validatePartitionConfig() {
        Member memberThis = this.getThisMember();
        int nThisMember = memberThis.getId();
        com.tangosol.net.Member memberSenior = this.getOwnershipSenior();
        int nSeniorMember = memberSenior == null ? (this.isOwnershipEnabled() ? nThisMember : 0) : memberSenior.getId();
        MemberSet setOwners = this.getOwnershipMemberSet();
        int cPartitions = this.getPartitionCount();
        int cBackups = this.getBackupCount();
        if (this.getPartitionConfigMap().isEmpty()) {
            if (nSeniorMember != nThisMember && nSeniorMember != 0) {
                PartitionedService._trace("Waiting for partition config from member " + nSeniorMember + " that is in the process of joining", 3);
                return false;
            }
            this.initPartitionConfig();
            return true;
        }
        boolean fValid = true;
        int[][] aaiOwner = this.getPartitionAssignments();
        int[] aiVersions = this.getOwnershipVersion();
        for (int iPartition = 0; iPartition < cPartitions && fValid; ++iPartition) {
            VersionedOwnership owners = this.getPartitionConfig(iPartition);
            if (owners == null) {
                throw new IllegalStateException("Missing the ownership data for partition " + iPartition);
            }
            int[] aiOwner = aaiOwner[iPartition];
            for (int iStore = 0; iStore < 1 + cBackups; ++iStore) {
                int nOwner = owners.getOwner(iStore);
                if (nOwner == nThisMember) {
                    PartitionedService._trace("Waiting for ownership update from member " + nSeniorMember + " for partition " + iPartition + " " + String.valueOf(owners), 3);
                    fValid = false;
                    break;
                }
                aiOwner[iStore] = nOwner > 0 && setOwners.contains(nOwner) ? nOwner : 0;
            }
            aiVersions[iPartition] = owners.getVersion();
        }
        return fValid;
    }

    @Override
    protected boolean validateServiceConfig(XmlElement xmlConfig) {
        int cBackups;
        int cPartitions = xmlConfig.getAttribute("partition-count").getInt();
        if (cPartitions != this.getPartitionCount()) {
            PartitionedService._trace("This node is configured with a 'partition-count' value of " + this.getPartitionCount() + ", but the service senior is using a value of " + cPartitions + "; overriding the local configuration.", 2);
            this.setPartitionCount(cPartitions);
        }
        if ((cBackups = xmlConfig.getAttribute("redundancy-count").getInt()) != this.getBackupCount()) {
            PartitionedService._trace("This node is configured with a 'backup-count' value of " + this.getBackupCount() + ", but the service senior is using a value of " + cBackups + "; overriding the local configuration.", 2);
            this.setBackupCount(cBackups);
        }
        KeyAssociator associator = this.getConfiguredKeyAssociator();
        KeyPartitioningStrategy partitioning = this.getConfiguredKeyPartitioningStrategy();
        ActionPolicy quorumPolicy = this.getActionPolicy();
        CentralDistribution strategy = this.getDistributionStrategy();
        String sAssociator = associator == null ? "none" : associator.getClass().getName();
        String sPartitioning = partitioning == null ? "none" : partitioning.getClass().getName();
        String sQuorumPolicy = quorumPolicy == null ? "none" : quorumPolicy.getClass().getName();
        String QUORUM_DEFAULT_LEGACY = "com.tangosol.net.ConfigurableQuorumPolicy$WrapperQuorumPolicy";
        String QUORUM_DEFAULT_12211 = "com.tangosol.net.ConfigurableQuorumPolicy$PartitionedCacheQuorumPolicy";
        String sQuorumGlobal = xmlConfig.getSafeAttribute("quorum-policy").getString();
        if ("com.tangosol.net.ConfigurableQuorumPolicy$WrapperQuorumPolicy".equals(sQuorumGlobal)) {
            sQuorumGlobal = "com.tangosol.net.ConfigurableQuorumPolicy$PartitionedCacheQuorumPolicy";
        }
        return super.validateServiceConfig(xmlConfig) && this.verifyFeature("QuorumPolicy", sQuorumPolicy, sQuorumGlobal) && this.verifyFeature("KeyAssociator", sAssociator, xmlConfig.getSafeAttribute("key-associator").getString()) && this.verifyFeature("KeyPartitioningStrategy", sPartitioning, xmlConfig.getSafeAttribute("key-partitioning").getString());
    }

    protected void validateTransferStrength(Ownership ownersOld, Ownership ownersNew, int iPartition) {
        CentralDistribution dist = this.getDistributionStrategy();
        int nStrengthOld = Math.min(this.getBackupStrength(ownersOld.getOwners()), dist.getTargetStrength());
        int nStrengthNew = this.getBackupStrength(ownersNew.getOwners());
        if (nStrengthNew < nStrengthOld && !this.getServiceMemberSet().isServiceLeaving(ownersOld.getPrimaryOwner())) {
            PartitionedService._trace("Initiating a transitional transfer for partition " + iPartition + ": " + String.valueOf(ownersOld) + " -> " + String.valueOf(ownersNew) + " (strength " + nStrengthOld + " -> " + nStrengthNew + ")", 2);
        }
    }

    protected void validateTransferStrength(Member member, int iPartition, int iStore) {
        Ownership ownersNew = this.getPartitionOwnership(iPartition);
        ownersNew.setOwner(iStore, member.getId());
        this.validateTransferStrength(this.getPartitionOwnership(iPartition), ownersNew, iPartition);
    }

    static {
        PartitionedService.__initStatic();
    }

    public static class BackupAssignment
    extends Message {
        private int __m_NewBackupOwner;
        private int __m_Partition;
        private int __m_PrimaryOwner;
        private boolean __m_Release;
        private int __m_Store;

        public BackupAssignment() {
            this(null, null, true);
        }

        public BackupAssignment(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(37);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new BackupAssignment();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$BackupAssignment".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public int getNewBackupOwner() {
            return this.__m_NewBackupOwner;
        }

        public int getPartition() {
            return this.__m_Partition;
        }

        public int getPrimaryOwner() {
            return this.__m_PrimaryOwner;
        }

        public int getStore() {
            return this.__m_Store;
        }

        public boolean isRelease() {
            return this.__m_Release;
        }

        @Override
        public void onReceived() {
            ((PartitionedService)this.get_Module()).onBackupAssignment(this);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            this.setRelease(input.readBoolean());
            this.setPartition(ExternalizableHelper.readInt(input));
            this.setStore(ExternalizableHelper.readInt(input));
            this.setNewBackupOwner(ExternalizableHelper.readInt(input));
            this.setPrimaryOwner(ExternalizableHelper.readInt(input));
        }

        public void setNewBackupOwner(int nOwner) {
            this.__m_NewBackupOwner = nOwner;
        }

        public void setPartition(int nPartition) {
            this.__m_Partition = nPartition;
        }

        public void setPrimaryOwner(int nOwner) {
            this.__m_PrimaryOwner = nOwner;
        }

        public void setRelease(boolean fRelease) {
            this.__m_Release = fRelease;
        }

        public void setStore(int iStore) {
            this.__m_Store = iStore;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            output.writeBoolean(this.isRelease());
            ExternalizableHelper.writeInt(output, this.getPartition());
            ExternalizableHelper.writeInt(output, this.getStore());
            ExternalizableHelper.writeInt(output, this.getNewBackupOwner());
            ExternalizableHelper.writeInt(output, this.getPrimaryOwner());
        }
    }

    public static class BackupConfirmRequest
    extends RequestMessage
    implements Continuation {
        private int __m_DepartedMemberId;
        private int __m_Partition;
        private int __m_Store;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public BackupConfirmRequest() {
            this(null, null, true);
        }

        public BackupConfirmRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(40);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new BackupConfirmRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$BackupConfirmRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public int getDepartedMemberId() {
            return this.__m_DepartedMemberId;
        }

        public int getPartition() {
            return this.__m_Partition;
        }

        public int getStore() {
            return this.__m_Store;
        }

        @Override
        protected com.tangosol.coherence.component.net.Poll instantiatePoll() {
            return (com.tangosol.coherence.component.net.Poll)this._newChild("Poll");
        }

        @Override
        public void onReceived() {
            PartitionedService service = (PartitionedService)this.getService();
            Member memberDeparted = service.getServiceMemberSet().getMember(this.getDepartedMemberId());
            if (memberDeparted == null) {
                this.proceed((Object)null);
            } else {
                BackupConfirmRequest._trace("Deferring BackupConfirmRequest for partition " + this.getPartition() + ", backup[" + this.getStore() + "] until member " + memberDeparted.getId() + " has departed.", 3);
                service.deferUntilServiceLeft(memberDeparted, this);
            }
        }

        public void proceed(Object oResult) {
            ((PartitionedService)this.get_Module()).onBackupConfirmRequest(this);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            this.setPartition(ExternalizableHelper.readInt(input));
            this.setStore(ExternalizableHelper.readInt(input));
            this.setDepartedMemberId(ExternalizableHelper.readInt(input));
        }

        public void setDepartedMemberId(int nId) {
            this.__m_DepartedMemberId = nId;
        }

        public void setPartition(int nPartition) {
            this.__m_Partition = nPartition;
        }

        public void setStore(int nStore) {
            this.__m_Store = nStore;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            ExternalizableHelper.writeInt(output, this.getPartition());
            ExternalizableHelper.writeInt(output, this.getStore());
            ExternalizableHelper.writeInt(output, this.getDepartedMemberId());
        }

        static {
            BackupConfirmRequest.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$BackupConfirmRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected void onCompletion() {
                BackupConfirmRequest msg = (BackupConfirmRequest)this.get_Parent();
                ((PartitionedService)this.getService()).getPartitionControl(msg.getPartition()).enableTransfer();
            }
        }
    }

    public static class CentralDistribution
    extends DistributionStrategy {
        private volatile long __m_AnalysisNextMillis;
        private DistributionManager __m_DistributionManager;
        private Member __m_LastCoordinator;
        private long __m_LastStorageSize;
        private transient PartitionAssignmentStrategy __m_PartitionAssignmentStrategy;
        private PartitionStatistics[] __m_PartitionStatistics;
        private Map[] __m_PendingChanges;
        private int __m_TargetStrength;

        public CentralDistribution() {
            this(null, null, true);
        }

        public CentralDistribution(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setDistributionsPendingStart(0L);
                this.setTargetStrength(-1);
                this.setWarningNextMillis(0L);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new DistributionManager("DistributionManager", this, true), "DistributionManager");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new CentralDistribution();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$CentralDistribution".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void checkDistribution(MemberSet setOwners, Set setLeaving) {
            PartitionedService service = this.getService();
            long ldtNow = Base.getSafeTimeMillis();
            long ldtNextCheck = ldtNow + (long)service.getDistributionRepeatMillis();
            long ldtNextSample = this.getStatsSampleNextMillis();
            long ldtNextAnalysis = Long.MAX_VALUE;
            if (ldtNow > ldtNextSample) {
                PartitionControl[] actrl = service.getPartitionControl();
                PartitionSet parts = service.collectOwnedPartitions(true);
                PartitionStatistics[] aStats = this.getPartitionStatistics();
                ArrayList<PartitionStatistics> listStats = new ArrayList<PartitionStatistics>(parts.cardinality());
                long cStorageSize = 0L;
                int nPartition = parts.next(0);
                while (nPartition >= 0) {
                    PartitionStatistics statsCtrl = actrl[nPartition].updateDirectStorageSize();
                    PartitionStatistics stats = aStats[nPartition];
                    cStorageSize += statsCtrl.getStorageSize();
                    if (this.isCoordinator()) {
                        if (stats == null) {
                            aStats[nPartition] = stats = new PartitionStatistics();
                        }
                        stats.copyFrom(statsCtrl);
                        statsCtrl.reset();
                    } else {
                        listStats.add(statsCtrl);
                    }
                    nPartition = parts.next(nPartition + 1);
                }
                if (listStats.size() > 0 && (double)Math.abs(cStorageSize - this.getLastStorageSize()) > 0.1 * (double)cStorageSize) {
                    PartitionStatsUpdate msgUpdate = (PartitionStatsUpdate)service.instantiateMessage("PartitionStatsUpdate");
                    msgUpdate.setStatsList(listStats);
                    msgUpdate.addToMember(service.getOwnershipSenior(false));
                    service.post(msgUpdate);
                    Iterator iter = listStats.iterator();
                    while (iter.hasNext()) {
                        ((PartitionStatistics)iter.next()).reset();
                    }
                    this.setLastStorageSize(cStorageSize);
                }
                ldtNextSample = ldtNow + this.getStatsSamplingInterval();
                this.setStatsSampleNextMillis(ldtNextSample);
            }
            if (this.isCoordinator()) {
                Map mapUpdate;
                DistributionManager manager = this.getDistributionManager();
                ldtNextAnalysis = this.getAnalysisNextMillis();
                if (ldtNow >= ldtNextAnalysis) {
                    try {
                        manager.reset();
                        manager.setOwnershipMembers(setOwners);
                        manager.setOwnershipLeavingMembers(setLeaving);
                        long cAnalysisMillis = this.getPartitionAssignmentStrategy().analyzeDistribution();
                        if (setOwners.size() == 1) {
                            ldtNextSample = Long.MAX_VALUE;
                            ldtNextAnalysis = Long.MAX_VALUE;
                            ldtNextCheck = Long.MAX_VALUE;
                        } else {
                            long cRepeatMillis = service.getDistributionRepeatMillis();
                            ldtNextAnalysis = ldtNow + (service.getServiceState() == 3 ? cRepeatMillis / (long)service.getDistributionAggressiveness() : (cAnalysisMillis == -1L ? cRepeatMillis : cAnalysisMillis));
                        }
                        this.setAnalysisNextMillis(ldtNextAnalysis);
                    }
                    catch (Throwable t) {
                        CentralDistribution._trace("Unexpected exception occurred while calculating the partition assignment: " + Base.printStackTrace(t), 1);
                    }
                }
                if ((mapUpdate = manager.getSafeSuggestions()) != null && !mapUpdate.isEmpty()) {
                    DistributionPlanUpdate msgUpdate = (DistributionPlanUpdate)service.instantiateMessage("DistributionPlanUpdate");
                    msgUpdate.setUpdateMap(mapUpdate);
                    msgUpdate.setToMemberSet(service.getOwnershipOtherMemberSet(null));
                    msgUpdate.setTargetStrength(this.getTargetStrength());
                    service.post(msgUpdate);
                    this.processUpdate(mapUpdate);
                    Map mapDeferredSuggestions = manager.getSuggestionMap();
                    if (mapDeferredSuggestions != null && !mapDeferredSuggestions.isEmpty()) {
                        ldtNextCheck = ldtNow + (long)(service.getDistributionRepeatMillis() / service.getDistributionAggressiveness());
                    }
                }
            }
            if (service.isDistributionAllowed() && !this.processPendingChanges() || !service.isDistributionStable()) {
                ldtNextCheck = ldtNow + (long)(service.getDistributionRepeatMillis() / service.getDistributionAggressiveness());
            }
            service.setDistributionNextMillis(Math.min(Math.min(ldtNextCheck, ldtNextAnalysis), ldtNextSample));
        }

        public void clearAdvice(PartitionSet parts) {
            int cBackups = this.getBackupCount();
            for (int iStore = 0; iStore <= cBackups; ++iStore) {
                Map mapPending = this.getPendingChanges(iStore);
                for (PartitionSet partsPending : mapPending.values()) {
                    partsPending.remove(parts);
                }
            }
        }

        protected void clearPendingChanges() {
            int cBackups = this.getBackupCount();
            for (int iStore = 0; iStore <= cBackups; ++iStore) {
                this.getPendingChanges(iStore).clear();
            }
        }

        protected boolean deferBackupTransfer(int iPart, int iStore, int nMember) {
            int i;
            int[] aiOwners = this.getPartitionAssignments()[iPart];
            int c = aiOwners.length;
            for (i = 1; i < c; ++i) {
                if (aiOwners[i] != 0) continue;
                return i != iStore;
            }
            c = this.getBackupCount();
            for (i = iStore + 1; i <= c; ++i) {
                int nMemberCur;
                Map mapPending = this.getPendingChanges(i);
                PartitionSet parts = (PartitionSet)mapPending.get(nMemberCur = aiOwners[iStore]);
                if (parts == null || !parts.contains(iPart)) continue;
                return true;
            }
            PartitionedService service = this.getService();
            int[] aiOwnerTemp = (int[])aiOwners.clone();
            int nMemberCur = aiOwners[iStore];
            aiOwnerTemp[iStore] = nMember;
            int nStrength = service.getBackupStrength(aiOwnerTemp);
            aiOwnerTemp[iStore] = nMemberCur;
            if (nStrength < this.getTargetStrength()) {
                int c2 = this.getBackupCount();
                for (int i2 = iStore + 1; i2 <= c2; ++i2) {
                    Map mapPending = this.getPendingChanges(i2);
                    for (Map.Entry entry : mapPending.entrySet()) {
                        PartitionSet parts = (PartitionSet)entry.getValue();
                        if (parts == null || !parts.contains(iPart)) continue;
                        nMemberCur = aiOwnerTemp[i2];
                        aiOwnerTemp[i2] = (Integer)entry.getKey();
                        if (service.getBackupStrength(aiOwnerTemp) > nStrength) {
                            return true;
                        }
                        aiOwnerTemp[i2] = nMemberCur;
                    }
                }
            }
            return false;
        }

        protected void endangerPartitions(PartitionSet partsEndanger, int iStore) {
            int[][] aaiOwners = this.getPartitionAssignments();
            int nMemberThis = this.getThisMember().getId();
            PartitionedService service = this.getService();
            TransferControl ctrlTransfer = service.getTransferControl();
            int iPart = partsEndanger.next(0);
            while (iPart >= 0) {
                if (aaiOwners[iPart][0] == nMemberThis) {
                    int nBackupOwner = aaiOwners[iPart][iStore];
                    Member memberBackup = service.getServiceMemberSet().getMember(nBackupOwner);
                    if (memberBackup != null) {
                        aaiOwners[iPart][iStore] = 0;
                        service.getPartitionControl(iPart).preventTransfer();
                        ctrlTransfer.sendBackupRelease(iPart, iStore, nMemberThis, 0, memberBackup, null);
                    }
                }
                iPart = partsEndanger.next(iPart + 1);
            }
        }

        public long getAnalysisNextMillis() {
            return this.__m_AnalysisNextMillis;
        }

        public DistributionManager getDistributionManager() {
            DistributionManager mgr = this.__m_DistributionManager;
            if (mgr == null) {
                CentralDistribution._assert(this.isCoordinator());
                PartitionedService service = this.getService();
                CentralDistribution._trace("This member has become the distribution coordinator for " + String.valueOf(service.getOwnershipMemberSet()), 3);
                mgr = (DistributionManager)this._findChild("DistributionManager");
                mgr.initialize(this.getPartitionAssignmentStrategy());
                this.setDistributionManager(mgr);
                this.scheduleImmediate();
            }
            return mgr;
        }

        protected Member getLastCoordinator() {
            return this.__m_LastCoordinator;
        }

        public long getLastStorageSize() {
            return this.__m_LastStorageSize;
        }

        public PartitionAssignmentStrategy getPartitionAssignmentStrategy() {
            return this.__m_PartitionAssignmentStrategy;
        }

        public PartitionStatistics[] getPartitionStatistics() {
            return this.__m_PartitionStatistics;
        }

        public PartitionStatistics getPartitionStatistics(int i) {
            return this.getPartitionStatistics()[i];
        }

        protected Map[] getPendingChanges() {
            return this.__m_PendingChanges;
        }

        public Map getPendingChanges(int iStore) {
            return this.getPendingChanges()[iStore];
        }

        public int getTargetStrength() {
            return this.__m_TargetStrength;
        }

        @Override
        public void initialize() {
            super.initialize();
            PartitionedService service = (PartitionedService)this.get_Module();
            int cBackups = service.getBackupCount();
            Map[] aMapPending = new Map[cBackups + 1];
            for (int iStore = 0; iStore <= cBackups; ++iStore) {
                aMapPending[iStore] = new HashMap();
            }
            this.setPendingChanges(aMapPending);
            this.setPartitionStatistics(new PartitionStatistics[service.getPartitionCount()]);
            this.setStatsSamplingInterval(Config.getLong("coherence.distributed.sampling.interval", 5000L));
        }

        public boolean isCoordinator() {
            PartitionedService service = this.getService();
            return service.getOwnershipSenior(false) == service.getThisMember();
        }

        @Override
        public void onDistributionCompleted(Member member, boolean fSuccess) {
            this.setDistributionInProgress(false);
            PartitionedService service = this.getService();
            int nRetryMillis = service.getDistributionRepeatMillis() / service.getDistributionAggressiveness();
            if (!fSuccess) {
                service.getTransferControl().onReceiveRollback(member);
            }
            CentralDistribution._assert(!service.isTransferInProgress());
            service.setDistributionNextMillis(Base.getSafeTimeMillis() + (long)nRetryMillis);
            this.setStatsSampleNextMillis(Base.getSafeTimeMillis() + 1000L);
        }

        @Override
        public void onDistributionPlanUpdate(DistributionPlanUpdate msgUpdate) {
            PartitionedService service = this.getService();
            Member memberPrev = this.getLastCoordinator();
            Member memberCurr = msgUpdate.getFromMember();
            if (memberCurr != memberPrev) {
                if (memberPrev != null) {
                    CentralDistribution._trace("Ignoring unprocessed distribution plan from " + memberPrev.getId() + " due to advice from the new coordinator " + memberCurr.getId(), 6);
                    this.clearPendingChanges();
                }
                this.setLastCoordinator(memberCurr);
            }
            this.setTargetStrength(msgUpdate.getTargetStrength());
            this.processUpdate(msgUpdate.getUpdateMap());
        }

        @Override
        public void onDistributionRequest(RequestMessage msgRequest) {
            DistributionRequest msg = (DistributionRequest)msgRequest;
            PartitionedService service = this.getService();
            if (!service.checkDeferredDistribution()) {
                PartitionSet parts = msg.getPartitions();
                int cRequest = msg.getPartitionCount();
                Member memberFrom = msg.getFromMember();
                parts.retain(service.collectOwnedPartitions(true));
                cRequest = Math.min(cRequest, parts.cardinality());
                if (cRequest > 0) {
                    if (service.transferPrimary(memberFrom, msg, parts, cRequest)) {
                        return;
                    }
                    this.reportLateDistributions();
                }
            }
            Grid.Response msgResponse = (Grid.Response)service.instantiateMessage("Response");
            msgResponse.respondTo(msg);
            service.post(msgResponse);
        }

        @Override
        public void onPartitionStatsUpdate(PartitionStatsUpdate msgUpdate) {
            PartitionStatistics[] aStats = this.getPartitionStatistics();
            Iterator iter = msgUpdate.getStatsList().iterator();
            while (iter.hasNext()) {
                PartitionStatistics stats;
                aStats[stats.getPartition()] = stats = (PartitionStatistics)iter.next();
            }
            long ldtNext = Base.getSafeTimeMillis() + 1000L;
            this.getService().setDistributionNextMillis(ldtNext);
            this.setAnalysisNextMillis(ldtNext);
        }

        protected boolean processPendingChanges() {
            PartitionedService service = this.getService();
            int[][] aaiOwners = this.getPartitionAssignments();
            int nMemberThis = this.getThisMember().getId();
            ServiceMemberSet setMembers = service.getServiceMemberSet();
            int cBackups = this.getBackupCount();
            for (int iStore = 0; iStore <= cBackups; ++iStore) {
                int cPending;
                boolean fPrimary = iStore == 0;
                Map mapPending = this.getPendingChanges(iStore);
                PartitionSet partsEndanger = (PartitionSet)mapPending.remove(0);
                if (partsEndanger != null) {
                    CentralDistribution._assert(iStore > 0);
                    this.endangerPartitions(partsEndanger, iStore);
                }
                if ((cPending = mapPending.size()) == 0) continue;
                Object[] aNMember = mapPending.keySet().toArray(new Integer[cPending]);
                Base.randomize(aNMember);
                for (int i = 0; i < cPending; ++i) {
                    Object NMember = aNMember[i];
                    int nMember = (Integer)NMember;
                    PartitionSet partsPlan = (PartitionSet)mapPending.get(NMember);
                    Member member = setMembers.getMember(nMember);
                    if (member == null || !fPrimary && setMembers.isServiceLeaving(nMember)) {
                        mapPending.remove(NMember);
                        CentralDistribution._trace("Ignoring obsolete distribution plan for " + String.valueOf(partsPlan) + "; member " + nMember + (member == null ? " has left " : " is leaving ") + "the service", 6);
                        continue;
                    }
                    PartitionSet partsDefer = null;
                    int iPart = partsPlan.next(0);
                    while (iPart >= 0) {
                        int[] aiOwners = aaiOwners[iPart];
                        int nOwnerActual = aiOwners[0];
                        if (fPrimary) {
                            if (nOwnerActual != nMember) {
                                partsPlan.remove(iPart);
                            }
                        } else {
                            int iStoreCur = service.getOwnedIndex(iPart, nMember);
                            if (nOwnerActual != nMemberThis || iStore == iStoreCur || iStoreCur != -1 && service.swapBackupIndex(iPart, iStore, iStoreCur)) {
                                partsPlan.remove(iPart);
                            } else if (cBackups > 1 && this.deferBackupTransfer(iPart, iStore, nMember)) {
                                CentralDistribution._trace("Re-prioritizing transfer for backup[" + iStore + "] of " + service.reportPartitionOwnership(iPart) + " to member " + nMember, 3);
                                if (partsDefer == null) {
                                    partsDefer = new PartitionSet(partsPlan.getPartitionCount());
                                }
                                partsDefer.add(iPart);
                            }
                        }
                        iPart = partsPlan.next(iPart + 1);
                    }
                    if (partsPlan.isEmpty()) {
                        mapPending.remove(NMember);
                        continue;
                    }
                    if (fPrimary) {
                        DistributionRequest msg = (DistributionRequest)service.instantiateMessage("DistributionRequest");
                        msg.addToMember(member);
                        msg.setSourceMember(member);
                        msg.setPartitionCount(partsPlan.cardinality());
                        msg.setPartitions(partsPlan);
                        CentralDistribution._trace("Asking member " + member.getId() + " for primary ownership of " + String.valueOf(partsPlan), 3);
                        this.setDistributionInProgress(true);
                        service.post(msg);
                    } else {
                        partsPlan = new PartitionSet(partsPlan);
                        if (partsDefer != null) {
                            partsPlan.remove(partsDefer);
                            if (partsPlan.isEmpty()) continue;
                        }
                        service.transferBackup(member, partsPlan, iStore, partsPlan.cardinality());
                    }
                    return false;
                }
            }
            return true;
        }

        protected void processUpdate(Map mapUpdate) {
            int nMemberThis = this.getThisMember().getId();
            int cPartitions = this.getPartitionCount();
            int cBackups = this.getBackupCount();
            int[][] aaiOwners = this.getPartitionAssignments();
            PartitionSet partsUpdated = new PartitionSet(cPartitions);
            for (PartitionSet partitionSet : mapUpdate.values()) {
                partsUpdated.add(partitionSet);
            }
            this.clearAdvice(partsUpdated);
            for (Map.Entry entry : mapUpdate.entrySet()) {
                Ownership owners = (Ownership)entry.getKey();
                PartitionSet parts = (PartitionSet)entry.getValue();
                if (owners.getPrimaryOwner() != nMemberThis) continue;
                PartitionSet partsIgnored = null;
                int iPart = parts.next(0);
                while (iPart >= 0) {
                    int[] aiOwners = aaiOwners[iPart];
                    boolean fPrimaryXfer = false;
                    for (int iStore = 0; iStore <= cBackups; ++iStore) {
                        int nOwnerPlan = owners.getOwner(iStore);
                        int nOwnerActual = aiOwners[iStore];
                        if (iStore == 0 && nOwnerActual == 0) {
                            if (partsIgnored == null) {
                                partsIgnored = new PartitionSet(cPartitions);
                            }
                            partsIgnored.add(iPart);
                            break;
                        }
                        if (nOwnerPlan == nOwnerActual && !fPrimaryXfer) continue;
                        int nMemberTarget = iStore == 0 ? nOwnerActual : nOwnerPlan;
                        Integer IMemberTarget = nMemberTarget;
                        Map mapPending = this.getPendingChanges(iStore);
                        PartitionSet partsPending = (PartitionSet)mapPending.get(IMemberTarget);
                        if (partsPending == null) {
                            partsPending = new PartitionSet(cPartitions);
                            mapPending.put(IMemberTarget, partsPending);
                        }
                        partsPending.add(iPart);
                        fPrimaryXfer = fPrimaryXfer || iStore == 0;
                    }
                    iPart = parts.next(iPart + 1);
                }
                if (partsIgnored == null) continue;
                CentralDistribution._trace("Ignoring obsolete distribution plan update " + String.valueOf(owners) + " for endangered " + String.valueOf(partsIgnored), 6);
            }
            this.getService().setDistributionNextMillis(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void recoverOrphans(PartitionSet partsOrphan, MemberSet setOwners, Set setLeaving, GUIDHelper.GUIDResolver resolverGUID, String sSnapshot) {
            int cRequests;
            PersistenceControl.SnapshotController ctrlSnapshot;
            boolean fActivePersistence;
            CentralDistribution._assert(this.isCoordinator());
            PartitionedService service = this.getService();
            Map mapSuggest = null;
            DistributionManager manager = this.getDistributionManager();
            try {
                manager.reset();
                manager.setOwnershipMembers(setOwners);
                manager.setOwnershipLeavingMembers(setLeaving);
                this.getPartitionAssignmentStrategy().analyzeOrphans(resolverGUID.resolve());
                mapSuggest = manager.getSuggestionMap();
            }
            catch (Throwable t) {
                CentralDistribution._trace("Unexpected exception occurred while calculating the partition assignment: " + Base.printStackTrace(t), 1);
            }
            finally {
                manager.reset();
            }
            PartitionSet partsAssign = resolverGUID.getUnresolvedPartitions();
            partsAssign.retain(partsOrphan);
            Map<com.tangosol.net.Member, List<String>> mapInvalidGUIDs = resolverGUID.getInvalidGUIDs();
            PartitionSet partsRecover = service.instantiatePartitionSet(false);
            HashMap<Member, PartitionRecoverRequest> mapMemberMsg = new HashMap<Member, PartitionRecoverRequest>();
            if (mapSuggest != null && !mapSuggest.isEmpty()) {
                for (Map.Entry entry : mapSuggest.entrySet()) {
                    int nOwner = ((Ownership)entry.getKey()).getPrimaryOwner();
                    Member memberOwner = setOwners.getMember(nOwner);
                    PartitionSet parts = (PartitionSet)entry.getValue();
                    if (memberOwner == null) continue;
                    List<String> listGUIDs = mapInvalidGUIDs.get(memberOwner);
                    String[] asInvalidGUIDs = listGUIDs == null ? null : listGUIDs.toArray(new String[listGUIDs.size()]);
                    parts.retain(partsOrphan);
                    int iPart = parts.next(0);
                    while (iPart >= 0) {
                        if (partsOrphan.contains(iPart)) {
                            PartitionRecoverRequest msgRequest = (PartitionRecoverRequest)mapMemberMsg.get(memberOwner);
                            if (msgRequest == null) {
                                msgRequest = (PartitionRecoverRequest)service.instantiateMessage("PartitionRecoverRequest");
                                msgRequest.addToMember(memberOwner);
                                msgRequest.setPartsAssign(service.instantiatePartitionSet(false));
                                msgRequest.setPartsRecover(service.instantiatePartitionSet(false));
                                msgRequest.setInvalidPersistentIds(asInvalidGUIDs);
                                msgRequest.setEventsPartsFailed(service.instantiatePartitionSet(false));
                                mapMemberMsg.put(memberOwner, msgRequest);
                            }
                            if (partsAssign.contains(iPart)) {
                                msgRequest.getPartsAssign().add(iPart);
                            } else {
                                msgRequest.getPartsRecover().add(iPart);
                                partsRecover.add(iPart);
                            }
                            partsOrphan.remove(iPart);
                        }
                        iPart = parts.next(iPart + 1);
                    }
                }
            }
            if ((fActivePersistence = service.isActivePersistence()) && !partsAssign.isEmpty()) {
                CentralDistribution._trace("Failed to find a partition assignment for orphaned " + String.valueOf(partsAssign), 2);
            }
            PersistenceControl ctrlPersistence = service.getPersistenceControl();
            PersistenceControl.SnapshotController snapshotController = ctrlSnapshot = sSnapshot != null || fActivePersistence ? ctrlPersistence.getSnapshotController() : null;
            if (ctrlSnapshot != null && !partsRecover.isEmpty()) {
                ctrlSnapshot.onRecoveryStarted(sSnapshot, partsRecover);
            }
            if (!partsOrphan.isEmpty()) {
                Member memberThis = service.getThisMember();
                PartitionRecoverRequest msgRequest = (PartitionRecoverRequest)mapMemberMsg.get(memberThis);
                if (msgRequest == null) {
                    msgRequest = (PartitionRecoverRequest)service.instantiateMessage("PartitionRecoverRequest");
                    msgRequest.addToMember(memberThis);
                    msgRequest.setPartsAssign(service.instantiatePartitionSet(false));
                    msgRequest.setPartsRecover(service.instantiatePartitionSet(false));
                    if (service.isPersistEvents()) {
                        msgRequest.setEventsPartsFailed(service.instantiatePartitionSet(false));
                    }
                    mapMemberMsg.put(memberThis, msgRequest);
                }
                msgRequest.getPartsAssign().add(partsOrphan);
            }
            if ((cRequests = mapMemberMsg.size()) == 0) {
                if (ctrlSnapshot != null) {
                    ctrlSnapshot.onRecoveryCompleted(sSnapshot, partsOrphan, null);
                }
            } else {
                service.setDistributionNextMillis(Long.MAX_VALUE);
                ctrlPersistence.getActiveRecoveryRequests().set(cRequests);
                PartitionSet partsRecovered = service.instantiatePartitionSet(false);
                for (PartitionRecoverRequest msgRequest : mapMemberMsg.values()) {
                    msgRequest.setSnapshotToRecover(sSnapshot);
                    msgRequest.setGUIDs(resolverGUID.getNewestGUIDs(msgRequest.getPartsRecover()));
                    msgRequest.setPartsRecovered(partsRecovered);
                    service.post(msgRequest);
                }
                service.setOwnershipInProgress(1);
            }
        }

        @Override
        public String reportLocalDistributionState(boolean fVerbose) {
            StringBuilder sb = new StringBuilder();
            PartitionedService service = this.getService();
            ServiceMemberSet setMembers = service.getServiceMemberSet();
            int cBackups = this.getBackupCount();
            int cChanges = 0;
            for (int iStore = 0; iStore <= cBackups; ++iStore) {
                HashMap mapPending = this.getPendingChanges(iStore);
                if (mapPending.isEmpty()) continue;
                while (true) {
                    try {
                        mapPending = new HashMap(mapPending);
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        continue;
                    }
                    break;
                }
                int cPending = mapPending.size();
                Object[] aNMember = mapPending.keySet().toArray(new Integer[cPending]);
                Arrays.sort(aNMember);
                for (int i = 0; i < cPending; ++i) {
                    Object NMember = aNMember[i];
                    int nMember = (Integer)NMember;
                    PartitionSet parts = (PartitionSet)mapPending.get(NMember);
                    cChanges += parts.cardinality();
                    if (!fVerbose) continue;
                    Member member = ((MemberSet)setMembers).getMember(nMember);
                    sb.append("  Transfer of ").append(iStore == 0 ? "Primary " : "Backup ").append(parts).append(iStore == 0 ? " from" : " to").append(" Member ").append(nMember).append('\n');
                }
            }
            String sPending = this.displayPendingState(fVerbose);
            if (cChanges == 0) {
                return sPending.isEmpty() ? "There are currently no pending or scheduled distributions for this service." : sPending + "\nThere are no additional scheduled distributions for this service.";
            }
            return (String)(sPending.isEmpty() ? sPending : sPending + "\n") + cChanges + " scheduled distributions remain to be processed" + (String)(fVerbose ? ":\n" + sb.toString() : ".");
        }

        @Override
        public void scheduleImmediate() {
            PartitionedService service = this.getService();
            this.setAnalysisNextMillis(0L);
            super.scheduleImmediate();
        }

        public void setAnalysisNextMillis(long ldtNext) {
            this.__m_AnalysisNextMillis = ldtNext;
        }

        protected void setDistributionManager(DistributionManager manager) {
            this.__m_DistributionManager = manager;
        }

        protected void setLastCoordinator(Member member) {
            this.__m_LastCoordinator = member;
        }

        public void setLastStorageSize(long lSize) {
            this.__m_LastStorageSize = lSize;
        }

        public void setPartitionAssignmentStrategy(PartitionAssignmentStrategy strategy) {
            if (this.getService().isAcceptingClients()) {
                throw new IllegalStateException("Service is already running");
            }
            this.__m_PartitionAssignmentStrategy = strategy;
        }

        public void setPartitionStatistics(PartitionStatistics[] aStats) {
            this.__m_PartitionStatistics = aStats;
        }

        public void setPartitionStatistics(int i, PartitionStatistics stats) {
            this.getPartitionStatistics()[i] = stats;
        }

        protected void setPendingChanges(Map[] aMapPending) {
            this.__m_PendingChanges = aMapPending;
        }

        protected void setPendingChanges(int iStore, Map mapPending) {
            this.getPendingChanges()[iStore] = mapPending;
        }

        public void setTargetStrength(int nStrength) {
            this.__m_TargetStrength = nStrength;
        }

        public static class DistributionManager
        extends Util
        implements com.tangosol.net.partition.DistributionManager {
            private boolean __m_DeferredSuggestion;
            private PartitionSet __m_IgnoredAdvice;
            private Set __m_OwnershipLeavingMembers;
            private Set __m_OwnershipMembers;
            private String __m_StrategyName;
            private Map __m_SuggestionMap;
            private int __m_TargetStrength;

            public DistributionManager() {
                this(null, null, true);
            }

            public DistributionManager(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setTargetStrength(-1);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new DistributionManager();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$CentralDistribution$DistributionManager".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public int getBackupCount() {
                return ((PartitionedService)this.getService()).getBackupCount();
            }

            @Override
            public PartitionSet getIgnoredAdvice() {
                return this.__m_IgnoredAdvice;
            }

            @Override
            public com.tangosol.net.Member getMember(int nMemberId) {
                return ((MemberSet)this.getOwnershipMembers()).getMember(nMemberId);
            }

            @Override
            public PartitionSet getOwnedPartitions(com.tangosol.net.Member member, int iStore) {
                int[][] aiOwners = this.getPartitionAssignments();
                int cPartitions = this.getPartitionCount();
                int nMemberId = member.getId();
                PartitionSet parts = new PartitionSet(cPartitions);
                for (int i = 0; i < cPartitions; ++i) {
                    if (aiOwners[i][iStore] != nMemberId) continue;
                    parts.add(i);
                }
                return parts;
            }

            public Set getOwnershipLeavingMembers() {
                return this.__m_OwnershipLeavingMembers;
            }

            public Set getOwnershipMembers() {
                return this.__m_OwnershipMembers;
            }

            public int[][] getPartitionAssignments() {
                return ((PartitionedService)this.getService()).getPartitionAssignments();
            }

            public int getPartitionCount() {
                return ((PartitionedService)this.getService()).getPartitionCount();
            }

            @Override
            public Ownership getPartitionOwnership(int nPartition) {
                return ((PartitionedService)this.get_Module()).getPartitionOwnership(nPartition);
            }

            @Override
            public PartitionStatistics[] getPartitionStats() {
                return ((CentralDistribution)this.get_Parent()).getPartitionStatistics();
            }

            public Map getSafeSuggestions() {
                Map mapSuggest = this.getSuggestionMap();
                if (mapSuggest == null || mapSuggest.isEmpty()) {
                    return mapSuggest;
                }
                PartitionedService service = (PartitionedService)this.get_Module();
                int cBackups = this.getBackupCount();
                int nStrengthSvc = service.getBackupStrength(true);
                int nStrengthTarget = 5;
                PartitionSet partsUnchanged = service.instantiatePartitionSet(true);
                int[] aiOwners = new int[cBackups + 1];
                CentralDistribution dist = (CentralDistribution)this.get_Parent();
                if (this.isDeferredSuggestion()) {
                    nStrengthTarget = dist.getTargetStrength();
                } else {
                    for (Map.Entry entry : mapSuggest.entrySet()) {
                        Ownership ownersNew = (Ownership)entry.getKey();
                        PartitionSet parts = (PartitionSet)entry.getValue();
                        nStrengthTarget = Math.min(nStrengthTarget, service.getBackupStrength(ownersNew.getOwners(aiOwners)));
                        partsUnchanged.remove(parts);
                    }
                    int iPart = partsUnchanged.next(0);
                    while (iPart >= 0) {
                        nStrengthTarget = Math.min(nStrengthTarget, service.getBackupStrength(iPart, true));
                        iPart = partsUnchanged.next(iPart + 1);
                    }
                    dist.setTargetStrength(nStrengthTarget);
                }
                ServiceMemberSet setMembers = service.getServiceMemberSet();
                HashMap<Ownership, PartitionSet> mapDeferred = null;
                HashMap<Ownership, PartitionSet> mapSafe = null;
                Iterator iter = mapSuggest.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    Ownership ownersNew = (Ownership)entry.getKey();
                    PartitionSet partsSuggest = (PartitionSet)entry.getValue();
                    int iPart = partsSuggest.next(0);
                    while (iPart >= 0) {
                        Ownership ownersOld = this.getPartitionOwnership(iPart);
                        Ownership ownersInterim = (Ownership)ownersOld.clone();
                        if (!setMembers.isServiceLeaving(ownersOld.getPrimaryOwner()) && service.getBackupStrength(ownersOld.getOwners(aiOwners)) >= nStrengthTarget) {
                            for (int iStore = 0; iStore <= cBackups; ++iStore) {
                                PartitionSet partsSafe;
                                PartitionSet partsDeferred;
                                int nOwnerNew = ownersNew.getOwner(iStore);
                                int nOwnerOld = ownersInterim.getOwner(iStore);
                                if (nOwnerOld == nOwnerNew) continue;
                                this.simulateTransfer(ownersInterim, iStore, nOwnerNew, true);
                                if (service.getBackupStrength(ownersInterim.getOwners(aiOwners)) >= nStrengthTarget) continue;
                                Ownership ownersSafe = null;
                                for (int i = cBackups + 1; i >= 0; --i) {
                                    Ownership ownersStep = (Ownership)ownersOld.clone();
                                    if (ownersOld.getOwner(i) == ownersNew.getOwner(i)) continue;
                                    this.simulateTransfer(ownersStep, i, ownersNew.getOwner(i), false);
                                    if (service.getBackupStrength(ownersStep.getOwners(aiOwners)) < nStrengthTarget) continue;
                                    ownersSafe = ownersStep;
                                    break;
                                }
                                if (ownersSafe == null) {
                                    int iStore1 = -1;
                                    int iStore2 = -1;
                                    for (int i = cBackups + 1; i >= 0; --i) {
                                        if (ownersOld.getOwner(i) == ownersNew.getOwner(i)) continue;
                                        if (iStore1 == -1) {
                                            iStore1 = i;
                                            continue;
                                        }
                                        if (iStore2 != -1) continue;
                                        iStore2 = i;
                                    }
                                    if (iStore1 == -1 && iStore2 == -1) break;
                                    ownersSafe = (Ownership)ownersOld.clone();
                                    ownersSafe.setOwner(iStore1, ownersOld.getOwner(iStore2));
                                    ownersSafe.setOwner(iStore2, ownersOld.getOwner(iStore1));
                                }
                                if (setMembers.isServiceLeaving(ownersSafe.getPrimaryOwner())) break;
                                if (mapDeferred == null) {
                                    mapDeferred = new HashMap<Ownership, PartitionSet>();
                                    mapSafe = new HashMap<Ownership, PartitionSet>();
                                }
                                if ((partsDeferred = (PartitionSet)mapDeferred.get(ownersNew)) == null) {
                                    partsDeferred = service.instantiatePartitionSet(false);
                                    mapDeferred.put(ownersNew, partsDeferred);
                                }
                                if ((partsSafe = (PartitionSet)mapSafe.get(ownersSafe)) == null) {
                                    partsSafe = service.instantiatePartitionSet(false);
                                    mapSafe.put(ownersSafe, partsSafe);
                                }
                                partsSafe.add(iPart);
                                partsDeferred.add(iPart);
                                partsSuggest.remove(iPart);
                                if (!DistributionManager._isTraceEnabled(6)) break;
                                DistributionManager._trace("Re-ordering the suggested transfer of partition " + iPart + " from " + String.valueOf(ownersOld) + " to " + String.valueOf(ownersNew) + " to maintain the backup-strength by prioritizing the transfer to " + String.valueOf(ownersSafe), 3);
                                break;
                            }
                        }
                        iPart = partsSuggest.next(iPart + 1);
                    }
                    if (!partsSuggest.isEmpty()) continue;
                    iter.remove();
                }
                if (mapDeferred == null) {
                    this.setSuggestionMap(null);
                } else {
                    this.setSuggestionMap(mapDeferred);
                    this.setDeferredSuggestion(true);
                    for (Map.Entry entry : mapSafe.entrySet()) {
                        Ownership ownersSafe = (Ownership)entry.getKey();
                        PartitionSet partsSafe = (PartitionSet)entry.getValue();
                        PartitionSet partsSuggest = (PartitionSet)mapSuggest.get(ownersSafe);
                        if (partsSuggest == null) {
                            mapSuggest.put(ownersSafe, partsSafe);
                            continue;
                        }
                        partsSuggest.add(partsSafe);
                    }
                }
                return mapSuggest;
            }

            @Override
            public long getSamplingPeriod() {
                return ((CentralDistribution)this.get_Parent()).getStatsSamplingInterval();
            }

            @Override
            public com.tangosol.net.PartitionedService getService() {
                return (PartitionedService)this.get_Module();
            }

            public long getStatsSamplingInterval() {
                return 0L;
            }

            public String getStrategyName() {
                return this.__m_StrategyName;
            }

            public Map getSuggestionMap() {
                return this.__m_SuggestionMap;
            }

            public int getTargetStrength() {
                return this.__m_TargetStrength;
            }

            public void initialize(PartitionAssignmentStrategy strategy) {
                strategy.init(this);
                this.setStrategyName(ClassHelper.getSimpleName(strategy.getClass()));
            }

            public boolean isDeferredSuggestion() {
                return this.__m_DeferredSuggestion;
            }

            public void reset() {
                this.setOwnershipLeavingMembers(null);
                this.setOwnershipMembers(null);
                Map mapSuggest = this.getSuggestionMap();
                this.setSuggestionMap(null);
                this.setDeferredSuggestion(false);
                if (mapSuggest != null && !mapSuggest.isEmpty()) {
                    PartitionSet partsIgnored = this.getIgnoredAdvice();
                    for (PartitionSet parts : mapSuggest.values()) {
                        if (partsIgnored == null) {
                            partsIgnored = new PartitionSet(parts);
                            continue;
                        }
                        partsIgnored.add(parts);
                    }
                    this.setIgnoredAdvice(partsIgnored);
                }
            }

            @Override
            public void scheduleNextAnalysis(long cMillis) {
                CentralDistribution dist = (CentralDistribution)this.get_Parent();
                if (dist.isCoordinator() && cMillis >= 0L) {
                    long ldtNow = Base.getSafeTimeMillis();
                    dist.setAnalysisNextMillis(ldtNow + cMillis);
                    PartitionedService service = (PartitionedService)this.getService();
                    if (!service.isDistributionStable()) {
                        cMillis = Math.min(cMillis, (long)(service.getDistributionRepeatMillis() / service.getDistributionAggressiveness()));
                    }
                    service.setDistributionNextMillis(ldtNow + cMillis);
                }
            }

            protected void setDeferredSuggestion(boolean fSuggestion) {
                this.__m_DeferredSuggestion = fSuggestion;
            }

            protected void setIgnoredAdvice(PartitionSet parts) {
                this.__m_IgnoredAdvice = parts;
            }

            public void setOwnershipLeavingMembers(Set setLeaving) {
                this.__m_OwnershipLeavingMembers = setLeaving;
            }

            public void setOwnershipMembers(Set setOwners) {
                this.__m_OwnershipMembers = setOwners;
            }

            public void setStrategyName(String sName) {
                this.__m_StrategyName = sName;
            }

            protected void setSuggestionMap(Map partsUpdated) {
                this.__m_SuggestionMap = partsUpdated;
            }

            protected void setTargetStrength(int nStrength) {
                this.__m_TargetStrength = nStrength;
            }

            protected void simulateTransfer(Ownership owners, int iStore, int nOwnerNew, boolean fForward) {
                int nOwnerPrev = owners.getOwner(iStore);
                int cBackups = this.getBackupCount();
                owners.setOwner(iStore, nOwnerNew);
                if (fForward) {
                    for (int i = iStore + 1; i <= cBackups; ++i) {
                        if (owners.getOwner(i) != nOwnerNew) continue;
                        owners.setOwner(i, nOwnerPrev);
                    }
                } else {
                    for (int i = iStore - 1; i >= 0; --i) {
                        if (owners.getOwner(i) != nOwnerNew) continue;
                        owners.setOwner(i, nOwnerPrev);
                    }
                }
            }

            @Override
            public void suggest(PartitionSet parts, Ownership owners) {
                PartitionSet partsSuggest;
                if (DistributionManager._isTraceEnabled(6)) {
                    DistributionManager._trace(this.getStrategyName() + " suggested the ownership of " + String.valueOf(owners) + " for " + String.valueOf(parts), 3);
                }
                if (!this.validateSuggestion(parts, owners)) {
                    PartitionSet partsIgnored = this.getIgnoredAdvice();
                    if (partsIgnored == null) {
                        partsIgnored = new PartitionSet(parts);
                    } else {
                        partsIgnored.add(parts);
                    }
                    return;
                }
                this.setIgnoredAdvice(null);
                HashMap<Ownership, PartitionSet> mapSuggestions = this.getSuggestionMap();
                if (mapSuggestions == null) {
                    mapSuggestions = new HashMap<Ownership, PartitionSet>();
                    this.setSuggestionMap(mapSuggestions);
                }
                if ((partsSuggest = (PartitionSet)mapSuggestions.get(owners)) == null) {
                    mapSuggestions.put(owners, new PartitionSet(parts));
                } else {
                    partsSuggest.add(parts);
                }
            }

            protected boolean validateSuggestion(PartitionSet parts, Ownership owners) {
                MemberSet setSuggest = new MemberSet();
                MemberSet setOwners = (MemberSet)this.getOwnershipMembers();
                Set setLeaving = this.getOwnershipLeavingMembers();
                int cBackups = this.getBackupCount();
                for (int iStore = 0; iStore <= cBackups; ++iStore) {
                    int nOwner = owners.getOwner(iStore);
                    Member member = setOwners.getMember(nOwner);
                    if (member == null) {
                        if (nOwner == 0 && iStore > 0) continue;
                        DistributionManager._trace("Distribution suggestion (" + String.valueOf(owners) + ") for " + String.valueOf(parts) + " contains unknown member " + nOwner + "; ignoring suggested distribution", 1);
                        return false;
                    }
                    if (setLeaving.contains(member)) {
                        DistributionManager._trace("Distribution suggestion (" + String.valueOf(owners) + ") for " + String.valueOf(parts) + " contains member " + nOwner + " which is leaving the service; ignoring suggested distribution", 1);
                        return false;
                    }
                    if (setSuggest.add(member)) continue;
                    DistributionManager._trace("Distribution suggestion (" + String.valueOf(owners) + ") for " + String.valueOf(parts) + " contains duplicate storage indices for " + nOwner + "; ignoring suggested distribution", 1);
                    return false;
                }
                return true;
            }
        }
    }

    public static class Contention
    extends Util {
        private int __m_AccessCount;
        private boolean __m_Cleared;
        private int __m_Partition;
        private List __m_WaitingThreads;

        public Contention() {
            this(null, null, true);
        }

        public Contention(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setPartition(-1);
                this.setWaitingThreads(new LinkedList());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Contention();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$Contention".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public synchronized void clear() {
            this.setCleared(true);
            List listThreads = this.getWaitingThreads();
            listThreads.remove(Thread.currentThread());
            if (!listThreads.isEmpty()) {
                this.notifyAll();
            }
        }

        public int getAccessCount() {
            return this.__m_AccessCount;
        }

        public int getPartition() {
            return this.__m_Partition;
        }

        public List getWaitingThreads() {
            return this.__m_WaitingThreads;
        }

        public boolean isCleared() {
            return this.__m_Cleared;
        }

        public void setAccessCount(int c) {
            this.__m_AccessCount = c;
        }

        protected void setCleared(boolean fClear) {
            this.__m_Cleared = fClear;
        }

        public void setPartition(int iBucket) {
            this.__m_Partition = iBucket;
        }

        protected void setWaitingThreads(List list) {
            this.__m_WaitingThreads = list;
        }

        @Override
        public String toString() {
            return "Contention for partition " + this.getPartition() + " among " + this.getWaitingThreads().size() + " threads; count " + this.getAccessCount();
        }
    }

    public static class ConverterKeyToBinary
    extends Converter
    implements KeyPartitioningStrategy {
        private boolean __m_PassThrough;

        public ConverterKeyToBinary() {
            this(null, null, true);
        }

        public ConverterKeyToBinary(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ConverterKeyToBinary();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$ConverterKeyToBinary".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public Object convert(Object o) {
            int nHash;
            PartitionedService service = (PartitionedService)this.get_Module();
            KeyPartitioningStrategy partitioning = service.getKeyPartitioningStrategy();
            if (this.isPassThrough()) {
                int nHash2;
                Binary binKey = (Binary)o;
                ConverterKeyToBinary._assert(binKey != null);
                boolean fDeco = ExternalizableHelper.isIntDecorated(binKey);
                if (partitioning instanceof ConverterKeyToBinary) {
                    if (fDeco) {
                        nHash2 = binKey.getEncodedHash();
                    } else {
                        o = ExternalizableHelper.fromBinary(binKey, this.getSerializer());
                        Object oAssocKey = service.getKeyAssociator().getAssociatedKey(o);
                        nHash2 = oAssocKey == null ? (o instanceof KeyPartitioningStrategy.PartitionAwareKey ? ((KeyPartitioningStrategy.PartitionAwareKey)o).getPartitionId() : binKey.calculateNaturalPartition(0)) : DefaultKeyPartitioningStrategy.calculateBasePartitionHash(service, oAssocKey);
                    }
                } else {
                    o = ExternalizableHelper.fromBinary(binKey, this.getSerializer());
                    nHash2 = partitioning.getKeyPartition(o);
                }
                int nHashNew = service.convertHash(nHash2);
                if (fDeco) {
                    if (nHash2 == nHashNew) {
                        return binKey;
                    }
                    binKey = ExternalizableHelper.removeIntDecoration(binKey).toBinary();
                }
                return ExternalizableHelper.decorateBinary(binKey, nHashNew).toBinary();
            }
            if (partitioning instanceof ConverterKeyToBinary) {
                Object oAssocKey = service.getKeyAssociator().getAssociatedKey(o);
                if (oAssocKey == null) {
                    Binary binKey = ExternalizableHelper.toBinary(o, this.getSerializer());
                    int nHash3 = o instanceof KeyPartitioningStrategy.PartitionAwareKey ? ((KeyPartitioningStrategy.PartitionAwareKey)o).getPartitionId() : binKey.calculateNaturalPartition(0);
                    return ExternalizableHelper.decorateBinary(binKey, service.convertHash(nHash3)).toBinary();
                }
                nHash = DefaultKeyPartitioningStrategy.calculateBasePartitionHash(service, oAssocKey);
            } else {
                nHash = partitioning.getKeyPartition(o);
            }
            return ExternalizableHelper.toBinary(ExternalizableHelper.decorate(o, service.convertHash(nHash)), this.getSerializer());
        }

        @Override
        public PartitionSet getAssociatedPartitions(Object oKey) {
            PartitionedService service = (PartitionedService)this.get_Module();
            PartitionSet parts = new PartitionSet(service.getPartitionCount());
            parts.add(this.getKeyPartition(oKey));
            return parts;
        }

        @Override
        public int getKeyPartition(Object oKey) {
            return DefaultKeyPartitioningStrategy.calculateKeyPartition((PartitionedService)this.get_Module(), oKey);
        }

        @Override
        public void init(com.tangosol.net.PartitionedService service) {
        }

        public boolean isPassThrough() {
            return this.__m_PassThrough;
        }

        public void setPassThrough(boolean fPass) {
            this.__m_PassThrough = fPass;
        }
    }

    public static class DispatchEvent
    extends Grid.DispatchEvent {
        public DispatchEvent() {
            this(null, null, true);
        }

        public DispatchEvent(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new DispatchEvent();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$DispatchEvent".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }
    }

    public static class DistributionPlanUpdate
    extends Message {
        private int __m_TargetStrength;
        private Map __m_UpdateMap;

        public DistributionPlanUpdate() {
            this(null, null, true);
        }

        public DistributionPlanUpdate(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(36);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new DistributionPlanUpdate();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$DistributionPlanUpdate".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            StringBuilder sb = new StringBuilder();
            Map mapUpdate = this.getUpdateMap();
            sb.append("\nOwnership Assignments={");
            for (Map.Entry entry : mapUpdate.entrySet()) {
                Ownership owners = (Ownership)entry.getKey();
                PartitionSet parts = (PartitionSet)entry.getValue();
                sb.append("\n  ").append(parts).append("=").append(owners);
            }
            sb.append("}");
            return sb.toString();
        }

        public int getTargetStrength() {
            return this.__m_TargetStrength;
        }

        public Map getUpdateMap() {
            return this.__m_UpdateMap;
        }

        @Override
        public void onReceived() {
            PartitionedService service = (PartitionedService)this.get_Module();
            service.getDistributionStrategy().onDistributionPlanUpdate(this);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setTargetStrength(ExternalizableHelper.readInt(input));
            int cEntries = ExternalizableHelper.readInt(input);
            HashMap<Ownership, PartitionSet> mapUpdate = new HashMap<Ownership, PartitionSet>();
            for (int i = 0; i < cEntries; ++i) {
                Ownership owners = new Ownership();
                PartitionSet parts = new PartitionSet();
                owners.readExternal(input);
                parts.readExternal(input);
                mapUpdate.put(owners, parts);
            }
            this.setUpdateMap(mapUpdate);
        }

        public void setTargetStrength(int nStrength) {
            this.__m_TargetStrength = nStrength;
        }

        public void setUpdateMap(Map mapUpdate) {
            this.__m_UpdateMap = mapUpdate;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            PartitionedService service = (PartitionedService)this.getService();
            Map mapUpdate = this.getUpdateMap();
            ExternalizableHelper.writeInt(output, this.getTargetStrength());
            ExternalizableHelper.writeInt(output, mapUpdate.size());
            for (Map.Entry entry : mapUpdate.entrySet()) {
                Ownership owners = (Ownership)entry.getKey();
                PartitionSet parts = (PartitionSet)entry.getValue();
                owners.writeExternal(output);
                parts.writeExternal(output);
            }
        }
    }

    public static class DistributionRequest
    extends RequestMessage {
        private int __m_PartitionCount;
        private PartitionSet __m_Partitions;
        private transient Member __m_SourceMember;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public DistributionRequest() {
            this(null, null, true);
        }

        public DistributionRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(35);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new DistributionRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$DistributionRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public int getPartitionCount() {
            return this.__m_PartitionCount;
        }

        public PartitionSet getPartitions() {
            return this.__m_Partitions;
        }

        public Member getSourceMember() {
            return this.__m_SourceMember;
        }

        @Override
        protected com.tangosol.coherence.component.net.Poll instantiatePoll() {
            return (com.tangosol.coherence.component.net.Poll)this._newChild("Poll");
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ((PartitionedService)this.getService()).getDistributionStrategy().onDistributionRequest(this);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setPartitionCount(ExternalizableHelper.readInt(input));
            PartitionSet parts = new PartitionSet();
            parts.readExternal(input);
            this.setPartitions(parts);
        }

        public void setPartitionCount(int cBuckets) {
            this.__m_PartitionCount = cBuckets;
        }

        public void setPartitions(PartitionSet pPartitions) {
            this.__m_Partitions = pPartitions;
        }

        public void setSourceMember(Member member) {
            this.__m_SourceMember = member;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            ExternalizableHelper.writeInt(output, this.getPartitionCount());
            this.getPartitions().writeExternal(output);
        }

        static {
            DistributionRequest.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$DistributionRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected void onCompletion() {
                int iResult;
                Integer IResult = (Integer)this.getResult();
                int n = iResult = IResult == null ? 2 : IResult;
                if (iResult == 2) {
                    ((PartitionedService)this.getService()).getDistributionStrategy().onDistributionCompleted(((DistributionRequest)this.get_Parent()).getSourceMember(), false);
                }
                super.onCompletion();
            }

            @Override
            public void onResponse(Message msg) {
                if (msg instanceof TransferRequest) {
                    TransferRequest msgTransfer = (TransferRequest)msg;
                    if (!msgTransfer.isLastInTransfer()) {
                        return;
                    }
                    if (((PartitionedService)this.getService()).isOwnershipEnabled()) {
                        this.setResult(0);
                    } else {
                        this.setResult(2);
                    }
                } else {
                    this.setResult(2);
                }
                super.onResponse(msg);
            }
        }
    }

    public static class MemberConfigUpdate
    extends Grid.MemberConfigUpdate {
        public MemberConfigUpdate() {
            this(null, null, true);
        }

        public MemberConfigUpdate(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-3);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MemberConfigUpdate();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$MemberConfigUpdate".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void onReceived() {
            super.onReceived();
            PartitionedService service = (PartitionedService)this.getService();
            if (service.isAcceptingClients() && service.isOwnershipEnabled() && Base.equals("ownership-enabled", this.getKey()) && Base.equals(4, this.getValue())) {
                service.getDistributionStrategy().onMembershipChanged(1);
                service.getPersistenceControl().onMembershipChanged(1);
            }
        }
    }

    public static class MemberWelcome
    extends Grid.MemberWelcome {
        private Map __m_PartitionConfigMap;

        public MemberWelcome() {
            this(null, null, true);
        }

        public MemberWelcome(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-2);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MemberWelcome();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$MemberWelcome".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return super.getDescription() + ", PartitionConfig=" + String.valueOf(this.getPartitionConfigMap());
        }

        public Map getPartitionConfigMap() {
            return this.__m_PartitionConfigMap;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            PartitionedService service = (PartitionedService)this.getService();
            Map mapConfig = this.getPartitionConfigMap();
            MemberWelcome._trace("Received MemberWelcome from member " + this.getFromMember().getId() + ", memberConfigMap: " + String.valueOf(this.getMemberConfigMap()) + ", serviceConfigMap: " + String.valueOf(this.getServiceConfigMap()) + ", partitionConfigMap: " + String.valueOf(mapConfig), 7);
            if (mapConfig != null) {
                service.getPartitionConfigMap().updateInternal(mapConfig, false);
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            if (this.isRejected()) {
                return;
            }
            PartitionedService service = (PartitionedService)this.getService();
            try {
                HashMap<Object, Object> mapConfig = null;
                boolean fPartitionConfig = input.readBoolean();
                if (fPartitionConfig) {
                    ServiceConfig cfgPartition = service.getPartitionConfigMap().getConfig();
                    mapConfig = new HashMap<Object, Object>();
                    int c = input.readInt();
                    for (int i = 0; i < c; ++i) {
                        Object oKey = cfgPartition.readObject(input);
                        Object oValue = cfgPartition.readObject(input);
                        mapConfig.put(oKey, oValue);
                    }
                }
                this.setPartitionConfigMap(mapConfig);
            }
            catch (IOException e) {
                service.onConfigIOException(e, this.getFromMember());
            }
        }

        public void setPartitionConfigMap(Map mapConfig) {
            this.__m_PartitionConfigMap = mapConfig;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            if (this.isRejected()) {
                return;
            }
            PartitionedService service = (PartitionedService)this.getService();
            Map mapConfig = this.getPartitionConfigMap();
            if (mapConfig == null) {
                output.writeBoolean(false);
            } else {
                ServiceConfig cfgPartition = service.getPartitionConfigMap().getConfig();
                output.writeBoolean(true);
                output.writeInt(mapConfig.size());
                for (Map.Entry entry : mapConfig.entrySet()) {
                    cfgPartition.writeObject(output, entry.getKey());
                    cfgPartition.writeObject(output, entry.getValue());
                }
            }
        }
    }

    public static class MemberWelcomeRequest
    extends Grid.MemberWelcomeRequest {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Grid.MemberWelcomeRequest.Poll.get_CLASS());
        }

        public MemberWelcomeRequest() {
            this(null, null, true);
        }

        public MemberWelcomeRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-1);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MemberWelcomeRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$MemberWelcomeRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        protected Grid.MemberWelcome populateWelcomeMessage() {
            MemberWelcome msgWelcome = (MemberWelcome)super.populateWelcomeMessage();
            if (!msgWelcome.isRejected()) {
                PartitionedService service = (PartitionedService)this.getService();
                PartitionConfig.Map mapPartitionConfig = service.getPartitionConfigMap();
                if (service.getThisMember() == mapPartitionConfig.getConfigCoordinator()) {
                    if (service.isVersionCompatible(msgWelcome.getToMemberSet(), 12, 2, 1, 1, 0)) {
                        msgWelcome.setPartitionConfigMap(mapPartitionConfig);
                    } else {
                        HashMap mapClone = new HashMap(mapPartitionConfig);
                        mapClone.remove(PartitionConfig.KEY_QUORUM);
                        msgWelcome.setPartitionConfigMap(mapClone);
                    }
                }
            }
            return msgWelcome;
        }

        static {
            MemberWelcomeRequest.__initStatic();
        }
    }

    public static class NotifyServiceLeaving
    extends Grid.NotifyServiceLeaving {
        public NotifyServiceLeaving() {
            this(null, null, true);
        }

        public NotifyServiceLeaving(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-11);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyServiceLeaving();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$NotifyServiceLeaving".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ((PartitionedService)this.getService()).onNotifyServiceLeaving(this.getNotifyMember());
        }
    }

    public static class NotifyServiceQuiescence
    extends Grid.NotifyServiceQuiescence {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Grid.NotifyServiceQuiescence.Poll.get_CLASS());
        }

        public NotifyServiceQuiescence() {
            this(null, null, true);
        }

        public NotifyServiceQuiescence(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-22);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyServiceQuiescence();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$NotifyServiceQuiescence".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public boolean isResumeOnFailover() {
            return super.isResumeOnFailover();
        }

        static {
            NotifyServiceQuiescence.__initStatic();
        }
    }

    public static class NotifyShutdown
    extends Grid.NotifyShutdown {
        public NotifyShutdown() {
            this(null, null, true);
        }

        public NotifyShutdown(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-13);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyShutdown();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$NotifyShutdown".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void onReceived() {
            ((PartitionedService)this.getService()).onNotifyShutdown();
        }
    }

    public static class NotifySnapshotRecoverRequest
    extends Message {
        private String __m_SnapshotName;

        public NotifySnapshotRecoverRequest() {
            this(null, null, true);
        }

        public NotifySnapshotRecoverRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(44);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifySnapshotRecoverRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$NotifySnapshotRecoverRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public String getSnapshotName() {
            return this.__m_SnapshotName;
        }

        @Override
        public void onReceived() {
            ((PartitionedService)this.getService()).onNotifySnapshotRecoverRequest(this.getSnapshotName());
        }

        public void setSnapshotName(String sName) {
            this.__m_SnapshotName = sName;
        }
    }

    public static class OwnershipRequest
    extends RequestMessage {
        private transient OwnershipConflictResolver __m_ConflictResolver;
        private transient GUIDHelper.GUIDResolver __m_PersistentIdResolver;
        private boolean __m_Query;
        private QuorumInfo __m_QuorumInfo;
        private PartitionSet __m_RecoveryPartitions;
        public static final int REQUEST_COUNT_THRESHOLD = 4;
        private int[][] __m_RequestAssignments;
        private transient int __m_RequestCount;
        private PartitionSet __m_RestorePartitions;
        private MemberSet __m_SenderMemberSet;
        private String __m_SnapshotToRecover;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public OwnershipRequest() {
            this(null, null, true);
        }

        public OwnershipRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(33);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new OwnershipRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$OwnershipRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public OwnershipConflictResolver getConflictResolver() {
            OwnershipConflictResolver resolver = this.__m_ConflictResolver;
            if (resolver == null) {
                PartitionedService service = (PartitionedService)this.getService();
                resolver = new OwnershipConflictResolver(service.getPartitionCount(), service.getBackupCount());
                this.setConflictResolver(resolver);
            }
            return resolver;
        }

        public GUIDHelper.GUIDResolver getPersistentIdResolver() {
            GUIDHelper.GUIDResolver resolver = this.__m_PersistentIdResolver;
            if (resolver == null) {
                resolver = new GUIDHelper.GUIDResolver(((PartitionedService)this.getService()).getPartitionCount());
                this.setPersistentIdResolver(resolver);
            }
            return resolver;
        }

        public QuorumInfo getQuorumInfo() {
            return this.__m_QuorumInfo;
        }

        public PartitionSet getRecoveryPartitions() {
            return this.__m_RecoveryPartitions;
        }

        public int[][] getRequestAssignments() {
            return this.__m_RequestAssignments;
        }

        public int getRequestCount() {
            return this.__m_RequestCount;
        }

        public PartitionSet getRestorePartitions() {
            return this.__m_RestorePartitions;
        }

        public MemberSet getSenderMemberSet() {
            return this.__m_SenderMemberSet;
        }

        public String getSnapshotToRecover() {
            return this.__m_SnapshotToRecover;
        }

        @Override
        protected com.tangosol.coherence.component.net.Poll instantiatePoll() {
            return (com.tangosol.coherence.component.net.Poll)this._newChild("Poll");
        }

        public boolean isQuery() {
            return this.__m_Query;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ((PartitionedService)this.getService()).onOwnershipRequest(this);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            boolean fAssignments;
            super.read(input);
            MemberSet setMembers = new MemberSet();
            setMembers.readExternal(input);
            this.setSenderMemberSet(setMembers);
            boolean fQuery = input.readBoolean();
            this.setQuery(fQuery);
            if (input.readBoolean()) {
                this.setSnapshotToRecover(input.readUTF());
            }
            boolean bl = fAssignments = !fQuery;
            if (fQuery) {
                int cAttempt = ExternalizableHelper.readInt(input);
                this.setRequestCount(cAttempt);
                fAssignments = cAttempt > 4;
            } else if (input.readBoolean()) {
                PartitionSet parts = new PartitionSet();
                parts.readExternal(input);
                this.setRecoveryPartitions(parts);
            }
            if (fAssignments) {
                this.setRequestAssignments(ExternalizableHelper.readIntArray2d(input));
            }
        }

        protected void setConflictResolver(OwnershipConflictResolver resolver) {
            this.__m_ConflictResolver = resolver;
        }

        protected void setPersistentIdResolver(GUIDHelper.GUIDResolver resolver) {
            this.__m_PersistentIdResolver = resolver;
        }

        public void setQuery(boolean fQuery) {
            this.__m_Query = fQuery;
        }

        public void setQuorumInfo(QuorumInfo infoQuorum) {
            this.__m_QuorumInfo = infoQuorum;
        }

        public void setRecoveryPartitions(PartitionSet setPartitions) {
            this.__m_RecoveryPartitions = setPartitions;
        }

        public void setRequestAssignments(int[][] aai) {
            this.__m_RequestAssignments = aai;
        }

        public void setRequestCount(int c) {
            this.__m_RequestCount = c;
        }

        public void setRestorePartitions(PartitionSet setPartitions) {
            this.__m_RestorePartitions = setPartitions;
        }

        public void setSenderMemberSet(MemberSet setMember) {
            this.__m_SenderMemberSet = setMember;
        }

        public void setSnapshotToRecover(String sSnapshot) {
            this.__m_SnapshotToRecover = sSnapshot;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            PartitionedService service = (PartitionedService)this.getService();
            this.getSenderMemberSet().writeExternal(output);
            boolean fQuery = this.isQuery();
            output.writeBoolean(fQuery);
            String sSnapshot = this.getSnapshotToRecover();
            if (sSnapshot == null) {
                output.writeBoolean(false);
            } else {
                output.writeBoolean(true);
                output.writeUTF(sSnapshot);
            }
            int[][] aaiOwners = null;
            if (fQuery) {
                int cAttempt = service.getOwnershipInProgress();
                ExternalizableHelper.writeInt(output, cAttempt);
                if (cAttempt > 4) {
                    aaiOwners = service.getPartitionAssignments();
                }
            } else {
                PartitionSet partsRecover = this.getRecoveryPartitions();
                if (partsRecover == null) {
                    output.writeBoolean(false);
                } else {
                    output.writeBoolean(true);
                    partsRecover.writeExternal(output);
                }
                aaiOwners = this.getRequestAssignments();
            }
            if (aaiOwners != null) {
                ExternalizableHelper.writeIntArray2d(output, aaiOwners);
            }
        }

        static {
            OwnershipRequest.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            private transient int __m_ConflictCount;

            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$OwnershipRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            private static QuorumInfo deserializeQuorumInfo(Binary binQuorum) {
                return (QuorumInfo)ExternalizableHelper.fromBinary(binQuorum, NullImplementation.getClassLoader());
            }

            public int getConflictCount() {
                return this.__m_ConflictCount;
            }

            @Override
            protected void onCompletion() {
                PartitionedService service = (PartitionedService)this.getService();
                OwnershipRequest msgRequest = (OwnershipRequest)this.get_Parent();
                if (service.getServiceState() != 4) {
                    Binary binQuorum;
                    int cConflicts;
                    if (!this.getLeftMemberSet().isEmpty() || !service.getOwnershipMemberSet().equals(this.getRespondedMemberSet())) {
                        this.setConflictCount(-1);
                    }
                    if ((cConflicts = this.getConflictCount()) == 0 && msgRequest.isQuery()) {
                        PartitionSet partsConflict = msgRequest.getConflictResolver().resolveConflicts();
                        cConflicts = partsConflict.cardinality();
                        this.setConflictCount(cConflicts);
                    }
                    if ((binQuorum = service.getPersistenceControl().getQuorumRaw()) != null) {
                        msgRequest.setQuorumInfo(Poll.deserializeQuorumInfo(binQuorum));
                    }
                    service.onOwnershipRequestCompleted(msgRequest, cConflicts);
                }
                super.onCompletion();
            }

            @Override
            public void onResponse(Message msg) {
                if (this.isClosed()) {
                    return;
                }
                OwnershipResponse msgResponse = (OwnershipResponse)msg;
                if (msgResponse.isSuccess()) {
                    PartitionedService service = (PartitionedService)this.getService();
                    OwnershipRequest msgRequest = (OwnershipRequest)this.get_Parent();
                    if (msgRequest.isQuery()) {
                        int nMemberFrom = msg.getFromMember().getId();
                        int[][] aaiOwnersThat = msgResponse.getAssignments();
                        service.calculateOwnershipConflicts(nMemberFrom, aaiOwnersThat, service.getOwnershipInProgress());
                        msgRequest.getConflictResolver().registerOwnership(nMemberFrom, aaiOwnersThat);
                    } else {
                        Binary binQuorum;
                        PersistentStoreInfo[] aInfo;
                        GUIDHelper.GUIDResolver resolver = msgRequest.getPersistentIdResolver();
                        if (msgRequest.getRecoveryPartitions() != null && (aInfo = msgResponse.getStoreInfos()) != null) {
                            resolver.registerStoreInfo(msg.getFromMember(), aInfo);
                        }
                        if ((binQuorum = msgResponse.getQuorumRaw()) != null) {
                            if (msgRequest.getQuorumInfo() == null) {
                                msgRequest.setQuorumInfo(Poll.deserializeQuorumInfo(binQuorum));
                            } else {
                                Map<com.tangosol.net.Member, PartitionSet> mapResolved = resolver.resolve();
                                PartitionSet partsNew = mapResolved.get(msg.getFromMember());
                                if (partsNew != null && partsNew.intersects(CachePersistenceHelper.getGlobalPartitions(service))) {
                                    msgRequest.setQuorumInfo(Poll.deserializeQuorumInfo(binQuorum));
                                }
                            }
                        }
                    }
                    super.onResponse(msg);
                } else {
                    this.setConflictCount(-1);
                    this.close();
                }
            }

            protected void setConflictCount(int c) {
                this.__m_ConflictCount = c;
            }
        }
    }

    public static class OwnershipResponse
    extends Message {
        private int[][] __m_Assignments;
        private PersistentStoreInfo[] __m_StoreInfos;
        private Binary __m_QuorumRaw;
        private boolean __m_Success;

        public OwnershipResponse() {
            this(null, null, true);
        }

        public OwnershipResponse(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(42);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new OwnershipResponse();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$OwnershipResponse".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public int[][] getAssignments() {
            return this.__m_Assignments;
        }

        public PersistentStoreInfo[] getStoreInfos() {
            return this.__m_StoreInfos;
        }

        public Binary getQuorumRaw() {
            return this.__m_QuorumRaw;
        }

        public boolean isSuccess() {
            return this.__m_Success;
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            boolean fSuccess = input.readBoolean();
            this.setSuccess(fSuccess);
            if (fSuccess) {
                int cb;
                boolean fStores;
                Grid service = this.getService();
                boolean fAssignments = input.readBoolean();
                if (fAssignments) {
                    this.setAssignments(ExternalizableHelper.readIntArray2d(input));
                }
                if (fStores = input.readBoolean()) {
                    boolean fStoresCompat = service.isVersionCompatible(OwnershipResponse::isLazyOpenCompatible);
                    int cStores = input.readInt();
                    PersistentStoreInfo[] aInfo = new PersistentStoreInfo[cStores];
                    for (int i = 0; i < cStores; ++i) {
                        aInfo[i] = fStoresCompat ? (PersistentStoreInfo)ExternalizableHelper.readObject(input) : new PersistentStoreInfo(input.readUTF(), false);
                    }
                    this.setStoreInfos(aInfo);
                }
                if (service.isVersionCompatible(this.getFromMember(), 12, 2, 1, 1, 0) && (cb = input.readInt()) > 0) {
                    this.setQuorumRaw(input.readBuffer(cb).toBinary());
                }
            }
        }

        public void setAssignments(int[][] aanAssignments) {
            this.__m_Assignments = aanAssignments;
        }

        public void setStoreInfos(PersistentStoreInfo[] aInfos) {
            this.__m_StoreInfos = aInfos;
        }

        public void setQuorumRaw(Binary bin) {
            this.__m_QuorumRaw = bin;
        }

        public void setSuccess(boolean fSuccess) {
            this.__m_Success = fSuccess;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            boolean fSuccess = this.isSuccess();
            output.writeBoolean(fSuccess);
            if (fSuccess) {
                Grid service = this.getService();
                int[][] aaiOwner = this.getAssignments();
                if (aaiOwner == null) {
                    output.writeBoolean(false);
                } else {
                    output.writeBoolean(true);
                    ExternalizableHelper.writeIntArray2d(output, aaiOwner);
                }
                PersistentStoreInfo[] aInfo = this.getStoreInfos();
                boolean fStores = aInfo != null;
                output.writeBoolean(fStores);
                if (fStores) {
                    boolean fStoresCompat = service.isVersionCompatible(OwnershipResponse::isLazyOpenCompatible);
                    int cStores = aInfo.length;
                    output.writeInt(cStores);
                    for (int i = 0; i < cStores; ++i) {
                        if (fStoresCompat) {
                            ExternalizableHelper.writeObject(output, aInfo[i]);
                            continue;
                        }
                        output.writeUTF(aInfo[i].getId());
                    }
                }
                if (service.isVersionCompatible(this.getToMemberSet(), 12, 2, 1, 1, 0)) {
                    Binary bin = this.getQuorumRaw();
                    int cb = bin == null ? 0 : bin.length();
                    output.writeInt(cb);
                    if (cb > 0) {
                        output.writeBuffer(bin);
                    }
                }
            }
        }

        protected static boolean isLazyOpenCompatible(int nVersion) {
            return VersionHelper.isVersionCompatible(VersionHelper.VERSION_14_1_2_0, nVersion) || VersionHelper.isVersionCompatible(VersionHelper.VERSION_24_09, nVersion);
        }
    }

    public static class PartitionAbandonRequest
    extends ChainedRequest {
        private PartitionSet __m_PartitionSet;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public PartitionAbandonRequest() {
            this(null, null, true);
        }

        public PartitionAbandonRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(46);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PartitionAbandonRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionAbandonRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            PartitionAbandonRequest msgRequest = (PartitionAbandonRequest)super.cloneMessage();
            msgRequest.setPartitionSet(this.getPartitionSet());
            return msgRequest;
        }

        public PartitionSet getPartitionSet() {
            return this.__m_PartitionSet;
        }

        @Override
        public void onRequestDelivered() {
            ((PartitionedService)this.get_Module()).onPartitionAbandonRequest(this);
            super.onRequestDelivered();
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            PartitionSet parts = new PartitionSet();
            parts.readExternal(input);
            this.setPartitionSet(parts);
        }

        public void setPartitionSet(PartitionSet sProperty) {
            this.__m_PartitionSet = sProperty;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            this.getPartitionSet().writeExternal(output);
        }

        static {
            PartitionAbandonRequest.__initStatic();
        }

        public static class Poll
        extends ChainedRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            @Override
            public boolean isPreprocessable() {
                return false;
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionAbandonRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static abstract class PartitionControl
    extends Component
    implements Guardable {
        private transient AtomicInteger __m_BackupPolls;
        private List __m_BackupsCompletedActions;
        private Guardian.GuardContext __m_Context;
        private Message __m_DeferredBackup;
        private List __m_DeferredBackups;
        private long __m_EventStartTime;
        public static final int LOCK_BACKUP_XFER_OUT = 1;
        public static final int LOCK_NONE = 0;
        public static final int LOCK_PENDING = 8;
        public static final int LOCK_PERSISTENCE = 4;
        public static final int LOCK_PRIMARY_XFER_IN = 2;
        public static final int LOCK_PRIMARY_XFER_OUT = 3;
        private int __m_LockAttempt;
        private int __m_LockId;
        public static final int PARTITION_EVENT_ASSIGNED = 10;
        public static final int PARTITION_EVENT_INDEX_BUILD = 11;
        public static final int PARTITION_EVENT_RESTORE = 12;
        private int __m_PartitionId;
        private volatile int __m_PartitionState;
        private LongArray __m_PendingBackups;
        private Map __m_PendingBackupTotalSize;
        private transient AtomicInteger __m_PersistenceTasks;
        private CopyOnWriteLongList __m_PersistentBackupExtents;
        private transient PersistentStore __m_PersistentBackupStore;
        private transient PersistentStore __m_PersistentEventsStore;
        private CopyOnWriteLongList __m_PersistentExtents;
        private volatile transient PersistentStore __m_PersistentStore;
        private boolean __m_Recovered;
        public static final int STATE_MASK_LOCK = 15;
        public static final int STATE_MASK_PIN = 64;
        public static final int STATE_MASK_SYNC = 128;
        public static final int STATE_MASK_XFER = 48;
        public static final int STATE_SHIFT_LOCK = 0;
        public static final int STATE_SHIFT_PIN = 6;
        public static final int STATE_SHIFT_SYNC = 7;
        public static final int STATE_SHIFT_XFER = 4;
        private PartitionStatistics __m_Statistics;
        private ThreadLocal __m_TLOEnterCounter;
        private long __m_VersionBackup;
        private AtomicLong __m_VersionCounter;
        private LongSupplier __m_VersionIncrementer;
        public static final int XFER_NONE = 0;
        public static final int XFER_SENT = 2;
        public static final int XFER_STARTED = 1;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("GuardContinuation", GuardContinuation.get_CLASS());
        }

        public PartitionControl(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionControl".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public synchronized void addBackupsCompletedAction(Continuation continuation) {
            PartitionControl._assert(this.isLocked());
            LinkedList<Continuation> list = this.getBackupsCompletedActions();
            if (list == null) {
                list = new LinkedList<Continuation>();
                this.setBackupsCompletedActions(list);
            }
            list.add(continuation);
        }

        public synchronized void addUnlockAction(Continuation continuation) {
            ConcurrentLinkedQueue<Continuation> queueActions = this.getUnlockActions();
            if (queueActions == null) {
                queueActions = new ConcurrentLinkedQueue<Continuation>();
                this.set_Sink(queueActions);
            }
            queueActions.offer(continuation);
        }

        public void beginEvent() {
            this.setEventStartTime(Base.getSafeTimeMillis());
        }

        public void checkDeferredBackups() {
            if (this.getContext() == null && !this.getDeferredBackups().isEmpty()) {
                PartitionedService service = this.getService();
                service.guard(this, service.getDeferredBackupTimeoutMillis(), 0.9f);
            }
        }

        public void deferBackup(Message msgBackup, long lVersionNew) {
            List listDefer = this.getDeferredBackups();
            long lVersionNext = this.getVersionCounter().get() + 1L;
            int iNew = (int)(lVersionNew - lVersionNext - 1L);
            int iMax = listDefer.size();
            if (lVersionNew == lVersionNext) {
                this.setDeferredBackup(msgBackup);
            } else if (iNew >= iMax) {
                for (int i = iMax; i < iNew; ++i) {
                    listDefer.add(null);
                }
                listDefer.add(msgBackup);
            } else {
                listDefer.set(iNew, msgBackup);
            }
        }

        public synchronized boolean deferResponse(Grid.Response msgResponse) {
            if (this.getLockType() == 0) {
                return false;
            }
            msgResponse.setResult(1);
            this.addUnlockAction(this.getService().getContinuations().instantiateMessagePost(msgResponse));
            return true;
        }

        public void deleteBackupPersistentStore() {
            String sStoreId;
            PersistentStore store = this.getPersistentBackupStore();
            if (store != null && (sStoreId = store.getId()) != null) {
                this.getService().getPersistenceControl().getBackupManager().delete(sStoreId, false);
                PartitionControl._trace("Deleted persistent backup store " + sStoreId, 7);
            }
            this.setPersistentBackupStore(null);
        }

        public void deletePersistentExtent(long lExtentId, LongArray laCaches) {
        }

        public void deletePersistentStore() {
            for (PersistentStore store : new PersistentStore[]{this.getPersistentStore(), this.getPersistentEventsStore()}) {
                String sStoreId;
                if (store == null || (sStoreId = store.getId()) == null) continue;
                this.getService().getPersistenceManager().delete(sStoreId, false);
                PartitionControl._trace("Deleted persistent store " + sStoreId, 7);
            }
            this.setPersistentStore(null);
            this.setPersistentEventsStore(null);
        }

        public void disablePersistentStore() {
            this.setPersistentStore(NullImplementation.getPersistentStore());
            this.setPersistentEventsStore(NullImplementation.getPersistentStore());
        }

        public void doSyncBackups() {
            this.flushDeferredBackups();
            PartitionedService service = (PartitionedService)this.get_Module();
            int nPartition = this.getPartitionId();
            List listBackups = service.getBackupOwners(nPartition, false);
            if (!listBackups.isEmpty()) {
                this.markVersionInSync();
                PartitionVersionSyncRequest msg = (PartitionVersionSyncRequest)service.instantiateMessage("PartitionVersionSyncRequest");
                msg.setPartition(nPartition);
                msg.setPartitionVersion(this.getVersionCounter().get());
                msg.setMemberList(listBackups);
                service.post(msg);
            }
        }

        public void enableTransfer() {
            Gate gate = this.getGate();
            if (gate.isEnteredByCurrentThread()) {
                gate.exit();
                this.setPartitionState(this.getPartitionState() & 0xFFFFFFBF);
            } else if (this.getLockType() != 0) {
                PartitionControl._trace("Unexpected enableTransfer() call for " + String.valueOf(this) + "\n" + PartitionControl.get_StackTrace(), 2);
            }
        }

        public void endEvent(int iPartition, int nLockType, boolean fRollBack) {
            if (!fRollBack) {
                this.getService().handlePartitionTrace(iPartition, PartitionControl.getPartitionEventDescription(nLockType), Base.getSafeTimeMillis() - this.getEventStartTime());
            }
            this.setEventStartTime(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LongArray ensurePendingBackups() {
            CopyOnWriteLongArray laBackups = this.getPendingBackups();
            if (laBackups == null) {
                PartitionControl partitionControl = this;
                synchronized (partitionControl) {
                    laBackups = this.getPendingBackups();
                    if (laBackups == null) {
                        laBackups = new CopyOnWriteLongArray();
                        this.setPendingBackups(laBackups);
                    }
                }
            }
            return laBackups;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map ensurePendingBackupTotalSize() {
            ConcurrentHashMap map = (ConcurrentHashMap)this.getPendingBackupTotalSize();
            if (map == null) {
                PartitionControl partitionControl = this;
                synchronized (partitionControl) {
                    map = (ConcurrentHashMap)this.getPendingBackupTotalSize();
                    if (map == null) {
                        map = new ConcurrentHashMap();
                        this.setPendingBackupTotalSize(map);
                    }
                }
            }
            return map;
        }

        public boolean ensurePersistentExtent(long lExtentId) {
            return false;
        }

        public PersistentStore ensureOpenPersistentStore() {
            return this.ensureOpenPersistentStore(null, false);
        }

        public PersistentStore ensureOpenPersistentStore(PersistentStore storeFrom, boolean fSeal) {
            return this.ensureOpenPersistentStore(storeFrom, fSeal, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PersistentStore ensureOpenPersistentStore(PersistentStore storeFrom, boolean fSeal, boolean fBackupStore) {
            PersistentStore store;
            PersistentStore persistentStore = store = fBackupStore ? this.getPersistentBackupStore() : this.getPersistentStore();
            if (store == null || !store.isOpen() || storeFrom != null) {
                PartitionControl partitionControl = this;
                synchronized (partitionControl) {
                    store = fBackupStore ? this.getPersistentBackupStore() : this.getPersistentStore();
                    PartitionedService service = this.getService();
                    String sGUID = null;
                    if (store == null || storeFrom != null) {
                        int nPartition = this.getPartitionId();
                        Member member = service.getThisMember();
                        long ldtJoin = service.getServiceMemberSet().getServiceJoinTime(member.getId());
                        sGUID = GUIDHelper.generateGUID(nPartition, service.getOwnershipVersion(nPartition), ldtJoin, member);
                    } else if (!store.isOpen()) {
                        sGUID = store.getId();
                    }
                    if (sGUID != null) {
                        PersistentStore persistentStore2 = store = fBackupStore ? service.getPersistenceControl().openBackupStore(sGUID, storeFrom) : service.getPersistenceControl().openActiveStore(sGUID, storeFrom);
                        if (fSeal) {
                            CachePersistenceHelper.seal(store, service, null);
                        }
                        if (fBackupStore) {
                            this.setPersistentBackupStore(store);
                        } else {
                            this.setPersistentStore(store);
                        }
                    }
                }
            }
            return store;
        }

        public PersistentStore ensurePersistentStore() {
            return this.ensurePersistentStore(null);
        }

        public PersistentStore ensurePersistentStore(PersistentStore storeFrom) {
            return this.ensurePersistentStore(storeFrom, true);
        }

        public PersistentStore ensurePersistentStore(PersistentStore storeFrom, boolean fEventsStore) {
            return this.ensurePersistentStore(storeFrom, fEventsStore, false);
        }

        public PersistentStore ensurePersistentStore(PersistentStore storeFrom, boolean fEventsStore, boolean fBackupStore) {
            PartitionedService service = this.getService();
            PersistenceControl ctrlPersistence = service.getPersistenceControl();
            PersistentStore store = fBackupStore ? this.getPersistentBackupStore() : this.getPersistentStore();
            String sGUID = null;
            if (store == null || storeFrom != null) {
                int nPartition = this.getPartitionId();
                Member member = service.getThisMember();
                long ldtJoin = service.getServiceMemberSet().getServiceJoinTime(member.getId());
                sGUID = GUIDHelper.generateGUID(nPartition, service.getOwnershipVersion(nPartition) + (fBackupStore ? 1 : 0), ldtJoin, member);
                if (!fBackupStore) {
                    store = ctrlPersistence.ensurePersistentStore(sGUID);
                    this.setPersistentStore(store);
                } else {
                    store = ctrlPersistence.ensureBackupPersistentStore(sGUID);
                    this.setPersistentBackupStore(store);
                }
            } else {
                sGUID = store.getId();
            }
            if (fEventsStore && (this.getPersistentEventsStore() == null || storeFrom != null)) {
                this.setPersistentEventsStore(ctrlPersistence.openEventsStore(sGUID, storeFrom == null ? null : storeFrom.getId()));
            }
            return store;
        }

        public boolean enter(long cWait) {
            ThreadLocal tlo = this.getTLOEnterCounter();
            MutableLong mlCounter = (MutableLong)tlo.get();
            if (mlCounter.get() > 0L || this.getGate().enter(cWait)) {
                mlCounter.incrementAndGet();
                return true;
            }
            return false;
        }

        public void exit() {
            ThreadLocal tlo = this.getTLOEnterCounter();
            MutableLong mlCounter = (MutableLong)tlo.get();
            if (mlCounter.decrementAndGet() == 0L) {
                this.getGate().exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finishBackup(long lVersion) {
            if (lVersion > this.getVersionBackup()) {
                this.setVersionBackup(lVersion);
            }
            if (this.getBackupPolls().decrementAndGet() == 0 && this.isLocked()) {
                PartitionControl partitionControl = this;
                synchronized (partitionControl) {
                    List listActions = this.getBackupsCompletedActions();
                    if (listActions != null) {
                        this.setBackupsCompletedActions(null);
                        for (Continuation cont : listActions) {
                            cont.proceed(null);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finishPersist() {
            AtomicInteger atomicTasks = this.getPersistenceTasks();
            int cTask = atomicTasks.decrementAndGet();
            if (cTask == 0) {
                AtomicInteger atomicInteger = atomicTasks;
                synchronized (atomicInteger) {
                    atomicTasks.notifyAll();
                }
            }
        }

        public void flushDeferredBackups() {
            Message msgExpected = this.getDeferredBackup();
            if (msgExpected != null) {
                this.setDeferredBackup(null);
                msgExpected.onReceived();
            } else {
                List listDeferred = this.getDeferredBackups();
                if (!listDeferred.isEmpty()) {
                    Guardian.GuardContext ctx;
                    Message msgDeferred = (Message)listDeferred.remove(0);
                    if (msgDeferred != null) {
                        msgDeferred.onReceived();
                    }
                    if ((ctx = this.getContext()) != null) {
                        if (listDeferred.isEmpty()) {
                            ctx.release();
                        } else {
                            ctx.heartbeat();
                        }
                    }
                }
            }
        }

        public AtomicInteger getBackupPolls() {
            return this.__m_BackupPolls;
        }

        public List getBackupsCompletedActions() {
            return this.__m_BackupsCompletedActions;
        }

        @Override
        public Guardian.GuardContext getContext() {
            return this.__m_Context;
        }

        public Message getDeferredBackup() {
            return this.__m_DeferredBackup;
        }

        public List getDeferredBackups() {
            return this.__m_DeferredBackups;
        }

        public long getEventStartTime() {
            return this.__m_EventStartTime;
        }

        public Gate getGate() {
            return (Gate)this.get_Feed();
        }

        public int getLockAttempt() {
            return this.__m_LockAttempt;
        }

        public int getLockId() {
            return this.__m_LockId;
        }

        public int getLockType() {
            return (this.getPartitionState() & 0xF) >> 0 & 0xFFFFFFF7;
        }

        public static String getPartitionEventDescription(int nLockType) {
            switch (nLockType) {
                case 1: {
                    return "BACKUP_TRANSFER_OUT";
                }
                case 2: {
                    return "PRIMARY_TRANSFER_IN";
                }
                case 3: {
                    return "PRIMARY_TRANSFER_OUT";
                }
                case 4: {
                    return "PERSISTENCE";
                }
                case 10: {
                    return "ASSIGN";
                }
                case 11: {
                    return "INDEX_BUILD";
                }
                case 12: {
                    return "RESTORE";
                }
            }
            return null;
        }

        public int getPartitionId() {
            return this.__m_PartitionId;
        }

        public int getPartitionState() {
            return this.__m_PartitionState;
        }

        public LongArray getPendingBackups() {
            return this.__m_PendingBackups;
        }

        public Map getPendingBackupTotalSize() {
            return this.__m_PendingBackupTotalSize;
        }

        public AtomicInteger getPersistenceTasks() {
            return this.__m_PersistenceTasks;
        }

        public CopyOnWriteLongList getPersistentBackupExtents() {
            return this.__m_PersistentBackupExtents;
        }

        public PersistentStore getPersistentBackupStore() {
            return this.__m_PersistentBackupStore;
        }

        public PersistentStore getPersistentEventsStore() {
            return this.__m_PersistentEventsStore;
        }

        public CopyOnWriteLongList getPersistentExtents() {
            return this.__m_PersistentExtents;
        }

        public PersistentStore getPersistentStore() {
            return this.__m_PersistentStore;
        }

        public PartitionedService getService() {
            return (PartitionedService)this.get_Module();
        }

        public PartitionStatistics getStatistics() {
            return this.__m_Statistics;
        }

        public ThreadLocal getTLOEnterCounter() {
            return this.__m_TLOEnterCounter;
        }

        public int getTransferState() {
            return (this.getPartitionState() & 0x30) >> 4;
        }

        public Queue getUnlockActions() {
            return (Queue)this.get_Sink();
        }

        public long getVersionBackup() {
            return this.__m_VersionBackup;
        }

        public AtomicLong getVersionCounter() {
            return this.__m_VersionCounter;
        }

        public LongSupplier getVersionIncrementer() {
            return this.__m_VersionIncrementer;
        }

        public boolean hasScheduledBackups() {
            LongArray laPending = this.getPendingBackups();
            return laPending != null && !laPending.isEmpty();
        }

        public boolean initiateBackup() {
            PartitionedService service = (PartitionedService)this.get_Module();
            return this.getBackupPolls().incrementAndGet() >= 100 || !service.isAsyncBackup();
        }

        public boolean initiatePersist() {
            PartitionedService service = (PartitionedService)this.get_Module();
            PersistenceControl ctlPersistence = service.getPersistenceControl();
            return this.getPersistenceTasks().incrementAndGet() >= 100 || !ctlPersistence.isAsync();
        }

        public boolean isLocked() {
            int nState = (this.getPartitionState() & 0xF) >> 0;
            return nState != 0 && (nState & 8) == 0;
        }

        public boolean isRecovered() {
            return this.__m_Recovered;
        }

        public boolean isRecovering() {
            return (this.getLockType() & 4) != 0 && !this.isRecovered();
        }

        public boolean isTransferDisallowed() {
            return (this.getPartitionState() & 0xC0) != 0;
        }

        public boolean isTransferringOut() {
            return this.isLocked() && this.getLockType() == 3;
        }

        public boolean lock(long cWait, int nLockType) {
            boolean fLocked = false;
            long ldtStart = Base.getSafeTimeMillis();
            long cWaitRemaining = cWait;
            while (!this.lockInternal(Math.min(100L, cWait == -1L ? Long.MAX_VALUE : cWaitRemaining), nLockType)) {
                if (cWait >= 0L && (cWaitRemaining -= Base.getSafeTimeMillis() - ldtStart) <= 0L) {
                    return false;
                }
                Base.sleep(1L);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized boolean lockInternal(long cWait, int nLockType) {
            Gate gate = this.getGate();
            if (gate.isEnteredByCurrentThread() || gate.isClosedByCurrentThread() && nLockType != this.getLockType()) {
                return false;
            }
            int nLockTypeOld = this.getLockType();
            boolean fLocked = false;
            this.setLockType(nLockType | 8);
            try {
                fLocked = this.getGate().close(cWait);
                this.setLockType(fLocked ? nLockType : nLockTypeOld);
            }
            catch (Throwable throwable) {
                this.setLockType(fLocked ? nLockType : nLockTypeOld);
                throw throwable;
            }
            if (fLocked) {
                this.beginEvent();
            }
            return fLocked;
        }

        public boolean lockWithAdaptiveTime(long cWait, int nLockType, int nMemberId) {
            boolean fHeartbeat;
            int nLockId;
            PartitionedService service = this.getService();
            int nLockIdCur = this.getLockId();
            int cAttempt = nLockIdCur == (nLockId = nMemberId << 16 | nLockType) ? this.getLockAttempt() : 0;
            long cWaitAdapt = cWait > 0L && cAttempt > 0 ? Math.max((long)((double)service.getMaxContendMillis() * Math.min(Math.log(this.getLockAttempt()) / Math.log(service.getMaxLockAttempt()), 1.0)), cWait) : cWait;
            boolean bl = fHeartbeat = cWaitAdapt > 500L && cWaitAdapt > GuardSupport.getThreadContext().getSoftTimeoutMillis() >> 2;
            if (fHeartbeat) {
                service.heartbeat(cWaitAdapt << 1);
            }
            boolean fLock = this.lock(cWaitAdapt, nLockType);
            if (fHeartbeat) {
                service.heartbeat();
            }
            if (service.isAdaptivePartitionLock() && !fLock && cWait > 0L) {
                cAttempt = nLockIdCur == nLockId ? this.getLockAttempt() + 1 : 1;
                this.setLockAttempt(cAttempt);
                this.setLockId(nLockId);
            }
            return fLock;
        }

        protected void markVersionInSync() {
            this.setPartitionState(this.getPartitionState() | 0x80);
        }

        @Override
        public void onInit() {
            this.set_Feed(new ThreadGateLite());
            this.setBackupPolls(new AtomicInteger());
            this.setPersistenceTasks(new AtomicInteger());
            AtomicLong counterVersion = new AtomicLong();
            this.setVersionCounter(counterVersion);
            this.setVersionIncrementer(AtomicsHelper.newIncrementor(counterVersion));
        }

        public void onProcessedActions() {
        }

        public void preparePersistentExtent(long lExtentId, LongArray laCaches, boolean fBackup) {
        }

        public void preparePersistentExtents() {
        }

        public void preparePersistentExtents(LongArray laExtentsExclude) {
        }

        public void preventTransfer() {
            Gate gate = this.getGate();
            if (!gate.isEnteredByCurrentThread()) {
                this.setPartitionState(this.getPartitionState() | 0x40);
                gate.enter(0L);
            }
        }

        @Override
        public void recover() {
            long lVersionMissing = this.getVersionCounter().get() + 1L;
            Guardian.GuardContext ctx = this.getContext();
            if (ctx != null && ctx.getState() != 1) {
                PartitionedService service = this.getService();
                GuardContinuation continuation = (GuardContinuation)this._newChild("GuardContinuation");
                continuation.setMissingVersion(lVersionMissing);
                service.sendPingRequest(service.getPrimaryOwner(this.getPartitionId()), continuation);
                ctx.heartbeat();
            }
        }

        public void reset() {
            this.setLockAttempt(0);
            this.setLockId(0);
        }

        protected void setBackupPolls(AtomicInteger integerPolls) {
            this.__m_BackupPolls = integerPolls;
        }

        public void setBackupsCompletedActions(List listActions) {
            this.__m_BackupsCompletedActions = listActions;
        }

        @Override
        public void setContext(Guardian.GuardContext ctx) {
            this.__m_Context = ctx;
        }

        public void setDeferredBackup(Message msgBackup) {
            this.__m_DeferredBackup = msgBackup;
        }

        protected void setDeferredBackups(List listBackups) {
            this.__m_DeferredBackups = listBackups;
        }

        public void setEventStartTime(long ldtTime) {
            this.__m_EventStartTime = ldtTime;
        }

        public void setLockAttempt(int nAttempt) {
            this.__m_LockAttempt = nAttempt;
        }

        public void setLockId(int nId) {
            this.__m_LockId = nId;
        }

        protected void setLockType(int nLockType) {
            this.setPartitionState(this.getPartitionState() & 0xFFFFFFF0 | nLockType << 0);
        }

        public void setPartitionId(int nId) {
            this.__m_PartitionId = nId;
        }

        protected void setPartitionState(int nLockType) {
            this.__m_PartitionState = nLockType;
        }

        public synchronized void setPendingBackups(LongArray arrayBackups) {
            this.__m_PendingBackups = arrayBackups;
        }

        public void setPendingBackupTotalSize(Map mapSize) {
            this.__m_PendingBackupTotalSize = mapSize;
        }

        protected void setPersistenceTasks(AtomicInteger integerTasks) {
            this.__m_PersistenceTasks = integerTasks;
        }

        public void setPersistentBackupExtents(CopyOnWriteLongList listExtents) {
            this.__m_PersistentBackupExtents = listExtents;
        }

        protected void setPersistentBackupStore(PersistentStore store) {
            this.__m_PersistentBackupStore = store;
        }

        protected void setPersistentEventsStore(PersistentStore store) {
            this.__m_PersistentEventsStore = store;
        }

        public void setPersistentExtents(CopyOnWriteLongList listExtents) {
            this.__m_PersistentExtents = listExtents;
        }

        protected void setPersistentStore(PersistentStore store) {
            this.__m_PersistentStore = store;
        }

        public void setRecovered(boolean fRecovered) {
            this.__m_Recovered = fRecovered;
        }

        public void setStatistics(PartitionStatistics statistics) {
            this.__m_Statistics = statistics;
        }

        public void setTLOEnterCounter(ThreadLocal localCount) {
            this.__m_TLOEnterCounter = localCount;
        }

        public synchronized void setTransferState(int nState) {
            this.setPartitionState(this.getPartitionState() & 0xFFFFFFCF | nState << 4);
        }

        public void setVersionBackup(long lVersion) {
            this.__m_VersionBackup = lVersion;
        }

        protected void setVersionCounter(AtomicLong atomic) {
            this.__m_VersionCounter = atomic;
        }

        protected void setVersionIncrementer(LongSupplier atomic) {
            this.__m_VersionIncrementer = atomic;
        }

        @Override
        public void terminate() {
        }

        @Override
        public String toString() {
            long lVersion = this.getVersionCounter().get();
            int nLockType = this.getLockType();
            String sLockType = "";
            switch (nLockType) {
                case 1: {
                    sLockType = "[Backup Transfer Snapshot]";
                    break;
                }
                case 0: {
                    sLockType = "NONE";
                    break;
                }
                case 4: {
                    sLockType = "[Persistence Operation]";
                    break;
                }
                case 2: {
                    sLockType = "[Incoming Partition Transfer]";
                    break;
                }
                case 3: {
                    sLockType = "[Outgoing Partition Transfer]";
                    break;
                }
                default: {
                    sLockType = "[unknown]";
                }
            }
            int nXferState = this.getTransferState();
            String sXferState = "";
            switch (nXferState) {
                case 0: {
                    sXferState = "NONE";
                    break;
                }
                case 1: {
                    sXferState = "[Transfer Started]";
                    break;
                }
                case 2: {
                    sXferState = "[Transfer Sent]";
                    break;
                }
                default: {
                    sXferState = "[unknown]";
                }
            }
            String sXferPrevented = this.isTransferDisallowed() ? ", TransferDisallowed" : "";
            return "PartitionControl{Partition=" + this.getPartitionId() + ", Version=" + lVersion + ", Lock=" + sLockType + ", TransferState=" + sXferState + sXferPrevented + "}";
        }

        public void truncatePersistentExtent(long lExtentId) {
        }

        public void unlock() {
            this.unlock(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock(boolean fRollBack) {
            Queue queueActions = this.getUnlockActions();
            boolean fActioned = false;
            while (true) {
                Continuation cont = null;
                while (queueActions != null && (cont = (Continuation)queueActions.poll()) != null) {
                    try {
                        cont.proceed(null);
                        fActioned = true;
                    }
                    catch (Throwable t) {
                        PartitionControl._trace("Caught " + String.valueOf(t) + " while running deferred event:\n" + Base.getStackTrace(t), 1);
                    }
                }
                PartitionControl partitionControl = this;
                synchronized (partitionControl) {
                    if (queueActions == null) {
                        queueActions = this.getUnlockActions();
                    }
                    if (queueActions == null || queueActions.isEmpty()) {
                        int nLockType = this.getService().isRestoreInProgress() ? 12 : this.getLockType();
                        this.endEvent(this.getPartitionId(), nLockType, fRollBack);
                        if (fActioned) {
                            fActioned &= this.enter(0L);
                        }
                        this.setLockType(0);
                        this.getGate().open();
                        break;
                    }
                }
            }
            if (fActioned) {
                this.onProcessedActions();
                this.exit();
            }
        }

        public void unmarkVersionInSync() {
            this.setPartitionState(this.getPartitionState() & 0xFFFFFF7F);
        }

        public PartitionStatistics updateDirectStorageSize() {
            return null;
        }

        public void updatePersistentStoreVersion() {
            PersistentStore store = this.getPersistentStore();
            if (store != null) {
                PartitionedService service = this.getService();
                String sStoreId = store.getId();
                PersistentStore storeNew = store.isOpen() ? this.ensureOpenPersistentStore(store, false) : this.ensurePersistentStore(store);
                service.saveQuorum(-1, storeNew);
                PersistentStore storeEvents = this.getPersistentEventsStore();
                if (storeEvents != null) {
                    CachePersistenceHelper.seal(storeEvents, service, null);
                }
                CachePersistenceHelper.seal(storeNew, service, null);
                service.getPersistenceManager().delete(sStoreId, false);
            }
        }

        static {
            PartitionControl.__initStatic();
        }

        public static class GuardContinuation
        extends Component
        implements Continuation {
            private long __m_MissingVersion;

            public GuardContinuation() {
                this(null, null, true);
            }

            public GuardContinuation(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new GuardContinuation();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionControl$GuardContinuation".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public long getMissingVersion() {
                return this.__m_MissingVersion;
            }

            public PartitionControl getPartitionControl() {
                return (PartitionControl)this.get_Parent();
            }

            public PartitionedService getService() {
                return (PartitionedService)this.get_Module();
            }

            public void proceed(Object FResponded) {
                PartitionControl ctrlPartition = this.getPartitionControl();
                boolean fResponded = (Boolean)FResponded;
                if (fResponded) {
                    long lVersionMissing;
                    long lVersionLast = ctrlPartition.getVersionCounter().get();
                    if (lVersionLast < (lVersionMissing = this.getMissingVersion())) {
                        int nPartition = ctrlPartition.getPartitionId();
                        PartitionedService service = this.getService();
                        GuardContinuation._trace("The update for version " + lVersionMissing + " of partition " + nPartition + " has been delayed for over " + service.getDeferredBackupTimeoutMillis() / 1000L + " seconds; discarding the backup ownership.", 2);
                        service.discardBackupOwnership(nPartition);
                        Iterator iter = ctrlPartition.getDeferredBackups().iterator();
                        while (iter.hasNext()) {
                            BackupRequest msgBackup = (BackupRequest)iter.next();
                            if (msgBackup != null) {
                                msgBackup.forwardOrReply(msgBackup);
                            }
                            iter.remove();
                        }
                    }
                } else {
                    Guardian.GuardContext ctx = ctrlPartition.getContext();
                    if (ctx != null) {
                        ctx.release();
                    }
                }
            }

            public void setMissingVersion(long lVersion) {
                this.__m_MissingVersion = lVersion;
            }
        }
    }

    public static class PartitionFilter
    extends Util
    implements Filter {
        private PartitionSet __m_PartitionSet;

        public PartitionFilter() {
            this(null, null, true);
        }

        public PartitionFilter(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PartitionFilter();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionFilter".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public void addPartition(int iPartition) {
        }

        public boolean evaluate(Object oTest) {
            Binary binKey = null;
            if (oTest instanceof ReadBuffer) {
                binKey = ((ReadBuffer)oTest).toBinary();
            } else if (oTest instanceof Map.Entry) {
                binKey = (Binary)((Map.Entry)oTest).getKey();
            } else {
                return false;
            }
            return this.getPartitionSet().contains(((PartitionedService)this.get_Module()).getKeyPartition(binKey));
        }

        public PartitionSet getPartitionSet() {
            return this.__m_PartitionSet;
        }

        public void setPartitionSet(PartitionSet setPartition) {
            this.__m_PartitionSet = setPartition;
        }
    }

    public static class PartitionRecoverCleanup
    extends Message
    implements Runnable {
        private PartitionSet __m_Partitions;
        private boolean __m_Primary;

        public PartitionRecoverCleanup() {
            this(null, null, true);
        }

        public PartitionRecoverCleanup(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(45);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PartitionRecoverCleanup();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionRecoverCleanup".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public PartitionSet getPartitions() {
            return this.__m_Partitions;
        }

        public boolean isPrimary() {
            return this.__m_Primary;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            this.getService().getDaemonPool().add(this);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            PartitionSet parts = new PartitionSet();
            parts.readExternal(input);
            this.setPartitions(parts);
            if (this.getService().isVersionCompatible(this.getFromMember(), 22, 6, 10)) {
                this.setPrimary(input.readBoolean());
            }
        }

        @Override
        public void run() {
            ((PartitionedService)this.getService()).onPartitionRecoverCleanup(this);
        }

        public void setPartitions(PartitionSet parts) {
            this.__m_Partitions = parts;
        }

        public void setPrimary(boolean fPrimary) {
            this.__m_Primary = fPrimary;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            this.getPartitions().writeExternal(output);
            output.writeBoolean(this.isPrimary());
        }
    }

    public static class PartitionRecoverRequest
    extends RequestMessage {
        private PartitionSet __m_EventsPartsFailed;
        private String[] __m_GUIDs;
        private String[] __m_InvalidPersistentIds;
        private transient Map __m_MapAssigned;
        private PartitionSet __m_PartsAssign;
        private transient PartitionSet __m_PartsAssigned;
        private transient PartitionSet __m_PartsLost;
        private PartitionSet __m_PartsRecover;
        private PartitionSet __m_PartsRecovered;
        private AtomicInteger __m_RecoverJobs;
        private String __m_SnapshotToRecover;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
            __mapChildren.put("RecoverJob", RecoverJob.get_CLASS());
        }

        public PartitionRecoverRequest() {
            this(null, null, true);
        }

        public PartitionRecoverRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(43);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PartitionRecoverRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionRecoverRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public PartitionSet getEventsPartsFailed() {
            return this.__m_EventsPartsFailed;
        }

        public String[] getGUIDs() {
            return this.__m_GUIDs;
        }

        public String[] getInvalidPersistentIds() {
            return this.__m_InvalidPersistentIds;
        }

        public Map getMapAssigned() {
            return this.__m_MapAssigned;
        }

        public PartitionSet getPartsAssign() {
            return this.__m_PartsAssign;
        }

        public PartitionSet getPartsAssigned() {
            return this.__m_PartsAssigned;
        }

        public PartitionSet getPartsLost() {
            return this.__m_PartsLost;
        }

        public PartitionSet getPartsRecover() {
            return this.__m_PartsRecover;
        }

        public PartitionSet getPartsRecovered() {
            return this.__m_PartsRecovered;
        }

        public PersistenceManager getPersistenceManager() {
            String sSnapshot = this.getSnapshotToRecover();
            PersistenceControl ctrlPersistence = ((PartitionedService)this.getService()).getPersistenceControl();
            return sSnapshot == null ? ctrlPersistence.getActiveManager() : ctrlPersistence.openSnapshot(sSnapshot);
        }

        public AtomicInteger getRecoverJobs() {
            return this.__m_RecoverJobs;
        }

        public String getSnapshotToRecover() {
            return this.__m_SnapshotToRecover;
        }

        @Override
        protected com.tangosol.coherence.component.net.Poll instantiatePoll() {
            return (com.tangosol.coherence.component.net.Poll)this._newChild("Poll");
        }

        @Override
        public void onReceived() {
            this.scheduleRecoveryJobs();
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            int cGUID = input.readInt();
            String[] asGUID = new String[cGUID];
            for (int i = 0; i < cGUID; ++i) {
                asGUID[i] = input.readUTF();
            }
            this.setGUIDs(asGUID);
            PartitionSet partsAssign = new PartitionSet();
            partsAssign.readExternal(input);
            this.setPartsAssign(partsAssign);
            if (input.readBoolean()) {
                this.setSnapshotToRecover(input.readUTF());
            }
            if (this.getService().isVersionCompatible(OwnershipResponse::isLazyOpenCompatible)) {
                int cSize = input.readInt();
                String[] asGUIDToClean = new String[cSize];
                for (int i = 0; i < cSize; ++i) {
                    asGUIDToClean[i] = input.readUTF();
                }
                this.setInvalidPersistentIds(asGUIDToClean);
            }
        }

        public void scheduleRecoveryJobs() {
            PartitionedService service = (PartitionedService)this.getService();
            String[] asGUIDs = this.getGUIDs();
            int cGUIDs = asGUIDs.length;
            int cFair = Config.getInteger("coherence.distributed.persistence.recover.threads", Platform.getPlatform().getFairShareProcessors() + 2);
            int cBatch = cGUIDs / cFair + 1;
            SparseArray<RecoverJob> laJob = new SparseArray<RecoverJob>();
            Map mapUpdate = service.lockForRecovery(this);
            PartitionRecoverInfo info = new PartitionRecoverInfo(this, mapUpdate, new ArrayList(), this.getPersistenceManager(), service.instantiatePartitionSet(false), service.instantiatePartitionSet(false), service.instantiatePartitionSet(false));
            for (int i = 0; i < cGUIDs; ++i) {
                String sGUID = asGUIDs[i];
                int nPartition = GUIDHelper.getPartition(sGUID);
                if (!mapUpdate.containsKey(nPartition)) continue;
                int nBatch = i / cBatch;
                RecoverJob job = (RecoverJob)laJob.get(nBatch);
                if (job == null) {
                    job = new RecoverJob();
                    job.setListGUID(new ArrayList());
                    job.setService(service);
                    job.setRecoverInfo(info);
                    laJob.set(nBatch, job);
                }
                job.getListGUID().add(sGUID);
            }
            if (laJob.isEmpty()) {
                RecoverJob job = new RecoverJob();
                job.setListGUID(Collections.emptyList());
                job.setService(service);
                job.setRecoverInfo(info);
                laJob.set(0L, job);
            }
            this.setRecoverJobs(new AtomicInteger(laJob.getSize()));
            com.tangosol.coherence.component.util.DaemonPool pool = service.getDaemonPool();
            for (RecoverJob job : laJob) {
                pool.add(job);
            }
        }

        public void setEventsPartsFailed(PartitionSet setRecovered) {
            this.__m_EventsPartsFailed = setRecovered;
        }

        public void setGUIDs(String[] asGUID) {
            this.__m_GUIDs = asGUID;
        }

        public void setInvalidPersistentIds(String[] asGUIDs) {
            this.__m_InvalidPersistentIds = asGUIDs;
        }

        public void setMapAssigned(Map mapAssigned) {
            this.__m_MapAssigned = mapAssigned;
        }

        public void setPartsAssign(PartitionSet setRecovered) {
            this.__m_PartsAssign = setRecovered;
        }

        public void setPartsAssigned(PartitionSet setAssigned) {
            this.__m_PartsAssigned = setAssigned;
        }

        public void setPartsLost(PartitionSet setAssigned) {
            this.__m_PartsLost = setAssigned;
        }

        public void setPartsRecover(PartitionSet setRecovered) {
            this.__m_PartsRecover = setRecovered;
        }

        public void setPartsRecovered(PartitionSet setRecovered) {
            this.__m_PartsRecovered = setRecovered;
        }

        public void setRecoverJobs(AtomicInteger atomicJobs) {
            this.__m_RecoverJobs = atomicJobs;
        }

        public void setSnapshotToRecover(String sSnapshot) {
            this.__m_SnapshotToRecover = sSnapshot;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            String[] asGUID = this.getGUIDs();
            int cGUID = asGUID.length;
            output.writeInt(cGUID);
            for (int i = 0; i < cGUID; ++i) {
                output.writeUTF(asGUID[i]);
            }
            this.getPartsAssign().writeExternal(output);
            String sSnapshot = this.getSnapshotToRecover();
            if (sSnapshot == null) {
                output.writeBoolean(false);
            } else {
                output.writeBoolean(true);
                output.writeUTF(sSnapshot);
            }
            if (this.getService().isVersionCompatible(OwnershipResponse::isLazyOpenCompatible)) {
                String[] asInvalidGUIDs = this.getInvalidPersistentIds();
                int cSize = asInvalidGUIDs == null ? 0 : asInvalidGUIDs.length;
                output.writeInt(cSize);
                for (int i = 0; i < cSize; ++i) {
                    output.writeUTF(asInvalidGUIDs[i]);
                }
            }
        }

        static {
            PartitionRecoverRequest.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionRecoverRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected void onCompletion() {
                PartitionedService service = (PartitionedService)this.get_Module();
                if (service.getPersistenceControl().getActiveRecoveryRequests().decrementAndGet() == 0) {
                    if (!service.isSuspended()) {
                        service.getDistributionStrategy().scheduleImmediate();
                    }
                    service.setOwnershipInProgress(0);
                    PartitionRecoverRequest msgRequest = (PartitionRecoverRequest)this.get_Parent();
                    String sSnapshot = msgRequest.getSnapshotToRecover();
                    if (sSnapshot != null || service.isActivePersistence()) {
                        if (sSnapshot == null) {
                            PartitionRecoverCleanup msg = (PartitionRecoverCleanup)service.instantiateMessage("PartitionRecoverCleanup");
                            msg.setPartitions(msgRequest.getPartsRecovered());
                            msg.setToMemberSet(service.getOwnershipMemberSet());
                            service.post(msg);
                        }
                        service.getPersistenceControl().getSnapshotController().onRecoveryCompleted(sSnapshot, service.collectOrphanPartitions(), msgRequest.getEventsPartsFailed());
                    }
                }
                super.onCompletion();
            }

            @Override
            public void onResponse(Message msg) {
                Grid.Response msgResponse = (Grid.Response)msg;
                PartitionRecoverRequest msgRequest = (PartitionRecoverRequest)this.get_Parent();
                PartitionSet partsRecovered = null;
                PartitionSet partsFailedEvents = null;
                Object oResponseValue = msgResponse.getValue();
                if (this.getService().isVersionCompatible(msgResponse.getFromMember(), 21, 6, 0) || oResponseValue.getClass().isArray()) {
                    Object[] aoResult = (Object[])oResponseValue;
                    partsRecovered = (PartitionSet)aoResult[0];
                    partsFailedEvents = (PartitionSet)aoResult[1];
                } else {
                    partsRecovered = (PartitionSet)oResponseValue;
                }
                msgRequest.getPartsRecovered().add(partsRecovered);
                if (partsFailedEvents != null) {
                    msgRequest.getEventsPartsFailed().add(partsFailedEvents);
                }
                super.onResponse(msg);
            }
        }

        public static class RecoverJob
        extends Util
        implements PriorityTask,
        Runnable {
            private List __m_ListGUID;
            private PartitionRecoverInfo __m_RecoverInfo;
            private Grid __m_Service;

            public RecoverJob() {
                this(null, null, true);
            }

            public RecoverJob(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new RecoverJob();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionRecoverRequest$RecoverJob".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public long getExecutionTimeoutMillis() {
                return 0L;
            }

            public List getListGUID() {
                return this.__m_ListGUID;
            }

            public PartitionRecoverInfo getRecoverInfo() {
                return this.__m_RecoverInfo;
            }

            @Override
            public long getRequestTimeoutMillis() {
                return 0L;
            }

            @Override
            public int getSchedulingPriority() {
                return 2;
            }

            public Grid getService() {
                return this.__m_Service;
            }

            @Override
            public void run() {
                PartitionedService service = (PartitionedService)this.getService();
                service.setRecoveryThread(true);
                try {
                    ((PartitionedService)this.getService()).onPartitionRecoverJob(this);
                }
                finally {
                    service.setRecoveryThread(false);
                }
            }

            @Override
            public void runCanceled(boolean Param_1) {
            }

            public void setListGUID(List listD) {
                this.__m_ListGUID = listD;
            }

            public void setRecoverInfo(PartitionRecoverInfo infoRecover) {
                this.__m_RecoverInfo = infoRecover;
            }

            public void setService(Grid gridService) {
                this.__m_Service = gridService;
            }
        }
    }

    public static class PartitionStatsUpdate
    extends Message {
        private List __m_StatsList;

        public PartitionStatsUpdate() {
            this(null, null, true);
        }

        public PartitionStatsUpdate(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(50);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PartitionStatsUpdate();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionStatsUpdate".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public List getStatsList() {
            return this.__m_StatsList;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            PartitionedService service = (PartitionedService)this.get_Module();
            service.getDistributionStrategy().onPartitionStatsUpdate(this);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            int cParts = ExternalizableHelper.readInt(input);
            ArrayList listStats = new ArrayList(cParts);
            for (int i = 0; i < cParts; ++i) {
                listStats.add(ExternalizableHelper.readObject(input));
            }
            this.setStatsList(listStats);
        }

        public void setStatsList(List listStats) {
            this.__m_StatsList = listStats;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            List listStats = this.getStatsList();
            ExternalizableHelper.writeInt(output, listStats.size());
            Iterator iter = listStats.iterator();
            while (iter.hasNext()) {
                ExternalizableHelper.writeObject(output, iter.next());
            }
        }
    }

    public static class PartitionSwapRequest
    extends ChainedRequest {
        private VersionedOwnership __m_Owners;
        private int __m_Partition;
        private int __m_PromoteIndex;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public PartitionSwapRequest() {
            this(null, null, true);
        }

        public PartitionSwapRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(39);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PartitionSwapRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionSwapRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            PartitionSwapRequest msg = (PartitionSwapRequest)super.cloneMessage();
            msg.setOwners(this.getOwners());
            msg.setPartition(this.getPartition());
            msg.setPromoteIndex(this.getPromoteIndex());
            return msg;
        }

        public VersionedOwnership getOwners() {
            return this.__m_Owners;
        }

        public int getPartition() {
            return this.__m_Partition;
        }

        public int getPromoteIndex() {
            return this.__m_PromoteIndex;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ((PartitionedService)this.get_Module()).onPartitionSwapRequest(this);
        }

        @Override
        public void onRequestCompleted() {
            PartitionedService service = (PartitionedService)this.getService();
            int iPartition = this.getPartition();
            int iStoreLow = this.getPromoteIndex();
            int iStoreHigh = iStoreLow + 1;
            int[] aiOwner = service.getPartitionAssignments()[iPartition];
            VersionedOwnership owners = new VersionedOwnership(service.getPartitionConfig(iPartition));
            owners.setOwner(iStoreLow, aiOwner[iStoreLow]);
            owners.setOwner(iStoreHigh, aiOwner[iStoreHigh]);
            service.putPartitionConfig(iPartition, owners);
            service.getPartitionControl(iPartition).enableTransfer();
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setPartition(input.readInt());
            this.setPromoteIndex(input.readInt());
            VersionedOwnership owners = new VersionedOwnership();
            owners.readExternal(input);
            this.setOwners(owners);
        }

        public void setOwners(VersionedOwnership ownershipOwners) {
            this.__m_Owners = ownershipOwners;
        }

        public void setPartition(int nPartition) {
            this.__m_Partition = nPartition;
        }

        public void setPromoteIndex(int nIndex) {
            this.__m_PromoteIndex = nIndex;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeInt(this.getPartition());
            output.writeInt(this.getPromoteIndex());
            this.getOwners().writeExternal(output);
        }

        static {
            PartitionSwapRequest.__initStatic();
        }

        public static class Poll
        extends ChainedRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            @Override
            public boolean isPreprocessable() {
                return false;
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionSwapRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class PartitionVersionSyncRequest
    extends ChainedRequest {
        private int __m_Partition;
        private long __m_PartitionVersion;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public PartitionVersionSyncRequest() {
            this(null, null, true);
        }

        public PartitionVersionSyncRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(41);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PartitionVersionSyncRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionVersionSyncRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            PartitionVersionSyncRequest msg = (PartitionVersionSyncRequest)super.cloneMessage();
            msg.setPartition(this.getPartition());
            msg.setPartitionVersion(this.getPartitionVersion());
            return msg;
        }

        public int getPartition() {
            return this.__m_Partition;
        }

        public long getPartitionVersion() {
            return this.__m_PartitionVersion;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            int nPartition = this.getPartition();
            PartitionedService service = (PartitionedService)this.getService();
            PartitionControl ctrlPart = service.getPartitionControl(nPartition);
            if (ctrlPart != null) {
                AtomicLong atomicVersion = ctrlPart.getVersionCounter();
                long lVersionCur = atomicVersion.get();
                long lVersionNew = this.getPartitionVersion();
                if (lVersionNew != lVersionCur) {
                    if (lVersionNew != lVersionCur + 1L) {
                        if (lVersionNew > lVersionCur) {
                            PartitionVersionSyncRequest._trace("Synchronizing the version counter for partition " + nPartition + " forward to version " + lVersionNew + " from " + lVersionCur, 3);
                        } else {
                            PartitionVersionSyncRequest._trace("Reverting the backup version for partition " + nPartition + " from version " + lVersionCur + " to version " + lVersionNew, 2);
                            return;
                        }
                    }
                    atomicVersion.set(lVersionNew);
                }
                ctrlPart.flushDeferredBackups();
            } else {
                PartitionVersionSyncRequest._trace("Ignoring PartitionVersionSyncRequest for un-owned partition " + nPartition + " originating from member " + this.getOriginatingMemberId(), 2);
            }
        }

        @Override
        public void onRequestCompleted() {
            ((PartitionedService)this.getService()).getPartitionControl(this.getPartition()).unmarkVersionInSync();
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setPartition(input.readInt());
            this.setPartitionVersion(input.readLong());
        }

        public void setPartition(int sProperty) {
            this.__m_Partition = sProperty;
        }

        public void setPartitionVersion(long lVersion) {
            this.__m_PartitionVersion = lVersion;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeInt(this.getPartition());
            output.writeLong(this.getPartitionVersion());
        }

        static {
            PartitionVersionSyncRequest.__initStatic();
        }

        public static class Poll
        extends ChainedRequest.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            @Override
            public boolean isPreprocessable() {
                return false;
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionVersionSyncRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class PersistenceControl
    extends Component {
        private Continuation __m_ActiveFailureHandler;
        private int __m_ActiveFailureMode;
        private PersistenceManager __m_ActiveManager;
        private transient AtomicInteger __m_ActiveRecoveryRequests;
        private boolean __m_Async;
        private PersistenceManager __m_BackupManager;
        private volatile boolean __m_Disabled;
        private PersistenceManager __m_EventsManager;
        private boolean __m_ForceRecovery;
        private PartitionVersionExclusionList __m_PartitionVersionExclusionList;
        private PersistenceEnvironment __m_PersistenceEnvironment;
        private volatile Binary __m_QuorumRaw;
        private boolean __m_ResumeOnFailover;
        private SnapshotArchiver __m_SnapshotArchiver;
        private SnapshotController __m_SnapshotController;
        private long __m_StatsLatencyCount;
        private long __m_StatsLatencyMax;
        private long __m_StatsLatencyTotal;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("SnapshotBuilder", SnapshotBuilder.get_CLASS());
            __mapChildren.put("SnapshotController", SnapshotController.get_CLASS());
        }

        public PersistenceControl() {
            this(null, null, true);
        }

        public PersistenceControl(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setActiveRecoveryRequests(new AtomicInteger());
                this.setPartitionVersionExclusionList(new PartitionVersionExclusionList());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PersistenceControl();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PersistenceControl".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public void add(Object o) {
        }

        public void archiveOperation(SnapshotArchiveRequest msgRequest, boolean fArchive) {
            String sDesc = fArchive ? "archive" : "retrieve";
            PartitionedService service = (PartitionedService)this.get_Module();
            Grid.Response msgResponse = (Grid.Response)service.instantiateMessage("Response");
            msgResponse.respondTo(msgRequest);
            msgResponse.setResult(0);
            if (!this.isValid()) {
                PersistenceControl._trace("Service is not configured for persistence", 2);
                msgResponse.setResult(2);
                service.send(msgResponse);
                return;
            }
            String sSnapshot = msgRequest.getSnapshotName();
            Map mapStores = msgRequest.getStores();
            Object[] aoStores = (Object[])mapStores.get(service.getThisMember().getId());
            if (aoStores == null || aoStores.length == 0) {
                throw new IllegalArgumentException("Did not receive any stores to archive");
            }
            String[] asStores = new String[aoStores.length];
            for (int i = 0; i < aoStores.length; ++i) {
                asStores[i] = aoStores[i].toString();
            }
            PersistenceControl._trace("Received request to " + sDesc + " " + asStores.length + " stores for snapshot \"" + sSnapshot + "\"", 3);
            try {
                SnapshotArchiver archiver = this.getSnapshotArchiver();
                if (archiver == null) {
                    throw new IllegalStateException("No archiver is defined for this service");
                }
                Snapshot snapshot = new Snapshot(sSnapshot, asStores);
                if (fArchive) {
                    archiver.archive(snapshot, this.getPersistenceEnvironment());
                } else {
                    archiver.retrieve(snapshot, this.getPersistenceEnvironment());
                }
            }
            catch (Exception e) {
                PersistenceControl._trace("Failed to " + sDesc + " persistent snapshot: " + PersistenceControl.getStackTrace(e), 2);
                msgResponse.setResult(2);
            }
            service.send(msgResponse);
        }

        public void createSnapshot(SnapshotRequest msgRequest) {
            PersistenceManager mgrSnapshot;
            PartitionedService service = (PartitionedService)this.get_Module();
            Grid.Response msgResponse = (Grid.Response)service.instantiateMessage("Response");
            msgResponse.respondTo(msgRequest);
            msgResponse.setResult(0);
            if (!this.isValid()) {
                PersistenceControl._trace("Service is not configured for persistent snapshot creation.", 2);
                msgResponse.setResult(2);
                service.send(msgResponse);
                return;
            }
            PartitionSet parts = service.collectOwnedPartitions(true);
            PartitionSet partsMask = msgRequest.getRequestMask();
            if (partsMask != null) {
                parts.retain(partsMask);
            }
            if (parts.isEmpty()) {
                service.send(msgResponse);
                return;
            }
            String sSnapshot = msgRequest.getSnapshotName();
            try {
                mgrSnapshot = this.getPersistenceEnvironment().createSnapshot(sSnapshot);
            }
            catch (PersistenceException e) {
                PersistenceControl._trace("Failed to create persistent snapshot: " + PersistenceControl.getStackTrace(e), 2);
                msgResponse.setResult(2);
                service.send(msgResponse);
                return;
            }
            PersistenceControl._trace("Creating snapshot \"" + sSnapshot + "\" of partitions " + String.valueOf(parts) + " using " + String.valueOf(mgrSnapshot), 3);
            SnapshotBuilder builder = (SnapshotBuilder)this._newChild("SnapshotBuilder");
            builder.setManager(mgrSnapshot);
            builder.setResponse(msgResponse);
            builder.setPartitions(parts);
            builder.build(0);
        }

        public PersistentStore ensurePersistentStore(String sGUID) {
            try {
                return new SafePersistenceWrappers.SafePersistentStore(this.getActiveManager().createStore(sGUID), this.getActiveFailureHandler());
            }
            catch (PersistenceException e) {
                this.onActivePersistenceFailure(e);
                return NullImplementation.getPersistentStore();
            }
        }

        public PersistentStore ensureBackupPersistentStore(String sGUID) {
            try {
                return new SafePersistenceWrappers.SafePersistentStore(this.getBackupManager().createStore(sGUID), this.getActiveFailureHandler());
            }
            catch (PersistenceException e) {
                this.onActivePersistenceFailure(e);
                return NullImplementation.getPersistentStore();
            }
        }

        public Continuation getActiveFailureHandler() {
            return this.__m_ActiveFailureHandler;
        }

        public int getActiveFailureMode() {
            return this.__m_ActiveFailureMode;
        }

        public PersistenceManager getActiveManager() {
            return this.__m_ActiveManager;
        }

        public AtomicInteger getActiveRecoveryRequests() {
            return this.__m_ActiveRecoveryRequests;
        }

        public PersistenceManager getBackupManager() {
            return this.__m_BackupManager;
        }

        public PersistenceManager getEventsManager() {
            return this.__m_EventsManager;
        }

        public String getMBeanName() {
            return null;
        }

        protected PartitionVersionExclusionList getPartitionVersionExclusionList() {
            return this.__m_PartitionVersionExclusionList;
        }

        public PersistenceEnvironment getPersistenceEnvironment() {
            return this.__m_PersistenceEnvironment;
        }

        public Binary getQuorumRaw() {
            return this.__m_QuorumRaw;
        }

        public SnapshotArchiver getSnapshotArchiver() {
            return this.__m_SnapshotArchiver;
        }

        public SnapshotController getSnapshotController() {
            return this.__m_SnapshotController;
        }

        public long getStatsLatencyCount() {
            return this.__m_StatsLatencyCount;
        }

        public long getStatsLatencyMax() {
            return this.__m_StatsLatencyMax;
        }

        public long getStatsLatencyTotal() {
            return this.__m_StatsLatencyTotal;
        }

        public boolean isAllowed(String sGUID) {
            return this.getPartitionVersionExclusionList().isAllowed(GUIDHelper.getPartition(sGUID), (int)GUIDHelper.getVersion(sGUID));
        }

        public boolean isAsync() {
            return this.__m_Async;
        }

        public boolean isDisabled() {
            return this.__m_Disabled;
        }

        public boolean isForceRecovery() {
            return this.__m_ForceRecovery;
        }

        public boolean isPersistEvents() {
            return this.getEventsManager() != null;
        }

        public boolean isResumeOnFailover() {
            return this.__m_ResumeOnFailover;
        }

        public boolean isValid() {
            return this.getPersistenceEnvironment() != null;
        }

        public void onActivePersistenceFailure(PersistenceException e) {
            if (!this.isDisabled()) {
                PartitionedService service = (PartitionedService)this.get_Module();
                PersistentStore<?> store = e.getPersistentStore();
                int nPartition = GUIDHelper.getPartition(store.getId());
                PartitionControl ctrl = service.getPartitionControl(nPartition);
                int nLockState = ctrl.getLockType();
                if (ctrl.isLocked() && nLockState == 4) {
                    throw e;
                }
                switch (this.getActiveFailureMode()) {
                    case 0: {
                        PersistenceControl._trace("Stopping service due to an unexpected persistence exception: " + PersistenceControl.getStackTrace(e), 1);
                        service.stop();
                        break;
                    }
                    case 1: {
                        PersistenceControl._trace("Disabling active persistence due to an unexpected persistence exception: " + PersistenceControl.getStackTrace(e), 1);
                        this.setActiveManager(NullImplementation.getPersistenceManager());
                        PartitionSet parts = service.collectOwnedPartitions(true);
                        int iPart = parts.next(0);
                        while (iPart >= 0) {
                            service.getPartitionControl(iPart).disablePersistentStore();
                            iPart = parts.next(iPart + 1);
                        }
                        break;
                    }
                }
                this.setDisabled(true);
            }
        }

        @Override
        public void onInit() {
            PartitionedService service = (PartitionedService)this.get_Module();
            Continuations contHelper = service.getContinuations();
            this.setActiveFailureHandler(contHelper.instantiatePersistenceErrorHandler(contHelper.instantiateActivePersistenceError()));
        }

        public void onMembershipChanged(int nMemberEvent) {
            SnapshotController ctrlSnapshot = this.getSnapshotController();
            if (ctrlSnapshot != null) {
                ctrlSnapshot.setSnapshotNames(null);
            }
        }

        public void onOwnershipSeniority() {
            if (this.isValid()) {
                this.setSnapshotController((SnapshotController)this._newChild("SnapshotController"));
            }
        }

        public synchronized void onPrimaryOwnershipChanged(int iPartition) {
            this.getPartitionVersionExclusionList().reset(iPartition);
        }

        public void onServiceResume() {
            this.setResumeOnFailover(false);
        }

        public void onServiceSuspend(boolean fAutoResume) {
            if (fAutoResume) {
                this.setResumeOnFailover(true);
            }
        }

        public synchronized void onTransientException(String sGUID) {
            this.getPartitionVersionExclusionList().exclude(GUIDHelper.getPartition(sGUID), (int)GUIDHelper.getVersion(sGUID));
        }

        public PersistenceManager openActiveManager() {
            PersistenceEnvironment env = this.getPersistenceEnvironment();
            PersistenceManager mgrActive = this.getActiveManager();
            if (env != null && mgrActive == null) {
                mgrActive = env.openActive();
                this.setActiveManager(mgrActive);
                this.setEventsManager(env.openEvents());
                this.setBackupManager(env.openBackup());
            }
            return mgrActive;
        }

        public PersistentStore openActiveStore(String sGUID, PersistentStore storeFrom) {
            try {
                return new SafePersistenceWrappers.SafePersistentStore(this.getActiveManager().open(sGUID, storeFrom), this.getActiveFailureHandler());
            }
            catch (PersistenceException e) {
                this.onActivePersistenceFailure(e);
                return NullImplementation.getPersistentStore();
            }
        }

        public PersistentStore openBackupStore(String sGUID, PersistentStore storeFrom) {
            try {
                return new SafePersistenceWrappers.SafePersistentStore(this.getBackupManager().open(sGUID, storeFrom), this.getActiveFailureHandler());
            }
            catch (PersistenceException e) {
                if (e.getPersistentStore() != null) {
                    this.onActivePersistenceFailure(e);
                }
                return NullImplementation.getPersistentStore();
            }
        }

        public PersistentStore openEventsStore(String sGUID, String sGUIDFrom) {
            if (this.isPersistEvents()) {
                try {
                    PersistenceManager mgrEvents = this.getEventsManager();
                    PersistentStore storeFrom = null;
                    if (sGUIDFrom != null) {
                        if (!mgrEvents.contains(sGUIDFrom)) {
                            return null;
                        }
                        storeFrom = this.openStoreForRead(mgrEvents, sGUIDFrom, false);
                    }
                    return new SafePersistenceWrappers.SafePersistentStore(this.getEventsManager().open(sGUID, storeFrom), this.getActiveFailureHandler());
                }
                catch (PersistenceException persistenceException) {
                    // empty catch block
                }
            }
            return null;
        }

        public PersistenceManager openSnapshot(String sSnapshot) {
            PersistenceManager mgr = null;
            try {
                mgr = this.getPersistenceEnvironment().openSnapshot(sSnapshot);
            }
            catch (PersistenceException e) {
                PersistenceControl._trace("Failed to recover from snapshot \"" + sSnapshot + "\": " + PersistenceControl.getStackTrace(e), 2);
            }
            return mgr;
        }

        public PersistentStore openStoreForRead(PersistenceManager mgr, String sGUID) {
            PartitionedService service = (PartitionedService)this.get_Module();
            if (mgr.isEmpty(sGUID)) {
                return mgr.createStore(sGUID);
            }
            int cRetry = 0;
            while (true) {
                try {
                    PersistentStore store = mgr.open(sGUID, null);
                    CachePersistenceHelper.validate(store, service);
                    return store;
                }
                catch (ConcurrentAccessException e) {
                    if (cRetry > 100) {
                        throw new FatalAccessException((Throwable)e);
                    }
                    PartitionedService.sleep(10L);
                    ++cRetry;
                    continue;
                }
                break;
            }
        }

        public PersistentStore openStoreForRead(PersistenceManager mgr, String sGUID, boolean fOpen) {
            PartitionedService service = (PartitionedService)this.get_Module();
            if (fOpen) {
                int cRetry = 0;
                while (true) {
                    try {
                        PersistentStore store = mgr.open(sGUID, null);
                        CachePersistenceHelper.validate(store, service);
                        return store;
                    }
                    catch (ConcurrentAccessException e) {
                        if (cRetry > 100) {
                            throw new FatalAccessException((Throwable)e);
                        }
                        PartitionedService.sleep(10L);
                        ++cRetry;
                        continue;
                    }
                    break;
                }
            }
            return mgr.createStore(sGUID);
        }

        public void recordLatencyStats(long cMillis) {
            this.setStatsLatencyTotal(this.getStatsLatencyTotal() + cMillis);
            this.setStatsLatencyCount(this.getStatsLatencyCount() + 1L);
            if (cMillis > this.getStatsLatencyMax()) {
                this.setStatsLatencyMax(cMillis);
            }
        }

        public void release() {
            PersistenceManager mgr;
            SnapshotController ctrlSnapshot = this.getSnapshotController();
            if (ctrlSnapshot != null) {
                ctrlSnapshot.release();
                this.setSnapshotController(null);
            }
            if ((mgr = this.getActiveManager()) != null) {
                mgr.release();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void removeSnapshot(SnapshotRequest msgRequest) {
            PartitionedService service = (PartitionedService)this.get_Module();
            Grid.Response msgResponse = (Grid.Response)service.instantiateMessage("Response");
            msgResponse.respondTo(msgRequest);
            msgResponse.setResult(0);
            if (!this.isValid()) {
                PersistenceControl._trace("Service is not configured for persistent snapshot removal.", 2);
                msgResponse.setResult(2);
                service.send(msgResponse);
                return;
            }
            String sSnapshot = msgRequest.getSnapshotName();
            try {
                if (this.getPersistenceEnvironment().removeSnapshot(sSnapshot)) {
                    // empty if block
                }
            }
            catch (PersistenceException e) {
                PersistenceControl._trace("Failed to remove persistent snapshot \"" + sSnapshot + "\" : " + PersistenceControl.getStackTrace(e), 2);
                msgResponse.setResult(2);
            }
            service.send(msgResponse);
        }

        public void resetStats() {
            this.setStatsLatencyMax(0L);
            this.setStatsLatencyCount(0L);
            this.setStatsLatencyTotal(0L);
        }

        public void retrieveSnapshot(SnapshotArchiveRequest msgRequest) {
        }

        protected void setActiveFailureHandler(Continuation cont) {
            this.__m_ActiveFailureHandler = cont;
        }

        public void setActiveFailureMode(int nMode) {
            this.__m_ActiveFailureMode = nMode;
        }

        protected void setActiveManager(PersistenceManager mgr) {
            this.__m_ActiveManager = mgr;
        }

        protected void setActiveRecoveryRequests(AtomicInteger atomicRecoverRequests) {
            this.__m_ActiveRecoveryRequests = atomicRecoverRequests;
        }

        public void setAsync(boolean fAsync) {
            this.__m_Async = fAsync;
        }

        public void setBackupManager(PersistenceManager managerBackup) {
            this.__m_BackupManager = managerBackup;
        }

        protected void setDisabled(boolean fDisabled) {
            this.__m_Disabled = fDisabled;
        }

        protected void setEventsManager(PersistenceManager mgr) {
            this.__m_EventsManager = mgr;
        }

        public void setForceRecovery(boolean fRecovery) {
            this.__m_ForceRecovery = fRecovery;
        }

        protected void setPartitionVersionExclusionList(PartitionVersionExclusionList storage) {
            this.__m_PartitionVersionExclusionList = storage;
        }

        public void setPersistenceEnvironment(PersistenceEnvironment env) {
            PersistenceControl._assert(this.getPersistenceEnvironment() == null, "Environment is not resettable");
            this.__m_PersistenceEnvironment = env;
        }

        public void setQuorumRaw(Binary binRaw) {
            this.__m_QuorumRaw = binRaw;
        }

        protected void setResumeOnFailover(boolean fFailover) {
            this.__m_ResumeOnFailover = fFailover;
        }

        public void setSnapshotArchiver(SnapshotArchiver archiverSnapshot) {
            this.__m_SnapshotArchiver = archiverSnapshot;
        }

        protected void setSnapshotController(SnapshotController controller) {
            this.__m_SnapshotController = controller;
        }

        protected void setStatsLatencyCount(long cStats) {
            this.__m_StatsLatencyCount = cStats;
        }

        protected void setStatsLatencyMax(long cMillisMax) {
            this.__m_StatsLatencyMax = cMillisMax;
        }

        protected void setStatsLatencyTotal(long cMillisTotal) {
            this.__m_StatsLatencyTotal = cMillisTotal;
        }

        static {
            PersistenceControl.__initStatic();
        }

        public static class SnapshotBuilder
        extends Component
        implements Continuation,
        PriorityTask,
        Runnable {
            private PersistenceManager __m_Manager;
            private int __m_Partition;
            private boolean __m_PartitionLocked;
            private PartitionSet __m_Partitions;
            private volatile PartitionSet __m_RejectedPartitions;
            private Grid.Response __m_Response;

            public SnapshotBuilder() {
                this(null, null, true);
            }

            public SnapshotBuilder(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setPartition(-1);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new SnapshotBuilder();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PersistenceControl$SnapshotBuilder".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public void build(int iPart) {
                PartitionedService service = this.getService();
                boolean fSuspended = service.isSuspendedFully();
                boolean fLocked = false;
                while ((iPart = this.getPartitions().next(iPart)) >= 0 && !fSuspended && !(fLocked = this.lock(iPart))) {
                    if (!fSuspended) {
                        this.onPartitionFailed(iPart, null);
                    }
                    ++iPart;
                }
                if (iPart == -1) {
                    this.setPartition(Integer.MIN_VALUE);
                    this.onSnapshotCompleted();
                    return;
                }
                SnapshotBuilder._assert(fSuspended || fLocked);
                this.setPartitionLocked(fLocked);
                boolean fStart = this.getPartition() == -1;
                this.setPartition(iPart);
                if (fStart) {
                    service.getDaemonPool().add(this);
                }
            }

            protected String buildGUID(int iPart) {
                PartitionedService service = this.getService();
                Member memberThis = service.getThisMember();
                return GUIDHelper.generateGUID(iPart, service.getOwnershipVersion(iPart), service.getServiceMemberSet().getServiceJoinTime(memberThis.getId()), memberThis);
            }

            @Override
            public long getExecutionTimeoutMillis() {
                return 0L;
            }

            public PersistenceManager getManager() {
                return this.__m_Manager;
            }

            public int getPartition() {
                return this.__m_Partition;
            }

            public PartitionSet getPartitions() {
                return this.__m_Partitions;
            }

            public PartitionSet getRejectedPartitions() {
                return this.__m_RejectedPartitions;
            }

            @Override
            public long getRequestTimeoutMillis() {
                return 0L;
            }

            public Grid.Response getResponse() {
                return this.__m_Response;
            }

            @Override
            public int getSchedulingPriority() {
                return 2;
            }

            protected PartitionedService getService() {
                return (PartitionedService)this.get_Module();
            }

            protected boolean isPartitionLocked() {
                return this.__m_PartitionLocked;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected boolean lock(int iPart) {
                PartitionedService service = this.getService();
                PartitionControl ctrlPart = service.getPartitionControl(iPart);
                long cMillis = service.getDistributionContendMillis();
                boolean fLocked = ctrlPart != null && ctrlPart.lock(cMillis, 4);
                AtomicInteger atomicTasks = ctrlPart.getPersistenceTasks();
                if (fLocked && atomicTasks.get() > 0) {
                    try {
                        AtomicInteger atomicInteger = atomicTasks;
                        synchronized (atomicInteger) {
                            Blocking.wait(atomicTasks, cMillis);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (atomicTasks.get() > 0) {
                        ctrlPart.unlock();
                        fLocked = false;
                    }
                }
                return fLocked;
            }

            public void onPartitionFailed(int iPart, Throwable tFailure) {
                Grid.Response msgResponse = this.getResponse();
                PartitionSet partsRejected = this.getRejectedPartitions();
                if (partsRejected == null) {
                    msgResponse.setResult(2);
                    partsRejected = this.getService().instantiatePartitionSet(false);
                }
                Object sMsg = "Failed to create snapshot of partition";
                if (iPart != -1) {
                    partsRejected.add(iPart);
                    sMsg = (String)sMsg + " " + iPart;
                    this.setRejectedPartitions(partsRejected);
                }
                if (tFailure == null) {
                    SnapshotBuilder._trace((String)sMsg + " due to a failure to lock", 6);
                } else {
                    SnapshotBuilder._trace((String)sMsg + " due to: " + String.valueOf(tFailure) + "\n" + Base.getStackTrace(tFailure), 2);
                }
            }

            protected void onPartitionsFailed(PartitionSet partsFailed, Throwable tFailure) {
                if (partsFailed.isEmpty()) {
                    return;
                }
                Grid.Response msgResponse = this.getResponse();
                PartitionSet partsRejected = this.getRejectedPartitions();
                if (partsRejected == null) {
                    msgResponse.setResult(2);
                    partsRejected = this.getService().instantiatePartitionSet(false);
                }
                partsRejected.add(partsFailed);
                String sMsg = "Failed to create snapshot of partitions " + String.valueOf(partsFailed) + " due to: " + String.valueOf(tFailure) + "\n" + Base.getStackTrace(tFailure);
                this.setRejectedPartitions(partsRejected);
                SnapshotBuilder._trace(sMsg, 2);
            }

            protected void onSnapshotCompleted() {
                Grid.Response msgResponse = this.getResponse();
                PartitionSet partsCompleted = this.getPartitions();
                PartitionSet partsRejected = this.getRejectedPartitions();
                if (partsRejected != null) {
                    partsCompleted.remove(partsRejected);
                }
                msgResponse.setValue(partsCompleted);
                this.getManager().release();
                this.getService().send(msgResponse);
            }

            public void proceed(Object o) {
                int iPart;
                Throwable t = null;
                if (o instanceof Integer) {
                    iPart = (Integer)o;
                } else {
                    t = (Throwable)o;
                    iPart = this.getPartition();
                }
                if (this.isPartitionLocked()) {
                    this.getService().getPartitionControl(iPart).unlock();
                }
                if (t == null) {
                    this.build(iPart + 1);
                } else {
                    PartitionSet parts = this.getPartitions();
                    PartitionSet partsFailed = this.getService().instantiatePartitionSet(false);
                    while (iPart >= 0) {
                        partsFailed.add(iPart);
                        iPart = parts.next(iPart + 1);
                    }
                    this.onPartitionsFailed(partsFailed, t);
                }
            }

            public void removeTransientCaches(PersistentStore store) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int iPartPrev = -1;
                while (true) {
                    int iPart;
                    SnapshotBuilder snapshotBuilder = this;
                    synchronized (snapshotBuilder) {
                        while ((iPart = this.getPartition()) < 0 || iPartPrev == iPart) {
                            if (iPart == Integer.MIN_VALUE) {
                                return;
                            }
                            try {
                                Blocking.wait(this, 1000L);
                            }
                            catch (InterruptedException e) {
                                this.getService().getContinuations().thenOnServiceThread(this).proceed(e);
                            }
                        }
                    }
                    this.snapshotStore(iPart);
                    iPartPrev = iPart;
                }
            }

            @Override
            public void runCanceled(boolean fAbandoned) {
            }

            public void setManager(PersistenceManager manager) {
                if (this.getManager() != null) {
                    throw new IllegalStateException("The PersistenceManager cannot be reset.");
                }
                this.__m_Manager = manager;
            }

            public synchronized void setPartition(int nPartition) {
                this.__m_Partition = nPartition;
                this.notify();
            }

            protected void setPartitionLocked(boolean fLocked) {
                this.__m_PartitionLocked = fLocked;
            }

            public void setPartitions(PartitionSet setPartitions) {
                this.__m_Partitions = setPartitions;
            }

            public void setRejectedPartitions(PartitionSet setPartitions) {
                this.__m_RejectedPartitions = setPartitions;
            }

            public void setResponse(Grid.Response response) {
                this.__m_Response = response;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void snapshotStore(int iPart) {
                PersistenceManager mgrActive = ((PersistenceControl)this.get_Parent()).getActiveManager();
                PersistenceManager mgrSnapshot = this.getManager();
                PersistentStore store = null;
                Object oToken = null;
                PartitionedService service = this.getService();
                Throwable eFailure = null;
                String sGUID = null;
                try {
                    GuardSupport.heartbeat();
                    if (mgrActive == null) {
                        sGUID = this.buildGUID(iPart);
                        if (service.hasPersistentData(iPart)) {
                            store = mgrSnapshot.open(sGUID, null);
                            oToken = store.begin();
                            service.snapshotPartition(iPart, store, oToken);
                            store.commit(oToken);
                        } else {
                            mgrSnapshot.createStore(sGUID);
                        }
                    } else {
                        PersistentStore storeFrom = service.getPartitionControl(iPart).getPersistentStore();
                        sGUID = storeFrom.getId();
                        store = mgrSnapshot.open(sGUID, storeFrom);
                        this.removeTransientCaches(store);
                    }
                    SnapshotBuilder._trace("Created snapshot of partition " + iPart, 3);
                }
                catch (Throwable t) {
                    eFailure = t;
                    if (store != null) {
                        store.abort(oToken);
                    }
                    this.onPartitionFailed(iPart, t);
                }
                finally {
                    if (store != null) {
                        mgrSnapshot.close(sGUID);
                    }
                    this.getService().getContinuations().thenOnServiceThread(this).proceed(iPart);
                }
            }
        }

        public static class SnapshotController
        extends Component
        implements PersistenceManagerMBean {
            private boolean __m_ResumeOnCompletion;
            public static final int SNAPSHOT_NAMES_EXPIRE = 5000;
            private String __m_SnapshotName;
            private String[] __m_SnapshotNames;
            private volatile long __m_SnapshotNamesExpire;
            private volatile int __m_State;
            public static final int STATE_ACTIVE_RECOVERY = 6;
            public static final int STATE_IDLE = 0;
            public static final int STATE_RECOVER_RECOVERING = 2;
            public static final int STATE_SNAPSHOT_ARCHIVING = 4;
            public static final int STATE_SNAPSHOT_BUILDING = 1;
            public static final int STATE_SNAPSHOT_REMOVING = 3;
            public static final int STATE_SNAPSHOT_RETRIEVING = 5;

            public SnapshotController() {
                this(null, null, true);
            }

            public SnapshotController(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new SnapshotController();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PersistenceControl$SnapshotController".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            protected void addNotification(String sNotificationType, String sMessage, String sUserData) {
                Registry registry = this.getService().getCluster().getManagement();
                if (registry != null) {
                    this.getService().dispatchNotification(registry.ensureGlobalName(this.getMBeanName()), sNotificationType, sMessage, sUserData);
                }
            }

            @Override
            public synchronized void archiveSnapshot(String sSnapshot) {
                MBeanHelper.checkReadOnly("archiveSnapshot");
                this.ensureArchiveReady();
                if (!this.hasSnapshot(sSnapshot)) {
                    throw new IllegalArgumentException("A snapshot named \"" + sSnapshot + "\" does not exist");
                }
                if (this.hasArchivedSnapshot(sSnapshot)) {
                    throw new IllegalArgumentException("The archived snapshot \"" + sSnapshot + "\" already exists");
                }
                Map<Integer, String[]> mapStores = this.getSnapshotStores(sSnapshot);
                PartitionedService service = this.getService();
                mapStores = GUIDHelper.assignStores(GUIDHelper.getMapGuids((Map<Integer, Object[]>)mapStores), service.getPartitionCount());
                this.setSnapshotName(sSnapshot);
                ActualMemberSet setMembers = new ActualMemberSet();
                for (Member member : service.getOwnershipMemberSet()) {
                    Object[] aoStores = mapStores.get(member.getId());
                    if (aoStores == null || aoStores.length <= 0) continue;
                    ((MemberSet)setMembers).add(member);
                }
                SnapshotArchiveRequest msgArchiveRequest = (SnapshotArchiveRequest)service.instantiateMessage("SnapshotArchiveRequest");
                msgArchiveRequest.setSnapshotName(sSnapshot);
                msgArchiveRequest.setToMemberSet(setMembers);
                msgArchiveRequest.setArchive(true);
                msgArchiveRequest.setStores(mapStores);
                service.send(msgArchiveRequest);
                this.setState(4);
                this.addNotification("archive.snapshot.begin", this.getOperationStatus(), "");
            }

            protected void checkResume() {
                if (this.isResumeOnCompletion()) {
                    PartitionedService service = this.getService();
                    String sServiceName = service.getServiceName();
                    SnapshotController._trace("Automatically resuming service " + sServiceName, 3);
                    CachePersistenceHelper.resumeService(service.getCluster(), sServiceName);
                    this.setResumeOnCompletion(false);
                }
            }

            public MemberSet combineMembersLeft(MemberSet setMembersFailed, MemberSet setMembersLeft) {
                if (setMembersFailed == null) {
                    return setMembersLeft;
                }
                if (!setMembersLeft.isEmpty()) {
                    setMembersFailed.addAll((Collection)setMembersLeft);
                }
                return setMembersFailed;
            }

            @Override
            public synchronized void createSnapshot(String sSnapshot) {
                MemberSet setOwners;
                boolean fPartitioned;
                MBeanHelper.checkReadOnly("createSnapshot");
                this.ensureReady(false);
                if (this.hasSnapshot(sSnapshot)) {
                    throw new IllegalArgumentException("A snapshot named \"" + sSnapshot + "\" already exists");
                }
                PartitionedService service = this.getService();
                boolean bl = fPartitioned = service.isVersionCompatible(setOwners = service.getOwnershipMemberSet(), 12, 2, 1, 2, 0) && !service.isSuspendedFully();
                if (!fPartitioned) {
                    this.ensureSuspended();
                }
                this.setSnapshotName(sSnapshot);
                this.setState(1);
                SnapshotRequest msgRequest = (SnapshotRequest)service.instantiateMessage("SnapshotRequest");
                msgRequest.setSnapshotName(sSnapshot);
                msgRequest.setToMemberSet(setOwners);
                msgRequest.setCreate(true);
                if (fPartitioned) {
                    msgRequest.setCompleted(service.instantiatePartitionSet(false));
                    msgRequest.setRequestMask(service.instantiatePartitionSet(true));
                }
                service.send(msgRequest);
                this.addNotification("create.snapshot.begin", this.getOperationStatus(), "");
            }

            protected void ensureArchiveReady() {
                this.ensureReady(false);
                if (this.getPersistenceControl().getSnapshotArchiver() == null) {
                    throw new IllegalArgumentException("No archiver is defined for this service");
                }
            }

            protected void ensureReady(boolean fSuspend) {
                PartitionedService service = this.getService();
                if (service == null || !service.isRunning()) {
                    throw new IllegalStateException("There are no remaining storage-enabled members of the service");
                }
                SnapshotController._assert(service.getOwnershipSenior() == service.getThisMember());
                if (!this.getPersistenceControl().isValid()) {
                    throw new IllegalStateException("Persistence has not been configured on the ownership senior");
                }
                if (fSuspend && !service.isSuspended()) {
                    throw new IllegalStateException("The service must be suspended; see the \"suspendService\" operation on the ClusterMBean");
                }
                if (!this.isIdle()) {
                    throw new IllegalStateException("Request is pending: " + this.getOperationStatus());
                }
            }

            protected void ensureSuspended() {
                PartitionedService service = this.getService();
                if (service.isSuspended()) {
                    this.setResumeOnCompletion(false);
                } else {
                    String sServiceName = service.getServiceName();
                    SnapshotController._trace("Automatically suspending service " + sServiceName, 3);
                    ((Cluster)service.getCluster()).suspendService(sServiceName, true);
                    this.setResumeOnCompletion(true);
                }
            }

            @Override
            public void forceRecovery() {
                MBeanHelper.checkReadOnly("forceRecovery");
                this.getPersistenceControl().setForceRecovery(true);
            }

            @Override
            public int getCoordinatorId() {
                PartitionedService service = this.getService();
                return service == null || !service.isRunning() ? -1 : service.getThisMember().getId();
            }

            public String getGUIDFromPartition(int nPartition, String[] asStores) {
                for (int i = 0; i < asStores.length; ++i) {
                    if (GUIDHelper.getPartition(asStores[i]) != nPartition) continue;
                    return asStores[i];
                }
                return null;
            }

            public String getMBeanName() {
                return CachePersistenceHelper.getMBeanName(this.getService().getServiceName());
            }

            @Override
            public String getOperationStatus() {
                PartitionedService service = this.getService();
                if (service == null || !service.isRunning()) {
                    return "n/a";
                }
                switch (this.getState()) {
                    case 0: {
                        return "Idle";
                    }
                    case 1: {
                        return "Building snapshot \"" + this.getSnapshotName() + "\"";
                    }
                    case 2: {
                        return "Recovering snapshot \"" + this.getSnapshotName() + "\"";
                    }
                    case 3: {
                        return "Removing snapshot \"" + this.getSnapshotName() + "\"";
                    }
                    case 4: {
                        return "Archiving snapshot \"" + this.getSnapshotName() + "\"";
                    }
                    case 5: {
                        return "Retrieving archived snapshot \"" + this.getSnapshotName() + "\"";
                    }
                    case 6: {
                        return "Active recovery in progress";
                    }
                }
                throw new IllegalStateException("Invalid state: " + this.getState());
            }

            protected PersistenceControl getPersistenceControl() {
                return (PersistenceControl)this.get_Parent();
            }

            protected PartitionedService getService() {
                return (PartitionedService)this.get_Module();
            }

            public String getSnapshotName() {
                return this.__m_SnapshotName;
            }

            protected String[] getSnapshotNames() {
                return this.__m_SnapshotNames;
            }

            protected long getSnapshotNamesExpire() {
                return this.__m_SnapshotNamesExpire;
            }

            @Override
            public String[] getSnapshots() {
                PartitionedService service = this.getService();
                if (service == null || !service.isRunning()) {
                    return null;
                }
                if (Base.getSafeTimeMillis() < this.getSnapshotNamesExpire() || Thread.currentThread() == service.getThread()) {
                    return this.getSnapshotNames();
                }
                SnapshotListRequest msgRequest = (SnapshotListRequest)service.instantiateMessage("SnapshotListRequest");
                msgRequest.setToMemberSet(service.getOwnershipMemberSet());
                msgRequest.setSnapshotName(null);
                String[] asNames = (String[])service.poll(msgRequest);
                this.setSnapshotNames(asNames);
                return asNames;
            }

            private Map getSnapshotStores(String sSnapshot) {
                PartitionedService service = this.getService();
                SnapshotListRequest msgRequest = (SnapshotListRequest)service.instantiateMessage("SnapshotListRequest");
                msgRequest.setToMemberSet(service.getOwnershipMemberSet());
                msgRequest.setSnapshotName(sSnapshot);
                Map mapStores = (Map)service.poll(msgRequest);
                if (mapStores == null || mapStores.size() == 0) {
                    throw new IllegalArgumentException("No members returned snapshot store details");
                }
                return mapStores;
            }

            public int getState() {
                return this.__m_State;
            }

            protected boolean hasArchivedSnapshot(String sSnapshot) {
                String[] asSnapshots = this.listArchivedSnapshots();
                int c = asSnapshots.length;
                for (int i = 0; i < c; ++i) {
                    if (!sSnapshot.equals(asSnapshots[i])) continue;
                    return true;
                }
                return false;
            }

            protected boolean hasSnapshot(String sSnapshot) {
                String[] asSnapshots = this.getSnapshots();
                int c = asSnapshots.length;
                for (int i = 0; i < c; ++i) {
                    if (!sSnapshot.equals(asSnapshots[i])) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean isIdle() {
                return this.getState() == 0;
            }

            public boolean isResumeOnCompletion() {
                return this.__m_ResumeOnCompletion;
            }

            @Override
            public String[] listArchivedSnapshots() {
                SnapshotArchiver archiver = this.getPersistenceControl().getSnapshotArchiver();
                if (archiver == null) {
                    throw new IllegalArgumentException("No archiver is defined for this service");
                }
                return archiver.list();
            }

            @Override
            public String[] listArchivedSnapshotStores(String sSnapshot) {
                if (!this.hasArchivedSnapshot(sSnapshot)) {
                    throw new IllegalArgumentException("A snapshot named \"" + sSnapshot + "\" does not exist");
                }
                SnapshotArchiver archiver = this.getPersistenceControl().getSnapshotArchiver();
                return archiver.get(sSnapshot).listStores();
            }

            public void onArchiveCompleted(MemberSet setMembersFailed) {
                String sNotificationType;
                String sMessage;
                int nState = this.getState();
                SnapshotController._assert(nState == 4 || nState == 5);
                String sSnapshot = this.getSnapshotName();
                Object sUserData = "";
                boolean fArchive = nState == 4;
                String sDesc = fArchive ? "archive" : "retrieve";
                String sArchived = fArchive ? "" : " archived ";
                String sServiceName = this.getService().getServiceName();
                if (setMembersFailed == null || setMembersFailed.isEmpty()) {
                    sMessage = "Successfully " + sDesc + "d " + sArchived + "snapshot \"" + sSnapshot + "\"";
                    SnapshotController._trace(sMessage, 3);
                } else {
                    sMessage = "Failed to " + sDesc + " " + sArchived + "snapshot \"" + sSnapshot + "\"";
                    sUserData = "failed members " + String.valueOf(setMembersFailed);
                    SnapshotController._trace(sMessage + " because of " + (String)sUserData, 2);
                }
                if (fArchive) {
                    sNotificationType = "archive.snapshot.end";
                } else {
                    sNotificationType = "retrieve.archived.snapshot.end";
                    this.setSnapshotNames(null);
                }
                this.addNotification(sNotificationType, sMessage, (String)sUserData);
                this.reset();
            }

            @Override
            public void onInit() {
                super.onInit();
                Registry registry = this.getService().getCluster().getManagement();
                if (registry != null) {
                    try {
                        registry.register(registry.ensureGlobalName(this.getMBeanName()), new AnnotatedStandardEmitterMBean(this, PersistenceManagerMBean.class));
                    }
                    catch (Exception e) {
                        throw Base.ensureRuntimeException(e);
                    }
                }
                this.setResumeOnCompletion(this.getPersistenceControl().isResumeOnFailover());
                this.checkResume();
            }

            public void onRecoveryCompleted(String sSnapshot, PartitionSet partsFailed, PartitionSet partsFailedEvents) {
                Object sUserData;
                String sMessage;
                if (sSnapshot == null) {
                    this.addNotification("recover.end", "Recovery Completed", "");
                    if (!partsFailedEvents.isEmpty()) {
                        SnapshotController._trace("Event stores for the following partitions failed to recover: " + String.valueOf(partsFailedEvents), 2);
                    }
                    this.reset();
                    return;
                }
                SnapshotController._assert(this.getState() == 2);
                if (partsFailed == null || partsFailed.isEmpty()) {
                    sMessage = "Successfully recovered snapshot \"" + sSnapshot + "\"";
                    sUserData = "";
                    SnapshotController._trace(sMessage, 3);
                } else {
                    sMessage = "Failed to recover snapshot \"" + sSnapshot + "\"";
                    sUserData = "failed partitions " + String.valueOf(partsFailed);
                    SnapshotController._trace(sMessage + " because of " + (String)sUserData, 2);
                }
                this.checkResume();
                this.addNotification("recover.end", "Recovery Completed", "");
                this.addNotification("recover.snapshot.end", sMessage, (String)sUserData);
                this.reset();
                this.sendMemberRecovered();
            }

            public void onRecoveryStarted(String sSnapshot, PartitionSet partsRecover) {
                if (sSnapshot == null) {
                    this.setState(6);
                }
                this.addNotification("recover.begin", this.getOperationStatus(), partsRecover.cardinality() + " partitions to recover");
            }

            public void onSnapshotCompleted(MemberSet setMembersFailed, PartitionSet partsFailed) {
                String sMessage;
                boolean fMembersSuccess;
                int nState = this.getState();
                SnapshotController._assert(nState == 1 || nState == 3);
                String sSnapshot = this.getSnapshotName();
                Object sUserData = "";
                boolean fCreate = nState == 1;
                String sDesc = fCreate ? "create" : "remove";
                boolean fPartsSuccess = partsFailed == null || partsFailed.isEmpty();
                boolean bl = fMembersSuccess = setMembersFailed == null || setMembersFailed.isEmpty();
                if (fMembersSuccess && fPartsSuccess) {
                    sMessage = "Successfully " + sDesc + "d snapshot \"" + sSnapshot + "\"";
                    SnapshotController._trace(sMessage, 3);
                } else {
                    sMessage = "Failed to " + sDesc + " snapshot \"" + sSnapshot + "\"";
                    sUserData = (String)sUserData + (String)(fPartsSuccess ? "" : "failed " + String.valueOf(partsFailed));
                    sUserData = (String)sUserData + (String)(fMembersSuccess ? "" : (fPartsSuccess ? "failed " : " on ") + String.valueOf(setMembersFailed));
                    SnapshotController._trace(sMessage + " because of " + (String)sUserData, 2);
                }
                if (fCreate) {
                    this.checkResume();
                }
                this.setSnapshotNames(null);
                this.addNotification(fCreate ? "create.snapshot.end" : "remove.snapshot.end", sMessage, (String)sUserData);
                this.reset();
            }

            @Override
            public synchronized void recoverSnapshot(String sSnapshot) {
                MBeanHelper.checkReadOnly("recoverSnapshot");
                this.ensureReady(false);
                if (!this.hasSnapshot(sSnapshot)) {
                    throw new IllegalArgumentException("A snapshot named \"" + sSnapshot + "\" does not exist");
                }
                PartitionedService service = this.getService();
                int cParts = service.getPartitionCount();
                PartitionSet parts = GUIDHelper.getPartitions(this.getSnapshotStores(sSnapshot), cParts);
                if (parts.cardinality() != cParts) {
                    throw new IllegalStateException("Missing the following partitions to recover snapsot '" + sSnapshot + "': " + String.valueOf(parts.invert()));
                }
                this.ensureSuspended();
                this.setSnapshotName(sSnapshot);
                this.addNotification("recover.snapshot.begin", "Recovering Snapshot \"" + sSnapshot + "\"", "");
                this.setState(2);
                NotifySnapshotRecoverRequest msg = (NotifySnapshotRecoverRequest)service.instantiateMessage("NotifySnapshotRecoverRequest");
                msg.setSnapshotName(sSnapshot);
                msg.addToMember(service.getThisMember());
                service.post(msg);
            }

            public void release() {
                Registry registry = this.getService().getCluster().getManagement();
                if (registry != null) {
                    registry.unregister(registry.ensureGlobalName(this.getMBeanName()));
                }
            }

            @Override
            public void removeArchivedSnapshot(String sSnapshot) {
                this.ensureArchiveReady();
                if (!this.hasArchivedSnapshot(sSnapshot)) {
                    throw new IllegalArgumentException("The archived snapshot \"" + sSnapshot + "\" does not exist");
                }
                SnapshotArchiver archiver = this.getPersistenceControl().getSnapshotArchiver();
                String sServiceName = this.getService().getServiceName();
                SnapshotController._trace("Removing archived snapshot \"" + sSnapshot + "\" for service " + sServiceName, 3);
                try {
                    this.addNotification("remove.archived.snapshot.begin", "Removing archived snapshot \"" + sSnapshot + "\"", "");
                    archiver.remove(sSnapshot);
                    SnapshotController._trace("Archived snapshot \"" + sSnapshot + "\" removed for service " + sServiceName, 3);
                    this.addNotification("remove.archived.snapshot.end", "Sucessfully removed archived snapshot \"" + sSnapshot + "\"", "");
                }
                catch (Exception e) {
                    String sStack = SnapshotController.getStackTrace(e);
                    SnapshotController._trace("Unable to remove archived snapshot \"" + sSnapshot + "\"\n" + sStack, 2);
                    this.addNotification("remove.archived.snapshot.end", "Failed to remove archived snapshot \"" + sSnapshot + "\"", sStack);
                }
            }

            @Override
            public void removeSnapshot(String sSnapshot) {
                MBeanHelper.checkReadOnly("removeSnapshot");
                this.ensureReady(false);
                if (!this.hasSnapshot(sSnapshot)) {
                    throw new IllegalArgumentException("A snapshot named \"" + sSnapshot + "\" does not exist");
                }
                this.setSnapshotName(sSnapshot);
                this.setState(3);
                PartitionedService service = this.getService();
                SnapshotRequest msgRequest = (SnapshotRequest)service.instantiateMessage("SnapshotRequest");
                msgRequest.setSnapshotName(sSnapshot);
                msgRequest.setCreate(false);
                msgRequest.setToMemberSet(service.getOwnershipMemberSet());
                service.send(msgRequest);
                this.addNotification("remove.snapshot.begin", this.getOperationStatus(), "");
            }

            protected synchronized void reset() {
                this.setSnapshotName(null);
                this.setState(0);
            }

            @Override
            public void retrieveArchivedSnapshot(String sSnapshot) {
                HashSet<String> setStores;
                Snapshot snapshot;
                String[] asStores;
                MBeanHelper.checkReadOnly("retrieveArchivedSnapshot");
                this.ensureArchiveReady();
                if (this.hasSnapshot(sSnapshot)) {
                    throw new IllegalArgumentException("A local snapshot named \"" + sSnapshot + "\" already exists and must be removed prior to being retrieved");
                }
                if (!this.hasArchivedSnapshot(sSnapshot)) {
                    throw new IllegalArgumentException("The archived snapshot \"" + sSnapshot + "\" does not exist");
                }
                SnapshotArchiver archiver = this.getPersistenceControl().getSnapshotArchiver();
                PartitionedService service = this.getService();
                int cParts = service.getPartitionCount();
                if (cParts != (asStores = (snapshot = archiver.get(sSnapshot)).listStores()).length) {
                    throw new IllegalStateException("The number of archived stores for snapshot " + sSnapshot + " is " + asStores.length + " which does not match the current service partition count of " + cParts);
                }
                ServiceMemberSet setMembers = service.getServiceMemberSet();
                ActualMemberSet setTo = new ActualMemberSet();
                HashMap mapStores = new HashMap();
                for (int iPart = 0; iPart < cParts; ++iPart) {
                    String sGUID;
                    int nMember = service.getPartitionConfig(iPart).getPrimaryOwner();
                    Integer NMember = nMember;
                    setStores = (HashSet<String>)mapStores.get(NMember);
                    if (setStores == null) {
                        setStores = new HashSet<String>();
                        mapStores.put(NMember, setStores);
                        setTo.add(setMembers.getMember(nMember));
                    }
                    if ((sGUID = this.getGUIDFromPartition(iPart, asStores)) == null) {
                        throw new IllegalStateException("Unable to find a GUID for partition " + iPart + " in the list of stores for snapshot " + sSnapshot + ". Unable to retrieve");
                    }
                    setStores.add(sGUID);
                }
                HashMap mapConvertedStores = new HashMap();
                for (Map.Entry entry : mapStores.entrySet()) {
                    setStores = (Set)entry.getValue();
                    mapConvertedStores.put(entry.getKey(), setStores.toArray(new String[setStores.size()]));
                }
                this.setSnapshotName(sSnapshot);
                SnapshotArchiveRequest msgArchiveRequest = (SnapshotArchiveRequest)service.instantiateMessage("SnapshotArchiveRequest");
                msgArchiveRequest.setSnapshotName(sSnapshot);
                msgArchiveRequest.setToMemberSet(setTo);
                msgArchiveRequest.setArchive(false);
                msgArchiveRequest.setStores(mapConvertedStores);
                service.send(msgArchiveRequest);
                this.setState(5);
                this.addNotification("retrieve.archived.snapshot.begin", this.getOperationStatus(), "");
            }

            public void sendMemberRecovered() {
                PartitionedService service = (PartitionedService)this.get_Module();
                Grid.MemberRecovered msg = (Grid.MemberRecovered)service.instantiateMessage("MemberRecovered");
                Member member = service.getThisMember();
                msg.setMemberId(member.getId());
                msg.setToMemberSet(service.getServiceMemberSet());
                service.post(msg);
            }

            protected void setResumeOnCompletion(boolean fResume) {
                this.__m_ResumeOnCompletion = fResume;
            }

            protected void setSnapshotName(String sSnapshot) {
                this.__m_SnapshotName = sSnapshot;
            }

            public void setSnapshotNames(String[] asNames) {
                this.__m_SnapshotNames = asNames;
                this.setSnapshotNamesExpire(asNames == null ? 0L : Base.getSafeTimeMillis() + 5000L);
            }

            protected void setSnapshotNamesExpire(long ldtExpire) {
                this.__m_SnapshotNamesExpire = ldtExpire;
            }

            protected void setState(int nState) {
                this.__m_State = nState;
            }
        }
    }

    public static class PinningIterator
    extends Util
    implements Iterator {
        private boolean __m_Concurrent;
        private PartitionSet __m_DeferredPartitions;
        private Iterator __m_FullIterator;
        private Set __m_FullSet;
        private boolean __m_InitialRun;
        private boolean __m_Next;
        private Object __m_NextItem;
        private PartitionVersions __m_PartitionVersions;
        private PartitionSet __m_PinnedPartitions;
        private Set __m_RejectedKeys;
        private PartitionSet __m_RejectedPartitions;
        private boolean __m_Removable;

        public PinningIterator() {
            this(null, null, true);
        }

        public PinningIterator(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PinningIterator();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PinningIterator".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        protected Set ensureRejectedKeys() {
            HashSet setReject = this.getRejectedKeys();
            if (setReject == null) {
                setReject = new HashSet();
                this.setRejectedKeys(setReject);
            }
            return setReject;
        }

        protected boolean enterPartition(int nPartition) {
            return ((PartitionedService)this.get_Module()).enterPartition(nPartition);
        }

        private boolean evaluate(Object o) {
            Binary binKey = o instanceof Binary ? (Binary)o : (Binary)((Map.Entry)o).getKey();
            if (this.isInitialRun()) {
                PartitionedService service = (PartitionedService)this.get_Module();
                PartitionSet partAccept = this.getPinnedPartitions();
                PartitionSet partReject = this.getRejectedPartitions();
                PartitionSet partDefer = this.getDeferredPartitions();
                int iPartition = service.getKeyPartition(binKey);
                if (partAccept.contains(iPartition)) {
                    return true;
                }
                if (partReject != null && partReject.contains(iPartition)) {
                    this.ensureRejectedKeys().add(binKey);
                    return false;
                }
                if (partDefer != null && partDefer.contains(iPartition)) {
                    if (partReject == null) {
                        partReject = new PartitionSet(service.getPartitionCount());
                        this.setRejectedPartitions(partReject);
                    }
                    partReject.add(iPartition);
                    this.ensureRejectedKeys().add(binKey);
                    return false;
                }
                boolean fEntered = false;
                int nVersion = this.getVersion(iPartition);
                if (!(this.isConcurrent() && !(fEntered = this.enterPartition(iPartition)) || !service.isPrimaryOwner(iPartition) || nVersion != -1 && nVersion != service.getOwnershipVersion(iPartition))) {
                    partAccept.add(iPartition);
                    return true;
                }
                if (partReject == null) {
                    partReject = new PartitionSet(service.getPartitionCount());
                    this.setRejectedPartitions(partReject);
                }
                partReject.add(iPartition);
                this.ensureRejectedKeys().add(binKey);
                if (fEntered) {
                    service.exitPartition(iPartition);
                }
                return false;
            }
            Set setRejected = this.getRejectedKeys();
            return setRejected == null || !setRejected.contains(binKey);
        }

        public PartitionSet getDeferredPartitions() {
            return this.__m_DeferredPartitions;
        }

        private Iterator getFullIterator() {
            return this.__m_FullIterator;
        }

        public Set getFullSet() {
            return this.__m_FullSet;
        }

        private Object getNextItem() {
            return this.__m_NextItem;
        }

        public PartitionVersions getPartitionVersions() {
            return this.__m_PartitionVersions;
        }

        public PartitionSet getPinnedPartitions() {
            return this.__m_PinnedPartitions;
        }

        public Set getRejectedKeys() {
            return this.__m_RejectedKeys;
        }

        public PartitionSet getRejectedPartitions() {
            return this.__m_RejectedPartitions;
        }

        protected int getVersion(int nPartition) {
            PartitionVersions versions = this.getPartitionVersions();
            return versions == null ? -1 : versions.getVersion(nPartition);
        }

        @Override
        public boolean hasNext() {
            boolean fNext = this.isNext();
            if (fNext) {
                return true;
            }
            Iterator iter = this.getFullIterator();
            while (iter.hasNext()) {
                Object oNext = iter.next();
                if (this.evaluate(oNext)) {
                    this.setNextItem(oNext);
                    fNext = true;
                    this.setNext(true);
                    break;
                }
                PinningIterator._assert(this.isInitialRun());
                iter.remove();
            }
            this.setRemovable(false);
            return fNext;
        }

        public boolean isConcurrent() {
            return this.__m_Concurrent;
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        private boolean isInitialRun() {
            return this.__m_InitialRun;
        }

        private boolean isNext() {
            return this.__m_Next;
        }

        private boolean isRemovable() {
            return this.__m_Removable;
        }

        public Object next() {
            if (this.isNext()) {
                this.setNext(false);
                this.setRemovable(true);
                return this.getNextItem();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (!this.isRemovable()) {
                throw new IllegalStateException();
            }
            this.setRemovable(false);
            Object oNext = this.getNextItem();
            this.ensureRejectedKeys().add(oNext instanceof Map.Entry ? ((Map.Entry)oNext).getKey() : oNext);
            this.getFullIterator().remove();
        }

        public void reset() {
            this.setNext(false);
            this.setRemovable(false);
            this.setInitialRun(false);
            this.setFullIterator(this.getFullSet().iterator());
        }

        protected void setConcurrent(boolean fConcurrent) {
            this.__m_Concurrent = fConcurrent;
        }

        public void setDeferredPartitions(PartitionSet setPartitions) {
            this.__m_DeferredPartitions = setPartitions;
        }

        private void setFullIterator(Iterator iter) {
            this.__m_FullIterator = iter;
        }

        public void setFullSet(Set set) {
            PinningIterator._assert(this.getFullSet() == null, "Not resettable");
            PartitionedService service = (PartitionedService)this.get_Module();
            this.setPinnedPartitions(new PartitionSet(service.getPartitionCount()));
            this.setConcurrent(service.isConcurrent());
            this.setFullIterator(set.iterator());
            this.setInitialRun(true);
            this.__m_FullSet = set;
        }

        private void setInitialRun(boolean f) {
            this.__m_InitialRun = f;
        }

        private void setNext(boolean f) {
            this.__m_Next = f;
        }

        private void setNextItem(Object oNext) {
            this.__m_NextItem = oNext;
        }

        public void setPartitionVersions(PartitionVersions versions) {
            this.__m_PartitionVersions = versions;
        }

        protected void setPinnedPartitions(PartitionSet partitions) {
            this.__m_PinnedPartitions = partitions;
        }

        protected void setRejectedKeys(Set set) {
            this.__m_RejectedKeys = set;
        }

        protected void setRejectedPartitions(PartitionSet partitions) {
            this.__m_RejectedPartitions = partitions;
        }

        private void setRemovable(boolean f) {
            this.__m_Removable = f;
        }

        public int size() {
            Set setReject = this.getRejectedKeys();
            int cReject = setReject == null ? 0 : setReject.size();
            return this.getFullSet().size() - cReject;
        }
    }

    public static class SnapshotArchiveRequest
    extends RequestMessage
    implements Runnable {
        private boolean __m_Archive;
        private String __m_SnapshotName;
        private Map __m_Stores;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public SnapshotArchiveRequest() {
            this(null, null, true);
        }

        public SnapshotArchiveRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(49);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new SnapshotArchiveRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$SnapshotArchiveRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public String getSnapshotName() {
            return this.__m_SnapshotName;
        }

        public Map getStores() {
            return this.__m_Stores;
        }

        @Override
        protected com.tangosol.coherence.component.net.Poll instantiatePoll() {
            return (com.tangosol.coherence.component.net.Poll)this._newChild("Poll");
        }

        public boolean isArchive() {
            return this.__m_Archive;
        }

        @Override
        public void onReceived() {
            PartitionedService service = (PartitionedService)this.getService();
            PersistenceControl ctrlPersistence = service.getPersistenceControl();
            if (ctrlPersistence.isValid()) {
                service.getDaemonPool().add(this);
            } else {
                Grid.Response msgResponse = (Grid.Response)service.instantiateMessage("Response");
                msgResponse.respondTo(this);
                msgResponse.setResult(2);
                service.send(msgResponse);
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            HashMap mapStores = new HashMap();
            super.read(input);
            this.setSnapshotName(input.readUTF());
            this.setArchive(input.readBoolean());
            ExternalizableHelper.readMap(input, mapStores, null);
            this.setStores(mapStores);
        }

        @Override
        public void run() {
            PartitionedService service = (PartitionedService)this.getService();
            PersistenceControl ctrlPersistence = service.getPersistenceControl();
            ctrlPersistence.archiveOperation(this, this.isArchive());
        }

        public void setArchive(boolean fArchive) {
            this.__m_Archive = fArchive;
        }

        public void setSnapshotName(String sName) {
            this.__m_SnapshotName = sName;
        }

        public void setStores(Map sName) {
            this.__m_Stores = sName;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeUTF(this.getSnapshotName());
            output.writeBoolean(this.isArchive());
            ExternalizableHelper.writeMap(output, this.getStores());
        }

        static {
            SnapshotArchiveRequest.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            private MemberSet __m_Failures;

            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$SnapshotArchiveRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public MemberSet getFailures() {
                return this.__m_Failures;
            }

            @Override
            protected void onCompletion() {
                PersistenceControl.SnapshotController ctrlSnapshot = ((PartitionedService)this.get_Module()).getPersistenceControl().getSnapshotController();
                MemberSet setFailures = ctrlSnapshot.combineMembersLeft(this.getFailures(), this.getLeftMemberSet());
                ctrlSnapshot.onArchiveCompleted(setFailures);
                super.onCompletion();
            }

            @Override
            public void onResponse(Message msg) {
                Grid.Response msgResponse = (Grid.Response)msg;
                if (msgResponse.getResult() == 2) {
                    MemberSet setFailed = this.getFailures();
                    if (setFailed == null) {
                        setFailed = new MemberSet();
                        this.setFailures(setFailed);
                    }
                    setFailed.add(msg.getFromMember());
                }
                super.onResponse(msg);
            }

            public void setFailures(MemberSet setFailures) {
                this.__m_Failures = setFailures;
            }
        }
    }

    public static class SnapshotListRequest
    extends RequestMessage {
        public static final String RESPONSE_SNAPSHOTS = "1";
        public static final String RESPONSE_STORES = "2";
        private String __m_SnapshotName;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public SnapshotListRequest() {
            this(null, null, true);
        }

        public SnapshotListRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(48);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new SnapshotListRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$SnapshotListRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public String getSnapshotName() {
            return this.__m_SnapshotName;
        }

        @Override
        protected com.tangosol.coherence.component.net.Poll instantiatePoll() {
            return (com.tangosol.coherence.component.net.Poll)this._newChild("Poll");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceived() {
            PartitionedService service = (PartitionedService)this.get_Module();
            Grid.Response msgResponse = (Grid.Response)service.instantiateMessage("Response");
            msgResponse.respondTo(this);
            PersistenceControl ctrlPersistence = service.getPersistenceControl();
            if (ctrlPersistence.isValid()) {
                String sSnapshotName = this.getSnapshotName();
                PersistenceEnvironment env = ctrlPersistence.getPersistenceEnvironment();
                PersistenceManager mgrSnapshot = null;
                msgResponse.setResult(0);
                if (sSnapshotName == null) {
                    msgResponse.setValue(new Object[]{RESPONSE_SNAPSHOTS, env.listSnapshots()});
                } else {
                    try {
                        mgrSnapshot = ctrlPersistence.openSnapshot(sSnapshotName);
                        msgResponse.setValue(new Object[]{RESPONSE_STORES, mgrSnapshot == null ? new PersistentStoreInfo[]{} : mgrSnapshot.listStoreInfo()});
                    }
                    finally {
                        if (mgrSnapshot != null) {
                            mgrSnapshot.release();
                        }
                    }
                }
            } else {
                msgResponse.setResult(2);
            }
            service.post(msgResponse);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            boolean fNull = input.readBoolean();
            this.setSnapshotName(fNull ? null : input.readUTF());
        }

        public void setSnapshotName(String sSnapshotName) {
            this.__m_SnapshotName = sSnapshotName;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            boolean fNull = this.getSnapshotName() == null;
            output.writeBoolean(fNull);
            if (!fNull) {
                output.writeUTF(this.getSnapshotName());
            }
        }

        static {
            SnapshotListRequest.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            private transient Set __m_Snapshots;
            private Map __m_Stores;

            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$SnapshotListRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public Set getSnapshots() {
                return this.__m_Snapshots;
            }

            public Map getStores() {
                return this.__m_Stores;
            }

            @Override
            protected void onCompletion() {
                Set setSnapshots = this.getSnapshots();
                Map mapStores = this.getStores();
                if (setSnapshots != null) {
                    this.setResult(setSnapshots.toArray(new String[setSnapshots.size()]));
                } else {
                    this.setResult(mapStores);
                }
                super.onCompletion();
            }

            @Override
            public void onResponse(Message msg) {
                Grid.Response msgResponse = (Grid.Response)msg;
                Object[] oResult = null;
                if (msgResponse.getResult() == 0 && (oResult = (Object[])msgResponse.getValue()) != null) {
                    if (SnapshotListRequest.RESPONSE_SNAPSHOTS.equals(oResult[0])) {
                        TreeSet<Object> setSnapshots = this.getSnapshots();
                        if (setSnapshots == null) {
                            setSnapshots = new TreeSet<Object>();
                            this.setSnapshots(setSnapshots);
                        }
                        Object[] asSnapshots = (Object[])oResult[1];
                        int c = asSnapshots.length;
                        for (int i = 0; i < c; ++i) {
                            setSnapshots.add(asSnapshots[i]);
                        }
                    } else {
                        Object[] aoStores;
                        HashMap<Integer, Object[]> mapStores = this.getStores();
                        if (mapStores == null) {
                            mapStores = new HashMap<Integer, Object[]>();
                            this.setStores(mapStores);
                        }
                        if ((aoStores = (Object[])oResult[1]).length > 0) {
                            mapStores.put(msg.getFromMember().getId(), aoStores);
                        }
                    }
                }
                super.onResponse(msg);
            }

            public void setSnapshots(Set setSnapshots) {
                this.__m_Snapshots = setSnapshots;
            }

            public void setStores(Map mapStores) {
                this.__m_Stores = mapStores;
            }
        }
    }

    public static class SnapshotRequest
    extends RequestMessage {
        private int __m_Attempt;
        private PartitionSet __m_Completed;
        private boolean __m_Create;
        private PartitionSet __m_RequestMask;
        private String __m_SnapshotName;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public SnapshotRequest() {
            this(null, null, true);
        }

        public SnapshotRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setAttempt(10);
                this.setMessageType(47);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new SnapshotRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$SnapshotRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            SnapshotRequest msgClone = (SnapshotRequest)super.cloneMessage();
            msgClone.setAttempt(this.getAttempt() - 1);
            msgClone.setCompleted(this.getCompleted());
            msgClone.setCreate(this.isCreate());
            msgClone.setRequestMask(this.getRequestMask());
            msgClone.setSnapshotName(this.getSnapshotName());
            return msgClone;
        }

        public int getAttempt() {
            return this.__m_Attempt;
        }

        public PartitionSet getCompleted() {
            return this.__m_Completed;
        }

        public PartitionSet getRequestMask() {
            return this.__m_RequestMask;
        }

        public String getSnapshotName() {
            return this.__m_SnapshotName;
        }

        @Override
        protected com.tangosol.coherence.component.net.Poll instantiatePoll() {
            return (com.tangosol.coherence.component.net.Poll)this._newChild("Poll");
        }

        public boolean isCreate() {
            return this.__m_Create;
        }

        @Override
        public void onReceived() {
            PartitionedService service = (PartitionedService)this.getService();
            PersistenceControl ctrlPersistence = service.getPersistenceControl();
            if (ctrlPersistence.isValid()) {
                if (this.isCreate()) {
                    ctrlPersistence.createSnapshot(this);
                } else {
                    ctrlPersistence.removeSnapshot(this);
                }
            } else {
                Grid.Response msgResponse = (Grid.Response)service.instantiateMessage("Response");
                msgResponse.respondTo(this);
                msgResponse.setResult(2);
                service.send(msgResponse);
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            PartitionedService service = (PartitionedService)this.getService();
            this.setSnapshotName(input.readUTF());
            this.setCreate(input.readBoolean());
            if (this.isCreate() && service.isVersionCompatible(this.getFromMember(), 12, 2, 1, 2, 0)) {
                PartitionSet partsMask = service.instantiatePartitionSet(false);
                partsMask.readExternal(input);
                if (!partsMask.isEmpty()) {
                    this.setRequestMask(partsMask);
                }
            }
        }

        public void setAttempt(int nAttempt) {
            this.__m_Attempt = nAttempt;
        }

        public void setCompleted(PartitionSet fCreate) {
            this.__m_Completed = fCreate;
        }

        public void setCreate(boolean fCreate) {
            this.__m_Create = fCreate;
        }

        public void setRequestMask(PartitionSet fCreate) {
            this.__m_RequestMask = fCreate;
        }

        public void setSnapshotName(String sName) {
            this.__m_SnapshotName = sName;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            boolean fCreate = this.isCreate();
            output.writeUTF(this.getSnapshotName());
            output.writeBoolean(fCreate);
            if (fCreate) {
                PartitionSet partsMask = this.getRequestMask();
                if (partsMask == null) {
                    partsMask = ((PartitionedService)this.get_Module()).instantiatePartitionSet(false);
                }
                partsMask.writeExternal(output);
            }
        }

        static {
            SnapshotRequest.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            private MemberSet __m_Failures;

            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$SnapshotRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public MemberSet getFailures() {
                return this.__m_Failures;
            }

            @Override
            protected void onCompletion() {
                PartitionedService service = (PartitionedService)this.getService();
                PersistenceControl.SnapshotController ctrlSnapshot = service.getPersistenceControl().getSnapshotController();
                SnapshotRequest msgRequest = (SnapshotRequest)this.get_Parent();
                PartitionSet partsCompleted = msgRequest.getCompleted();
                PartitionSet partsMask = msgRequest.getRequestMask();
                if (partsCompleted != null) {
                    partsMask.remove(partsCompleted);
                }
                if (partsMask == null || partsMask.isEmpty() || msgRequest.getAttempt() <= 0) {
                    MemberSet setFailures = ctrlSnapshot.combineMembersLeft(this.getFailures(), this.getLeftMemberSet());
                    ctrlSnapshot.onSnapshotCompleted(setFailures, partsMask);
                } else {
                    SnapshotRequest msgRepeat = (SnapshotRequest)msgRequest.cloneMessage();
                    msgRepeat.setToMemberSet(service.getOwnershipMemberSet());
                    service.send(msgRepeat);
                }
                super.onCompletion();
            }

            @Override
            public void onResponse(Message msg) {
                SnapshotRequest msgRequest;
                PartitionSet partsAll;
                PartitionSet partsMember;
                Grid.Response msgResponse = (Grid.Response)msg;
                if (msgResponse.getResult() == 2) {
                    MemberSet setFailed = this.getFailures();
                    if (setFailed == null) {
                        setFailed = new MemberSet();
                        this.setFailures(setFailed);
                    }
                    setFailed.add(msg.getFromMember());
                }
                PartitionSet partitionSet = partsMember = (partsAll = (msgRequest = (SnapshotRequest)this.get_Parent()).getCompleted()) == null ? null : (PartitionSet)msgResponse.getValue();
                if (partsMember != null) {
                    partsAll.add(partsMember);
                }
                super.onResponse(msg);
            }

            public void setFailures(MemberSet setFailures) {
                this.__m_Failures = setFailures;
            }
        }
    }

    public static class TransferRequest
    extends RequestMessage {
        private boolean __m_LastInPartition;
        private boolean __m_LastInTransfer;
        private VersionedOwnership __m_Owners;
        private int __m_Partition;
        private long __m_PartitionVersion;
        private Object __m_PendingEvents;
        private LongArray __m_PendingResults;
        private transient Member __m_Recipient;
        private Object __m_Response;
        public static final int RESPONSE_BACKUP = 1;
        public static final int RESPONSE_INCOMPLETE = 0;
        public static final int RESPONSE_REJECT = -1;
        public static final int RESPONSE_RELEASE = -2;
        private int __m_Store;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public TransferRequest() {
            this(null, null, true);
        }

        public TransferRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(34);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new TransferRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$TransferRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public String getDescription() {
            return "Partition=" + this.getPartition() + ", Store=" + this.getStore() + ", Version=" + this.getPartitionVersion() + ", Owners=" + String.valueOf(this.getOwners()) + ", LastInTransfer=" + this.isLastInTransfer();
        }

        public VersionedOwnership getOwners() {
            return this.__m_Owners;
        }

        public int getPartition() {
            return this.__m_Partition;
        }

        public long getPartitionVersion() {
            return this.__m_PartitionVersion;
        }

        public Object getPendingEvents() {
            return this.__m_PendingEvents;
        }

        public LongArray getPendingResults() {
            return this.__m_PendingResults;
        }

        public Member getRecipient() {
            return this.__m_Recipient;
        }

        public Object getResponse() {
            return this.__m_Response;
        }

        public int getStore() {
            return this.__m_Store;
        }

        @Override
        protected com.tangosol.coherence.component.net.Poll instantiatePoll() {
            return (com.tangosol.coherence.component.net.Poll)this._newChild("Poll");
        }

        public boolean isLastInPartition() {
            return this.__m_LastInPartition;
        }

        public boolean isLastInTransfer() {
            return this.__m_LastInTransfer;
        }

        @Override
        public void onReceived() {
            ((PartitionedService)this.getService()).onTransferRequest(this);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setPartition(ExternalizableHelper.readInt(input));
            this.setPartitionVersion(ExternalizableHelper.readLong(input));
            this.setStore(input.readUnsignedByte());
            this.setLastInPartition(input.readBoolean());
            this.setLastInTransfer(input.readBoolean());
            VersionedOwnership owners = new VersionedOwnership();
            owners.readExternal(input);
            this.setOwners(owners);
        }

        public void setLastInPartition(boolean fLast) {
            this.__m_LastInPartition = fLast;
        }

        public void setLastInTransfer(boolean fLast) {
            this.__m_LastInTransfer = fLast;
        }

        public void setOwners(VersionedOwnership owners) {
            this.__m_Owners = owners;
        }

        public void setPartition(int iPartition) {
            this.__m_Partition = iPartition;
        }

        public void setPartitionVersion(long lVersion) {
            this.__m_PartitionVersion = lVersion;
        }

        public void setPendingEvents(Object oEvents) {
            this.__m_PendingEvents = oEvents;
        }

        public void setPendingResults(LongArray arrayResults) {
            this.__m_PendingResults = arrayResults;
        }

        public void setRecipient(Member member) {
            this.__m_Recipient = member;
        }

        public void setResponse(Object oResponse) {
            this.__m_Response = oResponse;
        }

        public void setStore(int nStore) {
            this.__m_Store = nStore;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            ExternalizableHelper.writeInt(output, this.getPartition());
            ExternalizableHelper.writeLong(output, this.getPartitionVersion());
            output.writeByte(this.getStore());
            output.writeBoolean(this.isLastInPartition());
            output.writeBoolean(this.isLastInTransfer());
            this.getOwners().writeExternal(output);
        }

        static {
            TransferRequest.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$TransferRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public String getDescription() {
                return ", Result=" + String.valueOf(this.getResult()) + ", Partition=" + ((TransferRequest)this.get_Parent()).getPartition();
            }

            @Override
            protected void onCompletion() {
                PartitionedService service = (PartitionedService)this.getService();
                Object oResult = this.getResult();
                oResult = oResult == null ? Integer.valueOf(-1) : oResult;
                Integer NResult = oResult instanceof Integer ? (Integer)oResult : null;
                TransferRequest msg = (TransferRequest)this.get_Parent();
                msg.setResponse(oResult);
                if (msg.getStore() == 0 && msg.isLastInTransfer()) {
                    boolean fSuccess = NResult == null;
                    service.onTransferCompleted(fSuccess, oResult, msg);
                } else {
                    service.onTransferRequestCompleted(msg);
                }
                super.onCompletion();
            }

            @Override
            public void onResponse(Message msg) {
                this.setResult(((TransferResponse)msg).getValue());
                super.onResponse(msg);
            }
        }
    }

    public static class TransferResponse
    extends RequestMessage {
        private transient PartitionSet __m_PrimaryPartitions;
        private Object __m_Value;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public TransferResponse() {
            this(null, null, true);
        }

        public TransferResponse(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(38);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new TransferResponse();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$TransferResponse".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public PartitionSet getPrimaryPartitions() {
            return this.__m_PrimaryPartitions;
        }

        public Object getValue() {
            return this.__m_Value;
        }

        @Override
        protected com.tangosol.coherence.component.net.Poll instantiatePoll() {
            return (com.tangosol.coherence.component.net.Poll)this._newChild("Poll");
        }

        @Override
        public void onReceived() {
            PartitionedService service = (PartitionedService)this.getService();
            Grid.Response msgResponse = (Grid.Response)service.instantiateMessage("Response");
            msgResponse.respondTo(this);
            service.post(msgResponse);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            this.setValue(this.readObject(input));
        }

        public void setPrimaryPartitions(PartitionSet parts) {
            this.__m_PrimaryPartitions = parts;
        }

        public void setValue(Object oValue) {
            this.__m_Value = oValue;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            this.writeObject(output, this.getValue());
        }

        static {
            TransferResponse.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$TransferResponse$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected void onCompletion() {
                TransferResponse msgResponse = (TransferResponse)this.get_Parent();
                PartitionSet parts = msgResponse.getPrimaryPartitions();
                if (parts != null) {
                    PartitionedService service = (PartitionedService)this.getService();
                    PartitionControl[] aControl = service.getPartitionControl();
                    int iPart = parts.next(0);
                    while (iPart >= 0) {
                        aControl[iPart].enableTransfer();
                        iPart = parts.next(iPart + 1);
                    }
                }
            }
        }
    }

    public static class PartitionConfig
    extends ServiceConfig {
        public static final Integer KEY_QUORUM;
        public static final int TYPE_ANY = 0;
        public static final int TYPE_BINARY = 3;
        public static final int TYPE_INT = 1;
        public static final int TYPE_OWNERSHIP = 2;

        public PartitionConfig() {
            this(null, null, true);
        }

        public PartitionConfig(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setPendingConfigUpdates(new LinkedList());
                this.setPendingPolls(new LiteMap());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new ConfigListener("ConfigListener", this, true), "ConfigListener");
            this._addChild(new Map("Map", this, true), "Map");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PartitionConfig();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionConfig".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public Member getConfigCoordinator() {
            PartitionedService service = (PartitionedService)this.getService();
            return service.isAcceptingOthers() ? service.getOwnershipSenior(true) : null;
        }

        public boolean isPartition(int iPart) {
            return iPart >= 0;
        }

        @Override
        public void onMissingCoordinator() {
        }

        @Override
        public Object readObject(DataInput in) throws IOException {
            byte nType = in.readByte();
            switch (nType) {
                case 2: {
                    VersionedOwnership owners = new VersionedOwnership();
                    owners.readExternal(in);
                    return owners;
                }
                case 1: {
                    return in.readInt();
                }
                case 3: {
                    return new Binary(in);
                }
                case 0: {
                    return super.readObject(in);
                }
            }
            throw new IOException("invalid type: " + nType);
        }

        @Override
        public void writeObject(DataOutput out, Object o) throws IOException {
            if (o instanceof Ownership) {
                out.write(2);
                ((Ownership)o).writeExternal(out);
            } else if (o instanceof Integer) {
                out.write(1);
                out.writeInt((Integer)o);
            } else if (o instanceof Binary) {
                out.write(3);
                ((Binary)o).writeExternal(out);
            } else {
                out.write(0);
                super.writeObject(out, o);
            }
        }

        static {
            try {
                KEY_QUORUM = new Integer(-1);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
        }

        public static class ConfigListener
        extends ServiceConfig.ConfigListener {
            public ConfigListener() {
                this(null, null, true);
            }

            public ConfigListener(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ConfigListener();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionConfig$ConfigListener".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public void entryDeleted(MapEvent evt) {
                int iKey;
                Object oKey = evt.getKey();
                if (oKey instanceof Integer && (iKey = ((Integer)oKey).intValue()) >= 0) {
                    throw new IllegalStateException("Partition info is not removable:" + String.valueOf(evt));
                }
            }

            @Override
            public void entryInserted(MapEvent evt) {
                this.onInsertOrUpdate(evt);
            }

            @Override
            public void entryUpdated(MapEvent evt) {
                this.onInsertOrUpdate(evt);
            }

            protected void onInsertOrUpdate(MapEvent evt) {
                PartitionedService service = (PartitionedService)this.get_Module();
                Object oKey = evt.getKey();
                if (oKey instanceof Integer) {
                    Binary binQuorum;
                    int iKey = (Integer)oKey;
                    if (iKey >= 0) {
                        if (!Base.equals(evt.getOldValue(), evt.getNewValue())) {
                            service.onPartitionConfigUpdate(evt);
                        }
                    } else if (iKey == KEY_QUORUM && service.isOwnershipEnabled() && (binQuorum = (Binary)evt.getNewValue()) != null) {
                        service.getPersistenceControl().setQuorumRaw(binQuorum);
                    }
                }
            }
        }

        public static class Map
        extends ServiceConfig.Map {
            private PartitionSet __m_InitializedPartitions;
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("EntrySet", EntrySet.get_CLASS());
                __mapChildren.put("KeySet", KeySet.get_CLASS());
                __mapChildren.put("Values", Values.get_CLASS());
            }

            public Map() {
                this(null, null, true);
            }

            public Map(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Map();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionConfig$Map".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected java.util.Map get_ChildClasses() {
                return __mapChildren;
            }

            protected PartitionSet getInitializedPartitions() {
                PartitionSet parts = this.__m_InitializedPartitions;
                if (parts == null) {
                    PartitionedService service = (PartitionedService)this.get_Module();
                    parts = new PartitionSet(service.getPartitionCount());
                    this.setInitializedPartitions(parts);
                }
                return parts;
            }

            @Override
            public int getMapType() {
                return 2;
            }

            public void initializePartitions() {
                PartitionSet partsInit = this.getInitializedPartitions();
                for (Map.Entry entry : this.entrySet()) {
                    Ownership owners;
                    int iPart = (Integer)entry.getKey();
                    if (iPart < 0 || (owners = (Ownership)entry.getValue()).getPrimaryOwner() == 0) continue;
                    partsInit.add(iPart);
                }
            }

            public boolean isAssignmentCompleted() {
                return this.getInitializedPartitions().isFull();
            }

            public boolean isAssignmentCompleted(int nPartition) {
                return this.getInitializedPartitions().contains(nPartition);
            }

            protected void setInitializedPartitions(PartitionSet parts) {
                this.__m_InitializedPartitions = parts;
            }

            @Override
            public Object updateInternal(Object oKey, Object oValue, boolean fRemove) {
                int iPart;
                PartitionConfig config;
                if (this.getService().isAcceptingClients() && !this.isAssignmentCompleted() && (config = (PartitionConfig)this.get_Parent()).isPartition(iPart = ((Integer)oKey).intValue()) && ((Ownership)oValue).getPrimaryOwner() != 0) {
                    this.getInitializedPartitions().add(iPart);
                }
                return super.updateInternal(oKey, oValue, fRemove);
            }

            static {
                Map.__initStatic();
            }

            public static class EntrySet
            extends ServiceConfig.Map.EntrySet {
                private static ListMap __mapChildren;

                private static void __initStatic() {
                    __mapChildren = new ListMap();
                    __mapChildren.put("Entry", Entry.get_CLASS());
                    __mapChildren.put("Iterator", Iterator.get_CLASS());
                }

                public EntrySet() {
                    this(null, null, true);
                }

                public EntrySet(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new EntrySet();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionConfig$Map$EntrySet".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                @Override
                protected java.util.Map get_ChildClasses() {
                    return __mapChildren;
                }

                static {
                    EntrySet.__initStatic();
                }

                public static class Entry
                extends ServiceConfig.Map.EntrySet.Entry {
                    public Entry() {
                        this(null, null, true);
                    }

                    public Entry(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Entry();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionConfig$Map$EntrySet$Entry".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }

                public static class Iterator
                extends ServiceConfig.Map.EntrySet.Iterator {
                    public Iterator() {
                        this(null, null, true);
                    }

                    public Iterator(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Iterator();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionConfig$Map$EntrySet$Iterator".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }
            }

            public static class KeySet
            extends ServiceConfig.Map.KeySet {
                private static ListMap __mapChildren;

                private static void __initStatic() {
                    __mapChildren = new ListMap();
                    __mapChildren.put("Iterator", Iterator.get_CLASS());
                }

                public KeySet() {
                    this(null, null, true);
                }

                public KeySet(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new KeySet();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionConfig$Map$KeySet".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                @Override
                protected java.util.Map get_ChildClasses() {
                    return __mapChildren;
                }

                static {
                    KeySet.__initStatic();
                }

                public static class Iterator
                extends ServiceConfig.Map.KeySet.Iterator {
                    public Iterator() {
                        this(null, null, true);
                    }

                    public Iterator(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Iterator();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionConfig$Map$KeySet$Iterator".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }
            }

            public static class Values
            extends ServiceConfig.Map.Values {
                private static ListMap __mapChildren;

                private static void __initStatic() {
                    __mapChildren = new ListMap();
                    __mapChildren.put("Iterator", Iterator.get_CLASS());
                }

                public Values() {
                    this(null, null, true);
                }

                public Values(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Values();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionConfig$Map$Values".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                @Override
                protected java.util.Map get_ChildClasses() {
                    return __mapChildren;
                }

                static {
                    Values.__initStatic();
                }

                public static class Iterator
                extends ServiceConfig.Map.Values.Iterator {
                    public Iterator() {
                        this(null, null, true);
                    }

                    public Iterator(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Iterator();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionConfig$Map$Values$Iterator".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }
            }
        }
    }

    public static class Continuations
    extends Util {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Continuation", Continuation.get_CLASS());
            __mapChildren.put("Message", Message.get_CLASS());
            __mapChildren.put("Task", Task.get_CLASS());
        }

        public Continuations() {
            this(null, null, true);
        }

        public Continuations(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Continuations();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$Continuations".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        protected com.oracle.coherence.common.base.Continuation instantiate(int nType, Object oContext, com.oracle.coherence.common.base.Continuation contNext) {
            Continuation continuation = new Continuation();
            this._linkChild(continuation);
            continuation.setType(nType);
            continuation.setContext(oContext);
            continuation.setNext(contNext);
            return continuation;
        }

        public com.oracle.coherence.common.base.Continuation instantiateActivePersistenceError() {
            return this.instantiate(9, null, null);
        }

        public com.oracle.coherence.common.base.Continuation instantiateFinalizeAssignPrimaries(Map mapConfig, com.tangosol.coherence.component.net.Message msgResponse) {
            return this.instantiate(6, mapConfig, this.instantiateMessagePost(msgResponse));
        }

        public com.oracle.coherence.common.base.Continuation instantiateFinalizeReceivePrimary(TransferRequest msgTransfer) {
            return this.instantiate(1, msgTransfer, null);
        }

        public com.oracle.coherence.common.base.Continuation instantiateFinalizeRecoverPrimary(PartitionRecoverInfo info) {
            return this.instantiate(7, info, null);
        }

        public com.oracle.coherence.common.base.Continuation instantiateFinalizeRestorePrimaries(OwnershipRequest msgRequest, Map mapConfig) {
            return this.instantiate(5, new Object[]{msgRequest, mapConfig}, null);
        }

        public com.oracle.coherence.common.base.Continuation instantiateFinalizeSendPrimary(PartitionSet parts) {
            return this.instantiate(4, parts, null);
        }

        public com.oracle.coherence.common.base.Continuation instantiateFinalizeTransferPrimary(TransferRequest msgRequest) {
            return this.instantiate(12, msgRequest, null);
        }

        public com.oracle.coherence.common.base.Continuation instantiateMessagePost(List listMessage) {
            return this.instantiate(2, listMessage, null);
        }

        public com.oracle.coherence.common.base.Continuation instantiateMessagePost(com.tangosol.coherence.component.net.Message msg) {
            return this.instantiate(2, msg, null);
        }

        public com.oracle.coherence.common.base.Continuation instantiatePersistenceErrorHandler(com.oracle.coherence.common.base.Continuation continuation) {
            return this.instantiate(10, null, continuation);
        }

        public com.oracle.coherence.common.base.Continuation instantiateTaskDispatch(Runnable task) {
            return this.instantiate(3, task, null);
        }

        public com.oracle.coherence.common.base.Continuation thenOnServiceThread(com.oracle.coherence.common.base.Continuation continuation) {
            return this.instantiate(8, null, continuation);
        }

        public com.oracle.coherence.common.base.Continuation wrapAsMessage(com.oracle.coherence.common.base.Continuation continuation) {
            Message msg = new Message();
            msg.setContinuation(continuation);
            msg.addToMember(((PartitionedService)this.get_Module()).getThisMember());
            return this.instantiateMessagePost(msg);
        }

        public com.oracle.coherence.common.base.Continuation wrapAsTask(com.oracle.coherence.common.base.Continuation continuation) {
            Task task = new Task();
            task.setContinuation(continuation);
            return this.instantiateTaskDispatch(task);
        }

        static {
            Continuations.__initStatic();
        }

        public static class Continuation
        extends Util
        implements com.oracle.coherence.common.base.Continuation {
            private volatile Object __m_Context;
            private com.oracle.coherence.common.base.Continuation __m_Next;
            private int __m_Type;
            public static final int TYPE_ACTIVE_PERSISTENCE_ERROR = 9;
            public static final int TYPE_FINALIZE_ASSIGN_PRIMARY = 6;
            public static final int TYPE_FINALIZE_RECEIVE_PRIMARY = 1;
            public static final int TYPE_FINALIZE_RECOVER_PRIMARY = 7;
            public static final int TYPE_FINALIZE_RESTORE_PRIMARY = 5;
            public static final int TYPE_FINALIZE_SEND_PRIMARY = 4;
            public static final int TYPE_FINALIZE_TRANSFER_PRIMARY = 12;
            public static final int TYPE_INVOKE_ON_SERVICE_THREAD = 8;
            public static final int TYPE_MESSAGE_POST = 2;
            public static final int TYPE_PERSISTENCE_ERROR_HANDLER = 10;
            public static final int TYPE_TASK_DISPATCH = 3;

            public Continuation() {
                this(null, null, true);
            }

            public Continuation(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Continuation();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$Continuations$Continuation".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public Object getContext() {
                return this.__m_Context;
            }

            public com.oracle.coherence.common.base.Continuation getNext() {
                return this.__m_Next;
            }

            public int getType() {
                return this.__m_Type;
            }

            public void proceed(Object oResult) {
                PartitionedService service = (PartitionedService)this.get_Module();
                Object oContext = this.getContext();
                switch (this.getType()) {
                    case 10: {
                        PersistentStore<?> store;
                        PersistenceException e = (PersistenceException)oResult;
                        PersistentStore<?> persistentStore = store = e == null ? null : e.getPersistentStore();
                        if (store != null && !service.isRecovering(GUIDHelper.getPartition(store.getId()))) {
                            if (Thread.currentThread() != service.getThread()) {
                                this.setNext(((Continuations)this.get_Parent()).wrapAsMessage(this.getNext()));
                            }
                            this.proceedNext(oResult);
                            break;
                        }
                    }
                    case 9: {
                        service.getPersistenceControl().onActivePersistenceFailure((PersistenceException)oResult);
                        this.proceedNext(oResult);
                        break;
                    }
                    case 6: {
                        service.onFinalizeAssignPrimary((Map)oContext);
                        this.proceedNext(oResult);
                        break;
                    }
                    case 1: {
                        service.onFinalizeReceivePrimary((TransferRequest)oContext);
                        this.proceedNext(oResult);
                        break;
                    }
                    case 5: {
                        Object[] aoResult = (Object[])oContext;
                        service.onFinalizeRestorePrimary((OwnershipRequest)aoResult[0], (Map)aoResult[1]);
                        break;
                    }
                    case 7: {
                        PartitionRecoverInfo info = (PartitionRecoverInfo)oContext;
                        service.onFinalizeRecoverPrimary(info);
                        break;
                    }
                    case 4: {
                        service.onFinalizeSendPrimary((PartitionSet)oContext);
                        this.proceedNext(oResult);
                        break;
                    }
                    case 12: {
                        service.onTransferRequestCompleted((TransferRequest)oContext);
                        this.proceedNext(oResult);
                        break;
                    }
                    case 8: {
                        if (Thread.currentThread() != service.getThread()) {
                            this.setNext(((Continuations)this.get_Parent()).wrapAsMessage(this.getNext()));
                        }
                        this.proceedNext(oResult);
                        break;
                    }
                    case 2: {
                        if (oContext instanceof com.tangosol.coherence.component.net.Message) {
                            if (oContext instanceof Message) {
                                ((Message)oContext).setResult(oResult);
                            }
                            service.send((com.tangosol.coherence.component.net.Message)oContext);
                            break;
                        }
                        if (!(oContext instanceof List)) break;
                        for (com.tangosol.coherence.component.net.Message msg : (List)oContext) {
                            service.post(msg);
                        }
                        service.flush();
                        break;
                    }
                    case 3: {
                        if (oContext instanceof Task) {
                            ((Task)oContext).setResult(oResult);
                        }
                        service.ensureEventDispatcher().getQueue().add(oContext);
                        break;
                    }
                    default: {
                        Continuation._assert(false);
                    }
                }
            }

            protected void proceedNext(Object oResult) {
                com.oracle.coherence.common.base.Continuation contNext = this.getNext();
                if (contNext != null) {
                    contNext.proceed(oResult);
                }
            }

            public void setContext(Object oContext) {
                this.__m_Context = oContext;
            }

            public void setNext(com.oracle.coherence.common.base.Continuation continuationNext) {
                this.__m_Next = continuationNext;
            }

            public void setType(int nType) {
                this.__m_Type = nType;
            }
        }

        public static class Message
        extends com.tangosol.coherence.component.net.Message {
            private com.oracle.coherence.common.base.Continuation __m_Continuation;
            private Object __m_Result;

            public Message() {
                this(null, null, true);
            }

            public Message(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Message();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$Continuations$Message".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public com.oracle.coherence.common.base.Continuation getContinuation() {
                return this.__m_Continuation;
            }

            public Object getResult() {
                return this.__m_Result;
            }

            @Override
            public void onReceived() {
                com.oracle.coherence.common.base.Continuation continuation = this.getContinuation();
                if (continuation != null) {
                    continuation.proceed(this.getResult());
                }
            }

            public void setContinuation(com.oracle.coherence.common.base.Continuation continuation) {
                this.__m_Continuation = continuation;
            }

            public void setResult(Object oResult) {
                this.__m_Result = oResult;
            }
        }

        public static class Task
        extends Util
        implements Runnable {
            private com.oracle.coherence.common.base.Continuation __m_Continuation;
            private Object __m_Result;

            public Task() {
                this(null, null, true);
            }

            public Task(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Task();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$Continuations$Task".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public com.oracle.coherence.common.base.Continuation getContinuation() {
                return this.__m_Continuation;
            }

            public Object getResult() {
                return this.__m_Result;
            }

            @Override
            public void run() {
                com.oracle.coherence.common.base.Continuation continuation = this.getContinuation();
                if (continuation != null) {
                    continuation.proceed(this.getResult());
                }
            }

            public void setContinuation(com.oracle.coherence.common.base.Continuation continuation) {
                this.__m_Continuation = continuation;
            }

            public void setResult(Object oResult) {
                this.__m_Result = oResult;
            }
        }
    }

    public static class TransferControl
    extends Component {
        private RequestMessage __m_DistributionRequest;
        private Map __m_IncomingTransfers;
        private PrimitiveSparseArray __m_PartitionsOut;
        private Member __m_ToMember;
        private int __m_TransferCountLimit;
        private long __m_TransferredBytes;
        private long __m_TransferSizeLimit;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("TransferIterator", TransferIterator.get_CLASS());
        }

        public TransferControl() {
            this(null, null, true);
        }

        public TransferControl(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setIncomingTransfers(new HashMap());
                this.setPartitionsOut(new PrimitiveSparseArray());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new TransferControl();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$TransferControl".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public void cancelTransmit(int iPartition) {
        }

        public void finalizeReceive(TransferRequest msgTransferLast) {
        }

        public void finalizeReceivePartition(int iPartition, List listXferRequests) {
            for (TransferRequest msgTransfer : listXferRequests) {
                if (!msgTransfer.isLastInPartition()) continue;
                this.finalizeReceive(msgTransfer);
            }
        }

        protected void finalizeTransmit(TransferRequest msgTransferLast) {
            this.setTransferState(msgTransferLast.getPartition(), 2);
        }

        public RequestMessage getDistributionRequest() {
            return this.__m_DistributionRequest;
        }

        public Map getIncomingTransfers() {
            return this.__m_IncomingTransfers;
        }

        public PartitionControl getPartitionControl(int idx) {
            return ((PartitionedService)this.get_Module()).getPartitionControl(idx);
        }

        public PrimitiveSparseArray getPartitionsOut() {
            return this.__m_PartitionsOut;
        }

        public List getQueuedTransfers(Member member) {
            return (List)this.getIncomingTransfers().get(member);
        }

        public Member getToMember() {
            return this.__m_ToMember;
        }

        public int getTransferCount() {
            return this.getPartitionsOut().getSize();
        }

        public int getTransferCountLimit() {
            return this.__m_TransferCountLimit;
        }

        public long getTransferredBytes() {
            return this.__m_TransferredBytes;
        }

        public long getTransferSizeLimit() {
            return this.__m_TransferSizeLimit;
        }

        public boolean isIncomingTransfer(Member member) {
            return this.getIncomingTransfers().containsKey(member);
        }

        public boolean isIncompleteTransfer(Member member) {
            List listXfers = (List)this.getIncomingTransfers().get(member);
            if (listXfers == null || listXfers.isEmpty()) {
                return false;
            }
            TransferRequest msgXferLast = (TransferRequest)listXfers.get(listXfers.size() - 1);
            return !msgXferLast.isLastInTransfer();
        }

        public boolean isInProgress() {
            return this.getDistributionRequest() != null || this.getTransferCount() > 0;
        }

        public boolean isTransferFull() {
            return this.getTransferredBytes() >= this.getTransferSizeLimit() || this.getTransferCount() >= this.getTransferCountLimit();
        }

        public boolean isTransferInProgress(int iPartition) {
            return this.getPartitionsOut().exists(iPartition);
        }

        public TransferIterator iterateTransfersInProgress() {
            return (TransferIterator)this._newChild("TransferIterator");
        }

        public void onMemberLeft(Member member) {
            if (this.isIncompleteTransfer(member)) {
                this.onReceiveRollback(member);
            }
        }

        public void onReceiveCommitted(TransferRequest msgLastTransfer) {
            TransferControl._assert(msgLastTransfer.isLastInTransfer());
            this.getIncomingTransfers().remove(msgLastTransfer.getFromMember());
        }

        public void onReceiveRollback(Member memberSender) {
            this.getIncomingTransfers().remove(memberSender);
            this.finalizeReceive(null);
        }

        public void onReceiveStarted(TransferRequest msgRequest, Continuation continuation) {
            Member memberFrom = msgRequest.getFromMember();
            Map mapQueues = this.getIncomingTransfers();
            ArrayList<TransferRequest> listXfers = (ArrayList<TransferRequest>)mapQueues.get(memberFrom);
            if (listXfers == null) {
                listXfers = new ArrayList<TransferRequest>();
                mapQueues.put(memberFrom, listXfers);
            }
            listXfers.add(msgRequest);
            if (continuation != null) {
                continuation.proceed(null);
            }
        }

        public void onTransmitCommitted(TransferRequest msgLastTransfer) {
            this.finalizeTransmit(msgLastTransfer);
        }

        public void onTransmitCompleted(int iPartition, int iStore) {
            PrimitiveSparseArray saInProgress = this.getPartitionsOut();
            this.setTransferState(iPartition, 0);
            int iStoreXfer = (int)saInProgress.removePrimitive(iPartition);
            TransferControl._assert(iStoreXfer == iStore);
            if (saInProgress.isEmpty()) {
                this.reset();
            }
        }

        public void onTransmitRejected(int iPartition, int iStore) {
            this.setTransferState(iPartition, 0);
            PrimitiveSparseArray saInProgress = this.getPartitionsOut();
            int iStoreXfer = (int)saInProgress.removePrimitive(iPartition);
            TransferControl._assert(iStoreXfer == iStore);
            if (iStore == 0) {
                this.cancelTransmit(iPartition);
            }
            if (saInProgress.isEmpty()) {
                this.reset();
            }
        }

        public void prepareBackupTransfer(Member member, long cbLimit, int cPartitionLimit) {
            TransferControl._assert(!this.isInProgress());
            this.setDistributionRequest(null);
            this.setToMember(member);
            this.setTransferSizeLimit(cbLimit);
            this.setTransferCountLimit(cPartitionLimit);
        }

        public void preparePrimaryTransfer(RequestMessage msgRequest, long cbLimit) {
            TransferControl._assert(!this.isInProgress());
            this.setDistributionRequest(msgRequest);
            this.setToMember(msgRequest.getFromMember());
            this.setTransferSizeLimit(cbLimit);
            this.setTransferCountLimit(Integer.MAX_VALUE);
        }

        public boolean recordTransfer(TransferRequest msgTransfer, long cbTransfer) {
            RequestMessage msgRequest = this.getDistributionRequest();
            Member member = this.getToMember();
            msgTransfer.setRecipient(member);
            if (msgRequest == null) {
                msgTransfer.addToMember(member);
            } else {
                msgTransfer.respondTo(msgRequest);
            }
            int iPartition = msgTransfer.getPartition();
            int iStore = msgTransfer.getStore();
            this.setTransferredBytes(this.getTransferredBytes() + cbTransfer);
            this.getPartitionsOut().setPrimitive(iPartition, iStore);
            this.setTransferState(iPartition, 1);
            return this.isTransferFull();
        }

        public void requestBackupConfirmation(int iPartition, int iStore, int nMemberDeparted, Member memberTo) {
            TransferControl._assert(iStore > 0);
            TransferControl._trace("Sending backup[" + iStore + "] confirmation to member " + memberTo.getId() + " for partition " + iPartition, 3);
            PartitionedService service = (PartitionedService)this.get_Module();
            BackupConfirmRequest msg = (BackupConfirmRequest)service.instantiateMessage("BackupConfirmRequest");
            this.getPartitionControl(iPartition).preventTransfer();
            msg.setPartition(iPartition);
            msg.setStore(iStore);
            msg.setDepartedMemberId(nMemberDeparted);
            msg.addToMember(memberTo);
            service.post(msg);
        }

        protected void reset() {
            this.setDistributionRequest(null);
            this.getPartitionsOut().clear();
            this.setToMember(null);
            this.setTransferCountLimit(0);
            this.setTransferredBytes(0L);
            PartitionControl[] aCtrlPartition = ((PartitionedService)this.get_Module()).getPartitionControl();
            int cPartitions = aCtrlPartition.length;
            for (int i = 0; i < cPartitions; ++i) {
                PartitionControl ctrlPartition = aCtrlPartition[i];
                if (ctrlPartition == null || ctrlPartition.getTransferState() == 0) continue;
                TransferControl._trace("Partition " + i + " is in an unexpected transfer state; recovering.", 3);
                ctrlPartition.setTransferState(0);
            }
        }

        public void sendBackupAnnounce(int iPartition, int iStore, Member memberTo, BackupConfirmRequest msgRequest) {
            TransferControl._assert(iStore != 0);
            PartitionedService service = (PartitionedService)this.get_Module();
            BackupAssignment msg = (BackupAssignment)service.instantiateMessage("BackupAssignment");
            msg.setPartition(iPartition);
            msg.setStore(iStore);
            msg.setRelease(false);
            if (msgRequest == null) {
                msg.addToMember(memberTo);
            } else {
                msg.respondTo(msgRequest);
            }
            service.post(msg);
        }

        public void sendBackupRelease(int iPartition, int iStore, int nOwnerPrimary, int nOwnerNew, Member memberTo, BackupConfirmRequest msgRequest) {
            TransferControl._assert(iStore > 0);
            PartitionedService service = (PartitionedService)this.get_Module();
            BackupAssignment msg = (BackupAssignment)service.instantiateMessage("BackupAssignment");
            msg.setPartition(iPartition);
            msg.setStore(iStore);
            msg.setRelease(true);
            msg.setNewBackupOwner(nOwnerNew);
            msg.setPrimaryOwner(nOwnerPrimary);
            if (msgRequest == null) {
                msg.addToMember(memberTo);
            } else {
                msg.respondTo(msgRequest);
            }
            service.post(msg);
        }

        protected void setDistributionRequest(RequestMessage msgRequest) {
            this.__m_DistributionRequest = msgRequest;
        }

        protected void setIncomingTransfers(Map laQueues) {
            this.__m_IncomingTransfers = laQueues;
        }

        protected void setPartitionsOut(PrimitiveSparseArray saInProgress) {
            this.__m_PartitionsOut = saInProgress;
        }

        protected void setToMember(Member member) {
            this.__m_ToMember = member;
        }

        protected void setTransferCountLimit(int cTransfer) {
            this.__m_TransferCountLimit = cTransfer;
        }

        protected void setTransferredBytes(long cbTransfer) {
            this.__m_TransferredBytes = cbTransfer;
        }

        protected void setTransferSizeLimit(long cbLimit) {
            this.__m_TransferSizeLimit = cbLimit;
        }

        protected void setTransferState(int nPartition, int nState) {
            this.getPartitionControl(nPartition).setTransferState(nState);
        }

        static {
            TransferControl.__initStatic();
        }

        public static class TransferIterator
        extends Component {
            private int __m_Backup;
            private PrimitiveSparseArray.Iterator __m_Iterator;
            private int __m_NextBackup;
            private int __m_NextPartition;
            private int __m_Partition;

            public TransferIterator() {
                this(null, null, true);
            }

            public TransferIterator(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setBackup(-1);
                    this.setNextBackup(-1);
                    this.setNextPartition(-1);
                    this.setPartition(-1);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new TransferIterator();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$TransferControl$TransferIterator".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            protected void advance() {
                PrimitiveSparseArray.Iterator iter = this.getIterator();
                if (iter == null) {
                    throw new NoSuchElementException();
                }
                if (iter.hasNext()) {
                    this.setNextBackup((int)iter.nextPrimitive());
                    this.setNextPartition((int)iter.getIndex());
                } else {
                    this.setIterator(null);
                }
            }

            public int getBackup() {
                return this.__m_Backup;
            }

            public PrimitiveSparseArray.Iterator getIterator() {
                return this.__m_Iterator;
            }

            public int getNextBackup() {
                return this.__m_NextBackup;
            }

            public int getNextPartition() {
                return this.__m_NextPartition;
            }

            public int getPartition() {
                return this.__m_Partition;
            }

            public boolean hasNext() {
                return this.getIterator() != null;
            }

            public void next() {
                this.setPartition(this.getNextPartition());
                this.setBackup(this.getNextBackup());
                this.advance();
            }

            @Override
            public void onInit() {
                TransferControl control = (TransferControl)this.get_Parent();
                this.setIterator(control.getPartitionsOut().iterator());
                this.advance();
            }

            protected void setBackup(int nBackup) {
                this.__m_Backup = nBackup;
            }

            protected void setIterator(PrimitiveSparseArray.Iterator iter) {
                this.__m_Iterator = iter;
            }

            protected void setNextBackup(int nBackup) {
                this.__m_NextBackup = nBackup;
            }

            protected void setNextPartition(int iPartition) {
                this.__m_NextPartition = iPartition;
            }

            protected void setPartition(int nPartition) {
                this.__m_Partition = nPartition;
            }
        }
    }

    public class MaintenanceTask
    implements Runnable {
        @Override
        public void run() {
            try {
                PersistenceManager manager = PartitionedService.this.getPersistenceManager();
                if (manager != null) {
                    manager.maintainEnvironment();
                }
            }
            finally {
                PartitionedService.this.scheduleEnvironmentMaintenance();
            }
        }
    }

    public static class MemberConfigListener
    extends Grid.MemberConfigListener {
        public MemberConfigListener() {
            this(null, null, true);
        }

        public MemberConfigListener(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MemberConfigListener();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$MemberConfigListener".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void onEvent(MapEvent event) {
            super.onEvent(event);
        }
    }

    public static class DaemonPool
    extends Grid.DaemonPool {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Daemon", Grid.DaemonPool.Daemon.get_CLASS());
            __mapChildren.put("ResizeTask", Service.DaemonPool.ResizeTask.get_CLASS());
            __mapChildren.put("ScheduleTask", Service.DaemonPool.ScheduleTask.get_CLASS());
            __mapChildren.put("StartTask", Service.DaemonPool.StartTask.get_CLASS());
            __mapChildren.put("StopTask", Service.DaemonPool.StopTask.get_CLASS());
            __mapChildren.put("WorkSlot", Service.DaemonPool.WorkSlot.get_CLASS());
            __mapChildren.put("WrapperTask", WrapperTask.get_CLASS());
        }

        public DaemonPool() {
            this(null, null, true);
        }

        public DaemonPool(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setAbandonThreshold(8);
                this.setDaemonCountMax(Integer.MAX_VALUE);
                this.setDaemonCountMin(1);
                this.setScheduledTasks(new HashSet());
                this.setStatsTaskAddCount(new AtomicLong());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new DaemonPool();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$DaemonPool".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        protected DaemonPool.WrapperTask instantiateWrapperTask() {
            WrapperTask task = new WrapperTask();
            this._linkChild(task);
            return task;
        }

        static {
            DaemonPool.__initStatic();
        }

        public static class WrapperTask
        extends Service.DaemonPool.WrapperTask {
            public WrapperTask() {
                this(null, null, true);
            }

            public WrapperTask(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new WrapperTask();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$DaemonPool$WrapperTask".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public void run() {
                super.run();
                this.updatePartitionStats();
            }

            protected void updatePartitionStats() {
                Runnable task = this.getTask();
                int nPartition = -1;
                PartitionSet parts = null;
                long ldtArrived = 0L;
                if (task instanceof PartialJob) {
                    nPartition = ((PartialJob)task).getPartition();
                    ldtArrived = this.getPostTime();
                } else if (task instanceof DistributedCacheKeyRequest) {
                    nPartition = ((DistributedCacheKeyRequest)task).getProcessedPartition();
                    ldtArrived = this.getPostTime();
                } else if (task instanceof DistributedCacheRequest) {
                    parts = ((DistributedCacheRequest)task).getProcessedPartitions();
                    ldtArrived = this.getPostTime();
                } else {
                    return;
                }
                PartitionedService service = (PartitionedService)this.get_Module();
                long ldtNow = Base.getLastSafeTimeMillis();
                long cExecMillis = ldtNow - this.getStartTime();
                long cWaitMillis = ldtNow - ldtArrived;
                if (nPartition >= 0) {
                    PartitionControl ctrl = service.getPartitionControl(nPartition);
                    if (ctrl != null) {
                        ctrl.getStatistics().recordRequest(cWaitMillis, cExecMillis);
                    }
                } else if (parts != null) {
                    PartitionControl[] actrlPartition = service.getPartitionControl();
                    nPartition = parts.next(0);
                    while (nPartition >= 0) {
                        PartitionControl ctrl = actrlPartition[nPartition];
                        if (ctrl != null) {
                            ctrl.getStatistics().recordRequest(cWaitMillis, cExecMillis);
                        }
                        nPartition = parts.next(nPartition + 1);
                    }
                }
            }
        }
    }
}

