/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.oracle.coherence.common.base.Associated;
import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.common.base.NonBlocking;
import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.WindowedArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.internal.net.service.DefaultServiceDependencies;
import com.tangosol.internal.net.service.grid.DefaultInvocationServiceDependencies;
import com.tangosol.internal.net.service.grid.InvocationServiceDependencies;
import com.tangosol.internal.net.service.grid.LegacyXmlGridHelper;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.Invocable;
import com.tangosol.net.InvocableInOrder;
import com.tangosol.net.InvocationObserver;
import com.tangosol.net.NonBlockingInvocable;
import com.tangosol.net.PriorityTask;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.ListMap;
import com.tangosol.util.LiteMap;
import com.tangosol.util.SimpleResourceRegistry;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class InvocationService
extends Grid
implements com.tangosol.net.InvocationService {
    private transient Map __m_PendingProcess;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Acknowledgement", Grid.Acknowledgement.get_CLASS());
        __mapChildren.put("BusEventMessage", Grid.BusEventMessage.get_CLASS());
        __mapChildren.put("ConfigRequest", Grid.ConfigRequest.get_CLASS());
        __mapChildren.put("ConfigResponse", Grid.ConfigResponse.get_CLASS());
        __mapChildren.put("ConfigSync", Grid.ConfigSync.get_CLASS());
        __mapChildren.put("ConfigUpdate", Grid.ConfigUpdate.get_CLASS());
        __mapChildren.put("DispatchEvent", Grid.DispatchEvent.get_CLASS());
        __mapChildren.put("DispatchNotification", Grid.DispatchNotification.get_CLASS());
        __mapChildren.put("InvocationMessage", InvocationMessage.get_CLASS());
        __mapChildren.put("InvocationRequest", InvocationRequest.get_CLASS());
        __mapChildren.put("InvocationResponse", InvocationResponse.get_CLASS());
        __mapChildren.put("MemberConfigUpdate", Grid.MemberConfigUpdate.get_CLASS());
        __mapChildren.put("MemberJoined", Grid.MemberJoined.get_CLASS());
        __mapChildren.put("MemberWelcome", Grid.MemberWelcome.get_CLASS());
        __mapChildren.put("MemberWelcomeRequest", Grid.MemberWelcomeRequest.get_CLASS());
        __mapChildren.put("MemberWelcomeRequestTask", Grid.MemberWelcomeRequestTask.get_CLASS());
        __mapChildren.put("NotifyConnectionClose", Grid.NotifyConnectionClose.get_CLASS());
        __mapChildren.put("NotifyConnectionOpen", Grid.NotifyConnectionOpen.get_CLASS());
        __mapChildren.put("NotifyMemberJoined", Grid.NotifyMemberJoined.get_CLASS());
        __mapChildren.put("NotifyMemberLeaving", Grid.NotifyMemberLeaving.get_CLASS());
        __mapChildren.put("NotifyMemberLeft", Grid.NotifyMemberLeft.get_CLASS());
        __mapChildren.put("NotifyMessageReceipt", Grid.NotifyMessageReceipt.get_CLASS());
        __mapChildren.put("NotifyPollClosed", Grid.NotifyPollClosed.get_CLASS());
        __mapChildren.put("NotifyResponse", Grid.NotifyResponse.get_CLASS());
        __mapChildren.put("NotifyServiceAnnounced", Grid.NotifyServiceAnnounced.get_CLASS());
        __mapChildren.put("NotifyServiceJoining", Grid.NotifyServiceJoining.get_CLASS());
        __mapChildren.put("NotifyServiceLeaving", Grid.NotifyServiceLeaving.get_CLASS());
        __mapChildren.put("NotifyServiceLeft", Grid.NotifyServiceLeft.get_CLASS());
        __mapChildren.put("NotifyServiceQuiescence", Grid.NotifyServiceQuiescence.get_CLASS());
        __mapChildren.put("NotifyShutdown", Grid.NotifyShutdown.get_CLASS());
        __mapChildren.put("NotifyStartup", Grid.NotifyStartup.get_CLASS());
        __mapChildren.put("PingRequest", Grid.PingRequest.get_CLASS());
        __mapChildren.put("ProtocolContext", Grid.ProtocolContext.get_CLASS());
        __mapChildren.put("Response", Grid.Response.get_CLASS());
        __mapChildren.put("WrapperGuardable", Grid.WrapperGuardable.get_CLASS());
    }

    public InvocationService() {
        this(null, null, true);
    }

    public InvocationService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setMessageClassMap(new HashMap());
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setOldestPendingRequestSUIDCounter(new AtomicLong());
            this.setPendingProcess(new LiteMap());
            this.setResourceRegistry(new SimpleResourceRegistry());
            this.setSerializerMap(new WeakHashMap());
            this.setSuspendPollLimit(new AtomicLong());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Grid.DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Grid.EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Grid.Guard("Guard", this, true), "Guard");
        this._addChild(new Grid.MemberConfigListener("MemberConfigListener", this, true), "MemberConfigListener");
        this._addChild(new Grid.PollArray("PollArray", this, true), "PollArray");
        this._addChild(new Grid.ReceiveQueue("ReceiveQueue", this, true), "ReceiveQueue");
        this._addChild(new Grid.ServiceConfig("ServiceConfig", this, true), "ServiceConfig");
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    @Override
    public String getServiceType() {
        return "Invocation";
    }

    public static Component get_Instance() {
        return new InvocationService();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/InvocationService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    protected DefaultServiceDependencies cloneDependencies(ServiceDependencies deps) {
        return new DefaultInvocationServiceDependencies((InvocationServiceDependencies)deps);
    }

    @Override
    public synchronized void configure(XmlElement xml) {
        this.setDependencies(LegacyXmlGridHelper.fromXml(xml, new DefaultInvocationServiceDependencies(), this.getOperationalContext(), this.getContextClassLoader()));
        this.setServiceConfig(xml);
    }

    @Override
    public long drainOverflow(MemberSet setMembers, long cMillis) throws InterruptedException {
        return this.isServiceThread(true) ? cMillis : super.drainOverflow(setMembers, cMillis);
    }

    @Override
    public void execute(Invocable task, Set setMembers, InvocationObserver observer) {
        long cTimeout;
        Message msgExecute;
        if (task == null) {
            throw new IllegalArgumentException("Task must be specified");
        }
        if (observer == null) {
            msg = (InvocationMessage)this.instantiateMessage("InvocationMessage");
            ((InvocationMessage)msg).setTask(task);
            msgExecute = msg;
            cTimeout = this.getRequestTimeout();
        } else {
            msg = (InvocationRequest)this.instantiateMessage("InvocationRequest");
            ((InvocationRequest)msg).setTask(task);
            ((InvocationRequest)msg).setQuery(false);
            ((InvocationRequest)msg).setObserver(observer);
            ((InvocationRequest)msg).setRespondInOrder(task instanceof InvocableInOrder ? ((InvocableInOrder)task).isRespondInOrder() : false);
            msgExecute = msg;
            cTimeout = this.calculateRequestTimeout((RequestMessage)msg);
        }
        msgExecute.ensureToMemberSet().addAll((Collection)(setMembers == null ? this.getServiceMemberSet() : setMembers));
        this.send(msgExecute);
        if (!NonBlocking.isNonBlockingCaller()) {
            try {
                this.drainOverflow(msgExecute.getToMemberSet(), cTimeout);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WrapperException(e, "Request interrupted");
            }
        }
    }

    public Map getPendingProcess() {
        return this.__m_PendingProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowedArray getProcessArray(Member member) {
        Map mapPending = this.getPendingProcess();
        WindowedArray waProcess = (WindowedArray)mapPending.get(member);
        if (waProcess == null) {
            InvocationService invocationService = this;
            synchronized (invocationService) {
                waProcess = (WindowedArray)mapPending.get(member);
                if (waProcess == null) {
                    waProcess = new WindowedArray();
                    mapPending.put(member, waProcess);
                }
            }
        }
        return waProcess;
    }

    public void onInvocationMessage(InvocationMessage msg) {
        Invocable task = msg.getTask();
        try {
            task.run();
        }
        catch (Throwable e) {
            InvocationService._trace("Failure to execute an Invocable object: " + String.valueOf(task) + "\n" + InvocationService.getStackTrace(e), 1);
        }
    }

    public void onInvocationRequest(InvocationRequest msgRequest) {
        Invocable task = msgRequest.getTask();
        try {
            if (task instanceof NonBlockingInvocable) {
                ((NonBlockingInvocable)task).run(msgRequest);
            } else {
                task.run();
                msgRequest.proceed(task.getResult());
            }
        }
        catch (Throwable e) {
            msgRequest.proceed(e);
        }
    }

    @Override
    public void onNotifyServiceLeft(Member member) {
        super.onNotifyServiceLeft(member);
        this.getPendingProcess().remove(member);
    }

    @Override
    public void onServiceStarted() {
        DaemonPool pool = this.getDaemonPool();
        if (pool.getDaemonCountMin() > 0) {
            pool.setThreadGroup(new ThreadGroup(this.getServiceName()));
            pool.start();
        }
        super.onServiceStarted();
    }

    @Override
    public Map query(Invocable task, Set setMembers) {
        if (task == null) {
            throw new IllegalArgumentException("Task must be specified");
        }
        InvocationRequest msg = (InvocationRequest)this.instantiateMessage("InvocationRequest");
        msg.setTask(task);
        msg.setQuery(true);
        msg.setRespondInOrder(task instanceof InvocableInOrder ? ((InvocableInOrder)task).isRespondInOrder() : false);
        msg.ensureToMemberSet().addAll((Collection)(setMembers == null ? this.getServiceMemberSet() : setMembers));
        return (Map)this.poll(msg);
    }

    public void sendResponse(InvocationRequest msgRequest, InvocationResponse msgResponse) {
        try {
            msgResponse.respondTo(msgRequest);
            this.send(msgResponse);
        }
        catch (Exception e) {
            msgResponse = (InvocationResponse)msgResponse.cloneMessage();
            msgResponse.setException(e);
            msgResponse.respondTo(msgRequest);
            this.send(msgResponse);
        }
    }

    protected void setPendingProcess(Map map) {
        this.__m_PendingProcess = map;
    }

    @Override
    public String getDescription() {
        return super.getDescription() + ", Serializer=" + this.getSerializer().getName();
    }

    static {
        InvocationService.__initStatic();
    }

    public static class InvocationMessage
    extends Message
    implements Associated,
    PriorityTask,
    Runnable {
        private Invocable __m_Task;

        public InvocationMessage() {
            this(null, null, true);
        }

        public InvocationMessage(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(35);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new InvocationMessage();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/InvocationService$InvocationMessage".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public Object getAssociatedKey() {
            Invocable task = this.getTask();
            return task instanceof Associated ? ((Associated)((Object)task)).getAssociatedKey() : null;
        }

        @Override
        public String getDescription() {
            StringBuffer sb = new StringBuffer("InvocationMessage{Task=");
            try {
                sb.append(this.getTask());
            }
            catch (Throwable e) {
                sb.append(this.getTask().getClass().getName());
            }
            sb.append('}');
            return sb.toString();
        }

        @Override
        public long getExecutionTimeoutMillis() {
            Invocable task = this.getTask();
            return task instanceof PriorityTask ? ((PriorityTask)((Object)task)).getExecutionTimeoutMillis() : -1L;
        }

        @Override
        public long getRequestTimeoutMillis() {
            return 0L;
        }

        @Override
        public int getSchedulingPriority() {
            Invocable task = this.getTask();
            return task instanceof PriorityTask ? ((PriorityTask)((Object)task)).getSchedulingPriority() : 0;
        }

        public Invocable getTask() {
            return this.__m_Task;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            InvocationService service = (InvocationService)this.getService();
            Invocable task = this.getTask();
            if (task != null) {
                try {
                    task.init(service);
                }
                catch (Throwable e) {
                    InvocationMessage._trace("Failure to initialize an Invocable object: " + String.valueOf(e) + "\n" + InvocationMessage.getStackTrace(e), 1);
                    return;
                }
                DaemonPool pool = service.getDaemonPool();
                if (pool.isStarted()) {
                    pool.add(this);
                } else {
                    service.onInvocationMessage(this);
                }
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            try {
                this.setTask((Invocable)this.readObject(input));
            }
            catch (IOException e) {
                InvocationMessage._trace("Failure to deserialize an Invocable object: " + String.valueOf(e) + "\n" + InvocationMessage.getStackTrace(e) + " Message " + this.toString(false), 1);
            }
        }

        @Override
        public void run() {
            ((InvocationService)this.getService()).onInvocationMessage(this);
        }

        @Override
        public void runCanceled(boolean fAbandoned) {
            try {
                Invocable task = this.getTask();
                if (task instanceof PriorityTask) {
                    ((PriorityTask)((Object)task)).runCanceled(fAbandoned);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void setTask(Invocable pTask) {
            this.__m_Task = pTask;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            this.writeObject(output, this.getTask());
        }
    }

    public static class InvocationRequest
    extends RequestMessage
    implements Associated,
    Continuation,
    PriorityTask,
    Runnable {
        private transient Throwable __m_Exception;
        private transient InvocationObserver __m_Observer;
        private transient long __m_ProcessId;
        private transient boolean __m_Query;
        private boolean __m_RespondInOrder;
        private Invocable __m_Task;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public InvocationRequest() {
            this(null, null, true);
        }

        public InvocationRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(33);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new InvocationRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/InvocationService$InvocationRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public Object getAssociatedKey() {
            Invocable task = this.getTask();
            return task instanceof Associated ? ((Associated)((Object)task)).getAssociatedKey() : null;
        }

        @Override
        public String getDescription() {
            StringBuffer sb = new StringBuffer("InvocationRequest{");
            sb.append(this.isQuery() ? "Query" : "Execute").append(", Task=");
            try {
                sb.append(this.getTask());
            }
            catch (Throwable e) {
                sb.append(this.getTask().getClass().getName());
            }
            sb.append('}');
            return sb.toString();
        }

        protected Throwable getException() {
            return this.__m_Exception;
        }

        @Override
        public long getExecutionTimeoutMillis() {
            Invocable task = this.getTask();
            return task instanceof PriorityTask ? ((PriorityTask)((Object)task)).getExecutionTimeoutMillis() : -1L;
        }

        public InvocationObserver getObserver() {
            return this.__m_Observer;
        }

        public long getProcessId() {
            return this.__m_ProcessId;
        }

        @Override
        public long getRequestTimeoutMillis() {
            Invocable task = this.getTask();
            return task instanceof PriorityTask ? ((PriorityTask)((Object)task)).getRequestTimeoutMillis() : -1L;
        }

        @Override
        public int getSchedulingPriority() {
            Invocable task = this.getTask();
            return task instanceof PriorityTask ? ((PriorityTask)((Object)task)).getSchedulingPriority() : 0;
        }

        public Invocable getTask() {
            return this.__m_Task;
        }

        @Override
        protected com.tangosol.coherence.component.net.Poll instantiatePoll() {
            return (com.tangosol.coherence.component.net.Poll)this._newChild("Poll");
        }

        public boolean isQuery() {
            return this.__m_Query;
        }

        public boolean isRespondInOrder() {
            return this.__m_RespondInOrder;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            InvocationService service = (InvocationService)this.getService();
            Throwable exception = this.getException();
            if (exception == null) {
                Invocable task = this.getTask();
                try {
                    task.init(service);
                }
                catch (Throwable e) {
                    exception = e;
                }
            }
            if (exception == null) {
                DaemonPool pool = service.getDaemonPool();
                if (pool.isStarted()) {
                    if (this.isRespondInOrder()) {
                        WindowedArray waProcess = service.getProcessArray(this.getFromMember());
                        this.setProcessId(waProcess.add(this));
                    }
                    pool.add(this);
                } else {
                    this.setRespondInOrder(false);
                    service.onInvocationRequest(this);
                }
            } else {
                InvocationResponse msgResponse = (InvocationResponse)service.instantiateMessage("InvocationResponse");
                msgResponse.setException(exception);
                msgResponse.respondTo(this);
                service.send(msgResponse);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void proceed(Object oResult) {
            InvocationService service = (InvocationService)this.getService();
            InvocationResponse msgResponse = (InvocationResponse)service.instantiateMessage("InvocationResponse");
            if (oResult instanceof Throwable) {
                msgResponse.setException((Throwable)oResult);
            } else {
                msgResponse.setResult(oResult);
            }
            if (this.isRespondInOrder()) {
                WindowedArray waProcess;
                WindowedArray windowedArray = waProcess = service.getProcessArray(this.getFromMember());
                synchronized (windowedArray) {
                    long lProcessId = this.getProcessId();
                    if (lProcessId == waProcess.getFirstIndex()) {
                        Message msg;
                        waProcess.remove(lProcessId);
                        service.sendResponse(this, msgResponse);
                        while ((msg = (Message)waProcess.get(++lProcessId)) instanceof InvocationResponse) {
                            waProcess.remove(lProcessId);
                            service.sendResponse(this, (InvocationResponse)msg);
                        }
                    } else {
                        InvocationRequest._assert(lProcessId > waProcess.getFirstIndex());
                        waProcess.set(lProcessId, msgResponse);
                    }
                }
            } else {
                service.sendResponse(this, msgResponse);
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            try {
                this.setTask((Invocable)this.readObject(input));
                this.setRespondInOrder(input.readBoolean());
            }
            catch (IOException e) {
                this.setException(e);
                InvocationRequest._trace("Failure to deserialize an Invocable object: " + String.valueOf(e) + "\n" + InvocationRequest.getStackTrace(e), 1);
            }
        }

        @Override
        public void run() {
            ((InvocationService)this.getService()).onInvocationRequest(this);
        }

        @Override
        public void runCanceled(boolean fAbandoned) {
            InvocationService service = (InvocationService)this.getService();
            InvocationResponse msgResponse = (InvocationResponse)service.instantiateMessage("InvocationResponse");
            msgResponse.respondTo(this);
            try {
                Invocable task = this.getTask();
                if (task instanceof PriorityTask) {
                    ((PriorityTask)((Object)task)).runCanceled(fAbandoned);
                }
                String sMsg = (fAbandoned ? "Abandoned " : "Canceled ") + this.getDescription() + "; Service=" + service.getServiceName();
                msgResponse.setException(new RequestTimeoutException(sMsg));
            }
            catch (Throwable e) {
                msgResponse.setException(e);
            }
            service.send(msgResponse);
        }

        protected void setException(Throwable e) {
            this.__m_Exception = e;
        }

        public void setObserver(InvocationObserver observer) {
            this.__m_Observer = observer;
        }

        public void setProcessId(long lProcessId) {
            this.__m_ProcessId = lProcessId;
        }

        public void setQuery(boolean fQuery) {
            this.__m_Query = fQuery;
        }

        public void setRespondInOrder(boolean fDone) {
            this.__m_RespondInOrder = fDone;
        }

        public void setTask(Invocable task) {
            this.__m_Task = task;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            this.writeObject(output, this.getTask());
            output.writeBoolean(this.isRespondInOrder());
        }

        static {
            InvocationRequest.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            private transient InvocationObserver __m_Observer;
            private transient boolean __m_Query;

            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/InvocationService$InvocationRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public InvocationObserver getObserver() {
                return this.__m_Observer;
            }

            public boolean isQuery() {
                return this.__m_Query;
            }

            @Override
            protected void onCompletion() {
                InvocationObserver observer = this.getObserver();
                if (observer != null) {
                    try {
                        observer.invocationCompleted();
                    }
                    catch (Throwable e) {
                        Poll._trace(e);
                    }
                }
                super.onCompletion();
            }

            @Override
            public void onInit() {
                super.onInit();
                InvocationRequest msg = (InvocationRequest)this.get_Parent();
                if (msg.isQuery()) {
                    this.setQuery(true);
                    this.setResult(new HashMap());
                } else {
                    this.setObserver(msg.getObserver());
                }
            }

            @Override
            public void onLeft(Member member) {
                InvocationObserver observer = this.getObserver();
                if (observer != null) {
                    try {
                        if (this.getRemainingMemberSet().contains(member)) {
                            observer.memberLeft(member);
                        }
                    }
                    catch (Throwable e) {
                        Poll._trace(e);
                    }
                }
                super.onLeft(member);
            }

            @Override
            public void onResponse(Message msg) {
                Member member = msg.getFromMember();
                InvocationResponse msgResponse = (InvocationResponse)msg;
                Throwable exception = msgResponse.getException();
                Object oResult = msgResponse.getResult();
                if (this.isQuery()) {
                    InvocationRequest msgRequest = (InvocationRequest)this.get_Parent();
                    if (exception != null && msgRequest.getTask() instanceof NonBlockingInvocable) {
                        oResult = exception;
                        exception = null;
                    }
                    ((Map)this.getResult()).put(member, oResult);
                } else {
                    InvocationObserver observer = this.getObserver();
                    if (observer != null) {
                        try {
                            if (exception == null) {
                                observer.memberCompleted(member, oResult);
                            } else {
                                observer.memberFailed(member, exception);
                                exception = null;
                            }
                        }
                        catch (Throwable e) {
                            Poll._trace(e);
                        }
                    }
                }
                if (exception != null) {
                    Poll._trace("Invocation request to " + String.valueOf(member) + " threw an exception \n" + Poll.getStackTrace(exception), 1);
                }
                super.onResponse(msg);
            }

            public void setObserver(InvocationObserver observer) {
                this.__m_Observer = observer;
            }

            public void setQuery(boolean fQuery) {
                this.__m_Query = fQuery;
            }
        }
    }

    public static class InvocationResponse
    extends Message {
        private Throwable __m_Exception;
        private Object __m_Result;

        public InvocationResponse() {
            this(null, null, true);
        }

        public InvocationResponse(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(34);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new InvocationResponse();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/InvocationService$InvocationResponse".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "InvocationResponse{" + (this.getException() == null ? "Exception=" + String.valueOf(this.getException()) : "Result=" + String.valueOf(this.getResult())) + "}";
        }

        public Throwable getException() {
            return this.__m_Exception;
        }

        public Object getResult() {
            return this.__m_Result;
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            try {
                this.setException((Throwable)this.readObject(input));
                this.setResult(this.readObject(input));
            }
            catch (Exception e) {
                this.setException(e);
            }
        }

        public void setException(Throwable exception) {
            this.__m_Exception = exception;
        }

        public void setResult(Object oResult) {
            this.__m_Result = oResult;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            this.writeObject(output, this.getException());
            this.writeObject(output, this.getResult());
        }
    }
}

