/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.common.base.Notifier;
import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.oracle.coherence.common.collections.Arrays;
import com.oracle.coherence.common.internal.continuations.Continuations;
import com.oracle.coherence.common.net.InetAddresses;
import com.oracle.coherence.common.util.Duration;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.net.ServiceInfo;
import com.tangosol.coherence.component.net.TcpRing;
import com.tangosol.coherence.component.net.memberSet.ActualMemberSet;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.message.DiscoveryMessage;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.config.Config;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.ActionPolicy;
import com.tangosol.net.Cluster;
import com.tangosol.net.ClusterDependencies;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.Member;
import com.tangosol.net.Service;
import com.tangosol.net.SocketOptions;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.internal.ClusterJoinException;
import com.tangosol.net.security.PermissionInfo;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.DeltaSet;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.ListMap;
import com.tangosol.util.LongArray;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SimpleResourceRegistry;
import com.tangosol.util.SparseArray;
import com.tangosol.util.UID;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class ClusterService
extends Grid {
    public static final int ANNOUNCE_BIND_THRESHOLD = 3;
    public static final int ANNOUNCE_PROTOCOL_VERSION = 1;
    private com.tangosol.coherence.component.net.Member __m_AnnounceMember;
    private transient Set __m_BroadcastAddresses;
    private transient long __m_BroadcastAddressesExpiry;
    private int __m_BroadcastCounter;
    private int __m_BroadcastLimit;
    private int __m_BroadcastMode;
    private long __m_BroadcastNextMillis;
    private int __m_BroadcastRepeatMillis;
    private int __m_BroadcastTimeoutMillis;
    private Binary __m_BroadcastTimestamp;
    private transient int __m_DeliveryTimeoutMillis;
    private int __m_HeartbeatDelay;
    private transient MemberSet __m_HeartbeatMemberSet;
    private transient long __m_LastInterminableWarningMillis;
    private UUID __m_LastPanicUid;
    private transient int __m_MaximumPacketLength;
    private long __m_MembershipReopen;
    private transient LongArray __m_PendingServiceJoining;
    private QuorumControl __m_QuorumControl;
    public static final int REJECT_AUTHORIZE = 8161;
    public static final int REJECT_CLUSTER_NAME = 8167;
    public static final int REJECT_EDITION = 8168;
    public static final int REJECT_LICENSE_EXPIRED = 8164;
    public static final int REJECT_LICENSE_TYPE = 8169;
    public static final int REJECT_NONE = 8171;
    public static final int REJECT_PACKET_MAX = 8163;
    public static final int REJECT_QUORUM = 8172;
    public static final int REJECT_RESTART = 8170;
    public static final int REJECT_SENIOR = 8165;
    public static final int REJECT_SIZE = 8160;
    public static final int REJECT_VERSION = 8162;
    public static final int REJECT_WKA = 8166;
    private com.tangosol.coherence.component.net.Member __m_RequestMember;
    private volatile Grid[] __m_Service;
    private transient Map __m_ServiceContext;
    private ServiceInfo[] __m_ServiceInfo;
    private int __m_State;
    public static final int STATE_ANNOUNCE = 0;
    public static final int STATE_JOINED = 2;
    public static final int STATE_JOINING = 1;
    public static final int STATE_LEAVING = 3;
    public static final int STATE_LEFT = 4;
    private transient long __m_StatsJoinRequests;
    private transient long __m_StatsMembersDepartureCount;
    private transient TcpRing __m_TcpRing;
    private transient long __m_TimestampAdjustment;
    private transient int __m_TimestampMaxVariance;
    public static final String VERSION = "12.2.1.1.0";
    public static final String VERSION_BARRIER = "12.2.1";
    private Set __m_WellKnownAddresses;
    private Map __m_WkaMap;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Acknowledgement", Grid.Acknowledgement.get_CLASS());
        __mapChildren.put("BusEventMessage", Grid.BusEventMessage.get_CLASS());
        __mapChildren.put("ConfigRequest", Grid.ConfigRequest.get_CLASS());
        __mapChildren.put("ConfigResponse", Grid.ConfigResponse.get_CLASS());
        __mapChildren.put("ConfigSync", Grid.ConfigSync.get_CLASS());
        __mapChildren.put("ConfigUpdate", Grid.ConfigUpdate.get_CLASS());
        __mapChildren.put("DispatchEvent", Grid.DispatchEvent.get_CLASS());
        __mapChildren.put("DispatchNotification", Grid.DispatchNotification.get_CLASS());
        __mapChildren.put("MemberConfigUpdate", Grid.MemberConfigUpdate.get_CLASS());
        __mapChildren.put("MemberHeartbeat", MemberHeartbeat.get_CLASS());
        __mapChildren.put("MemberJoined", MemberJoined.get_CLASS());
        __mapChildren.put("MemberLeaving", MemberLeaving.get_CLASS());
        __mapChildren.put("MemberLeft", MemberLeft.get_CLASS());
        __mapChildren.put("MemberWelcome", Grid.MemberWelcome.get_CLASS());
        __mapChildren.put("MemberWelcomeRequest", Grid.MemberWelcomeRequest.get_CLASS());
        __mapChildren.put("MemberWelcomeRequestTask", Grid.MemberWelcomeRequestTask.get_CLASS());
        __mapChildren.put("NewMemberAnnounce", NewMemberAnnounce.get_CLASS());
        __mapChildren.put("NewMemberAnnounceReply", NewMemberAnnounceReply.get_CLASS());
        __mapChildren.put("NewMemberAnnounceWait", NewMemberAnnounceWait.get_CLASS());
        __mapChildren.put("NewMemberInduct", NewMemberInduct.get_CLASS());
        __mapChildren.put("NewMemberRequestId", NewMemberRequestId.get_CLASS());
        __mapChildren.put("NewMemberRequestIdReject", NewMemberRequestIdReject.get_CLASS());
        __mapChildren.put("NewMemberRequestIdReply", NewMemberRequestIdReply.get_CLASS());
        __mapChildren.put("NewMemberRequestIdWait", NewMemberRequestIdWait.get_CLASS());
        __mapChildren.put("NewMemberTimestampRequest", NewMemberTimestampRequest.get_CLASS());
        __mapChildren.put("NewMemberTimestampResponse", NewMemberTimestampResponse.get_CLASS());
        __mapChildren.put("NewMemberWelcome", NewMemberWelcome.get_CLASS());
        __mapChildren.put("NewMemberWelcomeAnnounce", NewMemberWelcomeAnnounce.get_CLASS());
        __mapChildren.put("NewMemberWelcomeRequest", NewMemberWelcomeRequest.get_CLASS());
        __mapChildren.put("NotifyConnectionClose", Grid.NotifyConnectionClose.get_CLASS());
        __mapChildren.put("NotifyConnectionOpen", Grid.NotifyConnectionOpen.get_CLASS());
        __mapChildren.put("NotifyIpTimeout", NotifyIpTimeout.get_CLASS());
        __mapChildren.put("NotifyMemberJoined", Grid.NotifyMemberJoined.get_CLASS());
        __mapChildren.put("NotifyMemberLeaving", Grid.NotifyMemberLeaving.get_CLASS());
        __mapChildren.put("NotifyMemberLeft", NotifyMemberLeft.get_CLASS());
        __mapChildren.put("NotifyMessageReceipt", Grid.NotifyMessageReceipt.get_CLASS());
        __mapChildren.put("NotifyPollClosed", Grid.NotifyPollClosed.get_CLASS());
        __mapChildren.put("NotifyResponse", NotifyResponse.get_CLASS());
        __mapChildren.put("NotifyServiceAnnounced", Grid.NotifyServiceAnnounced.get_CLASS());
        __mapChildren.put("NotifyServiceJoining", Grid.NotifyServiceJoining.get_CLASS());
        __mapChildren.put("NotifyServiceLeaving", Grid.NotifyServiceLeaving.get_CLASS());
        __mapChildren.put("NotifyServiceLeft", Grid.NotifyServiceLeft.get_CLASS());
        __mapChildren.put("NotifyServiceQuiescence", Grid.NotifyServiceQuiescence.get_CLASS());
        __mapChildren.put("NotifyShutdown", NotifyShutdown.get_CLASS());
        __mapChildren.put("NotifyStartup", Grid.NotifyStartup.get_CLASS());
        __mapChildren.put("NotifyTcmpTimeout", NotifyTcmpTimeout.get_CLASS());
        __mapChildren.put("PingRequest", Grid.PingRequest.get_CLASS());
        __mapChildren.put("ProtocolContext", Grid.ProtocolContext.get_CLASS());
        __mapChildren.put("QuorumRollCall", QuorumRollCall.get_CLASS());
        __mapChildren.put("Response", Grid.Response.get_CLASS());
        __mapChildren.put("SeniorMemberHeartbeat", SeniorMemberHeartbeat.get_CLASS());
        __mapChildren.put("SeniorMemberKill", SeniorMemberKill.get_CLASS());
        __mapChildren.put("SeniorMemberPanic", SeniorMemberPanic.get_CLASS());
        __mapChildren.put("ServiceJoined", ServiceJoined.get_CLASS());
        __mapChildren.put("ServiceJoining", ServiceJoining.get_CLASS());
        __mapChildren.put("ServiceJoinRequest", ServiceJoinRequest.get_CLASS());
        __mapChildren.put("ServiceLeaving", ServiceLeaving.get_CLASS());
        __mapChildren.put("ServiceLeft", ServiceLeft.get_CLASS());
        __mapChildren.put("ServiceQuiescenceRequest", ServiceQuiescenceRequest.get_CLASS());
        __mapChildren.put("ServiceRegister", ServiceRegister.get_CLASS());
        __mapChildren.put("ServiceRegisterRequest", ServiceRegisterRequest.get_CLASS());
        __mapChildren.put("ServiceUpdateResponse", ServiceUpdateResponse.get_CLASS());
        __mapChildren.put("WitnessRequest", WitnessRequest.get_CLASS());
        __mapChildren.put("WrapperGuardable", Grid.WrapperGuardable.get_CLASS());
    }

    public ClusterService() {
        this(null, null, true);
    }

    public ClusterService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setAcceptingClients(false);
            this.setAcceptingOthers(true);
            this.setBroadcastRepeatMillis(256);
            this.setBroadcastTimeoutMillis(32768);
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setMessageClassMap(new HashMap());
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setOldestPendingRequestSUIDCounter(new AtomicLong());
            this.setResourceRegistry(new SimpleResourceRegistry());
            this.setSerializerMap(new WeakHashMap());
            this.setServiceId(0);
            this.setServiceName("Cluster");
            this.setSuspendPollLimit(new AtomicLong());
            this.setTimestampMaxVariance(10);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Grid.DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Grid.EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Grid.Guard("Guard", this, true), "Guard");
        this._addChild(new Grid.MemberConfigListener("MemberConfigListener", this, true), "MemberConfigListener");
        this._addChild(new Grid.PollArray("PollArray", this, true), "PollArray");
        this._addChild(new QuorumControl("QuorumControl", this, true), "QuorumControl");
        this._addChild(new Grid.ReceiveQueue("ReceiveQueue", this, true), "ReceiveQueue");
        this._addChild(new Grid.ServiceConfig("ServiceConfig", this, true), "ServiceConfig");
        this._addChild(new TcpRing("TcpRing", this, true), "TcpRing");
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_PendingServiceJoining = new SparseArray();
            this.__m_WkaMap = new SafeHashMap();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    public int getBroadcastVariance() {
        return 212343923;
    }

    @Override
    public String getServiceType() {
        return "Cluster";
    }

    public static Component get_Instance() {
        return new ClusterService();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDynamicBroadcast(com.tangosol.coherence.component.net.Member member) {
        Set setBroadcast;
        if (member != null && !this.isWellKnown(member) && (setBroadcast = this.getBroadcastAddresses()) != null) {
            Set set = setBroadcast;
            synchronized (set) {
                setBroadcast.add(member.getSocketAddress());
            }
            this.setBroadcastAddressesExpiry(Base.getSafeTimeMillis() + (long)this.getDeliveryTimeoutMillis());
        }
    }

    public static int calcMachines(Set setMembers) {
        HashSet<Integer> setMachines = new HashSet<Integer>();
        for (com.tangosol.coherence.component.net.Member member : setMembers) {
            setMachines.add(Base.makeInteger(member.getMachineId()));
        }
        return setMachines.size();
    }

    public long calcTimestamp(long lLocalhostMillis) {
        if (lLocalhostMillis != 0L) {
            lLocalhostMillis += this.getTimestampAdjustment();
        }
        return lLocalhostMillis;
    }

    @Override
    protected void checkGuardables() {
        long cLateMillis;
        if (this.isGuardian() && (cLateMillis = this.getGuardSupport().check()) > 0L) {
            ClusterService._trace("Service guardian is " + cLateMillis + "ms late, indicating that this JVM may be running slowly or experienced a long GC", 3);
        }
    }

    protected void checkPendingJoinPolls() {
        ClusterService._assert(Thread.currentThread() == this.getThread());
        LongArray laPending = this.getPendingServiceJoining();
        if (!laPending.isEmpty()) {
            long ldtNow = Base.getSafeTimeMillis();
            long cTimeout = this.getDeliveryTimeoutMillis();
            long ldtCutoff = ldtNow - (cTimeout - (cTimeout >> 2));
            long ldtOldest = laPending.getFirstIndex();
            if (ldtOldest < ldtCutoff) {
                ServiceJoining msg = (ServiceJoining)laPending.get(ldtOldest);
                String sMsg = "ServiceJoining";
                try {
                    sMsg = String.valueOf(msg);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Poll poll = msg.getRequestPoll();
                if (poll == null) {
                    laPending.remove(ldtOldest);
                    ClusterService._trace("validatePolls: This senior encountered a null pending poll for message: " + sMsg, 1);
                    return;
                }
                MemberSet setRemain = poll.getRemainingMemberSet();
                if (setRemain.isEmpty()) {
                    boolean fWasClosed = poll.isClosed();
                    poll.close();
                    laPending.remove(ldtOldest);
                    ClusterService._trace("validatePolls: This senior encountered an empty " + (fWasClosed ? "closed " : "") + "pending poll for message: " + sMsg, 1);
                    return;
                }
                String sPoll = "Poll";
                try {
                    sPoll = poll.toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ClusterService._trace("validatePolls: This senior encountered an overdue poll, indicating a dead member, a significant network issue or an Operating System threading library bug (e.g. Linux NPTL): " + sPoll + "\nfor message: " + sMsg, 2);
                try {
                    ArrayList<com.tangosol.coherence.component.net.Member> listOverdue = new ArrayList<com.tangosol.coherence.component.net.Member>();
                    HashSet<Integer> setMachines = new HashSet<Integer>();
                    MasterMemberSet setAll = this.getClusterMemberSet();
                    for (com.tangosol.coherence.component.net.Member member : (com.tangosol.coherence.component.net.Member[])((MemberSet)setAll).toArray(new com.tangosol.coherence.component.net.Member[((MemberSet)setAll).size()])) {
                        if (member == null || !setRemain.contains(member)) continue;
                        listOverdue.add(member);
                        setMachines.add(member.getMachineId());
                    }
                    long ldtGiveUp = ldtOldest + (cTimeout + (cTimeout >> 2));
                    if (setMachines.size() <= 1 || ldtNow > ldtGiveUp) {
                        for (com.tangosol.coherence.component.net.Member member : listOverdue) {
                            ClusterService._trace("Removing unresponsive member: " + String.valueOf(member), 2);
                            this.doMemberLeft(member);
                        }
                        poll.close();
                        if (listOverdue.isEmpty()) {
                            ClusterService._trace("validatePolls: This senior encountered and closed an overdue poll that did not contain any known members, indicating a likely JVM or Operating System threading library (e.g. Linux NPTL) bug: " + sPoll, 1);
                        }
                    }
                }
                catch (Throwable e) {
                    ClusterService._trace("validatePolls: Non-fatal exception detected during processing:", 1);
                    ClusterService._trace(e);
                    ClusterService._trace("validatePolls: Exception has been logged; continuing processing.", 1);
                }
            }
        }
    }

    @Override
    public int compareImportance(com.tangosol.coherence.component.net.Member memberThat) {
        com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
        int nThisWeight = memberThis.getPriority();
        int nThatWeight = memberThat.getPriority();
        int iResult = nThisWeight - nThatWeight;
        int c = this.getServiceCount();
        for (int i = 1; i < c; ++i) {
            Grid service = this.getService(i);
            if (service == null) continue;
            try {
                iResult += service.compareImportance(memberThat);
                continue;
            }
            catch (Throwable e) {
                ClusterService._trace("Failed to determine importance of com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid \"" + service.getServiceName() + "\"\n" + ClusterService.getStackTrace(e), 1);
            }
        }
        return iResult;
    }

    public void doMemberInduct(com.tangosol.coherence.component.net.Member memberNew) {
        ClusterService._assert(Thread.currentThread() == this.getThread());
        NewMemberInduct msg = (NewMemberInduct)this.instantiateMessage("NewMemberInduct");
        msg.addToMember(memberNew);
        MasterMemberSet setMember = this.getClusterMemberSet();
        Object[] aoMember = setMember.toArray();
        int cMembers = aoMember.length;
        msg.setMemberCount(cMembers);
        for (int i = 0; i < cMembers; ++i) {
            com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)aoMember[i];
            msg.setMember(i, member);
            msg.setServiceVersion(i, VERSION_BARRIER);
        }
        int cServices = this.getServiceInfoCount();
        msg.setServiceCount(cServices);
        for (int i = 0; i < cServices; ++i) {
            ServiceInfo info = this.getServiceInfo(i);
            msg.setServiceId(i, info.getServiceId());
            msg.setServiceName(i, info.getServiceName());
            msg.setServiceType(i, info.getServiceType());
            msg.setServiceSuspended(i, info.isSuspended());
        }
        this.send(msg);
    }

    public void doMemberLeaving() {
        this.setState(3);
        com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
        if (memberThis != null) {
            MemberLeaving msg = (MemberLeaving)this.instantiateMessage("MemberLeaving");
            msg.setToMemberSet(this.getOthersMemberSet());
            msg.setMemberId(memberThis.getId());
            msg.setMemberUid(memberThis.getUid32());
            this.send(msg);
        }
    }

    public void doMemberLeft() {
        com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
        if (memberThis != null) {
            MemberLeft msg = (MemberLeft)this.instantiateMessage("MemberLeft");
            msg.setToMemberSet(this.getOthersMemberSet());
            msg.setSynchronizationRequest(false);
            msg.setMemberCount(1);
            msg.setMemberIDs(new short[]{(short)memberThis.getId()});
            msg.setMemberUUIDs(new UUID[]{memberThis.getUid32()});
            msg.setMemberTimestamps(new long[]{this.calcTimestamp(memberThis.getTimestamp())});
            this.send(msg);
            ClusterService.sleep(((Cluster)this.getCluster()).getDependencies().getPublisherAckDelayMillis());
        }
        this.setState(4);
    }

    public void doMemberLeft(com.tangosol.coherence.component.net.Member member) {
        this.removeMember(member);
        this.ensureMemberLeft(null, null, false);
    }

    public void doNotifyIpTimeout(InetAddress address) {
        NotifyIpTimeout msg = (NotifyIpTimeout)this.instantiateMessage("NotifyIpTimeout");
        msg.addToMember(this.getThisMember());
        msg.setTimedOutAddress(address);
        this.send(msg);
    }

    public void doNotifyTcmpTimeout(MessagePacket packet, MemberSet setTimedOut) {
        NotifyTcmpTimeout msg = (NotifyTcmpTimeout)this.instantiateMessage("NotifyTcmpTimeout");
        msg.addToMember(this.getThisMember());
        msg.setUndeliverablePacket(packet);
        msg.setTimedOutMembers(setTimedOut);
        this.send(msg);
    }

    public void doServiceJoined(Grid service) {
        int nServiceId = service.getServiceId();
        if (nServiceId > 0) {
            if (this.getService(nServiceId) == service) {
                ServiceMemberSet setMember = service.getServiceMemberSet();
                com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
                long ldtJoined = setMember.getServiceJoinTime(memberThis.getId());
                ServiceJoined msg = (ServiceJoined)this.instantiateMessage("ServiceJoined");
                msg.addToMember(memberThis);
                msg.setServiceId(nServiceId);
                this.send(msg);
            } else {
                ClusterService._trace("ClusterService.doServiceJoined: Unknown Service " + String.valueOf(service), 1);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void doServiceJoining(Grid service) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void doServiceLeaving(Grid service) {
        int nServiceId = service.getServiceId();
        if (nServiceId > 0) {
            if (this.getService(nServiceId) == service) {
                ServiceMemberSet setMember = this.getServiceInfo(nServiceId).getMemberSet();
                com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
                long ldtJoined = setMember.getServiceJoinTime(memberThis.getId());
                ServiceLeaving msg = (ServiceLeaving)this.instantiateMessage("ServiceLeaving");
                msg.addToMember(memberThis);
                msg.setServiceId(nServiceId);
                msg.setServiceJoinTime(ldtJoined);
                this.send(msg);
            } else {
                ClusterService._trace("ClusterService.doServiceLeaving: Unknown Service " + String.valueOf(service), 1);
            }
        }
    }

    public void doServiceLeft(Grid serviceLeft) {
        int nServiceId = serviceLeft.getServiceId();
        if (nServiceId > 0) {
            Grid service = this.getService(nServiceId);
            if (service == null || service == serviceLeft) {
                ServiceMemberSet setMember = this.getServiceInfo(nServiceId).getMemberSet();
                com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
                long ldtJoined = setMember.getServiceJoinTime(memberThis.getId());
                this.setService(nServiceId, null);
                ServiceLeft msg = (ServiceLeft)this.instantiateMessage("ServiceLeft");
                msg.addToMember(memberThis);
                msg.setServiceId(nServiceId);
                msg.setServiceJoinTime(ldtJoined);
                msg.setMemberLeftId(memberThis.getId());
                this.send(msg);
            } else if (!serviceLeft.isExiting()) {
                ClusterService._trace("ClusterService.doServiceLeft: Unknown Service " + String.valueOf(serviceLeft), 1);
            }
        }
    }

    public void doServiceQueiscence(String sService, boolean fResume) {
        this.doServiceQueiscence(sService, fResume, false);
    }

    public void doServiceQueiscence(String sService, boolean fResume, boolean fResumeOnFailover) {
        ServiceQuiescenceRequest msg;
        ServiceInfo info = this.getServiceInfo(sService);
        if (info == null) {
            throw new IllegalArgumentException("Unknown service: " + sService);
        }
        do {
            msg = (ServiceQuiescenceRequest)this.instantiateMessage("ServiceQuiescenceRequest");
            msg.setServiceId(info.getServiceId());
            msg.setResume(fResume);
            msg.setResumeOnFailover(fResumeOnFailover);
            msg.setRelay(true);
            msg.setToMemberSet(MemberSet.instantiate(this.getServiceMemberSet().getOldestMember()));
            this.poll(msg);
        } while (msg.ensureRequestPoll().getRespondedMemberSet().isEmpty());
    }

    protected boolean ensureDiscovery() {
        return false;
    }

    public com.tangosol.coherence.component.net.Member ensureMember(com.tangosol.coherence.component.net.Member memberNew, String sVersion) {
        int nId;
        MasterMemberSet setMember = this.getClusterMemberSet();
        com.tangosol.coherence.component.net.Member member = setMember.getMember(nId = memberNew.getId());
        if (member == null) {
            member = memberNew;
            com.tangosol.coherence.component.net.Member memberDead = setMember.getRecycleSet().getMember(nId);
            if (memberDead != null && memberDead.getUid32().equals(memberNew.getUid32())) {
                return null;
            }
            member.initCommSupport();
            setMember.add(member);
            setMember.setServiceVersion(nId, sVersion);
            setMember.setServiceJoinTime(nId, member.getTimestamp());
            setMember.setServiceEndPointName(nId, "");
            setMember.setServiceJoining(nId);
            this.onMemberJoined(member);
        }
        return member;
    }

    public void ensureMemberLeft(com.tangosol.coherence.component.net.Member memberTo, Set setUUIDExempt, boolean fRequest) {
        MasterMemberSet setMembers = this.getClusterMemberSet();
        com.tangosol.coherence.component.net.Member[] aMemberDead = (com.tangosol.coherence.component.net.Member[])setMembers.getRecycleSet().toArray((Object[])null);
        short[] anId = new short[aMemberDead.length];
        UUID[] aUUID = new UUID[aMemberDead.length];
        long[] aldtDeath = new long[aMemberDead.length];
        long ldtCutoffMillis = Base.getSafeTimeMillis() - (long)setMembers.getRecycleMillis();
        int cDead = 0;
        for (com.tangosol.coherence.component.net.Member member : aMemberDead) {
            if (member == null || member.getTimestamp() <= ldtCutoffMillis || !member.isLeaving() && memberTo == null || setUUIDExempt != null && setUUIDExempt.contains(member.getUid32())) continue;
            anId[cDead] = (short)member.getId();
            aUUID[cDead] = member.getUid32();
            aldtDeath[cDead] = this.calcTimestamp(member.getTimestamp());
            if (memberTo == null) {
                member.setLeaving(false);
            }
            ++cDead;
        }
        if (cDead > 0 || fRequest) {
            MemberLeft msg = (MemberLeft)this.instantiateMessage("MemberLeft");
            msg.setToMemberSet(memberTo == null ? this.getOthersMemberSet() : SingleMemberSet.instantiate(memberTo));
            msg.setSynchronizationRequest(fRequest);
            msg.setMemberCount(cDead);
            msg.setMemberIDs(anId);
            msg.setMemberUUIDs(aUUID);
            msg.setMemberTimestamps(aldtDeath);
            this.send(msg);
        }
    }

    public int ensureService(Grid service) {
        String sName = service.getServiceName();
        String sType = service.getServiceType();
        do {
            ServiceRegisterRequest msg = (ServiceRegisterRequest)this.instantiateMessage("ServiceRegisterRequest");
            msg.addToMember(this.getClusterOldestMember());
            msg.setServiceName(sName);
            msg.setServiceType(sType);
            Object oResult = this.poll(msg);
            if (oResult == null) continue;
            int nId = (Integer)oResult;
            ServiceInfo info = this.getServiceInfo(nId);
            String sTypeReg = info.getServiceType();
            if (!service.isCompatibleServiceType(sTypeReg)) {
                throw new IllegalArgumentException("Invalid service type: requested=" + sType + ", registered=" + sTypeReg);
            }
            return nId;
        } while (this.getServiceState() <= 2);
        throw new IllegalStateException("Service can not be created against a stopped cluster");
    }

    public ServiceInfo ensureServiceInfo(int nService, String sName, String sType) {
        int c;
        ServiceInfo[] ainfo = this.getServiceInfo();
        int n = c = ainfo == null ? 0 : ainfo.length;
        for (int i = 0; i < c; ++i) {
            ServiceInfo info = ainfo[i];
            if (info == null) continue;
            boolean fObsolete = false;
            fObsolete = i == nService ? !info.getServiceName().equals(sName) || sType != null && !sType.equals(info.getServiceType()) : info.getServiceName().equals(sName);
            if (!fObsolete) continue;
            ClusterService._trace("Removing the obsolete service info: " + String.valueOf(info), 3);
            ainfo[i] = null;
        }
        ServiceInfo info = this.getServiceInfo(nService);
        if (info == null) {
            info = new ServiceInfo();
            info.setMemberSet(nService == 0 ? this.getServiceMemberSet() : new ServiceMemberSet());
            info.setServiceId(nService);
            info.setServiceName(sName);
            info.setServiceType(sType);
            if (nService != 0 && this.getServiceInfo(0).isSuspended()) {
                info.setSuspended(true);
            }
            this.setServiceInfo(nService, info);
            this.onServiceAnnounced(info);
        } else {
            ClusterService._assert(sName.equals(info.getServiceName()));
            ClusterService._assert(sType == null || sType.equals(info.getServiceType()));
        }
        return info;
    }

    public String formatClusterString() {
        String sClusterName = this.getClusterName();
        StringBuffer sb = new StringBuffer("cluster");
        if (sClusterName != null && sClusterName.length() > 0) {
            sb.append(" \"").append(sClusterName).append('\"');
        }
        return sb.toString();
    }

    public static String formatStateName(int nState) {
        switch (nState) {
            case 0: {
                return "STATE_ANNOUNCE";
            }
            case 1: {
                return "STATE_JOINING";
            }
            case 2: {
                return "STATE_JOINED";
            }
            case 3: {
                return "STATE_LEAVING";
            }
            case 4: {
                return "STATE_LEFT";
            }
        }
        return "<unknown> " + nState;
    }

    public int fromString(String s) {
        if (s != null && s.length() >= 2) {
            String[] a;
            char ch1 = s.charAt(0);
            int ch2 = s.charAt(1);
            if (s.indexOf(32) > 0 && (a = Base.parseDelimitedString(s, ' ')).length > 3 && a[0].length() > 5 && a[1].length() > 5 && a[2].length() > 3 && a[3].length() > 3) {
                int n = 0;
                for (int i = 1; i < 4; ++i) {
                    n = n << 8 | a[i].charAt(i);
                }
                switch (n) {
                    case 7103333: 
                    case 7304293: {
                        return 0;
                    }
                    case 7299429: 
                    case 7302501: {
                        return 1;
                    }
                    case 7299956: {
                        if (a[2].charAt(0) == 'L') {
                            return 0;
                        }
                    }
                    case 7299444: 
                    case 7304564: {
                        return 3;
                    }
                    case 7303284: 
                    case 7304308: {
                        if (a[2].charAt(0) != 'D') {
                            return 4;
                        }
                    }
                    case 7301492: {
                        return 5;
                    }
                }
            }
            if (s.length() >= 30 && s.charAt(13) == 'l' && s.charAt(28) == 'c') {
                ch2 = s.length();
                ch1 = s.charAt(ch2 - 1);
                switch (ch1) {
                    case 'e': {
                        return 5 - (ch2 < 33 ? 2 : 1);
                    }
                    case 'l': 
                    case 's': {
                        return 0;
                    }
                }
                ch2 = s.charAt(ch2 - (ch1 == 'n' ? 1 : 0) - 6);
                ch1 = s.charAt(30);
            }
            switch (ch1) {
                case 'G': {
                    return 5;
                }
                case 'E': 
                case 'e': {
                    return ch2 == ch1 ? 4 : 0;
                }
                case 'S': {
                    return 3;
                }
                case 'P': 
                case 'p': {
                    return 2;
                }
                case 'C': 
                case 'R': {
                    return 1;
                }
                case 'D': 
                case 'd': {
                    return ch2 == 101 ? 1 : 0;
                }
            }
        }
        return -1;
    }

    public com.tangosol.coherence.component.net.Member getAnnounceMember() {
        return this.__m_AnnounceMember;
    }

    public Set getBroadcastAddresses() {
        return this.__m_BroadcastAddresses;
    }

    public long getBroadcastAddressesExpiry() {
        return this.__m_BroadcastAddressesExpiry;
    }

    public int getBroadcastCounter() {
        return this.__m_BroadcastCounter;
    }

    public int getBroadcastLimit() {
        return this.__m_BroadcastLimit;
    }

    private int getBroadcastMode() {
        return this.__m_BroadcastMode;
    }

    public long getBroadcastNextMillis() {
        return this.__m_BroadcastNextMillis;
    }

    public int getBroadcastRepeatMillis() {
        return this.__m_BroadcastRepeatMillis;
    }

    public int getBroadcastTimeoutMillis() {
        return this.__m_BroadcastTimeoutMillis;
    }

    public Binary getBroadcastTimestamp() {
        return this.__m_BroadcastTimestamp;
    }

    public int getClusterId() {
        return 0;
    }

    public String getClusterName() {
        return ((Cluster)this.getCluster()).getClusterName();
    }

    @Override
    public String getDecoratedThreadName() {
        int nState = this.getState();
        String sState = nState == 2 ? "" : "|" + ClusterService.formatStateName(nState);
        com.tangosol.coherence.component.net.Member member = this.getThisMember();
        if (member == null && (member = this.getRequestMember()) == null) {
            member = this.getAnnounceMember();
        }
        String sMember = member == null ? "" : "|" + member.toString();
        return super.getDecoratedThreadName() + sState + sMember;
    }

    public int getDeliveryTimeoutMillis() {
        return this.__m_DeliveryTimeoutMillis;
    }

    public int getHeartbeatDelay() {
        return this.__m_HeartbeatDelay;
    }

    public MemberSet getHeartbeatMemberSet() {
        MemberSet setTo = this.__m_HeartbeatMemberSet;
        if (setTo == null) {
            setTo = new ActualMemberSet();
            this.setHeartbeatMemberSet(setTo);
        }
        setTo.clear();
        MasterMemberSet setMembers = this.getClusterMemberSet();
        int cMembers = setMembers.size();
        if (cMembers > 1) {
            Cluster cluster = (Cluster)this.getCluster();
            com.tangosol.coherence.component.net.Member memberThis = setMembers.getThisMember();
            int cDelay = this.getHeartbeatDelay();
            int cTimeout = this.getHeuristicTimeoutMillis() - cDelay;
            int cDesired = Math.max(cMembers * cDelay / cTimeout, 1);
            long ldtNow = Base.getSafeTimeMillis();
            long ldtEligible = ldtNow - (long)(cTimeout >> 2);
            long ldtDanger = ldtEligible - (long)(cTimeout >> 1);
            com.tangosol.coherence.component.net.Member[] aMember = (com.tangosol.coherence.component.net.Member[])setMembers.toArray(new com.tangosol.coherence.component.net.Member[cMembers]);
            cMembers = aMember.length;
            int iFirst = (int)(Math.random() * (double)cMembers);
            int iLast = iFirst + cMembers;
            for (int i = iFirst; i < iLast; ++i) {
                long ldtLastIn;
                com.tangosol.coherence.component.net.Member member = aMember[i >= cMembers ? i - cMembers : i];
                if (member == null || member == memberThis || member.isDeaf()) continue;
                long ldtLastOut = member.getLastOutgoingMillis();
                boolean fAckPending = ldtLastOut > (ldtLastIn = member.getLastIncomingMillis());
                boolean fDanger = !fAckPending && ldtLastIn < ldtDanger;
                boolean fEligible = !fAckPending && ldtLastIn < ldtEligible;
                boolean fTrintDanger = cluster.isCommEndangered(member);
                if (fEligible && cDesired > 0 || fDanger || fTrintDanger) {
                    setTo.add(member);
                }
                --cDesired;
            }
        }
        return setTo;
    }

    public int getHeuristicTimeoutMillis() {
        return this.getDeliveryTimeoutMillis() >> 1;
    }

    public long getLastInterminableWarningMillis() {
        return this.__m_LastInterminableWarningMillis;
    }

    public UUID getLastPanicUid() {
        return this.__m_LastPanicUid;
    }

    public int getMaximumPacketLength() {
        return this.__m_MaximumPacketLength;
    }

    public long getMembershipReopen() {
        return this.__m_MembershipReopen;
    }

    public String getMemberStatsDescription(com.tangosol.coherence.component.net.Member member) {
        return member.toString(2);
    }

    public int getMulticastTimeToLive() {
        return this.getWellKnownAddresses() == null ? 0 : ((Cluster)this.getCluster()).getDependencies().getGroupTimeToLive();
    }

    public LongArray getPendingServiceJoining() {
        return this.__m_PendingServiceJoining;
    }

    public QuorumControl getQuorumControl() {
        QuorumControl control = this.__m_QuorumControl;
        if (control == null) {
            control = (QuorumControl)this._findChild("QuorumControl");
            this.setQuorumControl(control);
        }
        return control;
    }

    public com.tangosol.coherence.component.net.Member getRequestMember() {
        return this.__m_RequestMember;
    }

    @Override
    public long getRequestTimeout() {
        return this.getDeliveryTimeoutMillis();
    }

    public Grid[] getService() {
        return this.__m_Service;
    }

    public Grid getService(int i) {
        Grid[] aService = this.getService();
        return aService == null || i >= aService.length ? null : aService[i];
    }

    public Grid getService(String sName) {
        int cServices = this.getServiceCount();
        for (int i = 0; i < cServices; ++i) {
            Grid service = this.getService(i);
            if (service == null || !sName.equals(service.getServiceName())) continue;
            return service;
        }
        return null;
    }

    public Map getServiceContext() {
        return this.__m_ServiceContext;
    }

    public int getServiceCount() {
        Grid[] aService = this.getService();
        return aService == null ? 0 : aService.length;
    }

    public ServiceInfo[] getServiceInfo() {
        return this.__m_ServiceInfo;
    }

    public ServiceInfo getServiceInfo(int i) {
        ServiceInfo[] ainfo = this.getServiceInfo();
        return ainfo == null || i >= ainfo.length ? null : ainfo[i];
    }

    public ServiceInfo getServiceInfo(String sName) {
        int cInfo = this.getServiceInfoCount();
        for (int i = 0; i < cInfo; ++i) {
            ServiceInfo info = this.getServiceInfo(i);
            if (info == null || !sName.equals(info.getServiceName())) continue;
            return info;
        }
        return null;
    }

    public int getServiceInfoCount() {
        ServiceInfo[] ainfo = this.getServiceInfo();
        return ainfo == null ? 0 : ainfo.length;
    }

    @Override
    public com.tangosol.coherence.component.net.Member getServiceOldestMember() {
        return this.getClusterOldestMember();
    }

    @Override
    public String getServiceStateName() {
        return super.getServiceStateName() + ", " + ClusterService.formatStateName(this.getState());
    }

    @Override
    public String getServiceVersion() {
        String sVersion = Coherence.VERSION_INTERNAL;
        return sVersion == null || sVersion.isEmpty() || "n/a".equals(sVersion) ? VERSION : sVersion;
    }

    public Set getSlowMembers() {
        HashSet<com.tangosol.coherence.component.net.Member> setMembers = null;
        for (com.tangosol.coherence.component.net.Member member : this.getClusterMemberSet()) {
            if (!this.isSlow(member)) continue;
            if (setMembers == null) {
                setMembers = new HashSet<com.tangosol.coherence.component.net.Member>();
            }
            setMembers.add(member);
        }
        return setMembers;
    }

    public int getState() {
        return this.__m_State;
    }

    public long getStatsJoinRequests() {
        return this.__m_StatsJoinRequests;
    }

    public long getStatsMembersDepartureCount() {
        return this.__m_StatsMembersDepartureCount;
    }

    public TcpRing getTcpRing() {
        TcpRing ring = this.__m_TcpRing;
        if (ring == null) {
            ring = (TcpRing)this._findChild("TcpRing");
            this.setTcpRing(ring);
        }
        return ring;
    }

    public long getTimestamp() {
        return this.calcTimestamp(Base.getSafeTimeMillis());
    }

    public long getTimestampAdjustment() {
        return this.__m_TimestampAdjustment;
    }

    public int getTimestampMaxVariance() {
        return this.__m_TimestampMaxVariance;
    }

    @Override
    public long getWaitMillis() {
        long cWait1 = super.getWaitMillis();
        long cWait2 = Math.max(1L, this.getBroadcastNextMillis() - Base.getSafeTimeMillis());
        return cWait1 <= 0L ? cWait2 : Math.min(cWait1, cWait2);
    }

    public Set getWellKnownAddresses() {
        return this.__m_WellKnownAddresses;
    }

    protected MemberSet getWitnessMemberSet(com.tangosol.coherence.component.net.Member memberSuspect) {
        boolean GREATER = false;
        boolean EQUAL = true;
        int LESSER = 2;
        int WEAK = 3;
        int POOR = 4;
        int NIL = 5;
        Object[] aoMember = this.getClusterMemberSet().toArray();
        com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
        int nMachineThis = memberThis.getMachineId();
        int nMachineSuspect = memberSuspect.getMachineId();
        Arrays.shuffle(aoMember);
        ActualMemberSet setWitness = new ActualMemberSet();
        int iCatDesired = 0;
        int iCatBest = 5;
        int s = 0;
        while (iCatDesired < 5) {
            for (int i = s; i < aoMember.length; ++i) {
                com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)aoMember[i];
                int iCatThat = 5;
                if (member != null) {
                    int nMachineThat = member.getMachineId();
                    int iComp = this.compareImportance(member);
                    int n = member == memberThis || member == memberSuspect || member.isDeaf() ? 5 : (this.isSlow(member) || this.isRecentlyHeuristicallyDead(member) ? 4 : (nMachineThat == nMachineThis || nMachineThat == nMachineSuspect ? 3 : (iComp > 0 ? 2 : (iCatThat = iComp == 0 ? 1 : 0))));
                    if (iCatThat <= iCatDesired) {
                        setWitness.add(member);
                        if (setWitness.size() == 2) {
                            return setWitness;
                        }
                        iCatThat = 5;
                    } else if (iCatThat < iCatBest) {
                        iCatBest = iCatThat;
                    }
                }
                if (iCatThat != 5) continue;
                aoMember[i] = null;
                if (i != s) continue;
                ++s;
            }
            iCatDesired = Math.max(iCatDesired + 1, iCatBest);
        }
        return setWitness.isEmpty() ? null : setWitness;
    }

    public int getWkaHashCode() {
        return this.isWkaEnabled() ? this.getWellKnownAddresses().hashCode() : 0;
    }

    public Map getWkaMap() {
        return this.__m_WkaMap;
    }

    public void heartbeat(MemberSet setMember) {
        if (setMember == null || setMember.isEmpty()) {
            return;
        }
        long ldtLastReceived = this.calcTimestamp(this.getThisMember().getLastIncomingMillis());
        Iterator iter = setMember.iterator();
        while (iter.hasNext()) {
            MemberHeartbeat msg = (MemberHeartbeat)this.instantiateMessage("MemberHeartbeat");
            msg.setToMemberSet(SingleMemberSet.instantiate((com.tangosol.coherence.component.net.Member)iter.next()));
            msg.setLastReceivedMillis(ldtLastReceived);
            this.post(msg);
        }
        this.flush();
    }

    public int indexOfService(String sName) {
        ClusterService._assert(sName != null);
        ServiceInfo[] ainfo = this.getServiceInfo();
        int c = ainfo.length;
        for (int i = 0; i < c; ++i) {
            ServiceInfo info = ainfo[i];
            if (info == null || !info.getServiceName().equals(sName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void initializeTransport() {
        this.setMessagePublisher(((Cluster)this.getCluster()).getPublisher());
    }

    public com.tangosol.coherence.component.net.Member instantiateMember() {
        com.tangosol.coherence.component.net.Member member = new com.tangosol.coherence.component.net.Member();
        member.initCommSupport();
        return member;
    }

    public boolean isHeuristicallyDead(com.tangosol.coherence.component.net.Member member) {
        if (member == null || member.isDeaf()) {
            return true;
        }
        long lCurrentMillis = Base.getSafeTimeMillis();
        long lCutoffMillis = lCurrentMillis - (long)this.getHeuristicTimeoutMillis();
        long lLastInMillis = member.getLastIncomingMillis();
        return lLastInMillis < lCutoffMillis;
    }

    public boolean isMembershipSuspended() {
        return Base.getSafeTimeMillis() <= this.getMembershipReopen() || this.getQuorumControl().isClusterSuspended();
    }

    public boolean isRecentlyHeuristicallyDead(com.tangosol.coherence.component.net.Member member) {
        if (member == null || member.isDeaf() || this.isHeuristicallyDead(member)) {
            return true;
        }
        return member.getLastHeuristicDeathMillis() >= Base.getSafeTimeMillis() - (long)this.getDeliveryTimeoutMillis();
    }

    public boolean isSlow(com.tangosol.coherence.component.net.Member member) {
        int cTimeoutMillis;
        long lCurrentMillis = Base.getSafeTimeMillis();
        long lLastSlowMillis = member.getLastSlowMillis();
        return lLastSlowMillis > lCurrentMillis - (long)(cTimeoutMillis = this.getDeliveryTimeoutMillis());
    }

    @Override
    public boolean isSuspendedFully() {
        return this.isSuspended();
    }

    public boolean isVersionCompatible(String sVersion) {
        int nThat;
        String sVersionThis = this.getServiceVersion();
        if (Base.equals(sVersionThis, sVersion)) {
            return true;
        }
        int nThis = ServiceMemberSet.parseVersion(sVersionThis);
        return nThis <= (nThat = ServiceMemberSet.parseVersion(sVersion)) || nThat >= ServiceMemberSet.parseVersion(VERSION_BARRIER);
    }

    public boolean isVersionOlder(String sVersion) {
        String sVersionThis = this.getServiceVersion();
        return !Base.equals(sVersionThis, sVersion) && ServiceMemberSet.parseVersion(sVersion) < ServiceMemberSet.parseVersion(sVersionThis);
    }

    public boolean isWellKnown(InetAddress addrInet) {
        return !this.isWkaEnabled() || this.getWellKnownAddresses().contains(new InetSocketAddress(addrInet, this.getCluster().getDependencies().getGroupPort()));
    }

    public boolean isWellKnown(com.tangosol.coherence.component.net.Member member) {
        return !this.isWkaEnabled() || this.getWellKnownAddresses().contains(member.getSocketAddress());
    }

    public boolean isWkaEnabled() {
        return this.getWellKnownAddresses() != null;
    }

    @Override
    protected void notifyServiceJoined() {
    }

    @Override
    protected void onEnter() {
        int n;
        if (this.isWkaEnabled() && (n = this.getCluster().getDependencies().getEdition()) < 3 && n != 1) {
            throw Base.ensureRuntimeException(null, "WKA (unicast-only) clustering is not available.");
        }
        this.setBroadcastLimit(this.getBroadcastTimeoutMillis() / this.getBroadcastRepeatMillis() + 1);
        this.setBroadcastNextMillis(Base.getSafeTimeMillis());
        super.onEnter();
    }

    @Override
    public void onException(Throwable e) {
        switch (this.getState()) {
            default: {
                super.onException(e);
                break;
            }
            case 1: {
                if (e instanceof ClusterJoinException) {
                    this.setStartException(e);
                } else {
                    ClusterService._trace("StopJoining " + this.toString() + " due to unhandled exception: ", 1);
                    ClusterService._trace(e);
                }
                this.onStopJoining();
                break;
            }
            case 2: {
                ClusterService._trace("StopRunning " + this.toString() + " due to unhandled exception: ", 1);
                ClusterService._trace(e);
                this.onStopRunning();
            }
        }
    }

    @Override
    protected void onExit() {
        this.getTcpRing().close();
        super.onExit();
    }

    @Override
    public void onInit() {
        MasterMemberSet setMember = new MasterMemberSet();
        this.setClusterMemberSet(setMember);
        this.setServiceMemberSet(setMember);
        this.ensureServiceInfo(0, this.getServiceName(), this.getServiceType());
        this.setService(0, this);
        super.onInit();
        TcpRing ring = this.getTcpRing();
        this.setNotifier(ring);
        ((Grid.ReceiveQueue)this.getQueue()).setNotifier(ring);
    }

    @Override
    protected void onInterval() {
        super.onInterval();
    }

    public void onMemberJoined(com.tangosol.coherence.component.net.Member member) {
        com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
        if (memberThis != null && member != memberThis) {
            long ldtCluster;
            long ldtMember = member.getTimestamp();
            if (ldtMember > (ldtCluster = this.getTimestamp())) {
                this.setTimestampAdjustment(this.getTimestampAdjustment() + (ldtMember - ldtCluster));
            }
            ClusterService._trace(String.valueOf(member) + " joined Cluster with senior member " + this.getClusterOldestMember().getId(), 3);
            Cluster cluster = (Cluster)this.getCluster();
            cluster.onMemberJoined(member);
            if (this.getClusterMemberSet().isServiceJoined(memberThis.getId())) {
                this.getTcpRing().onMemberJoined(member);
            }
            int c = this.getServiceCount();
            for (int i = 0; i < c; ++i) {
                Grid service = this.getService(i);
                if (service == null) continue;
                Grid.NotifyMemberJoined msg = (Grid.NotifyMemberJoined)service.instantiateMessage("NotifyMemberJoined");
                msg.setNotifyMember(member);
                service.send(msg);
            }
            this.getQuorumControl().onMemberJoined(member);
        }
        if (this.isAcceptingClients()) {
            this.dispatchMemberEvent(member, 1);
            this.dispatchNotification("type=Cluster", "member.joined", "Member " + member.getId() + " joined", member.toString());
        }
    }

    public void onMemberLeaving(com.tangosol.coherence.component.net.Member member) {
        int c = this.getServiceCount();
        for (int i = 0; i < c; ++i) {
            Grid service = this.getService(i);
            if (service == null) continue;
            Grid.NotifyMemberLeaving msg = (Grid.NotifyMemberLeaving)service.instantiateMessage("NotifyMemberLeaving");
            msg.setNotifyMember(member);
            service.send(msg);
        }
        this.dispatchMemberEvent(member, 2);
    }

    protected void onMemberLeft(com.tangosol.coherence.component.net.Member member) {
        member.setLeaving(true);
        com.tangosol.coherence.component.net.Member memberSenior = this.getClusterOldestMember();
        ClusterService._trace(String.valueOf(member) + " left Cluster with senior member " + memberSenior.getId(), 3);
        this.getQuorumControl().onMemberLeft(member);
        this.removeDynamicBroadcast(member);
        Cluster cluster = (Cluster)this.getCluster();
        cluster.onMemberLeft(member);
        this.getTcpRing().onMemberLeft(member);
        int c = this.getServiceCount();
        for (int i = 0; i < c; ++i) {
            Grid service = this.getService(i);
            if (service == null) continue;
            Grid.NotifyMemberLeft msg = (Grid.NotifyMemberLeft)service.instantiateMessage("NotifyMemberLeft");
            msg.setNotifyMember(member);
            service.send(msg);
        }
        this.dispatchMemberEvent(member, 3);
        this.dispatchNotification("type=Cluster", "member.left", "Member " + member.getId() + " left", member.toString());
        this.setStatsMembersDepartureCount(this.getStatsMembersDepartureCount() + 1L);
    }

    public void onMemberRejected(int nReason, com.tangosol.coherence.component.net.Member rejector) {
        Object sError;
        switch (nReason) {
            case 8160: {
                int cbMax = this.getMaximumPacketLength();
                sError = "The cluster has exceeded its maximum size.  This limit is based on the configured maximum packet length, with the current value of " + cbMax + " bytes the cluster size limit is approximately " + MessagePacket.calcMaxMembers(cbMax) + " members.";
                break;
            }
            case 8161: {
                sError = "This member is not authorized to join the cluster.";
                break;
            }
            case 8162: {
                sError = "This member could not join the cluster because of an incompatibility between the cluster protocol used by this member and the one being used by the rest of the cluster.  This is most likely caused by a Coherence version mismatch, or by mismatched protocol filters (e.g. compression, or encryption).";
                break;
            }
            case 8163: {
                sError = "This member could not join the cluster because of a configuration mismatch between this member and the configuration being used by the rest of the cluster. The maximum packet size (" + this.getMaximumPacketLength() + ") for this member does not match the maximum packet size that the running cluster is using.";
                break;
            }
            case 8164: {
                sError = "This member could not join the cluster because the senior member's license has expired.";
                break;
            }
            case 8165: {
                sError = "This member will not join the cluster because the senior member's IP address is not an authorized host.";
                break;
            }
            case 8166: {
                boolean fWka = this.isWkaEnabled();
                sError = "This member could not join the cluster because of a configuration mismatch between this member and the configuration being used by the running cluster. This member is" + (fWka ? " " : " not ") + "configured to use WKA, but the running cluster is" + (fWka ? " not." : ".");
                break;
            }
            case 8167: {
                sError = "This member could not join the cluster because of a configuration mismatch between this member and the configuration being used by the rest of the cluster. This member specified a cluster name of \"" + this.getClusterName() + "\" which did not match the name of the running cluster" + (String)(rejector == null ? "" : " " + rejector.getClusterName() + "\"") + ". This indicates that there are multiple clusters on this network attempting to use overlapping network configurations.";
                break;
            }
            case 8168: {
                ClusterDependencies cfg = ((Cluster)this.getCluster()).getDependencies();
                String sEditionName = Coherence.EDITION_NAMES[cfg.getEdition()];
                sError = "This member could not join the cluster because of a mismatch between Coherence product editions. This member was attempting to run as a Oracle Coherence " + sEditionName + " edition cluster.";
                break;
            }
            case 8169: {
                ClusterDependencies cfg = ((Cluster)this.getCluster()).getDependencies();
                String modeName = Coherence.MODE_NAMES[cfg.getMode()];
                sError = "This member could not join the cluster because of a mismatch between Coherence license types. This member was attempting to run in " + modeName + " mode.";
                break;
            }
            case 8170: {
                this.resetBroadcastCounter("restarting the join protocol", null);
                this.setTimestampAdjustment(0L);
                this.setRequestMember(null);
                this.setState(0);
                return;
            }
            case 8172: {
                sError = "This member was prevented from joining the cluster by the existing cluster's action policy.";
                break;
            }
            default: {
                sError = "Unknown reject reason code of " + nReason;
            }
        }
        if (sError != null) {
            if (rejector != null) {
                sError = (String)sError + " Rejected by " + String.valueOf(rejector) + ".";
            }
            ClusterService._trace((String)sError, 1);
        }
        this.onStopJoining();
    }

    public void onMembersTimedOut(Set setTimedOut) {
        this.getQuorumControl().onMembersTimedOut(setTimedOut);
    }

    @Override
    protected boolean onMessageReadException(Throwable e, Message msg) {
        if (msg instanceof DiscoveryMessage) {
            if (e instanceof SecurityException) {
                ClusterService._trace("SecurityException received while reading message " + msg.get_Name() + "\n" + String.valueOf(e), 2);
            }
            ((DiscoveryMessage)msg).setReadError(true);
            return true;
        }
        return super.onMessageReadException(e, msg);
    }

    @Override
    protected void onNotify() {
        long lTime = Base.getSafeTimeMillis();
        if (lTime >= this.getBroadcastNextMillis()) {
            switch (this.getState()) {
                case 0: {
                    this.onTimerAnnouncing();
                    break;
                }
                case 1: {
                    this.onTimerJoining();
                    break;
                }
                case 2: {
                    this.onTimerRunning();
                }
            }
            this.setBroadcastNextMillis(lTime + (long)this.getBroadcastRepeatMillis());
        }
        super.onNotify();
    }

    public void onNotifyIpTimeout(InetAddress address) {
        ActualMemberSet setTimedOut = new ActualMemberSet();
        for (com.tangosol.coherence.component.net.Member member : this.getClusterMemberSet()) {
            if (!address.equals(member.getAddress())) continue;
            ((MemberSet)setTimedOut).add(member);
        }
        if (!((MemberSet)setTimedOut).isEmpty()) {
            Iterator iter = setTimedOut.iterator();
            while (iter.hasNext()) {
                if (((com.tangosol.coherence.component.net.Member)iter.next()).isTimedOut()) continue;
                ClusterService._trace("Failed to reach address " + String.valueOf(address) + " within the IpMonitor timeout. Members " + setTimedOut.toString(2) + " are suspect.", 2);
                break;
            }
            this.onMembersTimedOut(setTimedOut);
        }
    }

    public void onNotifyMemberLeft(com.tangosol.coherence.component.net.Member member) {
        this.closePolls(member);
    }

    public void onNotifyTcmpTimeout(MessagePacket packet, MemberSet setLate) {
        HashSet<com.tangosol.coherence.component.net.Member> setTimedOut = new HashSet<com.tangosol.coherence.component.net.Member>();
        com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
        for (com.tangosol.coherence.component.net.Member memberLate : setLate) {
            if (!memberLate.isTimedOut() && !memberThis.isTimedOut() && !this.verifyMemberLeft(memberLate, packet)) continue;
            setTimedOut.add(memberLate);
        }
        if (!setTimedOut.isEmpty()) {
            this.onMembersTimedOut(setTimedOut);
        }
    }

    public void onNotifyTcpDeparture(com.tangosol.coherence.component.net.Member member) {
        if (this.getClusterMemberSet().contains(member)) {
            this.doMemberLeft(member);
        }
    }

    public void onServiceAnnounced(ServiceInfo info) {
        String sServiceName = info.getServiceName();
        int c = this.getServiceCount();
        for (int i = 1; i < c; ++i) {
            Grid service = this.getService(i);
            if (service == null) continue;
            Grid.NotifyServiceAnnounced msg = (Grid.NotifyServiceAnnounced)service.instantiateMessage("NotifyServiceAnnounced");
            msg.setNotifyServiceName(sServiceName);
            service.send(msg);
        }
    }

    public void onServiceJoined(ServiceInfo info, com.tangosol.coherence.component.net.Member member) {
    }

    public void onServiceJoining(ServiceInfo info, com.tangosol.coherence.component.net.Member member) {
        ClusterService._assert(info != null && member != null);
    }

    public void onServiceLeaving(ServiceInfo info, com.tangosol.coherence.component.net.Member member) {
        Grid service;
        int nServiceId;
        ClusterService._assert(info != null && member != null);
        ClusterService._assert(info.getMemberSet().contains(member));
        if (member != this.getThisMember() && (nServiceId = info.getServiceId()) > 0 && (service = this.getService(nServiceId)) != null && service.getServiceMemberSet() != null) {
            Grid.NotifyServiceLeaving msg = (Grid.NotifyServiceLeaving)service.instantiateMessage("NotifyServiceLeaving");
            msg.setNotifyMember(member);
            service.send(msg);
        }
    }

    public void onServiceLeft(ServiceInfo info, com.tangosol.coherence.component.net.Member member, int nState) {
        ClusterService._assert(info != null && member != null);
        if (member != this.getThisMember()) {
            int nServiceId = info.getServiceId();
            ClusterService._assert(nServiceId > 0);
            Grid service = this.getService(nServiceId);
            if (service != null && service.getServiceMemberSet() != null) {
                Grid.NotifyServiceLeft msg = (Grid.NotifyServiceLeft)service.instantiateMessage("NotifyServiceLeft");
                msg.setNotifyMember(member);
                service.send(msg);
            }
        }
    }

    @Override
    public void onServiceStarted() {
    }

    public void onStopJoining() {
        if (this.isAcceptingClients()) {
            this.getCluster().stop();
        } else {
            this.stop();
        }
    }

    public void onStopRunning() {
        if (this.isAcceptingClients()) {
            this.getCluster().stop();
        } else {
            this.getTcpRing().onLeft();
            this.stop();
        }
    }

    public void onTimerAnnouncing() {
        int cLimit;
        com.tangosol.coherence.component.net.Member memberThis = this.getAnnounceMember();
        int cAttempts = this.getBroadcastCounter() + 1;
        if (cAttempts > (cLimit = this.getBroadcastLimit())) {
            boolean fDeaf;
            Cluster cluster = (Cluster)this.getCluster();
            boolean fWellKnown = this.isWellKnown(memberThis) || this.isWellKnown(memberThis.getAddress());
            boolean bl = fDeaf = this.getStatsJoinRequests() == 0L;
            if (fWellKnown && !fDeaf && this.ensureDiscovery()) {
                MasterMemberSet setMember = this.getClusterMemberSet();
                memberThis.setId(1);
                memberThis.setPreferredPacketLength(cluster.getSocketManager().getPreferredUnicastUdpSocket().getPacketLength());
                memberThis.setPreferredPort(cluster.getSocketManager().getPreferredUnicastUdpSocket().getPort());
                int nReject = setMember.induct(memberThis, this);
                if (nReject == 8171) {
                    setMember.setThisMember(memberThis);
                    ClusterService._trace("Created a new " + this.formatClusterString() + " with " + memberThis.toString(1), 3);
                    this.setState(2);
                    setMember.setServiceJoined(memberThis.getId());
                    this.setAcceptingClients(true);
                } else {
                    ClusterService._trace(memberThis.toString(1) + " is unable to join the cluster.", 1);
                    this.onMemberRejected(nReject, null);
                }
            } else if (!fWellKnown) {
                this.resetBroadcastCounter("waiting for well-known nodes in cluster '" + this.getClusterName() + "' to respond", null);
            } else if (fDeaf) {
                boolean fMC = this.getWellKnownAddresses() == null;
                this.resetBroadcastCounter((fMC ? "multicast" : "unicast") + " networking appears to be inoperable on interface " + memberThis.getAddress().getHostAddress() + " as this process isn't receiving even its own transmissions" + (InetAddresses.PreferIPv4Stack ? (fMC ? "; consider switching network interfaces or using WKA based clustering" : "; consider switching network interfaces") : "; consider forcing IPv4 via -Djava.net.preferIPv4Stack=true"), null);
            } else {
                this.resetBroadcastCounter("unable to bind or share cluster port", null);
            }
        } else {
            NewMemberAnnounce msg = (NewMemberAnnounce)this.instantiateMessage("NewMemberAnnounce");
            msg.setAnnounceProtocolVersion(1);
            msg.setFromMember(memberThis);
            msg.setAttemptCounter(cAttempts);
            msg.setAttemptLimit(cLimit);
            this.send(msg);
            this.setBroadcastCounter(cAttempts);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onTimerJoining() {
        int cLimit;
        int cAttempts = this.getBroadcastCounter() + 1;
        if (cAttempts > (cLimit = this.getBroadcastLimit())) {
            if (this.getThisMember() != null) throw new ClusterJoinException();
            this.resetBroadcastCounter("AnnounceReply was not followed by RequestIdReply", null);
            this.setTimestampAdjustment(0L);
            this.setRequestMember(null);
            this.setState(0);
            return;
        } else {
            NewMemberRequestId msg = (NewMemberRequestId)this.instantiateMessage("NewMemberRequestId");
            msg.setFromMember(this.getRequestMember());
            msg.setAttemptCounter(cAttempts);
            msg.setAttemptLimit(cLimit);
            msg.setServiceVersion(VERSION_BARRIER);
            msg.setMaxPacketSize(this.getMaximumPacketLength());
            msg.setWkaEnabled(this.isWkaEnabled());
            this.send(msg);
            this.setBroadcastCounter(cAttempts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTimerRunning() {
        Set setBroadcast;
        MasterMemberSet setMember = this.getClusterMemberSet();
        com.tangosol.coherence.component.net.Member memberThis = setMember.getThisMember();
        com.tangosol.coherence.component.net.Member memberOldest = setMember.getOldestMember();
        long ldtLastRecv = this.calcTimestamp(memberThis.getLastIncomingMillis());
        MemberSet setTo = this.getHeartbeatMemberSet();
        if (setTo != null && !setTo.isEmpty()) {
            this.heartbeat(setTo);
        }
        if ((setBroadcast = this.getBroadcastAddresses()) != null && this.getBroadcastAddressesExpiry() < Base.getSafeTimeMillis()) {
            Set set = setBroadcast;
            synchronized (set) {
                setBroadcast.clear();
            }
        }
        if (this.isAcceptingClients()) {
            if (memberThis == memberOldest) {
                msg = (SeniorMemberHeartbeat)this.instantiateMessage("SeniorMemberHeartbeat");
                ((SeniorMemberHeartbeat)msg).setLastReceivedMillis(ldtLastRecv);
                ((SeniorMemberHeartbeat)msg).setMemberSet(setMember);
                ((SeniorMemberHeartbeat)msg).setWkaEnabled(this.isWkaEnabled());
                ((SeniorMemberHeartbeat)msg).setLastJoinTime(setMember.getLastJoinTime());
                this.send(msg);
                this.checkPendingJoinPolls();
            }
        } else if (memberThis == memberOldest) {
            this.setAcceptingClients(true);
        } else {
            msg = (NewMemberWelcomeAnnounce)this.instantiateMessage("NewMemberWelcomeAnnounce");
            ((NewMemberWelcomeAnnounce)msg).setSeniorMember(memberOldest);
            ((NewMemberWelcomeAnnounce)msg).setServiceVersion(VERSION_BARRIER);
            this.send(msg);
        }
        this.getTcpRing().heartbeatBuddies();
    }

    public void populateWelcomeMessage(NewMemberWelcome msg) {
        com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
        int nMemberThis = memberThis.getId();
        msg.setFromMemberUid(memberThis.getUid32());
        msg.setPreferredPacketLength(memberThis.getPreferredPacketLength());
        msg.setPreferredPort(memberThis.getPreferredPort());
        Grid[] aService = this.getService();
        int cServices = aService.length;
        ServiceInfo[] aInfo = new ServiceInfo[cServices];
        int cInfo = 0;
        for (int iService = 0; iService < cServices; ++iService) {
            ServiceInfo info;
            Grid service = aService[iService];
            if (service == null || (info = this.getServiceInfo(iService)).getMemberSet().getServiceJoinTime(nMemberThis) <= 0L) continue;
            aInfo[cInfo++] = info;
        }
        msg.setServiceCount(cInfo);
        for (int i = 0; i < cInfo; ++i) {
            ServiceInfo info = aInfo[i];
            ServiceMemberSet setMember = info.getMemberSet();
            msg.setServiceId(i, info.getServiceId());
            msg.setServiceName(i, info.getServiceName());
            msg.setServiceType(i, info.getServiceType());
            msg.setServiceVersion(i, setMember.getServiceVersion(nMemberThis));
            msg.setServiceEndPointName(i, setMember.getServiceEndPointName(nMemberThis));
            msg.setServiceJoinTime(i, setMember.getServiceJoinTime(nMemberThis));
            msg.setServiceState(i, setMember.getState(nMemberThis));
            msg.setServiceMemberConfigMap(i, setMember.getMemberConfigMap(nMemberThis));
        }
    }

    @Override
    protected void register() {
    }

    public void registerServiceJoining(ServiceJoining msg) {
        ClusterService._assert(Thread.currentThread() == this.getThread());
        LongArray laPending = this.getPendingServiceJoining();
        long lIndex = Base.getSafeTimeMillis();
        while (true) {
            if (laPending.get(lIndex) == null) {
                laPending.set(lIndex, msg);
                return;
            }
            ++lIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDynamicBroadcast(com.tangosol.coherence.component.net.Member member) {
        Set setBroadcast;
        if (member != null && !this.isWellKnown(member) && (setBroadcast = this.getBroadcastAddresses()) != null) {
            Set set = setBroadcast;
            synchronized (set) {
                setBroadcast.remove(member.getSocketAddress());
            }
        }
    }

    public void removeMember(com.tangosol.coherence.component.net.Member member) {
        int nMember = member.getId();
        int c = this.getServiceInfoCount();
        for (int i = 1; i < c; ++i) {
            ServiceInfo info = this.getServiceInfo(i);
            if (info == null) continue;
            int nState = info.getMemberSet().getState(nMember);
            if (!info.getMemberSet().remove(member)) continue;
            this.onServiceLeft(info, member, nState);
        }
        if (this.getClusterMemberSet().remove(member)) {
            this.onMemberLeft(member);
        }
    }

    public void resetBroadcastCounter(DataInput stream, boolean fSelf) throws IOException {
        Coherence app = (Coherence)Coherence.get_Instance();
        XmlElement xmlAll = Coherence.getServiceConfig("$License");
        MasterMemberSet setMember = this.getClusterMemberSet();
        boolean fValid = fSelf || this.getState() == 2 && setMember.getThisMember() == setMember.getOldestMember() && !this.isMembershipSuspended();
        int nEThis = Math.max(0, this.fromString(xmlAll.getSafeElement("edition-name").getString()));
        int nMThis = Math.max(0, this.fromString(xmlAll.getSafeElement("license-mode").getString()));
        Map map = this.getWkaMap();
        int nEThat = ExternalizableHelper.readInt(stream);
        int nMThat = ExternalizableHelper.readInt(stream);
        if (!(nEThis == nEThat || nEThis == 1 && nEThat == 5 || nEThis == 5 && nEThat == 1)) {
            fValid = false;
        }
        if (nMThis != nMThat) {
            fValid = false;
        }
        int[] anType = new int[6];
        int c = anType.length;
        for (int i = 0; i < c; ++i) {
            anType[i] = -1;
        }
        for (int[] an : map.values()) {
            anType[an[0]] = an[1];
        }
        while (stream.readBoolean()) {
            int[] anOld;
            UID id = new UID(stream);
            int[] an = new int[3];
            for (int i = 0; i < 3; ++i) {
                an[i] = ExternalizableHelper.readInt(stream);
            }
            if (!fValid) continue;
            if (anType[an[0]] >= 0 && an[1] != anType[an[0]]) {
                if (an[2] >= 0) continue;
                Iterator iter = map.values().iterator();
                while (iter.hasNext()) {
                    if (((int[])iter.next())[0] != an[0]) continue;
                    iter.remove();
                }
            }
            if ((anOld = map.put(id, an)) != null && anOld[0] == an[0] && anOld[1] == an[1]) {
                an[2] = Math.max(an[2], anOld[2]);
            }
            anType[an[0]] = an[1];
        }
    }

    public void resetBroadcastCounter(String sReason, DiscoveryMessage msg) {
        this.setBroadcastCounter(0);
        com.tangosol.coherence.component.net.Member memberThis = this.getAnnounceMember();
        long ldtNow = Base.getSafeTimeMillis();
        long cMillisDelay = ldtNow - memberThis.getTimestamp();
        long cMillisMax = this.getStartupTimeout();
        long cMillisJoin = this.getBroadcastTimeoutMillis();
        long cMillisWarn = Math.min(30000L, (cMillisMax + cMillisJoin) / 2L);
        if (sReason != null && cMillisDelay > cMillisWarn) {
            long ldtLastWarning = this.getLastInterminableWarningMillis();
            if (ldtLastWarning == 0L) {
                if (this.isWkaEnabled()) {
                    ClusterService._trace("This " + String.valueOf(memberThis) + " has been attempting to join the cluster using WKA list " + String.valueOf(this.getWellKnownAddresses()) + " for " + cMillisDelay / 1000L + " seconds without success; this could indicate a mis-configured WKA, or it may simply be the result of a busy cluster or active failover.", 2);
                } else {
                    ClusterDependencies config = ((Cluster)this.getCluster()).getDependencies();
                    ClusterService._trace("This " + String.valueOf(memberThis) + " has been attempting to join the cluster at address " + config.getGroupAddress().toString() + ":" + config.getGroupPort() + " with TTL " + config.getGroupTimeToLive() + " for " + cMillisDelay / 1000L + " seconds without success; this could indicate a mis-configured TTL value, or it may simply be the result of a busy cluster or active failover.", 2);
                }
            }
            int iLevel = 6;
            if (ldtNow > ldtLastWarning + 5000L) {
                iLevel = 2;
                this.setLastInterminableWarningMillis(ldtNow);
            }
            String sMsg = msg == null ? "Delaying formation of a new cluster; " + sReason : "Received a discovery message that indicates " + sReason + ":\n" + String.valueOf(msg);
            ClusterService._trace(sMsg, iLevel);
            if (cMillisDelay > cMillisMax) {
                ClusterService._trace("Failure to join a cluster for " + cMillisDelay / 1000L + " seconds; stopping cluster service.", 1);
                this.onStopJoining();
            }
        }
    }

    @Override
    public void setAcceptingClients(boolean fAccepting) {
        boolean fPrev = this.isAcceptingClients();
        super.setAcceptingClients(fAccepting);
        if (fAccepting && !fPrev) {
            int cMillis = this.getHeartbeatDelay();
            if (cMillis == 0) {
                cMillis = Math.max(this.getBroadcastRepeatMillis(), this.getBroadcastTimeoutMillis() >>> 3);
            }
            this.setBroadcastRepeatMillis(cMillis);
        }
    }

    @Override
    public void setActionPolicy(ActionPolicy policy) {
        super.setActionPolicy(policy);
    }

    public void setAnnounceMember(com.tangosol.coherence.component.net.Member member) {
        this.__m_AnnounceMember = member;
    }

    public void setBroadcastAddresses(Set setAddresses) {
        this.__m_BroadcastAddresses = setAddresses;
    }

    public void setBroadcastAddressesExpiry(long setAddresses) {
        this.__m_BroadcastAddressesExpiry = setAddresses;
    }

    public void setBroadcastCounter(int c) {
        this.__m_BroadcastCounter = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void setBroadcastLimit(int c) {
        block42: {
            block43: {
                block39: {
                    if (c <= 0) break block42;
                    n = this.getBroadcastMode();
                    iInv = -2147483648;
                    if (n >= 1) break block43;
                    app = (Coherence)Coherence.get_Instance();
                    n = this.getBroadcastVariance();
                    cl = Base.class.getClassLoader();
                    if (cl == null) {
                        cl = Base.getContextClassLoader();
                    }
                    asName = new String[]{"com/tangosol/license/LicensedObject.class", "com/tangosol/license/LicensedObject$LicenseData.class", "com/tangosol/license/CoherenceDataGridEdition.class", "com/tangosol/license/CoherenceApplicationEdition.class", "com/tangosol/license/CoherenceCachingEdition.class", "com/tangosol/license/CoherenceComputeClient.class", "com/tangosol/license/CoherenceRealTimeClient.class", "com/tangosol/license/CoherenceDataClient.class", "tangosol.dat", "tangosol.cer"};
                    sa = new SparseArray<UID>();
                    ab = null;
                    if (cl != null) {
                        cNames = asName.length;
                        for (i = 0; i < cNames; ++i) {
                            try {
                                in = cl.getResourceAsStream(this.toString(asName[i]));
                                if (in == null) continue;
                                ab = Base.read(in);
                                n ^= Base.toCrc(ab);
                                if (i != 8) continue;
                                bufin = new Binary(ab).getBufferInput();
                                while (bufin.available() > 0) {
                                    sa.set(bufin.readPackedInt(), new UID(bufin));
                                }
                                continue;
                            }
                            catch (Throwable e) {
                                n -= this.getBroadcastRepeatMillis();
                                iInv |= 1;
                            }
                        }
                    }
                    xmlAll = Coherence.getServiceConfig("$License");
                    nEN = Math.max(0, this.fromString(xmlAll.getSafeElement("edition-name").getString()));
                    nLM = Math.max(0, this.fromString(xmlAll.getSafeElement("license-mode").getString()));
                    buf = new BinaryWriteBuffer(100);
                    try {
                        out = buf.getBufferOutput();
                        out.writePackedInt(nEN);
                        out.writePackedInt(nLM);
                        if (nEN < 2 || xmlAll == null) break block39;
                        cfc = Class.forName("java.security.cert.CertificateFactory");
                        cf = ClassHelper.invokeStatic(cfc, "getInstance", new Object[]{"X.509"});
                        ct = ClassHelper.invoke(cf, "generateCertificate", new Object[]{new Binary(ab).getInputStream()});
                        pb = ((Certificate)ct).getPublicKey();
                        sg = null;
                        sgc = Class.forName("java.security.Signature");
                        sg = ClassHelper.invokeStatic(sgc, "getInstance", new String[]{"SHA1withDSA"});
                        mUp = sgc.getMethod("update", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE});
                        mVf = sgc.getMethod("verify", new Class[]{byte[].class});
                        ClassHelper.invoke(sg, "initVerify", new Object[]{pb});
                        iLc = 15;
                        iter = xmlAll.getSafeElement("license-list").getElements("license");
                        while (iter.hasNext()) {
                            block41: {
                                block47: {
                                    block50: {
                                        block49: {
                                            block48: {
                                                block40: {
                                                    block46: {
                                                        block45: {
                                                            block44: {
                                                                xml = (XmlElement)iter.next();
                                                                id = null;
                                                                nId = 0;
                                                                nType = 0;
                                                                cStop = 0;
                                                                sP = xml.getSafeElement("software").getString();
                                                                sL = xml.getSafeElement("licensee").getString();
                                                                sA = xml.getSafeElement("agreement").getString();
                                                                sM = xml.getSafeElement("type").getString();
                                                                sF = xml.getSafeElement("from-date").getString();
                                                                sT = xml.getSafeElement("to-date").getString();
                                                                sR = xml.getSafeElement("maintenance-renewal-date").getString();
                                                                cI = xml.getSafeElement("max-seats").getInt();
                                                                cU = xml.getSafeElement("max-users").getInt();
                                                                sS = xml.getSafeElement("site").getString();
                                                                cS = xml.getSafeElement("max-servers").getInt();
                                                                cP = xml.getSafeElement("max-sockets").getInt();
                                                                cC = xml.getSafeElement("max-cpus").getInt();
                                                                sI = xml.getSafeElement("id").getString();
                                                                sK = xml.getSafeElement("key").getString();
                                                                sE = xml.getSafeElement("signature").getString();
                                                                iInv |= 1 << iLc;
                                                                if (sP.length() != 0 && sL.length() != 0 && sM.length() != 0 && sI.length() != 0) break block44;
                                                                iInv |= 2;
                                                                break block41;
                                                            }
                                                            nP = this.fromString(sP);
                                                            nM = this.fromString(sM);
                                                            if (nP >= 1) break block45;
                                                            iInv |= 4;
                                                            break block41;
                                                        }
                                                        if (nP == nEN || (nEN == 1 || nEN == 5) && (nP == 1 || nP == 5)) break block46;
                                                        iInv |= 8;
                                                        break block41;
                                                    }
                                                    if (sT.length() <= 0) ** GOTO lbl-1000
                                                    ldt = 0L;
                                                    if (sT.length() >= 8 && sT.length() <= 10) {
                                                        ldt = Coherence.parseDate(sT) + 345600000L;
                                                    }
                                                    if (this.getTimestamp() > ldt) {
                                                        iInv |= 16;
                                                    } else lbl-1000:
                                                    // 2 sources

                                                    {
                                                        if (sI.length() == 32 || sI.length() == 34) {
                                                            try {
                                                                id = new UID(sI);
                                                                break block40;
                                                            }
                                                            catch (Throwable e) {
                                                                iInv |= 32;
                                                                break block41;
                                                            }
                                                        }
                                                        iInv |= 64;
                                                    }
                                                    break block41;
                                                }
                                                if (sE.length() != 0) break block47;
                                                if (sK.length() != 0) break block48;
                                                iInv |= 128;
                                                break block41;
                                            }
                                            try {
                                                nC = (int)Long.parseLong(sK.substring(1, 9), 16);
                                                sC = new Binary(Base.parseHex(sK.substring(9, sK.length() - 1))).getBufferInput().readUTF();
                                            }
                                            catch (Exception e) {
                                                iInv |= 256;
                                                break block41;
                                            }
                                            nId = this.fromString(sC);
                                            if (nP == nId) break block49;
                                            iInv |= 512;
                                            break block41;
                                        }
                                        sb = new StringBuffer();
                                        sb.append(sP.length() == 0 ? null : sP).append(sL.length() == 0 ? null : sL).append(nM).append(sC.length() == 0 ? null : sC).append(Coherence.parseDate(sF)).append(Coherence.parseDate(sT)).append(cU).append("00").append(sS.length() == 0 ? null : sS).append(cS).append('0').append(cC).append(id);
                                        bufTemp = new BinaryWriteBuffer(sb.length() + 10);
                                        bufTemp.getBufferOutput().writeUTF(sb.toString());
                                        if (nC == Base.toCrc(bufTemp.toByteArray())) break block50;
                                        iInv |= 1024;
                                        break block41;
                                    }
                                    if (Base.equals(sa.get(nC), id)) ** GOTO lbl-1000
                                    iInv |= 2048;
                                    break block41;
                                }
                                nId = this.fromString(sP);
                                sb = new StringBuffer();
                                sb.append(sP.length() == 0 ? null : sP).append(sL.length() == 0 ? null : sL).append(sA).append(nM).append(Coherence.parseDate(sF)).append(Coherence.parseDate(sT)).append(Coherence.parseDate(sR)).append(cI).append(cU).append(sS.length() == 0 ? null : sS).append(cS).append(cP).append(cC).append(id);
                                streamRaw = new ByteArrayOutputStream();
                                stream = new DataOutputStream(streamRaw);
                                stream.writeUTF(sb.toString());
                                abRaw = streamRaw.toByteArray();
                                abSg = Base.parseHex(sE);
                                mUp.invoke(sg, new Object[]{abRaw, Base.makeInteger(0), Base.makeInteger(abRaw.length)});
                                if (!((Boolean)mVf.invoke(sg, new Object[]{abSg})).booleanValue()) {
                                    iInv |= 4096;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    if (cS > 0) {
                                        nType = 1;
                                        cStop = cS;
                                    } else if (cP > 0) {
                                        nType = 2;
                                        cStop = cP;
                                    } else if (cC > 0) {
                                        nType = 3;
                                        cStop = cC;
                                    } else if (cI > 0) {
                                        nType = 4;
                                        cStop = cI;
                                    } else if (cU > 0) {
                                        nType = 5;
                                        cStop = cU;
                                    }
                                    out.writeBoolean(true);
                                    out.write(id.toByteArray());
                                    ExternalizableHelper.writeInt(out, nId);
                                    ExternalizableHelper.writeInt(out, nType);
                                    ExternalizableHelper.writeInt(out, cStop);
                                    iInv &= ~(1 << iLc);
                                }
                            }
                            ++iLc;
                        }
                    }
                    catch (Throwable e) {
                        if (buf.length() > 2) {
                            buf.retain(0, 2);
                        }
                        iInv |= 8192;
                    }
                    finally {
                        try {
                            buf.getAppendingBufferOutput().writeBoolean(false);
                        }
                        catch (Throwable out) {}
                    }
                }
                this.setBroadcastTimestamp(buf.toBinary());
                n = n == 2 ? --n : 2;
                this.setBroadcastMode(n);
            }
            if (n > 1) {
                var3_3 = iInv | 16384;
            }
        }
        this.__m_BroadcastLimit = c;
    }

    private void setBroadcastMode(int n) {
        this.__m_BroadcastMode = n;
        try {
            this.resetBroadcastCounter(this.getBroadcastTimestamp().getBufferInput(), true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setBroadcastNextMillis(long cMillis) {
        this.__m_BroadcastNextMillis = cMillis;
    }

    public void setBroadcastRepeatMillis(int cMillis) {
        this.__m_BroadcastRepeatMillis = cMillis;
    }

    public void setBroadcastTimeoutMillis(int cMillis) {
        this.__m_BroadcastTimeoutMillis = cMillis;
    }

    private void setBroadcastTimestamp(Binary bin) {
        this.__m_BroadcastTimestamp = bin;
    }

    public void setDeliveryTimeoutMillis(int cMillis) {
        this.__m_DeliveryTimeoutMillis = cMillis;
    }

    public void setHeartbeatDelay(int cMillis) {
        this.__m_HeartbeatDelay = cMillis;
    }

    protected void setHeartbeatMemberSet(MemberSet setMember) {
        this.__m_HeartbeatMemberSet = setMember;
    }

    protected void setLastInterminableWarningMillis(long cMillis) {
        this.__m_LastInterminableWarningMillis = cMillis;
    }

    protected void setLastPanicUid(UUID uid) {
        this.__m_LastPanicUid = uid;
    }

    public void setMaximumPacketLength(int cbPacket) {
        this.__m_MaximumPacketLength = cbPacket;
    }

    public void setMembershipReopen(long ldtMillis) {
        this.__m_MembershipReopen = ldtMillis;
    }

    private void setPendingServiceJoining(LongArray la) {
        this.__m_PendingServiceJoining = la;
    }

    protected void setQuorumControl(QuorumControl control) {
        this.__m_QuorumControl = control;
    }

    public void setRequestMember(com.tangosol.coherence.component.net.Member member) {
        this.__m_RequestMember = member;
    }

    protected void setService(Grid[] aService) {
        this.__m_Service = aService;
    }

    protected synchronized void setService(int i, Grid service) {
        boolean fBeyondBounds;
        Grid[] aService = this.getService();
        boolean bl = fBeyondBounds = aService == null || i >= aService.length;
        if (fBeyondBounds && service != null) {
            int cNew = i + 1;
            Grid[] aServiceNew = new Grid[cNew];
            if (aService != null) {
                System.arraycopy(aService, 0, aServiceNew, 0, aService.length);
            }
            aService = aServiceNew;
            this.setService(aServiceNew);
            fBeyondBounds = false;
        }
        if (!fBeyondBounds) {
            aService[i] = service;
            this.setService(aService);
        }
    }

    public void setServiceContext(Map mapContext) {
        this.__m_ServiceContext = mapContext;
    }

    protected void setServiceInfo(ServiceInfo[] aInfo) {
        this.__m_ServiceInfo = aInfo;
    }

    public synchronized void setServiceInfo(int i, ServiceInfo info) {
        boolean fBeyondBounds;
        ServiceInfo[] ainfo = this.getServiceInfo();
        boolean bl = fBeyondBounds = ainfo == null || i >= ainfo.length;
        if (fBeyondBounds && info != null) {
            int cNew = i + 1;
            ServiceInfo[] ainfoNew = new ServiceInfo[cNew];
            if (ainfo != null) {
                System.arraycopy(ainfo, 0, ainfoNew, 0, ainfo.length);
            }
            ainfo = ainfoNew;
            this.setServiceInfo(ainfoNew);
            fBeyondBounds = false;
        }
        if (!fBeyondBounds) {
            ainfo[i] = info;
        }
    }

    public synchronized void setState(int nState) {
        if (nState != this.getState()) {
            switch (nState) {
                case 2: {
                    com.tangosol.coherence.component.net.Member member = this.getThisMember();
                    int nMemberId = member.getId();
                    MasterMemberSet setMember = this.getClusterMemberSet();
                    setMember.setServiceVersion(nMemberId, this.getServiceVersion());
                    setMember.setServiceJoinTime(nMemberId, member.getTimestamp());
                    setMember.setServiceEndPointName(nMemberId, "");
                    this.initializeSUID();
                    Cluster cluster = (Cluster)this.getCluster();
                    ClusterDependencies config = cluster.getDependencies();
                    if (!config.isIpMonitorEnabled()) break;
                    cluster.getIpMonitor().ensureSeniority();
                    break;
                }
            }
            this.__m_State = nState;
            this.updateServiceThreadName();
        }
        this.notifyAll();
    }

    public void setStatsJoinRequests(long cMsgs) {
        this.__m_StatsJoinRequests = cMsgs;
    }

    protected void setStatsMembersDepartureCount(long c) {
        this.__m_StatsMembersDepartureCount = c;
    }

    protected void setTcpRing(TcpRing ring) {
        this.__m_TcpRing = ring;
    }

    public void setTimestampAdjustment(long cMillis) {
        this.__m_TimestampAdjustment = cMillis;
    }

    public void setTimestampMaxVariance(int cMillis) {
        this.__m_TimestampMaxVariance = cMillis;
    }

    public void setWellKnownAddresses(Set setWka) {
        this.__m_WellKnownAddresses = setWka;
    }

    private void setWkaMap(Map map) {
        this.__m_WkaMap = map;
    }

    @Override
    public void shutdown() {
        Cluster cluster = (Cluster)this.getCluster();
        if (cluster.getState() < 4) {
            throw new IllegalStateException("Cannot shutdown ClusterService without shutting down the Cluster");
        }
        super.shutdown();
    }

    @Override
    public void stop() {
        Cluster cluster = (Cluster)this.getCluster();
        if (this.isAcceptingClients() && cluster.getState() < 4) {
            ClusterService._trace("Requested to stop cluster service.", 1);
            cluster.stop();
        } else {
            super.stop();
        }
    }

    public void unregisterServiceJoining(ServiceJoining msg) {
        ClusterService._assert(Thread.currentThread() == this.getThread());
        boolean fRemoved = false;
        LongArray laPending = this.getPendingServiceJoining();
        Iterator iter = laPending.iterator();
        while (iter.hasNext()) {
            if (!msg.equals(iter.next())) continue;
            iter.remove();
            fRemoved = true;
            break;
        }
        ClusterService._assert(fRemoved);
    }

    public boolean validateNewMember(com.tangosol.coherence.component.net.Member memberNew) {
        InetAddress addrNew = memberNew.getAddress();
        int nPortNew = memberNew.getPort();
        MasterMemberSet setMember = this.getClusterMemberSet();
        for (com.tangosol.coherence.component.net.Member member : setMember) {
            if (member.getPort() != nPortNew || !member.getAddress().equals(addrNew) || member.getUid32().equals(memberNew.getUid32())) continue;
            ClusterService._trace("New member uses existing address/port; killing the old member: " + String.valueOf(member), 3);
            this.doMemberLeft(member);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateNewService(ServiceInfo info, com.tangosol.coherence.component.net.Member member, Continuation continuation, PermissionInfo piRequest) {
        ClusterService._assert(info != null && member != null);
        int nServiceId = info.getServiceId();
        ClusterService._assert(nServiceId > 0);
        com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
        if (member != memberThis) {
            Grid serviceJoining;
            ClusterService clusterService = this;
            synchronized (clusterService) {
                serviceJoining = this.getService(nServiceId);
            }
            ServiceMemberSet setMember = info.getMemberSet();
            if (serviceJoining != null) {
                com.tangosol.coherence.component.net.Member memberOldest = setMember.getOldestMember();
                if (serviceJoining.getServiceMemberSet() != null) {
                    int nMember = member.getId();
                    Grid.NotifyServiceJoining msg = (Grid.NotifyServiceJoining)serviceJoining.instantiateMessage("NotifyServiceJoining");
                    msg.setNotifyMember(member);
                    msg.setNotifyServiceVersion(setMember.getServiceVersion(nMember));
                    msg.setNotifyServiceJoinTime(setMember.getServiceJoinTime(nMember));
                    msg.setNotifyServiceEndPointName(setMember.getServiceEndPointName(nMember));
                    msg.setNotifyMemberConfigMap(setMember.getMemberConfigMap(nMember));
                    msg.setPermissionInfo(piRequest);
                    msg.addToMember(memberThis);
                    if (continuation != null) {
                        NotifyResponse msgContinue = (NotifyResponse)this.instantiateMessage("NotifyResponse");
                        msgContinue.setService(this);
                        msgContinue.setContinuation(continuation);
                        continuation = null;
                        msg.setContinuationMessage(msgContinue);
                    }
                    serviceJoining.send(msg);
                }
            }
        }
        if (continuation != null) {
            continuation.proceed(null);
        }
    }

    public boolean validateSeniorBroadcast(DiscoveryMessage message, MemberSet setFrom) {
        UUID uidThis;
        if (this.isExiting()) {
            return false;
        }
        com.tangosol.coherence.component.net.Member memberFrom = message.getFromMember();
        if (message.isReadError()) {
            if (this.getClusterMemberSet().size() <= 1) {
                this.onMemberRejected(8162, memberFrom);
                throw new EventDeathException("Version mismatch");
            }
            ClusterService._trace("Detected another cluster senior, running on an incompatible protocol at " + String.valueOf(message.getSourceAddress()) + " manual intervention may be required", 1);
            return false;
        }
        if (message instanceof SeniorMemberHeartbeat && ((SeniorMemberHeartbeat)message).isWkaEnabled() && !Base.equals(this.getClusterName(), message.getClusterName())) {
            return false;
        }
        switch (this.getState()) {
            case 0: 
            case 1: {
                if (message instanceof SeniorMemberHeartbeat && this.isWkaEnabled() != ((SeniorMemberHeartbeat)message).isWkaEnabled()) {
                    this.onMemberRejected(8166, memberFrom);
                    throw new EventDeathException("WKA mismatch");
                }
                if (!message.getClusterName().equals(this.getClusterName())) {
                    this.onMemberRejected(8167, memberFrom);
                    throw new EventDeathException("Cluster name mismatch");
                }
                this.resetBroadcastCounter("the presence of an existing cluster that does not respond to join requests; this is usually caused by a network layer failure", message);
                this.addDynamicBroadcast(memberFrom);
            }
            default: {
                return false;
            }
            case 2: 
        }
        MasterMemberSet setMember = this.getClusterMemberSet();
        com.tangosol.coherence.component.net.Member memberThis = setMember.getThisMember();
        com.tangosol.coherence.component.net.Member memberOldest = setMember.getOldestMember();
        if (memberThis == null || memberOldest == null) {
            return false;
        }
        if (memberFrom.equals(memberOldest)) {
            return true;
        }
        UUID uidFrom = memberFrom.getUid32();
        ClusterService._assert(!uidFrom.equals(uidThis = memberThis.getUid32()));
        if (memberThis == memberOldest && message instanceof SeniorMemberHeartbeat && ((SeniorMemberHeartbeat)message).isWkaEnabled()) {
            if (this.isWkaEnabled()) {
                this.addDynamicBroadcast(memberFrom);
            } else {
                SeniorMemberHeartbeat msg = (SeniorMemberHeartbeat)this.instantiateMessage("SeniorMemberHeartbeat");
                msg.setToMember(memberFrom);
                msg.setLastReceivedMillis(this.calcTimestamp(memberThis.getLastIncomingMillis()));
                msg.setMemberSet(setMember);
                msg.setWkaEnabled(this.isWkaEnabled());
                msg.setLastJoinTime(setMember.getLastJoinTime());
                this.send(msg);
            }
        }
        long ldtCurrent = Base.getSafeTimeMillis();
        long cTimeout = this.getDeliveryTimeoutMillis();
        long cHeartbeat = this.getHeartbeatDelay();
        com.tangosol.coherence.component.net.Member memberDead = setMember.findDeadMember(memberFrom);
        boolean fPanicActivated = uidFrom.equals(this.getLastPanicUid());
        if (memberDead != null) {
            ClusterService._assert(memberDead.isDead());
            if (!fPanicActivated) {
                this.setMembershipReopen(ldtCurrent + cTimeout / 4L);
            }
            if (!memberDead.isZombie()) {
                ClusterService._trace("The member formerly known as " + String.valueOf(memberDead) + " has been forcefully evicted from the cluster, but continues to emit a cluster heartbeat; henceforth, the member will be shunned and its messages will be ignored.", 2);
                memberDead.declareZombie();
                return false;
            }
            if (!(ldtCurrent <= memberDead.getTimestamp() + cTimeout || memberThis != memberOldest && this.isWellKnown(memberDead))) {
                memberDead.declareZombie();
                this.setLastPanicUid(null);
                fPanicActivated = false;
            } else {
                return false;
            }
        }
        if (memberThis == memberOldest) {
            if (setFrom == null) {
                return false;
            }
            int cSizeThis = setMember.size();
            int cSizeFrom = setFrom.size();
            if (setMember.getMember(uidFrom) != null && cSizeThis - cSizeFrom < cSizeFrom && setMember.containsAll((Collection)setFrom)) {
                ClusterService._trace("This senior " + String.valueOf(memberThis) + " appears to have been disconnected from other nodes due to a long period of inactivity and the seniority has been assumed by the " + String.valueOf(memberFrom) + "; stopping cluster service.", 1);
                this.onStopRunning();
                return false;
            }
            if (!fPanicActivated) {
                this.setMembershipReopen(ldtCurrent + 4L * cHeartbeat);
            }
            if (cSizeThis == 1 || cSizeFrom == 1) {
                boolean fStop;
                if (cSizeThis > 1) {
                    fStop = false;
                } else if (cSizeFrom > 1) {
                    fStop = true;
                } else {
                    boolean bl = fStop = uidThis.compareTo(uidFrom) > 0;
                }
                if (fStop) {
                    ClusterService._trace("This senior " + String.valueOf(memberThis) + " appears to have been disconnected from another senior " + String.valueOf(memberFrom) + "; stopping cluster service.", 1);
                    this.onStopRunning();
                } else {
                    long ldtWarning = this.getLastInterminableWarningMillis();
                    if (ldtCurrent > ldtWarning + cTimeout) {
                        if (ldtWarning > 0L) {
                            String sCause = cSizeThis == 1 ? "younger that this member" : "the only member of its cluster";
                            ClusterService._trace("This senior " + String.valueOf(memberThis) + " appears to have been disconnected from another senior " + String.valueOf(memberFrom) + ", which is " + sCause + ", but did not respond to any of the termination requests; manual intervention may be necessary to stop that process.", 2);
                            this.setLastPanicUid(uidFrom);
                        }
                        this.setLastInterminableWarningMillis(ldtCurrent);
                    }
                }
                return false;
            }
            if (cSizeThis < cSizeFrom || cSizeThis == cSizeFrom && uidThis.compareTo(uidFrom) > 0) {
                return false;
            }
            if (!fPanicActivated) {
                ClusterService._trace("An existence of a cluster island with senior " + String.valueOf(memberFrom) + " containing " + cSizeFrom + " nodes have been detected. Since this " + String.valueOf(memberThis) + " is the senior of " + (cSizeThis > cSizeFrom ? "a larger" : "an older") + " cluster island, the panic protocol is being activated to stop the other island's senior and all junior nodes that belong to it.", 2);
                this.setLastPanicUid(uidFrom);
                SeniorMemberPanic msg = (SeniorMemberPanic)this.instantiateMessage("SeniorMemberPanic");
                MemberSet setTo = new MemberSet();
                setTo.addAll((Collection)setMember);
                setTo.remove(memberThis);
                msg.setCulpritMember(memberFrom);
                msg.setToMemberSet(setTo);
                this.send(msg);
            }
        } else if (!fPanicActivated) {
            this.setLastPanicUid(uidFrom);
            ClusterService._trace("Notifying the senior " + String.valueOf(memberOldest) + " of an unexpected cluster heartbeat from " + (memberDead == null ? "" : "departed ") + String.valueOf(memberFrom), 2);
            SeniorMemberPanic msg = (SeniorMemberPanic)this.instantiateMessage("SeniorMemberPanic");
            msg.setCulpritMember(memberFrom);
            msg.addToMember(memberOldest);
            this.send(msg);
        }
        return false;
    }

    protected boolean verifyMemberLeft(com.tangosol.coherence.component.net.Member memberSuspect, MessagePacket packet) {
        if (!this.isRunning()) {
            return false;
        }
        if (memberSuspect == null) {
            return true;
        }
        MasterMemberSet setMembers = this.getClusterMemberSet();
        int cMembers = ((MemberSet)setMembers).size();
        if (packet != null && !this.isHeuristicallyDead(memberSuspect)) {
            Set setSlow = this.getSlowMembers();
            if (setSlow == null || !setSlow.contains(memberSuspect)) {
                this.verifyMemberSlow(memberSuspect, packet);
                ClusterService._trace("This member is running extremely slowly and may endanger the rest of the cluster. Marking this member as suspect.", 1);
                this.onMembersTimedOut(Collections.singleton(this.getThisMember()));
                return false;
            }
            int cSlow = setSlow.size();
            int iVote = this.compareImportance(memberSuspect);
            if (iVote > 0 || iVote == 0 && cSlow == 1) {
                if (!memberSuspect.isTimedOut()) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Timeout while delivering a packet");
                    if (cSlow == 1) {
                        sb.append("to ").append(this.getMemberStatsDescription(memberSuspect)).append("; the member appears to be alive, but exhibits long periods of unresponsiveness ");
                    } else {
                        sb.append(" to a lower priority ").append(this.getMemberStatsDescription(memberSuspect));
                    }
                    sb.append(". Marking Member ").append(memberSuspect.getId()).append(" as suspect.");
                    ClusterService._trace(sb.toString(), 2);
                }
                return true;
            }
        }
        if (!memberSuspect.isDeaf()) {
            if (memberSuspect.isDead()) {
                return true;
            }
            MemberSet setWitness = this.getWitnessMemberSet(memberSuspect);
            if (setWitness == null) {
                if (!this.getThisMember().isTimedOut()) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("This node appears to have become disconnected from the rest of the cluster containing ").append(cMembers - 1).append(" nodes. All departure confirmation requests went unanswered.");
                    ClusterService._trace(sb.toString(), 1);
                }
                this.onMembersTimedOut(Collections.singleton(this.getThisMember()));
                return false;
            }
            memberSuspect.setDeaf(true);
            StringBuffer sb = new StringBuffer();
            sb.append("Timeout while delivering a " + (packet == null ? "message" : "packet"));
            if (packet != null && ClusterService._isTraceEnabled(6)) {
                sb.append(' ').append(packet);
            }
            sb.append("; requesting time-out confirmation for ").append(this.getMemberStatsDescription(memberSuspect)).append("\nby ").append(setWitness);
            ClusterService._trace(sb.toString(), 2);
            WitnessRequest msg = (WitnessRequest)this.instantiateMessage("WitnessRequest");
            msg.setToMemberSet(setWitness);
            msg.setMemberUUID(memberSuspect.getUid32());
            this.send(msg);
        }
        return false;
    }

    public void verifyMemberSlow(com.tangosol.coherence.component.net.Member memberSlow, MessagePacket packet) {
        int cTimeoutMillis;
        long lLastInMillis;
        if (!this.isRunning() || memberSlow == null) {
            return;
        }
        long lCurrentMillis = Base.getSafeTimeMillis();
        if (lCurrentMillis - (lLastInMillis = memberSlow.getLastIncomingMillis()) < (long)((cTimeoutMillis = this.getDeliveryTimeoutMillis()) >> 1)) {
            if (!this.isSlow(memberSlow)) {
                long lFirstSentMillis = packet.getResendTimeout() - (long)cTimeoutMillis;
                long lFailedAckMillis = lCurrentMillis - lFirstSentMillis;
                long cRecentMillis = lCurrentMillis - lLastInMillis;
                int cbPacket = packet.getLength();
                DependentMemberSet setTo = packet.getToMemberSet();
                boolean fMulticast = setTo != null && !this.isWkaEnabled() && ((Cluster)this.getCluster()).getPublisher().isMulticast(((MemberSet)setTo).size());
                StringBuffer sb = new StringBuffer();
                sb.append("A potential communication problem has been detected. ").append("A packet has failed to be acknowledged");
                if (setTo != null && ((MemberSet)setTo).size() > 1) {
                    sb.append(" by ").append(((MemberSet)setTo).size()).append(" members");
                }
                sb.append(" after ").append(lFailedAckMillis / 1000L).append(" seconds, although other packets were acknowledged by ").append(this.getMemberStatsDescription(memberSlow)).append(" to this ").append(this.getThisMember()).append(" as recently as ").append(cRecentMillis / 1000L).append(" seconds ago. ");
                if (fMulticast || cbPacket > 1468) {
                    if (fMulticast) {
                        sb.append("It is possible this was caused by a multicast failure");
                        if (!InetAddressHelper.PreferIPv4Stack) {
                            sb.append("; you may need to run the JVM with the system property ").append("\"-Djava.net.preferIPv4Stack=true\"");
                        }
                        sb.append(". ");
                    }
                    if (cbPacket > 1468) {
                        sb.append("It is possible that the packet size ").append(cbPacket).append(" , which is greater than 1468, is responsible; for example, some network ").append("equipment cannot handle packets larger than 1468 bytes (UDP) or 1448 bytes (TCP).").append("Use the 'ping' command with the <size> option to verify successful").append(" delivery of specifically sized packets.");
                    }
                    sb.append(" Other possible");
                } else {
                    sb.append(" Possible");
                }
                sb.append(" causes include network failure, poor thread scheduling (see FAQ if running on Windows), ").append("an extremely overloaded server, a server that is attempting to run its ").append("processes using swap space, and unreasonably lengthy GC times.");
                ClusterService._trace(sb.toString(), 2);
            }
            memberSlow.setLastSlowMillis(lCurrentMillis);
        }
    }

    static {
        ClusterService.__initStatic();
    }

    public static class MemberHeartbeat
    extends Message {
        private long __m_LastReceivedMillis;

        public MemberHeartbeat() {
            this(null, null, true);
        }

        public MemberHeartbeat(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(33);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MemberHeartbeat();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$MemberHeartbeat".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            long lLastReceivedMillis = this.getLastReceivedMillis();
            String sLastReceivedMillis = lLastReceivedMillis == 0L ? "none" : new Date(lLastReceivedMillis).toString();
            return "LastReceivedMillis=" + sLastReceivedMillis;
        }

        public long getLastReceivedMillis() {
            return this.__m_LastReceivedMillis;
        }

        @Override
        public void onReceived() {
            super.onReceived();
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            this.setLastReceivedMillis(input.readLong());
        }

        public void setLastReceivedMillis(long cMillis) {
            this.__m_LastReceivedMillis = cMillis;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            output.writeLong(this.getLastReceivedMillis());
        }
    }

    public static class MemberJoined
    extends Grid.MemberJoined {
        private com.tangosol.coherence.component.net.Member __m_Member;
        private String __m_ServiceVersion;

        public MemberJoined() {
            this(null, null, true);
        }

        public MemberJoined(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(4);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MemberJoined();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$MemberJoined".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return super.getDescription() + "\nServiceVersion=" + this.getServiceVersion();
        }

        public com.tangosol.coherence.component.net.Member getMember() {
            return this.__m_Member;
        }

        public String getServiceVersion() {
            return this.__m_ServiceVersion;
        }

        @Override
        public void onReceived() {
            ClusterService service = (ClusterService)this.getService();
            service.ensureMember(this.getMember(), this.getServiceVersion());
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            ClusterService service = (ClusterService)this.getService();
            com.tangosol.coherence.component.net.Member member = service.instantiateMember();
            member.readExternal(input);
            member.setTcpRingPort(input.readInt());
            this.setMember(member);
            this.setServiceVersion(input.readUTF());
        }

        public void setMember(com.tangosol.coherence.component.net.Member member) {
            this.__m_Member = member;
        }

        public void setServiceVersion(String sVersion) {
            this.__m_ServiceVersion = sVersion;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            this.getMember().writeExternal(output);
            output.writeInt(this.getMember().getTcpRingPort());
            output.writeUTF(this.getServiceVersion());
        }
    }

    public static class MemberLeaving
    extends Message {
        private int __m_MemberId;
        private UUID __m_MemberUid;

        public MemberLeaving() {
            this(null, null, true);
        }

        public MemberLeaving(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(35);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MemberLeaving();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$MemberLeaving".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "MemberId=" + this.getMemberId() + "\nMemberUid=" + String.valueOf(this.getMemberUid());
        }

        public int getMemberId() {
            return this.__m_MemberId;
        }

        public UUID getMemberUid() {
            return this.__m_MemberUid;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ClusterService service = (ClusterService)this.getService();
            com.tangosol.coherence.component.net.Member member = service.getClusterMemberSet().getMember(this.getMemberId());
            if (member != null) {
                MemberLeaving._assert(this.getMemberUid().equals(member.getUid32()));
                if (!member.isLeaving()) {
                    member.setLeaving(true);
                    service.onMemberLeaving(member);
                }
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            this.setMemberId(input.readUnsignedShort());
            this.setMemberUid(new UUID(input));
        }

        public void setMemberId(int nId) {
            this.__m_MemberId = nId;
        }

        public void setMemberUid(UUID uid) {
            this.__m_MemberUid = uid;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            output.writeShort(this.getMemberId());
            this.getMemberUid().writeExternal(output);
        }
    }

    public static class MemberLeft
    extends Message {
        private transient int __m_MemberCount;
        private short[] __m_MemberIDs;
        private long[] __m_MemberTimestamps;
        private UUID[] __m_MemberUUIDs;
        private boolean __m_SynchronizationRequest;

        public MemberLeft() {
            this(null, null, true);
        }

        public MemberLeft(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(36);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MemberLeft();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$MemberLeft".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public int getMemberCount() {
            return this.__m_MemberCount;
        }

        public short[] getMemberIDs() {
            return this.__m_MemberIDs;
        }

        public short getMemberIDs(int i) {
            return this.getMemberIDs()[i];
        }

        public long[] getMemberTimestamps() {
            return this.__m_MemberTimestamps;
        }

        public long getMemberTimestamps(int i) {
            return this.getMemberTimestamps()[i];
        }

        public UUID[] getMemberUUIDs() {
            return this.__m_MemberUUIDs;
        }

        public UUID getMemberUUIDs(int i) {
            return this.getMemberUUIDs()[i];
        }

        public boolean isSynchronizationRequest() {
            return this.__m_SynchronizationRequest;
        }

        @Override
        public void onReceived() {
            ClusterService service = (ClusterService)this.getService();
            com.tangosol.coherence.component.net.Member memberFrom = this.getFromMember();
            Object[] auuid = this.getMemberUUIDs();
            short[] anid = this.getMemberIDs();
            long[] aldtDeath = this.getMemberTimestamps();
            MasterMemberSet setMembers = service.getClusterMemberSet();
            ActualMemberSet setDead = setMembers.getRecycleSet();
            int c = this.getMemberCount();
            for (int i = 0; i < c; ++i) {
                com.tangosol.coherence.component.net.Member member = setMembers.getMember(auuid[i]);
                if (memberFrom == member) {
                    service.removeMember(member);
                    MemberLeft._trace("MemberLeft announcement from " + String.valueOf(member), 3);
                    continue;
                }
                if (member != null) {
                    service.removeMember(member);
                    MemberLeft._trace("MemberLeft notification for " + String.valueOf(member) + " received from " + String.valueOf(memberFrom), 3);
                    continue;
                }
                if (setMembers.contains(anid[i])) continue;
                member = ((MemberSet)setDead).getMember(anid[i]);
                long ldtDeath = aldtDeath[i] - service.getTimestampAdjustment();
                if (member != null && (member.getTimestamp() >= ldtDeath || member.getUid32().equals(auuid[i]))) continue;
                member = new com.tangosol.coherence.component.net.Member();
                member.configureDead(anid[i], (UUID)auuid[i], ldtDeath);
                member.setLeaving(true);
                ((MemberSet)setDead).add(member);
            }
            if (this.isSynchronizationRequest()) {
                service.ensureMemberLeft(this.getFromMember(), new ImmutableArrayList(auuid).getSet(), false);
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setSynchronizationRequest(input.readBoolean());
            int cDead = input.readInt();
            short[] anID = new short[cDead];
            long[] aldtDeath = new long[cDead];
            UUID[] aUUID = new UUID[cDead];
            for (int i = 0; i < cDead; ++i) {
                anID[i] = input.readShort();
                aldtDeath[i] = input.readLong();
                aUUID[i] = new UUID();
                aUUID[i].readExternal(input);
            }
            this.setMemberCount(cDead);
            this.setMemberIDs(anID);
            this.setMemberTimestamps(aldtDeath);
            this.setMemberUUIDs(aUUID);
        }

        public void setMemberCount(int nCount) {
            this.__m_MemberCount = nCount;
        }

        public void setMemberIDs(short[] anIDs) {
            this.__m_MemberIDs = anIDs;
        }

        public void setMemberIDs(int i, short nID) {
            this.getMemberIDs()[i] = nID;
        }

        public void setMemberTimestamps(long[] aldt) {
            this.__m_MemberTimestamps = aldt;
        }

        public void setMemberTimestamps(int i, long ldt) {
            this.getMemberTimestamps()[i] = ldt;
        }

        public void setMemberUUIDs(UUID[] auuid) {
            this.__m_MemberUUIDs = auuid;
        }

        public void setMemberUUIDs(int i, UUID uuid) {
            this.getMemberUUIDs()[i] = uuid;
        }

        public void setSynchronizationRequest(boolean fRequest) {
            this.__m_SynchronizationRequest = fRequest;
        }

        @Override
        public String toString() {
            return "Request=" + this.isSynchronizationRequest() + ", Members=" + java.util.Arrays.toString(this.getMemberIDs());
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeBoolean(this.isSynchronizationRequest());
            int cDead = this.getMemberCount();
            short[] anID = this.getMemberIDs();
            long[] alDeath = this.getMemberTimestamps();
            UUID[] aUUID = this.getMemberUUIDs();
            output.writeInt(cDead);
            for (int i = 0; i < cDead; ++i) {
                output.writeShort(anID[i]);
                output.writeLong(alDeath[i]);
                aUUID[i].writeExternal(output);
            }
        }
    }

    public static class NewMemberAnnounce
    extends DiscoveryMessage {
        private int __m_AnnounceProtocolVersion;
        private int __m_AttemptCounter;
        private int __m_AttemptLimit;
        public static final int MESSAGE_TYPE = 7;
        private transient long __m_ThisRecvTimestamp;
        private long __m_ThisSentTimestamp;

        public NewMemberAnnounce() {
            this(null, null, true);
        }

        public NewMemberAnnounce(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(7);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NewMemberAnnounce();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NewMemberAnnounce".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public int getAnnounceProtocolVersion() {
            return this.__m_AnnounceProtocolVersion;
        }

        public int getAttemptCounter() {
            return this.__m_AttemptCounter;
        }

        public int getAttemptLimit() {
            return this.__m_AttemptLimit;
        }

        @Override
        public String getDescription() {
            long lThisSentTimestamp = this.getThisSentTimestamp() & 0xFFFFFFFFFFFFFFL;
            long lThisRecvTimestamp = this.getThisRecvTimestamp();
            String sThisSentTimestamp = lThisSentTimestamp == 0L ? "none" : new Date(lThisSentTimestamp).toString();
            String sThisRecvTimestamp = lThisRecvTimestamp == 0L ? "none" : new Date(lThisRecvTimestamp).toString();
            return "AttemptCounter=" + this.getAttemptCounter() + "\nAttemptLimit=" + this.getAttemptLimit() + "\nThisSentTimestamp=" + sThisSentTimestamp + "\nThisRecvTimestamp=" + sThisRecvTimestamp;
        }

        public long getThisRecvTimestamp() {
            return this.__m_ThisRecvTimestamp;
        }

        public long getThisSentTimestamp() {
            return this.__m_ThisSentTimestamp;
        }

        @Override
        public void onReceived() {
            InetAddress addrSrc;
            super.onReceived();
            ClusterService service = (ClusterService)this.getService();
            com.tangosol.coherence.component.net.Member memberNew = this.getFromMember();
            InetSocketAddress addrSockSrc = (InetSocketAddress)this.getSourceAddress();
            InetAddress inetAddress = addrSrc = addrSockSrc == null ? null : addrSockSrc.getAddress();
            if (this.getAnnounceProtocolVersion() < 1 || !service.isWkaEnabled() || addrSrc == null || memberNew.getAddress().equals(addrSrc) || addrSockSrc.getPort() != memberNew.getPort() || InetAddresses.isLocalAddress(addrSrc)) {
                addrSockSrc = null;
                addrSrc = null;
            }
            service.setStatsJoinRequests(service.getStatsJoinRequests() + 1L);
            switch (service.getState()) {
                case 0: {
                    if (this.isReadError()) {
                        service.onMemberRejected(8162, memberNew);
                        throw new EventDeathException("Version mismatch");
                    }
                    com.tangosol.coherence.component.net.Member memberThis = service.getAnnounceMember();
                    if (memberNew.equals(memberThis)) {
                        ClusterDependencies config = service.getCluster().getDependencies();
                        if (addrSrc == null || config.getLocalAddress() != null) break;
                        com.tangosol.coherence.component.net.Member memberAnnounce = service.instantiateMember();
                        memberAnnounce.configure(config, addrSrc, memberThis.getPort(), memberThis.getTcpRingPort(), new int[]{memberThis.getCpuCount(), memberThis.getSocketCount(), memberThis.getMachineId()});
                        service.setAnnounceMember(memberAnnounce);
                        service.resetBroadcastCounter("selecting alternate member address", this);
                        break;
                    }
                    if (this.getAttemptCounter() <= this.getAttemptLimit() / 3 || !service.isWellKnown(memberNew.getAddress()) && !service.isWellKnown(memberNew) && (addrSrc == null || !service.isWellKnown(addrSrc)) || memberThis.compareTo(memberNew) <= 0) break;
                    service.resetBroadcastCounter("an older member announcing", this);
                    break;
                }
                case 2: {
                    boolean fJoinSuspended;
                    if (this.isReadError()) {
                        throw new EventDeathException("Version mismatch");
                    }
                    MasterMemberSet setMember = service.getClusterMemberSet();
                    com.tangosol.coherence.component.net.Member memberThis = setMember.getThisMember();
                    com.tangosol.coherence.component.net.Member memberSenior = setMember.getOldestMember();
                    boolean fRecordAnnouncing = fJoinSuspended = service.isMembershipSuspended();
                    if (memberThis == memberSenior && !fJoinSuspended) {
                        if (memberNew.getId() == 0) {
                            NewMemberAnnounceReply msg = (NewMemberAnnounceReply)service.instantiateMessage("NewMemberAnnounceReply");
                            msg.setAnnounceProtocolVersion(1);
                            msg.setToMember(memberNew);
                            msg.setPrevSentTimestamp(this.getThisSentTimestamp());
                            msg.setPrevRecvTimestamp(this.getThisRecvTimestamp());
                            msg.setExternalAddress(addrSockSrc);
                            service.send(msg);
                        } else {
                            SeniorMemberHeartbeat msg = (SeniorMemberHeartbeat)service.instantiateMessage("SeniorMemberHeartbeat");
                            msg.setLastReceivedMillis(service.calcTimestamp(memberThis.getLastIncomingMillis()));
                            msg.setMemberSet(setMember);
                            msg.setWkaEnabled(service.isWkaEnabled());
                            msg.setLastJoinTime(setMember.getLastJoinTime());
                            msg.setToMember(memberNew);
                            service.send(msg);
                        }
                    } else if (this.getAttemptCounter() > this.getAttemptLimit() >>> 2 || !service.isWellKnown(memberSenior.getAddress()) && !service.isWellKnown(memberSenior)) {
                        NewMemberAnnounceWait msg = (NewMemberAnnounceWait)service.instantiateMessage("NewMemberAnnounceWait");
                        msg.setToMember(memberNew);
                        msg.setSeniorMember(memberSenior);
                        msg.setExternalAddress(addrSockSrc);
                        service.send(msg);
                        fRecordAnnouncing = true;
                    }
                    if (!fRecordAnnouncing) break;
                    service.getQuorumControl().onMemberAnnounceWaiting(memberNew);
                }
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            MessagePacket packet;
            super.read(input);
            this.setAttemptCounter(input.readInt());
            this.setAttemptLimit(input.readInt());
            long ldtSentAndVer = input.readLong();
            this.setAnnounceProtocolVersion((int)(ldtSentAndVer >>> 56));
            this.setThisSentTimestamp(ldtSentAndVer);
            MessagePacket[] aPacket = this.getPacket();
            if (aPacket != null && aPacket.length > 0 && (packet = aPacket[0]) != null) {
                this.setThisRecvTimestamp(((ClusterService)this.getService()).calcTimestamp(packet.getReceivedMillis()));
            }
            if (input.available() > 0) {
                byte[] abSrc = new byte[input.readInt()];
                input.readFully(abSrc);
                this.setSourceAddress(new InetSocketAddress(InetAddress.getByAddress(abSrc), input.readInt()));
            }
            this.ensureEOS(input);
        }

        public void setAnnounceProtocolVersion(int nVersion) {
            if ((nVersion & 0xFFFFFF00) != 0) {
                throw new IllegalArgumentException("version exceeds max bit width");
            }
            this.__m_AnnounceProtocolVersion = nVersion;
        }

        public void setAttemptCounter(int n) {
            this.__m_AttemptCounter = n;
        }

        public void setAttemptLimit(int c) {
            this.__m_AttemptLimit = c;
        }

        protected void setThisRecvTimestamp(long ldt) {
            this.__m_ThisRecvTimestamp = ldt;
        }

        public void setThisSentTimestamp(long cMillis) {
            this.__m_ThisSentTimestamp = cMillis;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            this.setThisSentTimestamp(Base.getSafeTimeMillis() | (long)this.getAnnounceProtocolVersion() << 56);
            output.writeInt(this.getAttemptCounter());
            output.writeInt(this.getAttemptLimit());
            output.writeLong(this.getThisSentTimestamp());
        }
    }

    public static class NewMemberAnnounceReply
    extends DiscoveryMessage {
        private int __m_AnnounceProtocolVersion;
        private static long __s_LastTraceMillis;
        private long __m_PrevRecvTimestamp;
        private long __m_PrevSentTimestamp;
        private transient long __m_ThisRecvTimestamp;
        private long __m_ThisSentTimestamp;

        public NewMemberAnnounceReply() {
            this(null, null, true);
        }

        public NewMemberAnnounceReply(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(8);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NewMemberAnnounceReply();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NewMemberAnnounceReply".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public int getAnnounceProtocolVersion() {
            return this.__m_AnnounceProtocolVersion;
        }

        @Override
        public String getDescription() {
            long lPrevSentTimestamp = this.getPrevSentTimestamp() & 0xFFFFFFFFFFFFFFL;
            long lPrevRecvTimestamp = this.getPrevRecvTimestamp();
            long lThisSentTimestamp = this.getThisSentTimestamp();
            long lThisRecvTimestamp = this.getThisRecvTimestamp();
            String sPrevSentTimestamp = lPrevSentTimestamp == 0L ? "none" : new Date(lPrevSentTimestamp).toString();
            String sPrevRecvTimestamp = lPrevRecvTimestamp == 0L ? "none" : new Date(lPrevRecvTimestamp).toString();
            String sThisSentTimestamp = lThisSentTimestamp == 0L ? "none" : new Date(lThisSentTimestamp).toString();
            String sThisRecvTimestamp = lThisRecvTimestamp == 0L ? "none" : new Date(lThisRecvTimestamp).toString();
            return "ToMember=" + String.valueOf(this.getToMember()) + "\nPrevSentTimestamp=" + sPrevSentTimestamp + "\nPrevRecvTimestamp=" + sPrevRecvTimestamp + "\nThisSentTimestamp=" + sThisSentTimestamp + "\nThisRecvTimestamp=" + sThisRecvTimestamp + "\nMaxDeliveryVariance=" + this.getMaxDeliveryVariance();
        }

        public static long getLastTraceMillis() {
            return __s_LastTraceMillis;
        }

        protected int getMaxDeliveryVariance() {
            ClusterService service = (ClusterService)this.getService();
            return service.getTimestampMaxVariance();
        }

        public long getPrevRecvTimestamp() {
            return this.__m_PrevRecvTimestamp;
        }

        public long getPrevSentTimestamp() {
            return this.__m_PrevSentTimestamp;
        }

        protected long getThisRecvTimestamp() {
            return this.__m_ThisRecvTimestamp;
        }

        public long getThisSentTimestamp() {
            return this.__m_ThisSentTimestamp;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ClusterService service = (ClusterService)this.getService();
            com.tangosol.coherence.component.net.Member memberFrom = this.getFromMember();
            com.tangosol.coherence.component.net.Member memberTo = this.getToMember();
            switch (service.getState()) {
                case 0: {
                    if (this.isReadError()) {
                        service.onMemberRejected(8162, memberFrom);
                        throw new EventDeathException("Version mismatch");
                    }
                    com.tangosol.coherence.component.net.Member memberAnnounce = service.getAnnounceMember();
                    if (memberTo.equals(memberAnnounce)) {
                        TcpRing ring;
                        service.resetBroadcastCounter(null, this);
                        Cluster cluster = (Cluster)service.getCluster();
                        ClusterDependencies config = cluster.getDependencies();
                        if (!cluster.isAuthorizedHost(memberFrom.getAddress())) {
                            service.onMemberRejected(8165, memberFrom);
                            throw new EventDeathException("Unauthorized senior");
                        }
                        Cluster.SocketManager.UnicastUdpSocket socket = cluster.getSocketManager().getUnicastUdpSocket();
                        if (socket.getInetAddress().isAnyLocalAddress()) {
                            InetAddress addrRebind;
                            InetSocketAddress addrSockExt = this.getExternalAddress();
                            InetAddress addrExt = addrSockExt == null ? null : addrSockExt.getAddress();
                            InetAddress addrAnnounce = memberAnnounce.getAddress();
                            InetAddress inetAddress = addrRebind = addrExt == null ? addrAnnounce : addrExt;
                            if (InetAddresses.isLocalAddress(addrRebind)) {
                                try {
                                    socket.rebind(addrRebind);
                                }
                                catch (IOException e) {
                                    ClusterJoinException eJoin = new ClusterJoinException();
                                    eJoin.initCause(e);
                                    throw eJoin;
                                }
                            }
                            if (service.isWkaEnabled() && addrExt != null && !addrExt.equals(addrAnnounce) && config.getLocalAddress() == null) {
                                com.tangosol.coherence.component.net.Member memberAnnounceNew = service.instantiateMember();
                                memberAnnounceNew.configure(config, addrExt, memberAnnounce.getPort(), memberAnnounce.getTcpRingPort(), new int[]{memberAnnounce.getCpuCount(), memberAnnounce.getSocketCount(), memberAnnounce.getMachineId()});
                                memberAnnounce = memberAnnounceNew;
                                service.setAnnounceMember(memberAnnounce);
                            }
                        }
                        if ((ring = service.getTcpRing()).isEnabled() && !ring.verifyReachable(memberFrom, 1000L)) {
                            service.resetBroadcastCounter("TcpRing failed to connect to senior " + String.valueOf(memberFrom) + "; if this persists it is likely the result of a local or remote firewall rule blocking connections to TCP-ring port " + memberFrom.getTcpRingPort(), null);
                            return;
                        }
                        if (config.isIpMonitorEnabled() && !memberFrom.isCollocated(memberTo) && !cluster.getIpMonitor().verifyReachable(memberFrom)) {
                            service.resetBroadcastCounter("IpMonitor failed to verify the reachability of senior " + String.valueOf(memberFrom) + "  via " + String.valueOf(memberTo.getAddress()) + "; if this persists it is likely the result of a local or remote firewall rule blocking either ICMP pings, or connections to TCP port 7", null);
                            return;
                        }
                        long cPrevSentMillis = this.getPrevSentTimestamp();
                        long cPrevRecvMillis = this.getPrevRecvTimestamp();
                        long cThisSentMillis = this.getThisSentTimestamp();
                        long cThisRecvMillis = this.getThisRecvTimestamp();
                        long cMillisGoing = cPrevRecvMillis - cPrevSentMillis;
                        long cMillisComing = cThisSentMillis - cThisRecvMillis;
                        long cMillisMaxVar = this.getMaxDeliveryVariance();
                        long cMillisVar = Math.abs(cMillisGoing - cMillisComing);
                        if (cMillisVar <= cMillisMaxVar) {
                            long cMillisDif = (cMillisGoing + cMillisComing) / 2L;
                            service.setTimestampAdjustment(cMillisDif);
                            com.tangosol.coherence.component.net.Member memberThis = service.instantiateMember();
                            memberThis.configure(memberAnnounce, cThisSentMillis);
                            service.setRequestMember(memberThis);
                            service.setState(1);
                            break;
                        }
                        long lMillis = Base.getSafeTimeMillis();
                        int nLevel = 5;
                        if (lMillis - NewMemberAnnounceReply.getLastTraceMillis() >= (long)service.getBroadcastTimeoutMillis()) {
                            NewMemberAnnounceReply.setLastTraceMillis(lMillis);
                            nLevel = 3;
                        }
                        NewMemberAnnounceReply._trace("Failed to satisfy the variance: allowed=" + cMillisMaxVar + ", actual=" + (cMillisGoing - cMillisComing), nLevel);
                        int cNewVariance = (int)Math.min(cMillisMaxVar + Math.max((cMillisVar - cMillisMaxVar) / 8L, 1L), 1000L);
                        if ((long)cNewVariance == cMillisMaxVar) break;
                        service.setTimestampMaxVariance(cNewVariance);
                        NewMemberAnnounceReply._trace("Increasing allowable variance to " + cNewVariance, nLevel);
                        break;
                    }
                    service.resetBroadcastCounter("the presence of an existing cluster", this);
                    break;
                }
                case 1: {
                    if (this.isReadError()) {
                        service.onMemberRejected(8162, memberFrom);
                        throw new EventDeathException("Version mismatch");
                    }
                    service.resetBroadcastCounter("the presence of an existing cluster", this);
                    break;
                }
                case 2: {
                    service.validateSeniorBroadcast(this, null);
                }
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            MessagePacket packet;
            super.read(input);
            this.setPrevSentTimestamp(input.readLong() & 0xFFFFFFFFFFFFFFL);
            this.setPrevRecvTimestamp(input.readLong());
            this.setThisSentTimestamp(input.readLong());
            this.getFromMember().setTcpRingPort(input.readInt());
            MessagePacket[] aPacket = this.getPacket();
            if (aPacket != null && aPacket.length > 0 && (packet = aPacket[0]) != null) {
                this.setThisRecvTimestamp(((ClusterService)this.getService()).calcTimestamp(packet.getReceivedMillis()));
            }
            if (input.available() > 0) {
                int cbAddr;
                int nProtoVerPeer = input.read();
                this.setAnnounceProtocolVersion(nProtoVerPeer);
                if (nProtoVerPeer >= 1 && (cbAddr = input.readInt()) > 0) {
                    byte[] abAddr = new byte[cbAddr];
                    input.read(abAddr);
                    int nPort = input.readInt();
                    this.setExternalAddress(new InetSocketAddress(InetAddress.getByAddress(abAddr), nPort));
                }
            }
            this.ensureEOS(input);
        }

        public void setAnnounceProtocolVersion(int nVersion) {
            if ((nVersion & 0xFFFFFF00) != 0) {
                throw new IllegalArgumentException("version exceeds max bit width");
            }
            this.__m_AnnounceProtocolVersion = nVersion;
        }

        protected static void setLastTraceMillis(long lMillis) {
            __s_LastTraceMillis = lMillis;
        }

        public void setPrevRecvTimestamp(long cMillis) {
            this.__m_PrevRecvTimestamp = cMillis;
        }

        public void setPrevSentTimestamp(long cMillis) {
            this.__m_PrevSentTimestamp = cMillis;
        }

        protected void setThisRecvTimestamp(long ldt) {
            this.__m_ThisRecvTimestamp = ldt;
        }

        public void setThisSentTimestamp(long cMillis) {
            this.__m_ThisSentTimestamp = cMillis;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            long lMillis = ((ClusterService)this.getService()).getTimestamp();
            this.setThisSentTimestamp(lMillis);
            long ldtPrevSent = this.getPrevSentTimestamp();
            output.writeLong(ldtPrevSent);
            output.writeLong(this.getPrevRecvTimestamp());
            output.writeLong(this.getThisSentTimestamp());
            output.writeInt(this.getFromMember().getTcpRingPort());
            int nProtoVerPeer = (int)(ldtPrevSent >>> 56);
            if (nProtoVerPeer >= 1) {
                output.write(this.getAnnounceProtocolVersion());
                InetSocketAddress addrExternal = this.getExternalAddress();
                if (addrExternal == null) {
                    output.writeInt(0);
                } else {
                    InetAddress addr = addrExternal.getAddress();
                    byte[] abAddr = addr.getAddress();
                    output.writeInt(abAddr.length);
                    output.write(abAddr);
                    output.writeInt(addrExternal.getPort());
                }
            }
        }
    }

    public static class NewMemberAnnounceWait
    extends DiscoveryMessage {
        private com.tangosol.coherence.component.net.Member __m_SeniorMember;

        public NewMemberAnnounceWait() {
            this(null, null, true);
        }

        public NewMemberAnnounceWait(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(9);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NewMemberAnnounceWait();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NewMemberAnnounceWait".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "ToMember=" + String.valueOf(this.getToMember()) + "\nSeniorMember=" + String.valueOf(this.getSeniorMember());
        }

        public com.tangosol.coherence.component.net.Member getSeniorMember() {
            return this.__m_SeniorMember;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ClusterService service = (ClusterService)this.getService();
            com.tangosol.coherence.component.net.Member memberFrom = this.getFromMember();
            switch (service.getState()) {
                case 0: 
                case 1: {
                    if (this.isReadError()) {
                        service.onMemberRejected(8162, memberFrom);
                        throw new EventDeathException("Version mismatch");
                    }
                    service.resetBroadcastCounter("the presence of an existing cluster", this);
                }
            }
            service.addDynamicBroadcast(this.getSeniorMember());
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            ClusterService service = (ClusterService)this.getService();
            com.tangosol.coherence.component.net.Member memberSenior = service.instantiateMember();
            memberSenior.readExternal(input);
            this.setSeniorMember(memberSenior);
            this.ensureEOS(input);
        }

        public void setSeniorMember(com.tangosol.coherence.component.net.Member member) {
            this.__m_SeniorMember = member;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            this.getSeniorMember().writeExternal(output);
        }
    }

    public static class NewMemberInduct
    extends Message {
        private com.tangosol.coherence.component.net.Member[] __m_Member;
        private transient int __m_MemberCount;
        private transient int __m_ServiceCount;
        private int[] __m_ServiceId;
        private String[] __m_ServiceName;
        private boolean[] __m_ServiceSuspended;
        private String[] __m_ServiceType;
        private String[] __m_ServiceVersion;

        public NewMemberInduct() {
            this(null, null, true);
        }

        public NewMemberInduct(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(6);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NewMemberInduct();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NewMemberInduct".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            int i;
            StringBuffer sb = new StringBuffer();
            int cMembers = this.getMemberCount();
            int cServices = this.getServiceCount();
            sb.append("MemberCount=").append(cMembers).append("\nMember/ServiceVersion=[");
            for (i = 0; i < cMembers; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.getMember(i)).append('/').append(this.getServiceVersion(i));
            }
            sb.append("]\nServiceCount=").append(cServices).append("\nServiceId/ServiceName=[");
            for (i = 0; i < cServices; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.getServiceId(i)).append('/').append(this.getServiceName(i));
            }
            sb.append(']');
            return sb.toString();
        }

        public com.tangosol.coherence.component.net.Member[] getMember() {
            return this.__m_Member;
        }

        public com.tangosol.coherence.component.net.Member getMember(int i) {
            return this.getMember()[i];
        }

        public int getMemberCount() {
            com.tangosol.coherence.component.net.Member[] ao = this.getMember();
            return ao == null ? 0 : ao.length;
        }

        public int getServiceCount() {
            int[] anId = this.getServiceId();
            return anId == null ? 0 : anId.length;
        }

        public int[] getServiceId() {
            return this.__m_ServiceId;
        }

        public int getServiceId(int i) {
            return this.getServiceId()[i];
        }

        public String[] getServiceName() {
            return this.__m_ServiceName;
        }

        public String getServiceName(int i) {
            return this.getServiceName()[i];
        }

        public String[] getServiceType() {
            return this.__m_ServiceType;
        }

        public String getServiceType(int i) {
            return this.getServiceType()[i];
        }

        public String[] getServiceVersion() {
            return this.__m_ServiceVersion;
        }

        public String getServiceVersion(int i) {
            return this.getServiceVersion()[i];
        }

        public boolean[] isServiceSuspended() {
            return this.__m_ServiceSuspended;
        }

        public boolean isServiceSuspended(int i) {
            return this.isServiceSuspended()[i];
        }

        @Override
        public void onReceived() {
            int cServices;
            super.onReceived();
            ClusterService service = (ClusterService)this.getService();
            String sVersionThis = service.getServiceVersion();
            int cMembers = this.getMemberCount();
            if (cMembers > 0) {
                com.tangosol.coherence.component.net.Member[] aMember = this.getMember();
                String[] asVersion = this.getServiceVersion();
                for (int i = 0; i < cMembers; ++i) {
                    com.tangosol.coherence.component.net.Member member = aMember[i];
                    String sVersion = asVersion[i];
                    if (!service.isVersionCompatible(sVersion)) {
                        service.onMemberRejected(8162, this.getFromMember());
                        throw new EventDeathException("Version mismatch");
                    }
                    service.ensureMember(member, sVersion);
                }
            }
            if ((cServices = this.getServiceCount()) > 0) {
                int[] anId = this.getServiceId();
                String[] asName = this.getServiceName();
                String[] asType = this.getServiceType();
                boolean[] afSuspended = this.isServiceSuspended();
                for (int i = 0; i < cServices; ++i) {
                    service.ensureServiceInfo(anId[i], asName[i], asType[i]).setSuspended(afSuspended[i]);
                }
            }
            service.setState(2);
            service.getTcpRing().onJoined();
            service.ensureMemberLeft(null, null, true);
            com.tangosol.coherence.component.net.Member memberThis = service.getThisMember();
            service.getClusterMemberSet().setServiceJoined(memberThis.getId());
            NewMemberWelcomeRequest msg = (NewMemberWelcomeRequest)service.instantiateMessage("NewMemberWelcomeRequest");
            msg.setToMemberSet(service.getOthersMemberSet());
            msg.setPreferredPacketLength(memberThis.getPreferredPacketLength());
            msg.setPreferredPort(memberThis.getPreferredPort());
            msg.setServiceVersion(sVersionThis);
            service.send(msg);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            int cServices;
            ClusterService service = (ClusterService)this.getService();
            int cMembers = input.readUnsignedShort();
            if (cMembers > 0) {
                com.tangosol.coherence.component.net.Member[] aMember = new com.tangosol.coherence.component.net.Member[cMembers];
                String[] asVersion = new String[cMembers];
                for (int i = 0; i < cMembers; ++i) {
                    com.tangosol.coherence.component.net.Member member = service.instantiateMember();
                    member.readExternal(input);
                    member.setTcpRingPort(ExternalizableHelper.readInt(input));
                    aMember[i] = member;
                    asVersion[i] = ExternalizableHelper.readUTF(input);
                }
                this.setMember(aMember);
                this.setServiceVersion(asVersion);
            }
            if ((cServices = input.readUnsignedShort()) > 0) {
                int[] anServiceId = new int[cServices];
                String[] asServiceName = new String[cServices];
                String[] asServiceType = new String[cServices];
                boolean[] afServiceSuspended = new boolean[cServices];
                for (int i = 0; i < cServices; ++i) {
                    anServiceId[i] = input.readUnsignedShort();
                    asServiceName[i] = input.readUTF();
                    asServiceType[i] = input.readUTF();
                    afServiceSuspended[i] = input.readBoolean();
                }
                this.setServiceId(anServiceId);
                this.setServiceName(asServiceName);
                this.setServiceType(asServiceType);
                this.setServiceSuspended(afServiceSuspended);
            }
        }

        public void setMember(com.tangosol.coherence.component.net.Member[] anId) {
            this.__m_Member = anId;
        }

        public void setMember(int i, com.tangosol.coherence.component.net.Member nId) {
            this.getMember()[i] = nId;
        }

        public void setMemberCount(int c) {
            String[] asOldVer;
            int cOldVers;
            int cOldMbrs;
            com.tangosol.coherence.component.net.Member[] aOldMbr = this.getMember();
            int n = cOldMbrs = aOldMbr == null ? 0 : aOldMbr.length;
            if (c != cOldMbrs) {
                com.tangosol.coherence.component.net.Member[] aNewMbr = new com.tangosol.coherence.component.net.Member[c];
                if (cOldMbrs > 0) {
                    System.arraycopy(aOldMbr, 0, aNewMbr, 0, Math.min(c, cOldMbrs));
                }
                this.setMember(aNewMbr);
            }
            int n2 = cOldVers = (asOldVer = this.getServiceVersion()) == null ? 0 : asOldVer.length;
            if (c != cOldVers) {
                String[] asNewVer = new String[c];
                if (cOldVers > 0) {
                    System.arraycopy(asOldVer, 0, asNewVer, 0, Math.min(c, cOldVers));
                }
                this.setServiceVersion(asNewVer);
            }
        }

        public void setServiceCount(int c) {
            boolean[] afOldSuspended;
            int cOldSuspended;
            String[] asOldType;
            int cOldTypes;
            String[] asOldName;
            int cOldNames;
            int cOldIds;
            int[] anOldId = this.getServiceId();
            int n = cOldIds = anOldId == null ? 0 : anOldId.length;
            if (c != cOldIds) {
                int[] anNewId = new int[c];
                if (cOldIds > 0) {
                    System.arraycopy(anOldId, 0, anNewId, 0, Math.min(c, cOldIds));
                }
                this.setServiceId(anNewId);
            }
            int n2 = cOldNames = (asOldName = this.getServiceName()) == null ? 0 : asOldName.length;
            if (c != cOldNames) {
                String[] asNewName = new String[c];
                if (cOldNames > 0) {
                    System.arraycopy(asOldName, 0, asNewName, 0, Math.min(c, cOldNames));
                }
                this.setServiceName(asNewName);
            }
            int n3 = cOldTypes = (asOldType = this.getServiceType()) == null ? 0 : asOldType.length;
            if (c != cOldTypes) {
                String[] asNewType = new String[c];
                if (cOldTypes > 0) {
                    System.arraycopy(asOldType, 0, asNewType, 0, Math.min(c, cOldTypes));
                }
                this.setServiceType(asNewType);
            }
            int n4 = cOldSuspended = (afOldSuspended = this.isServiceSuspended()) == null ? 0 : afOldSuspended.length;
            if (c != cOldSuspended) {
                boolean[] afNewSuspended = new boolean[c];
                if (cOldSuspended > 0) {
                    System.arraycopy(afOldSuspended, 0, afNewSuspended, 0, Math.min(c, cOldSuspended));
                }
                this.setServiceSuspended(afNewSuspended);
            }
        }

        public void setServiceId(int[] anId) {
            this.__m_ServiceId = anId;
        }

        public void setServiceId(int i, int nId) {
            this.getServiceId()[i] = nId;
        }

        public void setServiceName(String[] asName) {
            this.__m_ServiceName = asName;
        }

        public void setServiceName(int i, String sName) {
            this.getServiceName()[i] = sName;
        }

        public void setServiceSuspended(boolean[] afSuspended) {
            this.__m_ServiceSuspended = afSuspended;
        }

        public void setServiceSuspended(int i, boolean fSuspended) {
            this.isServiceSuspended()[i] = fSuspended;
        }

        public void setServiceType(String[] asType) {
            this.__m_ServiceType = asType;
        }

        public void setServiceType(int i, String sType) {
            this.getServiceType()[i] = sType;
        }

        public void setServiceVersion(String[] asVersion) {
            this.__m_ServiceVersion = asVersion;
        }

        public void setServiceVersion(int i, String sVersion) {
            this.getServiceVersion()[i] = sVersion;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            int cMembers = this.getMemberCount();
            output.writeShort(cMembers);
            if (cMembers > 0) {
                com.tangosol.coherence.component.net.Member[] aMember = this.getMember();
                String[] asVersion = this.getServiceVersion();
                for (int i = 0; i < cMembers; ++i) {
                    com.tangosol.coherence.component.net.Member member = aMember[i];
                    member.writeExternal(output);
                    ExternalizableHelper.writeInt(output, member.getTcpRingPort());
                    ExternalizableHelper.writeUTF(output, asVersion[i]);
                }
            }
            int cServices = this.getServiceCount();
            output.writeShort(cServices);
            if (cServices > 0) {
                int[] anServiceId = this.getServiceId();
                String[] asServiceName = this.getServiceName();
                String[] asServiceType = this.getServiceType();
                boolean[] afServiceSuspended = this.isServiceSuspended();
                for (int i = 0; i < cServices; ++i) {
                    output.writeShort(anServiceId[i]);
                    output.writeUTF(asServiceName[i]);
                    output.writeUTF(asServiceType[i]);
                    output.writeBoolean(afServiceSuspended[i]);
                }
            }
        }
    }

    public static class NewMemberRequestId
    extends DiscoveryMessage
    implements Service.MemberJoinAction {
        private int __m_AttemptCounter;
        private int __m_AttemptLimit;
        private transient int __m_Count;
        private int __m_MaxPacketSize;
        private String __m_ServiceVersion;
        private boolean __m_WkaEnabled;

        public NewMemberRequestId() {
            this(null, null, true);
        }

        public NewMemberRequestId(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(10);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NewMemberRequestId();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NewMemberRequestId".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void ensureEOS(DataInput stream) throws IOException {
            ((ClusterService)this.getService()).resetBroadcastCounter(stream, false);
            super.ensureEOS(stream);
        }

        public int getAttemptCounter() {
            return this.__m_AttemptCounter;
        }

        public int getAttemptLimit() {
            return this.__m_AttemptLimit;
        }

        public int getCount() {
            return this.__m_Count;
        }

        @Override
        public String getDescription() {
            return "AttemptCounter=" + this.getAttemptCounter() + "\nAttemptLimit=" + this.getAttemptLimit() + "\nServiceVersion=" + this.getServiceVersion();
        }

        @Override
        public Member getJoiningMember() {
            return this.getFromMember();
        }

        public int getMaxPacketSize() {
            return this.__m_MaxPacketSize;
        }

        public String getServiceVersion() {
            return this.__m_ServiceVersion;
        }

        public boolean isWkaEnabled() {
            return this.__m_WkaEnabled;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ClusterService service = (ClusterService)this.getService();
            com.tangosol.coherence.component.net.Member memberFrom = this.getFromMember();
            switch (service.getState()) {
                case 0: {
                    if (this.isReadError()) {
                        service.onMemberRejected(8162, null);
                        throw new EventDeathException("Version mismatch");
                    }
                    service.resetBroadcastCounter("the presence of an existing cluster", this);
                    break;
                }
                case 1: {
                    if (this.isReadError()) {
                        service.onMemberRejected(8162, null);
                        throw new EventDeathException("Version mismatch");
                    }
                    com.tangosol.coherence.component.net.Member memberThis = service.getRequestMember();
                    if (memberFrom.equals(memberThis) || memberThis.compareTo(memberFrom) <= 0) break;
                    service.resetBroadcastCounter("an older member joining", this);
                    break;
                }
                case 2: {
                    MasterMemberSet setMember = service.getClusterMemberSet();
                    com.tangosol.coherence.component.net.Member memberSenior = setMember.getOldestMember();
                    com.tangosol.coherence.component.net.Member memberThis = setMember.getThisMember();
                    com.tangosol.coherence.component.net.Member memberNew = setMember.getMember(memberFrom.getUid32());
                    if (memberThis == memberSenior && service.validateNewMember(memberFrom) && !service.isMembershipSuspended() && (memberNew != null || service.getPendingServiceJoining().isEmpty())) {
                        int cbPacketNew = this.getMaxPacketSize();
                        int cbPacketThis = service.getMaximumPacketLength();
                        String sVersionNew = this.getServiceVersion();
                        boolean fWkaEnabledNew = this.isWkaEnabled();
                        boolean fWkaEnabledThis = service.isWkaEnabled();
                        String sClusterNameNew = memberFrom.getClusterName();
                        String sClusterNameThis = service.getClusterName();
                        int nEditionNew = memberFrom.getEdition();
                        int nEditionThis = memberThis.getEdition();
                        int nModeNew = memberFrom.getMode();
                        int nModeThis = memberThis.getMode();
                        boolean fAllowRTCThis = nEditionThis == 5 || nEditionThis == 3;
                        boolean fAllowRTCNew = nEditionNew == 5 || nEditionNew == 3;
                        boolean fBrandNew = false;
                        if (memberNew == null) {
                            int nRejectReason;
                            if (!service.isVersionCompatible(sVersionNew) || cbPacketNew == 0 || this.isReadError()) {
                                nRejectReason = 8162;
                            } else if (!Base.equals(sClusterNameNew, sClusterNameThis)) {
                                nRejectReason = 8167;
                            } else if (cbPacketNew != cbPacketThis) {
                                nRejectReason = 8163;
                            } else if (fWkaEnabledNew != fWkaEnabledThis) {
                                nRejectReason = 8166;
                            } else if (nModeNew != nModeThis) {
                                nRejectReason = 8169;
                            } else if (!(nEditionNew >= 3 && nEditionThis >= 3 || nEditionNew == 1 && fAllowRTCThis || fAllowRTCNew && nEditionThis == 1)) {
                                nRejectReason = 8168;
                            } else if (!service.getActionPolicy().isAllowed(service, this)) {
                                nRejectReason = 8172;
                            } else {
                                memberNew = service.instantiateMember();
                                memberNew.configure(memberFrom, 0L);
                                nRejectReason = setMember.induct(memberNew, service);
                            }
                            if (nRejectReason == 8171) {
                                fBrandNew = true;
                                setMember.setServiceVersion(memberNew.getId(), sVersionNew);
                                setMember.setServiceJoinTime(memberNew.getId(), memberNew.getUid32().getTimestamp());
                            } else {
                                NewMemberRequestIdReject msg = (NewMemberRequestIdReject)service.instantiateMessage("NewMemberRequestIdReject");
                                msg.setToMember(memberFrom);
                                msg.setReason(nRejectReason);
                                service.send(msg);
                                break;
                            }
                        }
                        NewMemberRequestIdReply msg = (NewMemberRequestIdReply)service.instantiateMessage("NewMemberRequestIdReply");
                        msg.setToMember(memberNew);
                        msg.setServiceVersion(ClusterService.VERSION_BARRIER);
                        msg.setMulticastTimeToLive(service.getMulticastTimeToLive());
                        msg.setWkaHashCode(service.getWkaHashCode());
                        service.send(msg);
                        if (!fBrandNew) break;
                        service.ensureMemberLeft(memberNew, null, false);
                        service.doMemberInduct(memberNew);
                        service.onMemberJoined(memberNew);
                        ActualMemberSet setOthers = new ActualMemberSet();
                        ((MemberSet)setOthers).addAll((Collection)setMember);
                        setOthers.remove(memberThis);
                        setOthers.remove(memberNew);
                        if (((MemberSet)setOthers).isEmpty()) break;
                        MemberJoined msg2 = (MemberJoined)service.instantiateMessage("MemberJoined");
                        msg2.setToMemberSet(setOthers);
                        msg2.setMember(memberNew);
                        msg2.setServiceVersion(sVersionNew);
                        service.send(msg2);
                        break;
                    }
                    if (this.getAttemptCounter() <= this.getAttemptLimit() >>> 2) break;
                    int cMembers = setMember.size();
                    if (((Cluster)service.getCluster()).getDependencies().getPublisherGroupThreshold() < 100 && cMembers >= 8 && Base.getRandom().nextInt(cMembers) >= (int)Math.log(cMembers) + 1) break;
                    NewMemberRequestIdWait msg = (NewMemberRequestIdWait)service.instantiateMessage("NewMemberRequestIdWait");
                    msg.setToMember(memberFrom);
                    msg.setSeniorMember(memberSenior);
                    service.send(msg);
                }
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setAttemptCounter(ExternalizableHelper.readInt(input));
            this.setAttemptLimit(ExternalizableHelper.readInt(input));
            this.setServiceVersion(ExternalizableHelper.readUTF(input));
            this.setMaxPacketSize(ExternalizableHelper.readInt(input));
            this.setWkaEnabled(input.readBoolean());
            this.getFromMember().setTcpRingPort(ExternalizableHelper.readInt(input));
            this.setCount(input.readInt());
            this.ensureEOS(input);
        }

        public void setAttemptCounter(int n) {
            this.__m_AttemptCounter = n;
        }

        public void setAttemptLimit(int c) {
            this.__m_AttemptLimit = c;
        }

        public void setCount(int pCount) {
            this.__m_Count = pCount;
        }

        public void setMaxPacketSize(int cb) {
            this.__m_MaxPacketSize = cb;
        }

        public void setServiceVersion(String sVersion) {
            this.__m_ServiceVersion = sVersion;
        }

        public void setWkaEnabled(boolean fEnabled) {
            this.__m_WkaEnabled = fEnabled;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            ExternalizableHelper.writeInt(output, this.getAttemptCounter());
            ExternalizableHelper.writeInt(output, this.getAttemptLimit());
            ExternalizableHelper.writeUTF(output, this.getServiceVersion());
            ExternalizableHelper.writeInt(output, this.getMaxPacketSize());
            output.writeBoolean(this.isWkaEnabled());
            ExternalizableHelper.writeInt(output, this.getFromMember().getTcpRingPort());
            ((ClusterService)this.getService()).getBroadcastTimestamp().writeExternal(output);
        }
    }

    public static class NewMemberRequestIdReject
    extends DiscoveryMessage {
        private int __m_Reason;

        public NewMemberRequestIdReject() {
            this(null, null, true);
        }

        public NewMemberRequestIdReject(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(11);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NewMemberRequestIdReject();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NewMemberRequestIdReject".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "ToMember=" + String.valueOf(this.getToMember()) + "\nReason=" + this.getReason();
        }

        public int getReason() {
            return this.__m_Reason;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ClusterService service = (ClusterService)this.getService();
            com.tangosol.coherence.component.net.Member memberFrom = this.getFromMember();
            switch (service.getState()) {
                case 0: {
                    if (this.isReadError()) {
                        service.onMemberRejected(8162, memberFrom);
                        throw new EventDeathException("Version mismatch");
                    }
                    service.resetBroadcastCounter("the presence of an existing cluster", this);
                    break;
                }
                case 1: {
                    if (this.isReadError()) {
                        service.onMemberRejected(8162, memberFrom);
                        throw new EventDeathException("Version mismatch");
                    }
                    service.resetBroadcastCounter("the presence of an existing cluster", this);
                    if (!this.getToMember().equals(service.getRequestMember())) break;
                    service.onMemberRejected(this.getReason(), memberFrom);
                    break;
                }
                case 2: {
                    service.validateSeniorBroadcast(this, null);
                }
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setReason(input.readInt());
            this.ensureEOS(input);
        }

        public void setReason(int nReason) {
            this.__m_Reason = nReason;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeInt(this.getReason());
        }
    }

    public static class NewMemberRequestIdReply
    extends DiscoveryMessage {
        private int __m_MulticastTimeToLive;
        private String __m_ServiceVersion;
        private int __m_WkaHashCode;

        public NewMemberRequestIdReply() {
            this(null, null, true);
        }

        public NewMemberRequestIdReply(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(12);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NewMemberRequestIdReply();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NewMemberRequestIdReply".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "ToMember=" + String.valueOf(this.getToMember()) + "\nServiceVersion=" + this.getServiceVersion();
        }

        public int getMulticastTimeToLive() {
            return this.__m_MulticastTimeToLive;
        }

        public String getServiceVersion() {
            return this.__m_ServiceVersion;
        }

        public int getWkaHashCode() {
            return this.__m_WkaHashCode;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            com.tangosol.coherence.component.net.Member memberFrom = this.getFromMember();
            ClusterService service = (ClusterService)this.getService();
            switch (service.getState()) {
                case 0: {
                    if (this.isReadError()) {
                        service.onMemberRejected(8162, memberFrom);
                        throw new EventDeathException("Version mismatch");
                    }
                    service.resetBroadcastCounter("the presence of an existing cluster", this);
                    break;
                }
                case 1: {
                    int iTtlSenior;
                    if (this.isReadError()) {
                        service.onMemberRejected(8162, memberFrom);
                        throw new EventDeathException("Version mismatch");
                    }
                    service.resetBroadcastCounter("the presence of an existing cluster", this);
                    if (!this.getToMember().getUid32().equals(service.getRequestMember().getUid32())) break;
                    MasterMemberSet setMember = service.getClusterMemberSet();
                    Cluster cluster = (Cluster)service.getCluster();
                    com.tangosol.coherence.component.net.Member memberOldest = service.ensureMember(memberFrom, this.getServiceVersion());
                    if (memberOldest == null) {
                        return;
                    }
                    com.tangosol.coherence.component.net.Member memberThis = service.getRequestMember();
                    if (setMember.getThisMember() != null) {
                        if (setMember.getOldestMember() != memberOldest) {
                            throw new ClusterJoinException();
                        }
                        if (memberThis.getId() != this.getToMember().getId()) {
                            throw new ClusterJoinException();
                        }
                        return;
                    }
                    memberThis.setId(this.getToMember().getId());
                    memberThis = service.ensureMember(memberThis, service.getServiceVersion());
                    memberThis.setPreferredPacketLength(cluster.getSocketManager().getPreferredUnicastUdpSocket().getPacketLength());
                    memberThis.setPreferredPort(cluster.getSocketManager().getPreferredUnicastUdpSocket().getPort());
                    setMember.setThisMember(memberThis);
                    service.onMemberJoined(memberOldest);
                    NewMemberRequestIdReply._trace("This " + memberThis.toString(1) + " joined " + service.formatClusterString() + " with senior " + memberOldest.toString(1), 3);
                    if (service.isWkaEnabled()) {
                        if (service.getWkaHashCode() == this.getWkaHashCode()) break;
                        NewMemberRequestIdReply._trace("This member is configured with a compatible but different WKA list than the senior " + String.valueOf(memberOldest) + ". It is strongly recommended to use the same WKA list for all cluster members.", 2);
                        break;
                    }
                    int iTtlThis = service.getMulticastTimeToLive();
                    if (iTtlThis == (iTtlSenior = this.getMulticastTimeToLive())) break;
                    NewMemberRequestIdReply._trace("This member is configured with a multicast TTL of " + iTtlThis + "; the senior " + String.valueOf(memberOldest) + " is configured with a TTL of " + iTtlSenior + ". It is strongly recommended to use the same TTL setting for all cluster members.", 2);
                    break;
                }
                case 2: {
                    service.validateSeniorBroadcast(this, null);
                }
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setServiceVersion(input.readUTF());
            this.setMulticastTimeToLive(input.readInt());
            this.setWkaHashCode(input.readInt());
            this.getFromMember().setTcpRingPort(input.readInt());
            this.ensureEOS(input);
        }

        public void setMulticastTimeToLive(int pMulticastTimeToLive) {
            this.__m_MulticastTimeToLive = pMulticastTimeToLive;
        }

        public void setServiceVersion(String sVersion) {
            this.__m_ServiceVersion = sVersion;
        }

        public void setWkaHashCode(int iHash) {
            this.__m_WkaHashCode = iHash;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeUTF(this.getServiceVersion());
            output.writeInt(this.getMulticastTimeToLive());
            output.writeInt(this.getWkaHashCode());
            output.writeInt(this.getFromMember().getTcpRingPort());
        }
    }

    public static class NewMemberRequestIdWait
    extends DiscoveryMessage {
        private com.tangosol.coherence.component.net.Member __m_SeniorMember;

        public NewMemberRequestIdWait() {
            this(null, null, true);
        }

        public NewMemberRequestIdWait(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(13);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NewMemberRequestIdWait();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NewMemberRequestIdWait".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "ToMember=" + String.valueOf(this.getToMember());
        }

        public com.tangosol.coherence.component.net.Member getSeniorMember() {
            return this.__m_SeniorMember;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ClusterService service = (ClusterService)this.getService();
            com.tangosol.coherence.component.net.Member memberFrom = this.getFromMember();
            switch (service.getState()) {
                case 0: 
                case 1: {
                    if (this.isReadError()) {
                        service.onMemberRejected(8162, memberFrom);
                        throw new EventDeathException("Version mismatch");
                    }
                    service.addDynamicBroadcast(this.getSeniorMember());
                    service.resetBroadcastCounter("the presence of an existing cluster", this);
                }
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            ClusterService service = (ClusterService)this.get_Parent();
            com.tangosol.coherence.component.net.Member memberSenior = service.instantiateMember();
            memberSenior.readExternal(input);
            this.setSeniorMember(memberSenior);
            this.ensureEOS(input);
        }

        public void setSeniorMember(com.tangosol.coherence.component.net.Member member) {
            this.__m_SeniorMember = member;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            this.getSeniorMember().writeExternal(output);
        }
    }

    public static class NewMemberTimestampRequest
    extends RequestMessage {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public NewMemberTimestampRequest() {
            this(null, null, true);
        }

        public NewMemberTimestampRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(51);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NewMemberTimestampRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NewMemberTimestampRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public com.tangosol.coherence.component.net.Poll ensureRequestPoll() {
            return (Poll)this._newChild("Poll");
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onReceived() {
            super.onReceived();
            ClusterService service = (ClusterService)this.getService();
            NewMemberTimestampResponse msg = (NewMemberTimestampResponse)service.instantiateMessage("NewMemberTimestampResponse");
            msg.respondTo(this);
            int nTimestamp = Integer.MIN_VALUE;
            block5: for (Map.Entry entry : service.getWkaMap().entrySet()) {
                int[] an = (int[])entry.getValue();
                if (an[0] != 1) continue;
                int n = 0;
                switch (an[1]) {
                    case 0: {
                        nTimestamp = 0;
                        break block5;
                    }
                    case 4: {
                        n = 2 * an[2];
                        break;
                    }
                    case 5: {
                        n = an[2];
                    }
                }
                nTimestamp = nTimestamp < 0 ? n : nTimestamp + n;
            }
            msg.setTimestamp(nTimestamp);
            service.send(msg);
        }

        static {
            NewMemberTimestampRequest.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NewMemberTimestampRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public void onCompletion() {
                super.onCompletion();
            }

            @Override
            public void onResponse(Message msg) {
                if (this.isClosed()) {
                    this.setResult(Base.makeInteger(0));
                } else {
                    NewMemberTimestampResponse msgResponse = (NewMemberTimestampResponse)msg;
                    this.setResult(Base.makeInteger(msgResponse.getTimestamp()));
                }
                super.onResponse(msg);
            }
        }
    }

    public static class NewMemberTimestampResponse
    extends Message {
        private int __m_Timestamp;

        public NewMemberTimestampResponse() {
            this(null, null, true);
        }

        public NewMemberTimestampResponse(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(52);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NewMemberTimestampResponse();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NewMemberTimestampResponse".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "Timestamp=" + this.getTimestamp();
        }

        public int getTimestamp() {
            return this.__m_Timestamp;
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            this.setTimestamp(ExternalizableHelper.readInt(input));
        }

        public void setTimestamp(int n) {
            this.__m_Timestamp = n;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            ExternalizableHelper.writeInt(output, this.getTimestamp());
        }
    }

    public static class NewMemberWelcome
    extends Message {
        private UUID __m_FromMemberUid;
        private int __m_PreferredPacketLength;
        private int __m_PreferredPort;
        private int __m_ServiceCount;
        private String[] __m_ServiceEndPointName;
        private int[] __m_ServiceId;
        private long[] __m_ServiceJoinTime;
        private Map[] __m_ServiceMemberConfigMap;
        private String[] __m_ServiceName;
        private int[] __m_ServiceState;
        private String[] __m_ServiceType;
        private String[] __m_ServiceVersion;

        public NewMemberWelcome() {
            this(null, null, true);
        }

        public NewMemberWelcome(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(37);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NewMemberWelcome();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NewMemberWelcome".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            StringBuffer sb = new StringBuffer();
            int cServices = this.getServiceCount();
            sb.append("FromMemberUid=").append(this.getFromMemberUid()).append(", ServiceCount=").append(cServices).append("\nServiceId/ServiceName/ServiceVersion/ServiceEndPoint/ServiceState=[");
            for (int i = 0; i < cServices; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.getServiceId(i)).append('/').append(this.getServiceName(i)).append('/').append(this.getServiceVersion(i)).append('/').append(this.getServiceEndPointName(i)).append('/').append(ServiceMemberSet.formatJoinTime(this.getServiceJoinTime(i))).append('/').append(ServiceMemberSet.formatStateName(this.getServiceState(i)));
            }
            sb.append(']');
            return sb.toString();
        }

        public UUID getFromMemberUid() {
            return this.__m_FromMemberUid;
        }

        public int getPreferredPacketLength() {
            return this.__m_PreferredPacketLength;
        }

        public int getPreferredPort() {
            return this.__m_PreferredPort;
        }

        public int getServiceCount() {
            int[] anId = this.getServiceId();
            return anId == null ? 0 : anId.length;
        }

        public String[] getServiceEndPointName() {
            return this.__m_ServiceEndPointName;
        }

        public String getServiceEndPointName(int i) {
            return this.getServiceEndPointName()[i];
        }

        public int[] getServiceId() {
            return this.__m_ServiceId;
        }

        public int getServiceId(int i) {
            return this.getServiceId()[i];
        }

        public long[] getServiceJoinTime() {
            return this.__m_ServiceJoinTime;
        }

        public long getServiceJoinTime(int i) {
            return this.getServiceJoinTime()[i];
        }

        public Map[] getServiceMemberConfigMap() {
            return this.__m_ServiceMemberConfigMap;
        }

        public Map getServiceMemberConfigMap(int i) {
            return this.getServiceMemberConfigMap()[i];
        }

        public String[] getServiceName() {
            return this.__m_ServiceName;
        }

        public String getServiceName(int i) {
            return this.getServiceName()[i];
        }

        public int[] getServiceState() {
            return this.__m_ServiceState;
        }

        public int getServiceState(int i) {
            return this.getServiceState()[i];
        }

        public String[] getServiceType() {
            return this.__m_ServiceType;
        }

        public String getServiceType(int i) {
            return this.getServiceType()[i];
        }

        public String[] getServiceVersion() {
            return this.__m_ServiceVersion;
        }

        public String getServiceVersion(int i) {
            return this.getServiceVersion()[i];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceived() {
            super.onReceived();
            ClusterService service = (ClusterService)this.getService();
            MasterMemberSet setMembers = service.getClusterMemberSet();
            com.tangosol.coherence.component.net.Member member = this.getFromMember();
            int nMemberId = member.getId();
            NewMemberWelcome._assert(this.getFromMemberUid().equals(member.getUid32()));
            member.setPreferredPort(this.getPreferredPort());
            member.setPreferredPacketLength(this.getPreferredPacketLength());
            int cServices = this.getServiceCount();
            if (cServices > 0) {
                ServiceMemberSet setMember;
                ServiceInfo info;
                int i;
                int[] anServiceId = this.getServiceId();
                String[] asServiceName = this.getServiceName();
                String[] asServiceType = this.getServiceType();
                String[] asServiceVersion = this.getServiceVersion();
                String[] asServiceEndPoint = this.getServiceEndPointName();
                long[] alServiceJoined = this.getServiceJoinTime();
                int[] anServiceState = this.getServiceState();
                Map[] aMapServiceConfig = this.getServiceMemberConfigMap();
                ServiceInfo[] ainfo = new ServiceInfo[cServices];
                for (i = 0; i < cServices; ++i) {
                    info = service.ensureServiceInfo(anServiceId[i], asServiceName[i], asServiceType[i]);
                    ServiceMemberSet serviceMemberSet = setMember = info.getMemberSet();
                    synchronized (serviceMemberSet) {
                        if (setMember.add(member)) {
                            setMember.setServiceJoinTime(nMemberId, alServiceJoined[i]);
                            setMember.setServiceEndPointName(nMemberId, asServiceEndPoint[i]);
                            setMember.updateMemberConfigMap(nMemberId, aMapServiceConfig[i]);
                        }
                        String sVersion = asServiceVersion[i];
                        setMember.setServiceVersion(nMemberId, sVersion);
                        if (anServiceId[i] == 0 && service.isVersionOlder(sVersion)) {
                            NewMemberWelcome._trace("Cluster member " + nMemberId + " is running an older Coherence version " + setMembers.getServiceVersionExternal(nMemberId), 2);
                        }
                    }
                    ainfo[i] = info;
                }
                for (i = 0; i < cServices; ++i) {
                    info = ainfo[i];
                    setMember = info.getMemberSet();
                    int nServiceState = anServiceState[i];
                    switch (setMember.getState(nMemberId)) {
                        default: {
                            if (nServiceState >= 1) {
                                setMember.setServiceJoining(nMemberId);
                                service.onServiceJoining(info, member);
                            }
                        }
                        case 1: {
                            if (nServiceState < 2) break;
                            setMember.setServiceJoined(nMemberId);
                            service.onServiceJoined(info, member);
                        }
                        case 2: 
                    }
                    if (nServiceState < 3) continue;
                    setMember.setServiceLeaving(nMemberId);
                    service.onServiceLeaving(info, member);
                }
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            this.setFromMemberUid(new UUID(input));
            int cServices = input.readUnsignedShort();
            if (cServices > 0) {
                int[] anServiceId = new int[cServices];
                String[] asServiceName = new String[cServices];
                String[] asServiceType = new String[cServices];
                String[] asServiceVersion = new String[cServices];
                String[] asServiceEndPoint = new String[cServices];
                long[] alServiceJoinTime = new long[cServices];
                int[] anServiceState = new int[cServices];
                Map[] aMapServiceConfig = new Map[cServices];
                for (int i = 0; i < cServices; ++i) {
                    anServiceId[i] = input.readUnsignedShort();
                    asServiceName[i] = input.readUTF();
                    asServiceType[i] = input.readUTF();
                    asServiceVersion[i] = input.readUTF();
                    asServiceEndPoint[i] = input.readUTF();
                    alServiceJoinTime[i] = input.readLong();
                    anServiceState[i] = input.readInt();
                    aMapServiceConfig[i] = new HashMap();
                    ExternalizableHelper.readMap(input, aMapServiceConfig[i], null);
                }
                this.setServiceId(anServiceId);
                this.setServiceName(asServiceName);
                this.setServiceType(asServiceType);
                this.setServiceVersion(asServiceVersion);
                this.setServiceEndPointName(asServiceEndPoint);
                this.setServiceJoinTime(alServiceJoinTime);
                this.setServiceState(anServiceState);
                this.setServiceMemberConfigMap(aMapServiceConfig);
            }
            this.setPreferredPacketLength(input.readInt());
            this.setPreferredPort(input.readInt());
        }

        public void setFromMemberUid(UUID uid) {
            this.__m_FromMemberUid = uid;
        }

        public void setPreferredPacketLength(int cb) {
            this.__m_PreferredPacketLength = cb;
        }

        public void setPreferredPort(int nPort) {
            this.__m_PreferredPort = nPort;
        }

        public void setServiceCount(int c) {
            Map[] aMapOld;
            int cOldMap;
            int[] anOldState;
            int cOldState;
            long[] alOldJoined;
            int cOldJoined;
            String[] asOldEndPoint;
            int cOldEndPoints;
            String[] asOldVersion;
            int cOldVersions;
            String[] asOldType;
            int cOldTypes;
            String[] asOldName;
            int cOldNames;
            int cOldIds;
            int[] anOldId = this.getServiceId();
            int n = cOldIds = anOldId == null ? 0 : anOldId.length;
            if (c != cOldIds) {
                int[] anNewId = new int[c];
                if (cOldIds > 0) {
                    System.arraycopy(anOldId, 0, anNewId, 0, Math.min(c, cOldIds));
                }
                this.setServiceId(anNewId);
            }
            int n2 = cOldNames = (asOldName = this.getServiceName()) == null ? 0 : asOldName.length;
            if (c != cOldNames) {
                String[] asNewName = new String[c];
                if (cOldNames > 0) {
                    System.arraycopy(asOldName, 0, asNewName, 0, Math.min(c, cOldNames));
                }
                this.setServiceName(asNewName);
            }
            int n3 = cOldTypes = (asOldType = this.getServiceType()) == null ? 0 : asOldType.length;
            if (c != cOldTypes) {
                String[] asNewType = new String[c];
                if (cOldTypes > 0) {
                    System.arraycopy(asOldType, 0, asNewType, 0, Math.min(c, cOldTypes));
                }
                this.setServiceType(asNewType);
            }
            int n4 = cOldVersions = (asOldVersion = this.getServiceVersion()) == null ? 0 : asOldVersion.length;
            if (c != cOldVersions) {
                String[] asNewVersion = new String[c];
                if (cOldVersions > 0) {
                    System.arraycopy(asOldVersion, 0, asNewVersion, 0, Math.min(c, cOldVersions));
                }
                this.setServiceVersion(asNewVersion);
            }
            int n5 = cOldEndPoints = (asOldEndPoint = this.getServiceEndPointName()) == null ? 0 : asOldEndPoint.length;
            if (c != cOldEndPoints) {
                String[] asNewEndPoint = new String[c];
                if (cOldEndPoints > 0) {
                    System.arraycopy(asOldEndPoint, 0, asNewEndPoint, 0, Math.min(c, cOldEndPoints));
                }
                this.setServiceEndPointName(asNewEndPoint);
            }
            int n6 = cOldJoined = (alOldJoined = this.getServiceJoinTime()) == null ? 0 : alOldJoined.length;
            if (c != cOldJoined) {
                long[] alNewJoined = new long[c];
                if (cOldJoined > 0) {
                    System.arraycopy(alOldJoined, 0, alNewJoined, 0, Math.min(c, cOldJoined));
                }
                this.setServiceJoinTime(alNewJoined);
            }
            int n7 = cOldState = (anOldState = this.getServiceState()) == null ? 0 : anOldState.length;
            if (c != cOldState) {
                int[] anNewState = new int[c];
                if (cOldState > 0) {
                    System.arraycopy(anOldState, 0, anNewState, 0, Math.min(c, cOldState));
                }
                this.setServiceState(anNewState);
            }
            int n8 = cOldMap = (aMapOld = this.getServiceMemberConfigMap()) == null ? 0 : aMapOld.length;
            if (c != cOldMap) {
                Map[] aMapNew = new Map[c];
                if (cOldMap > 0) {
                    System.arraycopy(aMapOld, 0, aMapNew, 0, Math.min(c, cOldMap));
                }
                this.setServiceMemberConfigMap(aMapNew);
            }
        }

        public void setServiceEndPointName(String[] asName) {
            this.__m_ServiceEndPointName = asName;
        }

        public void setServiceEndPointName(int i, String sName) {
            this.getServiceEndPointName()[i] = sName;
        }

        public void setServiceId(int[] anId) {
            this.__m_ServiceId = anId;
        }

        public void setServiceId(int i, int nId) {
            this.getServiceId()[i] = nId;
        }

        public void setServiceJoinTime(long[] alJoined) {
            this.__m_ServiceJoinTime = alJoined;
        }

        public void setServiceJoinTime(int i, long lJoined) {
            this.getServiceJoinTime()[i] = lJoined;
        }

        public void setServiceMemberConfigMap(Map[] amapConfig) {
            this.__m_ServiceMemberConfigMap = amapConfig;
        }

        public void setServiceMemberConfigMap(int i, Map mapConfig) {
            this.getServiceMemberConfigMap()[i] = mapConfig;
        }

        public void setServiceName(String[] asName) {
            this.__m_ServiceName = asName;
        }

        public void setServiceName(int i, String sName) {
            this.getServiceName()[i] = sName;
        }

        public void setServiceState(int[] anState) {
            this.__m_ServiceState = anState;
        }

        public void setServiceState(int i, int nState) {
            this.getServiceState()[i] = nState;
        }

        public void setServiceType(String[] asType) {
            this.__m_ServiceType = asType;
        }

        public void setServiceType(int i, String sType) {
            this.getServiceType()[i] = sType;
        }

        public void setServiceVersion(String[] aVersion) {
            this.__m_ServiceVersion = aVersion;
        }

        public void setServiceVersion(int i, String version) {
            this.getServiceVersion()[i] = version;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            this.getFromMemberUid().writeExternal(output);
            int cServices = this.getServiceCount();
            output.writeShort(cServices);
            if (cServices > 0) {
                int[] anServiceId = this.getServiceId();
                String[] asServiceName = this.getServiceName();
                String[] asServiceType = this.getServiceType();
                String[] asServiceVersion = this.getServiceVersion();
                String[] asServiceEndPoint = this.getServiceEndPointName();
                long[] alServiceJoinTime = this.getServiceJoinTime();
                int[] anServiceState = this.getServiceState();
                Map[] aMapMemberConfig = this.getServiceMemberConfigMap();
                for (int i = 0; i < cServices; ++i) {
                    output.writeShort(anServiceId[i]);
                    output.writeUTF(asServiceName[i]);
                    output.writeUTF(asServiceType[i]);
                    output.writeUTF(asServiceVersion[i]);
                    output.writeUTF(asServiceEndPoint[i]);
                    output.writeLong(alServiceJoinTime[i]);
                    output.writeInt(anServiceState[i]);
                    ExternalizableHelper.writeMap(output, aMapMemberConfig[i]);
                }
            }
            output.writeInt(this.getPreferredPacketLength());
            output.writeInt(this.getPreferredPort());
        }
    }

    public static class NewMemberWelcomeAnnounce
    extends DiscoveryMessage {
        private com.tangosol.coherence.component.net.Member __m_SeniorMember;
        private String __m_ServiceVersion;

        public NewMemberWelcomeAnnounce() {
            this(null, null, true);
        }

        public NewMemberWelcomeAnnounce(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(38);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NewMemberWelcomeAnnounce();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NewMemberWelcomeAnnounce".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "SeniorMember=" + String.valueOf(this.getSeniorMember()) + "\nServiceVersion=" + this.getServiceVersion();
        }

        public com.tangosol.coherence.component.net.Member getSeniorMember() {
            return this.__m_SeniorMember;
        }

        public String getServiceVersion() {
            return this.__m_ServiceVersion;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ClusterService service = (ClusterService)this.getService();
            if (!service.isRunning() || this.isReadError()) {
                return;
            }
            com.tangosol.coherence.component.net.Member memberFrom = this.getFromMember();
            switch (service.getState()) {
                case 0: 
                case 1: {
                    com.tangosol.coherence.component.net.Member memberThis;
                    com.tangosol.coherence.component.net.Member member = memberThis = service.getState() == 0 ? service.getAnnounceMember() : service.getRequestMember();
                    if (memberThis.equals(memberFrom)) break;
                    service.resetBroadcastCounter("the presence of an existing cluster", this);
                    break;
                }
                case 2: {
                    com.tangosol.coherence.component.net.Member memberThis = service.getThisMember();
                    if (memberThis.equals(memberFrom)) break;
                    int nMember = memberFrom.getId();
                    UUID uidMember = memberFrom.getUid32();
                    MasterMemberSet setMember = service.getClusterMemberSet();
                    ActualMemberSet setRecycled = setMember.getRecycleSet();
                    com.tangosol.coherence.component.net.Member memberById = setMember.getMember(nMember);
                    com.tangosol.coherence.component.net.Member memberByUid = setMember.getMember(uidMember);
                    if (memberById == null && memberByUid == null) {
                        com.tangosol.coherence.component.net.Member memberSenior = this.getSeniorMember();
                        if (!memberSenior.equals(setMember.getOldestMember()) && !memberSenior.equals(((MemberSet)setRecycled).getMember(memberSenior.getId()))) break;
                        service.ensureMember(memberFrom, this.getServiceVersion());
                        break;
                    }
                    if (memberById != memberByUid) {
                        // empty if block
                    } else {
                        break;
                    }
                }
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            ClusterService service = (ClusterService)this.getService();
            com.tangosol.coherence.component.net.Member memberSenior = service.instantiateMember();
            memberSenior.readExternal(input);
            this.setSeniorMember(memberSenior);
            this.setServiceVersion(input.readUTF());
            this.getFromMember().setTcpRingPort(input.readInt());
        }

        public void setSeniorMember(com.tangosol.coherence.component.net.Member member) {
            this.__m_SeniorMember = member;
        }

        public void setServiceVersion(String sVersion) {
            this.__m_ServiceVersion = sVersion;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            this.getSeniorMember().writeExternal(output);
            output.writeUTF(this.getServiceVersion());
            output.writeInt(this.getFromMember().getTcpRingPort());
        }
    }

    public static class NewMemberWelcomeRequest
    extends RequestMessage {
        private int __m_PreferredPacketLength;
        private int __m_PreferredPort;
        private String __m_ServiceVersion;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public NewMemberWelcomeRequest() {
            this(null, null, true);
        }

        public NewMemberWelcomeRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(39);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NewMemberWelcomeRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NewMemberWelcomeRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public int getPreferredPacketLength() {
            return this.__m_PreferredPacketLength;
        }

        public int getPreferredPort() {
            return this.__m_PreferredPort;
        }

        public String getServiceVersion() {
            return this.__m_ServiceVersion;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ClusterService service = (ClusterService)this.getService();
            MasterMemberSet setMembers = service.getClusterMemberSet();
            com.tangosol.coherence.component.net.Member member = this.getFromMember();
            int nMemberId = member.getId();
            member.setPreferredPort(this.getPreferredPort());
            member.setPreferredPacketLength(this.getPreferredPacketLength());
            String sVersion = this.getServiceVersion();
            if (sVersion == null) {
                sVersion = ClusterService.VERSION_BARRIER;
            } else {
                setMembers.setServiceVersion(nMemberId, sVersion);
            }
            if (service.isVersionOlder(sVersion)) {
                NewMemberWelcomeRequest._trace("Cluster member " + nMemberId + " is running an older Coherence version " + setMembers.getServiceVersionExternal(nMemberId), 2);
            }
            NewMemberWelcome msg = (NewMemberWelcome)service.instantiateMessage("NewMemberWelcome");
            msg.respondTo(this);
            service.populateWelcomeMessage(msg);
            service.send(msg);
            setMembers.setServiceJoined(nMemberId);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setPreferredPacketLength(input.readInt());
            this.setPreferredPort(input.readInt());
            try {
                this.setServiceVersion(input.readUTF());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void setPreferredPacketLength(int cb) {
            this.__m_PreferredPacketLength = cb;
        }

        public void setPreferredPort(int nPort) {
            this.__m_PreferredPort = nPort;
        }

        public void setServiceVersion(String sVersion) {
            this.__m_ServiceVersion = sVersion;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeInt(this.getPreferredPacketLength());
            output.writeInt(this.getPreferredPort());
            output.writeUTF(this.getServiceVersion());
        }

        static {
            NewMemberWelcomeRequest.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NewMemberWelcomeRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public void onCompletion() {
                ClusterService service = (ClusterService)this.getService();
                if (service.getServiceState() == 2) {
                    service.setAcceptingClients(true);
                }
            }
        }
    }

    public static class NotifyIpTimeout
    extends Message {
        private InetAddress __m_TimedOutAddress;

        public NotifyIpTimeout() {
            this(null, null, true);
        }

        public NotifyIpTimeout(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(55);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyIpTimeout();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NotifyIpTimeout".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public InetAddress getTimedOutAddress() {
            return this.__m_TimedOutAddress;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ((ClusterService)this.getService()).onNotifyIpTimeout(this.getTimedOutAddress());
        }

        public void setTimedOutAddress(InetAddress setTimedOut) {
            this.__m_TimedOutAddress = setTimedOut;
        }
    }

    public static class NotifyMemberLeft
    extends Grid.NotifyMemberLeft {
        public NotifyMemberLeft() {
            this(null, null, true);
        }

        public NotifyMemberLeft(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-6);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyMemberLeft();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NotifyMemberLeft".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ((ClusterService)this.getService()).onNotifyMemberLeft(this.getNotifyMember());
        }
    }

    public static class NotifyResponse
    extends Grid.NotifyResponse {
        private Continuation __m_Continuation;

        public NotifyResponse() {
            this(null, null, true);
        }

        public NotifyResponse(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-20);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyResponse();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NotifyResponse".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public Continuation getContinuation() {
            return this.__m_Continuation;
        }

        @Override
        public void onReceived() {
            Continuation action = this.getContinuation();
            if (action != null) {
                action.proceed(this.getResult());
            }
        }

        public void setContinuation(Continuation continuation) {
            this.__m_Continuation = continuation;
        }
    }

    public static class NotifyShutdown
    extends Grid.NotifyShutdown {
        public NotifyShutdown() {
            this(null, null, true);
        }

        public NotifyShutdown(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-13);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyShutdown();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NotifyShutdown".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void onReceived() {
            ClusterService service = (ClusterService)this.getService();
            service.setServiceState(3);
            service.doMemberLeaving();
            ((Cluster)service.getCluster()).waitHeuristicDelivery(500);
            service.doMemberLeft();
            service.stop();
        }
    }

    public static class NotifyTcmpTimeout
    extends Message {
        private transient MemberSet __m_TimedOutMembers;
        private transient MessagePacket __m_UndeliverablePacket;

        public NotifyTcmpTimeout() {
            this(null, null, true);
        }

        public NotifyTcmpTimeout(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(54);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyTcmpTimeout();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NotifyTcmpTimeout".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public MemberSet getTimedOutMembers() {
            return this.__m_TimedOutMembers;
        }

        public MessagePacket getUndeliverablePacket() {
            return this.__m_UndeliverablePacket;
        }

        @Override
        public void onReceived() {
            ((ClusterService)this.getService()).onNotifyTcmpTimeout(this.getUndeliverablePacket(), this.getTimedOutMembers());
        }

        public void setTimedOutMembers(MemberSet pTimedOutMembers) {
            this.__m_TimedOutMembers = pTimedOutMembers;
        }

        public void setUndeliverablePacket(MessagePacket pUndeliverablePacket) {
            this.__m_UndeliverablePacket = pUndeliverablePacket;
        }
    }

    public static class QuorumRollCall
    extends RequestMessage {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public QuorumRollCall() {
            this(null, null, true);
        }

        public QuorumRollCall(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(53);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new QuorumRollCall();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$QuorumRollCall".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        protected com.tangosol.coherence.component.net.Poll instantiatePoll() {
            return (Poll)this._newChild("Poll");
        }

        @Override
        public void onReceived() {
            ClusterService service = (ClusterService)this.getService();
            Grid.Acknowledgement msg = (Grid.Acknowledgement)service.instantiateMessage("Acknowledgement");
            msg.respondTo(this);
            service.send(msg);
        }

        static {
            QuorumRollCall.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$QuorumRollCall$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected MemberSet instantiateRespondedMemberSet() {
                return new ActualMemberSet();
            }

            @Override
            protected void onCompletion() {
                super.onCompletion();
                QuorumRollCall msgRollCall = (QuorumRollCall)this.get_Parent();
                ((ClusterService)this.get_Module()).getQuorumControl().onRollCallCompleted(msgRollCall);
            }

            @Override
            public void onResponded(com.tangosol.coherence.component.net.Member member) {
                super.onResponded(member);
                ((ClusterService)this.get_Module()).getQuorumControl().onRollCallResponded(member);
            }

            @Override
            public void onResponse(Message msg) {
                ((ClusterService)this.get_Module()).getQuorumControl().onRollCallResponse(msg.getFromMember());
                super.onResponse(msg);
            }
        }
    }

    public static class SeniorMemberHeartbeat
    extends DiscoveryMessage {
        private long __m_LastJoinTime;
        private long __m_LastReceivedMillis;
        private MemberSet __m_MemberSet;
        private boolean __m_WkaEnabled;

        public SeniorMemberHeartbeat() {
            this(null, null, true);
        }

        public SeniorMemberHeartbeat(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(17);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new SeniorMemberHeartbeat();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$SeniorMemberHeartbeat".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            long lLastRecvTimestamp = this.getLastReceivedMillis();
            String sLastRecvTimestamp = lLastRecvTimestamp == 0L ? "none" : new Date(lLastRecvTimestamp).toString();
            return "\nLastRecvTimestamp=" + sLastRecvTimestamp + "\nMemberSet=" + String.valueOf(this.getMemberSet());
        }

        public long getLastJoinTime() {
            return this.__m_LastJoinTime;
        }

        public long getLastReceivedMillis() {
            return this.__m_LastReceivedMillis;
        }

        public MemberSet getMemberSet() {
            return this.__m_MemberSet;
        }

        public boolean isWkaEnabled() {
            return this.__m_WkaEnabled;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ClusterService service = (ClusterService)this.getService();
            if (service.validateSeniorBroadcast(this, this.getMemberSet())) {
                com.tangosol.coherence.component.net.Member memberThis = service.getThisMember();
                if (this.getLastJoinTime() >= memberThis.getTimestamp() && !this.getMemberSet().contains(memberThis)) {
                    SeniorMemberHeartbeat._trace("Received cluster heartbeat from the senior " + String.valueOf(service.getClusterOldestMember()) + " that does not contain this " + String.valueOf(memberThis) + "; stopping cluster service.", 1);
                    service.onStopRunning();
                }
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setLastReceivedMillis(input.readLong());
            MemberSet setMember = new MemberSet();
            setMember.readExternal(input);
            this.setMemberSet(setMember);
            this.setWkaEnabled(input.readBoolean());
            this.setLastJoinTime(input.readLong());
            this.ensureEOS(input);
        }

        public void setLastJoinTime(long lTime) {
            this.__m_LastJoinTime = lTime;
        }

        public void setLastReceivedMillis(long cMillis) {
            this.__m_LastReceivedMillis = cMillis;
        }

        public void setMemberSet(MemberSet setMember) {
            this.__m_MemberSet = setMember;
        }

        public void setWkaEnabled(boolean pWkaEnabled) {
            this.__m_WkaEnabled = pWkaEnabled;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeLong(this.getLastReceivedMillis());
            this.getMemberSet().writeExternal(output);
            output.writeBoolean(this.isWkaEnabled());
            output.writeLong(this.getLastJoinTime());
        }
    }

    public static class SeniorMemberKill
    extends DiscoveryMessage {
        public SeniorMemberKill() {
            this(null, null, true);
        }

        public SeniorMemberKill(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(40);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new SeniorMemberKill();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$SeniorMemberKill".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "ToMember=" + String.valueOf(this.getToMember());
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ClusterService service = (ClusterService)this.getService();
            if (!service.isRunning()) {
                return;
            }
            switch (service.getState()) {
                case 0: 
                case 1: {
                    service.resetBroadcastCounter("the presence of an existing cluster", this);
                    break;
                }
                case 2: {
                    com.tangosol.coherence.component.net.Member memberFrom = this.getFromMember();
                    com.tangosol.coherence.component.net.Member memberKill = this.getToMember();
                    com.tangosol.coherence.component.net.Member memberThis = service.getThisMember();
                    if (!memberThis.getUid32().equals(memberKill.getUid32())) break;
                    SeniorMemberKill._trace("Received a Kill message from a valid " + String.valueOf(memberFrom) + "; stopping cluster service.", 1);
                    MasterMemberSet setMember = service.getClusterMemberSet();
                    if (memberThis == setMember.getOldestMember()) {
                        ActualMemberSet setOther = new ActualMemberSet();
                        ((MemberSet)setOther).addAll((Collection)setMember);
                        setOther.remove(memberThis);
                        for (com.tangosol.coherence.component.net.Member member : setOther) {
                            SeniorMemberKill msg = (SeniorMemberKill)service.instantiateMessage("SeniorMemberKill");
                            msg.setToMember(member);
                            msg.setToMemberSet(SingleMemberSet.instantiate(member));
                            service.send(msg);
                        }
                        try {
                            Blocking.sleep(service.getBroadcastRepeatMillis() * 2);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    service.onStopRunning();
                    break;
                }
            }
        }
    }

    public static class SeniorMemberPanic
    extends Message {
        private com.tangosol.coherence.component.net.Member __m_CulpritMember;
        private boolean __m_Zombie;

        public SeniorMemberPanic() {
            this(null, null, true);
        }

        public SeniorMemberPanic(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(41);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new SeniorMemberPanic();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$SeniorMemberPanic".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public com.tangosol.coherence.component.net.Member getCulpritMember() {
            return this.__m_CulpritMember;
        }

        @Override
        public String getDescription() {
            return "CulpritMember=" + String.valueOf(this.getCulpritMember()) + (this.isZombie() ? " (zombie)" : "");
        }

        public boolean isZombie() {
            return this.__m_Zombie;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ClusterService service = (ClusterService)this.getService();
            if (!service.isRunning() || service.getState() != 2) {
                return;
            }
            MasterMemberSet setMember = service.getClusterMemberSet();
            com.tangosol.coherence.component.net.Member memberThis = service.getThisMember();
            com.tangosol.coherence.component.net.Member memberFrom = this.getFromMember();
            com.tangosol.coherence.component.net.Member memberOldest = setMember.getOldestMember();
            com.tangosol.coherence.component.net.Member memberCulprit = this.getCulpritMember();
            com.tangosol.coherence.component.net.Member memberDead = setMember.findDeadMember(memberCulprit);
            if (memberThis == memberOldest) {
                service.addDynamicBroadcast(memberCulprit);
                if (memberDead == null) {
                    SeniorMemberPanic._trace("Received panic from junior member " + String.valueOf(memberFrom) + " caused by " + String.valueOf(memberCulprit), 2);
                } else {
                    SeniorMemberPanic msg = (SeniorMemberPanic)service.instantiateMessage("SeniorMemberPanic");
                    msg.setCulpritMember(memberCulprit);
                    msg.addToMember(memberFrom);
                    msg.setZombie(true);
                    service.send(msg);
                }
            } else if (memberFrom == memberOldest) {
                if (this.isZombie()) {
                    if (memberDead == null) {
                        memberCulprit.setDead(true);
                        setMember.getRecycleSet().add(memberCulprit);
                    }
                } else {
                    SeniorMemberPanic._trace("Received panic from senior " + String.valueOf(memberFrom) + " caused by " + String.valueOf(memberCulprit), 1);
                    SeniorMemberKill msg = (SeniorMemberKill)service.instantiateMessage("SeniorMemberKill");
                    msg.setToMember(memberCulprit);
                    service.send(msg);
                }
            } else {
                SeniorMemberPanic._trace("Deferring panic notification from " + String.valueOf(memberFrom), 4);
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            this.setZombie(input.readBoolean());
            ClusterService service = (ClusterService)this.getService();
            com.tangosol.coherence.component.net.Member memberCulprit = service.instantiateMember();
            memberCulprit.readExternal(input);
            this.setCulpritMember(memberCulprit);
        }

        public void setCulpritMember(com.tangosol.coherence.component.net.Member uid) {
            this.__m_CulpritMember = uid;
        }

        public void setZombie(boolean fZombie) {
            this.__m_Zombie = fZombie;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            output.writeBoolean(this.isZombie());
            this.getCulpritMember().writeExternal(output);
        }
    }

    public static class ServiceJoined
    extends Message {
        private int __m_ServiceId;

        public ServiceJoined() {
            this(null, null, true);
        }

        public ServiceJoined(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(49);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ServiceJoined();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$ServiceJoined".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "ServiceId=" + this.getServiceId();
        }

        public int getServiceId() {
            return this.__m_ServiceId;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ClusterService service = (ClusterService)this.getService();
            int nService = this.getServiceId();
            ServiceInfo info = service.getServiceInfo(nService);
            if (info == null) {
                ServiceJoined._trace("ClusterService$ServiceJoined: Unknown Service " + nService, 1);
            } else {
                ServiceMemberSet setMember;
                com.tangosol.coherence.component.net.Member member = this.getFromMember();
                if (member == service.getThisMember()) {
                    ServiceJoined msg = (ServiceJoined)service.instantiateMessage("ServiceJoined");
                    msg.setToMemberSet(service.getOthersMemberSet());
                    msg.setServiceId(nService);
                    service.send(msg);
                }
                if ((setMember = info.getMemberSet()).contains(member)) {
                    setMember.setServiceJoined(member.getId());
                } else if (service.isAcceptingClients()) {
                    ServiceJoined._trace("Ignoring out of order ServiceJoined for " + info.getServiceName() + " from " + String.valueOf(member), 5);
                }
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            this.setServiceId(input.readUnsignedShort());
        }

        public void setServiceId(int nId) {
            this.__m_ServiceId = nId;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            output.writeShort(this.getServiceId());
        }
    }

    public static class ServiceJoining
    extends RequestMessage
    implements Continuation {
        private transient ServiceJoinRequest __m_JoinRequest;
        private Map __m_MemberConfigMap;
        private int __m_MemberId;
        private PermissionInfo __m_PermissionInfo;
        private String __m_ServiceEndPointName;
        private int __m_ServiceId;
        private long __m_ServiceJoinTime;
        private String __m_ServiceName;
        private String __m_ServiceType;
        private String __m_ServiceVersion;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public ServiceJoining() {
            this(null, null, true);
        }

        public ServiceJoining(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(43);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ServiceJoining();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$ServiceJoining".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public String getDescription() {
            return "MemberId=" + this.getMemberId() + "\nServiceId=" + this.getServiceId() + "\nServiceName=" + this.getServiceName() + "\nServiceVersion=" + this.getServiceVersion() + "\nServiceEndPoint=" + this.getServiceEndPointName() + "\nServiceJoinTime=" + this.getServiceJoinTime() + "\nMemberConfigMap=" + String.valueOf(this.getMemberConfigMap());
        }

        public ServiceJoinRequest getJoinRequest() {
            return this.__m_JoinRequest;
        }

        public Map getMemberConfigMap() {
            return this.__m_MemberConfigMap;
        }

        public int getMemberId() {
            return this.__m_MemberId;
        }

        public PermissionInfo getPermissionInfo() {
            return this.__m_PermissionInfo;
        }

        public String getServiceEndPointName() {
            return this.__m_ServiceEndPointName;
        }

        public int getServiceId() {
            return this.__m_ServiceId;
        }

        public long getServiceJoinTime() {
            return this.__m_ServiceJoinTime;
        }

        public String getServiceName() {
            return this.__m_ServiceName;
        }

        public String getServiceType() {
            return this.__m_ServiceType;
        }

        public String getServiceVersion() {
            return this.__m_ServiceVersion;
        }

        @Override
        protected com.tangosol.coherence.component.net.Poll instantiatePoll() {
            return (Poll)this._newChild("Poll");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceived() {
            ServiceMemberSet setMember;
            ServiceInfo info;
            super.onReceived();
            ClusterService service = (ClusterService)this.getService();
            int nMember = this.getMemberId();
            com.tangosol.coherence.component.net.Member member = service.getClusterMemberSet().getMember(nMember);
            if (member == null) {
                String sReason = "Member " + nMember + (service.getClusterMemberSet().getRecycleSet().getMember(nMember) == null ? " is unknown to" : " is detected as departed by") + " member " + service.getThisMember().getId();
                this.proceed(sReason);
                return;
            }
            com.tangosol.coherence.component.net.Member memberThis = service.getThisMember();
            long ldtJoined = this.getServiceJoinTime();
            if (member == memberThis) {
                int nServiceId = this.getServiceId();
                info = service.getServiceInfo(nServiceId);
                ServiceJoining._assert(info != null);
                com.tangosol.coherence.component.net.Poll pollJoinRequest = this.getPoll();
                if (pollJoinRequest == null || pollJoinRequest.isClosed()) {
                    ServiceJoining._trace("Ignoring delayed response to JoinRequest for " + this.getServiceName() + " at " + ServiceMemberSet.formatJoinTime(ldtJoined), 3);
                    this.proceed((Object)null);
                    return;
                }
            } else {
                info = service.ensureServiceInfo(this.getServiceId(), this.getServiceName(), this.getServiceType());
            }
            if ((setMember = info.getMemberSet()).contains(member)) {
                if (member == memberThis) {
                    throw new IllegalStateException("Service " + this.getServiceName() + " joining request for this member is out of order");
                }
                int nState = setMember.getState(nMember);
                setMember.remove(member);
                service.onServiceLeft(info, member, nState);
            }
            if (setMember.contains(memberThis) && ldtJoined < setMember.getServiceJoinTime(memberThis.getId())) {
                ServiceJoining._trace("Service " + this.getServiceName() + " joining request for member " + member.getId() + " (joinTime=" + ServiceMemberSet.formatJoinTime(ldtJoined) + ") out of order:\n" + String.valueOf(setMember), 1);
                this.proceed("New service member is older than member" + memberThis.getId());
                return;
            }
            ServiceMemberSet serviceMemberSet = setMember;
            synchronized (serviceMemberSet) {
                setMember.add(member);
                setMember.setServiceVersion(nMember, this.getServiceVersion());
                setMember.setServiceJoinTime(nMember, ldtJoined);
                setMember.setServiceJoining(nMember);
                setMember.setServiceEndPointName(nMember, this.getServiceEndPointName());
                setMember.updateMemberConfigMap(nMember, this.getMemberConfigMap());
            }
            service.onServiceJoining(info, member);
            service.validateNewService(info, member, this, this.getPermissionInfo());
        }

        public void proceed(Object oResult) {
            ClusterService service = (ClusterService)this.getService();
            ServiceUpdateResponse msgResponse = (ServiceUpdateResponse)service.instantiateMessage("ServiceUpdateResponse");
            msgResponse.respondTo(this);
            if (oResult instanceof String || oResult instanceof Exception) {
                service.getServiceInfo(this.getServiceId()).getMemberSet().remove(this.getMemberId());
            }
            msgResponse.setResult(oResult);
            service.send(msgResponse);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            try {
                this.setMemberId(input.readUnsignedShort());
                this.setServiceId(input.readUnsignedShort());
                this.setServiceName(input.readUTF());
                this.setServiceType(input.readUTF());
                this.setServiceVersion(input.readUTF());
                this.setServiceEndPointName(input.readUTF());
                this.setServiceJoinTime(input.readLong());
                this.setMemberConfigMap((Map)this.readObject(input));
                this.setPermissionInfo((PermissionInfo)this.readObject(input));
            }
            catch (IOException e) {
                this.getService().onConfigIOException(e, this.getFromMember());
            }
        }

        public void setJoinRequest(ServiceJoinRequest pJoinRequest) {
            this.__m_JoinRequest = pJoinRequest;
        }

        public void setMemberConfigMap(Map map) {
            this.__m_MemberConfigMap = map;
        }

        public void setMemberId(int pMemberId) {
            this.__m_MemberId = pMemberId;
        }

        public void setPermissionInfo(PermissionInfo infoPermission) {
            this.__m_PermissionInfo = infoPermission;
        }

        public void setServiceEndPointName(String sName) {
            this.__m_ServiceEndPointName = sName;
        }

        public void setServiceId(int nId) {
            this.__m_ServiceId = nId;
        }

        public void setServiceJoinTime(long lMillis) {
            this.__m_ServiceJoinTime = lMillis;
        }

        public void setServiceName(String sName) {
            this.__m_ServiceName = sName;
        }

        public void setServiceType(String pServiceType) {
            this.__m_ServiceType = pServiceType;
        }

        public void setServiceVersion(String sVersion) {
            this.__m_ServiceVersion = sVersion;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            output.writeShort(this.getMemberId());
            output.writeShort(this.getServiceId());
            output.writeUTF(this.getServiceName());
            output.writeUTF(this.getServiceType());
            output.writeUTF(this.getServiceVersion());
            output.writeUTF(this.getServiceEndPointName());
            output.writeLong(this.getServiceJoinTime());
            this.writeObject(output, this.getMemberConfigMap());
            this.writeObject(output, this.getPermissionInfo());
        }

        static {
            ServiceJoining.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$ServiceJoining$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected void onCompletion() {
                ClusterService service = (ClusterService)this.getService();
                if (service.isRunning()) {
                    ServiceJoining msgJoining = (ServiceJoining)this.get_Parent();
                    ServiceJoinRequest msgRequest = msgJoining.getJoinRequest();
                    if (msgRequest != null) {
                        Object oResult = this.getResult();
                        com.tangosol.coherence.component.net.Member member = msgRequest.getFromMember();
                        if (oResult instanceof String || oResult instanceof Exception || member == service.getThisMember()) {
                            ServiceUpdateResponse msg = (ServiceUpdateResponse)service.instantiateMessage("ServiceUpdateResponse");
                            msg.respondTo(msgRequest);
                            msg.setResult(oResult);
                            service.send(msg);
                        } else {
                            ServiceJoining msg = (ServiceJoining)service.instantiateMessage("ServiceJoining");
                            msg.respondTo(msgRequest);
                            msg.setMemberId(msgJoining.getMemberId());
                            msg.setServiceId(msgJoining.getServiceId());
                            msg.setServiceJoinTime(msgJoining.getServiceJoinTime());
                            msg.setServiceName(msgJoining.getServiceName());
                            msg.setServiceType(msgJoining.getServiceType());
                            msg.setServiceVersion(msgJoining.getServiceVersion());
                            msg.setServiceEndPointName(msgJoining.getServiceEndPointName());
                            msg.setMemberConfigMap(msgJoining.getMemberConfigMap());
                            msg.setPermissionInfo((PermissionInfo)oResult);
                            service.registerServiceJoining(msg);
                            service.send(msg);
                        }
                    }
                    service.unregisterServiceJoining(msgJoining);
                }
                super.onCompletion();
            }

            @Override
            public void onResponse(Message msg) {
                this.setResult(((ServiceUpdateResponse)msg).getResult());
                super.onResponse(msg);
            }

            @Override
            public void setResult(Object oResult) {
                if (oResult != null) {
                    Object oResultPrev = this.getResult();
                    if (oResultPrev == null) {
                        super.setResult(oResult);
                    } else if (oResultPrev instanceof PermissionInfo) {
                        if (oResult instanceof String || oResult instanceof Exception) {
                            super.setResult(oResult);
                        }
                    } else if (oResultPrev instanceof String) {
                        if (oResult instanceof Exception) {
                            super.setResult(oResult);
                        }
                    } else if (oResultPrev instanceof Exception) {
                        return;
                    }
                }
            }
        }
    }

    public static class ServiceJoinRequest
    extends RequestMessage
    implements Continuation {
        private Map __m_MemberConfigMap;
        private PermissionInfo __m_PermissionInfo;
        private String __m_ServiceEndPointName;
        private int __m_ServiceId;
        private String __m_ServiceVersion;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public ServiceJoinRequest() {
            this(null, null, true);
        }

        public ServiceJoinRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(42);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ServiceJoinRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$ServiceJoinRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public String getDescription() {
            return "ServiceId=" + this.getServiceId() + "\nServiceVersion=" + this.getServiceVersion() + "\nServiceEndPoint=" + this.getServiceEndPointName() + "\nMemberConfigMap=" + String.valueOf(this.getMemberConfigMap());
        }

        public Map getMemberConfigMap() {
            return this.__m_MemberConfigMap;
        }

        public PermissionInfo getPermissionInfo() {
            return this.__m_PermissionInfo;
        }

        public String getServiceEndPointName() {
            return this.__m_ServiceEndPointName;
        }

        public int getServiceId() {
            return this.__m_ServiceId;
        }

        public String getServiceVersion() {
            return this.__m_ServiceVersion;
        }

        @Override
        protected com.tangosol.coherence.component.net.Poll instantiatePoll() {
            return (Poll)this._newChild("Poll");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceived() {
            super.onReceived();
            ClusterService service = (ClusterService)this.getService();
            int nService = this.getServiceId();
            ServiceInfo info = service.getServiceInfo(nService);
            if (info == null) {
                ServiceUpdateResponse msg = (ServiceUpdateResponse)service.instantiateMessage("ServiceUpdateResponse");
                msg.respondTo(this);
                service.send(msg);
            } else {
                com.tangosol.coherence.component.net.Member member;
                ServiceMemberSet setMember = info.getMemberSet();
                if (setMember.contains(member = this.getFromMember())) {
                    int nState = setMember.getState(member.getId());
                    setMember.remove(member);
                    service.onServiceLeft(info, member, nState);
                }
                long ldtJoined = service.getTimestamp();
                int nMember = member.getId();
                Iterator iter = setMember.iterator();
                while (iter.hasNext()) {
                    long ldtOld = setMember.getServiceJoinTime(((com.tangosol.coherence.component.net.Member)iter.next()).getId());
                    if (ldtJoined > ldtOld) continue;
                    ldtJoined = ldtOld + 1L;
                }
                ServiceMemberSet serviceMemberSet = setMember;
                synchronized (serviceMemberSet) {
                    setMember.add(member);
                    setMember.setServiceVersion(nMember, this.getServiceVersion());
                    setMember.setServiceJoinTime(nMember, ldtJoined);
                    setMember.setServiceJoining(nMember);
                    setMember.setServiceEndPointName(nMember, this.getServiceEndPointName());
                    setMember.updateMemberConfigMap(nMember, this.getMemberConfigMap());
                }
                service.onServiceJoining(info, member);
                service.validateNewService(info, member, this, this.getPermissionInfo());
            }
        }

        public void proceed(Object oResult) {
            ClusterService service = (ClusterService)this.getService();
            com.tangosol.coherence.component.net.Member member = this.getFromMember();
            int nMember = member.getId();
            int nService = this.getServiceId();
            ServiceInfo info = service.getServiceInfo(nService);
            ServiceJoinRequest._assert(info != null);
            if (oResult instanceof SecurityException) {
                ServiceJoinRequest._trace("member left due to security exception", 1);
                service.doMemberLeft(member);
                return;
            }
            if (oResult instanceof String || oResult instanceof Exception) {
                info.getMemberSet().remove(member);
                ServiceUpdateResponse msg = (ServiceUpdateResponse)service.instantiateMessage("ServiceUpdateResponse");
                msg.respondTo(this);
                msg.setResult(oResult);
                service.send(msg);
            } else {
                MemberSet setOthers = service.getOthersMemberSet();
                setOthers.remove(member);
                ServiceJoining msg = (ServiceJoining)service.instantiateMessage("ServiceJoining");
                msg.setMemberId(nMember);
                msg.setServiceId(nService);
                msg.setServiceName(info.getServiceName());
                msg.setServiceType(info.getServiceType());
                msg.setServiceJoinTime(info.getServiceJoinTime(nMember));
                msg.setServiceVersion(this.getServiceVersion());
                msg.setServiceEndPointName(this.getServiceEndPointName());
                msg.setMemberConfigMap(this.getMemberConfigMap());
                msg.setToMemberSet(setOthers);
                msg.setJoinRequest(this);
                msg.setPermissionInfo(this.getPermissionInfo());
                ((ServiceJoining.Poll)msg.ensureRequestPoll()).setResult((PermissionInfo)oResult);
                service.registerServiceJoining(msg);
                service.send(msg);
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            try {
                this.setServiceId(input.readUnsignedShort());
                this.setServiceVersion(input.readUTF());
                this.setServiceEndPointName(input.readUTF());
                this.setMemberConfigMap((Map)this.readObject(input));
                this.setPermissionInfo((PermissionInfo)this.readObject(input));
            }
            catch (IOException e) {
                this.getService().onConfigIOException(e, this.getFromMember());
            }
        }

        public void setMemberConfigMap(Map map) {
            this.__m_MemberConfigMap = map;
        }

        public void setPermissionInfo(PermissionInfo service) {
            this.__m_PermissionInfo = service;
        }

        public void setServiceEndPointName(String sEndPoint) {
            this.__m_ServiceEndPointName = sEndPoint;
        }

        public void setServiceId(int nId) {
            this.__m_ServiceId = nId;
        }

        public void setServiceVersion(String sVersion) {
            this.__m_ServiceVersion = sVersion;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            output.writeShort(this.getServiceId());
            output.writeUTF(this.getServiceVersion());
            output.writeUTF(this.getServiceEndPointName());
            this.writeObject(output, this.getMemberConfigMap());
            this.writeObject(output, this.getPermissionInfo());
        }

        static {
            ServiceJoinRequest.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$ServiceJoinRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected void onCompletion() {
                if (!this.getRespondedMemberSet().isEmpty()) {
                    Security security;
                    ClusterService service = (ClusterService)this.getService();
                    ServiceJoinRequest msgRequest = (ServiceJoinRequest)this.get_Parent();
                    int nServiceId = msgRequest.getServiceId();
                    ServiceMemberSet setInfoMember = service.getServiceInfo(nServiceId).getMemberSet();
                    Grid serviceJoining = service.getService(nServiceId);
                    com.tangosol.coherence.component.net.Member memberThis = service.getThisMember();
                    Object oResult = this.getResult();
                    Security security2 = security = nServiceId > 1 ? Security.getInstance() : null;
                    if (serviceJoining != null && setInfoMember.getServiceJoinTime(memberThis.getId()) > 0L && (security == null && oResult == null || security != null && (oResult instanceof PermissionInfo || oResult == null && memberThis == setInfoMember.getOldestMember()))) {
                        ServiceMemberSet setServiceMember = new ServiceMemberSet();
                        setServiceMember.copy(setInfoMember);
                        setServiceMember.setThisMember(memberThis);
                        serviceJoining.setServiceMemberSet(setServiceMember);
                        Poll._assert(serviceJoining.getThisMemberConfigMap().equals(msgRequest.getMemberConfigMap()));
                        if (service.getServiceInfo(nServiceId).isSuspended()) {
                            Grid.NotifyServiceQuiescence msg = (Grid.NotifyServiceQuiescence)serviceJoining.instantiateMessage("NotifyServiceQuiescence");
                            msg.addToMember(memberThis);
                            msg.setResume(false);
                            msg.post();
                        }
                    } else {
                        setInfoMember.remove(memberThis);
                    }
                }
                super.onCompletion();
            }

            @Override
            public void onResponse(Message msg) {
                if (msg instanceof ServiceUpdateResponse) {
                    this.setResult(((ServiceUpdateResponse)msg).getResult());
                } else if (msg instanceof ServiceJoining) {
                    this.setResult(((ServiceJoining)msg).getPermissionInfo());
                }
                super.onResponse(msg);
            }
        }
    }

    public static class ServiceLeaving
    extends Message {
        private int __m_ServiceId;
        private long __m_ServiceJoinTime;

        public ServiceLeaving() {
            this(null, null, true);
        }

        public ServiceLeaving(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(44);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ServiceLeaving();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$ServiceLeaving".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "ServiceId=" + this.getServiceId();
        }

        public int getServiceId() {
            return this.__m_ServiceId;
        }

        public long getServiceJoinTime() {
            return this.__m_ServiceJoinTime;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ClusterService service = (ClusterService)this.getService();
            int nService = this.getServiceId();
            ServiceInfo info = service.getServiceInfo(nService);
            if (info == null) {
                ServiceLeaving._trace("ClusterService$ServiceLeaving: Unknown Service " + nService, 4);
            } else {
                ServiceMemberSet setMember;
                com.tangosol.coherence.component.net.Member member = this.getFromMember();
                long ldtJoined = this.getServiceJoinTime();
                if (member == service.getThisMember()) {
                    ServiceLeaving msg = (ServiceLeaving)service.instantiateMessage("ServiceLeaving");
                    msg.setToMemberSet(service.getOthersMemberSet());
                    msg.setServiceId(nService);
                    msg.setServiceJoinTime(ldtJoined);
                    service.send(msg);
                }
                if ((setMember = info.getMemberSet()).contains(member)) {
                    ServiceLeaving._assert(ldtJoined > 0L);
                    int nMember = member.getId();
                    if (setMember.getServiceJoinTime(nMember) == ldtJoined) {
                        setMember.setServiceLeaving(nMember);
                        service.onServiceLeaving(info, member);
                    }
                } else {
                    ServiceLeaving._trace("ClusterService$ServiceLeaving: " + info.getServiceName() + "; Unknown " + String.valueOf(member), 6);
                }
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            this.setServiceId(input.readUnsignedShort());
            this.setServiceJoinTime(input.readLong());
        }

        public void setServiceId(int nId) {
            this.__m_ServiceId = nId;
        }

        public void setServiceJoinTime(long ldtJoined) {
            this.__m_ServiceJoinTime = ldtJoined;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            output.writeShort(this.getServiceId());
            output.writeLong(this.getServiceJoinTime());
        }
    }

    public static class ServiceLeft
    extends Message {
        private int __m_MemberLeftId;
        private int __m_ServiceId;
        private long __m_ServiceJoinTime;

        public ServiceLeft() {
            this(null, null, true);
        }

        public ServiceLeft(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(45);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ServiceLeft();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$ServiceLeft".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "ServiceId=" + this.getServiceId();
        }

        public int getMemberLeftId() {
            return this.__m_MemberLeftId;
        }

        public int getServiceId() {
            return this.__m_ServiceId;
        }

        public long getServiceJoinTime() {
            return this.__m_ServiceJoinTime;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ClusterService service = (ClusterService)this.getService();
            int nService = this.getServiceId();
            ServiceInfo info = service.getServiceInfo(nService);
            if (info == null) {
                ServiceLeft._trace("ClusterService$ServiceLeft: Unknown Service " + nService, 4);
            } else {
                ServiceMemberSet setMember = info.getMemberSet();
                com.tangosol.coherence.component.net.Member memberThis = service.getThisMember();
                int nMemberId = this.getMemberLeftId();
                com.tangosol.coherence.component.net.Member memberLeft = service.getClusterMemberSet().getMember(nMemberId);
                long ldtJoined = this.getServiceJoinTime();
                if (memberLeft == null) {
                    return;
                }
                if (memberThis == memberLeft || memberThis == service.getClusterOldestMember() && setMember.contains(memberLeft)) {
                    ServiceLeft msg = (ServiceLeft)service.instantiateMessage("ServiceLeft");
                    MemberSet setTo = service.getOthersMemberSet();
                    setTo.remove(nMemberId);
                    msg.setToMemberSet(setTo);
                    msg.setServiceId(nService);
                    msg.setMemberLeftId(nMemberId);
                    msg.setServiceJoinTime(memberThis != memberLeft && ldtJoined == 0L ? setMember.getServiceJoinTime(nMemberId) : ldtJoined);
                    service.send(msg);
                }
                if (setMember.contains(memberLeft)) {
                    if (setMember.getServiceJoinTime(nMemberId) == ldtJoined || ldtJoined == 0L) {
                        int nState = setMember.getState(nMemberId);
                        setMember.remove(memberLeft);
                        service.onServiceLeft(info, memberLeft, nState);
                    }
                } else {
                    ServiceLeft._trace("ClusterService$ServiceLeft: " + info.getServiceName() + "; Unknown " + String.valueOf(memberLeft), 6);
                }
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            this.setServiceId(input.readUnsignedShort());
            this.setServiceJoinTime(input.readLong());
            try {
                this.setMemberLeftId(input.readUnsignedShort());
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }

        public void setMemberLeftId(int nId) {
            this.__m_MemberLeftId = nId;
        }

        public void setServiceId(int nId) {
            this.__m_ServiceId = nId;
        }

        public void setServiceJoinTime(long ldtJoined) {
            this.__m_ServiceJoinTime = ldtJoined;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            output.writeShort(this.getServiceId());
            output.writeLong(this.getServiceJoinTime());
            output.writeShort(this.getMemberLeftId());
        }
    }

    public static class ServiceQuiescenceRequest
    extends RequestMessage
    implements Continuation {
        private transient int __m_PendingCounter;
        private boolean __m_Relay;
        private boolean __m_Resume;
        private boolean __m_ResumeOnFailover;
        private int __m_ServiceId;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public ServiceQuiescenceRequest() {
            this(null, null, true);
        }

        public ServiceQuiescenceRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(57);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ServiceQuiescenceRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$ServiceQuiescenceRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public Message cloneMessage() {
            ServiceQuiescenceRequest msg = (ServiceQuiescenceRequest)super.cloneMessage();
            msg.setServiceId(this.getServiceId());
            msg.setResume(this.isResume());
            return msg;
        }

        public int getPendingCounter() {
            return this.__m_PendingCounter;
        }

        public int getServiceId() {
            return this.__m_ServiceId;
        }

        public boolean isRelay() {
            return this.__m_Relay;
        }

        public boolean isResume() {
            return this.__m_Resume;
        }

        protected boolean isResumeOnFailover() {
            return this.__m_ResumeOnFailover;
        }

        @Override
        public void onReceived() {
            ServiceInfo[] serviceInfoArray;
            ClusterService clusterSvc = (ClusterService)this.getService();
            int nServiceId = this.getServiceId();
            int cPending = 0;
            boolean fResume = this.isResume();
            boolean fResumeFailover = this.isResumeOnFailover();
            if (nServiceId == 0) {
                serviceInfoArray = clusterSvc.getServiceInfo();
            } else {
                ServiceInfo[] serviceInfoArray2 = new ServiceInfo[1];
                serviceInfoArray = serviceInfoArray2;
                serviceInfoArray2[0] = clusterSvc.getServiceInfo(nServiceId);
            }
            for (ServiceInfo info : serviceInfoArray) {
                if (info == null) continue;
                info.setSuspended(!fResume);
                Grid service = clusterSvc.getService(info.getServiceId());
                if (service == null) continue;
                Grid.NotifyServiceQuiescence msg = (Grid.NotifyServiceQuiescence)service.instantiateMessage("NotifyServiceQuiescence");
                msg.addToMember(service.getThisMember());
                msg.setResume(fResume);
                msg.setResumeOnFailover(fResumeFailover);
                NotifyResponse msgContinue = (NotifyResponse)clusterSvc.instantiateMessage("NotifyResponse");
                msgContinue.setService(clusterSvc);
                msgContinue.setContinuation(this);
                msg.setContinuationMessage(msgContinue);
                service.send(msg);
                ++cPending;
            }
            if (this.isRelay()) {
                ServiceQuiescenceRequest msg = (ServiceQuiescenceRequest)clusterSvc.instantiateMessage("ServiceQuiescenceRequest");
                msg.setServiceId(nServiceId);
                msg.setResume(fResume);
                msg.setResumeOnFailover(fResumeFailover);
                msg.setRelay(false);
                msg.setToMemberSet(clusterSvc.getOthersMemberSet());
                ((Poll)msg.ensureRequestPoll()).setContinuation(this);
                ++cPending;
                msg.post();
            }
            if (cPending == 0) {
                this.sendReply();
            } else {
                this.setPendingCounter(cPending);
            }
        }

        public void proceed(Object oResult) {
            int cPending = this.getPendingCounter() - 1;
            this.setPendingCounter(cPending);
            if (cPending == 0) {
                this.sendReply();
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setServiceId(input.readInt());
            this.setResume(input.readBoolean());
            this.setResumeOnFailover(input.readBoolean());
            this.setRelay(input.readBoolean());
        }

        protected void sendReply() {
            Message msgResp = this.getService().instantiateMessage("Response");
            msgResp.respondTo(this);
            msgResp.post();
        }

        public void setPendingCounter(int sProperty) {
            this.__m_PendingCounter = sProperty;
        }

        public void setRelay(boolean fRelay) {
            this.__m_Relay = fRelay;
        }

        public void setResume(boolean fResume) {
            this.__m_Resume = fResume;
        }

        public void setResumeOnFailover(boolean fResume) {
            this.__m_ResumeOnFailover = fResume;
        }

        public void setServiceId(int nId) {
            this.__m_ServiceId = nId;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeInt(this.getServiceId());
            output.writeBoolean(this.isResume());
            output.writeBoolean(this.isResumeOnFailover());
            output.writeBoolean(this.isRelay());
        }

        static {
            ServiceQuiescenceRequest.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            private transient Continuation __m_Continuation;

            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$ServiceQuiescenceRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public Continuation getContinuation() {
                return this.__m_Continuation;
            }

            @Override
            protected void onCompletion() {
                Continuations.proceed(this.getContinuation(), null);
            }

            public void setContinuation(Continuation continuation) {
                this.__m_Continuation = continuation;
            }
        }
    }

    public static class ServiceRegister
    extends RequestMessage {
        private transient ServiceRegisterRequest __m_RegisterRequest;
        private int __m_ServiceId;
        private String __m_ServiceName;
        private String __m_ServiceType;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public ServiceRegister() {
            this(null, null, true);
        }

        public ServiceRegister(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(46);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ServiceRegister();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$ServiceRegister".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public String getDescription() {
            return "ServiceId=" + this.getServiceId() + "\nServiceName=" + this.getServiceName();
        }

        public ServiceRegisterRequest getRegisterRequest() {
            return this.__m_RegisterRequest;
        }

        public int getServiceId() {
            return this.__m_ServiceId;
        }

        public String getServiceName() {
            return this.__m_ServiceName;
        }

        public String getServiceType() {
            return this.__m_ServiceType;
        }

        @Override
        protected com.tangosol.coherence.component.net.Poll instantiatePoll() {
            return (Poll)this._newChild("Poll");
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ClusterService service = (ClusterService)this.getService();
            service.ensureServiceInfo(this.getServiceId(), this.getServiceName(), this.getServiceType());
            ServiceUpdateResponse msg = (ServiceUpdateResponse)service.instantiateMessage("ServiceUpdateResponse");
            msg.respondTo(this);
            service.send(msg);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            this.setServiceId(input.readUnsignedShort());
            this.setServiceName(input.readUTF());
            this.setServiceType(input.readUTF());
        }

        public void setRegisterRequest(ServiceRegisterRequest msgRequest) {
            this.__m_RegisterRequest = msgRequest;
        }

        public void setServiceId(int nId) {
            this.__m_ServiceId = nId;
        }

        public void setServiceName(String sName) {
            this.__m_ServiceName = sName;
        }

        public void setServiceType(String sType) {
            this.__m_ServiceType = sType;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            output.writeShort(this.getServiceId());
            output.writeUTF(this.getServiceName());
            output.writeUTF(this.getServiceType());
        }

        static {
            ServiceRegister.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$ServiceRegister$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected void onCompletion() {
                ServiceRegister msgRegister = (ServiceRegister)this.get_Parent();
                ServiceRegisterRequest msgRequest = msgRegister.getRegisterRequest();
                if (msgRequest != null) {
                    ClusterService service = (ClusterService)this.getService();
                    ServiceRegister msg = (ServiceRegister)service.instantiateMessage("ServiceRegister");
                    msg.respondTo(msgRequest);
                    msg.setServiceId(msgRegister.getServiceId());
                    msg.setServiceName(msgRegister.getServiceName());
                    msg.setServiceType(msgRegister.getServiceType());
                    service.send(msg);
                }
                super.onCompletion();
            }
        }
    }

    public static class ServiceRegisterRequest
    extends RequestMessage {
        private String __m_ServiceName;
        private String __m_ServiceType;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public ServiceRegisterRequest() {
            this(null, null, true);
        }

        public ServiceRegisterRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(47);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ServiceRegisterRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$ServiceRegisterRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public String getDescription() {
            return "ServiceName=" + this.getServiceName();
        }

        public String getServiceName() {
            return this.__m_ServiceName;
        }

        public String getServiceType() {
            return this.__m_ServiceType;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            ClusterService service = (ClusterService)this.getService();
            String sName = this.getServiceName();
            String sType = this.getServiceType();
            ServiceRegister msg = (ServiceRegister)service.instantiateMessage("ServiceRegister");
            msg.setServiceName(sName);
            int nId = service.indexOfService(sName);
            if (nId < 0) {
                nId = service.getServiceInfoCount();
                service.ensureServiceInfo(nId, sName, sType);
                msg.setServiceType(sType);
                MemberSet setOthers = service.getOthersMemberSet();
                setOthers.remove(this.getFromMember());
                if (!setOthers.isEmpty()) {
                    msg.setToMemberSet(setOthers);
                    msg.setServiceId(nId);
                    msg.setRegisterRequest(this);
                    service.send(msg);
                    return;
                }
            } else {
                msg.setServiceType(service.getServiceInfo(nId).getServiceType());
            }
            msg.respondTo(this);
            msg.setServiceId(nId);
            service.send(msg);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            this.setServiceName(input.readUTF());
            this.setServiceType(input.readUTF());
        }

        public void setServiceName(String sName) {
            this.__m_ServiceName = sName;
        }

        public void setServiceType(String pServiceType) {
            this.__m_ServiceType = pServiceType;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            output.writeUTF(this.getServiceName());
            output.writeUTF(this.getServiceType());
        }

        static {
            ServiceRegisterRequest.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$ServiceRegisterRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public void onResponse(Message msg) {
                ServiceRegister msgRegister = (ServiceRegister)msg;
                this.setResult(Base.makeInteger(msgRegister.getServiceId()));
                super.onResponse(msg);
            }
        }
    }

    public static class ServiceUpdateResponse
    extends Message {
        private Object __m_Result;

        public ServiceUpdateResponse() {
            this(null, null, true);
        }

        public ServiceUpdateResponse(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(48);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ServiceUpdateResponse();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$ServiceUpdateResponse".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public Object getResult() {
            return this.__m_Result;
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            try {
                this.setResult(this.readObject(input));
                if (input.skipBytes(1) != 0) {
                    throw new IOException("message contains more data than expected");
                }
            }
            catch (IOException e) {
                this.getService().onConfigIOException(e, this.getFromMember());
            }
        }

        public void setResult(Object oResult) {
            this.__m_Result = oResult;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            this.writeObject(output, this.getResult());
        }
    }

    public static class WitnessRequest
    extends RequestMessage {
        private UUID __m_MemberUUID;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public WitnessRequest() {
            this(null, null, true);
        }

        public WitnessRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(56);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new WitnessRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$WitnessRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public String getDescription() {
            return "MemberUid=" + String.valueOf(this.getMemberUUID());
        }

        public UUID getMemberUUID() {
            return this.__m_MemberUUID;
        }

        @Override
        protected com.tangosol.coherence.component.net.Poll instantiatePoll() {
            return (Poll)this._newChild("Poll");
        }

        @Override
        public void onReceived() {
            ClusterService service = (ClusterService)this.getService();
            com.tangosol.coherence.component.net.Member member = service.getClusterMemberSet().getMember(this.getMemberUUID());
            com.tangosol.coherence.component.net.Member memberReq = this.getFromMember();
            Grid.Response response = (Grid.Response)service.instantiateMessage("Response");
            response.respondTo(this);
            if (member == null) {
                response.setResult(0);
            } else if (!this.getMemberUUID().equals(member.getUid32())) {
                WitnessRequest._trace("Rejecting MemberLeft " + String.valueOf(this) + "\nfor " + String.valueOf(member) + " with different UID " + String.valueOf(member.getUid32()), 1);
                response.setResult(2);
            } else if ((service.isRecentlyHeuristicallyDead(member) || service.isSlow(member)) && !service.isRecentlyHeuristicallyDead(memberReq) && !service.isSlow(memberReq)) {
                WitnessRequest._trace("Confirming the departure request by " + service.getMemberStatsDescription(memberReq) + " regarding " + service.getMemberStatsDescription(member), 3);
                response.setResult(0);
            } else {
                WitnessRequest._trace("Rejecting the departure confirmation request by " + service.getMemberStatsDescription(memberReq) + " regarding " + service.getMemberStatsDescription(member), 3);
                response.setResult(2);
            }
            service.send(response);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            UUID uuid = new UUID();
            uuid.readExternal(input);
            this.setMemberUUID(uuid);
        }

        public void setMemberUUID(UUID uid) {
            this.__m_MemberUUID = uid;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            this.getMemberUUID().writeExternal(output);
        }

        static {
            WitnessRequest.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$WitnessRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public void onCompletion() {
                if (((ClusterService)this.getService()).isRunning()) {
                    ClusterService service = (ClusterService)this.getService();
                    com.tangosol.coherence.component.net.Member memberSuspect = service.getClusterMemberSet().getMember(((WitnessRequest)this.get_Parent()).getMemberUUID());
                    com.tangosol.coherence.component.net.Member memberWitness = (com.tangosol.coherence.component.net.Member)this.getResult();
                    if (memberSuspect == null) {
                        return;
                    }
                    if (memberWitness != null) {
                        Poll._trace("Member time-out confirmed by " + String.valueOf(memberWitness) + "; marking " + service.getMemberStatsDescription(memberSuspect) + " as suspect", 3);
                        service.onMembersTimedOut(Collections.singleton(memberSuspect));
                    } else if (this.getLeftMemberSet().isEmpty()) {
                        int nComp = service.compareImportance(memberSuspect);
                        Poll._trace("This node appears to have partially lost connectivity: it receives responses from " + String.valueOf(this.getRespondedMemberSet()) + " which communicate with " + service.getMemberStatsDescription(memberSuspect) + ", but is not responding directly to this member; that could mean that either requests are not coming out or responses are not coming in; marking " + (nComp == 0 ? "this" : "the lower priority") + " member as suspect.", 1);
                        service.onMembersTimedOut(Collections.singleton(nComp <= 0 ? service.getThisMember() : memberSuspect));
                    } else {
                        memberSuspect.setDeaf(false);
                    }
                }
            }

            @Override
            public void onResponse(Message msg) {
                if (!this.isClosed() && ((Grid.Response)msg).getResult() == 0) {
                    this.setResult(msg.getFromMember());
                    super.onResponse(msg);
                    this.close();
                } else {
                    super.onResponse(msg);
                }
            }
        }
    }

    public static class QuorumControl
    extends Component
    implements Cluster.MemberTimeoutAction {
        private Map __m_AnnouncingMembers;
        private Set __m_ConvictedMembers;
        private long __m_IncidentStartTime;
        private long __m_MoratoriumTimeMillis;
        private QuorumRollCall __m_PendingRollCall;
        private int __m_PresenceProofExpiry;
        private boolean __m_Suicide;

        public QuorumControl() {
            this(null, null, true);
        }

        public QuorumControl(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new QuorumControl();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$QuorumControl".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        protected boolean attemptDisconnect() {
            ClusterService service = this.getService();
            Set setConvicts = this.getConvictedMembers();
            if (Base.getSafeTimeMillis() < this.getMoratoriumTimeMillis()) {
                return false;
            }
            if (service.getActionPolicy().isAllowed(service, this)) {
                if (this.isSuicide()) {
                    QuorumControl._trace("Stopping ClusterService", 2);
                    service.onStopRunning();
                } else {
                    QuorumControl._trace("Timed-out members " + String.valueOf(setConvicts) + " will be removed.", 2);
                    Iterator iter = setConvicts.iterator();
                    while (iter.hasNext()) {
                        service.doMemberLeft((com.tangosol.coherence.component.net.Member)iter.next());
                    }
                }
                this.onIncidentClosed();
                return true;
            }
            return false;
        }

        protected void doRollCall() {
            ClusterService service = this.getService();
            long ldtExpiry = Base.getSafeTimeMillis() + (long)this.getPresenceProofExpiry();
            QuorumRollCall msgRollCall = (QuorumRollCall)service.instantiateMessage("QuorumRollCall");
            msgRollCall.ensureRequestPoll().setExpiryTimeMillis(ldtExpiry);
            msgRollCall.setToMemberSet(service.getOthersMemberSet());
            this.setPendingRollCall(msgRollCall);
            service.send(msgRollCall);
        }

        protected long ensureIncidentStartTime(long ldtNow) {
            long ldtStart = this.getIncidentStartTime();
            if (ldtStart == 0L) {
                ldtStart = ldtNow;
                this.setIncidentStartTime(ldtStart);
            }
            return ldtStart;
        }

        protected long ensureMemberTimeoutStamp(com.tangosol.coherence.component.net.Member member, long ldtNow) {
            long ldtTimeout = member.getLastTimeoutMillis();
            if (ldtTimeout == 0L) {
                ldtTimeout = ldtNow;
                member.setLastTimeoutMillis(ldtTimeout);
            }
            return ldtTimeout;
        }

        public String formatStatus() {
            Set setConvicts = this.getConvictedMembers();
            if (setConvicts.isEmpty()) {
                return "";
            }
            HashSet<String> setMachines = new HashSet<String>();
            StringBuilder sb = new StringBuilder();
            sb.append("timed-out-members: {");
            Iterator iter = setConvicts.iterator();
            while (iter.hasNext()) {
                com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)iter.next();
                sb.append(member.getId());
                setMachines.add(member.getMachineName());
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            sb.append("}; machine-names: {");
            iter = setMachines.iterator();
            while (iter.hasNext()) {
                sb.append(iter.next());
                if (!iter.hasNext()) continue;
                sb.append(", ");
            }
            sb.append('}');
            return sb.toString();
        }

        public Map getAnnouncingMembers() {
            Map map = this.__m_AnnouncingMembers;
            if (map == null) {
                map = new LocalCache(Integer.MAX_VALUE, 2000);
                this.setAnnouncingMembers(map);
            }
            return map;
        }

        public Set getAnnouncingMemberSet() {
            return new ImmutableArrayList(this.getAnnouncingMembers().values()).getSet();
        }

        public Set getConvictedMembers() {
            return this.__m_ConvictedMembers;
        }

        @Override
        public long getIncidentStartTime() {
            return this.__m_IncidentStartTime;
        }

        public long getMoratoriumTimeMillis() {
            return this.__m_MoratoriumTimeMillis;
        }

        public QuorumRollCall getPendingRollCall() {
            return this.__m_PendingRollCall;
        }

        public int getPresenceProofExpiry() {
            int cExpiryMillis = this.__m_PresenceProofExpiry;
            if (cExpiryMillis == 0) {
                cExpiryMillis = Config.getInteger("coherence.quorum.expirymillis", this.getService().getDeliveryTimeoutMillis() >> 2);
                this.setPresenceProofExpiry(cExpiryMillis);
            }
            return cExpiryMillis;
        }

        public Set getResponsiveMemberSet() {
            com.tangosol.coherence.component.net.Member memberThis = this.getService().getThisMember();
            QuorumRollCall msgRollCall = this.getPendingRollCall();
            if (msgRollCall == null || this.getConvictedMembers().contains(memberThis)) {
                return NullImplementation.getSet();
            }
            MemberSet setReplies = msgRollCall.getRequestPoll().getRespondedMemberSet();
            DeltaSet setHealthy = new DeltaSet(setReplies);
            setHealthy.removeAll(this.getConvictedMembers());
            setHealthy.add(memberThis);
            return Collections.unmodifiableSet(setHealthy);
        }

        public ClusterService getService() {
            return (ClusterService)this.get_Module();
        }

        public Set getTimedOutMemberSet() {
            return this.isSuicide() ? Collections.singleton(this.getService().getThisMember()) : Collections.unmodifiableSet(this.getConvictedMembers());
        }

        public boolean isClusterSuspended() {
            return this.getPendingRollCall() != null;
        }

        public boolean isSuicide() {
            return this.__m_Suicide;
        }

        protected void onIncidentClosed() {
            QuorumRollCall msgRollCall = this.getPendingRollCall();
            if (msgRollCall != null) {
                msgRollCall.getRequestPoll().close();
                this.setPendingRollCall(null);
            }
            this.setIncidentStartTime(0L);
            this.setSuicide(false);
            this.getConvictedMembers().clear();
        }

        @Override
        public void onInit() {
            DependentMemberSet setConvicts = new DependentMemberSet();
            setConvicts.setBaseSet(this.getService().getClusterMemberSet());
            this.setConvictedMembers(setConvicts);
            super.onInit();
        }

        public void onMemberAnnounceWaiting(com.tangosol.coherence.component.net.Member member) {
            this.getAnnouncingMembers().put(member.getSocketAddress(), member);
        }

        public void onMemberJoined(com.tangosol.coherence.component.net.Member member) {
            this.getAnnouncingMembers().remove(member.getSocketAddress());
        }

        public void onMemberLeft(com.tangosol.coherence.component.net.Member member) {
            Set setConvicts = this.getConvictedMembers();
            if (setConvicts.remove(member) && setConvicts.isEmpty() || this.getService().getOthersMemberSet().isEmpty()) {
                this.onIncidentClosed();
            }
        }

        public void onMembersTimedOut(Set setTimedOut) {
            QuorumRollCall msgRollCall;
            ClusterService service = this.getService();
            Set setConvicts = this.getConvictedMembers();
            com.tangosol.coherence.component.net.Member memberThis = service.getThisMember();
            long ldtNow = Base.getSafeTimeMillis();
            this.ensureIncidentStartTime(ldtNow);
            if (!this.isSuicide()) {
                if (setTimedOut.contains(memberThis)) {
                    this.setSuicide(true);
                    this.ensureMemberTimeoutStamp(memberThis, ldtNow);
                    setConvicts.clear();
                    setConvicts.add(memberThis);
                } else {
                    setConvicts.addAll(setTimedOut);
                    for (com.tangosol.coherence.component.net.Member member : setTimedOut) {
                        member.setDeaf(true);
                        this.ensureMemberTimeoutStamp(member, ldtNow);
                    }
                }
            }
            if (!this.attemptDisconnect() && (msgRollCall = this.getPendingRollCall()) == null) {
                this.doRollCall();
            }
        }

        public void onRollCallCompleted(QuorumRollCall msgRollCall) {
            this.setPendingRollCall(null);
            ClusterService service = this.getService();
            Set setConvicts = this.getConvictedMembers();
            if (service.getServiceState() >= 3 || setConvicts.isEmpty()) {
                return;
            }
            if (this.isSuicide() && !msgRollCall.getRequestPoll().getRespondedMemberSet().isEmpty()) {
                com.tangosol.coherence.component.net.Member memberThis = service.getThisMember();
                long ldtNow = Base.getSafeTimeMillis();
                QuorumControl._trace("Re-established connectivity with the rest of the cluster (which has been timed-out for " + (ldtNow - memberThis.getLastTimeoutMillis()) + "ms)", 3);
                this.setMoratoriumTimeMillis(ldtNow + (long)this.getPresenceProofExpiry());
                memberThis.setLastTimeoutMillis(0L);
                this.onIncidentClosed();
            } else if (!this.attemptDisconnect()) {
                String sAction = this.isSuicide() ? "Stopping the local ClusterService" : "Disconnect of suspect members " + String.valueOf(setConvicts);
                QuorumControl._trace(sAction + " is disallowed by the cluster quorum policy.", 2);
                this.doRollCall();
            }
        }

        public void onRollCallResponded(com.tangosol.coherence.component.net.Member member) {
            this.attemptDisconnect();
        }

        public void onRollCallResponse(com.tangosol.coherence.component.net.Member member) {
            Set setConvicts = this.getConvictedMembers();
            if (setConvicts.contains(member)) {
                member.setDeaf(false);
                if (!this.getService().isHeuristicallyDead(member)) {
                    long ldtNow = Base.getSafeTimeMillis();
                    QuorumControl._trace("Member " + member.getId() + " (which had timed-out " + String.valueOf(new Duration((ldtNow - member.getLastTimeoutMillis()) * 1000000L)) + " ago) has become available again.", 3);
                    setConvicts.remove(member);
                    member.setLastTimeoutMillis(0L);
                    if (setConvicts.isEmpty()) {
                        this.onIncidentClosed();
                    } else {
                        this.setMoratoriumTimeMillis(ldtNow + (long)this.getPresenceProofExpiry());
                    }
                }
            }
        }

        protected void setAnnouncingMembers(Map setAnnounce) {
            this.__m_AnnouncingMembers = setAnnounce;
        }

        protected void setConvictedMembers(Set setConvicts) {
            this.__m_ConvictedMembers = setConvicts;
        }

        protected void setIncidentStartTime(long ldtStart) {
            this.__m_IncidentStartTime = ldtStart;
        }

        protected void setMoratoriumTimeMillis(long cMoratoriumMillis) {
            this.__m_MoratoriumTimeMillis = cMoratoriumMillis;
        }

        protected void setPendingRollCall(QuorumRollCall msgRollCall) {
            this.__m_PendingRollCall = msgRollCall;
        }

        protected void setPresenceProofExpiry(int cExpiryMillis) {
            this.__m_PresenceProofExpiry = cExpiryMillis;
        }

        protected void setSuicide(boolean fSuicide) {
            this.__m_Suicide = fSuicide;
        }
    }

    public static class TcpRing
    extends com.tangosol.coherence.component.net.TcpRing
    implements Notifier {
        private transient boolean __m_Enabled;

        public TcpRing() {
            this(null, null, true);
        }

        public TcpRing(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setBuddies(new HashMap());
                this.setEnabled(true);
                this.setSocketOptions(new SocketOptions());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new TcpRing.MemberMonitor("MemberMonitor", this, true), "MemberMonitor");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new TcpRing();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$TcpRing".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void await() throws InterruptedException {
            this.await(0L);
        }

        @Override
        public void await(long cMillis) throws InterruptedException {
            this.select(cMillis);
        }

        public Set computeBuddies() {
            if (!this.isEnabled()) {
                return NullImplementation.getSet();
            }
            com.tangosol.coherence.component.net.Member memberThis = ((ClusterService)this.get_Module()).getThisMember();
            HashSet<com.tangosol.coherence.component.net.Member> setBuddy = new HashSet<com.tangosol.coherence.component.net.Member>();
            setBuddy.add(this.getRingBuddy(memberThis, false));
            setBuddy.add(this.getRoleBuddy(memberThis, false));
            setBuddy.remove(null);
            return setBuddy;
        }

        public com.tangosol.coherence.component.net.Member getRingBuddy(com.tangosol.coherence.component.net.Member member, boolean fStrong) {
            com.tangosol.coherence.component.net.Member buddy;
            MasterMemberSet setMembers = ((ClusterService)this.get_Module()).getClusterMemberSet();
            int nBuddy = setMembers.getPrevId(member.getId());
            if (fStrong) {
                int nMachine = member.getMachineId();
                do {
                    buddy = ((MemberSet)setMembers).getMember(nBuddy == 0 ? setMembers.getLastId() : nBuddy);
                    nBuddy = setMembers.getPrevId(buddy.getId());
                } while (buddy.getMachineId() == nMachine && buddy != member);
            } else {
                buddy = ((MemberSet)setMembers).getMember(nBuddy == 0 ? setMembers.getLastId() : nBuddy);
            }
            return buddy == member ? null : buddy;
        }

        public com.tangosol.coherence.component.net.Member getRoleBuddy(com.tangosol.coherence.component.net.Member member, boolean fStrong) {
            com.tangosol.coherence.component.net.Member buddy;
            String sRole = member.getRoleName();
            int nMachine = member.getMachineId();
            MasterMemberSet setMembers = ((ClusterService)this.get_Module()).getClusterMemberSet();
            int nBuddy = setMembers.getPrevId(member.getId());
            do {
                buddy = ((MemberSet)setMembers).getMember(nBuddy == 0 ? setMembers.getLastId() : nBuddy);
                nBuddy = setMembers.getPrevId(buddy.getId());
            } while ((fStrong && nMachine == buddy.getMachineId() || !Base.equals(buddy.getRoleName(), sRole)) && buddy != member);
            return buddy == member ? null : buddy;
        }

        public boolean isEnabled() {
            return this.__m_Enabled;
        }

        @Override
        protected void onDeadBuddy(com.tangosol.coherence.component.net.Member member, IOException e) {
            ((ClusterService)this.get_Module()).onNotifyTcpDeparture(member);
            super.onDeadBuddy(member, e);
        }

        @Override
        protected void onIsolation() {
            ClusterService service = (ClusterService)this.get_Module();
            int cMembers = service.getServiceMemberSet().size();
            if (cMembers > 1) {
                NewMemberAnnounce msg = (NewMemberAnnounce)service.instantiateMessage("NewMemberAnnounce");
                msg.setAnnounceProtocolVersion(1);
                msg.setFromMember(service.getThisMember());
                msg.setAttemptCounter(1);
                msg.setAttemptLimit(1);
                service.send(msg);
            }
        }

        public void onJoined() {
            this.ensureTopology(this.computeBuddies());
        }

        public void onLeft() {
            this.ensureTopology(NullImplementation.getSet());
            this.disconnectAll();
        }

        public void onMemberJoined(com.tangosol.coherence.component.net.Member member) {
            Set setBuddies = this.computeBuddies();
            if (setBuddies.contains(member)) {
                this.ensureTopology(setBuddies);
            }
        }

        public void onMemberLeft(com.tangosol.coherence.component.net.Member member) {
            if (this.getBuddies().containsKey(member)) {
                this.ensureTopology(this.computeBuddies());
                ((ClusterService)this.get_Module()).ensureMemberLeft(null, null, false);
            }
        }

        public void setEnabled(boolean fEnabled) {
            this.__m_Enabled = fEnabled;
        }

        @Override
        public void signal() {
            this.wakeup();
        }

        @Override
        public String toString() {
            if (this.isEnabled()) {
                return super.toString();
            }
            return "TcpRing{disabled}";
        }

        @Override
        public void wakeup() {
            block2: {
                try {
                    super.wakeup();
                }
                catch (RuntimeException e) {
                    if (((ClusterService)this.get_Module()).isExiting()) break block2;
                    throw e;
                }
            }
        }
    }
}

