/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.oracle.coherence.common.base.Blocking;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.Channel;
import com.tangosol.coherence.component.net.extend.Codec;
import com.tangosol.coherence.component.net.extend.message.Request;
import com.tangosol.coherence.component.net.extend.message.Response;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.daemon.QueueProcessor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.net.security.AccessAdapter;
import com.tangosol.internal.net.service.DefaultServiceDependencies;
import com.tangosol.internal.net.service.peer.DefaultPeerDependencies;
import com.tangosol.internal.net.service.peer.LegacyXmlPeerHelper;
import com.tangosol.internal.net.service.peer.PeerDependencies;
import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.WrapperBufferInput;
import com.tangosol.io.WrapperBufferOutput;
import com.tangosol.io.WrapperDataInputStream;
import com.tangosol.io.WrapperDataOutputStream;
import com.tangosol.io.WrapperStreamFactory;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.license.LicenseException;
import com.tangosol.net.Guardable;
import com.tangosol.net.Guardian;
import com.tangosol.net.Member;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.Connection;
import com.tangosol.net.messaging.ConnectionEvent;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.ConnectionListener;
import com.tangosol.net.messaging.ConnectionManager;
import com.tangosol.net.messaging.Message;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.net.messaging.Request;
import com.tangosol.net.security.IdentityAsserter;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.Subject;

public abstract class Peer
extends Service
implements Channel.Receiver,
ConnectionManager {
    private transient Channel __m__Channel;
    private transient com.tangosol.coherence.component.net.extend.Connection __m__Connection;
    private com.tangosol.net.messaging.Codec __m_Codec;
    private Listeners __m_ConnectionListeners;
    private static transient boolean __s_DEBUG;
    private static transient String __s_LicenseError;
    private int __m_MaxIncomingMessageSize;
    private int __m_MaxOutgoingMessageSize;
    private transient com.tangosol.net.Service __m_ParentService;
    private long __m_PingInterval;
    private transient long __m_PingLastCheckMillis;
    private transient long __m_PingLastMillis;
    private long __m_PingTimeout;
    private static transient UUID __s_ProcessId;
    private com.tangosol.net.messaging.Protocol __m_Protocol;
    private Map __m_ProtocolMap;
    private transient Map __m_ProtocolVersionMap;
    private transient Map __m_ReceiverMap;
    private long __m_RequestTimeout;
    private transient long __m_StatsBytesReceived;
    private transient long __m_StatsBytesSent;
    private transient long __m_StatsSent;
    private volatile transient long __m_StatsTimeoutCount;
    private transient List __m_WrapperStreamFactoryList;
    private static ListMap __mapChildren;

    private static void _initStatic$Default() {
        Peer.__initStatic();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("DispatchEvent", DispatchEvent.get_CLASS());
        __mapChildren.put("MessageFactory", MessageFactory.get_CLASS());
        __mapChildren.put("Queue", QueueProcessor.Queue.get_CLASS());
    }

    public Peer(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_ConnectionListeners = new Listeners();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public com.tangosol.net.messaging.Channel acceptChannel(com.tangosol.coherence.component.net.extend.Connection connection, URI uri, ClassLoader loader, Channel.Receiver receiver, Subject subject) {
        Peer._assert(connection != null);
        Channel channel0 = this.get_Channel();
        Protocol.MessageFactory factory0 = channel0.getMessageFactory();
        MessageFactory.AcceptChannel request = (MessageFactory.AcceptChannel)factory0.createMessage(-1);
        request.setChannelUri(uri);
        request.setClassLoader(loader);
        request.setConnection(connection);
        request.setIdentityToken(this.serializeIdentityToken(this.generateIdentityToken(subject)));
        request.setReceiver(receiver);
        request.setSubject(subject);
        Request.Status status = (Request.Status)channel0.request(request);
        MessageFactory.AcceptChannelResponse response = (MessageFactory.AcceptChannelResponse)status.waitForResponse(this.getRequestTimeout());
        return (Channel)response.getResult();
    }

    @Override
    public void addConnectionListener(ConnectionListener l) {
        this.ensureEventDispatcher();
        this.getConnectionListeners().add(l);
    }

    protected WriteBuffer allocateWriteBuffer() {
        return new ByteArrayWriteBuffer(1024);
    }

    public Subject assertIdentityToken(Object oToken) {
        return this.getOperationalContext().getIdentityAsserter().assertIdentity(oToken, this.getParentService());
    }

    protected void checkPingTimeout(com.tangosol.coherence.component.net.extend.Connection connection) {
        long ldtPing;
        long cMillis = this.getPingTimeout();
        if (cMillis > 0L && (ldtPing = connection.getPingLastMillis()) > 0L && Base.getSafeTimeMillis() >= ldtPing + cMillis) {
            connection.close(false, new ConnectionException("did not receive a response to a ping within " + cMillis + " millis", (Connection)connection));
        }
    }

    protected void checkPingTimeouts() {
    }

    @Override
    protected DefaultServiceDependencies cloneDependencies(ServiceDependencies deps) {
        return new DefaultPeerDependencies((PeerDependencies)deps);
    }

    public void closeChannel(Channel channel, boolean fNotify, Throwable e) {
        this.closeChannel(channel, fNotify, e, true);
    }

    public void closeChannel(Channel channel, boolean fNotify, Throwable e, boolean fWait) {
        Peer._assert(channel != null);
        Channel channel0 = this.get_Channel();
        Protocol.MessageFactory factory0 = channel0.getMessageFactory();
        MessageFactory.CloseChannel request = (MessageFactory.CloseChannel)factory0.createMessage(-2);
        request.setCause(e);
        request.setChannelClose(channel);
        request.setNotify(fNotify);
        if (fWait) {
            channel0.request(request);
        } else {
            channel0.send(request);
        }
    }

    public void closeConnection(com.tangosol.coherence.component.net.extend.Connection connection, boolean fNotify, Throwable e, boolean fWait) {
        Peer._assert(connection != null);
        Channel channel0 = this.get_Channel();
        Protocol.MessageFactory factory0 = channel0.getMessageFactory();
        MessageFactory.CloseConnection request = (MessageFactory.CloseConnection)factory0.createMessage(-3);
        request.setCause(e);
        request.setConnectionClose(connection);
        request.setNotify(fNotify);
        if (fWait) {
            channel0.request(request);
        } else {
            channel0.send(request);
        }
    }

    @Override
    public synchronized void configure(XmlElement xml) {
        this.setDependencies(LegacyXmlPeerHelper.fromXml(xml, new DefaultPeerDependencies(), this.getOperationalContext(), this.getContextClassLoader()));
        this.setServiceConfig(xml);
    }

    public URI createChannel(com.tangosol.coherence.component.net.extend.Connection connection, com.tangosol.net.messaging.Protocol protocol, ClassLoader loader, Channel.Receiver receiver) {
        Peer._assert(connection != null);
        Channel channel0 = this.get_Channel();
        Protocol.MessageFactory factory0 = channel0.getMessageFactory();
        MessageFactory.CreateChannel request = (MessageFactory.CreateChannel)factory0.createMessage(-4);
        request.setClassLoader(loader);
        request.setConnection(connection);
        request.setProtocol(protocol);
        request.setReceiver(receiver);
        return (URI)channel0.request(request);
    }

    protected Message decodeMessage(ReadBuffer.BufferInput in, com.tangosol.coherence.component.net.extend.Connection connection, boolean fFilter) throws IOException {
        Channel channel;
        Peer._assert(in != null);
        Peer._assert(connection != null);
        com.tangosol.net.messaging.Codec codec = this.getCodec();
        Peer._assert(codec != null);
        if (fFilter) {
            in = this.filterBufferInput(in);
        }
        if ((channel = (Channel)connection.getChannel(in.readPackedInt())) == null || !channel.isOpen()) {
            return null;
        }
        Message message = codec.decode(channel, in);
        message.setChannel(channel);
        return message;
    }

    public Object deserializeIdentityToken(byte[] abToken) {
        if (abToken != null) {
            try {
                ByteArrayReadBuffer buf = new ByteArrayReadBuffer(abToken);
                return this.ensureSerializer().deserialize(buf.getBufferInput());
            }
            catch (Exception e) {
                Peer._trace(e, "An exception occurred while deserializing an identity token");
                throw new SecurityException("invalid identity token");
            }
        }
        return null;
    }

    protected void dispatchConnectionEvent(Connection connection, int nEvent, Throwable e) {
        Listeners listeners = this.getConnectionListeners();
        if (!listeners.isEmpty()) {
            this.dispatchEvent(new ConnectionEvent(connection, nEvent, e), listeners);
        }
    }

    public long drainOverflow(long cMillisTimeout) throws InterruptedException {
        Service.EventDispatcher dispatcher = this.getEventDispatcher();
        return dispatcher == null ? cMillisTimeout : dispatcher.drainOverflow(cMillisTimeout);
    }

    protected void encodeMessage(Message message, WriteBuffer.BufferOutput out, boolean fFilter) throws IOException {
        Peer._assert(message != null);
        Peer._assert(out != null);
        com.tangosol.net.messaging.Channel channel = message.getChannel();
        Peer._assert(channel != null);
        com.tangosol.net.messaging.Codec codec = this.getCodec();
        Peer._assert(codec != null);
        if (fFilter) {
            out = this.filterBufferOutput(out);
        }
        out.writePackedInt(channel.getId());
        codec.encode(channel, message, out);
        out.close();
    }

    public void enforceMaxIncomingMessageSize(int cbSize) throws IOException {
        int cbMax = this.getMaxIncomingMessageSize();
        if (cbMax > 0 && cbSize > cbMax) {
            throw new IOException("message length: " + cbSize + " exceeds the maximum incoming message size");
        }
    }

    public void enforceMaxOutgoingMessageSize(int cbSize) throws IOException {
        int cbMax = this.getMaxOutgoingMessageSize();
        if (cbMax > 0 && cbSize > cbMax) {
            throw new IOException("message length: " + cbSize + " exceeds the maximum outgoing message size");
        }
    }

    protected ReadBuffer.BufferInput filterBufferInput(ReadBuffer.BufferInput in) throws IOException {
        List list = this.getWrapperStreamFactoryList();
        if (list == null || list.isEmpty()) {
            return in;
        }
        InputStream stream = new WrapperDataInputStream(in);
        int c = list.size();
        for (int i = 0; i < c; ++i) {
            try {
                stream = ((WrapperStreamFactory)list.get(i)).getInputStream(stream);
                continue;
            }
            catch (RuntimeException e) {
                Throwable t = Base.getOriginalException(e);
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw e;
            }
        }
        DataInput din = stream instanceof DataInput ? (DataInput)((Object)stream) : new DataInputStream(stream);
        return new WrapperBufferInput(din, this.getContextClassLoader());
    }

    protected WriteBuffer.BufferOutput filterBufferOutput(WriteBuffer.BufferOutput out) throws IOException {
        List list = this.getWrapperStreamFactoryList();
        if (list == null || list.isEmpty()) {
            return out;
        }
        OutputStream stream = new WrapperDataOutputStream(out);
        int c = list.size();
        for (int i = 0; i < c; ++i) {
            try {
                stream = ((WrapperStreamFactory)list.get(i)).getOutputStream(stream);
                continue;
            }
            catch (RuntimeException e) {
                Throwable t = Base.getOriginalException(e);
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw e;
            }
        }
        DataOutput dout = stream instanceof DataOutput ? (DataOutput)((Object)stream) : new DataOutputStream(stream);
        return new WrapperBufferOutput(dout);
    }

    @Override
    public String formatStats() {
        long cTotal = Math.max(System.currentTimeMillis() - this.getStatsReset(), 0L);
        long cbRcvd = this.getStatsBytesReceived();
        long cbSent = this.getStatsBytesSent();
        long cbpsIn = cTotal == 0L ? 0L : cbRcvd / cTotal * 1000L;
        long cbpsOut = cTotal == 0L ? 0L : cbSent / cTotal * 1000L;
        StringBuffer sb = new StringBuffer(super.formatStats());
        sb.append(", BytesReceived=").append(Base.toMemorySizeString(cbRcvd, false)).append(", BytesSent=").append(Base.toMemorySizeString(cbSent, false)).append(", ThroughputInbound=").append(Base.toBandwidthString(cbpsIn, false)).append(", ThroughputOutbound=").append(Base.toBandwidthString(cbpsOut, false));
        return sb.toString();
    }

    public Object generateIdentityToken(Subject subject) {
        return this.getOperationalContext().getIdentityTransformer().transformIdentity(subject, this.getParentService());
    }

    public Channel get_Channel() {
        return this.__m__Channel;
    }

    public com.tangosol.coherence.component.net.extend.Connection get_Connection() {
        return this.__m__Connection;
    }

    public AccessAdapter getAccessAdapter() {
        IdentityAsserter asserter = this.getOperationalContext().getIdentityAsserter();
        return asserter instanceof AccessAdapter ? (AccessAdapter)((Object)asserter) : null;
    }

    @Override
    public com.tangosol.net.messaging.Codec getCodec() {
        return this.__m_Codec;
    }

    public Listeners getConnectionListeners() {
        return this.__m_ConnectionListeners;
    }

    @Override
    public float getDefaultGuardRecovery() {
        com.tangosol.net.Service service = this.getParentService();
        if (service instanceof Guardian) {
            return ((Guardian)((Object)service)).getDefaultGuardRecovery();
        }
        return super.getDefaultGuardRecovery();
    }

    @Override
    public long getDefaultGuardTimeout() {
        com.tangosol.net.Service service = this.getParentService();
        if (service instanceof Guardian) {
            return ((Guardian)((Object)service)).getDefaultGuardTimeout();
        }
        return super.getDefaultGuardTimeout();
    }

    @Override
    public String getDescription() {
        com.tangosol.net.messaging.Codec codec;
        StringBuffer sb = new StringBuffer();
        com.tangosol.coherence.component.util.DaemonPool pool = this.getDaemonPool();
        if (pool.isStarted()) {
            sb.append("ThreadCount=").append(pool.getDaemonCount()).append(", HungThreshold=").append(pool.getHungThreshold()).append(", TaskTimeout=").append(pool.getTaskTimeout());
        } else {
            sb.append("ThreadCount=0");
        }
        List list = this.getWrapperStreamFactoryList();
        if (list != null && !list.isEmpty()) {
            sb.append(", Filters=[");
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                sb.append(iter.next().getClass().getName());
                if (!iter.hasNext()) continue;
                sb.append(',');
            }
            sb.append(']');
        }
        if ((codec = this.getCodec()) != null) {
            sb.append(", Codec=").append(codec);
        }
        sb.append(", Serializer=").append(this.ensureSerializer().getClass().getName()).append(", PingInterval=").append(this.getPingInterval()).append(", PingTimeout=").append(this.getPingTimeout()).append(", RequestTimeout=").append(this.getRequestTimeout()).append(", MaxIncomingMessageSize=").append(this.getMaxIncomingMessageSize()).append(", MaxOutgoingMessageSize=").append(this.getMaxOutgoingMessageSize());
        return sb.toString();
    }

    public static String getLicenseError() {
        return __s_LicenseError;
    }

    public int getMaxIncomingMessageSize() {
        return this.__m_MaxIncomingMessageSize;
    }

    public int getMaxOutgoingMessageSize() {
        return this.__m_MaxOutgoingMessageSize;
    }

    protected Protocol.MessageFactory getMessageFactory() {
        com.tangosol.net.messaging.Protocol protocol = this.getProtocol();
        return protocol.getMessageFactory(protocol.getCurrentVersion());
    }

    @Override
    public String getName() {
        return this.getServiceName();
    }

    public com.tangosol.net.Service getParentService() {
        return this.__m_ParentService;
    }

    public long getPingInterval() {
        return this.__m_PingInterval;
    }

    public long getPingLastCheckMillis() {
        return this.__m_PingLastCheckMillis;
    }

    public long getPingLastMillis() {
        return this.__m_PingLastMillis;
    }

    public long getPingNextCheckMillis() {
        long ldtLast = this.getPingLastMillis();
        long cMillis = this.getPingTimeout();
        return cMillis == 0L || ldtLast == 0L || this.getPingLastCheckMillis() > 0L ? Long.MAX_VALUE : ldtLast + cMillis;
    }

    public long getPingNextMillis() {
        long ldtLast = this.getPingLastMillis();
        long cMillis = this.getPingInterval();
        return cMillis == 0L ? Long.MAX_VALUE : (ldtLast == 0L ? Base.getSafeTimeMillis() : ldtLast + cMillis);
    }

    public long getPingTimeout() {
        return this.__m_PingTimeout;
    }

    public static UUID getProcessId() {
        return __s_ProcessId;
    }

    @Override
    public com.tangosol.net.messaging.Protocol getProtocol() {
        com.tangosol.net.messaging.Protocol protocol = this.__m_Protocol;
        if (protocol == null) {
            protocol = (com.tangosol.net.messaging.Protocol)((Object)this._findChild("Protocol"));
            this.setProtocol(protocol);
        }
        return protocol;
    }

    @Override
    public com.tangosol.net.messaging.Protocol getProtocol(String sName) {
        return (com.tangosol.net.messaging.Protocol)this.getProtocolMap().get(sName);
    }

    public Map getProtocolMap() {
        return this.__m_ProtocolMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getProtocols() {
        Map map;
        Map map2 = map = this.getProtocolMap();
        synchronized (map2) {
            return new HashMap(map);
        }
    }

    public Map getProtocolVersionMap() {
        return this.__m_ProtocolVersionMap;
    }

    @Override
    public Channel.Receiver getReceiver(String sName) {
        return (Channel.Receiver)this.getReceiverMap().get(sName);
    }

    public Map getReceiverMap() {
        return this.__m_ReceiverMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getReceivers() {
        Map map;
        Map map2 = map = this.getReceiverMap();
        synchronized (map2) {
            return new HashMap(map);
        }
    }

    public long getRequestTimeout() {
        return this.__m_RequestTimeout;
    }

    public long getStatsBytesReceived() {
        return this.__m_StatsBytesReceived;
    }

    public long getStatsBytesSent() {
        return this.__m_StatsBytesSent;
    }

    public long getStatsSent() {
        return this.__m_StatsSent;
    }

    public long getStatsTimeoutCount() {
        return this.__m_StatsTimeoutCount;
    }

    @Override
    public long getWaitMillis() {
        long ldtNow;
        long cMillis = super.getWaitMillis();
        if (this.getPingInterval() > 0L) {
            ldtNow = Base.getLastSafeTimeMillis();
            long ldtNext = Math.min(this.getPingNextMillis(), this.getPingNextCheckMillis());
            long cNext = ldtNext > ldtNow ? ldtNext - ldtNow : -1L;
            long l = cMillis = cMillis == 0L ? cNext : Math.min(cNext, cMillis);
        }
        if (this.isGuardian()) {
            ldtNow = Base.getLastSafeTimeMillis();
            long cGuardMillis = Math.max(1L, this.getGuardSupport().getNextCheckTime() - ldtNow);
            cMillis = cMillis == 0L ? cGuardMillis : Math.min(cMillis, cGuardMillis);
        } else if (this.isGuarded()) {
            cMillis = cMillis == 0L ? 1000L : Math.min(cMillis, 1000L);
        }
        return cMillis;
    }

    public List getWrapperStreamFactoryList() {
        return this.__m_WrapperStreamFactoryList;
    }

    @Override
    public Guardian.GuardContext guard(Guardable guardable) {
        com.tangosol.net.Service service = this.getParentService();
        if (service instanceof Guardian) {
            return ((Guardian)((Object)service)).guard(guardable);
        }
        return super.guard(guardable);
    }

    @Override
    public Guardian.GuardContext guard(Guardable guardable, long cMillis, float flPctRecover) {
        com.tangosol.net.Service service = this.getParentService();
        if (service instanceof Guardian) {
            return ((Guardian)((Object)service)).guard(guardable, cMillis, flPctRecover);
        }
        return super.guard(guardable, cMillis, flPctRecover);
    }

    protected com.tangosol.coherence.component.net.extend.Connection instantiateConnection() {
        return null;
    }

    public static boolean isDEBUG() {
        return __s_DEBUG;
    }

    @Override
    public void onChannelClosed(com.tangosol.net.messaging.Channel channel) {
        if (channel.getId() != 0 && Peer._isTraceEnabled(6)) {
            Peer._trace("Closed: " + String.valueOf(channel), 6);
        }
    }

    public void onChannelOpened(Channel channel) {
        if (channel.getId() != 0 && Peer._isTraceEnabled(6)) {
            Peer._trace("Opened: " + String.valueOf(channel), 6);
        }
    }

    public void onConnectionClosed(com.tangosol.coherence.component.net.extend.Connection connection) {
        if (this.get_Connection() == connection) {
            return;
        }
        this.dispatchConnectionEvent(connection, 2, null);
        if (Peer._isTraceEnabled(6)) {
            Peer._trace("Closed: " + String.valueOf(connection), 6);
        }
    }

    public void onConnectionError(com.tangosol.coherence.component.net.extend.Connection connection, Throwable e) {
        if (this.get_Connection() == connection) {
            return;
        }
        this.dispatchConnectionEvent(connection, 3, e);
        Peer._trace("Closed: " + String.valueOf(connection) + " due to: " + String.valueOf(e), 6);
    }

    public void onConnectionOpened(com.tangosol.coherence.component.net.extend.Connection connection) {
        if (this.get_Connection() == connection) {
            return;
        }
        this.dispatchConnectionEvent(connection, 1, null);
        if (Peer._isTraceEnabled(6)) {
            Peer._trace("Opened: " + String.valueOf(connection), 6);
        }
    }

    @Override
    protected void onDependencies(ServiceDependencies deps) {
        super.onDependencies(deps);
        PeerDependencies peerDeps = (PeerDependencies)deps;
        this.setWrapperStreamFactoryList(peerDeps.getFilterList());
        this.setCodec(peerDeps.getMessageCodec());
        this.setPingInterval(peerDeps.getPingIntervalMillis());
        this.setPingTimeout(peerDeps.getPingTimeoutMillis());
        this.setRequestTimeout(peerDeps.getRequestTimeoutMillis());
        this.setMaxIncomingMessageSize(peerDeps.getMaxIncomingMessageSize());
        this.setMaxOutgoingMessageSize(peerDeps.getMaxOutgoingMessageSize());
    }

    @Override
    protected void onEnter() {
        this.get_Connection().openInternal();
        this.setStartTimestamp(Base.getSafeTimeMillis());
        this.resetStats();
        this.setServiceState(1);
        Channel channel = this.get_Channel();
        channel.send(channel.createMessage(-6));
    }

    @Override
    protected void onExit() {
        super.onExit();
        this.get_Connection().closeInternal(false, null, -1L);
    }

    @Override
    public void onInit() {
        if (Peer.getLicenseError() != null) {
            throw new LicenseException("cannot instantiate " + this.get_Name() + ": " + Peer.getLicenseError());
        }
        com.tangosol.net.messaging.Protocol protocol = this.getProtocol();
        this.registerProtocol(protocol);
        com.tangosol.coherence.component.net.extend.Connection connection = new com.tangosol.coherence.component.net.extend.Connection();
        connection.setConnectionManager(this);
        connection.setId(Peer.getProcessId());
        connection.setMessageFactoryMap(Collections.singletonMap(protocol.getName(), protocol.getMessageFactory(protocol.getCurrentVersion())));
        Channel channel = (Channel)connection.getChannel(0);
        channel.setReceiver(this);
        this.set_Channel(channel);
        this.set_Connection(connection);
        super.onInit();
    }

    @Override
    public void onMessage(Message message) {
        message.run();
    }

    protected void onMessageDecodeException(Throwable e, ReadBuffer.BufferInput in, com.tangosol.coherence.component.net.extend.Connection connection, boolean fFilter) {
        Channel channel;
        try {
            if (fFilter) {
                in = this.filterBufferInput(in);
            }
            channel = (Channel)connection.getChannel(in.readPackedInt());
        }
        catch (IOException ee) {
            channel = null;
        }
        StringBuffer sb = new StringBuffer("An exception occurred while decoding a Message for Service \"").append(this.getServiceName()).append("\" received from: ").append(connection).append('.');
        if (channel != null) {
            sb.append(" This service is configured with a serializer: ").append(channel.getSerializer()).append(", which may be incompatible with the serializer configured by the connecting client.");
        }
        Peer._trace(e, sb.toString());
        if (channel == null || !channel.isOpen() || channel.getId() == 0) {
            connection.close(true, e, false);
        } else {
            channel.close(true, e);
        }
    }

    protected void onMessageEncodeException(Throwable e, Message message) {
        Peer._trace(e, "An exception occurred while encoding a " + ClassHelper.getSimpleName(message.getClass()) + " for Service=" + this.getServiceName());
        Channel channel = (Channel)message.getChannel();
        if (!channel.isOpen() || channel.getId() == 0) {
            com.tangosol.coherence.component.net.extend.Connection connection = (com.tangosol.coherence.component.net.extend.Connection)channel.getConnection();
            connection.setCloseOnExit(true);
            connection.setCloseNotify(true);
            connection.setCloseThrowable(e);
        } else {
            channel.setCloseOnExit(true);
            channel.setCloseNotify(true);
            channel.setCloseThrowable(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onNotify() {
        long ldtNow;
        long ldtStart = Base.getSafeTimeMillis();
        long cMessage = this.getStatsReceived();
        long cbReceive = this.getStatsBytesReceived();
        com.tangosol.coherence.component.util.DaemonPool pool = this.getDaemonPool();
        while (!this.isExiting()) {
            com.tangosol.coherence.component.net.extend.Connection connection;
            Channel channel;
            Message message;
            if ((cMessage & 0x1FFL) == 511L) {
                this.heartbeat();
            }
            if ((message = (Message)this.getQueue().removeNoWait()) == null) break;
            ++cMessage;
            if (message instanceof MessageFactory.EncodedMessage) {
                MessageFactory.EncodedMessage messageImpl = (MessageFactory.EncodedMessage)message;
                ReadBuffer rb = messageImpl.getReadBuffer();
                if (rb == null || rb.length() == 0) continue;
                int cb = rb.length();
                com.tangosol.coherence.component.net.extend.Connection connection2 = messageImpl.getConnection();
                connection2.setStatsBytesReceived(connection2.getStatsBytesReceived() + (long)cb);
                cbReceive += (long)cb;
                try {
                    message = this.decodeMessage(rb.getBufferInput(), connection2, true);
                }
                catch (Throwable e) {
                    this.onMessageDecodeException(e, rb.getBufferInput(), connection2, true);
                    continue;
                }
                finally {
                    this.releaseReadBuffer(rb);
                    continue;
                }
                if (message == null) continue;
                if ((Peer.isDEBUG() || connection2.isMessagingDebug()) && Peer._isTraceEnabled(6)) {
                    Peer._trace("Received: " + String.valueOf(message), 6);
                }
            }
            if ((channel = (Channel)message.getChannel()) == null || !channel.isOpen() || (connection = (com.tangosol.coherence.component.net.extend.Connection)channel.getConnection()) == null || !connection.isOpen()) continue;
            connection.setStatsReceived(connection.getStatsReceived() + 1L);
            if (this == channel.getReceiver() || !pool.isStarted() || message.isExecuteInOrder()) {
                channel.receive(message);
                continue;
            }
            pool.add(message);
        }
        if ((ldtNow = Base.getSafeTimeMillis()) >= this.getPingNextCheckMillis()) {
            this.checkPingTimeouts();
            this.setPingLastCheckMillis(ldtNow);
        }
        if (ldtNow >= this.getPingNextMillis()) {
            this.ping();
            this.setPingLastCheckMillis(0L);
            this.setPingLastMillis(ldtNow);
        }
        this.setStatsReceived(cMessage);
        this.setStatsBytesReceived(cbReceive);
        this.setStatsCpu(this.getStatsCpu() + (ldtNow - ldtStart));
        super.onNotify();
    }

    @Override
    public void onServiceStarted() {
        com.tangosol.coherence.component.util.DaemonPool pool = this.getDaemonPool();
        if (pool.getDaemonCount() > 0) {
            pool.setThreadGroup(new ThreadGroup(this.getServiceName()));
            pool.start();
        }
        this.setAcceptingClients(true);
        Peer._trace("Started: " + String.valueOf(this), 6);
    }

    @Override
    protected void onServiceStarting() {
        super.onServiceStarting();
        if (this.getCodec() == null) {
            this.setCodec(new Codec());
        }
        HashMap<String, Integer[]> map = new HashMap<String, Integer[]>();
        for (com.tangosol.net.messaging.Protocol protocol : this.getProtocolMap().values()) {
            String sName = protocol.getName();
            int nVersionCurrent = protocol.getCurrentVersion();
            int nVersionSupport = protocol.getSupportedVersion();
            if (sName == null) {
                throw new IllegalArgumentException("protocol has no name: " + String.valueOf(protocol));
            }
            map.put(sName, new Integer[]{nVersionCurrent, nVersionSupport});
        }
        this.setProtocolVersionMap(Collections.unmodifiableMap(map));
    }

    @Override
    protected void onServiceStopped() {
        super.onServiceStopped();
        Peer._trace("Stopped: " + String.valueOf(this), 6);
    }

    public com.tangosol.net.messaging.Channel openChannel(com.tangosol.coherence.component.net.extend.Connection connection, com.tangosol.net.messaging.Protocol protocol, String sName, ClassLoader loader, Channel.Receiver receiver, Subject subject) {
        Peer._assert(connection != null);
        Channel channel0 = this.get_Channel();
        Protocol.MessageFactory factory0 = channel0.getMessageFactory();
        MessageFactory.OpenChannel request = (MessageFactory.OpenChannel)factory0.createMessage(-7);
        request.setClassLoader(loader);
        request.setConnection(connection);
        request.setIdentityToken(this.serializeIdentityToken(this.generateIdentityToken(subject)));
        request.setProtocol(protocol);
        request.setReceiver(receiver);
        request.setReceiverName(sName);
        request.setSubject(subject);
        Request.Status status = (Request.Status)channel0.request(request);
        MessageFactory.OpenChannelResponse response = (MessageFactory.OpenChannelResponse)status.waitForResponse(this.getRequestTimeout());
        return (Channel)response.getResult();
    }

    public void openConnection(com.tangosol.coherence.component.net.extend.Connection connection) {
        Peer._assert(connection != null);
        Channel channel0 = this.get_Channel();
        Protocol.MessageFactory factory0 = channel0.getMessageFactory();
        MessageFactory.OpenConnection request = (MessageFactory.OpenConnection)factory0.createMessage(-8);
        request.setConnectionOpen(connection);
        Request.Status status = (Request.Status)channel0.request(request);
        if (status != null) {
            try {
                status.waitForResponse(this.getRequestTimeout());
            }
            catch (RequestTimeoutException e) {
                connection.close(false, e);
                throw e;
            }
        }
    }

    protected static long parseMemorySize(XmlElement xml, String sName, long cbDefault) {
        if (xml == null) {
            return cbDefault;
        }
        String sBytes = xml.getSafeElement(sName).getString();
        if (sBytes.length() == 0) {
            return cbDefault;
        }
        try {
            return Base.parseMemorySize(sBytes);
        }
        catch (RuntimeException e) {
            throw Base.ensureRuntimeException(e, "illegal \"" + sName + "\" value: " + sBytes);
        }
    }

    protected void ping() {
    }

    public void post(Message message) {
        Peer._assert(message != null);
        com.tangosol.net.messaging.Channel channel = message.getChannel();
        Peer._assert(channel != null);
        if (this == channel.getReceiver() && message.getTypeId() < 0) {
            this.getQueue().add(message);
        } else {
            this.send(message);
        }
    }

    public void receive(ReadBuffer rb, com.tangosol.coherence.component.net.extend.Connection connection) {
        Peer._assert(rb != null);
        Peer._assert(connection != null);
        Channel channel0 = this.get_Channel();
        if (channel0 == null) {
            return;
        }
        Protocol.MessageFactory factory0 = channel0.getMessageFactory();
        if (factory0 == null) {
            return;
        }
        MessageFactory.EncodedMessage message = (MessageFactory.EncodedMessage)factory0.createMessage(-10);
        message.setChannel(channel0);
        message.setConnection(connection);
        message.setReadBuffer(rb);
        this.post(message);
    }

    @Override
    public void registerChannel(com.tangosol.net.messaging.Channel channel) {
    }

    @Override
    public void registerProtocol(com.tangosol.net.messaging.Protocol protocol) {
        if (this.getServiceState() > 0) {
            throw new IllegalStateException();
        }
        if (protocol == null) {
            throw new IllegalArgumentException("protocol cannot be null");
        }
        String sName = protocol.getName();
        if (sName == null) {
            throw new IllegalArgumentException("missing protocol name: " + String.valueOf(protocol));
        }
        this.getProtocolMap().put(sName, protocol);
    }

    @Override
    public void registerReceiver(Channel.Receiver receiver) {
        if (this.getServiceState() > 0) {
            throw new IllegalStateException();
        }
        if (receiver == null) {
            throw new IllegalArgumentException("receiver cannot be null");
        }
        String sName = receiver.getName();
        if (sName == null) {
            throw new IllegalArgumentException("missing receiver name: " + String.valueOf(receiver));
        }
        this.getReceiverMap().put(sName, receiver);
    }

    protected void releaseReadBuffer(ReadBuffer rb) {
    }

    protected void releaseWriteBuffer(WriteBuffer wb, Throwable e) {
    }

    @Override
    public void removeConnectionListener(ConnectionListener l) {
        this.getConnectionListeners().remove(l);
    }

    @Override
    public void resetStats() {
        this.setStatsBytesReceived(0L);
        this.setStatsBytesSent(0L);
        this.setStatsSent(0L);
        this.setStatsTimeoutCount(0L);
        super.resetStats();
    }

    protected void send(Message message) {
        Channel channel = (Channel)message.getChannel();
        Peer._assert(channel != null);
        Peer._assert(channel.isActiveThread());
        com.tangosol.coherence.component.net.extend.Connection connection = (com.tangosol.coherence.component.net.extend.Connection)channel.getConnection();
        boolean fMsgDebug = (Peer.isDEBUG() || connection.isMessagingDebug()) && Peer._isTraceEnabled(6);
        String sDebugMsg = null;
        if (fMsgDebug) {
            sDebugMsg = message.toString();
        }
        WriteBuffer wb = this.allocateWriteBuffer();
        try {
            this.encodeMessage(message, wb.getBufferOutput(), true);
            this.enforceMaxOutgoingMessageSize(wb.length());
        }
        catch (Throwable e) {
            this.releaseWriteBuffer(wb, e);
            this.onMessageEncodeException(e, message);
            throw Base.ensureRuntimeException(e);
        }
        try {
            connection.send(wb);
            this.releaseWriteBuffer(wb, null);
        }
        catch (RequestTimeoutException e) {
            this.releaseWriteBuffer(wb, e);
            throw e;
        }
        catch (Throwable e) {
            this.releaseWriteBuffer(wb, e);
            connection.setCloseOnExit(true);
            connection.setCloseNotify(false);
            connection.setCloseThrowable(e);
            throw Base.ensureRuntimeException(e);
        }
        this.setStatsSent(this.getStatsSent() + 1L);
        this.setStatsBytesSent(this.getStatsBytesSent() + (long)wb.length());
        if (fMsgDebug) {
            Peer._trace("Sent: " + sDebugMsg, 6);
        }
    }

    public byte[] serializeIdentityToken(Object oToken) {
        if (oToken != null) {
            try {
                ByteArrayWriteBuffer buf = new ByteArrayWriteBuffer(1024);
                this.ensureSerializer().serialize(buf.getBufferOutput(), oToken);
                return buf.toByteArray();
            }
            catch (Exception e) {
                Peer._trace(e, "An exception occurred while serializing an identity token");
                throw new SecurityException("unable to produce identity token");
            }
        }
        return null;
    }

    protected void set_Channel(Channel channel) {
        this.__m__Channel = channel;
    }

    protected void set_Connection(com.tangosol.coherence.component.net.extend.Connection channel) {
        this.__m__Connection = channel;
    }

    @Override
    public void setCodec(com.tangosol.net.messaging.Codec codec) {
        this.__m_Codec = codec;
    }

    private void setConnectionListeners(Listeners listeners) {
        this.__m_ConnectionListeners = listeners;
    }

    public static void setDEBUG(boolean fDEBUG) {
        __s_DEBUG = fDEBUG;
    }

    protected static void setLicenseError(String sMsg) {
        __s_LicenseError = sMsg;
    }

    protected void setMaxIncomingMessageSize(int cbSize) {
        this.__m_MaxIncomingMessageSize = cbSize;
    }

    protected void setMaxOutgoingMessageSize(int cbSize) {
        this.__m_MaxOutgoingMessageSize = cbSize;
    }

    public void setParentService(com.tangosol.net.Service service) {
        this.__m_ParentService = service;
    }

    protected void setPingInterval(long cMillis) {
        this.__m_PingInterval = cMillis;
    }

    protected void setPingLastCheckMillis(long ldt) {
        this.__m_PingLastCheckMillis = ldt;
    }

    protected void setPingLastMillis(long ldt) {
        this.__m_PingLastMillis = ldt;
    }

    protected void setPingTimeout(long cMillis) {
        this.__m_PingTimeout = cMillis;
    }

    protected static void setProcessId(UUID uuid) {
        Peer._assert(uuid != null);
        __s_ProcessId = uuid;
    }

    protected void setProtocol(com.tangosol.net.messaging.Protocol protocol) {
        this.__m_Protocol = protocol;
    }

    protected void setProtocolMap(Map map) {
        this.__m_ProtocolMap = map;
    }

    protected void setProtocolVersionMap(Map map) {
        this.__m_ProtocolVersionMap = map;
    }

    protected void setReceiverMap(Map map) {
        this.__m_ReceiverMap = map;
    }

    protected void setRequestTimeout(long cMillis) {
        this.__m_RequestTimeout = cMillis;
    }

    protected void setStatsBytesReceived(long cb) {
        this.__m_StatsBytesReceived = cb;
    }

    protected void setStatsBytesSent(long cb) {
        this.__m_StatsBytesSent = cb;
    }

    protected void setStatsSent(long pStatsSent) {
        this.__m_StatsSent = pStatsSent;
    }

    protected void setStatsTimeoutCount(long cRequests) {
        this.__m_StatsTimeoutCount = cRequests;
    }

    public void setWrapperStreamFactoryList(List list) {
        this.__m_WrapperStreamFactoryList = list;
    }

    @Override
    public synchronized void shutdown() {
        Thread thread;
        if (this.isStarted() && this.getServiceState() < 3) {
            Channel channel = this.get_Channel();
            channel.send(channel.createMessage(-5));
        }
        if ((thread = this.getThread()) != Thread.currentThread()) {
            while (this.isStarted() && this.getServiceState() < 4) {
                try {
                    Blocking.wait(this);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new WrapperException(e);
                }
            }
            if (this.getServiceState() != 4) {
                this.stop();
            }
        }
    }

    @Override
    public void unregisterChannel(com.tangosol.net.messaging.Channel channel) {
    }

    static {
        Peer._initStatic$Default();
        Peer.setDEBUG(Config.getBoolean("coherence.messaging.debug"));
        Peer.setProcessId(new UUID());
    }

    public static class DispatchEvent
    extends Service.DispatchEvent {
        public DispatchEvent() {
            this(null, null, true);
        }

        public DispatchEvent(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new DispatchEvent();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$DispatchEvent".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void run() {
            EventObject evt = this.getEvent();
            if (evt instanceof ConnectionEvent) {
                ((ConnectionEvent)evt).dispatch(this.getListeners());
            } else {
                super.run();
            }
        }
    }

    public static abstract class MessageFactory
    extends com.tangosol.coherence.component.net.extend.MessageFactory {
        public static final int MESSAGE_OFFSET = 32;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("AcceptChannel", AcceptChannel.get_CLASS());
            __mapChildren.put("AcceptChannelRequest", AcceptChannelRequest.get_CLASS());
            __mapChildren.put("AcceptChannelResponse", AcceptChannelResponse.get_CLASS());
            __mapChildren.put("CloseChannel", CloseChannel.get_CLASS());
            __mapChildren.put("CloseConnection", CloseConnection.get_CLASS());
            __mapChildren.put("CreateChannel", CreateChannel.get_CLASS());
            __mapChildren.put("EncodedMessage", EncodedMessage.get_CLASS());
            __mapChildren.put("NotifyChannelClosed", NotifyChannelClosed.get_CLASS());
            __mapChildren.put("NotifyConnectionClosed", NotifyConnectionClosed.get_CLASS());
            __mapChildren.put("NotifyShutdown", NotifyShutdown.get_CLASS());
            __mapChildren.put("NotifyStartup", NotifyStartup.get_CLASS());
            __mapChildren.put("OpenChannel", OpenChannel.get_CLASS());
            __mapChildren.put("OpenChannelRequest", OpenChannelRequest.get_CLASS());
            __mapChildren.put("OpenChannelResponse", OpenChannelResponse.get_CLASS());
            __mapChildren.put("OpenConnection", OpenConnection.get_CLASS());
            __mapChildren.put("OpenConnectionRequest", OpenConnectionRequest.get_CLASS());
            __mapChildren.put("OpenConnectionResponse", OpenConnectionResponse.get_CLASS());
            __mapChildren.put("PingRequest", PingRequest.get_CLASS());
            __mapChildren.put("PingResponse", PingResponse.get_CLASS());
            __mapChildren.put("Response", Response.get_CLASS());
        }

        public MessageFactory(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        protected Class getMessageClass(int i) {
            return super.getMessageClass(i + 32);
        }

        @Override
        protected void setMessageClass(int i, Class clz) {
            super.setMessageClass(i + 32, clz);
        }

        static {
            MessageFactory.__initStatic();
        }

        public static class AcceptChannel
        extends Request {
            private URI __m_ChannelUri;
            private transient ClassLoader __m_ClassLoader;
            private transient com.tangosol.coherence.component.net.extend.Connection __m_Connection;
            private byte[] __m_IdentityToken;
            private transient Channel.Receiver __m_Receiver;
            private transient Subject __m_Subject;
            public static final int TYPE_ID = -1;
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Status", Status.get_CLASS());
            }

            public AcceptChannel() {
                this(null, null, true);
            }

            public AcceptChannel(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new AcceptChannel();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$AcceptChannel".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            public URI getChannelUri() {
                return this.__m_ChannelUri;
            }

            public ClassLoader getClassLoader() {
                return this.__m_ClassLoader;
            }

            public com.tangosol.coherence.component.net.extend.Connection getConnection() {
                return this.__m_Connection;
            }

            public byte[] getIdentityToken() {
                return this.__m_IdentityToken;
            }

            public Channel.Receiver getReceiver() {
                return this.__m_Receiver;
            }

            public Subject getSubject() {
                return this.__m_Subject;
            }

            @Override
            public int getTypeId() {
                return -1;
            }

            @Override
            protected com.tangosol.coherence.component.net.extend.message.Response instantiateResponse(Protocol.MessageFactory factory) {
                return (Response)factory.createMessage(-9);
            }

            @Override
            protected void onRun(com.tangosol.coherence.component.net.extend.message.Response response) {
                com.tangosol.coherence.component.net.extend.Connection connection = this.getConnection();
                AcceptChannel._assert(connection != null);
                com.tangosol.net.messaging.Channel channel0 = this.getChannel();
                Subject subject = this.getSubject();
                Peer module = (Peer)channel0.getReceiver();
                response.setResult(connection.acceptChannelInternal(this.getChannelUri(), module.ensureSerializer(this.getClassLoader()), this.getReceiver(), subject, this.getIdentityToken()));
            }

            public void setChannelUri(URI uri) {
                this.__m_ChannelUri = uri;
            }

            public void setClassLoader(ClassLoader loader) {
                this.__m_ClassLoader = loader;
            }

            public void setConnection(com.tangosol.coherence.component.net.extend.Connection connection) {
                this.__m_Connection = connection;
            }

            public void setIdentityToken(byte[] abToken) {
                this.__m_IdentityToken = abToken;
            }

            public void setReceiver(Channel.Receiver receiver) {
                this.__m_Receiver = receiver;
            }

            public void setSubject(Subject subject) {
                this.__m_Subject = subject;
            }

            static {
                AcceptChannel.__initStatic();
            }

            public static class Status
            extends Request.Status {
                public Status() {
                    this(null, null, true);
                }

                public Status(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Status();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$AcceptChannel$Status".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class AcceptChannelRequest
        extends Request {
            private int __m_ChannelId;
            private byte[] __m_IdentityToken;
            private transient Protocol.MessageFactory __m_MessageFactory;
            private transient String __m_ProtocolName;
            private transient Channel.Receiver __m_Receiver;
            private transient Serializer __m_Serializer;
            private transient Subject __m_Subject;
            public static final int TYPE_ID = 13;
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Status", Status.get_CLASS());
            }

            public AcceptChannelRequest() {
                this(null, null, true);
            }

            public AcceptChannelRequest(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new AcceptChannelRequest();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$AcceptChannelRequest".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            public int getChannelId() {
                return this.__m_ChannelId;
            }

            @Override
            protected String getDescription() {
                return super.getDescription() + ", ChannelId=" + this.getChannelId();
            }

            public byte[] getIdentityToken() {
                return this.__m_IdentityToken;
            }

            public Protocol.MessageFactory getMessageFactory() {
                return this.__m_MessageFactory;
            }

            public String getProtocolName() {
                return this.__m_ProtocolName;
            }

            public Channel.Receiver getReceiver() {
                return this.__m_Receiver;
            }

            public Serializer getSerializer() {
                return this.__m_Serializer;
            }

            public Subject getSubject() {
                return this.__m_Subject;
            }

            @Override
            public int getTypeId() {
                return 13;
            }

            @Override
            protected com.tangosol.coherence.component.net.extend.message.Response instantiateResponse(Protocol.MessageFactory factory) {
                return (AcceptChannelResponse)factory.createMessage(14);
            }

            @Override
            protected void onRun(com.tangosol.coherence.component.net.extend.message.Response response) {
                com.tangosol.net.messaging.Channel channel0 = this.getChannel();
                AcceptChannelRequest._assert(channel0.getId() == 0);
                com.tangosol.coherence.component.net.extend.Connection connection = (com.tangosol.coherence.component.net.extend.Connection)channel0.getConnection();
                AcceptChannelRequest._assert(connection != null);
                Peer module = (Peer)channel0.getReceiver();
                int nId = this.getChannelId();
                connection.acceptChannelRequest(nId, module.assertIdentityToken(module.deserializeIdentityToken(this.getIdentityToken())), module.getAccessAdapter());
                Protocol.MessageFactory clientFactory = (Protocol.MessageFactory)connection.getMessageFactoryMap().get(channel0.getMessageFactory().getProtocol().getName());
                if (clientFactory != null && clientFactory.getVersion() >= 3) {
                    response.setResult(nId);
                }
            }

            @Override
            public void readExternal(PofReader in) throws IOException {
                super.readExternal(in);
                this.setChannelId(in.readInt(1));
                this.setIdentityToken(in.readByteArray(2));
            }

            public void setChannelId(int nId) {
                this.__m_ChannelId = nId;
            }

            public void setIdentityToken(byte[] ab) {
                this.__m_IdentityToken = ab;
            }

            public void setMessageFactory(Protocol.MessageFactory factory) {
                this.__m_MessageFactory = factory;
            }

            public void setProtocolName(String sName) {
                this.__m_ProtocolName = sName;
            }

            public void setReceiver(Channel.Receiver receiver) {
                this.__m_Receiver = receiver;
            }

            public void setSerializer(Serializer serializer) {
                this.__m_Serializer = serializer;
            }

            public void setSubject(Subject subject) {
                this.__m_Subject = subject;
            }

            @Override
            public void writeExternal(PofWriter out) throws IOException {
                super.writeExternal(out);
                out.writeInt(1, this.getChannelId());
                out.writeByteArray(2, this.getIdentityToken());
            }

            static {
                AcceptChannelRequest.__initStatic();
            }

            public static class Status
            extends Request.Status {
                public Status() {
                    this(null, null, true);
                }

                public Status(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Status();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$AcceptChannelRequest$Status".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class AcceptChannelResponse
        extends com.tangosol.coherence.component.net.extend.message.Response {
            public static final int TYPE_ID = 14;

            public AcceptChannelResponse() {
                this(null, null, true);
            }

            public AcceptChannelResponse(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new AcceptChannelResponse();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$AcceptChannelResponse".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public int getTypeId() {
                return 14;
            }

            @Override
            public void run() {
                Channel channel0 = (Channel)this.getChannel();
                AcceptChannelResponse._assert(channel0.getId() == 0);
                if (this.isFailure()) {
                    return;
                }
                AcceptChannelRequest request = (AcceptChannelRequest)channel0.getRequest(this.getRequestId());
                if (request == null) {
                    Integer nId = (Integer)this.getResult();
                    if (nId != null) {
                        NotifyChannelClosed message = (NotifyChannelClosed)channel0.getMessageFactory().createMessage(20);
                        message.setChannelId(nId);
                        channel0.send(message);
                    }
                } else {
                    com.tangosol.coherence.component.net.extend.Connection connection = (com.tangosol.coherence.component.net.extend.Connection)channel0.getConnection();
                    int nId = request.getChannelId();
                    Protocol.MessageFactory factory = request.getMessageFactory();
                    Channel.Receiver receiver = request.getReceiver();
                    Serializer serializer = request.getSerializer();
                    Subject subject = request.getSubject();
                    this.setResult(connection.acceptChannelResponse(nId, factory, serializer, receiver, subject));
                }
            }
        }

        public static class CloseChannel
        extends Request {
            private transient Throwable __m_Cause;
            private transient Channel __m_ChannelClose;
            private transient boolean __m_Notify;
            public static final int TYPE_ID = -2;
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Status", Status.get_CLASS());
            }

            public CloseChannel() {
                this(null, null, true);
            }

            public CloseChannel(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new CloseChannel();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$CloseChannel".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            public Throwable getCause() {
                return this.__m_Cause;
            }

            public Channel getChannelClose() {
                return this.__m_ChannelClose;
            }

            @Override
            public int getTypeId() {
                return -2;
            }

            @Override
            protected com.tangosol.coherence.component.net.extend.message.Response instantiateResponse(Protocol.MessageFactory factory) {
                return (Response)factory.createMessage(-9);
            }

            public boolean isNotify() {
                return this.__m_Notify;
            }

            @Override
            protected void onRun(com.tangosol.coherence.component.net.extend.message.Response response) {
                this.getChannelClose().closeInternal(this.isNotify(), this.getCause(), 0L);
            }

            public void setCause(Throwable e) {
                this.__m_Cause = e;
            }

            public void setChannelClose(Channel channel) {
                this.__m_ChannelClose = channel;
            }

            public void setNotify(boolean fNotify) {
                this.__m_Notify = fNotify;
            }

            static {
                CloseChannel.__initStatic();
            }

            public static class Status
            extends Request.Status {
                public Status() {
                    this(null, null, true);
                }

                public Status(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Status();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$CloseChannel$Status".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class CloseConnection
        extends Request {
            private transient Throwable __m_Cause;
            private transient com.tangosol.coherence.component.net.extend.Connection __m_ConnectionClose;
            private transient boolean __m_Notify;
            public static final int TYPE_ID = -3;
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Status", Status.get_CLASS());
            }

            public CloseConnection() {
                this(null, null, true);
            }

            public CloseConnection(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new CloseConnection();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$CloseConnection".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            public Throwable getCause() {
                return this.__m_Cause;
            }

            public com.tangosol.coherence.component.net.extend.Connection getConnectionClose() {
                return this.__m_ConnectionClose;
            }

            @Override
            public int getTypeId() {
                return -3;
            }

            @Override
            protected com.tangosol.coherence.component.net.extend.message.Response instantiateResponse(Protocol.MessageFactory factory) {
                return (Response)factory.createMessage(-9);
            }

            public boolean isNotify() {
                return this.__m_Notify;
            }

            @Override
            protected void onRun(com.tangosol.coherence.component.net.extend.message.Response response) {
                this.getConnectionClose().closeInternal(this.isNotify(), this.getCause(), 0L);
            }

            public void setCause(Throwable e) {
                this.__m_Cause = e;
            }

            public void setConnectionClose(com.tangosol.coherence.component.net.extend.Connection connection) {
                this.__m_ConnectionClose = connection;
            }

            public void setNotify(boolean fNotify) {
                this.__m_Notify = fNotify;
            }

            static {
                CloseConnection.__initStatic();
            }

            public static class Status
            extends Request.Status {
                public Status() {
                    this(null, null, true);
                }

                public Status(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Status();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$CloseConnection$Status".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class CreateChannel
        extends Request {
            private transient ClassLoader __m_ClassLoader;
            private transient com.tangosol.coherence.component.net.extend.Connection __m_Connection;
            private transient com.tangosol.net.messaging.Protocol __m_Protocol;
            private transient Channel.Receiver __m_Receiver;
            public static final int TYPE_ID = -4;
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Status", Status.get_CLASS());
            }

            public CreateChannel() {
                this(null, null, true);
            }

            public CreateChannel(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new CreateChannel();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$CreateChannel".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            public ClassLoader getClassLoader() {
                return this.__m_ClassLoader;
            }

            public com.tangosol.coherence.component.net.extend.Connection getConnection() {
                return this.__m_Connection;
            }

            public com.tangosol.net.messaging.Protocol getProtocol() {
                return this.__m_Protocol;
            }

            public Channel.Receiver getReceiver() {
                return this.__m_Receiver;
            }

            @Override
            public int getTypeId() {
                return -4;
            }

            @Override
            protected com.tangosol.coherence.component.net.extend.message.Response instantiateResponse(Protocol.MessageFactory factory) {
                return (Response)factory.createMessage(-9);
            }

            @Override
            protected void onRun(com.tangosol.coherence.component.net.extend.message.Response response) {
                com.tangosol.coherence.component.net.extend.Connection connection = this.getConnection();
                CreateChannel._assert(connection != null);
                com.tangosol.net.messaging.Channel channel0 = this.getChannel();
                Peer module = (Peer)channel0.getReceiver();
                response.setResult(connection.createChannelInternal(this.getProtocol(), module.ensureSerializer(this.getClassLoader()), this.getReceiver()));
            }

            public void setClassLoader(ClassLoader loader) {
                this.__m_ClassLoader = loader;
            }

            public void setConnection(com.tangosol.coherence.component.net.extend.Connection connection) {
                this.__m_Connection = connection;
            }

            public void setProtocol(com.tangosol.net.messaging.Protocol protocol) {
                this.__m_Protocol = protocol;
            }

            public void setReceiver(Channel.Receiver receiver) {
                this.__m_Receiver = receiver;
            }

            static {
                CreateChannel.__initStatic();
            }

            public static class Status
            extends Request.Status {
                public Status() {
                    this(null, null, true);
                }

                public Status(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Status();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$CreateChannel$Status".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class EncodedMessage
        extends com.tangosol.coherence.component.net.extend.Message {
            private com.tangosol.coherence.component.net.extend.Connection __m_Connection;
            private ReadBuffer __m_ReadBuffer;
            public static final int TYPE_ID = -10;

            public EncodedMessage() {
                this(null, null, true);
            }

            public EncodedMessage(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new EncodedMessage();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$EncodedMessage".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public com.tangosol.coherence.component.net.extend.Connection getConnection() {
                return this.__m_Connection;
            }

            public ReadBuffer getReadBuffer() {
                return this.__m_ReadBuffer;
            }

            @Override
            public int getTypeId() {
                return -10;
            }

            @Override
            public void run() {
            }

            public void setConnection(com.tangosol.coherence.component.net.extend.Connection connection) {
                this.__m_Connection = connection;
            }

            public void setReadBuffer(ReadBuffer rb) {
                this.__m_ReadBuffer = rb;
            }
        }

        public static class NotifyChannelClosed
        extends com.tangosol.coherence.component.net.extend.Message {
            private Throwable __m_Cause;
            private transient int __m_ChannelId;
            public static final int TYPE_ID = 20;

            public NotifyChannelClosed() {
                this(null, null, true);
            }

            public NotifyChannelClosed(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyChannelClosed();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$NotifyChannelClosed".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public Throwable getCause() {
                return this.__m_Cause;
            }

            public int getChannelId() {
                return this.__m_ChannelId;
            }

            @Override
            protected String getDescription() {
                return super.getDescription() + ", ChannelId=" + this.getChannelId();
            }

            @Override
            public int getTypeId() {
                return 20;
            }

            @Override
            public void readExternal(PofReader in) throws IOException {
                super.readExternal(in);
                this.setChannelId(in.readInt(0));
                this.setCause((Throwable)in.readObject(1));
            }

            @Override
            public void run() {
                Channel channel0 = (Channel)this.getChannel();
                NotifyChannelClosed._assert(channel0.getId() == 0);
                Connection connection = channel0.getConnection();
                NotifyChannelClosed._assert(connection != null);
                Channel channel = (Channel)connection.getChannel(this.getChannelId());
                if (channel != null) {
                    channel.close(false, this.getCause());
                }
            }

            public void setCause(Throwable e) {
                this.__m_Cause = e;
            }

            public void setChannelId(int nId) {
                this.__m_ChannelId = nId;
            }

            @Override
            public void writeExternal(PofWriter out) throws IOException {
                super.writeExternal(out);
                out.writeInt(0, this.getChannelId());
                out.writeObject(1, this.getCause());
            }
        }

        public static class NotifyConnectionClosed
        extends com.tangosol.coherence.component.net.extend.Message {
            private Throwable __m_Cause;
            public static final int TYPE_ID = 10;

            public NotifyConnectionClosed() {
                this(null, null, true);
            }

            public NotifyConnectionClosed(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyConnectionClosed();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$NotifyConnectionClosed".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public Throwable getCause() {
                return this.__m_Cause;
            }

            @Override
            public int getTypeId() {
                return 10;
            }

            @Override
            public void readExternal(PofReader in) throws IOException {
                super.readExternal(in);
                this.setCause((Throwable)in.readObject(0));
            }

            @Override
            public void run() {
                com.tangosol.net.messaging.Channel channel0 = this.getChannel();
                NotifyConnectionClosed._assert(channel0.getId() == 0);
                com.tangosol.coherence.component.net.extend.Connection connection = (com.tangosol.coherence.component.net.extend.Connection)channel0.getConnection();
                NotifyConnectionClosed._assert(connection != null);
                connection.close(false, this.getCause());
            }

            public void setCause(Throwable e) {
                this.__m_Cause = e;
            }

            @Override
            public void writeExternal(PofWriter out) throws IOException {
                super.writeExternal(out);
                out.writeObject(0, this.getCause());
            }
        }

        public static class NotifyShutdown
        extends com.tangosol.coherence.component.net.extend.Message {
            public static final int TYPE_ID = -5;

            public NotifyShutdown() {
                this(null, null, true);
            }

            public NotifyShutdown(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyShutdown();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$NotifyShutdown".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public int getTypeId() {
                return -5;
            }

            @Override
            public void run() {
                Peer module = (Peer)this.getChannel().getReceiver();
                try {
                    module.setServiceState(3);
                }
                finally {
                    module.stop();
                }
            }
        }

        public static class NotifyStartup
        extends com.tangosol.coherence.component.net.extend.Message {
            public static final int TYPE_ID = -6;

            public NotifyStartup() {
                this(null, null, true);
            }

            public NotifyStartup(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyStartup();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$NotifyStartup".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public int getTypeId() {
                return -6;
            }

            @Override
            public void run() {
                Peer module = (Peer)this.getChannel().getReceiver();
                module.setServiceState(2);
            }
        }

        public static class OpenChannel
        extends Request {
            private transient ClassLoader __m_ClassLoader;
            private transient com.tangosol.coherence.component.net.extend.Connection __m_Connection;
            private byte[] __m_IdentityToken;
            private transient com.tangosol.net.messaging.Protocol __m_Protocol;
            private transient Channel.Receiver __m_Receiver;
            private String __m_ReceiverName;
            private transient Subject __m_Subject;
            public static final int TYPE_ID = -7;
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Status", Status.get_CLASS());
            }

            public OpenChannel() {
                this(null, null, true);
            }

            public OpenChannel(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new OpenChannel();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$OpenChannel".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            public ClassLoader getClassLoader() {
                return this.__m_ClassLoader;
            }

            public com.tangosol.coherence.component.net.extend.Connection getConnection() {
                return this.__m_Connection;
            }

            public byte[] getIdentityToken() {
                return this.__m_IdentityToken;
            }

            public com.tangosol.net.messaging.Protocol getProtocol() {
                return this.__m_Protocol;
            }

            public Channel.Receiver getReceiver() {
                return this.__m_Receiver;
            }

            public String getReceiverName() {
                return this.__m_ReceiverName;
            }

            public Subject getSubject() {
                return this.__m_Subject;
            }

            @Override
            public int getTypeId() {
                return -7;
            }

            @Override
            protected com.tangosol.coherence.component.net.extend.message.Response instantiateResponse(Protocol.MessageFactory factory) {
                return (Response)factory.createMessage(-9);
            }

            @Override
            protected void onRun(com.tangosol.coherence.component.net.extend.message.Response response) {
                com.tangosol.coherence.component.net.extend.Connection connection = this.getConnection();
                OpenChannel._assert(connection != null);
                com.tangosol.net.messaging.Channel channel0 = this.getChannel();
                Peer module = (Peer)channel0.getReceiver();
                response.setResult(connection.openChannelInternal(this.getProtocol(), this.getReceiverName(), module.ensureSerializer(this.getClassLoader()), this.getReceiver(), this.getSubject(), this.getIdentityToken()));
            }

            public void setClassLoader(ClassLoader loader) {
                this.__m_ClassLoader = loader;
            }

            public void setConnection(com.tangosol.coherence.component.net.extend.Connection connection) {
                this.__m_Connection = connection;
            }

            public void setIdentityToken(byte[] abToken) {
                this.__m_IdentityToken = abToken;
            }

            public void setProtocol(com.tangosol.net.messaging.Protocol protocol) {
                this.__m_Protocol = protocol;
            }

            public void setReceiver(Channel.Receiver receiver) {
                this.__m_Receiver = receiver;
            }

            public void setReceiverName(String sName) {
                this.__m_ReceiverName = sName;
            }

            public void setSubject(Subject subject) {
                this.__m_Subject = subject;
            }

            static {
                OpenChannel.__initStatic();
            }

            public static class Status
            extends Request.Status {
                public Status() {
                    this(null, null, true);
                }

                public Status(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Status();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$OpenChannel$Status".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class OpenChannelRequest
        extends Request {
            private byte[] __m_IdentityToken;
            private transient Protocol.MessageFactory __m_MessageFactory;
            private String __m_ProtocolName;
            private transient Channel.Receiver __m_Receiver;
            private String __m_ReceiverName;
            private transient Serializer __m_Serializer;
            private transient Subject __m_Subject;
            public static final int TYPE_ID = 11;
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Status", Status.get_CLASS());
            }

            public OpenChannelRequest() {
                this(null, null, true);
            }

            public OpenChannelRequest(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new OpenChannelRequest();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$OpenChannelRequest".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            @Override
            protected String getDescription() {
                return super.getDescription() + ", Protocol=" + this.getProtocolName() + ", Receiver=" + this.getReceiverName();
            }

            public byte[] getIdentityToken() {
                return this.__m_IdentityToken;
            }

            public Protocol.MessageFactory getMessageFactory() {
                return this.__m_MessageFactory;
            }

            public String getProtocolName() {
                return this.__m_ProtocolName;
            }

            public Channel.Receiver getReceiver() {
                return this.__m_Receiver;
            }

            public String getReceiverName() {
                return this.__m_ReceiverName;
            }

            public Serializer getSerializer() {
                return this.__m_Serializer;
            }

            public Subject getSubject() {
                return this.__m_Subject;
            }

            @Override
            public int getTypeId() {
                return 11;
            }

            @Override
            protected com.tangosol.coherence.component.net.extend.message.Response instantiateResponse(Protocol.MessageFactory factory) {
                return (OpenChannelResponse)factory.createMessage(12);
            }

            @Override
            protected void onRun(com.tangosol.coherence.component.net.extend.message.Response response) {
                com.tangosol.net.messaging.Channel channel0 = this.getChannel();
                OpenChannelRequest._assert(channel0.getId() == 0);
                com.tangosol.coherence.component.net.extend.Connection connection = (com.tangosol.coherence.component.net.extend.Connection)channel0.getConnection();
                OpenChannelRequest._assert(connection != null);
                Peer module = (Peer)channel0.getReceiver();
                Channel.Receiver receiver = module.getReceiver(this.getReceiverName());
                if (receiver == null) {
                    throw new IllegalArgumentException("unknown receiver: " + this.getReceiverName());
                }
                response.setResult(connection.openChannelRequest(this.getProtocolName(), channel0.getSerializer(), receiver, module.assertIdentityToken(module.deserializeIdentityToken(this.getIdentityToken())), module.getAccessAdapter()));
            }

            @Override
            public void readExternal(PofReader in) throws IOException {
                super.readExternal(in);
                this.setProtocolName(in.readString(1));
                this.setReceiverName(in.readString(2));
                this.setIdentityToken(in.readByteArray(3));
            }

            public void setIdentityToken(byte[] abToken) {
                this.__m_IdentityToken = abToken;
            }

            public void setMessageFactory(Protocol.MessageFactory factory) {
                this.__m_MessageFactory = factory;
            }

            public void setProtocolName(String sName) {
                this.__m_ProtocolName = sName;
            }

            public void setReceiver(Channel.Receiver receiver) {
                this.__m_Receiver = receiver;
            }

            public void setReceiverName(String sName) {
                this.__m_ReceiverName = sName;
            }

            public void setSerializer(Serializer serializer) {
                this.__m_Serializer = serializer;
            }

            public void setSubject(Subject subject) {
                this.__m_Subject = subject;
            }

            @Override
            public void writeExternal(PofWriter out) throws IOException {
                super.writeExternal(out);
                out.writeString(1, this.getProtocolName());
                out.writeString(2, this.getReceiverName());
                out.writeByteArray(3, this.getIdentityToken());
            }

            static {
                OpenChannelRequest.__initStatic();
            }

            public static class Status
            extends Request.Status {
                public Status() {
                    this(null, null, true);
                }

                public Status(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Status();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$OpenChannelRequest$Status".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class OpenChannelResponse
        extends com.tangosol.coherence.component.net.extend.message.Response {
            public static final int TYPE_ID = 12;

            public OpenChannelResponse() {
                this(null, null, true);
            }

            public OpenChannelResponse(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new OpenChannelResponse();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$OpenChannelResponse".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public int getTypeId() {
                return 12;
            }

            @Override
            public void run() {
                Channel channel0 = (Channel)this.getChannel();
                OpenChannelResponse._assert(channel0.getId() == 0);
                if (this.isFailure()) {
                    return;
                }
                com.tangosol.coherence.component.net.extend.Connection connection = (com.tangosol.coherence.component.net.extend.Connection)channel0.getConnection();
                int nId = (Integer)this.getResult();
                OpenChannelRequest request = (OpenChannelRequest)channel0.getRequest(this.getRequestId());
                if (request == null) {
                    NotifyChannelClosed message = (NotifyChannelClosed)channel0.getMessageFactory().createMessage(20);
                    message.setChannelId(nId);
                    channel0.send(message);
                } else {
                    Protocol.MessageFactory factory = request.getMessageFactory();
                    Channel.Receiver receiver = request.getReceiver();
                    Serializer serializer = request.getSerializer();
                    Subject subject = request.getSubject();
                    this.setResult(connection.openChannelResponse(nId, factory, serializer, receiver, subject));
                }
            }
        }

        public static abstract class OpenConnection
        extends Request {
            private transient com.tangosol.coherence.component.net.extend.Connection __m_ConnectionOpen;
            private byte[] __m_IdentityToken;
            private transient Subject __m_Subject;
            public static final int TYPE_ID = -8;
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Status", Status.get_CLASS());
            }

            public OpenConnection(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$OpenConnection".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            public com.tangosol.coherence.component.net.extend.Connection getConnectionOpen() {
                return this.__m_ConnectionOpen;
            }

            public byte[] getIdentityToken() {
                return this.__m_IdentityToken;
            }

            public Subject getSubject() {
                return this.__m_Subject;
            }

            @Override
            public int getTypeId() {
                return -8;
            }

            @Override
            protected com.tangosol.coherence.component.net.extend.message.Response instantiateResponse(Protocol.MessageFactory factory) {
                return (Response)factory.createMessage(-9);
            }

            public void setConnectionOpen(com.tangosol.coherence.component.net.extend.Connection connection) {
                this.__m_ConnectionOpen = connection;
            }

            public void setIdentityToken(byte[] abToken) {
                this.__m_IdentityToken = abToken;
            }

            public void setSubject(Subject subject) {
                this.__m_Subject = subject;
            }

            static {
                OpenConnection.__initStatic();
            }

            public static class Status
            extends Request.Status {
                public Status() {
                    this(null, null, true);
                }

                public Status(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Status();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$OpenConnection$Status".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static abstract class OpenConnectionRequest
        extends Request {
            private UUID __m_ClientId;
            private String __m_ClusterName;
            private int __m_Edition;
            private byte[] __m_IdentityToken;
            private Member __m_Member;
            private Map __m_ProtocolVersionMap;
            private String __m_ServiceName;
            private transient Subject __m_Subject;
            public static final int TYPE_ID = 1;
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Status", Status.get_CLASS());
            }

            public OpenConnectionRequest(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$OpenConnectionRequest".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            public UUID getClientId() {
                return this.__m_ClientId;
            }

            public String getClusterName() {
                return this.__m_ClusterName;
            }

            @Override
            protected String getDescription() {
                return super.getDescription() + ", ClientId=" + String.valueOf(this.getClientId()) + ", Edition=" + this.getEdition() + ", ProtocolVersionMap=" + this.getVersionMapDescription(this.getProtocolVersionMap()) + ", Member=" + String.valueOf(this.getMember());
            }

            public int getEdition() {
                return this.__m_Edition;
            }

            public byte[] getIdentityToken() {
                return this.__m_IdentityToken;
            }

            public Member getMember() {
                return this.__m_Member;
            }

            public Map getProtocolVersionMap() {
                return this.__m_ProtocolVersionMap;
            }

            public String getServiceName() {
                return this.__m_ServiceName;
            }

            public Subject getSubject() {
                return this.__m_Subject;
            }

            @Override
            public int getTypeId() {
                return 1;
            }

            protected String getVersionMapDescription(Map map) {
                StringBuilder sb = new StringBuilder("{");
                Iterator iter = map.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String sName = (String)entry.getKey();
                    Object oVersion = entry.getValue();
                    sb.append(sName + "=");
                    if (oVersion instanceof Integer) {
                        sb.append(oVersion);
                    } else {
                        Object[] aVersions = (Object[])oVersion;
                        int nRequestCurrent = (Integer)aVersions[0];
                        int nRequestSupport = (Integer)aVersions[1];
                        sb.append("[" + nRequestSupport + ", " + nRequestCurrent + "]");
                    }
                    if (!iter.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append('}');
                return sb.toString();
            }

            @Override
            protected com.tangosol.coherence.component.net.extend.message.Response instantiateResponse(Protocol.MessageFactory factory) {
                return (OpenConnectionResponse)factory.createMessage(0);
            }

            @Override
            public void readExternal(PofReader in) throws IOException {
                super.readExternal(in);
                this.setClientId((UUID)in.readObject(1));
                this.setEdition(in.readInt(2));
                this.setProtocolVersionMap(in.readMap(3, new HashMap()));
                this.setIdentityToken(in.readByteArray(4));
                this.setMember((Member)in.readObject(5));
                this.setClusterName(in.readString(6));
                this.setServiceName(in.readString(7));
            }

            public void setClientId(UUID uuid) {
                this.__m_ClientId = uuid;
            }

            public void setClusterName(String sName) {
                this.__m_ClusterName = sName;
            }

            public void setEdition(int nEdition) {
                this.__m_Edition = nEdition;
            }

            public void setIdentityToken(byte[] abToken) {
                this.__m_IdentityToken = abToken;
            }

            public void setMember(Member member) {
                this.__m_Member = member;
            }

            public void setProtocolVersionMap(Map map) {
                this.__m_ProtocolVersionMap = map;
            }

            public void setServiceName(String sName) {
                this.__m_ServiceName = sName;
            }

            public void setSubject(Subject subject) {
                this.__m_Subject = subject;
            }

            @Override
            public void writeExternal(PofWriter out) throws IOException {
                super.writeExternal(out);
                out.writeObject(1, this.getClientId());
                out.writeInt(2, this.getEdition());
                out.writeMap(3, this.getProtocolVersionMap(), String.class, Integer[].class);
                out.writeByteArray(4, this.getIdentityToken());
                out.writeObject(5, this.getMember());
                out.writeString(6, this.getClusterName());
                out.writeString(7, this.getServiceName());
            }

            static {
                OpenConnectionRequest.__initStatic();
            }

            public static class Status
            extends Request.Status {
                public Status() {
                    this(null, null, true);
                }

                public Status(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Status();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$OpenConnectionRequest$Status".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static abstract class OpenConnectionResponse
        extends com.tangosol.coherence.component.net.extend.message.Response {
            private Map __m_ProtocolVersionMap;
            public static final int TYPE_ID = 0;

            public OpenConnectionResponse(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$OpenConnectionResponse".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected String getDescription() {
                return super.getDescription() + ", ProtocolVersionMap=" + String.valueOf(this.getProtocolVersionMap());
            }

            public Map getProtocolVersionMap() {
                return this.__m_ProtocolVersionMap;
            }

            @Override
            public int getTypeId() {
                return 0;
            }

            @Override
            public void readExternal(PofReader in) throws IOException {
                super.readExternal(in);
                this.setProtocolVersionMap(in.readMap(6, null));
            }

            public void setProtocolVersionMap(Map map) {
                this.__m_ProtocolVersionMap = map;
            }

            @Override
            public void writeExternal(PofWriter out) throws IOException {
                super.writeExternal(out);
                out.writeMap(6, this.getProtocolVersionMap());
            }
        }

        public static class PingRequest
        extends Request {
            public static final int TYPE_ID = 3;
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Status", Status.get_CLASS());
            }

            public PingRequest() {
                this(null, null, true);
            }

            public PingRequest(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new PingRequest();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$PingRequest".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            @Override
            public int getTypeId() {
                return 3;
            }

            @Override
            protected com.tangosol.coherence.component.net.extend.message.Response instantiateResponse(Protocol.MessageFactory factory) {
                return (com.tangosol.coherence.component.net.extend.message.Response)factory.createMessage(4);
            }

            @Override
            protected void onRun(com.tangosol.coherence.component.net.extend.message.Response response) {
                PingRequest._assert(this.getChannel().getId() == 0);
            }

            static {
                PingRequest.__initStatic();
            }

            public static class Status
            extends Request.Status {
                public Status() {
                    this(null, null, true);
                }

                public Status(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Status();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$PingRequest$Status".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class PingResponse
        extends com.tangosol.coherence.component.net.extend.message.Response {
            public static final int TYPE_ID = 4;

            public PingResponse() {
                this(null, null, true);
            }

            public PingResponse(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new PingResponse();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$PingResponse".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public int getTypeId() {
                return 4;
            }

            @Override
            public void run() {
                Channel channel = (Channel)this.getChannel();
                PingResponse._assert(channel.getId() == 0);
                com.tangosol.coherence.component.net.extend.Connection connection = (com.tangosol.coherence.component.net.extend.Connection)channel.getConnection();
                connection.setPingLastMillis(0L);
            }
        }

        public static class Response
        extends com.tangosol.coherence.component.net.extend.message.Response {
            public static final int TYPE_ID = -9;

            public Response() {
                this(null, null, true);
            }

            public Response(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Response();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$MessageFactory$Response".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public int getTypeId() {
                return -9;
            }

            @Override
            public void run() {
            }
        }
    }

    public static class Protocol
    extends com.tangosol.coherence.component.net.extend.Protocol {
        public static final String PROTOCOL_NAME = "MessagingProtocol";

        public Protocol() {
            this(null, null, true);
        }

        public Protocol(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setVersionCurrent(3);
                this.setVersionSupported(2);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Protocol();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$Protocol".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getName() {
            return PROTOCOL_NAME;
        }

        @Override
        protected com.tangosol.coherence.component.net.extend.MessageFactory instantiateMessageFactory(int nVersion) {
            return (MessageFactory)((Peer)this.get_Module())._newChild("MessageFactory");
        }
    }

    public static class DaemonPool
    extends Service.DaemonPool {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Daemon", Service.DaemonPool.Daemon.get_CLASS());
            __mapChildren.put("ResizeTask", Service.DaemonPool.ResizeTask.get_CLASS());
            __mapChildren.put("ScheduleTask", Service.DaemonPool.ScheduleTask.get_CLASS());
            __mapChildren.put("StartTask", Service.DaemonPool.StartTask.get_CLASS());
            __mapChildren.put("StopTask", Service.DaemonPool.StopTask.get_CLASS());
            __mapChildren.put("WorkSlot", Service.DaemonPool.WorkSlot.get_CLASS());
            __mapChildren.put("WrapperTask", WrapperTask.get_CLASS());
        }

        public DaemonPool() {
            this(null, null, true);
        }

        public DaemonPool(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setAbandonThreshold(8);
                this.setDaemonCountMax(Integer.MAX_VALUE);
                this.setDaemonCountMin(1);
                this.setScheduledTasks(new HashSet());
                this.setStatsTaskAddCount(new AtomicLong());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new DaemonPool();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$DaemonPool".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        protected DaemonPool.WrapperTask instantiateWrapperTask() {
            WrapperTask task = new WrapperTask();
            this._linkChild(task);
            return task;
        }

        static {
            DaemonPool.__initStatic();
        }

        public static class WrapperTask
        extends Service.DaemonPool.WrapperTask {
            public WrapperTask() {
                this(null, null, true);
            }

            public WrapperTask(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new WrapperTask();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Peer$DaemonPool$WrapperTask".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected void run(Runnable task) {
                if (task instanceof Message) {
                    Message message = (Message)task;
                    Channel channel = (Channel)message.getChannel();
                    channel.receive(message);
                } else {
                    task.run();
                }
            }
        }
    }
}

